(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    340279,       6841]
NotebookOptionsPosition[    338048,       6796]
NotebookOutlinePosition[    338389,       6811]
CellTagsIndexPosition[    338346,       6808]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
This Notebook contains the algorithms from the paper
\"A Computer Algorithm for Proving Symmetric Homogeneous Triangle \
Inequalities\"
by Stanley Rabinowitz published in the International Journal of Computer \
Discovered Mathematics in May 2022.
   
This Notebook is Copyright \[Copyright] December 2021 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and is published with open access. This \
Notebook is distributed under the terms of the Creative Commons Attribution \
License which permits any use, distribution, and reproduction in any medium, \
provided the original author and the source are credited.\
\>", "Text",
 CellChangeTimes->{{3.847982489519108*^9, 3.847982489525961*^9}, {
  3.8479825392582006`*^9, 3.8479826101822643`*^9}, {3.847982689622816*^9, 
  3.847982691798325*^9}, {3.848504718226446*^9, 3.848504723337509*^9}, {
  3.860775354642537*^9, 
  3.860775368444364*^9}},ExpressionUUID->"1e66b701-429a-4ec0-9f88-\
2b0a90741036"],

Cell["\<\
version 15 (Dec. 8, 2021)
version 16 (Jan. 19, 2022) Added Together before simplifying xy-expr, Add \
Time Constraint when showing roots of equations 
version 17 (Jan. 23, 2022) Start of adding a calculator mode.
version 18 (Feb. 15, 2022) Allow finding k when operator is Equal
version 19 (Feb. 17, 2022) Add findBestKusingT
version 20 (Feb. 26, 2022) Fix trig rules to use \[RuleDelayed] rather than ->
version 21 (Mar. 1, 2022) rename convertToABC direct to convertToABC
version 22 (Mar. 17, 2022) add Sec[x/2] to half angle rules\
\>", "Text",
 Evaluatable->False,
 InitializationCell->True,
 CellChangeTimes->{{3.822908871517373*^9, 3.8229088846933403`*^9}, {
   3.822908993772704*^9, 3.822909025964164*^9}, {3.822909056620248*^9, 
   3.82290911623693*^9}, 3.822909186053378*^9, {3.822909220524805*^9, 
   3.82290935394835*^9}, {3.822909429797757*^9, 3.822909449901354*^9}, 
   3.822909510061504*^9, {3.822909559365554*^9, 3.822909728454052*^9}, {
   3.822909769190195*^9, 3.822909917133679*^9}, {3.822910126991056*^9, 
   3.822910153012528*^9}, {3.822910205550027*^9, 3.822910213526156*^9}, {
   3.822910415254594*^9, 3.8229105086631517`*^9}, {3.822910601703784*^9, 
   3.822910615383337*^9}, {3.822910660774351*^9, 3.822910671295066*^9}, {
   3.822910722055887*^9, 3.8229107751824713`*^9}, {3.822910820912163*^9, 
   3.822910876927878*^9}, 3.8229109082325163`*^9, {3.8229115146594563`*^9, 
   3.822911542328704*^9}, {3.822913828544114*^9, 3.822913895479711*^9}, {
   3.822913975384657*^9, 3.82291401343128*^9}, {3.822914045730054*^9, 
   3.822914050432732*^9}, {3.822914086138496*^9, 3.822914090193131*^9}, {
   3.822916146887686*^9, 3.822916159654559*^9}, {3.822924937961116*^9, 
   3.822924939344111*^9}, {3.82292500267371*^9, 3.822925005600039*^9}, {
   3.8229261790373793`*^9, 3.822926233491604*^9}, {3.822926324653338*^9, 
   3.822926365179591*^9}, {3.82337446368808*^9, 3.823374476007173*^9}, {
   3.8236193420693827`*^9, 3.823619345780365*^9}, {3.823619378629221*^9, 
   3.823619414943871*^9}, {3.823619459597434*^9, 3.823619472188478*^9}, {
   3.82361950635718*^9, 3.823619524421496*^9}, {3.823619577005493*^9, 
   3.8236199523998003`*^9}, {3.823620156736362*^9, 3.823620159214953*^9}, {
   3.823620190112598*^9, 3.823620213647558*^9}, {3.8236203307697897`*^9, 
   3.8236203363446302`*^9}, {3.82362041107592*^9, 3.823620416924191*^9}, {
   3.823620450763652*^9, 3.823620457873304*^9}, {3.823620504998816*^9, 
   3.82362050904387*^9}, {3.823620541730588*^9, 3.823620596522399*^9}, {
   3.823620633259019*^9, 3.823620695729815*^9}, {3.823621176949081*^9, 
   3.823621198787867*^9}, {3.8236212481652203`*^9, 3.8236212495957613`*^9}, {
   3.8236213167657022`*^9, 3.823621339252634*^9}, {3.823621380277945*^9, 
   3.823621380612316*^9}, {3.823621638910816*^9, 3.8236216427332687`*^9}, {
   3.8236217274788723`*^9, 3.8236217363335752`*^9}, {3.823621853358876*^9, 
   3.8236219113986683`*^9}, {3.823621957119934*^9, 3.823621958694228*^9}, {
   3.823622359608397*^9, 3.8236223916715193`*^9}, {3.823624054997119*^9, 
   3.8236240594045563`*^9}, {3.823624173725913*^9, 3.8236241743014727`*^9}, 
   3.823696790374243*^9, {3.8236968262927637`*^9, 3.823696839691636*^9}, {
   3.823696921324325*^9, 3.823696928220275*^9}, 3.8236970725337543`*^9, {
   3.823697491239805*^9, 3.823697496495001*^9}, {3.823701751566345*^9, 
   3.823701882149891*^9}, {3.823701943991397*^9, 3.8237019724860067`*^9}, {
   3.82370270248803*^9, 3.823702714488469*^9}, {3.823702744753292*^9, 
   3.82370274517654*^9}, {3.823704505890622*^9, 3.823704510377575*^9}, {
   3.8237081603943853`*^9, 3.823708175306937*^9}, 3.823709908785244*^9, {
   3.823718524649069*^9, 3.823718537927596*^9}, {3.823719179308312*^9, 
   3.8237192094657297`*^9}, {3.823722337433564*^9, 3.82372242208209*^9}, {
   3.823774862702227*^9, 3.823774887148958*^9}, {3.823775452048861*^9, 
   3.823775610664427*^9}, {3.8237756566868973`*^9, 3.823775677766955*^9}, 
   3.823776351209985*^9, 3.823790234213605*^9, {3.823793318661992*^9, 
   3.823793332493455*^9}, {3.82379337070151*^9, 3.823793388557926*^9}, 
   3.823800140166448*^9, {3.823856885299554*^9, 3.8238568898773036`*^9}, {
   3.8238569251435213`*^9, 3.8238570109857397`*^9}, {3.823865623901927*^9, 
   3.8238656287849884`*^9}, {3.8238735783900642`*^9, 3.823873600621265*^9}, {
   3.8238898628764677`*^9, 3.823889891339191*^9}, {3.823893435782099*^9, 
   3.823893502278061*^9}, {3.823893709135557*^9, 3.8238937229186277`*^9}, {
   3.8239502129451923`*^9, 3.8239502595037727`*^9}, {3.823969763116432*^9, 
   3.8239697839799147`*^9}, {3.824031255042159*^9, 3.8240312681406403`*^9}, {
   3.824031683651812*^9, 3.824031700873748*^9}, {3.8240317400655613`*^9, 
   3.824031816635357*^9}, {3.8240319936758347`*^9, 3.8240320505151052`*^9}, {
   3.824033103750351*^9, 3.824033130734036*^9}, {3.8240331772336407`*^9, 
   3.824033207782094*^9}, {3.8241317991081877`*^9, 3.8241318973158712`*^9}, {
   3.8241319373727417`*^9, 3.824131959027308*^9}, 3.824147096164373*^9, {
   3.8241475362145243`*^9, 3.82414760190049*^9}, {3.8241476973331738`*^9, 
   3.824147705972501*^9}, {3.824147805845065*^9, 3.824147815564746*^9}, {
   3.824147876806415*^9, 3.824147896981539*^9}, {3.824147956904272*^9, 
   3.8241479827733583`*^9}, {3.8242027748200483`*^9, 3.824202791956951*^9}, {
   3.824202826127434*^9, 3.824202851705501*^9}, {3.824202888686819*^9, 
   3.8242028961650047`*^9}, {3.824202928209832*^9, 3.8242030117298393`*^9}, {
   3.824203249451116*^9, 3.824203256450589*^9}, {3.824203355939393*^9, 
   3.824203414026991*^9}, {3.824204665583246*^9, 3.824204681487897*^9}, {
   3.82440393070536*^9, 3.824403977065269*^9}, {3.8244796614776697`*^9, 
   3.824479675597055*^9}, {3.824481177585989*^9, 3.824481203097234*^9}, {
   3.824496004435927*^9, 3.824496018515934*^9}, {3.824640446779298*^9, 
   3.824640554378882*^9}, 3.824745023989655*^9, {3.825242317751726*^9, 
   3.825242332359943*^9}, {3.825272245500588*^9, 3.825272281588336*^9}, {
   3.825759862590049*^9, 3.825759904719408*^9}, {3.825939121790017*^9, 
   3.8259391439976254`*^9}, {3.829306236013426*^9, 3.829306253645144*^9}, {
   3.8479826416303387`*^9, 3.847982643646257*^9}, {3.8479840295959044`*^9, 
   3.8479840394834843`*^9}, {3.851578265313212*^9, 3.851578302377063*^9}, {
   3.851626376679582*^9, 3.851626396815434*^9}, {3.851975348580288*^9, 
   3.851975371492298*^9}, {3.85394490789679*^9, 3.853944931104973*^9}, {
   3.854129133744955*^9, 3.8541291564728813`*^9}, {3.85488944557057*^9, 
   3.8548894825217323`*^9}, {3.855134573133301*^9, 3.8551346095171328`*^9}, {
   3.8565297803484592`*^9, 
   3.856529808500166*^9}},ExpressionUUID->"27642479-5d0e-4405-834d-\
56c69a1ef19c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Global", " ", "variables", " ", "used", " ", "by", " ", "Algoirthm", " ", 
    "B", " ", "and", " ", "its", " ", "related", " ", 
    RowBox[{"algorithms", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"showSteps", "=", "False"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"showExpressionSimplification", "=", "False"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"showRegions", "=", "False"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"showCounterexample", "=", "False"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"showConditionsForEquality", "=", "False"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"True", "/", "False"}], "/", 
      RowBox[{"All", " ", ".", " ", "True"}]}], " ", "excludes", " ", 
     "equilateral", " ", "triangles"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "r", ",", "R", ",", "K", ",", "s", ",", "a", ",", "b", ",", "c"}], "]"}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Convenience", " ", "functions", " ", "used", " ", "for", " ", "forming", 
     " ", "input"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"symmetric", " ", "sum"}], ",", " ", 
     RowBox[{"symmetric", " ", "product"}], ",", " ", 
     RowBox[{"and", " ", "cymmetric", " ", "vector"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"csum", "[", "expr_", "]"}], ":=", 
     RowBox[{"expr", "+", 
      RowBox[{"(", 
       RowBox[{"expr", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", "\[Rule]", "b"}], ",", 
          RowBox[{"b", "\[Rule]", "c"}], ",", 
          RowBox[{"c", "\[Rule]", "a"}], ",", 
          RowBox[{"A", "\[Rule]", "B"}], ",", 
          RowBox[{"B", "\[Rule]", "C"}], ",", 
          RowBox[{"C", "\[Rule]", "A"}]}], "}"}]}], ")"}], "+", 
      RowBox[{"(", 
       RowBox[{"expr", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", "\[Rule]", "c"}], ",", 
          RowBox[{"b", "\[Rule]", "a"}], ",", 
          RowBox[{"c", "\[Rule]", "b"}], ",", 
          RowBox[{"A", "\[Rule]", "C"}], ",", 
          RowBox[{"B", "\[Rule]", "A"}], ",", 
          RowBox[{"C", "\[Rule]", "B"}]}], "}"}]}], ")"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"cprod", "[", "expr_", "]"}], ":=", 
     RowBox[{"expr", "*", 
      RowBox[{"(", 
       RowBox[{"expr", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", "\[Rule]", "b"}], ",", 
          RowBox[{"b", "\[Rule]", "c"}], ",", 
          RowBox[{"c", "\[Rule]", "a"}], ",", 
          RowBox[{"A", "\[Rule]", "B"}], ",", 
          RowBox[{"B", "\[Rule]", "C"}], ",", 
          RowBox[{"C", "\[Rule]", "A"}]}], "}"}]}], ")"}], "*", 
      RowBox[{"(", 
       RowBox[{"expr", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", "\[Rule]", "c"}], ",", 
          RowBox[{"b", "\[Rule]", "a"}], ",", 
          RowBox[{"c", "\[Rule]", "b"}], ",", 
          RowBox[{"A", "\[Rule]", "C"}], ",", 
          RowBox[{"B", "\[Rule]", "A"}], ",", 
          RowBox[{"C", "\[Rule]", "B"}]}], "}"}]}], ")"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"cvec", "[", "expr_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{"expr", ",", 
       RowBox[{"(", 
        RowBox[{"expr", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"a", "\[Rule]", "b"}], ",", 
           RowBox[{"b", "\[Rule]", "c"}], ",", 
           RowBox[{"c", "\[Rule]", "a"}], ",", 
           RowBox[{"A", "\[Rule]", "B"}], ",", 
           RowBox[{"B", "\[Rule]", "C"}], ",", 
           RowBox[{"C", "\[Rule]", "A"}]}], "}"}]}], ")"}], ",", 
       RowBox[{"(", 
        RowBox[{"expr", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"a", "\[Rule]", "c"}], ",", 
           RowBox[{"b", "\[Rule]", "a"}], ",", 
           RowBox[{"c", "\[Rule]", "b"}], ",", 
           RowBox[{"A", "\[Rule]", "C"}], ",", 
           RowBox[{"B", "\[Rule]", "A"}], ",", 
           RowBox[{"C", "\[Rule]", "B"}]}], "}"}]}], ")"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Convenience", " ", "function", " ", "used", " ", "for", " ", "testing", 
     " ", "the", " ", "algorithm"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"showExpression", "=", "False"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"triangcount", "=", "0"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"triangtrue", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"timeConstraint", "=", "5"}], ";"}], " ", 
   RowBox[{"(*", " ", "seconds", " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{"inequality_", ",", 
       RowBox[{"specialType_:", "\"\<all\>\""}]}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", "simp", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"triangcount", "++"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"showExpression", ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Print", "[", 
            RowBox[{
            "\"\<[\>\"", ",", "triangcount", ",", "\"\<] \>\"", ",", 
             "inequality"}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"simp", "=", 
         RowBox[{"TimeConstrained", "[", 
          RowBox[{
           RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
            RowBox[{"inequality", ",", 
             RowBox[{"Method", "\[Rule]", "\"\<xy\>\""}], ",", 
             RowBox[{"triangleType", "\[Rule]", "specialType"}]}], "]"}], ",",
            "timeConstraint"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"BooleanQ", "[", "simp", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{"Style", "[", 
            RowBox[{"simp", ",", "Blue", ",", "Bold"}], "]"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"simp", "===", "$Aborted"}], ",", 
             RowBox[{"redPrint", "[", "\"\<Time limit exceeded.\>\"", "]"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"redPrint", "[", "\"\<Not sure\>\"", "]"}]}], 
            "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"simp", ",", 
          RowBox[{"triangtrue", "++"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "simp", "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"h", "[", "x", "]"}], " ", "is", " ", "the", " ", "length", " ", 
     "of", " ", "the", " ", "altitude", " ", "to", " ", "side", " ", "x"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hRules", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"h", "[", "x_", "]"}], "\[Rule]", 
       RowBox[{"2", 
        RowBox[{"K", "/", "x"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "K", " ", "is", " ", "the", " ", "area", " ", "of", " ", "the", " ", 
     "triangle"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kRules", "=", 
     RowBox[{"{", 
      RowBox[{"K", "\[Rule]", 
       RowBox[{"r", "*", "s"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"m", "[", "x", "]"}], " ", "is", " ", "the", " ", "length", " ", 
     "of", " ", "the", " ", "median", " ", "to", " ", "side", " ", "x"}], " ",
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mRules", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"m", "[", "a", "]"}], "^", "n_"}], "/;", 
         RowBox[{"EvenQ", "[", "n", "]"}]}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", 
              RowBox[{"b", "^", "2"}]}], "+", 
             RowBox[{"2", 
              RowBox[{"c", "^", "2"}]}], "-", 
             RowBox[{"a", "^", "2"}]}], ")"}], "/", "4"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "/", "2"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"m", "[", "b", "]"}], "^", "n_"}], "/;", 
         RowBox[{"EvenQ", "[", "n", "]"}]}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", 
              RowBox[{"c", "^", "2"}]}], "+", 
             RowBox[{"2", 
              RowBox[{"a", "^", "2"}]}], "-", 
             RowBox[{"b", "^", "2"}]}], ")"}], "/", "4"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "/", "2"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"m", "[", "c", "]"}], "^", "n_"}], "/;", 
         RowBox[{"EvenQ", "[", "n", "]"}]}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", 
              RowBox[{"a", "^", "2"}]}], "+", 
             RowBox[{"2", 
              RowBox[{"b", "^", "2"}]}], "-", 
             RowBox[{"c", "^", "2"}]}], ")"}], "/", "4"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "/", "2"}], ")"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"w", "[", "x", "]"}], " ", "is", " ", "the", " ", "length", " ", 
     "of", " ", "the", " ", "angle", " ", "bisector", " ", "to", " ", "side", 
     " ", "x"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wRules", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"w", "[", "a", "]"}], "^", "n_"}], "/;", 
         RowBox[{"EvenQ", "[", "n", "]"}]}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "b", "*", "c", "*", "s", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"s", "-", "a"}], ")"}], "/", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"b", "+", "c"}], ")"}], "^", "2"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "/", "2"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"w", "[", "b", "]"}], "^", "n_"}], "/;", 
         RowBox[{"EvenQ", "[", "n", "]"}]}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "c", "*", "a", "*", "s", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"s", "-", "b"}], ")"}], "/", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"c", "+", "a"}], ")"}], "^", "2"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "/", "2"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"w", "[", "c", "]"}], "^", "n_"}], "/;", 
         RowBox[{"EvenQ", "[", "n", "]"}]}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "a", "*", "b", "*", "s", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"s", "-", "c"}], ")"}], "/", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", "b"}], ")"}], "^", "2"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "/", "2"}], ")"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"g", "[", "x", "]"}], " ", "is", " ", "the", " ", "length", " ", 
     "of", " ", "the", " ", "Gergonne", " ", "cevian", " ", "side", " ", 
     "x"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gRules", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"g", "[", "a", "]"}], "^", "n_"}], "/;", 
         RowBox[{"EvenQ", "[", "n", "]"}]}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"s", "-", "a"}], ")"}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "*", "s"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"b", "-", "c"}], ")"}], "^", "2"}]}], ")"}], "/", 
            "a"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "/", "2"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"g", "[", "b", "]"}], "^", "n_"}], "/;", 
         RowBox[{"EvenQ", "[", "n", "]"}]}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"s", "-", "b"}], ")"}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", "*", "s"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"c", "-", "a"}], ")"}], "^", "2"}]}], ")"}], "/", 
            "b"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "/", "2"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"g", "[", "c", "]"}], "^", "n_"}], "/;", 
         RowBox[{"EvenQ", "[", "n", "]"}]}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"s", "-", "c"}], ")"}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"c", "*", "s"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"a", "-", "b"}], ")"}], "^", "2"}]}], ")"}], "/", 
            "c"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "/", "2"}], ")"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"n", "[", "x", "]"}], " ", "is", " ", "the", " ", "length", " ", 
     "of", " ", "the", " ", "Nagel", " ", "cevian", " ", "side", " ", "x"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nRules", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"n", "[", "a", "]"}], "^", "n_"}], "/;", 
         RowBox[{"EvenQ", "[", "n", "]"}]}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"c", "^", "2"}], 
              RowBox[{"(", 
               RowBox[{"s", "-", "b"}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"b", "^", "2"}], 
              RowBox[{"(", 
               RowBox[{"s", "-", "c"}], ")"}]}], "-", 
             RowBox[{"a", 
              RowBox[{"(", 
               RowBox[{"s", "-", "b"}], ")"}], 
              RowBox[{"(", 
               RowBox[{"s", "-", "c"}], ")"}]}]}], ")"}], "/", "a"}], ")"}], 
         "^", 
         RowBox[{"(", 
          RowBox[{"n", "/", "2"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
       "\t    ", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"n", "[", "b", "]"}], "^", "n_"}], "/;", 
         RowBox[{"EvenQ", "[", "n", "]"}]}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"a", "^", "2"}], 
              RowBox[{"(", 
               RowBox[{"s", "-", "c"}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"c", "^", "2"}], 
              RowBox[{"(", 
               RowBox[{"s", "-", "a"}], ")"}]}], "-", 
             RowBox[{"b", 
              RowBox[{"(", 
               RowBox[{"s", "-", "c"}], ")"}], 
              RowBox[{"(", 
               RowBox[{"s", "-", "a"}], ")"}]}]}], ")"}], "/", "b"}], ")"}], 
         "^", 
         RowBox[{"(", 
          RowBox[{"n", "/", "2"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
       "             ", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"n", "[", "c", "]"}], "^", "n_"}], "/;", 
         RowBox[{"EvenQ", "[", "n", "]"}]}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"b", "^", "2"}], 
              RowBox[{"(", 
               RowBox[{"s", "-", "a"}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"a", "^", "2"}], 
              RowBox[{"(", 
               RowBox[{"s", "-", "b"}], ")"}]}], "-", 
             RowBox[{"c", 
              RowBox[{"(", 
               RowBox[{"s", "-", "a"}], ")"}], 
              RowBox[{"(", 
               RowBox[{"s", "-", "b"}], ")"}]}]}], ")"}], "/", "c"}], ")"}], 
         "^", 
         RowBox[{"(", 
          RowBox[{"n", "/", "2"}], ")"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"r", "[", "x", "]"}], " ", "is", " ", "the", " ", "radius", " ", 
     "of", " ", "the", " ", "excircle", " ", "touching", " ", "the", " ", 
     "side", " ", "of", " ", "length", " ", "x"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rRules", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"r", "[", "a", "]"}], "\[Rule]", 
        RowBox[{"r", "*", 
         RowBox[{"s", "/", 
          RowBox[{"(", 
           RowBox[{"s", "-", "a"}], ")"}]}]}]}], ",", 
       RowBox[{
        RowBox[{"r", "[", "b", "]"}], "\[Rule]", 
        RowBox[{"r", "*", 
         RowBox[{"s", "/", 
          RowBox[{"(", 
           RowBox[{"s", "-", "b"}], ")"}]}]}]}], ",", 
       RowBox[{
        RowBox[{"r", "[", "c", "]"}], "\[Rule]", 
        RowBox[{"r", "*", 
         RowBox[{"s", "/", 
          RowBox[{"(", 
           RowBox[{"s", "-", "c"}], ")"}]}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Some", " ", "convenience", " ", "rules"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"extraRules", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"L", "\[Rule]", 
        RowBox[{"2", "s"}]}], ",", 
       RowBox[{"F", "\[Rule]", "K"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"2", "K"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"SA", " ", "->", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"], "-", 
           SuperscriptBox["a", "2"]}], ")"}]}]}], ",", 
       RowBox[{"SB", " ", "->", " ", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}]}]}], ",", 
       RowBox[{"SC", " ", "->", " ", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
       RowBox[{"SW", "->", " ", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"trigIverseRules", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Sec", "[", "x_", "]"}], "\[RuleDelayed]", " ", 
        RowBox[{"1", "/", 
         RowBox[{"Cos", "[", "x", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"Csc", "[", "x", "]"}], "\[RuleDelayed]", 
        RowBox[{"1", "/", 
         RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"Cot", "[", "x_", "]"}], "\[RuleDelayed]", 
        RowBox[{"1", "/", 
         RowBox[{"Tan", "[", "x", "]"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"halfAngleRules", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Tan", "[", 
         RowBox[{"x_", "/", "2"}], "]"}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Cot", "[", 
         RowBox[{"x_", "/", "2"}], "]"}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "/", 
         RowBox[{"Sin", "[", "x", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"x_", "/", "2"}], "]"}], "^", "n_"}], "/;", 
         RowBox[{"EvenQ", "[", "n", "]"}]}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "/", "2"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "/", "2"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"x_", "/", "2"}], "]"}], "^", "n_"}], "/;", 
         RowBox[{"EvenQ", "[", "n", "]"}]}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "/", "2"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "/", "2"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"x_", "/", "2"}], "]"}], "^", "n_"}], "/;", 
         RowBox[{"EvenQ", "[", "n", "]"}]}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "/", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "/", "2"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"x_", "/", "2"}], "]"}], "^", "n_"}], "/;", 
         RowBox[{"EvenQ", "[", "n", "]"}]}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "/", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "/", "2"}], ")"}]}]}]}], "\[IndentingNewLine]", 
      "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"trigRules", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", "A", "]"}], "\[Rule]", 
        RowBox[{"a", "/", 
         RowBox[{"(", 
          RowBox[{"2", "R"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"Sin", "[", "B", "]"}], "\[Rule]", 
        RowBox[{"b", "/", 
         RowBox[{"(", 
          RowBox[{"2", "R"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"Sin", "[", "C", "]"}], "\[Rule]", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{"2", "R"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"Cos", "[", "A", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}], "-", 
           RowBox[{"a", "^", "2"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "b", "*", "c"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"Cos", "[", "B", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", "^", "2"}], "+", 
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "c", "*", "a"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"Cos", "[", "C", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "a", "*", "b"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"Tan", "[", "A", "]"}], "\[Rule]", 
        RowBox[{"4", 
         RowBox[{"K", "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "+", 
            RowBox[{"c", "^", "2"}], "-", 
            RowBox[{"a", "^", "2"}]}], ")"}]}]}]}], ",", 
       RowBox[{
        RowBox[{"Tan", "[", "B", "]"}], "\[Rule]", 
        RowBox[{"4", 
         RowBox[{"K", "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"c", "^", "2"}], "+", 
            RowBox[{"a", "^", "2"}], "-", 
            RowBox[{"b", "^", "2"}]}], ")"}]}]}]}], ",", 
       RowBox[{
        RowBox[{"Tan", "[", "C", "]"}], "\[Rule]", 
        RowBox[{"4", 
         RowBox[{"K", "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "^", "2"}], "+", 
            RowBox[{"b", "^", "2"}], "-", 
            RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], ",", 
       RowBox[{
        RowBox[{"Csc", "[", "A", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", " ", "c"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "K"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"Csc", "[", "B", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", " ", "a"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "K"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"Csc", "[", "C", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", " ", "b"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "K"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"Sec", "[", "A", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "*", "b", "*", "c"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}], "-", 
           RowBox[{"a", "^", "2"}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"Sec", "[", "B", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "*", "c", "*", "a"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", "^", "2"}], "+", 
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"Sec", "[", "C", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "*", "a", "*", "b"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"Cot", "[", "A", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}], "-", 
           RowBox[{"a", "^", "2"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"4", "K"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"Cot", "[", "B", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", "^", "2"}], "+", 
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"4", "K"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"Cot", "[", "C", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"4", "K"}], ")"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "We", " ", "use", " ", "more", " ", "rules", " ", "here", " ", "than", 
     " ", "the", " ", "paper", " ", "specifies", " ", "because", " ", 
     "Mathematica", " ", "will", " ", "automatically", "\[IndentingNewLine]", 
     "reintroduce", " ", "some", " ", "inverse", " ", "trig", " ", 
     RowBox[{"functions", ".", " ", "For"}], " ", "example", " ", 
     "Mathematica", " ", "automatically", " ", "changes", " ", 
     RowBox[{"1", "/", 
      RowBox[{"Cos", "[", "x", "]"}]}], " ", "to", " ", 
     RowBox[{
      RowBox[{"Sec", "[", "x", "]"}], ".", "\[IndentingNewLine]", "This"}], 
     " ", "may", " ", "not", " ", "be", " ", "true", " ", "in", " ", "other", 
     " ", "symbolic", " ", "algebra", " ", 
     RowBox[{"systems", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"x_", "/", "2"}], "]"}], "\[Rule]", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Cot", "[", 
        RowBox[{"x_", "/", "2"}], "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "/", 
        RowBox[{"Sin", "[", "x", "]"}]}]}], ";"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Error", " ", "messages"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"algorithmB", "::", "notSymmetric"}], "=", 
     "\"\<The input is not symmetric in a, b, and c.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"algorithmB", "::", "notIneq"}], "=", 
     "\"\<The input is missing an inequality symbol.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"algorithmB", "::", "equal"}], "=", 
     "\"\<The input has an = symbol. Use == for equality.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"algorithmB", "::", "tooManyIneq"}], "=", 
     "\"\<The input has too many relational symbols.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"algorithmB", "::", "unknownType"}], "=", 
     RowBox[{
     "\"\<Triangle type `1` is not a valid type of triangle.\\n\>\"", "<>", 
      "\[IndentingNewLine]", 
      "\"\<Please specify: \\\"all\\\", \\\"acute\\\", \\\"obtuse\\\", \
\\\"nonacute\\\", \\\"nonobtuse\\\", or \\\"right\\\".\>\""}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"algorithmB", "::", "unknownMethod"}], "=", 
     RowBox[{
     "\"\<Method `1` is not a valid method. Using Automatic. \>\"", "<>", 
      "\[IndentingNewLine]", 
      "\"\<Valid methods: \\\"xy\\\", \\\"t\\\", and Automatic.\>\""}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"algorithmB", "::", "notPoly"}], "=", 
     "\"\<Expression `1` is not a polynomial.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"algorithmB", "::", "notPolynomial"}], "=", 
     "\"\<Could not find an equivalent polynomial inequality.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"algorithmC", "::", "noInstance"}], "=", 
     "\"\<Internal error: could not find nondegenerate counterexample.\>\""}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"algorithmB", "::", "badVar"}], "=", 
     "\"\<Could not convert `1` to an equivalent expression in terms of a, b, \
and c.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"algorithmB", "::", "inhomog"}], "=", 
     "\"\<Inequality is not homogeneous.\>\""}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", "      ", 
    RowBox[{"ALGORITHM", " ", "T"}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"removeTrigonometricFunctions", "[", "expression_", "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", "expr", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"expr", "=", 
         RowBox[{"expression", "/.", "trigIverseRules"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"expr", "=", 
         RowBox[{"expr", "/.", "halfAngleRules"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"We", " ", "do", " ", "not", " ", "do", " ", 
           RowBox[{"Tan", "[", "x_", "]"}]}], "\[Rule]", 
          RowBox[{
           RowBox[{
            RowBox[{"Sin", "[", "x", "]"}], "/", 
            RowBox[{"Cos", "[", "x", "]"}]}], " ", "because", " ", 
           "Mathematica", " ", "automayically", " ", "changes", " ", 
           RowBox[{
            RowBox[{"Sin", "[", "x", "]"}], "/", 
            RowBox[{"Cos", "[", "x", "]"}]}], " ", "back", " ", "to", " ", 
           RowBox[{"Tan", "[", "x", "]"}]}]}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"expr", "=", 
         RowBox[{"TrigExpand", "[", "expr", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"expr", "=", 
         RowBox[{"expr", "/.", "trigRules"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "expr", "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", "      ", 
    RowBox[{
     RowBox[{
     "ALGORITHM", " ", "R", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "Convert", " ", "an", " ", "expression", " ", "involving", " ", "a"}], 
     ",", " ", "b", ",", " ", "c", ",", " ", "K", ",", " ", 
     RowBox[{
     "and", " ", "trig", " ", "functions", " ", "to", "\[IndentingNewLine]", 
      "an", " ", "expression", " ", "containing", " ", "only", " ", "R"}], 
     ",", " ", "r", ",", " ", 
     RowBox[{"and", " ", 
      RowBox[{"s", ".", "\[IndentingNewLine]", "Returns"}], " ", "$Failed", 
      " ", "if", " ", "expression", " ", "is", " ", "not", " ", 
      RowBox[{"symmetric", "."}]}]}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"convertToRrs", "[", "expression_", "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "expr", ",", "num", ",", "den", ",", "num2", ",", "den2", ",", "rem", 
         ",", "expr2", ",", "expr3"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"expr", "=", 
         RowBox[{"Expand", "[", "expression", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"gExpr3", "=", 
         RowBox[{"op", "[", 
          RowBox[{"expr", ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"expr", "=", 
         RowBox[{"removeTrigonometricFunctions", "[", "expr", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"expr", "=", 
         RowBox[{"expr", "//.", "kRules"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"gExpr4", "=", 
         RowBox[{"op", "[", 
          RowBox[{"expr", ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "remove", " ", "sums", " ", "and", " ", "multiples", " ", "of", " ", 
          "angles"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"expr", "=", 
         RowBox[{"expr", "//.", "hRules"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"expr", "=", 
         RowBox[{"expr", "//.", "mRules"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"expr", "=", 
         RowBox[{"expr", "//.", "wRules"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"expr", "=", 
         RowBox[{"expr", "//.", "gRules"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"expr", "=", 
         RowBox[{"expr", "//.", "nRules"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"expr", "=", 
         RowBox[{"expr", "//.", "extraRules"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"expr", "=", 
         RowBox[{"expr", "//.", "rRules"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"expr", "=", 
         RowBox[{"expr", "//.", "kRules"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"gExpr5", "=", 
         RowBox[{"op", "[", 
          RowBox[{"expr", ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"expr", "=", 
         RowBox[{"Together", "[", "expr", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"gExpr6", "=", 
         RowBox[{"op", "[", 
          RowBox[{"expr", ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"num", "=", 
         RowBox[{"Numerator", "[", "expr", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"den", "=", 
         RowBox[{"Denominator", "[", "expr", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"num2", ",", "rem"}], "}"}], "=", 
         RowBox[{"SymmetricReduction", "[", 
          RowBox[{"num", ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"rem", "=!=", "0"}], ",", 
          RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"den2", ",", "rem"}], "}"}], "=", 
         RowBox[{"SymmetricReduction", "[", 
          RowBox[{"den", ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"rem", "=!=", "0"}], ",", 
          RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"showExpressionSimplification", ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Print", "[", 
            RowBox[{"\"\<symmetric reduction: \>\"", ",", " ", 
             RowBox[{"num2", "/", "den2"}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"gExpr7", "=", 
         RowBox[{"op", "[", 
          RowBox[{
           RowBox[{"num2", "/", "den2"}], ",", "0"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
          "See", " ", "Mitrinovic", " ", "page", " ", "7", " ", "for", " ", 
           "how", " ", "to", " ", "convert", " ", "symmetric", " ", 
           "functions", " ", "of", " ", "a"}], ",", " ", "b", ",", " ", 
          RowBox[{"and", " ", "c", " ", "to", " ", "R"}], ",", " ", "r", ",", 
          " ", 
          RowBox[{"and", " ", 
           RowBox[{"s", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"num2", ",", "den2"}], "}"}], "=", 
         RowBox[{"Map", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"First", "[", 
             RowBox[{"SymmetricReduction", "[", 
              RowBox[{"#", ",", 
               RowBox[{"{", 
                RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"2", " ", "s"}], ",", 
                 RowBox[{
                  SuperscriptBox["s", "2"], "+", 
                  SuperscriptBox["r", "2"], "+", 
                  RowBox[{"4", " ", "R", " ", "r"}]}], ",", 
                 RowBox[{"4", " ", "R", " ", "r", " ", "s"}]}], "}"}]}], 
              "]"}], "]"}], "&"}], ",", 
           RowBox[{"{", 
            RowBox[{"num", ",", "den"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"expr2", "=", 
         RowBox[{"num2", "/", "den2"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"expr3", "=", 
         RowBox[{"Simplify", "[", 
          RowBox[{"Together", "[", "expr2", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "expr3", "]"}], ";"}]}], "\[IndentingNewLine]",
       "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", "      ", 
    RowBox[{
     RowBox[{"ALGORITHM", " ", "P"}], "-", 
     RowBox[{
     "rational", "\[IndentingNewLine]", "\[IndentingNewLine]", "\t", "Remove",
       " ", "positive", " ", "factors", " ", "from", " ", "a", " ", 
      "rational", " ", 
      RowBox[{"expression", "."}]}]}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Removes", " ", "positive", " ", "factors", " ", "from", " ", "a", " ", 
     "rational", " ", "expression"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"removePositiveFactors", "[", 
      RowBox[{"expr_", ",", "constraints_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"num", ",", "den"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"num", ",", "den"}], "}"}], "=", 
         RowBox[{"NumeratorDenominator", "[", 
          RowBox[{"Together", "[", "expr", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"num", "=", 
         RowBox[{"removePositiveFactorsFromPolynomial", "[", 
          RowBox[{"num", ",", "constraints"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"den", "=", 
         RowBox[{"removePositiveFactorsFromPolynomial", "[", 
          RowBox[{"den", ",", "constraints"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"num", "/", "den"}], "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"isPositive", "[", 
      RowBox[{"expr_", ",", "constraints_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Quiet", "[", 
       RowBox[{"Simplify", "[", 
        RowBox[{
         RowBox[{"expr", ">", "0"}], ",", "constraints"}], "]"}], "]"}], "===",
       "True"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", "      ", 
    RowBox[{
    "ALGORITHM", " ", "P", "\[IndentingNewLine]", "\[IndentingNewLine]", "\t",
      "Remove", " ", "positive", " ", "factors", " ", "from", " ", "a", " ", 
     RowBox[{"polynomial", "."}]}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"removePositiveFactorsFromPolynomial", "[", 
      RowBox[{"expr_", ",", "constraints_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "factorList", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"factorList", "=", 
         RowBox[{"FactorSquareFreeList", "[", "expr", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"removePosFactor", "=", 
         RowBox[{"Function", "[", 
          RowBox[{"pair", ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"isPositive", "[", 
              RowBox[{
               RowBox[{"pair", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "constraints"}], "]"}], 
             ",", "1", ",", 
             RowBox[{
              RowBox[{"pair", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "^", 
              RowBox[{"pair", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"factorList", "=", 
         RowBox[{"Map", "[", 
          RowBox[{"removePosFactor", ",", "factorList"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"multiply", " ", "the", " ", "factors", " ", "together"}], 
         " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"Times", "@@", "factorList"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", "      ", 
    RowBox[{
     RowBox[{
     "ALGORITHM", " ", "F", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\t", "Remove", " ", "fractions", " ", "from", " ", "an", " ", 
      "inequality", " ", "expr"}], "\[GreaterEqual]", 
     RowBox[{"0", " ", "involving", " ", "rational", " ", 
      RowBox[{"functions", "."}]}]}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"convertToPolynomial", "[", "expr_", "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"num", ",", "den", ",", "simp"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Use", " ", "\"\<Simplify\>\"", " ", "command", " ", "to", " ", 
         "determine", " ", "if", " ", "the", " ", "denominator", " ", "is", 
         " ", "always", " ", 
         RowBox[{"positive", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"simp", "=", 
         RowBox[{"removePositiveFactors", "[", 
          RowBox[{"expr", ",", 
           RowBox[{
            RowBox[{"x", ">", "0"}], "&&", 
            RowBox[{"y", ">", "0"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"num", "=", 
         RowBox[{"Numerator", "[", "simp", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"den", "=", 
         RowBox[{"Denominator", "[", "simp", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
          "If", " ", "denominator", " ", "is", " ", "not", " ", "positive"}], 
          ",", " ", 
          RowBox[{
          "multiply", " ", "both", " ", "sides", " ", "of", " ", "the", " ", 
           "inequality", " ", "by", " ", 
           RowBox[{"den", "^", "2."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"num", "*", "den"}], "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fundamentalRrsInequality", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"s", "^", "2"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"18", "R", "*", "r"}], "-", 
          RowBox[{"9", 
           RowBox[{"r", "^", "2"}]}], "-", 
          RowBox[{"s", "^", "2"}]}], ")"}], "^", "2"}]}], "\[LessEqual]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"s", "^", "2"}], "-", 
         RowBox[{"3", 
          RowBox[{"r", "^", "2"}]}], "-", 
         RowBox[{"12", "R", "*", "r"}]}], ")"}], "^", "3"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"BlundonInequality", "=", 
     RowBox[{
      RowBox[{"4", "R", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"R", "-", 
          RowBox[{"2", "r"}]}], ")"}], "^", "3"}]}], "\[GreaterEqual]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"s", "^", "2"}], "-", 
         RowBox[{"2", 
          RowBox[{"R", "^", "2"}]}], "-", 
         RowBox[{"10", "R", "*", "r"}], "+", 
         RowBox[{"r", "^", "2"}]}], ")"}], "^", "2"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fundamentalFunction", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], ")"}], "^", "2"}], "+", 
      RowBox[{"12", 
       RowBox[{"x", "^", "3"}]}], "-", 
      RowBox[{"20", "x", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"48", 
       RowBox[{"x", "^", "2"}]}], "-", 
      RowBox[{"4", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"64", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fundamentalRegion", "=", 
     RowBox[{
      RowBox[{"fundamentalFunction", "<=", "0"}], "&&", 
      RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"polynomialDegree", "[", "poly_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"Max", "[", 
        RowBox[{"Plus", "@@@", 
         RowBox[{
          RowBox[{"CoefficientRules", "[", "#", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", "1"}], "]"}], "]"}]}], "]"}], "&"}], "@", 
      "poly"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tTransform", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", 
        RowBox[{"4", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"t", "^", "2"}], "-", "1"}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"t", "^", "2"}], "+", "1"}], ")"}], "^", "2"}]}]}]}], 
       ",", 
       RowBox[{"y", "\[Rule]", 
        RowBox[{"8", 
         RowBox[{
          RowBox[{"t", "^", "3"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"t", "^", "2"}], "+", "1"}], ")"}], "^", "2"}]}]}]}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"equationForabc", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "3"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "s"}], ")"}], "*", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"r", "^", "2"}], "+", 
          RowBox[{"s", "^", "2"}], "+", 
          RowBox[{"4", "R", "*", "r"}]}], ")"}], "x"}], "-", 
       RowBox[{"(", 
        RowBox[{"4", "R", "*", "r", "*", "s"}], ")"}]}], "\[Equal]", "0"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"convertToxy", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "\[Rule]", 
        RowBox[{"x", "*", "R"}]}], ",", 
       RowBox[{"s", "\[Rule]", 
        RowBox[{"y", "*", "R"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"convertXYtoRrs", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", 
        RowBox[{"r", "/", "R"}]}], ",", 
       RowBox[{"y", "\[Rule]", 
        RowBox[{"s", "/", "R"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"triangleCondition", "=", 
     RowBox[{
      RowBox[{"a", ">", "0"}], "&&", 
      RowBox[{"b", ">", "0"}], "&&", 
      RowBox[{"c", ">", "0"}], "&&", 
      RowBox[{
       RowBox[{"a", "+", "b"}], ">", "c"}], "&&", 
      RowBox[{
       RowBox[{"b", "+", "c"}], ">", "a"}], "&&", 
      RowBox[{
       RowBox[{"c", "+", "a"}], ">", "b"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"redPrint", "[", "msg_", "]"}], ":=", 
     RowBox[{"Print", "[", 
      RowBox[{"Style", "[", 
       RowBox[{"msg", ",", "Red", ",", "Bold"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", "      ", 
    RowBox[{"ALGORITHM", " ", "B"}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "proveTriangleInequalityUsingBlundon", "]"}], 
     "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"triangleType", "\[Rule]", "\"\<all\>\""}], ",", 
       RowBox[{"Method", "\[Rule]", "\"\<xy\>\""}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"valid", " ", "triangle", " ", 
      RowBox[{"types", ":", " ", "AllTriangles"}]}], ",", " ", 
     "AcuteTriangle", ",", " ", "ObtuseTriangles", ",", " ", 
     "NonAcuteTriangles", ",", " ", "NonObtuseTriangles"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Valid", " ", 
      RowBox[{"Methods", ":", " ", "Automatic"}]}], ",", " ", "\"\<xy\>\"", 
     ",", " ", "\"\<t\>\""}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Automatic", " ", "will", " ", "make", " ", "a", " ", "guess", " ", 
      "about", " ", "whether", " ", "to", " ", "use", " ", "the", " ", "xy"}],
      "-", 
     RowBox[{"form", " ", "or", " ", "the", " ", "t"}], "-", 
     RowBox[{
     "form", " ", "based", "\[IndentingNewLine]", "on", " ", "the", " ", 
      "degree", " ", "of", " ", "the", " ", "polynomial", " ", "and", " ", 
      "is", " ", "not", " ", "guaranteed", " ", "to", " ", "always", " ", 
      "give", " ", "correct", " ", 
      RowBox[{"results", "/"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"By", " ", "default"}], ",", " ", 
     RowBox[{"this", " ", "routine", " ", "uses", " ", "Algorithm", " ", 
      RowBox[{"B", ".", " ", "To"}], " ", "use", " ", "Algorithm", " ", "S"}],
      ",", " ", 
     RowBox[{
      RowBox[{"add", " ", "the", " ", "argument", " ", "Method"}], "\[Rule]", 
      RowBox[{"\"\<t\>\"", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
      RowBox[{"inequality_", ",", 
       RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
        "rsExpr", ",", "xyExprz", ",", "left", ",", "right", ",", "opx", ",", 
         "ineq", ",", "rsIneq", ",", "num", ",", "den", ",", "expo", ",", 
         "vars", ",", "extraVars", ",", "extraVar", ",", 
         "\[IndentingNewLine]", "deg", ",", "plot", ",", "kres", ",", 
         "specialTriangleCondition", ",", "useTform", ",", "string", ",", 
         "relCount"}], "}"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"gExpr1", "=", "inequality"}], ";", " ", 
        RowBox[{"(*", " ", 
         RowBox[{"original", " ", "inequality"}], " ", "*)"}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Switch", "[", 
         RowBox[{
          RowBox[{"OptionValue", "[", "triangleType", "]"}], ",", 
          "\[IndentingNewLine]", "\"\<all\>\"", ",", 
          RowBox[{
           RowBox[{"specialTriangleCondition", "=", "True"}], ";", 
           RowBox[{"specialXYcondition", "=", "True"}]}], ",", 
          "\[IndentingNewLine]", "\"\<acute\>\"", ",", 
          RowBox[{
           RowBox[{"specialTriangleCondition", "=", 
            RowBox[{"s", ">", 
             RowBox[{
              RowBox[{"2", "R"}], "+", "r"}]}]}], ";", 
           RowBox[{"specialXYcondition", "=", 
            RowBox[{"y", ">", 
             RowBox[{"2", "+", "x"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\"\<nonobtuse\>\"", ",", 
          RowBox[{
           RowBox[{"specialTriangleCondition", "=", 
            RowBox[{"s", ">=", 
             RowBox[{
              RowBox[{"2", "R"}], "+", "r"}]}]}], ";", 
           RowBox[{"specialXYcondition", "=", 
            RowBox[{"y", ">=", 
             RowBox[{"2", "+", "x"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\"\<obtuse\>\"", ",", 
          RowBox[{
           RowBox[{"specialTriangleCondition", "=", 
            RowBox[{"s", "<", 
             RowBox[{
              RowBox[{"2", "R"}], "+", "r"}]}]}], ";", 
           RowBox[{"specialXYcondition", "=", 
            RowBox[{"y", "<", 
             RowBox[{"2", "+", "x"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\"\<nonacute\>\"", ",", 
          RowBox[{
           RowBox[{"specialTriangleCondition", "=", 
            RowBox[{"s", "<=", 
             RowBox[{
              RowBox[{"2", "R"}], "+", "r"}]}]}], ";", 
           RowBox[{"specialXYcondition", "=", 
            RowBox[{"y", "<=", 
             RowBox[{"2", "+", "x"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\"\<right\>\"", ",", 
          RowBox[{
           RowBox[{"specialTriangleCondition", "=", 
            RowBox[{"s", "==", 
             RowBox[{
              RowBox[{"2", "R"}], "+", "r"}]}]}], ";", 
           RowBox[{"specialXYcondition", "=", 
            RowBox[{"y", "==", 
             RowBox[{"2", "+", "x"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\"\<special\>\"", ",", 
          RowBox[{
           RowBox[{"specialTriangleCondition", "=", "gSpecial"}], ";", 
           RowBox[{"specialXYcondition", "=", "gSpecialxy"}]}], ",", 
          "\[IndentingNewLine]", "_", ",", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"algorithmB", "::", "unknownType"}], ",", 
             RowBox[{"resultArg", "=", 
              RowBox[{"OptionValue", "[", "triangleType", "]"}]}]}], "]"}], 
           ";", 
           RowBox[{"Return", "[", "]"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"specialTcondition", "=", 
         RowBox[{"specialXYcondition", "/.", "tTransform"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"useTform", "=", "False"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"Switch", "[", 
         RowBox[{
          RowBox[{"OptionValue", "[", "Method", "]"}], ",", 
          "\[IndentingNewLine]", "\"\<xy\>\"", ",", 
          RowBox[{"useTform", "=", "False"}], ",", "\[IndentingNewLine]", 
          "\"\<t\>\"", ",", " ", 
          RowBox[{"useTform", "=", "True"}], ",", "\[IndentingNewLine]", 
          "Automatic", ",", " ", 
          RowBox[{"useTform", "=", "False"}], ",", "\[IndentingNewLine]", "_",
           ",", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"algorithmB", "::", "unknownMethod"}], ",", 
            RowBox[{"resultArg", "=", 
             RowBox[{"OptionValue", "[", "Method", "]"}]}]}], "]"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"inequality", "===", "True"}], ",", 
          RowBox[{"Return", "[", "True", "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"inequality", "===", "False"}], ",", 
          RowBox[{"Return", "[", "False", "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Check", " ", "that", " ", "the", " ", "expression", " ", "has", " ",
           "exactly", " ", "one", " ", "relational", " ", "symbol"}], " ", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"string", "=", 
         RowBox[{"ToString", "[", "inequality", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"string", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"string", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\"\<<=\>\"", "\[Rule]", "\"\<<\>\""}], ",", 
             RowBox[{"\"\<>=\>\"", "\[Rule]", "\"\<>\>\""}], ",", 
             RowBox[{"\"\<==\>\"", "\[Rule]", "\"\<=\>\""}], ",", 
             RowBox[{"\"\<\[Equal]\>\"", "\[Rule]", "\"\<=\>\""}]}], "}"}]}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"relCount", "=", 
         RowBox[{"StringCount", "[", 
          RowBox[{"string", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<<\>\"", ",", "\"\<>\>\"", ",", "\"\<=\>\""}], 
            "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"relCount", ">", "1"}], ",", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{"algorithmB", "::", "tooManyIneq"}], "]"}], ";", 
           RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"relCount", "==", "0"}], ",", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{"algorithmB", "::", "notIneq"}], "]"}], ";", 
           RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"STEP", " ", "1"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Move", " ", "larger", " ", "expression", " ", "to", " ", "left", 
          " ", "side"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"op", "=", "\"\<none\>\""}], ";", "\[IndentingNewLine]", 
        RowBox[{"Switch", "[", 
         RowBox[{"inequality", ",", "\[IndentingNewLine]", 
          RowBox[{"_", ">", "_"}], ",", " ", 
          RowBox[{
           RowBox[{"inequality", "/.", 
            RowBox[{
             RowBox[{"p_", ">", "q_"}], ":>", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"left", "=", "p"}], ")"}], ">", 
              RowBox[{"(", 
               RowBox[{"right", "=", "q"}], ")"}]}]}]}], ";", 
           RowBox[{"op", "=", "Greater"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"_", ">=", "_"}], ",", " ", 
          RowBox[{
           RowBox[{"inequality", "/.", 
            RowBox[{
             RowBox[{"p_", ">=", "q_"}], ":>", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"left", "=", "p"}], ")"}], ">=", 
              RowBox[{"(", 
               RowBox[{"right", "=", "q"}], ")"}]}]}]}], ";", 
           RowBox[{"op", "=", "GreaterEqual"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"_", "<", "_"}], ",", " ", 
          RowBox[{
           RowBox[{"inequality", "/.", 
            RowBox[{
             RowBox[{"p_", "<", "q_"}], ":>", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"left", "=", "q"}], ")"}], "<", 
              RowBox[{"(", 
               RowBox[{"right", "=", "p"}], ")"}]}]}]}], ";", 
           RowBox[{"op", "=", "Greater"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"_", "<=", "_"}], ",", " ", 
          RowBox[{
           RowBox[{"inequality", "/.", 
            RowBox[{
             RowBox[{"p_", "<=", "q_"}], ":>", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"left", "=", "q"}], ")"}], "<=", 
              RowBox[{"(", 
               RowBox[{"right", "=", "p"}], ")"}]}]}]}], ";", 
           RowBox[{"op", "=", "GreaterEqual"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"j_", "\[Equal]", "_"}], ",", 
          RowBox[{
           RowBox[{"inequality", "/.", 
            RowBox[{
             RowBox[{"p_", "==", "q_"}], ":>", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"left", "=", "p"}], ")"}], "==", 
              RowBox[{"(", 
               RowBox[{"right", "=", "q"}], ")"}]}]}]}], ";", 
           RowBox[{"op", "=", "Equal"}]}], ",", " ", 
          RowBox[{"(*", " ", 
           RowBox[{"must", " ", "name", " ", "pattern"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"j_", "==", "_"}], ",", 
          RowBox[{
           RowBox[{"inequality", "/.", 
            RowBox[{
             RowBox[{"p_", "==", "q_"}], ":>", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"left", "=", "p"}], ")"}], "==", 
              RowBox[{"(", 
               RowBox[{"right", "=", "q"}], ")"}]}]}]}], ";", 
           RowBox[{"op", "=", "Equal"}]}], ",", "\[IndentingNewLine]", "_", 
          ",", " ", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{"algorithmB", "::", "notIneq"}], "]"}], ";", " ", 
           RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"ineq", "=", 
         RowBox[{"op", "[", 
          RowBox[{"left", ",", "right"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"showSteps", ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"inequality", "=!=", "ineq"}], ",", 
             RowBox[{"Print", "[", 
              RowBox[{"\"\<Normalized to: \>\"", ",", "ineq"}], "]"}]}], 
            "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"STEP", " ", "2"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Bring", " ", "all", " ", "terms", " ", "to", " ", "the", " ", 
          "left", " ", "side"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"expr", "=", 
         RowBox[{"left", "-", "right"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"gExpr2", "=", 
         RowBox[{"op", "[", 
          RowBox[{"expr", ",", "0"}], "]"}]}], ";", " ", 
        RowBox[{"(*", " ", 
         RowBox[{"normalized", " ", "inequality"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"showExpressionSimplification", ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Print", "[", 
            RowBox[{"\"\<a-b-c form: \>\"", ",", "expr"}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Print", "[", 
            RowBox[{"\"\<a-b-c form (simplified): \>\"", ",", 
             RowBox[{"Simplify", "[", "expr", "]"}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"STEP", " ", "3"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
          "Convert", " ", "to", " ", "expression", " ", "involving", " ", 
           "only", " ", "R"}], ",", " ", "r", ",", " ", 
          RowBox[{"and", " ", "s"}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"rsExpr", "=", 
         RowBox[{"convertToRrs", "[", "expr", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"rsExpr", "===", "$Failed"}], ",", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{"algorithmB", "::", "notSymmetric"}], "]"}], ";", " ", 
           RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rsIneq", "=", 
         RowBox[{"op", "[", 
          RowBox[{"rsExpr", ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"gExpr8", "=", "rsIneq"}], ";", " ", 
        RowBox[{"(*", " ", 
         RowBox[{"R", "-", "r", "-", 
          RowBox[{"s", " ", "form"}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"showSteps", ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Print", "[", 
            RowBox[{"\"\<R-r-s form: \>\"", ",", "rsIneq"}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"vars", "=", 
         RowBox[{"Variables", "[", "rsExpr", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"FreeQ", " ", "[", 
            RowBox[{"rsExpr", ",", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"x_", "/;", 
               RowBox[{"!", 
                RowBox[{"NumberQ", "[", "x", "]"}]}]}], "]"}]}], "]"}]}], ",",
           "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{"algorithmB", "::", "notPolynomial"}], "]"}], ";", " ", 
           RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"ContainsOnly", "[", 
            RowBox[{"vars", ",", 
             RowBox[{"{", 
              RowBox[{"r", ",", "R", ",", "s", ",", "k"}], "}"}]}], "]"}]}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"extraVars", "=", 
            RowBox[{"Complement", "[", 
             RowBox[{"vars", ",", 
              RowBox[{"{", 
               RowBox[{"r", ",", "R", ",", "s", ",", "k"}], "}"}]}], "]"}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"extraVar", "=", 
            RowBox[{"extraVars", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"algorithmB", "::", "badVar"}], ",", 
             RowBox[{"resultArg", "=", "extraVar"}]}], "]"}], ";", " ", 
           RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"BooleanQ", "[", "rsIneq", "]"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"FreeQ", "[", 
             RowBox[{"ineq", ",", "k"}], "]"}], ",", 
            RowBox[{"Return", "[", "rsIneq", "]"}], ",", 
            RowBox[{"Return", "[", 
             RowBox[{"{", 
              RowBox[{"rsIneq", ",", "0", ",", "Infinity"}], "}"}], "]"}]}], 
           "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"STEP", " ", "4"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
          "Since", " ", "the", " ", "expression", " ", "is", " ", 
           "homogeneous", " ", "in", " ", "R"}], ",", " ", "r", ",", " ", 
          RowBox[{"and", " ", "s"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
           "we", " ", "only", " ", "care", " ", "about", " ", "their", " ", 
            RowBox[{"ratios", ".", " ", "Apply"}], " ", "the", " ", "Bottema",
             " ", 
            RowBox[{"variation", ":", " ", "x"}]}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"r", "/", "R"}], " ", "and", " ", "y"}], "=", 
            RowBox[{"s", "/", 
             RowBox[{"R", "."}]}]}]}]}], " ", "\[IndentingNewLine]", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"xyExpr", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"rsExpr", "/.", "convertToxy"}], "//", "Together"}], "//", 
          "Simplify"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"R", " ", "is", " ", "always", " ", "positive"}], ",", " ", 
          RowBox[{
          "so", " ", "we", " ", "can", " ", "divide", " ", "out", " ", 
           "factors", " ", "of", " ", "R"}]}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"xyExpr", "=!=", "0"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"expo", "=", 
            RowBox[{"Exponent", "[", 
             RowBox[{"xyExpr", ",", "R"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"xyExpr", "=", 
            RowBox[{"Simplify", "[", 
             RowBox[{
              RowBox[{"xyExpr", "/", 
               RowBox[{"(", 
                RowBox[{"R", "^", "expo"}], ")"}]}], ",", 
              RowBox[{"R", ">", "0"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"gExpr9", "=", 
            RowBox[{"op", "[", 
             RowBox[{"xyExpr", ",", "0"}], "]"}]}], ";", " ", 
           RowBox[{"(*", " ", 
            RowBox[{"xy", " ", "form"}], " ", "*)"}], "\[IndentingNewLine]", 
           RowBox[{"vars", "=", 
            RowBox[{"Variables", "[", "xyExpr", "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"!", 
              RowBox[{"ContainsOnly", "[", 
               RowBox[{"vars", ",", 
                RowBox[{"{", 
                 RowBox[{"x", ",", "y", ",", "k"}], "}"}]}], "]"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"extraVars", "=", 
               RowBox[{"Complement", "[", 
                RowBox[{"vars", ",", 
                 RowBox[{"{", 
                  RowBox[{"x", ",", "y", ",", "k"}], "}"}]}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"extraVar", "=", 
               RowBox[{"extraVars", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{"extraVars", ",", "R"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"Message", "[", 
                  RowBox[{"algorithmB", "::", "inhomog"}], "]"}], ";", 
                 RowBox[{"Return", "[", "$Failed", "]"}], ";"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Message", "[", 
                   RowBox[{
                    RowBox[{"algorithmB", "::", "badVar"}], ",", 
                    RowBox[{"resultArg", "=", "extraVar"}]}], "]"}], 
                  RowBox[{"Return", "[", "$Failed", "]"}]}], ";"}]}], 
               "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}],
            ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
          "If", " ", "the", " ", "denominator", " ", "is", " ", "numeric"}], 
          ",", " ", 
          RowBox[{"we", " ", "can", " ", "delete", " ", "it"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
          "changing", " ", "the", " ", "sign", " ", "of", " ", "the", " ", 
           "numerator", " ", "if", " ", "the", " ", "denominator", " ", "is", 
           " ", 
           RowBox[{"negative", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"xyExpr", "=", 
         RowBox[{"Together", "[", "xyExpr", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"num", "=", 
         RowBox[{"Numerator", "[", "xyExpr", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"den", "=", 
         RowBox[{"Denominator", "[", "xyExpr", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"gExpr10", "=", 
         RowBox[{"op", "[", 
          RowBox[{
           RowBox[{"num", "/", "den"}], ",", "0"}], "]"}]}], ";", " ", 
        RowBox[{"(*", " ", 
         RowBox[{"x", "-", 
          RowBox[{"y", " ", "combined", " ", "form"}]}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"NumericQ", "[", "den", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"den", ">", "0"}], ",", 
             RowBox[{"xyExpr", "=", 
              RowBox[{"xyExpr", "*", "den"}]}], ",", 
             RowBox[{"xyExpr", "=", 
              RowBox[{
               RowBox[{"-", "xyExpr"}], "*", "den"}]}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"showSteps", ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Print", "[", 
            RowBox[{"\"\<x-y form: \>\"", ",", "xyExpr"}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"STEP", " ", "5"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"Remove", " ", "fractions"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
          "suffices", " ", "to", " ", "show", " ", "that", " ", "xyExpr"}], 
          ">", "fundamentalFunction"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"xyNum", "=", "num"}], ";", "\[IndentingNewLine]", 
        RowBox[{"xyExpr", "=", 
         RowBox[{"convertToPolynomial", "[", "xyExpr", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"PolynomialQ", "[", 
            RowBox[{"xyExpr", ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", "y", ",", "k"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"algorithmB", "::", "notPoly"}], ",", 
            RowBox[{"resultArg", "=", "xyExpr"}]}], "]"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"gExpr11", "=", 
         RowBox[{"op", "[", 
          RowBox[{"xyExpr", ",", "0"}], "]"}]}], ";", " ", 
        RowBox[{"(*", " ", 
         RowBox[{"x", "-", 
          RowBox[{"y", " ", "form", " ", "without", " ", "fractions"}]}], " ",
          "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"showSteps", ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Print", "[", 
            RowBox[{"\"\<x-y polynomial: \>\"", ",", "xyExpr"}], "]"}], 
           ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"op", "\[Equal]", "Equal"}], "&&", 
           RowBox[{"FreeQ", "[", 
            RowBox[{"xyExpr", ",", "k"}], "]"}]}], ",", 
          RowBox[{"Return", "[", "False", "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
          "If", " ", "the", " ", "expression", " ", "involves", " ", "the", 
           " ", "variable", " ", "k"}], ",", " ", 
          RowBox[{"then", " ", "use", " ", "Algorithm", " ", "K"}]}], " ", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"functionRegion", "=", "Null"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"FreeQ", "[", 
            RowBox[{"xyExpr", ",", "k"}], "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{"useTform", ",", "\[IndentingNewLine]", 
             RowBox[{"kres", "=", 
              RowBox[{"findBestKusingT", "[", 
               RowBox[{"xyExpr", ",", "specialTcondition"}], "]"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"kres", "=", 
              RowBox[{"findBestK", "[", 
               RowBox[{"xyExpr", ",", "specialXYcondition"}], "]"}]}]}], 
            "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"Return", "[", "kres", "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"xyExpr", "\[Equal]", "False"}], ",", 
          RowBox[{"Return", "[", "False", "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"STEP", " ", "6"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"deg", "=", 
         RowBox[{"polynomialDegree", "[", "xyExpr", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"functionRegion", "=", 
         RowBox[{
          RowBox[{"xyExpr", ">=", "0"}], "&&", 
          RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
          RowBox[{"y", "\[GreaterEqual]", "0"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"showRegions", ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"plot", "=", 
            RowBox[{"RegionPlot", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"functionRegion", ",", 
                RowBox[{"fundamentalRegion", "&&", "specialXYcondition"}]}], 
               "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"y", ",", "0", ",", "4"}], "}"}], ",", 
              RowBox[{"BoundaryStyle", "\[Rule]", "Red"}], ",", 
              RowBox[{"PlotLegends", "\[Rule]", "\"\<Expressions\>\""}], ",", 
              RowBox[{"PlotPoints", "\[Rule]", "100"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Print", "[", "plot", "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"OptionValue", "[", "Method", "]"}], "===", "Automatic"}],
            "&&", 
           RowBox[{"deg", "\[Equal]", "2"}]}], ",", 
          RowBox[{"useTform", "=", "True"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"useTform", ",", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{
            "Use", " ", "Algorithm", " ", "S", " ", "if", " ", "argument", 
             " ", "Method"}], "\[Rule]", 
            RowBox[{"\"\<t\>\"", " ", "was", " ", 
             RowBox[{"specified", "."}]}]}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"truth", "=", 
           RowBox[{"simplifyUsingT", "[", 
            RowBox[{"xyExpr", ",", "xyNum", ",", "specialTcondition"}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Otherwise", ",", " ", 
            RowBox[{"use", " ", "Algorithm", " ", "K"}]}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"truth", "=", 
           RowBox[{"simplifyUsingXY", "[", 
            RowBox[{"xyExpr", ",", "xyNum", ",", "specialXYcondition"}], 
            "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"truth", "=!=", "True"}], ",", 
          RowBox[{"truth", "=", "False"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "truth", "]"}], ";"}]}], "\[IndentingNewLine]",
       "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"simplifyUsingXY", "[", 
      RowBox[{"xyExpr_", ",", "xyNum_", ",", "specialXYcondition_"}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", "truth", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"truth", "=", 
         RowBox[{"Simplify", "[", 
          RowBox[{
           RowBox[{"xyExpr", ">=", "0"}], ",", 
           RowBox[{"fundamentalRegion", "&&", "specialXYcondition"}]}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"truth", "=!=", "True"}], ",", 
          RowBox[{"truth", "=", "False"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
          "If", " ", "global", " ", "variable", " ", "showCounterexample", 
           " ", "is", " ", "True"}], ",", " ", 
          RowBox[{"then", " ", "use", " ", "Algorithm", " ", "C"}]}], " ", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"!", "truth"}], "&&", "showCounterexample"}], ",", 
          RowBox[{"findCounterexampleFromXY", "[", "xyExpr", "]"}]}], "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
          "If", " ", "global", " ", "variable", " ", 
           "showConditionsForEquality", " ", "is", " ", "True"}], ",", " ", 
          RowBox[{"then", " ", "use", " ", "Algorithm", " ", "Q"}]}], " ", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"truth", "&&", 
           RowBox[{"showConditionsForEquality", "=!=", "False"}]}], ",", 
          RowBox[{"showEqualityUsingXY", "[", "xyNum", "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "truth", "]"}], ";"}]}], "\[IndentingNewLine]",
       "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"simplifyUsingT", "[", 
      RowBox[{"xyExpr_", ",", "xyNum_", ",", "specialTcondition_"}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tExpr", ",", "num", ",", "den", ",", "truth"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"STEP", " ", "8"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"tExpr", "=", 
         RowBox[{
          RowBox[{"xyExpr", "/.", "tTransform"}], "//", "Simplify"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"showSteps", ",", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<t-form: \>\"", ",", "tExpr"}], "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"STEP", " ", "9"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"tExpr", "=", 
         RowBox[{"removePositiveFactors", "[", 
          RowBox[{"tExpr", ",", 
           RowBox[{"t", ">", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"STEP", " ", "10"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"num", ",", "den"}], "}"}], "=", 
         RowBox[{"NumeratorDenominator", "[", "tExpr", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"tExpr", "=", 
         RowBox[{"num", "*", "den"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"showSteps", ",", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<pos t-form: \>\"", ",", "tExpr"}], "]"}]}], "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"STEP", " ", "11"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"truth", "=", 
         RowBox[{
          RowBox[{"Simplify", "[", 
           RowBox[{
            RowBox[{"tExpr", ">=", "0"}], ",", 
            RowBox[{
             RowBox[{"t", ">", "1"}], "&&", "specialTcondition"}]}], "]"}], "//",
           "Quiet"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"truth", "=!=", "True"}], ",", 
          RowBox[{"truth", "=", "False"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
          "If", " ", "global", " ", "variable", " ", "showCounterexample", 
           " ", "is", " ", "True"}], ",", " ", 
          RowBox[{
           RowBox[{"then", " ", "use", " ", "Algorithm", " ", "C"}], "-", 
           "star"}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"!", "truth"}], "&&", "showCounterexample"}], ",", 
          RowBox[{"findCounterexampleFromT", "[", "tExpr", "]"}]}], "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
          "If", " ", "global", " ", "variable", " ", 
           "showConditionsForEquality", " ", "is", " ", "True"}], ",", " ", 
          RowBox[{
           RowBox[{"then", " ", "use", " ", "Algorithm", " ", "Q"}], "-", 
           "star"}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"truth", "&&", 
           RowBox[{"showConditionsForEquality", "=!=", "False"}]}], ",", 
          RowBox[{"showEqualityUsingT", "[", 
           RowBox[{"xyNum", "/.", "tTransform"}], "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "truth", "]"}], ";"}]}], "\[IndentingNewLine]",
       "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", "      ", 
    RowBox[{
     RowBox[{"ALGORITHM", " ", "C", " ", "or", " ", "C"}], "-", "star"}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"findCounterexample", "[", "expr_", "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{"expr", ",", "t"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"findCounterexampleFromXY", "[", "expr", "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"findCounterexampleFromT", "[", "expr", "]"}]}], 
         "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", "      ", 
    RowBox[{"ALGORITHM", " ", "C"}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"findCounterexampleFromXY", "[", "xyExpr_", "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "instance", ",", "xval", ",", "yval", ",", "aval", ",", "bval", ",", 
         "cval", ",", "ans", ",", "g", ",", "Rval"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"instance", "=", 
         RowBox[{"FindInstance", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"xyExpr", "<", "0"}], "&&", 
              RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
              RowBox[{"y", "\[GreaterEqual]", "0"}]}], ",", 
             RowBox[{
              RowBox[{"fundamentalFunction", "\[LessEqual]", "0"}], "&&", 
              RowBox[{"x", ">", "0"}], "&&", 
              RowBox[{"y", ">", "0"}]}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"instance", "\[Equal]", 
           RowBox[{"{", "}"}]}], ",", 
          RowBox[{"Message", "[", 
           RowBox[{"algorithmC", "::", "noInstance"}], "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"instance", "=", 
         RowBox[{"First", "[", "instance", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"xval", ",", "yval"}], "}"}], "=", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], "/.", "instance"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Rval", "=", "1"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"xval", "\[Element]", "Rationals"}], "&&", 
           RowBox[{"yval", "\[Element]", "Rationals"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"g", "=", 
            RowBox[{"GCD", "[", 
             RowBox[{"xval", ",", "yval"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Rval", ",", "xval", ",", "yval"}], "}"}], "=", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Rval", ",", "xval", ",", "yval"}], "}"}], "/", "g"}]}],
            ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"getABCforCounterexample", "[", 
         RowBox[{"Rval", ",", "xval", ",", "yval"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", "      ", 
    RowBox[{
     RowBox[{"ALGORITHM", " ", "C"}], "-", "star"}], "\[IndentingNewLine]", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"findCounterexampleFromT", "[", "tExpr_", "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "instance", ",", "tval", ",", "Rval", ",", "rval", ",", "sval"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"instance", "=", 
         RowBox[{"FindInstance", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"tExpr", "<", "0"}], "&&", 
            RowBox[{"t", ">", "1"}]}], ",", "t"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"instance", "\[Equal]", 
           RowBox[{"{", "}"}]}], ",", 
          RowBox[{"Message", "[", 
           RowBox[{"algorithmC", "::", "noInstance"}], "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"instance", "=", 
         RowBox[{"First", "[", "instance", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"tval", "=", 
         RowBox[{"t", "/.", "instance"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<t-instance=\>\"", ",", "tval"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Rval", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"tval", "^", "2"}], "+", "1"}], ")"}], "^", "2"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rval", "=", 
         RowBox[{"4", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"tval", "^", "2"}], "-", "1"}], ")"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"sval", "=", 
         RowBox[{"8", 
          RowBox[{"tval", "^", "3"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"getABCforCounterexample", "[", 
         RowBox[{"Rval", ",", "rval", ",", "sval"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"getABCforCounterexample", "[", 
      RowBox[{"Rval_", ",", "rval_", ",", "sval_"}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "ansx", ",", "aval", ",", "bval", ",", "cval", ",", "abcEquation"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"abcEquation", "=", 
         RowBox[{"equationForabc", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"r", "\[Rule]", "rval"}], ",", 
            RowBox[{"s", "\[Rule]", "sval"}], ",", 
            RowBox[{"R", "\[Rule]", "Rval"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<Equation for a, b, and c is: \>\"", ",", "abcEquation"}], "]"}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"ans", "=", 
         RowBox[{
          RowBox[{"Solve", "[", 
           RowBox[{"abcEquation", ",", "x"}], "]"}], "//", "N"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"aval", ",", "bval", ",", "cval"}], "}"}], "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"x", "/.", 
            RowBox[{"ans", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<ans=\>\"", ",", "ans"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"aval", " ", "\[Element]", " ", "PositiveReals"}], "&&", 
           RowBox[{"bval", " ", "\[Element]", " ", "PositiveReals"}], "&&", 
           RowBox[{"cval", " ", "\[Element]", " ", "PositiveReals"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<counterexample: a=\>\"", ",", "aval", ",", "\"\< b=\>\"", ",",
             "bval", ",", "\"\< c=\>\"", ",", "cval", ",", "\"\< R=\>\"", ",",
             "Rval", ",", "\"\< r=\>\"", ",", "rval", ",", "\"\< s=\>\"", ",",
             "aval", ",", "\"\< K=\>\"", ",", 
            RowBox[{"rval", "*", "sval"}], ",", "\[IndentingNewLine]", 
            "\"\< x=\>\"", ",", 
            RowBox[{"rval", "/", "Rval"}], ",", "\"\< y=\>\"", ",", 
            RowBox[{"sval", "/", "Rval"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<Bug. Complex solutions found: a=\>\"", ",", "aval", ",", 
            "\"\< b=\>\"", ",", "bval", ",", "\"\< c=\>\"", ",", "cval", ",", 
            "\"\< R=\>\"", ",", "Rval", ",", "\"\< r=\>\"", ",", "rval", ",", 
            "\"\< s=\>\"", ",", "sval", ",", "\"\< K=\>\"", ",", 
            RowBox[{"rval", "*", "sval"}]}], "]"}]}], "\[IndentingNewLine]", 
         "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", "      ", 
    RowBox[{"ALGORITHM", " ", "Q"}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"showEqualityUsingXY", "[", "xyExpr_", "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ans", ",", "num", ",", "den"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<using xy: \>\"", ",", "xyExpr"}], "]"}], ";"}], 
        "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"showConditionsForEquality", "===", "False"}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"expr", "=", 
         RowBox[{"removePositiveFactors", "[", 
          RowBox[{"xyExpr", ",", 
           RowBox[{
            RowBox[{"x", ">", "0"}], "&&", 
            RowBox[{"y", ">", "0"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ans", "=", 
         RowBox[{
          RowBox[{"Solve", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"expr", "\[Equal]", "0"}], ",", "fundamentalRegion"}], 
             "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}], ",", "PositiveReals"}], "]"}], "//",
           "Quiet"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ans", "=", 
         RowBox[{"TimeConstrained", "[", 
          RowBox[{
           RowBox[{"FullSimplify", "[", "ans", "]"}], ",", "2", ",", "ans"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ans", "=", 
         RowBox[{"DeleteDuplicates", "[", "ans", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ans", "\[Equal]", 
           RowBox[{"{", 
            RowBox[{"{", "}"}], "}"}]}], ",", 
          RowBox[{
           RowBox[{
           "Print", "[", "\"\<Equality is true for all triangles.\>\"", "]"}],
            ";", 
           RowBox[{"Return", "[", "]"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ans", "\[Equal]", 
           RowBox[{"{", "}"}]}], ",", 
          RowBox[{
           RowBox[{"Print", "[", "\"\<Equality cannot occur.\>\"", "]"}], ";", 
           RowBox[{"Return", "[", "]"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Map", "[", 
         RowBox[{"showEqXY", ",", "ans"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", "      ", 
    RowBox[{
     RowBox[{"ALGORITHM", " ", "Q"}], "-", "star"}], "\[IndentingNewLine]", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"showEqualityUsingT", "[", "tExpr_", "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ans", ",", "tExp"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"showConditionsForEquality", "===", "False"}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"tExp", "=", 
         RowBox[{"removePositiveFactors", "[", 
          RowBox[{"tExpr", ",", 
           RowBox[{"t", ">", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ans", "=", 
         RowBox[{
          RowBox[{"Solve", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tExp", "\[Equal]", "0"}], ",", 
              RowBox[{"t", ">", "1"}]}], "}"}], ",", "t", ",", 
            "PositiveReals"}], "]"}], "//", "Quiet"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ans", "=", 
         RowBox[{"DeleteDuplicates", "[", "ans", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ans", "\[Equal]", 
           RowBox[{"{", 
            RowBox[{"{", "}"}], "}"}]}], ",", 
          RowBox[{
           RowBox[{
           "Print", "[", "\"\<Equality is true for all triangles.\>\"", "]"}],
            ";", 
           RowBox[{"Return", "[", "]"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ans", "\[Equal]", 
           RowBox[{"{", "}"}]}], ",", 
          RowBox[{
           RowBox[{"Print", "[", "\"\<Equality cannot occur.\>\"", "]"}], ";", 
           RowBox[{"Return", "[", "]"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Map", "[", 
         RowBox[{"showEqT", ",", "ans"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"showEqT", "[", "cond_", "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tval", ",", "Rval", ",", "rval", ",", "sval"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{
         "cond", " ", "is", " ", "of", " ", "the", " ", "form", " ", "t"}], 
         "\[Rule]", "tval"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"tval", "=", 
         RowBox[{"t", "/.", "cond"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"showConditionsForEquality", "=!=", "All"}], "&&", 
           RowBox[{"tval", "\[Equal]", 
            RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Equality occurs for t=\>\"", ",", "tval"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Rval", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"tval", "^", "2"}], "+", "1"}], ")"}], "^", "2"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rval", "=", 
         RowBox[{"4", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"tval", "^", "2"}], "-", "1"}], ")"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"sval", "=", 
         RowBox[{"8", 
          RowBox[{"tval", "^", "3"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Head", "[", "tval", "]"}], "=!=", "Root"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Rval", ",", "rval", ",", "sval"}], "}"}], "=", 
           RowBox[{"Simplify", "[", 
            RowBox[{"{", 
             RowBox[{"Rval", ",", "rval", ",", "sval"}], "}"}], "]"}]}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"showEq", "[", 
         RowBox[{"Rval", ",", "rval", ",", "sval"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"showEqXY", "[", "cond_", "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"g", ",", "xval", ",", "yval"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"cond", " ", "is", " ", "of", " ", "the", " ", "form", " ", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}]}], "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"xval", ",", "yval"}], "}"}]}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"xval", ",", "yval"}], "}"}], "=", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], "/.", "cond"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"xval", "=", 
         RowBox[{"RootReduce", "[", "xval", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"yval", "=", 
         RowBox[{"RootReduce", "[", "yval", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Equality occurs for (x,y)=\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"xval", ",", "yval"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"showConditionsForEquality", "=!=", "All"}], "&&", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"xval", ",", "yval"}], "}"}], "\[Equal]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1", "/", "2"}], ",", 
              RowBox[{"3", 
               RowBox[{
                RowBox[{"Sqrt", "[", "3", "]"}], "/", "2"}]}]}], "}"}]}]}], 
          ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"IntegerQ", "[", "xval", "]"}], "&&", 
           RowBox[{"IntegerQ", "[", "yval", "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"g", "=", 
            RowBox[{"GCD", "[", 
             RowBox[{"xval", ",", "yval"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"xval", ",", "yval"}], "}"}], "=", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"xval", ",", "yval"}], "}"}], "/", "g"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"showEq", "[", 
         RowBox[{"1", ",", "xval", ",", "yval"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"showEq", "[", 
      RowBox[{"Rval_", ",", "rval_", ",", "sval_"}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "g", ",", "ans", ",", "aval", ",", "bval", ",", "cval", ",", "xval", 
         ",", "yval", ",", "equation", ",", "cubic", ",", "triple"}], "}"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"equation", "=", 
         RowBox[{"equationForabc", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"R", "\[Rule]", "Rval"}], ",", 
            RowBox[{"r", "\[Rule]", "rval"}], ",", 
            RowBox[{"s", "\[Rule]", "sval"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"cubic", "=", 
         RowBox[{"First", "[", "equation", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"cubic", "=", 
         RowBox[{"Map", "[", 
          RowBox[{"RootReduce", ",", "cubic"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"equation", "=", 
         RowBox[{"cubic", "\[Equal]", "0"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ans", "=", 
         RowBox[{"TimeConstrained", "[", 
          RowBox[{
           RowBox[{"Solve", "[", 
            RowBox[{"equation", ",", "x"}], "]"}], ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ans", "===", "$Aborted"}], ",", 
          RowBox[{
           RowBox[{
           "Print", "[", "\"\<Taking too long to find a, b, and c.\\n\>\"", 
            "]"}], ";", 
           RowBox[{"Print", "[", 
            RowBox[{
            "\"\<Equality condition: R=\>\"", ",", "Rval", ",", 
             "\"\<, r=\>\"", ",", "rval", ",", "\"\<, s=\>\"", ",", "sval"}], 
            "]"}], ";", 
           RowBox[{"Return", "[", "]"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"aval", ",", "bval", ",", "cval"}], "}"}], "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"x", "/.", 
            RowBox[{"ans", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<Equality condition: R=\>\"", ",", "Rval", ",", "\"\<, r=\>\"", 
          ",", "rval", ",", "\"\<, s=\>\"", ",", "sval"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<a, b, c are roots of \>\"", ",", "equation"}], "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"aval", ",", "bval", ",", "cval"}], "}"}], "=", 
         RowBox[{"Sort", "[", 
          RowBox[{"{", 
           RowBox[{"aval", ",", "bval", ",", "cval"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"aval", "\[Equal]", "bval"}], "&&", 
           RowBox[{"aval", "\[Equal]", "cval"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<{a,b,c}=\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"aval", ",", "bval", ",", "cval"}], "}"}], ",", 
            "\"\< which is equivalent to {1,1,1}\>\""}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"bval", "\[Equal]", "cval"}], ",", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"aval", ",", "bval", ",", "cval"}], "}"}], "=", 
              RowBox[{"{", 
               RowBox[{"cval", ",", "bval", ",", "aval"}], "}"}]}]}], "]"}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"aval", "\[Equal]", "bval"}], ",", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"aval", ",", "bval", ",", "cval"}], "}"}], "=", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"aval", ",", "bval", ",", "cval"}], "}"}], "/", 
               "aval"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"ans", "=", 
            RowBox[{"TimeConstrained", "[", 
             RowBox[{
              RowBox[{"triple", "=", 
               RowBox[{"RootReduce", "[", 
                RowBox[{"{", 
                 RowBox[{"aval", ",", "bval", ",", "cval"}], "}"}], "]"}]}], 
              ",", "10"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ans", "=!=", "$Aborted"}], ",", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"aval", ",", "bval", ",", "cval"}], "}"}], "=", 
              "triple"}]}], "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"Print", "[", 
            RowBox[{"\"\<{a,b,c}=\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"aval", ",", "bval", ",", "cval"}], "}"}]}], "]"}], 
           ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", "      ", 
    RowBox[{"ALGORITHM", " ", "V"}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"verifyIdentity", "[", "expr_", "]"}], ":=", 
     RowBox[{"proveTriangleInequalityUsingBlundon", "[", "expr", "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", "      ", 
    RowBox[{"ALGORITHM", " ", "K"}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Find", " ", "condition"}], ",", " ", "kCondition", ",", " ", 
     RowBox[{
     "that", " ", "k", " ", "must", " ", "satisfy", " ", "to", " ", "make", 
      " ", "the", " ", "inequality", " ", "true"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Return", " ", "the", " ", "triple", " ", 
     RowBox[{"{", 
      RowBox[{"kCondition", ",", " ", "minK", ",", " ", "maxK"}], "}"}]}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"findBestK", "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"specialXYcondition_:", "True"}]}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"kCondition", ",", "minK", ",", "maxK", ",", "exp"}], "}"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"op", "===", "Equal"}], ",", 
          RowBox[{"exp", "=", 
           RowBox[{"expr", "==", "0"}]}], ",", 
          RowBox[{"exp", "=", 
           RowBox[{"expr", "\[GreaterEqual]", "0"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"kCondition", "=", 
         RowBox[{
          RowBox[{"Resolve", "[", 
           RowBox[{
            RowBox[{"ForAll", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", "y"}], "}"}], ",", 
              RowBox[{
               RowBox[{"fundamentalFunction", "<=", "0"}], "&&", 
               RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
               RowBox[{"y", "\[GreaterEqual]", "0"}], "&&", 
               "specialXYcondition"}], ",", "exp"}], "]"}], ",", "Reals"}], 
           "]"}], "//", "Simplify"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "need", " ", "to", " ", "change", " ", "region", " ", "when", " ", 
          "inequality", " ", "is", " ", "strict"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"BooleanQ", "[", "kCondition", "]"}], ",", 
          RowBox[{"Return", "[", 
           RowBox[{"{", 
            RowBox[{"kCondition", ",", "0", ",", "Infinity"}], "}"}], "]"}]}],
          "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"minK", "=", 
         RowBox[{"MinValue", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"k", ",", "kCondition"}], "}"}], ",", "k"}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"maxK", "=", 
         RowBox[{"MaxValue", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"k", ",", "kCondition"}], "}"}], ",", "k"}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{"kCondition", ",", "minK", ",", "maxK"}], "}"}], "]"}], 
        ";"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"findBestKusingT", "[", 
      RowBox[{"xyExpr_", ",", 
       RowBox[{"specialTcondition_:", "True"}]}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "kCondition", ",", "minK", ",", "maxK", ",", "exp", ",", "tExpr"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"tExpr", "=", 
         RowBox[{
          RowBox[{"xyExpr", "/.", "tTransform"}], "//", "Simplify"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"tExpr", "=", 
         RowBox[{"removePositiveFactors", "[", 
          RowBox[{"tExpr", ",", 
           RowBox[{"t", ">", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"op", "===", "Equal"}], ",", 
          RowBox[{"exp", "=", 
           RowBox[{"tExpr", "==", "0"}]}], ",", 
          RowBox[{"exp", "=", 
           RowBox[{"tExpr", "\[GreaterEqual]", "0"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"kCondition", "=", 
         RowBox[{
          RowBox[{"Resolve", "[", 
           RowBox[{
            RowBox[{"ForAll", "[", 
             RowBox[{"t", ",", 
              RowBox[{
               RowBox[{"t", ">", "1"}], "&&", "specialTcondition"}], ",", 
              "exp"}], "]"}], ",", "Reals"}], "]"}], "//", "Simplify"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"BooleanQ", "[", "kCondition", "]"}], ",", 
          RowBox[{"Return", "[", 
           RowBox[{"{", 
            RowBox[{"kCondition", ",", "0", ",", "Infinity"}], "}"}], "]"}]}],
          "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"minK", "=", 
         RowBox[{"MinValue", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"k", ",", "kCondition"}], "}"}], ",", "k"}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"maxK", "=", 
         RowBox[{"MaxValue", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"k", ",", "kCondition"}], "}"}], ",", "k"}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{"kCondition", ",", "minK", ",", "maxK"}], "}"}], "]"}], 
        ";"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Convenience", " ", "routine", " ", "for", " ", "displaying", " ", 
      "real", " ", "numbers"}], ",", " ", 
     RowBox[{"such", " ", "as", " ", "best", " ", "k", " ", "values"}], ",", 
     " ", 
     RowBox[{
     "as", " ", "a", " ", "string", "\[IndentingNewLine]", "that", " ", 
      "explains", " ", "that", " ", "the", " ", "real", " ", "number", " ", 
      "is", " ", "a", " ", "zero", " ", "of", " ", "its", " ", "minimal", " ", 
      RowBox[{"polynomial", ".", "\[IndentingNewLine]", "Typically"}], " ", 
      "used", " ", "when", " ", "displaying", " ", "mink", " ", "or", " ", 
      RowBox[{"maxk", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"displayRealNumber", "[", "real_", "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"realVal", ",", "func", ",", "rootList"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"realVal", "=", 
         RowBox[{"TimeConstrained", "[", 
          RowBox[{
           RowBox[{"FullSimplify", "[", "real", "]"}], ",", "3"}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"realVal", "===", "$Aborted"}], ",", 
          RowBox[{
           RowBox[{
           "Print", "[", 
            "\"\<Skipping simplification because of time constraint.\>\"", 
            "]"}], ";", 
           RowBox[{"realVal", "=", "real"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Head", "[", "realVal", "]"}], "===", "Root"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"func", "=", 
            RowBox[{
             RowBox[{"First", "[", "realVal", "]"}], "[", "x", "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"rootList", "=", 
            RowBox[{
             RowBox[{"Last", "/@", 
              RowBox[{"First", "/@", 
               RowBox[{"NSolve", "[", 
                RowBox[{
                 RowBox[{"func", "\[Equal]", "0"}], ",", "PositiveReals"}], 
                "]"}]}]}], "//", "Quiet"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Length", "[", "rootList", "]"}], "\[Equal]", "1"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"Return", "[", 
              RowBox[{"\"\<k\[TildeTilde]\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"N", "[", 
                 RowBox[{"realVal", ",", "10"}], "]"}], "]"}], "<>", 
               "\"\< is the positive root of \>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"func", ",", "StandardForm"}], "]"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"realVal", "\[Equal]", 
                 RowBox[{"Min", "[", "rootList", "]"}]}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Return", "[", 
                 RowBox[{"\"\<k\[TildeTilde]\>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"N", "[", 
                    RowBox[{"realVal", ",", "10"}], "]"}], "]"}], "<>", 
                  "\"\< is the smallest positive root of \>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"func", ",", "StandardForm"}], "]"}]}], "]"}], ",",
                 "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"realVal", "\[Equal]", 
                    RowBox[{"Max", "[", "rootList", "]"}]}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"Return", "[", 
                    RowBox[{"\"\<k\[TildeTilde]\>\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"N", "[", 
                    RowBox[{"realVal", ",", "10"}], "]"}], "]"}], "<>", 
                    "\"\< is the largest positive root of \>\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"func", ",", "StandardForm"}], "]"}]}], "]"}], 
                   ",", "\[IndentingNewLine]", 
                   RowBox[{"Return", "[", 
                    RowBox[{"\"\<k\[TildeTilde]\>\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"N", "[", 
                    RowBox[{"realVal", ",", "10"}], "]"}], "]"}], "<>", 
                    "\"\< is a root of \>\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"func", ",", "StandardForm"}], "]"}]}], "]"}]}], 
                  "\[IndentingNewLine]", "]"}], ";"}]}], 
               "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
            "]"}]}], "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"else", " ", "not", " ", "a", " ", "root"}], " ", "*)"}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Return", "[", 
            RowBox[{"\"\<k=\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"FullSimplify", "[", "realVal", "]"}], "//", 
                "Factor"}], ",", "StandardForm"}], "]"}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", "      ", 
    RowBox[{"ALGORITHM", " ", "XYZ"}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"proveTrivariateInequality", "[", "inequality_", "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", "abcInequality", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"convertToABC", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x", "\[Rule]", 
            RowBox[{"b", "+", "c", "-", "a"}]}], ",", 
           RowBox[{"y", "\[Rule]", 
            RowBox[{"c", "+", "a", "-", "b"}]}], ",", 
           RowBox[{"z", "\[Rule]", 
            RowBox[{"a", "+", "b", "-", "c"}]}]}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"abcInequality", "=", 
         RowBox[{"inequality", "/.", "convertToABC"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
        "proveTriangleInequalityUsingBlundon", "[", "abcInequality", 
         "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", "      ", 
    RowBox[{"ALGORITHM", " ", "ABC"}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"convertToABCviaRrs", "[", "expr_", "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"abc", ",", "rRs"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"rRs", "=", 
         RowBox[{"convertToRrs", "[", "expr", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"abc", "=", 
         RowBox[{"rRs", "//.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"r", "\[Rule]", 
             RowBox[{"K", "/", "s"}]}], ",", 
            RowBox[{"R", "\[Rule]", 
             RowBox[{"a", "*", "b", "*", 
              RowBox[{"c", "/", 
               RowBox[{"(", 
                RowBox[{"4", "K"}], ")"}]}]}]}], ",", 
            RowBox[{"K", "\[Rule]", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"s", 
               RowBox[{"(", 
                RowBox[{"s", "-", "a"}], ")"}], 
               RowBox[{"(", 
                RowBox[{"s", "-", "b"}], ")"}], 
               RowBox[{"(", 
                RowBox[{"s", "-", "c"}], ")"}]}], "]"}]}], ",", 
            RowBox[{"s", "\[Rule]", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a", "+", "b", "+", "c"}], ")"}], "/", "2"}]}]}], 
           "}"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"abc", "=", 
         RowBox[{"Together", "[", "abc", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "abc", "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"convertToABC", "[", "expr_", "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"abc", ",", "notrig"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"notrig", "=", 
         RowBox[{"removeTrigonometricFunctions", "[", "expr", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"abc", "=", 
         RowBox[{"notrig", "//.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"r", "\[Rule]", 
             RowBox[{"K", "/", "s"}]}], ",", 
            RowBox[{"R", "\[Rule]", 
             RowBox[{"a", "*", "b", "*", 
              RowBox[{"c", "/", 
               RowBox[{"(", 
                RowBox[{"4", "K"}], ")"}]}]}]}], ",", 
            RowBox[{"K", "\[Rule]", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"s", 
               RowBox[{"(", 
                RowBox[{"s", "-", "a"}], ")"}], 
               RowBox[{"(", 
                RowBox[{"s", "-", "b"}], ")"}], 
               RowBox[{"(", 
                RowBox[{"s", "-", "c"}], ")"}]}], "]"}]}], ",", 
            RowBox[{"s", "\[Rule]", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a", "+", "b", "+", "c"}], ")"}], "/", "2"}]}]}], 
           "}"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"abc", "=", 
         RowBox[{"Together", "[", "abc", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "abc", "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", "      ", 
    RowBox[{"ALGORITHM", " ", "ABCK"}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"convertToABCK", "[", "expr_", "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"abc", ",", "rRs"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"rRs", "=", 
         RowBox[{"convertToRrs", "[", "expr", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"abc", "=", 
         RowBox[{"rRs", "//.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"r", "\[Rule]", 
             RowBox[{"K", "/", "s"}]}], ",", 
            RowBox[{"R", "\[Rule]", 
             RowBox[{"a", "*", "b", "*", 
              RowBox[{"c", "/", 
               RowBox[{"(", 
                RowBox[{"4", "K"}], ")"}]}]}]}], ",", 
            RowBox[{"s", "\[Rule]", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a", "+", "b", "+", "c"}], ")"}], "/", "2"}]}]}], 
           "}"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"abc", "=", 
         RowBox[{"Together", "[", "abc", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "abc", "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.822908871517373*^9, 3.8229088846933403`*^9}, {
   3.822908993772704*^9, 3.822909025964164*^9}, {3.822909056620248*^9, 
   3.82290911623693*^9}, 3.822909186053378*^9, {3.822909220524805*^9, 
   3.82290935394835*^9}, {3.822909429797757*^9, 3.822909449901354*^9}, 
   3.822909510061504*^9, {3.822909559365554*^9, 3.822909728454052*^9}, {
   3.822909769190195*^9, 3.822909917133679*^9}, {3.822910126991056*^9, 
   3.822910153012528*^9}, {3.822910205550027*^9, 3.822910213526156*^9}, {
   3.822910415254594*^9, 3.8229105086631517`*^9}, {3.822910601703784*^9, 
   3.822910615383337*^9}, {3.822910660774351*^9, 3.822910671295066*^9}, {
   3.822910722055887*^9, 3.8229107751824713`*^9}, {3.822910820912163*^9, 
   3.822910876927878*^9}, 3.8229109082325163`*^9, {3.8229115146594563`*^9, 
   3.822911542328704*^9}, {3.822913828544114*^9, 3.822913895479711*^9}, {
   3.822913975384657*^9, 3.82291401343128*^9}, {3.822914045730054*^9, 
   3.822914050432732*^9}, {3.822914086138496*^9, 3.822914090193131*^9}, {
   3.822916146887686*^9, 3.822916159654559*^9}, {3.822924937961116*^9, 
   3.822924939344111*^9}, {3.82292500267371*^9, 3.822925005600039*^9}, {
   3.8229261790373793`*^9, 3.822926233491604*^9}, {3.822926324653338*^9, 
   3.822926365179591*^9}, {3.82337446368808*^9, 3.823374476007173*^9}, {
   3.8236193420693827`*^9, 3.823619345780365*^9}, {3.823619378629221*^9, 
   3.823619414943871*^9}, {3.823619459597434*^9, 3.823619472188478*^9}, {
   3.82361950635718*^9, 3.823619524421496*^9}, {3.823619577005493*^9, 
   3.8236199523998003`*^9}, {3.823620156736362*^9, 3.823620159214953*^9}, {
   3.823620190112598*^9, 3.823620213647558*^9}, {3.8236203307697897`*^9, 
   3.8236203363446302`*^9}, {3.82362041107592*^9, 3.823620416924191*^9}, {
   3.823620450763652*^9, 3.823620457873304*^9}, {3.823620504998816*^9, 
   3.82362050904387*^9}, {3.823620541730588*^9, 3.823620596522399*^9}, {
   3.823620633259019*^9, 3.823620695729815*^9}, {3.823621176949081*^9, 
   3.823621198787867*^9}, {3.8236212481652203`*^9, 3.8236212495957613`*^9}, {
   3.8236213167657022`*^9, 3.823621339252634*^9}, {3.823621380277945*^9, 
   3.823621380612316*^9}, {3.823621638910816*^9, 3.8236216427332687`*^9}, {
   3.8236217274788723`*^9, 3.8236217363335752`*^9}, {3.823621853358876*^9, 
   3.8236219113986683`*^9}, {3.823621957119934*^9, 3.823621958694228*^9}, {
   3.823622359608397*^9, 3.8236223916715193`*^9}, {3.823624054997119*^9, 
   3.8236240594045563`*^9}, {3.823624173725913*^9, 3.8236241743014727`*^9}, 
   3.823696790374243*^9, {3.8236968262927637`*^9, 3.823696839691636*^9}, {
   3.823696921324325*^9, 3.823696928220275*^9}, 3.8236970725337543`*^9, {
   3.823697491239805*^9, 3.823697496495001*^9}, {3.823701751566345*^9, 
   3.823701882149891*^9}, {3.823701943991397*^9, 3.8237019724860067`*^9}, {
   3.82370270248803*^9, 3.823702714488469*^9}, {3.823702744753292*^9, 
   3.82370274517654*^9}, {3.823704505890622*^9, 3.823704510377575*^9}, {
   3.8237081603943853`*^9, 3.823708175306937*^9}, 3.823709908785244*^9, {
   3.823718524649069*^9, 3.823718537927596*^9}, {3.823719179308312*^9, 
   3.8237192094657297`*^9}, {3.823722337433564*^9, 3.82372242208209*^9}, {
   3.823774862702227*^9, 3.823774887148958*^9}, {3.823775452048861*^9, 
   3.823775610664427*^9}, {3.8237756566868973`*^9, 3.823775677766955*^9}, 
   3.823776351209985*^9, 3.823790234213605*^9, {3.823793318661992*^9, 
   3.823793332493455*^9}, {3.82379337070151*^9, 3.823793388557926*^9}, 
   3.823800140166448*^9, {3.823856885299554*^9, 3.8238568898773036`*^9}, {
   3.8238569251435213`*^9, 3.8238570109857397`*^9}, {3.823865623901927*^9, 
   3.8238656287849884`*^9}, {3.8238735783900642`*^9, 3.823873600621265*^9}, {
   3.8238898628764677`*^9, 3.823889891339191*^9}, {3.823893435782099*^9, 
   3.823893502278061*^9}, {3.823893709135557*^9, 3.8238937229186277`*^9}, {
   3.8239502129451923`*^9, 3.8239502595037727`*^9}, {3.823969763116432*^9, 
   3.8239697839799147`*^9}, {3.824031255042159*^9, 3.8240312681406403`*^9}, {
   3.824031683651812*^9, 3.824031700873748*^9}, {3.8240317400655613`*^9, 
   3.824031816635357*^9}, {3.8240319936758347`*^9, 3.8240320505151052`*^9}, {
   3.824033103750351*^9, 3.824033130734036*^9}, {3.8240331772336407`*^9, 
   3.824033207782094*^9}, {3.8241317991081877`*^9, 3.8241318973158712`*^9}, {
   3.8241319373727417`*^9, 3.824131959027308*^9}, 3.824147096164373*^9, {
   3.8241475362145243`*^9, 3.82414760190049*^9}, {3.8241476973331738`*^9, 
   3.824147705972501*^9}, {3.824147805845065*^9, 3.824147815564746*^9}, {
   3.824147876806415*^9, 3.824147896981539*^9}, {3.824147956904272*^9, 
   3.8241479827733583`*^9}, {3.8242027748200483`*^9, 3.824202791956951*^9}, 
   3.824202826127434*^9, {3.824203058506036*^9, 3.824203063426155*^9}, {
   3.82420312732649*^9, 3.824203128325157*^9}, {3.824203234025835*^9, 
   3.824203238138401*^9}, {3.8242033228708267`*^9, 3.824203330886252*^9}, {
   3.8242034210710173`*^9, 3.824203435822794*^9}, {3.824203495016692*^9, 
   3.824203552279232*^9}, {3.824203589880299*^9, 3.824203634496048*^9}, {
   3.8242036931759157`*^9, 3.824203737816053*^9}, {3.824203769193336*^9, 
   3.824203772137323*^9}, {3.824204010537056*^9, 3.824204052697124*^9}, {
   3.8242044039024143`*^9, 3.824204658596539*^9}, {3.8242048056066227`*^9, 
   3.824204822580906*^9}, {3.824204897477118*^9, 3.8242049936135674`*^9}, {
   3.82420538800371*^9, 3.824205438840374*^9}, {3.824205748369466*^9, 
   3.824205777528336*^9}, {3.824304089996434*^9, 3.824304104492502*^9}, 
   3.8243043527488537`*^9, {3.8243045584952803`*^9, 3.824304594581566*^9}, {
   3.824304637925798*^9, 3.824304692799458*^9}, {3.824304851809901*^9, 
   3.824304865167238*^9}, {3.824304958182616*^9, 3.8243050663429623`*^9}, {
   3.8243051818006687`*^9, 3.824305275791452*^9}, {3.8243053698494368`*^9, 
   3.824305370952304*^9}, {3.8243055188598127`*^9, 3.824305535464679*^9}, {
   3.8243056015546722`*^9, 3.824305848753923*^9}, {3.824305902842174*^9, 
   3.824305928219007*^9}, {3.82430599542658*^9, 3.824306004795023*^9}, {
   3.8243063885675383`*^9, 3.8243063980678062`*^9}, {3.824306694117592*^9, 
   3.82430677087669*^9}, {3.824306943174672*^9, 3.8243069439809217`*^9}, {
   3.824307038296632*^9, 3.824307039285469*^9}, {3.824307082767035*^9, 
   3.824307084029756*^9}, {3.82430715403063*^9, 3.824307263326521*^9}, {
   3.8243073245208197`*^9, 3.824307339623199*^9}, {3.8243162909550543`*^9, 
   3.8243162998726177`*^9}, {3.824316341416233*^9, 3.824316359223804*^9}, {
   3.8243165154656143`*^9, 3.824316523896017*^9}, {3.824316563299282*^9, 
   3.824316588075015*^9}, {3.824316637971209*^9, 3.824316667385283*^9}, {
   3.824317053611972*^9, 3.824317071356697*^9}, {3.824317479731399*^9, 
   3.8243174946663446`*^9}, {3.8243175293412*^9, 3.824317559183434*^9}, 
   3.824317751084696*^9, 3.824317782558161*^9, {3.824317842084097*^9, 
   3.824317848027111*^9}, {3.8243180824881372`*^9, 3.824318097621941*^9}, {
   3.8243181603833923`*^9, 3.824318200900125*^9}, {3.824318666638871*^9, 
   3.8243186716775713`*^9}, {3.824319407337921*^9, 3.824319441433609*^9}, {
   3.824321321646599*^9, 3.824321365491712*^9}, {3.8243215912457647`*^9, 
   3.824321599924211*^9}, 3.8243217823361597`*^9, {3.824321972301404*^9, 
   3.82432213982845*^9}, {3.824322201877049*^9, 3.8243222447805243`*^9}, {
   3.8243222870683002`*^9, 3.824322477336347*^9}, {3.824322621333489*^9, 
   3.8243226333801193`*^9}, {3.824322815382309*^9, 3.824322819436599*^9}, {
   3.8243228564231863`*^9, 3.8243228836544323`*^9}, {3.8243229970940313`*^9, 
   3.824323010838478*^9}, {3.824323233982336*^9, 3.824323241492653*^9}, {
   3.8243234899222527`*^9, 3.824323503365035*^9}, {3.8243235547978153`*^9, 
   3.8243235554934053`*^9}, {3.8243237242074327`*^9, 3.824323730421761*^9}, 
   3.824323761168837*^9, 3.824323952905325*^9, {3.82432405752836*^9, 
   3.824324086967753*^9}, {3.824324252672003*^9, 3.824324375250628*^9}, {
   3.824324737612454*^9, 3.8243247549254313`*^9}, {3.824378622141406*^9, 
   3.824378623773576*^9}, {3.8243792176705227`*^9, 3.824379247853079*^9}, {
   3.824380506585346*^9, 3.824380522719743*^9}, {3.824380594424905*^9, 
   3.824380632769609*^9}, {3.824380674578382*^9, 3.824380676785921*^9}, {
   3.824380744057234*^9, 3.8243809361469727`*^9}, {3.8243809740129223`*^9, 
   3.8243810028048964`*^9}, {3.824381093357889*^9, 3.824381147018771*^9}, {
   3.824381303749411*^9, 3.8243813202521067`*^9}, {3.82438137216076*^9, 
   3.8243813982566967`*^9}, {3.824381494559657*^9, 3.824381532932824*^9}, {
   3.824381713245915*^9, 3.824381755549697*^9}, {3.824381801374597*^9, 
   3.824381804222047*^9}, {3.824381870048253*^9, 3.824381874150517*^9}, {
   3.8243821183678493`*^9, 3.824382146647502*^9}, {3.824382250112228*^9, 
   3.824382305745874*^9}, {3.824382339177752*^9, 3.824382361816609*^9}, {
   3.824382420410205*^9, 3.824382424881279*^9}, {3.824382545505968*^9, 
   3.8243826033726463`*^9}, {3.824382648378278*^9, 3.8243826643055058`*^9}, {
   3.8243827234508266`*^9, 3.824382739089408*^9}, {3.824383038845396*^9, 
   3.824383070613852*^9}, 3.82438320164922*^9, 3.824400537390781*^9, {
   3.824403779294389*^9, 3.8244037837972603`*^9}, {3.824403849014937*^9, 
   3.824403917462731*^9}, {3.824403999634643*^9, 3.8244040156779413`*^9}, {
   3.824404052954364*^9, 3.8244040557687883`*^9}, 3.824404103050233*^9, {
   3.824460970852582*^9, 3.824461098467567*^9}, {3.8244613971296186`*^9, 
   3.824461440249875*^9}, {3.824461477521265*^9, 3.824461497466525*^9}, {
   3.8244616045692244`*^9, 3.824461628009087*^9}, {3.8244617848667088`*^9, 
   3.8244618152268133`*^9}, 3.8244625788641663`*^9, {3.8244626230613003`*^9, 
   3.82446263449269*^9}, {3.8244628255922747`*^9, 3.824462922469895*^9}, 
   3.824462960127304*^9, {3.824463035151226*^9, 3.824463038309729*^9}, {
   3.824463108519464*^9, 3.8244631118699093`*^9}, {3.8244631426907988`*^9, 
   3.824463144455471*^9}, {3.824463199351809*^9, 3.824463319918708*^9}, {
   3.8244640675955048`*^9, 3.82446416991201*^9}, {3.82446431845292*^9, 
   3.824464320035488*^9}, 3.824464496783165*^9, {3.824464548823409*^9, 
   3.824464554718096*^9}, {3.824465888411708*^9, 3.82446588916905*^9}, 
   3.824466286150136*^9, {3.8244664161652393`*^9, 3.824466417819915*^9}, 
   3.8244713130319643`*^9, 3.824471347691832*^9, {3.8244720609439917`*^9, 
   3.82447207415259*^9}, {3.8244725298466053`*^9, 3.824472545254757*^9}, {
   3.824472706568149*^9, 3.824472707879013*^9}, {3.824472768097693*^9, 
   3.824472778447116*^9}, {3.824473073265183*^9, 3.824473167810129*^9}, {
   3.824473541244115*^9, 3.82447356335467*^9}, {3.8244786700927067`*^9, 
   3.8244786777949047`*^9}, {3.824478754669229*^9, 3.824478761404977*^9}, {
   3.8244788120550632`*^9, 3.824478817645639*^9}, {3.824478849457411*^9, 
   3.8244788515467463`*^9}, {3.82447890648458*^9, 3.824478927585105*^9}, {
   3.824478962337624*^9, 3.824479000969161*^9}, {3.82447904127402*^9, 
   3.824479075836295*^9}, {3.824479108143141*^9, 3.82447916219993*^9}, {
   3.824479205746525*^9, 3.824479294696515*^9}, {3.8244794514912863`*^9, 
   3.824479517637339*^9}, {3.824479691070177*^9, 3.82447971692492*^9}, {
   3.824480030418826*^9, 3.824480039825623*^9}, {3.8244802311548967`*^9, 
   3.824480243625589*^9}, {3.8244802876098557`*^9, 3.82448029383351*^9}, {
   3.824480325306052*^9, 3.824480341793705*^9}, {3.824480416436371*^9, 
   3.824480429314217*^9}, {3.824480488406756*^9, 3.824480525325712*^9}, 
   3.824495992528854*^9, {3.82449618344587*^9, 3.824496326061397*^9}, {
   3.824633167121106*^9, 3.824633384081979*^9}, {3.824633506725947*^9, 
   3.8246335642850227`*^9}, 3.824633676608029*^9, {3.824633706669322*^9, 
   3.824633765808579*^9}, {3.8246338209700117`*^9, 3.8246338420259457`*^9}, {
   3.824633884474386*^9, 3.8246341201967497`*^9}, {3.824634190669572*^9, 
   3.824634198203721*^9}, 3.824635938148926*^9, {3.824636087740123*^9, 
   3.8246360964988194`*^9}, {3.824642634956689*^9, 3.824642648990889*^9}, 
   3.824731469847003*^9, {3.824821752191306*^9, 3.8248218154955387`*^9}, {
   3.8248218620880623`*^9, 3.824821869767541*^9}, {3.824821955302643*^9, 
   3.824821987847189*^9}, {3.824822277869081*^9, 3.824822282063695*^9}, 
   3.82482234934516*^9, {3.824822538233693*^9, 3.8248225430892477`*^9}, {
   3.8248230168276243`*^9, 3.8248230187379723`*^9}, {3.82482369238109*^9, 
   3.824823734069811*^9}, 3.824928977030019*^9, 3.824929014534408*^9, {
   3.82496915205877*^9, 3.824969162042848*^9}, 3.8249713425562067`*^9, {
   3.8249713752759113`*^9, 3.824971379873399*^9}, {3.824971476420268*^9, 
   3.824971483353716*^9}, 3.8249759173898897`*^9, {3.824976295678516*^9, 
   3.824976349885427*^9}, {3.824976385517989*^9, 3.824976446575704*^9}, {
   3.824976956154492*^9, 3.824977015465835*^9}, {3.8249772822200537`*^9, 
   3.824977331539256*^9}, 3.8249776159335203`*^9, {3.824977684757576*^9, 
   3.824977698156582*^9}, {3.824978513754431*^9, 3.824978525319128*^9}, {
   3.824979108555475*^9, 3.8249791189134912`*^9}, {3.824979151849029*^9, 
   3.824979241992868*^9}, {3.825070796869494*^9, 3.825070830413393*^9}, {
   3.8250811770591383`*^9, 3.82508120434056*^9}, {3.825081347817258*^9, 
   3.825081381298354*^9}, {3.825082706520434*^9, 3.8250827431030817`*^9}, {
   3.825089584709899*^9, 3.825089591220538*^9}, {3.825242279241478*^9, 
   3.825242311288034*^9}, {3.8252443086024733`*^9, 3.8252443374410753`*^9}, {
   3.825244371493813*^9, 3.82524439324681*^9}, {3.8252444515994167`*^9, 
   3.825244809184203*^9}, {3.8252453457957697`*^9, 3.825245370579118*^9}, {
   3.825267520972926*^9, 3.8252675482343397`*^9}, {3.825267578768886*^9, 
   3.8252676897588387`*^9}, {3.825267844400839*^9, 3.825267858151093*^9}, {
   3.825267890622819*^9, 3.825268016112062*^9}, {3.8252680802490473`*^9, 
   3.825268202593583*^9}, {3.825268433562145*^9, 3.8252684820645037`*^9}, {
   3.8252685275449343`*^9, 3.825268561678172*^9}, {3.825268610145067*^9, 
   3.82526861219314*^9}, {3.8252686542489567`*^9, 3.825268691897525*^9}, {
   3.825268961971208*^9, 3.825269071226486*^9}, {3.825269187573242*^9, 
   3.825269217243194*^9}, 3.825269257100588*^9, {3.825269287679949*^9, 
   3.8252693135152607`*^9}, {3.8252693512128277`*^9, 3.825269450399952*^9}, {
   3.825269501004368*^9, 3.8252695785576*^9}, {3.8252699995198317`*^9, 
   3.82527001280512*^9}, 3.8252700884155817`*^9, {3.825270118640101*^9, 
   3.8252701209884043`*^9}, {3.82527027047845*^9, 3.825270337309226*^9}, {
   3.825270668483964*^9, 3.825270742300716*^9}, {3.825270783267104*^9, 
   3.8252708347632427`*^9}, {3.825270955231681*^9, 3.825270960805567*^9}, {
   3.8252712278235826`*^9, 3.825271241775811*^9}, {3.825271336375576*^9, 
   3.825271367817857*^9}, {3.825271404934971*^9, 3.8252714564694*^9}, {
   3.8252715518726254`*^9, 3.825271557742951*^9}, {3.825271787539927*^9, 
   3.825271793522805*^9}, 3.825271903772286*^9, {3.825272223283504*^9, 
   3.825272225138769*^9}, {3.825519375959817*^9, 3.825519394300568*^9}, {
   3.825519448827897*^9, 3.825519513832808*^9}, {3.825519569113226*^9, 
   3.8255196146813593`*^9}, {3.8255197196327553`*^9, 3.825519722031741*^9}, {
   3.825519760931128*^9, 3.82551976609766*^9}, {3.825521865113546*^9, 
   3.825521873968863*^9}, {3.8255219078968267`*^9, 3.825521932240704*^9}, {
   3.825522019762638*^9, 3.8255220271130657`*^9}, {3.825522227602995*^9, 
   3.82552226037008*^9}, {3.825579004180437*^9, 3.825579052322719*^9}, {
   3.82557912086726*^9, 3.825579199604961*^9}, {3.825579233233536*^9, 
   3.825579253868734*^9}, {3.825579318220532*^9, 3.82557937571839*^9}, 
   3.8255885525739927`*^9, {3.82559142769379*^9, 3.825591599442643*^9}, 
   3.825591630920025*^9, {3.825591668871419*^9, 3.8255917675028877`*^9}, {
   3.825591846552423*^9, 3.8255918700175037`*^9}, {3.825591910922738*^9, 
   3.825591914433226*^9}, {3.8255928384296494`*^9, 3.825592842683766*^9}, {
   3.825592872757448*^9, 3.825592895316*^9}, {3.825592958668004*^9, 
   3.825592983324054*^9}, {3.825593070045765*^9, 3.825593073212302*^9}, {
   3.825594940085676*^9, 3.8255949444100943`*^9}, {3.825615667523259*^9, 
   3.825615672408486*^9}, {3.825615705213729*^9, 3.825615737762459*^9}, {
   3.825615789141519*^9, 3.82561579943633*^9}, {3.825615890775329*^9, 
   3.8256159337458277`*^9}, {3.825615968272119*^9, 3.82561600666903*^9}, 
   3.8256160786227503`*^9, {3.825616530880005*^9, 3.825616616377798*^9}, 
   3.825616655240473*^9, {3.825616747136677*^9, 3.825616747647106*^9}, {
   3.825616779130192*^9, 3.825616781135345*^9}, {3.825616837488761*^9, 
   3.825616856986721*^9}, {3.8256169537689257`*^9, 3.825616964186842*^9}, {
   3.825617160482009*^9, 3.825617171632175*^9}, {3.8256174475161257`*^9, 
   3.8256174630647593`*^9}, {3.825617553826668*^9, 3.825617564308413*^9}, {
   3.825666798528277*^9, 3.825666817931601*^9}, {3.825666861696927*^9, 
   3.8256668712960176`*^9}, {3.825672104183578*^9, 3.825672153865587*^9}, {
   3.825678828336813*^9, 3.825678832223687*^9}, {3.825678875562698*^9, 
   3.825678930783793*^9}, {3.825678980918682*^9, 3.825679013685154*^9}, {
   3.82567905077509*^9, 3.825679083284877*^9}, {3.8256791142470217`*^9, 
   3.825679127933955*^9}, {3.8256792316805058`*^9, 3.825679243149808*^9}, {
   3.825679286070107*^9, 3.825679372111643*^9}, {3.825679421590081*^9, 
   3.8256795451296577`*^9}, {3.8256796030236588`*^9, 3.825679647670493*^9}, {
   3.825679717431595*^9, 3.825679754182765*^9}, {3.825679797552615*^9, 
   3.825679804087286*^9}, {3.825679944362494*^9, 3.825680002590747*^9}, 
   3.8256800905337667`*^9, {3.825680123717263*^9, 3.825680130570808*^9}, {
   3.825680195507072*^9, 3.825680391409994*^9}, {3.825680680828114*^9, 
   3.825680719546187*^9}, {3.8256825306162643`*^9, 3.825682533366708*^9}, 
   3.825682610769237*^9, {3.825682680898343*^9, 3.825682714848937*^9}, {
   3.825698984424266*^9, 3.825698987327927*^9}, {3.825699243936063*^9, 
   3.825699265230576*^9}, {3.825699342002578*^9, 3.825699353921294*^9}, {
   3.825700173086657*^9, 3.825700219530089*^9}, {3.8257008358519793`*^9, 
   3.8257008408267384`*^9}, {3.82587550484489*^9, 3.8258757258031607`*^9}, {
   3.825875924668507*^9, 3.825875960229476*^9}, {3.825876374765317*^9, 
   3.825876380756288*^9}, {3.825876421188181*^9, 3.825876422556292*^9}, {
   3.825876521124754*^9, 3.825876555726095*^9}, {3.825876692752385*^9, 
   3.825876769509595*^9}, {3.825876818391776*^9, 3.825876884301906*^9}, {
   3.825877266416438*^9, 3.8258772811111517`*^9}, {3.825877453707172*^9, 
   3.825877463778351*^9}, {3.825877657827512*^9, 3.825877694464437*^9}, {
   3.8258777664735413`*^9, 3.8258777728657427`*^9}, {3.825927569408984*^9, 
   3.8259275783108664`*^9}, {3.8259276775198298`*^9, 3.825927681351659*^9}, {
   3.8259277516664743`*^9, 3.825927857073319*^9}, {3.825927890219245*^9, 
   3.825928106390696*^9}, {3.82592815960386*^9, 3.825928160252555*^9}, {
   3.825928269665975*^9, 3.825928358243764*^9}, {3.825928402358406*^9, 
   3.8259285020444403`*^9}, 3.825928532404202*^9, {3.8259294781602707`*^9, 
   3.825929493599255*^9}, {3.8259297121492777`*^9, 3.8259297586879463`*^9}, {
   3.825932762222518*^9, 3.8259328243140583`*^9}, {3.8259332373921833`*^9, 
   3.8259332414570932`*^9}, {3.825946461334633*^9, 3.825946531421483*^9}, {
   3.825946567945394*^9, 3.8259469890068607`*^9}, {3.825947035009268*^9, 
   3.825947085857738*^9}, {3.825947158268218*^9, 3.825947199857386*^9}, {
   3.825947249280911*^9, 3.82594732915405*^9}, {3.8259478162923594`*^9, 
   3.825947839107676*^9}, {3.8259492459903803`*^9, 3.8259492506870623`*^9}, 
   3.825949386856241*^9, {3.8259494469893637`*^9, 3.825949562200398*^9}, {
   3.8261152771876163`*^9, 3.826115347474124*^9}, {3.8261159412820663`*^9, 
   3.8261159611004343`*^9}, {3.826117411509171*^9, 3.82611756295992*^9}, {
   3.826117608920223*^9, 3.826117614597743*^9}, {3.826117695998695*^9, 
   3.826117766336384*^9}, 3.826117954766088*^9, {3.826118136201058*^9, 
   3.8261181682239017`*^9}, {3.826119047866571*^9, 3.826119120971141*^9}, {
   3.826119186047021*^9, 3.8261192272583933`*^9}, {3.826119269770927*^9, 
   3.826119275578347*^9}, {3.826119803605381*^9, 3.826119821222438*^9}, {
   3.826119883980377*^9, 3.826119943835988*^9}, {3.82612001850856*^9, 
   3.826120027716139*^9}, {3.826121569705723*^9, 3.826121626744502*^9}, {
   3.826121694760775*^9, 3.826121713522704*^9}, {3.8261217515930147`*^9, 
   3.826121782121975*^9}, {3.826121813051104*^9, 3.8261218181606092`*^9}, {
   3.826122174949215*^9, 3.8261221790275593`*^9}, 3.826201040912023*^9, {
   3.82620111734768*^9, 3.826201143693709*^9}, {3.826201253989555*^9, 
   3.826201278156094*^9}, {3.82620130910807*^9, 3.8262014773971033`*^9}, {
   3.8262015657889767`*^9, 3.8262018096539373`*^9}, {3.826202008782728*^9, 
   3.826202063593285*^9}, {3.82627253962114*^9, 3.826272640892786*^9}, {
   3.826272749609405*^9, 3.82627277833517*^9}, 3.826273059787875*^9, {
   3.8262775129008837`*^9, 3.826277522556306*^9}, {3.826277592089662*^9, 
   3.826277629009426*^9}, {3.8262777019224253`*^9, 3.82627770421006*^9}, {
   3.826277758109519*^9, 3.826277759618866*^9}, {3.826277830892795*^9, 
   3.826277898122321*^9}, {3.826278082365494*^9, 3.8262781383473377`*^9}, {
   3.8262782305557423`*^9, 3.8262782792912617`*^9}, {3.826278355269846*^9, 
   3.826278362451577*^9}, {3.826278594349895*^9, 3.826278599462421*^9}, {
   3.826290588295508*^9, 3.826290670178636*^9}, {3.8262907094338408`*^9, 
   3.8262907525599213`*^9}, {3.8262910032149467`*^9, 3.826291086130972*^9}, 
   3.826296397989573*^9, 3.826296447515497*^9, {3.826296872891363*^9, 
   3.826296922763389*^9}, {3.826296955662045*^9, 3.826296981013825*^9}, {
   3.826297033407131*^9, 3.8262970409898987`*^9}, {3.8262970752354593`*^9, 
   3.826297088653596*^9}, {3.826297190829809*^9, 3.826297218725595*^9}, 
   3.82629727195026*^9, {3.826297309639141*^9, 3.826297397495181*^9}, {
   3.826297444606594*^9, 3.826297545654669*^9}, {3.826298272706457*^9, 
   3.826298273624927*^9}, {3.826298338034555*^9, 3.8262983973386183`*^9}, {
   3.8263660488473053`*^9, 3.826366116522216*^9}, {3.826366946407155*^9, 
   3.826366971992915*^9}, {3.826367055134132*^9, 3.8263672416526623`*^9}, 
   3.826367303266202*^9, {3.826367865250697*^9, 3.8263678787282763`*^9}, {
   3.826367961388111*^9, 3.826367995691037*^9}, {3.826368783421591*^9, 
   3.8263688037883463`*^9}, {3.8263688595817833`*^9, 3.826368875804335*^9}, {
   3.8263689343908663`*^9, 3.826368954356682*^9}, {3.826368995422662*^9, 
   3.826369020223673*^9}, {3.826369060688546*^9, 3.826369122103307*^9}, {
   3.826461066657946*^9, 3.826461103071924*^9}, {3.826461328960454*^9, 
   3.826461356894607*^9}, {3.826461582616959*^9, 3.826461651407853*^9}, {
   3.826461778691177*^9, 3.826461911547611*^9}, {3.826461953835187*^9, 
   3.826462008563216*^9}, {3.82646209296264*^9, 3.8264620990334272`*^9}, {
   3.826462143727544*^9, 3.8264621516999197`*^9}, {3.8264621958764973`*^9, 
   3.826462240620158*^9}, 3.826466038498995*^9, {3.82648089908204*^9, 
   3.8264809087461433`*^9}, 3.826481689800851*^9, {3.826481721542959*^9, 
   3.82648172590339*^9}, {3.8264823498975477`*^9, 3.8264823516563787`*^9}, 
   3.8264824340780983`*^9, {3.8266415851578417`*^9, 3.8266416500735817`*^9}, {
   3.826641704412566*^9, 3.826641721057686*^9}, {3.8266417594422398`*^9, 
   3.826641811244289*^9}, {3.826705115139262*^9, 3.8267051281582727`*^9}, {
   3.826705191837517*^9, 3.826705194083049*^9}, {3.826705228958014*^9, 
   3.826705317821684*^9}, {3.8267058762964697`*^9, 3.826705894175014*^9}, 
   3.826706860965046*^9, {3.826706951986125*^9, 3.8267073228024063`*^9}, {
   3.826707365310255*^9, 3.826707515008379*^9}, {3.82670756016903*^9, 
   3.826707609152732*^9}, {3.826707640947688*^9, 3.8267076478647957`*^9}, {
   3.8267077383534927`*^9, 3.826707855219728*^9}, {3.826707913570138*^9, 
   3.826707934849661*^9}, {3.826707978065764*^9, 3.826708068348467*^9}, {
   3.826708171022311*^9, 3.826708180917027*^9}, {3.826708214962509*^9, 
   3.826708222138193*^9}, 3.82670825229412*^9, 3.82670829239526*^9, {
   3.8267083614881907`*^9, 3.826708364365967*^9}, {3.826708458364759*^9, 
   3.826708474059762*^9}, {3.826708518117799*^9, 3.8267085340584803`*^9}, {
   3.8267086901768312`*^9, 3.826708983214161*^9}, {3.826709243376899*^9, 
   3.826709301310442*^9}, {3.826709505408841*^9, 3.826709536480071*^9}, {
   3.826709587570673*^9, 3.826709625240313*^9}, {3.8267097673608007`*^9, 
   3.826709794208474*^9}, {3.8267101420992126`*^9, 3.826710155889474*^9}, 
   3.826710249837298*^9, {3.826710325035944*^9, 3.8267103607462606`*^9}, {
   3.826710709539795*^9, 3.826710711834141*^9}, 3.8267138466481113`*^9, {
   3.826737251777714*^9, 3.8267372560334806`*^9}, 3.8267374096683826`*^9, {
   3.826739557302308*^9, 3.8267395738461742`*^9}, {3.826740229069009*^9, 
   3.8267402717286253`*^9}, {3.826740399204884*^9, 3.8267405092558327`*^9}, {
   3.826741019915819*^9, 3.826741040713566*^9}, 3.826741230742703*^9, {
   3.826743632513667*^9, 3.8267437354431458`*^9}, {3.826743776539065*^9, 
   3.8267438344729033`*^9}, {3.826803630488277*^9, 3.826803680683465*^9}, {
   3.826803711544595*^9, 3.8268038116441727`*^9}, 3.82680385242712*^9, 
   3.826803888515874*^9, {3.826803975281374*^9, 3.8268040169154*^9}, {
   3.8268040744737167`*^9, 3.826804076649139*^9}, {3.8268041213625603`*^9, 
   3.826804162801488*^9}, {3.826804303571417*^9, 3.82680432081443*^9}, {
   3.8268043520129623`*^9, 3.826804470086454*^9}, {3.8268045102190638`*^9, 
   3.8268045563548813`*^9}, {3.826804594506996*^9, 3.82680482769566*^9}, {
   3.8268048582230597`*^9, 3.826804884284066*^9}, 3.8268062749423933`*^9, 
   3.8268064975259438`*^9, {3.826806528798023*^9, 3.826806567613599*^9}, {
   3.826806729941655*^9, 3.826806785604313*^9}, {3.826891982791854*^9, 
   3.826892062452222*^9}, {3.826895156726602*^9, 3.826895166510006*^9}, {
   3.826895225439765*^9, 3.826895228182549*^9}, {3.826902150042267*^9, 
   3.826902150585053*^9}, {3.8272389699755917`*^9, 3.827239042217108*^9}, {
   3.827239088778377*^9, 3.827239095025003*^9}, {3.827239193882757*^9, 
   3.827239205904306*^9}, {3.827239292562106*^9, 3.827239357520521*^9}, 
   3.82930646004056*^9, 3.82930694387465*^9, {3.8461735610751743`*^9, 
   3.846173581658497*^9}, {3.846173649932879*^9, 3.846173667403284*^9}, {
   3.8461737551722183`*^9, 3.846173765099165*^9}, {3.846173826086974*^9, 
   3.846173828075448*^9}, {3.846173884567183*^9, 3.846173886283039*^9}, {
   3.846173931198164*^9, 3.8461739473973703`*^9}, {3.8461743420414143`*^9, 
   3.846174408865184*^9}, {3.84617445548752*^9, 3.84617451834461*^9}, 
   3.8461745958435907`*^9, {3.846174642042406*^9, 3.846174643992025*^9}, {
   3.847642626153911*^9, 3.847642641777158*^9}, {3.8476428487951107`*^9, 
   3.8476428764195557`*^9}, {3.847642922751445*^9, 3.847642930540284*^9}, {
   3.8477233798578*^9, 3.847723390209407*^9}, 3.847723615535879*^9, {
   3.847723965251656*^9, 3.847723965649817*^9}, {3.84798272857658*^9, 
   3.847982746349678*^9}, {3.8479830366409683`*^9, 3.8479830707360888`*^9}, {
   3.847983149725238*^9, 3.847983384363638*^9}, {3.847983475097576*^9, 
   3.847983522425283*^9}, {3.847983574132594*^9, 3.847983801871902*^9}, {
   3.847983842128545*^9, 3.8479838668394413`*^9}, {3.8479839347362947`*^9, 
   3.847983938046529*^9}, {3.851577908010745*^9, 3.851577962985219*^9}, {
   3.851578230149324*^9, 3.851578239076532*^9}, {3.851626159715314*^9, 
   3.851626304757175*^9}, {3.852052258558001*^9, 3.852052296116911*^9}, {
   3.8520523315863733`*^9, 3.852052390467497*^9}, {3.85205242608601*^9, 
   3.8520524285087233`*^9}, {3.8520526077561817`*^9, 
   3.8520526390297527`*^9}, {3.852052753828932*^9, 3.852053138021021*^9}, {
   3.852053171527341*^9, 3.852053340330028*^9}, {3.852053484408023*^9, 
   3.8520535052253437`*^9}, {3.8520536257310143`*^9, 3.8520536341715384`*^9}, 
   3.852053761027746*^9, {3.852055666151411*^9, 3.8520556919460983`*^9}, 
   3.852055903036487*^9, 3.852055994933298*^9, {3.8520568743191957`*^9, 
   3.85205692792378*^9}, {3.85219462878743*^9, 3.852194656188891*^9}, {
   3.852194690682661*^9, 3.852194716475238*^9}, {3.852194810368476*^9, 
   3.85219486427536*^9}, {3.85219496935632*^9, 3.852194992735302*^9}, {
   3.852195109334257*^9, 3.852195199037142*^9}, {3.852195255988925*^9, 
   3.8521953469264793`*^9}, 3.852195415263133*^9, {3.852195548551775*^9, 
   3.8521957327120457`*^9}, 3.852197104242841*^9, {3.85219714085894*^9, 
   3.852197195474609*^9}, {3.852197962606387*^9, 3.852198041454207*^9}, {
   3.8521980768493147`*^9, 3.852198167750979*^9}, {3.85228641882089*^9, 
   3.85228645549436*^9}, {3.85228650046791*^9, 3.852286548107801*^9}, {
   3.852286653559051*^9, 3.852286667891995*^9}, {3.852286707494729*^9, 
   3.852286761605707*^9}, {3.8522878388237057`*^9, 3.852287855992366*^9}, 
   3.8522880047302933`*^9, {3.852288065724468*^9, 3.852288097819262*^9}, {
   3.852288270930278*^9, 3.8522883217544518`*^9}, {3.852288362945469*^9, 
   3.85228837971308*^9}, {3.8522899674166107`*^9, 3.852289986998887*^9}, {
   3.85229015561241*^9, 3.8522901632310333`*^9}, {3.852290232274822*^9, 
   3.8522902369619293`*^9}, {3.852290362851788*^9, 3.8522903958252287`*^9}, {
   3.8522914274919157`*^9, 3.852291512003413*^9}, 3.8522928376095552`*^9, {
   3.852292894399282*^9, 3.852292916526662*^9}, {3.852293603081663*^9, 
   3.852293657200791*^9}, 3.8522936881955547`*^9, {3.852293719609242*^9, 
   3.852293821683167*^9}, {3.852293893955842*^9, 3.852293925721512*^9}, {
   3.852294019028576*^9, 3.852294020929708*^9}, {3.85229431543847*^9, 
   3.85229435332125*^9}, {3.852295241170597*^9, 3.85229525398378*^9}, 
   3.852295357009454*^9, {3.852295611166759*^9, 3.852295612953856*^9}, 
   3.852649012805407*^9, {3.852652407511738*^9, 3.852652408923499*^9}, {
   3.852665780423126*^9, 3.852665788236844*^9}, {3.852748626636724*^9, 
   3.852748628962674*^9}, {3.852748728681603*^9, 3.852748745789909*^9}, {
   3.8529701222366858`*^9, 3.852970208747953*^9}, {3.852970258300227*^9, 
   3.8529704019333897`*^9}, {3.8529705442736273`*^9, 3.852970571520488*^9}, {
   3.852970942249485*^9, 3.852970942809897*^9}, {3.853944743637391*^9, 
   3.853944753212557*^9}, {3.853944832214266*^9, 3.8539448977218847`*^9}, {
   3.8539449906719217`*^9, 3.853944992310563*^9}, {3.853945824145665*^9, 
   3.8539458248936872`*^9}, {3.854127588815935*^9, 3.854127591318659*^9}, {
   3.854128380758985*^9, 3.8541284142799788`*^9}, {3.854128459857828*^9, 
   3.854128497355536*^9}, {3.8541285362517233`*^9, 3.8541285628035307`*^9}, {
   3.854128618058573*^9, 3.854128704645071*^9}, {3.8541287512676764`*^9, 
   3.854128779966813*^9}, {3.854128997129472*^9, 3.854128999664323*^9}, {
   3.8543436307695723`*^9, 3.8543436646357594`*^9}, {3.854889390835845*^9, 
   3.8548894247157307`*^9}, {3.855134432111719*^9, 3.855134443515788*^9}, {
   3.855134520874024*^9, 3.855134547668606*^9}, {3.8565297582132196`*^9, 
   3.856529771330744*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"a4cf76da-2fba-495c-8982-46ad8378f2c2"],

Cell[CellGroupData[{

Cell["Test", "Section",
 CellChangeTimes->{{3.8238589649529853`*^9, 3.8238589765963507`*^9}, {
  3.8238598964159775`*^9, 
  3.8238598971515875`*^9}},ExpressionUUID->"13ad0316-cffb-4bda-bf6c-\
6311726b5669"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"csum", "[", "expr_", "]"}], ":=", 
    RowBox[{"expr", "+", 
     RowBox[{"(", 
      RowBox[{"expr", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "\[Rule]", "b"}], ",", 
         RowBox[{"b", "\[Rule]", "c"}], ",", 
         RowBox[{"c", "\[Rule]", "a"}], ",", 
         RowBox[{"A", "\[Rule]", "B"}], ",", 
         RowBox[{"B", "\[Rule]", "C"}], ",", 
         RowBox[{"C", "\[Rule]", "A"}]}], "}"}]}], ")"}], "+", 
     RowBox[{"(", 
      RowBox[{"expr", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "\[Rule]", "c"}], ",", 
         RowBox[{"b", "\[Rule]", "a"}], ",", 
         RowBox[{"c", "\[Rule]", "b"}], ",", 
         RowBox[{"A", "\[Rule]", "C"}], ",", 
         RowBox[{"B", "\[Rule]", "A"}], ",", 
         RowBox[{"C", "\[Rule]", "B"}]}], "}"}]}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"cprod", "[", "expr_", "]"}], ":=", 
    RowBox[{"expr", "*", 
     RowBox[{"(", 
      RowBox[{"expr", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "\[Rule]", "b"}], ",", 
         RowBox[{"b", "\[Rule]", "c"}], ",", 
         RowBox[{"c", "\[Rule]", "a"}], ",", 
         RowBox[{"A", "\[Rule]", "B"}], ",", 
         RowBox[{"B", "\[Rule]", "C"}], ",", 
         RowBox[{"C", "\[Rule]", "A"}]}], "}"}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{"expr", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "\[Rule]", "c"}], ",", 
         RowBox[{"b", "\[Rule]", "a"}], ",", 
         RowBox[{"c", "\[Rule]", "b"}], ",", 
         RowBox[{"A", "\[Rule]", "C"}], ",", 
         RowBox[{"B", "\[Rule]", "A"}], ",", 
         RowBox[{"C", "\[Rule]", "B"}]}], "}"}]}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"triangcount", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"triangtrue", "=", "0"}], ";"}]}], "Input",
 CellLabel->
  "In[149]:=",ExpressionUUID->"2971b754-2f54-48ca-b9ef-3613b9de0650"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"showSteps", "=", "True"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"showRegions", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"proveTriangleInequality", "[", 
  RowBox[{
   RowBox[{"csum", "[", 
    RowBox[{"Cot", "[", "A", "]"}], "]"}], "\[GreaterEqual]", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{3.8238591464739275`*^9},
 CellLabel->
  "In[153]:=",ExpressionUUID->"fe1e492e-8110-4928-88e3-df42aeefa4b1"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R-r-s form: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SqrtBox["3"]}], "-", 
       FractionBox["r", "s"], "-", 
       FractionBox[
        RowBox[{"4", " ", "R"}], "s"], "+", 
       FractionBox["s", "r"]}], ")"}]}], "\[GreaterEqual]", "0"}]}],
  SequenceForm[
  "R-r-s form: ", 
   Rational[1, 2] ((-2) 3^Rational[1, 2] - $CellContext`r/$CellContext`s - 
     4 $CellContext`R/$CellContext`s + $CellContext`r^(-1) $CellContext`s) >= 
   0],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOK6uSKH82rfOIpNDzsHoov8Y6+DaNXIt+z5QLpqTSgf
iOb4xikMoneeW6kOouc4qxmA6HszAs3A/FVmNiD6qt46RxCtsH2mB4gukHDx
A9ExfpE1IFrn1s82EG235+cEEH1gdtlMEP1ricSZUiB9peqwaBmQdstKnj0V
JB8Ztqyi7o1jxsmIw3OB9I6TMrb5TW8cezUOu4DoLI0vESBa1aAq4N/yN455
kRb3jq5641gyRYH1BJDepqV8+DSQbqkPfgCiO84dfg6ivbJlTT4D6TLjAn8Q
/Ux0ZyaIPjnXqQJEb5nkKyC++o2jv8/CH45A2umvbX4RkJ6yZ+aZSiC9qYff
+8bhN44AAu6oDw==
  "],
 CellLabel->
  "During evaluation of \
In[153]:=",ExpressionUUID->"41db714c-0e06-4c5a-90c2-eb52665b8c90"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x-y form: \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", "x"}], "-", 
     SuperscriptBox["x", "2"], "-", 
     RowBox[{"2", " ", 
      SqrtBox["3"], " ", "x", " ", "y"}], "+", 
     SuperscriptBox["y", "2"]}], 
    RowBox[{"2", " ", "x", " ", "y"}]]}],
  SequenceForm[
  "x-y form: ", 
   Rational[1, 
     2] $CellContext`x^(-1) $CellContext`y^(-1) ((-4) $CellContext`x - \
$CellContext`x^2 - 2 
    3^Rational[1, 2] $CellContext`x $CellContext`y + $CellContext`y^2)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOK6uSKH82rfOIpNDzsHoov8Y6+DaNXIt+z5QLpqTSgf
iOb4xikMoneeW6kOouc4qxmA6HszAs3A/FVmNiD6qt46RxCtsH2mB4gukHDx
A9ExfpE1IFrn1s82EG235+cEEH1gdtlMEP1ricSZUiB9peqwaBmQdstKnj0V
JB8Ztqyi7o1jxsmIw3OB9I6TMrb5TW8cezUOu4DoLI0vESBa1aAq4N/yN455
kRb3jq5641gyRYH1BJDepqV8+DSQbqkPfgCiO84dfg6ivbJlTT4D6TLjAn8Q
/Ux0ZyaIPjnXqQJEb5nkKyC++o2jv8/CH45A2umvbX4RkJ6yZ+aZSiBd1Cno
fePwG0cAAOWnzg==
  "],
 CellLabel->
  "During evaluation of \
In[153]:=",ExpressionUUID->"be4d220d-3085-41db-9081-71b267c3fdf7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x-y polynomial: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], " ", "x"}], "-", 
    SuperscriptBox["x", "2"], "-", 
    RowBox[{"2", " ", 
     SqrtBox["3"], " ", "x", " ", "y"}], "+", 
    SuperscriptBox["y", "2"]}]}],
  SequenceForm[
  "x-y polynomial: ", (-4) $CellContext`x - $CellContext`x^2 - 2 
   3^Rational[1, 2] $CellContext`x $CellContext`y + $CellContext`y^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOK6uSKH82rfOIpNDzsHoov8Y6+DaNXIt+z5QLpqTSgf
iOb4xikMoneeW6kOouc4qxmA6HszAs3A/FVmNiD6qt46RxCtsH2mB4gukHDx
A9ExfpE1IFrn1s82EG235+cEEH1gdtlMEP1ricSZUiB9peqwaBmQdstKnj0V
JB8Ztqyi7o1jxsmIw3OB9I6TMrb5TW8cezUOu4DoLI0vESBa1aAq4N/yN455
kRb3jq5641gyRYH1BJDepqV8+DSQbqkPfgCiO84dfg6ivbJlTT4D6TLjAn8Q
/Ux0ZyaIPjnXqQJEb5nkKyC++o2jv8/CH45A2umvbX4RkJ6yZ+aZSiCd/EjQ
+8bhN44AAtyoGA==
  "],
 CellLabel->
  "During evaluation of \
In[153]:=",ExpressionUUID->"95650ce1-e270-44a6-96ee-549f341aee6b"],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{
     GraphicsComplexBox[CompressedData["
1:eJxs3XnclmP+P/67tK8kSzQSyR5hEqXjGskk6zSyZE9EUhgTWaKQJRLZiSYy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      "], {{{
         EdgeForm[], 
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6], 
          Opacity[0.3]], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxMnQWUl2X3tZn5dQ4GiliYGKCiYgcGBiqKWNjd3YrdndjdIiqKogIWtqiI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            "]], 
           PolygonBox[CompressedData["
1:eJwtmHnATdUaxg++iY+zz1pHMmUoJLMQpUGhUCENmud50Cxu473lNt+MIXNC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            "]]}]}, {
         EdgeForm[], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6], 
          Opacity[0.3]], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxNnXncV9MTxx9CUZF6vndt1aq9tG/alLQp7bRRSElRshSSolKkTYtKWRLZ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            "]], 
           PolygonBox[CompressedData["
1:eJwtmXm8jtUXxV+XjKnU9T7POW8SmSWlQiSaSHPSKL9Kk5AhQ6TMQ0qlJFMa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            "]]}]}, {}, {}, {}, {}, {}}, {{
         Directive[
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]], 
         LineBox[CompressedData["
1:eJwl13f8j+Uex/GvvXcdlRFHKaLsI1SSDkIhQo71s+fP3nvvsvfeewuJrNBw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          "]]}, {
         Directive[
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]], 
         LineBox[CompressedData["
1:eJwl13n8T1Uex/GvnZJkXyqVmrRoI6nsUSKJkIQJJWFQylZkVwohSyVRRslo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          "]]}}}], {}}, {DisplayFunction -> Identity, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 1, Axes -> {False, False}, 
     AxesLabel -> {None, None}, AxesOrigin -> {Automatic, Automatic}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "ScalingFunctions" -> None, "TransparentPolygonMesh" -> True, 
       "AxesInFront" -> True}, PlotRange -> {{0, 1}, {0, 4}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {
       Scaled[0.02], 
       Scaled[0.02]}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{"functionRegion", 
       RowBox[{"fundamentalRegion", "\[And]", "specialXYcondition"}]}, 
      "SwatchLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[
                    Directive[
                    Opacity[1], 
                    AbsoluteThickness[1], 
                    RGBColor[1, 0, 0]]], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Opacity[0.3]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[
                    Directive[
                    Opacity[1], 
                    AbsoluteThickness[1], 
                    RGBColor[1, 0, 0]]], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Opacity[0.3]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"SwatchLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.3`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.3`", "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
             RowBox[{
               TagBox[#, HoldForm], ",", 
               TagBox[#2, HoldForm]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOK6uSKH82rfOIpNDzsHoov8Y6+DaNXIt+z5QLpqTSgf
iOb4xikMoneeW6kOouc4qxmA6HszAs3A/FVmNiD6qt46RxCtsH2mB4gukHDx
A9ExfpE1IFrn1s82EG235+cEEH1gdtlMEP1ricSZUiB9peqwaBmQdstKnj0V
JB8Ztqyi7o1jxsmIw3OB9I6TMrb5TW8cezUOu4DoLI0vESBa1aAq4N/yN455
kRb3jq5641gyRYH1BJDepqV8+DSQbqkPfgCiO84dfg6ivbJlTT4D6TLjAn8Q
/Ux0ZyaIPjnXqQJEb5nkKyC++o2jv8/CH45A2umvbX4RkJ6yZ+aZSiBtNkHP
+8bhN44A/9Wntg==
  "],
 CellLabel->
  "During evaluation of \
In[153]:=",ExpressionUUID->"629298a3-5ced-44ba-9884-16636d65a9ae"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOK6uSKH82rfOIpNDzsHoov8Y6+DaNXIt+z5QLpqTSgf
iOb4xikMoneeW6kOouc4qxmA6HszAs3A/FVmNiD6qt46RxCtsH2mB4gukHDx
A9ExfpE1IFrn1s82EG235+cEEH1gdtlMEP1ricSZUiB9peqwaBmQdstKnj0V
JB8Ztqyi7o1jxsmIw3OB9I6TMrb5TW8cezUOu4DoLI0vESBa1aAq4N/yN455
kRb3jq5641gyRYH1BJDepqV8+DSQbqkPfgCiO84dfg6ivbJlTT4D6TLjAn8Q
/Ux0ZyaIPjnXqQJEb5nkKyC++o2jv8/CH45A2umvbX4RkJ6yZ+aZSiA9+aOe
943DbxwBBXOodA==
  "],
 CellLabel->
  "During evaluation of \
In[153]:=",ExpressionUUID->"f50971dc-5bd7-4309-9712-2abaa7a6b04b"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.826481642591454*^9, 3.826481702851379*^9, 
  3.82648186443919*^9, 3.846173316716502*^9, 3.847630578767561*^9, 
  3.847634985893215*^9, 3.847642649942687*^9, 3.847642883488647*^9, 
  3.847642942893381*^9, 3.847723425919116*^9, 3.847723644443301*^9, 
  3.847723854681941*^9, 3.847723970962924*^9, 3.8477968673698797`*^9, 
  3.8478847423520393`*^9, 3.8479839949231033`*^9, 3.8479990776753817`*^9, 
  3.860775513468048*^9},
 CellLabel->
  "Out[155]=",ExpressionUUID->"8903cb7d-d365-4f68-92cc-ff78b2bb5263"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"showExpression", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"showSteps", "=", "False"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"showRegions", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"showBestK", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"condition", ",", "minK", ",", "maxK"}], "}"}], "=", 
   RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"csum", "[", 
       FractionBox["1", "a"], "]"}], "-", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["3"]], 
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "R"], "+", 
         FractionBox["1", "r"]}], ")"}]}]}], "\[LessEqual]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"k", 
        SqrtBox["3"]}]], 
      RowBox[{"(", 
       RowBox[{
        FractionBox["2", "R"], "-", 
        FractionBox["1", "r"]}], ")"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"chensAnswer", "=", 
   RowBox[{"2", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "3"}], ")"}]}], "+", 
      RowBox[{"2", "^", 
       RowBox[{"(", 
        RowBox[{"2", "/", "3"}], ")"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"minK", "=", 
  RowBox[{
   RowBox[{"MinValue", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"condition", "&&", 
        RowBox[{"k", ">", "0"}]}]}], "}"}], ",", "k"}], "]"}], "//", 
   "Factor"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"FullSimplify", "[", 
      RowBox[{"minK", "-", "chensAnswer"}], "]"}], "\[NotEqual]", "0"}], ",", 
    RowBox[{
    "redPrint", "[", "\"\<Calculation for best k failed.\>\"", "]"}]}], "]"}],
   ";"}]}], "Input",
 CellChangeTimes->{{3.824480580088436*^9, 3.824480645935659*^9}, {
   3.824480694641141*^9, 3.8244806984159107`*^9}, {3.824480730049788*^9, 
   3.824480823864023*^9}, {3.824480904393708*^9, 3.8244809350496883`*^9}, {
   3.8244809656897163`*^9, 3.824481077081299*^9}, {3.824640071850844*^9, 
   3.824640081738125*^9}, {3.824640112522005*^9, 3.8246401145454884`*^9}, {
   3.824640189045246*^9, 3.824640214026238*^9}, {3.82464034487554*^9, 
   3.824640405818841*^9}, {3.826482481012664*^9, 3.826482505195209*^9}, 
   3.826641592564591*^9},
 CellLabel->
  "In[156]:=",ExpressionUUID->"ae8f9204-c979-4c01-b34e-5185bfcbae9a"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SuperscriptBox["2", 
     RowBox[{"1", "/", "3"}]], "+", 
    SuperscriptBox["2", 
     RowBox[{"2", "/", "3"}]]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.824640381296359*^9, 3.824640406880309*^9}, 
   3.826481565525372*^9, {3.8264818522059793`*^9, 3.826481879325961*^9}, {
   3.826482454616173*^9, 3.826482506223864*^9}, 3.846173317067626*^9, 
   3.847630579196802*^9, 3.847634986252452*^9, 3.847642650138188*^9, 
   3.8476428836839*^9, 3.847642943067752*^9, 3.847723426334825*^9, 
   3.847723644820071*^9, 3.847723855030545*^9, 3.847723971311864*^9, 
   3.847796867742362*^9, 3.847884742940922*^9, 3.847983995304659*^9, 
   3.84799907802565*^9, 3.860775513928543*^9},
 CellLabel->
  "Out[162]=",ExpressionUUID->"44d5d5c6-b3b0-4f24-97f1-a786ee85840d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["condition"], "Input",
 CellLabel->
  "In[164]:=",ExpressionUUID->"620a9e90-c11e-4103-a806-3ef7e977981c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "\[LessEqual]", "0"}], "||", 
  RowBox[{"k", "\[GreaterEqual]", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["2", 
       RowBox[{"1", "/", "3"}]], "+", 
      SuperscriptBox["2", 
       RowBox[{"2", "/", "3"}]]}], ")"}]}]}]}]], "Output",
 CellChangeTimes->{3.826481896548396*^9, 3.846173317076679*^9, 
  3.847630579205881*^9, 3.8476349862616377`*^9, 3.847642650183833*^9, 
  3.8476428837379513`*^9, 3.8476429431123333`*^9, 3.8477234263424253`*^9, 
  3.847723644829114*^9, 3.847723855039545*^9, 3.847723971321844*^9, 
  3.847796867752695*^9, 3.847884742953113*^9, 3.847983995312203*^9, 
  3.847999078034945*^9, 3.860775513936092*^9},
 CellLabel->
  "Out[164]=",ExpressionUUID->"d35e7abe-8e10-4a4d-8bdc-4fbf0281af0a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["minK"], "Input",
 CellChangeTimes->{{3.8264819356937304`*^9, 3.826481941762713*^9}},
 CellLabel->
  "In[165]:=",ExpressionUUID->"e3ff0f4f-99d1-4f64-a4ad-1f1e7502f445"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SuperscriptBox["2", 
     RowBox[{"1", "/", "3"}]], "+", 
    SuperscriptBox["2", 
     RowBox[{"2", "/", "3"}]]}], ")"}]}]], "Output",
 CellChangeTimes->{3.8264819426146097`*^9, 3.846173317107812*^9, 
  3.847630579238051*^9, 3.8476349862939568`*^9, 3.847642650191677*^9, 
  3.847642883746166*^9, 3.847642943146604*^9, 3.8477234263766127`*^9, 
  3.847723644861465*^9, 3.847723855070881*^9, 3.847723971353853*^9, 
  3.847796867784595*^9, 3.847884742997669*^9, 3.847983995348392*^9, 
  3.847999078067185*^9, 3.8607755139836807`*^9},
 CellLabel->
  "Out[165]=",ExpressionUUID->"fe149261-d3bd-44ed-8de0-dcade37057e0"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1087, 1084},
WindowMargins->{{Automatic, 489}, {-50, Automatic}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 962, 18, 173, "Text",ExpressionUUID->"1e66b701-429a-4ec0-9f88-2b0a90741036"],
Cell[1523, 40, 6640, 95, 196, "Text",ExpressionUUID->"27642479-5d0e-4405-834d-56c69a1ef19c",
 Evaluatable->False,
 InitializationCell->True],
Cell[8166, 137, 160432, 3654, 13685, "Input",ExpressionUUID->"a4cf76da-2fba-495c-8982-46ad8378f2c2",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[168623, 3795, 206, 4, 67, "Section",ExpressionUUID->"13ad0316-cffb-4bda-bf6c-6311726b5669"],
Cell[168832, 3801, 2071, 58, 136, "Input",ExpressionUUID->"2971b754-2f54-48ca-b9ef-3613b9de0650"],
Cell[CellGroupData[{
Cell[170928, 3863, 481, 12, 73, "Input",ExpressionUUID->"fe1e492e-8110-4928-88e3-df42aeefa4b1"],
Cell[CellGroupData[{
Cell[171434, 3879, 1191, 32, 40, "Print",ExpressionUUID->"41db714c-0e06-4c5a-90c2-eb52665b8c90"],
Cell[172628, 3913, 1138, 30, 46, "Print",ExpressionUUID->"be4d220d-3085-41db-9081-71b267c3fdf7"],
Cell[173769, 3945, 1016, 25, 26, "Print",ExpressionUUID->"95650ce1-e270-44a6-96ee-549f341aee6b"],
Cell[174788, 3972, 156605, 2637, 377, "Print",ExpressionUUID->"629298a3-5ced-44ba-9884-16636d65a9ae"],
Cell[331396, 6611, 790, 20, 24, "Print",ExpressionUUID->"f50971dc-5bd7-4309-9712-2abaa7a6b04b"]
}, Open  ]],
Cell[332201, 6634, 555, 9, 34, "Output",ExpressionUUID->"8903cb7d-d365-4f68-92cc-ff78b2bb5263"]
}, Open  ]],
Cell[CellGroupData[{
Cell[332793, 6648, 2528, 73, 203, "Input",ExpressionUUID->"ae8f9204-c979-4c01-b34e-5185bfcbae9a"],
Cell[335324, 6723, 831, 17, 37, "Output",ExpressionUUID->"44d5d5c6-b3b0-4f24-97f1-a786ee85840d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[336192, 6745, 118, 2, 30, "Input",ExpressionUUID->"620a9e90-c11e-4103-a806-3ef7e977981c"],
Cell[336313, 6749, 797, 18, 37, "Output",ExpressionUUID->"d35e7abe-8e10-4a4d-8bdc-4fbf0281af0a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[337147, 6772, 181, 3, 30, "Input",ExpressionUUID->"e3ff0f4f-99d1-4f64-a4ad-1f1e7502f445"],
Cell[337331, 6777, 689, 15, 37, "Output",ExpressionUUID->"fe149261-d3bd-44ed-8de0-dcade37057e0"]
}, Open  ]]
}, Open  ]]
}
]
*)

