(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    363800,       9330]
NotebookOptionsPosition[    336493,       9036]
NotebookOutlinePosition[    336832,       9051]
CellTagsIndexPosition[    336789,       9048]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"timeConstraint", "=", "10"}], ";"}], " ", 
  RowBox[{"(*", " ", "seconds", " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"triangcount", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"triangtrue", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"showExpression", "=", "True"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"showConditionsForEquality", "=", "False"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"showSteps", "=", "False"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"showRegions", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"totalTime", "=", "0"}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Chapter 1\>\"", ",", "Blue", ",", " ", "18", ",", "Bold"}], 
    "]"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"time", ",", "result"}], "}"}], "=", 
    RowBox[{"Timing", "[", "\n", 
     RowBox[{"(*", " ", "1.1", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"3", "*", 
         RowBox[{"csum", "[", 
          RowBox[{"a", "*", "b"}], "]"}]}], "<=", 
        RowBox[{
         RowBox[{"csum", "[", "a", "]"}], "^", "2"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.2", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"csum", "[", "a", "]"}], "^", "2"}], "<", 
        RowBox[{"4", "*", 
         RowBox[{"csum", "[", 
          RowBox[{"a", "*", "b"}], "]"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.3", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "^", "2"}], "]"}], ">=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"36", "/", "35"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"s", "^", "2"}], "+", 
           RowBox[{"a", "*", "b", "*", 
            RowBox[{"c", "/", "s"}]}]}], ")"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.4", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"8", "*", 
         RowBox[{"cprod", "[", 
          RowBox[{"s", "-", "a"}], "]"}]}], "<=", 
        RowBox[{"a", "*", "b", "*", "c"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.5", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"8", "*", "a", "*", "b", "*", "c"}], "<=", 
        RowBox[{"cprod", "[", 
         RowBox[{"a", "+", "b"}], "]"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.6", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"3", "*", 
         RowBox[{"cprod", "[", 
          RowBox[{"a", "+", "b"}], "]"}]}], "<=", 
        RowBox[{"8", "*", 
         RowBox[{"csum", "[", 
          RowBox[{"a", "^", "3"}], "]"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.7", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"2", "*", 
         RowBox[{"csum", "[", "a", "]"}], "*", 
         RowBox[{"csum", "[", 
          RowBox[{"a", "^", "2"}], "]"}]}], ">=", 
        RowBox[{"3", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"csum", "[", 
            RowBox[{"a", "^", "3"}], "]"}], "+", 
           RowBox[{"3", "*", "a", "*", "b", "*", "c"}]}], ")"}]}]}], "]"}], 
      ";", "\n", 
      RowBox[{"(*", " ", "1.8", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"a", "*", "b", "*", "c"}], "<", 
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"s", "-", "a"}], ")"}]}], "]"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.9", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"s", "-", "a"}], ")"}]}], "]"}], "<=", 
        RowBox[{"3", "*", "a", "*", "b", "*", 
         RowBox[{"c", "/", "2"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.10", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "*", "b", "*", 
          RowBox[{"(", 
           RowBox[{"a", "+", "b"}], ")"}]}], "]"}], ">=", 
        RowBox[{"48", "*", 
         RowBox[{"cprod", "[", 
          RowBox[{"s", "-", "a"}], "]"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.11", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"a", "^", "3"}], "*", 
          RowBox[{"(", 
           RowBox[{"s", "-", "a"}], ")"}]}], "]"}], "<=", 
        RowBox[{"a", "*", "b", "*", "c", "*", "s"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.12", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"a", "^", "5"}], "*", 
          RowBox[{"(", 
           RowBox[{"s", "-", "a"}], ")"}]}], "]"}], "<=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}], "*", "a", "*", "b", "*", "c", "*", 
         RowBox[{"csum", "[", 
          RowBox[{"a", "^", "3"}], "]"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.13", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"64", "*", 
         RowBox[{"s", "^", "3"}], "*", 
         RowBox[{"cprod", "[", 
          RowBox[{"s", "-", "a"}], "]"}]}], "<=", 
        RowBox[{"27", "*", 
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"c", "^", "2"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.14", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"2", "*", 
         RowBox[{"s", "/", 
          RowBox[{"(", 
           RowBox[{"a", "*", "b", "*", "c"}], ")"}]}]}], "<=", 
        RowBox[{"csum", "[", 
         RowBox[{"1", "/", 
          RowBox[{"a", "^", "2"}]}], "]"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.15", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"s", "-", "a"}], ")"}]}], "]"}], ">=", 
        RowBox[{"9", "/", "s"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.16", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"3", "/", "2"}], "<=", 
        RowBox[{"csum", "[", 
         RowBox[{"a", "/", 
          RowBox[{"(", 
           RowBox[{"b", "+", "c"}], ")"}]}], "]"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.17", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "/", 
          RowBox[{"(", 
           RowBox[{"b", "+", "c"}], ")"}]}], "]"}], "<", "2"}], "]"}], ";", 
      "\n", 
      RowBox[{"(*", " ", "1.18", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"15", "/", "4"}], "<=", 
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"s", "+", "a"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"b", "+", "c"}], ")"}]}], "]"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.19", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"s", "+", "a"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"b", "+", "c"}], ")"}]}], "]"}], "<", 
        RowBox[{"9", "/", "2"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.20", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"1", "/", "3"}], "<=", 
        RowBox[{
         RowBox[{"csum", "[", 
          RowBox[{"a", "^", "2"}], "]"}], "/", 
         RowBox[{
          RowBox[{"csum", "[", "a", "]"}], "^", "2"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.21", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"csum", "[", 
          RowBox[{"a", "^", "2"}], "]"}], "/", 
         RowBox[{
          RowBox[{"csum", "[", "a", "]"}], "^", "2"}]}], "<", 
        RowBox[{"1", "/", "2"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.22", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"csum", "[", 
          RowBox[{"a", "^", "2"}], "]"}], "*", 
         RowBox[{"csum", "[", 
          RowBox[{
           RowBox[{"b", "^", "3"}], "*", 
           RowBox[{"c", "^", "3"}]}], "]"}]}], "<", 
        RowBox[{"2", "*", 
         RowBox[{"csum", "[", 
          RowBox[{"a", "^", "5"}], "]"}], "*", 
         RowBox[{"csum", "[", 
          RowBox[{"a", "^", "3"}], "]"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "1.23", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"csum", "[", "a", "]"}], "^", "3"}], "<=", 
        RowBox[{
         RowBox[{"5", "*", 
          RowBox[{"csum", "[", 
           RowBox[{"a", "*", "b", "*", 
            RowBox[{"(", 
             RowBox[{"a", "+", "b"}], ")"}]}], "]"}]}], "-", 
         RowBox[{"3", "*", "a", "*", "b", "*", "c"}]}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", "\"\< \>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"totalTime", "+=", "time"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Proved \>\"", ",", "triangtrue", ",", "\"\< inequalities out of \>\"",
     ",", "triangcount", ",", "\"\<. Time=\>\"", ",", "time"}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Chapter 2\>\"", ",", "Blue", ",", " ", "18", ",", "Bold"}], 
    "]"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"time", ",", "result"}], "}"}], "=", 
    RowBox[{"Timing", "[", "\n", 
     RowBox[{"(*", " ", "2.1", " ", "*)"}], "\n", 
     RowBox[{
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"Sin", "[", "A", "]"}], "]"}], "\[LessEqual]", 
        RowBox[{"3", "*", 
         RowBox[{
          RowBox[{"Sqrt", "[", "3", "]"}], "/", "2"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "2.2", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"Sin", "[", "A", "]"}], "^", "2"}], "]"}], "\[LessEqual]", 
        RowBox[{"9", "/", "4"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "2.3", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"Sin", "[", "A", "]"}], "]"}], "\[GreaterEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "*", "A"}], "]"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "2.4", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"cprod", "[", 
         RowBox[{"Sin", "[", "A", "]"}], "]"}], "\[LessEqual]", 
        RowBox[{"3", "*", 
         RowBox[{
          RowBox[{"Sqrt", "[", "3", "]"}], "/", "8"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "2.5", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{"1", "<", 
        RowBox[{"csum", "[", 
         RowBox[{"Cos", "[", "A", "]"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "2.6", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"Cos", "[", "A", "]"}], "]"}], "\[LessEqual]", 
        RowBox[{"3", "/", "2"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "2.7", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"3", "/", "4"}], "\[LessEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"Cos", "[", "A", "]"}], "^", "2"}], "]"}]}], "]"}], ";", 
      "\n", 
      RowBox[{"(*", " ", "2.8", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"Cos", "[", "A", "]"}], "^", "2"}], "]"}], "<", "3"}], 
       "]"}], ";", "\n", 
      RowBox[{"(*", " ", "2.9", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"Cos", "[", "A", "]"}], "*", 
          RowBox[{"Cos", "[", "B", "]"}]}], "]"}], "\[LessEqual]", 
        RowBox[{"3", "/", "4"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "2.10", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"cprod", "[", 
         RowBox[{"Cos", "[", "A", "]"}], "]"}], "\[LessEqual]", 
        RowBox[{"1", "/", "8"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "2.11", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"cprod", "[", 
         RowBox[{"Cos", "[", "A", "]"}], "]"}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "24"}], ")"}], "*", 
         RowBox[{"csum", "[", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"A", "-", "B"}], "]"}], "^", "2"}], "]"}]}]}], "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "2.12", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"Cot", "[", "A", "]"}], "]"}], "\[GreaterEqual]", 
        RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "2.13", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"Cot", "[", "A", "]"}], "^", "2"}], "]"}], 
        "\[GreaterEqual]", "1"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "2.14", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"Csc", "[", "A", "]"}], "]"}], "\[GreaterEqual]", 
        RowBox[{"2", "*", 
         RowBox[{"Sqrt", "[", "3", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "2.15", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"Csc", "[", "A", "]"}], "^", "2"}], "]"}], 
        "\[GreaterEqual]", "4"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "2.16", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"cprod", "[", 
            RowBox[{"Cos", "[", "A", "]"}], "]"}]}], ")"}], "/", 
         RowBox[{"cprod", "[", 
          RowBox[{"Sin", "[", "A", "]"}], "]"}]}], "\[GreaterEqual]", 
        RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"(*", " ", "2.17", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"2", "*", 
         RowBox[{"csum", "[", 
          RowBox[{"Cot", "[", "A", "]"}], "]"}]}], "\[GreaterEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{"Csc", "[", "A", "]"}], "]"}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\< \>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"totalTime", "+=", "time"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Proved \>\"", ",", "triangtrue", ",", "\"\< inequalities out of \>\"",
     ",", "triangcount", ",", "\"\<. Time=\>\"", ",", "time"}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Chapter 4\>\"", ",", "Blue", ",", " ", "18", ",", "Bold"}], 
    "]"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"time", ",", "result"}], "}"}], "=", 
    RowBox[{"Timing", "[", "\n", 
     RowBox[{"(*", " ", "4.1", " ", "*)"}], "\n", 
     RowBox[{
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"s", "^", "2"}], ">=", 
        RowBox[{"3", "K", "*", 
         RowBox[{"Sqrt", "[", "3", "]"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "4.2", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"s", "^", "2"}], ">=", 
        RowBox[{
         RowBox[{"3", "K", "*", 
          RowBox[{"Sqrt", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"csum", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "-", "b"}], ")"}], "^", "2"}], "]"}]}]}]}], "]"}], 
      ";", "\n", 
      RowBox[{"(*", " ", "4.3", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "^", "2"}], "]"}], ">=", 
        RowBox[{"4", "K", "*", 
         RowBox[{"Sqrt", "[", "3", "]"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "4.4", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "*", "b"}], "]"}], ">=", 
        RowBox[{"4", "K", "*", 
         RowBox[{"Sqrt", "[", "3", "]"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "4.5", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "*", "b"}], "]"}], ">=", 
        RowBox[{
         RowBox[{"4", "K", "*", 
          RowBox[{"Sqrt", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"csum", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "-", "b"}], ")"}], "^", "2"}], "]"}]}]}]}], "]"}], 
      ";", "\n", 
      RowBox[{"(*", " ", "4.6", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"4", "K", "*", 
          RowBox[{"Sqrt", "[", "3", "]"}]}], "+", 
         RowBox[{"csum", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "b"}], ")"}], "^", "2"}], "]"}]}], "<=", 
        RowBox[{"csum", "[", 
         RowBox[{"a", "^", "2"}], "]"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "4.7", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "^", "2"}], "]"}], "<=", 
        RowBox[{
         RowBox[{"4", "K", "*", 
          RowBox[{"Sqrt", "[", "3", "]"}]}], "+", 
         RowBox[{"3", "*", 
          RowBox[{"csum", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "-", "b"}], ")"}], "^", "2"}], "]"}]}]}]}], "]"}], 
      ";", "\n", 
      RowBox[{"(*", " ", "4.8", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"12", "K", "*", 
          RowBox[{"Sqrt", "[", "3", "]"}]}], "+", 
         RowBox[{"2", "*", 
          RowBox[{"csum", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "-", "b"}], ")"}], "^", "2"}], "]"}]}]}], "<=", 
        RowBox[{
         RowBox[{"csum", "[", "a", "]"}], "^", "2"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "4.9", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"csum", "[", "a", "]"}], "^", "2"}], "<=", 
        RowBox[{
         RowBox[{"12", "K", "*", 
          RowBox[{"Sqrt", "[", "3", "]"}]}], "+", 
         RowBox[{"8", "*", 
          RowBox[{"csum", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "-", "b"}], ")"}], "^", "2"}], "]"}]}]}]}], "]"}], 
      ";", "\n", 
      RowBox[{"(*", " ", "4.10", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "^", "4"}], "]"}], ">=", 
        RowBox[{"16", 
         RowBox[{"K", "^", "2"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "4.11", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "^", "4"}], "]"}], ">=", 
        RowBox[{
         RowBox[{"16", 
          RowBox[{"K", "^", "2"}]}], "+", 
         RowBox[{"4", "K", "*", 
          RowBox[{"csum", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "-", "b"}], ")"}], "^", "2"}], "]"}], "*", 
          RowBox[{"Sqrt", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{
           RowBox[{"csum", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "-", "b"}], ")"}], "^", "2"}], "]"}], "^", 
           "2"}]}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "4.12", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "*", 
          RowBox[{"b", "^", "2"}]}], "]"}], ">=", 
        RowBox[{"16", 
         RowBox[{"K", "^", "2"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "4.13", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"4", "K", "*", 
         RowBox[{"Sqrt", "[", "3", "]"}]}], "<=", 
        RowBox[{"9", "*", "a", "*", "b", "*", 
         RowBox[{"c", "/", 
          RowBox[{"csum", "[", "a", "]"}]}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "4.14", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "*", "b", "*", "c"}], ")"}], "^", "2"}], ">=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", 
           RowBox[{"K", "/", 
            RowBox[{"Sqrt", "[", "3", "]"}]}]}], ")"}], "^", "3"}]}], "]"}], 
      ";", "\n", 
      RowBox[{"(*", " ", "4.15", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"csum", "[", 
            RowBox[{"a", "*", "b"}], "]"}], "-", 
           RowBox[{
            RowBox[{"csum", "[", 
             RowBox[{"a", "^", "2"}], "]"}], "/", "2"}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", "*", 
             RowBox[{"csum", "[", 
              RowBox[{"a", "*", "b"}], "]"}]}], "-", 
            RowBox[{"5", "*", 
             RowBox[{
              RowBox[{"csum", "[", 
               RowBox[{"a", "^", "2"}], "]"}], "/", "2"}]}]}], ")"}], "/", 
          "12"}]}], "<=", 
        RowBox[{"K", "^", "2"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "4.16", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"K", "^", "2"}], "<=", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"csum", "[", 
             RowBox[{"a", "*", "b"}], "]"}], "-", 
            RowBox[{
             RowBox[{"csum", "[", 
              RowBox[{"a", "^", "2"}], "]"}], "/", "2"}]}], ")"}], "^", "2"}],
          "/", "12"}]}], "]"}], ";"}], "\n", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"4.17", " ", "is", " ", "not", " ", "true"}], ",", " ", 
       RowBox[{
       "see", " ", "Ono", " ", "inequality", " ", "on", " ", "Mathworld"}]}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"(*", "\n", 
      RowBox[{
       RowBox[{"proveTriangleInequality", "[", 
        RowBox[{
         RowBox[{"27", "*", 
          RowBox[{
           RowBox[{"cprod", "[", 
            RowBox[{
             RowBox[{"b", "^", "2"}], "+", 
             RowBox[{"c", "^", "2"}], "-", 
             RowBox[{"a", "^", "2"}]}], "]"}], "^", "2"}]}], "<=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"4", "K"}], ")"}], "^", "6"}]}], "]"}], ";"}], 
      "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", "\"\< \>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"totalTime", "+=", "time"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Proved \>\"", ",", "triangtrue", ",", "\"\< inequalities out of \>\"",
     ",", "triangcount", ",", "\"\<. Time=\>\"", ",", "time"}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Chapter 5\>\"", ",", "Blue", ",", " ", "18", ",", "Bold"}], 
    "]"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"time", ",", "result"}], "}"}], "=", 
    RowBox[{"Timing", "[", "\n", 
     RowBox[{"(*", " ", "5.1", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"2", "*", "r"}], "\[LessEqual]", "R"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "5.2", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", "a", "]"}], "\[LessEqual]", 
        RowBox[{"3", "*", "R", "*", 
         RowBox[{"Sqrt", "[", "3", "]"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "5.3", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{"s", "\[LessEqual]", 
        RowBox[{
         RowBox[{"2", "*", "R"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", "*", 
             RowBox[{"Sqrt", "[", "3", "]"}]}], "-", "4"}], ")"}], "*", 
          "r"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "5.4", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"9", "*", "r", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", "*", "R"}], "+", "r"}], ")"}]}], "\[LessEqual]", 
        RowBox[{"3", "*", 
         RowBox[{"s", "^", "2"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "5.5", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"3", "*", 
         RowBox[{"s", "^", "2"}]}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", "*", "R"}], "+", "r"}], ")"}], "^", "2"}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "5.6", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"6", "*", "r", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", "*", "R"}], "+", "r"}], ")"}]}], "\[LessEqual]", 
        RowBox[{"2", "*", 
         RowBox[{"s", "^", "2"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "5.7", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"2", "*", 
         RowBox[{"s", "^", "2"}]}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"2", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "*", "R"}], "+", "r"}], ")"}], "^", "2"}]}], "+", 
         RowBox[{"R", "^", "2"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "5.8", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"2", "*", 
         RowBox[{"s", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "R"}], "-", "r"}], ")"}]}], "\[LessEqual]", 
        RowBox[{"R", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", "*", "R"}], "+", "r"}], ")"}], "^", "2"}]}]}], "]"}],
       ";", "\n", 
      RowBox[{"(*", " ", "5.9", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"r", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", "*", "R"}], "-", 
           RowBox[{"5", "*", "r"}]}], ")"}]}], "\[LessEqual]", 
        RowBox[{"s", "^", "2"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "5.10", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"s", "^", "2"}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"4", "*", 
          RowBox[{"R", "^", "2"}]}], "+", 
         RowBox[{"4", "*", "R", "*", "r"}], "+", 
         RowBox[{"3", "*", 
          RowBox[{"r", "^", "2"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "5.11", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"s", "^", "2"}], "\[GreaterEqual]", 
        RowBox[{"27", "*", 
         RowBox[{"r", "^", "2"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "5.12", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"2", "*", 
         RowBox[{"s", "^", "2"}]}], "\[GreaterEqual]", 
        RowBox[{"27", "*", "R", "*", "r"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "5.13", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"36", "*", 
         RowBox[{"r", "^", "2"}]}], "\[LessEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{"a", "^", "2"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"(*", " ", "5.14", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "^", "2"}], "]"}], "\[LessEqual]", 
        RowBox[{"9", "*", 
         RowBox[{"R", "^", "2"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "5.15", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"24", "*", "R", "*", "r"}], "-", 
         RowBox[{"12", "*", 
          RowBox[{"r", "^", "2"}]}]}], "\[LessEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{"a", "^", "2"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"(*", " ", "5.16", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "^", "2"}], "]"}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"8", "*", 
          RowBox[{"R", "^", "2"}]}], "+", 
         RowBox[{"4", "*", 
          RowBox[{"r", "^", "2"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "5.17", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"36", "*", 
         RowBox[{"r", "^", "2"}]}], "\[LessEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{"a", "*", "b"}], "]"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "5.18", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "*", "b"}], "]"}], "\[LessEqual]", 
        RowBox[{"9", "*", 
         RowBox[{"R", "^", "2"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "5.19", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"4", "*", "r", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", "*", "R"}], "-", "r"}], ")"}]}], "\[LessEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{"a", "*", "b"}], "]"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "5.20", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "*", "b"}], "]"}], "\[LessEqual]", 
        RowBox[{"4", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"R", "+", "r"}], ")"}], "^", "2"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "5.21", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"36", "*", 
         RowBox[{"r", "^", "2"}]}], "\[LessEqual]", 
        RowBox[{"4", "*", "r", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", "*", "R"}], "-", "r"}], ")"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "5.22", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"4", "*", "r", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", "*", "R"}], "-", "r"}], ")"}]}], "\[LessEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{"a", "*", "b"}], "]"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "5.23", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"4", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"R", "+", "r"}], ")"}], "^", "2"}]}], "\[LessEqual]", 
        RowBox[{"9", "*", 
         RowBox[{"R", "^", "2"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "5.24", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "*", 
          RowBox[{"(", 
           RowBox[{"s", "-", "a"}], ")"}]}], "]"}], "\[LessEqual]", 
        RowBox[{"9", "*", "R", "*", "r"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "5.25", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"a", "*", "b", "*", "c"}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"8", "*", 
          RowBox[{"R", "^", "2"}], "*", "r"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", "*", 
             RowBox[{"Sqrt", "[", "3", "]"}]}], "-", "16"}], ")"}], "*", "R", 
          "*", 
          RowBox[{"r", "^", "2"}]}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "5.26", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", "3", "]"}], "/", "R"}], "\[LessEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{"1", "/", "a"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"(*", " ", "5.27", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"1", "/", "a"}], "]"}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"Sqrt", "[", "3", "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "r"}], ")"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "5.28", " ", "can", " ", "prove", " ", "in", " ", "5", " ", 
        "minutes"}], " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"3", "*", 
         RowBox[{
          RowBox[{"Sqrt", "[", "3", "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", "*", 
            RowBox[{"(", 
             RowBox[{"R", "+", "r"}], ")"}]}], ")"}]}]}], "\[LessEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{"1", "/", "a"}], "]"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "5.29", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"R", "^", "2"}]}], "\[LessEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"a", "*", "b"}], ")"}]}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "5.30", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"a", "*", "b"}], ")"}]}], "]"}], "\[LessEqual]", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"4", "*", 
           RowBox[{"r", "^", "2"}]}], ")"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "5.31", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"8", "*", "r", "*", 
         RowBox[{"(", 
          RowBox[{"R", "-", 
           RowBox[{"2", "*", "r"}]}], ")"}]}], "\[LessEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "b"}], ")"}], "^", "2"}], "]"}]}], "]"}], ";", 
      "\n", 
      RowBox[{"(*", " ", "5.32", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "b"}], ")"}], "^", "2"}], "]"}], "\[LessEqual]", 
        
        RowBox[{"8", "*", "R", "*", 
         RowBox[{"(", 
          RowBox[{"R", "-", 
           RowBox[{"2", "*", "r"}]}], ")"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "5.33", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"4", "*", 
         RowBox[{"r", "^", "2"}]}], "\[LessEqual]", 
        RowBox[{"a", "*", "b", "*", 
         RowBox[{"c", "/", 
          RowBox[{"csum", "[", "a", "]"}]}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "5.34", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"a", "*", "b", "*", "c"}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"R", "*", 
           RowBox[{"Sqrt", "[", "3", "]"}]}], ")"}], "^", "3"}]}], "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "5.35", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"5", "*", "R"}], "-", "r"}], "\[GreaterEqual]", 
        RowBox[{"s", "*", 
         RowBox[{"Sqrt", "[", "3", "]"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "5.36", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"54", "*", "R", "*", "r"}], "\[LessEqual]", 
        RowBox[{"3", "*", 
         RowBox[{"csum", "[", 
          RowBox[{"a", "*", "b"}], "]"}]}]}], "]"}], ";"}], "\n", "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\< \>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"totalTime", "+=", "time"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Proved \>\"", ",", "triangtrue", ",", "\"\< inequalities out of \>\"",
     ",", "triangcount", ",", "\"\<. Time=\>\"", ",", "time"}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Chapter 6\>\"", ",", "Blue", ",", " ", "18", ",", "Bold"}], 
    "]"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"time", ",", "result"}], "}"}], "=", 
    RowBox[{"Timing", "[", "\n", 
     RowBox[{"(*", " ", "6.1", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"2", "*", 
         RowBox[{"csum", "[", 
          RowBox[{"h", "[", "a", "]"}], "]"}]}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"Sqrt", "[", "3", "]"}], "*", 
         RowBox[{"csum", "[", "a", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "6.2", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"3", "*", 
         RowBox[{"csum", "[", 
          RowBox[{"a", "*", "b"}], "]"}]}], "\[GreaterEqual]", 
        RowBox[{"4", 
         RowBox[{"csum", "[", 
          RowBox[{
           RowBox[{"h", "[", "a", "]"}], "*", 
           RowBox[{"h", "[", "b", "]"}]}], "]"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "6.3", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "^", "3"}], "]"}], ">", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"8", "/", "7"}], ")"}], "*", 
         RowBox[{"csum", "[", 
          RowBox[{
           RowBox[{"h", "[", "a", "]"}], "^", "3"}], "]"}]}]}], "]"}], ";", 
      "\n", 
      RowBox[{"(*", " ", "6.4", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"h", "[", "b", "]"}], "^", "2"}], "+", 
            RowBox[{
             RowBox[{"h", "[", "c", "]"}], "^", "2"}]}], ")"}]}], "]"}], 
        "\[GreaterEqual]", "2"}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "6.5", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"h", "[", "a", "]"}], "]"}], "\[GreaterEqual]", 
        RowBox[{"9", "*", "r"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "6.6", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"h", "[", "a", "]"}], "]"}], "\[LessEqual]", 
        RowBox[{"3", "*", 
         RowBox[{"(", 
          RowBox[{"R", "+", "r"}], ")"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "6.7", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"h", "[", "a", "]"}], "]"}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"2", "*", "R"}], "+", 
         RowBox[{"5", "*", "r"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "6.8", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"2", "*", "r", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", "*", "R"}], "-", "r"}], ")"}], "/", "R"}]}], 
        "\[LessEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{"h", "[", "a", "]"}], "]"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "6.9", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"h", "[", "a", "]"}], "]"}], "\[LessEqual]", 
        RowBox[{"2", "*", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"R", "+", "r"}], ")"}], "^", "2"}], "/", "R"}]}]}], "]"}],
       ";", "\n", 
      RowBox[{"(*", " ", "6.10", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"2", "*", 
         RowBox[{"csum", "[", 
          RowBox[{
           RowBox[{"h", "[", "a", "]"}], "*", 
           RowBox[{"h", "[", "b", "]"}]}], "]"}]}], "\[LessEqual]", 
        RowBox[{"6", "*", "K", "*", 
         RowBox[{"Sqrt", "[", "3", "]"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "6.11", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"6", "*", "K", "*", 
         RowBox[{"Sqrt", "[", "3", "]"}]}], "\[LessEqual]", 
        RowBox[{"27", "*", "R", "*", "r"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "6.12", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"cprod", "[", 
         RowBox[{"h", "[", "a", "]"}], "]"}], "\[GreaterEqual]", 
        RowBox[{"27", "*", 
         RowBox[{"r", "^", "3"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "6.13", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"h", "[", "a", "]"}], "-", 
            RowBox[{"2", "*", "r"}]}], ")"}]}], "]"}], "\[GreaterEqual]", 
        RowBox[{"3", "/", "r"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "6.14", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"h", "[", "a", "]"}], "+", "r"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"h", "[", "a", "]"}], "-", "r"}], ")"}]}], "]"}], 
        "\[GreaterEqual]", "6"}], "]"}], ";"}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\< \>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"totalTime", "+=", "time"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Proved \>\"", ",", "triangtrue", ",", 
     "\"\< inequalities out of \>\"", ",", "triangcount", ",", 
     "\"\<. Time=\>\"", ",", "time"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Chapter 7\>\"", ",", "Blue", ",", " ", "18", ",", "Bold"}], 
    "]"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"time", ",", "result"}], "}"}], "=", 
    RowBox[{"Timing", "[", "\n", 
     RowBox[{"(*", " ", "7.1", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"K", "*", 
         RowBox[{"Sqrt", "[", "3", "]"}]}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"R", "+", "r"}], ")"}], "^", "2"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "7.2", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"K", "*", 
         RowBox[{"Sqrt", "[", "3", "]"}]}], "\[LessEqual]", 
        RowBox[{"r", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", "*", "R"}], "+", "r"}], ")"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "7.3", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"s", "^", "2"}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"4", "*", 
          RowBox[{"R", "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"11", "/", 
            RowBox[{"(", 
             RowBox[{"3", "*", 
              RowBox[{"Sqrt", "[", "3", "]"}]}], ")"}]}], ")"}], "*", 
          "K"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "7.4", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"8", "*", "R", "*", "r"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"11", "/", 
            RowBox[{"(", 
             RowBox[{"3", "*", 
              RowBox[{"Sqrt", "[", "3", "]"}]}], ")"}]}], ")"}], "*", "K"}]}],
         "\[LessEqual]", 
        RowBox[{"s", "^", "2"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "7.5", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "^", "2"}], "]"}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"8", "*", 
          RowBox[{"R", "^", "2"}]}], "+", 
         RowBox[{"4", "*", 
          RowBox[{"K", "/", 
           RowBox[{"(", 
            RowBox[{"3", "*", 
             RowBox[{"Sqrt", "[", "3", "]"}]}], ")"}]}]}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "7.6", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"csum", "[", 
          RowBox[{"a", "^", "2"}], "]"}], "^", "2"}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"64", "*", 
          RowBox[{"R", "^", "4"}]}], "+", 
         RowBox[{"48", "*", 
          RowBox[{"K", "^", "2"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "7.7", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"8", "*", "K", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "R"}], "-", "r"}], ")"}]}], "\[LessEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{"a", "^", "3"}], "]"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "7.8", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"proveTriangleInequality", "[", 
         RowBox[{
          RowBox[{"4", "*", "R", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"R", "-", 
              RowBox[{"4", "*", 
               RowBox[{"K", "/", "s"}]}]}], ")"}], "^", "3"}]}], 
          "\[GreaterEqual]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"s", "^", "2"}], "/", "4"}], "+", 
             RowBox[{"4", "*", 
              RowBox[{
               RowBox[{"K", "^", "2"}], "/", 
               RowBox[{"s", "^", "2"}]}]}], "-", 
             RowBox[{"2", "*", 
              RowBox[{"R", "^", "2"}]}], "-", 
             RowBox[{"5", "*", "K", "*", 
              RowBox[{"R", "/", "s"}]}]}], ")"}], "^", "2"}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", "*)"}], "\n", 
      RowBox[{"(*", " ", 
       RowBox[{"7.9", " ", "modified"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"4", "*", "K"}], "\[LessEqual]", 
        RowBox[{"3", "*", 
         RowBox[{"R", "^", "2"}], "*", 
         RowBox[{"Sqrt", "[", "3", "]"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "7.10", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"3", "*", 
         RowBox[{"r", "^", "2"}], "*", 
         RowBox[{"Sqrt", "[", "3", "]"}]}], "\[LessEqual]", "K"}], "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "7.11", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"r", "^", "3"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", "*", "R"}], "-", 
           RowBox[{"5", "*", "r"}]}], ")"}]}], "\[LessEqual]", 
        RowBox[{"K", "^", "2"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "7.12", " ", "*)"}], "\n", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"K", "^", "2"}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"r", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", "*", 
            RowBox[{"r", "^", "2"}]}], "+", 
           RowBox[{"4", "*", "R", "*", "r"}], "+", 
           RowBox[{"4", "*", 
            RowBox[{"R", "^", "2"}]}]}], ")"}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "7.13", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"9", "*", 
         RowBox[{"r", "/", 
          RowBox[{"(", 
           RowBox[{"2", "*", "K"}], ")"}]}]}], "\[LessEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{"1", "/", "a"}], "]"}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "7.14", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"1", "/", "a"}], "]"}], "\[LessEqual]", 
        RowBox[{"9", "*", 
         RowBox[{"R", "/", 
          RowBox[{"(", 
           RowBox[{"4", "*", "K"}], ")"}]}]}]}], "]"}], ";", "\n", 
      RowBox[{"(*", " ", "7.15", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"4", "*", "R", "*", "r"}], "+", 
         RowBox[{"r", "^", "2"}]}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"K", "*", 
          RowBox[{"Sqrt", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"csum", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "-", "b"}], ")"}], "^", "2"}], "]"}]}]}]}], "]"}], 
      ";"}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", "\"\< \>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"totalTime", "+=", "time"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Proved \>\"", ",", "triangtrue", ",", 
     "\"\< inequalities out of \>\"", ",", "triangcount", ",", 
     "\"\<. Time=\>\"", ",", "time"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Chapter 8\>\"", ",", "Blue", ",", " ", "18", ",", "Bold"}], 
    "]"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"time", ",", "result"}], "}"}], "=", 
    RowBox[{"Timing", "[", "\n", 
     RowBox[{"(*", " ", "8.1", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"m", "[", "a", "]"}], "^", "2"}], "]"}], "\[GreaterEqual]", 
        
        RowBox[{"3", "K", "*", 
         RowBox[{"Sqrt", "[", "3", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "8.2", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"w", "[", "a", "]"}], "^", "2"}], "]"}], "\[GreaterEqual]", 
        
        RowBox[{"3", "K", "*", 
         RowBox[{"Sqrt", "[", "3", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "8.3", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"16", 
         RowBox[{"csum", "[", 
          RowBox[{
           RowBox[{"w", "[", "a", "]"}], "^", "4"}], "]"}]}], "\[LessEqual]", 
        
        RowBox[{"9", 
         RowBox[{"csum", "[", 
          RowBox[{"a", "^", "4"}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "8.4", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"w", "[", "a", "]"}], "^", "2"}], "]"}], "\[LessEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"r", "[", "b", "]"}], "*", 
          RowBox[{"r", "[", "c", "]"}]}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "8.5", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", "[", "a", "]"}], "/", 
            RowBox[{"w", "[", "a", "]"}]}], ")"}], "^", "2"}], "]"}], 
        "\[GreaterEqual]", "3"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "8.6", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"w", "[", "a", "]"}], "^", "2"}], "]"}], "\[LessEqual]", 
        RowBox[{"s", "^", "2"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "8.7", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proveTriangleInequality", "[", 
       RowBox[{
        RowBox[{"s", "^", "2"}], "\[LessEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"m", "[", "a", "]"}], "^", "2"}], "]"}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", "\"\< \>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"totalTime", "+=", "time"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Proved \>\"", ",", "triangtrue", ",", 
     "\"\< inequalities out of \>\"", ",", "triangcount", ",", 
     "\"\<. Time=\>\"", ",", "time"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Total time=\>\"", ",", "totalTime"}], "]"}], ";"}]}], "Input",\

 CellChangeTimes->{{3.824969453771798*^9, 3.824969453778088*^9}, {
   3.824969498958709*^9, 3.8249695914226217`*^9}, {3.824969624471027*^9, 
   3.824969689206497*^9}, {3.824969726324748*^9, 3.824969728329039*^9}, 
   3.824970338406981*^9, {3.824970568039728*^9, 3.824970581189137*^9}, {
   3.824970785413896*^9, 3.824970852948936*^9}, {3.824970898990786*^9, 
   3.824970904749445*^9}, 3.824970953646728*^9, {3.824971013413022*^9, 
   3.824971025255468*^9}, {3.824971103988493*^9, 3.824971104686327*^9}, {
   3.824971190270049*^9, 3.824971229101419*^9}, 3.824971391894301*^9, {
   3.824971545220141*^9, 3.824971552231632*^9}, 3.8252719761925373`*^9, {
   3.825522076776515*^9, 3.825522077209223*^9}, 3.825522133584608*^9, 
   3.825522269840276*^9, 3.825522340866173*^9, {3.825616982982751*^9, 
   3.8256169943731737`*^9}, 3.82561784203296*^9, {3.826290907707473*^9, 
   3.826290917316728*^9}, {3.826465493885653*^9, 3.826465536980966*^9}, {
   3.826465589828412*^9, 3.826465723732641*^9}, {3.826465754652812*^9, 
   3.826465957871117*^9}, 3.826641844276366*^9, {3.827239886010695*^9, 
   3.8272398891800537`*^9}, 3.827239937060898*^9, 3.8272400941116657`*^9, {
   3.847723445337997*^9, 3.847723518068027*^9}, {3.847723662864909*^9, 
   3.8477236663463984`*^9}, 3.848053998983522*^9},
 CellLabel->
  "In[166]:=",ExpressionUUID->"ca280df3-3b4a-4d7b-8692-39e270427d70"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Chapter 1\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontSize->18,
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN47Qs46Abh984AgDYIq8u
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"49016930-6ab9-42a1-be6f-48c195702cc8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "b"}], "+", 
       RowBox[{"a", " ", "c"}], "+", 
       RowBox[{"b", " ", "c"}]}], ")"}]}], "\[LessEqual]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", "b", "+", "c"}], ")"}], "2"]}]}],
  SequenceForm[
  "[", 1, "] ", 
   3 ($CellContext`a $CellContext`b + $CellContext`a $CellContext`c + \
$CellContext`b $CellContext`c) <= ($CellContext`a + $CellContext`b + \
$CellContext`c)^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY2ilcdCNw28cAdaDrvw=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"56a56d4c-b857-492a-a61f-aa57d897c032"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshrovv3GQTcOv3EEANaFrwU=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"c9ede8aa-b812-424c-bb23-6ce87057e145"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", "b", "+", "c"}], ")"}], "2"], "<", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "b"}], "+", 
       RowBox[{"a", " ", "c"}], "+", 
       RowBox[{"b", " ", "c"}]}], ")"}]}]}]}],
  SequenceForm[
  "[", 2, "] ", ($CellContext`a + $CellContext`b + $CellContext`c)^2 < 
   4 ($CellContext`a $CellContext`b + $CellContext`a $CellContext`c + \
$CellContext`b $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshpo/injoBuH3zgCANqSr4g=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"8af5ec4b-4c6f-49e4-86ca-63970f5a247e"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN47crxkE3Dr9xBADeCK/4
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"b667df99-a387-45be-b531-c2e7f54ef03f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[GreaterEqual]", 
    RowBox[{
     FractionBox["36", "35"], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"a", " ", "b", " ", "c"}], "s"], "+", 
       SuperscriptBox["s", "2"]}], ")"}]}]}]}],
  SequenceForm[
  "[", 3, "] ", $CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2 >= 
   Rational[36, 
      35] ($CellContext`a $CellContext`b $CellContext`c/$CellContext`s + \
$CellContext`s^2)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4577xkE3Dr9xBADcha/J
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"9c6b8c8c-1068-4ffd-a721-f1c0295e3cd3"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshpo7z6ToBuH3zgCAN0Er9U=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"f9ecb5be-8b69-496f-8479-e68a139e14a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "s"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "b"}], "+", "s"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "c"}], "+", "s"}], ")"}]}], "\[LessEqual]", 
    RowBox[{"a", " ", "b", " ", "c"}]}]}],
  SequenceForm[
  "[", 4, "] ", 
   8 (-$CellContext`a + $CellContext`s) (-$CellContext`b + $CellContext`s) \
(-$CellContext`c + $CellContext`s) <= $CellContext`a $CellContext`b \
$CellContext`c],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY9JJk6Abh984AgDZIa9a
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"8cdb269b-3cce-44db-aa14-48f939c45c07"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4x5W06Abh984AgDWm67x
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"aeaafa37-f85e-4eb9-afea-1951e32a9486"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"8", " ", "a", " ", "b", " ", "c"}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", "b"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", "c"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}]}]}]}],
  SequenceForm[
  "[", 5, "] ", 
   8 $CellContext`a $CellContext`b $CellContext`c <= ($CellContext`a + \
$CellContext`b) ($CellContext`a + $CellContext`c) ($CellContext`b + \
$CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4x8B06Abh984AgDY6K88
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"a5cedb49-66ce-44e3-9809-3564fcfa7aa3"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN48JvpkE3Dr9xBADcWq/H
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"9ca0af45-555c-415f-b0bd-e561edbbc952"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", "b"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", "c"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}]}], "\[LessEqual]", 
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "3"], "+", 
       SuperscriptBox["b", "3"], "+", 
       SuperscriptBox["c", "3"]}], ")"}]}]}]}],
  SequenceForm[
  "[", 6, "] ", 
   3 ($CellContext`a + $CellContext`b) ($CellContext`a + $CellContext`c) \
($CellContext`b + $CellContext`c) <= 
   8 ($CellContext`a^3 + $CellContext`b^3 + $CellContext`c^3)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshoYHoxmQTcOv3EEANJFrmY=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"106b4709-c3bd-445b-a0de-d33ce945a1f2"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo8Ans6Abh984AgDXvK8z
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"bd70168f-a477-4f78-9675-e198a9bacce3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}], "\[GreaterEqual]", 
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "3"], "+", 
       SuperscriptBox["b", "3"], "+", 
       RowBox[{"3", " ", "a", " ", "b", " ", "c"}], "+", 
       SuperscriptBox["c", "3"]}], ")"}]}]}]}],
  SequenceForm[
  "[", 7, "] ", 
   2 ($CellContext`a + $CellContext`b + $CellContext`c) ($CellContext`a^2 + \
$CellContext`b^2 + $CellContext`c^2) >= 
   3 ($CellContext`a^3 + $CellContext`b^3 + 
     3 $CellContext`a $CellContext`b $CellContext`c + $CellContext`c^3)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4+Y/ZkE3Dr9xBADdGq/g
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"b5a6160a-1f21-4d3e-9ced-32a686df945a"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo8I/86Abh984AgDYlq9Q
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"bbcaccdd-a4a1-415a-8f44-78ebec0f5a6a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a", " ", "b", " ", "c"}], "<", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "s"}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "b"}], "+", "s"}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "c"}], "+", "s"}], ")"}]}]}]}]}],
  SequenceForm[
  "[", 8, "] ", $CellContext`a $CellContext`b $CellContext`c < \
$CellContext`a^2 (-$CellContext`a + $CellContext`s) + $CellContext`b^2 \
(-$CellContext`b + $CellContext`s) + $CellContext`c^2 (-$CellContext`c + \
$CellContext`s)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN420Oi6Abh984AgDXuq8W
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"f7477395-113a-4026-b1e7-62548d1911aa"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY5KwRdCNw28cAdQ/rqg=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"760e20ba-8c40-4f6d-b4b7-03a61f735d34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "s"}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "b"}], "+", "s"}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "c"}], "+", "s"}], ")"}]}]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"3", " ", "a", " ", "b", " ", "c"}], "2"]}]}],
  SequenceForm[
  "[", 9, "] ", $CellContext`a^2 (-$CellContext`a + $CellContext`s) + \
$CellContext`b^2 (-$CellContext`b + $CellContext`s) + $CellContext`c^2 \
(-$CellContext`c + $CellContext`s) <= 
   Rational[3, 2] $CellContext`a $CellContext`b $CellContext`c],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo6usRdCNw28cAdOdrpU=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"6532ca15-a9d8-4b45-ac79-22de13e249eb"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshporrpF0I3DbxwB1Puuwg==
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"bc2bb8da-b1ce-470e-b99a-1e714ddd2eb7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "b", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}]}], "+", 
     RowBox[{"a", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}]}], "+", 
     RowBox[{"b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}]}], "\[GreaterEqual]", 
    RowBox[{"48", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "s"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "b"}], "+", "s"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "c"}], "+", "s"}], ")"}]}]}]}],
  SequenceForm[
  "[", 10, "] ", $CellContext`a $CellContext`b ($CellContext`a + \
$CellContext`b) + $CellContext`a $CellContext`c ($CellContext`a + \
$CellContext`c) + $CellContext`b $CellContext`c ($CellContext`b + \
$CellContext`c) >= 
   48 (-$CellContext`a + $CellContext`s) (-$CellContext`b + $CellContext`s) \
(-$CellContext`c + $CellContext`s)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN42VDi6Abh984AgDYma83
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"33dcdf0d-d876-4e78-b0af-7b90e2c5fec6"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN45pEi6Abh984AgDYsa9A
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"000a2d2d-38cd-4bcf-becf-7e5817f47120"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "s"}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["b", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "b"}], "+", "s"}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "c"}], "+", "s"}], ")"}]}]}], "\[LessEqual]", 
    RowBox[{"a", " ", "b", " ", "c", " ", "s"}]}]}],
  SequenceForm[
  "[", 11, "] ", $CellContext`a^3 (-$CellContext`a + $CellContext`s) + \
$CellContext`b^3 (-$CellContext`b + $CellContext`s) + $CellContext`c^3 \
(-$CellContext`c + $CellContext`s) <= $CellContext`a $CellContext`b \
$CellContext`c $CellContext`s],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY0WBRdCNw28cAdd6rxs=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"8e62f64c-274e-4488-81d3-83eb763a5fb6"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY46/ZdCNw28cAdY5ru8=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"b83d2de0-b92c-4b00-9663-7abe4cbf427c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "s"}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["b", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "b"}], "+", "s"}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["c", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "c"}], "+", "s"}], ")"}]}]}], "\[LessEqual]", 
    RowBox[{
     FractionBox["1", "2"], " ", "a", " ", "b", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "3"], "+", 
       SuperscriptBox["b", "3"], "+", 
       SuperscriptBox["c", "3"]}], ")"}]}]}]}],
  SequenceForm[
  "[", 12, "] ", $CellContext`a^5 (-$CellContext`a + $CellContext`s) + \
$CellContext`b^5 (-$CellContext`b + $CellContext`s) + $CellContext`c^5 \
(-$CellContext`c + $CellContext`s) <= 
   Rational[1, 
      2] $CellContext`a $CellContext`b $CellContext`c ($CellContext`a^3 + \
$CellContext`b^3 + $CellContext`c^3)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo0W0ZdCNw28cAdTtrsc=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"9072c8ab-098b-41ef-9453-aff8bf213ae9"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo/0Tq6Abh984AgDY6q9Y
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"6d3d7a72-acd0-445c-a39d-8e5a8b102c7e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"64", " ", 
     SuperscriptBox["s", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "s"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "b"}], "+", "s"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "c"}], "+", "s"}], ")"}]}], "\[LessEqual]", 
    RowBox[{"27", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}]}]}],
  SequenceForm[
  "[", 13, "] ", 
   64 $CellContext`s^3 (-$CellContext`a + $CellContext`s) (-$CellContext`b + \
$CellContext`s) (-$CellContext`c + $CellContext`s) <= 
   27 $CellContext`a^2 $CellContext`b^2 $CellContext`c^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshpo/weroBuH3zgCANver7g=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"fe7792af-a6b7-4079-af42-6d9a9f2defd8"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN47Yr1kE3Dr9xBADcOK/A
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"543eceb9-6e8f-4703-99d8-7b042427fef9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", "s"}], 
     RowBox[{"a", " ", "b", " ", "c"}]], "\[LessEqual]", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox["a", "2"]], "+", 
     FractionBox["1", 
      SuperscriptBox["b", "2"]], "+", 
     FractionBox["1", 
      SuperscriptBox["c", "2"]]}]}]}],
  SequenceForm[
  "[", 14, "] ", 
   2 $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
$CellContext`s <= $CellContext`a^(-2) + $CellContext`b^(-2) + \
$CellContext`c^(-2)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo9h966Abh984AgDXha8r
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"415a3698-b1b7-4d2c-bb6b-8e7f97ecd89e"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN46I7NkE3Dr9xBADb1q+1
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"67c9f3ce-b796-4f75-a9a8-43643339048b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "s"}]], "+", 
     FractionBox["1", 
      RowBox[{
       RowBox[{"-", "b"}], "+", "s"}]], "+", 
     FractionBox["1", 
      RowBox[{
       RowBox[{"-", "c"}], "+", "s"}]]}], "\[GreaterEqual]", 
    FractionBox["9", "s"]}]}],
  SequenceForm[
  "[", 15, "] ", (-$CellContext`a + $CellContext`s)^(-1) + (-$CellContext`b + \
$CellContext`s)^(-1) + (-$CellContext`c + $CellContext`s)^(-1) >= 
   9/$CellContext`s],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY8dzm6Abh984AgDbU6+m
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"9f3583f3-3e1d-4b70-a59a-bea84f4172f6"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN48b7tkE3Dr9xBADcaa/I
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"fa97106f-ed46-432c-90c5-f3a9fcee413e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["3", "2"], "\[LessEqual]", 
    RowBox[{
     FractionBox["c", 
      RowBox[{"a", "+", "b"}]], "+", 
     FractionBox["b", 
      RowBox[{"a", "+", "c"}]], "+", 
     FractionBox["a", 
      RowBox[{"b", "+", "c"}]]}]}]}],
  SequenceForm[
  "[", 16, "] ", 
   Rational[3, 
     2] <= ($CellContext`a + $CellContext`b)^(-1) $CellContext`c + \
$CellContext`b/($CellContext`a + $CellContext`c) + \
$CellContext`a/($CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN49+XtkE3Dr9xBADfD7Ae
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"f09adbf1-ac7b-4e8f-b0a6-5e4dc4223218"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4xY+u6Abh984AgDW0K77
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"2d97364d-2db4-4b22-9f9b-5eee35599e7f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox["c", 
      RowBox[{"a", "+", "b"}]], "+", 
     FractionBox["b", 
      RowBox[{"a", "+", "c"}]], "+", 
     FractionBox["a", 
      RowBox[{"b", "+", "c"}]]}], "<", "2"}]}],
  SequenceForm[
  "[", 17, "] ", ($CellContext`a + $CellContext`b)^(-1) $CellContext`c + \
$CellContext`b/($CellContext`a + $CellContext`c) + \
$CellContext`a/($CellContext`b + $CellContext`c) < 2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4ysxu6Abh984AgDYuK85
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"7dd04a72-9c56-4838-937a-81561255eb04"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN44X/dkE3Dr9xBADeR7AI
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"ed57c9c7-04f6-4426-ac3b-f316257ad965"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["15", "4"], "\[LessEqual]", 
    RowBox[{
     FractionBox[
      RowBox[{"a", "+", "s"}], 
      RowBox[{"b", "+", "c"}]], "+", 
     FractionBox[
      RowBox[{"b", "+", "s"}], 
      RowBox[{"a", "+", "c"}]], "+", 
     FractionBox[
      RowBox[{"c", "+", "s"}], 
      RowBox[{"a", "+", "b"}]]}]}]}],
  SequenceForm[
  "[", 18, "] ", 
   Rational[15, 
     4] <= ($CellContext`b + $CellContext`c)^(-1) ($CellContext`a + \
$CellContext`s) + ($CellContext`a + $CellContext`c)^(-1) ($CellContext`b + \
$CellContext`s) + ($CellContext`a + $CellContext`b)^(-1) ($CellContext`c + \
$CellContext`s)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNoxuHfdCNw28cAdM8rog=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"b9dcc582-3ce8-422e-a13e-590382acda92"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4z9++6Abh984AgDZLa9H
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"6d6def31-fcbe-4bc6-9e72-524923f39635"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"a", "+", "s"}], 
      RowBox[{"b", "+", "c"}]], "+", 
     FractionBox[
      RowBox[{"b", "+", "s"}], 
      RowBox[{"a", "+", "c"}]], "+", 
     FractionBox[
      RowBox[{"c", "+", "s"}], 
      RowBox[{"a", "+", "b"}]]}], "<", 
    FractionBox["9", "2"]}]}],
  SequenceForm[
  "[", 19, "] ", ($CellContext`b + $CellContext`c)^(-1) ($CellContext`a + \
$CellContext`s) + ($CellContext`a + $CellContext`c)^(-1) ($CellContext`b + \
$CellContext`s) + ($CellContext`a + $CellContext`b)^(-1) ($CellContext`c + \
$CellContext`s) < Rational[9, 2]],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshponrh90I3DbxwB0kWuaw==
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"f7a90849-fa75-4909-bb8c-28cd9652dacc"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY5+cfdCNw28cAdYWruY=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"2268c9c1-09c3-49a3-9285-e83959e0d26f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}], "2"]]}]}],
  SequenceForm[
  "[", 20, "] ", 
   Rational[1, 
     3] <= ($CellContext`a + $CellContext`b + $CellContext`c)^(-2) \
($CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshporpp90I3DbxwB1R6uyA==
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"bf1b5660-3d93-4928-94bf-adbdfaef6bb7"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY4q+fdCNw28cAdU9rs0=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"36c6017b-a434-4218-916b-1b3b0feb4cc9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}], "2"]], "<", 
    FractionBox["1", "2"]}]}],
  SequenceForm[
  "[", 21, "] ", ($CellContext`a + $CellContext`b + $CellContext`c)^(-2) \
($CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2) < Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo4OZfdCNw28cAdROrrA=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"ea584eaf-94d3-4f6c-bbc3-b07d17573ab9"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN42Vb+6Abh984AgDZF69K
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"29b964f9-0139-46d5-8de5-4bdb713d9175"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["b", "3"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["c", "3"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "3"], " ", 
        SuperscriptBox["c", "3"]}]}], ")"}]}], "<", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "3"], "+", 
       SuperscriptBox["b", "3"], "+", 
       SuperscriptBox["c", "3"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "5"], "+", 
       SuperscriptBox["b", "5"], "+", 
       SuperscriptBox["c", "5"]}], ")"}]}]}]}],
  SequenceForm[
  "[", 22, "] ", ($CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2) \
($CellContext`a^3 $CellContext`b^3 + $CellContext`a^3 $CellContext`c^3 + \
$CellContext`b^3 $CellContext`c^3) < 
   2 ($CellContext`a^3 + $CellContext`b^3 + $CellContext`c^3) \
($CellContext`a^5 + $CellContext`b^5 + $CellContext`c^5)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4yJX+6Abh984AgDXx68h
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"0b4b6d35-6b57-4fc7-a014-cb569180990f"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN44pjzkE3Dr9xBADblq+s
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"7a4dc5f5-ebf4-4545-9966-402dd249a010"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", "b", "+", "c"}], ")"}], "3"], "\[LessEqual]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], " ", "a", " ", "b", " ", "c"}], "+", 
     RowBox[{"5", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "b", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}], "+", 
        RowBox[{"a", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}], "+", 
        RowBox[{"b", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}]}]}]}],
  SequenceForm[
  "[", 23, "] ", ($CellContext`a + $CellContext`b + $CellContext`c)^3 <= (-3) \
$CellContext`a $CellContext`b $CellContext`c + 
    5 ($CellContext`a $CellContext`b ($CellContext`a + $CellContext`b) + \
$CellContext`a $CellContext`c ($CellContext`a + $CellContext`c) + \
$CellContext`b $CellContext`c ($CellContext`b + $CellContext`c))],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN49YLzkE3Dr9xBADcRK/D
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"e53f4abb-2349-429d-bbf2-c5d821b96ac9"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo8MP56Abh984AgDZtK92
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"9cec41cc-0201-467f-af12-c907ef66bc43"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY91/56Abh984AgDb1a+7
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"d1eb7578-bc7d-4ecf-bd20-0c2fdbd8303b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Proved \"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" inequalities out of \"\>", "\[InvisibleSpace]", 
   "23", "\[InvisibleSpace]", "\<\". Time=\"\>", "\[InvisibleSpace]", 
   "0.520821`"}],
  SequenceForm[
  "Proved ", 23, " inequalities out of ", 23, ". Time=", 0.520821],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNoxGbS9CNw28cAdKsrnc=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"f1e79984-dea5-4d53-aff8-0121d87d1ba8"],

Cell[BoxData[
 StyleBox["\<\"Chapter 2\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontSize->18,
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4w1el6Abh984AgDYDa8k
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"cda8967f-f7b6-4ae6-bd7f-68c2c43bfc1a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "A", "]"}], "+", 
     RowBox[{"Sin", "[", "B", "]"}], "+", 
     RowBox[{"Sin", "[", "C", "]"}]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"3", " ", 
      SqrtBox["3"]}], "2"]}]}],
  SequenceForm[
  "[", 24, "] ", Sin[$CellContext`A] + Sin[$CellContext`B] + Sin[C] <= 
   Rational[3, 2] 3^Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY4eoS9CNw28cAdXFrtw=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"fd47a358-d6af-44e3-a238-3661eb64e32f"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshpor41r0I3DbxwB2dyvZA==
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"636b5fbc-ed6b-4385-abe9-6b1942b1f42f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", "A", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "B", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "C", "]"}], "2"]}], "\[LessEqual]", 
    FractionBox["9", "4"]}]}],
  SequenceForm[
  "[", 25, "] ", Sin[$CellContext`A]^2 + Sin[$CellContext`B]^2 + Sin[C]^2 <= 
   Rational[9, 4]],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshqoz9U16MbhN44A2NOvRA==
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"fcedaed5-0fce-40f0-905a-d9f53c40a946"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN41RNt6Abh984AgDWxa7/
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"772f2d3a-3579-483d-a03e-7a6fe3784b15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "A", "]"}], "+", 
     RowBox[{"Sin", "[", "B", "]"}], "+", 
     RowBox[{"Sin", "[", "C", "]"}]}], "\[GreaterEqual]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "A"}], "]"}], "+", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "B"}], "]"}], "+", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "C"}], "]"}]}]}]}],
  SequenceForm[
  "[", 26, "] ", Sin[$CellContext`A] + Sin[$CellContext`B] + Sin[C] >= 
   Sin[2 $CellContext`A] + Sin[2 $CellContext`B] + Sin[2 C]],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY5+RW9CNw28cAdbMrwE=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"681c2cd9-a163-4e35-a275-7c26ccb7d5dc"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4xRJ96Abh984AgDWU67v
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"c3e22ff8-0bd6-442a-90e1-831dee2e027f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "A", "]"}], " ", 
     RowBox[{"Sin", "[", "B", "]"}], " ", 
     RowBox[{"Sin", "[", "C", "]"}]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"3", " ", 
      SqrtBox["3"]}], "8"]}]}],
  SequenceForm[
  "[", 27, "] ", Sin[$CellContext`A] Sin[$CellContext`B] Sin[C] <= 
   Rational[3, 8] 3^Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN40ol96Abh984AgDXOq8N
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"a4390e3c-8740-45ab-9901-7f108b171b45"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4y5+j6Abh984AgDXQ68M
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"9b841639-795a-42a3-bb5f-50b9f1671bc9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "<", 
    RowBox[{
     RowBox[{"Cos", "[", "A", "]"}], "+", 
     RowBox[{"Cos", "[", "B", "]"}], "+", 
     RowBox[{"Cos", "[", "C", "]"}]}]}]}],
  SequenceForm[
  "[", 28, "] ", 1 < Cos[$CellContext`A] + Cos[$CellContext`B] + Cos[C]],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY4mER9CNw28cAdVSrs8=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"8ee78a2a-1b76-4e4e-826d-6588044c1be6"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN40l5j6Abh984AgDYK68r
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"f8426665-3790-4c47-8a08-b9ca7755db95"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "A", "]"}], "+", 
     RowBox[{"Cos", "[", "B", "]"}], "+", 
     RowBox[{"Cos", "[", "C", "]"}]}], "\[LessEqual]", 
    FractionBox["3", "2"]}]}],
  SequenceForm[
  "[", 29, "] ", Cos[$CellContext`A] + Cos[$CellContext`B] + Cos[C] <= 
   Rational[3, 2]],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo5a6R9CNw28cAdNrrpQ=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"46980414-fc06-44ea-ab4d-4d4602a8a6b3"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4xR9j6Abh984AgDW868G
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"cbc3b384-a187-4e66-9d8d-04a836cc6d8a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "30", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["3", "4"], "\[LessEqual]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cos", "[", "A", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "B", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "C", "]"}], "2"]}]}]}],
  SequenceForm[
  "[", 30, "] ", Rational[3, 4] <= 
   Cos[$CellContext`A]^2 + Cos[$CellContext`B]^2 + Cos[C]^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN414zj6Abh984AgDYbK82
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"b4194b35-c90c-4b07-aa5c-7b8dcc03b4b3"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4287j6Abh984AgDalK98
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"23965e14-18be-4c52-a9b8-ed8233f611e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cos", "[", "A", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "B", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "C", "]"}], "2"]}], "<", "3"}]}],
  SequenceForm[
  "[", 31, "] ", Cos[$CellContext`A]^2 + Cos[$CellContext`B]^2 + Cos[C]^2 < 3],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNI5ObR9CNw28cAdMEros=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"3c67c409-8e46-4b7e-be17-a4639b2efb61"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshroLiPPoBuH3zgCANlur1Y=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"6dbf062b-5278-4182-9743-da6eb108bd7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "A", "]"}], " ", 
      RowBox[{"Cos", "[", "B", "]"}]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", "A", "]"}], " ", 
      RowBox[{"Cos", "[", "C", "]"}]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", "B", "]"}], " ", 
      RowBox[{"Cos", "[", "C", "]"}]}]}], "\[LessEqual]", 
    FractionBox["3", "4"]}]}],
  SequenceForm[
  "[", 32, "] ", 
   Cos[$CellContext`A] Cos[$CellContext`B] + Cos[$CellContext`A] Cos[C] + 
    Cos[$CellContext`B] Cos[C] <= Rational[3, 4]],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshoYDjaeQTcOv3EEANpcr3U=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"8b0d34a9-2ddb-4439-a6cd-5c886642168d"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY4S6V9CNw28cAdTnrsQ=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"f97cf970-24af-4102-a917-f4a0dd329e32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "A", "]"}], " ", 
     RowBox[{"Cos", "[", "B", "]"}], " ", 
     RowBox[{"Cos", "[", "C", "]"}]}], "\[LessEqual]", 
    FractionBox["1", "8"]}]}],
  SequenceForm[
  "[", 33, "] ", Cos[$CellContext`A] Cos[$CellContext`B] Cos[C] <= 
   Rational[1, 8]],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshroX32voBuH3zgCANfPryI=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"a548545f-1d57-4442-8a40-3fde15c88d0e"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshroHnOvoBuH3zgCANUHrso=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"c8add4cf-3993-4132-8fab-9ab14266e072"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "34", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "A", "]"}], " ", 
     RowBox[{"Cos", "[", "B", "]"}], " ", 
     RowBox[{"Cos", "[", "C", "]"}]}], "\[LessEqual]", 
    RowBox[{
     FractionBox["1", "24"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         RowBox[{"A", "-", "B"}], "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         RowBox[{"A", "-", "C"}], "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         RowBox[{"B", "-", "C"}], "]"}], "2"]}], ")"}]}]}]}],
  SequenceForm[
  "[", 34, "] ", Cos[$CellContext`A] Cos[$CellContext`B] Cos[C] <= 
   Rational[1, 24] (Cos[$CellContext`A - $CellContext`B]^2 + 
     Cos[$CellContext`A - C]^2 + Cos[$CellContext`B - C]^2)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshrof3uvoBuH3zgCANRPrrQ=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"c4e9f1a3-7e37-4be6-8d51-d812cc9b9d4a"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN45eHPkE3Dr9xBADe6bAc
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"b5a17163-4ccf-4141-9ec6-f2ce4005e0a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "35", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"Cot", "[", "A", "]"}], "+", 
     RowBox[{"Cot", "[", "B", "]"}], "+", 
     RowBox[{"Cot", "[", "C", "]"}]}], "\[GreaterEqual]", 
    SqrtBox["3"]}]}],
  SequenceForm[
  "[", 35, "] ", Cot[$CellContext`A] + Cot[$CellContext`B] + Cot[C] >= 
   3^Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY8Irn6Abh984AgDaiK+R
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"9fb55b7b-3c42-4f0f-b414-dce94a5fe8bb"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN48+9fkE3Dr9xBADeIa//
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"69024184-4e4d-497a-a6dc-d4b17cd683f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cot", "[", "A", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Cot", "[", "B", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Cot", "[", "C", "]"}], "2"]}], "\[GreaterEqual]", "1"}]}],
  SequenceForm[
  "[", 36, "] ", Cot[$CellContext`A]^2 + Cot[$CellContext`B]^2 + Cot[C]^2 >= 
   1],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY9cxv6Abh984AgDa6K+Z
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"e8d435c8-293e-415b-8af1-1933155ad691"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4yu9wKAbh984AgDZ0q9k
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"92c2889e-843c-4b78-8c00-df645c7b79cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "37", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"Csc", "[", "A", "]"}], "+", 
     RowBox[{"Csc", "[", "B", "]"}], "+", 
     RowBox[{"Csc", "[", "C", "]"}]}], "\[GreaterEqual]", 
    RowBox[{"2", " ", 
     SqrtBox["3"]}]}]}],
  SequenceForm[
  "[", 37, "] ", Csc[$CellContext`A] + Csc[$CellContext`B] + Csc[C] >= 
   2 3^Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY555YNCNw28cAdYxrvE=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"a58e9b9b-95fc-4ddd-b084-1b4585561f66"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN45rdQUE3Dr9xBADbw6+0
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"b6ab20b0-25e3-49a9-b077-7131567c4f87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "38", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", "A", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Csc", "[", "B", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Csc", "[", "C", "]"}], "2"]}], "\[GreaterEqual]", "4"}]}],
  SequenceForm[
  "[", 38, "] ", Csc[$CellContext`A]^2 + Csc[$CellContext`B]^2 + Csc[C]^2 >= 
   4],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY8SRoKAbh984AgDZYq9p
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"d7fd8c78-f7a7-431a-9410-753dfe4002f3"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNI/eR4KAbh984AgDXAK8d
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"6be9eb09-648a-4d7c-94b8-e6bb9b22dfee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "39", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"Cos", "[", "A", "]"}], " ", 
        RowBox[{"Cos", "[", "B", "]"}], " ", 
        RowBox[{"Cos", "[", "C", "]"}]}]}], ")"}], " ", 
     RowBox[{"Csc", "[", "A", "]"}], " ", 
     RowBox[{"Csc", "[", "B", "]"}], " ", 
     RowBox[{"Csc", "[", "C", "]"}]}], "\[GreaterEqual]", 
    SqrtBox["3"]}]}],
  SequenceForm[
  "[", 39, "] ", (1 + Cos[$CellContext`A] Cos[$CellContext`B] Cos[C]) 
    Csc[$CellContext`A] Csc[$CellContext`B] Csc[C] >= 3^Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshrorjPBQTcOv3EEAN3gr/o=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"339dfb68-fe66-464a-9922-6ecdd19dce3a"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY9fVkKAbh984AgDbda+u
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"56f623f2-e6ee-4f53-bec6-d60d36b48749"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "40", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Cot", "[", "A", "]"}], "+", 
       RowBox[{"Cot", "[", "B", "]"}], "+", 
       RowBox[{"Cot", "[", "C", "]"}]}], ")"}]}], "\[GreaterEqual]", 
    RowBox[{
     RowBox[{"Csc", "[", "A", "]"}], "+", 
     RowBox[{"Csc", "[", "B", "]"}], "+", 
     RowBox[{"Csc", "[", "C", "]"}]}]}]}],
  SequenceForm[
  "[", 40, "] ", 2 (Cot[$CellContext`A] + Cot[$CellContext`B] + Cot[C]) >= 
   Csc[$CellContext`A] + Csc[$CellContext`B] + Csc[C]],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN46F7IUE3Dr9xBADddK/v
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"6f265d4c-2bbe-4d0a-adb3-a07e6a0438c1"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY/6zkKAbh984AgDbFK+k
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"e65cf0ce-4487-429b-a127-37a4d1738c39"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY9C7kKAbh984AgDaZK+P
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"5cab396c-1a4c-4808-8cb6-1be5d033800f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Proved \"\>", "\[InvisibleSpace]", "40", 
   "\[InvisibleSpace]", "\<\" inequalities out of \"\>", "\[InvisibleSpace]", 
   "40", "\[InvisibleSpace]", "\<\". Time=\"\>", "\[InvisibleSpace]", 
   "0.499973`"}],
  SequenceForm[
  "Proved ", 40, " inequalities out of ", 40, ". Time=", 0.499973],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshpoz5eQoBuH3zgCAN+GsDQ=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"270b94aa-68e6-46e5-b61c-41b16873dbf9"],

Cell[BoxData[
 StyleBox["\<\"Chapter 4\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontSize->18,
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo+GfkKAbh984AgDZvq98
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"edbd2fbb-2318-472c-b5cf-04209814d409"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "41", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"3", " ", 
     SqrtBox["3"], " ", "K"}]}]}],
  SequenceForm["[", 41, "] ", $CellContext`s^2 >= 3 3^Rational[1, 2] K],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshoYbsyhQTcOv3EEANgdryk=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"b983cc54-6d73-4a4e-b8ca-5755fd2d625d"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo9K70KAbh984AgDY6q9g
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"ede8d97a-79d6-4683-89ca-53497f155b95"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "42", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", "-", "c"}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "+", "c"}], ")"}], "2"]}], ")"}]}], "+", 
     RowBox[{"3", " ", 
      SqrtBox["3"], " ", "K"}]}]}]}],
  SequenceForm[
  "[", 42, "] ", $CellContext`s^2 >= 
   Rational[1, 
       2] (($CellContext`a - $CellContext`b)^2 + ($CellContext`b - \
$CellContext`c)^2 + (-$CellContext`a + $CellContext`c)^2) + 
    3 3^Rational[1, 2] K],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshro3++hQTcOv3EEAN2Jr/U=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"4f65030a-a9a6-4b69-b78f-2c78c7eef7ab"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN45W3YUE3Dr9xBADeebAS
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"b0fe351d-bf42-4638-85fe-094376ef3752"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "43", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[GreaterEqual]", 
    RowBox[{"4", " ", 
     SqrtBox["3"], " ", "K"}]}]}],
  SequenceForm[
  "[", 43, "] ", $CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2 >= 
   4 3^Rational[1, 2] K],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo/+3sKAbh984AgDakK+W
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"c0ccaf75-b81f-4fcf-bd14-7de44f892534"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNozhDRNCNw28cAdIirmo=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"48e497b3-5996-4b05-a841-8a7a58857b32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "44", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "b"}], "+", 
     RowBox[{"a", " ", "c"}], "+", 
     RowBox[{"b", " ", "c"}]}], "\[GreaterEqual]", 
    RowBox[{"4", " ", 
     SqrtBox["3"], " ", "K"}]}]}],
  SequenceForm[
  "[", 44, "] ", $CellContext`a $CellContext`b + $CellContext`a \
$CellContext`c + $CellContext`b $CellContext`c >= 4 3^Rational[1, 2] K],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4wGOiKAbh984AgDXoq8b
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"2c2a9d66-6d3d-48a5-8189-5ac874a54494"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshroD8GIoBuH3zgCANIhrmw=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"71816bcd-e1e5-4092-afd3-19e3ba0f1e01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "45", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "b"}], "+", 
     RowBox[{"a", " ", "c"}], "+", 
     RowBox[{"b", " ", "c"}]}], "\[GreaterEqual]", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", "-", "c"}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "+", "c"}], ")"}], "2"]}], ")"}]}], "+", 
     RowBox[{"4", " ", 
      SqrtBox["3"], " ", "K"}]}]}]}],
  SequenceForm[
  "[", 45, "] ", $CellContext`a $CellContext`b + $CellContext`a \
$CellContext`c + $CellContext`b $CellContext`c >= 
   Rational[1, 
       2] (($CellContext`a - $CellContext`b)^2 + ($CellContext`b - \
$CellContext`c)^2 + (-$CellContext`a + $CellContext`c)^2) + 
    4 3^Rational[1, 2] K],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY5tkRNCNw28cAdZJrvI=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"799afa37-b2a6-4910-b1d0-3394c80687f7"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4z3FiKAbh984AgDZQa9S
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"2c95d406-76b9-44d5-af86-7858b6e80106"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "46", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "c"}], ")"}], "2"], "+", 
     RowBox[{"4", " ", 
      SqrtBox["3"], " ", "K"}]}], "\[LessEqual]", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}]}]}],
  SequenceForm[
  "[", 46, "] ", ($CellContext`a - $CellContext`b)^2 + ($CellContext`b - \
$CellContext`c)^2 + (-$CellContext`a + $CellContext`c)^2 + 
    4 3^Rational[1, 2] 
     K <= $CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY6pmRNCNw28cAdWxruE=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"04c9b5f4-f877-404d-8e56-e3e6a10ce3bf"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4zyJyKAbh984AgDXCK8K
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"1be17b55-59d6-403e-b113-988c53ba5859"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "47", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", "-", "c"}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "+", "c"}], ")"}], "2"]}], ")"}]}], "+", 
     RowBox[{"4", " ", 
      SqrtBox["3"], " ", "K"}]}]}]}],
  SequenceForm[
  "[", 47, "] ", $CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2 <= 
   3 (($CellContext`a - $CellContext`b)^2 + ($CellContext`b - \
$CellContext`c)^2 + (-$CellContext`a + $CellContext`c)^2) + 
    4 3^Rational[1, 2] K],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4zflyKAbh984AgDaFa9t
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"2da138da-bea8-4c71-8ff2-e48f2a0ffb7b"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo5Z+VNCNw28cAdQPrq4=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"11387d9c-5af7-4235-ab3c-c6eb60226ccd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "48", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", "-", "c"}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "+", "c"}], ")"}], "2"]}], ")"}]}], "+", 
     RowBox[{"12", " ", 
      SqrtBox["3"], " ", "K"}]}], "\[LessEqual]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", "b", "+", "c"}], ")"}], "2"]}]}],
  SequenceForm[
  "[", 48, "] ", 
   2 (($CellContext`a - $CellContext`b)^2 + ($CellContext`b - \
$CellContext`c)^2 + (-$CellContext`a + $CellContext`c)^2) + 
    12 3^Rational[1, 2] 
     K <= ($CellContext`a + $CellContext`b + $CellContext`c)^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY4lFVNCNw28cAdaerwE=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"36474eba-0bde-468e-a834-fb531e441055"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo4NZdNCNw28cAdT2rsw=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"c82ce94e-a228-4e1d-a5fd-c35da73fd855"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "49", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", "b", "+", "c"}], ")"}], "2"], "\[LessEqual]", 
    RowBox[{
     RowBox[{"8", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", "-", "c"}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "+", "c"}], ")"}], "2"]}], ")"}]}], "+", 
     RowBox[{"12", " ", 
      SqrtBox["3"], " ", "K"}]}]}]}],
  SequenceForm[
  "[", 49, "] ", ($CellContext`a + $CellContext`b + $CellContext`c)^2 <= 
   8 (($CellContext`a - $CellContext`b)^2 + ($CellContext`b - \
$CellContext`c)^2 + (-$CellContext`a + $CellContext`c)^2) + 
    12 3^Rational[1, 2] K],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo5xDdNCNw28cAdQsrrQ=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"17eedcc1-23f4-4b7d-b7b2-b7953e89a1a0"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo5NXdNCNw28cAdWSruI=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"f83322e0-817c-4531-9637-7ba9b1ef041c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "50", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "4"], "+", 
     SuperscriptBox["b", "4"], "+", 
     SuperscriptBox["c", "4"]}], "\[GreaterEqual]", 
    RowBox[{"16", " ", 
     SuperscriptBox["K", "2"]}]}]}],
  SequenceForm[
  "[", 50, "] ", $CellContext`a^4 + $CellContext`b^4 + $CellContext`c^4 >= 
   16 K^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNI3dwdNCNw28cAdQZrrQ=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"fa4647c7-134e-4d31-8273-a629212ca0ad"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNI7drTNCNw28cAdO9rqc=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"4d92d512-8e24-4d58-950b-5856b839d184"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "51", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "4"], "+", 
     SuperscriptBox["b", "4"], "+", 
     SuperscriptBox["c", "4"]}], "\[GreaterEqual]", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "-", "b"}], ")"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", "-", "c"}], ")"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "+", "c"}], ")"}], "2"]}], ")"}], "2"]}], "+", 
     RowBox[{"4", " ", 
      SqrtBox["3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", "-", "c"}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "+", "c"}], ")"}], "2"]}], ")"}], " ", "K"}], 
     "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["K", "2"]}]}]}]}],
  SequenceForm[
  "[", 51, "] ", $CellContext`a^4 + $CellContext`b^4 + $CellContext`c^4 >= 
   Rational[1, 
       2] (($CellContext`a - $CellContext`b)^2 + ($CellContext`b - \
$CellContext`c)^2 + (-$CellContext`a + $CellContext`c)^2)^2 + 
    4 3^Rational[
       1, 2] (($CellContext`a - $CellContext`b)^2 + ($CellContext`b - \
$CellContext`c)^2 + (-$CellContext`a + $CellContext`c)^2) K + 16 K^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo0JgTNCNw28cAdS5rsg=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"ca30821c-921c-48ec-8d0c-bd0f444bc53b"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY9jc+KAbh984AgDYj69N
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"e4a41945-4b7e-4b4c-891a-d1f8617857bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "52", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "+", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}]}], "\[GreaterEqual]", 
    RowBox[{"16", " ", 
     SuperscriptBox["K", "2"]}]}]}],
  SequenceForm[
  "[", 52, "] ", $CellContext`a^2 $CellContext`b^2 + $CellContext`a^2 \
$CellContext`c^2 + $CellContext`b^2 $CellContext`c^2 >= 16 K^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN48Nl8UE3Dr9xBADdJq/h
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"7a34cd54-ac0a-47d5-99fb-95cda825f958"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshron/PxQTcOv3EEANsNr6M=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"fc3b0bf2-6809-4c4b-ad8b-3758f5f4f16a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "53", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"4", " ", 
     SqrtBox["3"], " ", "K"}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"9", " ", "a", " ", "b", " ", "c"}], 
     RowBox[{"a", "+", "b", "+", "c"}]]}]}],
  SequenceForm[
  "[", 53, "] ", 4 3^Rational[1, 2] K <= 
   9 $CellContext`a $CellContext`b $CellContext`c/($CellContext`a + \
$CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo9aN+KAbh984AgDYzK9c
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"d0a8adba-3c6c-4d2e-9de1-f7277b0f769c"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN45/NCUE3Dr9xBADeX7AK
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"69d26d47-c1c5-470f-8e51-5554dfaa0d9a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "54", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"64", " ", 
      SuperscriptBox["K", "3"]}], 
     RowBox[{"3", " ", 
      SqrtBox["3"]}]]}]}],
  SequenceForm[
  "[", 54, "] ", $CellContext`a^2 $CellContext`b^2 $CellContext`c^2 >= 
   Rational[64, 3] 3^Rational[-1, 2] K^3],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN45s9CUE3Dr9xBADeHrAD
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"8d3ae777-1953-42e0-ac47-074441cfa17c"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN49LniUE3Dr9xBADdGa/o
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"20bae36b-3d2a-4b41-aea8-1192c321cede"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "55", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox["1", "12"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "b"}], "+", 
       RowBox[{"a", " ", "c"}], "+", 
       RowBox[{"b", " ", "c"}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "b"}], "+", 
          RowBox[{"a", " ", "c"}], "+", 
          RowBox[{"b", " ", "c"}]}], ")"}]}], "-", 
       RowBox[{
        FractionBox["5", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], "\[LessEqual]", 
    SuperscriptBox["K", "2"]}]}],
  SequenceForm[
  "[", 55, "] ", 
   Rational[1, 
      12] ($CellContext`a $CellContext`b + $CellContext`a $CellContext`c + \
$CellContext`b $CellContext`c + 
     Rational[1, 
        2] (-$CellContext`a^2 - $CellContext`b^2 - $CellContext`c^2)) (
     3 ($CellContext`a $CellContext`b + $CellContext`a $CellContext`c + \
$CellContext`b $CellContext`c) + 
     Rational[-5, 
        2] ($CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2)) <= K^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN453PiUE3Dr9xBADfJbAr
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"a7043c81-7e1e-4140-bbbc-e65f501cea80"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo49YctCNw28cAdSmrsA=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"ef0a22c5-597b-44ff-a442-b7038472dec0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "56", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["K", "2"], "\[LessEqual]", 
    RowBox[{
     FractionBox["1", "12"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "b"}], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], "2"]}]}]}],
  SequenceForm[
  "[", 56, "] ", K^2 <= 
   Rational[1, 
      12] ($CellContext`a $CellContext`b + $CellContext`a $CellContext`c + \
$CellContext`b $CellContext`c + 
      Rational[1, 
         2] (-$CellContext`a^2 - $CellContext`b^2 - $CellContext`c^2))^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshrof4XkoBuH3zgCANQMrq4=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"b15ebeeb-38ed-4a0a-aa17-22f50d4d1601"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshqonjUl6MbhN44A2F2vNQ==
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"43801906-c51c-4a5f-81ac-5b65af722c40"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNIx9fStCNw28cAdKErns=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"b8f51495-cb66-4a5b-933e-a03f43b7e636"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Proved \"\>", "\[InvisibleSpace]", "56", 
   "\[InvisibleSpace]", "\<\" inequalities out of \"\>", "\[InvisibleSpace]", 
   "56", "\[InvisibleSpace]", "\<\". Time=\"\>", "\[InvisibleSpace]", 
   "0.449924`"}],
  SequenceForm[
  "Proved ", 56, " inequalities out of ", 56, ". Time=", 0.449924],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4y7RlKAbh984AgDYFa8u
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"d38bab0b-527d-4fa9-a59c-5a58b71f89cd"],

Cell[BoxData[
 StyleBox["\<\"Chapter 5\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontSize->18,
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4xaFlKAbh984AgDYMq8z
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"4b0662b4-44c2-4289-80ab-984bea24ba93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "57", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "r"}], "\[LessEqual]", "R"}]}],
  SequenceForm["[", 57, "] ", 2 $CellContext`r <= $CellContext`R],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY7JGStCNw28cAdXiruo=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"3b1cb84a-98dd-45c7-9b35-5bd48245926e"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4zv9lKAbh984AgDaa698
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"c16cf3a1-0761-4af1-9c1f-b7a83f4faa12"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "58", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a", "+", "b", "+", "c"}], "\[LessEqual]", 
    RowBox[{"3", " ", 
     SqrtBox["3"], " ", "R"}]}]}],
  SequenceForm[
  "[", 58, "] ", $CellContext`a + $CellContext`b + $CellContext`c <= 
   3 3^Rational[1, 2] $CellContext`R],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshoYHuYpQTcOv3EEANTTrso=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"e5ea84c6-abdc-4c0c-a1a9-3224bb08b8f7"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo1JcStCNw28cAdVUrt8=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"4efe4af8-08b2-45fd-9aea-4a4955a013b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "59", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{"s", "\[LessEqual]", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        RowBox[{"3", " ", 
         SqrtBox["3"]}]}], ")"}], " ", "r"}], "+", 
     RowBox[{"2", " ", "R"}]}]}]}],
  SequenceForm[
  "[", 59, "] ", $CellContext`s <= (-4 + 3 3^Rational[1, 2]) $CellContext`r + 
    2 $CellContext`R],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY21GStCNw28cAdhyr0Q=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"16dbb471-e17f-4568-8516-2d8444d1aaf4"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN41vetKAbh984AgDZga9b
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"07489e92-79f4-4a62-aca6-237c0bae018a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "60", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"9", " ", "r", " ", 
     RowBox[{"(", 
      RowBox[{"r", "+", 
       RowBox[{"4", " ", "R"}]}], ")"}]}], "\[LessEqual]", 
    RowBox[{"3", " ", 
     SuperscriptBox["s", "2"]}]}]}],
  SequenceForm[
  "[", 60, "] ", 9 $CellContext`r ($CellContext`r + 4 $CellContext`R) <= 
   3 $CellContext`s^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4wGJtKAbh984AgDYZq85
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"e07f8fd4-c639-406c-8184-a5a729c28802"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4x7G9KAbh984AgDXq68f
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"e2e6477c-ee77-4286-9a11-cc6deaa8db08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "61", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"3", " ", 
     SuperscriptBox["s", "2"]}], "\[LessEqual]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"r", "+", 
       RowBox[{"4", " ", "R"}]}], ")"}], "2"]}]}],
  SequenceForm[
  "[", 61, "] ", 3 $CellContext`s^2 <= ($CellContext`r + 4 $CellContext`R)^2],
  
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNoyhvetCNw28cAdLHroQ=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"866419d2-7614-45c5-a7a9-0cfe15478611"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN42XR9KAbh984AgDY769K
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"ddd7ee1f-5149-406d-a0d7-a8569b0d19f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "62", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"6", " ", "r", " ", 
     RowBox[{"(", 
      RowBox[{"r", "+", 
       RowBox[{"4", " ", "R"}]}], ")"}]}], "\[LessEqual]", 
    RowBox[{"2", " ", 
     SuperscriptBox["s", "2"]}]}]}],
  SequenceForm[
  "[", 62, "] ", 6 $CellContext`r ($CellContext`r + 4 $CellContext`R) <= 
   2 $CellContext`s^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN40uZ9KAbh984AgDZ0K9n
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"8523bf09-ee7f-4a38-83ea-a192f94032dc"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshpovkp60I3DbxwB10CvFg==
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"84b462ed-8a9e-41fc-9a76-bd6ecdef4ab8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "63", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["s", "2"]}], "\[LessEqual]", 
    RowBox[{
     SuperscriptBox["R", "2"], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"2", " ", "R"}]}], ")"}], "2"]}]}]}]}],
  SequenceForm[
  "[", 63, "] ", 
   2 $CellContext`s^2 <= $CellContext`R^2 + 
    2 ($CellContext`r + 2 $CellContext`R)^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4wad9KAbh984AgDYeK8+
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"65be1d4c-164d-41e6-81b7-1b2a4063823d"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN412T9KAbh984AgDaGK9z
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"28d3fc87-254f-4836-8007-81f9f9517299"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "64", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "r"}], "+", 
       RowBox[{"2", " ", "R"}]}], ")"}], " ", 
     SuperscriptBox["s", "2"]}], "\[LessEqual]", 
    RowBox[{"R", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"4", " ", "R"}]}], ")"}], "2"]}]}]}],
  SequenceForm[
  "[", 64, "] ", 
   2 (-$CellContext`r + 
     2 $CellContext`R) $CellContext`s^2 <= $CellContext`R ($CellContext`r + 
      4 $CellContext`R)^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY5hNetCNw28cAdYYrvQ=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"9edd6487-31ed-46c8-8275-2ffbd8068037"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNI4NORtCNw28cAdL+ro8=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"7874987a-a4aa-4d73-b1a0-c7f1bce93140"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "5"}], " ", "r"}], "+", 
       RowBox[{"16", " ", "R"}]}], ")"}]}], "\[LessEqual]", 
    SuperscriptBox["s", "2"]}]}],
  SequenceForm[
  "[", 65, "] ", $CellContext`r ((-5) $CellContext`r + 
     16 $CellContext`R) <= $CellContext`s^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshponmlG0I3DbxwB1A2usg==
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"17da6dcd-0b24-476d-b7e5-9b746699be6c"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo5ZtRtCNw28cAdTFrso=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"13344c42-d132-4dad-bada-c6258bc9d91d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "66", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    RowBox[{
     RowBox[{"3", " ", 
      SuperscriptBox["r", "2"]}], "+", 
     RowBox[{"4", " ", "r", " ", "R"}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["R", "2"]}]}]}]}],
  SequenceForm[
  "[", 66, "] ", $CellContext`s^2 <= 
   3 $CellContext`r^2 + 4 $CellContext`r $CellContext`R + 4 $CellContext`R^2],
  
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo49LRtCNw28cAdYGrvM=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"6006f8e6-f042-489e-8959-e37eaf5c51cf"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshoYXgaZQTcOv3EEANTQrso=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"9dc40e50-c436-46d3-87a1-99624d39313a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"27", " ", 
     SuperscriptBox["r", "2"]}]}]}],
  SequenceForm["[", 67, "] ", $CellContext`s^2 >= 27 $CellContext`r^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY5hVZtCNw28cAdYWrvQ=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"f8daca89-8a79-4f94-a626-2357d049b3e3"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4x6nzKAbh984AgDZfq9i
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"c0491f66-47d5-46b3-a07a-aa2aa0247441"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "68", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["s", "2"]}], "\[GreaterEqual]", 
    RowBox[{"27", " ", "r", " ", "R"}]}]}],
  SequenceForm[
  "[", 68, "] ", 2 $CellContext`s^2 >= 27 $CellContext`r $CellContext`R],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4wbPzKAbh984AgDZT69d
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"5c25eb66-818a-4123-ae54-2673a2c1e82c"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN42HLrKAbh984AgDZfa9h
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"0f8c13b4-c833-4f4a-a2d6-e8e2673deb96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "69", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"36", " ", 
     SuperscriptBox["r", "2"]}], "\[LessEqual]", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}]}]}],
  SequenceForm[
  "[", 69, "] ", 
   36 $CellContext`r^2 <= $CellContext`a^2 + $CellContext`b^2 + \
$CellContext`c^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4x6nrKAbh984AgDZhK9j
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"65c5e315-00c3-49f7-bc06-80c97819c141"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN45GsrKAbh984AgDa3K+T
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"95ee82eb-cd65-43ac-b359-ed96c46aabfd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "70", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[LessEqual]", 
    RowBox[{"9", " ", 
     SuperscriptBox["R", "2"]}]}]}],
  SequenceForm[
  "[", 70, "] ", $CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2 <= 
   9 $CellContext`R^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN45+SrKAbh984AgDc4q/V
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"5cc1913e-3657-4132-957f-988f8446a550"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo35cdtCNw28cAdXmrvM=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"7637ed5a-dc1e-44a1-b6ea-07cd9c7f4e37"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "71", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "12"}], " ", 
      SuperscriptBox["r", "2"]}], "+", 
     RowBox[{"24", " ", "r", " ", "R"}]}], "\[LessEqual]", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}]}]}],
  SequenceForm[
  "[", 71, "] ", (-12) $CellContext`r^2 + 
    24 $CellContext`r $CellContext`R <= $CellContext`a^2 + $CellContext`b^2 + \
$CellContext`c^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY1FGdtCNw28cAdhEr0A=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"3ad3e1c8-865c-4b9d-a8d0-f0923d59b4ed"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN45aC7KAbh984AgDajK+K
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"739906c2-e457-4a83-af01-f1baa6534ee8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "72", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["r", "2"]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["R", "2"]}]}]}]}],
  SequenceForm[
  "[", 72, "] ", $CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2 <= 
   4 $CellContext`r^2 + 8 $CellContext`R^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo0BFdtCNw28cAdWkru4=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"e428504e-aab9-4f3a-a675-a7a5075d91d0"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN44767KAbh984AgDbFa+d
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"96a2d639-35e7-4a8a-a606-c32aa16aa87e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "73", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"36", " ", 
     SuperscriptBox["r", "2"]}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"a", " ", "b"}], "+", 
     RowBox[{"a", " ", "c"}], "+", 
     RowBox[{"b", " ", "c"}]}]}]}],
  SequenceForm[
  "[", 73, "] ", 
   36 $CellContext`r^2 <= $CellContext`a $CellContext`b + $CellContext`a \
$CellContext`c + $CellContext`b $CellContext`c],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY2B7dtCNw28cAdgVrz4=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"22f93232-575c-4cb1-b99c-eb52bf2de270"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo1VZTtCNw28cAdbsrxc=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"f5252c5d-2c9c-4f67-8087-5515682c1d65"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "74", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "b"}], "+", 
     RowBox[{"a", " ", "c"}], "+", 
     RowBox[{"b", " ", "c"}]}], "\[LessEqual]", 
    RowBox[{"9", " ", 
     SuperscriptBox["R", "2"]}]}]}],
  SequenceForm[
  "[", 74, "] ", $CellContext`a $CellContext`b + $CellContext`a \
$CellContext`c + $CellContext`b $CellContext`c <= 9 $CellContext`R^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo3NDTtCNw28cAdd6ryo=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"c2c814d0-5dae-4adf-932b-aacf75474b58"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN476OnKAbh984AgDbiq+t
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"b767ba34-6dad-4220-9ebf-c4a45bd01eaf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "75", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"4", " ", "r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "r"}], "+", 
       RowBox[{"5", " ", "R"}]}], ")"}]}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"a", " ", "b"}], "+", 
     RowBox[{"a", " ", "c"}], "+", 
     RowBox[{"b", " ", "c"}]}]}]}],
  SequenceForm[
  "[", 75, "] ", 
   4 $CellContext`r (-$CellContext`r + 
     5 $CellContext`R) <= $CellContext`a $CellContext`b + $CellContext`a \
$CellContext`c + $CellContext`b $CellContext`c],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY8iEnKAbh984AgDYcq9L
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"a9913aad-0078-4b29-9f4e-05db5a1ca5a2"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshrovlk5QTcOv3EEANbYrxk=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"104ace96-71c8-47e2-b3cb-ed254a905e50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "76", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "b"}], "+", 
     RowBox[{"a", " ", "c"}], "+", 
     RowBox[{"b", " ", "c"}]}], "\[LessEqual]", 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"r", "+", "R"}], ")"}], "2"]}]}]}],
  SequenceForm[
  "[", 76, "] ", $CellContext`a $CellContext`b + $CellContext`a \
$CellContext`c + $CellContext`b $CellContext`c <= 
   4 ($CellContext`r + $CellContext`R)^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY+2inKAbh984AgDaOK+G
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"72beaa0d-1bcd-4bfa-b954-79de15596872"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNI9/anKAbh984AgDXDa8i
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"9a73e329-4551-425f-98ed-76d551e787b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "77", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"36", " ", 
     SuperscriptBox["r", "2"]}], "\[LessEqual]", 
    RowBox[{"4", " ", "r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "r"}], "+", 
       RowBox[{"5", " ", "R"}]}], ")"}]}]}]}],
  SequenceForm[
  "[", 77, "] ", 36 $CellContext`r^2 <= 
   4 $CellContext`r (-$CellContext`r + 5 $CellContext`R)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshrI35oTdOPwG0cA2LWvWA==
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"20b21339-e04f-4fe4-9d15-6d770aa947b6"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4657OUE3Dr9xBADdxK//
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"7753070b-2f01-4461-a72b-67907479961a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "78", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"4", " ", "r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "r"}], "+", 
       RowBox[{"5", " ", "R"}]}], ")"}]}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"a", " ", "b"}], "+", 
     RowBox[{"a", " ", "c"}], "+", 
     RowBox[{"b", " ", "c"}]}]}]}],
  SequenceForm[
  "[", 78, "] ", 
   4 $CellContext`r (-$CellContext`r + 
     5 $CellContext`R) <= $CellContext`a $CellContext`b + $CellContext`a \
$CellContext`c + $CellContext`b $CellContext`c],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY9zLnKAbh984AgDbMa+u
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"2e13778b-19c1-4f17-8606-dbabaf97c515"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN46NTuUE3Dr9xBADefrAU
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"43a0a6c4-1f06-45a5-ae9a-55eff2c12b43"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "79", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"r", "+", "R"}], ")"}], "2"]}], "\[LessEqual]", 
    RowBox[{"9", " ", 
     SuperscriptBox["R", "2"]}]}]}],
  SequenceForm[
  "[", 79, "] ", 4 ($CellContext`r + $CellContext`R)^2 <= 9 $CellContext`R^2],
  
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo8qV3KAbh984AgDY1K9g
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"361db7cb-4430-4c4e-bdf8-bb221579e914"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo8ed3KAbh984AgDaLK+M
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"6e3275e0-a040-4f2a-9ec7-c50574ecdf5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "80", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "s"}], ")"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "b"}], "+", "s"}], ")"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "c"}], "+", "s"}], ")"}]}]}], "\[LessEqual]", 
    RowBox[{"9", " ", "r", " ", "R"}]}]}],
  SequenceForm[
  "[", 80, "] ", $CellContext`a (-$CellContext`a + $CellContext`s) + \
$CellContext`b (-$CellContext`b + $CellContext`s) + $CellContext`c \
(-$CellContext`c + $CellContext`s) <= 9 $CellContext`r $CellContext`R],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4/vHuUE3Dr9xBADflbA6
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"d9be16c8-2810-4555-8129-d91f8a62d371"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshoYXm9yg24cfuMIANoMr4o=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"68eb6cc9-e84b-4635-af20-e7c7e46da188"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "81", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a", " ", "b", " ", "c"}], "\[LessEqual]", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "16"}], "+", 
        RowBox[{"12", " ", 
         SqrtBox["3"]}]}], ")"}], " ", 
      SuperscriptBox["r", "2"], " ", "R"}], "+", 
     RowBox[{"8", " ", "r", " ", 
      SuperscriptBox["R", "2"]}]}]}]}],
  SequenceForm[
  "[", 81, "] ", $CellContext`a $CellContext`b $CellContext`c <= (-16 + 
      12 3^Rational[1, 2]) $CellContext`r^2 $CellContext`R + 
    8 $CellContext`r $CellContext`R^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshpo35fcoBuH3zgCANoEr4o=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"2f1282fb-794f-4861-abfa-c498c6955c8c"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY8GPvKAbh984AgDcNq/R
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"dc90e250-7566-4bbf-913c-64767cd2a53f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "82", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     SqrtBox["3"], "R"], "\[LessEqual]", 
    RowBox[{
     FractionBox["1", "a"], "+", 
     FractionBox["1", "b"], "+", 
     FractionBox["1", "c"]}]}]}],
  SequenceForm[
  "[", 82, "] ", 
   3^Rational[
      1, 2]/$CellContext`R <= $CellContext`a^(-1) + $CellContext`b^(-1) + \
$CellContext`c^(-1)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4z/G/KAbh984AgDZ669p
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"f6a2129e-faa3-4d0c-8035-73cd8b0e1d08"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4xuu/KAbh984AgDZmq9g
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"8fee6cbb-06d4-45cc-8405-327b1d960b72"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "83", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox["1", "a"], "+", 
     FractionBox["1", "b"], "+", 
     FractionBox["1", "c"]}], "\[LessEqual]", 
    FractionBox[
     SqrtBox["3"], 
     RowBox[{"2", " ", "r"}]]}]}],
  SequenceForm[
  "[", 83, "] ", $CellContext`a^(-1) + $CellContext`b^(-1) + \
$CellContext`c^(-1) <= Rational[1, 2] 3^Rational[1, 2]/$CellContext`r],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshrofqH8oBuH3zgCANbSrwg=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"709d5f69-1600-4d78-9b6b-682a63d2de03"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNI5thYdCNw28cAdOHrqM=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"35e5e39f-d857-49e3-8e67-d0e3b0ba4f9a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "84", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"3", " ", 
      SqrtBox["3"]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"r", "+", "R"}], ")"}]}]], "\[LessEqual]", 
    RowBox[{
     FractionBox["1", "a"], "+", 
     FractionBox["1", "b"], "+", 
     FractionBox["1", "c"]}]}]}],
  SequenceForm[
  "[", 84, "] ", 
   Rational[3, 2] 
    3^Rational[
      1, 2]/($CellContext`r + $CellContext`R) <= $CellContext`a^(-1) + \
$CellContext`b^(-1) + $CellContext`c^(-1)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY75VYdCNw28cAdcOrxU=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"cf1e047a-42fe-40e3-b2c6-79403cd7dd1a"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN49TtxUE3Dr9xBADbta+6
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"2c141518-e1e5-4f62-a805-cc5e6e23099a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "85", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox["R", "2"]], "\[LessEqual]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", " ", "b"}]], "+", 
     FractionBox["1", 
      RowBox[{"a", " ", "c"}]], "+", 
     FractionBox["1", 
      RowBox[{"b", " ", "c"}]]}]}]}],
  SequenceForm[
  "[", 85, "] ", $CellContext`R^(-2) <= $CellContext`a^(-1)/$CellContext`b + \
$CellContext`a^(-1)/$CellContext`c + $CellContext`b^(-1)/$CellContext`c],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN45sDxUE3Dr9xBADerLAa
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"b6deef15-93c5-41a6-a2d4-03b6ffd1f06b"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN46FXxUE3Dr9xBADegrAa
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"7b145bd7-2cf7-4c88-b76b-141ad962f6a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "86", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", " ", "b"}]], "+", 
     FractionBox["1", 
      RowBox[{"a", " ", "c"}]], "+", 
     FractionBox["1", 
      RowBox[{"b", " ", "c"}]]}], "\[LessEqual]", 
    FractionBox["1", 
     RowBox[{"4", " ", 
      SuperscriptBox["r", "2"]}]]}]}],
  SequenceForm[
  "[", 86, "] ", $CellContext`a^(-1)/$CellContext`b + \
$CellContext`a^(-1)/$CellContext`c + $CellContext`b^(-1)/$CellContext`c <= 
   Rational[1, 4] $CellContext`r^(-2)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN45WvxUE3Dr9xBADfX7A3
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"0f4251f3-3075-47f7-93b6-e9f0aa513dac"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY9vVkqAbh984AgDcFa/K
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"60cf6b3b-9094-4f4b-b594-67e81b2aa7cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "87", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"8", " ", "r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "r"}], "+", "R"}], ")"}]}], "\[LessEqual]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "c"}], ")"}], "2"]}]}]}],
  SequenceForm[
  "[", 87, "] ", 
   8 $CellContext`r ((-2) $CellContext`r + $CellContext`R) <= ($CellContext`a - \
$CellContext`b)^2 + ($CellContext`b - $CellContext`c)^2 + (-$CellContext`a + \
$CellContext`c)^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo9z9kqAbh984AgDZG69s
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"afe9d56c-baaf-4bce-8bf5-7868bb5c76d6"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN46PnJUE3Dr9xBADfc7A4
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"265a25d3-b197-4b13-a0a9-06737abde48b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "88", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "c"}], ")"}], "2"]}], "\[LessEqual]", 
    RowBox[{"8", " ", "R", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "r"}], "+", "R"}], ")"}]}]}]}],
  SequenceForm[
  "[", 88, "] ", ($CellContext`a - $CellContext`b)^2 + ($CellContext`b - \
$CellContext`c)^2 + (-$CellContext`a + $CellContext`c)^2 <= 
   8 $CellContext`R ((-2) $CellContext`r + $CellContext`R)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo+WHkqAbh984AgDaaq+Y
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"d12761a3-4c32-478a-944e-49a573cfeb66"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN47EfJUE3Dr9xBADfCrAt
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"857fcccc-4231-4d90-aed5-47b9b7e7f22f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "89", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["r", "2"]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"a", " ", "b", " ", "c"}], 
     RowBox[{"a", "+", "b", "+", "c"}]]}]}],
  SequenceForm[
  "[", 89, "] ", 
   4 $CellContext`r^2 <= $CellContext`a $CellContext`b \
$CellContext`c/($CellContext`a + $CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshpoP0Np0I3DbxwB1rCvAw==
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"93981490-6525-4dd5-96f4-e1d64338fddc"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4wGO0qAbh984AgDYUK84
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"b2c99df2-4991-491f-9f51-fb915ba2aad4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "90", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a", " ", "b", " ", "c"}], "\[LessEqual]", 
    RowBox[{"3", " ", 
     SqrtBox["3"], " ", 
     SuperscriptBox["R", "3"]}]}]}],
  SequenceForm[
  "[", 90, "] ", $CellContext`a $CellContext`b $CellContext`c <= 
   3 3^Rational[1, 2] $CellContext`R^3],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNI5tAadCNw28cAdK4roY=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"95a5eeaa-302e-49b7-828e-7df0de5ea702"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo7FkadCNw28cAdRfrrw=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"464c7abd-2d2b-49b7-9a26-9f22f77412f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "91", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "r"}], "+", 
     RowBox[{"5", " ", "R"}]}], "\[GreaterEqual]", 
    RowBox[{
     SqrtBox["3"], " ", "s"}]}]}],
  SequenceForm[
  "[", 91, "] ", -$CellContext`r + 5 $CellContext`R >= 
   3^Rational[1, 2] $CellContext`s],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4yGF0qAbh984AgDZCK9S
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"e9ea9387-bf8f-482e-92b0-b1877ae17396"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshpoL3NZ0I3DbxwB2XOvXA==
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"9f8041d0-74b9-4f4a-878f-b0f19f3c69fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "92", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"54", " ", "r", " ", "R"}], "\[LessEqual]", 
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "b"}], "+", 
       RowBox[{"a", " ", "c"}], "+", 
       RowBox[{"b", " ", "c"}]}], ")"}]}]}]}],
  SequenceForm[
  "[", 92, "] ", 54 $CellContext`r $CellContext`R <= 
   3 ($CellContext`a $CellContext`b + $CellContext`a $CellContext`c + \
$CellContext`b $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNYxBfWdCNw28cAdUQrtE=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"9a70e17b-e9bd-4eb7-984e-d2a624a32d95"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN49M/ZUE3Dr9xBADgKrBS
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"468c06c1-2437-4aa5-adba-2bae30dd2318"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNoxNredCNw28cAdRXrrk=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"1f63ae10-4238-4047-80bc-a6c5a4f87054"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Proved \"\>", "\[InvisibleSpace]", "92", 
   "\[InvisibleSpace]", "\<\" inequalities out of \"\>", "\[InvisibleSpace]", 
   "92", "\[InvisibleSpace]", "\<\". Time=\"\>", "\[InvisibleSpace]", 
   "0.567348`"}],
  SequenceForm[
  "Proved ", 92, " inequalities out of ", 92, ". Time=", 0.567348],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNYz9PedCNw28cAdbwrw0=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"c336f616-3111-4603-a51b-9851eb73911a"],

Cell[BoxData[
 StyleBox["\<\"Chapter 6\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontSize->18,
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo49IedCNw28cAdUQrtI=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"ca6ae5b7-74bd-44d6-a5df-edf668a8bb77"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "93", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"h", "[", "a", "]"}], "+", 
       RowBox[{"h", "[", "b", "]"}], "+", 
       RowBox[{"h", "[", "c", "]"}]}], ")"}]}], "\[LessEqual]", 
    RowBox[{
     SqrtBox["3"], " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}]}],
  SequenceForm[
  "[", 93, "] ", 
   2 ($CellContext`h[$CellContext`a] + $CellContext`h[$CellContext`b] + \
$CellContext`h[$CellContext`c]) <= 
   3^Rational[1, 2] ($CellContext`a + $CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo5ZMedCNw28cAdQ4rrg=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"82b257de-ebe1-40dd-bdea-8a5b571e4c14"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4wL+iqAbh984AgDXk68i
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"18df3f58-7747-4ea6-8b94-ca72887aba72"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "94", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "b"}], "+", 
       RowBox[{"a", " ", "c"}], "+", 
       RowBox[{"b", " ", "c"}]}], ")"}]}], "\[GreaterEqual]", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"h", "[", "a", "]"}], " ", 
        RowBox[{"h", "[", "b", "]"}]}], "+", 
       RowBox[{
        RowBox[{"h", "[", "a", "]"}], " ", 
        RowBox[{"h", "[", "c", "]"}]}], "+", 
       RowBox[{
        RowBox[{"h", "[", "b", "]"}], " ", 
        RowBox[{"h", "[", "c", "]"}]}]}], ")"}]}]}]}],
  SequenceForm[
  "[", 94, "] ", 
   3 ($CellContext`a $CellContext`b + $CellContext`a $CellContext`c + \
$CellContext`b $CellContext`c) >= 
   4 ($CellContext`h[$CellContext`a] $CellContext`h[$CellContext`b] + \
$CellContext`h[$CellContext`a] $CellContext`h[$CellContext`c] + \
$CellContext`h[$CellContext`b] $CellContext`h[$CellContext`c])],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshoYTpIVQTcOv3EEANeZryQ=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"0312161a-330e-432a-beeb-17a823a825be"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY5dcZdCNw28cAddSrxw=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"e46cc0ad-e125-428d-90cd-3dedf0d939cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "95", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "3"], "+", 
     SuperscriptBox["b", "3"], "+", 
     SuperscriptBox["c", "3"]}], ">", 
    RowBox[{
     FractionBox["8", "7"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"h", "[", "a", "]"}], "3"], "+", 
       SuperscriptBox[
        RowBox[{"h", "[", "b", "]"}], "3"], "+", 
       SuperscriptBox[
        RowBox[{"h", "[", "c", "]"}], "3"]}], ")"}]}]}]}],
  SequenceForm[
  "[", 95, "] ", $CellContext`a^3 + $CellContext`b^3 + $CellContext`c^3 > 
   Rational[8, 
      7] ($CellContext`h[$CellContext`a]^3 + $CellContext`h[$CellContext`b]^3 + \
$CellContext`h[$CellContext`c]^3)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN426NyqAbh984AgDZIK9X
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"f58b4bb9-86ed-43d0-af36-af02206578b0"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo4N6TdCNw28cAdVTrt4=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"ee3b9dd5-abb9-48d5-872d-524f934608d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "96", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox[
      SuperscriptBox["c", "2"], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"h", "[", "a", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"h", "[", "b", "]"}], "2"]}]], "+", 
     FractionBox[
      SuperscriptBox["b", "2"], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"h", "[", "a", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"h", "[", "c", "]"}], "2"]}]], "+", 
     FractionBox[
      SuperscriptBox["a", "2"], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"h", "[", "b", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"h", "[", "c", "]"}], "2"]}]]}], "\[GreaterEqual]", "2"}]}],
  SequenceForm[
  "[", 96, "] ", $CellContext`c^2/($CellContext`h[$CellContext`a]^2 + \
$CellContext`h[$CellContext`b]^2) + \
$CellContext`b^2/($CellContext`h[$CellContext`a]^2 + \
$CellContext`h[$CellContext`c]^2) + \
$CellContext`a^2/($CellContext`h[$CellContext`b]^2 + \
$CellContext`h[$CellContext`c]^2) >= 2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshpormFN0I3DbxwB1tmvEA==
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"c9b6444e-af3d-4fcb-a04c-ef7af5fac1f7"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4+sdjUE3Dr9xBADewLAf
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"ccf87941-b43d-4d54-a643-4845edbd6050"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "97", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"h", "[", "a", "]"}], "+", 
     RowBox[{"h", "[", "b", "]"}], "+", 
     RowBox[{"h", "[", "c", "]"}]}], "\[GreaterEqual]", 
    RowBox[{"9", " ", "r"}]}]}],
  SequenceForm[
  "[", 97, "] ", $CellContext`h[$CellContext`a] + \
$CellContext`h[$CellContext`b] + $CellContext`h[$CellContext`c] >= 
   9 $CellContext`r],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo8qhxqAbh984AgDYzq9i
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"0d5a5f03-5bad-43c6-9cf3-a9a16dd5adba"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo9vKpqAbh984AgDZNa9s
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"1d6aa5da-760c-43b4-b368-1d2cab65f2f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "98", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"h", "[", "a", "]"}], "+", 
     RowBox[{"h", "[", "b", "]"}], "+", 
     RowBox[{"h", "[", "c", "]"}]}], "\[LessEqual]", 
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{"r", "+", "R"}], ")"}]}]}]}],
  SequenceForm[
  "[", 98, "] ", $CellContext`h[$CellContext`a] + \
$CellContext`h[$CellContext`b] + $CellContext`h[$CellContext`c] <= 
   3 ($CellContext`r + $CellContext`R)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo9iWpqAbh984AgDYAq9H
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"b6a85754-0141-4635-adf8-0fec23ca69f1"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN453bTUE3Dr9xBADfQ7A0
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"380b4d7a-8a98-44a2-a7ca-7cdc30bf2a8b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "99", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"h", "[", "a", "]"}], "+", 
     RowBox[{"h", "[", "b", "]"}], "+", 
     RowBox[{"h", "[", "c", "]"}]}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"5", " ", "r"}], "+", 
     RowBox[{"2", " ", "R"}]}]}]}],
  SequenceForm[
  "[", 99, "] ", $CellContext`h[$CellContext`a] + \
$CellContext`h[$CellContext`b] + $CellContext`h[$CellContext`c] <= 
   5 $CellContext`r + 2 $CellContext`R],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN45tnTUE3Dr9xBADgELBP
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"777201e6-8775-4938-bb28-4f0c1996f735"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN44FbzUE3Dr9xBADeYrAY
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"5c799b6f-7807-47e8-a60f-20d3d48d1b8d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "100", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "r"}], "+", 
        RowBox[{"5", " ", "R"}]}], ")"}]}], "R"], "\[LessEqual]", 
    RowBox[{
     RowBox[{"h", "[", "a", "]"}], "+", 
     RowBox[{"h", "[", "b", "]"}], "+", 
     RowBox[{"h", "[", "c", "]"}]}]}]}],
  SequenceForm[
  "[", 100, "] ", 
   2 $CellContext`r $CellContext`R^(-1) (-$CellContext`r + 
     5 $CellContext`R) <= $CellContext`h[$CellContext`a] + \
$CellContext`h[$CellContext`b] + $CellContext`h[$CellContext`c]],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4/xnzUE3Dr9xBADdrrAD
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"8863ae6c-57e3-46d4-a643-620d7087b070"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN45IPzUE3Dr9xBADeHLAS
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"621a8c87-8578-48fd-9f04-86efdc405c66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "101", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"h", "[", "a", "]"}], "+", 
     RowBox[{"h", "[", "b", "]"}], "+", 
     RowBox[{"h", "[", "c", "]"}]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", "R"}], ")"}], "2"]}], "R"]}]}],
  SequenceForm[
  "[", 101, 
   "] ", $CellContext`h[$CellContext`a] + $CellContext`h[$CellContext`b] + \
$CellContext`h[$CellContext`c] <= 
   2 $CellContext`R^(-1) ($CellContext`r + $CellContext`R)^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshrojp/NQTcOv3EEAN1zr/4=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"f2d534da-eb82-4c51-9c4f-d6aff4ad1f32"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4xPllqAbh984AgDah6+G
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"b2802c5a-2f1d-46ba-8cea-11249e10e472"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "102", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"h", "[", "a", "]"}], " ", 
        RowBox[{"h", "[", "b", "]"}]}], "+", 
       RowBox[{
        RowBox[{"h", "[", "a", "]"}], " ", 
        RowBox[{"h", "[", "c", "]"}]}], "+", 
       RowBox[{
        RowBox[{"h", "[", "b", "]"}], " ", 
        RowBox[{"h", "[", "c", "]"}]}]}], ")"}]}], "\[LessEqual]", 
    RowBox[{"6", " ", 
     SqrtBox["3"], " ", "K"}]}]}],
  SequenceForm[
  "[", 102, "] ", 
   2 ($CellContext`h[$CellContext`a] $CellContext`h[$CellContext`b] + \
$CellContext`h[$CellContext`a] $CellContext`h[$CellContext`c] + \
$CellContext`h[$CellContext`b] $CellContext`h[$CellContext`c]) <= 
   6 3^Rational[1, 2] K],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshroPr2WoBuH3zgCANR0rsU=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"ce77a5da-2fa7-4b6f-8e95-619a7125e1db"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4zux1qAbh984AgDagq+E
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"dc356c3a-2a8d-4883-a903-2853337198e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "103", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"6", " ", 
     SqrtBox["3"], " ", "K"}], "\[LessEqual]", 
    RowBox[{"27", " ", "r", " ", "R"}]}]}],
  SequenceForm[
  "[", 103, "] ", 6 3^Rational[1, 2] K <= 27 $CellContext`r $CellContext`R],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN42mF1qAbh984AgDZsK9r
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"2e5ffdd9-0eaa-4bc2-bcc4-16e9eb4a94ad"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshpoHk9b0I3DbxwB06Kupw==
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"e3e04c72-1174-4c59-a700-d6f09302659b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "104", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"h", "[", "a", "]"}], " ", 
     RowBox[{"h", "[", "b", "]"}], " ", 
     RowBox[{"h", "[", "c", "]"}]}], "\[GreaterEqual]", 
    RowBox[{"27", " ", 
     SuperscriptBox["r", "3"]}]}]}],
  SequenceForm[
  "[", 104, 
   "] ", $CellContext`h[$CellContext`a] $CellContext`h[$CellContext`b] \
$CellContext`h[$CellContext`c] >= 27 $CellContext`r^3],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY5JoW9CNw28cAdYhrvg=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"0996eac9-25f0-474e-bd40-67416afaa0d0"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4yXZtqAbh984AgDZ2a9w
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"40c6f4c2-91ed-4895-8a23-4b7125eeba4e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "105", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "r"}], "+", 
       RowBox[{"h", "[", "a", "]"}]}]], "+", 
     FractionBox["1", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "r"}], "+", 
       RowBox[{"h", "[", "b", "]"}]}]], "+", 
     FractionBox["1", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "r"}], "+", 
       RowBox[{"h", "[", "c", "]"}]}]]}], "\[GreaterEqual]", 
    FractionBox["3", "r"]}]}],
  SequenceForm[
  "[", 105, 
   "] ", ((-2) $CellContext`r + $CellContext`h[$CellContext`a])^(-1) + ((-2) \
$CellContext`r + $CellContext`h[$CellContext`b])^(-1) + ((-2) $CellContext`r + \
$CellContext`h[$CellContext`c])^(-1) >= 3/$CellContext`r],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY5paW9CNw28cAda4rw0=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"7c0c802f-a792-4b96-991d-316a66653f38"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY0lgW9CNw28cAdhVr0Y=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"77c18586-e017-4511-9905-7b90a37d47ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "106", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"r", "+", 
       RowBox[{"h", "[", "a", "]"}]}], 
      RowBox[{
       RowBox[{"-", "r"}], "+", 
       RowBox[{"h", "[", "a", "]"}]}]], "+", 
     FractionBox[
      RowBox[{"r", "+", 
       RowBox[{"h", "[", "b", "]"}]}], 
      RowBox[{
       RowBox[{"-", "r"}], "+", 
       RowBox[{"h", "[", "b", "]"}]}]], "+", 
     FractionBox[
      RowBox[{"r", "+", 
       RowBox[{"h", "[", "c", "]"}]}], 
      RowBox[{
       RowBox[{"-", "r"}], "+", 
       RowBox[{"h", "[", "c", "]"}]}]]}], "\[GreaterEqual]", "6"}]}],
  SequenceForm[
  "[", 106, 
   "] ", (-$CellContext`r + $CellContext`h[$CellContext`a])^(-1) \
($CellContext`r + $CellContext`h[$CellContext`a]) + (-$CellContext`r + \
$CellContext`h[$CellContext`b])^(-1) ($CellContext`r + \
$CellContext`h[$CellContext`b]) + (-$CellContext`r + \
$CellContext`h[$CellContext`c])^(-1) ($CellContext`r + \
$CellContext`h[$CellContext`c]) >= 6],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN47PotqAbh984AgDcK6/C
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"ee85af93-0e5c-4bfe-971e-b4241d8335be"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN41bn9qAbh984AgDaAa96
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"bbe9057d-daac-43b9-9a59-2ce882d6f9b9"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY6x/e9CNw28cAdeVry4=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"c7a56d94-03db-4b7f-b3f8-0b7783412a52"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Proved \"\>", "\[InvisibleSpace]", "106", 
   "\[InvisibleSpace]", "\<\" inequalities out of \"\>", "\[InvisibleSpace]", 
   "106", "\[InvisibleSpace]", "\<\". Time=\"\>", "\[InvisibleSpace]", 
   "0.518124`"}],
  SequenceForm[
  "Proved ", 106, " inequalities out of ", 106, ". Time=", 0.518124],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN447w9qAbh984AgDapa+R
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"6b302af9-a679-476c-9553-c363114a806b"],

Cell[BoxData[
 StyleBox["\<\"Chapter 7\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontSize->18,
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN47TE9qAbh984AgDZ2695
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"4aae56ad-8d6f-45cb-ac54-622d90d65666"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "107", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SqrtBox["3"], " ", "K"}], "\[LessEqual]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"r", "+", "R"}], ")"}], "2"]}]}],
  SequenceForm[
  "[", 107, "] ", 3^Rational[1, 2] K <= ($CellContext`r + $CellContext`R)^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo0hWe9CNw28cAdYKrwA=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"58a6014e-648a-4c1b-97d9-38811c3c02d3"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY86sjqAbh984AgDaIK+J
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"3af8aeb4-c4c2-48ac-90cc-89ed5ba63778"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "108", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SqrtBox["3"], " ", "K"}], "\[LessEqual]", 
    RowBox[{"r", " ", 
     RowBox[{"(", 
      RowBox[{"r", "+", 
       RowBox[{"4", " ", "R"}]}], ")"}]}]}]}],
  SequenceForm[
  "[", 108, "] ", 
   3^Rational[1, 2] K <= $CellContext`r ($CellContext`r + 4 $CellContext`R)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo+aSjqAbh984AgDYTq9Q
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"b19ed76e-511b-4fb1-9b9c-adf246cf3061"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN47OJnUE3Dr9xBADdt6/7
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"2518eaa9-7e90-4390-bdc6-f03d096d4d66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "109", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    RowBox[{
     FractionBox[
      RowBox[{"11", " ", "K"}], 
      RowBox[{"3", " ", 
       SqrtBox["3"]}]], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["R", "2"]}]}]}]}],
  SequenceForm[
  "[", 109, "] ", $CellContext`s^2 <= 
   Rational[11, 3] 3^Rational[-1, 2] K + 4 $CellContext`R^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY9iczqAbh984AgDZhK92
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"85e121a4-b5f7-4ccb-bd15-dfbe84be0e80"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4/SPXUE3Dr9xBADd5bAN
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"ae596fd5-9343-4cf9-9557-ddeb1285dd8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "110", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"11", " ", "K"}], 
      RowBox[{"3", " ", 
       SqrtBox["3"]}]], "+", 
     RowBox[{"8", " ", "r", " ", "R"}]}], "\[LessEqual]", 
    SuperscriptBox["s", "2"]}]}],
  SequenceForm[
  "[", 110, "] ", 
   Rational[11, 3] 3^Rational[-1, 2] K + 
    8 $CellContext`r $CellContext`R <= $CellContext`s^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY9DvrqAbh984AgDcA6/S
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"3ce10a68-8eda-4943-a1da-d65cda96bc8b"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN44bVPUE3Dr9xBADcz6/i
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"0a72451d-ef89-42a3-814c-311591f0bdc8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "111", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[LessEqual]", 
    RowBox[{
     FractionBox[
      RowBox[{"4", " ", "K"}], 
      RowBox[{"3", " ", 
       SqrtBox["3"]}]], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["R", "2"]}]}]}]}],
  SequenceForm[
  "[", 111, "] ", $CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2 <= 
   Rational[4, 3] 3^Rational[-1, 2] K + 8 $CellContext`R^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshoYTlt7gm4cfuMIANxVr9Q=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"5c4e99ce-1262-4c02-b02f-b703b0d2384d"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4/SkvqAbh984AgDaFK+C
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"c462e926-c106-426f-b38c-3c206f559d51"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "112", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}], "2"], "\[LessEqual]", 
    RowBox[{
     RowBox[{"48", " ", 
      SuperscriptBox["K", "2"]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["R", "4"]}]}]}]}],
  SequenceForm[
  "[", 112, "] ", ($CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2)^2 <= 
   48 K^2 + 64 $CellContext`R^4],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshpobk5f0I3DbxwB2OKvXQ==
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"7db9be44-7aff-4dc7-b75f-a91b1be1d580"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNoxD3hKAbh984AgDTl66o
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"c86f970e-f61e-40ce-b3d2-8c4dd9d07683"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "113", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"8", " ", "K", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "r"}], "+", 
       RowBox[{"2", " ", "R"}]}], ")"}]}], "\[LessEqual]", 
    RowBox[{
     SuperscriptBox["a", "3"], "+", 
     SuperscriptBox["b", "3"], "+", 
     SuperscriptBox["c", "3"]}]}]}],
  SequenceForm[
  "[", 113, "] ", 
   8 K (-$CellContext`r + 
     2 $CellContext`R) <= $CellContext`a^3 + $CellContext`b^3 + \
$CellContext`c^3],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshpovuiEoBuH3zgCANfNrzA=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"e560002c-8fb6-4ff7-bf08-78dc6cc5b154"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNI4PVhKAbh984AgDUUK7F
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"5adadfd9-4c8c-4512-b907-86aee3871555"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "114", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"4", " ", "K"}], "\[LessEqual]", 
    RowBox[{"3", " ", 
     SqrtBox["3"], " ", 
     SuperscriptBox["R", "2"]}]}]}],
  SequenceForm["[", 114, "] ", 4 K <= 3 3^Rational[1, 2] $CellContext`R^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo7HLhKAbh984AgDWLq8C
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"0640751d-6ccc-4460-bcff-5969a47a1bd0"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo7jcxKAbh984AgDUSq7B
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"424c3e8e-e55a-4f1b-bb58-ab52d01abc57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "115", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"3", " ", 
     SqrtBox["3"], " ", 
     SuperscriptBox["r", "2"]}], "\[LessEqual]", "K"}]}],
  SequenceForm["[", 115, "] ", 3 3^Rational[1, 2] $CellContext`r^2 <= K],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4xL1iUE3Dr9xBADY8a9X
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"858b6d2a-e154-4061-a5d3-d1a6aaafe4cf"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshrI158UdOPwG0cA1e+u+A==
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"62bb7f5e-0322-4f65-9172-565d71425cfa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "116", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["r", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "5"}], " ", "r"}], "+", 
       RowBox[{"16", " ", "R"}]}], ")"}]}], "\[LessEqual]", 
    SuperscriptBox["K", "2"]}]}],
  SequenceForm[
  "[", 116, "] ", $CellContext`r^3 ((-5) $CellContext`r + 16 $CellContext`R) <= 
   K^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4wXrSUE3Dr9xBADa46+Y
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"81892f27-6971-4943-8ec9-17baf508d366"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo73rpKAbh984AgDWoa8R
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"b9b084a3-a943-4ee3-987f-b48bd89399d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "117", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["K", "2"], "\[LessEqual]", 
    RowBox[{
     SuperscriptBox["r", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{"4", " ", "r", " ", "R"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["R", "2"]}]}], ")"}]}]}]}],
  SequenceForm[
  "[", 117, "] ", 
   K^2 <= $CellContext`r^2 (3 $CellContext`r^2 + 
     4 $CellContext`r $CellContext`R + 4 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY6jfpKAbh984AgDXkK8w
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"aa970aee-5385-43e3-b41d-e95ab2a1ead9"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNI0PEpKAbh984AgDVLq7l
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"8680443d-76bc-4af4-996d-64310042c754"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "118", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"9", " ", "r"}], 
     RowBox[{"2", " ", "K"}]], "\[LessEqual]", 
    RowBox[{
     FractionBox["1", "a"], "+", 
     FractionBox["1", "b"], "+", 
     FractionBox["1", "c"]}]}]}],
  SequenceForm[
  "[", 118, "] ", 
   Rational[9, 2] 
    K^(-1) $CellContext`r <= $CellContext`a^(-1) + $CellContext`b^(-1) + \
$CellContext`c^(-1)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY1jCpKAbh984AgDYFq9D
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"e4f963c4-275e-4ca6-b1a7-881e3e4addd8"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo1HmpKAbh984AgDXNa8o
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"872002ca-743c-44e8-90f8-14aaa2cb7a55"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "119", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox["1", "a"], "+", 
     FractionBox["1", "b"], "+", 
     FractionBox["1", "c"]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"9", " ", "R"}], 
     RowBox[{"4", " ", "K"}]]}]}],
  SequenceForm[
  "[", 119, 
   "] ", $CellContext`a^(-1) + $CellContext`b^(-1) + $CellContext`c^(-1) <= 
   Rational[9, 4] K^(-1) $CellContext`R],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo2vxpKAbh984AgDYE69F
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"169d0628-8c1a-4bdc-9c08-56aaf2e6b963"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN48qoyUE3Dr9xBADaiq+R
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"1ef96fae-affe-4ae3-a4c9-e1ed5f79b6b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "120", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["r", "2"], "+", 
     RowBox[{"4", " ", "r", " ", "R"}]}], "\[LessEqual]", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", "-", "c"}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "+", "c"}], ")"}], "2"]}], ")"}]}], "+", 
     RowBox[{
      SqrtBox["3"], " ", "K"}]}]}]}],
  SequenceForm[
  "[", 120, "] ", $CellContext`r^2 + 4 $CellContext`r $CellContext`R <= 
   Rational[1, 
       2] (($CellContext`a - $CellContext`b)^2 + ($CellContext`b - \
$CellContext`c)^2 + (-$CellContext`a + $CellContext`c)^2) + 
    3^Rational[1, 2] K],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN47/UyUE3Dr9xBADdf6/x
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"efbd88c1-ff62-480c-9775-301b1676d4bb"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshoYLvmTg24cfuMIANw1r8k=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"978a4306-7282-4633-899b-4d7371180a5e"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo1j55KAbh984AgDWva8b
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"2c6c1750-20c0-4033-b90c-fad447fe53a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Proved \"\>", "\[InvisibleSpace]", "120", 
   "\[InvisibleSpace]", "\<\" inequalities out of \"\>", "\[InvisibleSpace]", 
   "120", "\[InvisibleSpace]", "\<\". Time=\"\>", "\[InvisibleSpace]", 
   "0.386653`"}],
  SequenceForm[
  "Proved ", 120, " inequalities out of ", 120, ". Time=", 0.386653],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN46K6yUE3Dr9xBADbTq+u
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"51144062-d821-4b33-aa23-2aee436e41b2"],

Cell[BoxData[
 StyleBox["\<\"Chapter 8\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontSize->18,
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN46OOyUE3Dr9xBADdlK/4
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"341c87e9-c405-4bb9-9e50-f4ae6baff0bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "121", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"m", "[", "a", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"m", "[", "b", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"m", "[", "c", "]"}], "2"]}], "\[GreaterEqual]", 
    RowBox[{"3", " ", 
     SqrtBox["3"], " ", "K"}]}]}],
  SequenceForm[
  "[", 121, 
   "] ", $CellContext`m[$CellContext`a]^2 + $CellContext`m[$CellContext`b]^2 + \
$CellContext`m[$CellContext`c]^2 >= 3 3^Rational[1, 2] K],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY820yUE3Dr9xBADaxq+g
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"eb0b4dc3-3300-4a6d-906e-333c94d8374c"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshro37IpQTcOv3EEANt8r7M=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"69c1976f-d2f3-41a8-8666-e50bf0a91910"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "122", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"w", "[", "a", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"w", "[", "b", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"w", "[", "c", "]"}], "2"]}], "\[GreaterEqual]", 
    RowBox[{"3", " ", 
     SqrtBox["3"], " ", "K"}]}]}],
  SequenceForm[
  "[", 122, 
   "] ", $CellContext`w[$CellContext`a]^2 + $CellContext`w[$CellContext`b]^2 + \
$CellContext`w[$CellContext`c]^2 >= 3 3^Rational[1, 2] K],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN446GKUE3Dr9xBADcEq/H
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"685ac53c-e3e8-4ec7-813b-18978850f957"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo8PMOUE3Dr9xBADZMa9w
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"3c24e711-9e3b-44f8-b487-b60a098021c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "123", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"16", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"w", "[", "a", "]"}], "4"], "+", 
       SuperscriptBox[
        RowBox[{"w", "[", "b", "]"}], "4"], "+", 
       SuperscriptBox[
        RowBox[{"w", "[", "c", "]"}], "4"]}], ")"}]}], "\[LessEqual]", 
    RowBox[{"9", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "4"], "+", 
       SuperscriptBox["b", "4"], "+", 
       SuperscriptBox["c", "4"]}], ")"}]}]}]}],
  SequenceForm[
  "[", 123, "] ", 
   16 ($CellContext`w[$CellContext`a]^4 + $CellContext`w[$CellContext`b]^4 + \
$CellContext`w[$CellContext`c]^4) <= 
   9 ($CellContext`a^4 + $CellContext`b^4 + $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN46TFc4JuHH7jCADcB6/M
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"aeb5d7b2-1a90-4236-91cd-b362f12b2593"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNYx3zqqAbh984AgDXW68m
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"8d2537af-177f-46af-8a60-308fd3349d7e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "124", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"w", "[", "a", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"w", "[", "b", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"w", "[", "c", "]"}], "2"]}], "\[LessEqual]", 
    RowBox[{
     RowBox[{
      RowBox[{"r", "[", "a", "]"}], " ", 
      RowBox[{"r", "[", "b", "]"}]}], "+", 
     RowBox[{
      RowBox[{"r", "[", "a", "]"}], " ", 
      RowBox[{"r", "[", "c", "]"}]}], "+", 
     RowBox[{
      RowBox[{"r", "[", "b", "]"}], " ", 
      RowBox[{"r", "[", "c", "]"}]}]}]}]}],
  SequenceForm[
  "[", 124, 
   "] ", $CellContext`w[$CellContext`a]^2 + $CellContext`w[$CellContext`b]^2 + \
$CellContext`w[$CellContext`c]^2 <= $CellContext`r[$CellContext`a] \
$CellContext`r[$CellContext`b] + $CellContext`r[$CellContext`a] \
$CellContext`r[$CellContext`c] + $CellContext`r[$CellContext`b] \
$CellContext`r[$CellContext`c]],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4yPeVUE3Dr9xBADawa+U
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"3e062945-a1a1-4573-846e-49d19c946a30"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bshroX9m1QTcOv3EEANmjr3M=
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"abf61198-b221-46b9-885a-762fb7e047d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "125", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"r", "[", "a", "]"}], "2"], 
      SuperscriptBox[
       RowBox[{"w", "[", "a", "]"}], "2"]], "+", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"r", "[", "b", "]"}], "2"], 
      SuperscriptBox[
       RowBox[{"w", "[", "b", "]"}], "2"]], "+", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"r", "[", "c", "]"}], "2"], 
      SuperscriptBox[
       RowBox[{"w", "[", "c", "]"}], "2"]]}], "\[GreaterEqual]", "3"}]}],
  SequenceForm[
  "[", 125, 
   "] ", $CellContext`r[$CellContext`a]^2 $CellContext`w[$CellContext`a]^(-2) + \
$CellContext`r[$CellContext`b]^2 $CellContext`w[$CellContext`b]^(-2) + \
$CellContext`r[$CellContext`c]^2 $CellContext`w[$CellContext`c]^(-2) >= 3],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN4xWttUE3Dr9xBADbLq+m
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"c12f64c0-2dde-479b-88f5-16bdd8d8612a"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY8TK9UE3Dr9xBADa06+r
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"3b127387-d788-47c4-82cc-08c3836ba862"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "126", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"w", "[", "a", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"w", "[", "b", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"w", "[", "c", "]"}], "2"]}], "\[LessEqual]", 
    SuperscriptBox["s", "2"]}]}],
  SequenceForm[
  "[", 126, 
   "] ", $CellContext`w[$CellContext`a]^2 + $CellContext`w[$CellContext`b]^2 + \
$CellContext`w[$CellContext`c]^2 <= $CellContext`s^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo8rm9UE3Dr9xBADZea+B
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"f263ab7d-e8b6-4de1-84fd-38199bda4501"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY9/e9UE3Dr9xBADdD6/1
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"1601e213-49ea-4faf-b668-525d82386308"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "127", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"m", "[", "a", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"m", "[", "b", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"m", "[", "c", "]"}], "2"]}]}]}],
  SequenceForm[
  "[", 127, 
   "] ", $CellContext`s^2 <= $CellContext`m[$CellContext`a]^2 + \
$CellContext`m[$CellContext`b]^2 + $CellContext`m[$CellContext`c]^2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY+LR9UE3Dr9xBADb36/Q
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"a1406808-d4fc-4156-ae01-1e5bdae75289"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNY/3Z9UE3Dr9xBADdB6/2
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"9f1acc67-4850-470f-adc0-c2a2a7e421c3"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNo8XV9UE3Dr9xBADbB6+3
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"60beeb8c-9122-42f9-b387-31066795c282"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Proved \"\>", "\[InvisibleSpace]", "127", 
   "\[InvisibleSpace]", "\<\" inequalities out of \"\>", "\[InvisibleSpace]", 
   "127", "\[InvisibleSpace]", "\<\". Time=\"\>", "\[InvisibleSpace]", 
   "0.907063`"}],
  SequenceForm[
  "Proved ", 127, " inequalities out of ", 127, ". Time=", 0.907063],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqNI/eD9UE3Dr9xBADZ7K+V
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"0e38003f-2f8a-4c6d-8834-c349df0bf921"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Total time=\"\>", "\[InvisibleSpace]", "3.849906`"}],
  SequenceForm["Total time=", 3.849906],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBOK2tOyA3vo3jtdaKgpAtJn/ix4QPSPBbzKIzvKNmQmi
z9RPXQSiTXZarQHRX0/v3w2iDb6pnAbRtp+4L4Doddsif0wE0pn1x1kmAekP
U+umKjS8cXzRvG36TCBdxT1n8SwgzSF6bjOI7sk5vAtEP5h84zSIzmBfdwVE
n1iZw3MSSEvod+mC6AerI61AtN8Km1oQ3R7nHpvV+MZxcv06I84moPntvB4g
Wu+0bzqI/sjw9SM3kJ5wZ+ZfEJ0Rc4GfB0hLHS2XFQLSy9KYjEG0jmfb1HQg
vf/xigUg+mKrQMVeIC3/dOVNu+Y3jo9/t7Y+BNI7eeIcPq9642gTuC0IREcZ
dG6bsvqN46wX64NuHH7jCADenLAs
  "],
 CellLabel->
  "During evaluation of \
In[166]:=",ExpressionUUID->"a59e1ec5-5499-4803-8c2c-ad8898d45e84"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "total", " ", "time", " ", "is", " ", "around", " ", "5", " ", "sec"}], " ",
   "*)"}]], "Input",
 CellChangeTimes->{{3.826272816536903*^9, 3.826272825132864*^9}, 
   3.82724000286622*^9, {3.848054172052867*^9, 3.848054185047029*^9}},
 CellLabel->
  "In[210]:=",ExpressionUUID->"56408ebb-6000-4c39-a8a4-3b6ff23e5b72"]
},
WindowSize->{808, 911},
WindowMargins->{{474, Automatic}, {Automatic, 133}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 58535, 1510, 6856, "Input",ExpressionUUID->"ca280df3-3b4a-4d7b-8692-39e270427d70"],
Cell[CellGroupData[{
Cell[59140, 1536, 831, 21, 32, "Print",ExpressionUUID->"49016930-6ab9-42a1-be6f-48c195702cc8"],
Cell[59974, 1559, 1215, 31, 25, "Print",ExpressionUUID->"56a56d4c-b857-492a-a61f-aa57d897c032"],
Cell[61192, 1592, 802, 20, 24, "Print",ExpressionUUID->"c9ede8aa-b812-424c-bb23-6ce87057e145"],
Cell[61997, 1614, 1201, 30, 25, "Print",ExpressionUUID->"8af5ec4b-4c6f-49e4-86ca-63970f5a247e"],
Cell[63201, 1646, 802, 20, 24, "Print",ExpressionUUID->"b667df99-a387-45be-b531-c2e7f54ef03f"],
Cell[64006, 1668, 1278, 33, 41, "Print",ExpressionUUID->"9c6b8c8c-1068-4ffd-a721-f1c0295e3cd3"],
Cell[65287, 1703, 802, 20, 24, "Print",ExpressionUUID->"f9ecb5be-8b69-496f-8479-e68a139e14a2"],
Cell[66092, 1725, 1263, 33, 24, "Print",ExpressionUUID->"8cdb269b-3cce-44db-aa14-48f939c45c07"],
Cell[67358, 1760, 802, 20, 24, "Print",ExpressionUUID->"aeaafa37-f85e-4eb9-afea-1951e32a9486"],
Cell[68163, 1782, 1191, 30, 24, "Print",ExpressionUUID->"a5cedb49-66ce-44e3-9809-3564fcfa7aa3"],
Cell[69357, 1814, 802, 20, 24, "Print",ExpressionUUID->"9ca0af45-555c-415f-b0bd-e561edbbc952"],
Cell[70162, 1836, 1347, 35, 27, "Print",ExpressionUUID->"106b4709-c3bd-445b-a0de-d33ce945a1f2"],
Cell[71512, 1873, 802, 20, 24, "Print",ExpressionUUID->"bd70168f-a477-4f78-9675-e198a9bacce3"],
Cell[72317, 1895, 1513, 38, 27, "Print",ExpressionUUID->"b5a6160a-1f21-4d3e-9ced-32a686df945a"],
Cell[73833, 1935, 802, 20, 24, "Print",ExpressionUUID->"bbcaccdd-a4a1-415a-8f44-78ebec0f5a6a"],
Cell[74638, 1957, 1463, 39, 25, "Print",ExpressionUUID->"f7477395-113a-4026-b1e7-62548d1911aa"],
Cell[76104, 1998, 802, 20, 24, "Print",ExpressionUUID->"760e20ba-8c40-4f6d-b4b7-03a61f735d34"],
Cell[76909, 2020, 1526, 40, 41, "Print",ExpressionUUID->"6532ca15-a9d8-4b45-ac79-22de13e249eb"],
Cell[78438, 2062, 802, 20, 24, "Print",ExpressionUUID->"bc2bb8da-b1ce-470e-b99a-1e714ddd2eb7"],
Cell[79243, 2084, 1698, 44, 24, "Print",ExpressionUUID->"33dcdf0d-d876-4e78-b0af-7b90e2c5fec6"],
Cell[80944, 2130, 802, 20, 24, "Print",ExpressionUUID->"000a2d2d-38cd-4bcf-becf-7e5817f47120"],
Cell[81749, 2152, 1502, 39, 25, "Print",ExpressionUUID->"8e62f64c-274e-4488-81d3-83eb763a5fb6"],
Cell[83254, 2193, 802, 20, 24, "Print",ExpressionUUID->"b83d2de0-b92c-4b00-9663-7abe4cbf427c"],
Cell[84059, 2215, 1754, 47, 40, "Print",ExpressionUUID->"9072c8ab-098b-41ef-9453-aff8bf213ae9"],
Cell[85816, 2264, 802, 20, 24, "Print",ExpressionUUID->"6d3d7a72-acd0-445c-a39d-8e5a8b102c7e"],
Cell[86621, 2286, 1424, 37, 25, "Print",ExpressionUUID->"fe7792af-a6b7-4079-af42-6d9a9f2defd8"],
Cell[88048, 2325, 802, 20, 24, "Print",ExpressionUUID->"543eceb9-6e8f-4703-99d8-7b042427fef9"],
Cell[88853, 2347, 1222, 32, 41, "Print",ExpressionUUID->"415a3698-b1b7-4d2c-bb6b-8e7f97ecd89e"],
Cell[90078, 2381, 802, 20, 24, "Print",ExpressionUUID->"67c9f3ce-b796-4f75-a9a8-43643339048b"],
Cell[90883, 2403, 1227, 32, 40, "Print",ExpressionUUID->"9f3583f3-3e1d-4b70-a59a-bea84f4172f6"],
Cell[92113, 2437, 802, 20, 24, "Print",ExpressionUUID->"fa97106f-ed46-432c-90c5-f3a9fcee413e"],
Cell[92918, 2459, 1193, 31, 41, "Print",ExpressionUUID->"f09adbf1-ac7b-4e8f-b0a6-5e4dc4223218"],
Cell[94114, 2492, 802, 20, 24, "Print",ExpressionUUID->"2d97364d-2db4-4b22-9f9b-5eee35599e7f"],
Cell[94919, 2514, 1135, 28, 41, "Print",ExpressionUUID->"7dd04a72-9c56-4838-937a-81561255eb04"],
Cell[96057, 2544, 802, 20, 24, "Print",ExpressionUUID->"ed57c9c7-04f6-4426-ac3b-f316257ad965"],
Cell[96862, 2566, 1345, 35, 41, "Print",ExpressionUUID->"b9dcc582-3ce8-422e-a13e-590382acda92"],
Cell[98210, 2603, 802, 20, 24, "Print",ExpressionUUID->"6d6def31-fcbe-4bc6-9e72-524923f39635"],
Cell[99015, 2625, 1321, 33, 41, "Print",ExpressionUUID->"f7a90849-fa75-4909-bb8c-28cd9652dacc"],
Cell[100339, 2660, 802, 20, 24, "Print",ExpressionUUID->"2268c9c1-09c3-49a3-9285-e83959e0d26f"],
Cell[101144, 2682, 1195, 31, 47, "Print",ExpressionUUID->"bf1b5660-3d93-4928-94bf-adbdfaef6bb7"],
Cell[102342, 2715, 802, 20, 24, "Print",ExpressionUUID->"36c6017b-a434-4218-916b-1b3b0feb4cc9"],
Cell[103147, 2737, 1173, 29, 47, "Print",ExpressionUUID->"ea584eaf-94d3-4f6c-bbc3-b07d17573ab9"],
Cell[104323, 2768, 802, 20, 24, "Print",ExpressionUUID->"29b964f9-0139-46d5-8de5-4bdb713d9175"],
Cell[105128, 2790, 1913, 51, 27, "Print",ExpressionUUID->"0b4b6d35-6b57-4fc7-a014-cb569180990f"],
Cell[107044, 2843, 802, 20, 24, "Print",ExpressionUUID->"7a4dc5f5-ebf4-4545-9966-402dd249a010"],
Cell[107849, 2865, 1686, 41, 25, "Print",ExpressionUUID->"e53f4abb-2349-429d-bbf2-c5d821b96ac9"],
Cell[109538, 2908, 802, 20, 24, "Print",ExpressionUUID->"9cec41cc-0201-467f-af12-c907ef66bc43"],
Cell[110343, 2930, 579, 12, 24, "Print",ExpressionUUID->"d1eb7578-bc7d-4ecf-bd20-0c2fdbd8303b"],
Cell[110925, 2944, 916, 20, 24, "Print",ExpressionUUID->"f1e79984-dea5-4d53-aff8-0121d87d1ba8"],
Cell[111844, 2966, 831, 21, 32, "Print",ExpressionUUID->"cda8967f-f7b6-4ae6-bd7f-68c2c43bfc1a"],
Cell[112678, 2989, 1083, 27, 43, "Print",ExpressionUUID->"fd47a358-d6af-44e3-a238-3661eb64e32f"],
Cell[113764, 3018, 802, 20, 24, "Print",ExpressionUUID->"636b5fbc-ed6b-4385-abe9-6b1942b1f42f"],
Cell[114569, 3040, 1114, 28, 40, "Print",ExpressionUUID->"fcedaed5-0fce-40f0-905a-d9f53c40a946"],
Cell[115686, 3070, 802, 20, 24, "Print",ExpressionUUID->"772f2d3a-3579-483d-a03e-7a6fe3784b15"],
Cell[116491, 3092, 1261, 31, 24, "Print",ExpressionUUID->"681c2cd9-a163-4e35-a275-7c26ccb7d5dc"],
Cell[117755, 3125, 802, 20, 24, "Print",ExpressionUUID->"c3e22ff8-0bd6-442a-90e1-831dee2e027f"],
Cell[118560, 3147, 1079, 27, 43, "Print",ExpressionUUID->"a4390e3c-8740-45ab-9901-7f108b171b45"],
Cell[119642, 3176, 802, 20, 24, "Print",ExpressionUUID->"9b841639-795a-42a3-bb5f-50b9f1671bc9"],
Cell[120447, 3198, 972, 23, 24, "Print",ExpressionUUID->"8ee78a2a-1b76-4e4e-826d-6588044c1be6"],
Cell[121422, 3223, 802, 20, 24, "Print",ExpressionUUID->"f8426665-3790-4c47-8a08-b9ca7755db95"],
Cell[122227, 3245, 1024, 25, 40, "Print",ExpressionUUID->"46980414-fc06-44ea-ab4d-4d4602a8a6b3"],
Cell[123254, 3272, 802, 20, 24, "Print",ExpressionUUID->"cbc3b384-a187-4e66-9d8d-04a836cc6d8a"],
Cell[124059, 3294, 1114, 28, 40, "Print",ExpressionUUID->"b4194b35-c90c-4b07-aa5c-7b8dcc03b4b3"],
Cell[125176, 3324, 802, 20, 24, "Print",ExpressionUUID->"23965e14-18be-4c52-a9b8-ed8233f611e9"],
Cell[125981, 3346, 1062, 26, 25, "Print",ExpressionUUID->"3c67c409-8e46-4b7e-be17-a4639b2efb61"],
Cell[127046, 3374, 802, 20, 24, "Print",ExpressionUUID->"6dbf062b-5278-4182-9743-da6eb108bd7b"],
Cell[127851, 3396, 1259, 32, 40, "Print",ExpressionUUID->"8b0d34a9-2ddb-4439-a6cd-5c886642168d"],
Cell[129113, 3430, 802, 20, 24, "Print",ExpressionUUID->"f97cf970-24af-4102-a917-f4a0dd329e32"],
Cell[129918, 3452, 1020, 25, 40, "Print",ExpressionUUID->"a548545f-1d57-4442-8a40-3fde15c88d0e"],
Cell[130941, 3479, 802, 20, 24, "Print",ExpressionUUID->"c8add4cf-3993-4132-8fab-9ab14266e072"],
Cell[131746, 3501, 1499, 38, 40, "Print",ExpressionUUID->"c4e9f1a3-7e37-4be6-8d51-d812cc9b9d4a"],
Cell[133248, 3541, 802, 20, 24, "Print",ExpressionUUID->"b5a17163-4ccf-4141-9ec6-f2ce4005e0a5"],
Cell[134053, 3563, 1020, 25, 26, "Print",ExpressionUUID->"9fb55b7b-3c42-4f0f-b414-dce94a5fe8bb"],
Cell[135076, 3590, 802, 20, 24, "Print",ExpressionUUID->"69024184-4e4d-497a-a6dc-d4b17cd683f8"],
Cell[135881, 3612, 1081, 27, 25, "Print",ExpressionUUID->"e8d435c8-293e-415b-8af1-1933155ad691"],
Cell[136965, 3641, 802, 20, 24, "Print",ExpressionUUID->"92c2889e-843c-4b78-8c00-df645c7b79cb"],
Cell[137770, 3663, 1048, 26, 26, "Print",ExpressionUUID->"a58e9b9b-95fc-4ddd-b084-1b4585561f66"],
Cell[138821, 3691, 802, 20, 24, "Print",ExpressionUUID->"b6ab20b0-25e3-49a9-b077-7131567c4f87"],
Cell[139626, 3713, 1081, 27, 25, "Print",ExpressionUUID->"d7fd8c78-f7a7-431a-9410-753dfe4002f3"],
Cell[140710, 3742, 802, 20, 24, "Print",ExpressionUUID->"6be9eb09-648a-4d7c-94b8-e6bb9b22dfee"],
Cell[141515, 3764, 1279, 31, 26, "Print",ExpressionUUID->"339dfb68-fe66-464a-9922-6ecdd19dce3a"],
Cell[142797, 3797, 802, 20, 24, "Print",ExpressionUUID->"56f623f2-e6ee-4f53-bec6-d60d36b48749"],
Cell[143602, 3819, 1237, 30, 24, "Print",ExpressionUUID->"6f265d4c-2bbe-4d0a-adb3-a07e6a0438c1"],
Cell[144842, 3851, 802, 20, 24, "Print",ExpressionUUID->"e65cf0ce-4487-429b-a127-37a4d1738c39"],
Cell[145647, 3873, 579, 12, 24, "Print",ExpressionUUID->"5cab396c-1a4c-4808-8cb6-1be5d033800f"],
Cell[146229, 3887, 916, 20, 24, "Print",ExpressionUUID->"270b94aa-68e6-46e5-b61c-41b16873dbf9"],
Cell[147148, 3909, 831, 21, 32, "Print",ExpressionUUID->"edbd2fbb-2318-472c-b5cf-04209814d409"],
Cell[147982, 3932, 911, 21, 26, "Print",ExpressionUUID->"b983cc54-6d73-4a4e-b8ca-5755fd2d625d"],
Cell[148896, 3955, 802, 20, 24, "Print",ExpressionUUID->"ede8d97a-79d6-4683-89ca-53497f155b95"],
Cell[149701, 3977, 1508, 41, 40, "Print",ExpressionUUID->"4f65030a-a9a6-4b69-b78f-2c78c7eef7ab"],
Cell[151212, 4020, 802, 20, 24, "Print",ExpressionUUID->"b0fe351d-bf42-4638-85fe-094376ef3752"],
Cell[152017, 4042, 1046, 26, 26, "Print",ExpressionUUID->"c0ccaf75-b81f-4fcf-bd14-7de44f892534"],
Cell[153066, 4070, 802, 20, 24, "Print",ExpressionUUID->"48e497b3-5996-4b05-a841-8a7a58857b32"],
Cell[153871, 4092, 1080, 26, 26, "Print",ExpressionUUID->"2c2a9d66-6d3d-48a5-8189-5ac874a54494"],
Cell[154954, 4120, 802, 20, 24, "Print",ExpressionUUID->"71816bcd-e1e5-4092-afd3-19e3ba0f1e01"],
Cell[155759, 4142, 1674, 45, 40, "Print",ExpressionUUID->"799afa37-b2a6-4910-b1d0-3394c80687f7"],
Cell[157436, 4189, 802, 20, 24, "Print",ExpressionUUID->"2c95d406-76b9-44d5-af86-7858b6e80106"],
Cell[158241, 4211, 1484, 39, 26, "Print",ExpressionUUID->"04c9b5f4-f877-404d-8e56-e3e6a10ce3bf"],
Cell[159728, 4252, 802, 20, 24, "Print",ExpressionUUID->"1be17b55-59d6-403e-b113-988c53ba5859"],
Cell[160533, 4274, 1587, 42, 28, "Print",ExpressionUUID->"2da138da-bea8-4c71-8ff2-e48f2a0ffb7b"],
Cell[162123, 4318, 802, 20, 24, "Print",ExpressionUUID->"11387d9c-5af7-4235-ab3c-c6eb60226ccd"],
Cell[162928, 4340, 1566, 42, 28, "Print",ExpressionUUID->"36474eba-0bde-468e-a834-fb531e441055"],
Cell[164497, 4384, 802, 20, 24, "Print",ExpressionUUID->"c82ce94e-a228-4e1d-a5fd-c35da73fd855"],
Cell[165302, 4406, 1560, 41, 28, "Print",ExpressionUUID->"17eedcc1-23f4-4b7d-b7b2-b7953e89a1a0"],
Cell[166865, 4449, 802, 20, 24, "Print",ExpressionUUID->"f83322e0-817c-4531-9637-7ba9b1ef041c"],
Cell[167670, 4471, 1035, 26, 25, "Print",ExpressionUUID->"fa4647c7-134e-4d31-8273-a629212ca0ad"],
Cell[168708, 4499, 802, 20, 24, "Print",ExpressionUUID->"4d92d512-8e24-4d58-950b-5856b839d184"],
Cell[169513, 4521, 2258, 62, 40, "Print",ExpressionUUID->"ca30821c-921c-48ec-8d0c-bd0f444bc53b"],
Cell[171774, 4585, 802, 20, 24, "Print",ExpressionUUID->"e4a41945-4b7e-4b4c-891a-d1f8617857bd"],
Cell[172579, 4607, 1249, 32, 25, "Print",ExpressionUUID->"7a34cd54-ac0a-47d5-99fb-95cda825f958"],
Cell[173831, 4641, 802, 20, 24, "Print",ExpressionUUID->"fc3b0bf2-6809-4c4b-ad8b-3758f5f4f16a"],
Cell[174636, 4663, 1077, 26, 41, "Print",ExpressionUUID->"d0a8adba-3c6c-4d2e-9de1-f7277b0f769c"],
Cell[175716, 4691, 802, 20, 24, "Print",ExpressionUUID->"69d26d47-c1c5-470f-8e51-5554dfaa0d9a"],
Cell[176521, 4713, 1129, 29, 47, "Print",ExpressionUUID->"8d3ae777-1953-42e0-ac47-074441cfa17c"],
Cell[177653, 4744, 802, 20, 24, "Print",ExpressionUUID->"20bae36b-3d2a-4b41-aea8-1192c321cede"],
Cell[178458, 4766, 2167, 59, 40, "Print",ExpressionUUID->"a7043c81-7e1e-4140-bbbc-e65f501cea80"],
Cell[180628, 4827, 802, 20, 24, "Print",ExpressionUUID->"ef0a22c5-597b-44ff-a442-b7038472dec0"],
Cell[181433, 4849, 1540, 41, 39, "Print",ExpressionUUID->"b15ebeeb-38ed-4a0a-aa17-22f50d4d1601"],
Cell[182976, 4892, 802, 20, 24, "Print",ExpressionUUID->"43801906-c51c-4a5f-81ac-5b65af722c40"],
Cell[183781, 4914, 579, 12, 24, "Print",ExpressionUUID->"b8f51495-cb66-4a5b-933e-a03f43b7e636"],
Cell[184363, 4928, 916, 20, 24, "Print",ExpressionUUID->"d38bab0b-527d-4fa9-a59c-5a58b71f89cd"],
Cell[185282, 4950, 831, 21, 32, "Print",ExpressionUUID->"4b0662b4-44c2-4289-80ab-984bea24ba93"],
Cell[186116, 4973, 851, 19, 24, "Print",ExpressionUUID->"3b1cb84a-98dd-45c7-9b35-5bd48245926e"],
Cell[186970, 4994, 802, 20, 24, "Print",ExpressionUUID->"c16cf3a1-0761-4af1-9c1f-b7a83f4faa12"],
Cell[187775, 5016, 969, 23, 26, "Print",ExpressionUUID->"e5ea84c6-abdc-4c0c-a1a9-3224bb08b8f7"],
Cell[188747, 5041, 802, 20, 24, "Print",ExpressionUUID->"4efe4af8-08b2-45fd-9aea-4a4955a013b9"],
Cell[189552, 5063, 1081, 28, 28, "Print",ExpressionUUID->"16dbb471-e17f-4568-8516-2d8444d1aaf4"],
Cell[190636, 5093, 802, 20, 24, "Print",ExpressionUUID->"07489e92-79f4-4a62-aca6-237c0bae018a"],
Cell[191441, 5115, 1041, 26, 25, "Print",ExpressionUUID->"e07f8fd4-c639-406c-8184-a5a729c28802"],
Cell[192485, 5143, 802, 20, 24, "Print",ExpressionUUID->"e2e6477c-ee77-4286-9a11-cc6deaa8db08"],
Cell[193290, 5165, 1016, 26, 25, "Print",ExpressionUUID->"866419d2-7614-45c5-a7a9-0cfe15478611"],
Cell[194309, 5193, 802, 20, 24, "Print",ExpressionUUID->"ddd7ee1f-5149-406d-a0d7-a8569b0d19f6"],
Cell[195114, 5215, 1041, 26, 25, "Print",ExpressionUUID->"8523bf09-ee7f-4a38-83ea-a192f94032dc"],
Cell[196158, 5243, 802, 20, 24, "Print",ExpressionUUID->"84b462ed-8a9e-41fc-9a76-bd6ecdef4ab8"],
Cell[196963, 5265, 1129, 30, 25, "Print",ExpressionUUID->"65be1d4c-164d-41e6-81b7-1b2a4063823d"],
Cell[198095, 5297, 802, 20, 24, "Print",ExpressionUUID->"28d3fc87-254f-4836-8007-81f9f9517299"],
Cell[198900, 5319, 1225, 33, 25, "Print",ExpressionUUID->"9edd6487-31ed-46c8-8275-2ffbd8068037"],
Cell[200128, 5354, 802, 20, 24, "Print",ExpressionUUID->"7874987a-a4aa-4d73-b1a0-c7f1bce93140"],
Cell[200933, 5376, 1062, 27, 25, "Print",ExpressionUUID->"17da6dcd-0b24-476d-b7e5-9b746699be6c"],
Cell[201998, 5405, 802, 20, 24, "Print",ExpressionUUID->"13344c42-d132-4dad-bada-c6258bc9d91d"],
Cell[202803, 5427, 1100, 28, 25, "Print",ExpressionUUID->"6006f8e6-f042-489e-8959-e37eaf5c51cf"],
Cell[203906, 5457, 802, 20, 24, "Print",ExpressionUUID->"9dc40e50-c436-46d3-87a1-99624d39313a"],
Cell[204711, 5479, 913, 21, 25, "Print",ExpressionUUID->"f8daca89-8a79-4f94-a626-2357d049b3e3"],
Cell[205627, 5502, 802, 20, 24, "Print",ExpressionUUID->"c0491f66-47d5-46b3-a07a-aa2aa0247441"],
Cell[206432, 5524, 940, 22, 25, "Print",ExpressionUUID->"5c25eb66-818a-4123-ae54-2673a2c1e82c"],
Cell[207375, 5548, 802, 20, 24, "Print",ExpressionUUID->"0f8c13b4-c833-4f4a-a2d6-e8e2673deb96"],
Cell[208180, 5570, 1047, 27, 25, "Print",ExpressionUUID->"65c5e315-00c3-49f7-bc06-80c97819c141"],
Cell[209230, 5599, 802, 20, 24, "Print",ExpressionUUID->"95ee82eb-cd65-43ac-b359-ed96c46aabfd"],
Cell[210035, 5621, 1043, 26, 25, "Print",ExpressionUUID->"5cc1913e-3657-4132-957f-988f8446a550"],
Cell[211081, 5649, 802, 20, 24, "Print",ExpressionUUID->"7637ed5a-dc1e-44a1-b6ea-07cd9c7f4e37"],
Cell[211886, 5671, 1172, 30, 25, "Print",ExpressionUUID->"3ad3e1c8-865c-4b9d-a8d0-f0923d59b4ed"],
Cell[213061, 5703, 802, 20, 24, "Print",ExpressionUUID->"739906c2-e457-4a83-af01-f1baa6534ee8"],
Cell[213866, 5725, 1145, 29, 25, "Print",ExpressionUUID->"e428504e-aab9-4f3a-a675-a7a5075d91d0"],
Cell[215014, 5756, 802, 20, 24, "Print",ExpressionUUID->"96a2d639-35e7-4a8a-a606-c32aa16aa87e"],
Cell[215819, 5778, 1083, 27, 25, "Print",ExpressionUUID->"22f93232-575c-4cb1-b99c-eb52bf2de270"],
Cell[216905, 5807, 802, 20, 24, "Print",ExpressionUUID->"f5252c5d-2c9c-4f67-8087-5515682c1d65"],
Cell[217710, 5829, 1077, 26, 25, "Print",ExpressionUUID->"c2c814d0-5dae-4adf-932b-aacf75474b58"],
Cell[218790, 5857, 802, 20, 24, "Print",ExpressionUUID->"b767ba34-6dad-4220-9ebf-c4a45bd01eaf"],
Cell[219595, 5879, 1209, 31, 24, "Print",ExpressionUUID->"a9913aad-0078-4b29-9f4e-05db5a1ca5a2"],
Cell[220807, 5912, 802, 20, 24, "Print",ExpressionUUID->"104ace96-71c8-47e2-b3cb-ed254a905e50"],
Cell[221612, 5934, 1155, 29, 25, "Print",ExpressionUUID->"72beaa0d-1bcd-4bfa-b954-79de15596872"],
Cell[222770, 5965, 802, 20, 24, "Print",ExpressionUUID->"9a73e329-4551-425f-98ed-76d551e787b3"],
Cell[223575, 5987, 1067, 27, 25, "Print",ExpressionUUID->"20b21339-e04f-4fe4-9d15-6d770aa947b6"],
Cell[224645, 6016, 802, 20, 24, "Print",ExpressionUUID->"7753070b-2f01-4461-a72b-67907479961a"],
Cell[225450, 6038, 1209, 31, 24, "Print",ExpressionUUID->"2e13778b-19c1-4f17-8606-dbabaf97c515"],
Cell[226662, 6071, 802, 20, 24, "Print",ExpressionUUID->"43a0a6c4-1f06-45a5-ae9a-55eff2c12b43"],
Cell[227467, 6093, 1016, 26, 25, "Print",ExpressionUUID->"361db7cb-4430-4c4e-bdf8-bb221579e914"],
Cell[228486, 6121, 802, 20, 24, "Print",ExpressionUUID->"6e3275e0-a040-4f2a-9ec7-c50574ecdf5c"],
Cell[229291, 6143, 1372, 35, 24, "Print",ExpressionUUID->"d9be16c8-2810-4555-8129-d91f8a62d371"],
Cell[230666, 6180, 802, 20, 24, "Print",ExpressionUUID->"68eb6cc9-e84b-4635-af20-e7c7e46da188"],
Cell[231471, 6202, 1267, 32, 28, "Print",ExpressionUUID->"2f1282fb-794f-4861-abfa-c498c6955c8c"],
Cell[232741, 6236, 802, 20, 24, "Print",ExpressionUUID->"dc90e250-7566-4bbf-913c-64767cd2a53f"],
Cell[233546, 6258, 1051, 28, 43, "Print",ExpressionUUID->"f6a2129e-faa3-4d0c-8035-73cd8b0e1d08"],
Cell[234600, 6288, 802, 20, 24, "Print",ExpressionUUID->"8fee6cbb-06d4-45cc-8405-327b1d960b72"],
Cell[235405, 6310, 1081, 27, 43, "Print",ExpressionUUID->"709d5f69-1600-4d78-9b6b-682a63d2de03"],
Cell[236489, 6339, 802, 20, 24, "Print",ExpressionUUID->"35e5e39f-d857-49e3-8e67-d0e3b0ba4f9a"],
Cell[237294, 6361, 1198, 33, 46, "Print",ExpressionUUID->"cf1e047a-42fe-40e3-b2c6-79403cd7dd1a"],
Cell[238495, 6396, 802, 20, 24, "Print",ExpressionUUID->"2c141518-e1e5-4f62-a805-cc5e6e23099a"],
Cell[239300, 6418, 1166, 29, 41, "Print",ExpressionUUID->"b6deef15-93c5-41a6-a2d4-03b6ffd1f06b"],
Cell[240469, 6449, 802, 20, 24, "Print",ExpressionUUID->"7b145bd7-2cf7-4c88-b76b-141ad962f6a7"],
Cell[241274, 6471, 1212, 31, 41, "Print",ExpressionUUID->"0f4251f3-3075-47f7-93b6-e9f0aa513dac"],
Cell[242489, 6504, 802, 20, 24, "Print",ExpressionUUID->"60cf6b3b-9094-4f4b-b594-67e81b2aa7cd"],
Cell[243294, 6526, 1419, 38, 25, "Print",ExpressionUUID->"afe9d56c-baaf-4bce-8bf5-7868bb5c76d6"],
Cell[244716, 6566, 802, 20, 24, "Print",ExpressionUUID->"265a25d3-b197-4b13-a0a9-06737abde48b"],
Cell[245521, 6588, 1417, 37, 25, "Print",ExpressionUUID->"d12761a3-4c32-478a-944e-49a573cfeb66"],
Cell[246941, 6627, 802, 20, 24, "Print",ExpressionUUID->"857fcccc-4231-4d90-aed5-47b9b7e7f22f"],
Cell[247746, 6649, 1065, 26, 41, "Print",ExpressionUUID->"93981490-6525-4dd5-96f4-e1d64338fddc"],
Cell[248814, 6677, 802, 20, 24, "Print",ExpressionUUID->"b2c99df2-4991-491f-9f51-fb915ba2aad4"],
Cell[249619, 6699, 994, 24, 26, "Print",ExpressionUUID->"95a5eeaa-302e-49b7-828e-7df0de5ea702"],
Cell[250616, 6725, 802, 20, 24, "Print",ExpressionUUID->"464c7abd-2d2b-49b7-9a26-9f22f77412f6"],
Cell[251421, 6747, 983, 25, 26, "Print",ExpressionUUID->"e9ea9387-bf8f-482e-92b0-b1877ae17396"],
Cell[252407, 6774, 802, 20, 24, "Print",ExpressionUUID->"9f8041d0-74b9-4f4a-878f-b0f19f3c69fa"],
Cell[253212, 6796, 1142, 28, 24, "Print",ExpressionUUID->"9a70e17b-e9bd-4eb7-984e-d2a624a32d95"],
Cell[254357, 6826, 802, 20, 24, "Print",ExpressionUUID->"468c06c1-2437-4aa5-adba-2bae30dd2318"],
Cell[255162, 6848, 579, 12, 24, "Print",ExpressionUUID->"1f63ae10-4238-4047-80bc-a6c5a4f87054"],
Cell[255744, 6862, 916, 20, 24, "Print",ExpressionUUID->"c336f616-3111-4603-a51b-9851eb73911a"],
Cell[256663, 6884, 831, 21, 32, "Print",ExpressionUUID->"ca6ae5b7-74bd-44d6-a5df-edf668a8bb77"],
Cell[257497, 6907, 1266, 32, 26, "Print",ExpressionUUID->"82b257de-ebe1-40dd-bdea-8a5b571e4c14"],
Cell[258766, 6941, 802, 20, 24, "Print",ExpressionUUID->"18df3f58-7747-4ea6-8b94-ca72887aba72"],
Cell[259571, 6963, 1654, 42, 24, "Print",ExpressionUUID->"0312161a-330e-432a-beeb-17a823a825be"],
Cell[261228, 7007, 802, 20, 24, "Print",ExpressionUUID->"e46cc0ad-e125-428d-90cd-3dedf0d939cb"],
Cell[262033, 7029, 1390, 36, 40, "Print",ExpressionUUID->"f58b4bb9-86ed-43d0-af36-af02206578b0"],
Cell[263426, 7067, 802, 20, 24, "Print",ExpressionUUID->"ee3b9dd5-abb9-48d5-872d-524f934608d7"],
Cell[264231, 7089, 1727, 46, 47, "Print",ExpressionUUID->"c9b6444e-af3d-4fcb-a04c-ef7af5fac1f7"],
Cell[265961, 7137, 802, 20, 24, "Print",ExpressionUUID->"ccf87941-b43d-4d54-a643-4845edbd6050"],
Cell[266766, 7159, 1073, 26, 24, "Print",ExpressionUUID->"0d5a5f03-5bad-43c6-9cf3-a9a16dd5adba"],
Cell[267842, 7187, 802, 20, 24, "Print",ExpressionUUID->"1d6aa5da-760c-43b4-b368-1d2cab65f2f1"],
Cell[268647, 7209, 1142, 28, 24, "Print",ExpressionUUID->"b6a85754-0141-4635-adf8-0fec23ca69f1"],
Cell[269792, 7239, 802, 20, 24, "Print",ExpressionUUID->"380b4d7a-8a98-44a2-a7ca-7cdc30bf2a8b"],
Cell[270597, 7261, 1141, 28, 24, "Print",ExpressionUUID->"777201e6-8775-4938-bb28-4f0c1996f735"],
Cell[271741, 7291, 802, 20, 24, "Print",ExpressionUUID->"5c799b6f-7807-47e8-a60f-20d3d48d1b8d"],
Cell[272546, 7313, 1277, 32, 40, "Print",ExpressionUUID->"8863ae6c-57e3-46d4-a643-620d7087b070"],
Cell[273826, 7347, 802, 20, 24, "Print",ExpressionUUID->"621a8c87-8578-48fd-9f04-86efdc405c66"],
Cell[274631, 7369, 1226, 31, 43, "Print",ExpressionUUID->"f2d534da-eb82-4c51-9c4f-d6aff4ad1f32"],
Cell[275860, 7402, 802, 20, 24, "Print",ExpressionUUID->"b2802c5a-2f1d-46ba-8cea-11249e10e472"],
Cell[276665, 7424, 1452, 37, 26, "Print",ExpressionUUID->"ce77a5da-2fa7-4b6f-8e95-619a7125e1db"],
Cell[278120, 7463, 802, 20, 24, "Print",ExpressionUUID->"dc356c3a-2a8d-4883-a903-2853337198e3"],
Cell[278925, 7485, 939, 22, 26, "Print",ExpressionUUID->"2e5ffdd9-0eaa-4bc2-bcc4-16e9eb4a94ad"],
Cell[279867, 7509, 802, 20, 24, "Print",ExpressionUUID->"e3e04c72-1174-4c59-a700-d6f09302659b"],
Cell[280672, 7531, 1102, 27, 25, "Print",ExpressionUUID->"0996eac9-25f0-474e-bd40-67416afaa0d0"],
Cell[281777, 7560, 802, 20, 24, "Print",ExpressionUUID->"40c6f4c2-91ed-4895-8a23-4b7125eeba4e"],
Cell[282582, 7582, 1477, 39, 42, "Print",ExpressionUUID->"7c0c802f-a792-4b96-991d-316a66653f38"],
Cell[284062, 7623, 802, 20, 24, "Print",ExpressionUUID->"77c18586-e017-4511-9905-7b90a37d47ab"],
Cell[284867, 7645, 1676, 44, 43, "Print",ExpressionUUID->"ee85af93-0e5c-4bfe-971e-b4241d8335be"],
Cell[286546, 7691, 802, 20, 24, "Print",ExpressionUUID->"bbe9057d-daac-43b9-9a59-2ce882d6f9b9"],
Cell[287351, 7713, 579, 12, 24, "Print",ExpressionUUID->"c7a56d94-03db-4b7f-b3f8-0b7783412a52"],
Cell[287933, 7727, 920, 20, 24, "Print",ExpressionUUID->"6b302af9-a679-476c-9553-c363114a806b"],
Cell[288856, 7749, 831, 21, 32, "Print",ExpressionUUID->"4aae56ad-8d6f-45cb-ac54-622d90d65666"],
Cell[289690, 7772, 973, 24, 26, "Print",ExpressionUUID->"58a6014e-648a-4c1b-97d9-38811c3c02d3"],
Cell[290666, 7798, 802, 20, 24, "Print",ExpressionUUID->"3af8aeb4-c4c2-48ac-90cc-89ed5ba63778"],
Cell[291471, 7820, 1019, 26, 26, "Print",ExpressionUUID->"b19ed76e-511b-4fb1-9b9c-adf246cf3061"],
Cell[292493, 7848, 802, 20, 24, "Print",ExpressionUUID->"2518eaa9-7e90-4390-bdc6-f03d096d4d66"],
Cell[293298, 7870, 1078, 28, 44, "Print",ExpressionUUID->"85e121a4-b5f7-4ccb-bd15-dfbe84be0e80"],
Cell[294379, 7900, 802, 20, 24, "Print",ExpressionUUID->"ae596fd5-9343-4cf9-9557-ddeb1285dd8e"],
Cell[295184, 7922, 1078, 28, 44, "Print",ExpressionUUID->"3ce10a68-8eda-4943-a1da-d65cda96bc8b"],
Cell[296265, 7952, 802, 20, 24, "Print",ExpressionUUID->"0a72451d-ef89-42a3-814c-311591f0bdc8"],
Cell[297070, 7974, 1204, 31, 44, "Print",ExpressionUUID->"5c4e99ce-1262-4c02-b02f-b703b0d2384d"],
Cell[298277, 8007, 802, 20, 24, "Print",ExpressionUUID->"c462e926-c106-426f-b38c-3c206f559d51"],
Cell[299082, 8029, 1202, 31, 27, "Print",ExpressionUUID->"7db9be44-7aff-4dc7-b75f-a91b1be1d580"],
Cell[300287, 8062, 802, 20, 24, "Print",ExpressionUUID->"c86f970e-f61e-40ce-b3d2-8c4dd9d07683"],
Cell[301092, 8084, 1162, 31, 25, "Print",ExpressionUUID->"e560002c-8fb6-4ff7-bf08-78dc6cc5b154"],
Cell[302257, 8117, 802, 20, 24, "Print",ExpressionUUID->"5adadfd9-4c8c-4512-b907-86aee3871555"],
Cell[303062, 8139, 938, 22, 26, "Print",ExpressionUUID->"0640751d-6ccc-4460-bcff-5969a47a1bd0"],
Cell[304003, 8163, 802, 20, 24, "Print",ExpressionUUID->"424c3e8e-e55a-4f1b-bb58-ab52d01abc57"],
Cell[304808, 8185, 911, 21, 26, "Print",ExpressionUUID->"858b6d2a-e154-4061-a5d3-d1a6aaafe4cf"],
Cell[305722, 8208, 802, 20, 24, "Print",ExpressionUUID->"62bb7f5e-0322-4f65-9172-565d71425cfa"],
Cell[306527, 8230, 1078, 28, 25, "Print",ExpressionUUID->"81892f27-6971-4943-8ec9-17baf508d366"],
Cell[307608, 8260, 802, 20, 24, "Print",ExpressionUUID->"b9b084a3-a943-4ee3-987f-b48bd89399d6"],
Cell[308413, 8282, 1201, 31, 27, "Print",ExpressionUUID->"aa970aee-5385-43e3-b41d-e95ab2a1ead9"],
Cell[309617, 8315, 802, 20, 24, "Print",ExpressionUUID->"8680443d-76bc-4af4-996d-64310042c754"],
Cell[310422, 8337, 1093, 29, 40, "Print",ExpressionUUID->"e4f963c4-275e-4ca6-b1a7-881e3e4addd8"],
Cell[311518, 8368, 802, 20, 24, "Print",ExpressionUUID->"872002ca-743c-44e8-90f8-14aaa2cb7a55"],
Cell[312323, 8390, 1090, 28, 40, "Print",ExpressionUUID->"169d0628-8c1a-4bdc-9c08-56aaf2e6b963"],
Cell[313416, 8420, 802, 20, 24, "Print",ExpressionUUID->"1ef96fae-affe-4ae3-a4c9-e1ed5f79b6b3"],
Cell[314221, 8442, 1591, 43, 40, "Print",ExpressionUUID->"efbd88c1-ff62-480c-9775-301b1676d4bb"],
Cell[315815, 8487, 802, 20, 24, "Print",ExpressionUUID->"978a4306-7282-4633-899b-4d7371180a5e"],
Cell[316620, 8509, 579, 12, 24, "Print",ExpressionUUID->"2c6c1750-20c0-4033-b90c-fad447fe53a8"],
Cell[317202, 8523, 920, 20, 24, "Print",ExpressionUUID->"51144062-d821-4b33-aa23-2aee436e41b2"],
Cell[318125, 8545, 831, 21, 32, "Print",ExpressionUUID->"341c87e9-c405-4bb9-9e50-f4ae6baff0bc"],
Cell[318959, 8568, 1194, 30, 26, "Print",ExpressionUUID->"eb0b4dc3-3300-4a6d-906e-333c94d8374c"],
Cell[320156, 8600, 802, 20, 24, "Print",ExpressionUUID->"69c1976f-d2f3-41a8-8666-e50bf0a91910"],
Cell[320961, 8622, 1194, 30, 26, "Print",ExpressionUUID->"685ac53c-e3e8-4ec7-813b-18978850f957"],
Cell[322158, 8654, 802, 20, 24, "Print",ExpressionUUID->"3c24e711-9e3b-44f8-b487-b60a098021c2"],
Cell[322963, 8676, 1429, 37, 27, "Print",ExpressionUUID->"aeb5d7b2-1a90-4236-91cd-b362f12b2593"],
Cell[324395, 8715, 802, 20, 24, "Print",ExpressionUUID->"8d2537af-177f-46af-8a60-308fd3349d7e"],
Cell[325200, 8737, 1621, 41, 25, "Print",ExpressionUUID->"3e062945-a1a1-4573-846e-49d19c946a30"],
Cell[326824, 8780, 802, 20, 24, "Print",ExpressionUUID->"abf61198-b221-46b9-885a-762fb7e047d8"],
Cell[327629, 8802, 1496, 38, 47, "Print",ExpressionUUID->"c12f64c0-2dde-479b-88f5-16bdd8d8612a"],
Cell[329128, 8842, 802, 20, 24, "Print",ExpressionUUID->"3b127387-d788-47c4-82cc-08c3836ba862"],
Cell[329933, 8864, 1163, 29, 25, "Print",ExpressionUUID->"f263ab7d-e8b6-4de1-84fd-38199bda4501"],
Cell[331099, 8895, 802, 20, 24, "Print",ExpressionUUID->"1601e213-49ea-4faf-b668-525d82386308"],
Cell[331904, 8917, 1163, 29, 25, "Print",ExpressionUUID->"a1406808-d4fc-4156-ae01-1e5bdae75289"],
Cell[333070, 8948, 802, 20, 24, "Print",ExpressionUUID->"9f1acc67-4850-470f-adc0-c2a2a7e421c3"],
Cell[333875, 8970, 579, 12, 24, "Print",ExpressionUUID->"60beeb8c-9122-42f9-b387-31066795c282"],
Cell[334457, 8984, 920, 20, 24, "Print",ExpressionUUID->"0e38003f-2f8a-4c6d-8834-c349df0bf921"],
Cell[335380, 9006, 717, 16, 24, "Print",ExpressionUUID->"a59e1ec5-5499-4803-8c2c-ad8898d45e84"]
}, Open  ]]
}, Open  ]],
Cell[336124, 9026, 365, 8, 30, "Input",ExpressionUUID->"56408ebb-6000-4c39-a8a4-3b6ff23e5b72"]
}
]
*)

