(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    156289,       3705]
NotebookOptionsPosition[    145217,       3564]
NotebookOutlinePosition[    145556,       3579]
CellTagsIndexPosition[    145513,       3576]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Acute triangles", "Section",
 CellChangeTimes->{{3.825928699994082*^9, 
  3.825928706561873*^9}},ExpressionUUID->"5edc58f7-4143-400e-a0f3-\
6e78a44f6f6e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"timeConstraint", "=", "10"}], ";"}], " ", 
  RowBox[{"(*", " ", "seconds", " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"showExpression", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"showConditionsForEquality", "=", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"showSteps", "=", "False"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"showRegions", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"triangcount", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"triangtrue", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"totalTime", "=", "0"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "From", " ", "Wikipedia", " ", "entry", " ", "for", " ", "acute", " ", 
    "and", " ", "obtuse", " ", "triangles"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Wikipedia\>\"", ",", "Blue", ",", " ", "18", ",", "Bold"}], 
    "]"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"time", ",", "result"}], "}"}], "=", 
   RowBox[{"Timing", "[", "\n", 
    RowBox[{
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"Cos", "[", "A", "]"}], "^", "2"}], "]"}], "<=", "1"}], 
       ",", "\"\<acute\>\""}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "*", 
          RowBox[{
           RowBox[{"Cos", "[", "A", "]"}], "^", "3"}]}], "]"}], 
        "\[LessEqual]", 
        RowBox[{"a", "*", "b", "*", 
         RowBox[{"c", "/", 
          RowBox[{"(", 
           RowBox[{"4", 
            RowBox[{"R", "^", "2"}]}], ")"}]}]}]}], ",", "\"\<acute\>\""}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "*", 
          RowBox[{
           RowBox[{"Cos", "[", "A", "]"}], "^", "3"}]}], "]"}], 
        "\[LessEqual]", 
        RowBox[{"a", "*", "b", "*", 
         RowBox[{"c", "/", 
          RowBox[{"(", 
           RowBox[{"4", 
            RowBox[{"R", "^", "2"}]}], ")"}]}]}]}], ",", "\"\<acute\>\""}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"csum", "[", 
          RowBox[{
           RowBox[{"Cos", "[", "A", "]"}], "^", "3"}], "]"}], "+", 
         RowBox[{"cprod", "[", 
          RowBox[{"Cos", "[", "A", "]"}], "]"}]}], "\[GreaterEqual]", 
        RowBox[{"1", "/", "2"}]}], ",", "\"\<acute\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"Sin", "[", "A", "]"}], 
          RowBox[{"Sin", "[", "B", "]"}]}], "]"}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"csum", "[", 
          RowBox[{"Cos", "[", "A", "]"}], "]"}], "^", "2"}]}], ",", 
       "\"\<acute\>\""}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"Tan", "[", "A", "]"}], "]"}], ">", "0"}], ",", 
       "\"\<acute\>\""}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"Tan", "[", "A", "]"}], "]"}], "\[GreaterEqual]", 
        RowBox[{"2", 
         RowBox[{"csum", "[", 
          RowBox[{"Sin", "[", 
           RowBox[{"2", "A"}], "]"}], "]"}]}]}], ",", "\"\<acute\>\""}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"csum", "[", 
          RowBox[{"Tan", "[", "A", "]"}], "]"}], "^", "2"}], ">=", 
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Sec", "[", "A", "]"}], "+", "1"}], ")"}], "^", "2"}], 
         "]"}]}], ",", "\"\<acute\>\""}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "*", 
          RowBox[{"Tan", "[", "A", "]"}]}], "]"}], "\[GreaterEqual]", 
        RowBox[{
         RowBox[{"10", "R"}], "-", 
         RowBox[{"2", "r"}]}]}], ",", "\"\<acute\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"m", "[", "a", "]"}], "^", "2"}], "]"}], ">", 
        RowBox[{"6", 
         RowBox[{"R", "^", "2"}]}]}], ",", "\"\<acute\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"r", "^", "2"}], "+", 
         RowBox[{"csum", "[", 
          RowBox[{
           RowBox[{"r", "[", "a", "]"}], "^", "2"}], "]"}]}], "<", 
        RowBox[{"8", 
         RowBox[{"R", "^", "2"}]}]}], ",", "\"\<acute\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "*", "b"}], "]"}], "\[GreaterEqual]", 
        RowBox[{
         RowBox[{"2", "R", 
          RowBox[{"(", 
           RowBox[{"R", "+", "r"}], ")"}]}], "+", 
         RowBox[{"8", 
          RowBox[{"K", "/", 
           RowBox[{"Sqrt", "[", "3", "]"}]}]}]}]}], ",", "\"\<acute\>\""}], 
      "]"}], ";"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"totalTime", "+=", "time"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<\\nProved \>\"", ",", "triangtrue", ",", 
     "\"\< inequalities out of \>\"", ",", "triangcount", ",", 
     "\"\<. Time=\>\"", ",", "time"}], "]"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"From", " ", "Bottema", " ", "Section", " ", "11"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"triangcount", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"triangtrue", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"totalTime", "=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Bottema\>\"", ",", "Blue", ",", " ", "18", ",", "Bold"}], 
    "]"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"time", ",", "result"}], "}"}], "=", 
   RowBox[{"Timing", "[", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", "11.2", " ", "*)"}], "\n", 
    RowBox[{
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"csum", "[", 
          RowBox[{"Cot", "[", 
           RowBox[{"2", "A"}], "]"}], "]"}]}], "\[GreaterEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{"Cot", "[", "A", "]"}], "]"}]}], ",", "\"\<acute\>\""}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"Cot", "[", "A", "]"}], "]"}], "\[GreaterEqual]", 
        RowBox[{"Sqrt", "[", "3", "]"}]}], ",", "\"\<acute\>\""}], "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "11.4", " ", "*)"}], "\n", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"Tan", "[", "A", "]"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Cot", "[", "B", "]"}], "+", 
            RowBox[{"Cot", "[", "C", "]"}]}], ")"}]}], "]"}], 
        "\[GreaterEqual]", "6"}], ",", "\"\<acute\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "11.5", " ", "*)"}], "\n", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"cprod", "[", 
         RowBox[{"Tan", "[", "A", "]"}], "]"}], "\[GreaterEqual]", 
        RowBox[{"3", 
         RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", "\"\<acute\>\""}], "]"}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "11.6", " ", "*)"}], "\n", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"Tan", "[", "A", "]"}], "]"}], "\[GreaterEqual]", 
        RowBox[{"3", 
         RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", "\"\<acute\>\""}], "]"}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "11.7", " ", "*)"}], "\n", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"Tan", "[", "A", "]"}], "^", "6"}], "]"}], ">", "12"}], 
       ",", "\"\<acute\>\""}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "11.8", " ", "*)"}], "\n", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"Tan", "[", "A", "]"}], "^", "5"}], "]"}], 
        "\[GreaterEqual]", 
        RowBox[{"3", 
         RowBox[{
          RowBox[{"Sqrt", "[", "3", "]"}], "^", "5"}]}]}], ",", 
       "\"\<acute\>\""}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"11.9", " ", "modified"}], " ", "*)"}], "\n", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"csum", "[", 
          RowBox[{"Sin", "[", "A", "]"}], "]"}], "+", 
         RowBox[{"csum", "[", 
          RowBox[{"Tan", "[", "A", "]"}], "]"}]}], ">", 
        RowBox[{"9", 
         RowBox[{
          RowBox[{"Sqrt", "[", "3", "]"}], "/", "2"}]}]}], ",", 
       "\"\<acute\>\""}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "11.10", " ", "*)"}], "\n", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"csum", "[", 
          RowBox[{"Sin", "[", 
           RowBox[{"2", "A"}], "]"}], "]"}], "/", 
         RowBox[{"csum", "[", 
          RowBox[{"Sin", "[", 
           RowBox[{"4", "A"}], "]"}], "]"}]}], "\[LessEqual]", 
        RowBox[{"-", "1"}]}], ",", "\"\<acute\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "11.18", " ", "*)"}], "\n", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"4", 
         RowBox[{"csum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Cos", "[", "B", "]"}], "^", "2"}], 
           RowBox[{
            RowBox[{"Cos", "[", "C", "]"}], "^", "2"}]}], "]"}]}], 
        "\[LessEqual]", 
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"Cos", "[", "A", "]"}], "^", "2"}], "]"}]}], ",", 
       "\"\<acute\>\""}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"4", 
          RowBox[{"csum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Cos", "[", "B", "]"}], "^", "2"}], 
            RowBox[{
             RowBox[{"Cos", "[", "C", "]"}], "^", "2"}]}], "]"}]}], "+", 
         RowBox[{"16", 
          RowBox[{"cprod", "[", 
           RowBox[{
            RowBox[{"Cos", "[", "A", "]"}], "^", "2"}], "]"}]}]}], 
        "\[LessEqual]", "1"}], ",", "\"\<acute\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "11.27", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"s", "-", "r"}], ">", 
        RowBox[{"2", "R"}]}], ",", "\"\<acute\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"Sin", "[", "A", "]"}], "^", "2"}], "]"}], ">", "2"}], ",", 
       "\"\<acute\>\""}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "^", "2"}], "]"}], ">", 
        RowBox[{"8", 
         RowBox[{"R", "^", "2"}]}]}], ",", "\"\<acute\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"cprod", "[", 
         RowBox[{"s", "-", 
          RowBox[{"r", "[", "a", "]"}]}], "]"}], ">", "0"}], ",", 
       "\"\<acute\>\""}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "11.28", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"h", "[", "a", "]"}], "]"}], ">=", 
        RowBox[{
         RowBox[{"2", "R"}], "+", 
         RowBox[{"4", "r"}], "+", 
         RowBox[{
          RowBox[{"r", "^", "2"}], "/", "R"}]}]}], ",", "\"\<acute\>\""}], 
      "]"}], ";"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"totalTime", "+=", "time"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<\\nProved \>\"", ",", "triangtrue", ",", 
     "\"\< inequalities out of \>\"", ",", "triangcount", ",", 
     "\"\<. Time=\>\"", ",", "time"}], "]"}], ";"}], "\n", 
  "\[IndentingNewLine]", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"From", " ", "Mitrinov", " ", "Section", " ", "10.2"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"triangcount", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"triangtrue", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"totalTime", "=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Mitrinovic\>\"", ",", "Blue", ",", " ", "18", ",", "Bold"}], 
    "]"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"time", ",", "result"}], "}"}], "=", 
   RowBox[{"Timing", "[", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", "2.1", " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"Ono", "'"}], "s", " ", "inequality"}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"27", 
         RowBox[{"cprod", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", "^", "2"}], "+", 
             RowBox[{"c", "^", "2"}], "-", 
             RowBox[{"a", "^", "2"}]}], ")"}], "^", "2"}], "]"}]}], 
        "\[LessEqual]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "K"}], ")"}], "^", "6"}]}], ",", "\"\<acute\>\""}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"s", "^", "2"}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "R"}], "+", "r"}], ")"}], "^", "2"}]}], 
        "\[LessEqual]", 
        RowBox[{"2", 
         RowBox[{"Sqrt", "[", "3", "]"}], 
         RowBox[{"K", "/", "9"}]}]}], ",", "\"\<acute\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "2.2", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"cprod", "[", 
          RowBox[{"Tan", "[", "A", "]"}], "]"}], 
         RowBox[{"cprod", "[", 
          RowBox[{"Sin", "[", "A", "]"}], "]"}]}], "\[GreaterEqual]", 
        RowBox[{"27", "/", "8"}]}], ",", "\"\<acute\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"Tan", "[", "A", "]"}], "]"}], "\[GreaterEqual]", 
        RowBox[{"27", 
         RowBox[{
          RowBox[{"R", "^", "2"}], "/", 
          RowBox[{"(", 
           RowBox[{"4", "K"}], ")"}]}]}]}], ",", "\"\<acute\>\""}], "]"}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"Tan", "[", "A", "]"}], "]"}], "\[GreaterEqual]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"27", "/", "8"}], ")"}], 
         RowBox[{"cprod", "[", 
          RowBox[{"Csc", "[", "A", "]"}], "]"}]}]}], ",", "\"\<acute\>\""}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"2.2", " ", "selected", " ", "1"}], ",", " ", 
       RowBox[{"2", " ", 
        RowBox[{"(", "corrected", ")"}]}], ",", " ", "33", ",", " ", "35", 
       ",", " ", 
       RowBox[{"50", " ", 
        RowBox[{"(", "corrected", ")"}]}]}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"b", "*", "c"}], "]"}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"4", 
          RowBox[{"R", "^", "2"}]}], "+", 
         RowBox[{"8", "R", "*", "r"}], "+", 
         RowBox[{"2", 
          RowBox[{"r", "^", "2"}]}], "+", 
         RowBox[{"8", 
          RowBox[{
           RowBox[{"K", "^", "2"}], "/", 
           RowBox[{"(", 
            RowBox[{"27", 
             RowBox[{"R", "^", "2"}]}], ")"}]}]}]}]}], ",", "\"\<acute\>\""}],
       "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "^", "2"}], "]"}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"8", 
          RowBox[{"R", "^", "2"}]}], "+", 
         RowBox[{"16", 
          RowBox[{
           RowBox[{"K", "^", "2"}], "/", 
           RowBox[{"(", 
            RowBox[{"27", 
             RowBox[{"R", "^", "2"}]}], ")"}]}]}]}]}], ",", "\"\<acute\>\""}],
       "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"Sec", "[", "B", "]"}], 
          RowBox[{"Sec", "[", "C", "]"}]}], "]"}], "\[GreaterEqual]", 
        RowBox[{"27", 
         RowBox[{"R", "^", "3"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"R", "+", "r"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", 
            RowBox[{"K", "^", "2"}]}], ")"}]}]}]}], ",", "\"\<acute\>\""}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"cprod", "[", 
         RowBox[{"Cot", "[", "A", "]"}], "]"}], "\[LessEqual]", 
        RowBox[{"4", 
         RowBox[{"K", "/", 
          RowBox[{"(", 
           RowBox[{"27", 
            RowBox[{"R", "^", "2"}]}], ")"}]}]}]}], ",", "\"\<acute\>\""}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"m", "[", "a", "]"}], "^", "2"}], "]"}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"6", 
          RowBox[{"R", "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"Sqrt", "[", "3", "]"}], 
          RowBox[{"K", "/", "3"}]}]}]}], ",", "\"\<acute\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "2.3", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"s", "^", "2"}], "\[GreaterEqual]", 
        RowBox[{
         RowBox[{"2", 
          RowBox[{"R", "^", "2"}]}], "+", 
         RowBox[{"8", "R", "*", "r"}], "+", 
         RowBox[{"3", 
          RowBox[{"r", "^", "2"}]}]}]}], ",", "\"\<nonobtuse\>\""}], "]"}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"2.3", " ", "selected", " ", "1"}], ",", " ", 
       RowBox[{"2", " ", 
        RowBox[{"(", "corrected", ")"}], " ", "3"}], ",", " ", "4", ",", " ", 
       "40"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"b", "*", "c"}], "]"}], "\[GreaterEqual]", 
        RowBox[{
         RowBox[{"2", 
          RowBox[{"R", "^", "2"}]}], "+", 
         RowBox[{"12", "R", "*", "r"}], "+", 
         RowBox[{"4", 
          RowBox[{"r", "^", "2"}]}]}]}], ",", "\"\<nonobtuse\>\""}], "]"}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"cprod", "[", 
         RowBox[{"a", "^", "2"}], "]"}], "\[GreaterEqual]", 
        RowBox[{"4", 
         RowBox[{"R", "^", "2"}], "*", 
         RowBox[{"r", "^", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", 
            RowBox[{"R", "^", "2"}]}], "+", 
           RowBox[{"8", "R", "*", "r"}], "+", 
           RowBox[{"3", 
            RowBox[{"r", "^", "2"}]}]}], ")"}]}]}], ",", 
       "\"\<nonobtuse\>\""}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "^", "2"}], "]"}], "\[GreaterEqual]", 
        RowBox[{"4", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"R", "+", "r"}], ")"}], "^", "2"}]}]}], ",", 
       "\"\<nonobtuse\>\""}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{"a", "^", "3"}], "]"}], "\[GreaterEqual]", 
        RowBox[{"4", "s", "*", "R", 
         RowBox[{"(", 
          RowBox[{"R", "+", "r"}], ")"}]}]}], ",", "\"\<nonobtuse\>\""}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"proveTriangleInequality", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"csum", "[", 
         RowBox[{
          RowBox[{"Cot", "[", 
           RowBox[{"A", "/", "2"}], "]"}], "^", "3"}], "]"}], 
        "\[GreaterEqual]", 
        RowBox[{"s", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", 
             RowBox[{"R", "^", "2"}]}], "-", 
            RowBox[{"4", "R", "*", "r"}], "+", 
            RowBox[{"3", 
             RowBox[{"r", "^", "2"}]}]}], ")"}], "/", 
          RowBox[{"r", "^", "3"}]}]}]}], ",", "\"\<nonobtuse\>\""}], "]"}], 
     ";"}], "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"totalTime", "+=", "time"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<\\nProved \>\"", ",", "triangtrue", ",", 
    "\"\< inequalities out of \>\"", ",", "triangcount", ",", 
    "\"\<. Time=\>\"", ",", "time"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.825928123407671*^9, 3.825928140711565*^9}, {
   3.8259283803304653`*^9, 3.825928381680416*^9}, {3.8259285448747177`*^9, 
   3.825928601033392*^9}, {3.82592863861112*^9, 3.82592865044162*^9}, {
   3.825928689715378*^9, 3.825928691817883*^9}, {3.825928723138698*^9, 
   3.825928724809884*^9}, {3.825929809815696*^9, 3.825929843630848*^9}, {
   3.825929890744142*^9, 3.8259300515493383`*^9}, {3.825930102262484*^9, 
   3.825930108173216*^9}, {3.8259301423667316`*^9, 3.8259302011501837`*^9}, {
   3.825930232646017*^9, 3.825930438126602*^9}, {3.8259305137395163`*^9, 
   3.8259305379835*^9}, {3.8259305747120647`*^9, 3.8259305992160387`*^9}, {
   3.8259306425006723`*^9, 3.8259306515678596`*^9}, {3.825930692282979*^9, 
   3.825930709729205*^9}, {3.825930828851706*^9, 3.8259308325444603`*^9}, {
   3.8259312449295893`*^9, 3.825931397890163*^9}, {3.825931445418804*^9, 
   3.825931560706348*^9}, {3.825931615147695*^9, 3.8259316779386253`*^9}, {
   3.825931726703433*^9, 3.825931761891139*^9}, {3.82593180202022*^9, 
   3.825931879179469*^9}, {3.8259320127407637`*^9, 3.82593217120426*^9}, {
   3.825932239181682*^9, 3.825932245540556*^9}, {3.825932280639262*^9, 
   3.8259324126292152`*^9}, {3.825932466146051*^9, 3.8259324666773663`*^9}, {
   3.825932497775319*^9, 3.825932498158575*^9}, {3.825933492341228*^9, 
   3.825933506336626*^9}, {3.825935479086409*^9, 3.8259355715974703`*^9}, {
   3.8259356038343554`*^9, 3.825935613206902*^9}, {3.82593569566286*^9, 
   3.825935795342371*^9}, {3.82593588314328*^9, 3.8259359688784037`*^9}, {
   3.825936058636476*^9, 3.825936168591158*^9}, {3.82593628660856*^9, 
   3.825936378367831*^9}, {3.825936418544855*^9, 3.8259364645920067`*^9}, 
   3.825936786041965*^9, 3.825937092242421*^9, {3.825937490043622*^9, 
   3.825937503852625*^9}, {3.825937568984755*^9, 3.825937569923131*^9}, {
   3.8259376416365843`*^9, 3.82593764647543*^9}, {3.825937772080797*^9, 
   3.825938000756618*^9}, {3.825938087029399*^9, 3.825938142461247*^9}, {
   3.825938573583908*^9, 3.8259386055932007`*^9}, {3.825939057670047*^9, 
   3.8259390672990923`*^9}, {3.82594749496144*^9, 3.82594757119285*^9}},
 CellLabel->
  "In[226]:=",ExpressionUUID->"626fd7e9-02af-43bf-86d0-b1f502c32753"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Wikipedia\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontSize->18,
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638094817*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"3aae14e9-fd60-4a6d-a84b-94e3f55f9069"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cos", "[", "A", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "B", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "C", "]"}], "2"]}], "\[LessEqual]", "1"}]}],
  SequenceForm[
  "[", 1, "] ", Cos[$CellContext`A]^2 + Cos[$CellContext`B]^2 + Cos[C]^2 <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.86077563809658*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"2bdfe197-fff4-4817-bd0a-1460052a9581"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638104446*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"2db02c87-473a-48ca-bef5-c264b156932a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "A", "]"}], "3"]}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "B", "]"}], "3"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "C", "]"}], "3"]}]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"a", " ", "b", " ", "c"}], 
     RowBox[{"4", " ", 
      SuperscriptBox["R", "2"]}]]}]}],
  SequenceForm[
  "[", 2, "] ", $CellContext`a Cos[$CellContext`A]^3 + $CellContext`b 
     Cos[$CellContext`B]^3 + $CellContext`c Cos[C]^3 <= 
   Rational[1, 
      4] $CellContext`a $CellContext`b $CellContext`c $CellContext`R^(-2)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756381054697`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"6286af7a-cbaf-4351-8514-3e2c06a49c50"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638136353*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"b00cce4e-6145-4b07-a8ad-4476ad9a9603"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "A", "]"}], "3"]}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "B", "]"}], "3"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "C", "]"}], "3"]}]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"a", " ", "b", " ", "c"}], 
     RowBox[{"4", " ", 
      SuperscriptBox["R", "2"]}]]}]}],
  SequenceForm[
  "[", 3, "] ", $CellContext`a Cos[$CellContext`A]^3 + $CellContext`b 
     Cos[$CellContext`B]^3 + $CellContext`c Cos[C]^3 <= 
   Rational[1, 
      4] $CellContext`a $CellContext`b $CellContext`c $CellContext`R^(-2)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638144114*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"a7d4e434-7712-4e1c-a012-f792ee0657ca"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756381455717`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"9517af1f-8b40-4363-96d3-7d31832b5a9d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cos", "[", "A", "]"}], "3"], "+", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "B", "]"}], "3"], "+", 
     RowBox[{
      RowBox[{"Cos", "[", "A", "]"}], " ", 
      RowBox[{"Cos", "[", "B", "]"}], " ", 
      RowBox[{"Cos", "[", "C", "]"}]}], "+", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "C", "]"}], "3"]}], "\[GreaterEqual]", 
    FractionBox["1", "2"]}]}],
  SequenceForm[
  "[", 4, "] ", 
   Cos[$CellContext`A]^3 + Cos[$CellContext`B]^3 + 
    Cos[$CellContext`A] Cos[$CellContext`B] Cos[C] + Cos[C]^3 >= 
   Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638146809*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"910485e8-39dc-45d4-a284-de7f557ac3c8"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756381900578`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"e563b9f4-a6df-4f5d-9068-565214e850dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "A", "]"}], " ", 
      RowBox[{"Sin", "[", "B", "]"}]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", "A", "]"}], " ", 
      RowBox[{"Sin", "[", "C", "]"}]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", "B", "]"}], " ", 
      RowBox[{"Sin", "[", "C", "]"}]}]}], "\[LessEqual]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Cos", "[", "A", "]"}], "+", 
       RowBox[{"Cos", "[", "B", "]"}], "+", 
       RowBox[{"Cos", "[", "C", "]"}]}], ")"}], "2"]}]}],
  SequenceForm[
  "[", 5, "] ", 
   Sin[$CellContext`A] Sin[$CellContext`B] + Sin[$CellContext`A] Sin[C] + 
    Sin[$CellContext`B] Sin[C] <= (Cos[$CellContext`A] + Cos[$CellContext`B] + 
     Cos[C])^2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756381913767`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"49c5f435-46c1-45b0-9596-9de5ec186881"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638222756*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"4d80bb22-e26b-42b9-832d-202d08e84147"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tan", "[", "A", "]"}], "+", 
     RowBox[{"Tan", "[", "B", "]"}], "+", 
     RowBox[{"Tan", "[", "C", "]"}]}], ">", "0"}]}],
  SequenceForm[
  "[", 6, "] ", Tan[$CellContext`A] + Tan[$CellContext`B] + Tan[C] > 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638224008*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"83615f23-d9ab-4458-9f35-0d0e16af09c5"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638258499*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"91b5d655-de80-4cf3-a616-a9ec66e41083"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tan", "[", "A", "]"}], "+", 
     RowBox[{"Tan", "[", "B", "]"}], "+", 
     RowBox[{"Tan", "[", "C", "]"}]}], "\[GreaterEqual]", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "A"}], "]"}], "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "B"}], "]"}], "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "C"}], "]"}]}], ")"}]}]}]}],
  SequenceForm[
  "[", 7, "] ", Tan[$CellContext`A] + Tan[$CellContext`B] + Tan[C] >= 
   2 (Sin[2 $CellContext`A] + Sin[2 $CellContext`B] + Sin[2 C])],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638259882*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"af855586-c256-4729-8b5b-61eb06027488"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756382932463`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"bd11a948-e4e7-4a1a-92b7-ae687ded9cbd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Tan", "[", "A", "]"}], "+", 
       RowBox[{"Tan", "[", "B", "]"}], "+", 
       RowBox[{"Tan", "[", "C", "]"}]}], ")"}], "2"], "\[GreaterEqual]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Sec", "[", "A", "]"}]}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Sec", "[", "B", "]"}]}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Sec", "[", "C", "]"}]}], ")"}], "2"]}]}]}],
  SequenceForm[
  "[", 8, "] ", (Tan[$CellContext`A] + Tan[$CellContext`B] + 
     Tan[C])^2 >= (1 + Sec[$CellContext`A])^2 + (1 + 
      Sec[$CellContext`B])^2 + (1 + Sec[C])^2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638294532*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"99eda047-5bd1-4f24-9981-eb76715b247d"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638343586*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"bef58bb3-ec70-4403-9f37-bbe483f17cb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Tan", "[", "A", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Tan", "[", "B", "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Tan", "[", "C", "]"}]}]}], "\[GreaterEqual]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "r"}], "+", 
     RowBox[{"10", " ", "R"}]}]}]}],
  SequenceForm[
  "[", 9, "] ", $CellContext`a Tan[$CellContext`A] + $CellContext`b 
     Tan[$CellContext`B] + $CellContext`c Tan[C] >= (-2) $CellContext`r + 
    10 $CellContext`R],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756383449373`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"95d08788-6d5e-4091-bf08-775381bfa765"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756384004593`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"57460dd7-9539-4751-9f46-a62dcd9a2933"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"m", "[", "a", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"m", "[", "b", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"m", "[", "c", "]"}], "2"]}], ">", 
    RowBox[{"6", " ", 
     SuperscriptBox["R", "2"]}]}]}],
  SequenceForm[
  "[", 10, "] ", $CellContext`m[$CellContext`a]^2 + \
$CellContext`m[$CellContext`b]^2 + $CellContext`m[$CellContext`c]^2 > 
   6 $CellContext`R^2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638401743*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"09d2877b-cebc-48ad-9e17-e9bf8bcfb5e4"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756384358397`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"8c898b91-015c-43ba-b961-1a621efc4da2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["r", "2"], "+", 
     SuperscriptBox[
      RowBox[{"r", "[", "a", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"r", "[", "b", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"r", "[", "c", "]"}], "2"]}], "<", 
    RowBox[{"8", " ", 
     SuperscriptBox["R", "2"]}]}]}],
  SequenceForm[
  "[", 11, "] ", $CellContext`r^2 + $CellContext`r[$CellContext`a]^2 + \
$CellContext`r[$CellContext`b]^2 + $CellContext`r[$CellContext`c]^2 < 
   8 $CellContext`R^2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638437162*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"688d81bd-2942-4b85-9b25-894b081958c1"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638438446*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"cbe250af-5c4b-4f69-9321-bad4e20ff0a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "b"}], "+", 
     RowBox[{"a", " ", "c"}], "+", 
     RowBox[{"b", " ", "c"}]}], "\[GreaterEqual]", 
    RowBox[{
     FractionBox[
      RowBox[{"8", " ", "K"}], 
      SqrtBox["3"]], "+", 
     RowBox[{"2", " ", "R", " ", 
      RowBox[{"(", 
       RowBox[{"r", "+", "R"}], ")"}]}]}]}]}],
  SequenceForm[
  "[", 12, "] ", $CellContext`a $CellContext`b + $CellContext`a \
$CellContext`c + $CellContext`b $CellContext`c >= 
   8 3^Rational[-1, 2] K + 2 $CellContext`R ($CellContext`r + $CellContext`R)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638440023*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"5f7c4123-1155-4132-948f-dcfaa6e2b571"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638498798*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"fbca203f-e326-4d0c-a265-3af8a91de822"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nProved \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" inequalities out of \"\>", "\[InvisibleSpace]", 
   "12", "\[InvisibleSpace]", "\<\". Time=\"\>", "\[InvisibleSpace]", 
   "0.414574`"}],
  SequenceForm[
  "\nProved ", 12, " inequalities out of ", 12, ". Time=", 0.414574],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638500037*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"f54d2bef-9461-44d7-966b-8bd17b0f82dd"],

Cell[BoxData[
 StyleBox["\<\"Bottema\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontSize->18,
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756385012302`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"83db0137-ebc9-404b-b910-c6066469224b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cot", "[", 
       RowBox[{"2", " ", "A"}], "]"}]}], "-", 
     RowBox[{"Cot", "[", 
      RowBox[{"2", " ", "B"}], "]"}], "-", 
     RowBox[{"Cot", "[", 
      RowBox[{"2", " ", "C"}], "]"}]}], "\[GreaterEqual]", 
    RowBox[{
     RowBox[{"Cot", "[", "A", "]"}], "+", 
     RowBox[{"Cot", "[", "B", "]"}], "+", 
     RowBox[{"Cot", "[", "C", "]"}]}]}]}],
  SequenceForm[
  "[", 1, "] ", -Cot[2 $CellContext`A] - Cot[2 $CellContext`B] - Cot[2 C] >= 
   Cot[$CellContext`A] + Cot[$CellContext`B] + Cot[C]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756385024347`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"5ffee6ea-62e7-40b1-9bab-85637d460943"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756386016417`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"025fd64b-50c9-4cf9-aaa0-a92b14af9a7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"Cot", "[", "A", "]"}], "+", 
     RowBox[{"Cot", "[", "B", "]"}], "+", 
     RowBox[{"Cot", "[", "C", "]"}]}], "\[GreaterEqual]", 
    SqrtBox["3"]}]}],
  SequenceForm[
  "[", 2, "] ", Cot[$CellContext`A] + Cot[$CellContext`B] + Cot[C] >= 
   3^Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638602862*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"a17eb960-0a73-4bb2-935d-a712ccaf9a15"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756386342993`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"baf439b4-1b72-4280-9bff-3365c7812a99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Cot", "[", "B", "]"}], "+", 
        RowBox[{"Cot", "[", "C", "]"}]}], ")"}], " ", 
      RowBox[{"Tan", "[", "A", "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Cot", "[", "A", "]"}], "+", 
        RowBox[{"Cot", "[", "C", "]"}]}], ")"}], " ", 
      RowBox[{"Tan", "[", "B", "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Cot", "[", "A", "]"}], "+", 
        RowBox[{"Cot", "[", "B", "]"}]}], ")"}], " ", 
      RowBox[{"Tan", "[", "C", "]"}]}]}], "\[GreaterEqual]", "6"}]}],
  SequenceForm[
  "[", 3, "] ", (Cot[$CellContext`B] + Cot[C]) 
     Tan[$CellContext`A] + (Cot[$CellContext`A] + Cot[C]) 
     Tan[$CellContext`B] + (Cot[$CellContext`A] + Cot[$CellContext`B]) Tan[C] >= 
   6],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638635592*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"abd4fd2b-64c6-4aed-ab83-057bde042966"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638681974*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"34b0186d-0ed9-4f19-90d2-011546c2bf9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tan", "[", "A", "]"}], " ", 
     RowBox[{"Tan", "[", "B", "]"}], " ", 
     RowBox[{"Tan", "[", "C", "]"}]}], "\[GreaterEqual]", 
    RowBox[{"3", " ", 
     SqrtBox["3"]}]}]}],
  SequenceForm[
  "[", 4, "] ", Tan[$CellContext`A] Tan[$CellContext`B] Tan[C] >= 
   3 3^Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756386829557`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"855a19a6-a8dd-4931-bb7d-2324df87a0e5"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638800809*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"6690f7c8-4165-4f9d-9bee-46c08a771d50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tan", "[", "A", "]"}], "+", 
     RowBox[{"Tan", "[", "B", "]"}], "+", 
     RowBox[{"Tan", "[", "C", "]"}]}], "\[GreaterEqual]", 
    RowBox[{"3", " ", 
     SqrtBox["3"]}]}]}],
  SequenceForm[
  "[", 5, "] ", Tan[$CellContext`A] + Tan[$CellContext`B] + Tan[C] >= 
   3 3^Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756388018208`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"e785e55c-d72b-4de8-9b34-c89201b953de"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775638835458*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"c8cce7c4-41d9-435b-ba25-cb2446d2971f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tan", "[", "A", "]"}], "6"], "+", 
     SuperscriptBox[
      RowBox[{"Tan", "[", "B", "]"}], "6"], "+", 
     SuperscriptBox[
      RowBox[{"Tan", "[", "C", "]"}], "6"]}], ">", "12"}]}],
  SequenceForm[
  "[", 6, "] ", Tan[$CellContext`A]^6 + Tan[$CellContext`B]^6 + Tan[C]^6 > 12],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756388364487`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"67a6957c-3d80-4136-91a1-75d65c62634e"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756436660843`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"ae5f14cc-f0ec-488a-bbd3-285013e24cbb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tan", "[", "A", "]"}], "5"], "+", 
     SuperscriptBox[
      RowBox[{"Tan", "[", "B", "]"}], "5"], "+", 
     SuperscriptBox[
      RowBox[{"Tan", "[", "C", "]"}], "5"]}], "\[GreaterEqual]", 
    RowBox[{"27", " ", 
     SqrtBox["3"]}]}]}],
  SequenceForm[
  "[", 7, "] ", Tan[$CellContext`A]^5 + Tan[$CellContext`B]^5 + Tan[C]^5 >= 
   27 3^Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775643667097*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"b0df9640-4438-4469-88c4-64da72933217"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756508244658`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"680d2fea-c2ed-43cd-a9a9-8a76b30eb927"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "A", "]"}], "+", 
     RowBox[{"Sin", "[", "B", "]"}], "+", 
     RowBox[{"Sin", "[", "C", "]"}], "+", 
     RowBox[{"Tan", "[", "A", "]"}], "+", 
     RowBox[{"Tan", "[", "B", "]"}], "+", 
     RowBox[{"Tan", "[", "C", "]"}]}], ">", 
    FractionBox[
     RowBox[{"9", " ", 
      SqrtBox["3"]}], "2"]}]}],
  SequenceForm[
  "[", 8, "] ", 
   Sin[$CellContext`A] + Sin[$CellContext`B] + Sin[C] + Tan[$CellContext`A] + 
    Tan[$CellContext`B] + Tan[C] > Rational[9, 2] 3^Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775650825508*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"07bb5bb8-ee81-416b-bf45-428a4def1e9f"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775650997563*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"cd09be91-7b76-438d-91ea-4e6020fb1058"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "A"}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "B"}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "C"}], "]"}]}], 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"4", " ", "A"}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"4", " ", "B"}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"4", " ", "C"}], "]"}]}]], "\[LessEqual]", 
    RowBox[{"-", "1"}]}]}],
  SequenceForm[
  "[", 9, "] ", (Sin[2 $CellContext`A] + Sin[2 $CellContext`B] + Sin[2 C])/(
    Sin[4 $CellContext`A] + Sin[4 $CellContext`B] + Sin[4 C]) <= -1],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775650998644*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"782234af-17dd-45d1-aec6-38344446da68"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651065422*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"147dd595-c514-48d1-9f88-5b2582ed8205"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"Cos", "[", "A", "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "B", "]"}], "2"]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Cos", "[", "A", "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "C", "]"}], "2"]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Cos", "[", "B", "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "C", "]"}], "2"]}]}], ")"}]}], "\[LessEqual]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cos", "[", "A", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "B", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "C", "]"}], "2"]}]}]}],
  SequenceForm[
  "[", 10, "] ", 
   4 (Cos[$CellContext`A]^2 Cos[$CellContext`B]^2 + 
     Cos[$CellContext`A]^2 Cos[C]^2 + Cos[$CellContext`B]^2 Cos[C]^2) <= 
   Cos[$CellContext`A]^2 + Cos[$CellContext`B]^2 + Cos[C]^2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651066538*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"ee05cc9e-43f5-46a0-a2c0-aafd00f6eb63"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651191634*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"1a1ff657-0e34-4da3-9dac-22a99ff947bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"16", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "A", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "B", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "C", "]"}], "2"]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "A", "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "B", "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "A", "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "C", "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "B", "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "C", "]"}], "2"]}]}], ")"}]}]}], "\[LessEqual]",
     "1"}]}],
  SequenceForm[
  "[", 11, "] ", 
   16 Cos[$CellContext`A]^2 Cos[$CellContext`B]^2 Cos[C]^2 + 
    4 (Cos[$CellContext`A]^2 Cos[$CellContext`B]^2 + 
      Cos[$CellContext`A]^2 Cos[C]^2 + Cos[$CellContext`B]^2 Cos[C]^2) <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651192733*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"4360ccbd-6ed9-4ead-9526-779950bcb1dc"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756512969933`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"8540508e-6e1a-4bae-87cb-2128fbff6e92"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "r"}], "+", "s"}], ">", 
    RowBox[{"2", " ", "R"}]}]}],
  SequenceForm[
  "[", 12, "] ", -$CellContext`r + $CellContext`s > 2 $CellContext`R],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651298027*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"0ceefef1-6d77-44d8-9e90-a8f5fc8213b1"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651332226*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"349e0b7b-5640-4203-8316-67b6de65dcf7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", "A", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "B", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "C", "]"}], "2"]}], ">", "2"}]}],
  SequenceForm[
  "[", 13, "] ", Sin[$CellContext`A]^2 + Sin[$CellContext`B]^2 + Sin[C]^2 > 2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651333191*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"01b1bf5c-dae0-4078-a6bc-34c880eaebbc"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756513343573`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"386ffa2c-d261-4eee-8e80-234da8c41e9d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], ">", 
    RowBox[{"8", " ", 
     SuperscriptBox["R", "2"]}]}]}],
  SequenceForm[
  "[", 14, "] ", $CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2 > 
   8 $CellContext`R^2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651335266*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"c3e83401-5cfc-4730-b678-f0d32f46732a"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651336206*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"44737641-23f4-4f0c-9a1a-c0a0fd019913"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"s", "-", 
       RowBox[{"r", "[", "a", "]"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"s", "-", 
       RowBox[{"r", "[", "b", "]"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"s", "-", 
       RowBox[{"r", "[", "c", "]"}]}], ")"}]}], ">", "0"}]}],
  SequenceForm[
  "[", 15, "] ", ($CellContext`s - $CellContext`r[$CellContext`a]) \
($CellContext`s - $CellContext`r[$CellContext`b]) ($CellContext`s - \
$CellContext`r[$CellContext`c]) > 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651337237*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"04a7384d-45cb-464f-bbd3-7b24f525f991"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756513694553`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"8c446345-0173-4268-8655-e50913fc22e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"h", "[", "a", "]"}], "+", 
     RowBox[{"h", "[", "b", "]"}], "+", 
     RowBox[{"h", "[", "c", "]"}]}], "\[GreaterEqual]", 
    RowBox[{
     RowBox[{"4", " ", "r"}], "+", 
     FractionBox[
      SuperscriptBox["r", "2"], "R"], "+", 
     RowBox[{"2", " ", "R"}]}]}]}],
  SequenceForm[
  "[", 16, "] ", $CellContext`h[$CellContext`a] + \
$CellContext`h[$CellContext`b] + $CellContext`h[$CellContext`c] >= 
   4 $CellContext`r + $CellContext`r^2/$CellContext`R + 2 $CellContext`R],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651370933*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"9c81aa96-2f7a-4f09-9c6d-cfbab1f1c7db"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756513722258`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"02b0a56e-6474-4e57-b4d0-ca14705d56c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nProved \"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" inequalities out of \"\>", "\[InvisibleSpace]", 
   "16", "\[InvisibleSpace]", "\<\". Time=\"\>", "\[InvisibleSpace]", 
   "13.552618`"}],
  SequenceForm[
  "\nProved ", 16, " inequalities out of ", 16, ". Time=", 13.552618],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651373168*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"bd268f68-44fb-418a-abaf-d0471b28dd20"],

Cell[BoxData[
 StyleBox["\<\"Mitrinovic\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontSize->18,
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651374099*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"9678780f-f129-4f5d-8ecd-e6682eb8d450"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"27", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], "2"]}], "\[LessEqual]", 
    RowBox[{"4096", " ", 
     SuperscriptBox["K", "6"]}]}]}],
  SequenceForm[
  "[", 1, "] ", 
   27 ($CellContext`a^2 + $CellContext`b^2 - $CellContext`c^2)^2 \
($CellContext`a^2 - $CellContext`b^2 + $CellContext`c^2)^2 (-$CellContext`a^2 + \
$CellContext`b^2 + $CellContext`c^2)^2 <= 4096 K^6],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756513750668`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"751413e4-2baf-4b2a-ba16-d7a1b4773830"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651445135*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"045d8496-e41e-4ce0-b6c9-82c983ede54f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"2", " ", "R"}]}], ")"}], "2"]}], "+", 
     SuperscriptBox["s", "2"]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"2", " ", "K"}], 
     RowBox[{"3", " ", 
      SqrtBox["3"]}]]}]}],
  SequenceForm[
  "[", 2, "] ", -($CellContext`r + 2 $CellContext`R)^2 + $CellContext`s^2 <= 
   Rational[2, 3] 3^Rational[-1, 2] K],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651446146*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"d7896441-b689-4af0-8446-ffce012e44c5"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756515083027`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"0bdaee4e-ed1b-44c0-9839-dc0a76769310"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "A", "]"}], " ", 
     RowBox[{"Sin", "[", "B", "]"}], " ", 
     RowBox[{"Sin", "[", "C", "]"}], " ", 
     RowBox[{"Tan", "[", "A", "]"}], " ", 
     RowBox[{"Tan", "[", "B", "]"}], " ", 
     RowBox[{"Tan", "[", "C", "]"}]}], "\[GreaterEqual]", 
    FractionBox["27", "8"]}]}],
  SequenceForm[
  "[", 3, "] ", 
   Sin[$CellContext`A] Sin[$CellContext`B] Sin[C] Tan[$CellContext`A] 
    Tan[$CellContext`B] Tan[C] >= Rational[27, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651509342*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"4d3612d5-c2cd-4119-b2fc-d8a729d2d94b"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756516452093`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"3cd6b26a-6dc5-4095-9b82-ab1f54b02ce2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tan", "[", "A", "]"}], "+", 
     RowBox[{"Tan", "[", "B", "]"}], "+", 
     RowBox[{"Tan", "[", "C", "]"}]}], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"27", " ", 
      SuperscriptBox["R", "2"]}], 
     RowBox[{"4", " ", "K"}]]}]}],
  SequenceForm[
  "[", 4, "] ", Tan[$CellContext`A] + Tan[$CellContext`B] + Tan[C] >= 
   Rational[27, 4] K^(-1) $CellContext`R^2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651646275*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"3b378007-9446-4e89-9a48-abd40d98a993"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651681036*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"e9bab08a-3e62-4598-b29a-e4060e1cd6b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tan", "[", "A", "]"}], "+", 
     RowBox[{"Tan", "[", "B", "]"}], "+", 
     RowBox[{"Tan", "[", "C", "]"}]}], "\[GreaterEqual]", 
    RowBox[{
     FractionBox["27", "8"], " ", 
     RowBox[{"Csc", "[", "A", "]"}], " ", 
     RowBox[{"Csc", "[", "B", "]"}], " ", 
     RowBox[{"Csc", "[", "C", "]"}]}]}]}],
  SequenceForm[
  "[", 5, "] ", Tan[$CellContext`A] + Tan[$CellContext`B] + Tan[C] >= 
   Rational[27, 8] Csc[$CellContext`A] Csc[$CellContext`B] Csc[C]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651682049*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"09285e27-b666-48db-a77c-d0f7bb40d150"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651716572*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"48e159bf-7a1e-4ee1-8317-7934a9635968"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "b"}], "+", 
     RowBox[{"a", " ", "c"}], "+", 
     RowBox[{"b", " ", "c"}]}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["r", "2"]}], "+", 
     FractionBox[
      RowBox[{"8", " ", 
       SuperscriptBox["K", "2"]}], 
      RowBox[{"27", " ", 
       SuperscriptBox["R", "2"]}]], "+", 
     RowBox[{"8", " ", "r", " ", "R"}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["R", "2"]}]}]}]}],
  SequenceForm[
  "[", 6, "] ", $CellContext`a $CellContext`b + $CellContext`a $CellContext`c + \
$CellContext`b $CellContext`c <= 
   2 $CellContext`r^2 + Rational[8, 27] K^2 $CellContext`R^(-2) + 
    8 $CellContext`r $CellContext`R + 4 $CellContext`R^2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756517176113`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"def63915-234d-4dc8-8215-c682800da8fe"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651751966*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"ed85a449-fc96-4c2a-a787-d056477ff62d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[LessEqual]", 
    RowBox[{
     FractionBox[
      RowBox[{"16", " ", 
       SuperscriptBox["K", "2"]}], 
      RowBox[{"27", " ", 
       SuperscriptBox["R", "2"]}]], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["R", "2"]}]}]}]}],
  SequenceForm[
  "[", 7, "] ", $CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2 <= 
   Rational[16, 27] K^2 $CellContext`R^(-2) + 8 $CellContext`R^2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651753334*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"ca2ec257-e960-43df-94aa-4191cb7d5abc"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651758932*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"8445f3f0-9e47-4462-9ae8-88e456c9b690"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", "A", "]"}], " ", 
      RowBox[{"Sec", "[", "B", "]"}]}], "+", 
     RowBox[{
      RowBox[{"Sec", "[", "A", "]"}], " ", 
      RowBox[{"Sec", "[", "C", "]"}]}], "+", 
     RowBox[{
      RowBox[{"Sec", "[", "B", "]"}], " ", 
      RowBox[{"Sec", "[", "C", "]"}]}]}], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"27", " ", 
      SuperscriptBox["R", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"r", "+", "R"}], ")"}]}], 
     RowBox[{"2", " ", 
      SuperscriptBox["K", "2"]}]]}]}],
  SequenceForm[
  "[", 8, "] ", 
   Sec[$CellContext`A] Sec[$CellContext`B] + Sec[$CellContext`A] Sec[C] + 
    Sec[$CellContext`B] Sec[C] >= 
   Rational[27, 2] K^(-2) $CellContext`R^3 ($CellContext`r + $CellContext`R)],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651760036*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"303bc729-5cf6-4125-8dd6-7fbff21380e2"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651793891*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"a7fb17c3-0cbc-4fcf-826e-dc970cd4a856"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"Cot", "[", "A", "]"}], " ", 
     RowBox[{"Cot", "[", "B", "]"}], " ", 
     RowBox[{"Cot", "[", "C", "]"}]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"4", " ", "K"}], 
     RowBox[{"27", " ", 
      SuperscriptBox["R", "2"]}]]}]}],
  SequenceForm[
  "[", 9, "] ", Cot[$CellContext`A] Cot[$CellContext`B] Cot[C] <= 
   Rational[4, 27] K $CellContext`R^(-2)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651794964*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"10c5a35b-195e-485e-95d6-b8bedf76158b"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756518299513`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"712d3ef5-1e75-48f5-a1c5-6b10413f0e93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"m", "[", "a", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"m", "[", "b", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"m", "[", "c", "]"}], "2"]}], "\[LessEqual]", 
    RowBox[{
     FractionBox["K", 
      SqrtBox["3"]], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["R", "2"]}]}]}]}],
  SequenceForm[
  "[", 10, "] ", $CellContext`m[$CellContext`a]^2 + \
$CellContext`m[$CellContext`b]^2 + $CellContext`m[$CellContext`c]^2 <= 
   3^Rational[-1, 2] K + 6 $CellContext`R^2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651831006*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"e0da1a4f-eaee-4da2-81ac-e1de4497315d"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651895542*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"8436e87e-eacf-4298-b71e-7345efb1c80d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{
     RowBox[{"3", " ", 
      SuperscriptBox["r", "2"]}], "+", 
     RowBox[{"8", " ", "r", " ", "R"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["R", "2"]}]}]}]}],
  SequenceForm[
  "[", 11, "] ", $CellContext`s^2 >= 
   3 $CellContext`r^2 + 8 $CellContext`r $CellContext`R + 2 $CellContext`R^2],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651896562*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"f2d8f8ec-ed07-4daa-af36-54ee608e5d8b"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651929771*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"6fb7350f-0834-4437-96e5-a8fe40a4a964"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "b"}], "+", 
     RowBox[{"a", " ", "c"}], "+", 
     RowBox[{"b", " ", "c"}]}], "\[GreaterEqual]", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["r", "2"]}], "+", 
     RowBox[{"12", " ", "r", " ", "R"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["R", "2"]}]}]}]}],
  SequenceForm[
  "[", 12, "] ", $CellContext`a $CellContext`b + $CellContext`a \
$CellContext`c + $CellContext`b $CellContext`c >= 
   4 $CellContext`r^2 + 12 $CellContext`r $CellContext`R + 2 $CellContext`R^2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651931088*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"4c8559b1-37be-4503-a7b6-5065c815e77d"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651932209*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"d15d1fae-50e9-46b6-a845-73ad13148bb7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "\[GreaterEqual]", 
    RowBox[{"4", " ", 
     SuperscriptBox["r", "2"], " ", 
     SuperscriptBox["R", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{"8", " ", "r", " ", "R"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["R", "2"]}]}], ")"}]}]}]}],
  SequenceForm[
  "[", 13, "] ", $CellContext`a^2 $CellContext`b^2 $CellContext`c^2 >= 
   4 $CellContext`r^2 $CellContext`R^2 (3 $CellContext`r^2 + 
     8 $CellContext`r $CellContext`R + 2 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651933202*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"3389cae9-fb0d-4b74-85e7-f81a7a06726b"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651967718*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"613d73a7-3729-43d9-b3cb-3b192cd965a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[GreaterEqual]", 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"r", "+", "R"}], ")"}], "2"]}]}]}],
  SequenceForm[
  "[", 14, "] ", $CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2 >= 
   4 ($CellContext`r + $CellContext`R)^2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651969339*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"26a61b66-5243-43f6-888e-6af9be1c6133"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775651970481*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"1d1f76cc-5411-40fb-9943-64d0c62a4371"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "3"], "+", 
     SuperscriptBox["b", "3"], "+", 
     SuperscriptBox["c", "3"]}], "\[GreaterEqual]", 
    RowBox[{"4", " ", "R", " ", 
     RowBox[{"(", 
      RowBox[{"r", "+", "R"}], ")"}], " ", "s"}]}]}],
  SequenceForm[
  "[", 15, "] ", $CellContext`a^3 + $CellContext`b^3 + $CellContext`c^3 >= 
   4 $CellContext`R ($CellContext`r + $CellContext`R) $CellContext`s],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.8607756519718437`*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"dce948c2-6a70-42a5-9638-5cda4e726a72"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775652005467*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"589c9508-f11f-4ee7-800c-2aa0333a342c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cot", "[", 
       FractionBox["A", "2"], "]"}], "3"], "+", 
     SuperscriptBox[
      RowBox[{"Cot", "[", 
       FractionBox["B", "2"], "]"}], "3"], "+", 
     SuperscriptBox[
      RowBox[{"Cot", "[", 
       FractionBox["C", "2"], "]"}], "3"]}], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["r", "2"]}], "-", 
        RowBox[{"4", " ", "r", " ", "R"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}], " ", "s"}], 
     SuperscriptBox["r", "3"]]}]}],
  SequenceForm[
  "[", 16, "] ", 
   Cot[Rational[1, 2] $CellContext`A]^3 + 
    Cot[Rational[1, 2] $CellContext`B]^3 + 
    Cot[Rational[1, 2] C]^3 >= $CellContext`r^(-3) (3 $CellContext`r^2 - 
     4 $CellContext`r $CellContext`R + 2 $CellContext`R^2) $CellContext`s],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775652006611*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"18aa3c4b-d083-4686-94d3-a36b41d7eef9"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775652007657*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"473c4187-0669-4001-bb1a-67940cd09795"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nProved \"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" inequalities out of \"\>", "\[InvisibleSpace]", 
   "16", "\[InvisibleSpace]", "\<\". Time=\"\>", "\[InvisibleSpace]", 
   "0.616004`"}],
  SequenceForm[
  "\nProved ", 16, " inequalities out of ", 16, ". Time=", 0.616004],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.825930069945629*^9, {3.825930265663814*^9, 3.825930277997423*^9}, 
   3.825930440222958*^9, 3.825930554160717*^9, 3.825930600706285*^9, 
   3.825930682506132*^9, 3.8259307648088837`*^9, 3.825930833184847*^9, 
   3.825931402602977*^9, 3.825931679116455*^9, 3.8259324221212187`*^9, 
   3.825932499401434*^9, 3.8259335076157084`*^9, 3.8259359765064173`*^9, 
   3.825937506159761*^9, 3.8259375711451817`*^9, 3.8259381450411158`*^9, 
   3.8259386062942*^9, 3.825939069455036*^9, 3.825947408200328*^9, 
   3.825947931710155*^9, 3.8480543338582087`*^9, 3.860775652008436*^9},
 CellLabel->
  "During evaluation of \
In[226]:=",ExpressionUUID->"63ec5e4c-5500-4785-9de7-a24c353b0e3b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"csum", "[", 
      RowBox[{"Sin", "[", "A", "]"}], "]"}], "+", 
     RowBox[{"csum", "[", 
      RowBox[{"Tan", "[", "A", "]"}], "]"}]}], ">", "k"}], ",", 
   RowBox[{"triangleType", "->", "\"\<acute\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8259328539180527`*^9, 3.825932874958673*^9}},
 CellLabel->
  "In[252]:=",ExpressionUUID->"e5a10846-42eb-4be9-925c-e647872b11be"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "k"}], "\[LessEqual]", 
    RowBox[{"9", " ", 
     SqrtBox["3"]}]}], ",", 
   RowBox[{"-", "\[Infinity]"}], ",", 
   FractionBox[
    RowBox[{"9", " ", 
     SqrtBox["3"]}], "2"]}], "}"}]], "Output",
 CellChangeTimes->{3.8259328702831793`*^9, 3.825939091405364*^9, 
  3.84805434862221*^9, 3.860775652909865*^9},
 CellLabel->
  "Out[252]=",ExpressionUUID->"f7d8b58e-42ed-4e92-bef0-165acdce24c8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"csum", "[", 
     RowBox[{"a", "^", "2"}], "]"}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"k", " ", 
      RowBox[{"R", "^", "2"}]}], "+", 
     RowBox[{"8", 
      RowBox[{
       RowBox[{"K", "^", "2"}], "/", 
       RowBox[{"(", 
        RowBox[{"27", 
         RowBox[{"R", "^", "2"}]}], ")"}]}]}]}]}], ",", 
   RowBox[{"triangleType", "->", "\"\<acute\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.82593722932882*^9, 3.8259372672248*^9}},
 CellLabel->
  "In[253]:=",ExpressionUUID->"a2c4cd0d-6b2e-4e0a-844e-d0451f5f742b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "k"}], "\[GreaterEqual]", "17"}], ",", 
   FractionBox["17", "2"], ",", "\[Infinity]"}], "}"}]], "Output",
 CellChangeTimes->{{3.825937259941771*^9, 3.825937267821109*^9}, 
   3.848054348814838*^9, 3.8607756531093903`*^9},
 CellLabel->
  "Out[253]=",ExpressionUUID->"5c41019d-41b9-4709-8689-931fb0ea6ea0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"csum", "[", 
     RowBox[{"a", "^", "2"}], "]"}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"8", " ", 
      RowBox[{"R", "^", "2"}]}], "+", 
     RowBox[{"k", " ", 
      RowBox[{
       RowBox[{"K", "^", "2"}], "/", 
       RowBox[{"(", 
        RowBox[{"27", 
         RowBox[{"R", "^", "2"}]}], ")"}]}]}]}]}], ",", 
   RowBox[{"triangleType", "->", "\"\<acute\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.825937287513232*^9, 3.8259372915048037`*^9}},
 CellLabel->
  "In[254]:=",ExpressionUUID->"6edd2cbb-4a55-429e-91bf-e9fec1aba868"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"k", "\[GreaterEqual]", "16"}], ",", "16", ",", "\[Infinity]"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.825937292210841*^9, 3.8480543489798717`*^9, 
  3.860775653277699*^9},
 CellLabel->
  "Out[254]=",ExpressionUUID->"d24edc8f-34d6-426c-9e22-53a8266b3217"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"csum", "[", 
     RowBox[{
      RowBox[{"m", "[", "a", "]"}], "^", "2"}], "]"}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"6", " ", 
      RowBox[{"R", "^", "2"}]}], "+", 
     RowBox[{"k", " ", 
      RowBox[{"Sqrt", "[", "3", "]"}], 
      RowBox[{"K", "/", "6"}]}]}]}], ",", 
   RowBox[{"triangleType", "->", "\"\<acute\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.825937389298407*^9, 3.825937410552981*^9}},
 CellLabel->
  "In[255]:=",ExpressionUUID->"6e806b8c-5538-4a39-976c-46d4a5241671"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"k", "\[GreaterEqual]", "2"}], ",", "2", ",", "\[Infinity]"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8259373899393187`*^9, 3.825937411339716*^9}, 
   3.848054349088945*^9, 3.8607756533969793`*^9},
 CellLabel->
  "Out[255]=",ExpressionUUID->"3ae744e2-c6aa-4a6c-aae5-341ec104381f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"cprod", "[", 
     RowBox[{"a", "^", "2"}], "]"}], "\[GreaterEqual]", 
    RowBox[{"4", 
     RowBox[{"R", "^", "2"}], "*", 
     RowBox[{"r", "^", "2"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"R", "^", "2"}]}], "+", 
       RowBox[{"8", "R", "*", "r"}], "+", 
       RowBox[{"3", 
        RowBox[{"r", "^", "2"}]}]}], ")"}]}]}], ",", 
   RowBox[{"triangleType", "->", "\"\<nonobtuse\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.825938328939803*^9, 3.825938346284933*^9}, {
  3.825938529860303*^9, 3.825938539445241*^9}},
 CellLabel->
  "In[256]:=",ExpressionUUID->"617de34d-c3b9-41e0-86e1-1490ef248758"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.8259385402065153`*^9, 3.84805434912496*^9, 
  3.860775653428835*^9},
 CellLabel->
  "Out[256]=",ExpressionUUID->"230e6b23-a9e3-44ee-a02b-ff2cc2051b9b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"proveTriangleInequality", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"csum", "[", 
      RowBox[{
       RowBox[{"Cot", "[", 
        RowBox[{"A", "/", "2"}], "]"}], "^", "3"}], "]"}], "\[GreaterEqual]", 
     
     RowBox[{"s", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", 
          RowBox[{"R", "^", "2"}]}], "-", 
         RowBox[{"4", "R", "*", "r"}], "+", 
         RowBox[{"3", 
          RowBox[{"r", "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"r", "^", "3"}]}]}]}], ",", "\"\<nonobtuse\>\""}], "]"}], 
  ";"}]], "Input",
 CellLabel->
  "In[257]:=",ExpressionUUID->"98ac0656-e9ec-4529-bcb8-92176da721fd"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\"] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cot", "[", 
       FractionBox["A", "2"], "]"}], "3"], "+", 
     SuperscriptBox[
      RowBox[{"Cot", "[", 
       FractionBox["B", "2"], "]"}], "3"], "+", 
     SuperscriptBox[
      RowBox[{"Cot", "[", 
       FractionBox["C", "2"], "]"}], "3"]}], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["r", "2"]}], "-", 
        RowBox[{"4", " ", "r", " ", "R"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}], " ", "s"}], 
     SuperscriptBox["r", "3"]]}]}],
  SequenceForm[
  "[", 17, "] ", 
   Cot[Rational[1, 2] $CellContext`A]^3 + 
    Cot[Rational[1, 2] $CellContext`B]^3 + 
    Cot[Rational[1, 2] C]^3 >= $CellContext`r^(-3) (3 $CellContext`r^2 - 
     4 $CellContext`r $CellContext`R + 2 $CellContext`R^2) $CellContext`s],
  Editable->False]], "Print",
 CellChangeTimes->{3.8259475800559483`*^9, 3.825947899474375*^9, 
  3.848054349134302*^9, 3.8607756534384336`*^9},
 CellLabel->
  "During evaluation of \
In[257]:=",ExpressionUUID->"05f30089-bdd5-44fc-99f4-da3ae288e496"],

Cell[BoxData[
 StyleBox["True",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontWeight->Bold,
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.8259475800559483`*^9, 3.825947899474375*^9, 
  3.848054349134302*^9, 3.860775653467875*^9},
 CellLabel->
  "During evaluation of \
In[257]:=",ExpressionUUID->"b188c88e-c6d6-4c16-9a36-d30a77f3ed3a"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{296, Automatic}, {Automatic, 163}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 160, 3, 67, "Section",ExpressionUUID->"5edc58f7-4143-400e-a0f3-6e78a44f6f6e"],
Cell[CellGroupData[{
Cell[765, 29, 25355, 675, 2131, "Input",ExpressionUUID->"626fd7e9-02af-43bf-86d0-b1f502c32753"],
Cell[CellGroupData[{
Cell[26145, 708, 986, 21, 32, "Print",ExpressionUUID->"3aae14e9-fd60-4a6d-a84b-94e3f55f9069"],
Cell[27134, 731, 1226, 26, 25, "Print",ExpressionUUID->"2bdfe197-fff4-4817-bd0a-1460052a9581"],
Cell[28363, 759, 957, 20, 24, "Print",ExpressionUUID->"2db02c87-473a-48ca-bef5-c264b156932a"],
Cell[29323, 781, 1566, 36, 42, "Print",ExpressionUUID->"6286af7a-cbaf-4351-8514-3e2c06a49c50"],
Cell[30892, 819, 957, 20, 24, "Print",ExpressionUUID->"b00cce4e-6145-4b07-a8ad-4476ad9a9603"],
Cell[31852, 841, 1564, 36, 42, "Print",ExpressionUUID->"a7d4e434-7712-4e1c-a012-f792ee0657ca"],
Cell[33419, 879, 959, 20, 24, "Print",ExpressionUUID->"9517af1f-8b40-4363-96d3-7d31832b5a9d"],
Cell[34381, 901, 1476, 34, 40, "Print",ExpressionUUID->"910485e8-39dc-45d4-a284-de7f557ac3c8"],
Cell[35860, 937, 959, 20, 24, "Print",ExpressionUUID->"e563b9f4-a6df-4f5d-9068-565214e850dd"],
Cell[36822, 959, 1631, 38, 25, "Print",ExpressionUUID->"49c5f435-46c1-45b0-9596-9de5ec186881"],
Cell[38456, 999, 957, 20, 24, "Print",ExpressionUUID->"4d80bb22-e26b-42b9-832d-202d08e84147"],
Cell[39416, 1021, 1125, 23, 24, "Print",ExpressionUUID->"83615f23-d9ab-4458-9f35-0d0e16af09c5"],
Cell[40544, 1046, 957, 20, 24, "Print",ExpressionUUID->"91b5d655-de80-4cf3-a616-a9ec66e41083"],
Cell[41504, 1068, 1483, 33, 24, "Print",ExpressionUUID->"af855586-c256-4729-8b5b-61eb06027488"],
Cell[42990, 1103, 959, 20, 24, "Print",ExpressionUUID->"bd11a948-e4e7-4a1a-92b7-ae687ded9cbd"],
Cell[43952, 1125, 1679, 40, 25, "Print",ExpressionUUID->"99eda047-5bd1-4f24-9981-eb76715b247d"],
Cell[45634, 1167, 957, 20, 24, "Print",ExpressionUUID->"bef58bb3-ec70-4403-9f37-bbe483f17cb1"],
Cell[46594, 1189, 1417, 32, 24, "Print",ExpressionUUID->"95d08788-6d5e-4091-bf08-775381bfa765"],
Cell[48014, 1223, 959, 20, 24, "Print",ExpressionUUID->"57460dd7-9539-4751-9f46-a62dcd9a2933"],
Cell[48976, 1245, 1332, 30, 25, "Print",ExpressionUUID->"09d2877b-cebc-48ad-9e17-e9bf8bcfb5e4"],
Cell[50311, 1277, 959, 20, 24, "Print",ExpressionUUID->"8c898b91-015c-43ba-b961-1a621efc4da2"],
Cell[51273, 1299, 1388, 31, 25, "Print",ExpressionUUID->"688d81bd-2942-4b85-9b25-894b081958c1"],
Cell[52664, 1332, 957, 20, 24, "Print",ExpressionUUID->"cbe250af-5c4b-4f69-9321-bad4e20ff0a2"],
Cell[53624, 1354, 1426, 32, 44, "Print",ExpressionUUID->"5f7c4123-1155-4132-948f-dcfaa6e2b571"],
Cell[55053, 1388, 957, 20, 24, "Print",ExpressionUUID->"fbca203f-e326-4d0c-a265-3af8a91de822"],
Cell[56013, 1410, 1076, 20, 44, "Print",ExpressionUUID->"f54d2bef-9461-44d7-966b-8bd17b0f82dd"],
Cell[57092, 1432, 986, 21, 32, "Print",ExpressionUUID->"83db0137-ebc9-404b-b910-c6066469224b"],
Cell[58081, 1455, 1440, 32, 24, "Print",ExpressionUUID->"5ffee6ea-62e7-40b1-9bab-85637d460943"],
Cell[59524, 1489, 959, 20, 24, "Print",ExpressionUUID->"025fd64b-50c9-4cf9-aaa0-a92b14af9a7b"],
Cell[60486, 1511, 1173, 25, 26, "Print",ExpressionUUID->"a17eb960-0a73-4bb2-935d-a712ccaf9a15"],
Cell[61662, 1538, 959, 20, 24, "Print",ExpressionUUID->"baf439b4-1b72-4280-9bff-3365c7812a99"],
Cell[62624, 1560, 1724, 41, 24, "Print",ExpressionUUID->"abd4fd2b-64c6-4aed-ab83-057bde042966"],
Cell[64351, 1603, 957, 20, 24, "Print",ExpressionUUID->"34b0186d-0ed9-4f19-90d2-011546c2bf9c"],
Cell[65311, 1625, 1199, 26, 26, "Print",ExpressionUUID->"855a19a6-a8dd-4931-bb7d-2324df87a0e5"],
Cell[66513, 1653, 957, 20, 24, "Print",ExpressionUUID->"6690f7c8-4165-4f9d-9bee-46c08a771d50"],
Cell[67473, 1675, 1203, 26, 26, "Print",ExpressionUUID->"e785e55c-d72b-4de8-9b34-c89201b953de"],
Cell[68679, 1703, 957, 20, 24, "Print",ExpressionUUID->"c8cce7c4-41d9-435b-ba25-cb2446d2971f"],
Cell[69639, 1725, 1219, 26, 25, "Print",ExpressionUUID->"67a6957c-3d80-4136-91a1-75d65c62634e"],
Cell[70861, 1753, 959, 20, 24, "Print",ExpressionUUID->"ae5f14cc-f0ec-488a-bbd3-285013e24cbb"],
Cell[71823, 1775, 1293, 29, 26, "Print",ExpressionUUID->"b0df9640-4438-4469-88c4-64da72933217"],
Cell[73119, 1806, 959, 20, 24, "Print",ExpressionUUID->"680d2fea-c2ed-43cd-a9a9-8a76b30eb927"],
Cell[74081, 1828, 1411, 31, 43, "Print",ExpressionUUID->"07bb5bb8-ee81-416b-bf45-428a4def1e9f"],
Cell[75495, 1861, 957, 20, 24, "Print",ExpressionUUID->"cd09be91-7b76-438d-91ea-4e6020fb1058"],
Cell[76455, 1883, 1563, 36, 43, "Print",ExpressionUUID->"782234af-17dd-45d1-aec6-38344446da68"],
Cell[78021, 1921, 957, 20, 24, "Print",ExpressionUUID->"147dd595-c514-48d1-9f88-5b2582ed8205"],
Cell[78981, 1943, 1929, 47, 27, "Print",ExpressionUUID->"ee05cc9e-43f5-46a0-a2c0-aafd00f6eb63"],
Cell[80913, 1992, 957, 20, 24, "Print",ExpressionUUID->"1a1ff657-0e34-4da3-9dac-22a99ff947bf"],
Cell[81873, 2014, 2000, 49, 27, "Print",ExpressionUUID->"4360ccbd-6ed9-4ead-9526-779950bcb1dc"],
Cell[83876, 2065, 959, 20, 24, "Print",ExpressionUUID->"8540508e-6e1a-4bae-87cb-2128fbff6e92"],
Cell[84838, 2087, 1061, 22, 24, "Print",ExpressionUUID->"0ceefef1-6d77-44d8-9e90-a8f5fc8213b1"],
Cell[85902, 2111, 957, 20, 24, "Print",ExpressionUUID->"349e0b7b-5640-4203-8316-67b6de65dcf7"],
Cell[86862, 2133, 1217, 26, 25, "Print",ExpressionUUID->"01b1bf5c-dae0-4078-a6bc-34c880eaebbc"],
Cell[88082, 2161, 959, 20, 24, "Print",ExpressionUUID->"386ffa2c-d261-4eee-8e80-234da8c41e9d"],
Cell[89044, 2183, 1186, 26, 25, "Print",ExpressionUUID->"c3e83401-5cfc-4730-b678-f0d32f46732a"],
Cell[90233, 2211, 957, 20, 24, "Print",ExpressionUUID->"44737641-23f4-4f0c-9a1a-c0a0fd019913"],
Cell[91193, 2233, 1389, 31, 24, "Print",ExpressionUUID->"04a7384d-45cb-464f-bbd3-7b24f525f991"],
Cell[92585, 2266, 959, 20, 24, "Print",ExpressionUUID->"8c446345-0173-4268-8655-e50913fc22e5"],
Cell[93547, 2288, 1395, 30, 43, "Print",ExpressionUUID->"9c81aa96-2f7a-4f09-9c6d-cfbab1f1c7db"],
Cell[94945, 2320, 959, 20, 24, "Print",ExpressionUUID->"02b0a56e-6474-4e57-b4d0-ca14705d56c5"],
Cell[95907, 2342, 1078, 20, 44, "Print",ExpressionUUID->"bd268f68-44fb-418a-abaf-d0471b28dd20"],
Cell[96988, 2364, 987, 21, 32, "Print",ExpressionUUID->"9678780f-f129-4f5d-8ecd-e6682eb8d450"],
Cell[97978, 2387, 1822, 44, 27, "Print",ExpressionUUID->"751413e4-2baf-4b2a-ba16-d7a1b4773830"],
Cell[99803, 2433, 957, 20, 24, "Print",ExpressionUUID->"045d8496-e41e-4ce0-b6c9-82c983ede54f"],
Cell[100763, 2455, 1326, 31, 44, "Print",ExpressionUUID->"d7896441-b689-4af0-8446-ffce012e44c5"],
Cell[102092, 2488, 959, 20, 24, "Print",ExpressionUUID->"0bdaee4e-ed1b-44c0-9839-dc0a76769310"],
Cell[103054, 2510, 1359, 29, 40, "Print",ExpressionUUID->"4d3612d5-c2cd-4119-b2fc-d8a729d2d94b"],
Cell[104416, 2541, 959, 20, 24, "Print",ExpressionUUID->"3cd6b26a-6dc5-4095-9b82-ab1f54b02ce2"],
Cell[105378, 2563, 1286, 28, 43, "Print",ExpressionUUID->"3b378007-9446-4e89-9a48-abd40d98a993"],
Cell[106667, 2593, 957, 20, 24, "Print",ExpressionUUID->"e9bab08a-3e62-4598-b29a-e4060e1cd6b0"],
Cell[107627, 2615, 1374, 29, 40, "Print",ExpressionUUID->"09285e27-b666-48db-a77c-d0f7bb40d150"],
Cell[109004, 2646, 957, 20, 24, "Print",ExpressionUUID->"48e159bf-7a1e-4ee1-8317-7934a9635968"],
Cell[109964, 2668, 1612, 37, 44, "Print",ExpressionUUID->"def63915-234d-4dc8-8215-c682800da8fe"],
Cell[111579, 2707, 957, 20, 24, "Print",ExpressionUUID->"ed85a449-fc96-4c2a-a787-d056477ff62d"],
Cell[112539, 2729, 1404, 32, 44, "Print",ExpressionUUID->"ca2ec257-e960-43df-94aa-4191cb7d5abc"],
Cell[113946, 2763, 957, 20, 24, "Print",ExpressionUUID->"8445f3f0-9e47-4462-9ae8-88e456c9b690"],
Cell[114906, 2785, 1655, 40, 44, "Print",ExpressionUUID->"303bc729-5cf6-4125-8dd6-7fbff21380e2"],
Cell[116564, 2827, 957, 20, 24, "Print",ExpressionUUID->"a7fb17c3-0cbc-4fcf-826e-dc970cd4a856"],
Cell[117524, 2849, 1277, 28, 41, "Print",ExpressionUUID->"10c5a35b-195e-485e-95d6-b8bedf76158b"],
Cell[118804, 2879, 959, 20, 24, "Print",ExpressionUUID->"712d3ef5-1e75-48f5-a1c5-6b10413f0e93"],
Cell[119766, 2901, 1433, 33, 44, "Print",ExpressionUUID->"e0da1a4f-eaee-4da2-81ac-e1de4497315d"],
Cell[121202, 2936, 957, 20, 24, "Print",ExpressionUUID->"8436e87e-eacf-4298-b71e-7345efb1c80d"],
Cell[122162, 2958, 1258, 28, 25, "Print",ExpressionUUID->"f2d8f8ec-ed07-4daa-af36-54ee608e5d8b"],
Cell[123423, 2988, 957, 20, 24, "Print",ExpressionUUID->"6fb7350f-0834-4437-96e5-a8fe40a4a964"],
Cell[124383, 3010, 1423, 31, 25, "Print",ExpressionUUID->"4c8559b1-37be-4503-a7b6-5065c815e77d"],
Cell[125809, 3043, 957, 20, 24, "Print",ExpressionUUID->"d15d1fae-50e9-46b6-a845-73ad13148bb7"],
Cell[126769, 3065, 1560, 35, 27, "Print",ExpressionUUID->"3389cae9-fb0d-4b74-85e7-f81a7a06726b"],
Cell[128332, 3102, 957, 20, 24, "Print",ExpressionUUID->"613d73a7-3729-43d9-b3cb-3b192cd965a7"],
Cell[129292, 3124, 1275, 28, 25, "Print",ExpressionUUID->"26a61b66-5243-43f6-888e-6af9be1c6133"],
Cell[130570, 3154, 957, 20, 24, "Print",ExpressionUUID->"1d1f76cc-5411-40fb-9943-64d0c62a4371"],
Cell[131530, 3176, 1296, 27, 25, "Print",ExpressionUUID->"dce948c2-6a70-42a5-9638-5cda4e726a72"],
Cell[132829, 3205, 957, 20, 24, "Print",ExpressionUUID->"589c9508-f11f-4ee7-800c-2aa0333a342c"],
Cell[133789, 3227, 1784, 43, 45, "Print",ExpressionUUID->"18aa3c4b-d083-4686-94d3-a36b41d7eef9"],
Cell[135576, 3272, 957, 20, 24, "Print",ExpressionUUID->"473c4187-0669-4001-bb1a-67940cd09795"],
Cell[136536, 3294, 1076, 20, 44, "Print",ExpressionUUID->"63ec5e4c-5500-4785-9de7-a24c353b0e3b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[137661, 3320, 495, 12, 52, "Input",ExpressionUUID->"e5a10846-42eb-4be9-925c-e647872b11be"],
Cell[138159, 3334, 469, 14, 54, "Output",ExpressionUUID->"f7d8b58e-42ed-4e92-bef0-165acdce24c8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[138665, 3353, 636, 18, 52, "Input",ExpressionUUID->"a2c4cd0d-6b2e-4e0a-844e-d0451f5f742b"],
Cell[139304, 3373, 379, 9, 50, "Output",ExpressionUUID->"5c41019d-41b9-4709-8689-931fb0ea6ea0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139720, 3387, 646, 18, 52, "Input",ExpressionUUID->"6edd2cbb-4a55-429e-91bf-e9fec1aba868"],
Cell[140369, 3407, 310, 8, 34, "Output",ExpressionUUID->"d24edc8f-34d6-426c-9e22-53a8266b3217"]
}, Open  ]],
Cell[CellGroupData[{
Cell[140716, 3420, 605, 16, 52, "Input",ExpressionUUID->"6e806b8c-5538-4a39-976c-46d4a5241671"],
Cell[141324, 3438, 335, 8, 34, "Output",ExpressionUUID->"3ae744e2-c6aa-4a6c-aae5-341ec104381f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[141696, 3451, 746, 20, 52, "Input",ExpressionUUID->"617de34d-c3b9-41e0-86e1-1490ef248758"],
Cell[142445, 3473, 204, 4, 34, "Output",ExpressionUUID->"230e6b23-a9e3-44ee-a02b-ff2cc2051b9b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[142686, 3482, 680, 22, 30, "Input",ExpressionUUID->"98ac0656-e9ec-4529-bcb8-92176da721fd"],
Cell[CellGroupData[{
Cell[143391, 3508, 1306, 36, 45, "Print",ExpressionUUID->"05f30089-bdd5-44fc-99f4-da3ae288e496"],
Cell[144700, 3546, 477, 13, 24, "Print",ExpressionUUID->"b188c88e-c6d6-4c16-9a36-d30a77f3ed3a"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

