(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    507695,      13354]
NotebookOptionsPosition[    469140,      12886]
NotebookOutlinePosition[    469479,      12901]
CellTagsIndexPosition[    469436,      12898]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
This Notebook contains the proofs of all the results in section 4 of the \
paper
\"Inequalities For Distances Between Triangle Centers\" by Stanley \
Rabinowitz,
submitted to the International Journal of Computer Discovered Mathematics 
(http : // www.journal - 1. eu/) on Jan. 2022.
 
This Notebook is Copyright \[Copyright] January 2022 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and is published with open access. This \
Notebook is distributed under the terms of the Creative Commons Attribution \
License which permits any use, distribution, and reproduction in any medium, \
provided the original author and the source are credited.
  
If you want to reproduce these results, you must evaluate the notebook \
\"proveTriangleInequalityUsing Blundon.nb\"
first before evaluating this notebook.\
\>", "Text",
 Evaluatable->False,
 CellChangeTimes->{{3.8517106718981447`*^9, 3.851710701258429*^9}, {
   3.851711035640792*^9, 3.851711101569191*^9}, 
   3.8517113718428907`*^9},ExpressionUUID->"0d9d1143-e2b1-4229-a334-\
eceae79f2764"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ETC1", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"X1", ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X2", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X3", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X4", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"X5", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["b", "4"], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ",", 
          RowBox[{
           SuperscriptBox["a", "4"], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ",", 
          RowBox[{
           SuperscriptBox["a", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["b", "4"], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X6", ",", 
        RowBox[{"{", 
         RowBox[{
          SuperscriptBox["a", "2"], ",", 
          SuperscriptBox["b", "2"], ",", 
          SuperscriptBox["c", "2"]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X7", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "+", "c"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}]}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X8", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", "-", "b", "-", "c"}], ",", 
          RowBox[{
           RowBox[{"-", "a"}], "+", "b", "-", "c"}], ",", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "b", "+", "c"}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X9", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "-", "c"}], ")"}]}], ",", 
          RowBox[{"b", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "-", "c"}], ")"}]}], ",", 
          RowBox[{"c", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "-", "b", "+", "c"}], ")"}]}]}], "}"}]}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X10", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"b", "+", "c"}], ",", 
          RowBox[{"a", "+", "c"}], ",", 
          RowBox[{"a", "+", "b"}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X11", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "a"}], "+", "c"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "+", "c"}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "-", "b"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}]}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"X12", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"b", "+", "c"}], ")"}], "2"]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "+", "c"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "+", "b"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}]}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X13", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "+", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "+", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], "2"]}], "+", 
           SuperscriptBox["c", "4"], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "+", 
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"X14", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "+", 
              SuperscriptBox["c", "2"], "-", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "+", 
              SuperscriptBox["c", "2"], "-", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], "2"]}], "+", 
           SuperscriptBox["c", "4"], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "+", 
              SuperscriptBox["b", "2"], "-", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X15", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["a", "2"], "-", 
                SuperscriptBox["b", "2"], "-", 
                SuperscriptBox["c", "2"]}], ")"}]}], "-", 
             RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["b", "2"], "-", 
                SuperscriptBox["c", "2"], "-", 
                SuperscriptBox["a", "2"]}], ")"}]}], "-", 
             RowBox[{"2", " ", "S"}]}], ")"}]}], "\[InvisibleSpace]", ",", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["c", "2"], "-", 
                SuperscriptBox["a", "2"], "-", 
                SuperscriptBox["b", "2"]}], ")"}]}], "-", 
             RowBox[{"2", " ", "S"}]}], ")"}]}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"X16", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["a", "2"], "-", 
                SuperscriptBox["b", "2"], "-", 
                SuperscriptBox["c", "2"]}], ")"}]}], "+", 
             RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["b", "2"], "-", 
                SuperscriptBox["c", "2"], "-", 
                SuperscriptBox["a", "2"]}], ")"}]}], "+", 
             RowBox[{"2", " ", "S"}]}], ")"}]}], "\[InvisibleSpace]", ",", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["c", "2"], "-", 
                SuperscriptBox["a", "2"], "-", 
                SuperscriptBox["b", "2"]}], ")"}]}], "+", 
             RowBox[{"2", " ", "S"}]}], ")"}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X17", ",", 
        FormBox[
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "+", 
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "-", 
              SuperscriptBox["b", "2"], "+", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "+", 
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["a", "2"]}], "+", 
              SuperscriptBox["b", "2"], "+", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "-", 
              SuperscriptBox["b", "2"], "+", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["a", "2"]}], "+", 
              SuperscriptBox["b", "2"], "+", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], "}"}],
         TraditionalForm]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"X18", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", 
              SqrtBox["3"], "S"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "S"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", 
              SqrtBox["3"], "S"}]}], ")"}]}], "\[InvisibleSpace]", ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "S"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "S"}]}], ")"}]}]}], "\[InvisibleSpace]", 
         "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X19", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], ",", 
          RowBox[{"b", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], ",", 
          RowBox[{"c", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"X20", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["a", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "4"]}], ",", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "4"]}], ",", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}]}], "}"}]}], "}"}]}], 
     "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", 
     RowBox[{"i", "\[LessEqual]", "20"}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "i", "]"}], "=", 
       RowBox[{"ETC1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}]}], ";"}]}], 
    "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "to", " ", "find", " ", "the", " ", "distance", " ", 
    "between", " ", "two", " ", "points", " ", "given", " ", "in", " ", 
    "Barycentric", " ", "coordinates"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"normed", "[", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_", ",", "z_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], "/", 
    RowBox[{"(", 
     RowBox[{"x", "+", "y", "+", "z"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"squaredDistance", "[", 
     RowBox[{"p1_", ",", "p2_"}], "]"}], ":=", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Total", "[", "p2", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{"Return", "[", "Infinity", "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], "=", 
        RowBox[{
         RowBox[{"normed", "[", "p1", "]"}], "-", 
         RowBox[{"normed", "[", "p2", "]"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"a", "^", "2"}]}], "*", "y", "*", "z"}], "-", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", "z", "*", "x"}], "-", 
         RowBox[{
          RowBox[{"c", "^", "2"}], "*", "x", "*", "y"}]}], "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"distance", "[", 
    RowBox[{"i_", ",", "j_"}], "]"}], ":=", 
   RowBox[{"squaredDistance", "[", 
    RowBox[{
     RowBox[{"x", "[", "i", "]"}], ",", 
     RowBox[{"x", "[", "j", "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8273470407215*^9, 3.827347044608625*^9}, {
   3.82734774268469*^9, 3.827347843091484*^9}, {3.82734787805133*^9, 
   3.8273480057689247`*^9}, 3.827348096913745*^9, {3.851275935729549*^9, 
   3.851276047174993*^9}, {3.851590466243751*^9, 3.85159046668266*^9}, {
   3.851590518355194*^9, 3.851590519443016*^9}},
 CellLabel->
  "In[1090]:=",ExpressionUUID->"eb9faff4-722f-422c-9a34-3ad93404b942"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"showExpression", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"showSteps", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"showRegions", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"showCounterexample", "=", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"showConditionsForEquality", "=", "False"}], ";"}]}], "Input",
 CellChangeTimes->{{3.82446823405422*^9, 3.824468238813963*^9}, {
   3.824639364376914*^9, 3.824639366254614*^9}, {3.824639489697496*^9, 
   3.824639501047118*^9}, {3.824730489171135*^9, 3.824730550273574*^9}, 
   3.829305063612216*^9, {3.829305236004871*^9, 3.829305240731523*^9}, 
   3.851275972535203*^9, 3.851276011087577*^9, {3.8512761097907343`*^9, 
   3.851276120502899*^9}, 3.851276166790948*^9},
 CellLabel->
  "In[101]:=",ExpressionUUID->"538dfab7-7976-4d7f-b042-a36426c48793"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Find", " ", "bounds", " ", "for", " ", "d", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", ",", "i"}], ")"}], "/", "d"}], 
    RowBox[{"(", 
     RowBox[{"n", ",", "j"}], ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"bounds", "[", 
     RowBox[{"n_", ",", "max_", ",", "timeLimit_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "i", ",", "j", ",", "truth", ",", "dni", ",", "dnj", ",", "ineq", ",", 
        "lo", ",", "hi", ",", "ineq2", ",", "lo2", ",", "hi2", ",", "expr", 
        ",", "code", ",", "uneq"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"inequalities", "[", "n", "]"}], "=", 
        RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "1"}], ",", 
         RowBox[{"i", "\[LessEqual]", "max"}], ",", 
         RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"i", "\[Equal]", "n"}], ",", 
            RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"dni", "=", 
           RowBox[{"distance", "[", 
            RowBox[{"n", ",", "i"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"j", "=", 
             RowBox[{"i", "+", "1"}]}], ",", 
            RowBox[{"j", "\[LessEqual]", "max"}], ",", 
            RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"j", "\[Equal]", "n"}], ",", 
               RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"dnj", "=", 
              RowBox[{"distance", "[", 
               RowBox[{"n", ",", "j"}], "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"code", "=", 
              RowBox[{"TimeConstrained", "[", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"ineq", ",", "lo", ",", "hi"}], "}"}], "=", 
                 RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
                  RowBox[{"dni", "<=", 
                   RowBox[{"k", " ", "dnj"}]}], "]"}]}], ",", 
                "\[IndentingNewLine]", "timeLimit"}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"code", "===", "$Aborted"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"Print", "[", 
                 RowBox[{
                 "\"\<Time limit exceeded for i=\>\"", ",", "i", ",", 
                  "\"\< j=\>\"", ",", "j"}], "]"}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"Continue", "[", "]"}], ";"}]}], 
              "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
             RowBox[{"code", "=", 
              RowBox[{"TimeConstrained", "[", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"ineq2", ",", "lo2", ",", "hi2"}], "}"}], "=", 
                 RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
                  RowBox[{"dni", ">=", 
                   RowBox[{"k", " ", "dnj"}]}], "]"}]}], ",", 
                "\[IndentingNewLine]", "10"}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"code", "===", "$Aborted"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"Print", "[", 
                 RowBox[{
                 "\"\<Time limit exceeded for i=\>\"", ",", "i", ",", 
                  "\"\< j=\>\"", ",", "j"}], "]"}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"Continue", "[", "]"}], ";"}]}], 
              "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
             RowBox[{"lo", "=", 
              RowBox[{
               RowBox[{"Sqrt", "[", "lo", "]"}], "//", "FullSimplify"}]}], 
             ";", "\[IndentingNewLine]", 
             RowBox[{"hi2", "=", 
              RowBox[{
               RowBox[{"Sqrt", "[", "hi2", "]"}], "//", "FullSimplify"}]}], 
             ";", "\[IndentingNewLine]", 
             RowBox[{"expr", "=", 
              RowBox[{
               RowBox[{"d", "[", 
                RowBox[{"n", ",", "i"}], "]"}], "/", 
               RowBox[{"d", "[", 
                RowBox[{"n", ",", "j"}], "]"}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"lo", "\[Equal]", "0"}], "&&", 
                RowBox[{"hi2", "\[Equal]", "0"}]}], ",", 
               RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"lo", "==", "hi2"}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"uneq", "=", 
                 RowBox[{"expr", "==", "lo"}]}], ";", "\[IndentingNewLine]", 
                RowBox[{"AppendTo", "[", 
                 RowBox[{
                  RowBox[{"inequalities", "[", "n", "]"}], ",", "uneq"}], 
                 "]"}], ";", "\[IndentingNewLine]", 
                RowBox[{"Print", "[", 
                 RowBox[{"n", ",", "\"\<:  \>\"", ",", 
                  RowBox[{"{", 
                   RowBox[{"ineq", ",", "lo", ",", "hi"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"ineq2", ",", "lo2", ",", "hi2"}], "}"}], ",", 
                  "\"\<   \>\"", ",", "uneq"}], "]"}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"Continue", "[", "]"}], ";"}]}], 
              "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"lo", ">", "0"}], "&&", 
                RowBox[{"hi2", ">", "0"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"uneq", "=", 
                 RowBox[{
                 "hi2", "\[LessEqual]", "expr", "\[LessEqual]", "lo"}]}], ";",
                 "\[IndentingNewLine]", 
                RowBox[{"AppendTo", "[", 
                 RowBox[{
                  RowBox[{"inequalities", "[", "n", "]"}], ",", "uneq"}], 
                 "]"}], ";", "\[IndentingNewLine]", 
                RowBox[{"Print", "[", 
                 RowBox[{"n", ",", "\"\<:  \>\"", ",", 
                  RowBox[{"{", 
                   RowBox[{"ineq", ",", "lo", ",", "hi"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"ineq2", ",", "lo2", ",", "hi2"}], "}"}], ",", 
                  "\"\<   \>\"", ",", "uneq"}], "]"}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"Continue", "[", "]"}], ";"}]}], 
              "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"hi2", ">", "0"}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"uneq", "=", 
                 RowBox[{"hi2", "\[LessEqual]", "expr"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"AppendTo", "[", 
                 RowBox[{
                  RowBox[{"inequalities", "[", "n", "]"}], ",", "uneq"}], 
                 "]"}], ";", "\[IndentingNewLine]", 
                RowBox[{"Print", "[", 
                 RowBox[{"n", ",", "\"\<:  \>\"", ",", 
                  RowBox[{"{", 
                   RowBox[{"ineq", ",", "lo", ",", "hi"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"ineq2", ",", "lo2", ",", "hi2"}], "}"}], ",", 
                  "\"\<   \>\"", ",", "uneq"}], "]"}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"Continue", "[", "]"}], ";"}]}], 
              "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"lo", ">", "0"}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"uneq", "=", 
                 RowBox[{"expr", "\[LessEqual]", "lo"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"AppendTo", "[", 
                 RowBox[{
                  RowBox[{"inequalities", "[", "n", "]"}], ",", "uneq"}], 
                 "]"}], ";", "\[IndentingNewLine]", 
                RowBox[{"Print", "[", 
                 RowBox[{"n", ",", "\"\<:  \>\"", ",", 
                  RowBox[{"{", 
                   RowBox[{"ineq", ",", "lo", ",", "hi"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"ineq2", ",", "lo2", ",", "hi2"}], "}"}], ",", 
                  "\"\<   \>\"", ",", "uneq"}], "]"}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"Continue", "[", "]"}], ";"}]}], 
              "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
           "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.8512763458403482`*^9, 3.851276416263245*^9}, {
   3.85127648442415*^9, 3.851276778593697*^9}, {3.8512768365465803`*^9, 
   3.851276836889391*^9}, {3.8512768763388453`*^9, 3.851276876681353*^9}, {
   3.8512801142710876`*^9, 3.851280114997387*^9}, {3.851280237679284*^9, 
   3.851280313638425*^9}, {3.851280367320208*^9, 3.851280392094688*^9}, {
   3.851280556128396*^9, 3.851280587431807*^9}, {3.8513295506565237`*^9, 
   3.851329743687974*^9}, {3.851329872242447*^9, 3.85132987844092*^9}, 
   3.851329922858239*^9, {3.851330718405266*^9, 3.851330823548781*^9}, {
   3.851333431897079*^9, 3.851333432263167*^9}, 3.851333478409096*^9, {
   3.8513336292817*^9, 3.851333643216072*^9}, {3.8513378277466927`*^9, 
   3.851337832457458*^9}, {3.851356799416808*^9, 3.8513569066482077`*^9}, {
   3.8513569901656446`*^9, 3.851357043976653*^9}, {3.8513572110428877`*^9, 
   3.851357228073625*^9}, {3.851357280778385*^9, 3.851357302642211*^9}, {
   3.851357341227866*^9, 3.851357460222364*^9}, 3.851357517036566*^9, 
   3.851357547914826*^9, {3.851357587611665*^9, 3.851357649507885*^9}, {
   3.851357696812581*^9, 3.8513576976995087`*^9}, {3.851357735901293*^9, 
   3.8513577695800447`*^9}, {3.8513579335738688`*^9, 3.851357934588296*^9}, {
   3.851358157279257*^9, 3.851358191773746*^9}, {3.8513583272076197`*^9, 
   3.851358396774221*^9}, {3.8513584343350983`*^9, 3.851358458631034*^9}, 
   3.851358494998949*^9, {3.851358525983111*^9, 3.85135855705847*^9}, {
   3.851358739233511*^9, 3.8513587731443233`*^9}, {3.851358823249456*^9, 
   3.8513588439079113`*^9}, {3.851359031571074*^9, 3.851359061393168*^9}, {
   3.851359100530802*^9, 3.851359138417474*^9}, {3.851359190938726*^9, 
   3.85135929737084*^9}, {3.851359333867363*^9, 3.851359362674728*^9}, {
   3.851359430076487*^9, 3.8513594486914186`*^9}, {3.8513595251917887`*^9, 
   3.851359527111264*^9}, 3.851359653677689*^9, {3.851359774837783*^9, 
   3.8513598281726923`*^9}, {3.851359877326495*^9, 3.851359884956839*^9}, {
   3.8513599227186117`*^9, 3.8513599234133043`*^9}, {3.8513599779194098`*^9, 
   3.851360009269299*^9}, {3.8513600437501593`*^9, 3.851360068462134*^9}, {
   3.851360910706888*^9, 3.8513609137614927`*^9}, {3.851361050314979*^9, 
   3.851361085738134*^9}, {3.851361347420331*^9, 3.8513613569473457`*^9}, {
   3.851361909622704*^9, 3.85136192845365*^9}, {3.851361961535221*^9, 
   3.851361972537161*^9}, {3.8513651725080976`*^9, 3.851365299231168*^9}, {
   3.8515902767885523`*^9, 3.85159029389254*^9}, {3.851590535262992*^9, 
   3.851590602468539*^9}, {3.851590694494656*^9, 3.8515907525495987`*^9}, {
   3.8515907865419703`*^9, 3.85159083075735*^9}, {3.8515908966393023`*^9, 
   3.851590936622418*^9}, {3.851590967958246*^9, 3.851591083999303*^9}},
 CellLabel->
  "In[1100]:=",ExpressionUUID->"7be14e67-6c84-4ae5-9b6d-364ec74eb9c2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"i", "=", "1"}], ",", 
    RowBox[{"i", "\[LessEqual]", "10"}], ",", 
    RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"bounds", "[", 
      RowBox[{"i", ",", "10", ",", "60"}], "]"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.851591164997554*^9, 3.85159118210926*^9}, {
  3.8515915850776587`*^9, 3.851591585750786*^9}},
 CellLabel->
  "In[1106]:=",ExpressionUUID->"94c6ce11-9dde-422f-8d11-1c19dbe1e358"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "4"}], ",", 
     FractionBox["2", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "3"}], "]"}]], "\[LessEqual]", 
    FractionBox["2", "3"]}]}],
  SequenceForm[1, ":  ", {9 $CellContext`k >= 4, 
    Rational[2, 3], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[1, 2]/$CellContext`d[1, 3] <= Rational[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159158881982*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"035cf325-0da5-4bd4-b613-99339c0d4072"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "8"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox[
      RowBox[{"2", " ", 
       SqrtBox["2"]}], "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SqrtBox["2"]}], "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "6"}], "]"}]]}]}],
  SequenceForm[1, ":  ", {False, 0, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 8, 
    DirectedInfinity[-1], Rational[2, 3] 2^Rational[1, 2]}, "   ", 
   Rational[2, 3] 2^Rational[1, 2] <= $CellContext`d[1, 2]/$CellContext`d[
    1, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515915897320633`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"21fd7b0f-16c9-4baf-ba54-96b0fd22089b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "7"}], "]"}]]}]}],
  SequenceForm[1, ":  ", {False, 0, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[1, 2]/$CellContext`d[1, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591589979705*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"b154eec9-0a75-4428-9644-0ecc8ed9c380"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "8"}], "]"}]], "\[Equal]", 
    FractionBox["1", "3"]}]}],
  SequenceForm[1, ":  ", {9 $CellContext`k >= 1, 
    Rational[1, 3], 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", $CellContext`d[1, 2]/$CellContext`d[1, 8] == 
   Rational[1, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591590066938*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"2a0d573c-6924-47d2-aabf-1e89c5c5bead"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "4"}], ",", 
     FractionBox["2", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "9"}], "]"}]], "\[LessEqual]", 
    FractionBox["2", "3"]}]}],
  SequenceForm[1, ":  ", {9 $CellContext`k >= 4, 
    Rational[2, 3], 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[1, 2]/$CellContext`d[1, 9] <= 
   Rational[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159159031912*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"9cb2c012-6729-454f-917e-9f19aa85c615"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "4"}], ",", 
     FractionBox["2", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["2", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "10"}], "]"}]], "\[Equal]", 
    FractionBox["2", "3"]}]}],
  SequenceForm[1, ":  ", {9 $CellContext`k >= 4, 
    Rational[2, 3], 
    DirectedInfinity[1]}, {9 $CellContext`k <= 4, 
    DirectedInfinity[-1], 
    Rational[2, 3]}, "   ", $CellContext`d[1, 2]/$CellContext`d[1, 10] == 
   Rational[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591590450959*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"b40b8a27-7e84-43cd-94ff-700a5784e45e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "4"}], "]"}]]}]}],
  SequenceForm[1, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[1, 3]/$CellContext`d[1, 4]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515915905789347`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"3037acef-1736-4475-a106-c1f88d3b6457"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "5"}], "]"}]]}]}],
  SequenceForm[1, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[1, 3]/$CellContext`d[1, 5]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591590673621*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"0b0dd868-27cd-4356-8a59-eec825ef7f85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         SqrtBox["3"]}], ")"}]}]}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     RowBox[{"1", "+", 
      SqrtBox["3"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"1", "+", 
     SqrtBox["3"]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "6"}], "]"}]]}]}],
  SequenceForm[1, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 2 (2 + 3^Rational[1, 2]), 
    DirectedInfinity[-1], 1 + 3^Rational[1, 2]}, "   ", 
   1 + 3^Rational[1, 2] <= $CellContext`d[1, 3]/$CellContext`d[1, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591592264987*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"bcb5166b-3ff1-4042-98a9-2fad8e01a7f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", 
      RowBox[{
       FractionBox["17", "4"], "+", 
       RowBox[{"3", " ", 
        SqrtBox["2"]}]}]}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     RowBox[{
      FractionBox["3", "2"], "+", 
      SqrtBox["2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox["3", "2"], "+", 
     SqrtBox["2"]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "7"}], "]"}]]}]}],
  SequenceForm[1, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 
    Rational[17, 4] + 3 2^Rational[1, 2], 
    DirectedInfinity[-1], Rational[3, 2] + 2^Rational[1, 2]}, "   ", 
   Rational[3, 2] + 2^Rational[1, 2] <= $CellContext`d[1, 3]/$CellContext`d[
    1, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515915925608683`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"8fbf5712-84bf-4c5e-8877-1150a941fde2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "8"}], "]"}]]}]}],
  SequenceForm[1, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[1, 3]/$CellContext`d[1, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591592740292*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"557c497c-e052-402d-b294-5469a77522fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "9"}], "]"}]]}]}],
  SequenceForm[1, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[1, 3]/$CellContext`d[1, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515915928906*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"5dd8226f-3078-43e6-92a6-c1ffbb9947ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "10"}], "]"}]]}]}],
  SequenceForm[1, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[1, 3]/$CellContext`d[1, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591593014501*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"a8847c24-fe7d-4d97-b47b-4932b9e7d171"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "6"}], "]"}]]}]}],
  SequenceForm[1, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[1, 4]/$CellContext`d[1, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591594158132*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"c383b7fb-f5ba-40ff-a037-537b06035cdc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "7"}], "]"}]]}]}],
  SequenceForm[1, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[1, 4]/$CellContext`d[1, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591594569375*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"23d335bf-ef35-4a73-9f67-582f14cc62d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "7"}], "]"}]]}]}],
  SequenceForm[1, ":  ", {False, 0, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[1, 6]/$CellContext`d[1, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515915975057163`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"b42000c6-d049-41d6-b048-1478bbe3a8f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"8", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "8"}], "]"}]], "\[LessEqual]", 
    FractionBox["1", 
     RowBox[{"2", " ", 
      SqrtBox["2"]}]]}]}],
  SequenceForm[
  1, ":  ", {8 $CellContext`k >= 1, Rational[1, 2] 2^Rational[-1, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[1, 6]/$CellContext`d[1, 8] <= 
   Rational[1, 2] 2^Rational[-1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515915980087967`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"8a410b46-a8aa-4942-bcf6-7a955a3576db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "2"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "9"}], "]"}]], "\[LessEqual]", 
    FractionBox["1", "2"]}]}],
  SequenceForm[1, ":  ", {4 $CellContext`k >= 1, 
    Rational[1, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[1, 6]/$CellContext`d[1, 9] <= Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515915984405003`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"ce106c85-c68f-43a4-a8e6-f5e32865cda7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", 
      SqrtBox["2"]], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "10"}], "]"}]], "\[LessEqual]", 
    FractionBox["1", 
     SqrtBox["2"]]}]}],
  SequenceForm[1, ":  ", {2 $CellContext`k >= 1, 2^Rational[-1, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[1, 6]/$CellContext`d[1, 10] <= 2^Rational[-1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591598938098*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"d52ecc6b-eabc-48a3-8ef2-5586533b594e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "8"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[1, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[1, 7]/$CellContext`d[1, 8] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591599205708*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"34772da1-94b0-49ee-acda-f7b97e78e176"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "9"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[1, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[1, 7]/$CellContext`d[1, 9] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591599425145*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"493f6c0b-b8a0-49fa-976d-109b31edab7e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "10"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[1, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[1, 7]/$CellContext`d[1, 10] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515915996897*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"5d82a334-c772-4cb5-8fb8-0acc59faeedf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "8"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "9"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[1, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[1, 8]/$CellContext`d[1, 9] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591599919392*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"cb0d8920-c97d-4b6f-a626-2441d64250d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "8"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "10"}], "]"}]], "\[Equal]", "2"}]}],
  SequenceForm[1, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, 
   "   ", $CellContext`d[1, 8]/$CellContext`d[1, 10] == 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591600010684*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"6dcb3def-0f8b-43e4-b237-16463b3f87b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "9"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"1", ",", "10"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[1, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[1, 9]/$CellContext`d[1, 10] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591600248513*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"c545bef9-98db-464b-b324-de5c75a9d32f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "3"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[2, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[2, 1]/$CellContext`d[2, 3] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591600441156*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"fa3eec88-d5ee-4991-b5c8-354859633a1a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "4"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[2, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[2, 1]/$CellContext`d[2, 4] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591600659752*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"3d669a53-5c6f-4318-a7b4-37c9a776d19a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "16"}], ",", "4", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "5"}], "]"}]], "\[LessEqual]", "4"}]}],
  SequenceForm[2, ":  ", {$CellContext`k >= 16, 4, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[2, 1]/$CellContext`d[2, 5] <= 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591600867322*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"f38daeef-2495-48a5-8ea0-c9a75d940f1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"96", " ", 
        SqrtBox["2"]}], "+", "k"}], "\[LessEqual]", "136"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     RowBox[{
      RowBox[{"-", "8"}], "+", 
      RowBox[{"6", " ", 
       SqrtBox["2"]}]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "8"}], "+", 
     RowBox[{"6", " ", 
      SqrtBox["2"]}]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "6"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[2, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {96 2^Rational[1, 2] + $CellContext`k <= 136, 
    DirectedInfinity[-1], -8 + 6 2^Rational[1, 2]}, 
   "   ", -8 + 6 2^Rational[1, 2] <= $CellContext`d[2, 1]/$CellContext`d[
    2, 6] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916015755796`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"c1b66857-6681-47e2-98b1-a2c4ac1d0d95"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"16", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "4"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "4"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "7"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[2, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {16 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 4]}, "   ", 
   Rational[1, 4] <= $CellContext`d[2, 1]/$CellContext`d[2, 7] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591601883832*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"1b0d6a35-e934-4d99-97a9-fe7a1fa1d401"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "2"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "8"}], "]"}]], "\[Equal]", 
    FractionBox["1", "2"]}]}],
  SequenceForm[2, ":  ", {4 $CellContext`k >= 1, 
    Rational[1, 2], 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", $CellContext`d[2, 1]/$CellContext`d[2, 8] == 
   Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916019711037`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"412df943-3134-4bb6-9b8b-875dc15649f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "9"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[2, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[2, 1]/$CellContext`d[2, 9] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591602277458*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"10a36be4-6a8a-486f-98da-8a75000c7abf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "10"}], "]"}]], "\[Equal]", "2"}]}],
  SequenceForm[2, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, 
   "   ", $CellContext`d[2, 1]/$CellContext`d[2, 10] == 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916023707113`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"8925c595-e7f5-4610-99c7-7d2fdade209e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "2"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "4"}], "]"}]], "\[Equal]", 
    FractionBox["1", "2"]}]}],
  SequenceForm[2, ":  ", {4 $CellContext`k >= 1, 
    Rational[1, 2], 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", $CellContext`d[2, 3]/$CellContext`d[2, 4] == 
   Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916024792633`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"fc177b01-b741-4945-8ccf-ac64376d62c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "5"}], "]"}]], "\[Equal]", "2"}]}],
  SequenceForm[2, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, 
   "   ", $CellContext`d[2, 3]/$CellContext`d[2, 5] == 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591602587955*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"3dee1a2b-9117-48e8-9ba2-50c9ad0511e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "6"}], "]"}]]}]}],
  SequenceForm[2, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[2, 3]/$CellContext`d[2, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916034665327`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"213e59df-9138-4ae4-ac7f-265df29dbdbd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "7"}], "]"}]]}]}],
  SequenceForm[2, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[2, 3]/$CellContext`d[2, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591603979458*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"1099ae53-891b-40f7-a0c9-84114fe9050a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"16", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "4"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "4"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "8"}], "]"}]]}]}],
  SequenceForm[2, ":  ", {False, 0, 
    DirectedInfinity[1]}, {16 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 4]}, "   ", 
   Rational[1, 4] <= $CellContext`d[2, 3]/$CellContext`d[2, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591604174835*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"80da34e3-5e84-4ec7-880f-c9fc188a3c38"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "9"}], "]"}]]}]}],
  SequenceForm[2, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[2, 3]/$CellContext`d[2, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591604641172*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"bfb4784d-7870-424d-ac12-137ce7b29d1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "10"}], "]"}]]}]}],
  SequenceForm[2, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[2, 3]/$CellContext`d[2, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591604829879*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"d2f2f9bb-8dd0-429b-a968-45830200330b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "16"}], ",", "4", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "16"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "5"}], "]"}]], "\[Equal]", "4"}]}],
  SequenceForm[2, ":  ", {$CellContext`k >= 16, 4, 
    DirectedInfinity[1]}, {$CellContext`k <= 16, 
    DirectedInfinity[-1], 4}, 
   "   ", $CellContext`d[2, 4]/$CellContext`d[2, 5] == 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591604957762*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"efccea6c-4475-4656-b879-d9abfebbb405"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "6"}], "]"}]]}]}],
  SequenceForm[2, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[2, 4]/$CellContext`d[2, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591605859332*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"6de78ce9-cbd2-4890-ac98-ca9a0f792dd5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "7"}], "]"}]]}]}],
  SequenceForm[2, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[2, 4]/$CellContext`d[2, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591606340888*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"66010fb4-f5ba-4119-9860-18d977f99842"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "8"}], "]"}]]}]}],
  SequenceForm[2, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[2, 4]/$CellContext`d[2, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591606537854*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"77d5d160-57cc-47e4-aebd-d1005961b8ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "9"}], "]"}]]}]}],
  SequenceForm[2, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[2, 4]/$CellContext`d[2, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591607003631*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"202a58de-670c-41ae-b60e-cc47323bb79d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "10"}], "]"}]]}]}],
  SequenceForm[2, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[2, 4]/$CellContext`d[2, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591607211738*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"d5f8490f-e0ba-4d80-8027-10bed8541251"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"16", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "4"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "4"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "6"}], "]"}]]}]}],
  SequenceForm[2, ":  ", {False, 0, 
    DirectedInfinity[1]}, {16 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 4]}, "   ", 
   Rational[1, 4] <= $CellContext`d[2, 5]/$CellContext`d[2, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916081479683`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"fef360ba-cac9-4bf8-8585-816cfa57ca7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"16", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "4"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "4"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "7"}], "]"}]]}]}],
  SequenceForm[2, ":  ", {False, 0, 
    DirectedInfinity[1]}, {16 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 4]}, "   ", 
   Rational[1, 4] <= $CellContext`d[2, 5]/$CellContext`d[2, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591608658491*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"7b2b42d6-e00e-4dcc-9d8b-a65179ce7cb2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"64", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "8"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "8"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "8"}], "]"}]]}]}],
  SequenceForm[2, ":  ", {False, 0, 
    DirectedInfinity[1]}, {64 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 8]}, "   ", 
   Rational[1, 8] <= $CellContext`d[2, 5]/$CellContext`d[2, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591608866667*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"6cf0511d-0f06-427d-a570-d6fcf877bb36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "9"}], "]"}]]}]}],
  SequenceForm[2, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[2, 5]/$CellContext`d[2, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591609388154*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"c4d30344-86dd-4d27-9641-c253805d448f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "10"}], "]"}]]}]}],
  SequenceForm[2, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[2, 5]/$CellContext`d[2, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591609588245*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"f6cb3443-c6b3-4bfd-b37a-f04db6931840"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[GreaterEqual]", "9"}], ",", 
     FractionBox["3", "2"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "7"}], "]"}]], "\[LessEqual]", 
    FractionBox["3", "2"]}]}],
  SequenceForm[2, ":  ", {4 $CellContext`k >= 9, 
    Rational[3, 2], 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[2, 6]/$CellContext`d[2, 7] <= 
   Rational[3, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591611476329*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"e8da0554-6231-481e-bd52-c1fca4a93ab0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"32", " ", "k"}], "\[GreaterEqual]", 
      RowBox[{"17", "+", 
       RowBox[{"12", " ", 
        SqrtBox["2"]}]}]}], ",", 
     RowBox[{
      FractionBox["1", "8"], " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", 
        RowBox[{"3", " ", 
         SqrtBox["2"]}]}], ")"}]}], ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "8"}], "]"}]], "\[LessEqual]", 
    RowBox[{
     FractionBox["1", "8"], " ", 
     RowBox[{"(", 
      RowBox[{"4", "+", 
       RowBox[{"3", " ", 
        SqrtBox["2"]}]}], ")"}]}]}]}],
  SequenceForm[
  2, ":  ", {
   32 $CellContext`k >= 17 + 12 2^Rational[1, 2], 
    Rational[1, 8] (4 + 3 2^Rational[1, 2]), 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[2, 6]/$CellContext`d[2, 8] <= 
   Rational[1, 8] (4 + 3 2^Rational[1, 2])],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591612265586*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"0d458f29-93e1-4b89-937d-0d096fee66c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "9"}], ",", "3", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "9"}], "]"}]], "\[LessEqual]", "3"}]}],
  SequenceForm[2, ":  ", {$CellContext`k >= 9, 3, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[2, 6]/$CellContext`d[2, 9] <= 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591613935104*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"e85ad06b-110e-45b8-bb64-5547119ca666"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", 
      RowBox[{
       FractionBox["17", "2"], "+", 
       RowBox[{"6", " ", 
        SqrtBox["2"]}]}]}], ",", 
     RowBox[{"2", "+", 
      FractionBox["3", 
       SqrtBox["2"]]}], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "10"}], "]"}]], "\[LessEqual]", 
    RowBox[{"2", "+", 
     FractionBox["3", 
      SqrtBox["2"]]}]}]}],
  SequenceForm[
  2, ":  ", {$CellContext`k >= Rational[17, 2] + 6 2^Rational[1, 2], 2 + 
    3 2^Rational[-1, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[2, 6]/$CellContext`d[2, 10] <= 2 + 3 2^Rational[-1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591614687182*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"165794d8-9acc-4926-858d-3a228000b854"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "8"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[2, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[2, 7]/$CellContext`d[2, 8] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916150147877`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"c9a79e6c-e6f6-4e38-b130-f3cc0db5dce0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "9"}], "]"}]], "\[Equal]", "2"}]}],
  SequenceForm[2, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, 
   "   ", $CellContext`d[2, 7]/$CellContext`d[2, 9] == 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591615177924*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"52464d32-4914-4e44-8141-b369a6af19a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "64"}], ",", "8", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "10"}], "]"}]], "\[LessEqual]", "8"}]}],
  SequenceForm[2, ":  ", {$CellContext`k >= 64, 8, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[2, 7]/$CellContext`d[2, 10] <= 8],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591615482533*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"00d2c912-b20a-4325-85f2-8dc6d3b60a71"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "16"}], ",", "4", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "8"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "9"}], "]"}]], "\[LessEqual]", "4"}]}],
  SequenceForm[2, ":  ", {$CellContext`k >= 16, 4, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[2, 8]/$CellContext`d[2, 9] <= 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591615809432*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"c5aee08e-a14c-42ea-8efa-bb716fcf0b8c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "16"}], ",", "4", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "16"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "8"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "10"}], "]"}]], "\[Equal]", "4"}]}],
  SequenceForm[2, ":  ", {$CellContext`k >= 16, 4, 
    DirectedInfinity[1]}, {$CellContext`k <= 16, 
    DirectedInfinity[-1], 4}, 
   "   ", $CellContext`d[2, 8]/$CellContext`d[2, 10] == 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916159015837`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"a860405b-d709-4f22-86ed-783482a18b9f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "16"}], ",", "4", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "9"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"2", ",", "10"}], "]"}]], "\[LessEqual]", "4"}]}],
  SequenceForm[2, ":  ", {$CellContext`k >= 16, 4, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[2, 9]/$CellContext`d[2, 10] <= 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591616205914*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"a2a65eab-a3eb-4680-9a44-82a929b1ef5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "9"}], ",", "3", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "2"}], "]"}]], "\[LessEqual]", "3"}]}],
  SequenceForm[3, ":  ", {$CellContext`k >= 9, 3, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[3, 1]/$CellContext`d[3, 2] <= 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591616377624*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"bd7fa58d-8d15-428b-8f3e-88a9c0e90cdd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "4"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[3, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[3, 1]/$CellContext`d[3, 4] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159161656219*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"6653b4e5-288c-447a-92e8-6ed996a4e094"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["2", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "5"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[3, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 4, 
    DirectedInfinity[-1], 
    Rational[2, 3]}, "   ", 
   Rational[2, 3] <= $CellContext`d[3, 1]/$CellContext`d[3, 5] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591616751389*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"2dee23cb-f207-4231-b059-0eba6837b293"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", 
        SqrtBox["3"]}], "+", "k"}], "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["3"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox["3"]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "6"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[3, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {2 3^Rational[1, 2] + $CellContext`k <= 4, 
    DirectedInfinity[-1], -1 + 3^Rational[1, 2]}, 
   "   ", -1 + 3^Rational[1, 2] <= $CellContext`d[3, 1]/$CellContext`d[3, 6] <= 
   1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591617196404*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"fb289ccd-458b-4e77-bb42-1d64bbb23e84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"289", " ", "k"}], "\[LessEqual]", 
      RowBox[{"81", "+", 
       RowBox[{"56", " ", 
        SqrtBox["2"]}]}]}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     RowBox[{
      FractionBox["1", "17"], " ", 
      RowBox[{"(", 
       RowBox[{"7", "+", 
        RowBox[{"4", " ", 
         SqrtBox["2"]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox["1", "17"], " ", 
     RowBox[{"(", 
      RowBox[{"7", "+", 
       RowBox[{"4", " ", 
        SqrtBox["2"]}]}], ")"}]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "7"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[3, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {289 $CellContext`k <= 81 + 56 2^Rational[1, 2], 
    DirectedInfinity[-1], Rational[1, 17] (7 + 4 2^Rational[1, 2])}, "   ", 
   Rational[1, 17] (7 + 4 2^Rational[1, 2]) <= $CellContext`d[
     3, 1]/$CellContext`d[3, 7] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916175851507`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"7bc91f70-5bc0-4e36-980c-e490149a8604"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "8"}], "]"}]]}]}],
  SequenceForm[3, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[3, 1]/$CellContext`d[3, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591617676141*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"45e36a37-4aad-4efa-9ea2-eb40970f7a7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "9"}], "]"}]]}]}],
  SequenceForm[3, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[3, 1]/$CellContext`d[3, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591617898477*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"4beab5ae-5680-4143-b508-286acce2e429"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "10"}], "]"}]]}]}],
  SequenceForm[3, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[3, 1]/$CellContext`d[3, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591618054522*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"731ddbc3-de5b-4900-b0cf-592fe3e70338"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "4"}], "]"}]], "\[Equal]", 
    FractionBox["1", "3"]}]}],
  SequenceForm[3, ":  ", {9 $CellContext`k >= 1, 
    Rational[1, 3], 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", $CellContext`d[3, 2]/$CellContext`d[3, 4] == 
   Rational[1, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916181820927`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"6fce9651-ac93-49b6-acdf-bfd2075aaad7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "4"}], ",", 
     FractionBox["2", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["2", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "5"}], "]"}]], "\[Equal]", 
    FractionBox["2", "3"]}]}],
  SequenceForm[3, ":  ", {9 $CellContext`k >= 4, 
    Rational[2, 3], 
    DirectedInfinity[1]}, {9 $CellContext`k <= 4, 
    DirectedInfinity[-1], 
    Rational[2, 3]}, "   ", $CellContext`d[3, 2]/$CellContext`d[3, 5] == 
   Rational[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591618301952*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"704d2a5b-ba2a-43ca-b546-d4a9d63fb05c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "6"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[3, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[3, 2]/$CellContext`d[3, 6] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916189797163`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"9915857d-fde1-44ae-aa29-1a242e2121f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "7"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[3, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[3, 2]/$CellContext`d[3, 7] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591619495562*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"297fb73e-68ad-4416-95a0-5c8155c3d06a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "8"}], "]"}]]}]}],
  SequenceForm[3, ":  ", {False, 0, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[3, 2]/$CellContext`d[3, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591619799871*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"95c3437c-51b0-40f9-908f-e56317a9f0c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "9"}], "]"}]]}]}],
  SequenceForm[3, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[3, 2]/$CellContext`d[3, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916202001266`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"9f4689fe-3f50-404d-94a8-54f62411fd9a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "10"}], "]"}]]}]}],
  SequenceForm[3, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[3, 2]/$CellContext`d[3, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916204220667`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"d24ac508-ab62-4926-ab92-59df929be6df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "5"}], "]"}]], "\[Equal]", "2"}]}],
  SequenceForm[3, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, 
   "   ", $CellContext`d[3, 4]/$CellContext`d[3, 5] == 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916205641527`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"826a16b4-9fd3-461c-a70b-6a556f86ac54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "9"}], ",", "3", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "6"}], "]"}]], "\[LessEqual]", "3"}]}],
  SequenceForm[3, ":  ", {$CellContext`k >= 9, 3, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[3, 4]/$CellContext`d[3, 6] <= 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591621271824*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"31926e77-97c3-40dc-9645-2001d90686ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "9"}], ",", "3", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "7"}], "]"}]], "\[LessEqual]", "3"}]}],
  SequenceForm[3, ":  ", {$CellContext`k >= 9, 3, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[3, 4]/$CellContext`d[3, 7] <= 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591621803524*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"bc6d9a97-84a2-4457-9235-1f3a3b1e7023"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "8"}], "]"}]]}]}],
  SequenceForm[3, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[3, 4]/$CellContext`d[3, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591622122072*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"d4ff040f-c6bf-4f95-a3b6-0f73b4528626"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "9"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"3", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "9"}], "]"}]]}]}],
  SequenceForm[3, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 9, 
    DirectedInfinity[-1], 3}, "   ", 
   3 <= $CellContext`d[3, 4]/$CellContext`d[3, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916225389853`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"1351fd43-52ab-4ae2-9f73-088ff8bd6e58"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "9"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"3", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "10"}], "]"}]]}]}],
  SequenceForm[3, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 9, 
    DirectedInfinity[-1], 3}, "   ", 
   3 <= $CellContext`d[3, 4]/$CellContext`d[3, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916227832527`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"493bf3ef-0edd-4bca-8ade-79e97cbaca97"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[GreaterEqual]", "9"}], ",", 
     FractionBox["3", "2"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "6"}], "]"}]], "\[LessEqual]", 
    FractionBox["3", "2"]}]}],
  SequenceForm[3, ":  ", {4 $CellContext`k >= 9, 
    Rational[3, 2], 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[3, 5]/$CellContext`d[3, 6] <= 
   Rational[3, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916234550743`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"4f1c8746-c745-4cd3-bb89-7f30b0650a24"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[GreaterEqual]", "9"}], ",", 
     FractionBox["3", "2"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "7"}], "]"}]], "\[LessEqual]", 
    FractionBox["3", "2"]}]}],
  SequenceForm[3, ":  ", {4 $CellContext`k >= 9, 
    Rational[3, 2], 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[3, 5]/$CellContext`d[3, 7] <= 
   Rational[3, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916239578543`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"a9c3f87e-f098-43f8-bd61-d60d5d3cc162"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "8"}], "]"}]]}]}],
  SequenceForm[3, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[3, 5]/$CellContext`d[3, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591624280551*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"1550c888-59f4-401b-b71c-f24db2685be3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "9"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["3", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["3", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "9"}], "]"}]]}]}],
  SequenceForm[3, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 9, 
    DirectedInfinity[-1], 
    Rational[3, 2]}, "   ", 
   Rational[3, 2] <= $CellContext`d[3, 5]/$CellContext`d[3, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591624659535*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"4418334f-728b-4f22-866e-598f8231c5b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "9"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["3", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["3", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "10"}], "]"}]]}]}],
  SequenceForm[3, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 9, 
    DirectedInfinity[-1], 
    Rational[3, 2]}, "   ", 
   Rational[3, 2] <= $CellContext`d[3, 5]/$CellContext`d[3, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159162488037*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"910478c9-bd6d-448d-b9c8-968a523a054b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"k", "\[GreaterEqual]", 
       InterpretationBox[
        TemplateBox[{"Root",TemplateBox[{"\"1.21\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"],TagBox[
           RowBox[{"Root", "[", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   RowBox[{"-", "10000"}], "+", 
                   RowBox[{"11765804", " ", "#1"}], "+", 
                   RowBox[{"12633875", " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"26886473", " ", 
                    SuperscriptBox["#1", "3"]}], "-", 
                   RowBox[{"38665175", " ", 
                    SuperscriptBox["#1", "4"]}], "+", 
                   RowBox[{"37662769", " ", 
                    SuperscriptBox["#1", "5"]}]}], "&"}], ",", "3"}], "]"}], 
           Short[#, 7]& ],1.2118731863337395`},
         "NumericalApproximation"],
        Root[-10000 + 11765804 # + 12633875 #^2 - 26886473 #^3 - 38665175 #^4 + 
         37662769 #^5& , 3, 0]]}], ",", 
      InterpretationBox[
       TemplateBox[{"Root",TemplateBox[{"\"1.10\"", 
           DynamicBox[
            FEPrivate`FrontEndResource[
            "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
         TagBox[
          RowBox[{"Root", "[", 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{"-", "100"}], "+", 
                  RowBox[{"3698", " ", "#1"}], "-", 
                  RowBox[{"9547", " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                  RowBox[{"14429", " ", 
                    SuperscriptBox["#1", "3"]}], "-", 
                  RowBox[{"14689", " ", 
                    SuperscriptBox["#1", "4"]}], "+", 
                  RowBox[{"6137", " ", 
                    SuperscriptBox["#1", "5"]}]}], "&"}], ",", "3"}], "]"}], 
          Short[#, 7]& ],1.1008511190591304`},
        "NumericalApproximation"],
       Root[-100 + 3698 # - 9547 #^2 + 14429 #^3 - 14689 #^4 + 6137 #^5& , 3, 
        0]], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"k", "\[LessEqual]", 
       InterpretationBox[
        TemplateBox[{"Root",TemplateBox[{"\"0.810\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"],TagBox[
           RowBox[{"Root", "[", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   RowBox[{"-", "10000"}], "+", 
                   RowBox[{"11765804", " ", "#1"}], "+", 
                   RowBox[{"12633875", " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"26886473", " ", 
                    SuperscriptBox["#1", "3"]}], "-", 
                   RowBox[{"38665175", " ", 
                    SuperscriptBox["#1", "4"]}], "+", 
                   RowBox[{"37662769", " ", 
                    SuperscriptBox["#1", "5"]}]}], "&"}], ",", "2"}], "]"}], 
           Short[#, 7]& ],0.8104087108834643},
         "NumericalApproximation"],
        Root[-10000 + 11765804 # + 12633875 #^2 - 26886473 #^3 - 38665175 #^4 + 
         37662769 #^5& , 2, 0]]}], ",", 
      RowBox[{"-", "\[Infinity]"}], ",", 
      InterpretationBox[
       TemplateBox[{"Root",TemplateBox[{"\"0.900\"", 
           DynamicBox[
            FEPrivate`FrontEndResource[
            "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
         TagBox[
          RowBox[{"Root", "[", 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{"-", "100"}], "+", 
                  RowBox[{"3698", " ", "#1"}], "-", 
                  RowBox[{"9547", " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                  RowBox[{"14429", " ", 
                    SuperscriptBox["#1", "3"]}], "-", 
                  RowBox[{"14689", " ", 
                    SuperscriptBox["#1", "4"]}], "+", 
                  RowBox[{"6137", " ", 
                    SuperscriptBox["#1", "5"]}]}], "&"}], ",", "2"}], "]"}], 
          Short[#, 7]& ],0.900227032966387},
        "NumericalApproximation"],
       Root[-100 + 3698 # - 9547 #^2 + 14429 #^3 - 14689 #^4 + 6137 #^5& , 2, 
        0]]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
    InterpretationBox[
     TemplateBox[{"Root",TemplateBox[{"\"0.900\"", 
         DynamicBox[
          FEPrivate`FrontEndResource[
          "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
       TagBox[
        RowBox[{"Root", "[", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{"-", "100"}], "+", 
                RowBox[{"3698", " ", "#1"}], "-", 
                RowBox[{"9547", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                RowBox[{"14429", " ", 
                  SuperscriptBox["#1", "3"]}], "-", 
                RowBox[{"14689", " ", 
                  SuperscriptBox["#1", "4"]}], "+", 
                RowBox[{"6137", " ", 
                  SuperscriptBox["#1", "5"]}]}], "&"}], ",", "2"}], "]"}], 
        Short[#, 7]& ],0.900227032966387},
      "NumericalApproximation"],
     Root[-100 + 3698 # - 9547 #^2 + 14429 #^3 - 14689 #^4 + 6137 #^5& , 2, 
      0]]}], "\[LessEqual]", 
   FractionBox[
    RowBox[{"d", "[", 
     RowBox[{"3", ",", "6"}], "]"}], 
    RowBox[{"d", "[", 
     RowBox[{"3", ",", "7"}], "]"}]], "\[LessEqual]", 
   InterpretationBox[
    TemplateBox[{"Root",TemplateBox[{"\"1.10\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{
               RowBox[{"-", "100"}], "+", 
               RowBox[{"3698", " ", "#1"}], "-", 
               RowBox[{"9547", " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
               RowBox[{"14429", " ", 
                 SuperscriptBox["#1", "3"]}], "-", 
               RowBox[{"14689", " ", 
                 SuperscriptBox["#1", "4"]}], "+", 
               RowBox[{"6137", " ", 
                 SuperscriptBox["#1", "5"]}]}], "&"}], ",", "3"}], "]"}], 
       Short[#, 7]& ],1.1008511190591304`},
     "NumericalApproximation"],
    Root[-100 + 3698 # - 9547 #^2 + 14429 #^3 - 14689 #^4 + 6137 #^5& , 3, 
     0]]}],
  SequenceForm[
  3, ":  ", {$CellContext`k >= 
    Root[-10000 + 11765804 # + 12633875 #^2 - 26886473 #^3 - 38665175 #^4 + 
      37662769 #^5& , 3, 0], 
    Root[-100 + 3698 # - 9547 #^2 + 14429 #^3 - 14689 #^4 + 6137 #^5& , 3, 0], 
    DirectedInfinity[1]}, {$CellContext`k <= 
    Root[-10000 + 11765804 # + 12633875 #^2 - 26886473 #^3 - 38665175 #^4 + 
      37662769 #^5& , 2, 0], 
    DirectedInfinity[-1], 
    Root[-100 + 3698 # - 9547 #^2 + 14429 #^3 - 14689 #^4 + 6137 #^5& , 2, 
     0]}, "   ", 
   Root[-100 + 3698 # - 9547 #^2 + 14429 #^3 - 14689 #^4 + 6137 #^5& , 2, 
     0] <= $CellContext`d[3, 6]/$CellContext`d[3, 7] <= 
   Root[-100 + 3698 # - 9547 #^2 + 14429 #^3 - 14689 #^4 + 6137 #^5& , 3, 0]],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916261245003`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"1d88d262-76d5-4ed6-8bf8-695519ad31b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "8"}], "]"}]]}]}],
  SequenceForm[3, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[3, 6]/$CellContext`d[3, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916265380096`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"fab4efd4-0dfa-4f4e-8226-52aa44aed230"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "9"}], "]"}]]}]}],
  SequenceForm[3, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[3, 6]/$CellContext`d[3, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916275499353`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"6b0db743-072e-4c3a-87cb-b4b5bcf1b087"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "10"}], "]"}]]}]}],
  SequenceForm[3, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[3, 6]/$CellContext`d[3, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159162843263*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"b1aac016-9ef6-4168-87c0-3b693e2c049d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "8"}], "]"}]]}]}],
  SequenceForm[3, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[3, 7]/$CellContext`d[3, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591628931067*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"ce41f26a-b42b-4002-9440-6cbfbe716788"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "9"}], "]"}]]}]}],
  SequenceForm[3, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[3, 7]/$CellContext`d[3, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591629206871*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"67784906-4798-48d0-9c6e-b6cb69ce9add"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "10"}], "]"}]]}]}],
  SequenceForm[3, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[3, 7]/$CellContext`d[3, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591629645658*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"868030fb-ea69-4961-873b-4783b3c4590b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "9"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"3", ",", "10"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[3, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[3, 9]/$CellContext`d[3, 10] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591630366578*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"4b51ef65-01bb-4611-b335-569181a673ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "2"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[4, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[4, 1]/$CellContext`d[4, 2] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591630633678*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"0e1dcd42-0ec3-48f7-a16d-04345ac98726"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "4"}], ",", 
     FractionBox["2", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "3"}], "]"}]], "\[LessEqual]", 
    FractionBox["2", "3"]}]}],
  SequenceForm[4, ":  ", {9 $CellContext`k >= 4, 
    Rational[2, 3], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[4, 1]/$CellContext`d[4, 3] <= Rational[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916308867702`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"146c5b5e-d7da-45c6-a76b-192f4c4a61d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "16"}], ",", 
     FractionBox["4", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "5"}], "]"}]], "\[LessEqual]", 
    FractionBox["4", "3"]}]}],
  SequenceForm[4, ":  ", {9 $CellContext`k >= 16, 
    Rational[4, 3], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[4, 1]/$CellContext`d[4, 5] <= Rational[4, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591631173617*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"8787b3c4-fe98-4efc-a207-0a89c85459c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "6"}], "]"}]]}]}],
  SequenceForm[4, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[4, 1]/$CellContext`d[4, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916322996063`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"d5292d98-3687-4077-83c1-d5a202b93c2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "7"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[4, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[4, 1]/$CellContext`d[4, 7] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591632741975*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"192ef5e9-25ca-4947-b4b8-7597c9a6a7a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "8"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[4, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[4, 1]/$CellContext`d[4, 8] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916329318*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"e32e2ba4-dec1-43e9-8cbd-7c71e22a5639"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "9"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[4, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[4, 1]/$CellContext`d[4, 9] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591633441329*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"af188ccc-30db-4238-9c8c-84dd9b8b419a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "10"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[4, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[4, 1]/$CellContext`d[4, 10] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159163370396*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"2027e80b-50ad-4206-93f9-04db19a1c23f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "4"}], ",", 
     FractionBox["2", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["2", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "3"}], "]"}]], "\[Equal]", 
    FractionBox["2", "3"]}]}],
  SequenceForm[4, ":  ", {9 $CellContext`k >= 4, 
    Rational[2, 3], 
    DirectedInfinity[1]}, {9 $CellContext`k <= 4, 
    DirectedInfinity[-1], 
    Rational[2, 3]}, "   ", $CellContext`d[4, 2]/$CellContext`d[4, 3] == 
   Rational[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591633845882*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"6491b292-6c3b-4594-80ff-c619d72cddf9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "16"}], ",", 
     FractionBox["4", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "16"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["4", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "5"}], "]"}]], "\[Equal]", 
    FractionBox["4", "3"]}]}],
  SequenceForm[4, ":  ", {9 $CellContext`k >= 16, 
    Rational[4, 3], 
    DirectedInfinity[1]}, {9 $CellContext`k <= 16, 
    DirectedInfinity[-1], 
    Rational[4, 3]}, "   ", $CellContext`d[4, 2]/$CellContext`d[4, 5] == 
   Rational[4, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591634005863*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"a10cca9a-3855-4dd3-a6c0-5ce92857a7a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "6"}], "]"}]]}]}],
  SequenceForm[4, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[4, 2]/$CellContext`d[4, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159163502693*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"fd04ae85-181e-4e42-a6a2-b64ca9588bf7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "7"}], "]"}]]}]}],
  SequenceForm[4, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[4, 2]/$CellContext`d[4, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916355132217`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"f0ba9502-2b0a-40f6-85fb-dba46b185766"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "8"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[4, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[4, 2]/$CellContext`d[4, 8] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916357119827`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"7e80e579-f26d-405b-b995-b384456ebd9a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["2", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "9"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[4, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 4, 
    DirectedInfinity[-1], 
    Rational[2, 3]}, "   ", 
   Rational[2, 3] <= $CellContext`d[4, 2]/$CellContext`d[4, 9] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591636203828*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"95de1b72-14f6-4aa9-878b-628ab73d64f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["2", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "10"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[4, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 4, 
    DirectedInfinity[-1], 
    Rational[2, 3]}, "   ", 
   Rational[2, 3] <= $CellContext`d[4, 2]/$CellContext`d[4, 10] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916364678793`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"bdc31783-c7e1-43bc-9497-cb647780d254"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "5"}], "]"}]], "\[Equal]", "2"}]}],
  SequenceForm[4, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, 
   "   ", $CellContext`d[4, 3]/$CellContext`d[4, 5] == 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159163663463*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"7cc6c5ee-07e1-4543-bd25-90c351301438"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "9"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["3", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["3", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "6"}], "]"}]]}]}],
  SequenceForm[4, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 9, 
    DirectedInfinity[-1], 
    Rational[3, 2]}, "   ", 
   Rational[3, 2] <= $CellContext`d[4, 3]/$CellContext`d[4, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916376133757`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"43d57044-4eb2-4902-ab11-5020d650cc44"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "9"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["3", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["3", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "7"}], "]"}]]}]}],
  SequenceForm[4, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 9, 
    DirectedInfinity[-1], 
    Rational[3, 2]}, "   ", 
   Rational[3, 2] <= $CellContext`d[4, 3]/$CellContext`d[4, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591638066*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"3b844676-424f-4002-99ca-c2a3e6141c1a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[GreaterEqual]", "9"}], ",", 
     FractionBox["3", "2"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "8"}], "]"}]], "\[LessEqual]", 
    FractionBox["3", "2"]}]}],
  SequenceForm[4, ":  ", {4 $CellContext`k >= 9, 
    Rational[3, 2], 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[4, 3]/$CellContext`d[4, 8] <= 
   Rational[3, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591638261299*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"976f6093-2538-4427-a5c6-b10f47c869fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[GreaterEqual]", "9"}], ",", 
     FractionBox["3", "2"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "9"}], "]"}]], "\[LessEqual]", 
    FractionBox["3", "2"]}]}],
  SequenceForm[4, ":  ", {4 $CellContext`k >= 9, 
    Rational[3, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[4, 3]/$CellContext`d[4, 9] <= Rational[3, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591638739279*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"aa72bc00-b80a-4518-884e-ae9a603687a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[GreaterEqual]", "9"}], ",", 
     FractionBox["3", "2"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "10"}], "]"}]], "\[LessEqual]", 
    FractionBox["3", "2"]}]}],
  SequenceForm[4, ":  ", {4 $CellContext`k >= 9, 
    Rational[3, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[4, 3]/$CellContext`d[4, 10] <= Rational[3, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916390073977`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"3077ea1a-93b4-43aa-9e8f-cebb3f0ead6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"16", " ", "k"}], "\[LessEqual]", "9"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["3", "4"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["3", "4"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "6"}], "]"}]]}]}],
  SequenceForm[4, ":  ", {False, 0, 
    DirectedInfinity[1]}, {16 $CellContext`k <= 9, 
    DirectedInfinity[-1], 
    Rational[3, 4]}, "   ", 
   Rational[3, 4] <= $CellContext`d[4, 5]/$CellContext`d[4, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591640088689*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"d67ef3f7-11d4-45b9-91de-c62730f6bc39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"16", " ", "k"}], "\[LessEqual]", "9"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["3", "4"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["3", "4"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "7"}], "]"}]]}]}],
  SequenceForm[4, ":  ", {False, 0, 
    DirectedInfinity[1]}, {16 $CellContext`k <= 9, 
    DirectedInfinity[-1], 
    Rational[3, 4]}, "   ", 
   Rational[3, 4] <= $CellContext`d[4, 5]/$CellContext`d[4, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591640582226*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"b85c5f21-5fa7-4eee-9d1a-d2ec31ea318a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"16", " ", "k"}], "\[GreaterEqual]", "9"}], ",", 
     FractionBox["3", "4"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"16", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "4"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "4"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "8"}], "]"}]], "\[LessEqual]", 
    FractionBox["3", "4"]}]}],
  SequenceForm[4, ":  ", {16 $CellContext`k >= 9, 
    Rational[3, 4], 
    DirectedInfinity[1]}, {16 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 4]}, "   ", 
   Rational[1, 4] <= $CellContext`d[4, 5]/$CellContext`d[4, 8] <= 
   Rational[3, 4]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159164080308*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"9483223a-0195-478b-9a47-ade370f2de37"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"16", " ", "k"}], "\[GreaterEqual]", "9"}], ",", 
     FractionBox["3", "4"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "9"}], "]"}]], "\[LessEqual]", 
    FractionBox["3", "4"]}]}],
  SequenceForm[4, ":  ", {16 $CellContext`k >= 9, 
    Rational[3, 4], 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[4, 5]/$CellContext`d[4, 9] <= 
   Rational[3, 4]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591641307273*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"1e95855a-2054-4e9d-8b99-660eadb119b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"16", " ", "k"}], "\[GreaterEqual]", "9"}], ",", 
     FractionBox["3", "4"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "10"}], "]"}]], "\[LessEqual]", 
    FractionBox["3", "4"]}]}],
  SequenceForm[4, ":  ", {16 $CellContext`k >= 9, 
    Rational[3, 4], 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[4, 5]/$CellContext`d[4, 10] <= 
   Rational[3, 4]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916415903053`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"2f8ab98c-a16e-4fae-85ef-ca995ffa9d2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"k", "\[GreaterEqual]", 
       InterpretationBox[
        TemplateBox[{"Root",TemplateBox[{"\"1.22\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"],TagBox[
           RowBox[{"Root", "[", 
             RowBox[{
               RowBox[{
                 RowBox[{"625", "-", 
                   RowBox[{"10411", " ", "#1"}], "+", 
                   RowBox[{"7401", " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                   RowBox[{"512", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   RowBox[{"64", " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}], 
           Short[#, 7]& ],1.2189676875336388`},
         "NumericalApproximation"],
        Root[625 - 10411 # + 7401 #^2 + 512 #^3 + 64 #^4& , 2, 0]]}], ",", 
      InterpretationBox[
       TemplateBox[{"Root",TemplateBox[{"\"1.10\"", 
           DynamicBox[
            FEPrivate`FrontEndResource[
            "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
         TagBox[
          RowBox[{"Root", "[", 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{"-", "25"}], "-", 
                  RowBox[{"69", " ", "#1"}], "+", 
                  RowBox[{"113", " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                  RowBox[{"36", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                  RowBox[{"8", " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}], 
          Short[#, 7]& ],1.1040686969267985`},
        "NumericalApproximation"],
       Root[-25 - 69 # + 113 #^2 - 36 #^3 + 8 #^4& , 2, 0]], ",", 
      "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"k", "\[LessEqual]", "0"}], ",", 
      RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
    "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "7"}], "]"}]]}], "\[LessEqual]", 
   InterpretationBox[
    TemplateBox[{"Root",TemplateBox[{"\"1.10\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{
               RowBox[{"-", "25"}], "-", 
               RowBox[{"69", " ", "#1"}], "+", 
               RowBox[{"113", " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
               RowBox[{"36", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{"8", " ", 
                 SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}], 
       Short[#, 7]& ],1.1040686969267985`},
     "NumericalApproximation"],
    Root[-25 - 69 # + 113 #^2 - 36 #^3 + 8 #^4& , 2, 0]]}],
  SequenceForm[
  4, ":  ", {$CellContext`k >= 
    Root[625 - 10411 # + 7401 #^2 + 512 #^3 + 64 #^4& , 2, 0], 
    Root[-25 - 69 # + 113 #^2 - 36 #^3 + 8 #^4& , 2, 0], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[4, 6]/$CellContext`d[4, 7] <= 
   Root[-25 - 69 # + 113 #^2 - 36 #^3 + 8 #^4& , 2, 0]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591644094699*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"921c4a93-2f66-4416-807a-659d78a2582d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "8"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[4, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[4, 6]/$CellContext`d[4, 8] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591645095647*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"a8612812-532f-44d3-b44d-4446d86dae33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "9"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[4, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[4, 6]/$CellContext`d[4, 9] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591652212101*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"9429aaf1-dae0-486b-a69a-3c40390f4c78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "10"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[4, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[4, 6]/$CellContext`d[4, 10] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591653610495*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"2afc3d24-cf0e-41d3-9529-576d36f70f83"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "8"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[4, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[4, 7]/$CellContext`d[4, 8] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591654112886*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"4689ea5f-591e-4063-819c-76c3eca80e9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "9"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[4, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[4, 7]/$CellContext`d[4, 9] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591654507762*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"30055419-8f1c-46be-874b-b2f23a748dc2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "10"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[4, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[4, 7]/$CellContext`d[4, 10] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916549051847`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"ddb2d778-e583-4af1-a26b-598cb8b2e3a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "8"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "9"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[4, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[4, 8]/$CellContext`d[4, 9] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591655231983*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"b9f63e4d-2c40-4d0d-af11-7510fd74bbe3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "8"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "10"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[4, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[4, 8]/$CellContext`d[4, 10] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591655450349*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"d77fc2e4-69e9-4dd6-af89-629c0f59cdd7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"81", " ", "k"}], "\[GreaterEqual]", "100"}], ",", 
     FractionBox["10", "9"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "9"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"4", ",", "10"}], "]"}]], "\[LessEqual]", 
    FractionBox["10", "9"]}]}],
  SequenceForm[4, ":  ", {81 $CellContext`k >= 100, 
    Rational[10, 9], 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[4, 9]/$CellContext`d[4, 10] <= Rational[10, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591655860655*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"fa30c17a-c408-4611-94cb-e32bf2f080ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "9"}], ",", "3", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "2"}], "]"}]], "\[LessEqual]", "3"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 9, 3, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[5, 1]/$CellContext`d[5, 2] <= 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591656072619*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"5dffbe0d-dc4e-46e8-8584-6e3fbbe2f142"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "3"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[5, 1]/$CellContext`d[5, 3] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591656283218*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"9c363fa5-9748-458d-b702-d3d752376e19"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "4"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[5, 1]/$CellContext`d[5, 4] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159165651711*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"6f06873f-d8f2-427d-b795-a4c5b5a37942"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "8"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[5, 1]/$CellContext`d[5, 8] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591657991973*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"75e1d635-1828-404b-948d-4472d63df599"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "9"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[5, 1]/$CellContext`d[5, 9] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591658358356*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"995d1c06-ff84-4290-b0e5-a454bfaace03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "10"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[5, 1]/$CellContext`d[5, 10] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591658471793*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"29ab94ca-3baf-4e23-8ca6-3eada5e25e4e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "3"}], "]"}]], "\[Equal]", 
    FractionBox["1", "3"]}]}],
  SequenceForm[5, ":  ", {9 $CellContext`k >= 1, 
    Rational[1, 3], 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", $CellContext`d[5, 2]/$CellContext`d[5, 3] == 
   Rational[1, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591658594708*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"c832d446-ff44-48ac-b92f-74bfd92e8714"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "4"}], "]"}]], "\[Equal]", 
    FractionBox["1", "3"]}]}],
  SequenceForm[5, ":  ", {9 $CellContext`k >= 1, 
    Rational[1, 3], 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", $CellContext`d[5, 2]/$CellContext`d[5, 4] == 
   Rational[1, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591658741213*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"aa547a77-5509-444c-9503-0b96edfef98f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "6"}], "]"}]]}]}],
  SequenceForm[5, ":  ", {False, 0, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[5, 2]/$CellContext`d[5, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591659568362*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"3a9fc437-a7fb-424a-89ca-153939d7837a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "7"}], "]"}]]}]}],
  SequenceForm[5, ":  ", {False, 0, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[5, 2]/$CellContext`d[5, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159166014425*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"96371745-1444-43fe-b06b-3c5930eceae3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"81", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "9"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "9"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "8"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {81 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 9]}, "   ", 
   Rational[1, 9] <= $CellContext`d[5, 2]/$CellContext`d[5, 8] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591660392302*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"fa2ac647-5147-4fa2-aee8-d694bd490033"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "9"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[5, 2]/$CellContext`d[5, 9] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591660890174*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"f08e712f-43a2-45ff-8fee-b002ec27f961"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "10"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[5, 2]/$CellContext`d[5, 10] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591661068407*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"96e6f363-857e-43b5-bc49-9929e387f249"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "4"}], "]"}]], "\[Equal]", "1"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, 
   "   ", $CellContext`d[5, 3]/$CellContext`d[5, 4] == 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591661226158*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"54e9df8d-388a-4915-8a37-71d5e782da7a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "6"}], "]"}]]}]}],
  SequenceForm[5, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[5, 3]/$CellContext`d[5, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591662069023*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"cfc31074-bdd5-4214-bd71-65ddcf8ed054"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "7"}], "]"}]]}]}],
  SequenceForm[5, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[5, 3]/$CellContext`d[5, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591662616517*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"12a65966-4da8-4085-96bc-e3125bcde2ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "9"}], ",", "3", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "8"}], "]"}]], "\[LessEqual]", "3"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 9, 3, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[5, 3]/$CellContext`d[5, 8] <= 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916628641443`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"12dcdc67-a8f5-4f43-9a40-90e98afd26dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "9"}], ",", "3", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "9"}], "]"}]], "\[LessEqual]", "3"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 9, 3, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[5, 3]/$CellContext`d[5, 9] <= 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159166333712*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"3aa9b342-e393-41e9-9b10-bf12b42a9fc0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "9"}], ",", "3", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "10"}], "]"}]], "\[LessEqual]", "3"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 9, 3, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[5, 3]/$CellContext`d[5, 10] <= 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591663524692*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"d86bfde7-8088-486d-88b0-bd8d3f0faf36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "6"}], "]"}]]}]}],
  SequenceForm[5, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[5, 4]/$CellContext`d[5, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591664394308*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"3f0d1475-a14f-437a-bd99-ac0709ab36cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "7"}], "]"}]]}]}],
  SequenceForm[5, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[5, 4]/$CellContext`d[5, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591664963994*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"4e70a7f4-ded0-4904-8a0d-01b6fbf3b89c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "9"}], ",", "3", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "8"}], "]"}]], "\[LessEqual]", "3"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 9, 3, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[5, 4]/$CellContext`d[5, 8] <= 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591665237903*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"2d429bc4-a849-4cde-9ad2-12fef1344199"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "9"}], ",", "3", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "9"}], "]"}]], "\[LessEqual]", "3"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 9, 3, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[5, 4]/$CellContext`d[5, 9] <= 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591665739225*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"8f483907-aa6d-48e0-bac5-64faa03d62cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "9"}], ",", "3", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "10"}], "]"}]], "\[LessEqual]", "3"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 9, 3, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[5, 4]/$CellContext`d[5, 10] <= 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591665952623*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"f0e9c323-a8e1-442e-ae0f-f7c7c548018f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "8"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[5, 6]/$CellContext`d[5, 8] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591674273485*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"ca4f6552-aa97-4c46-b590-ef614220b2b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"k", "\[GreaterEqual]", 
       InterpretationBox[
        TemplateBox[{"Root",TemplateBox[{"\"1.11\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"],TagBox[
           RowBox[{"Root", "[", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   RowBox[{"-", "1500625"}], "+", 
                   RowBox[{"80781541", " ", "#1"}], "-", 
                   RowBox[{"13487578", " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"76385222", " ", 
                    SuperscriptBox["#1", "3"]}], "-", 
                   RowBox[{"20140453", " ", 
                    SuperscriptBox["#1", "4"]}], "+", 
                   RowBox[{"37662769", " ", 
                    SuperscriptBox["#1", "5"]}]}], "&"}], ",", "2"}], "]"}], 
           Short[#, 7]& ],1.1094875210760982`},
         "NumericalApproximation"],
        Root[-1500625 + 80781541 # - 13487578 #^2 - 76385222 #^3 - 
         20140453 #^4 + 37662769 #^5& , 2, 0]]}], ",", 
      InterpretationBox[
       TemplateBox[{"Root",TemplateBox[{"\"1.05\"", 
           DynamicBox[
            FEPrivate`FrontEndResource[
            "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
         TagBox[
          RowBox[{"Root", "[", 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{"-", "1225"}], "-", 
                  RowBox[{"9479", " ", "#1"}], "-", 
                  RowBox[{"3702", " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                  RowBox[{"678", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                  RowBox[{"5335", " ", 
                    SuperscriptBox["#1", "4"]}], "+", 
                  RowBox[{"6137", " ", 
                    SuperscriptBox["#1", "5"]}]}], "&"}], ",", "3"}], "]"}], 
          Short[#, 7]& ],1.0533221354723816`},
        "NumericalApproximation"],
       Root[-1225 - 9479 # - 3702 #^2 + 678 #^3 + 5335 #^4 + 6137 #^5& , 3, 
        0]], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"k", "\[LessEqual]", "0"}], ",", 
      RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
    "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "9"}], "]"}]]}], "\[LessEqual]", 
   InterpretationBox[
    TemplateBox[{"Root",TemplateBox[{"\"1.05\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{
               RowBox[{"-", "1225"}], "-", 
               RowBox[{"9479", " ", "#1"}], "-", 
               RowBox[{"3702", " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
               RowBox[{"678", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{"5335", " ", 
                 SuperscriptBox["#1", "4"]}], "+", 
               RowBox[{"6137", " ", 
                 SuperscriptBox["#1", "5"]}]}], "&"}], ",", "3"}], "]"}], 
       Short[#, 7]& ],1.0533221354723816`},
     "NumericalApproximation"],
    Root[-1225 - 9479 # - 3702 #^2 + 678 #^3 + 5335 #^4 + 6137 #^5& , 3, 0]]}],
  SequenceForm[
  5, ":  ", {$CellContext`k >= 
    Root[-1500625 + 80781541 # - 13487578 #^2 - 76385222 #^3 - 20140453 #^4 + 
      37662769 #^5& , 2, 0], 
    Root[-1225 - 9479 # - 3702 #^2 + 678 #^3 + 5335 #^4 + 6137 #^5& , 3, 0], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[5, 6]/$CellContext`d[5, 9] <= 
   Root[-1225 - 9479 # - 3702 #^2 + 678 #^3 + 5335 #^4 + 6137 #^5& , 3, 0]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591681013027*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"c701d5fa-ba27-4364-a21c-d9ff7dd83220"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"k", "\[GreaterEqual]", 
       InterpretationBox[
        TemplateBox[{"Root",TemplateBox[{"\"1.43\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"],TagBox[
           RowBox[{"Root", "[", 
             RowBox[{
               RowBox[{
                 RowBox[{"1", "-", 
                   RowBox[{"944", " ", "#1"}], "+", 
                   RowBox[{"602", " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                   RowBox[{"40", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], 
           Short[#, 7]& ],1.4268423705705118`},
         "NumericalApproximation"],
        Root[1 - 944 # + 602 #^2 + 40 #^3 + #^4& , 2, 0]]}], ",", 
      InterpretationBox[
       TemplateBox[{"Root",TemplateBox[{"\"1.19\"", 
           DynamicBox[
            FEPrivate`FrontEndResource[
            "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
         TagBox[
          RowBox[{"Root", "[", 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{"-", "1"}], "-", 
                  RowBox[{"30", " ", "#1"}], "+", 
                  RowBox[{"22", " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                  RowBox[{"2", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                  SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], 
          Short[#, 7]& ],1.19450507348044},
        "NumericalApproximation"],
       Root[-1 - 30 # + 22 #^2 + 2 #^3 + #^4& , 2, 0]], ",", "\[Infinity]"}], 
     "}"}], "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"k", "\[LessEqual]", "0"}], ",", 
      RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
    "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "10"}], "]"}]]}], "\[LessEqual]", 
   InterpretationBox[
    TemplateBox[{"Root",TemplateBox[{"\"1.19\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{
               RowBox[{"-", "1"}], "-", 
               RowBox[{"30", " ", "#1"}], "+", 
               RowBox[{"22", " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
               RowBox[{"2", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
               SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], 
       Short[#, 7]& ],1.19450507348044},
     "NumericalApproximation"],
    Root[-1 - 30 # + 22 #^2 + 2 #^3 + #^4& , 2, 0]]}],
  SequenceForm[
  5, ":  ", {$CellContext`k >= 
    Root[1 - 944 # + 602 #^2 + 40 #^3 + #^4& , 2, 0], 
    Root[-1 - 30 # + 22 #^2 + 2 #^3 + #^4& , 2, 0], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[5, 6]/$CellContext`d[5, 10] <= 
   Root[-1 - 30 # + 22 #^2 + 2 #^3 + #^4& , 2, 0]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591681989183*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"7f87a0be-aae1-4a29-8128-62176021a5a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "8"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[5, 7]/$CellContext`d[5, 8] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591682587143*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"c39a9b43-7ef4-47ed-a5f3-efff8b78d843"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "9"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[5, 7]/$CellContext`d[5, 9] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591683097728*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"5dc3cb0f-48b1-47b1-93d6-0a57083eb208"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "10"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[5, 7]/$CellContext`d[5, 10] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916834549417`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"58aecd47-1d12-4e87-bcd7-066e133f7639"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "9"}], ",", "3", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "8"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "9"}], "]"}]], "\[LessEqual]", "3"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 9, 3, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[5, 8]/$CellContext`d[5, 9] <= 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591684062852*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"6499e1ee-639f-4427-8555-22408913f0d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "9"}], ",", "3", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "8"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "10"}], "]"}]], "\[LessEqual]", "3"}]}],
  SequenceForm[5, ":  ", {$CellContext`k >= 9, 3, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[5, 8]/$CellContext`d[5, 10] <= 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591684237173*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"aca26bc3-4a12-4344-b91a-94f519baa06c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"56", " ", 
        SqrtBox["2"]}], "+", "k"}], "\[GreaterEqual]", "81"}], ",", 
     RowBox[{"7", "-", 
      RowBox[{"4", " ", 
       SqrtBox["2"]}]}], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "9"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"5", ",", "10"}], "]"}]], "\[LessEqual]", 
    RowBox[{"7", "-", 
     RowBox[{"4", " ", 
      SqrtBox["2"]}]}]}]}],
  SequenceForm[
  5, ":  ", {
   56 2^Rational[1, 2] + $CellContext`k >= 81, 7 - 4 2^Rational[1, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[5, 9]/$CellContext`d[5, 10] <= 7 - 4 2^Rational[1, 2]],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591684750595*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"b74e0616-abe1-4312-b812-c76cff7d56eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"108", " ", 
        SqrtBox["2"]}], "+", "k"}], "\[GreaterEqual]", "153"}], ",", 
     RowBox[{"9", "-", 
      RowBox[{"6", " ", 
       SqrtBox["2"]}]}], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "2"}], "]"}]], "\[LessEqual]", 
    RowBox[{"9", "-", 
     RowBox[{"6", " ", 
      SqrtBox["2"]}]}]}]}],
  SequenceForm[
  6, ":  ", {
   108 2^Rational[1, 2] + $CellContext`k >= 153, 9 - 6 2^Rational[1, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[6, 1]/$CellContext`d[6, 2] <= 9 - 6 2^Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159168538207*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"d104d07e-6e64-4873-a496-c68fd4013f20"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"4", " ", 
        SqrtBox["3"]}], "+", "k"}], "\[GreaterEqual]", "7"}], ",", 
     RowBox[{"2", "-", 
      SqrtBox["3"]}], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "3"}], "]"}]], "\[LessEqual]", 
    RowBox[{"2", "-", 
     SqrtBox["3"]}]}]}],
  SequenceForm[
  6, ":  ", {4 3^Rational[1, 2] + $CellContext`k >= 7, 2 - 3^Rational[1, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[6, 1]/$CellContext`d[6, 3] <= 2 - 3^Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916858151693`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"8d99df26-eed0-4289-ba25-3259699c16e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "7"}], "]"}]]}]}],
  SequenceForm[6, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[6, 1]/$CellContext`d[6, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591687984157*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"af935071-41e8-4035-8fd9-aefadb81dba6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"4", " ", 
        SqrtBox["2"]}], "+", 
       RowBox[{"49", " ", "k"}]}], "\[GreaterEqual]", "9"}], ",", 
     RowBox[{
      FractionBox["1", "7"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["2"]}]}], ")"}]}], ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "8"}], "]"}]], "\[LessEqual]", 
    RowBox[{
     FractionBox["1", "7"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]}], ")"}]}]}]}],
  SequenceForm[
  6, ":  ", {
   4 2^Rational[1, 2] + 49 $CellContext`k >= 9, 
    Rational[1, 7] (-1 + 2 2^Rational[1, 2]), 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[6, 1]/$CellContext`d[6, 8] <= 
   Rational[1, 7] (-1 + 2 2^Rational[1, 2])],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591688666301*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"e692dacf-f673-4eae-8577-d995756bb9d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "9"}], "]"}]], "\[LessEqual]", 
    FractionBox["1", "3"]}]}],
  SequenceForm[6, ":  ", {9 $CellContext`k >= 1, 
    Rational[1, 3], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[6, 1]/$CellContext`d[6, 9] <= Rational[1, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591688997739*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"ab208a78-4f83-4232-b800-8f382b5db560"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", 
        SqrtBox["2"]}], "+", "k"}], "\[GreaterEqual]", "3"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["2"]}], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "10"}], "]"}]], "\[LessEqual]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox["2"]}]}]}],
  SequenceForm[
  6, ":  ", {
   2 2^Rational[1, 2] + $CellContext`k >= 3, -1 + 2^Rational[1, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[6, 1]/$CellContext`d[6, 10] <= -1 + 2^Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591689531433*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"f8b6f639-7c3e-432f-98d1-606d63e24206"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "4"}], ",", 
     FractionBox["2", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "3"}], "]"}]], "\[LessEqual]", 
    FractionBox["2", "3"]}]}],
  SequenceForm[6, ":  ", {9 $CellContext`k >= 4, 
    Rational[2, 3], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[6, 2]/$CellContext`d[6, 3] <= Rational[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515916902977943`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"bf3f02be-b67e-4e57-9381-ec753a8c33f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "7"}], "]"}]]}]}],
  SequenceForm[6, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[6, 2]/$CellContext`d[6, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159169342204*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"e4806b6f-8e44-4ea9-9908-8ac8ffe13df0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"441", " ", "k"}], "\[GreaterEqual]", 
      RowBox[{"57", "+", 
       RowBox[{"40", " ", 
        SqrtBox["2"]}]}]}], ",", 
     RowBox[{
      FractionBox["1", "21"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        RowBox[{"4", " ", 
         SqrtBox["2"]}]}], ")"}]}], ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "8"}], "]"}]], "\[LessEqual]", 
    RowBox[{
     FractionBox["1", "21"], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"4", " ", 
        SqrtBox["2"]}]}], ")"}]}]}]}],
  SequenceForm[
  6, ":  ", {
   441 $CellContext`k >= 57 + 40 2^Rational[1, 2], 
    Rational[1, 21] (5 + 4 2^Rational[1, 2]), 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[6, 2]/$CellContext`d[6, 8] <= 
   Rational[1, 21] (5 + 4 2^Rational[1, 2])],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591694273799*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"050d982c-a7a6-4e08-a1ae-80a0bf4e1841"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"16", " ", "k"}], "\[GreaterEqual]", "9"}], ",", 
     FractionBox["3", "4"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "9"}], "]"}]], "\[LessEqual]", 
    FractionBox["3", "4"]}]}],
  SequenceForm[6, ":  ", {16 $CellContext`k >= 9, 
    Rational[3, 4], 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[6, 2]/$CellContext`d[6, 9] <= 
   Rational[3, 4]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591695168716*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"d0b85af6-7df0-4f11-a667-0eb3e8ab62a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", 
      RowBox[{"3", "+", 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]}]}], ",", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox["2"]}], ")"}]}], ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["2", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "10"}], "]"}]], "\[LessEqual]", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}], ")"}]}]}]}],
  SequenceForm[
  6, ":  ", {
   9 $CellContext`k >= 3 + 2 2^Rational[1, 2], 
    Rational[1, 3] (1 + 2^Rational[1, 2]), 
    DirectedInfinity[1]}, {9 $CellContext`k <= 4, 
    DirectedInfinity[-1], 
    Rational[2, 3]}, "   ", 
   Rational[2, 3] <= $CellContext`d[6, 2]/$CellContext`d[6, 10] <= 
   Rational[1, 3] (1 + 2^Rational[1, 2])],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591695925191*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"25bfd086-dc58-4147-85b4-ee5973fa9bd0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "4"}], "]"}]]}]}],
  SequenceForm[6, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[6, 3]/$CellContext`d[6, 4]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591696828512*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"5e28c69d-ec4c-43ad-900d-19ec63b8bd0f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "5"}], "]"}]]}]}],
  SequenceForm[6, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[6, 3]/$CellContext`d[6, 5]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591697366138*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"a9688c2d-bfa2-48d6-a990-50aebf90a10d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
    "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"k", "\[LessEqual]", 
       InterpretationBox[
        TemplateBox[{"Root",TemplateBox[{"\"61.8\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"],TagBox[
           RowBox[{"Root", "[", 
             RowBox[{
               RowBox[{
                 RowBox[{"7744", "+", 
                   RowBox[{"290960784", " ", "#1"}], "-", 
                   RowBox[{"6782842860", " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                   RowBox[{"60418557684", " ", 
                    SuperscriptBox["#1", "3"]}], "-", 
                   RowBox[{"274035844587", " ", 
                    SuperscriptBox["#1", "4"]}], "+", 
                   RowBox[{"677249814873", " ", 
                    SuperscriptBox["#1", "5"]}], "-", 
                   RowBox[{"894980577861", " ", 
                    SuperscriptBox["#1", "6"]}], "+", 
                   RowBox[{"603818269839", " ", 
                    SuperscriptBox["#1", "7"]}], "-", 
                   RowBox[{"160813808784", " ", 
                    SuperscriptBox["#1", "8"]}], "+", 
                   RowBox[{"2015974656", " ", 
                    SuperscriptBox["#1", "9"]}], "+", 
                   RowBox[{"6967296", " ", 
                    SuperscriptBox["#1", "10"]}]}], "&"}], ",", "6"}], "]"}], 
           Short[#, 7]& ],61.82851802829733},
         "NumericalApproximation"],
        Root[
        7744 + 290960784 # - 6782842860 #^2 + 60418557684 #^3 - 
         274035844587 #^4 + 677249814873 #^5 - 894980577861 #^6 + 
         603818269839 #^7 - 160813808784 #^8 + 2015974656 #^9 + 
         6967296 #^10& , 6, 0]]}], ",", 
      RowBox[{"-", "\[Infinity]"}], ",", 
      SqrtBox[
       InterpretationBox[
        TemplateBox[{"Root",TemplateBox[{"\"61.8\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"],TagBox[
           RowBox[{"Root", "[", 
             RowBox[{
               RowBox[{
                 RowBox[{"7744", "+", 
                   RowBox[{"290960784", " ", "#1"}], "-", 
                   RowBox[{"6782842860", " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                   RowBox[{"60418557684", " ", 
                    SuperscriptBox["#1", "3"]}], "-", 
                   RowBox[{"274035844587", " ", 
                    SuperscriptBox["#1", "4"]}], "+", 
                   RowBox[{"677249814873", " ", 
                    SuperscriptBox["#1", "5"]}], "-", 
                   RowBox[{"894980577861", " ", 
                    SuperscriptBox["#1", "6"]}], "+", 
                   RowBox[{"603818269839", " ", 
                    SuperscriptBox["#1", "7"]}], "-", 
                   RowBox[{"160813808784", " ", 
                    SuperscriptBox["#1", "8"]}], "+", 
                   RowBox[{"2015974656", " ", 
                    SuperscriptBox["#1", "9"]}], "+", 
                   RowBox[{"6967296", " ", 
                    SuperscriptBox["#1", "10"]}]}], "&"}], ",", "6"}], "]"}], 
           Short[#, 7]& ],61.82851802829733},
         "NumericalApproximation"],
        Root[
        7744 + 290960784 # - 6782842860 #^2 + 60418557684 #^3 - 
         274035844587 #^4 + 677249814873 #^5 - 894980577861 #^6 + 
         603818269839 #^7 - 160813808784 #^8 + 2015974656 #^9 + 
         6967296 #^10& , 6, 0]]]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
     "\[InvisibleSpace]", 
    SqrtBox[
     InterpretationBox[
      TemplateBox[{"Root",TemplateBox[{"\"61.8\"", 
          DynamicBox[
           FEPrivate`FrontEndResource[
           "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
        TagBox[
         RowBox[{"Root", "[", 
           RowBox[{
             RowBox[{
               RowBox[{"7744", "+", 
                 RowBox[{"290960784", " ", "#1"}], "-", 
                 RowBox[{"6782842860", " ", 
                   SuperscriptBox["#1", "2"]}], "+", 
                 RowBox[{"60418557684", " ", 
                   SuperscriptBox["#1", "3"]}], "-", 
                 RowBox[{"274035844587", " ", 
                   SuperscriptBox["#1", "4"]}], "+", 
                 RowBox[{"677249814873", " ", 
                   SuperscriptBox["#1", "5"]}], "-", 
                 RowBox[{"894980577861", " ", 
                   SuperscriptBox["#1", "6"]}], "+", 
                 RowBox[{"603818269839", " ", 
                   SuperscriptBox["#1", "7"]}], "-", 
                 RowBox[{"160813808784", " ", 
                   SuperscriptBox["#1", "8"]}], "+", 
                 RowBox[{"2015974656", " ", 
                   SuperscriptBox["#1", "9"]}], "+", 
                 RowBox[{"6967296", " ", 
                   SuperscriptBox["#1", "10"]}]}], "&"}], ",", "6"}], "]"}], 
         Short[#, 7]& ],61.82851802829733},
       "NumericalApproximation"],
      Root[
      7744 + 290960784 # - 6782842860 #^2 + 60418557684 #^3 - 
       274035844587 #^4 + 677249814873 #^5 - 894980577861 #^6 + 
       603818269839 #^7 - 160813808784 #^8 + 2015974656 #^9 + 6967296 #^10& , 
       6, 0]]]}], "\[LessEqual]", 
   FractionBox[
    RowBox[{"d", "[", 
     RowBox[{"6", ",", "3"}], "]"}], 
    RowBox[{"d", "[", 
     RowBox[{"6", ",", "7"}], "]"}]]}],
  SequenceForm[6, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 
    Root[7744 + 290960784 # - 6782842860 #^2 + 60418557684 #^3 - 
      274035844587 #^4 + 677249814873 #^5 - 894980577861 #^6 + 
      603818269839 #^7 - 160813808784 #^8 + 2015974656 #^9 + 6967296 #^10& , 
      6, 0], 
    DirectedInfinity[-1], 
    Root[7744 + 290960784 # - 6782842860 #^2 + 60418557684 #^3 - 
      274035844587 #^4 + 677249814873 #^5 - 894980577861 #^6 + 
      603818269839 #^7 - 160813808784 #^8 + 2015974656 #^9 + 6967296 #^10& , 
      6, 0]^Rational[1, 2]}, "   ", 
   Root[7744 + 290960784 # - 6782842860 #^2 + 60418557684 #^3 - 
      274035844587 #^4 + 677249814873 #^5 - 894980577861 #^6 + 
      603818269839 #^7 - 160813808784 #^8 + 2015974656 #^9 + 6967296 #^10& , 
      6, 0]^Rational[1, 2] <= $CellContext`d[6, 3]/$CellContext`d[6, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159169873667*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"150c7217-85e0-4db2-ba81-0113080c0dca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "8"}], "]"}]]}]}],
  SequenceForm[6, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[6, 3]/$CellContext`d[6, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591699546753*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"bf07e69a-30d7-493e-8bd7-e9b8966b1b05"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "9"}], "]"}]]}]}],
  SequenceForm[6, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[6, 3]/$CellContext`d[6, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591700250955*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"7c509b7a-fcf3-4b0b-891d-f956f6941ffd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "10"}], "]"}]]}]}],
  SequenceForm[6, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[6, 3]/$CellContext`d[6, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591701142891*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"93e4b760-2bde-46a7-bf37-d90081f4044d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "2"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "8"}], "]"}]], "\[LessEqual]", 
    FractionBox["1", "2"]}]}],
  SequenceForm[6, ":  ", {4 $CellContext`k >= 1, 
    Rational[1, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[6, 7]/$CellContext`d[6, 8] <= Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591724355773*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"00dd4e9d-622d-4329-9bb6-02df9ef8223f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "2"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "9"}], "]"}]], "\[LessEqual]", 
    FractionBox["1", "2"]}]}],
  SequenceForm[6, ":  ", {4 $CellContext`k >= 1, 
    Rational[1, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[6, 7]/$CellContext`d[6, 9] <= Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591725051958*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"8f6ffdd5-4668-4245-91d1-7ea8eb32c38a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"25", " ", "k"}], "\[GreaterEqual]", "16"}], ",", 
     FractionBox["4", "5"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "10"}], "]"}]], "\[LessEqual]", 
    FractionBox["4", "5"]}]}],
  SequenceForm[6, ":  ", {25 $CellContext`k >= 16, 
    Rational[4, 5], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[6, 7]/$CellContext`d[6, 10] <= Rational[4, 5]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159172674398*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"ad5f94e6-3a2c-4021-80be-192fbfef7f1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "8"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "9"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[6, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[6, 8]/$CellContext`d[6, 9] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591727814928*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"94799129-d9b9-46ee-b90a-d22c489dfd80"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"6", " ", 
        SqrtBox["2"]}], "+", "k"}], "\[LessEqual]", "11"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     RowBox[{"3", "-", 
      SqrtBox["2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"3", "-", 
     SqrtBox["2"]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "8"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "10"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[6, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {6 2^Rational[1, 2] + $CellContext`k <= 11, 
    DirectedInfinity[-1], 3 - 2^Rational[1, 2]}, "   ", 
   3 - 2^Rational[1, 2] <= $CellContext`d[6, 8]/$CellContext`d[6, 10] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591728693098*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"780feb94-1cc5-480d-9b14-941e230016bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"25", " ", "k"}], "\[GreaterEqual]", "64"}], ",", 
     FractionBox["8", "5"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "9"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"6", ",", "10"}], "]"}]], "\[LessEqual]", 
    FractionBox["8", "5"]}]}],
  SequenceForm[6, ":  ", {25 $CellContext`k >= 64, 
    Rational[8, 5], 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[6, 9]/$CellContext`d[6, 10] <= Rational[8, 5]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591729447253*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"d2367351-7132-4fcd-87db-83612584f92c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"16", " ", "k"}], "\[GreaterEqual]", "9"}], ",", 
     FractionBox["3", "4"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "2"}], "]"}]], "\[LessEqual]", 
    FractionBox["3", "4"]}]}],
  SequenceForm[7, ":  ", {16 $CellContext`k >= 9, 
    Rational[3, 4], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[7, 1]/$CellContext`d[7, 2] <= Rational[3, 4]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591729744672*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"6acb06f8-3504-49a8-b5ab-442555445832"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"80", " ", 
        SqrtBox["2"]}], "+", 
       RowBox[{"289", " ", "k"}]}], "\[GreaterEqual]", "132"}], ",", 
     RowBox[{
      FractionBox["2", "17"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "-", 
        RowBox[{"2", " ", 
         SqrtBox["2"]}]}], ")"}]}], ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "3"}], "]"}]], "\[LessEqual]", 
    RowBox[{
     FractionBox["2", "17"], " ", 
     RowBox[{"(", 
      RowBox[{"5", "-", 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]}], ")"}]}]}]}],
  SequenceForm[
  7, ":  ", {
   80 2^Rational[1, 2] + 289 $CellContext`k >= 132, 
    Rational[2, 17] (5 - 2 2^Rational[1, 2]), 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[7, 1]/$CellContext`d[7, 3] <= 
   Rational[2, 17] (5 - 2 2^Rational[1, 2])],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591730219968*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"92619acf-3ca0-499e-90b5-247362505b08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "4"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[7, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[7, 1]/$CellContext`d[7, 4] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591730529154*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"3994bff2-517b-4797-93c3-d39be01034e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "2"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "8"}], "]"}]], "\[LessEqual]", 
    FractionBox["1", "2"]}]}],
  SequenceForm[7, ":  ", {4 $CellContext`k >= 1, 
    Rational[1, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[7, 1]/$CellContext`d[7, 8] <= Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591732369363*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"6d330095-08c7-4caf-a023-81eea6d3d9ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "2"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "9"}], "]"}]], "\[LessEqual]", 
    FractionBox["1", "2"]}]}],
  SequenceForm[7, ":  ", {4 $CellContext`k >= 1, 
    Rational[1, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[7, 1]/$CellContext`d[7, 9] <= Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591732701262*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"78493c28-2f23-44bd-be84-a2df219c9e1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "4"}], ",", 
     FractionBox["2", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "10"}], "]"}]], "\[LessEqual]", 
    FractionBox["2", "3"]}]}],
  SequenceForm[7, ":  ", {9 $CellContext`k >= 4, 
    Rational[2, 3], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[7, 1]/$CellContext`d[7, 10] <= Rational[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591733030828*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"db17d588-26de-4b62-b9e1-81f3507ab127"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "4"}], ",", 
     FractionBox["2", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "3"}], "]"}]], "\[LessEqual]", 
    FractionBox["2", "3"]}]}],
  SequenceForm[7, ":  ", {9 $CellContext`k >= 4, 
    Rational[2, 3], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[7, 2]/$CellContext`d[7, 3] <= Rational[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591733534905*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"18c4f1a3-4145-435d-83ae-0e029dea94b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "6"}], "]"}]]}]}],
  SequenceForm[7, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[7, 2]/$CellContext`d[7, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591736055994*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"30eda4c6-021a-414e-b6f3-37ae3b50f25a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "4"}], ",", 
     FractionBox["2", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "8"}], "]"}]], "\[LessEqual]", 
    FractionBox["2", "3"]}]}],
  SequenceForm[7, ":  ", {9 $CellContext`k >= 4, 
    Rational[2, 3], 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[7, 2]/$CellContext`d[7, 8] <= 
   Rational[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591736353862*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"92a35fd4-1b25-44f2-890c-6853216659c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "4"}], ",", 
     FractionBox["2", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["2", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "9"}], "]"}]], "\[Equal]", 
    FractionBox["2", "3"]}]}],
  SequenceForm[7, ":  ", {9 $CellContext`k >= 4, 
    Rational[2, 3], 
    DirectedInfinity[1]}, {9 $CellContext`k <= 4, 
    DirectedInfinity[-1], 
    Rational[2, 3]}, "   ", $CellContext`d[7, 2]/$CellContext`d[7, 9] == 
   Rational[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917365478497`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"2146c8c4-edea-422f-918e-5365a4cecd73"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"81", " ", "k"}], "\[GreaterEqual]", "64"}], ",", 
     FractionBox["8", "9"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["2", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "10"}], "]"}]], "\[LessEqual]", 
    FractionBox["8", "9"]}]}],
  SequenceForm[7, ":  ", {81 $CellContext`k >= 64, 
    Rational[8, 9], 
    DirectedInfinity[1]}, {9 $CellContext`k <= 4, 
    DirectedInfinity[-1], 
    Rational[2, 3]}, "   ", 
   Rational[2, 3] <= $CellContext`d[7, 2]/$CellContext`d[7, 10] <= 
   Rational[8, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591736940114*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"748d123d-a67d-4978-9a5a-67a26b10681d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "4"}], "]"}]]}]}],
  SequenceForm[7, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[7, 3]/$CellContext`d[7, 4]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591737290266*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"c28f108a-666b-4ac5-b1bd-d846ded656bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "5"}], "]"}]]}]}],
  SequenceForm[7, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[7, 3]/$CellContext`d[7, 5]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917377857637`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"b7e48059-7c05-4f34-9bdc-ae81bee8ab5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
    "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"k", "\[LessEqual]", 
       InterpretationBox[
        TemplateBox[{"Root",TemplateBox[{"\"63.6\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"],TagBox[
           RowBox[{"Root", "[", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   RowBox[{"-", "14637417984"}], "+", 
                   RowBox[{"253570773456", " ", "#1"}], "-", 
                   RowBox[{"2259294716376", " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                   RowBox[{"14226627485565", " ", 
                    SuperscriptBox["#1", "3"]}], "-", 
                   RowBox[{"65960002546284", " ", 
                    SuperscriptBox["#1", "4"]}], "+", 
                   RowBox[{"216425700787620", " ", 
                    SuperscriptBox["#1", "5"]}], "-", 
                   RowBox[{"492062343977916", " ", 
                    SuperscriptBox["#1", "6"]}], "+", 
                   RowBox[{"782711166381062", " ", 
                    SuperscriptBox["#1", "7"]}], "-", 
                   RowBox[{"892396597211316", " ", 
                    SuperscriptBox["#1", "8"]}], "+", 
                   RowBox[{"732430210466916", " ", 
                    SuperscriptBox["#1", "9"]}], "-", 
                   RowBox[{"410390834384412", " ", 
                    SuperscriptBox["#1", "10"]}], "+", 
                   RowBox[{"139707882692901", " ", 
                    SuperscriptBox["#1", "11"]}], "-", 
                   RowBox[{"19474287964848", " ", 
                    SuperscriptBox["#1", "12"]}], "+", 
                   RowBox[{"220028016384", " ", 
                    SuperscriptBox["#1", "13"]}], "+", 
                   RowBox[{"833089536", " ", 
                    SuperscriptBox["#1", "14"]}]}], "&"}], ",", "6"}], "]"}], 
           Short[#, 7]& ],63.6430843409629},
         "NumericalApproximation"],
        Root[-14637417984 + 253570773456 # - 2259294716376 #^2 + 
         14226627485565 #^3 - 65960002546284 #^4 + 216425700787620 #^5 - 
         492062343977916 #^6 + 782711166381062 #^7 - 892396597211316 #^8 + 
         732430210466916 #^9 - 410390834384412 #^10 + 139707882692901 #^11 - 
         19474287964848 #^12 + 220028016384 #^13 + 833089536 #^14& , 6, 0]]}],
       ",", 
      RowBox[{"-", "\[Infinity]"}], ",", 
      SqrtBox[
       InterpretationBox[
        TemplateBox[{"Root",TemplateBox[{"\"63.6\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"],TagBox[
           RowBox[{"Root", "[", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   RowBox[{"-", "14637417984"}], "+", 
                   RowBox[{"253570773456", " ", "#1"}], "-", 
                   RowBox[{"2259294716376", " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                   RowBox[{"14226627485565", " ", 
                    SuperscriptBox["#1", "3"]}], "-", 
                   RowBox[{"65960002546284", " ", 
                    SuperscriptBox["#1", "4"]}], "+", 
                   RowBox[{"216425700787620", " ", 
                    SuperscriptBox["#1", "5"]}], "-", 
                   RowBox[{"492062343977916", " ", 
                    SuperscriptBox["#1", "6"]}], "+", 
                   RowBox[{"782711166381062", " ", 
                    SuperscriptBox["#1", "7"]}], "-", 
                   RowBox[{"892396597211316", " ", 
                    SuperscriptBox["#1", "8"]}], "+", 
                   RowBox[{"732430210466916", " ", 
                    SuperscriptBox["#1", "9"]}], "-", 
                   RowBox[{"410390834384412", " ", 
                    SuperscriptBox["#1", "10"]}], "+", 
                   RowBox[{"139707882692901", " ", 
                    SuperscriptBox["#1", "11"]}], "-", 
                   RowBox[{"19474287964848", " ", 
                    SuperscriptBox["#1", "12"]}], "+", 
                   RowBox[{"220028016384", " ", 
                    SuperscriptBox["#1", "13"]}], "+", 
                   RowBox[{"833089536", " ", 
                    SuperscriptBox["#1", "14"]}]}], "&"}], ",", "6"}], "]"}], 
           Short[#, 7]& ],63.6430843409629},
         "NumericalApproximation"],
        Root[-14637417984 + 253570773456 # - 2259294716376 #^2 + 
         14226627485565 #^3 - 65960002546284 #^4 + 216425700787620 #^5 - 
         492062343977916 #^6 + 782711166381062 #^7 - 892396597211316 #^8 + 
         732430210466916 #^9 - 410390834384412 #^10 + 139707882692901 #^11 - 
         19474287964848 #^12 + 220028016384 #^13 + 833089536 #^14& , 6, 
         0]]]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
    "\[InvisibleSpace]", 
    SqrtBox[
     InterpretationBox[
      TemplateBox[{"Root",TemplateBox[{"\"63.6\"", 
          DynamicBox[
           FEPrivate`FrontEndResource[
           "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
        TagBox[
         RowBox[{"Root", "[", 
           RowBox[{
             RowBox[{
               RowBox[{
                 RowBox[{"-", "14637417984"}], "+", 
                 RowBox[{"253570773456", " ", "#1"}], "-", 
                 RowBox[{"2259294716376", " ", 
                   SuperscriptBox["#1", "2"]}], "+", 
                 RowBox[{"14226627485565", " ", 
                   SuperscriptBox["#1", "3"]}], "-", 
                 RowBox[{"65960002546284", " ", 
                   SuperscriptBox["#1", "4"]}], "+", 
                 RowBox[{"216425700787620", " ", 
                   SuperscriptBox["#1", "5"]}], "-", 
                 RowBox[{"492062343977916", " ", 
                   SuperscriptBox["#1", "6"]}], "+", 
                 RowBox[{"782711166381062", " ", 
                   SuperscriptBox["#1", "7"]}], "-", 
                 RowBox[{"892396597211316", " ", 
                   SuperscriptBox["#1", "8"]}], "+", 
                 RowBox[{"732430210466916", " ", 
                   SuperscriptBox["#1", "9"]}], "-", 
                 RowBox[{"410390834384412", " ", 
                   SuperscriptBox["#1", "10"]}], "+", 
                 RowBox[{"139707882692901", " ", 
                   SuperscriptBox["#1", "11"]}], "-", 
                 RowBox[{"19474287964848", " ", 
                   SuperscriptBox["#1", "12"]}], "+", 
                 RowBox[{"220028016384", " ", 
                   SuperscriptBox["#1", "13"]}], "+", 
                 RowBox[{"833089536", " ", 
                   SuperscriptBox["#1", "14"]}]}], "&"}], ",", "6"}], "]"}], 
         Short[#, 7]& ],63.6430843409629},
       "NumericalApproximation"],
      Root[-14637417984 + 253570773456 # - 2259294716376 #^2 + 
       14226627485565 #^3 - 65960002546284 #^4 + 216425700787620 #^5 - 
       492062343977916 #^6 + 782711166381062 #^7 - 892396597211316 #^8 + 
       732430210466916 #^9 - 410390834384412 #^10 + 139707882692901 #^11 - 
       19474287964848 #^12 + 220028016384 #^13 + 833089536 #^14& , 6, 0]]]}], 
   "\[LessEqual]", 
   FractionBox[
    RowBox[{"d", "[", 
     RowBox[{"7", ",", "3"}], "]"}], 
    RowBox[{"d", "[", 
     RowBox[{"7", ",", "6"}], "]"}]]}],
  SequenceForm[7, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 
    Root[-14637417984 + 253570773456 # - 2259294716376 #^2 + 
      14226627485565 #^3 - 65960002546284 #^4 + 216425700787620 #^5 - 
      492062343977916 #^6 + 782711166381062 #^7 - 892396597211316 #^8 + 
      732430210466916 #^9 - 410390834384412 #^10 + 139707882692901 #^11 - 
      19474287964848 #^12 + 220028016384 #^13 + 833089536 #^14& , 6, 0], 
    DirectedInfinity[-1], 
    Root[-14637417984 + 253570773456 # - 2259294716376 #^2 + 
      14226627485565 #^3 - 65960002546284 #^4 + 216425700787620 #^5 - 
      492062343977916 #^6 + 782711166381062 #^7 - 892396597211316 #^8 + 
      732430210466916 #^9 - 410390834384412 #^10 + 139707882692901 #^11 - 
      19474287964848 #^12 + 220028016384 #^13 + 833089536 #^14& , 6, 0]^
    Rational[1, 2]}, "   ", 
   Root[-14637417984 + 253570773456 # - 2259294716376 #^2 + 
      14226627485565 #^3 - 65960002546284 #^4 + 216425700787620 #^5 - 
      492062343977916 #^6 + 782711166381062 #^7 - 892396597211316 #^8 + 
      732430210466916 #^9 - 410390834384412 #^10 + 139707882692901 #^11 - 
      19474287964848 #^12 + 220028016384 #^13 + 833089536 #^14& , 6, 0]^
    Rational[1, 2] <= $CellContext`d[7, 3]/$CellContext`d[7, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591745504045*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"935e461e-2cd6-44f6-a204-b833e4074453"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "8"}], "]"}]]}]}],
  SequenceForm[7, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[7, 3]/$CellContext`d[7, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917457619333`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"d3ab5ed2-a48a-432b-a051-9c11b74006ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "9"}], "]"}]]}]}],
  SequenceForm[7, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[7, 3]/$CellContext`d[7, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591746244762*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"2742917a-0264-4e86-8121-4fe922a24534"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "10"}], "]"}]]}]}],
  SequenceForm[7, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[7, 3]/$CellContext`d[7, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591746722219*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"fff16cab-786f-4109-9e5e-fcc19e70ee7a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "6"}], "]"}]]}]}],
  SequenceForm[7, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[7, 4]/$CellContext`d[7, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917490226*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"8c39d62c-866e-4b25-ba4b-141903ed7d4e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "8"}], "]"}]], "\[LessEqual]", 
    FractionBox["1", "3"]}]}],
  SequenceForm[7, ":  ", {9 $CellContext`k >= 1, 
    Rational[1, 3], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[7, 6]/$CellContext`d[7, 8] <= Rational[1, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917606643476`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"82540269-1d9e-4889-bfe3-60b7463e9c16"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "9"}], "]"}]], "\[LessEqual]", 
    FractionBox["1", "3"]}]}],
  SequenceForm[7, ":  ", {9 $CellContext`k >= 1, 
    Rational[1, 3], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[7, 6]/$CellContext`d[7, 9] <= Rational[1, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159176221577*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"78a65ea7-71d8-4c50-8cbb-2b0b4cef3449"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"81", " ", "k"}], "\[GreaterEqual]", "16"}], ",", 
     FractionBox["4", "9"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "10"}], "]"}]], "\[LessEqual]", 
    FractionBox["4", "9"]}]}],
  SequenceForm[7, ":  ", {81 $CellContext`k >= 16, 
    Rational[4, 9], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[7, 6]/$CellContext`d[7, 10] <= Rational[4, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159176430249*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"586ad4cb-fb62-4dc2-87d0-6d9332cb4c3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "8"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "9"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[7, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[7, 8]/$CellContext`d[7, 9] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591764635337*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"c57af016-a729-4e23-993a-14cc62394249"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "16"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["4", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "8"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "10"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[7, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 16, 
    DirectedInfinity[-1], 
    Rational[4, 3]}, "   ", 
   Rational[4, 3] <= $CellContext`d[7, 8]/$CellContext`d[7, 10] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591764968029*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"ac6dc55b-bbe4-40ff-a169-255446c8656a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "16"}], ",", 
     FractionBox["4", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "9"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"7", ",", "10"}], "]"}]], "\[LessEqual]", 
    FractionBox["4", "3"]}]}],
  SequenceForm[7, ":  ", {9 $CellContext`k >= 16, 
    Rational[4, 3], 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[7, 9]/$CellContext`d[7, 10] <= Rational[4, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591765384647*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"4d79ceb6-da31-4bd1-a052-ac881e3f3196"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[GreaterEqual]", "9"}], ",", 
     FractionBox["3", "2"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "9"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["3", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "2"}], "]"}]], "\[Equal]", 
    FractionBox["3", "2"]}]}],
  SequenceForm[8, ":  ", {4 $CellContext`k >= 9, 
    Rational[3, 2], 
    DirectedInfinity[1]}, {4 $CellContext`k <= 9, 
    DirectedInfinity[-1], 
    Rational[3, 2]}, "   ", $CellContext`d[8, 1]/$CellContext`d[8, 2] == 
   Rational[3, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159176547174*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"a59a6dee-65a5-479d-b8d8-71ba124fadc2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "4"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[8, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[8, 1]/$CellContext`d[8, 4] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591765815158*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"076241cf-9329-4629-b5b6-4811b797d05a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "16"}], ",", 
     FractionBox["4", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "5"}], "]"}]], "\[LessEqual]", 
    FractionBox["4", "3"]}]}],
  SequenceForm[8, ":  ", {9 $CellContext`k >= 16, 
    Rational[4, 3], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[8, 1]/$CellContext`d[8, 5] <= Rational[4, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591766036721*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"90d2a020-2fdb-4021-a8d2-0d98a5e4080c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"32", " ", 
        SqrtBox["2"]}], "+", 
       RowBox[{"49", " ", "k"}]}], "\[LessEqual]", "72"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["2", "7"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        SqrtBox["2"]}], ")"}]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["2", "7"]}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "4"}], "+", 
       SqrtBox["2"]}], ")"}]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "6"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[8, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {32 2^Rational[1, 2] + 49 $CellContext`k <= 72, 
    DirectedInfinity[-1], Rational[-2, 7] (-4 + 2^Rational[1, 2])}, "   ", 
   Rational[-2, 7] (-4 + 2^Rational[1, 2]) <= $CellContext`d[
     8, 1]/$CellContext`d[8, 6] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159176685493*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"253c3fb5-b565-47c3-bbe9-2283c91a7a31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "7"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[8, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[8, 1]/$CellContext`d[8, 7] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591767138569*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"60212665-5112-4544-b062-e91f0576882a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "9"}], "]"}]]}]}],
  SequenceForm[8, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[8, 1]/$CellContext`d[8, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591767426874*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"f3390c88-b34f-463c-b61b-85f5786a4fcf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "10"}], "]"}]], "\[Equal]", "2"}]}],
  SequenceForm[8, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, 
   "   ", $CellContext`d[8, 1]/$CellContext`d[8, 10] == 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591767519659*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"bb50f199-c775-4902-88ab-1965aecdcc3b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "4"}], ",", 
     FractionBox["2", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "4"}], "]"}]], "\[LessEqual]", 
    FractionBox["2", "3"]}]}],
  SequenceForm[8, ":  ", {9 $CellContext`k >= 4, 
    Rational[2, 3], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[8, 2]/$CellContext`d[8, 4] <= Rational[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591767882454*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"1283c426-67c6-4b9c-8cd5-d970f2819c0e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"81", " ", "k"}], "\[GreaterEqual]", "64"}], ",", 
     FractionBox["8", "9"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "5"}], "]"}]], "\[LessEqual]", 
    FractionBox["8", "9"]}]}],
  SequenceForm[8, ":  ", {81 $CellContext`k >= 64, 
    Rational[8, 9], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[8, 2]/$CellContext`d[8, 5] <= Rational[8, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591768111216*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"68a03a25-c7cd-4547-9505-bc4321f5e062"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "4"}], ",", 
     FractionBox["2", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", 
      RowBox[{
       FractionBox["32", "441"], " ", 
       RowBox[{"(", 
        RowBox[{"9", "-", 
         RowBox[{"4", " ", 
          SqrtBox["2"]}]}], ")"}]}]}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["4", "21"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        SqrtBox["2"]}], ")"}]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["4", "21"]}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "4"}], "+", 
       SqrtBox["2"]}], ")"}]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "6"}], "]"}]], "\[LessEqual]", 
    FractionBox["2", "3"]}]}],
  SequenceForm[8, ":  ", {9 $CellContext`k >= 4, 
    Rational[2, 3], 
    DirectedInfinity[1]}, {$CellContext`k <= 
    Rational[32, 441] (9 - 4 2^Rational[1, 2]), 
    DirectedInfinity[-1], Rational[-4, 21] (-4 + 2^Rational[1, 2])}, "   ", 
   Rational[-4, 21] (-4 + 2^Rational[1, 2]) <= $CellContext`d[
     8, 2]/$CellContext`d[8, 6] <= Rational[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591769029457*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"b26afe2c-949e-459f-8856-c418cd061af2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "4"}], ",", 
     FractionBox["2", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "7"}], "]"}]], "\[LessEqual]", 
    FractionBox["2", "3"]}]}],
  SequenceForm[8, ":  ", {9 $CellContext`k >= 4, 
    Rational[2, 3], 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[8, 2]/$CellContext`d[8, 7] <= 
   Rational[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591769291898*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"53e97b6c-be33-427e-842e-7b0e0d2a7d5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "16"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["4", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "9"}], "]"}]]}]}],
  SequenceForm[8, ":  ", {False, 0, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 16, 
    DirectedInfinity[-1], 
    Rational[4, 3]}, "   ", 
   Rational[4, 3] <= $CellContext`d[8, 2]/$CellContext`d[8, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591769577277*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"ede7eee5-6d4f-43ac-bffc-0d6467220380"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "16"}], ",", 
     FractionBox["4", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "16"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["4", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "10"}], "]"}]], "\[Equal]", 
    FractionBox["4", "3"]}]}],
  SequenceForm[8, ":  ", {9 $CellContext`k >= 16, 
    Rational[4, 3], 
    DirectedInfinity[1]}, {9 $CellContext`k <= 16, 
    DirectedInfinity[-1], 
    Rational[4, 3]}, "   ", $CellContext`d[8, 2]/$CellContext`d[8, 10] == 
   Rational[4, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917696693172`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"4376630c-f037-4adb-bc1e-7d807f55aadf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "2"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "4"}], "]"}]], "\[LessEqual]", 
    FractionBox["1", "2"]}]}],
  SequenceForm[8, ":  ", {4 $CellContext`k >= 1, 
    Rational[1, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[8, 3]/$CellContext`d[8, 4] <= Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591769778503*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"d35c11b4-cb10-447e-baa0-3dcb72df8a13"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "5"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[8, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[8, 3]/$CellContext`d[8, 5] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917699760313`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"eeaa1f24-f7a1-4c86-81b7-29745c57a4a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "16"}], ",", "4", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "16"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["4", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "5"}], "]"}]], "\[LessEqual]", "4"}]}],
  SequenceForm[8, ":  ", {$CellContext`k >= 16, 4, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 16, 
    DirectedInfinity[-1], 
    Rational[4, 3]}, "   ", 
   Rational[4, 3] <= $CellContext`d[8, 4]/$CellContext`d[8, 5] <= 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591771695825*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"714a4fd5-399e-472e-918d-684b9ebc366d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "6"}], "]"}]]}]}],
  SequenceForm[8, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[8, 4]/$CellContext`d[8, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591772607432*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"6a478cf5-566c-458c-9578-3015289ad9de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "7"}], "]"}]]}]}],
  SequenceForm[8, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[8, 4]/$CellContext`d[8, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591772853801*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"541d1d17-633e-4535-a6df-f73bf0206105"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "9"}], "]"}]]}]}],
  SequenceForm[8, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[8, 4]/$CellContext`d[8, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591773178048*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"e53d2db5-fcba-4e02-8186-717b5439952c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "10"}], "]"}]]}]}],
  SequenceForm[8, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[8, 4]/$CellContext`d[8, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591773338999*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"40dbbe52-3bb2-4420-b923-e8e779424465"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
    "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"k", "\[LessEqual]", 
       InterpretationBox[
        TemplateBox[{"Root",TemplateBox[{"\"0.465\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"],TagBox[
           RowBox[{"Root", "[", 
             RowBox[{
               RowBox[{
                 RowBox[{"14641", "-", 
                   RowBox[{"108956", " ", "#1"}], "+", 
                   RowBox[{"607664", " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"1322048", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   RowBox[{"802816", " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], 
           Short[#, 7]& ],0.4647202486785734},
         "NumericalApproximation"],
        Root[
        14641 - 108956 # + 607664 #^2 - 1322048 #^3 + 802816 #^4& , 1, 0]]}], 
      ",", 
      RowBox[{"-", "\[Infinity]"}], ",", 
      InterpretationBox[
       TemplateBox[{"Root",TemplateBox[{"\"0.682\"", 
           DynamicBox[
            FEPrivate`FrontEndResource[
            "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
         TagBox[
          RowBox[{"Root", "[", 
            RowBox[{
              RowBox[{
                RowBox[{"121", "-", 
                  RowBox[{"758", " ", "#1"}], "+", 
                  RowBox[{"1924", " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                  RowBox[{"2184", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                  RowBox[{"896", " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], 
          Short[#, 7]& ],0.6817039303675558},
        "NumericalApproximation"],
       Root[121 - 758 # + 1924 #^2 - 2184 #^3 + 896 #^4& , 1, 0]]}], "}"}], 
    "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
    InterpretationBox[
     TemplateBox[{"Root",TemplateBox[{"\"0.682\"", 
         DynamicBox[
          FEPrivate`FrontEndResource[
          "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
       TagBox[
        RowBox[{"Root", "[", 
          RowBox[{
            RowBox[{
              RowBox[{"121", "-", 
                RowBox[{"758", " ", "#1"}], "+", 
                RowBox[{"1924", " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"2184", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                RowBox[{"896", " ", 
                  SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], 
        Short[#, 7]& ],0.6817039303675558},
      "NumericalApproximation"],
     Root[121 - 758 # + 1924 #^2 - 2184 #^3 + 896 #^4& , 1, 0]]}], 
   "\[LessEqual]", 
   FractionBox[
    RowBox[{"d", "[", 
     RowBox[{"8", ",", "5"}], "]"}], 
    RowBox[{"d", "[", 
     RowBox[{"8", ",", "6"}], "]"}]]}],
  SequenceForm[8, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 
    Root[14641 - 108956 # + 607664 #^2 - 1322048 #^3 + 802816 #^4& , 1, 0], 
    DirectedInfinity[-1], 
    Root[121 - 758 # + 1924 #^2 - 2184 #^3 + 896 #^4& , 1, 0]}, "   ", 
   Root[121 - 758 # + 1924 #^2 - 2184 #^3 + 896 #^4& , 1, 
     0] <= $CellContext`d[8, 5]/$CellContext`d[8, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591775210341*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"67abce39-81ee-4890-a44c-450144bea6dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"64", " ", "k"}], "\[LessEqual]", 
      RowBox[{"17", "+", 
       RowBox[{"12", " ", 
        SqrtBox["2"]}]}]}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     RowBox[{
      FractionBox["1", "8"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"2", " ", 
         SqrtBox["2"]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox["1", "8"], " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]}], ")"}]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "7"}], "]"}]]}]}],
  SequenceForm[8, ":  ", {False, 0, 
    DirectedInfinity[1]}, {64 $CellContext`k <= 17 + 12 2^Rational[1, 2], 
    DirectedInfinity[-1], Rational[1, 8] (3 + 2 2^Rational[1, 2])}, "   ", 
   Rational[1, 8] (3 + 2 2^Rational[1, 2]) <= $CellContext`d[
     8, 5]/$CellContext`d[8, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591775685862*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"4c4d5317-0725-4ae2-be18-6d95d98d388e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "9"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["3", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["3", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "9"}], "]"}]]}]}],
  SequenceForm[8, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 9, 
    DirectedInfinity[-1], 
    Rational[3, 2]}, "   ", 
   Rational[3, 2] <= $CellContext`d[8, 5]/$CellContext`d[8, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591776180583*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"deb0f33e-ebc4-4f44-9c7b-cd0301482264"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "9"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["3", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["3", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "10"}], "]"}]]}]}],
  SequenceForm[8, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 9, 
    DirectedInfinity[-1], 
    Rational[3, 2]}, "   ", 
   Rational[3, 2] <= $CellContext`d[8, 5]/$CellContext`d[8, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159177640492*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"1a039b69-e353-4eb8-be11-a6471d358ecc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"36", " ", "k"}], "\[GreaterEqual]", "49"}], ",", 
     FractionBox["7", "6"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["2", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "7"}], "]"}]], "\[LessEqual]", 
    FractionBox["7", "6"]}]}],
  SequenceForm[8, ":  ", {36 $CellContext`k >= 49, 
    Rational[7, 6], 
    DirectedInfinity[1]}, {9 $CellContext`k <= 4, 
    DirectedInfinity[-1], 
    Rational[2, 3]}, "   ", 
   Rational[2, 3] <= $CellContext`d[8, 6]/$CellContext`d[8, 7] <= 
   Rational[7, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591777935062*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"43919338-69f6-45f1-9fc0-7bfd605e9dc8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "9"}], "]"}]]}]}],
  SequenceForm[8, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[8, 6]/$CellContext`d[8, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917795130663`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"cc2150d0-d495-4693-94c6-44cd8154d96d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "k"}], "\[GreaterEqual]", 
      RowBox[{"9", "+", 
       RowBox[{"4", " ", 
        SqrtBox["2"]}]}]}], ",", 
     RowBox[{"2", "+", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "10"}], "]"}]], "\[LessEqual]", 
    RowBox[{"2", "+", 
     FractionBox["1", 
      SqrtBox["2"]]}]}]}],
  SequenceForm[
  8, ":  ", {
   2 $CellContext`k >= 9 + 4 2^Rational[1, 2], 2 + 2^Rational[-1, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[8, 6]/$CellContext`d[8, 10] <= 2 + 2^Rational[-1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591780313759*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"02fdf615-b848-4e6c-87b2-d4e3183a5101"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "9"}], "]"}]]}]}],
  SequenceForm[8, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[8, 7]/$CellContext`d[8, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591780540901*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"db325903-5357-4b97-b782-062116ccf495"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "16"}], ",", "4", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "10"}], "]"}]], "\[LessEqual]", "4"}]}],
  SequenceForm[8, ":  ", {$CellContext`k >= 16, 4, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[8, 7]/$CellContext`d[8, 10] <= 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917808010283`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"a87fe0fe-1d07-4fd6-886a-6d3be332a18e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "9"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"8", ",", "10"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[8, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[8, 9]/$CellContext`d[8, 10] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591781097146*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"a6422f3c-5105-4ce7-a39c-e57758996160"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "9"}], ",", "3", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "9"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["3", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["3", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "2"}], "]"}]], "\[LessEqual]", "3"}]}],
  SequenceForm[9, ":  ", {$CellContext`k >= 9, 3, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 9, 
    DirectedInfinity[-1], 
    Rational[3, 2]}, "   ", 
   Rational[3, 2] <= $CellContext`d[9, 1]/$CellContext`d[9, 2] <= 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591781366535*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"ae8f9896-98b9-41df-913e-11b6fbe3286d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "4"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[9, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[9, 1]/$CellContext`d[9, 4] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917819332867`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"fdaf42d9-94b9-4415-84ed-e0f0d606329f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "5"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[9, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[9, 1]/$CellContext`d[9, 5] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591782247473*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"b09e46a2-0455-461e-bab2-d0c9153062ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["2", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "6"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[9, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 4, 
    DirectedInfinity[-1], 
    Rational[2, 3]}, "   ", 
   Rational[2, 3] <= $CellContext`d[9, 1]/$CellContext`d[9, 6] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917826270857`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"cfbcccee-ccf6-415d-a7aa-c6e5bd6a467c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "7"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[9, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[9, 1]/$CellContext`d[9, 7] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917829301853`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"ae643f2d-29ac-4a56-825a-67b14c1aa97a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "8"}], "]"}]]}]}],
  SequenceForm[9, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[9, 1]/$CellContext`d[9, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591783123281*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"c851d157-eb56-4c69-98d2-5f6931f6a366"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "10"}], "]"}]]}]}],
  SequenceForm[9, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[9, 1]/$CellContext`d[9, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591783333292*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"9ba91d02-736e-4265-bb28-3301fea865e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "4"}], "]"}]], "\[LessEqual]", 
    FractionBox["1", "3"]}]}],
  SequenceForm[9, ":  ", {9 $CellContext`k >= 1, 
    Rational[1, 3], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[9, 2]/$CellContext`d[9, 4] <= Rational[1, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917841860733`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"55332941-47b9-42c2-85e6-4430aa50ab32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "4"}], ",", 
     FractionBox["2", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "5"}], "]"}]], "\[LessEqual]", 
    FractionBox["2", "3"]}]}],
  SequenceForm[9, ":  ", {9 $CellContext`k >= 4, 
    Rational[2, 3], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[9, 2]/$CellContext`d[9, 5] <= Rational[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917847011547`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"5e26e83d-bdf9-4247-8263-1cac725be797"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "2"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"16", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "4"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "4"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "6"}], "]"}]], "\[LessEqual]", 
    FractionBox["1", "2"]}]}],
  SequenceForm[9, ":  ", {4 $CellContext`k >= 1, 
    Rational[1, 2], 
    DirectedInfinity[1]}, {16 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 4]}, "   ", 
   Rational[1, 4] <= $CellContext`d[9, 2]/$CellContext`d[9, 6] <= 
   Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591785738275*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"f0a50331-25fc-4ab6-96e2-dfa240f2522a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "7"}], "]"}]], "\[Equal]", 
    FractionBox["1", "3"]}]}],
  SequenceForm[9, ":  ", {9 $CellContext`k >= 1, 
    Rational[1, 3], 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", $CellContext`d[9, 2]/$CellContext`d[9, 7] == 
   Rational[1, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591785925868*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"904eac05-0ef6-448d-a266-6dcfb319cfbc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "8"}], "]"}]]}]}],
  SequenceForm[9, ":  ", {False, 0, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[9, 2]/$CellContext`d[9, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159178620233*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"d8f2d963-2b68-4c4f-b748-00a5fd006499"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "16"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["4", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "10"}], "]"}]]}]}],
  SequenceForm[9, ":  ", {False, 0, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 16, 
    DirectedInfinity[-1], 
    Rational[4, 3]}, "   ", 
   Rational[4, 3] <= $CellContext`d[9, 2]/$CellContext`d[9, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591786482832*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"0c77cbb4-f94e-4141-838c-9d34698c5e11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "2"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "4"}], "]"}]], "\[LessEqual]", 
    FractionBox["1", "2"]}]}],
  SequenceForm[9, ":  ", {4 $CellContext`k >= 1, 
    Rational[1, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[9, 3]/$CellContext`d[9, 4] <= Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917868069773`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"d726749e-c5d8-4fdf-beb1-f1647c6468c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "5"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[9, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[9, 3]/$CellContext`d[9, 5] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917871269817`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"d53def64-add0-4cf8-b50e-2877c9d8de18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "10"}], "]"}]]}]}],
  SequenceForm[9, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[9, 3]/$CellContext`d[9, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591788960065*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"06c7db1b-b7c5-438f-b4d5-9663cf0bdbe3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "16"}], ",", "4", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "5"}], "]"}]], "\[LessEqual]", "4"}]}],
  SequenceForm[9, ":  ", {$CellContext`k >= 16, 4, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[9, 4]/$CellContext`d[9, 5] <= 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591789447092*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"04b9ac74-edff-494f-9add-d0d05feb98e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "6"}], "]"}]]}]}],
  SequenceForm[9, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[9, 4]/$CellContext`d[9, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591790524489*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"eb87f9d1-577a-4e70-8f01-345cb33eb943"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "7"}], "]"}]]}]}],
  SequenceForm[9, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[9, 4]/$CellContext`d[9, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591791047141*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"2dbfa644-38f7-413b-a178-0ffaecd97105"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "8"}], "]"}]]}]}],
  SequenceForm[9, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[9, 4]/$CellContext`d[9, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591791515841*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"405ed658-d729-483e-852d-386ae29a5099"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "100"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "10"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"10", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "10"}], "]"}]]}]}],
  SequenceForm[9, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 100, 
    DirectedInfinity[-1], 10}, "   ", 
   10 <= $CellContext`d[9, 4]/$CellContext`d[9, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159179186108*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"0d86959e-09cc-4c95-964b-d9a9fdffcc17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
    "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"k", "\[LessEqual]", 
       InterpretationBox[
        TemplateBox[{"Root",TemplateBox[{"\"0.237\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"],TagBox[
           RowBox[{"Root", "[", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   RowBox[{"-", "37662769"}], "+", 
                   RowBox[{"142972508", " ", "#1"}], "+", 
                   RowBox[{"8028640", " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                   RowBox[{"318484352", " ", 
                    SuperscriptBox["#1", "3"]}], "-", 
                   RowBox[{"302194240", " ", 
                    SuperscriptBox["#1", "4"]}], "+", 
                   RowBox[{"9437184", " ", 
                    SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}], 
           Short[#, 7]& ],0.23718423648248518`},
         "NumericalApproximation"],
        Root[-37662769 + 142972508 # + 8028640 #^2 + 318484352 #^3 - 
         302194240 #^4 + 9437184 #^5& , 1, 0]]}], ",", 
      RowBox[{"-", "\[Infinity]"}], ",", 
      InterpretationBox[
       TemplateBox[{"Root",TemplateBox[{"\"0.487\"", 
           DynamicBox[
            FEPrivate`FrontEndResource[
            "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
         TagBox[
          RowBox[{"Root", "[", 
            RowBox[{
              RowBox[{
                RowBox[{"6137", "-", 
                  RowBox[{"25350", " ", "#1"}], "+", 
                  RowBox[{"40708", " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                  RowBox[{"35096", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                  RowBox[{"9304", " ", 
                    SuperscriptBox["#1", "4"]}], "+", 
                  RowBox[{"3072", " ", 
                    SuperscriptBox["#1", "5"]}]}], "&"}], ",", "2"}], "]"}], 
          Short[#, 7]& ],0.4870156429546028},
        "NumericalApproximation"],
       Root[
       6137 - 25350 # + 40708 #^2 - 35096 #^3 + 9304 #^4 + 3072 #^5& , 2, 
        0]]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
    InterpretationBox[
     TemplateBox[{"Root",TemplateBox[{"\"0.487\"", 
         DynamicBox[
          FEPrivate`FrontEndResource[
          "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
       TagBox[
        RowBox[{"Root", "[", 
          RowBox[{
            RowBox[{
              RowBox[{"6137", "-", 
                RowBox[{"25350", " ", "#1"}], "+", 
                RowBox[{"40708", " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"35096", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                RowBox[{"9304", " ", 
                  SuperscriptBox["#1", "4"]}], "+", 
                RowBox[{"3072", " ", 
                  SuperscriptBox["#1", "5"]}]}], "&"}], ",", "2"}], "]"}], 
        Short[#, 7]& ],0.4870156429546028},
      "NumericalApproximation"],
     Root[
     6137 - 25350 # + 40708 #^2 - 35096 #^3 + 9304 #^4 + 3072 #^5& , 2, 0]]}],
    "\[LessEqual]", 
   FractionBox[
    RowBox[{"d", "[", 
     RowBox[{"9", ",", "5"}], "]"}], 
    RowBox[{"d", "[", 
     RowBox[{"9", ",", "6"}], "]"}]]}],
  SequenceForm[9, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 
    Root[-37662769 + 142972508 # + 8028640 #^2 + 318484352 #^3 - 
      302194240 #^4 + 9437184 #^5& , 1, 0], 
    DirectedInfinity[-1], 
    Root[6137 - 25350 # + 40708 #^2 - 35096 #^3 + 9304 #^4 + 3072 #^5& , 2, 
     0]}, "   ", 
   Root[6137 - 25350 # + 40708 #^2 - 35096 #^3 + 9304 #^4 + 3072 #^5& , 2, 
     0] <= $CellContext`d[9, 5]/$CellContext`d[9, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917931995087`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"691b126c-cc8f-45e6-a3fc-c3bfb40faa6c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "7"}], "]"}]]}]}],
  SequenceForm[9, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[9, 5]/$CellContext`d[9, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591793723938*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"1a7592c8-23ad-43de-8717-922ef6302220"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "8"}], "]"}]]}]}],
  SequenceForm[9, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[9, 5]/$CellContext`d[9, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591794215355*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"1409acaf-a65b-489c-a533-7fcdff0c4035"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", 
      RowBox[{
       FractionBox["33", "4"], "+", 
       RowBox[{"5", " ", 
        SqrtBox["2"]}]}]}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     RowBox[{
      FractionBox["5", "2"], "+", 
      SqrtBox["2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox["5", "2"], "+", 
     SqrtBox["2"]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "10"}], "]"}]]}]}],
  SequenceForm[9, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 
    Rational[33, 4] + 5 2^Rational[1, 2], 
    DirectedInfinity[-1], Rational[5, 2] + 2^Rational[1, 2]}, "   ", 
   Rational[5, 2] + 2^Rational[1, 2] <= $CellContext`d[9, 5]/$CellContext`d[
    9, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591794663765*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"3ea8ee6a-a91d-4085-87c9-602d863cdd2a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "16"}], ",", 
     FractionBox["4", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["2", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "7"}], "]"}]], "\[LessEqual]", 
    FractionBox["4", "3"]}]}],
  SequenceForm[9, ":  ", {9 $CellContext`k >= 16, 
    Rational[4, 3], 
    DirectedInfinity[1]}, {9 $CellContext`k <= 4, 
    DirectedInfinity[-1], 
    Rational[2, 3]}, "   ", 
   Rational[2, 3] <= $CellContext`d[9, 6]/$CellContext`d[9, 7] <= 
   Rational[4, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591795677433*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"3b491141-e125-46af-b6ae-3db17058dd29"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "8"}], "]"}]]}]}],
  SequenceForm[9, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[9, 6]/$CellContext`d[9, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591796615144*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"29a86f6d-994f-4537-8a6d-abac491d1bdf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "64"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["8", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["8", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "10"}], "]"}]]}]}],
  SequenceForm[9, ":  ", {False, 0, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 64, 
    DirectedInfinity[-1], 
    Rational[8, 3]}, "   ", 
   Rational[8, 3] <= $CellContext`d[9, 6]/$CellContext`d[9, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591797202363*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"77f5b8f7-2dd2-4422-be75-bc865db944cf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "8"}], "]"}]]}]}],
  SequenceForm[9, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[9, 7]/$CellContext`d[9, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917975029793`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"af3dc165-9fdf-4617-8bc2-ba9c39f22432"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "16"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"4", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"9", ",", "10"}], "]"}]]}]}],
  SequenceForm[9, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 16, 
    DirectedInfinity[-1], 4}, "   ", 
   4 <= $CellContext`d[9, 7]/$CellContext`d[9, 10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917978114147`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"e69ab432-dfd4-4f0b-ad5c-65884478946a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "9"}], ",", "3", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "9"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "2"}], "]"}]], "\[Equal]", "3"}]}],
  SequenceForm[10, ":  ", {$CellContext`k >= 9, 3, 
    DirectedInfinity[1]}, {$CellContext`k <= 9, 
    DirectedInfinity[-1], 3}, 
   "   ", $CellContext`d[10, 1]/$CellContext`d[10, 2] == 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591798141097*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"6af83043-8a40-47c8-a556-06924fc7cc84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "4"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[10, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[10, 1]/$CellContext`d[10, 4] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591798507904*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"56738bb0-1ff6-496e-a190-11775de31834"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "5"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[10, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[10, 1]/$CellContext`d[10, 5] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591798653438*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"5bce5b70-e050-4ae7-913f-fd10112df99f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"4", " ", 
        SqrtBox["2"]}], "+", "k"}], "\[LessEqual]", "6"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     RowBox[{"2", "-", 
      SqrtBox["2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", "-", 
     SqrtBox["2"]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "6"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[10, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {4 2^Rational[1, 2] + $CellContext`k <= 6, 
    DirectedInfinity[-1], 2 - 2^Rational[1, 2]}, "   ", 
   2 - 2^Rational[1, 2] <= $CellContext`d[10, 1]/$CellContext`d[10, 6] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591799402347*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"ff7de196-c9d8-41b3-9407-e11ca0ea96b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "7"}], "]"}]], "\[LessEqual]", "1"}]}],
  SequenceForm[10, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[10, 1]/$CellContext`d[10, 7] <= 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515917997537518`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"32fcd5ba-a32b-41f6-95d7-edeb0bbd3a03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "1"}], ",", "1", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "8"}], "]"}]], "\[Equal]", "1"}]}],
  SequenceForm[10, ":  ", {$CellContext`k >= 1, 1, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, 
   "   ", $CellContext`d[10, 1]/$CellContext`d[10, 8] == 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591799846477*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"8da9b6bb-8af4-4f90-8bb0-8aaaf55e16bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "1"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "9"}], "]"}]]}]}],
  SequenceForm[10, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[10, 1]/$CellContext`d[10, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515918000829277`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"71c2ebce-6c52-4efe-96a0-be95b9ff133a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "4"}], "]"}]], "\[LessEqual]", 
    FractionBox["1", "3"]}]}],
  SequenceForm[10, ":  ", {9 $CellContext`k >= 1, 
    Rational[1, 3], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[10, 2]/$CellContext`d[10, 4] <= Rational[1, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159180046038*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"4670874d-cca8-4c1d-be30-b62e80f9b423"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "4"}], ",", 
     FractionBox["2", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "5"}], "]"}]], "\[LessEqual]", 
    FractionBox["2", "3"]}]}],
  SequenceForm[10, ":  ", {9 $CellContext`k >= 4, 
    Rational[2, 3], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[10, 2]/$CellContext`d[10, 5] <= Rational[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591800604268*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"390ea5af-3056-4e64-9007-67a6e8c7d39a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"4", " ", 
        SqrtBox["2"]}], "+", 
       RowBox[{"9", " ", "k"}]}], "\[LessEqual]", "6"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"2", "-", 
        SqrtBox["2"]}], ")"}]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"2", "-", 
       SqrtBox["2"]}], ")"}]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "6"}], "]"}]], "\[LessEqual]", 
    FractionBox["1", "3"]}]}],
  SequenceForm[10, ":  ", {9 $CellContext`k >= 1, 
    Rational[1, 3], 
    DirectedInfinity[1]}, {4 2^Rational[1, 2] + 9 $CellContext`k <= 6, 
    DirectedInfinity[-1], Rational[1, 3] (2 - 2^Rational[1, 2])}, "   ", 
   Rational[1, 3] (2 - 2^Rational[1, 2]) <= $CellContext`d[
     10, 2]/$CellContext`d[10, 6] <= Rational[1, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591801379713*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"55264266-62b7-45f3-88c6-60b6f0acdee7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"81", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "9"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "9"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "7"}], "]"}]], "\[LessEqual]", 
    FractionBox["1", "3"]}]}],
  SequenceForm[10, ":  ", {9 $CellContext`k >= 1, 
    Rational[1, 3], 
    DirectedInfinity[1]}, {81 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 9]}, "   ", 
   Rational[1, 9] <= $CellContext`d[10, 2]/$CellContext`d[10, 7] <= 
   Rational[1, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515918017300253`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"9bf0423f-d49f-4b49-834b-7125d0c350d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "8"}], "]"}]], "\[Equal]", 
    FractionBox["1", "3"]}]}],
  SequenceForm[10, ":  ", {9 $CellContext`k >= 1, 
    Rational[1, 3], 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", $CellContext`d[10, 2]/$CellContext`d[10, 8] == 
   Rational[1, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591801823463*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"e86a7364-aabe-41e0-adf4-3346c9f93954"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "2"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "9"}], "]"}]]}]}],
  SequenceForm[10, ":  ", {False, 0, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 3]}, "   ", 
   Rational[1, 3] <= $CellContext`d[10, 2]/$CellContext`d[10, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591802059002*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"c9e7cf45-f477-431d-b557-de602e0d2324"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[GreaterEqual]", "1"}], ",", 
     FractionBox["1", "2"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "4"}], "]"}]], "\[LessEqual]", 
    FractionBox["1", "2"]}]}],
  SequenceForm[10, ":  ", {4 $CellContext`k >= 1, 
    Rational[1, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[10, 3]/$CellContext`d[10, 4] <= Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515918022812967`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"6d0dfb1c-f3b2-4d4f-af64-09937009bad6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "4"}], ",", "2", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "0"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "5"}], "]"}]], "\[LessEqual]", "2"}]}],
  SequenceForm[10, ":  ", {$CellContext`k >= 4, 2, 
    DirectedInfinity[1]}, {$CellContext`k <= 0, 
    DirectedInfinity[-1], 0}, 
   "   ", $CellContext`d[10, 3]/$CellContext`d[10, 5] <= 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515918024363947`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"2d12c270-97f5-4b8a-a2b2-f8922a44a291"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "3"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "9"}], "]"}]]}]}],
  SequenceForm[10, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[10, 3]/$CellContext`d[10, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515918043290243`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"67ea9e11-609b-43a5-b322-62482638de68"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "16"}], ",", "4", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "4"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "5"}], "]"}]], "\[LessEqual]", "4"}]}],
  SequenceForm[10, ":  ", {$CellContext`k >= 16, 4, 
    DirectedInfinity[1]}, {$CellContext`k <= 4, 
    DirectedInfinity[-1], 2}, "   ", 
   2 <= $CellContext`d[10, 4]/$CellContext`d[10, 5] <= 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591804522801*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"6c87dec6-eeb5-4f55-8bc0-6c15a819ba21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "6"}], "]"}]]}]}],
  SequenceForm[10, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[10, 4]/$CellContext`d[10, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515918054383373`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"848e7f7d-43a7-4f9b-8339-0b6325771962"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "7"}], "]"}]]}]}],
  SequenceForm[10, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[10, 4]/$CellContext`d[10, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591805955559*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"53b1cc9c-1e63-49be-8d56-78c7ecb6c0bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "8"}], "]"}]]}]}],
  SequenceForm[10, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[10, 4]/$CellContext`d[10, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515918061568193`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"28d2f05c-11fd-48fc-b5d4-a18cbb814ff2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "81"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "9"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"9", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "4"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "9"}], "]"}]]}]}],
  SequenceForm[10, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 81, 
    DirectedInfinity[-1], 9}, "   ", 
   9 <= $CellContext`d[10, 4]/$CellContext`d[10, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591806473606*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"4f728767-e4c4-495d-9c70-26bffa4b8a24"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
    "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"k", "\[LessEqual]", 
       InterpretationBox[
        TemplateBox[{"Root",TemplateBox[{"\"0.208\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"],TagBox[
           RowBox[{"Root", "[", 
             RowBox[{
               RowBox[{
                 RowBox[{"1", "+", 
                   RowBox[{"40", " ", "#1"}], "+", 
                   RowBox[{"296", " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"2984", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   RowBox[{"2500", " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], 
           Short[#, 7]& ],0.20764755489493278`},
         "NumericalApproximation"],
        Root[1 + 40 # + 296 #^2 - 2984 #^3 + 2500 #^4& , 1, 0]]}], ",", 
      RowBox[{"-", "\[Infinity]"}], ",", 
      InterpretationBox[
       TemplateBox[{"Root",TemplateBox[{"\"0.456\"", 
           DynamicBox[
            FEPrivate`FrontEndResource[
            "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
         TagBox[
          RowBox[{"Root", "[", 
            RowBox[{
              RowBox[{
                RowBox[{"1", "-", 
                  RowBox[{"2", " ", "#1"}], "+", 
                  RowBox[{"22", " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                  RowBox[{"72", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                  RowBox[{"50", " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], 
          Short[#, 7]& ],0.4556836127127382},
        "NumericalApproximation"],
       Root[1 - 2 # + 22 #^2 - 72 #^3 + 50 #^4& , 1, 0]]}], "}"}], 
    "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
    InterpretationBox[
     TemplateBox[{"Root",TemplateBox[{"\"0.456\"", 
         DynamicBox[
          FEPrivate`FrontEndResource[
          "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
       TagBox[
        RowBox[{"Root", "[", 
          RowBox[{
            RowBox[{
              RowBox[{"1", "-", 
                RowBox[{"2", " ", "#1"}], "+", 
                RowBox[{"22", " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"72", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                RowBox[{"50", " ", 
                  SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], 
        Short[#, 7]& ],0.4556836127127382},
      "NumericalApproximation"],
     Root[1 - 2 # + 22 #^2 - 72 #^3 + 50 #^4& , 1, 0]]}], "\[LessEqual]", 
   FractionBox[
    RowBox[{"d", "[", 
     RowBox[{"10", ",", "5"}], "]"}], 
    RowBox[{"d", "[", 
     RowBox[{"10", ",", "6"}], "]"}]]}],
  SequenceForm[10, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 
    Root[1 + 40 # + 296 #^2 - 2984 #^3 + 2500 #^4& , 1, 0], 
    DirectedInfinity[-1], 
    Root[1 - 2 # + 22 #^2 - 72 #^3 + 50 #^4& , 1, 0]}, "   ", 
   Root[1 - 2 # + 22 #^2 - 72 #^3 + 50 #^4& , 1, 0] <= $CellContext`d[
     10, 5]/$CellContext`d[10, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591807474448*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"4d33bd7a-c3c0-4bec-912c-d0eccbfdd8f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "7"}], "]"}]]}]}],
  SequenceForm[10, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[10, 5]/$CellContext`d[10, 7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591807923546*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"4ca762bd-76a9-4ea0-80d6-00cd96ac2d34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "k"}], "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["1", "2"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "8"}], "]"}]]}]}],
  SequenceForm[10, ":  ", {False, 0, 
    DirectedInfinity[1]}, {4 $CellContext`k <= 1, 
    DirectedInfinity[-1], 
    Rational[1, 2]}, "   ", 
   Rational[1, 2] <= $CellContext`d[10, 5]/$CellContext`d[10, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515918080755653`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"14d7cc58-0924-46d8-9d31-0fd40765fa2e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", 
      RowBox[{
       FractionBox["17", "4"], "+", 
       RowBox[{"3", " ", 
        SqrtBox["2"]}]}]}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     RowBox[{
      FractionBox["3", "2"], "+", 
      SqrtBox["2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     FractionBox["3", "2"], "+", 
     SqrtBox["2"]}], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "5"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "9"}], "]"}]]}]}],
  SequenceForm[10, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 
    Rational[17, 4] + 3 2^Rational[1, 2], 
    DirectedInfinity[-1], Rational[3, 2] + 2^Rational[1, 2]}, "   ", 
   Rational[3, 2] + 2^Rational[1, 2] <= $CellContext`d[10, 5]/$CellContext`d[
    10, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591808379043*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"aeba8250-b64f-4745-8b96-0133411cf68b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[GreaterEqual]", "16"}], ",", 
     FractionBox["4", "3"], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"81", " ", "k"}], "\[LessEqual]", "25"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["5", "9"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["5", "9"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "7"}], "]"}]], "\[LessEqual]", 
    FractionBox["4", "3"]}]}],
  SequenceForm[10, ":  ", {9 $CellContext`k >= 16, 
    Rational[4, 3], 
    DirectedInfinity[1]}, {81 $CellContext`k <= 25, 
    DirectedInfinity[-1], 
    Rational[5, 9]}, "   ", 
   Rational[5, 9] <= $CellContext`d[10, 6]/$CellContext`d[10, 7] <= 
   Rational[4, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.8515918103832493`*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"280d39b6-6b9b-4f8d-a073-837b6a9ecf39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", 
      RowBox[{
       FractionBox["3", "2"], "+", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"1", "+", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", "\[Infinity]"}], "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "8"}], "]"}]], "\[LessEqual]", 
    RowBox[{"1", "+", 
     FractionBox["1", 
      SqrtBox["2"]]}]}]}],
  SequenceForm[
  10, ":  ", {$CellContext`k >= Rational[3, 2] + 2^Rational[1, 2], 1 + 
    2^Rational[-1, 2], 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[10, 6]/$CellContext`d[10, 8] <= 1 + 2^Rational[-1, 2]],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591811137185*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"e84c3da2-1485-4937-a9e8-df99f4080bbc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", "k"}], "\[LessEqual]", "25"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", 
     FractionBox["5", "3"]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["5", "3"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "6"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "9"}], "]"}]]}]}],
  SequenceForm[10, ":  ", {False, 0, 
    DirectedInfinity[1]}, {9 $CellContext`k <= 25, 
    DirectedInfinity[-1], 
    Rational[5, 3]}, "   ", 
   Rational[5, 3] <= $CellContext`d[10, 6]/$CellContext`d[10, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591812338749*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"2045703d-c00c-422a-9800-63c6f25f3e7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "9"}], ",", "3", ",", "\[Infinity]"}], 
    "}"}], "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "8"}], "]"}]], "\[LessEqual]", "3"}]}],
  SequenceForm[10, ":  ", {$CellContext`k >= 9, 3, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[10, 7]/$CellContext`d[10, 8] <= 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591812686062*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"54efad8f-be66-4278-97b7-52862727511e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "9"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"3", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "7"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "9"}], "]"}]]}]}],
  SequenceForm[10, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 9, 
    DirectedInfinity[-1], 3}, "   ", 
   3 <= $CellContext`d[10, 7]/$CellContext`d[10, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.85159181298425*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"963af264-9530-4dc7-a1b1-542d78da38b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\":  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "0", ",", "\[Infinity]"}], "}"}], 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[LessEqual]", "1"}], ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "\[LessEqual]", 
    FractionBox[
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "8"}], "]"}], 
     RowBox[{"d", "[", 
      RowBox[{"10", ",", "9"}], "]"}]]}]}],
  SequenceForm[10, ":  ", {False, 0, 
    DirectedInfinity[1]}, {$CellContext`k <= 1, 
    DirectedInfinity[-1], 1}, "   ", 
   1 <= $CellContext`d[10, 8]/$CellContext`d[10, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.851591183500601*^9, 3.851591813224125*^9},
 CellLabel->
  "During evaluation of \
In[1106]:=",ExpressionUUID->"bccd7c52-7c66-4ab6-b7df-7c0db6b714e5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ineq2", ",", "lo2", ",", "hi2"}], "}"}], "=", 
  RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
   RowBox[{
    RowBox[{"distance", "[", 
     RowBox[{"3", ",", "6"}], "]"}], ">=", 
    RowBox[{"k", " ", 
     RowBox[{"distance", "[", 
      RowBox[{"3", ",", "7"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{3.851598883819542*^9},
 CellLabel->
  "In[1140]:=",ExpressionUUID->"9f6090b0-7c00-427c-8074-7d2b9ee85844"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"k", "\[LessEqual]", 
    InterpretationBox[
     TemplateBox[{"Root",TemplateBox[{"\"0.810\"", 
         DynamicBox[
          FEPrivate`FrontEndResource[
          "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
       TagBox[
        RowBox[{"Root", "[", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{"-", "10000"}], "+", 
                RowBox[{"11765804", " ", "#1"}], "+", 
                RowBox[{"12633875", " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"26886473", " ", 
                  SuperscriptBox["#1", "3"]}], "-", 
                RowBox[{"38665175", " ", 
                  SuperscriptBox["#1", "4"]}], "+", 
                RowBox[{"37662769", " ", 
                  SuperscriptBox["#1", "5"]}]}], "&"}], ",", "2"}], "]"}], 
        Short[#, 7]& ],0.8104087108834643},
      "NumericalApproximation"],
     Root[-10000 + 11765804 # + 12633875 #^2 - 26886473 #^3 - 38665175 #^4 + 
      37662769 #^5& , 2, 0]]}], ",", 
   RowBox[{"-", "\[Infinity]"}], ",", 
   InterpretationBox[
    TemplateBox[{"Root",TemplateBox[{"\"0.810\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{
               RowBox[{"-", "10000"}], "+", 
               RowBox[{"11765804", " ", "#1"}], "+", 
               RowBox[{"12633875", " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
               RowBox[{"26886473", " ", 
                 SuperscriptBox["#1", "3"]}], "-", 
               RowBox[{"38665175", " ", 
                 SuperscriptBox["#1", "4"]}], "+", 
               RowBox[{"37662769", " ", 
                 SuperscriptBox["#1", "5"]}]}], "&"}], ",", "2"}], "]"}], 
       Short[#, 7]& ],0.8104087108834643},
     "NumericalApproximation"],
    Root[-10000 + 11765804 # + 12633875 #^2 - 26886473 #^3 - 38665175 #^4 + 
     37662769 #^5& , 2, 0]]}], "}"}]], "Output",
 CellChangeTimes->{3.851598886840193*^9},
 CellLabel->
  "Out[1140]=",ExpressionUUID->"0693d4a4-201d-4453-ab14-8a527a4a5abb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"hi", "=", 
  RowBox[{
   RowBox[{"Sqrt", "[", "hi2", "]"}], "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.851598904379655*^9, 3.851598912211882*^9}},
 CellLabel->
  "In[1141]:=",ExpressionUUID->"1be46a77-2e6e-4e33-9247-0ff38235e73a"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{"Root",TemplateBox[{"\"0.900\"", 
      DynamicBox[
       FEPrivate`FrontEndResource[
       "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
    TagBox[
     RowBox[{"Root", "[", 
       RowBox[{
         RowBox[{
           RowBox[{
             RowBox[{"-", "100"}], "+", 
             RowBox[{"3698", " ", "#1"}], "-", 
             RowBox[{"9547", " ", 
               SuperscriptBox["#1", "2"]}], "+", 
             RowBox[{"14429", " ", 
               SuperscriptBox["#1", "3"]}], "-", 
             RowBox[{"14689", " ", 
               SuperscriptBox["#1", "4"]}], "+", 
             RowBox[{"6137", " ", 
               SuperscriptBox["#1", "5"]}]}], "&"}], ",", "2"}], "]"}], 
     Short[#, 7]& ],0.900227032966387},
   "NumericalApproximation"],
  Root[-100 + 3698 # - 9547 #^2 + 14429 #^3 - 14689 #^4 + 6137 #^5& , 2, 
   0]]], "Output",
 CellChangeTimes->{3.8515989134631977`*^9},
 CellLabel->
  "Out[1141]=",ExpressionUUID->"9f8fada5-1b54-40d3-a3c1-cf2315c9fd0c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"displayRealNumber", "[", "hi", "]"}]], "Input",
 CellChangeTimes->{{3.851598926027822*^9, 3.851598926355389*^9}},
 CellLabel->
  "In[1142]:=",ExpressionUUID->"432c13e9-7dec-45fb-9c0b-d8031caebb08"],

Cell[BoxData["\<\"k\[TildeTilde]0.9002270330 is a root of \
\\!\\(\\*RowBox[{RowBox[{\\\"-\\\", \\\"100\\\"}], \\\"+\\\", \
RowBox[{\\\"3698\\\", \\\" \\\", \\\"x\\\"}], \\\"-\\\", \
RowBox[{\\\"9547\\\", \\\" \\\", SuperscriptBox[\\\"x\\\", \\\"2\\\"]}], \
\\\"+\\\", RowBox[{\\\"14429\\\", \\\" \\\", SuperscriptBox[\\\"x\\\", \
\\\"3\\\"]}], \\\"-\\\", RowBox[{\\\"14689\\\", \\\" \\\", \
SuperscriptBox[\\\"x\\\", \\\"4\\\"]}], \\\"+\\\", RowBox[{\\\"6137\\\", \\\" \
\\\", SuperscriptBox[\\\"x\\\", \\\"5\\\"]}]}]\\)\"\>"], "Output",
 CellChangeTimes->{3.85159892741152*^9},
 CellLabel->
  "Out[1142]=",ExpressionUUID->"6029777d-0805-4c4c-82a8-ad752bc51826"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "100"}], "+", 
    RowBox[{"3698", " ", "x"}], "-", 
    RowBox[{"9547", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"14429", " ", 
     SuperscriptBox["x", "3"]}], "-", 
    RowBox[{"14689", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"6137", " ", 
     SuperscriptBox["x", "5"]}]}], "\[Equal]", "0"}], "]"}]], "Input",
 CellChangeTimes->{{3.851601701536714*^9, 3.851601717705649*^9}},
 CellLabel->
  "In[1170]:=",ExpressionUUID->"8f243d0d-25c4-47fa-bc93-2d1299329aff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.02914014101944695`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.18164822678695247`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.7288716961365549`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.18164822678695247`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.7288716961365549`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.9002270329663866`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.1008511190591301`"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{{3.851601710113625*^9, 3.851601718799034*^9}},
 CellLabel->
  "Out[1170]=",ExpressionUUID->"b6a31f78-eda4-47aa-9b74-a6957cc37677"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ineq2", ",", "lo2", ",", "hi2"}], "}"}], "=", 
  RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
   RowBox[{
    RowBox[{"distance", "[", 
     RowBox[{"3", ",", "6"}], "]"}], "<=", 
    RowBox[{"k", " ", 
     RowBox[{"distance", "[", 
      RowBox[{"3", ",", "7"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851598610234707*^9, 3.851598612554256*^9}},
 CellLabel->
  "In[1135]:=",ExpressionUUID->"5f5e5b68-4802-4f9e-b1c3-95e793723e60"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"k", "\[GreaterEqual]", 
    InterpretationBox[
     TemplateBox[{"Root",TemplateBox[{"\"1.21\"", 
         DynamicBox[
          FEPrivate`FrontEndResource[
          "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
       TagBox[
        RowBox[{"Root", "[", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{"-", "10000"}], "+", 
                RowBox[{"11765804", " ", "#1"}], "+", 
                RowBox[{"12633875", " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"26886473", " ", 
                  SuperscriptBox["#1", "3"]}], "-", 
                RowBox[{"38665175", " ", 
                  SuperscriptBox["#1", "4"]}], "+", 
                RowBox[{"37662769", " ", 
                  SuperscriptBox["#1", "5"]}]}], "&"}], ",", "3"}], "]"}], 
        Short[#, 7]& ],1.2118731863337395`},
      "NumericalApproximation"],
     Root[-10000 + 11765804 # + 12633875 #^2 - 26886473 #^3 - 38665175 #^4 + 
      37662769 #^5& , 3, 0]]}], ",", 
   InterpretationBox[
    TemplateBox[{"Root",TemplateBox[{"\"1.21\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{
               RowBox[{"-", "10000"}], "+", 
               RowBox[{"11765804", " ", "#1"}], "+", 
               RowBox[{"12633875", " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
               RowBox[{"26886473", " ", 
                 SuperscriptBox["#1", "3"]}], "-", 
               RowBox[{"38665175", " ", 
                 SuperscriptBox["#1", "4"]}], "+", 
               RowBox[{"37662769", " ", 
                 SuperscriptBox["#1", "5"]}]}], "&"}], ",", "3"}], "]"}], 
       Short[#, 7]& ],1.2118731863337395`},
     "NumericalApproximation"],
    Root[-10000 + 11765804 # + 12633875 #^2 - 26886473 #^3 - 38665175 #^4 + 
     37662769 #^5& , 3, 0]], ",", "\[Infinity]"}], "}"}]], "Output",
 CellChangeTimes->{3.851598614270795*^9},
 CellLabel->
  "Out[1135]=",ExpressionUUID->"1f0d4abb-65ff-4b75-be58-d6fd70328b70"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lo", "=", 
  RowBox[{
   RowBox[{"Sqrt", "[", "lo2", "]"}], "//", "FullSimplify"}]}]], "Input",
 CellLabel->
  "In[1136]:=",ExpressionUUID->"a3720173-1b83-4e31-aa5a-d9c83117d135"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{"Root",TemplateBox[{"\"1.10\"", 
      DynamicBox[
       FEPrivate`FrontEndResource[
       "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
    TagBox[
     RowBox[{"Root", "[", 
       RowBox[{
         RowBox[{
           RowBox[{
             RowBox[{"-", "100"}], "+", 
             RowBox[{"3698", " ", "#1"}], "-", 
             RowBox[{"9547", " ", 
               SuperscriptBox["#1", "2"]}], "+", 
             RowBox[{"14429", " ", 
               SuperscriptBox["#1", "3"]}], "-", 
             RowBox[{"14689", " ", 
               SuperscriptBox["#1", "4"]}], "+", 
             RowBox[{"6137", " ", 
               SuperscriptBox["#1", "5"]}]}], "&"}], ",", "3"}], "]"}], 
     Short[#, 7]& ],1.1008511190591304`},
   "NumericalApproximation"],
  Root[-100 + 3698 # - 9547 #^2 + 14429 #^3 - 14689 #^4 + 6137 #^5& , 3, 
   0]]], "Output",
 CellChangeTimes->{3.851598632975132*^9},
 CellLabel->
  "Out[1136]=",ExpressionUUID->"651af737-c2f3-4917-a7d3-d3eb4191d457"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"displayRealNumber", "[", "lo", "]"}]], "Input",
 CellLabel->
  "In[1138]:=",ExpressionUUID->"960b6403-4ad6-47a9-a8c2-8e3e575349ba"],

Cell[BoxData["\<\"k\[TildeTilde]1.100851119 is the largest positive root of \
\\!\\(\\*RowBox[{RowBox[{\\\"-\\\", \\\"100\\\"}], \\\"+\\\", \
RowBox[{\\\"3698\\\", \\\" \\\", \\\"x\\\"}], \\\"-\\\", \
RowBox[{\\\"9547\\\", \\\" \\\", SuperscriptBox[\\\"x\\\", \\\"2\\\"]}], \
\\\"+\\\", RowBox[{\\\"14429\\\", \\\" \\\", SuperscriptBox[\\\"x\\\", \
\\\"3\\\"]}], \\\"-\\\", RowBox[{\\\"14689\\\", \\\" \\\", \
SuperscriptBox[\\\"x\\\", \\\"4\\\"]}], \\\"+\\\", RowBox[{\\\"6137\\\", \\\" \
\\\", SuperscriptBox[\\\"x\\\", \\\"5\\\"]}]}]\\)\"\>"], "Output",
 CellChangeTimes->{3.851598711544779*^9},
 CellLabel->
  "Out[1138]=",ExpressionUUID->"81d7852e-156b-4464-b826-81ef6d70c70a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ineq2", ",", "lo2", ",", "hi2"}], "}"}], "=", 
  RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
   RowBox[{
    RowBox[{"distance", "[", 
     RowBox[{"4", ",", "6"}], "]"}], "<=", 
    RowBox[{"k", " ", 
     RowBox[{"distance", "[", 
      RowBox[{"4", ",", "7"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8515980058164673`*^9, 3.8515980680173397`*^9}},
 CellLabel->
  "In[1124]:=",ExpressionUUID->"ba4423ad-c1eb-492f-a563-5e03b597d2c6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"k", "\[GreaterEqual]", 
    InterpretationBox[
     TemplateBox[{"Root",TemplateBox[{"\"1.22\"", 
         DynamicBox[
          FEPrivate`FrontEndResource[
          "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
       TagBox[
        RowBox[{"Root", "[", 
          RowBox[{
            RowBox[{
              RowBox[{"625", "-", 
                RowBox[{"10411", " ", "#1"}], "+", 
                RowBox[{"7401", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                RowBox[{"512", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                RowBox[{"64", " ", 
                  SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}], 
        Short[#, 7]& ],1.2189676875336388`},
      "NumericalApproximation"],
     Root[625 - 10411 # + 7401 #^2 + 512 #^3 + 64 #^4& , 2, 0]]}], ",", 
   InterpretationBox[
    TemplateBox[{"Root",TemplateBox[{"\"1.22\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{"625", "-", 
               RowBox[{"10411", " ", "#1"}], "+", 
               RowBox[{"7401", " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
               RowBox[{"512", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{"64", " ", 
                 SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}], 
       Short[#, 7]& ],1.2189676875336388`},
     "NumericalApproximation"],
    Root[625 - 10411 # + 7401 #^2 + 512 #^3 + 64 #^4& , 2, 0]], ",", 
   "\[Infinity]"}], "}"}]], "Output",
 CellChangeTimes->{{3.8515980341425467`*^9, 3.8515980707546377`*^9}},
 CellLabel->
  "Out[1124]=",ExpressionUUID->"88340661-a10a-409b-82d4-5a3653a1ec16"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lo", "=", 
  RowBox[{
   RowBox[{"Sqrt", "[", "lo2", "]"}], "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.851598139273676*^9, 3.8515981583765182`*^9}, {
  3.851598223074492*^9, 3.8515982237689342`*^9}},
 CellLabel->
  "In[1128]:=",ExpressionUUID->"a548406f-a022-4ed8-b597-51f910769cec"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{"Root",TemplateBox[{"\"1.10\"", 
      DynamicBox[
       FEPrivate`FrontEndResource[
       "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
    TagBox[
     RowBox[{"Root", "[", 
       RowBox[{
         RowBox[{
           RowBox[{
             RowBox[{"-", "25"}], "-", 
             RowBox[{"69", " ", "#1"}], "+", 
             RowBox[{"113", " ", 
               SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"36", " ", 
               SuperscriptBox["#1", "3"]}], "+", 
             RowBox[{"8", " ", 
               SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}], 
     Short[#, 7]& ],1.1040686969267985`},
   "NumericalApproximation"],
  Root[-25 - 69 # + 113 #^2 - 36 #^3 + 8 #^4& , 2, 0]]], "Output",
 CellChangeTimes->{{3.851598146179636*^9, 3.8515981595373373`*^9}, 
   3.8515982262778187`*^9},
 CellLabel->
  "Out[1128]=",ExpressionUUID->"016155a6-f214-4e5d-8b30-cc5472532a00"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"displayRealNumber", "[", "lo", "]"}]], "Input",
 CellChangeTimes->{{3.851598229497883*^9, 3.8515983002666483`*^9}},
 CellLabel->
  "In[1133]:=",ExpressionUUID->"8cd519d1-d61e-49ec-a26f-c334320b3c31"],

Cell[BoxData["\<\"k\[TildeTilde]1.104068697 is the positive root of \
\\!\\(\\*RowBox[{RowBox[{\\\"-\\\", \\\"25\\\"}], \\\"-\\\", RowBox[{\\\"69\\\
\", \\\" \\\", \\\"x\\\"}], \\\"+\\\", RowBox[{\\\"113\\\", \\\" \\\", \
SuperscriptBox[\\\"x\\\", \\\"2\\\"]}], \\\"-\\\", RowBox[{\\\"36\\\", \\\" \
\\\", SuperscriptBox[\\\"x\\\", \\\"3\\\"]}], \\\"+\\\", RowBox[{\\\"8\\\", \
\\\" \\\", SuperscriptBox[\\\"x\\\", \\\"4\\\"]}]}]\\)\"\>"], "Output",
 CellChangeTimes->{{3.85159824445744*^9, 3.851598302224204*^9}},
 CellLabel->
  "Out[1133]=",ExpressionUUID->"c9e91345-de31-421f-858d-f0a60b6ad6d6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ineq2", ",", "lo2", ",", "hi2"}], "}"}], "=", 
  RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
   RowBox[{
    RowBox[{"distance", "[", 
     RowBox[{"5", ",", "6"}], "]"}], "<=", 
    RowBox[{"k", " ", 
     RowBox[{"distance", "[", 
      RowBox[{"5", ",", "9"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851599355501602*^9, 3.851599360701229*^9}},
 CellLabel->
  "In[1144]:=",ExpressionUUID->"afd9bfde-53a2-4b50-8578-1c70a4e3a5ad"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"k", "\[GreaterEqual]", 
    InterpretationBox[
     TemplateBox[{"Root",TemplateBox[{"\"1.11\"", 
         DynamicBox[
          FEPrivate`FrontEndResource[
          "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
       TagBox[
        RowBox[{"Root", "[", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{"-", "1500625"}], "+", 
                RowBox[{"80781541", " ", "#1"}], "-", 
                RowBox[{"13487578", " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"76385222", " ", 
                  SuperscriptBox["#1", "3"]}], "-", 
                RowBox[{"20140453", " ", 
                  SuperscriptBox["#1", "4"]}], "+", 
                RowBox[{"37662769", " ", 
                  SuperscriptBox["#1", "5"]}]}], "&"}], ",", "2"}], "]"}], 
        Short[#, 7]& ],1.1094875210760982`},
      "NumericalApproximation"],
     Root[-1500625 + 80781541 # - 13487578 #^2 - 76385222 #^3 - 20140453 #^4 + 
      37662769 #^5& , 2, 0]]}], ",", 
   InterpretationBox[
    TemplateBox[{"Root",TemplateBox[{"\"1.11\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{
               RowBox[{"-", "1500625"}], "+", 
               RowBox[{"80781541", " ", "#1"}], "-", 
               RowBox[{"13487578", " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
               RowBox[{"76385222", " ", 
                 SuperscriptBox["#1", "3"]}], "-", 
               RowBox[{"20140453", " ", 
                 SuperscriptBox["#1", "4"]}], "+", 
               RowBox[{"37662769", " ", 
                 SuperscriptBox["#1", "5"]}]}], "&"}], ",", "2"}], "]"}], 
       Short[#, 7]& ],1.1094875210760982`},
     "NumericalApproximation"],
    Root[-1500625 + 80781541 # - 13487578 #^2 - 76385222 #^3 - 20140453 #^4 + 
     37662769 #^5& , 2, 0]], ",", "\[Infinity]"}], "}"}]], "Output",
 CellChangeTimes->{3.8515993652177973`*^9},
 CellLabel->
  "Out[1144]=",ExpressionUUID->"1b1db75a-f675-444c-8227-61f9611bca77"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lo", "=", 
  RowBox[{
   RowBox[{"Sqrt", "[", "lo2", "]"}], "//", "FullSimplify"}]}]], "Input",
 CellLabel->
  "In[1145]:=",ExpressionUUID->"609bb25e-552c-4561-8d1c-f8c87f651203"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{"Root",TemplateBox[{"\"1.05\"", 
      DynamicBox[
       FEPrivate`FrontEndResource[
       "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
    TagBox[
     RowBox[{"Root", "[", 
       RowBox[{
         RowBox[{
           RowBox[{
             RowBox[{"-", "1225"}], "-", 
             RowBox[{"9479", " ", "#1"}], "-", 
             RowBox[{"3702", " ", 
               SuperscriptBox["#1", "2"]}], "+", 
             RowBox[{"678", " ", 
               SuperscriptBox["#1", "3"]}], "+", 
             RowBox[{"5335", " ", 
               SuperscriptBox["#1", "4"]}], "+", 
             RowBox[{"6137", " ", 
               SuperscriptBox["#1", "5"]}]}], "&"}], ",", "3"}], "]"}], 
     Short[#, 7]& ],1.0533221354723816`},
   "NumericalApproximation"],
  Root[-1225 - 9479 # - 3702 #^2 + 678 #^3 + 5335 #^4 + 6137 #^5& , 3, 
   0]]], "Output",
 CellChangeTimes->{3.851599379324461*^9},
 CellLabel->
  "Out[1145]=",ExpressionUUID->"dd9ef930-ba7a-4cbc-83c8-af22d02e6476"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"displayRealNumber", "[", "lo", "]"}]], "Input",
 CellLabel->
  "In[1146]:=",ExpressionUUID->"7ecc472d-1170-4ad3-82a3-ef268d471607"],

Cell[BoxData["\<\"k\[TildeTilde]1.053322135 is the positive root of \
\\!\\(\\*RowBox[{RowBox[{\\\"-\\\", \\\"1225\\\"}], \\\"-\\\", \
RowBox[{\\\"9479\\\", \\\" \\\", \\\"x\\\"}], \\\"-\\\", \
RowBox[{\\\"3702\\\", \\\" \\\", SuperscriptBox[\\\"x\\\", \\\"2\\\"]}], \
\\\"+\\\", RowBox[{\\\"678\\\", \\\" \\\", SuperscriptBox[\\\"x\\\", \
\\\"3\\\"]}], \\\"+\\\", RowBox[{\\\"5335\\\", \\\" \\\", \
SuperscriptBox[\\\"x\\\", \\\"4\\\"]}], \\\"+\\\", RowBox[{\\\"6137\\\", \\\" \
\\\", SuperscriptBox[\\\"x\\\", \\\"5\\\"]}]}]\\)\"\>"], "Output",
 CellChangeTimes->{3.851599387188098*^9},
 CellLabel->
  "Out[1146]=",ExpressionUUID->"1a607fac-5488-4656-8ef9-60cc764f8433"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ineq2", ",", "lo2", ",", "hi2"}], "}"}], "=", 
  RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
   RowBox[{
    RowBox[{"distance", "[", 
     RowBox[{"5", ",", "6"}], "]"}], "<=", 
    RowBox[{"k", " ", 
     RowBox[{"distance", "[", 
      RowBox[{"5", ",", "10"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851599546622504*^9, 3.8515995469980164`*^9}},
 CellLabel->
  "In[1148]:=",ExpressionUUID->"419ae364-60ed-42fb-aa86-3ecab1cb0ca5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"k", "\[GreaterEqual]", 
    InterpretationBox[
     TemplateBox[{"Root",TemplateBox[{"\"1.43\"", 
         DynamicBox[
          FEPrivate`FrontEndResource[
          "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
       TagBox[
        RowBox[{"Root", "[", 
          RowBox[{
            RowBox[{
              RowBox[{"1", "-", 
                RowBox[{"944", " ", "#1"}], "+", 
                RowBox[{"602", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                RowBox[{"40", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], 
        Short[#, 7]& ],1.4268423705705118`},
      "NumericalApproximation"],
     Root[1 - 944 # + 602 #^2 + 40 #^3 + #^4& , 2, 0]]}], ",", 
   InterpretationBox[
    TemplateBox[{"Root",TemplateBox[{"\"1.43\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{"1", "-", 
               RowBox[{"944", " ", "#1"}], "+", 
               RowBox[{"602", " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
               RowBox[{"40", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
               SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], 
       Short[#, 7]& ],1.4268423705705118`},
     "NumericalApproximation"],
    Root[1 - 944 # + 602 #^2 + 40 #^3 + #^4& , 2, 0]], ",", "\[Infinity]"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.851599548492071*^9},
 CellLabel->
  "Out[1148]=",ExpressionUUID->"0fd872ee-b40b-4b11-8f1a-51292f3dd39f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lo", "=", 
  RowBox[{
   RowBox[{"Sqrt", "[", "lo2", "]"}], "//", "FullSimplify"}]}]], "Input",
 CellLabel->
  "In[1149]:=",ExpressionUUID->"911c4a36-fff9-4c56-bd08-8560b810fba7"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{"Root",TemplateBox[{"\"1.19\"", 
      DynamicBox[
       FEPrivate`FrontEndResource[
       "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
    TagBox[
     RowBox[{"Root", "[", 
       RowBox[{
         RowBox[{
           RowBox[{
             RowBox[{"-", "1"}], "-", 
             RowBox[{"30", " ", "#1"}], "+", 
             RowBox[{"22", " ", 
               SuperscriptBox["#1", "2"]}], "+", 
             RowBox[{"2", " ", 
               SuperscriptBox["#1", "3"]}], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], 
     Short[#, 7]& ],1.19450507348044},
   "NumericalApproximation"],
  Root[-1 - 30 # + 22 #^2 + 2 #^3 + #^4& , 2, 0]]], "Output",
 CellChangeTimes->{3.851599556778344*^9},
 CellLabel->
  "Out[1149]=",ExpressionUUID->"04e32ee8-5442-448f-85d9-07e118f88825"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"displayRealNumber", "[", "lo", "]"}]], "Input",
 CellLabel->
  "In[1150]:=",ExpressionUUID->"c6604bd6-a16a-4961-8d71-1b876c1e9479"],

Cell[BoxData["\<\"k\[TildeTilde]1.194505073 is the positive root of \
\\!\\(\\*RowBox[{RowBox[{\\\"-\\\", \\\"1\\\"}], \\\"-\\\", \
RowBox[{\\\"30\\\", \\\" \\\", \\\"x\\\"}], \\\"+\\\", RowBox[{\\\"22\\\", \\\
\" \\\", SuperscriptBox[\\\"x\\\", \\\"2\\\"]}], \\\"+\\\", \
RowBox[{\\\"2\\\", \\\" \\\", SuperscriptBox[\\\"x\\\", \\\"3\\\"]}], \\\"+\\\
\", SuperscriptBox[\\\"x\\\", \\\"4\\\"]}]\\)\"\>"], "Output",
 CellChangeTimes->{3.8515995659982843`*^9},
 CellLabel->
  "Out[1150]=",ExpressionUUID->"b9d38f7f-0a28-413f-b14e-f7c7ddc063df"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ineq2", ",", "lo2", ",", "hi2"}], "}"}], "=", 
  RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
   RowBox[{
    RowBox[{"distance", "[", 
     RowBox[{"6", ",", "3"}], "]"}], ">=", 
    RowBox[{"k", " ", 
     RowBox[{"distance", "[", 
      RowBox[{"6", ",", "7"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851600647874741*^9, 3.8516006785145187`*^9}},
 CellLabel->
  "In[1157]:=",ExpressionUUID->"1fdee8c7-8c10-4a6a-8d82-3ff810a3fe86"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"k", "\[LessEqual]", 
    InterpretationBox[
     TemplateBox[{"Root",TemplateBox[{"\"61.8\"", 
         DynamicBox[
          FEPrivate`FrontEndResource[
          "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
       TagBox[
        RowBox[{"Root", "[", 
          RowBox[{
            RowBox[{
              RowBox[{"7744", "+", 
                RowBox[{"290960784", " ", "#1"}], "-", 
                RowBox[{"6782842860", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                RowBox[{"60418557684", " ", 
                  SuperscriptBox["#1", "3"]}], "-", 
                RowBox[{"274035844587", " ", 
                  SuperscriptBox["#1", "4"]}], "+", 
                RowBox[{"677249814873", " ", 
                  SuperscriptBox["#1", "5"]}], "-", 
                RowBox[{"894980577861", " ", 
                  SuperscriptBox["#1", "6"]}], "+", 
                RowBox[{"603818269839", " ", 
                  SuperscriptBox["#1", "7"]}], "-", 
                RowBox[{"160813808784", " ", 
                  SuperscriptBox["#1", "8"]}], "+", 
                RowBox[{"2015974656", " ", 
                  SuperscriptBox["#1", "9"]}], "+", 
                RowBox[{"6967296", " ", 
                  SuperscriptBox["#1", "10"]}]}], "&"}], ",", "6"}], "]"}], 
        Short[#, 7]& ],61.82851802829733},
      "NumericalApproximation"],
     Root[
     7744 + 290960784 # - 6782842860 #^2 + 60418557684 #^3 - 274035844587 #^4 + 
      677249814873 #^5 - 894980577861 #^6 + 603818269839 #^7 - 
      160813808784 #^8 + 2015974656 #^9 + 6967296 #^10& , 6, 0]]}], ",", 
   RowBox[{"-", "\[Infinity]"}], ",", 
   InterpretationBox[
    TemplateBox[{"Root",TemplateBox[{"\"61.8\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{"7744", "+", 
               RowBox[{"290960784", " ", "#1"}], "-", 
               RowBox[{"6782842860", " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
               RowBox[{"60418557684", " ", 
                 SuperscriptBox["#1", "3"]}], "-", 
               RowBox[{"274035844587", " ", 
                 SuperscriptBox["#1", "4"]}], "+", 
               RowBox[{"677249814873", " ", 
                 SuperscriptBox["#1", "5"]}], "-", 
               RowBox[{"894980577861", " ", 
                 SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{"603818269839", " ", 
                 SuperscriptBox["#1", "7"]}], "-", 
               RowBox[{"160813808784", " ", 
                 SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{"2015974656", " ", 
                 SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{"6967296", " ", 
                 SuperscriptBox["#1", "10"]}]}], "&"}], ",", "6"}], "]"}], 
       Short[#, 7]& ],61.82851802829733},
     "NumericalApproximation"],
    Root[7744 + 290960784 # - 6782842860 #^2 + 60418557684 #^3 - 
     274035844587 #^4 + 677249814873 #^5 - 894980577861 #^6 + 
     603818269839 #^7 - 160813808784 #^8 + 2015974656 #^9 + 6967296 #^10& , 6,
      0]]}], "}"}]], "Output",
 CellChangeTimes->{3.851600680609391*^9},
 CellLabel->
  "Out[1157]=",ExpressionUUID->"98229cb2-049f-4ec5-9465-f70a46266101"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"hi", "=", 
  RowBox[{
   RowBox[{"Sqrt", "[", "hi2", "]"}], "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.8516007091148787`*^9, 3.8516007162745447`*^9}},
 CellLabel->
  "In[1158]:=",ExpressionUUID->"0a3345c9-df4c-407f-ae37-d4d0cd4bdcd5"],

Cell[BoxData[
 SqrtBox[
  InterpretationBox[
   TemplateBox[{"Root",TemplateBox[{"\"61.8\"", 
       DynamicBox[
        FEPrivate`FrontEndResource[
        "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
     TagBox[
      RowBox[{"Root", "[", 
        RowBox[{
          RowBox[{
            RowBox[{"7744", "+", 
              RowBox[{"290960784", " ", "#1"}], "-", 
              RowBox[{"6782842860", " ", 
                SuperscriptBox["#1", "2"]}], "+", 
              RowBox[{"60418557684", " ", 
                SuperscriptBox["#1", "3"]}], "-", 
              RowBox[{"274035844587", " ", 
                SuperscriptBox["#1", "4"]}], "+", 
              RowBox[{"677249814873", " ", 
                SuperscriptBox["#1", "5"]}], "-", 
              RowBox[{"894980577861", " ", 
                SuperscriptBox["#1", "6"]}], "+", 
              RowBox[{"603818269839", " ", 
                SuperscriptBox["#1", "7"]}], "-", 
              RowBox[{"160813808784", " ", 
                SuperscriptBox["#1", "8"]}], "+", 
              RowBox[{"2015974656", " ", 
                SuperscriptBox["#1", "9"]}], "+", 
              RowBox[{"6967296", " ", 
                SuperscriptBox["#1", "10"]}]}], "&"}], ",", "6"}], "]"}], 
      Short[#, 7]& ],61.82851802829733},
    "NumericalApproximation"],
   Root[7744 + 290960784 # - 6782842860 #^2 + 60418557684 #^3 - 
    274035844587 #^4 + 677249814873 #^5 - 894980577861 #^6 + 603818269839 #^7 - 
    160813808784 #^8 + 2015974656 #^9 + 6967296 #^10& , 6, 0]]]], "Output",
 CellChangeTimes->{3.851600717499199*^9},
 CellLabel->
  "Out[1158]=",ExpressionUUID->"59ced701-d2a4-4215-ae56-4f1dfb187a7c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"displayRealNumber", "[", "hi", "]"}]], "Input",
 CellChangeTimes->{{3.851600769219005*^9, 3.851600769554865*^9}},
 CellLabel->
  "In[1159]:=",ExpressionUUID->"74c2312f-f5ec-47d3-aebb-41c71a36b633"],

Cell[BoxData["\<\"k=\\!\\(\\*SqrtBox[InterpretationBox[TemplateBox[List[\\\"\
Root\\\", TemplateBox[List[\\\"\\\\\\\"61.8\\\\\\\"\\\", \
DynamicBox[FEPrivate`FrontEndResource[\\\"FEExpressions\\\", \
\\\"NumericalApproximationElider\\\"]]], \\\"RowDefault\\\"], \
TagBox[RowBox[List[\\\"Root\\\", \\\"[\\\", \
RowBox[List[RowBox[List[RowBox[List[\\\"7744\\\", \\\"+\\\", \
RowBox[List[\\\"290960784\\\", \\\" \\\", \\\"#1\\\"]], \\\"-\\\", \
RowBox[List[\\\"6782842860\\\", \\\" \\\", SuperscriptBox[\\\"#1\\\", \\\"2\\\
\"]]], \\\"+\\\", RowBox[List[\\\"60418557684\\\", \\\" \\\", SuperscriptBox[\
\\\"#1\\\", \\\"3\\\"]]], \\\"-\\\", RowBox[List[\\\"274035844587\\\", \\\" \
\\\", SuperscriptBox[\\\"#1\\\", \\\"4\\\"]]], \\\"+\\\", \
RowBox[List[\\\"677249814873\\\", \\\" \\\", SuperscriptBox[\\\"#1\\\", \\\"5\
\\\"]]], \\\"-\\\", RowBox[List[\\\"894980577861\\\", \\\" \\\", \
SuperscriptBox[\\\"#1\\\", \\\"6\\\"]]], \\\"+\\\", \
RowBox[List[\\\"603818269839\\\", \\\" \\\", SuperscriptBox[\\\"#1\\\", \\\"7\
\\\"]]], \\\"-\\\", RowBox[List[\\\"160813808784\\\", \\\" \\\", \
SuperscriptBox[\\\"#1\\\", \\\"8\\\"]]], \\\"+\\\", \
RowBox[List[\\\"2015974656\\\", \\\" \\\", SuperscriptBox[\\\"#1\\\", \\\"9\\\
\"]]], \\\"+\\\", RowBox[List[\\\"6967296\\\", \\\" \\\", \
SuperscriptBox[\\\"#1\\\", \\\"10\\\"]]]]], \\\"&\\\"]], \\\",\\\", \
\\\"6\\\"]], \\\"]\\\"]], Function[Short[Slot[1], 7]]], 61.82851802829733`], \
\\\"NumericalApproximation\\\"], Root[Function[Plus[7744, Times[290960784, \
Slot[1]], Times[-6782842860, Power[Slot[1], 2]], Times[60418557684, \
Power[Slot[1], 3]], Times[-274035844587, Power[Slot[1], 4]], \
Times[677249814873, Power[Slot[1], 5]], Times[-894980577861, Power[Slot[1], \
6]], Times[603818269839, Power[Slot[1], 7]], Times[-160813808784, \
Power[Slot[1], 8]], Times[2015974656, Power[Slot[1], 9]], Times[6967296, \
Power[Slot[1], 10]]]], 6, 0]]]\\)\"\>"], "Output",
 CellChangeTimes->{3.85160077069739*^9},
 CellLabel->
  "Out[1159]=",ExpressionUUID->"66fa1157-b05f-4923-ab9e-ea7a9d11166d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mp", "=", 
  RowBox[{
   RowBox[{"MinimalPolynomial", "[", "hi", "]"}], "[", "x", "]"}]}]], "Input",\

 CellChangeTimes->{{3.85160087313273*^9, 3.851600912875309*^9}},
 CellLabel->
  "In[1162]:=",ExpressionUUID->"e122f110-6f44-4496-b06a-38405a9e045d"],

Cell[BoxData[
 RowBox[{"7744", "+", 
  RowBox[{"290960784", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"6782842860", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"60418557684", " ", 
   SuperscriptBox["x", "6"]}], "-", 
  RowBox[{"274035844587", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"677249814873", " ", 
   SuperscriptBox["x", "10"]}], "-", 
  RowBox[{"894980577861", " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{"603818269839", " ", 
   SuperscriptBox["x", "14"]}], "-", 
  RowBox[{"160813808784", " ", 
   SuperscriptBox["x", "16"]}], "+", 
  RowBox[{"2015974656", " ", 
   SuperscriptBox["x", "18"]}], "+", 
  RowBox[{"6967296", " ", 
   SuperscriptBox["x", "20"]}]}]], "Output",
 CellChangeTimes->{{3.851600881481674*^9, 3.851600913860239*^9}},
 CellLabel->
  "Out[1162]=",ExpressionUUID->"ae84dff4-f6fe-42e6-bfbc-845f5984d2cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"N", "[", "hi", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8516009290847607`*^9, 3.851600951987321*^9}},
 CellLabel->
  "In[1165]:=",ExpressionUUID->"3e8c0c8f-8735-4d8a-9a66-074f7de7c04e"],

Cell[BoxData[
 TagBox[
  StyleBox["7.863111218105549`",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 CellChangeTimes->{{3.851600939255685*^9, 3.851600952960528*^9}},
 CellLabel->
  "Out[1165]//FullForm=",ExpressionUUID->"66fe6056-f78a-47df-9388-\
b2a919e47250"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"mp", "\[Equal]", "0"}], ",", "x", ",", "Reals"}], "]"}]], "Input",\

 CellChangeTimes->{{3.8516016003355627`*^9, 3.851601613437934*^9}},
 CellLabel->
  "In[1168]:=",ExpressionUUID->"c300a81c-a5b6-41d7-ad82-29e413041561"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "7.86311121810555`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.2457727452615288`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "0.5073958441012303`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "0.3223086618976131`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.3223086618976131`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.5073958441012303`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.2457727452615288`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "7.86311121810555`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8516016084324827`*^9, 3.8516016145021*^9}},
 CellLabel->
  "Out[1168]=",ExpressionUUID->"b5db71d4-babc-4f85-8218-7f8f0e36839e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ineq2", ",", "lo2", ",", "hi2"}], "}"}], "=", 
  RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
   RowBox[{
    RowBox[{"distance", "[", 
     RowBox[{"7", ",", "3"}], "]"}], ">=", 
    RowBox[{"k", " ", 
     RowBox[{"distance", "[", 
      RowBox[{"7", ",", "6"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851601905631777*^9, 3.8516019104712143`*^9}},
 CellLabel->
  "In[1171]:=",ExpressionUUID->"ab35555d-d1f8-49d4-95e0-3e0068e12979"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"k", "\[LessEqual]", 
    InterpretationBox[
     TemplateBox[{"Root",TemplateBox[{"\"63.6\"", 
         DynamicBox[
          FEPrivate`FrontEndResource[
          "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
       TagBox[
        RowBox[{"Root", "[", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{"-", "14637417984"}], "+", 
                RowBox[{"253570773456", " ", "#1"}], "-", 
                RowBox[{"2259294716376", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                RowBox[{"14226627485565", " ", 
                  SuperscriptBox["#1", "3"]}], "-", 
                RowBox[{"65960002546284", " ", 
                  SuperscriptBox["#1", "4"]}], "+", 
                RowBox[{"216425700787620", " ", 
                  SuperscriptBox["#1", "5"]}], "-", 
                RowBox[{"492062343977916", " ", 
                  SuperscriptBox["#1", "6"]}], "+", 
                RowBox[{"782711166381062", " ", 
                  SuperscriptBox["#1", "7"]}], "-", 
                RowBox[{"892396597211316", " ", 
                  SuperscriptBox["#1", "8"]}], "+", 
                RowBox[{"732430210466916", " ", 
                  SuperscriptBox["#1", "9"]}], "-", 
                RowBox[{"410390834384412", " ", 
                  SuperscriptBox["#1", "10"]}], "+", 
                RowBox[{"139707882692901", " ", 
                  SuperscriptBox["#1", "11"]}], "-", 
                RowBox[{"19474287964848", " ", 
                  SuperscriptBox["#1", "12"]}], "+", 
                RowBox[{"220028016384", " ", 
                  SuperscriptBox["#1", "13"]}], "+", 
                RowBox[{"833089536", " ", 
                  SuperscriptBox["#1", "14"]}]}], "&"}], ",", "6"}], "]"}], 
        Short[#, 7]& ],63.6430843409629},
      "NumericalApproximation"],
     Root[-14637417984 + 253570773456 # - 2259294716376 #^2 + 
      14226627485565 #^3 - 65960002546284 #^4 + 216425700787620 #^5 - 
      492062343977916 #^6 + 782711166381062 #^7 - 892396597211316 #^8 + 
      732430210466916 #^9 - 410390834384412 #^10 + 139707882692901 #^11 - 
      19474287964848 #^12 + 220028016384 #^13 + 833089536 #^14& , 6, 0]]}], 
   ",", 
   RowBox[{"-", "\[Infinity]"}], ",", 
   InterpretationBox[
    TemplateBox[{"Root",TemplateBox[{"\"63.6\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{
               RowBox[{"-", "14637417984"}], "+", 
               RowBox[{"253570773456", " ", "#1"}], "-", 
               RowBox[{"2259294716376", " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
               RowBox[{"14226627485565", " ", 
                 SuperscriptBox["#1", "3"]}], "-", 
               RowBox[{"65960002546284", " ", 
                 SuperscriptBox["#1", "4"]}], "+", 
               RowBox[{"216425700787620", " ", 
                 SuperscriptBox["#1", "5"]}], "-", 
               RowBox[{"492062343977916", " ", 
                 SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{"782711166381062", " ", 
                 SuperscriptBox["#1", "7"]}], "-", 
               RowBox[{"892396597211316", " ", 
                 SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{"732430210466916", " ", 
                 SuperscriptBox["#1", "9"]}], "-", 
               RowBox[{"410390834384412", " ", 
                 SuperscriptBox["#1", "10"]}], "+", 
               RowBox[{"139707882692901", " ", 
                 SuperscriptBox["#1", "11"]}], "-", 
               RowBox[{"19474287964848", " ", 
                 SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{"220028016384", " ", 
                 SuperscriptBox["#1", "13"]}], "+", 
               RowBox[{"833089536", " ", 
                 SuperscriptBox["#1", "14"]}]}], "&"}], ",", "6"}], "]"}], 
       Short[#, 7]& ],63.6430843409629},
     "NumericalApproximation"],
    Root[-14637417984 + 253570773456 # - 2259294716376 #^2 + 
     14226627485565 #^3 - 65960002546284 #^4 + 216425700787620 #^5 - 
     492062343977916 #^6 + 782711166381062 #^7 - 892396597211316 #^8 + 
     732430210466916 #^9 - 410390834384412 #^10 + 139707882692901 #^11 - 
     19474287964848 #^12 + 220028016384 #^13 + 833089536 #^14& , 6, 0]]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8516019156102858`*^9},
 CellLabel->
  "Out[1171]=",ExpressionUUID->"ff5f8f3d-b7e4-4ec2-922a-cc5e313654b3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"hi", "=", 
  RowBox[{
   RowBox[{"Sqrt", "[", "hi2", "]"}], "//", "FullSimplify"}]}]], "Input",
 CellLabel->
  "In[1172]:=",ExpressionUUID->"d4b1d4cf-164e-4f89-9485-8bc62e794075"],

Cell[BoxData[
 SqrtBox[
  InterpretationBox[
   TemplateBox[{"Root",TemplateBox[{"\"63.6\"", 
       DynamicBox[
        FEPrivate`FrontEndResource[
        "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
     TagBox[
      RowBox[{"Root", "[", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{"-", "14637417984"}], "+", 
              RowBox[{"253570773456", " ", "#1"}], "-", 
              RowBox[{"2259294716376", " ", 
                SuperscriptBox["#1", "2"]}], "+", 
              RowBox[{"14226627485565", " ", 
                SuperscriptBox["#1", "3"]}], "-", 
              RowBox[{"65960002546284", " ", 
                SuperscriptBox["#1", "4"]}], "+", 
              RowBox[{"216425700787620", " ", 
                SuperscriptBox["#1", "5"]}], "-", 
              RowBox[{"492062343977916", " ", 
                SuperscriptBox["#1", "6"]}], "+", 
              RowBox[{"782711166381062", " ", 
                SuperscriptBox["#1", "7"]}], "-", 
              RowBox[{"892396597211316", " ", 
                SuperscriptBox["#1", "8"]}], "+", 
              RowBox[{"732430210466916", " ", 
                SuperscriptBox["#1", "9"]}], "-", 
              RowBox[{"410390834384412", " ", 
                SuperscriptBox["#1", "10"]}], "+", 
              RowBox[{"139707882692901", " ", 
                SuperscriptBox["#1", "11"]}], "-", 
              RowBox[{"19474287964848", " ", 
                SuperscriptBox["#1", "12"]}], "+", 
              RowBox[{"220028016384", " ", 
                SuperscriptBox["#1", "13"]}], "+", 
              RowBox[{"833089536", " ", 
                SuperscriptBox["#1", "14"]}]}], "&"}], ",", "6"}], "]"}], 
      Short[#, 7]& ],63.6430843409629},
    "NumericalApproximation"],
   Root[-14637417984 + 253570773456 # - 2259294716376 #^2 + 
    14226627485565 #^3 - 65960002546284 #^4 + 216425700787620 #^5 - 
    492062343977916 #^6 + 782711166381062 #^7 - 892396597211316 #^8 + 
    732430210466916 #^9 - 410390834384412 #^10 + 139707882692901 #^11 - 
    19474287964848 #^12 + 220028016384 #^13 + 833089536 #^14& , 6, 
    0]]]], "Output",
 CellChangeTimes->{3.851601926348393*^9},
 CellLabel->
  "Out[1172]=",ExpressionUUID->"09828cfc-55b8-40dd-bf0b-e18f359005f7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mp", "=", 
  RowBox[{
   RowBox[{"MinimalPolynomial", "[", "hi", "]"}], "[", "x", "]"}]}]], "Input",\

 CellLabel->
  "In[1174]:=",ExpressionUUID->"162ea0c5-7d50-45da-a956-7a1441ada6f2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "14637417984"}], "+", 
  RowBox[{"253570773456", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"2259294716376", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"14226627485565", " ", 
   SuperscriptBox["x", "6"]}], "-", 
  RowBox[{"65960002546284", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"216425700787620", " ", 
   SuperscriptBox["x", "10"]}], "-", 
  RowBox[{"492062343977916", " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{"782711166381062", " ", 
   SuperscriptBox["x", "14"]}], "-", 
  RowBox[{"892396597211316", " ", 
   SuperscriptBox["x", "16"]}], "+", 
  RowBox[{"732430210466916", " ", 
   SuperscriptBox["x", "18"]}], "-", 
  RowBox[{"410390834384412", " ", 
   SuperscriptBox["x", "20"]}], "+", 
  RowBox[{"139707882692901", " ", 
   SuperscriptBox["x", "22"]}], "-", 
  RowBox[{"19474287964848", " ", 
   SuperscriptBox["x", "24"]}], "+", 
  RowBox[{"220028016384", " ", 
   SuperscriptBox["x", "26"]}], "+", 
  RowBox[{"833089536", " ", 
   SuperscriptBox["x", "28"]}]}]], "Output",
 CellChangeTimes->{3.8516019575707903`*^9},
 CellLabel->
  "Out[1174]=",ExpressionUUID->"e4c85fe1-57de-4936-9141-61a2aefffcd9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"N", "[", "hi", "]"}], "]"}]], "Input",
 CellLabel->
  "In[1176]:=",ExpressionUUID->"9569016b-7a2a-45e5-b890-a6cd307ed759"],

Cell[BoxData[
 TagBox[
  StyleBox["7.9776615835069675`",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 CellChangeTimes->{3.851601977589621*^9},
 CellLabel->
  "Out[1176]//FullForm=",ExpressionUUID->"40e045d2-68a6-494d-946c-\
1a8d234fc44f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"mp", "\[Equal]", "0"}], ",", "x", ",", "Reals"}], "]"}]], "Input",\

 CellChangeTimes->{{3.8516020531853743`*^9, 3.851602071615727*^9}},
 CellLabel->
  "In[1178]:=",ExpressionUUID->"73f04e7d-58f1-4f33-871c-5c717763f2a4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "7.9776615835069675`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.8891105676851805`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "0.6244082234952268`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "0.5485715743105091`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "0.5047382957602776`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.5047382957602776`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.5485715743105091`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.6244082234952268`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.8891105676851805`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "7.9776615835069675`"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{{3.8516020673793983`*^9, 3.851602072513324*^9}},
 CellLabel->
  "Out[1178]=",ExpressionUUID->"645343a0-48dd-4eb0-bec9-9bbc94611f39"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ineq2", ",", "lo2", ",", "hi2"}], "}"}], "=", 
  RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
   RowBox[{
    RowBox[{"distance", "[", 
     RowBox[{"8", ",", "5"}], "]"}], ">=", 
    RowBox[{"k", " ", 
     RowBox[{"distance", "[", 
      RowBox[{"8", ",", "6"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851602249848959*^9, 3.851602278922051*^9}},
 CellLabel->
  "In[1180]:=",ExpressionUUID->"fad9c5d9-e9a8-4eb7-be3a-673ac12c40ad"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"k", "\[LessEqual]", 
    InterpretationBox[
     TemplateBox[{"Root",TemplateBox[{"\"0.465\"", 
         DynamicBox[
          FEPrivate`FrontEndResource[
          "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
       TagBox[
        RowBox[{"Root", "[", 
          RowBox[{
            RowBox[{
              RowBox[{"14641", "-", 
                RowBox[{"108956", " ", "#1"}], "+", 
                RowBox[{"607664", " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"1322048", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                RowBox[{"802816", " ", 
                  SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], 
        Short[#, 7]& ],0.4647202486785734},
      "NumericalApproximation"],
     Root[
     14641 - 108956 # + 607664 #^2 - 1322048 #^3 + 802816 #^4& , 1, 0]]}], 
   ",", 
   RowBox[{"-", "\[Infinity]"}], ",", 
   InterpretationBox[
    TemplateBox[{"Root",TemplateBox[{"\"0.465\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{"14641", "-", 
               RowBox[{"108956", " ", "#1"}], "+", 
               RowBox[{"607664", " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
               RowBox[{"1322048", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{"802816", " ", 
                 SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], 
       Short[#, 7]& ],0.4647202486785734},
     "NumericalApproximation"],
    Root[14641 - 108956 # + 607664 #^2 - 1322048 #^3 + 802816 #^4& , 1, 0]]}],
   "}"}]], "Output",
 CellChangeTimes->{{3.8516022588203287`*^9, 3.851602280574997*^9}},
 CellLabel->
  "Out[1180]=",ExpressionUUID->"57ba66e0-0e34-4c14-9cbe-9f50d59b4854"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"hi", "=", 
  RowBox[{
   RowBox[{"Sqrt", "[", "hi2", "]"}], "//", "FullSimplify"}]}]], "Input",
 CellLabel->
  "In[1181]:=",ExpressionUUID->"0b369b58-16f8-4cf5-a38a-8b35b3b0206f"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{"Root",TemplateBox[{"\"0.682\"", 
      DynamicBox[
       FEPrivate`FrontEndResource[
       "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
    TagBox[
     RowBox[{"Root", "[", 
       RowBox[{
         RowBox[{
           RowBox[{"121", "-", 
             RowBox[{"758", " ", "#1"}], "+", 
             RowBox[{"1924", " ", 
               SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"2184", " ", 
               SuperscriptBox["#1", "3"]}], "+", 
             RowBox[{"896", " ", 
               SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], 
     Short[#, 7]& ],0.6817039303675558},
   "NumericalApproximation"],
  Root[121 - 758 # + 1924 #^2 - 2184 #^3 + 896 #^4& , 1, 0]]], "Output",
 CellChangeTimes->{3.8516022940537367`*^9},
 CellLabel->
  "Out[1181]=",ExpressionUUID->"9db464b8-fedf-441d-8716-883b0e159642"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"displayRealNumber", "[", "hi", "]"}]], "Input",
 CellLabel->
  "In[1182]:=",ExpressionUUID->"9e69df92-6f02-46a9-8c06-9855554a2d6f"],

Cell[BoxData["\<\"k\[TildeTilde]0.6817039304 is the smallest positive root of \
\\!\\(\\*RowBox[{\\\"121\\\", \\\"-\\\", RowBox[{\\\"758\\\", \\\" \\\", \
\\\"x\\\"}], \\\"+\\\", RowBox[{\\\"1924\\\", \\\" \\\", SuperscriptBox[\\\"x\
\\\", \\\"2\\\"]}], \\\"-\\\", RowBox[{\\\"2184\\\", \\\" \\\", \
SuperscriptBox[\\\"x\\\", \\\"3\\\"]}], \\\"+\\\", RowBox[{\\\"896\\\", \\\" \
\\\", SuperscriptBox[\\\"x\\\", \\\"4\\\"]}]}]\\)\"\>"], "Output",
 CellChangeTimes->{3.851602310179222*^9},
 CellLabel->
  "Out[1182]=",ExpressionUUID->"f4391375-3af1-45bc-8215-83e5a4b4641f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ineq2", ",", "lo2", ",", "hi2"}], "}"}], "=", 
  RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
   RowBox[{
    RowBox[{"distance", "[", 
     RowBox[{"9", ",", "5"}], "]"}], ">=", 
    RowBox[{"k", " ", 
     RowBox[{"distance", "[", 
      RowBox[{"9", ",", "6"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851602493777894*^9, 3.851602513666978*^9}},
 CellLabel->
  "In[1185]:=",ExpressionUUID->"321a5acc-c821-45bd-9a25-dbe7c8a0ef86"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"k", "\[LessEqual]", 
    InterpretationBox[
     TemplateBox[{"Root",TemplateBox[{"\"0.237\"", 
         DynamicBox[
          FEPrivate`FrontEndResource[
          "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
       TagBox[
        RowBox[{"Root", "[", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{"-", "37662769"}], "+", 
                RowBox[{"142972508", " ", "#1"}], "+", 
                RowBox[{"8028640", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                RowBox[{"318484352", " ", 
                  SuperscriptBox["#1", "3"]}], "-", 
                RowBox[{"302194240", " ", 
                  SuperscriptBox["#1", "4"]}], "+", 
                RowBox[{"9437184", " ", 
                  SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}], 
        Short[#, 7]& ],0.23718423648248518`},
      "NumericalApproximation"],
     Root[-37662769 + 142972508 # + 8028640 #^2 + 318484352 #^3 - 
      302194240 #^4 + 9437184 #^5& , 1, 0]]}], ",", 
   RowBox[{"-", "\[Infinity]"}], ",", 
   InterpretationBox[
    TemplateBox[{"Root",TemplateBox[{"\"0.237\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{
               RowBox[{"-", "37662769"}], "+", 
               RowBox[{"142972508", " ", "#1"}], "+", 
               RowBox[{"8028640", " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
               RowBox[{"318484352", " ", 
                 SuperscriptBox["#1", "3"]}], "-", 
               RowBox[{"302194240", " ", 
                 SuperscriptBox["#1", "4"]}], "+", 
               RowBox[{"9437184", " ", 
                 SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}], 
       Short[#, 7]& ],0.23718423648248518`},
     "NumericalApproximation"],
    Root[-37662769 + 142972508 # + 8028640 #^2 + 318484352 #^3 - 
     302194240 #^4 + 9437184 #^5& , 1, 0]]}], "}"}]], "Output",
 CellChangeTimes->{{3.851602503247176*^9, 3.8516025150025063`*^9}},
 CellLabel->
  "Out[1185]=",ExpressionUUID->"4642c7da-8aaf-41a9-b5b7-64f72febd97e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"hi", "=", 
  RowBox[{
   RowBox[{"Sqrt", "[", "hi2", "]"}], "//", "FullSimplify"}]}]], "Input",
 CellLabel->
  "In[1186]:=",ExpressionUUID->"85fcebb7-1328-4250-91ab-dfcc89c9123a"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{"Root",TemplateBox[{"\"0.487\"", 
      DynamicBox[
       FEPrivate`FrontEndResource[
       "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
    TagBox[
     RowBox[{"Root", "[", 
       RowBox[{
         RowBox[{
           RowBox[{"6137", "-", 
             RowBox[{"25350", " ", "#1"}], "+", 
             RowBox[{"40708", " ", 
               SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"35096", " ", 
               SuperscriptBox["#1", "3"]}], "+", 
             RowBox[{"9304", " ", 
               SuperscriptBox["#1", "4"]}], "+", 
             RowBox[{"3072", " ", 
               SuperscriptBox["#1", "5"]}]}], "&"}], ",", "2"}], "]"}], 
     Short[#, 7]& ],0.4870156429546028},
   "NumericalApproximation"],
  Root[6137 - 25350 # + 40708 #^2 - 35096 #^3 + 9304 #^4 + 3072 #^5& , 2, 
   0]]], "Output",
 CellChangeTimes->{3.851602522467497*^9},
 CellLabel->
  "Out[1186]=",ExpressionUUID->"6b3e0139-2e66-46cd-8533-df068fbee0e8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"displayRealNumber", "[", "hi", "]"}]], "Input",
 CellLabel->
  "In[1187]:=",ExpressionUUID->"4652dbca-47ba-40fe-a301-3bce83b15ef7"],

Cell[BoxData["\<\"k\[TildeTilde]0.4870156430 is the smallest positive root of \
\\!\\(\\*RowBox[{\\\"6137\\\", \\\"-\\\", RowBox[{\\\"25350\\\", \\\" \\\", \
\\\"x\\\"}], \\\"+\\\", RowBox[{\\\"40708\\\", \\\" \\\", \
SuperscriptBox[\\\"x\\\", \\\"2\\\"]}], \\\"-\\\", RowBox[{\\\"35096\\\", \
\\\" \\\", SuperscriptBox[\\\"x\\\", \\\"3\\\"]}], \\\"+\\\", \
RowBox[{\\\"9304\\\", \\\" \\\", SuperscriptBox[\\\"x\\\", \\\"4\\\"]}], \
\\\"+\\\", RowBox[{\\\"3072\\\", \\\" \\\", SuperscriptBox[\\\"x\\\", \\\"5\\\
\"]}]}]\\)\"\>"], "Output",
 CellChangeTimes->{3.851602529086994*^9},
 CellLabel->
  "Out[1187]=",ExpressionUUID->"badaae72-f943-4516-b2bb-93e622b938d3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ineq2", ",", "lo2", ",", "hi2"}], "}"}], "=", 
  RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
   RowBox[{
    RowBox[{"distance", "[", 
     RowBox[{"10", ",", "5"}], "]"}], ">=", 
    RowBox[{"k", " ", 
     RowBox[{"distance", "[", 
      RowBox[{"10", ",", "6"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8516026534744787`*^9, 3.851602657754163*^9}},
 CellLabel->
  "In[1189]:=",ExpressionUUID->"29570f1b-cf83-4d9a-a407-68f2c2a8122d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"k", "\[LessEqual]", 
    InterpretationBox[
     TemplateBox[{"Root",TemplateBox[{"\"0.208\"", 
         DynamicBox[
          FEPrivate`FrontEndResource[
          "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
       TagBox[
        RowBox[{"Root", "[", 
          RowBox[{
            RowBox[{
              RowBox[{"1", "+", 
                RowBox[{"40", " ", "#1"}], "+", 
                RowBox[{"296", " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"2984", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                RowBox[{"2500", " ", 
                  SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], 
        Short[#, 7]& ],0.20764755489493278`},
      "NumericalApproximation"],
     Root[1 + 40 # + 296 #^2 - 2984 #^3 + 2500 #^4& , 1, 0]]}], ",", 
   RowBox[{"-", "\[Infinity]"}], ",", 
   InterpretationBox[
    TemplateBox[{"Root",TemplateBox[{"\"0.208\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{"1", "+", 
               RowBox[{"40", " ", "#1"}], "+", 
               RowBox[{"296", " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
               RowBox[{"2984", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{"2500", " ", 
                 SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], 
       Short[#, 7]& ],0.20764755489493278`},
     "NumericalApproximation"],
    Root[1 + 40 # + 296 #^2 - 2984 #^3 + 2500 #^4& , 1, 0]]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8516026593852882`*^9},
 CellLabel->
  "Out[1189]=",ExpressionUUID->"2865f2b8-0a08-41d3-bd54-6f1f4205da66"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"hi", "=", 
  RowBox[{
   RowBox[{"Sqrt", "[", "hi2", "]"}], "//", "FullSimplify"}]}]], "Input",
 CellLabel->
  "In[1190]:=",ExpressionUUID->"b5d9f768-e022-445e-9e09-3033f137a9ff"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{"Root",TemplateBox[{"\"0.456\"", 
      DynamicBox[
       FEPrivate`FrontEndResource[
       "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"],
    TagBox[
     RowBox[{"Root", "[", 
       RowBox[{
         RowBox[{
           RowBox[{"1", "-", 
             RowBox[{"2", " ", "#1"}], "+", 
             RowBox[{"22", " ", 
               SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"72", " ", 
               SuperscriptBox["#1", "3"]}], "+", 
             RowBox[{"50", " ", 
               SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], 
     Short[#, 7]& ],0.4556836127127382},
   "NumericalApproximation"],
  Root[1 - 2 # + 22 #^2 - 72 #^3 + 50 #^4& , 1, 0]]], "Output",
 CellChangeTimes->{3.851602668191506*^9},
 CellLabel->
  "Out[1190]=",ExpressionUUID->"00d9023c-53e7-4109-8b23-48d6f186be15"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"displayRealNumber", "[", "hi", "]"}]], "Input",
 CellLabel->
  "In[1191]:=",ExpressionUUID->"c1b78cd3-450a-456a-99e6-d6297cdf436d"],

Cell[BoxData["\<\"k\[TildeTilde]0.4556836127 is the smallest positive root of \
\\!\\(\\*RowBox[{\\\"1\\\", \\\"-\\\", RowBox[{\\\"2\\\", \\\" \\\", \
\\\"x\\\"}], \\\"+\\\", RowBox[{\\\"22\\\", \\\" \\\", SuperscriptBox[\\\"x\\\
\", \\\"2\\\"]}], \\\"-\\\", RowBox[{\\\"72\\\", \\\" \\\", SuperscriptBox[\\\
\"x\\\", \\\"3\\\"]}], \\\"+\\\", RowBox[{\\\"50\\\", \\\" \\\", \
SuperscriptBox[\\\"x\\\", \\\"4\\\"]}]}]\\)\"\>"], "Output",
 CellChangeTimes->{3.851602674585082*^9},
 CellLabel->
  "Out[1191]=",ExpressionUUID->"c6868918-3332-42a1-bbc6-cdc3e671e4fd"]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{323, Automatic}, {Automatic, 217}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1056, 22, 311, "Text",ExpressionUUID->"0d9d1143-e2b1-4229-a334-eceae79f2764",
 Evaluatable->False],
Cell[1617, 44, 25023, 706, 1110, "Input",ExpressionUUID->"eb9faff4-722f-422c-9a34-3ad93404b942"],
Cell[26643, 752, 924, 19, 115, "Input",ExpressionUUID->"538dfab7-7976-4d7f-b042-a36426c48793"],
Cell[27570, 773, 12248, 247, 1165, "Input",ExpressionUUID->"7be14e67-6c84-4ae5-9b6d-364ec74eb9c2"],
Cell[CellGroupData[{
Cell[39843, 1024, 546, 14, 73, "Input",ExpressionUUID->"94c6ce11-9dde-422f-8d11-1c19dbe1e358"],
Cell[CellGroupData[{
Cell[40414, 1042, 1115, 30, 44, "Print",ExpressionUUID->"035cf325-0da5-4bd4-b613-99339c0d4072"],
Cell[41532, 1074, 1188, 33, 46, "Print",ExpressionUUID->"21fd7b0f-16c9-4baf-ba54-96b0fd22089b"],
Cell[42723, 1109, 1066, 29, 44, "Print",ExpressionUUID->"b154eec9-0a75-4428-9644-0ecc8ed9c380"],
Cell[43792, 1140, 1183, 33, 44, "Print",ExpressionUUID->"2a0d573c-6924-47d2-aabf-1e89c5c5bead"],
Cell[44978, 1175, 1252, 35, 44, "Print",ExpressionUUID->"9cb2c012-6729-454f-917e-9f19aa85c615"],
Cell[46233, 1212, 1185, 33, 44, "Print",ExpressionUUID->"b40b8a27-7e84-43cd-94ff-700a5784e45e"],
Cell[47421, 1247, 1068, 29, 44, "Print",ExpressionUUID->"3037acef-1736-4475-a106-c1f88d3b6457"],
Cell[48492, 1278, 959, 25, 44, "Print",ExpressionUUID->"0b0dd868-27cd-4356-8a59-eec825ef7f85"],
Cell[49454, 1305, 1205, 33, 44, "Print",ExpressionUUID->"bcb5166b-3ff1-4042-98a9-2fad8e01a7f1"],
Cell[50662, 1340, 1301, 37, 44, "Print",ExpressionUUID->"8fbf5712-84bf-4c5e-8877-1150a941fde2"],
Cell[51966, 1379, 1066, 29, 44, "Print",ExpressionUUID->"557c497c-e052-402d-b294-5469a77522fc"],
Cell[53035, 1410, 957, 25, 44, "Print",ExpressionUUID->"5dd8226f-3078-43e6-92a6-c1ffbb9947ce"],
Cell[53995, 1437, 961, 25, 44, "Print",ExpressionUUID->"a8847c24-fe7d-4d97-b47b-4932b9e7d171"],
Cell[54959, 1464, 959, 25, 44, "Print",ExpressionUUID->"c383b7fb-f5ba-40ff-a037-537b06035cdc"],
Cell[55921, 1491, 959, 25, 44, "Print",ExpressionUUID->"23d335bf-ef35-4a73-9f67-582f14cc62d1"],
Cell[56883, 1518, 1068, 29, 44, "Print",ExpressionUUID->"b42000c6-d049-41d6-b048-1478bbe3a8f6"],
Cell[57954, 1549, 1238, 34, 45, "Print",ExpressionUUID->"8a410b46-a8aa-4942-bcf6-7a955a3576db"],
Cell[59195, 1585, 1118, 30, 44, "Print",ExpressionUUID->"ce106c85-c68f-43a4-a8e6-f5e32865cda7"],
Cell[60316, 1617, 1146, 30, 45, "Print",ExpressionUUID->"d52ecc6b-eabc-48a3-8ef2-5586533b594e"],
Cell[61465, 1649, 1010, 26, 44, "Print",ExpressionUUID->"34772da1-94b0-49ee-acda-f7b97e78e176"],
Cell[62478, 1677, 1010, 26, 44, "Print",ExpressionUUID->"493f6c0b-b8a0-49fa-976d-109b31edab7e"],
Cell[63491, 1705, 1010, 26, 44, "Print",ExpressionUUID->"5d82a334-c772-4cb5-8fb8-0acc59faeedf"],
Cell[64504, 1733, 1036, 26, 44, "Print",ExpressionUUID->"cb0d8920-c97d-4b6f-a626-2441d64250d5"],
Cell[65543, 1761, 1008, 26, 44, "Print",ExpressionUUID->"6dcb3def-0f8b-43e4-b237-16463b3f87b7"],
Cell[66554, 1789, 1038, 26, 44, "Print",ExpressionUUID->"c545bef9-98db-464b-b324-de5c75a9d32f"],
Cell[67595, 1817, 1010, 26, 44, "Print",ExpressionUUID->"fa3eec88-d5ee-4991-b5c8-354859633a1a"],
Cell[68608, 1845, 1010, 26, 44, "Print",ExpressionUUID->"3d669a53-5c6f-4318-a7b4-37c9a776d19a"],
Cell[69621, 1873, 1012, 26, 44, "Print",ExpressionUUID->"f38daeef-2495-48a5-8ea0-c9a75d940f1f"],
Cell[70636, 1901, 1367, 38, 44, "Print",ExpressionUUID->"c1b66857-6681-47e2-98b1-a2c4ac1d0d95"],
Cell[72006, 1941, 1145, 30, 44, "Print",ExpressionUUID->"1b0d6a35-e934-4d99-97a9-fe7a1fa1d401"],
Cell[73154, 1973, 1185, 33, 44, "Print",ExpressionUUID->"412df943-3134-4bb6-9b8b-875dc15649f4"],
Cell[74342, 2008, 1143, 30, 44, "Print",ExpressionUUID->"10a36be4-6a8a-486f-98da-8a75000c7abf"],
Cell[75488, 2040, 1010, 26, 44, "Print",ExpressionUUID->"8925c595-e7f5-4610-99c7-7d2fdade209e"],
Cell[76501, 2068, 1185, 33, 44, "Print",ExpressionUUID->"fc177b01-b741-4945-8ccf-ac64376d62c3"],
Cell[77689, 2103, 1006, 26, 44, "Print",ExpressionUUID->"3dee1a2b-9117-48e8-9ba2-50c9ad0511e2"],
Cell[78698, 2131, 1068, 29, 44, "Print",ExpressionUUID->"213e59df-9138-4ae4-ac7f-265df29dbdbd"],
Cell[79769, 2162, 1066, 29, 44, "Print",ExpressionUUID->"1099ae53-891b-40f7-a0c9-84114fe9050a"],
Cell[80838, 2193, 1068, 29, 44, "Print",ExpressionUUID->"80da34e3-5e84-4ec7-880f-c9fc188a3c38"],
Cell[81909, 2224, 959, 25, 44, "Print",ExpressionUUID->"bfb4784d-7870-424d-ac12-137ce7b29d1c"],
Cell[82871, 2251, 961, 25, 44, "Print",ExpressionUUID->"d2f2f9bb-8dd0-429b-a968-45830200330b"],
Cell[83835, 2278, 1010, 26, 44, "Print",ExpressionUUID->"efccea6c-4475-4656-b879-d9abfebbb405"],
Cell[84848, 2306, 959, 25, 44, "Print",ExpressionUUID->"6de78ce9-cbd2-4890-ac98-ca9a0f792dd5"],
Cell[85810, 2333, 959, 25, 44, "Print",ExpressionUUID->"66010fb4-f5ba-4119-9860-18d977f99842"],
Cell[86772, 2360, 1066, 29, 44, "Print",ExpressionUUID->"77d5d160-57cc-47e4-aebd-d1005961b8ff"],
Cell[87841, 2391, 959, 25, 44, "Print",ExpressionUUID->"202a58de-670c-41ae-b60e-cc47323bb79d"],
Cell[88803, 2418, 961, 25, 44, "Print",ExpressionUUID->"d5f8490f-e0ba-4d80-8027-10bed8541251"],
Cell[89767, 2445, 1070, 29, 44, "Print",ExpressionUUID->"fef360ba-cac9-4bf8-8585-816cfa57ca7c"],
Cell[90840, 2476, 1068, 29, 44, "Print",ExpressionUUID->"7b2b42d6-e00e-4dcc-9d8b-a65179ce7cb2"],
Cell[91911, 2507, 1068, 29, 44, "Print",ExpressionUUID->"6cf0511d-0f06-427d-a570-d6fcf877bb36"],
Cell[92982, 2538, 1066, 29, 44, "Print",ExpressionUUID->"c4d30344-86dd-4d27-9641-c253805d448f"],
Cell[94051, 2569, 1068, 29, 44, "Print",ExpressionUUID->"f6cb3443-c6b3-4bfd-b37a-f04db6931840"],
Cell[95122, 2600, 1253, 35, 44, "Print",ExpressionUUID->"e8da0554-6231-481e-bd52-c1fca4a93ab0"],
Cell[96378, 2637, 1665, 50, 44, "Print",ExpressionUUID->"0d458f29-93e1-4b89-937d-0d096fee66c2"],
Cell[98046, 2689, 1036, 26, 44, "Print",ExpressionUUID->"e85ad06b-110e-45b8-bb64-5547119ca666"],
Cell[99085, 2717, 1353, 37, 45, "Print",ExpressionUUID->"165794d8-9acc-4926-858d-3a228000b854"],
Cell[100441, 2756, 1145, 30, 44, "Print",ExpressionUUID->"c9a79e6c-e6f6-4e38-b130-f3cc0db5dce0"],
Cell[101589, 2788, 1006, 26, 44, "Print",ExpressionUUID->"52464d32-4914-4e44-8141-b369a6af19a1"],
Cell[102598, 2816, 1040, 26, 44, "Print",ExpressionUUID->"00d2c912-b20a-4325-85f2-8dc6d3b60a71"],
Cell[103641, 2844, 1038, 26, 44, "Print",ExpressionUUID->"c5aee08e-a14c-42ea-8efa-bb716fcf0b8c"],
Cell[104682, 2872, 1014, 26, 44, "Print",ExpressionUUID->"a860405b-d709-4f22-86ed-783482a18b9f"],
Cell[105699, 2900, 1040, 26, 44, "Print",ExpressionUUID->"a2a65eab-a3eb-4680-9a44-82a929b1ef5a"],
Cell[106742, 2928, 1036, 26, 44, "Print",ExpressionUUID->"bd7fa58d-8d15-428b-8f3e-88a9c0e90cdd"],
Cell[107781, 2956, 1142, 30, 44, "Print",ExpressionUUID->"6653b4e5-288c-447a-92e8-6ed996a4e094"],
Cell[108926, 2988, 1143, 30, 44, "Print",ExpressionUUID->"2dee23cb-f207-4231-b059-0eba6837b293"],
Cell[110072, 3020, 1299, 36, 44, "Print",ExpressionUUID->"fb289ccd-458b-4e77-bb42-1d64bbb23e84"],
Cell[111374, 3058, 1557, 43, 44, "Print",ExpressionUUID->"7bc91f70-5bc0-4e36-980c-e490149a8604"],
Cell[112934, 3103, 959, 25, 44, "Print",ExpressionUUID->"45e36a37-4aad-4efa-9ea2-eb40970f7a7d"],
Cell[113896, 3130, 959, 25, 44, "Print",ExpressionUUID->"4beab5ae-5680-4143-b508-286acce2e429"],
Cell[114858, 3157, 961, 25, 44, "Print",ExpressionUUID->"731ddbc3-de5b-4900-b0cf-592fe3e70338"],
Cell[115822, 3184, 1185, 33, 44, "Print",ExpressionUUID->"6fce9651-ac93-49b6-acdf-bfd2075aaad7"],
Cell[117010, 3219, 1183, 33, 44, "Print",ExpressionUUID->"704d2a5b-ba2a-43ca-b546-d4a9d63fb05c"],
Cell[118196, 3254, 1145, 30, 44, "Print",ExpressionUUID->"9915857d-fde1-44ae-aa29-1a242e2121f9"],
Cell[119344, 3286, 1143, 30, 44, "Print",ExpressionUUID->"297fb73e-68ad-4416-95a0-5c8155c3d06a"],
Cell[120490, 3318, 1066, 29, 44, "Print",ExpressionUUID->"95c3437c-51b0-40f9-908f-e56317a9f0c6"],
Cell[121559, 3349, 961, 25, 44, "Print",ExpressionUUID->"9f4689fe-3f50-404d-94a8-54f62411fd9a"],
Cell[122523, 3376, 963, 25, 44, "Print",ExpressionUUID->"d24ac508-ab62-4926-ab92-59df929be6df"],
Cell[123489, 3403, 1008, 26, 44, "Print",ExpressionUUID->"826a16b4-9fd3-461c-a70b-6a556f86ac54"],
Cell[124500, 3431, 1036, 26, 44, "Print",ExpressionUUID->"31926e77-97c3-40dc-9645-2001d90686ed"],
Cell[125539, 3459, 1036, 26, 44, "Print",ExpressionUUID->"bc6d9a97-84a2-4457-9235-1f3a3b1e7023"],
Cell[126578, 3487, 959, 25, 44, "Print",ExpressionUUID->"d4ff040f-c6bf-4f95-a3b6-0f73b4528626"],
Cell[127540, 3514, 961, 25, 44, "Print",ExpressionUUID->"1351fd43-52ab-4ae2-9f73-088ff8bd6e58"],
Cell[128504, 3541, 963, 25, 44, "Print",ExpressionUUID->"493bf3ef-0edd-4bca-8ade-79e97cbaca97"],
Cell[129470, 3568, 1255, 35, 44, "Print",ExpressionUUID->"4f1c8746-c745-4cd3-bb89-7f30b0650a24"],
Cell[130728, 3605, 1255, 35, 44, "Print",ExpressionUUID->"a9c3f87e-f098-43f8-bd61-d60d5d3cc162"],
Cell[131986, 3642, 1066, 29, 44, "Print",ExpressionUUID->"1550c888-59f4-401b-b71c-f24db2685be3"],
Cell[133055, 3673, 1066, 29, 44, "Print",ExpressionUUID->"4418334f-728b-4f22-866e-598f8231c5b7"],
Cell[134124, 3704, 1067, 29, 44, "Print",ExpressionUUID->"910478c9-bd6d-448d-b9c8-968a523a054b"],
Cell[135194, 3735, 7631, 179, 44, "Print",ExpressionUUID->"1d88d262-76d5-4ed6-8bf8-695519ad31b5"],
Cell[142828, 3916, 961, 25, 44, "Print",ExpressionUUID->"fab4efd4-0dfa-4f4e-8226-52aa44aed230"],
Cell[143792, 3943, 961, 25, 44, "Print",ExpressionUUID->"6b0db743-072e-4c3a-87cb-b4b5bcf1b087"],
Cell[144756, 3970, 960, 25, 44, "Print",ExpressionUUID->"b1aac016-9ef6-4168-87c0-3b693e2c049d"],
Cell[145719, 3997, 959, 25, 44, "Print",ExpressionUUID->"ce41f26a-b42b-4002-9440-6cbfbe716788"],
Cell[146681, 4024, 959, 25, 44, "Print",ExpressionUUID->"67784906-4798-48d0-9c6e-b6cb69ce9add"],
Cell[147643, 4051, 961, 25, 44, "Print",ExpressionUUID->"868030fb-ea69-4961-873b-4783b3c4590b"],
Cell[148607, 4078, 1145, 30, 44, "Print",ExpressionUUID->"4b51ef65-01bb-4611-b335-569181a673ea"],
Cell[149755, 4110, 1010, 26, 44, "Print",ExpressionUUID->"0e1dcd42-0ec3-48f7-a16d-04345ac98726"],
Cell[150768, 4138, 1118, 30, 44, "Print",ExpressionUUID->"146c5b5e-d7da-45c6-a76b-192f4c4a61d8"],
Cell[151889, 4170, 1118, 30, 44, "Print",ExpressionUUID->"8787b3c4-fe98-4efc-a207-0a89c85459c0"],
Cell[153010, 4202, 961, 25, 44, "Print",ExpressionUUID->"d5292d98-3687-4077-83c1-d5a202b93c2c"],
Cell[153974, 4229, 1036, 26, 44, "Print",ExpressionUUID->"192ef5e9-25ca-4947-b4b8-7597c9a6a7a3"],
Cell[155013, 4257, 1008, 26, 44, "Print",ExpressionUUID->"e32e2ba4-dec1-43e9-8cbd-7c71e22a5639"],
Cell[156024, 4285, 1010, 26, 44, "Print",ExpressionUUID->"af188ccc-30db-4238-9c8c-84dd9b8b419a"],
Cell[157037, 4313, 1011, 26, 44, "Print",ExpressionUUID->"2027e80b-50ad-4206-93f9-04db19a1c23f"],
Cell[158051, 4341, 1183, 33, 44, "Print",ExpressionUUID->"6491b292-6c3b-4594-80ff-c619d72cddf9"],
Cell[159237, 4376, 1187, 33, 44, "Print",ExpressionUUID->"a10cca9a-3855-4dd3-a6c0-5ce92857a7a6"],
Cell[160427, 4411, 958, 25, 44, "Print",ExpressionUUID->"fd04ae85-181e-4e42-a6a2-b64ca9588bf7"],
Cell[161388, 4438, 961, 25, 44, "Print",ExpressionUUID->"f0ba9502-2b0a-40f6-85fb-dba46b185766"],
Cell[162352, 4465, 1145, 30, 44, "Print",ExpressionUUID->"7e80e579-f26d-405b-b995-b384456ebd9a"],
Cell[163500, 4497, 1143, 30, 44, "Print",ExpressionUUID->"95de1b72-14f6-4aa9-878b-628ab73d64f9"],
Cell[164646, 4529, 1147, 30, 44, "Print",ExpressionUUID->"bdc31783-c7e1-43bc-9497-cb647780d254"],
Cell[165796, 4561, 1005, 26, 44, "Print",ExpressionUUID->"7cc6c5ee-07e1-4543-bd25-90c351301438"],
Cell[166804, 4589, 1068, 29, 44, "Print",ExpressionUUID->"43d57044-4eb2-4902-ab11-5020d650cc44"],
Cell[167875, 4620, 1063, 29, 44, "Print",ExpressionUUID->"3b844676-424f-4002-99ca-c2a3e6141c1a"],
Cell[168941, 4651, 1253, 35, 44, "Print",ExpressionUUID->"976f6093-2538-4427-a5c6-b10f47c869fa"],
Cell[170197, 4688, 1142, 30, 44, "Print",ExpressionUUID->"aa72bc00-b80a-4518-884e-ae9a603687a4"],
Cell[171342, 4720, 1146, 30, 44, "Print",ExpressionUUID->"3077ea1a-93b4-43aa-9e8f-cebb3f0ead6b"],
Cell[172491, 4752, 1068, 29, 44, "Print",ExpressionUUID->"d67ef3f7-11d4-45b9-91de-c62730f6bc39"],
Cell[173562, 4783, 1068, 29, 44, "Print",ExpressionUUID->"b85c5f21-5fa7-4eee-9d1a-d2ec31ea318a"],
Cell[174633, 4814, 1256, 35, 44, "Print",ExpressionUUID->"9483223a-0195-478b-9a47-ade370f2de37"],
Cell[175892, 4851, 1255, 35, 44, "Print",ExpressionUUID->"1e95855a-2054-4e9d-8b99-660eadb119b7"],
Cell[177150, 4888, 1259, 35, 44, "Print",ExpressionUUID->"2f8ab98c-a16e-4fae-85ef-ca995ffa9d2c"],
Cell[178412, 4925, 3752, 92, 44, "Print",ExpressionUUID->"921c4a93-2f66-4416-807a-659d78a2582d"],
Cell[182167, 5019, 1010, 26, 44, "Print",ExpressionUUID->"a8612812-532f-44d3-b44d-4446d86dae33"],
Cell[183180, 5047, 1010, 26, 44, "Print",ExpressionUUID->"9429aaf1-dae0-486b-a69a-3c40390f4c78"],
Cell[184193, 5075, 1012, 26, 44, "Print",ExpressionUUID->"2afc3d24-cf0e-41d3-9529-576d36f70f83"],
Cell[185208, 5103, 1010, 26, 44, "Print",ExpressionUUID->"4689ea5f-591e-4063-819c-76c3eca80e9c"],
Cell[186221, 5131, 1010, 26, 44, "Print",ExpressionUUID->"30055419-8f1c-46be-874b-b2f23a748dc2"],
Cell[187234, 5159, 1014, 26, 44, "Print",ExpressionUUID->"ddb2d778-e583-4af1-a26b-598cb8b2e3a8"],
Cell[188251, 5187, 1036, 26, 44, "Print",ExpressionUUID->"b9f63e4d-2c40-4d0d-af11-7510fd74bbe3"],
Cell[189290, 5215, 1038, 26, 44, "Print",ExpressionUUID->"d77fc2e4-69e9-4dd6-af89-629c0f59cdd7"],
Cell[190331, 5243, 1150, 29, 44, "Print",ExpressionUUID->"fa30c17a-c408-4611-94cb-e32bf2f080ab"],
Cell[191484, 5274, 1010, 26, 44, "Print",ExpressionUUID->"5dffbe0d-dc4e-46e8-8584-6e3fbbe2f142"],
Cell[192497, 5302, 1010, 26, 44, "Print",ExpressionUUID->"9c363fa5-9748-458d-b702-d3d752376e19"],
Cell[193510, 5330, 1009, 26, 44, "Print",ExpressionUUID->"6f06873f-d8f2-427d-b795-a4c5b5a37942"],
Cell[194522, 5358, 1010, 26, 44, "Print",ExpressionUUID->"75e1d635-1828-404b-948d-4472d63df599"],
Cell[195535, 5386, 1010, 26, 44, "Print",ExpressionUUID->"995d1c06-ff84-4290-b0e5-a454bfaace03"],
Cell[196548, 5414, 1012, 26, 44, "Print",ExpressionUUID->"29ab94ca-3baf-4e23-8ca6-3eada5e25e4e"],
Cell[197563, 5442, 1183, 33, 44, "Print",ExpressionUUID->"c832d446-ff44-48ac-b92f-74bfd92e8714"],
Cell[198749, 5477, 1183, 33, 44, "Print",ExpressionUUID->"aa547a77-5509-444c-9503-0b96edfef98f"],
Cell[199935, 5512, 1066, 29, 44, "Print",ExpressionUUID->"3a9fc437-a7fb-424a-89ca-153939d7837a"],
Cell[201004, 5543, 1065, 29, 44, "Print",ExpressionUUID->"96371745-1444-43fe-b06b-3c5930eceae3"],
Cell[202072, 5574, 1145, 30, 44, "Print",ExpressionUUID->"fa2ac647-5147-4fa2-aee8-d694bd490033"],
Cell[203220, 5606, 1143, 30, 44, "Print",ExpressionUUID->"f08e712f-43a2-45ff-8fee-b002ec27f961"],
Cell[204366, 5638, 1145, 30, 44, "Print",ExpressionUUID->"96e6f363-857e-43b5-bc49-9929e387f249"],
Cell[205514, 5670, 1006, 26, 44, "Print",ExpressionUUID->"54e9df8d-388a-4915-8a37-71d5e782da7a"],
Cell[206523, 5698, 959, 25, 44, "Print",ExpressionUUID->"cfc31074-bdd5-4214-bd71-65ddcf8ed054"],
Cell[207485, 5725, 959, 25, 44, "Print",ExpressionUUID->"12a65966-4da8-4085-96bc-e3125bcde2ab"],
Cell[208447, 5752, 1145, 30, 44, "Print",ExpressionUUID->"12dcdc67-a8f5-4f43-9a40-90e98afd26dd"],
Cell[209595, 5784, 1035, 26, 44, "Print",ExpressionUUID->"3aa9b342-e393-41e9-9b10-bf12b42a9fc0"],
Cell[210633, 5812, 1038, 26, 44, "Print",ExpressionUUID->"d86bfde7-8088-486d-88b0-bd8d3f0faf36"],
Cell[211674, 5840, 959, 25, 44, "Print",ExpressionUUID->"3f0d1475-a14f-437a-bd99-ac0709ab36cb"],
Cell[212636, 5867, 959, 25, 44, "Print",ExpressionUUID->"4e70a7f4-ded0-4904-8a0d-01b6fbf3b89c"],
Cell[213598, 5894, 1143, 30, 44, "Print",ExpressionUUID->"2d429bc4-a849-4cde-9ad2-12fef1344199"],
Cell[214744, 5926, 1036, 26, 44, "Print",ExpressionUUID->"8f483907-aa6d-48e0-bac5-64faa03d62cd"],
Cell[215783, 5954, 1038, 26, 44, "Print",ExpressionUUID->"f0e9c323-a8e1-442e-ae0f-f7c7c548018f"],
Cell[216824, 5982, 1010, 26, 44, "Print",ExpressionUUID->"ca4f6552-aa97-4c46-b590-ef614220b2b2"],
Cell[217837, 6010, 4286, 101, 44, "Print",ExpressionUUID->"c701d5fa-ba27-4364-a21c-d9ff7dd83220"],
Cell[222126, 6113, 3576, 89, 44, "Print",ExpressionUUID->"7f87a0be-aae1-4a29-8128-62176021a5a1"],
Cell[225705, 6204, 1010, 26, 44, "Print",ExpressionUUID->"c39a9b43-7ef4-47ed-a5f3-efff8b78d843"],
Cell[226718, 6232, 1010, 26, 44, "Print",ExpressionUUID->"5dc3cb0f-48b1-47b1-93d6-0a57083eb208"],
Cell[227731, 6260, 1014, 26, 44, "Print",ExpressionUUID->"58aecd47-1d12-4e87-bcd7-066e133f7639"],
Cell[228748, 6288, 1036, 26, 44, "Print",ExpressionUUID->"6499e1ee-639f-4427-8555-22408913f0d0"],
Cell[229787, 6316, 1038, 26, 44, "Print",ExpressionUUID->"aca26bc3-4a12-4344-b91a-94f519baa06c"],
Cell[230828, 6344, 1320, 37, 44, "Print",ExpressionUUID->"b74e0616-abe1-4312-b812-c76cff7d56eb"],
Cell[232151, 6383, 1292, 36, 44, "Print",ExpressionUUID->"d104d07e-6e64-4873-a496-c68fd4013f20"],
Cell[233446, 6421, 1224, 33, 44, "Print",ExpressionUUID->"8d99df26-eed0-4289-ba25-3259699c16e0"],
Cell[234673, 6456, 1066, 29, 44, "Print",ExpressionUUID->"af935071-41e8-4035-8fd9-aefadb81dba6"],
Cell[235742, 6487, 1578, 48, 44, "Print",ExpressionUUID->"e692dacf-f673-4eae-8577-d995756bb9d8"],
Cell[237323, 6537, 1116, 30, 44, "Print",ExpressionUUID->"ab208a78-4f83-4232-b800-8f382b5db560"],
Cell[238442, 6569, 1273, 36, 44, "Print",ExpressionUUID->"f8b6f639-7c3e-432f-98d1-606d63e24206"],
Cell[239718, 6607, 1118, 30, 44, "Print",ExpressionUUID->"bf3f02be-b67e-4e57-9381-ec753a8c33f3"],
Cell[240839, 6639, 958, 25, 44, "Print",ExpressionUUID->"e4806b6f-8e44-4ea9-9908-8ac8ffe13df0"],
Cell[241800, 6666, 1671, 50, 44, "Print",ExpressionUUID->"050d982c-a7a6-4e08-a1ae-80a0bf4e1841"],
Cell[243474, 6718, 1255, 35, 44, "Print",ExpressionUUID->"d0b85af6-7df0-4f11-a667-0eb3e8ab62a0"],
Cell[244732, 6755, 1598, 48, 44, "Print",ExpressionUUID->"25bfd086-dc58-4147-85b4-ee5973fa9bd0"],
Cell[246333, 6805, 1066, 29, 44, "Print",ExpressionUUID->"5e28c69d-ec4c-43ad-900d-19ec63b8bd0f"],
Cell[247402, 6836, 959, 25, 44, "Print",ExpressionUUID->"a9688c2d-bfa2-48d6-a990-50aebf90a10d"],
Cell[248364, 6863, 6688, 146, 47, "Print",ExpressionUUID->"150c7217-85e0-4db2-ba81-0113080c0dca"],
Cell[255055, 7011, 1066, 29, 44, "Print",ExpressionUUID->"bf07e69a-30d7-493e-8bd7-e9b8966b1b05"],
Cell[256124, 7042, 959, 25, 44, "Print",ExpressionUUID->"7c509b7a-fcf3-4b0b-891d-f956f6941ffd"],
Cell[257086, 7069, 961, 25, 44, "Print",ExpressionUUID->"93e4b760-2bde-46a7-bf37-d90081f4044d"],
Cell[258050, 7096, 1116, 30, 44, "Print",ExpressionUUID->"00dd4e9d-622d-4329-9bb6-02df9ef8223f"],
Cell[259169, 7128, 1116, 30, 44, "Print",ExpressionUUID->"8f6ffdd5-4668-4245-91d1-7ea8eb32c38a"],
Cell[260288, 7160, 1121, 30, 44, "Print",ExpressionUUID->"ad5f94e6-3a2c-4021-80be-192fbfef7f1f"],
Cell[261412, 7192, 1036, 26, 44, "Print",ExpressionUUID->"94799129-d9b9-46ee-b90a-d22c489dfd80"],
Cell[262451, 7220, 1254, 33, 44, "Print",ExpressionUUID->"780feb94-1cc5-480d-9b14-941e230016bc"],
Cell[263708, 7255, 1148, 30, 44, "Print",ExpressionUUID->"d2367351-7132-4fcd-87db-83612584f92c"],
Cell[264859, 7287, 1118, 30, 44, "Print",ExpressionUUID->"6acb06f8-3504-49a8-b5ab-442555445832"],
Cell[265980, 7319, 1541, 46, 44, "Print",ExpressionUUID->"92619acf-3ca0-499e-90b5-247362505b08"],
Cell[267524, 7367, 1010, 26, 44, "Print",ExpressionUUID->"3994bff2-517b-4797-93c3-d39be01034e8"],
Cell[268537, 7395, 1116, 30, 44, "Print",ExpressionUUID->"6d330095-08c7-4caf-a023-81eea6d3d9ff"],
Cell[269656, 7427, 1116, 30, 44, "Print",ExpressionUUID->"78493c28-2f23-44bd-be84-a2df219c9e1c"],
Cell[270775, 7459, 1118, 30, 44, "Print",ExpressionUUID->"db17d588-26de-4b62-b9e1-81f3507ab127"],
Cell[271896, 7491, 1116, 30, 44, "Print",ExpressionUUID->"18c4f1a3-4145-435d-83ae-0e029dea94b1"],
Cell[273015, 7523, 959, 25, 44, "Print",ExpressionUUID->"30eda4c6-021a-414e-b6f3-37ae3b50f25a"],
Cell[273977, 7550, 1253, 35, 44, "Print",ExpressionUUID->"92a35fd4-1b25-44f2-890c-6853216659c6"],
Cell[275233, 7587, 1185, 33, 44, "Print",ExpressionUUID->"2146c8c4-edea-422f-918e-5365a4cecd73"],
Cell[276421, 7622, 1259, 35, 44, "Print",ExpressionUUID->"748d123d-a67d-4978-9a5a-67a26b10681d"],
Cell[277683, 7659, 1066, 29, 44, "Print",ExpressionUUID->"c28f108a-666b-4ac5-b1bd-d846ded656bb"],
Cell[278752, 7690, 961, 25, 44, "Print",ExpressionUUID->"b7e48059-7c05-4f34-9bdc-ae81bee8ab5a"],
Cell[279716, 7717, 8983, 181, 47, "Print",ExpressionUUID->"935e461e-2cd6-44f6-a204-b833e4074453"],
Cell[288702, 7900, 1068, 29, 44, "Print",ExpressionUUID->"d3ab5ed2-a48a-432b-a051-9c11b74006ea"],
Cell[289773, 7931, 959, 25, 44, "Print",ExpressionUUID->"2742917a-0264-4e86-8121-4fe922a24534"],
Cell[290735, 7958, 961, 25, 44, "Print",ExpressionUUID->"fff16cab-786f-4109-9e5e-fcc19e70ee7a"],
Cell[291699, 7985, 957, 25, 44, "Print",ExpressionUUID->"8c39d62c-866e-4b25-ba4b-141903ed7d4e"],
Cell[292659, 8012, 1118, 30, 44, "Print",ExpressionUUID->"82540269-1d9e-4889-bfe3-60b7463e9c16"],
Cell[293780, 8044, 1115, 30, 44, "Print",ExpressionUUID->"78a65ea7-71d8-4c50-8cbb-2b0b4cef3449"],
Cell[294898, 8076, 1121, 30, 44, "Print",ExpressionUUID->"586ad4cb-fb62-4dc2-87d0-6d9332cb4c3e"],
Cell[296022, 8108, 1036, 26, 44, "Print",ExpressionUUID->"c57af016-a729-4e23-993a-14cc62394249"],
Cell[297061, 8136, 1147, 30, 44, "Print",ExpressionUUID->"ac6dc55b-bbe4-40ff-a169-255446c8656a"],
Cell[298211, 8168, 1146, 30, 44, "Print",ExpressionUUID->"4d79ceb6-da31-4bd1-a052-ac881e3f3196"],
Cell[299360, 8200, 1182, 33, 44, "Print",ExpressionUUID->"a59a6dee-65a5-479d-b8d8-71ba124fadc2"],
Cell[300545, 8235, 1010, 26, 44, "Print",ExpressionUUID->"076241cf-9329-4629-b5b6-4811b797d05a"],
Cell[301558, 8263, 1118, 30, 44, "Print",ExpressionUUID->"90d2a020-2fdb-4021-a8d2-0d98a5e4080c"],
Cell[302679, 8295, 1582, 45, 44, "Print",ExpressionUUID->"253c3fb5-b565-47c3-bbe9-2283c91a7a31"],
Cell[304264, 8342, 1143, 30, 44, "Print",ExpressionUUID->"60212665-5112-4544-b062-e91f0576882a"],
Cell[305410, 8374, 959, 25, 44, "Print",ExpressionUUID->"f3390c88-b34f-463c-b61b-85f5786a4fcf"],
Cell[306372, 8401, 1008, 26, 44, "Print",ExpressionUUID->"bb50f199-c775-4902-88ab-1965aecdcc3b"],
Cell[307383, 8429, 1116, 30, 44, "Print",ExpressionUUID->"1283c426-67c6-4b9c-8cd5-d970f2819c0e"],
Cell[308502, 8461, 1120, 30, 44, "Print",ExpressionUUID->"68a03a25-c7cd-4547-9505-bc4321f5e062"],
Cell[309625, 8493, 1772, 52, 44, "Print",ExpressionUUID->"b26afe2c-949e-459f-8856-c418cd061af2"],
Cell[311400, 8547, 1253, 35, 44, "Print",ExpressionUUID->"53e97b6c-be33-427e-842e-7b0e0d2a7d5d"],
Cell[312656, 8584, 1068, 29, 44, "Print",ExpressionUUID->"ede7eee5-6d4f-43ac-bffc-0d6467220380"],
Cell[313727, 8615, 1191, 33, 44, "Print",ExpressionUUID->"4376630c-f037-4adb-bc1e-7d807f55aadf"],
Cell[314921, 8650, 1116, 30, 44, "Print",ExpressionUUID->"d35c11b4-cb10-447e-baa0-3dcb72df8a13"],
Cell[316040, 8682, 1012, 26, 44, "Print",ExpressionUUID->"eeaa1f24-f7a1-4c86-81b7-29745c57a4a1"],
Cell[317055, 8710, 1147, 30, 44, "Print",ExpressionUUID->"714a4fd5-399e-472e-918d-684b9ebc366d"],
Cell[318205, 8742, 959, 25, 44, "Print",ExpressionUUID->"6a478cf5-566c-458c-9578-3015289ad9de"],
Cell[319167, 8769, 959, 25, 44, "Print",ExpressionUUID->"541d1d17-633e-4535-a6df-f73bf0206105"],
Cell[320129, 8796, 959, 25, 44, "Print",ExpressionUUID->"e53d2db5-fcba-4e02-8186-717b5439952c"],
Cell[321091, 8823, 961, 25, 44, "Print",ExpressionUUID->"40dbbe52-3bb2-4420-b923-e8e779424465"],
Cell[322055, 8850, 3745, 91, 44, "Print",ExpressionUUID->"67abce39-81ee-4890-a44c-450144bea6dd"],
Cell[325803, 8943, 1472, 42, 44, "Print",ExpressionUUID->"4c4d5317-0725-4ae2-be18-6d95d98d388e"],
Cell[327278, 8987, 1066, 29, 44, "Print",ExpressionUUID->"deb0f33e-ebc4-4f44-9c7b-cd0301482264"],
Cell[328347, 9018, 1067, 29, 44, "Print",ExpressionUUID->"1a039b69-e353-4eb8-be11-a6471d358ecc"],
Cell[329417, 9049, 1257, 35, 44, "Print",ExpressionUUID->"43919338-69f6-45f1-9fc0-7bfd605e9dc8"],
Cell[330677, 9086, 961, 25, 44, "Print",ExpressionUUID->"cc2150d0-d495-4693-94c6-44cd8154d96d"],
Cell[331641, 9113, 1336, 37, 45, "Print",ExpressionUUID->"02fdf615-b848-4e6c-87b2-d4e3183a5101"],
Cell[332980, 9152, 959, 25, 44, "Print",ExpressionUUID->"db325903-5357-4b97-b782-062116ccf495"],
Cell[333942, 9179, 1042, 26, 44, "Print",ExpressionUUID->"a87fe0fe-1d07-4fd6-886a-6d3be332a18e"],
Cell[334987, 9207, 1012, 26, 44, "Print",ExpressionUUID->"a6422f3c-5105-4ce7-a39c-e57758996160"],
Cell[336002, 9235, 1143, 30, 44, "Print",ExpressionUUID->"ae8f9896-98b9-41df-913e-11b6fbe3286d"],
Cell[337148, 9267, 1012, 26, 44, "Print",ExpressionUUID->"fdaf42d9-94b9-4415-84ed-e0f0d606329f"],
Cell[338163, 9295, 1010, 26, 44, "Print",ExpressionUUID->"b09e46a2-0455-461e-bab2-d0c9153062ee"],
Cell[339176, 9323, 1145, 30, 44, "Print",ExpressionUUID->"cfbcccee-ccf6-415d-a7aa-c6e5bd6a467c"],
Cell[340324, 9355, 1145, 30, 44, "Print",ExpressionUUID->"ae643f2d-29ac-4a56-825a-67b14c1aa97a"],
Cell[341472, 9387, 959, 25, 44, "Print",ExpressionUUID->"c851d157-eb56-4c69-98d2-5f6931f6a366"],
Cell[342434, 9414, 961, 25, 44, "Print",ExpressionUUID->"9ba91d02-736e-4265-bb28-3301fea865e5"],
Cell[343398, 9441, 1118, 30, 44, "Print",ExpressionUUID->"55332941-47b9-42c2-85e6-4430aa50ab32"],
Cell[344519, 9473, 1118, 30, 44, "Print",ExpressionUUID->"5e26e83d-bdf9-4247-8263-1cac725be797"],
Cell[345640, 9505, 1255, 35, 44, "Print",ExpressionUUID->"f0a50331-25fc-4ab6-96e2-dfa240f2522a"],
Cell[346898, 9542, 1183, 33, 44, "Print",ExpressionUUID->"904eac05-0ef6-448d-a266-6dcfb319cfbc"],
Cell[348084, 9577, 1065, 29, 44, "Print",ExpressionUUID->"d8f2d963-2b68-4c4f-b748-00a5fd006499"],
Cell[349152, 9608, 1070, 29, 44, "Print",ExpressionUUID->"0c77cbb4-f94e-4141-838c-9d34698c5e11"],
Cell[350225, 9639, 1118, 30, 44, "Print",ExpressionUUID->"d726749e-c5d8-4fdf-beb1-f1647c6468c4"],
Cell[351346, 9671, 1012, 26, 44, "Print",ExpressionUUID->"d53def64-add0-4cf8-b50e-2877c9d8de18"],
Cell[352361, 9699, 961, 25, 44, "Print",ExpressionUUID->"06c7db1b-b7c5-438f-b4d5-9663cf0bdbe3"],
Cell[353325, 9726, 1038, 26, 44, "Print",ExpressionUUID->"04b9ac74-edff-494f-9add-d0d05feb98e9"],
Cell[354366, 9754, 959, 25, 44, "Print",ExpressionUUID->"eb87f9d1-577a-4e70-8f01-345cb33eb943"],
Cell[355328, 9781, 959, 25, 44, "Print",ExpressionUUID->"2dbfa644-38f7-413b-a178-0ffaecd97105"],
Cell[356290, 9808, 959, 25, 44, "Print",ExpressionUUID->"405ed658-d729-483e-852d-386ae29a5099"],
Cell[357252, 9835, 968, 25, 44, "Print",ExpressionUUID->"0d86959e-09cc-4c95-964b-d9a9fdffcc17"],
Cell[358223, 9862, 4240, 101, 44, "Print",ExpressionUUID->"691b126c-cc8f-45e6-a3fc-c3bfb40faa6c"],
Cell[362466, 9965, 1066, 29, 44, "Print",ExpressionUUID->"1a7592c8-23ad-43de-8717-922ef6302220"],
Cell[363535, 9996, 1066, 29, 44, "Print",ExpressionUUID->"1409acaf-a65b-489c-a533-7fcdff0c4035"],
Cell[364604, 10027, 1301, 37, 44, "Print",ExpressionUUID->"3ea8ee6a-a91d-4085-87c9-602d863cdd2a"],
Cell[365908, 10066, 1255, 35, 44, "Print",ExpressionUUID->"3b491141-e125-46af-b6ae-3db17058dd29"],
Cell[367166, 10103, 959, 25, 44, "Print",ExpressionUUID->"29a86f6d-994f-4537-8a6d-abac491d1bdf"],
Cell[368128, 10130, 1070, 29, 44, "Print",ExpressionUUID->"77f5b8f7-2dd2-4422-be75-bc865db944cf"],
Cell[369201, 10161, 961, 25, 44, "Print",ExpressionUUID->"af3dc165-9fdf-4617-8bc2-ba9c39f22432"],
Cell[370165, 10188, 965, 25, 44, "Print",ExpressionUUID->"e69ab432-dfd4-4f0b-ad5c-65884478946a"],
Cell[371133, 10215, 1012, 26, 44, "Print",ExpressionUUID->"6af83043-8a40-47c8-a556-06924fc7cc84"],
Cell[372148, 10243, 1016, 26, 44, "Print",ExpressionUUID->"56738bb0-1ff6-496e-a190-11775de31834"],
Cell[373167, 10271, 1016, 26, 44, "Print",ExpressionUUID->"5bce5b70-e050-4ae7-913f-fd10112df99f"],
Cell[374186, 10299, 1256, 33, 44, "Print",ExpressionUUID->"ff7de196-c9d8-41b3-9407-e11ca0ea96b1"],
Cell[375445, 10334, 1151, 30, 44, "Print",ExpressionUUID->"32fcd5ba-a32b-41f6-95d7-edeb0bbd3a03"],
Cell[376599, 10366, 1012, 26, 44, "Print",ExpressionUUID->"8da9b6bb-8af4-4f90-8bb0-8aaaf55e16bf"],
Cell[377614, 10394, 967, 25, 44, "Print",ExpressionUUID->"71c2ebce-6c52-4efe-96a0-be95b9ff133a"],
Cell[378584, 10421, 1121, 30, 44, "Print",ExpressionUUID->"4670874d-cca8-4c1d-be30-b62e80f9b423"],
Cell[379708, 10453, 1122, 30, 44, "Print",ExpressionUUID->"390ea5af-3056-4e64-9007-67a6e8c7d39a"],
Cell[380833, 10485, 1593, 45, 44, "Print",ExpressionUUID->"55264266-62b7-45f3-88c6-60b6f0acdee7"],
Cell[382429, 10532, 1263, 35, 44, "Print",ExpressionUUID->"9bf0423f-d49f-4b49-834b-7125d0c350d3"],
Cell[383695, 10569, 1189, 33, 44, "Print",ExpressionUUID->"e86a7364-aabe-41e0-adf4-3346c9f93954"],
Cell[384887, 10604, 1072, 29, 44, "Print",ExpressionUUID->"c9e7cf45-f477-431d-b557-de602e0d2324"],
Cell[385962, 10635, 1124, 30, 44, "Print",ExpressionUUID->"6d0dfb1c-f3b2-4d4f-af64-09937009bad6"],
Cell[387089, 10667, 1018, 26, 44, "Print",ExpressionUUID->"2d12c270-97f5-4b8a-a2b2-f8922a44a291"],
Cell[388110, 10695, 967, 25, 44, "Print",ExpressionUUID->"67ea9e11-609b-43a5-b322-62482638de68"],
Cell[389080, 10722, 1044, 26, 44, "Print",ExpressionUUID->"6c87dec6-eeb5-4f55-8bc0-6c15a819ba21"],
Cell[390127, 10750, 967, 25, 44, "Print",ExpressionUUID->"848e7f7d-43a7-4f9b-8339-0b6325771962"],
Cell[391097, 10777, 965, 25, 44, "Print",ExpressionUUID->"53b1cc9c-1e63-49be-8d56-78c7ecb6c0bb"],
Cell[392065, 10804, 967, 25, 44, "Print",ExpressionUUID->"28d2f05c-11fd-48fc-b5d4-a18cbb814ff2"],
Cell[393035, 10831, 967, 25, 44, "Print",ExpressionUUID->"4f728767-e4c4-495d-9c70-26bffa4b8a24"],
Cell[394005, 10858, 3631, 88, 44, "Print",ExpressionUUID->"4d33bd7a-c3c0-4bec-912c-d0eccbfdd8f1"],
Cell[397639, 10948, 1072, 29, 44, "Print",ExpressionUUID->"4ca762bd-76a9-4ea0-80d6-00cd96ac2d34"],
Cell[398714, 10979, 1074, 29, 44, "Print",ExpressionUUID->"14d7cc58-0924-46d8-9d31-0fd40765fa2e"],
Cell[399791, 11010, 1305, 37, 44, "Print",ExpressionUUID->"aeba8250-b64f-4745-8b96-0133411cf68b"],
Cell[401099, 11049, 1267, 35, 44, "Print",ExpressionUUID->"280d39b6-6b9b-4f8d-a073-837b6a9ecf39"],
Cell[402369, 11086, 1323, 37, 45, "Print",ExpressionUUID->"e84c3da2-1485-4937-a9e8-df99f4080bbc"],
Cell[403695, 11125, 1074, 29, 44, "Print",ExpressionUUID->"2045703d-c00c-422a-9800-63c6f25f3e7c"],
Cell[404772, 11156, 1042, 26, 44, "Print",ExpressionUUID->"54efad8f-be66-4278-97b7-52862727511e"],
Cell[405817, 11184, 964, 25, 44, "Print",ExpressionUUID->"963af264-9530-4dc7-a1b1-542d78da38b4"],
Cell[406784, 11211, 965, 25, 44, "Print",ExpressionUUID->"bccd7c52-7c66-4ab6-b7df-7c0db6b714e5"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[407798, 11242, 480, 13, 30, "Input",ExpressionUUID->"9f6090b0-7c00-427c-8074-7d2b9ee85844"],
Cell[408281, 11257, 2257, 55, 42, "Output",ExpressionUUID->"0693d4a4-201d-4453-ab14-8a527a4a5abb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[410575, 11317, 269, 6, 30, "Input",ExpressionUUID->"1be46a77-2e6e-4e33-9247-0ff38235e73a"],
Cell[410847, 11325, 1047, 27, 41, "Output",ExpressionUUID->"9f8fada5-1b54-40d3-a3c1-cf2315c9fd0c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[411931, 11357, 221, 4, 30, "Input",ExpressionUUID->"432c13e9-7dec-45fb-9c0b-d8031caebb08"],
Cell[412155, 11363, 663, 10, 34, "Output",ExpressionUUID->"6029777d-0805-4c4c-82a8-ad752bc51826"]
}, Open  ]],
Cell[CellGroupData[{
Cell[412855, 11378, 575, 16, 33, "Input",ExpressionUUID->"8f243d0d-25c4-47fa-bc93-2d1299329aff"],
Cell[413433, 11396, 829, 20, 56, "Output",ExpressionUUID->"b6a31f78-eda4-47aa-9b74-a6957cc37677"]
}, Open  ]],
Cell[CellGroupData[{
Cell[414299, 11421, 504, 13, 30, "Input",ExpressionUUID->"5f5e5b68-4802-4f9e-b1c3-95e793723e60"],
Cell[414806, 11436, 2241, 54, 42, "Output",ExpressionUUID->"1f0d4abb-65ff-4b75-be58-d6fd70328b70"]
}, Open  ]],
Cell[CellGroupData[{
Cell[417084, 11495, 203, 5, 30, "Input",ExpressionUUID->"a3720173-1b83-4e31-aa5a-d9c83117d135"],
Cell[417290, 11502, 1046, 27, 41, "Output",ExpressionUUID->"651af737-c2f3-4917-a7d3-d3eb4191d457"]
}, Open  ]],
Cell[CellGroupData[{
Cell[418373, 11534, 155, 3, 30, "Input",ExpressionUUID->"960b6403-4ad6-47a9-a8c2-8e3e575349ba"],
Cell[418531, 11539, 682, 10, 56, "Output",ExpressionUUID->"81d7852e-156b-4464-b826-81ef6d70c70a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[419250, 11554, 508, 13, 30, "Input",ExpressionUUID->"ba4423ad-c1eb-492f-a563-5e03b597d2c6"],
Cell[419761, 11569, 1897, 47, 42, "Output",ExpressionUUID->"88340661-a10a-409b-82d4-5a3653a1ec16"]
}, Open  ]],
Cell[CellGroupData[{
Cell[421695, 11621, 322, 7, 30, "Input",ExpressionUUID->"a548406f-a022-4ed8-b597-51f910769cec"],
Cell[422020, 11630, 978, 25, 41, "Output",ExpressionUUID->"016155a6-f214-4e5d-8b30-cc5472532a00"]
}, Open  ]],
Cell[CellGroupData[{
Cell[423035, 11660, 223, 4, 30, "Input",ExpressionUUID->"8cd519d1-d61e-49ec-a26f-c334320b3c31"],
Cell[423261, 11666, 598, 8, 34, "Output",ExpressionUUID->"c9e91345-de31-421f-858d-f0a60b6ad6d6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[423896, 11679, 504, 13, 30, "Input",ExpressionUUID->"afd9bfde-53a2-4b50-8578-1c70a4e3a5ad"],
Cell[424403, 11694, 2251, 54, 42, "Output",ExpressionUUID->"1b1db75a-f675-444c-8227-61f9611bca77"]
}, Open  ]],
Cell[CellGroupData[{
Cell[426691, 11753, 203, 5, 30, "Input",ExpressionUUID->"609bb25e-552c-4561-8d1c-f8c87f651203"],
Cell[426897, 11760, 1042, 27, 41, "Output",ExpressionUUID->"dd9ef930-ba7a-4cbc-83c8-af22d02e6476"]
}, Open  ]],
Cell[CellGroupData[{
Cell[427976, 11792, 155, 3, 30, "Input",ExpressionUUID->"7ecc472d-1170-4ad3-82a3-ef268d471607"],
Cell[428134, 11797, 672, 10, 34, "Output",ExpressionUUID->"1a607fac-5488-4656-8ef9-60cc764f8433"]
}, Open  ]],
Cell[CellGroupData[{
Cell[428843, 11812, 507, 13, 30, "Input",ExpressionUUID->"419ae364-60ed-42fb-aa86-3ecab1cb0ca5"],
Cell[429353, 11827, 1759, 45, 42, "Output",ExpressionUUID->"0fd872ee-b40b-4b11-8f1a-51292f3dd39f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[431149, 11877, 203, 5, 30, "Input",ExpressionUUID->"911c4a36-fff9-4c56-bd08-8560b810fba7"],
Cell[431355, 11884, 877, 23, 41, "Output",ExpressionUUID->"04e32ee8-5442-448f-85d9-07e118f88825"]
}, Open  ]],
Cell[CellGroupData[{
Cell[432269, 11912, 155, 3, 30, "Input",ExpressionUUID->"c6604bd6-a16a-4961-8d71-1b876c1e9479"],
Cell[432427, 11917, 542, 8, 34, "Output",ExpressionUUID->"b9d38f7f-0a28-413f-b14e-f7c7ddc063df"]
}, Open  ]],
Cell[CellGroupData[{
Cell[433006, 11930, 506, 13, 30, "Input",ExpressionUUID->"1fdee8c7-8c10-4a6a-8d82-3ff810a3fe86"],
Cell[433515, 11945, 3411, 77, 42, "Output",ExpressionUUID->"98229cb2-049f-4ec5-9465-f70a46266101"]
}, Open  ]],
Cell[CellGroupData[{
Cell[436963, 12027, 273, 6, 30, "Input",ExpressionUUID->"0a3345c9-df4c-407f-ae37-d4d0cd4bdcd5"],
Cell[437239, 12035, 1677, 38, 58, "Output",ExpressionUUID->"59ced701-d2a4-4215-ae56-4f1dfb187a7c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[438953, 12078, 221, 4, 30, "Input",ExpressionUUID->"74c2312f-f5ec-47d3-aebb-41c71a36b633"],
Cell[439177, 12084, 2032, 30, 58, "Output",ExpressionUUID->"66fa1157-b05f-4923-ab9e-ea7a9d11166d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[441246, 12119, 275, 7, 30, "Input",ExpressionUUID->"e122f110-6f44-4496-b06a-38405a9e045d"],
Cell[441524, 12128, 876, 24, 56, "Output",ExpressionUUID->"ae84dff4-f6fe-42e6-bfbc-845f5984d2cf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[442437, 12157, 242, 5, 30, "Input",ExpressionUUID->"3e8c0c8f-8735-4d8a-9a66-074f7de7c04e"],
Cell[442682, 12164, 328, 10, 45, "Output",ExpressionUUID->"66fe6056-f78a-47df-9388-b2a919e47250"]
}, Open  ]],
Cell[CellGroupData[{
Cell[443047, 12179, 282, 7, 30, "Input",ExpressionUUID->"c300a81c-a5b6-41d7-ad82-29e413041561"],
Cell[443332, 12188, 947, 25, 56, "Output",ExpressionUUID->"b5db71d4-babc-4f85-8218-7f8f0e36839e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[444316, 12218, 506, 13, 30, "Input",ExpressionUUID->"ab35555d-d1f8-49d4-95e0-3e0068e12979"],
Cell[444825, 12233, 4629, 99, 42, "Output",ExpressionUUID->"ff5f8f3d-b7e4-4ec2-922a-cc5e313654b3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[449491, 12337, 203, 5, 30, "Input",ExpressionUUID->"d4b1d4cf-164e-4f89-9485-8bc62e794075"],
Cell[449697, 12344, 2276, 50, 58, "Output",ExpressionUUID->"09828cfc-55b8-40dd-bf0b-e18f359005f7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[452010, 12399, 210, 6, 30, "Input",ExpressionUUID->"162ea0c5-7d50-45da-a956-7a1441ada6f2"],
Cell[452223, 12407, 1197, 33, 98, "Output",ExpressionUUID->"e4c85fe1-57de-4936-9141-61a2aefffcd9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[453457, 12445, 174, 4, 30, "Input",ExpressionUUID->"9569016b-7a2a-45e5-b890-a6cd307ed759"],
Cell[453634, 12451, 305, 10, 45, "Output",ExpressionUUID->"40e045d2-68a6-494d-946c-1a8d234fc44f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[453976, 12466, 282, 7, 30, "Input",ExpressionUUID->"73f04e7d-58f1-4f33-871c-5c717763f2a4"],
Cell[454261, 12475, 1142, 31, 56, "Output",ExpressionUUID->"645343a0-48dd-4eb0-bec9-9bbc94611f39"]
}, Open  ]],
Cell[CellGroupData[{
Cell[455440, 12511, 504, 13, 30, "Input",ExpressionUUID->"fad9c5d9-e9a8-4eb7-be3a-673ac12c40ad"],
Cell[455947, 12526, 1972, 50, 42, "Output",ExpressionUUID->"57ba66e0-0e34-4c14-9cbe-9f50d59b4854"]
}, Open  ]],
Cell[CellGroupData[{
Cell[457956, 12581, 203, 5, 30, "Input",ExpressionUUID->"0b369b58-16f8-4cf5-a38a-8b35b3b0206f"],
Cell[458162, 12588, 910, 23, 41, "Output",ExpressionUUID->"9db464b8-fedf-441d-8716-883b0e159642"]
}, Open  ]],
Cell[CellGroupData[{
Cell[459109, 12616, 155, 3, 30, "Input",ExpressionUUID->"9e69df92-6f02-46a9-8c06-9855554a2d6f"],
Cell[459267, 12621, 571, 8, 34, "Output",ExpressionUUID->"f4391375-3af1-45bc-8215-83e5a4b4641f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[459875, 12634, 504, 13, 30, "Input",ExpressionUUID->"321a5acc-c821-45bd-9a25-dbe7c8a0ef86"],
Cell[460382, 12649, 2303, 55, 42, "Output",ExpressionUUID->"4642c7da-8aaf-41a9-b5b7-64f72febd97e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[462722, 12709, 203, 5, 30, "Input",ExpressionUUID->"85fcebb7-1328-4250-91ab-dfcc89c9123a"],
Cell[462928, 12716, 1020, 26, 41, "Output",ExpressionUUID->"6b3e0139-2e66-46cd-8533-df068fbee0e8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[463985, 12747, 155, 3, 30, "Input",ExpressionUUID->"4652dbca-47ba-40fe-a301-3bce83b15ef7"],
Cell[464143, 12752, 665, 10, 56, "Output",ExpressionUUID->"badaae72-f943-4516-b2bb-93e622b938d3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[464845, 12767, 508, 13, 52, "Input",ExpressionUUID->"29570f1b-cf83-4d9a-a407-68f2c2a8122d"],
Cell[465356, 12782, 1878, 48, 42, "Output",ExpressionUUID->"2865f2b8-0a08-41d3-bd54-6f1f4205da66"]
}, Open  ]],
Cell[CellGroupData[{
Cell[467271, 12835, 203, 5, 30, "Input",ExpressionUUID->"b5d9f768-e022-445e-9e09-3033f137a9ff"],
Cell[467477, 12842, 890, 23, 41, "Output",ExpressionUUID->"00d9023c-53e7-4109-8b23-48d6f186be15"]
}, Open  ]],
Cell[CellGroupData[{
Cell[468404, 12870, 155, 3, 30, "Input",ExpressionUUID->"c1b78cd3-450a-456a-99e6-d6297cdf436d"],
Cell[468562, 12875, 562, 8, 34, "Output",ExpressionUUID->"c6868918-3332-42a1-bbc6-cdc3e671e4fd"]
}, Open  ]]
}
]
*)

