(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    497712,      10934]
NotebookOptionsPosition[    483443,      10705]
NotebookOutlinePosition[    483782,      10720]
CellTagsIndexPosition[    483739,      10717]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
This Notebook contains the proofs of all the results in section 3 of the \
paper
\"Inequalities For Distances Between Triangle Centers\" by Stanley \
Rabinowitz,
submitted to the International Journal of Computer Discovered Mathematics 
(http : // www.journal - 1. eu/) on Jan. 2022.
 
This Notebook is Copyright \[Copyright] January 2022 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and is published with open access. This \
Notebook is distributed under the terms of the Creative Commons Attribution \
License which permits any use, distribution, and reproduction in any medium, \
provided the original author and the source are credited.
  
If you want to reproduce these results, you must evaluate the notebook \
\"proveTriangleInequalityUsing Blundon.nb\"
first before evaluating this notebook.\
\>", "Text",
 Evaluatable->False,
 CellChangeTimes->{{3.8517106718981447`*^9, 3.851710701258429*^9}, {
  3.851711035640792*^9, 
  3.851711101569191*^9}},ExpressionUUID->"7de05383-451a-49af-8d99-\
6224a72e56d4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ETC1", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"X1", ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X2", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X3", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X4", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"X5", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["b", "4"], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ",", 
          RowBox[{
           SuperscriptBox["a", "4"], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ",", 
          RowBox[{
           SuperscriptBox["a", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["b", "4"], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X6", ",", 
        RowBox[{"{", 
         RowBox[{
          SuperscriptBox["a", "2"], ",", 
          SuperscriptBox["b", "2"], ",", 
          SuperscriptBox["c", "2"]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X7", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "+", "c"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}]}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X8", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", "-", "b", "-", "c"}], ",", 
          RowBox[{
           RowBox[{"-", "a"}], "+", "b", "-", "c"}], ",", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "b", "+", "c"}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X9", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "-", "c"}], ")"}]}], ",", 
          RowBox[{"b", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "-", "c"}], ")"}]}], ",", 
          RowBox[{"c", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "-", "b", "+", "c"}], ")"}]}]}], "}"}]}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X10", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"b", "+", "c"}], ",", 
          RowBox[{"a", "+", "c"}], ",", 
          RowBox[{"a", "+", "b"}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X11", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "a"}], "+", "c"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "+", "c"}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "-", "b"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}]}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"X12", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"b", "+", "c"}], ")"}], "2"]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "+", "c"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "+", "b"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}]}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X13", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "+", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "+", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], "2"]}], "+", 
           SuperscriptBox["c", "4"], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "+", 
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"X14", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "+", 
              SuperscriptBox["c", "2"], "-", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "+", 
              SuperscriptBox["c", "2"], "-", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], "2"]}], "+", 
           SuperscriptBox["c", "4"], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "+", 
              SuperscriptBox["b", "2"], "-", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X15", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["a", "2"], "-", 
                SuperscriptBox["b", "2"], "-", 
                SuperscriptBox["c", "2"]}], ")"}]}], "-", 
             RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["b", "2"], "-", 
                SuperscriptBox["c", "2"], "-", 
                SuperscriptBox["a", "2"]}], ")"}]}], "-", 
             RowBox[{"2", " ", "S"}]}], ")"}]}], "\[InvisibleSpace]", ",", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["c", "2"], "-", 
                SuperscriptBox["a", "2"], "-", 
                SuperscriptBox["b", "2"]}], ")"}]}], "-", 
             RowBox[{"2", " ", "S"}]}], ")"}]}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"X16", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["a", "2"], "-", 
                SuperscriptBox["b", "2"], "-", 
                SuperscriptBox["c", "2"]}], ")"}]}], "+", 
             RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["b", "2"], "-", 
                SuperscriptBox["c", "2"], "-", 
                SuperscriptBox["a", "2"]}], ")"}]}], "+", 
             RowBox[{"2", " ", "S"}]}], ")"}]}], "\[InvisibleSpace]", ",", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["c", "2"], "-", 
                SuperscriptBox["a", "2"], "-", 
                SuperscriptBox["b", "2"]}], ")"}]}], "+", 
             RowBox[{"2", " ", "S"}]}], ")"}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X17", ",", 
        FormBox[
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "+", 
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "-", 
              SuperscriptBox["b", "2"], "+", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "+", 
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["a", "2"]}], "+", 
              SuperscriptBox["b", "2"], "+", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "-", 
              SuperscriptBox["b", "2"], "+", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["a", "2"]}], "+", 
              SuperscriptBox["b", "2"], "+", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], "}"}],
         TraditionalForm]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"X18", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", 
              SqrtBox["3"], "S"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "S"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", 
              SqrtBox["3"], "S"}]}], ")"}]}], "\[InvisibleSpace]", ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "S"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "S"}]}], ")"}]}]}], "\[InvisibleSpace]", 
         "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X19", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], ",", 
          RowBox[{"b", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], ",", 
          RowBox[{"c", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"X20", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["a", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "4"]}], ",", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "4"]}], ",", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}]}], "}"}]}], "}"}]}], 
     "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", 
     RowBox[{"i", "\[LessEqual]", "20"}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "i", "]"}], "=", 
       RowBox[{"ETC1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}]}], ";"}]}], 
    "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "to", " ", "find", " ", "the", " ", "distance", " ", 
    "between", " ", "two", " ", "points", " ", "given", " ", "in", " ", 
    "Barycentric", " ", "coordinates"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"normed", "[", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_", ",", "z_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], "/", 
    RowBox[{"(", 
     RowBox[{"x", "+", "y", "+", "z"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"squaredDistance", "[", 
     RowBox[{"p1_", ",", "p2_"}], "]"}], ":=", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Total", "[", "p2", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{"Return", "[", "Infinity", "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], "=", 
        RowBox[{
         RowBox[{"normed", "[", "p1", "]"}], "-", 
         RowBox[{"normed", "[", "p2", "]"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"a", "^", "2"}]}], "*", "y", "*", "z"}], "-", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", "z", "*", "x"}], "-", 
         RowBox[{
          RowBox[{"c", "^", "2"}], "*", "x", "*", "y"}]}], "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"distance", "[", 
    RowBox[{"i_", ",", "j_"}], "]"}], ":=", 
   RowBox[{"squaredDistance", "[", 
    RowBox[{
     RowBox[{"x", "[", "i", "]"}], ",", 
     RowBox[{"x", "[", "j", "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8273470407215*^9, 3.827347044608625*^9}, {
   3.82734774268469*^9, 3.827347843091484*^9}, {3.82734787805133*^9, 
   3.8273480057689247`*^9}, 3.827348096913745*^9, {3.851275935729549*^9, 
   3.851276047174993*^9}, {3.8516274997424707`*^9, 
   3.851627504212635*^9}},ExpressionUUID->"7b45cf9a-be39-4e62-b0a1-\
c91685b02596"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"showExpression", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"showSteps", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"showRegions", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"showCounterexample", "=", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"showConditionsForEquality", "=", "False"}], ";"}]}], "Input",
 CellChangeTimes->{{3.82446823405422*^9, 3.824468238813963*^9}, {
   3.824639364376914*^9, 3.824639366254614*^9}, {3.824639489697496*^9, 
   3.824639501047118*^9}, {3.824730489171135*^9, 3.824730550273574*^9}, 
   3.829305063612216*^9, {3.829305236004871*^9, 3.829305240731523*^9}, 
   3.851275972535203*^9, 3.851276011087577*^9, {3.8512761097907343`*^9, 
   3.851276120502899*^9}, 3.851276166790948*^9},
 CellLabel->
  "In[1278]:=",ExpressionUUID->"a5219acf-c3f7-47f0-bbf5-31f56fd927dc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Find", " ", "chains", " ", "starting", " ", "at", " ", "X", 
    RowBox[{"(", "i", ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Compares", " ", "d", 
    RowBox[{"(", 
     RowBox[{"Xi", ",", "Xj"}], ")"}], " ", "and", " ", "d", 
    RowBox[{"(", 
     RowBox[{"Xj", ",", "Xk"}], ")"}], " ", "for", " ", "all", " ", "j", " ", 
    "and", " ", "k"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"chain", "[", 
     RowBox[{"n_", ",", "max_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "i", ",", "j", ",", "truth", ",", "dni", ",", "dnj", ",", "ineq", ",", 
        "lo", ",", "hi"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"arcs", "[", "n", "]"}], "=", 
        RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "1"}], ",", 
         RowBox[{"i", "\[LessEqual]", "max"}], ",", 
         RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"i", "\[Equal]", "n"}], ",", 
            RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"dni", "=", 
           RowBox[{"distance", "[", 
            RowBox[{"n", ",", "i"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"j", "=", "1"}], ",", 
            RowBox[{"j", "\[LessEqual]", "max"}], ",", 
            RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"j", "\[Equal]", "n"}], ",", 
               RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"j", "\[Equal]", "i"}], ",", 
               RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"dnj", "=", 
              RowBox[{"distance", "[", 
               RowBox[{"n", ",", "j"}], "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"truth", "=", 
              RowBox[{"proveTriangleInequalityUsingBlundon", "[", 
               RowBox[{"dni", "<=", "dnj"}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{"truth", ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"AppendTo", "[", 
                 RowBox[{
                  RowBox[{"arcs", "[", "n", "]"}], ",", 
                  RowBox[{"i", "\[Rule]", "j"}]}], "]"}], ";"}]}], 
              "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
           "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.8512763458403482`*^9, 3.851276416263245*^9}, {
   3.85127648442415*^9, 3.851276778593697*^9}, {3.8512768365465803`*^9, 
   3.851276836889391*^9}, {3.8512768763388453`*^9, 3.851276876681353*^9}, {
   3.8512801142710876`*^9, 3.851280114997387*^9}, {3.851280237679284*^9, 
   3.851280313638425*^9}, {3.851280367320208*^9, 3.851280392094688*^9}, {
   3.851280556128396*^9, 3.851280587431807*^9}, {3.8513295506565237`*^9, 
   3.851329743687974*^9}, {3.851329872242447*^9, 3.85132987844092*^9}, 
   3.851329922858239*^9, {3.851330718405266*^9, 3.851330823548781*^9}, {
   3.851333431897079*^9, 3.851333432263167*^9}, 3.851333478409096*^9, {
   3.8513336292817*^9, 3.851333643216072*^9}, {3.8513378277466927`*^9, 
   3.851337832457458*^9}, 3.851357808429821*^9, {3.851627519063059*^9, 
   3.851627521437695*^9}, 3.851627693534721*^9, {3.851711138266552*^9, 
   3.851711143809482*^9}},ExpressionUUID->"d991614d-8b18-4a38-b6c5-\
cd3968b28cc3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"n", "=", "1"}], ",", 
    RowBox[{"n", "\[LessEqual]", "6"}], ",", 
    RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<n=\>\"", ",", "n"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"chain", "[", 
      RowBox[{"n", ",", "20"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"graph", "[", "n", "]"}], "=", 
      RowBox[{"TransitiveReductionGraph", "[", 
       RowBox[{"Graph", "[", 
        RowBox[{
         RowBox[{"arcs", "[", "n", "]"}], ",", "  ", 
         RowBox[{"VertexLabels", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{"\"\<Name\>\"", ",", "Center"}], "]"}]}], ",", 
         RowBox[{"VertexSize", "\[Rule]", "0.4"}], ",", "\[IndentingNewLine]", 
         RowBox[{"VertexStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"White", ",", 
            RowBox[{"EdgeForm", "[", 
             RowBox[{"{", 
              RowBox[{"Thick", ",", "Red", ",", 
               RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], "]"}]}], "]"}]}], 
         ",", 
         RowBox[{"EdgeStyle", "\[Rule]", "Black"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "600"}], ",", 
         RowBox[{"GraphLayout", "\[Rule]", "Automatic"}]}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"graph", "[", "n", "]"}], "]"}], ";"}]}], "\[IndentingNewLine]",
    "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.85142495712395*^9, 3.851424960731579*^9}},
 CellLabel->
  "In[466]:=",ExpressionUUID->"b5004178-20e9-4046-a664-1a3c2b64875b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["n=", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.851424962251608*^9},
 CellLabel->
  "During evaluation of \
In[466]:=",ExpressionUUID->"5dcc3300-4b73-41a2-a820-88034f6c29c9"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{2, 3, 8, 9, 10, 20, 4, 5, 6, 14, 16, 18, 19, 7, 11, 15, 12, 13, 
      17}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 1, 2, 3, 5, 6, 6, 7, 8, 13, 14, 14, 14, 15, 20, 21, 24, 30, 
          33, 36}, {{5}, {6}, {6}, {2}, {3}, {4}, {6}, {2}, {5}, {7}, {10}, {
          12}, {13}, {11}, {6}, {4}, {12}, {13}, {15}, {16}, {10}, {2}, {7}, {
          10}, {4}, {7}, {8}, {12}, {13}, {15}, {2}, {7}, {10}, {8}, {12}, {
          16}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{1., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{0., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{0., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{2., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{6., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJwtkmtIk2EARrc5p9+WbmW4+b31QywvM0VNRdL4nlCXlwoxxRhkJFreHUkS
UmoxLzMI1Azd1tLKmZdKF0QXVLAoG4iaaSVlM4ylSU3S6UyzRA88nP+Hxz2t
IDGDw2Kx9v7fhjeRYNMi0PnZsvJACQY8fAsXtUL0GI5lCXMkqFSn+U35CDE9
2Jmp65TgQLre/4XeGbV9yqggqwSTZdYijYszXlaOrxoPu6HIksjLVjihxPN2
TWazG7iPnn/y79mGXo2ZI7CjoRwIWJmxCaA06xMMuTRsAYZUjacAw5SpOHWS
xuk5hh8ZyUeOof2rFyEIjN7hVddHQd1VrTImEPySqXTWEAonuWUFslKChvm7
ijy9Iwz3q69r9ATS6IybSyJHqDvbl9+8Img9ZNxTf94BYrZJM/KFQGQe5cne
8eDZIS0xzBOkh1yJ5PvxYGyvvpW7SnBn39jEVKn9VpddCN6/gR0WfAcb+X8I
6vrVHrHlHIw/DD4rnSNQVB583Gxmo+lqaOapUYKhy+RHhJyN5L632rYugo7u
4H76MwuLcZQ9pSRwFKvCwxUslPlPNF06SjDdLUnRubCwkBWtcHAiuMh97VN1
bZ1JWosr1PfTCBKNzpxwXWd032fb5Pk0vlUk/3zQ+5cZ4oU1yuVitITVFcfE
rDL32K5DsVU7kcS+cK6Zt8L4flTGey9vh8VkN/7UtsS00tTuueNCFL0Pbalx
tzLxEdKAM+ECzE6LTN4lCwzEecO9egccoWorSoW/GWXHyNpiPRfaqGcN9WPz
DG1LeSKgOPhwQ+WaM2xhtg601cnC/ANj//E4
         "]], 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQDQESDhBawCFD+Ufe6lQJh2l32CeGzOJ3cGrSil70
QMJhX+3VJbHy/A49MtOPPCmQdCh7nGEt3c/n4PbJdnWRmJTDLt5DIb0veR0K
meX5fS5KOfT/efBhsx6vA0+A1YeChdIOX9Yf5e+P43GQuNHv97BNxuGFesFG
uUpuh2mz5bXmNso6ZKc8uJpUx+XQNOtl05KJcg51qWK10XmcDimG6n4d9+Qc
llQ4zIsS53Q4z3gtOkFJ3iFk2YlQ7a0cDqe4v63WiZV36Hi3bvFZdw4Hb/92
u7d98g5OgZ/bHc+zO0Se6RRetF3eoeXcVKZ2b3aHz01/tbyvyzv4pE0TnreH
zUGs+FHLi7fyDrMlvu5qU2JzODbHQrHqt7xD4dONPxxqWaHhouBgYgwCzA5H
ofITpPzY9zcxOYhD9ac853KtvMvo8AVq/paZmW8SnRnh9tcYZv2t2MIAd9/e
dTwV+wwYHE5A3f9RadGOlIL/9heg/ovanBeycuo/e5j/t/HVH/a6+NceFj4s
ppdZPZX/2k+Fhp+muX2IFfNve1j4Gm6Qn3uI96c9HzT8JReUPHjo9N2+CBo/
j9js5GYs+moPi7+eJ9VhT3W+2MPiV8JSr/Pkw0/2sPhvYQnd5nLwo30mNH1c
cvtwN+z0B3vU9PPBHgDgIO+N
         "]], 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQESDhBawGFl+ptHX8+LOwSfv3H09Xx+h8glPDZ3
Z4k7bPSQrNhlyu/Asy2Be1uCuINEzkGxnIN8DofnvAhoUBR3aLW8uJDBmc+h
PgKkQczhzwaQBl4H+5eT7V5OFnOou6Ree0md14HFf/uzdlcxB7Z5eWf5u3kc
znbysUp8EnWYISzLZfCE22HWTBAQdTAGA24HsHY7UYeLIO21XA6WfY8t+h6L
OBTJHC+UOc7p0NkBAiIOwoIgwOlws0n3RpOuiMMG1mgg4nDQAGm7JOwQ8GuJ
/68l7A4V5SAg7PD+HQiwOYBMKZQRdgAba8HmIA72l5CD3g2QQawOaWAg5HAG
DFgcTMo+/nrOK+SQBgomaRaHv2B/Cjr8Spxo9KGE2eGQGMgAQYcWkDNuMDk0
LY/+fFhJEOpvJge7ZPH19fcEHKqO6cX938Po8MVzPhAJOLwC+5PRYQVIeaqA
A1j5KQaHMHDACDisMVC3EklggMcTNOIcAGkorkU=
         "]], 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQESDhBawOE/GIg7BJ+/cfT1fH4HmPxGD8mKXab8
DoxQvkTOQbGcg3xw+VbLiwsZnBH8PxtAGnjh/LpL6rWX1BF8tnl5Z/m7eeD8
GcKyXAZPuOF8YzDgdjixqmt+zh9xh5jLWqpyDVwO6qu16jZ9FHeYc6p2z9dL
nA4SjA9mX7wv7vBJQufnTm1Oh9lrVv04eUzcIWKf6e2sLg6HTWu7psxeJu5w
bdesJI737A4xLA35bvXiDpl80f2TItkdZm3o6jwVIO4gsLMskfMUm0P2plWP
1KXFHc7sensjx4HN4Tzng6q4e2IO84QPfN2zh9Wh6fmygE05Yg5s530Xptxk
cdg7+zkTN7OYQ435eVYxNhaHerVFEzMWijr89XFRvujE7HCk/dqfU+6iDl38
a39O7WdymLS/xcXom4iDUj1nZ8obRocnZ9dkzFsj4nBiduRFm0hGhz2b/DL5
s0UcKlPnXpK7xuAgnZfl1moo4mB+50oPVzIDNHxEoDSDAwDKVZsa
         "]], 0.2], 
        ArrowBox[{{6., 1.}, {6., 0.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEiDlCGA1Msr47JHGEH5l1SERkW/+0z618L3FET
drj875riDt9/9ubps9Z9ny/kkHvOJPa9/V/7DBEp1nZ2IYeLGiZcfPx/7P+3
ZYl0xQo6/OO9qiGy+5f9733ddxgWCTh8qxXfyejy035Hxe9d11byO0Do7/au
/xr0Jr/hdYDQX+3n8K0QNufhcYDQX+zX1dy8NF+D22GHmuP+JrnP9jlneYNS
vLgc+kvXMH9Q/GR/nsF1Ykshp4Pc75cP6sQ+2l8Tq5/AMI/D4WTe57VxP97b
t/Pv8b9xnt3hZMj200zL3trfe/X7HDc7u4PVCnnpV6av7e+ssOOb7czmIJOp
M0dkxQv7Rs8W3rZWVof86Xf9mv48tT8DBiwOxmDw2D7tzaOv56VZHOZt7L5u
n//A/lfiRKMPJcwO5/i7pzQuv23fonujSfcGk4N4zkGxnIPX7Fn8tz9rd2Vy
kKzYZWqvc8m+6phe3P89jA4r0kEGnbZ/Ndnu5WQ7RocpIOrlYXuw8lMMDg9e
XvuzwWOn/RoDdSuRBAaHf1pnOvlYV9jD4gkWcwBLisKZ
         "]], 0.2], 
        ArrowBox[{{4., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{4., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{4., 3.}, {5., 2.}}, 0.2], 
        ArrowBox[{{4., 3.}, {6., 2.}}, 0.2], 
        ArrowBox[{{4., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{6., 2.}, {6., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {6., 1.}}, 0.2], 
        ArrowBox[{{3., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcDjD6PxiwO4Scv3H09Xx2uPgmD8mKXabsDoxQ
vnjOQbGcg2xw+TbLiwsZnBH8vxtAGljh/LpL6rWX1BF8jnl5Z/m7WeD8mcKy
XAZPmOF8E2MQYHaYFCpqf/MHu0PcZS1VuQYmB7+w0D8pj9kdZp+q3fP1EqOD
PtMB88X72R0+SOj83KnN6GAaGfpxci+7Q8Q+09tZXQwOydGimua+7A5rSk2P
Ctz7b7+Dg+F+zz82h0sy2+RUN/+zN0kUFZ66kM1BqejtIaEpf+2vpoQe9Tdj
c5hdenvjzYY/9vOED3zds4fVwU694XVl5W97tvO+C1NusjjwzZvtdHLTT/sa
8/OsYmwsDj/z5nHr8Pyw/+vjonzRidnh98wOt0Wt3+y7+Nf+nNrP5CAsH/VZ
W/6rvVI9Z2fKG0YH139CQidvfLY/MTvyok0ko8ME882LKjd9sq9MnXtJ7hqD
w6dTVktt13y0N79zpYcrmcEhd8dKSdFjH+yhEQYNpw/2AL4inlg=
         "]], 0.2], 
        ArrowBox[{{3., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{3., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{3., 3.}, {5., 2.}}, 0.2], 
        ArrowBox[{{3., 3.}, {6., 2.}}, 0.2], 
        ArrowBox[{{1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {6., 1.}}, 0.2], 
        ArrowBox[{{2., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{2., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{2., 3.}, {2., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 4.}, 0.2], InsetBox["2", {0., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["3", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["8", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["9", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 3.}, 0.2], 
         InsetBox["10", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 0.}, 0.2], 
         InsetBox["20", {2., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["4", {2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["5", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{6., 4.}, 0.2], 
         InsetBox["6", {6., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{6., 1.}, 0.2], 
         InsetBox["14", {6., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{6., 0.}, 0.2], 
         InsetBox["16", {6., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 2.}, 0.2], 
         InsetBox["18", {4., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 2.}, 0.2], 
         InsetBox["19", {5., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 3.}, 0.2], 
         InsetBox["7", {4., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{6., 2.}, 0.2], 
         InsetBox["11", {6., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["15", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.2], 
         InsetBox["12", {3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["13", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["17", {2., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.851426138937603*^9},
 CellLabel->
  "During evaluation of \
In[466]:=",ExpressionUUID->"0906809b-571c-4fca-9cd4-09543a232a88"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["n=", 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.851426138946066*^9},
 CellLabel->
  "During evaluation of \
In[466]:=",ExpressionUUID->"be5de69f-3bb0-404c-8361-abb09a752098"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 6, 7, 8, 11, 13, 14, 16, 18, 20, 3, 5, 9, 19, 10, 12, 17, 
      15}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 6, 7, 9, 11, 12, 13, 15, 16, 16, 16, 16, 17, 18, 26, 27, 31, 
          34, 36, 37}, {{3}, {4}, {5}, {6}, {7}, {10}, {11}, {2}, {8}, {2}, {
          8}, {11}, {8}, {2}, {8}, {9}, {2}, {12}, {3}, {4}, {5}, {6}, {7}, {
          10}, {12}, {15}, {11}, {1}, {14}, {17}, {18}, {4}, {7}, {10}, {7}, {
          10}, {7}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {-3., 2.}}, 0.2], 
        ArrowBox[{{1., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQUO6PTyeRu7r9v/t4fxkyYafSjJ/mfPCOXr3WjS
vdH0Fy7PU7zImbHtD5z/KxGk4TeCv8QfhBDqbe7Okhf7CecbqluJJJz4Duen
gcE3OH8xWPsXOP+xRR8QfYa7R1kJBD7B5RO5tyVwb/sA59u/nGz3cvI7OH/P
bhB4Dedbgox7/ALOB+lO4H4G5xuDwWM4Hxw8+Q/g/HP83VMal9+Gu0c856BY
zsFrcHnJil2m9jqX4PwV6W8efT1/Gs6fYgdy4GE4/8HLa382eOyE8/9pnenk
Y10B50NpBgCRoXL4
         "]], 0.2], ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{4., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{4., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {-3., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcDlCGw38wYHdYPm9j93X7//Yw+aSJRh9Ksv/Z
M0L5ejeadG80/YXL8xQvcmZs+wPn/0oEafiN4C/xByGEepu7s+TFfsL5hupW
IgknvsP5aWDwzX5SqKj9zR/sDjuWhXrZMHy19wsL/ZPymN3BfOrvitdLP9vr
Mx0wX7yf3eGBYcSn4vBP9qaRoR8n97I7bKjJ3nZV5KN9crSoprkvu0PE66wu
xT3v7XdwMNzv+cfmsMgyx9Yr7a29SaKo8NSFbA5OT261qmq8tr+aEnrU34zN
wfT1tuTNjC/t5wkf+LpnD6tDtR/D9c+fntmznfddmHKTxUHGxrx1Uupj+xrz
86xibCwO7+/aiEdIPLD/6+OifNGJ2eFZupJUp9gt+y7+tT+n9jM5+NRknF1f
c8VeqZ6zM+UNo4P6p+kTPI6dsz8xO/KiTSSjQ/WemaJnJx+1r0yde0nuGoOD
3Po1wbcO77I3v3OlhyuZwWEer7np4kMr7GHxBIs5AD06p5o=
         "]], 0.2], 
        ArrowBox[{{-2., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {-2., 3.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {-3., 3.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-3., 2.}}, 0.2], 
        ArrowBox[{{-3., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{-3., 3.}, {-3., 2.}}, 0.2], 
        ArrowBox[{{-1., 3.}, {-2., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 3.}, 0.2], InsetBox["1", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["4", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["6", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["7", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["8", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["11", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["13", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["14", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.2], 
         InsetBox["16", {0., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 2.}, 0.2], 
         InsetBox["18", {-3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 0.}, 0.2], 
         InsetBox["20", {2., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 2.}, 0.2], 
         InsetBox["3", {4., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 3.}, 0.2], 
         InsetBox["5", {4., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["9", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.2], 
         InsetBox["19", {3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 4.}, 0.2], 
         InsetBox["10", {-2., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 3.}, 0.2], 
         InsetBox["12", {-2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 3.}, 0.2], 
         InsetBox["17", {-3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["15", {-1., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.851427622194189*^9},
 CellLabel->
  "During evaluation of \
In[466]:=",ExpressionUUID->"56f9227b-5aed-47ee-a652-98eee769cdc6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["n=", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.851427622199293*^9},
 CellLabel->
  "During evaluation of \
In[466]:=",ExpressionUUID->"f5117968-95ed-4835-bb8c-9b7ed39c4a27"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 6, 7, 13, 16, 19, 20, 2, 5, 12, 17, 8, 9, 10, 11, 14, 15}, {
      
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 3, 4, 7, 10, 12, 12, 12, 13, 17, 18, 20, 21, 24, 25, 26, 27, 
          28, 30}, {{3}, {4}, {5}, {8}, {2}, {6}, {7}, {2}, {6}, {7}, {2}, {
          6}, {2}, {1}, {10}, {11}, {12}, {2}, {4}, {5}, {5}, {1}, {11}, {
          12}, {15}, {9}, {6}, {6}, {1}, {12}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{3.5585392307259465`, 0.9804008052551569}, {
         4.595688251372881, 1.703678640609248}}, 0.06811257425694832], 
        ArrowBox[{{3.5585392307259465`, 0.9804008052551569}, {
         4.260323232687459, 1.6444049235009521`}}, 0.06811257425694832], 
        ArrowBox[{{3.5585392307259465`, 0.9804008052551569}, {
         3.962115076239619, 1.2450961973820778`}}, 0.06811257425694832], 
        ArrowBox[BezierCurveBox[{{3.8542880325977724`, 2.3445182425439386`}, {
         3.696145155354033, 2.913657764132311}, {3.9066929191366686`, 
         3.465562288323618}}], 0.06811257425694832], 
        ArrowBox[{{4.595688251372881, 1.703678640609248}, {
         3.8542880325977724`, 2.3445182425439386`}}, 0.06811257425694832], 
        ArrowBox[{{4.595688251372881, 1.703678640609248}, {
         5.2315538477471755`, 1.1679975734393007`}}, 0.06811257425694832], 
        ArrowBox[{{4.595688251372881, 1.703678640609248}, {5.040846270909828, 
         2.2447720763412344`}}, 0.06811257425694832], 
        ArrowBox[{{4.260323232687459, 1.6444049235009521`}, {
         3.8542880325977724`, 2.3445182425439386`}}, 0.06811257425694832], 
        ArrowBox[{{4.260323232687459, 1.6444049235009521`}, {
         5.2315538477471755`, 1.1679975734393007`}}, 0.06811257425694832], 
        ArrowBox[{{4.260323232687459, 1.6444049235009521`}, {
         5.040846270909828, 2.2447720763412344`}}, 0.06811257425694832], 
        ArrowBox[{{3.962115076239619, 1.2450961973820778`}, {
         3.8542880325977724`, 2.3445182425439386`}}, 0.06811257425694832], 
        ArrowBox[{{3.962115076239619, 1.2450961973820778`}, {
         5.2315538477471755`, 1.1679975734393007`}}, 0.06811257425694832], 
        ArrowBox[BezierCurveBox[{{3.9066929191366686`, 3.465562288323618}, {
         4.064835796380434, 2.8964227667352263`}, {3.8542880325977724`, 
         2.3445182425439386`}}], 0.06811257425694832], 
        ArrowBox[{{2.382116958923394, 1.396559177178983}, {
         3.5585392307259465`, 0.9804008052551569}}, 0.06811257425694832], 
        ArrowBox[{{2.382116958923394, 1.396559177178983}, {2.770902563751294, 
         2.3450782833752752`}}, 0.06811257425694832], 
        ArrowBox[{{2.382116958923394, 1.396559177178983}, {3.27836633138068, 
         1.312072385662774}}, 0.06811257425694832], 
        ArrowBox[{{2.382116958923394, 1.396559177178983}, {
         2.8906478034666097`, 0.6984621701911929}}, 0.06811257425694832], 
        ArrowBox[{{2.770902563751294, 2.3450782833752752`}, {
         3.8542880325977724`, 2.3445182425439386`}}, 0.06811257425694832], 
        ArrowBox[{{3.27836633138068, 1.312072385662774}, {4.260323232687459, 
         1.6444049235009521`}}, 0.06811257425694832], 
        ArrowBox[{{3.27836633138068, 1.312072385662774}, {3.962115076239619, 
         1.2450961973820778`}}, 0.06811257425694832], 
        ArrowBox[{{2.8906478034666097`, 0.6984621701911929}, {
         3.962115076239619, 1.2450961973820778`}}, 0.06811257425694832], 
        ArrowBox[{{3.320534265226746, 0.4118214070010029}, {
         3.5585392307259465`, 0.9804008052551569}}, 0.06811257425694832], 
        ArrowBox[{{3.320534265226746, 0.4118214070010029}, {3.27836633138068, 
         1.312072385662774}}, 0.06811257425694832], 
        ArrowBox[{{3.320534265226746, 0.4118214070010029}, {
         2.8906478034666097`, 0.6984621701911929}}, 0.06811257425694832], 
        ArrowBox[{{0., 1.4705387328892463`}, {1.0035233360469475`, 
         1.4423261185135803`}}, 0.06811257425694832], 
        ArrowBox[{{1.0035233360469475`, 1.4423261185135803`}, {
         2.382116958923394, 1.396559177178983}}, 0.06811257425694832], 
        ArrowBox[{{6.337260522660051, 1.253302753384416}, {
         5.2315538477471755`, 1.1679975734393007`}}, 0.06811257425694832], 
        ArrowBox[{{6.097420388318892, 0.4930925020414867}, {
         5.2315538477471755`, 1.1679975734393007`}}, 0.06811257425694832], 
        ArrowBox[{{2.967456324130805, 0.}, {3.5585392307259465`, 
         0.9804008052551569}}, 0.06811257425694832], 
        ArrowBox[{{2.967456324130805, 0.}, {2.8906478034666097`, 
         0.6984621701911929}}, 0.06811257425694832]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {
         DiskBox[{3.5585392307259465, 0.9804008052551569}, 
          0.06811257425694832], 
         InsetBox["1", {3.5585392307259465, 0.9804008052551569},
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.8542880325977724, 2.3445182425439386}, 
          0.06811257425694832], 
         InsetBox["4", {3.8542880325977724, 2.3445182425439386},
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.595688251372881, 1.703678640609248}, 0.06811257425694832],
          InsetBox["6", {4.595688251372881, 1.703678640609248},
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.260323232687459, 1.6444049235009521}, 
          0.06811257425694832], 
         InsetBox["7", {4.260323232687459, 1.6444049235009521},
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.962115076239619, 1.2450961973820778}, 
          0.06811257425694832], 
         InsetBox["13", {3.962115076239619, 1.2450961973820778},
          BaseStyle->"Graphics"]}, {
         DiskBox[{5.2315538477471755, 1.1679975734393007}, 
          0.06811257425694832], 
         InsetBox["16", {5.2315538477471755, 1.1679975734393007},
          BaseStyle->"Graphics"]}, {
         DiskBox[{5.040846270909828, 2.2447720763412344}, 
          0.06811257425694832], 
         InsetBox["19", {5.040846270909828, 2.2447720763412344},
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.9066929191366686, 3.465562288323618}, 
          0.06811257425694832], 
         InsetBox["20", {3.9066929191366686, 3.465562288323618},
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.382116958923394, 1.396559177178983}, 0.06811257425694832],
          InsetBox["2", {2.382116958923394, 1.396559177178983},
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.770902563751294, 2.3450782833752752}, 
          0.06811257425694832], 
         InsetBox["5", {2.770902563751294, 2.3450782833752752},
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.27836633138068, 1.312072385662774}, 0.06811257425694832], 
         InsetBox["12", {3.27836633138068, 1.312072385662774},
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.8906478034666097, 0.6984621701911929}, 
          0.06811257425694832], 
         InsetBox["17", {2.8906478034666097, 0.6984621701911929},
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.320534265226746, 0.4118214070010029}, 
          0.06811257425694832], 
         InsetBox["8", {3.320534265226746, 0.4118214070010029},
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 1.4705387328892463}, 0.06811257425694832], 
         InsetBox["9", {0., 1.4705387328892463},
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0035233360469475, 1.4423261185135803}, 
          0.06811257425694832], 
         InsetBox["10", {1.0035233360469475, 1.4423261185135803},
          BaseStyle->"Graphics"]}, {
         DiskBox[{6.337260522660051, 1.253302753384416}, 0.06811257425694832],
          InsetBox["11", {6.337260522660051, 1.253302753384416},
          BaseStyle->"Graphics"]}, {
         DiskBox[{6.097420388318892, 0.4930925020414867}, 
          0.06811257425694832], 
         InsetBox["14", {6.097420388318892, 0.4930925020414867},
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.967456324130805, 0.}, 0.06811257425694832], 
         InsetBox["15", {2.967456324130805, 0.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.8514291403913918`*^9},
 CellLabel->
  "During evaluation of \
In[466]:=",ExpressionUUID->"3782f617-9cf5-46c7-a3f3-6711016e88d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm["n=", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.85142914039609*^9},
 CellLabel->
  "During evaluation of \
In[466]:=",ExpressionUUID->"eb1ba8ed-7a0c-4e3d-a4d7-c3dd4390d73a"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 8, 9, 10, 15, 18, 20, 5, 6, 11, 14, 7, 12, 13, 17, 19}, {
      
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 3, 4, 5, 6, 8, 9, 10, 10, 10, 11, 13, 14, 14, 17, 18, 22, 25, 
          27}, {{2}, {7}, {8}, {6}, {9}, {9}, {3}, {4}, {5}, {3}, {2}, {1}, {
          12}, {13}, {1}, {13}, {15}, {2}, {1}, {13}, {15}, {17}, {2}, {7}, {
          8}, {11}, {14}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 5.}, {2., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[{{2., 4.}, {2., 3.}}, 0.2], 
        ArrowBox[{{1., 1.}, {1., 0.}}, 0.2], 
        ArrowBox[{{2., 1.}, {1., 0.}}, 0.2], 
        ArrowBox[{{2., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{2., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQjQoEHGCs4PM3jr6ezw/nb/SQrNhliuBL5BwUyznI
B+e3Wl5cyOCM4P/ZANLAC+fXXVKvvaSO4LPNyzvL380D588QluUyeMIN5xuD
AYJ/EaS9lgvOL5I5XihznBPOFxYEAQR/A2s0EHHA+QG/lvj/WsIO579/BwJs
cH7fYwsgQvD1bjTp3mhihfNNwO5hdli4aeUq5tk59nGXtVTlGpig/B772adq
93y9xOhQVfKf30h8gf0HCZ2fO7UZofJr7CP2md7O6mJw6J8cclcqcpv9mlLT
owL3/ttD1B+wvySzTU518z/7I29Wnlv37Ki9UtHbQ0JT/tpD9J+xn116e+PN
hj/2XMn/AyWkLtnbqTe8rqz8bX+sfeLXWyY37fnmzXY6uemnvaJL20X/8/ft
f+bN49bh+WHPd+Zd0e4vj+x/z+xwW9T6zf7WQW/JFQef2gvLR33Wlv9qX8Z8
63au3wt7139CQidvfLZ/NGHmLp7Zr+wnmG9eVLnpk71MVtfWluVv7D+dslpq
u+ajvXr/mjNXi9/Z5+5YKSl67IM9JHQQNAAmY8WG
         "]], 0.2], 
        ArrowBox[{{1., 5.}, {2., 4.}}, 0.2], 
        ArrowBox[{{2., 6.}, {0., 5.}}, 0.2], 
        ArrowBox[{{2., 6.}, {2., 5.}}, 0.2], 
        ArrowBox[{{2., 5.}, {4., 4.}}, 0.2], 
        ArrowBox[{{5., 6.}, {0., 5.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEiDhBawiF0hrAsl4GIw8r0N4++nhd3WB79+bBS
qohD5BIem7uzxB2+es7/4jlfxIFnWwL3tgRxB9tk8fX190QcDs95EdCgKO7Q
BNYg6lAfAdIg5nBALOegWI6og/3LyXYvJ4s5/NngIVmxS9SBxX/7s3ZXMQeT
so+/nvOKOZzt5GOV+CTqkAYGYg6zZoKAqENJrIbwj61iDkK+KtvyHUQdnM13
7Fj4TszhblFVzt9XIg4XPouGJwuIO/zkmrPHaaaIg9Rkx3c20uIOGaKdy+y9
RRyURK3r9PjFHdQnOWp9AfrzRSUTu8UbMQeLxqPuCbuEHXIPTu+I3CTmMOeR
yP/mcmGHDa9/MU1OFHMI2qYfEG8h7LDxh3bZk5+iDpF/RK0//RFyuNuwP2Mb
p6hD3oF4k9stQg5LnJsWiWiLOFxSdAzsEhVyYHMsUf4fK+zQorBr4v91gg5M
lVNfly4Scmjcc+qrVaCgw4zXT39V/BB0OPO1qNbmj4DDqRmpgRwJgg6pZzZp
sGwQcJjWIPJe+aaAg49D1/eJOQIO/xZ9unw6WcChPvDny6eGAtB4QtAAKkSx
HA==
         "]], 0.2], ArrowBox[{{5., 6.}, {5., 5.}}, 0.2], 
        ArrowBox[{{5., 5.}, {2., 4.}}, 0.2], 
        ArrowBox[{{3., 6.}, {0., 5.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcDhBawsHszpUermQOhycTp+6sOifuUJk695Lc
NQ4HF9+N0z5MEXc4MTvyok0kp4OsUfD0xGBxB6V6zs6UN5wO+Q7Vu89yijt0
8a/9ObWfy8GmQpPZdIeYw18fF+WLTtwOTTdj86bHiTnUmJ9nFWPjcXBOkfj7
5Y+oA8d534UpN3kcaiUi1/tOFnWYL3zg6549vA6G3+RbFyqKOlxLCT3qb8bn
MFOpc/LJ+yIOJomiwlMX8jlULHbx/z1LxGEXB8P9nn98DmcrgnaYBYs4JEeL
apr78jtMW7TpXDWHiINpZOjHyb38DlcUUied2iXsoM90wHzxfn6Hjs+ZzMpZ
wg5+YaF/Uh7zO2ySOqjYKibsMCVU1P7mD36HoGlZbz/sF4KGi4BDGhgg+CZl
H38950Xw/27wkKzYJejACOUfEss5KJYjCJdvWh79+bASgm+XLL6+/p4AnP/F
cz4QIfgrQMpTEfywGcKyXAYIPowGALaUj9M=
         "]], 0.2], 
        ArrowBox[{{3., 6.}, {5., 5.}}, 0.2], 
        ArrowBox[{{3., 6.}, {3., 5.}}, 0.2], 
        ArrowBox[{{3., 5.}, {2., 4.}}, 0.2], 
        ArrowBox[{{3., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{3., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[{{5., 7.}, {2., 6.}}, 0.2], 
        ArrowBox[{{5., 7.}, {5., 6.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 5.}, 0.2], InsetBox["1", {0., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 4.}, 0.2], 
         InsetBox["2", {2., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["3", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["8", {2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["9", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["10", {2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 4.}, 0.2], 
         InsetBox["15", {0., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.2], 
         InsetBox["18", {1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 0.}, 0.2], 
         InsetBox["20", {1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 5.}, 0.2], 
         InsetBox["5", {1., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 6.}, 0.2], 
         InsetBox["6", {2., 6.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 5.}, 0.2], 
         InsetBox["11", {2., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 4.}, 0.2], 
         InsetBox["14", {4., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 6.}, 0.2], 
         InsetBox["7", {5., 6.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 5.}, 0.2], 
         InsetBox["12", {5., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 6.}, 0.2], 
         InsetBox["13", {3., 6.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 5.}, 0.2], 
         InsetBox["17", {3., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 7.}, 0.2], 
         InsetBox["19", {5., 7.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.851431371288734*^9},
 CellLabel->
  "During evaluation of \
In[466]:=",ExpressionUUID->"214c9720-6137-417f-ad83-0a526210da28"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm["n=", 5],
  Editable->False]], "Print",
 CellChangeTimes->{3.851431371293495*^9},
 CellLabel->
  "During evaluation of \
In[466]:=",ExpressionUUID->"1f238fe8-d4bb-420d-b2d2-27f09db85a1e"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 3, 4, 8, 9, 10, 11, 14, 18, 20, 2, 6, 7, 12, 13, 15, 17, 19}, {
      
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 1, 3, 4, 5, 9, 10, 11, 11, 11, 11, 12, 16, 17, 18, 19, 21, 22,
           24}, {{6}, {3}, {10}, {2}, {10}, {2}, {4}, {7}, {9}, {5}, {8}, {
          6}, {2}, {4}, {7}, {9}, {6}, {1}, {6}, {2}, {8}, {1}, {8}, {10}}}, 
         Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0.8947439646265583, 1.126303687888329}, {
         2.3698958155154393`, 1.2638330937288038`}}, 0.08228239320685984], 
        ArrowBox[BezierCurveBox[{{5.542714490534201, 0.8677282031266171}, {
         5.997415472225499, 0.5364787808953417}, {6.166736705768784, 0.}}], 
         0.08228239320685984], 
        ArrowBox[{{5.542714490534201, 0.8677282031266171}, {6.209618544417229,
          0.9565766992019489}}, 0.08228239320685984], 
        ArrowBox[BezierCurveBox[{{6.166736705768784, 0.}, {5.712035724077473, 
         0.3312494222312883}, {5.542714490534201, 0.8677282031266171}}], 
         0.08228239320685984], 
        ArrowBox[{{5.156731622112877, 0.725330762554623}, {6.209618544417229, 
         0.9565766992019489}}, 0.08228239320685984], 
        ArrowBox[{{4.184393005172332, 1.1371683479179668`}, {
         5.542714490534201, 0.8677282031266171}}, 0.08228239320685984], 
        ArrowBox[{{4.184393005172332, 1.1371683479179668`}, {
         5.156731622112877, 0.725330762554623}}, 0.08228239320685984], 
        ArrowBox[{{4.184393005172332, 1.1371683479179668`}, {
         5.062926144109307, 1.78441576438853}}, 0.08228239320685984], 
        ArrowBox[{{4.184393005172332, 1.1371683479179668`}, {
         4.2532213348858035`, 0.5255868140333304}}, 0.08228239320685984], 
        ArrowBox[{{2.3698958155154393`, 1.2638330937288038`}, {
         4.184393005172332, 1.1371683479179668`}}, 0.08228239320685984], 
        ArrowBox[{{5.062926144109307, 1.78441576438853}, {6.112418012405145, 
         2.1223806938887266`}}, 0.08228239320685984], 
        ArrowBox[{{1.971080934259061, 0.524556361793349}, {
         2.3698958155154393`, 1.2638330937288038`}}, 0.08228239320685984], 
        ArrowBox[{{4.861422939558032, 1.055347425796731}, {5.542714490534201, 
         0.8677282031266171}}, 0.08228239320685984], 
        ArrowBox[{{4.861422939558032, 1.055347425796731}, {5.156731622112877, 
         0.725330762554623}}, 0.08228239320685984], 
        ArrowBox[{{4.861422939558032, 1.055347425796731}, {5.062926144109307, 
         1.78441576438853}}, 0.08228239320685984], 
        ArrowBox[{{4.861422939558032, 1.055347425796731}, {
         4.2532213348858035`, 0.5255868140333304}}, 0.08228239320685984], 
        ArrowBox[{{1.6679388536250026`, 1.681039106461142}, {
         2.3698958155154393`, 1.2638330937288038`}}, 0.08228239320685984], 
        ArrowBox[{{0.06720130222276, 0.6696827354478481}, {0.8947439646265583,
          1.126303687888329}}, 0.08228239320685984], 
        ArrowBox[{{2.201426577164728, 2.1283073776878574`}, {
         2.3698958155154393`, 1.2638330937288038`}}, 0.08228239320685984], 
        ArrowBox[{{6.198670660659458, 1.5588651617660403`}, {
         5.542714490534201, 0.8677282031266171}}, 0.08228239320685984], 
        ArrowBox[{{6.198670660659458, 1.5588651617660403`}, {
         6.112418012405145, 2.1223806938887266`}}, 0.08228239320685984], 
        ArrowBox[{{0., 1.4493791114495513`}, {0.8947439646265583, 
         1.126303687888329}}, 0.08228239320685984], 
        ArrowBox[{{6.851007365455846, 1.6901070843082429`}, {
         6.112418012405145, 2.1223806938887266`}}, 0.08228239320685984], 
        ArrowBox[{{6.851007365455846, 1.6901070843082429`}, {
         6.209618544417229, 0.9565766992019489}}, 0.08228239320685984]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {
         DiskBox[{0.8947439646265583, 1.126303687888329}, 
          0.08228239320685984], 
         InsetBox["1", {0.8947439646265583, 1.126303687888329},
          BaseStyle->"Graphics"]}, {
         DiskBox[{5.542714490534201, 0.8677282031266171}, 
          0.08228239320685984], 
         InsetBox["3", {5.542714490534201, 0.8677282031266171},
          BaseStyle->"Graphics"]}, {
         DiskBox[{6.166736705768784, 0.}, 0.08228239320685984], 
         InsetBox["4", {6.166736705768784, 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{5.156731622112877, 0.725330762554623}, 0.08228239320685984],
          InsetBox["8", {5.156731622112877, 0.725330762554623},
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.184393005172332, 1.1371683479179668}, 
          0.08228239320685984], 
         InsetBox["9", {4.184393005172332, 1.1371683479179668},
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.3698958155154393, 1.2638330937288038}, 
          0.08228239320685984], 
         InsetBox["10", {2.3698958155154393, 1.2638330937288038},
          BaseStyle->"Graphics"]}, {
         DiskBox[{5.062926144109307, 1.78441576438853}, 0.08228239320685984], 
         InsetBox["11", {5.062926144109307, 1.78441576438853},
          BaseStyle->"Graphics"]}, {
         DiskBox[{6.112418012405145, 2.1223806938887266}, 
          0.08228239320685984], 
         InsetBox["14", {6.112418012405145, 2.1223806938887266},
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.2532213348858035, 0.5255868140333304}, 
          0.08228239320685984], 
         InsetBox["18", {4.2532213348858035, 0.5255868140333304},
          BaseStyle->"Graphics"]}, {
         DiskBox[{6.209618544417229, 0.9565766992019489}, 
          0.08228239320685984], 
         InsetBox["20", {6.209618544417229, 0.9565766992019489},
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.971080934259061, 0.524556361793349}, 0.08228239320685984],
          InsetBox["2", {1.971080934259061, 0.524556361793349},
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.861422939558032, 1.055347425796731}, 0.08228239320685984],
          InsetBox["6", {4.861422939558032, 1.055347425796731},
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6679388536250026, 1.681039106461142}, 
          0.08228239320685984], 
         InsetBox["7", {1.6679388536250026, 1.681039106461142},
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.06720130222276, 0.6696827354478481}, 0.08228239320685984],
          InsetBox["12", {0.06720130222276, 0.6696827354478481},
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.201426577164728, 2.1283073776878574}, 
          0.08228239320685984], 
         InsetBox["13", {2.201426577164728, 2.1283073776878574},
          BaseStyle->"Graphics"]}, {
         DiskBox[{6.198670660659458, 1.5588651617660403}, 
          0.08228239320685984], 
         InsetBox["15", {6.198670660659458, 1.5588651617660403},
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 1.4493791114495513}, 0.08228239320685984], 
         InsetBox["17", {0., 1.4493791114495513},
          BaseStyle->"Graphics"]}, {
         DiskBox[{6.851007365455846, 1.6901070843082429}, 
          0.08228239320685984], 
         InsetBox["19", {6.851007365455846, 1.6901070843082429},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.851433197740741*^9},
 CellLabel->
  "During evaluation of \
In[466]:=",ExpressionUUID->"edb34bfd-4a13-49eb-88d4-7aacbbc4d585"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "6"}],
  SequenceForm["n=", 6],
  Editable->False]], "Print",
 CellChangeTimes->{3.8514331977468157`*^9},
 CellLabel->
  "During evaluation of \
In[466]:=",ExpressionUUID->"31e505b3-c299-4974-86d4-5c9e42a68f91"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 8, 9, 10, 15, 16, 20, 4, 5, 7, 13, 14, 11, 12, 17, 18, 
      19}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 2, 3, 4, 5, 7, 8, 10, 10, 10, 11, 12, 14, 16, 17, 18, 19, 21, 
          21, 22}, {{2}, {7}, {6}, {9}, {9}, {3}, {4}, {5}, {3}, {8}, {9}, {
          3}, {2}, {13}, {7}, {14}, {8}, {14}, {2}, {7}, {18}, {9}}}, 
         Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 5.}, {3., 4.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQpEHGCslelvHn09LwznRyzhsbk7C8Hn2ZbAvS0B
wT8850VAgyKCXwfWIATn27+cbPdyMoLP4r/9Wbsrgn+mk49V4pMgnD9rJggI
OizctHIV8+wc+/WZU4X4HWD8Hnu/p3b3ql4KOFSV/Oc3El9gX8kz7c+dqQJQ
+TX2Ovdn5Zq6Cjj0Tw65KxW5zf7arllJHO/5oeoP2GfxRfdPiuR3OPJm5bl1
z47aC+wsS+Q8xQfVf8b+3K63N3Ic+By4kv8HSkhdsp8vfODrnj28DsfaJ369
ZXLTnu2878KUmzwOii5tF/3P37evMT/PKsbG48B35l3R7i+P7P/5uChfdOJ2
uHXQW3LFwaf2Xfxrf07t53IoY751O9fvhb1yPWdnyhtOh0cTZu7imf3K/sTs
yIs2kZwOMlldW1uWv7GvTJ17Se4ah4N6/5ozV4vf2ZvfudLDlcwBDZ8P9hCa
wwEAoGyhCQ==
         "]], 0.2], ArrowBox[{{3., 4.}, {3., 3.}}, 0.2], 
        ArrowBox[{{1., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{3., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{3., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{3., 2.}, {3., 1.}}, 0.2], 
        ArrowBox[{{3., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEf7CE0hwOMH3L+xtHX89nh/E0ekhW7TNkdGKF8
8ZyDYjkH2eDybZYXFzI4I/h/N4A0sML5dZfUay+pI/gc8/LO8nezwPkzhWW5
DJ4ww/kmxiCA4F8Baa9lgvMLZY4DESPcPUKCIMAIl9/IGr2BNZoBzl/wxXP+
F8//9jD+vbsg8BfOlwUZV/gHzo/ZADLgN5w/ayYI/ITzwcFj/gPO/3xYKfXB
y2/2MPewg6zf8BUuzw727xc4/2tP7J5/lZ/hfHDw1H6C88HKp3yE8yMS/Uo0
DnyA82E0AMNUgbQ=
         "]], 0.2], ArrowBox[{{1., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{0., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{2., 5.}, {3., 4.}}, 0.2], 
        ArrowBox[{{2., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[{{1., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {2., 3.}}, 0.2], 
        ArrowBox[{{2., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{2., 4.}, {2., 3.}}, 0.2], 
        ArrowBox[{{3., 5.}, {3., 4.}}, 0.2], 
        ArrowBox[{{-1., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{-1., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{0., 1.}, {0., 0.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 5.}, 0.2], InsetBox["1", {0., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 4.}, 0.2], 
         InsetBox["2", {3., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["3", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 1.}, 0.2], 
         InsetBox["8", {3., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.2], 
         InsetBox["9", {3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.2], 
         InsetBox["10", {3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["15", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["16", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.2], 
         InsetBox["20", {0., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["4", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["5", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 5.}, 0.2], 
         InsetBox["7", {2., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.2], 
         InsetBox["13", {1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["14", {2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 4.}, 0.2], 
         InsetBox["11", {2., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 5.}, 0.2], 
         InsetBox["12", {3., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 4.}, 0.2], 
         InsetBox["17", {-1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["18", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["19", {0., 1.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.851435315429782*^9},
 CellLabel->
  "During evaluation of \
In[466]:=",ExpressionUUID->"eca80cad-0cec-4a8e-90ec-968284b26f92"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"n", "=", "7"}], ",", 
    RowBox[{"n", "\[LessEqual]", "20"}], ",", 
    RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<n=\>\"", ",", "n"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"chain", "[", 
      RowBox[{"n", ",", "20"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"graph", "[", "n", "]"}], "=", 
      RowBox[{"TransitiveReductionGraph", "[", 
       RowBox[{"Graph", "[", 
        RowBox[{
         RowBox[{"arcs", "[", "n", "]"}], ",", "  ", 
         RowBox[{"VertexLabels", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{"\"\<Name\>\"", ",", "Center"}], "]"}]}], ",", 
         RowBox[{"VertexSize", "\[Rule]", "0.4"}], ",", "\[IndentingNewLine]", 
         RowBox[{"VertexStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"White", ",", 
            RowBox[{"EdgeForm", "[", 
             RowBox[{"{", 
              RowBox[{"Thick", ",", "Red", ",", 
               RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], "]"}]}], "]"}]}], 
         ",", 
         RowBox[{"EdgeStyle", "\[Rule]", "Black"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "600"}], ",", 
         RowBox[{"GraphLayout", "\[Rule]", "Automatic"}]}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"graph", "[", "n", "]"}], "]"}], ";"}]}], "\[IndentingNewLine]",
    "]"}], ";"}]], "Input",
 CellChangeTimes->{3.851365996597624*^9},
 CellLabel->
  "In[379]:=",ExpressionUUID->"6c69d59f-444b-4197-856b-42be96f58597"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "7"}],
  SequenceForm["n=", 7],
  Editable->False]], "Print",
 CellChangeTimes->{3.851366003398098*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"59daca50-9571-4483-a08c-f2565f78f44e"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 8, 9, 10, 11, 14, 15, 16, 18, 19, 20, 5, 6, 12, 13, 
      17}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 6, 7, 8, 9, 10, 12, 13, 15, 15, 17, 17, 17, 18, 18, 19, 25, 
          28, 31, 33}, {{2}, {4}, {8}, {10}, {12}, {13}, {7}, {14}, {14}, {
          14}, {3}, {5}, {6}, {9}, {11}, {3}, {11}, {3}, {3}, {2}, {4}, {9}, {
          10}, {12}, {13}, {2}, {11}, {12}, {4}, {9}, {10}, {10}, {12}}}, 
         Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 5.}, {-2., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {3., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {-1., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {-3., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {-2., 3.}}, 0.2], 
        ArrowBox[{{0., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGDQA2IQDQEcDhBawOE/GLA7BJ+/cfT1fH4HmPxGD8mKXab8
DoxQvkTOQbGcg3xw+VbLiwsZnBH8PxtAGnjh/LpL6rWX1BF8tnl5Z/m7eeD8
GcKyXAZPuOF8YzDghrvnIkh7LRdcvkjmeKHMcU64e4QFQYATLr+BNRqIOOD8
gF9L/H8tYYfz378DATY4v++xBRAh+Ho3mnRvNLHC+SZg9zDD3XMF7B4muHwh
2D2McPcIgd3DiAg/sHsY4PwFXzznf/H8bw/j37sLAn/hfFmQcYV/4PwYsId+
w/lpYPDNvn2Vz8n0b+wOb8TjglQ4vtorrjJSnX+T3YE9SnZm99HP9if/bRRe
tpLdYYvOEqs58z7ZN6w4NaUmjd3hY/8ns7DJH+09l9esUBJgdzjQzNG3c/EH
e6Xfx/1mLGNzcBY4U98z/70915I17Xc12Ry0rMRm/tB7Z8+0SCv400xWB7PW
9+nbv76x5/7quPHaNxaHlI/hb058fm0/7YHwc4NmRgfZa/md0yKf2x/x3bL/
wLo/9jeMK7S05R/b3+vXND/17Ju9huijebyd9+xL29tN6tZ9tJ+zZcuHoMnX
7eUy5+Tv5H5lL+KW4aUWe9E+VO934+mbD+2lJ/8M5z973F58b5hDat9Ve4U/
J0Lv7N1jL/Z8s8Zu/8P2ciauZkv2r7RnQAMAOrD0qA==
         "]], 0.2], 
        ArrowBox[{{-2., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {-2., 1.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{-1., 4.}, {2., 3.}}, 0.2], 
        ArrowBox[{{-1., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQjQoEHGCs4PM3jr6ezw/nb/SQrNhliuBL5BwUyznI
B+e3Wl5cyOCM4P/ZANLAC+fXXVKvvaSO4LPNyzvL380D588QluUyeMIN5xuD
AYJ/EaS9lgvOL5I5XihznBPOFxYEAQR/A2s0EHHA+QG/lvj/WsIO579/BwJs
cH7fYwsgQvD1bjTp3mhihfNNwO5hhvOvgN3DBOcXgt3DCOcLgd2D4G8Eu4cB
zl/wxXP+F8//9jD+vbsg8BfOlwUZV/gHzo8Be+g3nD9rJgj8hPPB0WX+A87/
fFgp9cHLb3A+O8j6DV8RfHD4f4Hzv/bE7vlX+RnOB0dX7Sc4H6x8ykc4PyLR
r0TjwAc4HwI+2AMAPjN8fg==
         "]], 0.2], 
        ArrowBox[{{0., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQDQEf7CG0gAOMH3z+xtHX8/nh/I0ekhW7TPkdGKF8
iZyDYjkH+eDyrZYXFzI4I/h/NoA08ML5dZfUay+pI/hs8/LO8nfzwPkzhGW5
DJ5ww/nGYIDgXwRpr+WC84tkjhfKHOeEu0dYEAQ44fIbWKOBiAPOD/i1xP/X
EnY4//07EGCD8/seWwARgq93o0n3RhMrnG8Cdg+zg29Y6J+Ux+/t4y5rqco1
MDmYRYZ+nNz73n72qdo9Xy8xOuziYLjf8++d/QcJnZ87tRkdrqWEHvU3e2cf
sc/0dlYXg0NfbuiSOyZv7deUmh4VuPff/pESQ43xr9f2l2S2yalu/md/viXU
J6Ttlb1S0dtDQlP+2kdMDhW1v/nCfnbp7Y03G/7YV/sxXP/86Zm9nXrD68rK
3/YyNuatk1If2/PNm+10ctNP+/d3bcQjJB7Y/8ybx63D88P+WbqSVKfYLfvf
MzvcFrV+s/epyTi7vuaKvbB81Gdt+a/26p+mT/A4ds7e9Z+Q0Mkbn+2r98wU
PTv5qP0E882LKjd9spdbvyb41uFd9p9OWS21XfPRfh6vueniQyvsc3eslBQ9
Bks3iHQEAH/Q13Q=
         "]], 0.2], ArrowBox[{{-1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{1., 5.}, {-2., 4.}}, 0.2], 
        ArrowBox[{{1., 5.}, {3., 4.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEf7CG0iEPOjpWSosc+2D+ZOHVn1Tlhh0+nrJba
rvlo7+y7cdqHKcIOE8w3L6rc9Mle1ih4emKwsIPrPyGhkzc+2+c7VO8+yyns
ICwf9Vlb/qu9dYUms+kOIYdfMzvcFrV+s2+6GZs3PU7I4UfePG4dnh/2TikS
f7/8EXTgnzfb6eSmn/Y1EpHrfScLOtipN7yurPxtb/BNvnWhoqDDmpOruubn
/LGfodQ5+eR9AYf0Q1pqWs5/7SsWu/j/niXgUCTIsE/y71/7MxVBO8yCBRxO
bNMKypv1z37qok3nqjkEHHI2rXqkLv3ffoXjKZWppfwOsSwN+W71/+0Fnl9m
c7vC5zB7zaofJ4/9t08xbXLm0uVzUF+tVbfp43/7JTpXbz2s53WABpDD2TMg
wAPnp7959PW8NIL/K3Gi0YcSbgdGKL9F90aT7g0uuDyL//Zn7a4IfvUxvbj/
ezjh/FeT7V5OtkPwwcpPccD5awzUrUQSEHwIxeEAAMnKpFY=
         "]], 0.2], 
        ArrowBox[{{1., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{1., 5.}, {-3., 4.}}, 0.2], 
        ArrowBox[{{1., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[{{-3., 5.}, {-2., 4.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcByC0iMNqA3UrkQSOAyvT3zz6el7YwX/7s3bX
UxwHIpbw2NydJezwcrIdEHEe4NmWwL0tQdih+phe3P89nAcOz3kR0KAo7MAC
1sB1oA6sQcihWfdGk+4NrgP2YI1CDr8SJxp9KOE+AFEn5JABskaa58CZTj5W
iU+CDmfPgADPgVkzQUDQoS1iSq1mNu8BT97lzfGOgg5fntSd07jFe2BTceui
Pe8EHMSKevafkuQ7cPuMybcNCwUcXvzfE8CvxXdgn8TWOpsoAYe8PoGmb1x8
B+LD2WziJQQcVsi2Bzfs4T1QKRgYY7SD32HKWoWja+x4D6yJNF91xYvfwcTu
7rXqiTwHYtr3Jy59wefQdn5Px9st3AeaZr1sWjKRz2Hfpbi66y0cB6bOltea
28jr4NGx/vXiKawHJG70+z1s43FQ+7DuQtATpgN8AVYfChZyOwRxxeo+KWY4
UMQsz+9zkcth8dpi5g1tf/a7fbJdXSTG5eC2umt2zNIf+3tkph95UsDp0M37
X+mc89f9Tk1a0YsecDiUXLkwkyXp0/5M5R95q1M5HCDx9GE/NN4cABjQxZQ=

         "]], 0.2], ArrowBox[{{-3., 5.}, {-3., 4.}}, 0.2], 
        ArrowBox[{{3., 5.}, {3., 4.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcDhBaxGG1gbqVSAKHw8r0N4++nhd28N/+rN31
FIdDxBIem7uzhB1eTrYDIk4Hnm0J3NsShB2qj+nF/d/D6XB4zouABkVhBxaw
Bi6HOrAGIYdm3RtNuje4HOzBGoUcfiVONPpQwg1VJ+SQAbJGmsfhTCcfq8Qn
QYezZ0CAx2HWTBAQdHi9K0DtQzavg7CvyrZ8B0GHtryCQue7vA53iqpy/r4S
cFjwXHvdMQU+h19cc/Y4zRRwMFZrvlNpxueQLtq5zN5bwMFZq+xPjByfg/ok
R60vDAIOlz6z8BXc4HUoYuruP1DC73CrSV9wcwqvg8VRzX/s7/kcEq9/ZVU7
zOOwKCd+wb4CPofkj+FvTnzmdtj4Q7vsyU9eh12M9RdzhLkc7jTsz9jGyevg
0c7iqhnG4bDEuWmRiDaPA3fTC7d/u9kc2BxLlP/HcjswfdK6/tqF1YGpcurr
0kVcDgbXT3/9+IHZYcbrp78qfnA6TDE8vUjgAJPDqRmpgRwJnA66jJr33Dcx
OkxrEHmvfJPD4Y/r0+XTjzM4/Fv06fLpZFg8MTjA4g0ACQ+1ag==
         "]], 0.2], 
        ArrowBox[{{3., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{-2., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{-2., 5.}, {-3., 4.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 5.}, 0.2], InsetBox["1", {0., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 4.}, 0.2], 
         InsetBox["2", {-2., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["3", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 4.}, 0.2], 
         InsetBox["4", {3., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 1.}, 0.2], 
         InsetBox["8", {-2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["9", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 3.}, 0.2], 
         InsetBox["10", {-2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 4.}, 0.2], 
         InsetBox["11", {-1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["14", {2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 4.}, 0.2], 
         InsetBox["15", {0., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["16", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 4.}, 0.2], 
         InsetBox["18", {-3., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.2], 
         InsetBox["19", {1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.2], 
         InsetBox["20", {0., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["5", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 5.}, 0.2], 
         InsetBox["6", {1., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 5.}, 0.2], 
         InsetBox["12", {-3., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 5.}, 0.2], 
         InsetBox["13", {3., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 5.}, 0.2], 
         InsetBox["17", {-2., 5.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.8513680309124727`*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"5d36c708-1df3-4ece-bb3f-94d9be9f7331"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "8"}],
  SequenceForm["n=", 8],
  Editable->False]], "Print",
 CellChangeTimes->{3.851368030920191*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"9264aed5-81ee-4550-84fb-6643a8635e6e"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 6, 7, 13, 14, 16, 2, 5, 12, 17, 3, 9, 10, 11, 19, 15}, {
       SparseArray[
       Automatic, {17, 17}, 0, {
        1, {{0, 3, 3, 5, 7, 9, 10, 10, 14, 15, 17, 18, 19, 21, 23, 24, 25, 
          26}, {{3}, {4}, {5}, {2}, {6}, {2}, {6}, {2}, {6}, {7}, {1}, {9}, {
          10}, {11}, {2}, {4}, {5}, {5}, {2}, {14}, {15}, {8}, {16}, {6}, {
          7}, {5}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{2., 1.}, {4., 0.}}, 0.2], 
        ArrowBox[{{1., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {2., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEf9kNoDgcYP+T8jaOv57PD+Zs8JCt2mbI7MEL5
4jkHxXIOssHl2ywvLmRwRvD/bgBpYIXz6y6p115SR/A55uWd5e9mgfNnCsty
GTxhhvNNjEGA2cE3LPRPyuP3++Mua6nKNTA5mEWGfpzc+37/7FO1e75eYnTY
xcFwv+ffu/0fJHR+7tRmdLiWEnrU3+zd/oh9prezuhgc+nJDl9wxebt/Tanp
UYF7/+0fKTHUGP96vf+SzDY51c3/7M+3hPqEtL3ar1T09pDQlL/2EZNDRe1v
vtg/u/T2xpsNf+yr/Riuf/70bL+desPrysrf9jI25q2TUh/v55s32+nkpp/2
7+/aiEdIPNj/M28etw7PD/tn6UpSnWK39v+e2eG2qPWbvU9Nxtn1NVf2C8tH
fdaW/2qv/mn6BI9j5/a7/hMSOnnjs331npmiZycf3T/BfPOiyk2f7OXWrwm+
dXjX/k+nrJbarvloP4/X3HTxoRX7c3eslBQ99sGeAQV8sAcAVeS+Ww==
         "]], 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{2., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{5., 6.}, {4., 5.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGDQA2IQDQEiDhBawgHGX5n+5tHX8+JwfuQSHpu7s8QdGKF8
nm0J3NsSEPKH57wIaFBE8OsjQBrE4Hz7l5PtXk5G8Fn8tz9rd0Xwz3bysUp8
EoXzZ80EAQQfrN0Owbfse2zR91gE7p7ODhAQgcvfbNK90aSL4GvUXlKvvSQM
51eUgwCCf7xQBogQfPGcg2I5B4XQ3CMI578CuwfBh7hHAO6eLrB7BODyN8Du
QfADfi3x/7WEH87/8A4E+OB8sHEWCL4e2ABeON8YDLjh/IvqIA9ywflFIO8c
54S7R1gQBDjh8htYo4GIA8097HD+e7B72NDcg+BD3MMK558BAxY4Pw2UfKQR
/F+JE40+lDDD3dMCCo4bTHB5SHpA8KuO6cX938OIFt4IPlj5KQY4f42BupVI
AoIPoRkcAKVYqmE=
         "]], 0.2], ArrowBox[{{4., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[{{4., 5.}, {4., 4.}}, 0.2], 
        ArrowBox[{{5., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGDQA2IQDQECDuh08PkbR1/P54fzN3pIVuwy5XdghPIlcg6K
5Rzkg8u3Wl5cyOCM4P/ZANLAC+fXXVKvvaSO4LPNyzvL380D588QluUyeMIN
5xuDAYJ/EaS9lgvOL5I5XihznBPuHmFBEOCEy29gjQYiDjg/4NcS/19L2OH8
9+9AgA3O73tsAUQIvt6NJt0bTaxwvgnYPcxw/hWwe5jg/EKwexjh7hECu4cR
EX5g9zDA+Qu+eM7/4vnfHsa/dxcE/sL5siDjCv/A+TFgD/2G89PA4Bucv9gf
5MEvcD7YO32f7WHuUVYCgU9w+UTubQnc2z7A+fYvJ9u9nPwOzt+zGwRew/mW
4AB6AeeDdCdwP4PzIfH1GM6ft7H7un3+Azj/HH/3lMblt+HuEQenn2tweVDq
ste5BOevSH/z6Ov503D+FDuQAw/D+Q9eXgMmsZ1w/j+tM518rCvgfAYoAACt
jauY
         "]], 0.2], ArrowBox[{{3., 3.}, {2., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 3.}, 0.2], InsetBox["1", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["4", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["6", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["7", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["13", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["14", {2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 0.}, 0.2], 
         InsetBox["16", {4., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.2], 
         InsetBox["2", {1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["5", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["12", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["17", {2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["3", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 6.}, 0.2], 
         InsetBox["9", {5., 6.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 5.}, 0.2], 
         InsetBox["10", {4., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 2.}, 0.2], 
         InsetBox["11", {5., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 4.}, 0.2], 
         InsetBox["19", {4., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.2], 
         InsetBox["15", {3., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.851369790560442*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"6ca6732a-c57f-4c26-92ee-e0c6f1019384"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "9"}],
  SequenceForm["n=", 9],
  Editable->False]], "Print",
 CellChangeTimes->{3.8513697905649548`*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"bbfda6a1-3723-4a8a-87e1-3c73bc827793"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 6, 7, 13, 14, 16, 20, 2, 5, 12, 17, 3, 8, 11, 10, 19, 15}, {
      
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 3, 4, 6, 8, 10, 11, 11, 11, 15, 16, 18, 19, 20, 22, 23, 26, 
          28, 29}, {{3}, {4}, {5}, {8}, {2}, {6}, {2}, {6}, {2}, {6}, {7}, {
          1}, {10}, {11}, {12}, {2}, {4}, {5}, {5}, {2}, {1}, {15}, {6}, {
          9}, {13}, {17}, {7}, {8}, {5}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{-2., 1.}, {-2., 0.}}, 0.2], 
        ArrowBox[{{0., 2.}, {-2., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {-2., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {-2., 1.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 1.}, {1., 0.}}, 0.2], 
        ArrowBox[{{-1., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{-1., 4.}, {-4., 3.}}, 0.2], 
        ArrowBox[{{-1., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{-1., 4.}, {-2., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQECByA0h0Pw+RtHX8/nPxACptkdNnpIVuwy5T+w
CUyzO0jkHBTLOch3QBxMszm0Wl5cyODMd6ANTLM5/NkAUsh74C+YZnWou6Re
e0md9wCEZnVgm5d3lr+b5wAHmGZxmCEsy2XwhPvATDDN7GAMBtwHTMA0s8NF
kLZargNXwDSTQ5HM8UKZ45wHCsE0o4OwIAhwHhAC04wOG1ijgYjjwEYwzeAQ
8GuJ/68l7AcWfPGc/8Xzv/37dyDAduDeXRD4a9/32AKI2A7Igowr/GOvd6NJ
90YT64EYsEG/7c+AAcuBWTNB4Kd92ptHX89LsxwAB4/5D/tfiRONPpQwH/h8
WCn1wctv9i26IAOYDrCDrN/w1Z7Ff/uzdlcgH+zfL/ZVx/Ti/u9hPPC1J3bP
v8rP9q8m272cbMd4ABw8tZ/swcpPMRwAK5/y0X6NgbqVSALDgYhEvxKNAx/s
oREGja8P9gAYh8Qf
         "]], 0.2], ArrowBox[{{-1., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{-1., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQDQEiByC0gAOMH3z+xtHX8/nh/I0ekhW7TPkdGKF8
iZyDYjkH+eDyrZYXFzI4I/h/NoA08ML5dZfUay+pI/hs8/LO8nfzwPkzhGW5
DJ5ww/nGYIDgXwRpr+WC84tkjhfKHOeEu0dYEAQ44fIbWKOBiAPOD/i1xP/X
EnY4//07EGCD8/seWwARgq93o0n3RhMrnG8Cdg+zg0vosifGv4UP/ODW1xRq
YXIQCJ056fwb4QPMa/vOHH3E6JD6/wbn5SvCB6LEgmT9/BkdHEJSvew2A9W7
V0qvPsngsCTYLkSwQ/jAA0eW43cCGRwm/E1W9wkWPqDE8cz+2Pn/9ixB1w6/
ExE+ICbb7VMj/t+eMXCq5s8zQgdmH/q++XbVP/vWXwsisquFDmz6oV325Odf
e68PncUzDgoc4Hu93eX0mt/2j9RuxSeE8x14K2kzdWr/T/v3x6dIpxZzH/Bu
3ZHuvOi7/a7DzlL21zkOqOvq7rny5Ku9u9Tz6HdNbAdaBWdN8gz/Yj/1dN2D
ojKWAylG/18t/PnJftF1rhVnNjIdONQfc/Tu6Y/2RXbdm36bMB5YqLlJ8e/Z
D/bQBARNPx/sATaW0LQ=
         "]], 0.2], ArrowBox[{{0., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQoEHGbympsuPrTC/oSydvHXOfwOcuvXBN86vMu+
fVaS7kNNfoeqPTNFz04+am+Vskzv8DI+B41P0yd4HDtnf6/hW9lsYT4Hn5qM
s+trrtiXfQhiyyrgdXiSriTVKXbLnmXz7jt6e3kc3t+1EY+QeGDfcsLg18uf
3A6yNuatk1If2/802BQ3W43bodqP4frnT8/sE9/Yczk7czlETA4Vtb/5wt7Q
VUh98n5Oh3MtoT4hba/s37t1zvtmyunwSImhxvjXa/sZH5cU5C7jcOjPDV1y
x+StvZZr6tzvAhwO11JCj/qbvbNf7nhKZWopu8NODob7Pf/e2Qs8v8zmdoXN
wSwy9OPk3vf2KaZNzly6bA5+YaF/Uh6/t1+sc/XWw3pWB0i4fLA/AwYscH7a
m0dfz0sj+L8SJxp9KGF2YITyW3RvNOneYILLs/hvf9buiuBXHdOL+7+HEc5/
Ndnu5WQ7BB+s/BQDnL/GQN1KJAHBh0aYAwAq8Kn6
         "]], 0.2], 
        ArrowBox[{{1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-1., 5.}, {-1., 4.}}, 0.2], 
        ArrowBox[{{-1., 5.}, {-5., 4.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGDQA2IQDQEf9kNoEQfBF1kJCx++2d+wjk1M6pywg9/v6PYH
Zi/3b91fypE3Wdhhi+Xlkr3/n+yfY+x7/be/sIPj4gsaFjYP9ptw9TYdZhZ2
eJe/wm3hjav7651NuY6uE3JIvl8+UdrhyP66+655DIFCDjcuKjoGdi2117u3
b13pK0GHS7w/utNmX7CfZL/gtEq1oINk9/4k93n37ZczvzrCyyzoYM07a0tD
7GP7tZ4X1i84LuDgd+rE9rxrz+yTZV8z1HQIOJz483rXW8tX9ifqrHbMdxVw
WLSEed/f9rf2m27XrBb/x+/w6UF7gn/CB3ujq283NWTyOzhrcSS9+PjRnu/V
8baqs3wOHuuaHp+s+GzvLsWtzqrF5/Av5/uTz1++2N9N3T5ZoZ7XwU694XVl
5W/7xDf2XM7OXA5rTq7qmp/zx97QVUh98n5Oh/RDWmpazn/t37t1zvtmyulQ
JMiwT/LvX/sZH5cU5C7jcDixTSsob9Y/ey3X1LnfBTgccjateqQu/d9+ueMp
laml7A6xLA35bvX/7QWeX2Zzu8LmMHvNqh8nj/23TzFtcubSZXNQX61Vt+nj
f/vFOldvPaxndYBGmIOJMQgwO6hB5eMua6nKNTA5zIHqn32qds/XS4wOcVDz
P0jo/NypzeiQDbU/Yp/p7awuBofjUPetKTU9KnDvv30h1P2XZLbJqW7+Z58B
9Z9S0dtDQlP+2sP8P7v09sabDX/sYeEDo/nmzXY6ueknnP6ZN49bh+cHnP49
s8NtUes3OC0sH/VZW/4rnHb9JyR08sZnOD3BfPOiyk2f4PSnU1ZLbdd8hNO5
O1ZKih77AKeh6RlOAwBN9lif
         "]], 0.2], 
        ArrowBox[{{1., 1.}, {1., 0.}}, 0.2], 
        ArrowBox[{{1., 1.}, {-2., 0.}}, 0.2], 
        ArrowBox[{{-3., 3.}, {-2., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 3.}, 0.2], InsetBox["1", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 1.}, 0.2], 
         InsetBox["4", {-2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["6", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["7", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["13", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["14", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 0.}, 0.2], 
         InsetBox["16", {1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 0.}, 0.2], 
         InsetBox["20", {-2., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 4.}, 0.2], 
         InsetBox["2", {-1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-4., 3.}, 0.2], 
         InsetBox["5", {-4., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["12", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 3.}, 0.2], 
         InsetBox["17", {-2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-5., 4.}, 0.2], 
         InsetBox["3", {-5., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 4.}, 0.2], 
         InsetBox["8", {0., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["11", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 5.}, 0.2], 
         InsetBox["10", {-1., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["19", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 3.}, 0.2], 
         InsetBox["15", {-3., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.851371420643224*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"eb4f25c4-5308-46c0-a31f-296eb3a830ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "10"}],
  SequenceForm["n=", 10],
  Editable->False]], "Print",
 CellChangeTimes->{3.851371420649124*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"c3c794e7-b8b5-4649-8a39-aa43a5232d1a"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 6, 7, 8, 11, 13, 14, 16, 20, 2, 5, 12, 17, 18, 3, 9, 19, 
      15}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 5, 6, 8, 10, 11, 12, 14, 15, 15, 15, 20, 21, 23, 24, 24, 25, 
          32, 34, 35}, {{3}, {4}, {5}, {6}, {7}, {10}, {2}, {8}, {2}, {8}, {
          1}, {8}, {2}, {8}, {9}, {1}, {12}, {13}, {14}, {15}, {2}, {4}, {
          7}, {7}, {2}, {1}, {12}, {13}, {14}, {15}, {16}, {18}, {9}, {10}, {
          7}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{2.3442541571656803`, 1.723213207118645}, {
         1.6885975117018752`, 2.458174301531755}}, 0.0839723673146405], 
        ArrowBox[{{2.3442541571656803`, 1.723213207118645}, {
         1.8130147299531754`, 1.926688115713831}}, 0.0839723673146405], 
        ArrowBox[BezierCurveBox[{{2.3442541571656803`, 1.723213207118645}, {
         2.951344268884647, 2.004098902535254}, {3.6066464142740857`, 
         1.8698071459576908`}}], 0.0839723673146405], 
        ArrowBox[{{2.3442541571656803`, 1.723213207118645}, {
         2.980490985520629, 2.670838405875971}}, 0.0839723673146405], 
        ArrowBox[{{2.3442541571656803`, 1.723213207118645}, {
         2.347847356159782, 1.30336674621703}}, 0.0839723673146405], 
        ArrowBox[{{1.0008370563642783`, 1.7461213142770469`}, {0., 
         2.407220157741636}}, 0.0839723673146405], 
        ArrowBox[{{1.6885975117018752`, 2.458174301531755}, {
         1.0008370563642783`, 1.7461213142770469`}}, 0.0839723673146405], 
        ArrowBox[{{1.6885975117018752`, 2.458174301531755}, {
         2.207519576813556, 2.609371436396798}}, 0.0839723673146405], 
        ArrowBox[{{1.8130147299531754`, 1.926688115713831}, {
         1.0008370563642783`, 1.7461213142770469`}}, 0.0839723673146405], 
        ArrowBox[{{1.8130147299531754`, 1.926688115713831}, {
         2.207519576813556, 2.609371436396798}}, 0.0839723673146405], 
        ArrowBox[BezierCurveBox[{{3.6066464142740857`, 1.8698071459576908`}, {
         2.9995563025551006`, 1.588921450541082}, {2.3442541571656803`, 
         1.723213207118645}}], 0.0839723673146405], 
        ArrowBox[{{2.980490985520629, 2.670838405875971}, {2.207519576813556, 
         2.609371436396798}}, 0.0839723673146405], 
        ArrowBox[{{2.347847356159782, 1.30336674621703}, {1.0008370563642783`,
          1.7461213142770469`}}, 0.0839723673146405], 
        ArrowBox[{{2.347847356159782, 1.30336674621703}, {2.207519576813556, 
         2.609371436396798}}, 0.0839723673146405], 
        ArrowBox[{{2.207519576813556, 2.609371436396798}, {1.320480000470993, 
         3.327830041704974}}, 0.0839723673146405], 
        ArrowBox[{{1.5596787847633353`, 0.5678566237665899}, {
         2.3442541571656803`, 1.723213207118645}}, 0.0839723673146405], 
        ArrowBox[{{1.5596787847633353`, 0.5678566237665899}, {
         0.6895919435800002, 0.7617724932838865}}, 0.0839723673146405], 
        ArrowBox[{{1.5596787847633353`, 0.5678566237665899}, {
         1.8335033597780752`, 1.072299943959784}}, 0.0839723673146405], 
        ArrowBox[{{1.5596787847633353`, 0.5678566237665899}, {
         2.0329558104220915`, 0.408820801648879}}, 0.0839723673146405], 
        ArrowBox[{{1.5596787847633353`, 0.5678566237665899}, {
         0.9671422332051074, 0.}}, 0.0839723673146405], 
        ArrowBox[{{0.6895919435800002, 0.7617724932838865}, {
         1.0008370563642783`, 1.7461213142770469`}}, 0.0839723673146405], 
        ArrowBox[{{1.8335033597780752`, 1.072299943959784}, {
         1.8130147299531754`, 1.926688115713831}}, 0.0839723673146405], 
        ArrowBox[{{1.8335033597780752`, 1.072299943959784}, {
         2.347847356159782, 1.30336674621703}}, 0.0839723673146405], 
        ArrowBox[{{2.0329558104220915`, 0.408820801648879}, {
         2.347847356159782, 1.30336674621703}}, 0.0839723673146405], 
        ArrowBox[{{0.17344217608261525`, 1.304112376295764}, {
         1.0008370563642783`, 1.7461213142770469`}}, 0.0839723673146405], 
        ArrowBox[{{1.165921924342335, 1.1413009256928177`}, {
         2.3442541571656803`, 1.723213207118645}}, 0.0839723673146405], 
        ArrowBox[{{1.165921924342335, 1.1413009256928177`}, {
         0.6895919435800002, 0.7617724932838865}}, 0.0839723673146405], 
        ArrowBox[{{1.165921924342335, 1.1413009256928177`}, {
         1.8335033597780752`, 1.072299943959784}}, 0.0839723673146405], 
        ArrowBox[{{1.165921924342335, 1.1413009256928177`}, {
         2.0329558104220915`, 0.408820801648879}}, 0.0839723673146405], 
        ArrowBox[{{1.165921924342335, 1.1413009256928177`}, {
         0.9671422332051074, 0.}}, 0.0839723673146405], 
        ArrowBox[{{1.165921924342335, 1.1413009256928177`}, {
         0.17344217608261525`, 1.304112376295764}}, 0.0839723673146405], 
        ArrowBox[{{1.165921924342335, 1.1413009256928177`}, {
         0.6608781141005138, 2.4906111034792073`}}, 0.0839723673146405], 
        ArrowBox[{{0.6608781141005138, 2.4906111034792073`}, {
         1.320480000470993, 3.327830041704974}}, 0.0839723673146405], 
        ArrowBox[{{0.6608781141005138, 2.4906111034792073`}, {0., 
         2.407220157741636}}, 0.0839723673146405], 
        ArrowBox[{{3.4241066338149864`, 0.6421834625232445}, {
         2.347847356159782, 1.30336674621703}}, 0.0839723673146405]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {
         DiskBox[{2.3442541571656803, 1.723213207118645}, 0.0839723673146405],
          InsetBox["1", {2.3442541571656803, 1.723213207118645},
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0008370563642783, 1.7461213142770469}, 
          0.0839723673146405], 
         InsetBox["4", {1.0008370563642783, 1.7461213142770469},
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6885975117018752, 2.458174301531755}, 0.0839723673146405],
          InsetBox["6", {1.6885975117018752, 2.458174301531755},
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8130147299531754, 1.926688115713831}, 0.0839723673146405],
          InsetBox["7", {1.8130147299531754, 1.926688115713831},
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.6066464142740857, 1.8698071459576908}, 
          0.0839723673146405], 
         InsetBox["8", {3.6066464142740857, 1.8698071459576908},
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.980490985520629, 2.670838405875971}, 0.0839723673146405], 
         InsetBox["11", {2.980490985520629, 2.670838405875971},
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.347847356159782, 1.30336674621703}, 0.0839723673146405], 
         InsetBox["13", {2.347847356159782, 1.30336674621703},
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.207519576813556, 2.609371436396798}, 0.0839723673146405], 
         InsetBox["14", {2.207519576813556, 2.609371436396798},
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.320480000470993, 3.327830041704974}, 0.0839723673146405], 
         InsetBox["16", {1.320480000470993, 3.327830041704974},
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 2.407220157741636}, 0.0839723673146405], 
         InsetBox["20", {0., 2.407220157741636},
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.5596787847633353, 0.5678566237665899}, 
          0.0839723673146405], 
         InsetBox["2", {1.5596787847633353, 0.5678566237665899},
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.6895919435800002, 0.7617724932838865}, 
          0.0839723673146405], 
         InsetBox["5", {0.6895919435800002, 0.7617724932838865},
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8335033597780752, 1.072299943959784}, 0.0839723673146405],
          InsetBox["12", {1.8335033597780752, 1.072299943959784},
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.0329558104220915, 0.408820801648879}, 0.0839723673146405],
          InsetBox["17", {2.0329558104220915, 0.408820801648879},
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9671422332051074, 0.}, 0.0839723673146405], 
         InsetBox["18", {0.9671422332051074, 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.17344217608261525, 1.304112376295764}, 
          0.0839723673146405], 
         InsetBox["3", {0.17344217608261525, 1.304112376295764},
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.165921924342335, 1.1413009256928177}, 0.0839723673146405],
          InsetBox["9", {1.165921924342335, 1.1413009256928177},
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.6608781141005138, 2.4906111034792073}, 
          0.0839723673146405], 
         InsetBox["19", {0.6608781141005138, 2.4906111034792073},
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.4241066338149864, 0.6421834625232445}, 
          0.0839723673146405], 
         InsetBox["15", {3.4241066338149864, 0.6421834625232445},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.85137317581142*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"74628dc8-f108-49ca-a9c5-fbdd9c3e5952"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "11"}],
  SequenceForm["n=", 11],
  Editable->False]], "Print",
 CellChangeTimes->{3.851373175816906*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"1f9a121a-c262-4656-be7a-831f6600a971"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 5, 12, 16, 17, 6, 13, 14, 7, 15}, {
       SparseArray[
       Automatic, {10, 10}, 0, {
        1, {{0, 2, 2, 3, 3, 5, 6, 7, 8, 9, 10}, {{3}, {5}, {2}, {2}, {4}, {
          8}, {4}, {7}, {7}, {4}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{0., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{1., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{1., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{2., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{3., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{2., 2.}, {3., 1.}}, 0.2], 
        ArrowBox[{{3., 2.}, {3., 1.}}, 0.2], 
        ArrowBox[{{2., 1.}, {2., 0.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 2.}, 0.2], InsetBox["1", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.2], 
         InsetBox["5", {0., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["12", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 0.}, 0.2], 
         InsetBox["16", {2., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["17", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["6", {2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 1.}, 0.2], 
         InsetBox["13", {3., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["14", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.2], 
         InsetBox["7", {3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["15", {2., 1.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.851375728309404*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"0a2865b2-f75a-460e-ba9a-7c4ccf091dec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "12"}],
  SequenceForm["n=", 12],
  Editable->False]], "Print",
 CellChangeTimes->{3.85137572831252*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"c4368140-1687-457f-9369-faf81afca959"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 8, 9, 10, 11, 13, 14, 16, 18, 19, 20, 6, 7, 15, 
      17}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 6, 7, 8, 9, 10, 11, 13, 14, 16, 20, 20, 20, 20, 21, 21, 27, 
          32, 36, 39}, {{2}, {5}, {9}, {10}, {13}, {14}, {8}, {15}, {15}, {
          3}, {15}, {3}, {6}, {7}, {11}, {12}, {3}, {4}, {11}, {12}, {15}, {
          4}, {8}, {11}, {12}, {13}, {14}, {4}, {8}, {9}, {13}, {14}, {3}, {
          4}, {11}, {12}, {5}, {10}, {13}}}, Pattern}], Null}, {
      EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 5.}, {5., 4.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQpEHOKKnwiEvz+5X9L8XqDiGWGHFVXs3E6yd/eL
Prr8vatb2KHs4f3DiRYv9n9lePjRxk7YYe6RZf+793zcv20yq4P5EyGHkKhn
txM1fuyPnuX4qLJWyOHWxnVlm+L/738kMvUGC5eQw6yn/5/bbWQ+4MPMoHyj
U9DB4PKbz4kSHAdmpTYd/PxHwGGDoly801OeA6esZbaEJws4ZGlxt/D18B7Y
lr9pab6ngENVj4SstTzfgWYnndJ76gIO99zdtE7M4zsQmSHs6vGX32FSzJTV
W7n4D2R2To1unM3vMPsU00LmZP4DFi/u6WZo8Tt8nziRa9Ny/gOHWt7v/rOS
z2H5JocXB27wH+CIP85qL8XnsEpHwMrgG/8B3vI0bv1qXgdIuAgcOHsGBHjg
/PQ3j76el0bwfyVONPpQwu3ACOW36N5o0r3BBZdn8d/+rN0Vwa8+phf3fw8n
nP9qst3LyXYIPlj5KQ44f42BupVIAoIPoTkcAMBlph0=
         "]], 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQpEHGbympsuPrTC/snEqTurzgk7yK1fE3zr8C57
Z9+N0z5MEXao2jNT9Ozko/ayRsHTE4OFHTQ+TZ/gceycfb5D9e6znMIOPjUZ
Z9fXXLG3rtBkNt0h5PAkXUmqU+yWfdPN2LzpcUIO7+/aiEdIPLB3SpH4++WP
oIOsjXnrpNTH9jUSket9Jws6VPsxXP/86Zm9wTf51oWKgg4Rk0NF7W++sJ+h
1Dn55H0Bh3MtoT4hba/sKxa7+P+eJeDwSImhxvjXa/szFUE7zIIFHPpzQ5fc
MXlrP3XRpnPVHAIO11JCj/qbvbNf4XhKZWopv8NODob7Pf/e2Qs8v8zmdoXP
wSwy9OPk3vf2KaZNzly6fA5+YaF/Uh6/t1+ic/XWw3peB0i4fLA/ewYEeOD8
9DePvp6XRvB/JU40+lDC7cAI5bfo3mjSvcEFl2fx3/6s3RXBrz6mF/d/Dyec
/2qy3cvJdgg+WPkpDjh/jYG6lUgCgg+hORwAxiCqJQ==
         "]], 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQpEHH5qnenkY12xf2X6m0dfzws73H957c8Gj537
I5bw2NydJewwxe7lZLuXh/fzbEvg3pYg7ABRd3r/4TkvAhoUhR0kK3aZ2utc
2l8H1iDkIJZzEIiu7bcHaZss5HCOv3tK4/Lb+1n8tz9rdxVymLex+7p9/oP9
IFslPgk6GIPB4/2zZoKAoMNWkDXcz/a/Amm3E3Sw6HsMRC/2W4JpAYc9u0Hg
9f6uDhAQcAA7b/K7/TeadIFIwAGsfduH/QG/lvj/WsLvoAQGn/Z/eAcCfA6P
wQZ+3g82zoLPYak/SOGX/XpgA3gd0sDg2/6zZ0CAx8FA3Uok4cT3/WBvS/M4
8AJDRV7s5/5fiRONPpRwO4Ct8f+1vwVk/Q0uB4j4b6h/uRy4ixc5M7b92V99
TC/u/x5OB4g9f6H+43RIAinP/rcfrPwUh8MKcAD9378GbDGHAzSiDkAoDgcA
3t/Y5A==
         "]], 0.2], ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQpEHGCslelvHn09LwznRyzhsbk7C8Hn2ZbAvS0B
wT8850VAgyKCXwfWIATn27+cbPdyMoLP4r/9Wbsrgn+mk49V4pMgnD9rJggI
OizctHIV8+yc/eszpwrxO8D4Pfv9ntrdq3op4FBV8p/fSHzB/kqeaX/uTBWA
yq/Zr3N/Vq6pq4BD/+SQu1KR2/Zf2zUrieM9P1T9gf1ZfNH9kyL5HY68WXlu
3bOj+wV2liVynuKD6j+z/9yutzdyHPgcuJL/B0pIXdo/X/jA1z17eB2OtU/8
esvk5n62874LU27yOCi6tF30P39/f435eVYxNh4HvjPvinZ/ebT/n4+L8kUn
bodbB70lVxx8ur+Lf+3Pqf1cDmXMt27n+r3Yr1zP2ZnyhtPh0YSZu3hmv9p/
YnbkRZtITgeZrK6tLcvf7K9MnXtJ7hqHg3r/mjNXi9/tN79zpYcrmQMaPh/2
Q2gOBwC5t6oJ
         "]], 0.2], ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQpEHH4Wp53In3nZ/tQ7O+09p4UdnlzbXX9O8Zn9
7QNhsd86hR2iXvu8XFj/yd6ozH3aOithh21z0t51G/22P8cneO3JXSGHo/VT
l1+awuSwoWuzzMxiIYfnnGdZy404HG681Ms6/VvQ4eibm4LGRXwObjrN+6rL
BB30Re6lMq8ScvgZuEFy1WMBh4h7OyV/Zos5fIraVh3mLOAw6+qXi0cOiDmI
xjz4q2og4NBVvH/DNG5xh+rs9QJNIgIOGjskt+X5iDu4CLlnXH3A71C4mPmR
T7O4g3BW5YX97fwO6aa1JoYbxB3S7n2NPCzL78CV17ZW+rK4g03+HpYHi/gc
onzlfXneiDtMkTl7QVSczyH8srsw829xh4Jn6vtSqngdIOEi4XD2DAjwOPwH
A3GH9DePvp6X5oHL/0qcaPShhNuBEcpv0b3RpHuDCy7P4r/9Wbsrgl99TC/u
/x5OOP/VZLuXk+0QfLDyUxxw/hoDdSuRBAQfQnM4AAB6DKN3
         "]], 0.2], 
        ArrowBox[{{5., 4.}, {5., 3.}}, 0.2], 
        ArrowBox[{{-2., 1.}, {4., 0.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcDlCGw38wYHdYPm9j93X7//Yw+aSJRh9Ksv/Z
M0L5ejeadG80/YXL8xQvcmZs+wPn/0oEafiN4C/xByGEepu7s+TFfsL5hupW
IgknvsP5aWDwzT571asDauwcDjuWhXrZMHy137xyFfNsGQ4H86m/K14v/Wx/
6a/9iRgHDocHhhGfisM/2Z9atoovp4jDYUNN9rarIh/t5yx5de3EJg6HiNdZ
XYp73tt7fP+vUMzI6bDIMsfWK+2t/Zl5r95kxXE6OD251aqq8dpea/Yqqw0n
OR1MX29L3sz40j7xjT2XszOXQ7Ufw/XPn57Z/zDYFDdbjdtBxsa8dVLqY/vm
Ewa/Xv7kdnh/10Y8QuKBPcvm3Xf09vI4PEtXkuoUu2Vf9iGILauA18GnJuPs
+por9ncbvpXNFuZzUP80fYLHsXP2linL9A4v43Oo3jNT9Ozko/bts5J0H2ry
O8itXxN86/Au+1PK2sVf5/A7zOM1N118aAU0fARg8cUAAB8Srm4=
         "]], 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQECByA0hwOMH3L+xtHX89nh/E0ekhW7TNkdGKF8
8ZyDYjkH2eDybZYXFzI4I/h/N4A0sML5dZfUay+pI/gc8/LO8nezwPkzhWW5
DJ4ww/kmxiDA7NBtWej05Rv/gQlSfuz7m5gcdJ8d4bx4m/9AynMu18q7jA7P
WH+HTlvHf2DLzMw3ic6MDptmCKu75PMfqDHM+luxhcFh2jy+2luy/Af2ruOp
2GfA4DBB/E145C6+Ax+VFu1IKfhvv4B5zfYDLnwHojbnhayc+s/+RJLfHIG9
vAe28dUf9rr4157F9DKrpzLvAQj9117T3D7Eipn7AIT+bW+4QX7uIV7OAxD6
p73kgpIHD53YD0Do7/aP2OzkZixiPQChv9r3PKkOe6rDcgBCf7GXsNTrPPmQ
6QCE/mTfwhK6zeUg4wEI/dH+ktuHu2GnGQ5A6A/20AiDxtcHewDmAKJk
         "]], 0.2], 
        ArrowBox[{{4., 1.}, {4., 0.}}, 0.2], 
        ArrowBox[{{4., 2.}, {-2., 1.}}, 0.2], 
        ArrowBox[{{4., 2.}, {4., 1.}}, 0.2], 
        ArrowBox[{{5., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQUHIBSHA4wfcv7G0dfz2eH8TR6SFbtM2R0YoXzx
nINiOQfZ4PJtlhcXMjgj+H83gDSwwvl1l9RrL6kj+Bzz8s7yd7PA+TOFZbkM
njDD+SbGIIDgXwFpr2WC8wtljgMRI9w9QoIgwAiX38gavYE1mgHOX/DFc/4X
z//2MP69uyDwF86XBRlX+AfOj9kAMuA3nD9rJgj8hPPBwWP+A87/fFgp9cHL
b/Yw97CDrN/wFS7PDvbvFzj/a0/snn+Vn+F8cPDUfoLzwcqnfITzIxL9SjQO
fIDzIdQHewD8y3WQ
         "]], 0.2], ArrowBox[{{-2., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQDQESDhCaw+E/GIg7hJy/cfT1fHYHmPwmD8mKXabs
DoxQvnjOQbGcg2xw+TbLiwsZnBH8vxtAGljh/LpL6rWX1BF8jnl5Z/m7WeD8
mcKyXAZPmOF8E2MQYIa75wpIey0TXL5Q5jgQMcLdIyQIAoxw+Y2s0RtYoxng
/AVfPOd/8fxvD+PfuwsCf+F8WZBxhX/g/JgNIAN+w/lpYPDN/sgcC8Wq3+IO
sqZz+OpYv9qLFz9qefFW3OHEOdGuT7s+239u+qvlfV3cIcP48o3DbZ/sI890
Ci/aLu7wPenKr48ZH+29/dvt3vaJO1THSn6oSfxgf4L722qdWHGHh64uhScf
vLO/wHgtOkFJ3GFL2t0VQdpv7VMM1f067ok5ZMv+a5u66LV906yXTUsmijlw
ZC3jnuT2yn7qbHmtuY2iDkF5dStK2J7ZS97o93vYJuKQmGBv1Sr9yJ43wOpD
wUJhh5SGS43t3Hfti5jl+X0uCjm0Sf+oSOi6Zu/2yXZ1kZiQg/6k95FTN1+w
75GZfuRJgaDDrhOFnj58x+2dmrSiFz0QcLD0CEj1Ftljn6n8I291qoCD9i2O
fbezVkLDR8ABlpIAYO7JuA==
         "]], 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcDhBawOE/GLA7BJ+/cfT1fH4HmPxGD8mKXab8
DoxQvkTOQbGcg3xw+VbLiwsZnBH8PxtAGnjh/LpL6rWX1BF8tnl5Z/m7eeD8
GcKyXAZPuOF8YzDghrvnIkh7LRdcvkjmeKHMcU64e4QFQYATLr+BNRqIOOD8
gF9L/H8tYYfz378DATY4v++xBRAh+Ho3mnRvNLHC+WfAgAXunrQ3j76el2aB
y/9KnGj0oYQZ7p4WXZABTHB5Fv/tz9pdEfyqY3px//cwwvmvJtu9nGyH4IOV
n2KA89cYqFuJJCD40IhzAADBa3Eq
         "]], 0.2], 
        ArrowBox[{{3., 4.}, {5., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcDhBawKH/YIkvy2k2B73XavmMM/kd4jS+hhv7
sTrI7wiUFZTid8gxaZTv7WR2uJDWwKXfzOew86nEEsFaRge775vMoq/wOnRV
VJxuDPxnn5v5cuFUXl4H1YJrJ0wlf9rH7FX2uafH42C7ydvBPvCzPdfnRFNT
C26HNbUbkm0+v7Sv4loSO0uTy2F1+IdSL88b9iuYXx3hZeZ0eP9+VVquwWX7
TXIsapMOcTik7zdtVU86a19euOumYwmHw3vfBuHqaUftP/zmeSAjweHwXCz7
w6rfe+0V9v22UF7HDtW/2Z5jR9uTEDN2qPql9stern20cQMbVH6y/Z+gQmMr
WTaHL2B+sT3nlwvX3lazOsBC6AwYsMD5aW8efT0vjeD/Spxo9KGEGc5v0b3R
pHuDCc5n8d/+rN0Vwa86phf3fw8jnP9qst3LyXYIPlj5KQY4f42BupVIAoIP
BQ4AaCyYHQ==
         "]], 0.2], ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcDhBawCHk/I2jr+ezOwSDaX6HTR6SFbtM2R02
gml+B/Gcg2I5B9kcJMA0n0Ob5cWFDM5sDq1gms/h7waQQlaHP2Ca16Huknrt
JXVWKM3rwDEv7yx/N4sDG5jmcZgpLMtl8ITZYQaY5nYwMQYBZgcwZcztcAWk
rZbJ4SKY5nIolDkORIwORWCa00FIEAQYHYTBNKfDRtboDazRDA4bwDSHw4Iv
nvO/eP63D/i1xP/XEnaHe3dB4K/9+3cgwOYgCzKm8I9932MLIGJziAFr/G2v
d6NJ90YTq8OsmSDw0/4MGLA4gIPF/Id92ptHX89Lszh8PqyU+uDlN/tfiRON
PpQwO7CDrN3w1b5FF2QAkwM72J9f7Fn8tz9rd2Vy+NoTu+df5Wf7qmN6cf/3
MDqAg6X2k/2ryXYvJ9sxOoCVT/loD1Z+isEhItGvROPAB/s1BupWIgkM0Hj6
YA+NOAcAE1u2Hw==
         "]], 0.2], ArrowBox[{{3., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{3., 4.}, {6., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQECDuh08PkbR1/P54fzN3pIVuwy5XdghPIlcg6K
5Rzkg8u3Wl5cyOCM4P/ZANLAC+fXXVKvvaSO4LPNyzvL380D588QluUyeMIN
5xuDAbfD5FBR+5s/+B1iLmupyjVwOfiFhf5JeczvMOdU7Z6vlzgdDJgOmC/e
z+/wSULn505tTgezyNCPk3v5HSL2md7O6uJwSIkW1TT35Xe4tmtWEsd7docd
HAz3e/7xOWTyRfdPimR3MEkUFZ66kM9BYGdZIucpNodrKaFH/c34HM7sensj
x4HNYb7wga979vA6zAPTrA5s530XptzkgdIsDjXm51nF2HigNIvDPx8X5YtO
3A5/wTSzQxf/2p9T+7mgNJODcj1nZ8obTgclMM3ocGJ25EWbSE4ozehQmTr3
ktw1DijN4GB+50oPVzIHlGaAhg8HlGZwAAC4y4ya
         "]], 0.2], 
        ArrowBox[{{4., 4.}, {5., 3.}}, 0.2], 
        ArrowBox[{{4., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{4., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{4., 4.}, {6., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcB6C0w38wYD8Qcv7G0dfz2R1g8ps8JCt2mbI7
MEL54jkHxXIOssHl2ywvLmRwRvD/bgBpYIXz6y6p115SR/A55uWd5e9mgfNn
CstyGTxhhvNNjEGA2WFSqKj9zR/sB+Iua6nKNTA5+IWF/kl5zH5g9qnaPV8v
MTroMx0wX7yf/cAHCZ2fO7UZHUwjQz9O7mU/ELHP9HZWF4NDcrSoprkv+4E1
paZHBe79t9/BwXC/5x/bgUsy2+RUN/+zN0kUFZ66kO2AUtHbQ0JT/tpfTQk9
6m/GdmB26e2NNxv+2M8TPvB1zx7WA3bqDa8rK3/bs533XZhyk+UA37zZTic3
/bSvMT/PKsbGcuBn3jxuHZ4f9n99XJQvOjEf+D2zw21R6zf7Lv61P6f2Mx0Q
lo/6rC3/1V6pnrMz5Q3jAdd/QkInb3y2PzE78qJNJOOBCeabF1Vu+mRfmTr3
ktw1hgOfTlkttV3z0d78zpUermSGA7k7VkqKHvtgD40waHx9sAcADOWsWA==

         "]], 0.2], ArrowBox[{{-3., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[{{-3., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{-3., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {-4., 3.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {-2., 3.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {-1., 3.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 5.}, 0.2], InsetBox["1", {0., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 4.}, 0.2], 
         InsetBox["2", {5., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 1.}, 0.2], 
         InsetBox["3", {-2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.2], 
         InsetBox["4", {3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-4., 3.}, 0.2], 
         InsetBox["5", {-4., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 1.}, 0.2], 
         InsetBox["8", {4., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 2.}, 0.2], 
         InsetBox["9", {4., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 3.}, 0.2], 
         InsetBox["10", {5., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["11", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 3.}, 0.2], 
         InsetBox["13", {-2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["14", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["16", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["18", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{6., 3.}, 0.2], 
         InsetBox["19", {6., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 0.}, 0.2], 
         InsetBox["20", {4., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 4.}, 0.2], 
         InsetBox["6", {3., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 4.}, 0.2], 
         InsetBox["7", {4., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 3.}, 0.2], 
         InsetBox["15", {-3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 4.}, 0.2], 
         InsetBox["17", {-2., 4.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.851377924450595*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"567eedfd-6f09-467b-b135-b70e08e10652"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "13"}],
  SequenceForm["n=", 13],
  Editable->False]], "Print",
 CellChangeTimes->{3.8513779244819393`*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"41944629-447b-4646-9c11-61b20c725348"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 8, 9, 10, 11, 14, 15, 18, 20, 5, 6, 7, 12, 17, 19}, {
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 5, 6, 7, 8, 9, 11, 12, 13, 13, 15, 15, 15, 16, 21, 23, 25, 28,
           29}, {{2}, {4}, {8}, {10}, {11}, {7}, {12}, {12}, {12}, {3}, {5}, {
          6}, {9}, {3}, {9}, {3}, {2}, {4}, {8}, {10}, {11}, {1}, {16}, {2}, {
          11}, {2}, {10}, {11}, {3}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 5.}, {3., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {-1., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {2., 4.}}, 0.2], 
        ArrowBox[{{3., 4.}, {3., 3.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGDQA2IQjQoEHGCs4PM3jr6ezw/nb/SQrNhliuBL5BwUyznI
B+e3Wl5cyOCM4P/ZANLAC+fXXVKvvaSO4LPNyzvL380D588QluUyeMIN5xuD
AYJ/EaS9lgvOL5I5XihznBPOFxYEAQR/A2s0EHHA+QG/lvj/WsIO579/BwJs
cH7fYwsgQvD1bjTp3mhihfNNwO5hhvOvgN3DBOcXgt3DCOcLgd2D4G8Eu4cB
zl/wxXP+F8//9jD+vbsg8BfOlwUZV/gHzo8Be+g3nJ8GBt/g/MX+IA9+gfPB
3un7DOcrK4HAJzg/kXtbAve2D3C+/cvJdi8nv4Pz9+wGgddwviU4gF7A+SDd
CdzP4HxIfD2G8+dt7L5un/8Azj/H3z2lcfltOF8cnH6uwfmg1GWvcwnOX5H+
5tHX86fh/Cl2IAcehvMfvLwGTGI74fx/Wmc6+VhXwPkwAADpQp0z
         "]], 0.2], 
        ArrowBox[{{2., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{2., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{3., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{-1., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQDQEf7CG0gAOMH3z+xtHX8/nh/I0ekhW7TPkdGKF8
iZyDYjkH+eDyrZYXFzI4I/h/NoA08ML5dZfUay+pI/hs8/LO8nfzwPkzhGW5
DJ5ww/nGYIDgXwRpr+WC84tkjhfKHOeEu0dYEAQ44fIbWKOBiAPOD/i1xP/X
EnY4//07EGCD8/seWwARgq93o0n3RhMrnG8Cdg+zg86zI5wXb7+3nyDlx76/
iclh8wxhdZf89/Ypz7lcK+8yOkwSfxMeueud/ZaZmW8SnRkdjif5zRHY+9a+
xjDrb8UWBofwKqsvmeVv7Peu46nYZ8Dg4BC3IT715Sv7j0qLdqQU/Ldv4ttw
j0n4pX3U5ryQlVP/2ct1WxY6fXlmv42v/rDXxb/2Ald8xFV6n9izmF5m9VT+
a++z8+fCS5I37DXN7UOsmH/bczD/vqh554C94Qb5uYd4f9q/+ZP98fDi7fsl
F5Q8eOj03f7LCX4++9eX9j9is5Obseir/aLbCj5XZ9zb3/OkOuypzhf7xdLu
t29WPNkvYanXefLhJ/tPb1ervf31Yn8LS+g2l4Mf7Xc/setYcunN/ktuH+6G
nYalmw/7YeEEAFcS2/Q=
         "]], 0.2], ArrowBox[{{1., 4.}, {-1., 3.}}, 0.2],
         ArrowBox[{{-2., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{1., 5.}, {3., 4.}}, 0.2], 
        ArrowBox[{{1., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{1., 5.}, {-1., 4.}}, 0.2], 
        ArrowBox[{{1., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[{{1., 5.}, {2., 4.}}, 0.2], 
        ArrowBox[{{3., 6.}, {0., 5.}}, 0.2], 
        ArrowBox[{{3., 6.}, {3., 5.}}, 0.2], 
        ArrowBox[{{3., 5.}, {3., 4.}}, 0.2], 
        ArrowBox[{{3., 5.}, {2., 4.}}, 0.2], 
        ArrowBox[{{2., 5.}, {3., 4.}}, 0.2], 
        ArrowBox[{{2., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[{{2., 5.}, {2., 4.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {-1., 1.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 5.}, 0.2], InsetBox["1", {0., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 4.}, 0.2], 
         InsetBox["2", {3., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["3", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 4.}, 0.2], 
         InsetBox["4", {0., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["8", {2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["9", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.2], 
         InsetBox["10", {3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 4.}, 0.2], 
         InsetBox["11", {-1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["14", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.2], 
         InsetBox["15", {1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 4.}, 0.2], 
         InsetBox["18", {2., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.2], 
         InsetBox["20", {0., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["5", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 5.}, 0.2], 
         InsetBox["6", {1., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 6.}, 0.2], 
         InsetBox["7", {3., 6.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 5.}, 0.2], 
         InsetBox["12", {3., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 5.}, 0.2], 
         InsetBox["17", {2., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["19", {-1., 2.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.851381715943028*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"0d01ba15-4a41-4ea8-89f5-6968c4dcb1ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "14"}],
  SequenceForm["n=", 14],
  Editable->False]], "Print",
 CellChangeTimes->{3.8513817159478483`*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"f5e0eaa0-36fd-423d-ac9c-93ace900cb4c"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 5, 12, 17, 6, 7, 13, 16, 11, 2, 4, 8, 9, 10, 19, 15}, {
       SparseArray[
       Automatic, {16, 16}, 0, {
        1, {{0, 2, 2, 3, 4, 5, 6, 7, 7, 15, 15, 15, 15, 15, 15, 15, 16}, {{
          3}, {4}, {2}, {2}, {6}, {7}, {8}, {1}, {6}, {10}, {11}, {12}, {
          13}, {14}, {15}, {10}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{0., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{1., 1.}, {1., 0.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-6., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-5., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-4., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-3., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{-6., 3.}, {-6., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 2.}, 0.2], InsetBox["1", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 0.}, 0.2], 
         InsetBox["5", {-1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["12", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["17", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["6", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["7", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["13", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 0.}, 0.2], 
         InsetBox["16", {1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 3.}, 0.2], 
         InsetBox["11", {-2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-6., 2.}, 0.2], 
         InsetBox["2", {-6., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-5., 2.}, 0.2], 
         InsetBox["4", {-5., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-4., 2.}, 0.2], 
         InsetBox["8", {-4., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 2.}, 0.2], 
         InsetBox["9", {-3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["10", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["19", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-6., 3.}, 0.2], 
         InsetBox["15", {-6., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.851385360478747*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"6e1ff13b-14a1-40c7-8e99-d0741399c0d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "15"}],
  SequenceForm["n=", 15],
  Editable->False]], "Print",
 CellChangeTimes->{3.851385360508172*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"48e82a0b-a0ce-4e4b-9a0f-3edfc3b7b747"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 3, 4, 7, 13, 16, 19, 20, 2, 5, 6, 8, 9, 10, 11, 12, 14, 17}, {
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 3, 4, 5, 8, 10, 10, 11, 11, 12, 13, 17, 18, 19, 20, 21, 24, 
          25, 27}, {{2}, {4}, {5}, {8}, {8}, {3}, {6}, {7}, {3}, {6}, {8}, {
          2}, {2}, {2}, {3}, {6}, {7}, {8}, {2}, {2}, {6}, {2}, {5}, {7}, {
          6}, {2}, {5}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQo4HOKKnwiEvz+53yhvz2KnGewOK6rYuZ1k7+7X
PrL8vag4u0PZw/uHEy1e7H/JeOhxZQ2bw9wjy/537/m4P1eduyHvBKtDSNSz
24kaP/ZvM2k+8vkXi8OtjevKNsX/339UU2sjpwiLw6yn/5/bbWQ+MIuNwW2D
MLODweU3nxMlOA6YnGZpfv6T0WGDoly801OeA1PKLTLWH2NwyNLibuHr4T2Q
fz/F+/4kBoeqHglZa3m+A6ytEa/2+DM43HN30zoxj+/A5gtqXRN+/befFDNl
9VYu/gOXhLS3M5n/t599imkhczL/gbwLe6MvhPyz/z5xItem5fwHmjjvl/8M
/mu/fJPDiwM3+A8I7OvjrjP5Y79KR8DK4Bv/AYl3Z8Tivv2yh4SLwIFZM0Hg
J5x//sbR1/PNf8D5nw8rpT54+c2eEcpnj97AGr3hK1yefV7eWf7uL3D+157Y
Pf8qP8P5l9RrgegTnA9WPuUjnB+R6FeiceADnA+hP9gDAC7TtHM=
         "]], 0.2], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{-4., 1.}, {-4., 0.}}, 0.2], 
        ArrowBox[{{0., 1.}, {-4., 0.}}, 0.2], 
        ArrowBox[{{1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{1., 1.}, {-4., 0.}}, 0.2], 
        ArrowBox[{{-9., 2.}, {-4., 1.}}, 0.2], 
        ArrowBox[{{-8., 2.}, {-4., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {-4., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{-5., 1.}, {-4., 0.}}, 0.2], 
        ArrowBox[{{-7., 2.}, {-4., 1.}}, 0.2], 
        ArrowBox[{{-6., 2.}, {-4., 1.}}, 0.2], 
        ArrowBox[{{-3., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQUOEIrDAcYPOX/j6Ov57HD+Jg/Jil2m7A6MUL54
zkGxnINscPk2y4sLGZwR/L8bQBpY4fy6S+q1l9QRfI55eWf5u1ng/JnCslwG
T5jhfBNjEGB2iPSV9+V5899+kuQNx9mtTA4ZprUmhhv+2+c8NtJ/9YLRQWOH
5LY8n//2xyY4/5aPZXSYdfXLxSMH/tnPVuRaZvOIweFgL1+HMe8/+3dT2/Qd
Khgc5jxIu7HL8K/9vrc7pmvJMzhonvt7KErvj71YkNPe72v/22eFXXYXZv5t
v6a/jiPD/r99XOXztCfrf9pbT1ETXPbpn33Rwg960gFP7eV22M0ML/xjv9k4
8dG5Oyf2v/X7zCqo9ss++cbpF8pm7/cviXAJvyTww76C4eqGqGu/9jtdNeyd
bfjNfunGMxy70pgOnDiye3lOxxf74K5Ibv0DbAes1B8tcxX9bO/BJZjQU851
YPKfJV1qNz7aNxp+ZrvUw3vgmgtLMP/FD/aQ4BE4AKE/2AMAf8ClUg==
         "]], 0.2], 
        ArrowBox[{{2., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQUOEIrDYbWBupVIAoNDyPkbR1/PZ3fw3/6s3fUU
g8MmD8mKXabsDq8m272cbMfoIJ5zUCznIJtD9TG9uP97GB3aLC8uZHBmc2AG
a2By+LsBpIHVoVn3RpPuDSaHukvqtZfUWR1+Jk40+lDC7MAxL+8sfzeLQ8ab
R1/PS7M4zBSW5TJ4wuxwBgxYHEyMQYDZ4dWuALUP2awOqrM8cu43MDm05xUU
Ot9lddj59MuNX1cZHRY81153TIHN4ZOoRWWrEaODsVrznUozNodzWkK+9dMY
HFy0yv7EyLE5+Kk0h7xgZHC4+JmFr+AGq8MjFjH5xpf/7G816QtuTmF1KOgK
/sN/7699wvWvrGqHWRzcb+5zqH34xz7pY/ibE5+ZHZLB9G/7nYz1F3OEmRx2
gelf9m7tLK6aYQwOHmD6h70Iy8XeP+V/7bmbXrj92/3NnvlJ6Lrrnb/smT5p
XX/t8tU+ft30148ffrc3uH7668cPn+3Vk6e5KjZ8tZ9ieHqRwIFP9pFMQXv6
Uz7b6zJq3nPf9NH+e/cpf/3+j/Z/XJ8un378gz0knhA0ABYnwK4=
         "]], 0.2], 
        ArrowBox[{{-2., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEiByA0hwOMH3L+xtHX89nh/E0ekhW7TNkdGKF8
8ZyDYjkH2eDybZYXFzI4I/h/N4A0sML5dZfUay+pI/gc8/LO8nezwPkzhWW5
DJ4ww/kmxiDA7HByVdf8nD/CB+Iua6nKNTA5qK3Wqtv0UfjA7FO1e75eYnSQ
YHww++J94QMfJHR+7tRmdJi9ZtWPk8eED0TsM72d1cXgsGlt15TZy4QPrCk1
PSpw7799DEtDvlu98IFLMtvkVDf/s5+1oavzVIDwAaWit4eEpvy1z9m06pG6
NND80tsbbzb8sb/A+aAq7p7QATv1hteVlb/tW54vC9iUI3SAb95sp5Obftrv
n/2ciZtZ6MDPvHncOjw/7BvUFk3MWCh44PfMDrdFrd/sj7Vf+3PKXfCAsHzU
Z235r/aT9re4GH0TOOD6T0jo5I3P9k/OrsmYt0bgwATzzYsqN32y37vJL5M/
W+DAp1NWS23XfLSXyctyazUUOJC7Y6Wk6LEP9pDwEYDG1wd7AICZr2k=
         "]], 0.2], 
        ArrowBox[{{-5., 3.}, {0., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 3.}, 0.2], InsetBox["1", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-4., 1.}, 0.2], 
         InsetBox["3", {-4., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["4", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["7", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["13", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["16", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["19", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-4., 0.}, 0.2], 
         InsetBox["20", {-4., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-9., 2.}, 0.2], 
         InsetBox["2", {-9., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-8., 2.}, 0.2], 
         InsetBox["5", {-8., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["6", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-5., 1.}, 0.2], 
         InsetBox["8", {-5., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-7., 2.}, 0.2], 
         InsetBox["9", {-7., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-6., 2.}, 0.2], 
         InsetBox["10", {-6., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 2.}, 0.2], 
         InsetBox["11", {-3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["12", {2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["14", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-5., 3.}, 0.2], 
         InsetBox["17", {-5., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.851388642425065*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"c71da65c-f41d-493f-be15-46733d9f685b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "16"}],
  SequenceForm["n=", 16],
  Editable->False]], "Print",
 CellChangeTimes->{3.851388642429821*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"d09ceae9-50b9-4d3d-bc2e-69374e3e6542"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 8, 9, 10, 15, 20, 4, 5, 6, 7, 12, 13, 17, 19}, {
       SparseArray[
       Automatic, {16, 16}, 0, {
        1, {{0, 2, 3, 4, 5, 7, 8, 9, 9, 10, 11, 12, 14, 15, 18, 20, 21}, {{
          2}, {7}, {6}, {8}, {8}, {3}, {4}, {5}, {3}, {8}, {3}, {1}, {1}, {
          13}, {2}, {1}, {13}, {15}, {2}, {7}, {6}}}, Pattern}], Null}, {
      EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 5.}, {2., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{2., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{0., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{1., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQjQoEHGCs4PM3jr6ezw/nb/SQrNhliuBL5BwUyznI
B+e3Wl5cyOCM4P/ZANLAC+fXXVKvvaSO4LPNyzvL380D588QluUyeMIN5xuD
AYJ/EaS9lgvOL5I5XihznBPOFxYEAQR/A2s0EHHA+QG/lvj/WsIO579/BwJs
cH7fYwsgQvD1bjTp3mhihfNNwO5hhvOvgN3DBOcXgt3DCOcLgd2D4G8Eu4cB
zl/wxXP+F8//9jD+vbsg8BfOlwUZV/gHzo8Be+g3nD9rJgj8hPPB0WX+A87/
fFgp9cHLb3A+O8j6DV8RfHD4f4Hzv/bE7vlX+RnOB0dX7Sc4H6x8ykc4PyLR
r0TjwAc4HwI+2AMAPjN8fg==
         "]], 0.2], 
        ArrowBox[{{-1., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-1., 6.}, {0., 5.}}, 0.2], 
        ArrowBox[{{0., 6.}, {0., 5.}}, 0.2], 
        ArrowBox[{{0., 6.}, {1., 5.}}, 0.2], 
        ArrowBox[{{1., 5.}, {2., 4.}}, 0.2], 
        ArrowBox[{{1., 6.}, {0., 5.}}, 0.2], 
        ArrowBox[{{1., 6.}, {1., 5.}}, 0.2], 
        ArrowBox[{{1., 6.}, {2., 5.}}, 0.2], 
        ArrowBox[{{2., 5.}, {2., 4.}}, 0.2], 
        ArrowBox[{{2., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{1., 4.}, {1., 3.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 5.}, 0.2], InsetBox["1", {0., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 4.}, 0.2], 
         InsetBox["2", {2., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["3", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["8", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["9", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["10", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 4.}, 0.2], 
         InsetBox["15", {0., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.2], 
         InsetBox["20", {0., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["4", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["5", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 6.}, 0.2], 
         InsetBox["6", {-1., 6.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 6.}, 0.2], 
         InsetBox["7", {0., 6.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 5.}, 0.2], 
         InsetBox["12", {1., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 6.}, 0.2], 
         InsetBox["13", {1., 6.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 5.}, 0.2], 
         InsetBox["17", {2., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.2], 
         InsetBox["19", {1., 4.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.851391962405098*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"b3eab40b-32c3-4385-acfb-9e5b46303488"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "17"}],
  SequenceForm["n=", 17],
  Editable->False]], "Print",
 CellChangeTimes->{3.851391962409178*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"ed10b791-b896-458e-9639-729bda435528"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 8, 9, 10, 11, 13, 14, 16, 18, 20, 6, 7, 12, 15, 
      19}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 4, 5, 6, 7, 8, 9, 11, 12, 14, 19, 19, 19, 19, 19, 24, 28, 29, 
          32, 33}, {{2}, {5}, {9}, {10}, {8}, {14}, {14}, {3}, {14}, {3}, {
          6}, {7}, {11}, {12}, {3}, {4}, {11}, {12}, {13}, {4}, {8}, {11}, {
          12}, {13}, {4}, {8}, {9}, {13}, {1}, {3}, {4}, {11}, {14}}}, 
         Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 5.}, {4., 4.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQjQpEHNRucey7nbVzv/e7Zg+ts8IOlh4Bqd4iZ/bf
35d1aV2/sMPOE4WePnzX9+8u3DK3113YQX/S+8ipmx/sv8uWuOrYFyGHdukf
FQldz/Z71BX8iJwu5JDUcKmxnfvt/l/XH7W76ws5JCbYW7VKf9r/RXhHRP8e
QYfgvLoVJWzf9psZfcgytBd04Mhaxj3J7df+/Ubd+3S3Czj0HZ1joVj1e3+Q
jYL/2m4BByf2iPzGzj/7NYOfrJoaJeCgpH9j/aaSv/tdy69ffKYs4KBjK/tr
i/W//c6Bn9sdz/M7pBiq+3Xc+7e/5dxUpnZvfocT3N9W68T+3++XNk143h4+
h4gzncKLtv/fP0fi6642JT4HseJHLS/e/t9f9HTjD4daXgdowBwwBgNuOP+i
eu0l9VouOL9I5nihzHFOB0YoX1gQBDjh8htYo4GIA84P+LXE/9cSdjj//TsQ
YIPz+x5bABGCr3ejSfdGEyucfwYMWOD8tDePvp6XRvB/JU40+lDCDHdPiy7I
ACa4PIv/9mftrgh+1TG9uP97GOH8V5PtXk62Q/DByk8xwPlrDNStRBIQfCjt
AACisNFs
         "]], 0.2], ArrowBox[{{0., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{4., 4.}, {5., 3.}}, 0.2], 
        ArrowBox[{{2., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQDQEcDjD6PxiwO4Scv3H09Xx2uPgmD8mKXabsDoxQ
vnjOQbGcg2xw+TbLiwsZnBH8vxtAGljh/LpL6rWX1BF8jnl5Z/m7WeD8mcKy
XAZPmOF8E2MQYIa75wpIey0TXL5Q5jgQMcLdIyQIAoxw+Y2s0RtYoxng/AVf
POd/8fxvD+PfuwsCf+F8WZBxhX/g/JgNIAN+w/lpYPDNflKoqP3NH+wOO5aF
etkwfLX3Cwv9k/KY3cF86u+K10s/2+szHTBfvJ/d4YFhxKfi8E/2ppGhHyf3
sjtsqMnedlXko31ytKimuS+7Q8TrrC7FPe/td3Aw3O/5x+awyDLH1ivtrb1J
oqjw1IVsDk5PbrWqary2v5oSetTfjM3B9PW25M2ML+3nCR/4umcPq0O1H8P1
z5+e2bOd912YcpPFQcbGvHVS6mP7GvPzrGJsLA7v79qIR0g8sP/r46J80YnZ
4Vm6klSn2C37Lv61P6f2Mzn41GScXV9zxV6pnrMz5Q2jg/qn6RM8jp2zPzE7
8qJNJKND9Z6ZomcnH7WvTJ17Se4ag4Pc+jXBtw7vsje/c6WHK5nBYR6vueni
Qyug4QMLZwYGANLRxWk=
         "]], 0.2], ArrowBox[{{-2., 2.}, {2., 1.}}, 0.2],
         ArrowBox[{{5., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{5., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{5., 2.}, {5., 1.}}, 0.2], 
        ArrowBox[{{5., 3.}, {5., 2.}}, 0.2], 
        ArrowBox[{{1., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQjQoEHH5qnenkY12xP/j8jaOv5/M73H957c8Gj537
N3pIVuwy5XeYYvdyst3Lw/slcg6K5Rzkc1iZ/ubR1/On97daXlzI4MznAFJl
r3NpP1ATkMnrIAZWd21/3SX12kvqvA7n+LunNC6/vZ9tXt5Z/m4eh3kbu6/b
5z/YP0NYlsvgCbeDMRg83g+huR2kkwK/LV3zdH+flB/7/iYuh4uTf1suzni+
P/U5l2vlXU6HoBOG/7TSX+zfNjPzTaIzp8O8/5+dbFe82F9jmPW3YguHww5L
J45b2i/271vHU7HPgMNhfpmMH+OnZ/srBQNjjHawOwRsaxLZ/OvJ/jWR5quu
eLE7nPtREv3e9dH+mPb9iUtfsDmIvWpOWvv2p/1y5ldHeJkZHVhcQpc9Mf5t
v0mORW3SIQYHEY9I/t3Bf+xLC3fddCxhcHD51j/XwPev/YffPA9kJBgcJvn9
DHBV+GdvX/O90C3mvz1j4FTNn2f+2QsU8J5cmfPPfuLfZHWf4P/2fpejjyYn
/rV3CEn1stv83/7H0kdpJVZ/7AVCZ046/+a/vfCLhWtvf/9lD40oh1kzQeAn
nA+OLvMfcP7nw0qpD15+s2eE8tmjN7BGb/gKl2cHh/8XOP9rT+yef5Wf4Xxw
dNV+gvPByqd8hPMjEv1KNA58gPMh1Ad7AKHJ9eQ=
         "]], 0.2], 
        ArrowBox[{{0., 4.}, {3., 3.}}, 0.2], 
        ArrowBox[{{0., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{0., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{0., 4.}, {2., 3.}}, 0.2], 
        ArrowBox[{{2., 4.}, {3., 3.}}, 0.2], 
        ArrowBox[{{2., 4.}, {5., 3.}}, 0.2], 
        ArrowBox[{{2., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{2., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{2., 4.}, {2., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQESDhBaxOE/GIg7rEx/8+jreWEHmHzEEh6bu7OE
HRihfJ5tCdzbEhDyh+e8CGhQRPDrwBqE4Hz7l5PtXk5G8Fn8tz9rd0Xwz3Ty
sUp8EoTzZ80EAUEH59BlT4x/izv8aZ0uwukk6CAYOnPS+TfiDk1h7s+SPgo4
pP6/wXn5iriDHvdKvuXLBRwcQlK97DYD1S/e03s1RcBhSbBdiGCHuMMHhabk
dxoCDpP+Jqv7BIs7CLF8ln/8nN+BLeja4Xci4g5dfa5q+7r5HZgCp2r+PCPm
4Pfw981cW36Htl8LIrKrxRwi/4haf/rD5+D9obN4xkERh7av0YtSr/E6FAq/
1d+gLezwjWfeqVPHeRx+JJ/q3bRT0GGZ053Nihe5He49VOydny3gMGWaWFzW
Jy4HD6nn0e+a+BwOc/ieXKLN5TDtdN2DojIeB6OZ9V8v1HA6LLnOteLMRi6H
h+7rHr17yuFQZNe96bcJp8NFkZsT/qVxQMMHQQMAEcKj6Q==
         "]], 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQESDhBaxCF0hrAsl4GEw8r0N4++nhd2WBH9+bBS
qoRDxBIem7uzhB2+es7/4jlfwoFnWwL3tgRhB7tk8fX19yQcDs95EdCgKOzQ
tBykQdKhDqxByOGQWM5BsRxJB/uXk+1eThZy+LfBQ7Jil6QDi//2Z+2uQg6m
ZR9/PeeVcjjTyccq8UnQIT0NBKQcZs0EAUGH0lgN4R9bpRyEfVW25TsIOjib
79ix8J2Uw52iqpy/rwQcLnwWDU8WkHb4xTVnj9NMAQepyY7vbKSlHdJFO5fZ
ews4KIla1+nxSzuoT3LU+sIg4PCikond4o2UQxFTd/+BEn6HvIPTOyI3STlY
HNX8x/6ez2HD619MkxOlHBblxC/YV8DnsPGHdtmTn5JQmtfhTsP+jG2cklCa
12GJc9MiEW0JKM3jwOpYovw/VtyBDUxzOzBUTn1dukjMgQlMcznMeP30V8UP
USjN6XBqRmogR4IolOZ0mNYg8l75pgiU5nD4t+jT5dPJIlCaAx5PEJrDAQCK
N7IX
         "]], 0.2], ArrowBox[{{6., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQESDhBaxGFl+ptHX8+LQ2lhh8glPDZ3Z4k7RIBp
YQeebQnc2xLEobSww+E5LwIaFMWhtLBDPVihmEMdmBZysH852e7lZDEoLeTA
4r/9WburGJQWcjjbyccq8UnU4QyYFnSYNRMERKG0oAPvqvtLbtqIOnjyLm+O
dxR0OPksXX3pHRGHTcWti/a8E3A442+k+KdCxOH2GZNvGxYKOIg/tZt0T1DE
YZ/E1jqbKAGHVct6q3yWCzvEh7PZxEsIOLRMkbvlainsUCkYGGO0g99h+bqP
G04dF3JYE2m+6ooXv4PgV7b/t4KEHGLa9ycufcHncDg97kjZLUGHplkvm5ZM
5HOIz9Tfn+0k4DB1trzW3EZeB8+O9a8XT+F1kLjR7/ewjcdB9cO6C0FPuBz4
Aqw+FCzkdgjkitV9UszhUMQsz+9zkcvh4rWdjBHObA5un2xXF4lxOSwKPeq7
LojFoUdm+pEnBZwOR9vqBZ8vZHJwatKKXvSAw8Eq64UPkyGjQ6byj7zVqRzQ
eGKA0hwOANQDsJM=
         "]], 0.2], ArrowBox[{{0., 6.}, {0., 5.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQDQEcDhBawMHszpUermQOhxPK2sVf5/A7VKbOvSR3
jcOhfVaS7kNNfocTsyMv2kRyOlilLNM7vIzPQameszPlDafDvYZvZbOF+Ry6
+Nf+nNrP5VD2IYgtq4DX4a+Pi/JFJ24Hls277+jt5XGoMT/PKsbG49BywuDX
y5/cDhznfRem3ORx+GmwKW62GrfDfOEDX/fs4XVIfGPP5ezM5XAtJfSovxmf
g6GrkPrk/ZwOJomiwlMX8jm8d+uc982U02EXB8P9nn98DjM+LinIXcbhkBwt
qmnuy++g5Zo697sAh4NpZOjHyb38DssdT6lMLWV30Gc6YL54P7+DwPPLbG5X
2Bz8wkL/pDzmd0gxbXLm0mVzmBIqan/zB7/DYp2rtx7Ws8LDxcQYBJgdui0L
nb5843eYIOXHvr+JyUH32RHOi7eB+p9zuVbeZXR4xvo7dNo6foctMzPfJDoz
OmyaIazuks/vUGOY9bdiC4PDtHl8tbdk+R32ruOp2GfA4DBB/E145C4+h49K
i3akFPy3X8C8ZvsBFz6HqM15ISun/rM/keQ3R2Avr8M2vvrDXhf/2rOYXmb1
VOZ1gNB/7TXN7UOsmLkdIPRve8MN8nMP8XI6QOif9pILSh48dGJ3gNDf7R+x
2cnNWMTqAKG/2vc8qQ57qsPiAKG/2EtY6nWefMjkAKE/2bewhG5zOcjoAKE/
2l9y+3A37DSDA4T+YA9NQNBw+mAPANfU5XI=
         "]], 0.2], 
        ArrowBox[{{3., 4.}, {3., 3.}}, 0.2], 
        ArrowBox[{{3., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{1., 1.}, {2., 0.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 5.}, 0.2], InsetBox["1", {0., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 4.}, 0.2], 
         InsetBox["2", {4., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["3", {2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.2], 
         InsetBox["4", {3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["5", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 1.}, 0.2], 
         InsetBox["8", {5., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 2.}, 0.2], 
         InsetBox["9", {5., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 3.}, 0.2], 
         InsetBox["10", {5., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.2], 
         InsetBox["11", {1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 4.}, 0.2], 
         InsetBox["13", {0., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["14", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 3.}, 0.2], 
         InsetBox["16", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["18", {2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 0.}, 0.2], 
         InsetBox["20", {2., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 4.}, 0.2], 
         InsetBox["6", {2., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{6., 5.}, 0.2], 
         InsetBox["7", {6., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 6.}, 0.2], 
         InsetBox["12", {0., 6.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 4.}, 0.2], 
         InsetBox["15", {3., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["19", {1., 1.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.851396045372436*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"24221ff6-879b-4ce8-a390-c3225f0f8a51"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "18"}],
  SequenceForm["n=", 18],
  Editable->False]], "Print",
 CellChangeTimes->{3.8513960453776693`*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"cfc27f81-9461-4423-b2c0-9fdcf474ef19"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{}, {}]]}, 
    TagBox[GraphicsGroupBox[{{}, {}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  PlotRange->NCache[{{0, 
      Rational[4, 3]}, {0, 1}}, {{0, 1.3333333333333333`}, {0, 1}}]]], "Print",\

 CellChangeTimes->{3.851400062672958*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"17275983-5c58-4114-966f-154521477832"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "19"}],
  SequenceForm["n=", 19],
  Editable->False]], "Print",
 CellChangeTimes->{3.851400062674625*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"3b91443d-6d41-412d-933c-31e6a29e9af1"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 3, 8, 15, 16, 18, 20, 2, 4, 5, 6, 14, 7, 9, 10, 11, 12, 13, 
      17}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 4, 5, 6, 7, 7, 7, 7, 9, 10, 11, 15, 15, 17, 19, 20, 21, 23, 
          26, 29}, {{3}, {4}, {5}, {6}, {7}, {7}, {2}, {2}, {3}, {7}, {2}, {
          4}, {5}, {6}, {12}, {1}, {12}, {2}, {3}, {14}, {12}, {2}, {3}, {
          4}, {5}, {12}, {4}, {5}, {6}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQo4HIy9Xqb/mnho/0ll7eKvc9gdwpsP7nssdGV/
x6wk3Yea7A4xvsYXbuo92G+Zskzv8DI2h7lfC3O2iTzff6/hW9lsYTaHol0y
W9h3v9tf9iGILauA1eH12ZmXn034vJ9l8+47entZHJ753FZqUfmxv+WEwa+X
P5kdtG5dOh4t8Xf/T4NNcbPVmB3uWDk8NDNjPJD4xp7L2ZnJYVLTeY2tfUwH
jFyF1CfvZ3R4VFw759pk5gPv3TrnfTNldDjJ52Uz25XlwIyPSwpylzE4uAWb
cjAvYTmg5Zo697sAg0O0oz0D33qWAwHNUzy1Xv+zZ7+ZrrInjeWA0rnlvD0r
/tr7SK0v4T3NfOBEFku7SNQfe3VW0Y+Md5gOuEeu2nr4/y/7mWDAeGAWmP5p
f+7G0dfzzRkOnAfTP+yftbueOnD57/7Ph5VSH7z8Zs+zLYF7W8Lv/ezRG1ij
N3y157G5O0te7Od+9nl5Z/m7v9i/ktxd8ffzt/1fe2L3/Kv8bL/U/9cS/19f
9l9SrwWiT/Zg5Zqf94OVT/lov+HQnBcBDR/3RyT6lWgc+GAPiacP+6G0PQDs
EdbM
         "]], 0.2], ArrowBox[{{0., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{0., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{3., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{-2., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{2., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[{{2., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{2., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{2., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{0., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQoEHOKKnwiEvz9pb5i3Z7HTDH6HFVXs3E6yd+21
jyx/LyrO71D28P7hRIsX9q8YDz2urOFzmHtk2f/uPR/tc9S5G/JO8DqERD27
najxw36bSfORz794HG5tXFe2Kf6//TFNrY2cIjwOs57+f263kdlhJhuD2wZh
bgeDy28+J0pwOJicZml+/pPTYYOiXLzTUx6HKeUWGeuPcThkaXG38PXwOuTe
T/G+P4nDoapHQtZans+BpTXi1R5/Dod77m5aJ+bxOURmCLt6/GV3mBQzZfVW
Ln6HrM6p0Y2z2R1mn2JayJzM72D24p5uhha7w/eJE7k2Led3ONjyfveflWwO
yzc5vDhwg9+BI/44q70Um8MqHQErg2/8Djzladz61awOsHA5AwYscH7am0df
z0sj+L8SJxp9KGF2YITyW3RvNOneYILLs/hvf9buiuBXHdOL+7+HEc5/Ndnu
5WQ7BB+s/BQDnL/GQN1KJAHBh0aYAwBiBZfK
         "]], 0.2], 
        ArrowBox[{{5., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{5., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{6., 3.}, {5., 2.}}, 0.2], 
        ArrowBox[{{5., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{3., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[{{3., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{3., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 3.}, 0.2], InsetBox["1", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["3", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["8", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.2], 
         InsetBox["15", {3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["16", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["18", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 0.}, 0.2], 
         InsetBox["20", {-1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["2", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 1.}, 0.2], 
         InsetBox["4", {-2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["5", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["6", {2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 2.}, 0.2], 
         InsetBox["14", {4., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 4.}, 0.2], 
         InsetBox["7", {0., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 2.}, 0.2], 
         InsetBox["9", {5., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{6., 3.}, 0.2], 
         InsetBox["10", {6., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 3.}, 0.2], 
         InsetBox["11", {5., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["12", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.2], 
         InsetBox["13", {3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["17", {1., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.851403670264434*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"af445455-3a37-4891-b4d5-4a0c7edd46e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "20"}],
  SequenceForm["n=", 20],
  Editable->False]], "Print",
 CellChangeTimes->{3.8514036702693987`*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"73886b9c-cdd6-48fd-9f93-1dc236771551"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 6, 7, 13, 16, 19, 2, 5, 12, 17, 3, 9, 10, 15, 8, 11, 14}, {
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 3, 3, 6, 9, 11, 11, 11, 15, 16, 18, 19, 21, 22, 23, 25, 26, 
          27, 28}, {{3}, {4}, {5}, {2}, {6}, {7}, {2}, {6}, {7}, {2}, {6}, {
          1}, {9}, {10}, {11}, {2}, {4}, {5}, {5}, {13}, {15}, {14}, {8}, {
          1}, {11}, {13}, {6}, {6}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{0., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{0., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{0., 1.}, {1., 0.}}, 0.2], 
        ArrowBox[{{1., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{1., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{1., 1.}, {1., 0.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQUO6PTyeRu7r9v/t4fxkyYafSjJ/mfPCOXr3WjS
vdH0Fy7PU7zImbHtD5z/KxGk4TeCv8QfhBDqbe7Okhf7CecbqluJJJz4Duen
gcE3e7HiRy0v3v63lzWdw1fH+tU+6kyn8KLt/+1PnBPt+rTrs/0p7m+rdWL/
22cYX75xuO2TfYqhul/HvX/235Ou/PqY8dFex1b21xbrf/bVsZIfahI/2Cvo
31i/qeSv/UNXl8KTD97ZO7JH5Dd2/rHfknZ3RZD2W/u+o3MsFKt+22fL/mub
uui1PUfWMu5Jbr+g9Cv7oLy6FSVs36D0M/vEBHurVulPUPqRfUrDpcZ27rdQ
+q59m/SPioSuZ1D6mr3+pPeRUzc/gNIX7HedKPT04bsOpY/bW3oEpHqLnIHS
e+y1b3Hsu521E0qvhIUPHAAA5JetZg==
         "]], 0.2], 
        ArrowBox[{{1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{-1., 6.}, {0., 5.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQDQEf9kNoCQcYf2X6m0dfz4vD+ZFLeGzuzhJ3YITy
ebYlcG9LQMgfnvMioEERwa+PAGkQg/PtX062ezkZwWfx3/6s3RXBP9vJxyrx
SRTOnzUTBBB8sHY7BN+y77FF32MRuHs6O0BABC5/s0n3RpMugq9Re0m99pIw
nF9RDgII/vFCGSBC8MVzDorlHBRCc48gnP8K7B4EH+IeAbh7usDuEYDL3wC7
B8EP+LXE/9cSfjj/wzsQ4IPzwcZZIPh6YAN4EeF1BgR44HxwdEkj+L8SJxp9
KOGGu6cFZP0NLrTwR/Crj+nF/d/DieY/BB+s/BQHnL/GQN1KJAHBh9AcDgBf
gL43
         "]], 0.2], ArrowBox[{{0., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{0., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{-1., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{-1., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{0., 6.}, {0., 5.}}, 0.2], 
        ArrowBox[{{-3., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{-2., 1.}, {-1., 0.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 2.}, 0.2], InsetBox["1", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.2], 
         InsetBox["4", {0., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["6", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["7", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["13", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 0.}, 0.2], 
         InsetBox["16", {-1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 0.}, 0.2], 
         InsetBox["19", {1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 3.}, 0.2], 
         InsetBox["2", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["5", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["12", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["17", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 6.}, 0.2], 
         InsetBox["3", {-1., 6.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 5.}, 0.2], 
         InsetBox["9", {0., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 4.}, 0.2], 
         InsetBox["10", {0., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["15", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 6.}, 0.2], 
         InsetBox["8", {0., 6.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 1.}, 0.2], 
         InsetBox["11", {-3., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 1.}, 0.2], 
         InsetBox["14", {-2., 1.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Print",
 CellChangeTimes->{3.851405736435101*^9},
 CellLabel->
  "During evaluation of \
In[379]:=",ExpressionUUID->"c85877bc-9345-41e3-9663-94e78247e861"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"adjustmentList", ":", " ", 
    RowBox[{
    "each", " ", "entry", " ", "is", " ", "of", " ", "the", " ", "form", " ", 
     
     RowBox[{"{", 
      RowBox[{"vertex", ",", 
       RowBox[{"{", 
        RowBox[{"deltax", ",", "deltay"}], "}"}]}], "}"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"adjustGraph", "[", 
     RowBox[{"graph_", ",", "adjustmentList_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "i", ",", "\[IndentingNewLine]", "adjustedGraph", ",", "index", ",", 
        "vertex", ",", "adjustment", ",", "vertexCoords"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vertexCoords", "=", 
        RowBox[{"Chop", "[", 
         RowBox[{
          RowBox[{"GraphEmbedding", "[", "graph", "]"}], ",", 
          RowBox[{"10", "^", 
           RowBox[{"(", 
            RowBox[{"-", "3"}], ")"}]}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "1"}], ",", 
         RowBox[{"i", "\[LessEqual]", 
          RowBox[{"Length", "[", "adjustmentList", "]"}]}], ",", 
         RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"vertex", "=", 
           RowBox[{
            RowBox[{"adjustmentList", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"adjustment", "=", 
           RowBox[{
            RowBox[{"adjustmentList", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"index", "=", 
           RowBox[{"VertexIndex", "[", 
            RowBox[{"graph", ",", "vertex"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"vertexCoords", "[", 
            RowBox[{"[", "index", "]"}], "]"}], "+=", "adjustment"}], ";"}]}],
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"adjustedGraph", "=", 
        RowBox[{"Graph", "[", 
         RowBox[{"graph", ",", 
          RowBox[{"VertexCoordinates", "\[Rule]", "vertexCoords"}]}], "]"}]}],
        ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "adjustedGraph", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.8515112587962112`*^9, 3.851511375579916*^9}, {
  3.851511450164933*^9, 3.851511665480669*^9}, {3.851511703709929*^9, 
  3.851511902812015*^9}, {3.8515121226808567`*^9, 3.8515121294794407`*^9}},
 CellLabel->
  "In[580]:=",ExpressionUUID->"298e19e3-681d-4c75-bdd3-2517d1b44d6a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g1", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{"graph", "[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8515119177509727`*^9, 3.851511933686061*^9}},
 CellLabel->
  "In[574]:=",ExpressionUUID->"c96e9dcb-d7c2-45f4-bad3-f951151ab19f"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{2, 3, 8, 9, 10, 20, 4, 5, 6, 14, 16, 18, 19, 7, 11, 15, 12, 13, 
      17}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 1, 2, 3, 5, 6, 6, 7, 8, 13, 14, 14, 14, 15, 20, 21, 24, 30, 
          33, 36}, {{5}, {6}, {6}, {2}, {3}, {4}, {6}, {2}, {5}, {7}, {10}, {
          12}, {13}, {11}, {6}, {4}, {12}, {13}, {15}, {16}, {10}, {2}, {7}, {
          10}, {4}, {7}, {8}, {12}, {13}, {15}, {2}, {7}, {10}, {8}, {12}, {
          16}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{1., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{0., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{0., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{2., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{6., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJwtkmtIk2EARrc5p9+WbmW4+b31QywvM0VNRdL4nlCXlwoxxRhkJFreHUkS
UmoxLzMI1Azd1tLKmZdKF0QXVLAoG4iaaSVlM4ylSU3S6UyzRA88nP+Hxz2t
IDGDw2Kx9v7fhjeRYNMi0PnZsvJACQY8fAsXtUL0GI5lCXMkqFSn+U35CDE9
2Jmp65TgQLre/4XeGbV9yqggqwSTZdYijYszXlaOrxoPu6HIksjLVjihxPN2
TWazG7iPnn/y79mGXo2ZI7CjoRwIWJmxCaA06xMMuTRsAYZUjacAw5SpOHWS
xuk5hh8ZyUeOof2rFyEIjN7hVddHQd1VrTImEPySqXTWEAonuWUFslKChvm7
ijy9Iwz3q69r9ATS6IybSyJHqDvbl9+8Img9ZNxTf94BYrZJM/KFQGQe5cne
8eDZIS0xzBOkh1yJ5PvxYGyvvpW7SnBn39jEVKn9VpddCN6/gR0WfAcb+X8I
6vrVHrHlHIw/DD4rnSNQVB583Gxmo+lqaOapUYKhy+RHhJyN5L632rYugo7u
4H76MwuLcZQ9pSRwFKvCwxUslPlPNF06SjDdLUnRubCwkBWtcHAiuMh97VN1
bZ1JWosr1PfTCBKNzpxwXWd032fb5Pk0vlUk/3zQ+5cZ4oU1yuVitITVFcfE
rDL32K5DsVU7kcS+cK6Zt8L4flTGey9vh8VkN/7UtsS00tTuueNCFL0Pbalx
tzLxEdKAM+ECzE6LTN4lCwzEecO9egccoWorSoW/GWXHyNpiPRfaqGcN9WPz
DG1LeSKgOPhwQ+WaM2xhtg601cnC/ANj//E4
         "]], 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQDQESDhBawCFD+Ufe6lQJh2l32CeGzOJ3cGrSil70
QMJhX+3VJbHy/A49MtOPPCmQdCh7nGEt3c/n4PbJdnWRmJTDLt5DIb0veR0K
meX5fS5KOfT/efBhsx6vA0+A1YeChdIOX9Yf5e+P43GQuNHv97BNxuGFesFG
uUpuh2mz5bXmNso6ZKc8uJpUx+XQNOtl05KJcg51qWK10XmcDimG6n4d9+Qc
llQ4zIsS53Q4z3gtOkFJ3iFk2YlQ7a0cDqe4v63WiZV36Hi3bvFZdw4Hb/92
u7d98g5OgZ/bHc+zO0Se6RRetF3eoeXcVKZ2b3aHz01/tbyvyzv4pE0TnreH
zUGs+FHLi7fyDrMlvu5qU2JzODbHQrHqt7xD4dONPxxqWaHhouBgYgwCzA5H
ofITpPzY9zcxOYhD9ac853KtvMvo8AVq/paZmW8SnRnh9tcYZv2t2MIAd9/e
dTwV+wwYHE5A3f9RadGOlIL/9heg/ovanBeycuo/e5j/t/HVH/a6+NceFj4s
ppdZPZX/2k+Fhp+muX2IFfNve1j4Gm6Qn3uI96c9HzT8JReUPHjo9N2+CBo/
j9js5GYs+moPi7+eJ9VhT3W+2MPiV8JSr/Pkw0/2sPhvYQnd5nLwo30mNH1c
cvtwN+z0B3vU9PPBHgDgIO+N
         "]], 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQESDhBawGFl+ptHX8+LOwSfv3H09Xx+h8glPDZ3
Z4k7bPSQrNhlyu/Asy2Be1uCuINEzkGxnIN8DofnvAhoUBR3aLW8uJDBmc+h
PgKkQczhzwaQBl4H+5eT7V5OFnOou6Ree0md14HFf/uzdlcxB7Z5eWf5u3kc
znbysUp8EnWYISzLZfCE22HWTBAQdTAGA24HsHY7UYeLIO21XA6WfY8t+h6L
OBTJHC+UOc7p0NkBAiIOwoIgwOlws0n3RpOuiMMG1mgg4nDQAGm7JOwQ8GuJ
/68l7A4V5SAg7PD+HQiwOYBMKZQRdgAba8HmIA72l5CD3g2QQawOaWAg5HAG
DFgcTMo+/nrOK+SQBgomaRaHv2B/Cjr8Spxo9KGE2eGQGMgAQYcWkDNuMDk0
LY/+fFhJEOpvJge7ZPH19fcEHKqO6cX938Po8MVzPhAJOLwC+5PRYQVIeaqA
A1j5KQaHMHDACDisMVC3EklggMcTNOIcAGkorkU=
         "]], 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQESDhBawOE/GIg7BJ+/cfT1fH4HmPxGD8mKXab8
DoxQvkTOQbGcg3xw+VbLiwsZnBH8PxtAGnjh/LpL6rWX1BF8tnl5Z/m7eeD8
GcKyXAZPuOF8YzDgdjixqmt+zh9xh5jLWqpyDVwO6qu16jZ9FHeYc6p2z9dL
nA4SjA9mX7wv7vBJQufnTm1Oh9lrVv04eUzcIWKf6e2sLg6HTWu7psxeJu5w
bdesJI737A4xLA35bvXiDpl80f2TItkdZm3o6jwVIO4gsLMskfMUm0P2plWP
1KXFHc7sensjx4HN4Tzng6q4e2IO84QPfN2zh9Wh6fmygE05Yg5s530Xptxk
cdg7+zkTN7OYQ435eVYxNhaHerVFEzMWijr89XFRvujE7HCk/dqfU+6iDl38
a39O7WdymLS/xcXom4iDUj1nZ8obRocnZ9dkzFsj4nBiduRFm0hGhz2b/DL5
s0UcKlPnXpK7xuAgnZfl1moo4mB+50oPVzIDNHxEoDSDAwDKVZsa
         "]], 0.2], 
        ArrowBox[{{6., 1.}, {6., 0.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEiDlCGA1Msr47JHGEH5l1SERkW/+0z618L3FET
drj875riDt9/9ubps9Z9ny/kkHvOJPa9/V/7DBEp1nZ2IYeLGiZcfPx/7P+3
ZYl0xQo6/OO9qiGy+5f9733ddxgWCTh8qxXfyejy035Hxe9d11byO0Do7/au
/xr0Jr/hdYDQX+3n8K0QNufhcYDQX+zX1dy8NF+D22GHmuP+JrnP9jlneYNS
vLgc+kvXMH9Q/GR/nsF1Ykshp4Pc75cP6sQ+2l8Tq5/AMI/D4WTe57VxP97b
t/Pv8b9xnt3hZMj200zL3trfe/X7HDc7u4PVCnnpV6av7e+ssOOb7czmIJOp
M0dkxQv7Rs8W3rZWVof86Xf9mv48tT8DBiwOxmDw2D7tzaOv56VZHOZt7L5u
n//A/lfiRKMPJcwO5/i7pzQuv23fonujSfcGk4N4zkGxnIPX7Fn8tz9rd2Vy
kKzYZWqvc8m+6phe3P89jA4r0kEGnbZ/Ndnu5WQ7RocpIOrlYXuw8lMMDg9e
XvuzwWOn/RoDdSuRBAaHf1pnOvlYV9jD4gkWcwBLisKZ
         "]], 0.2], 
        ArrowBox[{{4., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{4., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{4., 3.}, {5., 2.}}, 0.2], 
        ArrowBox[{{4., 3.}, {6., 2.}}, 0.2], 
        ArrowBox[{{4., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{6., 2.}, {6., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {6., 1.}}, 0.2], 
        ArrowBox[{{3., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcDjD6PxiwO4Scv3H09Xx2uPgmD8mKXabsDoxQ
vnjOQbGcg2xw+TbLiwsZnBH8vxtAGljh/LpL6rWX1BF8jnl5Z/m7WeD8mcKy
XAZPmOF8E2MQYHaYFCpqf/MHu0PcZS1VuQYmB7+w0D8pj9kdZp+q3fP1EqOD
PtMB88X72R0+SOj83KnN6GAaGfpxci+7Q8Q+09tZXQwOydGimua+7A5rSk2P
Ctz7b7+Dg+F+zz82h0sy2+RUN/+zN0kUFZ66kM1BqejtIaEpf+2vpoQe9Tdj
c5hdenvjzYY/9vOED3zds4fVwU694XVl5W97tvO+C1NusjjwzZvtdHLTT/sa
8/OsYmwsDj/z5nHr8Pyw/+vjonzRidnh98wOt0Wt3+y7+Nf+nNrP5CAsH/VZ
W/6rvVI9Z2fKG0YH139CQidvfLY/MTvyok0ko8ME882LKjd9sq9MnXtJ7hqD
w6dTVktt13y0N79zpYcrmcEhd8dKSdFjH+yhEQYNpw/2AL4inlg=
         "]], 0.2], 
        ArrowBox[{{3., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{3., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{3., 3.}, {5., 2.}}, 0.2], 
        ArrowBox[{{3., 3.}, {6., 2.}}, 0.2], 
        ArrowBox[{{1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {6., 1.}}, 0.2], 
        ArrowBox[{{2., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{2., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{2., 3.}, {2., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 4.}, 0.2], InsetBox["2", {0., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["3", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["8", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["9", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 3.}, 0.2], 
         InsetBox["10", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 0.}, 0.2], 
         InsetBox["20", {2., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["4", {2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["5", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{6., 4.}, 0.2], 
         InsetBox["6", {6., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{6., 1.}, 0.2], 
         InsetBox["14", {6., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{6., 0.}, 0.2], 
         InsetBox["16", {6., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 2.}, 0.2], 
         InsetBox["18", {4., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 2.}, 0.2], 
         InsetBox["19", {5., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 3.}, 0.2], 
         InsetBox["7", {4., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{6., 2.}, 0.2], 
         InsetBox["11", {6., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["15", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.2], 
         InsetBox["12", {3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["13", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["17", {2., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{{3.851511927118742*^9, 3.85151193463197*^9}},
 CellLabel->
  "Out[574]=",ExpressionUUID->"e4243abf-ad9a-48eb-a023-a0a2da9567b2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g1a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g1", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"6", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "3"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"14", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"16", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "}"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.851531956955948*^9, 3.851531983451578*^9}, {
  3.851532024679771*^9, 3.851532037123769*^9}, {3.851532109653364*^9, 
  3.8515321505241623`*^9}, {3.8515323021501617`*^9, 3.851532308092828*^9}},
 CellLabel->
  "In[868]:=",ExpressionUUID->"05367271-2e22-4c60-b868-35d33f633f70"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{2, 3, 8, 9, 10, 20, 4, 5, 6, 14, 16, 18, 19, 7, 11, 15, 12, 13, 
      17}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 1, 2, 3, 5, 6, 6, 7, 8, 13, 14, 14, 14, 15, 20, 21, 24, 30, 
          33, 36}, {{5}, {6}, {6}, {2}, {3}, {4}, {6}, {2}, {5}, {7}, {10}, {
          12}, {13}, {11}, {6}, {4}, {12}, {13}, {15}, {16}, {10}, {2}, {7}, {
          10}, {4}, {7}, {8}, {12}, {13}, {15}, {2}, {7}, {10}, {8}, {12}, {
          16}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, GraphLayout -> {"Dimension" -> 2}, ImageSize -> 600, 
       VertexCoordinates -> {{1, 3.}, {1., 1.}, {0, 1.}, {0, 2.}, {0, 3.}, {
         2., 0}, {2., 1.}, {3., 2.}, {3., 1.}, {4., 1.}, {4., 0}, {4., 2.}, {
         5., 2.}, {4., 3.}, {6., 2.}, {2., 2.}, {3., 3.}, {1., 2.}, {2., 3.}},
        VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{1., 3.}, {0., 3.}}, 0.2], 
        ArrowBox[{{1., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{0., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{0., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{2., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{3., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{3., 1.}, {0., 3.}}, 0.2], 
        ArrowBox[{{3., 1.}, {2., 1.}}, 0.2], 
        ArrowBox[{{3., 1.}, {4., 1.}}, 0.2], 
        ArrowBox[{{3., 1.}, {4., 2.}}, 0.2], 
        ArrowBox[{{3., 1.}, {5., 2.}}, 0.2], 
        ArrowBox[{{4., 1.}, {4., 0.}}, 0.2], 
        ArrowBox[{{5., 2.}, {2., 0.}}, 0.2], 
        ArrowBox[{{4., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{4., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{4., 3.}, {5., 2.}}, 0.2], 
        ArrowBox[{{4., 3.}, {6., 2.}}, 0.2], 
        ArrowBox[{{4., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{6., 2.}, {4., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {4., 1.}}, 0.2], 
        ArrowBox[{{3., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{3., 3.}, {2., 1.}}, 0.2], 
        ArrowBox[{{3., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[{{3., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{3., 3.}, {5., 2.}}, 0.2], 
        ArrowBox[{{3., 3.}, {6., 2.}}, 0.2], 
        ArrowBox[{{1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {4., 1.}}, 0.2], 
        ArrowBox[{{2., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[{{2., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{2., 3.}, {2., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{1., 3.}, 0.2], InsetBox["2", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["3", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["8", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["9", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 3.}, 0.2], 
         InsetBox["10", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 0.}, 0.2], 
         InsetBox["20", {2., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["4", {2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.2], 
         InsetBox["5", {3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 1.}, 0.2], 
         InsetBox["6", {3., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 1.}, 0.2], 
         InsetBox["14", {4., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 0.}, 0.2], 
         InsetBox["16", {4., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 2.}, 0.2], 
         InsetBox["18", {4., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 2.}, 0.2], 
         InsetBox["19", {5., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 3.}, 0.2], 
         InsetBox["7", {4., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{6., 2.}, 0.2], 
         InsetBox["11", {6., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["15", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.2], 
         InsetBox["12", {3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["13", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["17", {2., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{
  3.8515319849886*^9, {3.851532030049403*^9, 3.8515320381542177`*^9}, 
   3.851532119902264*^9, 3.851532151545109*^9, 3.851532309752716*^9},
 CellLabel->
  "Out[868]=",ExpressionUUID->"29879111-6f53-462d-9b37-1813ac125023"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g2", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{"graph", "[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851512704537434*^9, 3.851512707672917*^9}},
 CellLabel->
  "In[588]:=",ExpressionUUID->"b2cc8906-d04c-47b1-836e-d5d29f8c6ed6"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 6, 7, 8, 11, 13, 14, 16, 18, 20, 3, 5, 9, 19, 10, 12, 17, 
      15}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 6, 7, 9, 11, 12, 13, 15, 16, 16, 16, 16, 17, 18, 26, 27, 31, 
          34, 36, 37}, {{3}, {4}, {5}, {6}, {7}, {10}, {11}, {2}, {8}, {2}, {
          8}, {11}, {8}, {2}, {8}, {9}, {2}, {12}, {3}, {4}, {5}, {6}, {7}, {
          10}, {12}, {15}, {11}, {1}, {14}, {17}, {18}, {4}, {7}, {10}, {7}, {
          10}, {7}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {-3., 2.}}, 0.2], 
        ArrowBox[{{1., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQUO6PTyeRu7r9v/t4fxkyYafSjJ/mfPCOXr3WjS
vdH0Fy7PU7zImbHtD5z/KxGk4TeCv8QfhBDqbe7Okhf7CecbqluJJJz4Duen
gcE3OH8xWPsXOP+xRR8QfYa7R1kJBD7B5RO5tyVwb/sA59u/nGz3cvI7OH/P
bhB4Dedbgox7/ALOB+lO4H4G5xuDwWM4Hxw8+Q/g/HP83VMal9+Gu0c856BY
zsFrcHnJil2m9jqX4PwV6W8efT1/Gs6fYgdy4GE4/8HLa382eOyE8/9pnenk
Y10B50NpBgCRoXL4
         "]], 0.2], ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{4., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{4., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {-3., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcDlCGw38wYHdYPm9j93X7//Yw+aSJRh9Ksv/Z
M0L5ejeadG80/YXL8xQvcmZs+wPn/0oEafiN4C/xByGEepu7s+TFfsL5hupW
IgknvsP5aWDwzX5SqKj9zR/sDjuWhXrZMHy19wsL/ZPymN3BfOrvitdLP9vr
Mx0wX7yf3eGBYcSn4vBP9qaRoR8n97I7bKjJ3nZV5KN9crSoprkvu0PE66wu
xT3v7XdwMNzv+cfmsMgyx9Yr7a29SaKo8NSFbA5OT261qmq8tr+aEnrU34zN
wfT1tuTNjC/t5wkf+LpnD6tDtR/D9c+fntmznfddmHKTxUHGxrx1Uupj+xrz
86xibCwO7+/aiEdIPLD/6+OifNGJ2eFZupJUp9gt+y7+tT+n9jM5+NRknF1f
c8VeqZ6zM+UNo4P6p+kTPI6dsz8xO/KiTSSjQ/WemaJnJx+1r0yde0nuGoOD
3Po1wbcO77I3v3OlhyuZwWEer7np4kMr7GHxBIs5AD06p5o=
         "]], 0.2], 
        ArrowBox[{{-2., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {-2., 3.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {-3., 3.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-3., 2.}}, 0.2], 
        ArrowBox[{{-3., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{-3., 3.}, {-3., 2.}}, 0.2], 
        ArrowBox[{{-1., 3.}, {-2., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 3.}, 0.2], InsetBox["1", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["4", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["6", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["7", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["8", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["11", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["13", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["14", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.2], 
         InsetBox["16", {0., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 2.}, 0.2], 
         InsetBox["18", {-3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 0.}, 0.2], 
         InsetBox["20", {2., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 2.}, 0.2], 
         InsetBox["3", {4., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 3.}, 0.2], 
         InsetBox["5", {4., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["9", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.2], 
         InsetBox["19", {3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 4.}, 0.2], 
         InsetBox["10", {-2., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 3.}, 0.2], 
         InsetBox["12", {-2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 3.}, 0.2], 
         InsetBox["17", {-3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["15", {-1., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{3.851512709092565*^9},
 CellLabel->
  "Out[588]=",ExpressionUUID->"2498d54e-4e45-4388-81e6-f57353ad3404"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g2a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g2", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"16", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.851512742586945*^9, 3.851512854867146*^9}, {
  3.851512895827279*^9, 3.8515128991314383`*^9}},
 CellLabel->
  "In[591]:=",ExpressionUUID->"92fd3efd-ec59-4bf5-8dd2-b3c4a645aa59"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 6, 7, 8, 11, 13, 14, 16, 18, 20, 3, 5, 9, 19, 10, 12, 17, 
      15}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 6, 7, 9, 11, 12, 13, 15, 16, 16, 16, 16, 17, 18, 26, 27, 31, 
          34, 36, 37}, {{3}, {4}, {5}, {6}, {7}, {10}, {11}, {2}, {8}, {2}, {
          8}, {11}, {8}, {2}, {8}, {9}, {2}, {12}, {3}, {4}, {5}, {6}, {7}, {
          10}, {12}, {15}, {11}, {1}, {14}, {17}, {18}, {4}, {7}, {10}, {7}, {
          10}, {7}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, GraphLayout -> {"Dimension" -> 2}, ImageSize -> 600, 
       VertexCoordinates -> {{0, 3.}, {1., 1.}, {1., 2.}, {-1., 2.}, {2., 
         2.}, {0, 2.}, {-2., 2.}, {0, 1.}, {-1, 1}, {-3., 2.}, {2., 1}, {4., 
         2.}, {4., 3.}, {1., 3.}, {3., 2.}, {-2., 4.}, {-2., 3.}, {-3., 
         3.}, {-1., 3.}}, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {-3., 2.}}, 0.2], 
        ArrowBox[{{1., 1.}, {2., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 1.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{4., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{4., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {-3., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[{{3., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {-2., 3.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {-3., 3.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-3., 2.}}, 0.2], 
        ArrowBox[{{-3., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{-3., 3.}, {-3., 2.}}, 0.2], 
        ArrowBox[{{-1., 3.}, {-2., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 3.}, 0.2], InsetBox["1", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["4", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["6", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["7", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["8", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["11", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["13", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["14", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["16", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 2.}, 0.2], 
         InsetBox["18", {-3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["20", {2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 2.}, 0.2], 
         InsetBox["3", {4., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 3.}, 0.2], 
         InsetBox["5", {4., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["9", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.2], 
         InsetBox["19", {3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 4.}, 0.2], 
         InsetBox["10", {-2., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 3.}, 0.2], 
         InsetBox["12", {-2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 3.}, 0.2], 
         InsetBox["17", {-3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["15", {-1., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{3.851512820865446*^9, 3.851512856252651*^9, 
  3.8515129000383043`*^9},
 CellLabel->
  "Out[591]=",ExpressionUUID->"7016f76c-0ede-43a1-895f-07438d1c187b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g3", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"graph", "[", "3", "]"}], ",", 
    RowBox[{"GraphLayout", "\[Rule]", "\"\<LayeredDigraphEmbedding\>\""}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8515131211390133`*^9, 3.851513156353915*^9}},
 CellLabel->
  "In[596]:=",ExpressionUUID->"a0dc2b5e-5f35-457d-a248-f76c85a26318"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 6, 7, 13, 16, 19, 20, 2, 5, 12, 17, 8, 9, 10, 11, 14, 15}, {
      
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 3, 4, 7, 10, 12, 12, 12, 13, 17, 18, 20, 21, 24, 25, 26, 27, 
          28, 30}, {{3}, {4}, {5}, {8}, {2}, {6}, {7}, {2}, {6}, {7}, {2}, {
          6}, {2}, {1}, {10}, {11}, {12}, {2}, {4}, {5}, {5}, {1}, {11}, {
          12}, {15}, {9}, {6}, {6}, {1}, {12}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, 
       GraphLayout -> {
        "Dimension" -> 2, "VertexLayout" -> "LayeredDigraphEmbedding"}, 
       ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[BezierCurveBox[{{0., 
         0.}, {-1.5000000000000018`, -0.49332224154934784`}, {-3., 0.}}], 
         0.2], ArrowBox[{{0., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{0., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{0., 1.}, {1., 0.}}, 0.2], 
        ArrowBox[{{1., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{1., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{1., 1.}, {1., 0.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[BezierCurveBox[{{-3., 0.}, {-1.5000000000000018`, 
         0.49332224154934784`}, {0., 0.}}], 0.2], 
        ArrowBox[{{1., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQUO6PTyeRu7r9v/t4fxkyYafSjJ/mfPCOXr3WjS
vdH0Fy7PU7zImbHtD5z/KxGk4TeCv8QfhBDqbe7Okhf7CecbqluJJJz4Duen
gcE3e7HiRy0v3v63lzWdw1fH+tU+6kyn8KLt/+1PnBPt+rTrs/0p7m+rdWL/
22cYX75xuO2TfYqhul/HvX/235Ou/PqY8dFex1b21xbrf/bVsZIfahI/2Cvo
31i/qeSv/UNXl8KTD97ZO7JH5Dd2/rHfknZ3RZD2W/u+o3MsFKt+22fL/mub
uui1PUfWMu5Jbr+g9Cv7oLy6FSVs36D0M/vEBHurVulPUPqRfUrDpcZ27rdQ
+q59m/SPioSuZ1D6mr3+pPeRUzc/gNIX7HedKPT04bsOpY/bW3oEpHqLnIHS
e+y1b3Hsu521E0qvhIUPHAAA5JetZg==
         "]], 0.2], 
        ArrowBox[{{1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{1., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[{{1., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{-3., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{-2., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{-1., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{-1., 3.}, {-1., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 2.}, 0.2], InsetBox["1", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.2], 
         InsetBox["4", {0., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["6", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["7", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["13", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 0.}, 0.2], 
         InsetBox["16", {-1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 0.}, 0.2], 
         InsetBox["19", {1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 0.}, 0.2], 
         InsetBox["20", {-3., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["2", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["5", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["12", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["17", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 3.}, 0.2], 
         InsetBox["8", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 5.}, 0.2], 
         InsetBox["9", {1., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.2], 
         InsetBox["10", {1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 1.}, 0.2], 
         InsetBox["11", {-3., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 1.}, 0.2], 
         InsetBox["14", {-2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["15", {-1., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{3.851513124161585*^9, 3.85151315826021*^9},
 CellLabel->
  "Out[596]=",ExpressionUUID->"8635a5e3-3899-40f4-871d-003775178aa0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g3a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g3", ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"19", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"11", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "3"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851513238731512*^9, 3.851513474859984*^9}},
 CellLabel->
  "In[602]:=",ExpressionUUID->"06e05144-52b1-4fbe-9b4c-07cbbc068799"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 6, 7, 13, 16, 19, 20, 2, 5, 12, 17, 8, 9, 10, 11, 14, 15}, {
      
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 3, 4, 7, 10, 12, 12, 12, 13, 17, 18, 20, 21, 24, 25, 26, 27, 
          28, 30}, {{3}, {4}, {5}, {8}, {2}, {6}, {7}, {2}, {6}, {7}, {2}, {
          6}, {2}, {1}, {10}, {11}, {12}, {2}, {4}, {5}, {5}, {1}, {11}, {
          12}, {15}, {9}, {6}, {6}, {1}, {12}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, 
       GraphLayout -> {
        "Dimension" -> 2, "VertexLayout" -> "LayeredDigraphEmbedding"}, 
       ImageSize -> 600, 
       VertexCoordinates -> {{0, 2.}, {0, 0}, {0, 1.}, {1., 1.}, {-1., 
         1.}, {-1., 0}, {2., 0}, {1., 0}, {1., 3.}, {2., 1.}, {1., 2.}, {-1., 
         2.}, {0, 3.}, {2., 2.}, {2., 3.}, {-2., 0.}, {-2., 1.}, {-1., 3.}}, 
       VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[BezierCurveBox[{{0., 0.}, {0.5000000000000002, 
         0.1644407471831165}, {1., 0.}}], 0.2], 
        ArrowBox[{{0., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{0., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{0., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{1., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{1., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{1., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[BezierCurveBox[{{1., 0.}, {
         0.5000000000000003, -0.1644407471831164}, {0., 0.}}], 0.2], 
        ArrowBox[{{1., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {2., 1.}}, 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{2., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{2., 2.}, {2., 3.}}, 0.2], 
        ArrowBox[{{2., 3.}, {1., 3.}}, 0.2], 
        ArrowBox[{{-2., 0.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{-2., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{-1., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{-1., 3.}, {-1., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 2.}, 0.2], InsetBox["1", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.2], 
         InsetBox["4", {0., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["6", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["7", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["13", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 0.}, 0.2], 
         InsetBox["16", {-1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 0.}, 0.2], 
         InsetBox["19", {2., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 0.}, 0.2], 
         InsetBox["20", {1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["2", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["5", {2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["12", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["17", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 3.}, 0.2], 
         InsetBox["8", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["9", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["10", {2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 0.}, 0.2], 
         InsetBox["11", {-2., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 1.}, 0.2], 
         InsetBox["14", {-2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["15", {-1., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{
  3.851513325875228*^9, 3.851513362124749*^9, 3.851513403048875*^9, {
   3.851513452577134*^9, 3.851513475872383*^9}},
 CellLabel->
  "Out[602]=",ExpressionUUID->"38008314-4f7e-4429-9c35-6149b02b8a3e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g4", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"graph", "[", "4", "]"}], ",", 
    RowBox[{"GraphLayout", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<LayeredDigraphEmbedding\>\"", ",", 
       RowBox[{"\"\<Orientation\>\"", "\[Rule]", "Left"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8515135614128237`*^9, 3.8515135666381598`*^9}, {
  3.8515136116784678`*^9, 3.85151364550863*^9}},
 CellLabel->
  "In[606]:=",ExpressionUUID->"b32ad23b-444c-427b-84ef-9ebc9fa04191"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 8, 9, 10, 15, 18, 20, 5, 6, 11, 14, 7, 12, 13, 17, 19}, {
      
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 3, 4, 5, 6, 8, 9, 10, 10, 10, 11, 13, 14, 14, 17, 18, 22, 25, 
          27}, {{2}, {7}, {8}, {6}, {9}, {9}, {3}, {4}, {5}, {3}, {2}, {1}, {
          12}, {13}, {1}, {13}, {15}, {2}, {1}, {13}, {15}, {17}, {2}, {7}, {
          8}, {11}, {14}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, 
       GraphLayout -> {
        "Dimension" -> 2, 
         "VertexLayout" -> {
          "LayeredDigraphEmbedding", "Orientation" -> Left}}, ImageSize -> 
       600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{-4.999999999999998, 
         1.339744851455892*^-7}, {-3.9999999464102047`, 2.0000001071795874`}},
          0.1999999999999999], 
        ArrowBox[{{-4.999999999999998, 
         1.339744851455892*^-7}, {-3.9999999999999987`, 
         1.0717958811647137`*^-7}}, 0.1999999999999999], 
        ArrowBox[{{-4.999999999999998, 
         1.339744851455892*^-7}, {-3.9999999732051017`, 1.0000001071795879`}},
          0.1999999999999999], 
        ArrowBox[{{-3.9999999464102047`, 
         2.0000001071795874`}, {-2.999999946410205, 2.0000000803846905`}}, 
         0.1999999999999999], 
        ArrowBox[{{-0.9999999732051026, 1.0000000267948967`}, {
         2.6794897029117842`*^-8, 0.9999999999999997}}, 0.1999999999999999], 
        ArrowBox[{{-0.9999999464102056, 2.0000000267948965`}, {
         2.6794897029117842`*^-8, 0.9999999999999997}}, 0.1999999999999999], 
        ArrowBox[{{-1.9999999464102052`, 
         2.0000000535897935`}, {-0.9999999732051026, 1.0000000267948967`}}, 
         0.1999999999999999], 
        ArrowBox[{{-1.9999999464102052`, 
         2.0000000535897935`}, {-0.9999999464102056, 2.0000000267948965`}}, 
         0.1999999999999999], 
        ArrowBox[{{-2.999999946410205, 
         2.0000000803846905`}, {-1.9999999464102052`, 2.0000000535897935`}}, 
         0.1999999999999999], ArrowBox[BezierCurveBox[CompressedData["
1:eJwBYQKe/SFib1JlAgAAACUAAAACAAAA/f//////D8BiYhpBU8V8PlHP2MXr
nw/AYye6F/FufD6vSBl4ujUPwCMB5B93D3w+FWzBFmzBDsCg75dZ5aZ7PoM5
0aEAQw7A2PLVxDs1ez76sEgZeLoNwM4KnmF6uno+e9InfdInDcCCN/AvoTZ6
PgSebs0PiwzA8HjML7CpeT6WEx0KMOQLwB3PMmGnE3k+MTMzMzMzC8AGOiPE
hnR4Ps8nfdInfQrATa/YP9rQdz5xHMdxHMcJwJYkjrstLXc+EBERERERCcDf
mUM3gYl2Pq4FW7AFWwjAJg/5stTldT5O+qRP+qQHwG6Eri4oQnU+7u7u7u7u
BsC2+WOqe550Po3jOI7jOAbA/W4ZJs/6cz4t2IIt2IIFwEbkzqEiV3M+MjMz
MzMzA8BuodzzMUNxPlqcJyUegALAtyoI7ySbbD+W7nC89dIBwDbB6a0Lm4w/
5ikP+bkrAcBiBwT+MxegP0dOAttqigDA6UeNhgWbrD94t5TEEN7/v/MYi8Ib
WbY/h6TOHSWz/r9TsWd+MhfAP71jssESlP2/i8AJOa/mxT8Z9T+w2YD8vx+6
KxEEm8w/mlh36Xl5+78Iz2aDGBrSPzloxj/Jsvm//1bHI9s02T9ZPQsILAz4
vzIkxPxPz98/+ddFQqKF9r9Smy6Hu/TiPxc4du4rH/W/KEdJLKjB5T+2XZwM
ydjzv54Vsu1tTug/1Ui4nHmy8r+wBmnLDJvqP3L5yZ49rPG/YBpuxYSn7D+R
b9ESFcbwv7BQwdvVc+4/XFad8f//77/PVDEHAADwP7NVImM=
         "]], 
         0.1999999999999999], 
        ArrowBox[{{-4.999999973205101, 
         1.0000001339744848`}, {-3.9999999464102047`, 2.0000001071795874`}}, 
         0.1999999999999999], 
        ArrowBox[{{-5.999999946410204, 
         2.0000001607693814`}, {-4.999999999999998, 1.339744851455892*^-7}}, 
         0.1999999999999999], 
        ArrowBox[{{-5.999999946410204, 
         2.0000001607693814`}, {-4.999999946410204, 2.0000001339744844`}}, 
         0.1999999999999999], 
        ArrowBox[{{-4.999999946410204, 
         2.0000001339744844`}, {-3.9999998928204104`, 4.000000107179587}}, 
         0.1999999999999999], 
        ArrowBox[{{-5.999999866025513, 5.00000016076938}, {-4.999999999999998,
          1.339744851455892*^-7}}, 0.1999999999999999], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAA+lUC9///F8A2/8kKAAAUQBol2dn1
zxfAAv/HJwowFEBKg+Ey3ZoXwNXjj84iZRRAjXAbArZgF8CxrSH/SZ8UQN7s
hkeAIRfAlFx9uX/eFEBB+CMDPN0WwIDwov3DIhVAtJLyNOmTFsBzaZLLFmwV
QDi88tyHRRbAbsdLI3i6FUDOdCT7F/IVwHIKzwToDRZAdLyHj5mZFcB9Mhxw
ZmYWQN2q7qtvQBXATxS2HPi1FkC8Vyti/eoUwKqEH8Kh7hZAD8M9skKZFMCN
g1hgYxAXQNfsJZw/SxTA9hBh9zwbF0AU1eMf9AAUwOYsOYcuDxdAxnt3PWC6
E8Bf1+APOOwWQO3g4PSDdxPAYBBYkVmyFkCKBCBGXzgTwOfXnguTYRZAmuY0
MfL8EsD2LbV+5PkVQFyj6irbhBLAy7kScbYJFUDxGTBIihUSwPlxo6oUKxRA
W0oFif+uEcB/Vmcr/10TQJc0au06URHAW2de83WiEkCo2F51PPwQwJCkiAJ5
+BFAjDbjIASwEMAcDuZYCGARQERO9++RbBDAAKR29iPZEEDPH5vi5TEQwDxm
OtvLYxBAXFad8f//D8DPVDEHAAAQQKT0zCE=
         "]], 0.1999999999999999], 
        ArrowBox[{{-5.999999866025513, 5.00000016076938}, {-4.999999866025513,
          5.000000133974483}}, 0.1999999999999999], 
        ArrowBox[{{-4.999999866025513, 
         5.000000133974483}, {-3.9999999464102047`, 2.0000001071795874`}}, 
         0.1999999999999999], 
        ArrowBox[{{-5.999999919615307, 
         3.0000001607693814`}, {-4.999999999999998, 1.339744851455892*^-7}}, 
         0.1999999999999999], ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQncQw+9f//+IH8v9NFmVg4HDw8JfaUnVO/MDKEJtF
XMkcDhd1ZCZ+mCJ+wE7p4nO5axwOP2csmJgYLH5AOz3omU0kp8OBycu3nuUE
6lc+MDflDaeDmqzhX5MdYgd4w6X4pvVzOeib2mZMjxM7wMSUaH7Ridvh2u3T
3778ET0QoDJFUoyNx0FO8O4K38miB77t3bwl5SaPA9vVgrqFiqIHvp7bz7F3
D6/Ds7X7ek7eFzlg/Fbyhr8Zn4OtUJLH71kiB87yzFGdupDPgZspeqNZsMiB
I7puH3v+8Tn41648Xs0hcoA/QMLa3JffgavFt/vULuED24uFmKf08jtYibn/
UcoSPrBzhonn4v38Do+Mp0m1igkfENlfx5v6mN+B4a7Vsw/7hQ6cefbB/+YP
focpgqbxaWlCB961u3IwMAg4JCoe+PycV+jAsf2yYL5WjLhQxS7BA5Ntf7CD
+B8OWu0SyxE8EMJ4FczfEKT15rCS4AE27i1gfg7fs+X19wQOrIuaCuYrf819
6zlf4IDnhwow/xrboT1KqQIHrp+OA/NbnB+JchkIHIh86wbmx4TN/fj/P/+B
8yGGYD4Aq2y1Zw==
         "]], 0.1999999999999999], 
        ArrowBox[{{-5.999999919615307, 
         3.0000001607693814`}, {-4.999999866025513, 5.000000133974483}}, 
         0.1999999999999999], 
        ArrowBox[{{-5.999999919615307, 
         3.0000001607693814`}, {-4.999999919615307, 3.0000001339744844`}}, 
         0.1999999999999999], 
        ArrowBox[{{-4.999999919615307, 
         3.0000001339744844`}, {-3.9999999464102047`, 2.0000001071795874`}}, 
         0.1999999999999999], 
        ArrowBox[{{-4.999999919615307, 
         3.0000001339744844`}, {-3.9999999999999987`, 
         1.0717958811647137`*^-7}}, 0.1999999999999999], 
        ArrowBox[{{-4.999999919615307, 
         3.0000001339744844`}, {-3.9999999732051017`, 1.0000001071795879`}}, 
         0.1999999999999999], 
        ArrowBox[{{-6.9999998660255125`, 
         5.000000187564277}, {-5.999999946410204, 2.0000001607693814`}}, 
         0.1999999999999999], 
        ArrowBox[{{-6.9999998660255125`, 
         5.000000187564277}, {-5.999999866025513, 5.00000016076938}}, 
         0.1999999999999999]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {
         DiskBox[{-4.999999999999998, 1.339744851455892*^-7}, 
          0.1999999999999999], 
         InsetBox["1", {-4.999999999999998, 1.339744851455892*^-7},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999464102047, 2.0000001071795874}, 
          0.1999999999999999], 
         InsetBox["2", {-3.9999999464102047, 2.0000001071795874},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999732051026, 1.0000000267948967}, 
          0.1999999999999999], 
         InsetBox["3", {-0.9999999732051026, 1.0000000267948967},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999464102056, 2.0000000267948965}, 
          0.1999999999999999], 
         InsetBox["8", {-0.9999999464102056, 2.0000000267948965},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999464102052, 2.0000000535897935}, 
          0.1999999999999999], 
         InsetBox["9", {-1.9999999464102052, 2.0000000535897935},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.999999946410205, 2.0000000803846905}, 
          0.1999999999999999], 
         InsetBox["10", {-2.999999946410205, 2.0000000803846905},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999999999987, 1.0717958811647137*^-7}, 
          0.1999999999999999], 
         InsetBox["15", {-3.9999999999999987, 1.0717958811647137*^-7},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999732051017, 1.0000001071795879}, 
          0.1999999999999999], 
         InsetBox["18", {-3.9999999732051017, 1.0000001071795879},
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.6794897029117842*^-8, 0.9999999999999997}, 
          0.1999999999999999], 
         InsetBox["20", {2.6794897029117842*^-8, 0.9999999999999997},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999973205101, 1.0000001339744848}, 
          0.1999999999999999], 
         InsetBox["5", {-4.999999973205101, 1.0000001339744848},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-5.999999946410204, 2.0000001607693814}, 
          0.1999999999999999], 
         InsetBox["6", {-5.999999946410204, 2.0000001607693814},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999946410204, 2.0000001339744844}, 
          0.1999999999999999], 
         InsetBox["11", {-4.999999946410204, 2.0000001339744844},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999998928204104, 4.000000107179587}, 
          0.1999999999999999], 
         InsetBox["14", {-3.9999998928204104, 4.000000107179587},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-5.999999866025513, 5.00000016076938}, 0.1999999999999999], 
         InsetBox["7", {-5.999999866025513, 5.00000016076938},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999866025513, 5.000000133974483}, 0.1999999999999999],
          InsetBox["12", {-4.999999866025513, 5.000000133974483},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-5.999999919615307, 3.0000001607693814}, 
          0.1999999999999999], 
         InsetBox["13", {-5.999999919615307, 3.0000001607693814},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999919615307, 3.0000001339744844}, 
          0.1999999999999999], 
         InsetBox["17", {-4.999999919615307, 3.0000001339744844},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-6.9999998660255125, 5.000000187564277}, 
          0.1999999999999999], 
         InsetBox["19", {-6.9999998660255125, 5.000000187564277},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{3.851513567716898*^9, 3.851513613800219*^9, 
  3.8515136469432917`*^9},
 CellLabel->
  "Out[606]=",ExpressionUUID->"47e1926e-f668-4fe5-b49a-097043058248"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g4a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g4", ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"19", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"12", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"20", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"18", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.851513745693591*^9, 3.851513787581217*^9}, {
  3.851513903734912*^9, 3.851513921349868*^9}, {3.851513984879353*^9, 
  3.851514103262681*^9}, {3.8515142464247303`*^9, 3.8515142548872633`*^9}, {
  3.851514439179332*^9, 3.851514614816221*^9}, {3.851514680979274*^9, 
  3.851514719944952*^9}},
 CellLabel->
  "In[623]:=",ExpressionUUID->"76f250c2-dc9b-4b6f-a19e-193278e64aa2"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 8, 9, 10, 15, 18, 20, 5, 6, 11, 14, 7, 12, 13, 17, 19}, {
      
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 3, 4, 5, 6, 8, 9, 10, 10, 10, 11, 13, 14, 14, 17, 18, 22, 25, 
          27}, {{2}, {7}, {8}, {6}, {9}, {9}, {3}, {4}, {5}, {3}, {2}, {1}, {
          12}, {13}, {1}, {13}, {15}, {2}, {1}, {13}, {15}, {17}, {2}, {7}, {
          8}, {11}, {14}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, 
       GraphLayout -> {
        "Dimension" -> 2, 
         "VertexLayout" -> {
          "LayeredDigraphEmbedding", "Orientation" -> Left}}, ImageSize -> 
       600, VertexCoordinates -> {{-4.999999999999998, 
          1}, {-3.9999999464102047`, 
         2.0000001071795874`}, {-2.9999999732051026`, 
         2.000000026794897}, {-1.9999999464102056`, 
         3.0000000267948965`}, {-2.999999946410205, 
         3.0000000535897935`}, {-2.999999946410205, 
         4.000000080384691}, {-3.9999999999999987`, 1}, {-5.999999973205101, 
         1.0000001071795879`}, {-2, 
          1.9999999999999996`}, {-3.9999999732051013`, 
         3.000000133974485}, {-5.999999946410204, 
         2.0000001607693814`}, {-4.999999946410204, 
         2.0000001339744844`}, {-3.9999998928204104`, 
         4.000000107179587}, {-5.999999866025513, 
         4.00000016076938}, {-6.999999866025513, 
         3.000000133974483}, {-5.999999919615307, 
         3.0000001607693814`}, {-4.999999919615307, 
         3.0000001339744844`}, {-6.9999998660255125`, 4.000000187564277}}, 
       VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{-4.999999999999998, 1.}, {-3.9999999464102047`, 
         2.0000001071795874`}}, 0.1999999892820411], 
        ArrowBox[{{-4.999999999999998, 1.}, {-3.9999999999999987`, 1.}}, 
         0.1999999892820411], 
        ArrowBox[{{-4.999999999999998, 1.}, {-5.999999973205101, 
         1.0000001071795879`}}, 0.1999999892820411], 
        ArrowBox[{{-3.9999999464102047`, 
         2.0000001071795874`}, {-2.999999946410205, 4.000000080384691}}, 
         0.1999999892820411], 
        ArrowBox[{{-2.9999999732051026`, 2.000000026794897}, {-2., 
         1.9999999999999996`}}, 0.1999999892820411], 
        ArrowBox[{{-1.9999999464102056`, 3.0000000267948965`}, {-2., 
         1.9999999999999996`}}, 0.1999999892820411], 
        ArrowBox[{{-2.999999946410205, 
         3.0000000535897935`}, {-2.9999999732051026`, 2.000000026794897}}, 
         0.1999999892820411], 
        ArrowBox[{{-2.999999946410205, 
         3.0000000535897935`}, {-1.9999999464102056`, 3.0000000267948965`}}, 
         0.1999999892820411], 
        ArrowBox[{{-2.999999946410205, 
         4.000000080384691}, {-2.999999946410205, 3.0000000535897935`}}, 
         0.1999999892820411], 
        ArrowBox[{{-3.9999999999999987`, 1.}, {-2.9999999732051026`, 
         2.000000026794897}}, 0.1999999892820411], 
        ArrowBox[{{-3.9999999732051013`, 
         3.000000133974485}, {-3.9999999464102047`, 2.0000001071795874`}}, 
         0.1999999892820411], 
        ArrowBox[{{-5.999999946410204, 
         2.0000001607693814`}, {-4.999999999999998, 1.}}, 0.1999999892820411],
         ArrowBox[{{-5.999999946410204, 
         2.0000001607693814`}, {-4.999999946410204, 2.0000001339744844`}}, 
         0.1999999892820411], 
        ArrowBox[{{-4.999999946410204, 
         2.0000001339744844`}, {-3.9999998928204104`, 4.000000107179587}}, 
         0.1999999892820411], 
        ArrowBox[{{-5.999999866025513, 4.00000016076938}, {-4.999999999999998,
          1.}}, 0.1999999892820411], 
        ArrowBox[{{-5.999999866025513, 
         4.00000016076938}, {-3.9999998928204104`, 4.000000107179587}}, 
         0.1999999892820411], 
        ArrowBox[{{-5.999999866025513, 4.00000016076938}, {-6.999999866025513,
          3.000000133974483}}, 0.1999999892820411], 
        ArrowBox[{{-6.999999866025513, 
         3.000000133974483}, {-3.9999999464102047`, 2.0000001071795874`}}, 
         0.1999999892820411], 
        ArrowBox[{{-5.999999919615307, 
         3.0000001607693814`}, {-4.999999999999998, 1.}}, 0.1999999892820411],
         ArrowBox[{{-5.999999919615307, 
         3.0000001607693814`}, {-3.9999998928204104`, 4.000000107179587}}, 
         0.1999999892820411], 
        ArrowBox[{{-5.999999919615307, 
         3.0000001607693814`}, {-6.999999866025513, 3.000000133974483}}, 
         0.1999999892820411], 
        ArrowBox[{{-5.999999919615307, 
         3.0000001607693814`}, {-4.999999919615307, 3.0000001339744844`}}, 
         0.1999999892820411], 
        ArrowBox[{{-4.999999919615307, 
         3.0000001339744844`}, {-3.9999999464102047`, 2.0000001071795874`}}, 
         0.1999999892820411], 
        ArrowBox[{{-4.999999919615307, 
         3.0000001339744844`}, {-3.9999999999999987`, 1.}}, 
         0.1999999892820411], 
        ArrowBox[{{-4.999999919615307, 
         3.0000001339744844`}, {-5.999999973205101, 1.0000001071795879`}}, 
         0.1999999892820411], 
        ArrowBox[{{-6.9999998660255125`, 
         4.000000187564277}, {-5.999999946410204, 2.0000001607693814`}}, 
         0.1999999892820411], 
        ArrowBox[{{-6.9999998660255125`, 
         4.000000187564277}, {-5.999999866025513, 4.00000016076938}}, 
         0.1999999892820411]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{-4.999999999999998, 1.}, 0.1999999892820411], 
         InsetBox["1", {-4.999999999999998, 1.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999464102047, 2.0000001071795874}, 
          0.1999999892820411], 
         InsetBox["2", {-3.9999999464102047, 2.0000001071795874},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.9999999732051026, 2.000000026794897}, 
          0.1999999892820411], 
         InsetBox["3", {-2.9999999732051026, 2.000000026794897},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999464102056, 3.0000000267948965}, 
          0.1999999892820411], 
         InsetBox["8", {-1.9999999464102056, 3.0000000267948965},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.999999946410205, 3.0000000535897935}, 
          0.1999999892820411], 
         InsetBox["9", {-2.999999946410205, 3.0000000535897935},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.999999946410205, 4.000000080384691}, 0.1999999892820411],
          InsetBox["10", {-2.999999946410205, 4.000000080384691},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999999999987, 1.}, 0.1999999892820411], 
         InsetBox["15", {-3.9999999999999987, 1.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-5.999999973205101, 1.0000001071795879}, 
          0.1999999892820411], 
         InsetBox["18", {-5.999999973205101, 1.0000001071795879},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2., 1.9999999999999996}, 0.1999999892820411], 
         InsetBox["20", {-2., 1.9999999999999996},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999732051013, 3.000000133974485}, 
          0.1999999892820411], 
         InsetBox["5", {-3.9999999732051013, 3.000000133974485},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-5.999999946410204, 2.0000001607693814}, 
          0.1999999892820411], 
         InsetBox["6", {-5.999999946410204, 2.0000001607693814},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999946410204, 2.0000001339744844}, 
          0.1999999892820411], 
         InsetBox["11", {-4.999999946410204, 2.0000001339744844},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999998928204104, 4.000000107179587}, 
          0.1999999892820411], 
         InsetBox["14", {-3.9999998928204104, 4.000000107179587},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-5.999999866025513, 4.00000016076938}, 0.1999999892820411], 
         InsetBox["7", {-5.999999866025513, 4.00000016076938},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-6.999999866025513, 3.000000133974483}, 0.1999999892820411],
          InsetBox["12", {-6.999999866025513, 3.000000133974483},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-5.999999919615307, 3.0000001607693814}, 
          0.1999999892820411], 
         InsetBox["13", {-5.999999919615307, 3.0000001607693814},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999919615307, 3.0000001339744844}, 
          0.1999999892820411], 
         InsetBox["17", {-4.999999919615307, 3.0000001339744844},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-6.9999998660255125, 4.000000187564277}, 
          0.1999999892820411], 
         InsetBox["19", {-6.9999998660255125, 4.000000187564277},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{{3.8515140016584682`*^9, 3.851514068681819*^9}, 
   3.851514104791319*^9, 3.8515142564035683`*^9, 3.8515144590594893`*^9, {
   3.851514509387672*^9, 3.851514556965233*^9}, {3.851514592108129*^9, 
   3.85151461589504*^9}, {3.851514699176752*^9, 3.851514721106121*^9}},
 CellLabel->
  "Out[623]=",ExpressionUUID->"3d591962-43ac-41b3-8f54-51721023fd2c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g5", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"graph", "[", "5", "]"}], ",", 
    RowBox[{"GraphLayout", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<LayeredDigraphEmbedding\>\"", ",", 
       RowBox[{"\"\<Orientation\>\"", "\[Rule]", "Top"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.851514831057461*^9, 3.851514849201716*^9}},
 CellLabel->
  "In[627]:=",ExpressionUUID->"5f76d6c7-8cf1-4925-a992-f21311d2ff88"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 3, 4, 8, 9, 10, 11, 14, 18, 20, 2, 6, 7, 12, 13, 15, 17, 19}, {
      
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 1, 3, 4, 5, 9, 10, 11, 11, 11, 11, 12, 16, 17, 18, 19, 21, 22,
           24}, {{6}, {3}, {10}, {2}, {10}, {2}, {4}, {7}, {9}, {5}, {8}, {
          6}, {2}, {4}, {7}, {9}, {6}, {1}, {6}, {2}, {8}, {1}, {8}, {10}}}, 
         Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, 
       GraphLayout -> {
        "Dimension" -> 2, 
         "VertexLayout" -> {"LayeredDigraphEmbedding", "Orientation" -> Top}},
        ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{1., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[BezierCurveBox[{{1., 1.}, {-1.499999999999997, 
         0.17779626408441734`}, {-4., 1.}}], 0.2], 
        ArrowBox[BezierCurveBox[{{-4., 1.}, {-1.4999999999999971`, 
         1.822203735915582}, {1., 1.}}], 0.2], 
        ArrowBox[{{0., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {-3., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{-1., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{-3., 1.}, {-2., 0.}}, 0.2], 
        ArrowBox[{{-3., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{0., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {-3., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{0., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{-1., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{2., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQUO6PTyeRu7r9v/t4fxkyYafSjJ/mfPCOXr3WjS
vdH0Fy7PU7zImbHtD5z/KxGk4TeCv8QfhBDqbe7Okhf7CecbqluJJJz4Duen
gcE3++BIhZKEN//tnwsav1zI+dXeL7XxQuPG//bvHQu/NJ7+bP9BWVk0xf+/
ff03hQ62NZ/szaayOrEf+2c/Wd9pif7qj/YqOzXCs0X/2eu9veLx98QH+539
PSETbP/a++vfLM1n/WD/RcLQqszuj/2b13PDeA6+s78RIsYhK/Hb3qMp51LT
lrf2Cc42+1pO/bTfoCgX7/T0jX3SspvPDxt8sDe4/OZzosQL+ys6/+2/d961
n/30/3O7jY/tZxzR1NrIuWT/3Y3ryjbF37ffMi1tQkXc/f0hUc9uJ2rcsD9a
tonhRdub/XOPLPvfveeivSu/gNz5x5/3lz28fzjR4oR9mKJd7fodP/avqGLn
dpLdaz+l8LGs6KE/+5OKnwiEv18JC58DsIgDAMuftxc=
         "]], 0.2], 
        ArrowBox[{{1., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{-2., 1.}, {-2., 0.}}, 0.2], 
        ArrowBox[{{-2., 1.}, {0., 0.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 4.}, 0.2], InsetBox["1", {0., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["3", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-4., 1.}, 0.2], 
         InsetBox["4", {-4., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["8", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["9", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["10", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 1.}, 0.2], 
         InsetBox["11", {-3., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 0.}, 0.2], 
         InsetBox["14", {-2., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["18", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.2], 
         InsetBox["20", {0., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 4.}, 0.2], 
         InsetBox["2", {-3., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["6", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 4.}, 0.2], 
         InsetBox["7", {-2., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 5.}, 0.2], 
         InsetBox["12", {0., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 4.}, 0.2], 
         InsetBox["13", {-1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["15", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 5.}, 0.2], 
         InsetBox["17", {1., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 1.}, 0.2], 
         InsetBox["19", {-2., 1.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{{3.851514839439993*^9, 3.851514850303261*^9}},
 CellLabel->
  "Out[627]=",ExpressionUUID->"07606e2a-b92d-4ca1-8542-50896f211c77"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g5a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g5", ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"17", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "3"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"12", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8515148947220078`*^9, 3.851514996578274*^9}, {
  3.8515150574833307`*^9, 3.8515150625458384`*^9}, {3.851515102477273*^9, 
  3.851515112858521*^9}, {3.851515157139962*^9, 3.851515255874879*^9}},
 CellLabel->
  "In[636]:=",ExpressionUUID->"74a03566-7770-46c5-8e3f-5ef45099eda6"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 3, 4, 8, 9, 10, 11, 14, 18, 20, 2, 6, 7, 12, 13, 15, 17, 19}, {
      
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 1, 3, 4, 5, 9, 10, 11, 11, 11, 11, 12, 16, 17, 18, 19, 21, 22,
           24}, {{6}, {3}, {10}, {2}, {10}, {2}, {4}, {7}, {9}, {5}, {8}, {
          6}, {2}, {4}, {7}, {9}, {6}, {1}, {6}, {2}, {8}, {1}, {8}, {10}}}, 
         Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, 
       GraphLayout -> {
        "Dimension" -> 2, 
         "VertexLayout" -> {"LayeredDigraphEmbedding", "Orientation" -> Top}},
        ImageSize -> 600, 
       VertexCoordinates -> {{0, 3.}, {1., 1.}, {1., 0.}, {0, 1.}, {-1., 
         2.}, {-1., 3.}, {-3., 1.}, {-2., 0}, {-1., 1.}, {0, 0}, {-2., 2.}, {
         0, 2.}, {-2., 3.}, {1, 3.}, {-3., 2.}, {-1., 0.}, {1., 2.}, {-2., 
         1.}}, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 3.}, {-1., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[{{1., 1.}, {1.1644407471831195`, 
         0.5000000000000049}, {1., 0.}}], 0.2], 
        ArrowBox[{{1., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[BezierCurveBox[{{1., 0.}, {0.8355592528168824, 
         0.500000000000004}, {1., 1.}}], 0.2], 
        ArrowBox[{{0., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {-3., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{-1., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{-3., 1.}, {-2., 0.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{0., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {-3., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{1., 3.}, {0., 3.}}, 0.2], 
        ArrowBox[{{-3., 2.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{-1., 0.}, {1., 1.}}, 0.2], 
        ArrowBox[{{-1., 0.}, {-2., 0.}}, 0.2], 
        ArrowBox[{{1., 2.}, {0., 3.}}, 0.2], 
        ArrowBox[{{-2., 1.}, {-2., 0.}}, 0.2], 
        ArrowBox[{{-2., 1.}, {0., 0.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 3.}, 0.2], InsetBox["1", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["3", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 0.}, 0.2], 
         InsetBox["4", {1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["8", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["9", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["10", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 1.}, 0.2], 
         InsetBox["11", {-3., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 0.}, 0.2], 
         InsetBox["14", {-2., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["18", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.2], 
         InsetBox["20", {0., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["2", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["6", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 3.}, 0.2], 
         InsetBox["7", {-2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["12", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 2.}, 0.2], 
         InsetBox["13", {-3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 0.}, 0.2], 
         InsetBox["15", {-1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["17", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 1.}, 0.2], 
         InsetBox["19", {-2., 1.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{
  3.851514927973673*^9, 3.851514997781406*^9, 3.85151506336265*^9, 
   3.8515151139627333`*^9, {3.851515168209663*^9, 3.8515152568732557`*^9}},
 CellLabel->
  "Out[636]=",ExpressionUUID->"9b9c4193-44fc-44d5-888b-c02b8c19f236"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g6", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"graph", "[", "6", "]"}], ",", 
    RowBox[{"GraphLayout", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<LayeredDigraphEmbedding\>\"", ",", 
       RowBox[{"\"\<Orientation\>\"", "\[Rule]", "Left"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.851516138598764*^9, 3.851516163190671*^9}},
 CellLabel->
  "In[640]:=",ExpressionUUID->"731a46e5-e099-4a07-9190-acd05935e733"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 8, 9, 10, 15, 16, 20, 4, 5, 7, 13, 14, 11, 12, 17, 18, 
      19}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 2, 3, 4, 5, 7, 8, 10, 10, 10, 11, 12, 14, 16, 17, 18, 19, 21, 
          21, 22}, {{2}, {7}, {6}, {9}, {9}, {3}, {4}, {5}, {3}, {8}, {9}, {
          3}, {2}, {13}, {7}, {14}, {8}, {14}, {2}, {7}, {18}, {9}}}, 
         Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, 
       GraphLayout -> {
        "Dimension" -> 2, 
         "VertexLayout" -> {
          "LayeredDigraphEmbedding", "Orientation" -> Left}}, ImageSize -> 
       600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{-4.999999999999998, 
         1.339744851455892*^-7}, {-3.9999999196153078`, 3.0000001071795874`}},
          0.19999999999999998`], ArrowBox[BezierCurveBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAA/v//////E8B9fbAIVPuBPqhn7OL1
zxPA/V8A9CLQgT5XpAw83ZoTwN5MFfhloIE+C7ZgC7ZgE8AdRO8UHWyBPsGc
6FCAIRPAuUWOSkgzgT58WKQMPN0SwLRR8pjn9YA+POmTPumTEsANaBsA+7OA
PgJPt+aHRRLAxIgJgIJtgD7LiQ4FGPIRwNuzvBh+IoA+mJmZmZmZEcCf0mmU
26V/PizOkxIPQBHAz2tbtEGbbD9LdzjeeukQwHuRPt8Sm4w/8pSH/NyVEMBy
O1nKNRegPyMngW01RRDA+HviUgebrD+6W0piCO8PwPmytagcWbY/QlLnjpJZ
D8BW/nzxMhfAP94x2WAJyg7Ajg0frK/mxT+M+h/YbEAOwCEHQYQEm8w/TKy7
9Ly8DcCJdfG8GBrSPxw0459k2QzAf/1RXds02T+rngUEFgYMwLPKTjZQz98/
++siIdFCC8CS7vOju/TiPwocO/eVjwrAaJoOSajB5T/aLk6GZOwJwN1odwpu
Tug/aiRczjxZCcDwWS7oDJvqP7j8ZM8e1gjAoG0z4oSn7D/It2iJCmMIwPCj
hvjVc+4/llVn/P//B8Bv/pMVAADwPx5y3q4=
         "]], 0.19999999999999998`], 
        ArrowBox[{{-3.9999999196153078`, 
         3.0000001071795874`}, {-2.999999919615308, 3.00000008038469}}, 
         0.19999999999999998`], 
        ArrowBox[{{-0.9999999732051026, 1.0000000267948967`}, {0., 0.}}, 
         0.19999999999999998`], 
        ArrowBox[{{-0.9999999196153085, 3.000000026794896}, {0., 0.}}, 
         0.19999999999999998`], 
        ArrowBox[{{-1.9999999196153082`, 
         3.000000053589793}, {-0.9999999732051026, 1.0000000267948967`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-1.9999999196153082`, 
         3.000000053589793}, {-0.9999999196153085, 3.000000026794896}}, 
         0.19999999999999998`], 
        ArrowBox[{{-2.999999919615308, 
         3.00000008038469}, {-1.9999999196153082`, 3.000000053589793}}, 
         0.19999999999999998`], ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQPS00/c///+wH8v9NFmVg+GD/SsXh0Ov57Adc59iC
+R7zGkp2mbIf8FO6JwLirzuoIZxzkO1Ax4RSMF+m32IegzPbgc/PmMH8KWwb
RCt2sR6YoNopDOKLaPRXXlJnPRDnwwrmz/189SR/N8uBuOgKIRDfILOFzeAJ
84EJQY8EQfxTHbP0jY2ZD3wydAbzM2qfnFOvZTqQ1zpfAMTnKNLLkznOeODl
jd/8IP7KtApeQUHGA2k6EWC+e/ShNazRDAce1m/hA/HPzJeY8cXz//7YywJg
Pk/nmmt37/7df1MtlxfE9ypyED1e+Gd/SNVJHhC/I/pK8AbW3/svnFUF84+5
ZEyaOfPnfh/FJm4Q/0/zlCfzzX/sX8/wmAvEV8j/GPvg5bf9D7/7gPnGbPX/
ojZ83f+Q7QAniG/iaXuMv/vL/nW6NmC+soXO1n+Vn/d75xzkAPEZLnufVq/9
tH/bIX8w/4zkHI7uKR/3fzB4zg7it/HI5moc+LD/x7Z2MD8mbO7H///f7z8f
YgjmAwBfZMKG
         "]], 0.19999999999999998`], 
        ArrowBox[{{-2.999999973205102, 
         1.0000000803846907`}, {-1.9999999464102052`, 2.0000000535897935`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-1.0000000267948967`, -0.9999999732051026}, {0., 0.}}, 
         0.19999999999999998`], 
        ArrowBox[{{-1.9999999999999993`, 
         5.3589794058235685`*^-8}, {-0.9999999732051026, 
         1.0000000267948967`}}, 0.19999999999999998`], 
        ArrowBox[{{-4.999999946410204, 
         2.0000001339744844`}, {-3.9999999196153078`, 3.0000001071795874`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-4.999999946410204, 
         2.0000001339744844`}, {-3.9999999732051017`, 1.0000001071795879`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-3.9999999732051017`, 
         1.0000001071795879`}, {-2.999999973205102, 1.0000000803846907`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-3.9999999732051017`, 
         1.0000001071795879`}, {-2.999999946410205, 2.0000000803846905`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-2.999999946410205, 
         2.0000000803846905`}, {-1.9999999464102052`, 2.0000000535897935`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-3.9999999464102047`, 
         2.0000001071795874`}, {-2.999999946410205, 2.0000000803846905`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-4.999999919615307, 
         3.0000001339744844`}, {-3.9999999196153078`, 3.0000001071795874`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-4.000000026794896, -0.9999998928204116}, \
{-2.999999973205102, 1.0000000803846907`}}, 0.19999999999999998`], 
        ArrowBox[{{-4.000000026794896, -0.9999998928204116}, \
{-3.000000026794896, -0.9999999196153085}}, 0.19999999999999998`], 
        ArrowBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 0.}}, 
         0.19999999999999998`]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {
         DiskBox[{-4.999999999999998, 1.339744851455892*^-7}, 
          0.19999999999999998], 
         InsetBox["1", {-4.999999999999998, 1.339744851455892*^-7},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999196153078, 3.0000001071795874}, 
          0.19999999999999998], 
         InsetBox["2", {-3.9999999196153078, 3.0000001071795874},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999732051026, 1.0000000267948967}, 
          0.19999999999999998], 
         InsetBox["3", {-0.9999999732051026, 1.0000000267948967},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999196153085, 3.000000026794896}, 
          0.19999999999999998], 
         InsetBox["8", {-0.9999999196153085, 3.000000026794896},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999196153082, 3.000000053589793}, 
          0.19999999999999998], 
         InsetBox["9", {-1.9999999196153082, 3.000000053589793},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.999999919615308, 3.00000008038469}, 0.19999999999999998],
          InsetBox["10", {-2.999999919615308, 3.00000008038469},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.999999973205102, 1.0000000803846907}, 
          0.19999999999999998], 
         InsetBox["15", {-2.999999973205102, 1.0000000803846907},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999464102052, 2.0000000535897935}, 
          0.19999999999999998], 
         InsetBox["16", {-1.9999999464102052, 2.0000000535897935},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.19999999999999998], 
         InsetBox["20", {0., 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.0000000267948967, -0.9999999732051026}, 
          0.19999999999999998], 
         InsetBox["4", {-1.0000000267948967, -0.9999999732051026},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999999999993, 5.3589794058235685*^-8}, 
          0.19999999999999998], 
         InsetBox["5", {-1.9999999999999993, 5.3589794058235685*^-8},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999946410204, 2.0000001339744844}, 
          0.19999999999999998], 
         InsetBox["7", {-4.999999946410204, 2.0000001339744844},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999732051017, 1.0000001071795879}, 
          0.19999999999999998], 
         InsetBox["13", {-3.9999999732051017, 1.0000001071795879},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.999999946410205, 2.0000000803846905}, 
          0.19999999999999998], 
         InsetBox["14", {-2.999999946410205, 2.0000000803846905},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999464102047, 2.0000001071795874}, 
          0.19999999999999998], 
         InsetBox["11", {-3.9999999464102047, 2.0000001071795874},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999919615307, 3.0000001339744844}, 
          0.19999999999999998], 
         InsetBox["12", {-4.999999919615307, 3.0000001339744844},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.000000026794896, -0.9999998928204116}, 
          0.19999999999999998], 
         InsetBox["17", {-4.000000026794896, -0.9999998928204116},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.000000026794896, -0.9999999196153085}, 
          0.19999999999999998], 
         InsetBox["18", {-3.000000026794896, -0.9999999196153085},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999999999997, 2.6794897029117842*^-8}, 
          0.19999999999999998], 
         InsetBox["19", {-0.9999999999999997, 2.6794897029117842*^-8},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{{3.851516141563281*^9, 3.851516163890604*^9}},
 CellLabel->
  "Out[640]=",ExpressionUUID->"09640b12-6ed5-4102-8550-057d72a8f0cc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g6a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g6", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"17", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"18", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], "}"}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.8515161860389423`*^9, 3.8515162885828743`*^9}},
 CellLabel->
  "In[643]:=",ExpressionUUID->"c1e537db-56ba-4f56-994c-3d163015d9a5"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 8, 9, 10, 15, 16, 20, 4, 5, 7, 13, 14, 11, 12, 17, 18, 
      19}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 2, 3, 4, 5, 7, 8, 10, 10, 10, 11, 12, 14, 16, 17, 18, 19, 21, 
          21, 22}, {{2}, {7}, {6}, {9}, {9}, {3}, {4}, {5}, {3}, {8}, {9}, {
          3}, {2}, {13}, {7}, {14}, {8}, {14}, {2}, {7}, {18}, {9}}}, 
         Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, 
       GraphLayout -> {
        "Dimension" -> 2, 
         "VertexLayout" -> {
          "LayeredDigraphEmbedding", "Orientation" -> Left}}, ImageSize -> 
       600, VertexCoordinates -> {{-4.999999999999998, 
          0}, {-3.9999999196153078`, 
         3.0000001071795874`}, {-0.9999999732051026, 
         1.0000000267948967`}, {-0.9999999196153085, 
         3.000000026794896}, {-1.9999999196153082`, 
         3.000000053589793}, {-2.999999919615308, 
         3.00000008038469}, {-2.999999973205102, 
         1.0000000803846907`}, {-1.9999999464102052`, 2.0000000535897935`}, {
         0, 0}, {-2.67948967458409*^-8, 
         1.0000000267948974`}, {-1.9999999999999993`, 0}, {-4.999999946410204,
          2.0000001339744844`}, {-3.9999999732051017`, 
         1.0000001071795879`}, {-2.999999946410205, 
         2.0000000803846905`}, {-3.9999999464102047`, 
         2.0000001071795874`}, {-4.999999919615307, 
         3.0000001339744844`}, {-4.000000026794896, 
         1.0717958842665354`*^-7}, {-3.000000026794896, 
         8.038469145876803*^-8}, {-0.9999999999999997, 0}}, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{-4.999999999999998, 0.}, {-3.9999999196153078`, 
         3.0000001071795874`}}, 0.19999998928204119`], 
        ArrowBox[{{-4.999999999999998, 0.}, {-2.999999973205102, 
         1.0000000803846907`}}, 0.19999998928204119`], 
        ArrowBox[{{-3.9999999196153078`, 
         3.0000001071795874`}, {-2.999999919615308, 3.00000008038469}}, 
         0.19999998928204119`], 
        ArrowBox[{{-0.9999999732051026, 1.0000000267948967`}, {0., 0.}}, 
         0.19999998928204119`], 
        ArrowBox[{{-0.9999999196153085, 3.000000026794896}, {0., 0.}}, 
         0.19999998928204119`], 
        ArrowBox[{{-1.9999999196153082`, 
         3.000000053589793}, {-0.9999999732051026, 1.0000000267948967`}}, 
         0.19999998928204119`], 
        ArrowBox[{{-1.9999999196153082`, 
         3.000000053589793}, {-0.9999999196153085, 3.000000026794896}}, 
         0.19999998928204119`], 
        ArrowBox[{{-2.999999919615308, 
         3.00000008038469}, {-1.9999999196153082`, 3.000000053589793}}, 
         0.19999998928204119`], 
        ArrowBox[{{-2.999999973205102, 
         1.0000000803846907`}, {-0.9999999732051026, 1.0000000267948967`}}, 
         0.19999998928204119`], 
        ArrowBox[{{-2.999999973205102, 
         1.0000000803846907`}, {-1.9999999464102052`, 2.0000000535897935`}}, 
         0.19999998928204119`], 
        ArrowBox[{{-2.67948967458409*^-8, 1.0000000267948974`}, {0., 0.}}, 
         0.19999998928204119`], 
        ArrowBox[{{-1.9999999999999993`, 0.}, {-0.9999999732051026, 
         1.0000000267948967`}}, 0.19999998928204119`], 
        ArrowBox[{{-4.999999946410204, 
         2.0000001339744844`}, {-3.9999999196153078`, 3.0000001071795874`}}, 
         0.19999998928204119`], 
        ArrowBox[{{-4.999999946410204, 
         2.0000001339744844`}, {-3.9999999732051017`, 1.0000001071795879`}}, 
         0.19999998928204119`], 
        ArrowBox[{{-3.9999999732051017`, 
         1.0000001071795879`}, {-2.999999973205102, 1.0000000803846907`}}, 
         0.19999998928204119`], 
        ArrowBox[{{-3.9999999732051017`, 
         1.0000001071795879`}, {-2.999999946410205, 2.0000000803846905`}}, 
         0.19999998928204119`], 
        ArrowBox[{{-2.999999946410205, 
         2.0000000803846905`}, {-1.9999999464102052`, 2.0000000535897935`}}, 
         0.19999998928204119`], 
        ArrowBox[{{-3.9999999464102047`, 
         2.0000001071795874`}, {-2.999999946410205, 2.0000000803846905`}}, 
         0.19999998928204119`], 
        ArrowBox[{{-4.999999919615307, 
         3.0000001339744844`}, {-3.9999999196153078`, 3.0000001071795874`}}, 
         0.19999998928204119`], 
        ArrowBox[{{-4.000000026794896, 
         1.0717958842665354`*^-7}, {-2.999999973205102, 1.0000000803846907`}},
          0.19999998928204119`], 
        ArrowBox[{{-4.000000026794896, 
         1.0717958842665354`*^-7}, {-3.000000026794896, 
         8.038469145876803*^-8}}, 0.19999998928204119`], 
        ArrowBox[{{-0.9999999999999997, 0.}, {0., 0.}}, 
         0.19999998928204119`]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{-4.999999999999998, 0.}, 0.19999998928204119], 
         InsetBox["1", {-4.999999999999998, 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999196153078, 3.0000001071795874}, 
          0.19999998928204119], 
         InsetBox["2", {-3.9999999196153078, 3.0000001071795874},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999732051026, 1.0000000267948967}, 
          0.19999998928204119], 
         InsetBox["3", {-0.9999999732051026, 1.0000000267948967},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999196153085, 3.000000026794896}, 
          0.19999998928204119], 
         InsetBox["8", {-0.9999999196153085, 3.000000026794896},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999196153082, 3.000000053589793}, 
          0.19999998928204119], 
         InsetBox["9", {-1.9999999196153082, 3.000000053589793},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.999999919615308, 3.00000008038469}, 0.19999998928204119],
          InsetBox["10", {-2.999999919615308, 3.00000008038469},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.999999973205102, 1.0000000803846907}, 
          0.19999998928204119], 
         InsetBox["15", {-2.999999973205102, 1.0000000803846907},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999464102052, 2.0000000535897935}, 
          0.19999998928204119], 
         InsetBox["16", {-1.9999999464102052, 2.0000000535897935},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.19999998928204119], 
         InsetBox["20", {0., 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.67948967458409*^-8, 1.0000000267948974}, 
          0.19999998928204119], 
         InsetBox["4", {-2.67948967458409*^-8, 1.0000000267948974},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999999999993, 0.}, 0.19999998928204119], 
         InsetBox["5", {-1.9999999999999993, 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999946410204, 2.0000001339744844}, 
          0.19999998928204119], 
         InsetBox["7", {-4.999999946410204, 2.0000001339744844},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999732051017, 1.0000001071795879}, 
          0.19999998928204119], 
         InsetBox["13", {-3.9999999732051017, 1.0000001071795879},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.999999946410205, 2.0000000803846905}, 
          0.19999998928204119], 
         InsetBox["14", {-2.999999946410205, 2.0000000803846905},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999464102047, 2.0000001071795874}, 
          0.19999998928204119], 
         InsetBox["11", {-3.9999999464102047, 2.0000001071795874},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999919615307, 3.0000001339744844}, 
          0.19999998928204119], 
         InsetBox["12", {-4.999999919615307, 3.0000001339744844},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.000000026794896, 1.0717958842665354*^-7}, 
          0.19999998928204119], 
         InsetBox["17", {-4.000000026794896, 1.0717958842665354*^-7},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.000000026794896, 8.038469145876803*^-8}, 
          0.19999998928204119], 
         InsetBox["18", {-3.000000026794896, 8.038469145876803*^-8},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999999999997, 0.}, 0.19999998928204119], 
         InsetBox["19", {-0.9999999999999997, 0.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{{3.85151622120455*^9, 3.851516236289721*^9}, 
   3.8515162899378967`*^9},
 CellLabel->
  "Out[643]=",ExpressionUUID->"0c100929-d39a-4432-a32a-d9ef7f912e48"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g7", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{"graph", "[", "7", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851516613136649*^9, 3.85151662255377*^9}},
 CellLabel->
  "In[645]:=",ExpressionUUID->"dab4f72f-1ef7-4523-8f86-9e071bf1ecd6"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 8, 9, 10, 11, 14, 15, 16, 18, 19, 20, 5, 6, 12, 13, 
      17}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 6, 7, 8, 9, 10, 12, 13, 15, 15, 17, 17, 17, 18, 18, 19, 25, 
          28, 31, 33}, {{2}, {4}, {8}, {10}, {12}, {13}, {7}, {14}, {14}, {
          14}, {3}, {5}, {6}, {9}, {11}, {3}, {11}, {3}, {3}, {2}, {4}, {9}, {
          10}, {12}, {13}, {2}, {11}, {12}, {4}, {9}, {10}, {10}, {12}}}, 
         Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 5.}, {-2., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {3., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {-1., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {-3., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {-2., 3.}}, 0.2], 
        ArrowBox[{{0., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGDQA2IQDQEcDhBawOE/GLA7BJ+/cfT1fH4HmPxGD8mKXab8
DoxQvkTOQbGcg3xw+VbLiwsZnBH8PxtAGnjh/LpL6rWX1BF8tnl5Z/m7eeD8
GcKyXAZPuOF8YzDghrvnIkh7LRdcvkjmeKHMcU64e4QFQYATLr+BNRqIOOD8
gF9L/H8tYYfz378DATY4v++xBRAh+Ho3mnRvNLHC+SZg9zDD3XMF7B4muHwh
2D2McPcIgd3DiAg/sHsY4PwFXzznf/H8bw/j37sLAn/hfFmQcYV/4PwYsId+
w/lpYPDNvn2Vz8n0b+wOb8TjglQ4vtorrjJSnX+T3YE9SnZm99HP9if/bRRe
tpLdYYvOEqs58z7ZN6w4NaUmjd3hY/8ns7DJH+09l9esUBJgdzjQzNG3c/EH
e6Xfx/1mLGNzcBY4U98z/70915I17Xc12Ry0rMRm/tB7Z8+0SCv400xWB7PW
9+nbv76x5/7quPHaNxaHlI/hb058fm0/7YHwc4NmRgfZa/md0yKf2x/x3bL/
wLo/9jeMK7S05R/b3+vXND/17Ju9huijebyd9+xL29tN6tZ9tJ+zZcuHoMnX
7eUy5+Tv5H5lL+KW4aUWe9E+VO934+mbD+2lJ/8M5z973F58b5hDat9Ve4U/
J0Lv7N1jL/Z8s8Zu/8P2ciauZkv2r7RnQAMAOrD0qA==
         "]], 0.2], 
        ArrowBox[{{-2., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {-2., 1.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{-1., 4.}, {2., 3.}}, 0.2], 
        ArrowBox[{{-1., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQjQoEHGCs4PM3jr6ezw/nb/SQrNhliuBL5BwUyznI
B+e3Wl5cyOCM4P/ZANLAC+fXXVKvvaSO4LPNyzvL380D588QluUyeMIN5xuD
AYJ/EaS9lgvOL5I5XihznBPOFxYEAQR/A2s0EHHA+QG/lvj/WsIO579/BwJs
cH7fYwsgQvD1bjTp3mhihfNNwO5hhvOvgN3DBOcXgt3DCOcLgd2D4G8Eu4cB
zl/wxXP+F8//9jD+vbsg8BfOlwUZV/gHzo8Be+g3nD9rJgj8hPPB0WX+A87/
fFgp9cHLb3A+O8j6DV8RfHD4f4Hzv/bE7vlX+RnOB0dX7Sc4H6x8ykc4PyLR
r0TjwAc4HwI+2AMAPjN8fg==
         "]], 0.2], 
        ArrowBox[{{0., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQDQEf7CG0gAOMH3z+xtHX8/nh/I0ekhW7TPkdGKF8
iZyDYjkH+eDyrZYXFzI4I/h/NoA08ML5dZfUay+pI/hs8/LO8nfzwPkzhGW5
DJ5ww/nGYIDgXwRpr+WC84tkjhfKHOeEu0dYEAQ44fIbWKOBiAPOD/i1xP/X
EnY4//07EGCD8/seWwARgq93o0n3RhMrnG8Cdg+zg29Y6J+Ux+/t4y5rqco1
MDmYRYZ+nNz73n72qdo9Xy8xOuziYLjf8++d/QcJnZ87tRkdrqWEHvU3e2cf
sc/0dlYXg0NfbuiSOyZv7deUmh4VuPff/pESQ43xr9f2l2S2yalu/md/viXU
J6Ttlb1S0dtDQlP+2kdMDhW1v/nCfnbp7Y03G/7YV/sxXP/86Zm9nXrD68rK
3/YyNuatk1If2/PNm+10ctNP+/d3bcQjJB7Y/8ybx63D88P+WbqSVKfYLfvf
MzvcFrV+s/epyTi7vuaKvbB81Gdt+a/26p+mT/A4ds7e9Z+Q0Mkbn+2r98wU
PTv5qP0E882LKjd9spdbvyb41uFd9p9OWS21XfPRfh6vueniQyvsc3eslBQ9
Bks3iHQEAH/Q13Q=
         "]], 0.2], ArrowBox[{{-1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{1., 5.}, {-2., 4.}}, 0.2], 
        ArrowBox[{{1., 5.}, {3., 4.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEf7CG0iEPOjpWSosc+2D+ZOHVn1Tlhh0+nrJba
rvlo7+y7cdqHKcIOE8w3L6rc9Mle1ih4emKwsIPrPyGhkzc+2+c7VO8+yyns
ICwf9Vlb/qu9dYUms+kOIYdfMzvcFrV+s2+6GZs3PU7I4UfePG4dnh/2TikS
f7/8EXTgnzfb6eSmn/Y1EpHrfScLOtipN7yurPxtb/BNvnWhoqDDmpOruubn
/LGfodQ5+eR9AYf0Q1pqWs5/7SsWu/j/niXgUCTIsE/y71/7MxVBO8yCBRxO
bNMKypv1z37qok3nqjkEHHI2rXqkLv3ffoXjKZWppfwOsSwN+W71/+0Fnl9m
c7vC5zB7zaofJ4/9t08xbXLm0uVzUF+tVbfp43/7JTpXbz2s53WABpDD2TMg
wAPnp7959PW8NIL/K3Gi0YcSbgdGKL9F90aT7g0uuDyL//Zn7a4IfvUxvbj/
ezjh/FeT7V5OtkPwwcpPccD5awzUrUQSEHwIxeEAAMnKpFY=
         "]], 0.2], 
        ArrowBox[{{1., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{1., 5.}, {-3., 4.}}, 0.2], 
        ArrowBox[{{1., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[{{-3., 5.}, {-2., 4.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcByC0iMNqA3UrkQSOAyvT3zz6el7YwX/7s3bX
UxwHIpbw2NydJezwcrIdEHEe4NmWwL0tQdih+phe3P89nAcOz3kR0KAo7MAC
1sB1oA6sQcihWfdGk+4NrgP2YI1CDr8SJxp9KOE+AFEn5JABskaa58CZTj5W
iU+CDmfPgADPgVkzQUDQoS1iSq1mNu8BT97lzfGOgg5fntSd07jFe2BTceui
Pe8EHMSKevafkuQ7cPuMybcNCwUcXvzfE8CvxXdgn8TWOpsoAYe8PoGmb1x8
B+LD2WziJQQcVsi2Bzfs4T1QKRgYY7SD32HKWoWja+x4D6yJNF91xYvfwcTu
7rXqiTwHYtr3Jy59wefQdn5Px9st3AeaZr1sWjKRz2Hfpbi66y0cB6bOltea
28jr4NGx/vXiKawHJG70+z1s43FQ+7DuQtATpgN8AVYfChZyOwRxxeo+KWY4
UMQsz+9zkcth8dpi5g1tf/a7fbJdXSTG5eC2umt2zNIf+3tkph95UsDp0M37
X+mc89f9Tk1a0YsecDiUXLkwkyXp0/5M5R95q1M5HCDx9GE/NN4cABjQxZQ=

         "]], 0.2], ArrowBox[{{-3., 5.}, {-3., 4.}}, 0.2], 
        ArrowBox[{{3., 5.}, {3., 4.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcDhBaxGG1gbqVSAKHw8r0N4++nhd28N/+rN31
FIdDxBIem7uzhB1eTrYDIk4Hnm0J3NsShB2qj+nF/d/D6XB4zouABkVhBxaw
Bi6HOrAGIYdm3RtNuje4HOzBGoUcfiVONPpQwg1VJ+SQAbJGmsfhTCcfq8Qn
QYezZ0CAx2HWTBAQdHi9K0DtQzavg7CvyrZ8B0GHtryCQue7vA53iqpy/r4S
cFjwXHvdMQU+h19cc/Y4zRRwMFZrvlNpxueQLtq5zN5bwMFZq+xPjByfg/ok
R60vDAIOlz6z8BXc4HUoYuruP1DC73CrSV9wcwqvg8VRzX/s7/kcEq9/ZVU7
zOOwKCd+wb4CPofkj+FvTnzmdtj4Q7vsyU9eh12M9RdzhLkc7jTsz9jGyevg
0c7iqhnG4bDEuWmRiDaPA3fTC7d/u9kc2BxLlP/HcjswfdK6/tqF1YGpcurr
0kVcDgbXT3/9+IHZYcbrp78qfnA6TDE8vUjgAJPDqRmpgRwJnA66jJr33Dcx
OkxrEHmvfJPD4Y/r0+XTjzM4/Fv06fLpZFg8MTjA4g0ACQ+1ag==
         "]], 0.2], 
        ArrowBox[{{3., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{-2., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{-2., 5.}, {-3., 4.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 5.}, 0.2], InsetBox["1", {0., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 4.}, 0.2], 
         InsetBox["2", {-2., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["3", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 4.}, 0.2], 
         InsetBox["4", {3., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 1.}, 0.2], 
         InsetBox["8", {-2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["9", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 3.}, 0.2], 
         InsetBox["10", {-2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 4.}, 0.2], 
         InsetBox["11", {-1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["14", {2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 4.}, 0.2], 
         InsetBox["15", {0., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["16", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 4.}, 0.2], 
         InsetBox["18", {-3., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.2], 
         InsetBox["19", {1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.2], 
         InsetBox["20", {0., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["5", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 5.}, 0.2], 
         InsetBox["6", {1., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 5.}, 0.2], 
         InsetBox["12", {-3., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 5.}, 0.2], 
         InsetBox["13", {3., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 5.}, 0.2], 
         InsetBox["17", {-2., 5.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{3.851516623546487*^9},
 CellLabel->
  "Out[645]=",ExpressionUUID->"7eeeb03d-8fcc-4852-8944-9726aa1dbaba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g7a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g7", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"17", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"12", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"14", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"4", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{"18", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], "}"}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.8515166659766293`*^9, 3.851516743248444*^9}, {
  3.851516779347218*^9, 3.85151679156504*^9}, {3.851516843802867*^9, 
  3.851517000562934*^9}, {3.851517034978932*^9, 3.85151708080322*^9}, {
  3.851517137139495*^9, 3.8515171538742723`*^9}},
 CellLabel->
  "In[662]:=",ExpressionUUID->"78b149c4-66c2-4f45-83f8-058bbcbeb181"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 8, 9, 10, 11, 14, 15, 16, 18, 19, 20, 5, 6, 12, 13, 
      17}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 6, 7, 8, 9, 10, 12, 13, 15, 15, 17, 17, 17, 18, 18, 19, 25, 
          28, 31, 33}, {{2}, {4}, {8}, {10}, {12}, {13}, {7}, {14}, {14}, {
          14}, {3}, {5}, {6}, {9}, {11}, {3}, {11}, {3}, {3}, {2}, {4}, {9}, {
          10}, {12}, {13}, {2}, {11}, {12}, {4}, {9}, {10}, {10}, {12}}}, 
         Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, GraphLayout -> {"Dimension" -> 2}, ImageSize -> 600, 
       VertexCoordinates -> {{0, 5.}, {-2., 4.}, {0, 3.}, {2., 4.}, {0., 
         2.}, {-2., 2.}, {-2., 3.}, {-1., 4.}, {1., 3.}, {0, 4.}, {-1., 
         3.}, {-1., 6.}, {1., 4.}, {1, 2}, {2., 2.}, {1., 5.}, {-2., 5.}, {2.,
          5.}, {-1., 5.}}, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 5.}, {-2., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {2., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {-1., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {-1., 6.}}, 0.2], 
        ArrowBox[{{0., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {-2., 3.}}, 0.2], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{2., 4.}, {1., 2.}}, 0.2], 
        ArrowBox[{{0., 2.}, {1., 2.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {0., 3.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {0., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{-1., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{-1., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{0., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{0., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{2., 2.}, {0., 3.}}, 0.2], 
        ArrowBox[{{1., 5.}, {-2., 4.}}, 0.2], 
        ArrowBox[{{1., 5.}, {2., 4.}}, 0.2], 
        ArrowBox[{{1., 5.}, {1., 3.}}, 0.2], 
        ArrowBox[{{1., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{1., 5.}, {-1., 6.}}, 0.2], 
        ArrowBox[{{1., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[{{-2., 5.}, {-2., 4.}}, 0.2], 
        ArrowBox[{{-2., 5.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{-2., 5.}, {-1., 6.}}, 0.2], 
        ArrowBox[{{2., 5.}, {2., 4.}}, 0.2], 
        ArrowBox[{{2., 5.}, {1., 3.}}, 0.2], 
        ArrowBox[{{2., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{-1., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{-1., 5.}, {-1., 6.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 5.}, 0.2], InsetBox["1", {0., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 4.}, 0.2], 
         InsetBox["2", {-2., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 3.}, 0.2], 
         InsetBox["3", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 4.}, 0.2], 
         InsetBox["4", {2., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["8", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["9", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 3.}, 0.2], 
         InsetBox["10", {-2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 4.}, 0.2], 
         InsetBox["11", {-1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["14", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 4.}, 0.2], 
         InsetBox["15", {0., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["16", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 6.}, 0.2], 
         InsetBox["18", {-1., 6.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.2], 
         InsetBox["19", {1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["20", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["5", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 5.}, 0.2], 
         InsetBox["6", {1., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 5.}, 0.2], 
         InsetBox["12", {-2., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 5.}, 0.2], 
         InsetBox["13", {2., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 5.}, 0.2], 
         InsetBox["17", {-1., 5.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{{3.851516675497304*^9, 3.8515167442970877`*^9}, {
   3.851516780109145*^9, 3.851516792889407*^9}, {3.851516851212862*^9, 
   3.85151691013286*^9}, 3.851516960735284*^9, {3.8515169969509373`*^9, 
   3.851517001398794*^9}, {3.851517047510859*^9, 3.851517081935697*^9}, 
   3.851517154909565*^9},
 CellLabel->
  "Out[662]=",ExpressionUUID->"f5ef8577-986c-4a5e-8d20-630fc85d70a5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g8", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{"graph", "[", "8", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851517365331481*^9, 3.851517367363325*^9}},
 CellLabel->
  "In[664]:=",ExpressionUUID->"dba2ab7a-f1dc-43f7-8f2c-007a547e776e"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 6, 7, 13, 14, 16, 2, 5, 12, 17, 3, 9, 10, 11, 19, 15}, {
       SparseArray[
       Automatic, {17, 17}, 0, {
        1, {{0, 3, 3, 5, 7, 9, 10, 10, 14, 15, 17, 18, 19, 21, 23, 24, 25, 
          26}, {{3}, {4}, {5}, {2}, {6}, {2}, {6}, {2}, {6}, {7}, {1}, {9}, {
          10}, {11}, {2}, {4}, {5}, {5}, {2}, {14}, {15}, {8}, {16}, {6}, {
          7}, {5}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{2., 1.}, {4., 0.}}, 0.2], 
        ArrowBox[{{1., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {2., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEf9kNoDgcYP+T8jaOv57PD+Zs8JCt2mbI7MEL5
4jkHxXIOssHl2ywvLmRwRvD/bgBpYIXz6y6p115SR/A55uWd5e9mgfNnCsty
GTxhhvNNjEGA2cE3LPRPyuP3++Mua6nKNTA5mEWGfpzc+37/7FO1e75eYnTY
xcFwv+ffu/0fJHR+7tRmdLiWEnrU3+zd/oh9prezuhgc+nJDl9wxebt/Tanp
UYF7/+0fKTHUGP96vf+SzDY51c3/7M+3hPqEtL3ar1T09pDQlL/2EZNDRe1v
vtg/u/T2xpsNf+yr/Riuf/70bL+desPrysrf9jI25q2TUh/v55s32+nkpp/2
7+/aiEdIPNj/M28etw7PD/tn6UpSnWK39v+e2eG2qPWbvU9Nxtn1NVf2C8tH
fdaW/2qv/mn6BI9j5/a7/hMSOnnjs331npmiZycf3T/BfPOiyk2f7OXWrwm+
dXjX/k+nrJbarvloP4/X3HTxoRX7c3eslBQ99sGeAQV8sAcAVeS+Ww==
         "]], 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{2., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{5., 6.}, {4., 5.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGDQA2IQDQEiDhBawgHGX5n+5tHX8+JwfuQSHpu7s8QdGKF8
nm0J3NsSEPKH57wIaFBE8OsjQBrE4Hz7l5PtXk5G8Fn8tz9rd0Xwz3bysUp8
EoXzZ80EAQQfrN0Owbfse2zR91gE7p7ODhAQgcvfbNK90aSL4GvUXlKvvSQM
51eUgwCCf7xQBogQfPGcg2I5B4XQ3CMI578CuwfBh7hHAO6eLrB7BODyN8Du
QfADfi3x/7WEH87/8A4E+OB8sHEWCL4e2ABeON8YDLjh/IvqIA9ywflFIO8c
54S7R1gQBDjh8htYo4GIA8097HD+e7B72NDcg+BD3MMK558BAxY4Pw2UfKQR
/F+JE40+lDDD3dMCCo4bTHB5SHpA8KuO6cX938OIFt4IPlj5KQY4f42BupVI
AoIPoRkcAKVYqmE=
         "]], 0.2], ArrowBox[{{4., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[{{4., 5.}, {4., 4.}}, 0.2], 
        ArrowBox[{{5., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGDQA2IQDQECDuh08PkbR1/P54fzN3pIVuwy5XdghPIlcg6K
5Rzkg8u3Wl5cyOCM4P/ZANLAC+fXXVKvvaSO4LPNyzvL380D588QluUyeMIN
5xuDAYJ/EaS9lgvOL5I5XihznBPuHmFBEOCEy29gjQYiDjg/4NcS/19L2OH8
9+9AgA3O73tsAUQIvt6NJt0bTaxwvgnYPcxw/hWwe5jg/EKwexjh7hECu4cR
EX5g9zDA+Qu+eM7/4vnfHsa/dxcE/sL5siDjCv/A+TFgD/2G89PA4Bucv9gf
5MEvcD7YO32f7WHuUVYCgU9w+UTubQnc2z7A+fYvJ9u9nPwOzt+zGwRew/mW
4AB6AeeDdCdwP4PzIfH1GM6ft7H7un3+Azj/HH/3lMblt+HuEQenn2tweVDq
ste5BOevSH/z6Ov503D+FDuQAw/D+Q9eXgMmsZ1w/j+tM518rCvgfAYoAACt
jauY
         "]], 0.2], ArrowBox[{{3., 3.}, {2., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 3.}, 0.2], InsetBox["1", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["4", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["6", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["7", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["13", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["14", {2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 0.}, 0.2], 
         InsetBox["16", {4., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.2], 
         InsetBox["2", {1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["5", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["12", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["17", {2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["3", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 6.}, 0.2], 
         InsetBox["9", {5., 6.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 5.}, 0.2], 
         InsetBox["10", {4., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 2.}, 0.2], 
         InsetBox["11", {5., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 4.}, 0.2], 
         InsetBox["19", {4., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.2], 
         InsetBox["15", {3., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{3.8515173682156982`*^9},
 CellLabel->
  "Out[664]=",ExpressionUUID->"578f414a-2e2a-4fb4-822e-00f4b550a268"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g8a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g8", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"19", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"14", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"11", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"16", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851517392515753*^9, 3.851517491203444*^9}, {
   3.851517553645295*^9, 3.8515175568118896`*^9}, {3.851517607485601*^9, 
   3.851517615516018*^9}, {3.851517728917714*^9, 3.8515177484139233`*^9}, {
   3.851517783422345*^9, 3.85151793323879*^9}, 3.851518032695154*^9},
 CellLabel->
  "In[681]:=",ExpressionUUID->"74225860-5af1-4167-8cd6-375533efe11d"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 6, 7, 13, 14, 16, 2, 5, 12, 17, 3, 9, 10, 11, 19, 15}, {
       SparseArray[
       Automatic, {17, 17}, 0, {
        1, {{0, 3, 3, 5, 7, 9, 10, 10, 14, 15, 17, 18, 19, 21, 23, 24, 25, 
          26}, {{3}, {4}, {5}, {2}, {6}, {2}, {6}, {2}, {6}, {7}, {1}, {9}, {
          10}, {11}, {2}, {4}, {5}, {5}, {2}, {14}, {15}, {8}, {16}, {6}, {
          7}, {5}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, GraphLayout -> {"Dimension" -> 2}, ImageSize -> 600, 
       VertexCoordinates -> {{0, 3.}, {0, 1.}, {0, 2.}, {1., 2.}, {2., 2.}, {
         1., 1.}, {2., 1}, {1., 4.}, {-1., 3.}, {1., 3.}, {2., 3.}, {-1., 
         1.}, {3., 4.}, {2., 4.}, {4., 2.}, {3., 2.}, {3., 1.}}, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{1., 1.}, {2., 1.}}, 0.2], 
        ArrowBox[{{1., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {2., 3.}}, 0.2], 
        ArrowBox[{{-1., 3.}, {0., 1.}}, 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{2., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {0., 1.}}, 0.2], 
        ArrowBox[{{3., 4.}, {2., 4.}}, 0.2], 
        ArrowBox[{{3., 4.}, {4., 2.}}, 0.2], 
        ArrowBox[{{2., 4.}, {1., 4.}}, 0.2], 
        ArrowBox[{{2., 4.}, {3., 2.}}, 0.2], 
        ArrowBox[{{4., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{3., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{3., 1.}, {2., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 3.}, 0.2], InsetBox["1", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["4", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["6", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["7", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["13", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["14", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["16", {2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.2], 
         InsetBox["2", {1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["5", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["12", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["17", {2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["3", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 4.}, 0.2], 
         InsetBox["9", {3., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 4.}, 0.2], 
         InsetBox["10", {2., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 2.}, 0.2], 
         InsetBox["11", {4., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.2], 
         InsetBox["19", {3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 1.}, 0.2], 
         InsetBox["15", {3., 1.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{{3.851517832521887*^9, 3.851517873974101*^9}, {
   3.851517908567781*^9, 3.851517934216742*^9}, 3.851518033953751*^9},
 CellLabel->
  "Out[681]=",ExpressionUUID->"cb15adfa-2a78-4d51-a52a-3e8d224ddd59"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g9", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"graph", "[", "9", "]"}], ",", 
    RowBox[{"GraphLayout", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<LayeredDigraphEmbedding\>\"", ",", 
       RowBox[{"\"\<Orientation\>\"", "\[Rule]", "Left"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.851518038069889*^9, 3.851518040046607*^9}, {
  3.851518118479744*^9, 3.8515181194252987`*^9}},
 CellLabel->
  "In[683]:=",ExpressionUUID->"9d6d87be-2209-437b-877c-8cd788c05081"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 6, 7, 13, 14, 16, 20, 2, 5, 12, 17, 3, 8, 11, 10, 19, 15}, {
      
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 3, 4, 6, 8, 10, 11, 11, 11, 15, 16, 18, 19, 20, 22, 23, 26, 
          28, 29}, {{3}, {4}, {5}, {8}, {2}, {6}, {2}, {6}, {2}, {6}, {7}, {
          1}, {10}, {11}, {12}, {2}, {4}, {5}, {5}, {2}, {1}, {15}, {6}, {
          9}, {13}, {17}, {7}, {8}, {5}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, 
       GraphLayout -> {
        "Dimension" -> 2, 
         "VertexLayout" -> {
          "LayeredDigraphEmbedding", "Orientation" -> Left}}, ImageSize -> 
       600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{-2.999999999999999, 
         8.038469108735353*^-8}, {-1.9999999999999993`, 
         5.3589794058235685`*^-8}}, 0.1999999999999999], 
        ArrowBox[{{-2.999999999999999, 
         8.038469108735353*^-8}, {-2.0000000267948965`, -0.9999999464102056}},
          0.1999999999999999], 
        ArrowBox[{{-2.999999999999999, 
         8.038469108735353*^-8}, {-2.0000000535897935`, \
-1.9999999464102052`}}, 0.1999999999999999], 
        ArrowBox[{{-1.0000000535897937`, -1.9999999732051024`}, \
{-5.3589794058235685`*^-8, -1.9999999999999993`}}, 0.1999999999999999], 
        ArrowBox[{{-1.9999999999999993`, 
         5.3589794058235685`*^-8}, {-1.0000000535897937`, \
-1.9999999732051024`}}, 0.1999999999999999], 
        ArrowBox[{{-1.9999999999999993`, 
         5.3589794058235685`*^-8}, {-0.9999999999999997, 
         2.6794897029117842`*^-8}}, 0.1999999999999999], 
        ArrowBox[{{-2.0000000267948965`, -0.9999999464102056}, \
{-1.0000000535897937`, -1.9999999732051024`}}, 0.1999999999999999], 
        ArrowBox[{{-2.0000000267948965`, -0.9999999464102056}, \
{-0.9999999999999997, 2.6794897029117842`*^-8}}, 0.1999999999999999], 
        ArrowBox[{{-2.0000000535897935`, -1.9999999464102052`}, \
{-1.0000000535897937`, -1.9999999732051024`}}, 0.1999999999999999], 
        ArrowBox[{{-2.0000000535897935`, -1.9999999464102052`}, \
{-0.9999999999999997, 2.6794897029117842`*^-8}}, 0.1999999999999999], 
        ArrowBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {
         2.6794897029117842`*^-8, 0.9999999999999997}}, 0.1999999999999999], 
        ArrowBox[{{-4.000000026794896, -0.9999998928204116}, \
{-2.999999999999999, 8.038469108735353*^-8}}, 0.1999999999999999], 
        ArrowBox[{{-4.000000026794896, -0.9999998928204116}, \
{-3.0000001071795874`, -3.9999999196153078`}}, 0.1999999999999999], 
        ArrowBox[{{-4.000000026794896, -0.9999998928204116}, \
{-3.000000026794896, -0.9999999196153085}}, 0.1999999999999999], 
        ArrowBox[{{-4.000000026794896, -0.9999998928204116}, \
{-3.000000053589793, -1.9999999196153082`}}, 0.1999999999999999], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAn6liDgAACMDFADb1//8PwN1HENTr
nwfALAE6u+ufD8A/BCGGujUHwIY3qm26NQ/Aw96UJGzBBsDQo4YMbMEOwGbX
a68AQwbACUbPlwBDDsAs7qUmeLoFwDIehA94ug3AFCNDitInBcBMLKVz0icN
wB12Q9oPiwTAVHAyxA+LDMBI56YWMOQDwE7qKwEw5AvAlHZtPzMzA8A4mpEq
MzMLwPGUZd4nfQLAGWUtyid9CsBOs119HMcBwPsvyWkcxwnArNFVHBERAcDd
+mQJEREJwAjwTbsFWwDAv8UAqQVbCMDMHIy09En/v5+QnEj6pAfAhll88t3d
/b+AWzjo7u4GwD+WbDDHcfy/YibUh+M4BsD60lxusAX7v0TxbyfYggXAtA9N
rJmZ+b8lvAvHzMwEwEwu2v2fN/i/Dmxx8M8bBMCjEKF24On2vwjmai3wdAPA
trahFluw9b8SKvh9LdgCwIQg3N0Pi/S/KjgZ4odFAsAQTlDM/nnzv1MQzln/
vAHAWT/+4Sd98r+Mshblkz4BwF705R6LlPG/1R7zg0XKAMAgbQeDKMDwvy5V
YzYUYADAn6liDgAA8L8tq874////v+u/2Z4=
         "]], 0.1999999999999999], 
        ArrowBox[{{-3.000000026794896, -0.9999999196153085}, \
{-2.0000000267948965`, -0.9999999464102056}}, 0.1999999999999999], 
        ArrowBox[{{-3.000000026794896, -0.9999999196153085}, \
{-2.0000000535897935`, -1.9999999464102052`}}, 0.1999999999999999], 
        ArrowBox[{{-3.000000053589793, -1.9999999196153082`}, \
{-2.0000000535897935`, -1.9999999464102052`}}, 0.1999999999999999], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQzbzqLwcDg8ABvdXnfvz/L3wgUvnK9dfz+Q/scH4C
5m+bI9K1y5T/gJnSHzBf7sAejZyDfAdWuIn9BPF7es9sZnDmO8C70QjMZ2J1
0a7YxXsgLTEQzG9RU+6/pM57YFN4EZjP+ynzPn83z4FPk6eC+fPTJWQMnnAf
UBPbDeZbteu5GhtzH/C99wjMv1ld8US9lutA7knuXyB+ZcGhZpnjnAcmbDEB
8yVSeZQFBTkPbJwfC+Zvjww7xBrNceBSVxuYH+63IPHXEvYDn0rXg/nfnF4x
vH/HdkA48QaYP83cZMFjC7YDJj6Mv0F8E506+xtNrAfCzLV+I9zDfKDJeD2Y
f4FfzVqohenA76c1D4x/A80/UHHv6CPGA8rqU/rOvxE+cGaGmr6fP+OBv9++
sF6+InzAYKa+7uqTDAdaQue72W0WPtB8cPKNO4EMB/Y6TQ4Q7BA+0K28LOnY
+f/7l+y7oOwTLHzgnfDtvBrx//utT4YfeCcifEA/5NjV21X/9jcnaaj9PCN0
wO9J+vQnP//ur+pyCs2uFjqwKuZm0uk1v/eLbs0tmHFQ4IDY8uYNU/t/7u8K
k45KCOc7MPFwWoPzou/7hW65iKUWcx+Q2NR06cqTr/sPfQkXtb/OcWBD0fVl
nuFf9s9ZFhL+rontQBhr6t+FPz/tn/fe6k5RGcsBrizta3dPf9x/4jzXkjMb
mQ6cW6Bl+Pfsh/3S7kfW/TZhPDB/ZRIfA8OH/brg9PN/PwCI6EBb
         "]], 
         0.1999999999999999], 
        ArrowBox[{{-3.9999999999999987`, 
         1.0717958811647137`*^-7}, {-2.999999999999999, 
         8.038469108735353*^-8}}, 0.1999999999999999], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQ/fc/CPAfSEqScgw+WmN3au6/oq9z+A/8+7b/0LJD
K+xvRTDpPtTkP/B77U/hO4d32WsbcusdXsZ34JCq4Kezk4/a71CTLJstzHeA
79WbDM9j5+w7LHVYswp4D3wQ9DDfUHPFfkamy229vTwH5mTWNnaK3bJ/ti3x
x8uf3AfY7Lo9IyQe2JcrtsTMVuM+sGAJ57ZJqY/t3VauZnd25jow+4Ul25dP
z+xZo91VJu/nPDAtcZGz/c0X9tuU+2Z/M+U88Pv+qsqQtlf2gcwNubnLOA6c
Sg5eYfzrtf2NnzKzvgtwHGB8O/v8HZO39n7sqYpTS9kPLKxuee9v9s5+g3YE
s9sVtgMr+Xk5ev+9s/+X9s2eS5ftgNRKU8kpve/trXbaX39Yz3rgm/s/pdTH
7+2TlUxOnjnDckCmbLMQA8MH+7+OXp/OS7McqA8VAfMnbP+h96GE+cBGnzpB
EF+q2b5e9wbTgY3RHwVA/FlL5B63uzIdqG/KBfMFZaZF/d/DeEDm4Cd+EL/h
5dKnk+0YD7SLN4L5z3j8WlxPMRw40CoB5ju19ZmJJDAcOMG9kw/E11197gcw
wvbPX5kE5gMABBLT1g==
         "]], 0.1999999999999999], 
        ArrowBox[{{-1.9999999732051024`, 
         1.0000000535897937`}, {-0.9999999999999997, 
         2.6794897029117842`*^-8}}, 0.1999999999999999], 
        ArrowBox[{{-5.000000026794895, -0.9999998660255145}, \
{-4.000000026794896, -0.9999998928204116}}, 0.1999999999999999], 
        ArrowBox[{{-5.000000026794895, -0.9999998660255145}, \
{-4.000000133974484, -4.99999989282041}}, 0.1999999999999999], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJwd0nlIk2EYAPBvLt2R2g5LXJZ2LVM71MqD2SuIaVSa0brQMEHK0JV41NR0
llEtMcLSWJRH2K3mVQrF+1RqaNPKlqjlUhqWmrTDOa/t6/v64+X3x8tz8Tyr
Ek/vT7IjCGIT9Wj9pWoGQbjAYJ2ghST/Yo34gauoRwiJi/3cKkf+4PqzwxxZ
iRBsHuaw4e1j+H1kTv98jBCeTB7b/JrUYWFZ1sV3TCEkZch0gZJhrErq5bbX
CiDxZCRU9H/FRxuLZUSsALY1zV0VhbXhWMXT2sxxPpzhcaOkymp0Qe31YW0O
H3gpTZwTdz6hP2UObU5MPljWuA9F3vuB7F601la854FrlVGviP+J3EuryJwr
PIjetcMk6xtFQUFvXpRH8KCclWaeDB5HNUE+j1xtS4A9pLRYL08ifSGqUyQv
gQ5de25Mgh6FSPGF7G5nKB1tPf/bYEDKx09W23s7gzG90tZ5zoS0BYzrnvlO
8L0olzRNTaFhm2BReDgX9k65M7Pl86jiea1nCeZA15bPleUpCyhabi6b3sYB
2+mvEu9wK5o4/Cs59QEbdPUbNG5WK0qLKSy18NigmO4+IVPZ0GicesWtTBZ8
Cn1rWb+cRFEFmIzQOMCXyw6FO/NJVPoqXsLd6ABFGpVjVweJep0ffhnJt4fZ
Nfk3GgwkOq5l+AYEMGHmdiWbWl/YteaFFSsVdnBsUF1M//fEHmk29zKg2bee
TceLG12NrT4MMHjp8/7nHwjUnFISIPh41UDXD1amv+RpSSzyyEug+8uYCOGv
a7Rhrlv3B7p/bV97s+CmFWtfZQXQ82XtcakeUCxgFTenjJ4/ZI/4h1w+j0Ps
Bi2USOLtHNjZMIsH+BuiKdHf6R7C13EGz42mLqNE0oaTkqpL01hV8GgfJUqO
+zbm42HGLSP9C5Rok1nM6ew34UMsUkSJqnN3q+QNRpxlFD2lRGpj1N3QZwbs
ct+3hhJVH/IQLO3QY3+3rasoUdzBuwb6jj8e8GMRhB79A+Zzgqw=
         "]], 
         0.1999999999999999], 
        ArrowBox[{{-0.9999999732051026, 1.0000000267948967`}, {
         2.6794897029117842`*^-8, 0.9999999999999997}}, 0.1999999999999999], 
        ArrowBox[{{-0.9999999732051026, 
         1.0000000267948967`}, {-5.3589794058235685`*^-8, \
-1.9999999999999993`}}, 0.1999999999999999], 
        ArrowBox[{{-3.00000008038469, -2.999999919615308}, \
{-2.0000000535897935`, -1.9999999464102052`}}, 0.1999999999999999]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {
         DiskBox[{-2.999999999999999, 8.038469108735353*^-8}, 
          0.1999999999999999], 
         InsetBox["1", {-2.999999999999999, 8.038469108735353*^-8},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.0000000535897937, -1.9999999732051024}, 
          0.1999999999999999], 
         InsetBox["4", {-1.0000000535897937, -1.9999999732051024},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999999999993, 5.3589794058235685*^-8}, 
          0.1999999999999999], 
         InsetBox["6", {-1.9999999999999993, 5.3589794058235685*^-8},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.0000000267948965, -0.9999999464102056}, 
          0.1999999999999999], 
         InsetBox["7", {-2.0000000267948965, -0.9999999464102056},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.0000000535897935, -1.9999999464102052}, 
          0.1999999999999999], 
         InsetBox["13", {-2.0000000535897935, -1.9999999464102052},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999999999997, 2.6794897029117842*^-8}, 
          0.1999999999999999], 
         InsetBox["14", {-0.9999999999999997, 2.6794897029117842*^-8},
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.6794897029117842*^-8, 0.9999999999999997}, 
          0.1999999999999999], 
         InsetBox["16", {2.6794897029117842*^-8, 0.9999999999999997},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-5.3589794058235685*^-8, -1.9999999999999993}, 
          0.1999999999999999], 
         InsetBox["20", {-5.3589794058235685*^-8, -1.9999999999999993},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.000000026794896, -0.9999998928204116}, 
          0.1999999999999999], 
         InsetBox["2", {-4.000000026794896, -0.9999998928204116},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.0000001071795874, -3.9999999196153078}, 
          0.1999999999999999], 
         InsetBox["5", {-3.0000001071795874, -3.9999999196153078},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.000000026794896, -0.9999999196153085}, 
          0.1999999999999999], 
         InsetBox["12", {-3.000000026794896, -0.9999999196153085},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.000000053589793, -1.9999999196153082}, 
          0.1999999999999999], 
         InsetBox["17", {-3.000000053589793, -1.9999999196153082},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.000000133974484, -4.99999989282041}, 0.1999999999999999],
          InsetBox["3", {-4.000000133974484, -4.99999989282041},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999999999987, 1.0717958811647137*^-7}, 
          0.1999999999999999], 
         InsetBox["8", {-3.9999999999999987, 1.0717958811647137*^-7},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999732051024, 1.0000000535897937}, 
          0.1999999999999999], 
         InsetBox["11", {-1.9999999732051024, 1.0000000535897937},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-5.000000026794895, -0.9999998660255145}, 
          0.1999999999999999], 
         InsetBox["10", {-5.000000026794895, -0.9999998660255145},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999732051026, 1.0000000267948967}, 
          0.1999999999999999], 
         InsetBox["19", {-0.9999999732051026, 1.0000000267948967},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.00000008038469, -2.999999919615308}, 0.1999999999999999],
          InsetBox["15", {-3.00000008038469, -2.999999919615308},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{3.8515180408904753`*^9, 3.8515181209523363`*^9},
 CellLabel->
  "Out[683]=",ExpressionUUID->"895ed863-5932-4091-85eb-a89c1183ff74"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g9a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g9", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"10", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"19", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"11", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"16", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "}"}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.851518184406713*^9, 3.8515182459584637`*^9}, {
   3.8515183698562527`*^9, 3.851518392735092*^9}, {3.851518557249778*^9, 
   3.8515185748877172`*^9}, {3.851518624897347*^9, 3.8515186870002737`*^9}, 
   3.851518731961576*^9, {3.851518801946253*^9, 3.851518821050042*^9}},
 CellLabel->
  "In[695]:=",ExpressionUUID->"d02f52d0-3ac0-4eb2-816f-8e99b573921a"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 6, 7, 13, 14, 16, 20, 2, 5, 12, 17, 3, 8, 11, 10, 19, 15}, {
      
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 3, 4, 6, 8, 10, 11, 11, 11, 15, 16, 18, 19, 20, 22, 23, 26, 
          28, 29}, {{3}, {4}, {5}, {8}, {2}, {6}, {2}, {6}, {2}, {6}, {7}, {
          1}, {10}, {11}, {12}, {2}, {4}, {5}, {5}, {2}, {1}, {15}, {6}, {
          9}, {13}, {17}, {7}, {8}, {5}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, 
       GraphLayout -> {
        "Dimension" -> 2, 
         "VertexLayout" -> {
          "LayeredDigraphEmbedding", "Orientation" -> Left}}, ImageSize -> 
       600, VertexCoordinates -> {{-2.999999999999999, 
          0}, {-1.0000000535897937`, -1.9999999732051024`}, \
{-1.9999999999999993`, 
          0}, {-2.0000000267948965`, -0.9999999464102056}, \
{-2.0000000535897935`, -1.9999999464102052`}, {-0.9999999999999997, 0}, {
         0, -3.3306690738754696`*^-16}, {
         0, -1.9999999999999993`}, {-4.000000026794896, -0.9999998928204116}, \
{-3.0000001071795874`, -2.9999999196153078`}, {-3.000000026794896, \
-0.9999999196153085}, {-3.000000053589793, -1.9999999196153082`}, \
{-4.000000133974484, -2.9999998928204104`}, {-3.9999999999999987`, 
          0}, {-0.9999999732051024, -0.9999999464102063}, \
{-4.000000026794895, -1.9999998660255145`}, {
         2.6794897411974716`*^-8, -0.9999999732051033}, {-2.00000008038469, \
-2.999999919615308}}, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{-2.999999999999999, 0.}, {-1.9999999999999993`, 0.}}, 
         0.1999999785640824], 
        ArrowBox[{{-2.999999999999999, 
         0.}, {-2.0000000267948965`, -0.9999999464102056}}, 
         0.1999999785640824], 
        ArrowBox[{{-2.999999999999999, 
         0.}, {-2.0000000535897935`, -1.9999999464102052`}}, 
         0.1999999785640824], 
        ArrowBox[{{-1.0000000535897937`, -1.9999999732051024`}, {
         0., -1.9999999999999993`}}, 0.1999999785640824], 
        ArrowBox[{{-1.9999999999999993`, 
         0.}, {-1.0000000535897937`, -1.9999999732051024`}}, 
         0.1999999785640824], 
        ArrowBox[{{-1.9999999999999993`, 0.}, {-0.9999999999999997, 0.}}, 
         0.1999999785640824], 
        ArrowBox[{{-2.0000000267948965`, -0.9999999464102056}, \
{-1.0000000535897937`, -1.9999999732051024`}}, 0.1999999785640824], 
        ArrowBox[{{-2.0000000267948965`, -0.9999999464102056}, \
{-0.9999999999999997, 0.}}, 0.1999999785640824], 
        ArrowBox[{{-2.0000000535897935`, -1.9999999464102052`}, \
{-1.0000000535897937`, -1.9999999732051024`}}, 0.1999999785640824], 
        ArrowBox[{{-2.0000000535897935`, -1.9999999464102052`}, \
{-0.9999999999999997, 0.}}, 0.1999999785640824], 
        ArrowBox[{{-0.9999999999999997, 0.}, {0., -3.3306690738754696`*^-16}},
          0.1999999785640824], 
        ArrowBox[{{-4.000000026794896, -0.9999998928204116}, \
{-2.999999999999999, 0.}}, 0.1999999785640824], 
        ArrowBox[{{-4.000000026794896, -0.9999998928204116}, \
{-3.0000001071795874`, -2.9999999196153078`}}, 0.1999999785640824], 
        ArrowBox[{{-4.000000026794896, -0.9999998928204116}, \
{-3.000000026794896, -0.9999999196153085}}, 0.1999999785640824], 
        ArrowBox[{{-4.000000026794896, -0.9999998928204116}, \
{-3.000000053589793, -1.9999999196153082`}}, 0.1999999785640824], 
        ArrowBox[{{-3.0000001071795874`, -2.9999999196153078`}, \
{-1.0000000535897937`, -1.9999999732051024`}}, 0.1999999785640824], 
        ArrowBox[{{-3.000000026794896, -0.9999999196153085}, \
{-2.0000000267948965`, -0.9999999464102056}}, 0.1999999785640824], 
        ArrowBox[{{-3.000000026794896, -0.9999999196153085}, \
{-2.0000000535897935`, -1.9999999464102052`}}, 0.1999999785640824], 
        ArrowBox[{{-3.000000053589793, -1.9999999196153082`}, \
{-2.0000000535897935`, -1.9999999464102052`}}, 0.1999999785640824], 
        ArrowBox[{{-4.000000133974484, -2.9999998928204104`}, \
{-1.0000000535897937`, -1.9999999732051024`}}, 0.1999999785640824], 
        ArrowBox[{{-3.9999999999999987`, 0.}, {-2.999999999999999, 0.}}, 
         0.1999999785640824], 
        ArrowBox[{{-3.9999999999999987`, 
         0.}, {-0.9999999732051024, -0.9999999464102063}}, 
         0.1999999785640824], 
        ArrowBox[{{-0.9999999732051024, -0.9999999464102063}, \
{-0.9999999999999997, 0.}}, 0.1999999785640824], 
        ArrowBox[{{-4.000000026794895, -1.9999998660255145`}, \
{-4.000000026794896, -0.9999998928204116}}, 0.1999999785640824], 
        ArrowBox[{{-4.000000026794895, -1.9999998660255145`}, \
{-4.000000133974484, -2.9999998928204104`}}, 0.1999999785640824], 
        ArrowBox[{{-4.000000026794895, -1.9999998660255145`}, {
         2.6794897411974716`*^-8, -0.9999999732051033}}, 0.1999999785640824], 
        ArrowBox[{{2.6794897411974716`*^-8, -0.9999999732051033}, {
         0., -3.3306690738754696`*^-16}}, 0.1999999785640824], 
        ArrowBox[{{2.6794897411974716`*^-8, -0.9999999732051033}, {
         0., -1.9999999999999993`}}, 0.1999999785640824], 
        ArrowBox[{{-2.00000008038469, -2.999999919615308}, \
{-2.0000000535897935`, -1.9999999464102052`}}, 0.1999999785640824]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{-2.999999999999999, 0.}, 0.1999999785640824], 
         InsetBox["1", {-2.999999999999999, 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.0000000535897937, -1.9999999732051024}, 
          0.1999999785640824], 
         InsetBox["4", {-1.0000000535897937, -1.9999999732051024},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999999999993, 0.}, 0.1999999785640824], 
         InsetBox["6", {-1.9999999999999993, 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.0000000267948965, -0.9999999464102056}, 
          0.1999999785640824], 
         InsetBox["7", {-2.0000000267948965, -0.9999999464102056},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.0000000535897935, -1.9999999464102052}, 
          0.1999999785640824], 
         InsetBox["13", {-2.0000000535897935, -1.9999999464102052},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999999999997, 0.}, 0.1999999785640824], 
         InsetBox["14", {-0.9999999999999997, 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., -3.3306690738754696*^-16}, 0.1999999785640824], 
         InsetBox["16", {0., -3.3306690738754696*^-16},
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., -1.9999999999999993}, 0.1999999785640824], 
         InsetBox["20", {0., -1.9999999999999993},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.000000026794896, -0.9999998928204116}, 
          0.1999999785640824], 
         InsetBox["2", {-4.000000026794896, -0.9999998928204116},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.0000001071795874, -2.9999999196153078}, 
          0.1999999785640824], 
         InsetBox["5", {-3.0000001071795874, -2.9999999196153078},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.000000026794896, -0.9999999196153085}, 
          0.1999999785640824], 
         InsetBox["12", {-3.000000026794896, -0.9999999196153085},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.000000053589793, -1.9999999196153082}, 
          0.1999999785640824], 
         InsetBox["17", {-3.000000053589793, -1.9999999196153082},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.000000133974484, -2.9999998928204104}, 
          0.1999999785640824], 
         InsetBox["3", {-4.000000133974484, -2.9999998928204104},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999999999987, 0.}, 0.1999999785640824], 
         InsetBox["8", {-3.9999999999999987, 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999732051024, -0.9999999464102063}, 
          0.1999999785640824], 
         InsetBox["11", {-0.9999999732051024, -0.9999999464102063},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.000000026794895, -1.9999998660255145}, 
          0.1999999785640824], 
         InsetBox["10", {-4.000000026794895, -1.9999998660255145},
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.6794897411974716*^-8, -0.9999999732051033}, 
          0.1999999785640824], 
         InsetBox["19", {2.6794897411974716*^-8, -0.9999999732051033},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.00000008038469, -2.999999919615308}, 0.1999999785640824],
          InsetBox["15", {-2.00000008038469, -2.999999919615308},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{
  3.851518192666271*^9, {3.8515182257148323`*^9, 3.8515182471088743`*^9}, 
   3.851518394085001*^9, {3.851518558588089*^9, 3.8515185761329927`*^9}, {
   3.8515186386683903`*^9, 3.851518688025652*^9}, 3.851518734074854*^9, {
   3.851518810285234*^9, 3.851518822502616*^9}},
 CellLabel->
  "Out[695]=",ExpressionUUID->"01e3c9ec-9673-4c9a-8f45-b5240be186e3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g10", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"graph", "[", "10", "]"}], ",", 
    RowBox[{"GraphLayout", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<LayeredDigraphEmbedding\>\"", ",", 
       RowBox[{"\"\<Orientation\>\"", "\[Rule]", "Top"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.851518874185464*^9, 3.851518898753121*^9}},
 CellLabel->
  "In[699]:=",ExpressionUUID->"32713679-41ce-4e8d-adf9-895999987a1c"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 6, 7, 8, 11, 13, 14, 16, 20, 2, 5, 12, 17, 18, 3, 9, 19, 
      15}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 5, 6, 8, 10, 11, 12, 14, 15, 15, 15, 20, 21, 23, 24, 24, 25, 
          32, 34, 35}, {{3}, {4}, {5}, {6}, {7}, {10}, {2}, {8}, {2}, {8}, {
          1}, {8}, {2}, {8}, {9}, {1}, {12}, {13}, {14}, {15}, {2}, {4}, {
          7}, {7}, {2}, {1}, {12}, {13}, {14}, {15}, {16}, {18}, {9}, {10}, {
          7}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, 
       GraphLayout -> {
        "Dimension" -> 2, 
         "VertexLayout" -> {"LayeredDigraphEmbedding", "Orientation" -> Top}},
        ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[{{0., 3.}, {-0.9999999999999852, 
         2.671118505633769}, {-2., 3.}}], 0.2], 
        ArrowBox[{{2., 1.}, {3., 0.}}, 0.2], 
        ArrowBox[{{0., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[BezierCurveBox[{{-2., 3.}, {-1.0000000000000098`, 
         3.328881494366239}, {0., 3.}}], 0.2], 
        ArrowBox[{{-1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{1., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{1., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {4., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {3., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQECDhCawyH4/I2jr+fzO4SAaXaHjR6SFbtM+R02
gWl2B4mcg2I5B/kcxME0m0Or5cWFDM58Dm1gms3hzwaQQl6Hv2Ca1aHuknrt
JXVeKM3qwDYv7yx/N48DB5hmcZghLMtl8ITbYSaYZnYwBgNuBxMwzexwEaSt
lsvhCphmciiSOV4oc5zToRBMMzoIC4IAp4MQmGZ02MAaDUQcDhvBNINDwK8l
/r+WsDss+OI5/4vnf/v370CAzeHeXRD4a9/32AKI2BxkQcYV/rHXu9Gke6OJ
1SEGbNBv+zNgwOIwayYI/LRPe/Po63lpFgdw8Jj/sP+VONHoQwmzw+fDSqkP
Xn6zb9EFGcDkwA6yfsNXexb/7c/aXYF8sH+/2Fcd04v7v4fR4WtP7J5/lZ/t
X022eznZjtEBHDy1n+zByk8xOICVT/lov8ZA3UokgcEhItGvROPAB3tohEHj
64M9AMnEth8=
         "]], 0.2], ArrowBox[{{1., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{3., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQESDhCaw+E/GIg7hJy/cfT1fHYHmPwmD8mKXabs
DoxQvnjOQbGcg2xw+TbLiwsZnBH8vxtAGljh/LpL6rWX1BF8jnl5Z/m7WeD8
mcKyXAZPmOF8E2MQYHYIFuOQlfgt7vC1Y+aXCy1MDiGRCiUJb8Qdfiyw+HXg
KaPDnxMerDcvizs4VAu4MIcxOvilNl5o3CjucEpc8dL0qwwOnnqnrka1ijtM
L8taUpfC4PBOWVk0xV/cYcX0N7u2MzE42Ln19M3lF3f49tVPuy3hv73ZVFYn
9mNiDqqOZpmOt/7Z3xDo119YJOYAof/ZT8/89tOAR8QBQv+xP/fpf/H8G4IO
Z8H0T/v3EeHWN9fzO1SsWT33zfXv9lq6n98aiPA4TJ32s0yC65u9f9Ll/673
OBzUNr78r5T/xT7ux/cCCT42B70/1RY87J/tQ94nOK5YzOywqnyDwpWLH+3N
3PkKv85jdJij3L6j6vwHe2iEQcPpgz0AP9yjEA==
         "]], 0.2], 
        ArrowBox[{{3., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{3., 4.}, {4., 3.}}, 0.2], 
        ArrowBox[{{3., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{3., 4.}, {3., 3.}}, 0.2], 
        ArrowBox[{{3., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{3., 4.}, {6., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQDQEcDhBawOG369Pl049zODDG8uqYzOF30GPUvOe+
idMhq/61wB01focphqcXCRzgcjBPn7Xu+3w+B4Prp79+/MDtkCEixdrOzufA
9Enr+msXXod/bVkiXbG8DlxNL9z+7eZz+LOv+w7DIh6HJc5Ni0S0BRxi9tTG
vr7C7XCvYX/GNk5BB+V6h+me37gcNv3QLnvyU9DBj/1KpzQbl8OG17+YJicK
OURPXhDv2M/pkHtwekfkJiGHE1bXGH8IcDq8rGRit3gj5DDhb0mBfTeHg5Ko
dZ0ev7DDpts1q8X/sTtITXZ8ZyMt7GB09e2mhkx2hwufRcOTBYQd+F4db6s6
y+bgbL5jx8J3Qg5uUtzqrFpsDmWxGsI/tgo53EndPlmhntVh1kwQEHQwMQYB
ZodXk+1eTrYTdLiiXntJvZbJwbLvsUXfYwGHQpnjQMTo0NUBAgIOQoIgwOhw
o0kXiAQcNrJGb2CNZnAI+LXE/9cSfocFXzznf/H8b//hHQjwOdy7CwJ/7cHG
WfA5yIKMK/xjrwc2gNchZgPIgN/2Z8+AAA/UXT/t0988+npemsfh/I2jr+eb
/7D/lTjR6EMJt8Pnw0qpD15+s28BWX+Dy4EdZP2Gr/Ys/tuftbsC+fPyzvJ3
f7GvPqYX938Pp8PXntg9/yo/20P8x+lwCey/T/Zg5ac4HMDKp3y0X2OgbiWS
wOEQkehXonHggz1q+vlgDwBe4PqP
         "]], 0.2], 
        ArrowBox[{{3., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{3., 1.}, {3., 0.}}, 0.2], 
        ArrowBox[{{2., 3.}, {2., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 3.}, 0.2], InsetBox["1", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["4", {2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["6", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["7", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 3.}, 0.2], 
         InsetBox["8", {-2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["11", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["13", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["14", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 0.}, 0.2], 
         InsetBox["16", {2., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 0.}, 0.2], 
         InsetBox["20", {3., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.2], 
         InsetBox["2", {1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 3.}, 0.2], 
         InsetBox["5", {4., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["12", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.2], 
         InsetBox["17", {3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["18", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{6., 3.}, 0.2], 
         InsetBox["3", {6., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 4.}, 0.2], 
         InsetBox["9", {3., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 1.}, 0.2], 
         InsetBox["19", {3., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["15", {2., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{{3.8515188844797783`*^9, 3.851518899802326*^9}},
 CellLabel->
  "Out[699]=",ExpressionUUID->"47ff1fe0-af5f-4ead-a5da-0ed05b685d07"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g10a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g10", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"8", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"19", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"14", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"16", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"20", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.85151895728157*^9, 3.8515189865616493`*^9}, {
  3.851522500280562*^9, 3.851522598455592*^9}},
 CellLabel->
  "In[705]:=",ExpressionUUID->"d28fb436-84e3-42f1-a2d9-4044faf91f19"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 6, 7, 8, 11, 13, 14, 16, 20, 2, 5, 12, 17, 18, 3, 9, 19, 
      15}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 5, 6, 8, 10, 11, 12, 14, 15, 15, 15, 20, 21, 23, 24, 24, 25, 
          32, 34, 35}, {{3}, {4}, {5}, {6}, {7}, {10}, {2}, {8}, {2}, {8}, {
          1}, {8}, {2}, {8}, {9}, {1}, {12}, {13}, {14}, {15}, {2}, {4}, {
          7}, {7}, {2}, {1}, {12}, {13}, {14}, {15}, {16}, {18}, {9}, {10}, {
          7}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, 
       GraphLayout -> {
        "Dimension" -> 2, 
         "VertexLayout" -> {"LayeredDigraphEmbedding", "Orientation" -> Top}},
        ImageSize -> 600, 
       VertexCoordinates -> {{0, 3.}, {2., 1.}, {0, 2.}, {1., 2.}, {0., 
         4.}, {-1., 2.}, {2., 2.}, {0., 1.}, {1., 1}, {3., 1}, {1., 4.}, {4., 
         3.}, {1., 3.}, {3., 3.}, {-1., 3.}, {4., 2.}, {3., 4.}, {3., 2.}, {
         2., 3.}}, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[{{0., 3.}, {-0.16444074718311652`, 
         3.4999999999999987`}, {0., 4.}}], 0.2], 
        ArrowBox[{{0., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{2., 1.}, {3., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[BezierCurveBox[{{0., 4.}, {0.16444074718311652`, 
         3.4999999999999987`}, {0., 3.}}], 0.2], 
        ArrowBox[{{-1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 1.}, {1., 1.}}, 0.2], 
        ArrowBox[{{1., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {4., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {3., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{4., 3.}, {2., 1.}}, 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{3., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{4., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{3., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{3., 4.}, {4., 3.}}, 0.2], 
        ArrowBox[{{3., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{3., 4.}, {3., 3.}}, 0.2], 
        ArrowBox[{{3., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{3., 4.}, {4., 2.}}, 0.2], 
        ArrowBox[{{3., 4.}, {3., 2.}}, 0.2], 
        ArrowBox[{{3., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{3., 2.}, {3., 1.}}, 0.2], 
        ArrowBox[{{2., 3.}, {2., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 3.}, 0.2], InsetBox["1", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["4", {2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["6", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["7", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 4.}, 0.2], 
         InsetBox["8", {0., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["11", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["13", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["14", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["16", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 1.}, 0.2], 
         InsetBox["20", {3., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.2], 
         InsetBox["2", {1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 3.}, 0.2], 
         InsetBox["5", {4., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["12", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.2], 
         InsetBox["17", {3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["18", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 2.}, 0.2], 
         InsetBox["3", {4., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 4.}, 0.2], 
         InsetBox["9", {3., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.2], 
         InsetBox["19", {3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["15", {2., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{
  3.85151898778156*^9, {3.8515225167090673`*^9, 3.8515225997662687`*^9}},
 CellLabel->
  "Out[705]=",ExpressionUUID->"0cab43d1-11c5-4101-8eba-6cdc0f4816ff"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g11", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{"graph", "[", "11", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851522826800606*^9, 3.85152283335394*^9}},
 CellLabel->
  "In[707]:=",ExpressionUUID->"ab372597-5c2f-4cd8-9463-f44e2e08e1ce"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 5, 12, 16, 17, 6, 13, 14, 7, 15}, {
       SparseArray[
       Automatic, {10, 10}, 0, {
        1, {{0, 2, 2, 3, 3, 5, 6, 7, 8, 9, 10}, {{3}, {5}, {2}, {2}, {4}, {
          8}, {4}, {7}, {7}, {4}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{0., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{1., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{1., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{2., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{3., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{2., 2.}, {3., 1.}}, 0.2], 
        ArrowBox[{{3., 2.}, {3., 1.}}, 0.2], 
        ArrowBox[{{2., 1.}, {2., 0.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 2.}, 0.2], InsetBox["1", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.2], 
         InsetBox["5", {0., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["12", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 0.}, 0.2], 
         InsetBox["16", {2., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["17", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["6", {2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 1.}, 0.2], 
         InsetBox["13", {3., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["14", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.2], 
         InsetBox["7", {3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["15", {2., 1.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{3.8515228344545317`*^9},
 CellLabel->
  "Out[707]=",ExpressionUUID->"e7eb0dbc-4117-4349-b72a-8ba5ddfc70a7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g11a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g11", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"6", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851522854688822*^9, 3.851522873960719*^9}},
 CellLabel->
  "In[708]:=",ExpressionUUID->"8595a656-4667-4b86-b7f9-a9f012205b9e"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 5, 12, 16, 17, 6, 13, 14, 7, 15}, {
       SparseArray[
       Automatic, {10, 10}, 0, {
        1, {{0, 2, 2, 3, 3, 5, 6, 7, 8, 9, 10}, {{3}, {5}, {2}, {2}, {4}, {
          8}, {4}, {7}, {7}, {4}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, GraphLayout -> {"Dimension" -> 2}, ImageSize -> 600, 
       VertexCoordinates -> {{0, 2.}, {0, 0}, {0, 1.}, {2., 0}, {1., 1.}, {1.,
          2.}, {3., 1.}, {2., 2.}, {3., 2.}, {2., 1.}}, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{0., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{1., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{1., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{1., 2.}, {2., 2.}}, 0.2], 
        ArrowBox[{{3., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{2., 2.}, {3., 1.}}, 0.2], 
        ArrowBox[{{3., 2.}, {3., 1.}}, 0.2], 
        ArrowBox[{{2., 1.}, {2., 0.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 2.}, 0.2], InsetBox["1", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.2], 
         InsetBox["5", {0., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["12", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 0.}, 0.2], 
         InsetBox["16", {2., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["17", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["6", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 1.}, 0.2], 
         InsetBox["13", {3., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["14", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.2], 
         InsetBox["7", {3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["15", {2., 1.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{3.8515228751520433`*^9},
 CellLabel->
  "Out[708]=",ExpressionUUID->"8193bec6-4ca5-4f59-8119-0a1937602043"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g12", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{"graph", "[", "12", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851522926776967*^9, 3.851522967338284*^9}},
 CellLabel->
  "In[712]:=",ExpressionUUID->"80295f0c-c48f-4041-9439-10c85afa88e6"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 8, 9, 10, 11, 13, 14, 16, 18, 19, 20, 6, 7, 15, 
      17}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 6, 7, 8, 9, 10, 11, 13, 14, 16, 20, 20, 20, 20, 21, 21, 27, 
          32, 36, 39}, {{2}, {5}, {9}, {10}, {13}, {14}, {8}, {15}, {15}, {
          3}, {15}, {3}, {6}, {7}, {11}, {12}, {3}, {4}, {11}, {12}, {15}, {
          4}, {8}, {11}, {12}, {13}, {14}, {4}, {8}, {9}, {13}, {14}, {3}, {
          4}, {11}, {12}, {5}, {10}, {13}}}, Pattern}], Null}, {
      EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 5.}, {5., 4.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQpEHOKKnwiEvz+5X9L8XqDiGWGHFVXs3E6yd/eL
Prr8vatb2KHs4f3DiRYv9n9lePjRxk7YYe6RZf+793zcv20yq4P5EyGHkKhn
txM1fuyPnuX4qLJWyOHWxnVlm+L/738kMvUGC5eQw6yn/5/bbWQ+4MPMoHyj
U9DB4PKbz4kSHAdmpTYd/PxHwGGDoly801OeA6esZbaEJws4ZGlxt/D18B7Y
lr9pab6ngENVj4SstTzfgWYnndJ76gIO99zdtE7M4zsQmSHs6vGX32FSzJTV
W7n4D2R2To1unM3vMPsU00LmZP4DFi/u6WZo8Tt8nziRa9Ny/gOHWt7v/rOS
z2H5JocXB27wH+CIP85qL8XnsEpHwMrgG/8B3vI0bv1qXgdIuAgcOHsGBHjg
/PQ3j76el0bwfyVONPpQwu3ACOW36N5o0r3BBZdn8d/+rN0Vwa8+phf3fw8n
nP9qst3LyXYIPlj5KQ44f42BupVIAoIPoTkcAMBlph0=
         "]], 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQpEHGbympsuPrTC/snEqTurzgk7yK1fE3zr8C57
Z9+N0z5MEXao2jNT9Ozko/ayRsHTE4OFHTQ+TZ/gceycfb5D9e6znMIOPjUZ
Z9fXXLG3rtBkNt0h5PAkXUmqU+yWfdPN2LzpcUIO7+/aiEdIPLB3SpH4++WP
oIOsjXnrpNTH9jUSket9Jws6VPsxXP/86Zm9wTf51oWKgg4Rk0NF7W++sJ+h
1Dn55H0Bh3MtoT4hba/sKxa7+P+eJeDwSImhxvjXa/szFUE7zIIFHPpzQ5fc
MXlrP3XRpnPVHAIO11JCj/qbvbNf4XhKZWopv8NODob7Pf/e2Qs8v8zmdoXP
wSwy9OPk3vf2KaZNzly6fA5+YaF/Uh6/t1+ic/XWw3peB0i4fLA/ewYEeOD8
9DePvp6XRvB/JU40+lDC7cAI5bfo3mjSvcEFl2fx3/6s3RXBrz6mF/d/Dyec
/2qy3cvJdgg+WPkpDjh/jYG6lUgCgg+hORwAxiCqJQ==
         "]], 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQpEHH5qnenkY12xf2X6m0dfzws73H957c8Gj537
I5bw2NydJewwxe7lZLuXh/fzbEvg3pYg7ABRd3r/4TkvAhoUhR0kK3aZ2utc
2l8H1iDkIJZzEIiu7bcHaZss5HCOv3tK4/Lb+1n8tz9rdxVymLex+7p9/oP9
IFslPgk6GIPB4/2zZoKAoMNWkDXcz/a/Amm3E3Sw6HsMRC/2W4JpAYc9u0Hg
9f6uDhAQcAA7b/K7/TeadIFIwAGsfduH/QG/lvj/WsLvoAQGn/Z/eAcCfA6P
wQZ+3g82zoLPYak/SOGX/XpgA3gd0sDg2/6zZ0CAx8FA3Uok4cT3/WBvS/M4
8AJDRV7s5/5fiRONPpRwO4Ct8f+1vwVk/Q0uB4j4b6h/uRy4ixc5M7b92V99
TC/u/x5OB4g9f6H+43RIAinP/rcfrPwUh8MKcAD9378GbDGHAzSiDkAoDgcA
3t/Y5A==
         "]], 0.2], ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQpEHGCslelvHn09LwznRyzhsbk7C8Hn2ZbAvS0B
wT8850VAgyKCXwfWIATn27+cbPdyMoLP4r/9Wbsrgn+mk49V4pMgnD9rJggI
OizctHIV8+yc/eszpwrxO8D4Pfv9ntrdq3op4FBV8p/fSHzB/kqeaX/uTBWA
yq/Zr3N/Vq6pq4BD/+SQu1KR2/Zf2zUrieM9P1T9gf1ZfNH9kyL5HY68WXlu
3bOj+wV2liVynuKD6j+z/9yutzdyHPgcuJL/B0pIXdo/X/jA1z17eB2OtU/8
esvk5n62874LU27yOCi6tF30P39/f435eVYxNh4HvjPvinZ/ebT/n4+L8kUn
bodbB70lVxx8ur+Lf+3Pqf1cDmXMt27n+r3Yr1zP2ZnyhtPh0YSZu3hmv9p/
YnbkRZtITgeZrK6tLcvf7K9MnXtJ7hqHg3r/mjNXi9/tN79zpYcrmQMaPh/2
Q2gOBwC5t6oJ
         "]], 0.2], ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQpEHH4Wp53In3nZ/tQ7O+09p4UdnlzbXX9O8Zn9
7QNhsd86hR2iXvu8XFj/yd6ozH3aOithh21z0t51G/22P8cneO3JXSGHo/VT
l1+awuSwoWuzzMxiIYfnnGdZy404HG681Ms6/VvQ4eibm4LGRXwObjrN+6rL
BB30Re6lMq8ScvgZuEFy1WMBh4h7OyV/Zos5fIraVh3mLOAw6+qXi0cOiDmI
xjz4q2og4NBVvH/DNG5xh+rs9QJNIgIOGjskt+X5iDu4CLlnXH3A71C4mPmR
T7O4g3BW5YX97fwO6aa1JoYbxB3S7n2NPCzL78CV17ZW+rK4g03+HpYHi/gc
onzlfXneiDtMkTl7QVSczyH8srsw829xh4Jn6vtSqngdIOEi4XD2DAjwOPwH
A3GH9DePvp6X5oHL/0qcaPShhNuBEcpv0b3RpHuDCy7P4r/9Wbsrgl99TC/u
/x5OOP/VZLuXk+0QfLDyUxxw/hoDdSuRBAQfQnM4AAB6DKN3
         "]], 0.2], 
        ArrowBox[{{5., 4.}, {5., 3.}}, 0.2], 
        ArrowBox[{{-2., 1.}, {4., 0.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcDlCGw38wYHdYPm9j93X7//Yw+aSJRh9Ksv/Z
M0L5ejeadG80/YXL8xQvcmZs+wPn/0oEafiN4C/xByGEepu7s+TFfsL5hupW
IgknvsP5aWDwzT571asDauwcDjuWhXrZMHy137xyFfNsGQ4H86m/K14v/Wx/
6a/9iRgHDocHhhGfisM/2Z9atoovp4jDYUNN9rarIh/t5yx5de3EJg6HiNdZ
XYp73tt7fP+vUMzI6bDIMsfWK+2t/Zl5r95kxXE6OD251aqq8dpea/Yqqw0n
OR1MX29L3sz40j7xjT2XszOXQ7Ufw/XPn57Z/zDYFDdbjdtBxsa8dVLqY/vm
Ewa/Xv7kdnh/10Y8QuKBPcvm3Xf09vI4PEtXkuoUu2Vf9iGILauA18GnJuPs
+por9ncbvpXNFuZzUP80fYLHsXP2linL9A4v43Oo3jNT9Ozko/bts5J0H2ry
O8itXxN86/Au+1PK2sVf5/A7zOM1N118aAU0fARg8cUAAB8Srm4=
         "]], 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQECByA0hwOMH3L+xtHX89nh/E0ekhW7TNkdGKF8
8ZyDYjkH2eDybZYXFzI4I/h/N4A0sML5dZfUay+pI/gc8/LO8nezwPkzhWW5
DJ4ww/kmxiDA7NBtWej05Rv/gQlSfuz7m5gcdJ8d4bx4m/9AynMu18q7jA7P
WH+HTlvHf2DLzMw3ic6MDptmCKu75PMfqDHM+luxhcFh2jy+2luy/Af2ruOp
2GfA4DBB/E145C6+Ax+VFu1IKfhvv4B5zfYDLnwHojbnhayc+s/+RJLfHIG9
vAe28dUf9rr4157F9DKrpzLvAQj9117T3D7Eipn7AIT+bW+4QX7uIV7OAxD6
p73kgpIHD53YD0Do7/aP2OzkZixiPQChv9r3PKkOe6rDcgBCf7GXsNTrPPmQ
6QCE/mTfwhK6zeUg4wEI/dH+ktuHu2GnGQ5A6A/20AiDxtcHewDmAKJk
         "]], 0.2], 
        ArrowBox[{{4., 1.}, {4., 0.}}, 0.2], 
        ArrowBox[{{4., 2.}, {-2., 1.}}, 0.2], 
        ArrowBox[{{4., 2.}, {4., 1.}}, 0.2], 
        ArrowBox[{{5., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQUHIBSHA4wfcv7G0dfz2eH8TR6SFbtM2R0YoXzx
nINiOQfZ4PJtlhcXMjgj+H83gDSwwvl1l9RrL6kj+Bzz8s7yd7PA+TOFZbkM
njDD+SbGIIDgXwFpr2WC8wtljgMRI9w9QoIgwAiX38gavYE1mgHOX/DFc/4X
z//2MP69uyDwF86XBRlX+AfOj9kAMuA3nD9rJgj8hPPBwWP+A87/fFgp9cHL
b/Yw97CDrN/wFS7PDvbvFzj/a0/snn+Vn+F8cPDUfoLzwcqnfITzIxL9SjQO
fIDzIdQHewD8y3WQ
         "]], 0.2], ArrowBox[{{-2., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQDQESDhCaw+E/GIg7hJy/cfT1fHYHmPwmD8mKXabs
DoxQvnjOQbGcg2xw+TbLiwsZnBH8vxtAGljh/LpL6rWX1BF8jnl5Z/m7WeD8
mcKyXAZPmOF8E2MQYIa75wpIey0TXL5Q5jgQMcLdIyQIAoxw+Y2s0RtYoxng
/AVfPOd/8fxvD+PfuwsCf+F8WZBxhX/g/JgNIAN+w/lpYPDN/sgcC8Wq3+IO
sqZz+OpYv9qLFz9qefFW3OHEOdGuT7s+239u+qvlfV3cIcP48o3DbZ/sI890
Ci/aLu7wPenKr48ZH+29/dvt3vaJO1THSn6oSfxgf4L722qdWHGHh64uhScf
vLO/wHgtOkFJ3GFL2t0VQdpv7VMM1f067ok5ZMv+a5u66LV906yXTUsmijlw
ZC3jnuT2yn7qbHmtuY2iDkF5dStK2J7ZS97o93vYJuKQmGBv1Sr9yJ43wOpD
wUJhh5SGS43t3Hfti5jl+X0uCjm0Sf+oSOi6Zu/2yXZ1kZiQg/6k95FTN1+w
75GZfuRJgaDDrhOFnj58x+2dmrSiFz0QcLD0CEj1Ftljn6n8I291qoCD9i2O
fbezVkLDR8ABlpIAYO7JuA==
         "]], 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcDhBawOE/GLA7BJ+/cfT1fH4HmPxGD8mKXab8
DoxQvkTOQbGcg3xw+VbLiwsZnBH8PxtAGnjh/LpL6rWX1BF8tnl5Z/m7eeD8
GcKyXAZPuOF8YzDghrvnIkh7LRdcvkjmeKHMcU64e4QFQYATLr+BNRqIOOD8
gF9L/H8tYYfz378DATY4v++xBRAh+Ho3mnRvNLHC+WfAgAXunrQ3j76el2aB
y/9KnGj0oYQZ7p4WXZABTHB5Fv/tz9pdEfyqY3px//cwwvmvJtu9nGyH4IOV
n2KA89cYqFuJJCD40IhzAADBa3Eq
         "]], 0.2], 
        ArrowBox[{{3., 4.}, {5., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcDhBawKH/YIkvy2k2B73XavmMM/kd4jS+hhv7
sTrI7wiUFZTid8gxaZTv7WR2uJDWwKXfzOew86nEEsFaRge775vMoq/wOnRV
VJxuDPxnn5v5cuFUXl4H1YJrJ0wlf9rH7FX2uafH42C7ydvBPvCzPdfnRFNT
C26HNbUbkm0+v7Sv4loSO0uTy2F1+IdSL88b9iuYXx3hZeZ0eP9+VVquwWX7
TXIsapMOcTik7zdtVU86a19euOumYwmHw3vfBuHqaUftP/zmeSAjweHwXCz7
w6rfe+0V9v22UF7HDtW/2Z5jR9uTEDN2qPql9stern20cQMbVH6y/Z+gQmMr
WTaHL2B+sT3nlwvX3lazOsBC6AwYsMD5aW8efT0vjeD/Spxo9KGEGc5v0b3R
pHuDCc5n8d/+rN0Vwa86phf3fw8jnP9qst3LyXYIPlj5KQY4f42BupVIAoIP
BQ4AaCyYHQ==
         "]], 0.2], ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcDhBawCHk/I2jr+ezOwSDaX6HTR6SFbtM2R02
gml+B/Gcg2I5B9kcJMA0n0Ob5cWFDM5sDq1gms/h7waQQlaHP2Ca16Huknrt
JXVWKM3rwDEv7yx/N4sDG5jmcZgpLMtl8ITZYQaY5nYwMQYBZgcwZcztcAWk
rZbJ4SKY5nIolDkORIwORWCa00FIEAQYHYTBNKfDRtboDazRDA4bwDSHw4Iv
nvO/eP63D/i1xP/XEnaHe3dB4K/9+3cgwOYgCzKm8I9932MLIGJziAFr/G2v
d6NJ90YTq8OsmSDw0/4MGLA4gIPF/Id92ptHX89Lszh8PqyU+uDlN/tfiRON
PpQwO7CDrN3w1b5FF2QAkwM72J9f7Fn8tz9rd2Vy+NoTu+df5Wf7qmN6cf/3
MDqAg6X2k/2ryXYvJ9sxOoCVT/loD1Z+isEhItGvROPAB/s1BupWIgkM0Hj6
YA+NOAcAE1u2Hw==
         "]], 0.2], ArrowBox[{{3., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{3., 4.}, {6., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQECDuh08PkbR1/P54fzN3pIVuwy5XdghPIlcg6K
5Rzkg8u3Wl5cyOCM4P/ZANLAC+fXXVKvvaSO4LPNyzvL380D588QluUyeMIN
5xuDAbfD5FBR+5s/+B1iLmupyjVwOfiFhf5JeczvMOdU7Z6vlzgdDJgOmC/e
z+/wSULn505tTgezyNCPk3v5HSL2md7O6uJwSIkW1TT35Xe4tmtWEsd7docd
HAz3e/7xOWTyRfdPimR3MEkUFZ66kM9BYGdZIucpNodrKaFH/c34HM7sensj
x4HNYb7wga979vA6zAPTrA5s530XptzkgdIsDjXm51nF2HigNIvDPx8X5YtO
3A5/wTSzQxf/2p9T+7mgNJODcj1nZ8obTgclMM3ocGJ25EWbSE4ozehQmTr3
ktw1DijN4GB+50oPVzIHlGaAhg8HlGZwAAC4y4ya
         "]], 0.2], 
        ArrowBox[{{4., 4.}, {5., 3.}}, 0.2], 
        ArrowBox[{{4., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{4., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{4., 4.}, {6., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEcB6C0w38wYD8Qcv7G0dfz2R1g8ps8JCt2mbI7
MEL54jkHxXIOssHl2ywvLmRwRvD/bgBpYIXz6y6p115SR/A55uWd5e9mgfNn
CstyGTxhhvNNjEGA2WFSqKj9zR/sB+Iua6nKNTA5+IWF/kl5zH5g9qnaPV8v
MTroMx0wX7yf/cAHCZ2fO7UZHUwjQz9O7mU/ELHP9HZWF4NDcrSoprkv+4E1
paZHBe79t9/BwXC/5x/bgUsy2+RUN/+zN0kUFZ66kO2AUtHbQ0JT/tpfTQk9
6m/GdmB26e2NNxv+2M8TPvB1zx7WA3bqDa8rK3/bs533XZhyk+UA37zZTic3
/bSvMT/PKsbGcuBn3jxuHZ4f9n99XJQvOjEf+D2zw21R6zf7Lv61P6f2Mx0Q
lo/6rC3/1V6pnrMz5Q3jAdd/QkInb3y2PzE78qJNJOOBCeabF1Vu+mRfmTr3
ktw1hgOfTlkttV3z0d78zpUermSGA7k7VkqKHvtgD40waHx9sAcADOWsWA==

         "]], 0.2], ArrowBox[{{-3., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[{{-3., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{-3., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {-4., 3.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {-2., 3.}}, 0.2], 
        ArrowBox[{{-2., 4.}, {-1., 3.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 5.}, 0.2], InsetBox["1", {0., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 4.}, 0.2], 
         InsetBox["2", {5., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 1.}, 0.2], 
         InsetBox["3", {-2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.2], 
         InsetBox["4", {3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-4., 3.}, 0.2], 
         InsetBox["5", {-4., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 1.}, 0.2], 
         InsetBox["8", {4., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 2.}, 0.2], 
         InsetBox["9", {4., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 3.}, 0.2], 
         InsetBox["10", {5., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["11", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 3.}, 0.2], 
         InsetBox["13", {-2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["14", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["16", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["18", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{6., 3.}, 0.2], 
         InsetBox["19", {6., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 0.}, 0.2], 
         InsetBox["20", {4., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 4.}, 0.2], 
         InsetBox["6", {3., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 4.}, 0.2], 
         InsetBox["7", {4., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 3.}, 0.2], 
         InsetBox["15", {-3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 4.}, 0.2], 
         InsetBox["17", {-2., 4.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{{3.851522931088456*^9, 3.8515229685170097`*^9}},
 CellLabel->
  "Out[712]=",ExpressionUUID->"4d91668e-bf9b-4ca2-9189-8b21a11b9be9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g12a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g12", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"20", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "0"}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{"13", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"20", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"17", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"19", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "}"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.851522981208987*^9, 3.851523059233323*^9}, {
  3.851523120250638*^9, 3.8515232152177896`*^9}, {3.85152327293117*^9, 
  3.851523325819663*^9}, {3.85152337578756*^9, 3.851523435722538*^9}, {
  3.851523498132104*^9, 3.851523541132284*^9}, {3.851523610100429*^9, 
  3.851523660659562*^9}},
 CellLabel->
  "In[731]:=",ExpressionUUID->"bc92e87f-1453-4767-be06-72bd987c7c41"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 8, 9, 10, 11, 13, 14, 16, 18, 19, 20, 6, 7, 15, 
      17}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 6, 7, 8, 9, 10, 11, 13, 14, 16, 20, 20, 20, 20, 21, 21, 27, 
          32, 36, 39}, {{2}, {5}, {9}, {10}, {13}, {14}, {8}, {15}, {15}, {
          3}, {15}, {3}, {6}, {7}, {11}, {12}, {3}, {4}, {11}, {12}, {15}, {
          4}, {8}, {11}, {12}, {13}, {14}, {4}, {8}, {9}, {13}, {14}, {3}, {
          4}, {11}, {12}, {5}, {10}, {13}}}, Pattern}], Null}, {
      EdgeStyle -> {
         GrayLevel[0]}, GraphLayout -> {"Dimension" -> 2}, ImageSize -> 600, 
       VertexCoordinates -> {{1, 4.}, {4., 3.}, {1., 1.}, {2., 2.}, {-1., 
         2.}, {4., 1.}, {4., 2.}, {3., 3.}, {1., 3.}, {0., 1.}, {0, 2.}, {1., 
         2.}, {-1., 3.}, {3., 2.}, {2., 1}, {2., 4.}, {4., 4.}, {-1., 
         1.}, {-1., 4.}}, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{1., 4.}, {4., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{1., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {0., 1.}}, 0.2], 
        ArrowBox[{{1., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {3., 2.}}, 0.2], 
        ArrowBox[{{4., 3.}, {3., 3.}}, 0.2], 
        ArrowBox[{{1., 1.}, {2., 1.}}, 0.2], 
        ArrowBox[{{2., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{4., 1.}, {2., 1.}}, 0.2], 
        ArrowBox[{{4., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{4., 2.}, {4., 1.}}, 0.2], 
        ArrowBox[{{3., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{0., 1.}, {1., 1.}}, 0.2], 
        ArrowBox[{{0., 1.}, {2., 2.}}, 0.2], 
        ArrowBox[{{0., 1.}, {0., 2.}}, 0.2], 
        ArrowBox[{{0., 1.}, {1., 2.}}, 0.2], 
        ArrowBox[{{3., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{2., 4.}, {2., 2.}}, 0.2], 
        ArrowBox[{{2., 4.}, {3., 3.}}, 0.2], 
        ArrowBox[{{2., 4.}, {0., 2.}}, 0.2], 
        ArrowBox[{{2., 4.}, {1., 2.}}, 0.2], 
        ArrowBox[{{2., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{2., 4.}, {3., 2.}}, 0.2], 
        ArrowBox[{{4., 4.}, {2., 2.}}, 0.2], 
        ArrowBox[{{4., 4.}, {3., 3.}}, 0.2], 
        ArrowBox[{{4., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{4., 4.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{4., 4.}, {3., 2.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {1., 1.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {2., 2.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {0., 2.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {1., 2.}}, 0.2], 
        ArrowBox[{{-1., 4.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{-1., 4.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-1., 4.}, {-1., 3.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{1., 4.}, 0.2], InsetBox["1", {1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 3.}, 0.2], 
         InsetBox["2", {4., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["3", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["4", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["5", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 1.}, 0.2], 
         InsetBox["8", {4., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 2.}, 0.2], 
         InsetBox["9", {4., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.2], 
         InsetBox["10", {3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["11", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["13", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["14", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["16", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["18", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.2], 
         InsetBox["19", {3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["20", {2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 4.}, 0.2], 
         InsetBox["6", {2., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 4.}, 0.2], 
         InsetBox["7", {4., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["15", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 4.}, 0.2], 
         InsetBox["17", {-1., 4.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{{3.851523388015316*^9, 3.851523436777505*^9}, {
   3.851523498755329*^9, 3.85152354169096*^9}, 3.85152363101943*^9, 
   3.851523661553636*^9},
 CellLabel->
  "Out[731]=",ExpressionUUID->"46ce6029-744a-49b9-a178-620f04a74b37"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g13", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"graph", "[", "13", "]"}], ",", 
    RowBox[{"GraphLayout", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<LayeredDigraphEmbedding\>\"", ",", 
       RowBox[{"\"\<Orientation\>\"", "\[Rule]", "Left"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8515239639249563`*^9, 3.851523966652587*^9}, {
  3.851524021585884*^9, 3.8515240300528812`*^9}},
 CellLabel->
  "In[734]:=",ExpressionUUID->"0dc0dd90-e782-4056-8127-560c813bfa62"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 8, 9, 10, 11, 14, 15, 18, 20, 5, 6, 7, 12, 17, 19}, {
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 5, 6, 7, 8, 9, 11, 12, 13, 13, 15, 15, 15, 16, 21, 23, 25, 28,
           29}, {{2}, {4}, {8}, {10}, {11}, {7}, {12}, {12}, {12}, {3}, {5}, {
          6}, {9}, {3}, {9}, {3}, {2}, {4}, {8}, {10}, {11}, {1}, {16}, {2}, {
          11}, {2}, {10}, {11}, {3}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, 
       GraphLayout -> {
        "Dimension" -> 2, 
         "VertexLayout" -> {
          "LayeredDigraphEmbedding", "Orientation" -> Left}}, ImageSize -> 
       600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{-4.999999999999998, 
         1.339744851455892*^-7}, {-3.9999999196153078`, 3.0000001071795874`}},
          0.19999999999999998`], 
        ArrowBox[{{-4.999999999999998, 
         1.339744851455892*^-7}, {-3.9999999999999987`, 
         1.0717958811647137`*^-7}}, 0.19999999999999998`], 
        ArrowBox[{{-4.999999999999998, 
         1.339744851455892*^-7}, {-4.000000026794896, -0.9999998928204116}}, 
         0.19999999999999998`], 
        ArrowBox[{{-4.999999999999998, 
         1.339744851455892*^-7}, {-3.9999999732051017`, 1.0000001071795879`}},
          0.19999999999999998`], 
        ArrowBox[{{-4.999999999999998, 
         1.339744851455892*^-7}, {-3.9999999464102047`, 2.0000001071795874`}},
          0.19999999999999998`], 
        ArrowBox[{{-3.9999999196153078`, 
         3.0000001071795874`}, {-2.999999919615308, 3.00000008038469}}, 
         0.19999999999999998`], 
        ArrowBox[{{-1.0000000267948967`, -0.9999999732051026}, {0., 0.}}, 
         0.19999999999999998`], ArrowBox[BezierCurveBox[CompressedData["
1:eJxdkn0sFGAcx+/UXd6PGaKsoe5ac96at6v9VJqYLpPNS7fpHJUadwwdjj+I
NowadXoR3RKFudNk69ieR1Erx3Uqbl6qOSxTCCWH6Z7LX332e/b89fvu83ue
n6tAdPaCCYVC8TQccm9uERhYIHA+Ht2XD1Fqbd9cPQMnsZSOP4X5IA9zylH6
MbA7dWqfmJEP9qk9Dqk91vjhQk38dKMErgVpZJQQa6xd+tR7xE8CegVpsMKD
5nWJeco8kAyxCoZYVrgoYNFL5p8HO+uEA4xyS7yYo/JSPM0FqZ2LufeUBXZR
+yY22eWCz2GCBaZz3HuvZ+WAmrQXmGOuXBs8+l4MGXvfGMoMS/dXdrHZYrCx
JZjhL3dDAgpLr0Ibjaeg8Uwxk7H27ON0NpzRN0TqG3ZhYXGb58ET2TBvhI47
15KaJXVZUKELrNQF0vGm0Imp1mcCW1tkKBoOnRqUucVmgq/RZwcWysaXfUIy
QGP0McHPHapEJfXpkG70oWK9443h9lXRtg8VV5joB+IUQpAbfSh4z4/kvq2U
NKhdCa9fCd9CzSPq7kbXVBibIGwizktOB3f0CjiTuIwN9Lb1cctK1WWIV5CA
dRRfY/PofkQKJF8k/EYtth6nlO7JIIskA64gzoYUEscFMEnGqVxG72ao/qa3
E8HNyBI6p0lly7l8OG/RybfoXEQfxPLwVssE4MxWw2z1PFo6XRKoL+CBsosw
h2zceKywhTjwJ3G6b8h71dtByo+BDj4JmEGRKjptShO9/V869O99oqC2vXwk
WPQVHbh3dCuhggv9jPJbhU1jqCxCVLZ7Imx7f4aRaWxU6c3sk+Bo2K5gjyH0
oHty/XXMMWi69H3yl7ofSf+E9oqpQVAFRPAVYnmwcj7P+MD47PCGIuwFGmSp
mMVdTFg/pCq1pj1Bacg6ruyOPVD+4y9YG13A
         "]], 0.19999999999999998`], 
        ArrowBox[{{-0.9999999464102056, 2.0000000267948965`}, {0., 0.}}, 
         0.19999999999999998`], 
        ArrowBox[{{-1.9999999464102052`, 
         2.0000000535897935`}, {-1.0000000267948967`, -0.9999999732051026}}, 
         0.19999999999999998`], 
        ArrowBox[{{-1.9999999464102052`, 
         2.0000000535897935`}, {-0.9999999464102056, 2.0000000267948965`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-2.999999919615308, 
         3.00000008038469}, {-1.9999999464102052`, 2.0000000535897935`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-4.000000026794896, -0.9999998928204116}, \
{-3.000000026794896, -0.9999999196153085}}, 0.19999999999999998`], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQPTU0/c////wHHIKPyjAwfLB/oeJw6PV8/gNiH/PA
fNd5DSW7TPkPyJfzg/lrD2oI5xzkOxD5dJk0iC/VbzGPwZnvwBFrUzB/EtsG
0YpdvAcSqnZJgfjCGv2Vl9R5D+gvNAPzZ3++epK/m+eA3oaVkiC+bmYLm8ET
7gMJy4XB/BMds/SNjbkPHG4rkQDx02ufnFOv5Tpgd+uCOIjPUaSXJ3Oc88Au
XV0wf0VaBa+gIOcBs8ZOMRDfLfrQGtZojgMbrzwVBfGf+fP4/FrCfkBXwwnM
b3MJe/3uHduBldXzREB8VcsFXY8t2A6onv8lDOIf1X2leaOJ9cACpXAw/xTY
PcwHPhk6C4L4Oo07mfc3MR2Y/o9X++Lt9/ZijU2OlXcZDxxsMHZ3yX9v39Hx
9UWiM+OBtFffyiJ3vbNvmC70q2ILw4E664hdAnvf2v9fe7NknwHDAb6ScMGs
8jf23DOmbkop+L9fYsqX6tSXr+zVHp/2Wzn13/5ps/V/MQm/tPe3DdvndfHv
/t4ujh6nL8/sW5eZMHoq/93/O6HeUKX3iX3Ghc5AK+bf+1c191y6JHnDvkhN
d84h3p/79ymL6mjdOWC/cIXcw4dO3/ev85XxOrx4+/4vYXEKMxZ93W+Ro/Hc
7vWl/XmGbyKf6nzZ31ZxU/3qjHv7+SxO9J58+Gm/hozvqZsVT/Zfzvq02+Xg
x/3nQ7eKvf31Yv++k1lPwk5/2G+WqVq55NKb/edDDNmB4bI/Jmzux///3+8H
AIFYFjc=
         "]], 0.19999999999999998`], 
        ArrowBox[{{-3.9999999732051017`, 
         1.0000001071795879`}, {-3.000000026794896, -0.9999999196153085}}, 
         0.19999999999999998`], 
        ArrowBox[{{-2.0000000535897935`, -1.9999999464102052`}, \
{-1.0000000267948967`, -0.9999999732051026}}, 0.19999999999999998`], 
        ArrowBox[{{-4.999999973205101, 
         1.0000001339744848`}, {-3.9999999196153078`, 3.0000001071795874`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-4.999999973205101, 
         1.0000001339744848`}, {-3.9999999999999987`, 
         1.0717958811647137`*^-7}}, 0.19999999999999998`], 
        ArrowBox[{{-4.999999973205101, 
         1.0000001339744848`}, {-4.000000026794896, -0.9999998928204116}}, 
         0.19999999999999998`], 
        ArrowBox[{{-4.999999973205101, 
         1.0000001339744848`}, {-3.9999999732051017`, 1.0000001071795879`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-4.999999973205101, 
         1.0000001339744848`}, {-3.9999999464102047`, 2.0000001071795874`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-5.999999919615307, 
         3.0000001607693814`}, {-4.999999999999998, 1.339744851455892*^-7}}, 
         0.19999999999999998`], 
        ArrowBox[{{-5.999999919615307, 
         3.0000001607693814`}, {-4.999999919615307, 3.0000001339744844`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-4.999999919615307, 
         3.0000001339744844`}, {-3.9999999196153078`, 3.0000001071795874`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-4.999999919615307, 
         3.0000001339744844`}, {-3.9999999464102047`, 2.0000001071795874`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-4.999999946410204, 
         2.0000001339744844`}, {-3.9999999196153078`, 3.0000001071795874`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-4.999999946410204, 
         2.0000001339744844`}, {-3.9999999732051017`, 1.0000001071795879`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-4.999999946410204, 
         2.0000001339744844`}, {-3.9999999464102047`, 2.0000001071795874`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-2.0000000267948965`, -0.9999999464102056}, \
{-1.0000000267948967`, -0.9999999732051026}}, 0.19999999999999998`]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {
         DiskBox[{-4.999999999999998, 1.339744851455892*^-7}, 
          0.19999999999999998], 
         InsetBox["1", {-4.999999999999998, 1.339744851455892*^-7},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999196153078, 3.0000001071795874}, 
          0.19999999999999998], 
         InsetBox["2", {-3.9999999196153078, 3.0000001071795874},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.0000000267948967, -0.9999999732051026}, 
          0.19999999999999998], 
         InsetBox["3", {-1.0000000267948967, -0.9999999732051026},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999999999987, 1.0717958811647137*^-7}, 
          0.19999999999999998], 
         InsetBox["4", {-3.9999999999999987, 1.0717958811647137*^-7},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999464102056, 2.0000000267948965}, 
          0.19999999999999998], 
         InsetBox["8", {-0.9999999464102056, 2.0000000267948965},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999464102052, 2.0000000535897935}, 
          0.19999999999999998], 
         InsetBox["9", {-1.9999999464102052, 2.0000000535897935},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.999999919615308, 3.00000008038469}, 0.19999999999999998],
          InsetBox["10", {-2.999999919615308, 3.00000008038469},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.000000026794896, -0.9999998928204116}, 
          0.19999999999999998], 
         InsetBox["11", {-4.000000026794896, -0.9999998928204116},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.000000026794896, -0.9999999196153085}, 
          0.19999999999999998], 
         InsetBox["14", {-3.000000026794896, -0.9999999196153085},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999732051017, 1.0000001071795879}, 
          0.19999999999999998], 
         InsetBox["15", {-3.9999999732051017, 1.0000001071795879},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999464102047, 2.0000001071795874}, 
          0.19999999999999998], 
         InsetBox["18", {-3.9999999464102047, 2.0000001071795874},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.19999999999999998], 
         InsetBox["20", {0., 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.0000000535897935, -1.9999999464102052}, 
          0.19999999999999998], 
         InsetBox["5", {-2.0000000535897935, -1.9999999464102052},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999973205101, 1.0000001339744848}, 
          0.19999999999999998], 
         InsetBox["6", {-4.999999973205101, 1.0000001339744848},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-5.999999919615307, 3.0000001607693814}, 
          0.19999999999999998], 
         InsetBox["7", {-5.999999919615307, 3.0000001607693814},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999919615307, 3.0000001339744844}, 
          0.19999999999999998], 
         InsetBox["12", {-4.999999919615307, 3.0000001339744844},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999946410204, 2.0000001339744844}, 
          0.19999999999999998], 
         InsetBox["17", {-4.999999946410204, 2.0000001339744844},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.0000000267948965, -0.9999999464102056}, 
          0.19999999999999998], 
         InsetBox["19", {-2.0000000267948965, -0.9999999464102056},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{3.85152396988132*^9, 3.851524031100319*^9},
 CellLabel->
  "Out[734]=",ExpressionUUID->"dbb2b02b-4fd9-4d8e-a9af-347dbe55ad95"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g13a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g13", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"9", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"19", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8515241545579*^9, 3.85152418618148*^9}, {
  3.851524228006966*^9, 3.851524364806238*^9}, {3.85152442036742*^9, 
  3.8515244278065653`*^9}},
 CellLabel->
  "In[742]:=",ExpressionUUID->"829dd464-68f8-4602-8cf2-5313c4572041"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 8, 9, 10, 11, 14, 15, 18, 20, 5, 6, 7, 12, 17, 19}, {
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 5, 6, 7, 8, 9, 11, 12, 13, 13, 15, 15, 15, 16, 21, 23, 25, 28,
           29}, {{2}, {4}, {8}, {10}, {11}, {7}, {12}, {12}, {12}, {3}, {5}, {
          6}, {9}, {3}, {9}, {3}, {2}, {4}, {8}, {10}, {11}, {1}, {16}, {2}, {
          11}, {2}, {10}, {11}, {3}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, 
       GraphLayout -> {
        "Dimension" -> 2, 
         "VertexLayout" -> {
          "LayeredDigraphEmbedding", "Orientation" -> Left}}, ImageSize -> 
       600, VertexCoordinates -> {{-4.999999999999998, 
          0}, {-3.9999999196153078`, 
         3.0000001071795874`}, {-3.000000026794897, 
         1.0000000267948974`}, {-3.9999999999999987`, 
          0}, {-1.9999999464102056`, 
         2.0000000267948965`}, {-2.999999946410205, 
         2.0000000535897935`}, {-2.999999919615308, 
         3.00000008038469}, {-4.000000026794896, -0.9999998928204116}, \
{-3.000000026794896, -0.9999999196153085}, {-3.9999999732051017`, 
         1.0000001071795879`}, {-3.9999999464102047`, 
         2.0000001071795874`}, {-2, 1}, {-2.0000000535897935`, 
         5.358979482394943*^-8}, {-4.999999973205101, 
         1.0000001339744848`}, {-5.999999919615307, 
         3.0000001607693814`}, {-4.999999919615307, 
         3.0000001339744844`}, {-4.999999946410204, 
         2.0000001339744844`}, {-3.0000000267948965`, 5.358979437986022*^-8}},
        VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{-4.999999999999998, 0.}, {-3.9999999196153078`, 
         3.0000001071795874`}}, 0.1999999785640824], 
        ArrowBox[{{-4.999999999999998, 0.}, {-3.9999999999999987`, 0.}}, 
         0.1999999785640824], 
        ArrowBox[{{-4.999999999999998, 
         0.}, {-4.000000026794896, -0.9999998928204116}}, 0.1999999785640824],
         ArrowBox[{{-4.999999999999998, 0.}, {-3.9999999732051017`, 
         1.0000001071795879`}}, 0.1999999785640824], 
        ArrowBox[{{-4.999999999999998, 0.}, {-3.9999999464102047`, 
         2.0000001071795874`}}, 0.1999999785640824], 
        ArrowBox[{{-3.9999999196153078`, 
         3.0000001071795874`}, {-2.999999919615308, 3.00000008038469}}, 
         0.1999999785640824], 
        ArrowBox[{{-3.000000026794897, 1.0000000267948974`}, {-2., 1.}}, 
         0.1999999785640824], 
        ArrowBox[{{-3.9999999999999987`, 0.}, {-2., 1.}}, 0.1999999785640824],
         ArrowBox[{{-1.9999999464102056`, 2.0000000267948965`}, {-2., 1.}}, 
         0.1999999785640824], 
        ArrowBox[{{-2.999999946410205, 
         2.0000000535897935`}, {-3.000000026794897, 1.0000000267948974`}}, 
         0.1999999785640824], 
        ArrowBox[{{-2.999999946410205, 
         2.0000000535897935`}, {-1.9999999464102056`, 2.0000000267948965`}}, 
         0.1999999785640824], 
        ArrowBox[{{-2.999999919615308, 3.00000008038469}, {-2.999999946410205,
          2.0000000535897935`}}, 0.1999999785640824], 
        ArrowBox[{{-4.000000026794896, -0.9999998928204116}, \
{-3.000000026794896, -0.9999999196153085}}, 0.1999999785640824], 
        ArrowBox[{{-3.9999999732051017`, 
         1.0000001071795879`}, {-3.000000026794897, 1.0000000267948974`}}, 
         0.1999999785640824], 
        ArrowBox[{{-3.9999999732051017`, 
         1.0000001071795879`}, {-3.000000026794896, -0.9999999196153085}}, 
         0.1999999785640824], 
        ArrowBox[{{-2.0000000535897935`, 
         5.358979482394943*^-8}, {-3.000000026794897, 1.0000000267948974`}}, 
         0.1999999785640824], 
        ArrowBox[{{-4.999999973205101, 
         1.0000001339744848`}, {-3.9999999196153078`, 3.0000001071795874`}}, 
         0.1999999785640824], 
        ArrowBox[{{-4.999999973205101, 
         1.0000001339744848`}, {-3.9999999999999987`, 0.}}, 
         0.1999999785640824], 
        ArrowBox[{{-4.999999973205101, 
         1.0000001339744848`}, {-4.000000026794896, -0.9999998928204116}}, 
         0.1999999785640824], 
        ArrowBox[{{-4.999999973205101, 
         1.0000001339744848`}, {-3.9999999732051017`, 1.0000001071795879`}}, 
         0.1999999785640824], 
        ArrowBox[{{-4.999999973205101, 
         1.0000001339744848`}, {-3.9999999464102047`, 2.0000001071795874`}}, 
         0.1999999785640824], 
        ArrowBox[{{-5.999999919615307, 
         3.0000001607693814`}, {-4.999999999999998, 0.}}, 0.1999999785640824],
         ArrowBox[{{-5.999999919615307, 
         3.0000001607693814`}, {-4.999999919615307, 3.0000001339744844`}}, 
         0.1999999785640824], 
        ArrowBox[{{-4.999999919615307, 
         3.0000001339744844`}, {-3.9999999196153078`, 3.0000001071795874`}}, 
         0.1999999785640824], 
        ArrowBox[{{-4.999999919615307, 
         3.0000001339744844`}, {-3.9999999464102047`, 2.0000001071795874`}}, 
         0.1999999785640824], 
        ArrowBox[{{-4.999999946410204, 
         2.0000001339744844`}, {-3.9999999196153078`, 3.0000001071795874`}}, 
         0.1999999785640824], 
        ArrowBox[{{-4.999999946410204, 
         2.0000001339744844`}, {-3.9999999732051017`, 1.0000001071795879`}}, 
         0.1999999785640824], 
        ArrowBox[{{-4.999999946410204, 
         2.0000001339744844`}, {-3.9999999464102047`, 2.0000001071795874`}}, 
         0.1999999785640824], 
        ArrowBox[{{-3.0000000267948965`, 
         5.358979437986022*^-8}, {-3.000000026794897, 1.0000000267948974`}}, 
         0.1999999785640824]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{-4.999999999999998, 0.}, 0.1999999785640824], 
         InsetBox["1", {-4.999999999999998, 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999196153078, 3.0000001071795874}, 
          0.1999999785640824], 
         InsetBox["2", {-3.9999999196153078, 3.0000001071795874},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.000000026794897, 1.0000000267948974}, 
          0.1999999785640824], 
         InsetBox["3", {-3.000000026794897, 1.0000000267948974},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999999999987, 0.}, 0.1999999785640824], 
         InsetBox["4", {-3.9999999999999987, 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999464102056, 2.0000000267948965}, 
          0.1999999785640824], 
         InsetBox["8", {-1.9999999464102056, 2.0000000267948965},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.999999946410205, 2.0000000535897935}, 
          0.1999999785640824], 
         InsetBox["9", {-2.999999946410205, 2.0000000535897935},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.999999919615308, 3.00000008038469}, 0.1999999785640824], 
         InsetBox["10", {-2.999999919615308, 3.00000008038469},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.000000026794896, -0.9999998928204116}, 
          0.1999999785640824], 
         InsetBox["11", {-4.000000026794896, -0.9999998928204116},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.000000026794896, -0.9999999196153085}, 
          0.1999999785640824], 
         InsetBox["14", {-3.000000026794896, -0.9999999196153085},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999732051017, 1.0000001071795879}, 
          0.1999999785640824], 
         InsetBox["15", {-3.9999999732051017, 1.0000001071795879},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999464102047, 2.0000001071795874}, 
          0.1999999785640824], 
         InsetBox["18", {-3.9999999464102047, 2.0000001071795874},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 1.}, 0.1999999785640824], 
         InsetBox["20", {-2., 1.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.0000000535897935, 5.358979482394943*^-8}, 
          0.1999999785640824], 
         InsetBox["5", {-2.0000000535897935, 5.358979482394943*^-8},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999973205101, 1.0000001339744848}, 
          0.1999999785640824], 
         InsetBox["6", {-4.999999973205101, 1.0000001339744848},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-5.999999919615307, 3.0000001607693814}, 
          0.1999999785640824], 
         InsetBox["7", {-5.999999919615307, 3.0000001607693814},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999919615307, 3.0000001339744844}, 
          0.1999999785640824], 
         InsetBox["12", {-4.999999919615307, 3.0000001339744844},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999946410204, 2.0000001339744844}, 
          0.1999999785640824], 
         InsetBox["17", {-4.999999946410204, 2.0000001339744844},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.0000000267948965, 5.358979437986022*^-8}, 
          0.1999999785640824], 
         InsetBox["19", {-3.0000000267948965, 5.358979437986022*^-8},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{
  3.851524187871683*^9, {3.8515242399477577`*^9, 3.8515242868011913`*^9}, {
   3.851524318881535*^9, 3.851524333118671*^9}, 3.851524366506616*^9, 
   3.85152442870662*^9},
 CellLabel->
  "Out[742]=",ExpressionUUID->"148e6193-7618-402a-b405-0dc000d50419"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g14", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{"graph", "[", "14", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851524493559087*^9, 3.851524500152379*^9}},
 CellLabel->
  "In[744]:=",ExpressionUUID->"f6719683-9884-4672-bd0d-789e56441844"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 5, 12, 17, 6, 7, 13, 16, 11, 2, 4, 8, 9, 10, 19, 15}, {
       SparseArray[
       Automatic, {16, 16}, 0, {
        1, {{0, 2, 2, 3, 4, 5, 6, 7, 7, 15, 15, 15, 15, 15, 15, 15, 16}, {{
          3}, {4}, {2}, {2}, {6}, {7}, {8}, {1}, {6}, {10}, {11}, {12}, {
          13}, {14}, {15}, {10}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{0., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{1., 1.}, {1., 0.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-6., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-5., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-4., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-3., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{-6., 3.}, {-6., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 2.}, 0.2], InsetBox["1", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 0.}, 0.2], 
         InsetBox["5", {-1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["12", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["17", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["6", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["7", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["13", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 0.}, 0.2], 
         InsetBox["16", {1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 3.}, 0.2], 
         InsetBox["11", {-2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-6., 2.}, 0.2], 
         InsetBox["2", {-6., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-5., 2.}, 0.2], 
         InsetBox["4", {-5., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-4., 2.}, 0.2], 
         InsetBox["8", {-4., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 2.}, 0.2], 
         InsetBox["9", {-3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["10", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["19", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-6., 3.}, 0.2], 
         InsetBox["15", {-6., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{3.851524500904478*^9},
 CellLabel->
  "Out[744]=",ExpressionUUID->"ea94c162-5795-49f4-87a7-bd7376c42f47"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g14a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g14", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851524612399439*^9, 3.8515246382230577`*^9}, {
  3.851524679312701*^9, 3.851524762799529*^9}},
 CellLabel->
  "In[748]:=",ExpressionUUID->"30b415fc-4aa7-48b3-a111-bc5b48982a90"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 5, 12, 17, 6, 7, 13, 16, 11, 2, 4, 8, 9, 10, 19, 15}, {
       SparseArray[
       Automatic, {16, 16}, 0, {
        1, {{0, 2, 2, 3, 4, 5, 6, 7, 7, 15, 15, 15, 15, 15, 15, 15, 16}, {{
          3}, {4}, {2}, {2}, {6}, {7}, {8}, {1}, {6}, {10}, {11}, {12}, {
          13}, {14}, {15}, {10}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, GraphLayout -> {"Dimension" -> 2}, ImageSize -> 600, 
       VertexCoordinates -> {{0, 2.}, {-1., 0}, {-1., 1.}, {0, 1.}, {1., 
         3.}, {1., 2.}, {1., 1.}, {1., 0}, {-2., 3.}, {-3., 1.}, {-3., 
         3.}, {-1., 3.}, {-3., 2.}, {-2., 2.}, {-1., 2.}, {-2., 1.}}, 
       VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{0., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{1., 1.}, {1., 0.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-3., 1.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-3., 3.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-3., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-2., 2.}}, 0.2], 
        ArrowBox[{{-2., 3.}, {-1., 2.}}, 0.2], 
        ArrowBox[{{-2., 1.}, {-3., 1.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 2.}, 0.2], InsetBox["1", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 0.}, 0.2], 
         InsetBox["5", {-1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["12", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["17", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["6", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["7", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["13", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 0.}, 0.2], 
         InsetBox["16", {1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 3.}, 0.2], 
         InsetBox["11", {-2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 1.}, 0.2], 
         InsetBox["2", {-3., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 3.}, 0.2], 
         InsetBox["4", {-3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.2], 
         InsetBox["8", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 2.}, 0.2], 
         InsetBox["9", {-3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["10", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["19", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 1.}, 0.2], 
         InsetBox["15", {-2., 1.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{3.851524639279994*^9, 3.8515246898090487`*^9, 
  3.851524724548324*^9, 3.8515247638747253`*^9},
 CellLabel->
  "Out[748]=",ExpressionUUID->"39264bb6-ebc7-41ea-a1f1-5f22dcf103ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g15", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{"graph", "[", "15", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8515248183122673`*^9, 3.85152482111989*^9}},
 CellLabel->
  "In[750]:=",ExpressionUUID->"3cf69406-a80e-47f2-aee2-187938e5fbe4"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 3, 4, 7, 13, 16, 19, 20, 2, 5, 6, 8, 9, 10, 11, 12, 14, 17}, {
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 3, 4, 5, 8, 10, 10, 11, 11, 12, 13, 17, 18, 19, 20, 21, 24, 
          25, 27}, {{2}, {4}, {5}, {8}, {8}, {3}, {6}, {7}, {3}, {6}, {8}, {
          2}, {2}, {2}, {3}, {6}, {7}, {8}, {2}, {2}, {6}, {2}, {5}, {7}, {
          6}, {2}, {5}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQo4HOKKnwiEvz+53yhvz2KnGewOK6rYuZ1k7+7X
PrL8vag4u0PZw/uHEy1e7H/JeOhxZQ2bw9wjy/537/m4P1eduyHvBKtDSNSz
24kaP/ZvM2k+8vkXi8OtjevKNsX/339UU2sjpwiLw6yn/5/bbWQ+MIuNwW2D
MLODweU3nxMlOA6YnGZpfv6T0WGDoly801OeA1PKLTLWH2NwyNLibuHr4T2Q
fz/F+/4kBoeqHglZa3m+A6ytEa/2+DM43HN30zoxj+/A5gtqXRN+/befFDNl
9VYu/gOXhLS3M5n/t599imkhczL/gbwLe6MvhPyz/z5xItem5fwHmjjvl/8M
/mu/fJPDiwM3+A8I7OvjrjP5Y79KR8DK4Bv/AYl3Z8Tivv2yh4SLwIFZM0Hg
J5x//sbR1/PNf8D5nw8rpT54+c2eEcpnj97AGr3hK1yefV7eWf7uL3D+157Y
Pf8qP8P5l9RrgegTnA9WPuUjnB+R6FeiceADnA+hP9gDAC7TtHM=
         "]], 0.2], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[{{-4., 1.}, {-4., 0.}}, 0.2], 
        ArrowBox[{{0., 1.}, {-4., 0.}}, 0.2], 
        ArrowBox[{{1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{0., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{1., 1.}, {-4., 0.}}, 0.2], 
        ArrowBox[{{-9., 2.}, {-4., 1.}}, 0.2], 
        ArrowBox[{{-8., 2.}, {-4., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {-4., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {1., 1.}}, 0.2], 
        ArrowBox[{{-5., 1.}, {-4., 0.}}, 0.2], 
        ArrowBox[{{-7., 2.}, {-4., 1.}}, 0.2], 
        ArrowBox[{{-6., 2.}, {-4., 1.}}, 0.2], 
        ArrowBox[{{-3., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQUOEIrDAcYPOX/j6Ov57HD+Jg/Jil2m7A6MUL54
zkGxnINscPk2y4sLGZwR/L8bQBpY4fy6S+q1l9QRfI55eWf5u1ng/JnCslwG
T5jhfBNjEGB2iPSV9+V5899+kuQNx9mtTA4ZprUmhhv+2+c8NtJ/9YLRQWOH
5LY8n//2xyY4/5aPZXSYdfXLxSMH/tnPVuRaZvOIweFgL1+HMe8/+3dT2/Qd
Khgc5jxIu7HL8K/9vrc7pmvJMzhonvt7KErvj71YkNPe72v/22eFXXYXZv5t
v6a/jiPD/r99XOXztCfrf9pbT1ETXPbpn33Rwg960gFP7eV22M0ML/xjv9k4
8dG5Oyf2v/X7zCqo9ss++cbpF8pm7/cviXAJvyTww76C4eqGqGu/9jtdNeyd
bfjNfunGMxy70pgOnDiye3lOxxf74K5Ibv0DbAes1B8tcxX9bO/BJZjQU851
YPKfJV1qNz7aNxp+ZrvUw3vgmgtLMP/FD/aQ4BE4AKE/2AMAf8ClUg==
         "]], 0.2], 
        ArrowBox[{{2., 3.}, {0., 2.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQUOEIrDYbWBupVIAoNDyPkbR1/PZ3fw3/6s3fUU
g8MmD8mKXabsDq8m272cbMfoIJ5zUCznIJtD9TG9uP97GB3aLC8uZHBmc2AG
a2By+LsBpIHVoVn3RpPuDSaHukvqtZfUWR1+Jk40+lDC7MAxL+8sfzeLQ8ab
R1/PS7M4zBSW5TJ4wuxwBgxYHEyMQYDZ4dWuALUP2awOqrM8cu43MDm05xUU
Ot9lddj59MuNX1cZHRY81153TIHN4ZOoRWWrEaODsVrznUozNodzWkK+9dMY
HFy0yv7EyLE5+Kk0h7xgZHC4+JmFr+AGq8MjFjH5xpf/7G816QtuTmF1KOgK
/sN/7699wvWvrGqHWRzcb+5zqH34xz7pY/ibE5+ZHZLB9G/7nYz1F3OEmRx2
gelf9m7tLK6aYQwOHmD6h70Iy8XeP+V/7bmbXrj92/3NnvlJ6Lrrnb/smT5p
XX/t8tU+ft30148ffrc3uH7668cPn+3Vk6e5KjZ8tZ9ieHqRwIFP9pFMQXv6
Uz7b6zJq3nPf9NH+e/cpf/3+j/Z/XJ8un378gz0knhA0ABYnwK4=
         "]], 0.2], 
        ArrowBox[{{-2., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEiByA0hwOMH3L+xtHX89nh/E0ekhW7TNkdGKF8
8ZyDYjkH2eDybZYXFzI4I/h/N4A0sML5dZfUay+pI/gc8/LO8nezwPkzhWW5
DJ4ww/kmxiDA7HByVdf8nD/CB+Iua6nKNTA5qK3Wqtv0UfjA7FO1e75eYnSQ
YHww++J94QMfJHR+7tRmdJi9ZtWPk8eED0TsM72d1cXgsGlt15TZy4QPrCk1
PSpw7799DEtDvlu98IFLMtvkVDf/s5+1oavzVIDwAaWit4eEpvy1z9m06pG6
NND80tsbbzb8sb/A+aAq7p7QATv1hteVlb/tW54vC9iUI3SAb95sp5Obftrv
n/2ciZtZ6MDPvHncOjw/7BvUFk3MWCh44PfMDrdFrd/sj7Vf+3PKXfCAsHzU
Z235r/aT9re4GH0TOOD6T0jo5I3P9k/OrsmYt0bgwATzzYsqN32y37vJL5M/
W+DAp1NWS23XfLSXyctyazUUOJC7Y6Wk6LEP9pDwEYDG1wd7AICZr2k=
         "]], 0.2], 
        ArrowBox[{{-5., 3.}, {0., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 3.}, 0.2], InsetBox["1", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-4., 1.}, 0.2], 
         InsetBox["3", {-4., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["4", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["7", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["13", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["16", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["19", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-4., 0.}, 0.2], 
         InsetBox["20", {-4., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-9., 2.}, 0.2], 
         InsetBox["2", {-9., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-8., 2.}, 0.2], 
         InsetBox["5", {-8., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["6", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-5., 1.}, 0.2], 
         InsetBox["8", {-5., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-7., 2.}, 0.2], 
         InsetBox["9", {-7., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-6., 2.}, 0.2], 
         InsetBox["10", {-6., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 2.}, 0.2], 
         InsetBox["11", {-3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["12", {2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["14", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-5., 3.}, 0.2], 
         InsetBox["17", {-5., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{3.8515248217255573`*^9},
 CellLabel->
  "Out[750]=",ExpressionUUID->"5d9d7a31-8f7c-4b75-8a92-82fcabe1417f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g15a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g15", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"12", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"19", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"17", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{"20", ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"{", 
         RowBox[{"7", ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"11", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", 
        RowBox[{"{", 
         RowBox[{"1.5", ",", "1.5"}], "}"}]}], "}"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.851524890048532*^9, 3.8515249144484386`*^9}, {
  3.8515249658177423`*^9, 3.851524970504476*^9}, {3.851525001826335*^9, 
  3.8515250082007847`*^9}, {3.851525050874048*^9, 3.851525211905384*^9}, {
  3.851525258931201*^9, 3.851525264587009*^9}, {3.851525296531303*^9, 
  3.8515253442899647`*^9}, {3.8515254160272913`*^9, 3.851525430546266*^9}, {
  3.851525479219681*^9, 3.851525545034779*^9}, {3.851525631756289*^9, 
  3.851525663699338*^9}, {3.851525695603856*^9, 3.851525710579639*^9}},
 CellLabel->
  "In[775]:=",ExpressionUUID->"f374c1f1-dd13-445b-8150-4c62c42c676c"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 3, 4, 7, 13, 16, 19, 20, 2, 5, 6, 8, 9, 10, 11, 12, 14, 17}, {
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 3, 4, 5, 8, 10, 10, 11, 11, 12, 13, 17, 18, 19, 20, 21, 24, 
          25, 27}, {{2}, {4}, {5}, {8}, {8}, {3}, {6}, {7}, {3}, {6}, {8}, {
          2}, {2}, {2}, {3}, {6}, {7}, {8}, {2}, {2}, {6}, {2}, {5}, {7}, {
          6}, {2}, {5}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, GraphLayout -> {"Dimension" -> 2}, ImageSize -> 600, 
       VertexCoordinates -> {{0, 3.}, {-3., 1.}, {0, 1.}, {1., 2.}, {
         0, 2.}, {-1., 1.}, {1., 0.}, {0., 0}, {-2., 0.}, {-3., 0.}, {-1., 
         2.}, {1., 1.}, {-1., 0.}, {-2.5, 2.5}, {-2., 3.}, {-2., 1.}, {-2., 
         2.}, {-3., 3.}}, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 3.}, {-3., 1.}}, 0.14142135623730953`], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.14142135623730953`], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.14142135623730953`], 
        ArrowBox[{{-3., 1.}, {0., 0.}}, 0.14142135623730953`], 
        ArrowBox[{{0., 1.}, {0., 0.}}, 0.14142135623730953`], 
        ArrowBox[{{1., 2.}, {0., 1.}}, 0.14142135623730953`], 
        ArrowBox[{{1., 2.}, {-1., 1.}}, 0.14142135623730953`], 
        ArrowBox[{{1., 2.}, {1., 0.}}, 0.14142135623730953`], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.14142135623730953`], 
        ArrowBox[{{0., 2.}, {-1., 1.}}, 0.14142135623730953`], 
        ArrowBox[{{1., 0.}, {0., 0.}}, 0.14142135623730953`], 
        ArrowBox[{{-2., 0.}, {-3., 1.}}, 0.14142135623730953`], 
        ArrowBox[{{-3., 0.}, {-3., 1.}}, 0.14142135623730953`], 
        ArrowBox[{{-1., 2.}, {-3., 1.}}, 0.14142135623730953`], 
        ArrowBox[{{-1., 2.}, {0., 1.}}, 0.14142135623730953`], 
        ArrowBox[{{-1., 2.}, {-1., 1.}}, 0.14142135623730953`], 
        ArrowBox[{{-1., 2.}, {1., 0.}}, 0.14142135623730953`], 
        ArrowBox[{{1., 1.}, {0., 0.}}, 0.14142135623730953`], 
        ArrowBox[{{-1., 0.}, {-3., 1.}}, 0.14142135623730953`], 
        ArrowBox[{{-2.5, 2.5}, {-3., 1.}}, 0.14142135623730953`], 
        ArrowBox[{{-2., 3.}, {-1., 1.}}, 0.14142135623730953`], 
        ArrowBox[{{-2., 1.}, {-3., 1.}}, 0.14142135623730953`], 
        ArrowBox[{{-2., 1.}, {0., 2.}}, 0.14142135623730953`], 
        ArrowBox[{{-2., 1.}, {1., 0.}}, 0.14142135623730953`], 
        ArrowBox[{{-2., 2.}, {-1., 1.}}, 0.14142135623730953`], 
        ArrowBox[{{-3., 3.}, {-3., 1.}}, 0.14142135623730953`], 
        ArrowBox[{{-3., 3.}, {0., 2.}}, 0.14142135623730953`]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 3.}, 0.14142135623730953], 
         InsetBox["1", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 1.}, 0.14142135623730953], 
         InsetBox["3", {-3., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.14142135623730953], 
         InsetBox["4", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.14142135623730953], 
         InsetBox["7", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.14142135623730953], 
         InsetBox["13", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.14142135623730953], 
         InsetBox["16", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 0.}, 0.14142135623730953], 
         InsetBox["19", {1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.14142135623730953], 
         InsetBox["20", {0., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 0.}, 0.14142135623730953], 
         InsetBox["2", {-2., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 0.}, 0.14142135623730953], 
         InsetBox["5", {-3., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.14142135623730953], 
         InsetBox["6", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.14142135623730953], 
         InsetBox["8", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 0.}, 0.14142135623730953], 
         InsetBox["9", {-1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2.5, 2.5}, 0.14142135623730953],
          InsetBox["10", {-2.5, 2.5},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 3.}, 0.14142135623730953], 
         InsetBox["11", {-2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 1.}, 0.14142135623730953], 
         InsetBox["12", {-2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.14142135623730953], 
         InsetBox["14", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 3.}, 0.14142135623730953], 
         InsetBox["17", {-3., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{{3.8515251352791433`*^9, 3.851525212735063*^9}, {
   3.851525259851022*^9, 3.851525265104312*^9}, 3.851525303441141*^9, 
   3.851525345295658*^9, 3.851525431582011*^9, {3.851525511777094*^9, 
   3.851525545946848*^9}, {3.851525697071766*^9, 3.8515257111917152`*^9}},
 CellLabel->
  "Out[775]=",ExpressionUUID->"965c77e2-f87d-4c33-86b9-1e2afaf5bc9c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g16", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"graph", "[", "16", "]"}], ",", 
    RowBox[{"GraphLayout", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<LayeredDigraphEmbedding\>\"", ",", 
       RowBox[{"\"\<Orientation\>\"", "\[Rule]", "Left"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.851525762363948*^9, 3.851525765467937*^9}, {
  3.851525796181406*^9, 3.851525866435158*^9}},
 CellLabel->
  "In[782]:=",ExpressionUUID->"27155c11-045b-4bb5-9799-6462aba1ac4f"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 8, 9, 10, 15, 20, 4, 5, 6, 7, 12, 13, 17, 19}, {
       SparseArray[
       Automatic, {16, 16}, 0, {
        1, {{0, 2, 3, 4, 5, 7, 8, 9, 9, 10, 11, 12, 14, 15, 18, 20, 21}, {{
          2}, {7}, {6}, {8}, {8}, {3}, {4}, {5}, {3}, {8}, {3}, {1}, {1}, {
          13}, {2}, {1}, {13}, {15}, {2}, {7}, {6}}}, Pattern}], Null}, {
      EdgeStyle -> {
         GrayLevel[0]}, 
       GraphLayout -> {
        "Dimension" -> 2, 
         "VertexLayout" -> {
          "LayeredDigraphEmbedding", "Orientation" -> Left}}, ImageSize -> 
       600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{-4.999999999999998, 
         1.339744851455892*^-7}, {-3.9999999464102047`, 2.0000001071795874`}},
          0.19999999999999998`], 
        ArrowBox[{{-4.999999999999998, 
         1.339744851455892*^-7}, {-3.9999999999999987`, 
         1.0717958811647137`*^-7}}, 0.19999999999999998`], 
        ArrowBox[{{-3.9999999464102047`, 
         2.0000001071795874`}, {-2.999999973205102, 1.0000000803846907`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 0.}}, 
         0.19999999999999998`], 
        ArrowBox[{{-0.9999999732051026, 1.0000000267948967`}, {0., 0.}}, 
         0.19999999999999998`], 
        ArrowBox[{{-1.9999999732051024`, 
         1.0000000535897937`}, {-0.9999999999999997, 
         2.6794897029117842`*^-8}}, 0.19999999999999998`], 
        ArrowBox[{{-1.9999999732051024`, 
         1.0000000535897937`}, {-0.9999999732051026, 1.0000000267948967`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-2.999999973205102, 
         1.0000000803846907`}, {-1.9999999732051024`, 1.0000000535897937`}}, 
         0.19999999999999998`], ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQ/fc/CPAfSEqScgw+WmMXeP7G0dfz+Q8kq+8S/5hX
Y7feQ7Jilyn/AWXGJ/Ll/DV2ojkHxXIO8h1Y8H565NNl1XbNlhcXMjjzHbjx
6eoRa9Nqu18bQBp4D5zjmpdYtavKrvqSeu0ldd4DTeYf9BeaVdmxzMs7y9/N
c+BDxRn9DSsr7aYJy3IZPOE+IHveKHG5cKWdoTEIcB9gs1I+0lZSYXcepL2W
64Dv+hv2ty6U2xXKHAcizgPTVPp26+qW2wkIggDngfsznc0bO8vs1rFGb2CN
5jigxv9z05WnpXZ+v5b4/1rCfiCvZZ2ehlOp3TswYDuw7Wfyqup5JXa9jy36
HluwHfibJ6l2/lexne6NJiBiPeD25NxCpfBiOyOwe5gP5C2889nQudDuItg9
TAe2ik3Kb51fYFcAdg/jgV/i/dc2fs+HuofxQC/Tr7MRG/Ls1oPdw3BA+m3K
0f8ZuXZzvnjO/+L5f/+q6+f3LFPMsbt9FwT+7rc6ZLXF91aWnRTIuMI/+0+u
Wbr6y6RMu8gNIAN+74+cLrB4tneG3fSZIPBz/4vG6llOLOl2Z0HRZf5j/67w
mATGY6l2nw4rpT54+W2/MIvm4fczU+zA1m/4uv9L28NDvA3Jdqzg8P+yP+JB
a3x0RZLdl57YPf8qP+93ERCbeaMpEeq/T/u3gf2XYDcHpHzKx/0xzz8fPTwn
3i480a9E48CH/VF+s5/dlouzg6Sf9/sh6SfGDgB3sCXS
         "]], 
         0.19999999999999998`], 
        ArrowBox[{{-1.0000000267948967`, -0.9999999732051026}, {0., 0.}}, 
         0.19999999999999998`], 
        ArrowBox[{{-2.0000000267948965`, -0.9999999464102056}, \
{-0.9999999999999997, 2.6794897029117842`*^-8}}, 0.19999999999999998`], 
        ArrowBox[{{-6.000000026794895, -0.9999998392306175}, \
{-4.999999999999998, 1.339744851455892*^-7}}, 0.19999999999999998`], 
        ArrowBox[{{-5.999999999999998, 
         1.6076938217470707`*^-7}, {-4.999999999999998, 
         1.339744851455892*^-7}}, 0.19999999999999998`], 
        ArrowBox[{{-5.999999999999998, 
         1.6076938217470707`*^-7}, {-4.999999973205101, 1.0000001339744848`}},
          0.19999999999999998`], 
        ArrowBox[{{-4.999999973205101, 
         1.0000001339744848`}, {-3.9999999464102047`, 2.0000001071795874`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-5.999999973205101, 
         1.0000001607693818`}, {-4.999999999999998, 1.339744851455892*^-7}}, 
         0.19999999999999998`], 
        ArrowBox[{{-5.999999973205101, 
         1.0000001607693818`}, {-4.999999973205101, 1.0000001339744848`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-5.999999973205101, 
         1.0000001607693818`}, {-4.999999946410204, 2.0000001339744844`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-4.999999946410204, 
         2.0000001339744844`}, {-3.9999999464102047`, 2.0000001071795874`}}, 
         0.19999999999999998`], 
        ArrowBox[{{-4.999999946410204, 
         2.0000001339744844`}, {-3.9999999999999987`, 
         1.0717958811647137`*^-7}}, 0.19999999999999998`], 
        ArrowBox[{{-3.9999999732051017`, 
         1.0000001071795879`}, {-2.999999973205102, 1.0000000803846907`}}, 
         0.19999999999999998`]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {
         DiskBox[{-4.999999999999998, 1.339744851455892*^-7}, 
          0.19999999999999998], 
         InsetBox["1", {-4.999999999999998, 1.339744851455892*^-7},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999464102047, 2.0000001071795874}, 
          0.19999999999999998], 
         InsetBox["2", {-3.9999999464102047, 2.0000001071795874},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999999999997, 2.6794897029117842*^-8}, 
          0.19999999999999998], 
         InsetBox["3", {-0.9999999999999997, 2.6794897029117842*^-8},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999732051026, 1.0000000267948967}, 
          0.19999999999999998], 
         InsetBox["8", {-0.9999999732051026, 1.0000000267948967},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999732051024, 1.0000000535897937}, 
          0.19999999999999998], 
         InsetBox["9", {-1.9999999732051024, 1.0000000535897937},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.999999973205102, 1.0000000803846907}, 
          0.19999999999999998], 
         InsetBox["10", {-2.999999973205102, 1.0000000803846907},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999999999987, 1.0717958811647137*^-7}, 
          0.19999999999999998], 
         InsetBox["15", {-3.9999999999999987, 1.0717958811647137*^-7},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.19999999999999998], 
         InsetBox["20", {0., 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.0000000267948967, -0.9999999732051026}, 
          0.19999999999999998], 
         InsetBox["4", {-1.0000000267948967, -0.9999999732051026},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.0000000267948965, -0.9999999464102056}, 
          0.19999999999999998], 
         InsetBox["5", {-2.0000000267948965, -0.9999999464102056},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-6.000000026794895, -0.9999998392306175}, 
          0.19999999999999998], 
         InsetBox["6", {-6.000000026794895, -0.9999998392306175},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-5.999999999999998, 1.6076938217470707*^-7}, 
          0.19999999999999998], 
         InsetBox["7", {-5.999999999999998, 1.6076938217470707*^-7},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999973205101, 1.0000001339744848}, 
          0.19999999999999998], 
         InsetBox["12", {-4.999999973205101, 1.0000001339744848},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-5.999999973205101, 1.0000001607693818}, 
          0.19999999999999998], 
         InsetBox["13", {-5.999999973205101, 1.0000001607693818},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999946410204, 2.0000001339744844}, 
          0.19999999999999998], 
         InsetBox["17", {-4.999999946410204, 2.0000001339744844},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999732051017, 1.0000001071795879}, 
          0.19999999999999998], 
         InsetBox["19", {-3.9999999732051017, 1.0000001071795879},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{{3.851525815556222*^9, 3.8515258678905582`*^9}},
 CellLabel->
  "Out[782]=",ExpressionUUID->"9fdb60ca-e0a1-4660-a8a5-fa010e7b3b32"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g16a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g16", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"20", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "}"}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.851525899452631*^9, 3.851525939364204*^9}, {
  3.8515259749200563`*^9, 3.851526098036962*^9}},
 CellLabel->
  "In[789]:=",ExpressionUUID->"52184336-97bc-4e98-bd53-acbca373a93f"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 8, 9, 10, 15, 20, 4, 5, 6, 7, 12, 13, 17, 19}, {
       SparseArray[
       Automatic, {16, 16}, 0, {
        1, {{0, 2, 3, 4, 5, 7, 8, 9, 9, 10, 11, 12, 14, 15, 18, 20, 21}, {{
          2}, {7}, {6}, {8}, {8}, {3}, {4}, {5}, {3}, {8}, {3}, {1}, {1}, {
          13}, {2}, {1}, {13}, {15}, {2}, {7}, {6}}}, Pattern}], Null}, {
      EdgeStyle -> {
         GrayLevel[0]}, 
       GraphLayout -> {
        "Dimension" -> 2, 
         "VertexLayout" -> {
          "LayeredDigraphEmbedding", "Orientation" -> Left}}, ImageSize -> 
       600, VertexCoordinates -> {{-4.999999999999998, 
          0}, {-3.9999999464102047`, 
         2.0000001071795874`}, {-2.9999999999999996`, 
          0}, {-1.9999999732051026`, 
         1.0000000267948967`}, {-1.9999999732051024`, 
         2.000000053589794}, {-2.999999973205102, 
         1.0000000803846907`}, {-3.9999999999999987`, 0}, {-2, 
         0}, {-2.000000026794897, -0.9999999732051026}, \
{-3.0000000267948965`, -0.9999999464102056}, {-5.000000026794895, \
-0.9999998392306175}, {-5.999999999999998, 0}, {-4.999999973205101, 
         1.0000001339744848`}, {-5.999999973205101, 
         1.0000001607693818`}, {-4.999999946410204, 
         2.0000001339744844`}, {-3.9999999732051017`, 1.0000001071795879`}}, 
       VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{-4.999999999999998, 0.}, {-3.9999999464102047`, 
         2.0000001071795874`}}, 0.1999999678461236], 
        ArrowBox[{{-4.999999999999998, 0.}, {-3.9999999999999987`, 0.}}, 
         0.1999999678461236], 
        ArrowBox[{{-3.9999999464102047`, 
         2.0000001071795874`}, {-2.999999973205102, 1.0000000803846907`}}, 
         0.1999999678461236], 
        ArrowBox[{{-2.9999999999999996`, 0.}, {-2., 0.}}, 0.1999999678461236],
         ArrowBox[{{-1.9999999732051026`, 1.0000000267948967`}, {-2., 0.}}, 
         0.1999999678461236], 
        ArrowBox[{{-1.9999999732051024`, 
         2.000000053589794}, {-2.9999999999999996`, 0.}}, 0.1999999678461236],
         ArrowBox[{{-1.9999999732051024`, 
         2.000000053589794}, {-1.9999999732051026`, 1.0000000267948967`}}, 
         0.1999999678461236], 
        ArrowBox[{{-2.999999973205102, 
         1.0000000803846907`}, {-1.9999999732051024`, 2.000000053589794}}, 
         0.1999999678461236], 
        ArrowBox[{{-3.9999999999999987`, 0.}, {-2.9999999999999996`, 0.}}, 
         0.1999999678461236], 
        ArrowBox[{{-2.000000026794897, -0.9999999732051026}, {-2., 0.}}, 
         0.1999999678461236], 
        ArrowBox[{{-3.0000000267948965`, -0.9999999464102056}, \
{-2.9999999999999996`, 0.}}, 0.1999999678461236], 
        ArrowBox[{{-5.000000026794895, -0.9999998392306175}, \
{-4.999999999999998, 0.}}, 0.1999999678461236], 
        ArrowBox[{{-5.999999999999998, 0.}, {-4.999999999999998, 0.}}, 
         0.1999999678461236], 
        ArrowBox[{{-5.999999999999998, 0.}, {-4.999999973205101, 
         1.0000001339744848`}}, 0.1999999678461236], 
        ArrowBox[{{-4.999999973205101, 
         1.0000001339744848`}, {-3.9999999464102047`, 2.0000001071795874`}}, 
         0.1999999678461236], 
        ArrowBox[{{-5.999999973205101, 
         1.0000001607693818`}, {-4.999999999999998, 0.}}, 0.1999999678461236],
         ArrowBox[{{-5.999999973205101, 
         1.0000001607693818`}, {-4.999999973205101, 1.0000001339744848`}}, 
         0.1999999678461236], 
        ArrowBox[{{-5.999999973205101, 
         1.0000001607693818`}, {-4.999999946410204, 2.0000001339744844`}}, 
         0.1999999678461236], 
        ArrowBox[{{-4.999999946410204, 
         2.0000001339744844`}, {-3.9999999464102047`, 2.0000001071795874`}}, 
         0.1999999678461236], 
        ArrowBox[{{-4.999999946410204, 
         2.0000001339744844`}, {-3.9999999999999987`, 0.}}, 
         0.1999999678461236], 
        ArrowBox[{{-3.9999999732051017`, 
         1.0000001071795879`}, {-2.999999973205102, 1.0000000803846907`}}, 
         0.1999999678461236]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{-4.999999999999998, 0.}, 0.1999999678461236], 
         InsetBox["1", {-4.999999999999998, 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999464102047, 2.0000001071795874}, 
          0.1999999678461236], 
         InsetBox["2", {-3.9999999464102047, 2.0000001071795874},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.9999999999999996, 0.}, 0.1999999678461236], 
         InsetBox["3", {-2.9999999999999996, 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999732051026, 1.0000000267948967}, 
          0.1999999678461236], 
         InsetBox["8", {-1.9999999732051026, 1.0000000267948967},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999732051024, 2.000000053589794}, 
          0.1999999678461236], 
         InsetBox["9", {-1.9999999732051024, 2.000000053589794},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.999999973205102, 1.0000000803846907}, 
          0.1999999678461236], 
         InsetBox["10", {-2.999999973205102, 1.0000000803846907},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999999999987, 0.}, 0.1999999678461236], 
         InsetBox["15", {-3.9999999999999987, 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 0.}, 0.1999999678461236], 
         InsetBox["20", {-2., 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.000000026794897, -0.9999999732051026}, 
          0.1999999678461236], 
         InsetBox["4", {-2.000000026794897, -0.9999999732051026},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.0000000267948965, -0.9999999464102056}, 
          0.1999999678461236], 
         InsetBox["5", {-3.0000000267948965, -0.9999999464102056},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-5.000000026794895, -0.9999998392306175}, 
          0.1999999678461236], 
         InsetBox["6", {-5.000000026794895, -0.9999998392306175},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-5.999999999999998, 0.}, 0.1999999678461236], 
         InsetBox["7", {-5.999999999999998, 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999973205101, 1.0000001339744848}, 
          0.1999999678461236], 
         InsetBox["12", {-4.999999973205101, 1.0000001339744848},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-5.999999973205101, 1.0000001607693818}, 
          0.1999999678461236], 
         InsetBox["13", {-5.999999973205101, 1.0000001607693818},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999946410204, 2.0000001339744844}, 
          0.1999999678461236], 
         InsetBox["17", {-4.999999946410204, 2.0000001339744844},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999732051017, 1.0000001071795879}, 
          0.1999999678461236], 
         InsetBox["19", {-3.9999999732051017, 1.0000001071795879},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{
  3.851525940595406*^9, {3.851525979722266*^9, 3.8515260667332973`*^9}, 
   3.8515260999739532`*^9},
 CellLabel->
  "Out[789]=",ExpressionUUID->"44507d10-7be2-4059-ad8e-e4ddb8451500"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g17", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{"graph", "[", "17", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851526416278565*^9, 3.851526421495133*^9}},
 CellLabel->
  "In[791]:=",ExpressionUUID->"e966ec33-8066-432b-9eec-b77c90ca1ad4"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 8, 9, 10, 11, 13, 14, 16, 18, 20, 6, 7, 12, 15, 
      19}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 4, 5, 6, 7, 8, 9, 11, 12, 14, 19, 19, 19, 19, 19, 24, 28, 29, 
          32, 33}, {{2}, {5}, {9}, {10}, {8}, {14}, {14}, {3}, {14}, {3}, {
          6}, {7}, {11}, {12}, {3}, {4}, {11}, {12}, {13}, {4}, {8}, {11}, {
          12}, {13}, {4}, {8}, {9}, {13}, {1}, {3}, {4}, {11}, {14}}}, 
         Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 5.}, {4., 4.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQjQpEHNRucey7nbVzv/e7Zg+ts8IOlh4Bqd4iZ/bf
35d1aV2/sMPOE4WePnzX9+8u3DK3113YQX/S+8ipmx/sv8uWuOrYFyGHdukf
FQldz/Z71BX8iJwu5JDUcKmxnfvt/l/XH7W76ws5JCbYW7VKf9r/RXhHRP8e
QYfgvLoVJWzf9psZfcgytBd04Mhaxj3J7df+/Ubd+3S3Czj0HZ1joVj1e3+Q
jYL/2m4BByf2iPzGzj/7NYOfrJoaJeCgpH9j/aaSv/tdy69ffKYs4KBjK/tr
i/W//c6Bn9sdz/M7pBiq+3Xc+7e/5dxUpnZvfocT3N9W68T+3++XNk143h4+
h4gzncKLtv/fP0fi6642JT4HseJHLS/e/t9f9HTjD4daXgdowBwwBgNuOP+i
eu0l9VouOL9I5nihzHFOB0YoX1gQBDjh8htYo4GIA84P+LXE/9cSdjj//TsQ
YIPz+x5bABGCr3ejSfdGEyucfwYMWOD8tDePvp6XRvB/JU40+lDCDHdPiy7I
ACa4PIv/9mftrgh+1TG9uP97GOH8V5PtXk62Q/DByk8xwPlrDNStRBIQfCjt
AACisNFs
         "]], 0.2], ArrowBox[{{0., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[{{0., 5.}, {0., 4.}}, 0.2], 
        ArrowBox[{{4., 4.}, {5., 3.}}, 0.2], 
        ArrowBox[{{2., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQDQEcDjD6PxiwO4Scv3H09Xx2uPgmD8mKXabsDoxQ
vnjOQbGcg2xw+TbLiwsZnBH8vxtAGljh/LpL6rWX1BF8jnl5Z/m7WeD8mcKy
XAZPmOF8E2MQYIa75wpIey0TXL5Q5jgQMcLdIyQIAoxw+Y2s0RtYoxng/AVf
POd/8fxvD+PfuwsCf+F8WZBxhX/g/JgNIAN+w/lpYPDNflKoqP3NH+wOO5aF
etkwfLX3Cwv9k/KY3cF86u+K10s/2+szHTBfvJ/d4YFhxKfi8E/2ppGhHyf3
sjtsqMnedlXko31ytKimuS+7Q8TrrC7FPe/td3Aw3O/5x+awyDLH1ivtrb1J
oqjw1IVsDk5PbrWqary2v5oSetTfjM3B9PW25M2ML+3nCR/4umcPq0O1H8P1
z5+e2bOd912YcpPFQcbGvHVS6mP7GvPzrGJsLA7v79qIR0g8sP/r46J80YnZ
4Vm6klSn2C37Lv61P6f2Mzn41GScXV9zxV6pnrMz5Q2jg/qn6RM8jp2zPzE7
8qJNJKND9Z6ZomcnH7WvTJ17Se4ag4Pc+jXBtw7vsje/c6WHK5nBYR6vueni
Qyug4QMLZwYGANLRxWk=
         "]], 0.2], ArrowBox[{{-2., 2.}, {2., 1.}}, 0.2],
         ArrowBox[{{5., 1.}, {2., 0.}}, 0.2], 
        ArrowBox[{{5., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{5., 2.}, {5., 1.}}, 0.2], 
        ArrowBox[{{5., 3.}, {5., 2.}}, 0.2], 
        ArrowBox[{{1., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQjQoEHH5qnenkY12xP/j8jaOv5/M73H957c8Gj537
N3pIVuwy5XeYYvdyst3Lw/slcg6K5Rzkc1iZ/ubR1/On97daXlzI4MznAFJl
r3NpP1ATkMnrIAZWd21/3SX12kvqvA7n+LunNC6/vZ9tXt5Z/m4eh3kbu6/b
5z/YP0NYlsvgCbeDMRg83g+huR2kkwK/LV3zdH+flB/7/iYuh4uTf1suzni+
P/U5l2vlXU6HoBOG/7TSX+zfNjPzTaIzp8O8/5+dbFe82F9jmPW3YguHww5L
J45b2i/271vHU7HPgMNhfpmMH+OnZ/srBQNjjHawOwRsaxLZ/OvJ/jWR5quu
eLE7nPtREv3e9dH+mPb9iUtfsDmIvWpOWvv2p/1y5ldHeJkZHVhcQpc9Mf5t
v0mORW3SIQYHEY9I/t3Bf+xLC3fddCxhcHD51j/XwPev/YffPA9kJBgcJvn9
DHBV+GdvX/O90C3mvz1j4FTNn2f+2QsU8J5cmfPPfuLfZHWf4P/2fpejjyYn
/rV3CEn1stv83/7H0kdpJVZ/7AVCZ046/+a/vfCLhWtvf/9lD40oh1kzQeAn
nA+OLvMfcP7nw0qpD15+s2eE8tmjN7BGb/gKl2cHh/8XOP9rT+yef5Wf4Xxw
dNV+gvPByqd8hPMjEv1KNA58gPMh1Ad7AKHJ9eQ=
         "]], 0.2], 
        ArrowBox[{{0., 4.}, {3., 3.}}, 0.2], 
        ArrowBox[{{0., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{0., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{0., 4.}, {2., 3.}}, 0.2], 
        ArrowBox[{{2., 4.}, {3., 3.}}, 0.2], 
        ArrowBox[{{2., 4.}, {5., 3.}}, 0.2], 
        ArrowBox[{{2., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{2., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{2., 4.}, {2., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQESDhBaxOE/GIg7rEx/8+jreWEHmHzEEh6bu7OE
HRihfJ5tCdzbEhDyh+e8CGhQRPDrwBqE4Hz7l5PtXk5G8Fn8tz9rd0Xwz3Ty
sUp8EoTzZ80EAUEH59BlT4x/izv8aZ0uwukk6CAYOnPS+TfiDk1h7s+SPgo4
pP6/wXn5iriDHvdKvuXLBRwcQlK97DYD1S/e03s1RcBhSbBdiGCHuMMHhabk
dxoCDpP+Jqv7BIs7CLF8ln/8nN+BLeja4Xci4g5dfa5q+7r5HZgCp2r+PCPm
4Pfw981cW36Htl8LIrKrxRwi/4haf/rD5+D9obN4xkERh7av0YtSr/E6FAq/
1d+gLezwjWfeqVPHeRx+JJ/q3bRT0GGZ053Nihe5He49VOydny3gMGWaWFzW
Jy4HD6nn0e+a+BwOc/ieXKLN5TDtdN2DojIeB6OZ9V8v1HA6LLnOteLMRi6H
h+7rHr17yuFQZNe96bcJp8NFkZsT/qVxQMMHQQMAEcKj6Q==
         "]], 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQESDhBaxCF0hrAsl4GEw8r0N4++nhd2WBH9+bBS
qoRDxBIem7uzhB2+es7/4jlfwoFnWwL3tgRhB7tk8fX19yQcDs95EdCgKOzQ
tBykQdKhDqxByOGQWM5BsRxJB/uXk+1eThZy+LfBQ7Jil6QDi//2Z+2uQg6m
ZR9/PeeVcjjTyccq8UnQIT0NBKQcZs0EAUGH0lgN4R9bpRyEfVW25TsIOjib
79ix8J2Uw52iqpy/rwQcLnwWDU8WkHb4xTVnj9NMAQepyY7vbKSlHdJFO5fZ
ews4KIla1+nxSzuoT3LU+sIg4PCikond4o2UQxFTd/+BEn6HvIPTOyI3STlY
HNX8x/6ez2HD619MkxOlHBblxC/YV8DnsPGHdtmTn5JQmtfhTsP+jG2cklCa
12GJc9MiEW0JKM3jwOpYovw/VtyBDUxzOzBUTn1dukjMgQlMcznMeP30V8UP
USjN6XBqRmogR4IolOZ0mNYg8l75pgiU5nD4t+jT5dPJIlCaAx5PEJrDAQCK
N7IX
         "]], 0.2], ArrowBox[{{6., 5.}, {1., 4.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQESDhBaxGFl+ptHX8+LQ2lhh8glPDZ3Z4k7RIBp
YQeebQnc2xLEobSww+E5LwIaFMWhtLBDPVihmEMdmBZysH852e7lZDEoLeTA
4r/9WburGJQWcjjbyccq8UnU4QyYFnSYNRMERKG0oAPvqvtLbtqIOnjyLm+O
dxR0OPksXX3pHRGHTcWti/a8E3A442+k+KdCxOH2GZNvGxYKOIg/tZt0T1DE
YZ/E1jqbKAGHVct6q3yWCzvEh7PZxEsIOLRMkbvlainsUCkYGGO0g99h+bqP
G04dF3JYE2m+6ooXv4PgV7b/t4KEHGLa9ycufcHncDg97kjZLUGHplkvm5ZM
5HOIz9Tfn+0k4DB1trzW3EZeB8+O9a8XT+F1kLjR7/ewjcdB9cO6C0FPuBz4
Aqw+FCzkdgjkitV9UszhUMQsz+9zkcvh4rWdjBHObA5un2xXF4lxOSwKPeq7
LojFoUdm+pEnBZwOR9vqBZ8vZHJwatKKXvSAw8Eq64UPkyGjQ6byj7zVqRzQ
eGKA0hwOANQDsJM=
         "]], 0.2], ArrowBox[{{0., 6.}, {0., 5.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQDQEcDhBawMHszpUermQOhxPK2sVf5/A7VKbOvSR3
jcOhfVaS7kNNfocTsyMv2kRyOlilLNM7vIzPQameszPlDafDvYZvZbOF+Ry6
+Nf+nNrP5VD2IYgtq4DX4a+Pi/JFJ24Hls277+jt5XGoMT/PKsbG49BywuDX
y5/cDhznfRem3ORx+GmwKW62GrfDfOEDX/fs4XVIfGPP5ezM5XAtJfSovxmf
g6GrkPrk/ZwOJomiwlMX8jm8d+uc982U02EXB8P9nn98DjM+LinIXcbhkBwt
qmnuy++g5Zo697sAh4NpZOjHyb38DssdT6lMLWV30Gc6YL54P7+DwPPLbG5X
2Bz8wkL/pDzmd0gxbXLm0mVzmBIqan/zB7/DYp2rtx7Ws8LDxcQYBJgdui0L
nb5843eYIOXHvr+JyUH32RHOi7eB+p9zuVbeZXR4xvo7dNo6foctMzPfJDoz
OmyaIazuks/vUGOY9bdiC4PDtHl8tbdk+R32ruOp2GfA4DBB/E145C4+h49K
i3akFPy3X8C8ZvsBFz6HqM15ISun/rM/keQ3R2Avr8M2vvrDXhf/2rOYXmb1
VOZ1gNB/7TXN7UOsmLkdIPRve8MN8nMP8XI6QOif9pILSh48dGJ3gNDf7R+x
2cnNWMTqAKG/2vc8qQ57qsPiAKG/2EtY6nWefMjkAKE/2bewhG5zOcjoAKE/
2l9y+3A37DSDA4T+YA9NQNBw+mAPANfU5XI=
         "]], 0.2], 
        ArrowBox[{{3., 4.}, {3., 3.}}, 0.2], 
        ArrowBox[{{3., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{1., 1.}, {2., 0.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 5.}, 0.2], InsetBox["1", {0., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 4.}, 0.2], 
         InsetBox["2", {4., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["3", {2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.2], 
         InsetBox["4", {3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["5", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 1.}, 0.2], 
         InsetBox["8", {5., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 2.}, 0.2], 
         InsetBox["9", {5., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 3.}, 0.2], 
         InsetBox["10", {5., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.2], 
         InsetBox["11", {1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 4.}, 0.2], 
         InsetBox["13", {0., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["14", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 3.}, 0.2], 
         InsetBox["16", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["18", {2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 0.}, 0.2], 
         InsetBox["20", {2., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 4.}, 0.2], 
         InsetBox["6", {2., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{6., 5.}, 0.2], 
         InsetBox["7", {6., 5.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 6.}, 0.2], 
         InsetBox["12", {0., 6.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 4.}, 0.2], 
         InsetBox["15", {3., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["19", {1., 1.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{3.851526422326509*^9},
 CellLabel->
  "Out[791]=",ExpressionUUID->"c853eb91-f843-4548-8071-f38f76e92792"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g17a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g17", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"12", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "4"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"7", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{"20", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851526466318591*^9, 3.851526529590515*^9}, {
  3.851526563064295*^9, 3.851526632127038*^9}, {3.851526699448694*^9, 
  3.8515267705114594`*^9}, {3.85152683117699*^9, 3.851526840840753*^9}, {
  3.8515269435934067`*^9, 3.851526982856248*^9}, {3.851527114585926*^9, 
  3.8515271312651577`*^9}, {3.851527203274476*^9, 3.8515272735936737`*^9}},
 CellLabel->
  "In[814]:=",ExpressionUUID->"e63b1e64-fd2f-4a1e-8fc3-327970a8e5f7"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 8, 9, 10, 11, 13, 14, 16, 18, 20, 6, 7, 12, 15, 
      19}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 4, 5, 6, 7, 8, 9, 11, 12, 14, 19, 19, 19, 19, 19, 24, 28, 29, 
          32, 33}, {{2}, {5}, {9}, {10}, {8}, {14}, {14}, {3}, {14}, {3}, {
          6}, {7}, {11}, {12}, {3}, {4}, {11}, {12}, {13}, {4}, {8}, {11}, {
          12}, {13}, {4}, {8}, {9}, {13}, {1}, {3}, {4}, {11}, {14}}}, 
         Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, GraphLayout -> {"Dimension" -> 2}, ImageSize -> 600, 
       VertexCoordinates -> {{-1, 3.}, {1., 2.}, {3., 2.}, {3., 3.}, {0., 
         1.}, {4., 1.}, {4., 2.}, {4., 3.}, {1., 4.}, {0, 4.}, {1., 3.}, {
         0, 3.}, {2., 3.}, {2., 1}, {2., 4.}, {2., 2.}, {0, 2.}, {3., 4.}, {
         1., 1.}}, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{-1., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{-1., 3.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-1., 3.}, {1., 4.}}, 0.2], 
        ArrowBox[{{-1., 3.}, {0., 4.}}, 0.2], 
        ArrowBox[{{1., 2.}, {4., 3.}}, 0.2], 
        ArrowBox[{{3., 2.}, {2., 1.}}, 0.2], 
        ArrowBox[{{3., 3.}, {2., 1.}}, 0.2], 
        ArrowBox[{{0., 1.}, {3., 2.}}, 0.2], 
        ArrowBox[{{4., 1.}, {2., 1.}}, 0.2], 
        ArrowBox[{{4., 2.}, {3., 2.}}, 0.2], 
        ArrowBox[{{4., 2.}, {4., 1.}}, 0.2], 
        ArrowBox[{{4., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{1., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{1., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{0., 4.}, {3., 2.}}, 0.2], 
        ArrowBox[{{0., 4.}, {3., 3.}}, 0.2], 
        ArrowBox[{{0., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{0., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{0., 4.}, {2., 3.}}, 0.2], 
        ArrowBox[{{2., 4.}, {3., 3.}}, 0.2], 
        ArrowBox[{{2., 4.}, {4., 3.}}, 0.2], 
        ArrowBox[{{2., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{2., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[{{2., 4.}, {2., 3.}}, 0.2], 
        ArrowBox[{{2., 2.}, {3., 3.}}, 0.2], 
        ArrowBox[{{2., 2.}, {4., 3.}}, 0.2], 
        ArrowBox[{{2., 2.}, {1., 4.}}, 0.2], 
        ArrowBox[{{2., 2.}, {2., 3.}}, 0.2], 
        ArrowBox[{{0., 2.}, {-1., 3.}}, 0.2], 
        ArrowBox[{{3., 4.}, {3., 2.}}, 0.2], 
        ArrowBox[{{3., 4.}, {3., 3.}}, 0.2], 
        ArrowBox[{{3., 4.}, {1., 3.}}, 0.2], 
        ArrowBox[{{1., 1.}, {2., 1.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{-1., 3.}, 0.2], InsetBox["1", {-1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["2", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.2], 
         InsetBox["3", {3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.2], 
         InsetBox["4", {3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["5", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 1.}, 0.2], 
         InsetBox["8", {4., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 2.}, 0.2], 
         InsetBox["9", {4., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 3.}, 0.2], 
         InsetBox["10", {4., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.2], 
         InsetBox["11", {1., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 4.}, 0.2], 
         InsetBox["13", {0., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["14", {1., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 3.}, 0.2], 
         InsetBox["16", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["18", {2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["20", {2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 4.}, 0.2], 
         InsetBox["6", {2., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["7", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["12", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 4.}, 0.2], 
         InsetBox["15", {3., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["19", {1., 1.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{
  3.8515268418720284`*^9, {3.851526944437767*^9, 3.851526952325642*^9}, 
   3.851526983965098*^9, 3.851527132293955*^9, {3.851527204047977*^9, 
   3.851527274102982*^9}},
 CellLabel->
  "Out[814]=",ExpressionUUID->"708bba74-1316-459d-909b-d8e823244a48"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"graph", "[", "18", "]"}], "=", 
   RowBox[{"Graph", "[", 
    RowBox[{
     RowBox[{"{", "18", "}"}], ",", 
     RowBox[{"{", "}"}], ",", "  ", 
     RowBox[{"VertexLabels", "\[Rule]", 
      RowBox[{"Placed", "[", 
       RowBox[{"\"\<Name\>\"", ",", "Center"}], "]"}]}], ",", 
     RowBox[{"VertexSize", "\[Rule]", "0.4"}], ",", "\[IndentingNewLine]", 
     RowBox[{"VertexStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"White", ",", 
        RowBox[{"EdgeForm", "[", 
         RowBox[{"{", 
          RowBox[{"Thick", ",", "Red", ",", 
           RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "50"}], ",", 
     RowBox[{"GraphLayout", "\[Rule]", "Automatic"}]}], "]"}]}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.8515326449829617`*^9, 3.8515326765429993`*^9}, {
  3.85153272006429*^9, 3.851532760264379*^9}},
 CellLabel->
  "In[875]:=",ExpressionUUID->"28d3e2e4-7a5c-448f-8595-d5a87edcf654"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{18}, {}, {GraphLayout -> Automatic, ImageSize -> 50, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{{}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], DiskBox[{0., 0.}, 0.2], InsetBox["18", {0., 0.},
         BaseStyle->"Graphics"]}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->50,
  PlotRangePadding->0.1]], "Output",
 CellChangeTimes->{
  3.851532677974543*^9, {3.851532723496084*^9, 3.85153276230862*^9}},
 CellLabel->
  "Out[875]=",ExpressionUUID->"80f5de0f-9601-4e21-98b5-e434382f3ca7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g19", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{"graph", "[", "19", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851527349457924*^9, 3.851527353505528*^9}, {
  3.851527392355768*^9, 3.851527408857911*^9}},
 CellLabel->
  "In[818]:=",ExpressionUUID->"1f3570e7-61a4-4d99-af98-a09beea78757"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 3, 8, 15, 16, 18, 20, 2, 4, 5, 6, 14, 7, 9, 10, 11, 12, 13, 
      17}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 4, 5, 6, 7, 7, 7, 7, 9, 10, 11, 15, 15, 17, 19, 20, 21, 23, 
          26, 29}, {{3}, {4}, {5}, {6}, {7}, {7}, {2}, {2}, {3}, {7}, {2}, {
          4}, {5}, {6}, {12}, {1}, {12}, {2}, {3}, {14}, {12}, {2}, {3}, {
          4}, {5}, {12}, {4}, {5}, {6}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, ImageSize -> 600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQo4HIy9Xqb/mnho/0ll7eKvc9gdwpsP7nssdGV/
x6wk3Yea7A4xvsYXbuo92G+Zskzv8DI2h7lfC3O2iTzff6/hW9lsYTaHol0y
W9h3v9tf9iGILauA1eH12ZmXn034vJ9l8+47entZHJ753FZqUfmxv+WEwa+X
P5kdtG5dOh4t8Xf/T4NNcbPVmB3uWDk8NDNjPJD4xp7L2ZnJYVLTeY2tfUwH
jFyF1CfvZ3R4VFw759pk5gPv3TrnfTNldDjJ52Uz25XlwIyPSwpylzE4uAWb
cjAvYTmg5Zo697sAg0O0oz0D33qWAwHNUzy1Xv+zZ7+ZrrInjeWA0rnlvD0r
/tr7SK0v4T3NfOBEFku7SNQfe3VW0Y+Md5gOuEeu2nr4/y/7mWDAeGAWmP5p
f+7G0dfzzRkOnAfTP+yftbueOnD57/7Ph5VSH7z8Zs+zLYF7W8Lv/ezRG1ij
N3y157G5O0te7Od+9nl5Z/m7v9i/ktxd8ffzt/1fe2L3/Kv8bL/U/9cS/19f
9l9SrwWiT/Zg5Zqf94OVT/lov+HQnBcBDR/3RyT6lWgc+GAPiacP+6G0PQDs
EdbM
         "]], 0.2], ArrowBox[{{0., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{0., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{3., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-2., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{-2., 1.}, {-1., 0.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{2., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[{{2., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{2., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{2., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{0., 4.}, {0., 3.}}, 0.2], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQoEHOKKnwiEvz9pb5i3Z7HTDH6HFVXs3E6yd+21
jyx/LyrO71D28P7hRIsX9q8YDz2urOFzmHtk2f/uPR/tc9S5G/JO8DqERD27
najxw36bSfORz794HG5tXFe2Kf6//TFNrY2cIjwOs57+f263kdlhJhuD2wZh
bgeDy28+J0pwOJicZml+/pPTYYOiXLzTUx6HKeUWGeuPcThkaXG38PXwOuTe
T/G+P4nDoapHQtZans+BpTXi1R5/Dod77m5aJ+bxOURmCLt6/GV3mBQzZfVW
Ln6HrM6p0Y2z2R1mn2JayJzM72D24p5uhha7w/eJE7k2Led3ONjyfveflWwO
yzc5vDhwg9+BI/44q70Um8MqHQErg2/8Djzladz61awOsHA5AwYscH7am0df
z0sj+L8SJxp9KGF2YITyW3RvNOneYILLs/hvf9buiuBXHdOL+7+HEc5/Ndnu
5WQ7BB+s/BQDnL/GQN1KJAHBh0aYAwBiBZfK
         "]], 0.2], 
        ArrowBox[{{5., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{5., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{6., 3.}, {5., 2.}}, 0.2], 
        ArrowBox[{{5., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{3., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[{{3., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{3., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 3.}, 0.2], InsetBox["1", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["3", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["8", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.2], 
         InsetBox["15", {3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["16", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["18", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 0.}, 0.2], 
         InsetBox["20", {-1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.2], 
         InsetBox["2", {-2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 1.}, 0.2], 
         InsetBox["4", {-2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["5", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["6", {2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 2.}, 0.2], 
         InsetBox["14", {4., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 4.}, 0.2], 
         InsetBox["7", {0., 4.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 2.}, 0.2], 
         InsetBox["9", {5., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{6., 3.}, 0.2], 
         InsetBox["10", {6., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{5., 3.}, 0.2], 
         InsetBox["11", {5., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["12", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.2], 
         InsetBox["13", {3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["17", {1., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{3.851527354717345*^9, 3.851527396765345*^9, 
  3.851527436248436*^9},
 CellLabel->
  "Out[818]=",ExpressionUUID->"5e914a99-02e5-45f6-ba95-5f4a626eb025"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g19a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g19", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"7", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "3"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"11", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "3"}]}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"11", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.851527534435031*^9, 3.851527642578991*^9}, {
  3.851527698020265*^9, 3.851527755963395*^9}, {3.8515300142699747`*^9, 
  3.8515301196365957`*^9}, {3.851530185117819*^9, 3.85153019380476*^9}, {
  3.851530245470202*^9, 3.851530255045088*^9}, {3.851530311614337*^9, 
  3.851530352278698*^9}, {3.851530434855385*^9, 3.8515304390775747`*^9}, {
  3.851530477183758*^9, 3.851530487749712*^9}, {3.851530544503541*^9, 
  3.851530563727618*^9}, {3.851530700487846*^9, 3.8515307300640287`*^9}},
 CellLabel->
  "In[842]:=",ExpressionUUID->"c0a24fcb-a15d-49ce-9213-258c33d5c83e"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 3, 8, 15, 16, 18, 20, 2, 4, 5, 6, 14, 7, 9, 10, 11, 12, 13, 
      17}, {
       SparseArray[
       Automatic, {19, 19}, 0, {
        1, {{0, 4, 5, 6, 7, 7, 7, 7, 9, 10, 11, 15, 15, 17, 19, 20, 21, 23, 
          26, 29}, {{3}, {4}, {5}, {6}, {7}, {7}, {2}, {2}, {3}, {7}, {2}, {
          4}, {5}, {6}, {12}, {1}, {12}, {2}, {3}, {14}, {12}, {2}, {3}, {
          4}, {5}, {12}, {4}, {5}, {6}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, GraphLayout -> {"Dimension" -> 2}, ImageSize -> 600, 
       VertexCoordinates -> {{0, 3.}, {0, 1.}, {-1., 1.}, {3., 2.}, {2., 
         2.}, {1., 2.}, {0., 0}, {1., 0.}, {-1., 0.}, {0, 2.}, {2., 3.}, {4., 
         2.}, {1, 1.}, {2., 0.}, {3., 0.}, {3., 3.}, {-1., 2.}, {2., 1.}, {1.,
          3.}}, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 3.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{0., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{0., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{-1., 1.}, {0., 0.}}, 0.2], 
        ArrowBox[{{3., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{1., 0.}, {0., 1.}}, 0.2], 
        ArrowBox[{{1., 0.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{-1., 0.}, {0., 0.}}, 0.2], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{2., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[{{2., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{2., 3.}, {1., 2.}}, 0.2], 
        ArrowBox[{{2., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{1., 1.}, {0., 3.}}, 0.2], 
        ArrowBox[{{1., 1.}, {4., 2.}}, 0.2], 
        ArrowBox[{{2., 0.}, {0., 1.}}, 0.2], 
        ArrowBox[{{2., 0.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{3., 0.}, {2., 0.}}, 0.2], 
        ArrowBox[{{3., 3.}, {4., 2.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {0., 1.}}, 0.2], 
        ArrowBox[{{-1., 2.}, {-1., 1.}}, 0.2], 
        ArrowBox[{{2., 1.}, {3., 2.}}, 0.2], 
        ArrowBox[{{2., 1.}, {2., 2.}}, 0.2], 
        ArrowBox[{{2., 1.}, {4., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {3., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {2., 2.}}, 0.2], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.2]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{0., 3.}, 0.2], InsetBox["1", {0., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.2], 
         InsetBox["3", {0., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.2], 
         InsetBox["8", {-1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.2], 
         InsetBox["15", {3., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.2], 
         InsetBox["16", {2., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.2], 
         InsetBox["18", {1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.2], 
         InsetBox["20", {0., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 0.}, 0.2], 
         InsetBox["2", {1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 0.}, 0.2], 
         InsetBox["4", {-1., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.2], 
         InsetBox["5", {0., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.2], 
         InsetBox["6", {2., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{4., 2.}, 0.2], 
         InsetBox["14", {4., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.2], 
         InsetBox["7", {1., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 0.}, 0.2], 
         InsetBox["9", {2., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 0.}, 0.2], 
         InsetBox["10", {3., 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.2], 
         InsetBox["11", {3., 3.},
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 2.}, 0.2], 
         InsetBox["12", {-1., 2.},
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.2], 
         InsetBox["13", {2., 1.},
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.2], 
         InsetBox["17", {1., 3.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{
  3.851530565173237*^9, {3.8515307024801607`*^9, 3.851530731047172*^9}},
 CellLabel->
  "Out[842]=",ExpressionUUID->"fad62c40-3bc6-4519-b793-68f7528c0eb2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g20", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"graph", "[", "20", "]"}], ",", 
    RowBox[{"GraphLayout", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<LayeredDigraphEmbedding\>\"", ",", 
       RowBox[{"\"\<Orientation\>\"", "\[Rule]", "Left"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.851530810183509*^9, 3.851530842868248*^9}},
 CellLabel->
  "In[845]:=",ExpressionUUID->"8a0dae7e-b3de-48f6-ab37-aacd78edba56"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 6, 7, 13, 16, 19, 2, 5, 12, 17, 3, 9, 10, 15, 8, 11, 14}, {
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 3, 3, 6, 9, 11, 11, 11, 15, 16, 18, 19, 21, 22, 23, 25, 26, 
          27, 28}, {{3}, {4}, {5}, {2}, {6}, {7}, {2}, {6}, {7}, {2}, {6}, {
          1}, {9}, {10}, {11}, {2}, {4}, {5}, {5}, {13}, {15}, {14}, {8}, {
          1}, {11}, {13}, {6}, {6}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, 
       GraphLayout -> {
        "Dimension" -> 2, 
         "VertexLayout" -> {
          "LayeredDigraphEmbedding", "Orientation" -> Left}}, ImageSize -> 
       600, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{-1.9999999999999993`, 
         5.3589794058235685`*^-8}, {-0.9999999999999997, 
         2.6794897029117842`*^-8}}, 0.1999999999999999], 
        ArrowBox[{{-1.9999999999999993`, 
         5.3589794058235685`*^-8}, {-0.9999999732051026, 
         1.0000000267948967`}}, 0.1999999999999999], 
        ArrowBox[{{-1.9999999999999993`, 
         5.3589794058235685`*^-8}, {-1.0000000267948967`, \
-0.9999999732051026}}, 0.1999999999999999], 
        ArrowBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 0.}}, 
         0.1999999999999999], 
        ArrowBox[{{-0.9999999999999997, 
         2.6794897029117842`*^-8}, {-2.6794897029117842`*^-8, \
-0.9999999999999997}}, 0.1999999999999999], 
        ArrowBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {
         2.6794897029117842`*^-8, 0.9999999999999997}}, 0.1999999999999999], 
        ArrowBox[{{-0.9999999732051026, 1.0000000267948967`}, {0., 0.}}, 
         0.1999999999999999], 
        ArrowBox[{{-0.9999999732051026, 
         1.0000000267948967`}, {-2.6794897029117842`*^-8, \
-0.9999999999999997}}, 0.1999999999999999], 
        ArrowBox[{{-0.9999999732051026, 1.0000000267948967`}, {
         2.6794897029117842`*^-8, 0.9999999999999997}}, 0.1999999999999999], 
        ArrowBox[{{-1.0000000267948967`, -0.9999999732051026}, {0., 0.}}, 
         0.1999999999999999], 
        ArrowBox[{{-1.0000000267948967`, -0.9999999732051026}, \
{-2.6794897029117842`*^-8, -0.9999999999999997}}, 0.1999999999999999], 
        ArrowBox[{{-2.999999999999999, 
         8.038469108735353*^-8}, {-1.9999999999999993`, 
         5.3589794058235685`*^-8}}, 0.1999999999999999], 
        ArrowBox[{{-2.999999999999999, 
         8.038469108735353*^-8}, {-1.9999999464102052`, 2.0000000535897935`}},
          0.1999999999999999], 
        ArrowBox[{{-2.999999999999999, 
         8.038469108735353*^-8}, {-1.9999999732051024`, 1.0000000535897937`}},
          0.1999999999999999], 
        ArrowBox[{{-2.999999999999999, 
         8.038469108735353*^-8}, {-2.0000000267948965`, -0.9999999464102056}},
          0.1999999999999999], ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQHRM29+P////3nw8xZAdyHVi++tVet/+/f5cyG5i/
//n5hyXZ//bvT7vGBuL36CnI32j6u/+O7CIwP+2kvSlj25/9gp6ZYH7YDj2V
DyW/9ye80Abzw3+/eb3E/9f+479fsoL4WZOqeuTFfu53a14M5vfVXmdNOPF9
/4O6CDD/yB7miLS0b/snvuMA8zvXOjLUsX7dX70qtO/F2//2cWsvV3/a9Xn/
hOwMmUXb/9s77tl56nDbp/3JCl5bdGL/2xvc+vzmY8bH/e9O/ArtuPfPXo+9
6VFN4of95qlVjFut/9mXt50IO/ng3X6rrye2bSr5a79GxrQ/SPvt/l8Vz0ob
O//Y/7vgmTd10ev9ZR8u2SlW/bbPWcz2ZaLbq/1ro/sEJ7n9sjf6vmFKCduz
/ZJnCteWsH2zd1n8XbNV+tH+5f6Bdq3Sn+xd/bemt3Pf3b/yTGRHO/db+8kc
W1ISuq7td1LgrEvoemZfXfTaa+rmC/ulZm2Inbr5gf03ye0mPnzH92eWLPDz
4btu75Ag6OMtsme/KdOCbG+RM/Yv5+otv521cr9l5v7Dt7N22jOgAQCGGNVm

         "]], 0.1999999999999999], 
        ArrowBox[{{-1.9999999732051024`, 
         1.0000000535897937`}, {-0.9999999732051026, 1.0000000267948967`}}, 
         0.1999999999999999], 
        ArrowBox[{{-1.9999999732051024`, 
         1.0000000535897937`}, {-1.0000000267948967`, -0.9999999732051026}}, 
         0.1999999999999999], 
        ArrowBox[{{-2.0000000267948965`, -0.9999999464102056}, \
{-1.0000000267948967`, -0.9999999732051026}}, 0.1999999999999999], 
        ArrowBox[{{-6.000000026794895, -0.9999998392306175}, \
{-4.999999999999998, 1.339744851455892*^-7}}, 0.1999999999999999], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxFzl1IUwEYxvFTgzHP5trc5mbrxiKkYhdljbB2iOJASF/T8qKWbcESxsAJ
woqKYkETl0EMxCVYwSCamlZzmzXyXWXqOLqPBp6yRbUiTZkpSZ1JLN/d7OLh
4Xf3rzzfXGdeTxDE1rXh7zrFrCMIFdTwBx/l84sjH8OhbysxJbiiBh/axbG6
9F0lXHmp7kVTQk1pwKgE8utCwb+X/HXXK5VQvSfehx7st4n3p8uBC472o1so
44E5dzkYLJOP0VrvjVknveYjPwbQ+U8f+KplBeTOyp6gmay52+NRQPU9/VP0
xjly3k0pYN/frmdoa2ag5nZGDrT+sx8dTp9sb2uTwzFfVQBNstx7h0YODbzm
IPp0smfb1aQMGg2BENrHHLpkt8ugaejfMDr3dna8ZZMMbGL6Bbo20qGyRsrg
YtOtcLFHCqnDfkCrCz1SmHmwGin2SOB77uDrYo8Elurb36CFhR4J/OlLjKID
Xl19zrsBCH7FGLrB41zOZsUgOGccR690JO5k9opBEno4ge50qHeyjlKokC5G
0bvt5jjDiGCzRcugpzovczG1CM70tk6iTaLt2l+tQuDC96fQ89O2mxqWhNWe
5zG0hTv+00mT0Kh/FUd/sY2Z8uES2JIKJtAnqOkFN1UCR6u6k+gh0zUXHRUA
W2t9hy6bGdHJjQKYoHak0Bd8XTyCEICaxxb8HxAqc+s=
         "]], 
         0.1999999999999999], 
        ArrowBox[{{-4.999999999999998, 
         1.339744851455892*^-7}, {-3.9999999999999987`, 
         1.0717958811647137`*^-7}}, 0.1999999999999999], 
        ArrowBox[{{-3.9999999999999987`, 
         1.0717958811647137`*^-7}, {-2.999999999999999, 
         8.038469108735353*^-8}}, 0.1999999999999999], 
        ArrowBox[{{-3.000000026794896, -0.9999999196153085}, \
{-1.9999999999999993`, 5.3589794058235685`*^-8}}, 0.1999999999999999], 
        ArrowBox[{{-3.000000026794896, -0.9999999196153085}, \
{-2.0000000267948965`, -0.9999999464102056}}, 0.1999999999999999], 
        ArrowBox[{{-5.999999999999998, 
         1.6076938217470707`*^-7}, {-4.999999999999998, 
         1.339744851455892*^-7}}, 0.1999999999999999], 
        ArrowBox[{{-1.0000000803846907`, -2.999999973205102}, \
{-2.6794897029117842`*^-8, -0.9999999999999997}}, 0.1999999999999999], 
        ArrowBox[{{-1.0000000535897937`, -1.9999999732051024`}, \
{-2.6794897029117842`*^-8, -0.9999999999999997}}, 0.1999999999999999]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {
         DiskBox[{-1.9999999999999993, 5.3589794058235685*^-8}, 
          0.1999999999999999], 
         InsetBox["1", {-1.9999999999999993, 5.3589794058235685*^-8},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.1999999999999999], 
         InsetBox["4", {0., 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999999999997, 2.6794897029117842*^-8}, 
          0.1999999999999999], 
         InsetBox["6", {-0.9999999999999997, 2.6794897029117842*^-8},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999732051026, 1.0000000267948967}, 
          0.1999999999999999], 
         InsetBox["7", {-0.9999999732051026, 1.0000000267948967},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.0000000267948967, -0.9999999732051026}, 
          0.1999999999999999], 
         InsetBox["13", {-1.0000000267948967, -0.9999999732051026},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.6794897029117842*^-8, -0.9999999999999997}, 
          0.1999999999999999], 
         InsetBox["16", {-2.6794897029117842*^-8, -0.9999999999999997},
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.6794897029117842*^-8, 0.9999999999999997}, 
          0.1999999999999999], 
         InsetBox["19", {2.6794897029117842*^-8, 0.9999999999999997},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.999999999999999, 8.038469108735353*^-8}, 
          0.1999999999999999], 
         InsetBox["2", {-2.999999999999999, 8.038469108735353*^-8},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999464102052, 2.0000000535897935}, 
          0.1999999999999999], 
         InsetBox["5", {-1.9999999464102052, 2.0000000535897935},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999732051024, 1.0000000535897937}, 
          0.1999999999999999], 
         InsetBox["12", {-1.9999999732051024, 1.0000000535897937},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.0000000267948965, -0.9999999464102056}, 
          0.1999999999999999], 
         InsetBox["17", {-2.0000000267948965, -0.9999999464102056},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-6.000000026794895, -0.9999998392306175}, 
          0.1999999999999999], 
         InsetBox["3", {-6.000000026794895, -0.9999998392306175},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.999999999999998, 1.339744851455892*^-7}, 
          0.1999999999999999], 
         InsetBox["9", {-4.999999999999998, 1.339744851455892*^-7},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999999999987, 1.0717958811647137*^-7}, 
          0.1999999999999999], 
         InsetBox["10", {-3.9999999999999987, 1.0717958811647137*^-7},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.000000026794896, -0.9999999196153085}, 
          0.1999999999999999], 
         InsetBox["15", {-3.000000026794896, -0.9999999196153085},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-5.999999999999998, 1.6076938217470707*^-7}, 
          0.1999999999999999], 
         InsetBox["8", {-5.999999999999998, 1.6076938217470707*^-7},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.0000000803846907, -2.999999973205102}, 
          0.1999999999999999], 
         InsetBox["11", {-1.0000000803846907, -2.999999973205102},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.0000000535897937, -1.9999999732051024}, 
          0.1999999999999999], 
         InsetBox["14", {-1.0000000535897937, -1.9999999732051024},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{{3.85153081740551*^9, 3.851530843840002*^9}},
 CellLabel->
  "Out[845]=",ExpressionUUID->"ba8935fd-0929-4d76-b372-1791d4aac972"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g20a", "=", 
  RowBox[{"adjustGraph", "[", 
   RowBox[{"g20", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"14", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"11", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"19", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.851530905359954*^9, 3.8515309362877073`*^9}, 
   3.851530995561348*^9, {3.851531054713148*^9, 3.8515311724894743`*^9}, {
   3.851531207905909*^9, 3.851531239056737*^9}, {3.85153127281015*^9, 
   3.851531279305079*^9}, {3.851531331322344*^9, 3.851531334321269*^9}, {
   3.851531385506418*^9, 3.8515314380496492`*^9}},
 CellLabel->
  "In[861]:=",ExpressionUUID->"3cc7687e-616f-4ec6-ab27-66b97d054372"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 6, 7, 13, 16, 19, 2, 5, 12, 17, 3, 9, 10, 15, 8, 11, 14}, {
       SparseArray[
       Automatic, {18, 18}, 0, {
        1, {{0, 3, 3, 6, 9, 11, 11, 11, 15, 16, 18, 19, 21, 22, 23, 25, 26, 
          27, 28}, {{3}, {4}, {5}, {2}, {6}, {7}, {2}, {6}, {7}, {2}, {6}, {
          1}, {9}, {10}, {11}, {2}, {4}, {5}, {5}, {13}, {15}, {14}, {8}, {
          1}, {11}, {13}, {6}, {6}}}, Pattern}], Null}, {EdgeStyle -> {
         GrayLevel[0]}, 
       GraphLayout -> {
        "Dimension" -> 2, 
         "VertexLayout" -> {
          "LayeredDigraphEmbedding", "Orientation" -> Left}}, ImageSize -> 
       600, VertexCoordinates -> {{-1.9999999999999993`, 0}, {0, 
         1}, {-0.9999999999999997, 0}, {-0.9999999732051026, 
         2.000000026794897}, {-1.0000000267948967`, -0.9999999732051026}, {
         0, -0.9999999999999997}, {
         0, 1.9999999999999996`}, {-2.999999999999999, 
          0}, {-2.999999946410205, 
         2.0000000535897935`}, {-1.9999999732051024`, 
         1.0000000535897937`}, {-2.0000000267948965`, -0.9999999464102056}, \
{-4.000000026794895, -0.9999998392306175}, {-3.9999999999999982`, 
          0}, {-2.9999999999999987`, 
          1}, {-3.000000026794896, -0.9999999196153085}, \
{-3.9999999999999982`, 1}, {-8.038469068161191*^-8, 
         2.6794897856063926`*^-8}, {-1.0000000535897937`, 
         1.0000000267948976`}}, VertexLabels -> {
         Placed["Name", Center]}, VertexSize -> {0.4}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[{
            Thickness[Large], 
            RGBColor[1, 0, 0], 
            Opacity[1]}]]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{-1.9999999999999993`, 0.}, {-0.9999999999999997, 0.}}, 
         0.1999999678461236], 
        ArrowBox[{{-1.9999999999999993`, 0.}, {-0.9999999732051026, 
         2.000000026794897}}, 0.1999999678461236], 
        ArrowBox[{{-1.9999999999999993`, 
         0.}, {-1.0000000267948967`, -0.9999999732051026}}, 
         0.1999999678461236], 
        ArrowBox[{{-0.9999999999999997, 0.}, {0., 1.}}, 0.1999999678461236], 
        ArrowBox[{{-0.9999999999999997, 0.}, {0., -0.9999999999999997}}, 
         0.1999999678461236], 
        ArrowBox[{{-0.9999999999999997, 0.}, {0., 1.9999999999999996`}}, 
         0.1999999678461236], 
        ArrowBox[{{-0.9999999732051026, 2.000000026794897}, {0., 1.}}, 
         0.1999999678461236], 
        ArrowBox[{{-0.9999999732051026, 2.000000026794897}, {
         0., -0.9999999999999997}}, 0.1999999678461236], 
        ArrowBox[{{-0.9999999732051026, 2.000000026794897}, {0., 
         1.9999999999999996`}}, 0.1999999678461236], 
        ArrowBox[{{-1.0000000267948967`, -0.9999999732051026}, {0., 1.}}, 
         0.1999999678461236], 
        ArrowBox[{{-1.0000000267948967`, -0.9999999732051026}, {
         0., -0.9999999999999997}}, 0.1999999678461236], 
        ArrowBox[{{-2.999999999999999, 0.}, {-1.9999999999999993`, 0.}}, 
         0.1999999678461236], 
        ArrowBox[{{-2.999999999999999, 0.}, {-2.999999946410205, 
         2.0000000535897935`}}, 0.1999999678461236], 
        ArrowBox[{{-2.999999999999999, 0.}, {-1.9999999732051024`, 
         1.0000000535897937`}}, 0.1999999678461236], 
        ArrowBox[{{-2.999999999999999, 
         0.}, {-2.0000000267948965`, -0.9999999464102056}}, 
         0.1999999678461236], 
        ArrowBox[{{-2.999999946410205, 2.0000000535897935`}, {0., 1.}}, 
         0.1999999678461236], 
        ArrowBox[{{-1.9999999732051024`, 
         1.0000000535897937`}, {-0.9999999732051026, 2.000000026794897}}, 
         0.1999999678461236], 
        ArrowBox[{{-1.9999999732051024`, 
         1.0000000535897937`}, {-1.0000000267948967`, -0.9999999732051026}}, 
         0.1999999678461236], 
        ArrowBox[{{-2.0000000267948965`, -0.9999999464102056}, \
{-1.0000000267948967`, -0.9999999732051026}}, 0.1999999678461236], 
        ArrowBox[{{-4.000000026794895, -0.9999998392306175}, \
{-3.9999999999999982`, 0.}}, 0.1999999678461236], 
        ArrowBox[{{-4.000000026794895, -0.9999998392306175}, \
{-3.000000026794896, -0.9999999196153085}}, 0.1999999678461236], 
        ArrowBox[{{-3.9999999999999982`, 0.}, {-2.9999999999999987`, 1.}}, 
         0.1999999678461236], 
        ArrowBox[{{-2.9999999999999987`, 1.}, {-2.999999999999999, 0.}}, 
         0.1999999678461236], 
        ArrowBox[{{-3.000000026794896, -0.9999999196153085}, \
{-1.9999999999999993`, 0.}}, 0.1999999678461236], 
        ArrowBox[{{-3.000000026794896, -0.9999999196153085}, \
{-2.0000000267948965`, -0.9999999464102056}}, 0.1999999678461236], 
        ArrowBox[{{-3.9999999999999982`, 1.}, {-3.9999999999999982`, 0.}}, 
         0.1999999678461236], 
        ArrowBox[{{-8.038469068161191*^-8, 2.6794897856063926`*^-8}, {
         0., -0.9999999999999997}}, 0.1999999678461236], 
        ArrowBox[{{-1.0000000535897937`, 1.0000000267948976`}, {
         0., -0.9999999999999997}}, 0.1999999678461236]}, 
       {GrayLevel[1], EdgeForm[{RGBColor[1, 0, 0], Opacity[1], Thickness[
        Large]}], {DiskBox[{-1.9999999999999993, 0.}, 0.1999999678461236], 
         InsetBox["1", {-1.9999999999999993, 0.},
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.1999999678461236], 
         InsetBox["4", {0., 1.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999999999997, 0.}, 0.1999999678461236], 
         InsetBox["6", {-0.9999999999999997, 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9999999732051026, 2.000000026794897}, 
          0.1999999678461236], 
         InsetBox["7", {-0.9999999732051026, 2.000000026794897},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.0000000267948967, -0.9999999732051026}, 
          0.1999999678461236], 
         InsetBox["13", {-1.0000000267948967, -0.9999999732051026},
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., -0.9999999999999997}, 0.1999999678461236], 
         InsetBox["16", {0., -0.9999999999999997},
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 1.9999999999999996}, 0.1999999678461236], 
         InsetBox["19", {0., 1.9999999999999996},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.999999999999999, 0.}, 0.1999999678461236], 
         InsetBox["2", {-2.999999999999999, 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.999999946410205, 2.0000000535897935}, 
          0.1999999678461236], 
         InsetBox["5", {-2.999999946410205, 2.0000000535897935},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.9999999732051024, 1.0000000535897937}, 
          0.1999999678461236], 
         InsetBox["12", {-1.9999999732051024, 1.0000000535897937},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.0000000267948965, -0.9999999464102056}, 
          0.1999999678461236], 
         InsetBox["17", {-2.0000000267948965, -0.9999999464102056},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-4.000000026794895, -0.9999998392306175}, 
          0.1999999678461236], 
         InsetBox["3", {-4.000000026794895, -0.9999998392306175},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999999999982, 0.}, 0.1999999678461236], 
         InsetBox["9", {-3.9999999999999982, 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.9999999999999987, 1.}, 0.1999999678461236], 
         InsetBox["10", {-2.9999999999999987, 1.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.000000026794896, -0.9999999196153085}, 
          0.1999999678461236], 
         InsetBox["15", {-3.000000026794896, -0.9999999196153085},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-3.9999999999999982, 1.}, 0.1999999678461236], 
         InsetBox["8", {-3.9999999999999982, 1.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-8.038469068161191*^-8, 2.6794897856063926*^-8}, 
          0.1999999678461236], 
         InsetBox["11", {-8.038469068161191*^-8, 2.6794897856063926*^-8},
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.0000000535897937, 1.0000000267948976}, 
          0.1999999678461236], 
         InsetBox["14", {-1.0000000535897937, 1.0000000267948976},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->600]], "Output",
 CellChangeTimes->{
  3.851531173385717*^9, 3.8515312083426437`*^9, 3.851531240005857*^9, 
   3.8515312802058*^9, 3.8515313348320093`*^9, {3.8515313937183313`*^9, 
   3.851531438535194*^9}},
 CellLabel->
  "Out[861]=",ExpressionUUID->"2e1b0a24-2788-420e-8385-3e4289b0b67a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"chain", "[", 
  RowBox[{"18", ",", "20"}], "]"}]], "Input",
 CellChangeTimes->{{3.851627751908873*^9, 3.851627752284657*^9}},
 CellLabel->
  "In[1291]:=",ExpressionUUID->"40b3b51a-9d39-495d-8085-98bac1025990"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"arcs", "[", "18", "]"}]], "Input",
 CellChangeTimes->{{3.851637744877625*^9, 3.851637748745908*^9}},
 CellLabel->
  "In[1292]:=",ExpressionUUID->"49ed6425-9599-4db7-9759-347050818f2b"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{3.8516377503546953`*^9},
 CellLabel->
  "Out[1292]=",ExpressionUUID->"65c83ede-818b-4414-a4ac-393b772498c3"]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{161, Automatic}, {211, Automatic}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1030, 22, 311, "Text",ExpressionUUID->"7de05383-451a-49af-8d99-6224a72e56d4",
 Evaluatable->False],
Cell[1591, 44, 24953, 705, 1110, "Input",ExpressionUUID->"7b45cf9a-be39-4e62-b0a1-c91685b02596"],
Cell[26547, 751, 925, 19, 115, "Input",ExpressionUUID->"a5219acf-c3f7-47f0-bbf5-31f56fd927dc"],
Cell[27475, 772, 3953, 86, 388, "Input",ExpressionUUID->"d991614d-8b18-4a38-b6c5-cd3968b28cc3"],
Cell[CellGroupData[{
Cell[31453, 862, 1672, 39, 199, "Input",ExpressionUUID->"b5004178-20e9-4046-a664-1a3c2b64875b"],
Cell[CellGroupData[{
Cell[33150, 905, 288, 8, 24, "Print",ExpressionUUID->"5dcc3300-4b73-41a2-a820-88034f6c29c9"],
Cell[33441, 915, 8841, 177, 307, "Print",ExpressionUUID->"0906809b-571c-4fca-9cd4-09543a232a88"],
Cell[42285, 1094, 288, 8, 24, "Print",ExpressionUUID->"be5de69f-3bb0-404c-8361-abb09a752098"],
Cell[42576, 1104, 5946, 125, 374, "Print",ExpressionUUID->"56f9227b-5aed-47ee-a652-98eee769cdc6"],
Cell[48525, 1231, 288, 8, 24, "Print",ExpressionUUID->"f5117968-95ed-4835-bb8c-9b7ed39c4a27"],
Cell[48816, 1241, 8976, 162, 352, "Print",ExpressionUUID->"3782f617-9cf5-46c7-a3f3-6711016e88d6"],
Cell[57795, 1405, 287, 8, 24, "Print",ExpressionUUID->"eb1ba8ed-7a0c-4e3d-a4d7-c3dd4390d73a"],
Cell[58085, 1415, 6170, 128, 744, "Print",ExpressionUUID->"214c9720-6137-417f-ad83-0a526210da28"],
Cell[64258, 1545, 288, 8, 24, "Print",ExpressionUUID->"1f238fe8-d4bb-420d-b2d2-27f09db85a1e"],
Cell[64549, 1555, 8075, 149, 220, "Print",ExpressionUUID->"edb34bfd-4a13-49eb-88d4-7aacbbc4d585"],
Cell[72627, 1706, 290, 8, 24, "Print",ExpressionUUID->"31e505b3-c299-4974-86d4-5c9e42a68f91"],
Cell[72920, 1716, 5080, 108, 738, "Print",ExpressionUUID->"eca80cad-0cec-4a8e-90ec-968284b26f92"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[78049, 1830, 1650, 39, 199, "Input",ExpressionUUID->"6c69d59f-444b-4197-856b-42be96f58597"],
Cell[CellGroupData[{
Cell[79724, 1873, 288, 8, 24, "Print",ExpressionUUID->"59daca50-9571-4483-a08c-f2565f78f44e"],
Cell[80015, 1883, 8468, 169, 443, "Print",ExpressionUUID->"5d36c708-1df3-4ece-bb3f-94d9be9f7331"],
Cell[88486, 2054, 288, 8, 24, "Print",ExpressionUUID->"9264aed5-81ee-4550-84fb-6643a8635e6e"],
Cell[88777, 2064, 5755, 119, 529, "Print",ExpressionUUID->"6ca6732a-c57f-4c26-92ee-e0c6f1019384"],
Cell[94535, 2185, 290, 8, 24, "Print",ExpressionUUID->"bbfda6a1-3723-4a8a-87e1-3c73bc827793"],
Cell[94828, 2195, 7155, 144, 463, "Print",ExpressionUUID->"eb4f25c4-5308-46c0-a31f-296eb3a830ea"],
Cell[101986, 2341, 290, 8, 24, "Print",ExpressionUUID->"c3c794e7-b8b5-4649-8a39-aa43a5232d1a"],
Cell[102279, 2351, 9752, 171, 565, "Print",ExpressionUUID->"74628dc8-f108-49ca-a9c5-fbdd9c3e5952"],
Cell[112034, 2524, 290, 8, 24, "Print",ExpressionUUID->"1f9a121a-c262-4656-be7a-831f6600a971"],
Cell[112327, 2534, 2647, 60, 607, "Print",ExpressionUUID->"0a2865b2-f75a-460e-ba9a-7c4ccf091dec"],
Cell[114977, 2596, 289, 8, 24, "Print",ExpressionUUID->"c4368140-1687-457f-9369-faf81afca959"],
Cell[115269, 2606, 12395, 241, 331, "Print",ExpressionUUID->"567eedfd-6f09-467b-b135-b70e08e10652"],
Cell[127667, 2849, 292, 8, 24, "Print",ExpressionUUID->"41944629-447b-4646-9c11-61b20c725348"],
Cell[127962, 2859, 5642, 117, 714, "Print",ExpressionUUID->"0d01ba15-4a41-4ea8-89f5-6968c4dcb1ff"],
Cell[133607, 2978, 292, 8, 24, "Print",ExpressionUUID->"f5e0eaa0-36fd-423d-ac9c-93ace900cb4c"],
Cell[133902, 2988, 3622, 79, 296, "Print",ExpressionUUID->"6e1ff13b-14a1-40c7-8e99-d0741399c0d3"],
Cell[137527, 3069, 290, 8, 24, "Print",ExpressionUUID->"48e82a0b-a0ce-4e4b-9a0f-3edfc3b7b747"],
Cell[137820, 3079, 6743, 136, 195, "Print",ExpressionUUID->"c71da65c-f41d-493f-be15-46733d9f685b"],
Cell[144566, 3217, 290, 8, 24, "Print",ExpressionUUID->"d09ceae9-50b9-4d3d-bc2e-69374e3e6542"],
Cell[144859, 3227, 4264, 93, 1114, "Print",ExpressionUUID->"b3eab40b-32c3-4385-acfb-9e5b46303488"],
Cell[149126, 3322, 290, 8, 24, "Print",ExpressionUUID->"ed10b791-b896-458e-9639-729bda435528"],
Cell[149419, 3332, 9331, 184, 442, "Print",ExpressionUUID->"24221ff6-879b-4ce8-a390-c3225f0f8a51"],
Cell[158753, 3518, 292, 8, 24, "Print",ExpressionUUID->"cfc27f81-9461-4423-b2c0-9fdcf474ef19"],
Cell[159048, 3528, 665, 18, 278, "Print",ExpressionUUID->"17275983-5c58-4114-966f-154521477832"],
Cell[159716, 3548, 290, 8, 24, "Print",ExpressionUUID->"3b91443d-6d41-412d-933c-31e6a29e9af1"],
Cell[160009, 3558, 5773, 121, 320, "Print",ExpressionUUID->"af445455-3a37-4891-b4d5-4a0c7edd46e9"],
Cell[165785, 3681, 292, 8, 24, "Print",ExpressionUUID->"73886b9c-cdd6-48fd-9f93-1dc236771551"],
Cell[166080, 3691, 5319, 112, 714, "Print",ExpressionUUID->"c85877bc-9345-41e3-9663-94e78247e861"]
}, Open  ]]
}, Open  ]],
Cell[171426, 3807, 2770, 68, 283, "Input",ExpressionUUID->"298e19e3-681d-4c75-bdd3-2517d1b44d6a"],
Cell[CellGroupData[{
Cell[174221, 3879, 266, 6, 30, "Input",ExpressionUUID->"c96e9dcb-d7c2-45f4-bad3-f951151ab19f"],
Cell[174490, 3887, 8842, 176, 316, "Output",ExpressionUUID->"e4243abf-ad9a-48eb-a023-a0a2da9567b2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[183369, 4068, 1228, 37, 52, "Input",ExpressionUUID->"05367271-2e22-4c60-b868-35d33f633f70"],
Cell[184600, 4107, 5324, 113, 346, "Output",ExpressionUUID->"29879111-6f53-462d-9b37-1813ac125023"]
}, Open  ]],
Cell[CellGroupData[{
Cell[189961, 4225, 264, 6, 30, "Input",ExpressionUUID->"b2cc8906-d04c-47b1-836e-d5d29f8c6ed6"],
Cell[190228, 4233, 5924, 124, 383, "Output",ExpressionUUID->"2498d54e-4e45-4388-81e6-f57353ad3404"]
}, Open  ]],
Cell[CellGroupData[{
Cell[196189, 4362, 623, 19, 30, "Input",ExpressionUUID->"92fd3efd-ec59-4bf5-8dd2-b3c4a645aa59"],
Cell[196815, 4383, 5362, 113, 305, "Output",ExpressionUUID->"7016f76c-0ede-43a1-895f-07438d1c187b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[202214, 4501, 366, 9, 30, "Input",ExpressionUUID->"a0dc2b5e-5f35-457d-a248-f76c85a26318"],
Cell[202583, 4512, 5295, 112, 647, "Output",ExpressionUUID->"8635a5e3-3899-40f4-871d-003775178aa0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[207915, 4629, 1169, 36, 52, "Input",ExpressionUUID->"06e05144-52b1-4fbe-9b4c-07cbbc068799"],
Cell[209087, 4667, 5109, 109, 485, "Output",ExpressionUUID->"38008314-4f7e-4429-9c35-6149b02b8a3e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[214233, 4781, 526, 13, 30, "Input",ExpressionUUID->"b32ad23b-444c-427b-84ef-9ebc9fa04191"],
Cell[214762, 4796, 11021, 218, 505, "Output",ExpressionUUID->"47e1926e-f668-4fe5-b49a-097043058248"]
}, Open  ]],
Cell[CellGroupData[{
Cell[225820, 5019, 2503, 77, 94, "Input",ExpressionUUID->"76f250c2-dc9b-4b6f-a19e-193278e64aa2"],
Cell[228326, 5098, 9739, 194, 403, "Output",ExpressionUUID->"3d591962-43ac-41b3-8f54-51721023fd2c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[238102, 5297, 471, 12, 30, "Input",ExpressionUUID->"5f76d6c7-8cf1-4925-a992-f21311d2ff88"],
Cell[238576, 5311, 5095, 108, 526, "Output",ExpressionUUID->"07606e2a-b92d-4ca1-8542-50896f211c77"]
}, Open  ]],
Cell[CellGroupData[{
Cell[243708, 5424, 1746, 52, 73, "Input",ExpressionUUID->"74a03566-7770-46c5-8e3f-5ef45099eda6"],
Cell[245457, 5478, 4876, 104, 485, "Output",ExpressionUUID->"9b9c4193-44fc-44d5-888b-c02b8c19f236"]
}, Open  ]],
Cell[CellGroupData[{
Cell[250370, 5587, 472, 12, 30, "Input",ExpressionUUID->"731a46e5-e099-4a07-9190-acd05935e733"],
Cell[250845, 5601, 9398, 188, 510, "Output",ExpressionUUID->"09640b12-6ed5-4102-8550-057d72a8f0cc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[260280, 5794, 674, 21, 30, "Input",ExpressionUUID->"c1e537db-56ba-4f56-994c-3d163015d9a5"],
Cell[260957, 5817, 9074, 183, 403, "Output",ExpressionUUID->"0c100929-d39a-4432-a32a-d9ef7f912e48"]
}, Open  ]],
Cell[CellGroupData[{
Cell[270068, 6005, 263, 6, 30, "Input",ExpressionUUID->"dab4f72f-1ef7-4523-8f86-9e071bf1ecd6"],
Cell[270334, 6013, 8444, 168, 452, "Output",ExpressionUUID->"7eeeb03d-8fcc-4852-8944-9726aa1dbaba"]
}, Open  ]],
Cell[CellGroupData[{
Cell[278815, 6186, 1875, 57, 73, "Input",ExpressionUUID->"78b149c4-66c2-4f45-83f8-058bbcbeb181"],
Cell[280693, 6245, 5377, 112, 616, "Output",ExpressionUUID->"f5ef8577-986c-4a5e-8d20-630fc85d70a5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[286107, 6362, 264, 6, 30, "Input",ExpressionUUID->"dba2ab7a-f1dc-43f7-8f2c-007a547e776e"],
Cell[286374, 6370, 5735, 118, 538, "Output",ExpressionUUID->"578f414a-2e2a-4fb4-822e-00f4b550a268"]
}, Open  ]],
Cell[CellGroupData[{
Cell[292146, 6493, 1822, 54, 52, "Input",ExpressionUUID->"74225860-5af1-4167-8cd6-375533efe11d"],
Cell[293971, 6549, 4542, 95, 403, "Output",ExpressionUUID->"cb15adfa-2a78-4d51-a52a-3e8d224ddd59"]
}, Open  ]],
Cell[CellGroupData[{
Cell[298550, 6649, 523, 13, 30, "Input",ExpressionUUID->"9d6d87be-2209-437b-877c-8cd788c05081"],
Cell[299076, 6664, 12106, 228, 808, "Output",ExpressionUUID->"895ed863-5932-4091-85eb-a89c1183ff74"]
}, Open  ]],
Cell[CellGroupData[{
Cell[311219, 6897, 1522, 44, 52, "Input",ExpressionUUID->"d02f52d0-3ac0-4eb2-816f-8e99b573921a"],
Cell[312744, 6943, 9564, 181, 485, "Output",ExpressionUUID->"01e3c9ec-9673-4c9a-8f45-b5240be186e3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[322345, 7129, 473, 12, 30, "Input",ExpressionUUID->"32713679-41ce-4e8d-adf9-895999987a1c"],
Cell[322821, 7143, 7049, 145, 342, "Output",ExpressionUUID->"47ff1fe0-af5f-4ead-a5da-0ed05b685d07"]
}, Open  ]],
Cell[CellGroupData[{
Cell[329907, 7293, 1228, 38, 52, "Input",ExpressionUUID->"d28fb436-84e3-42f1-a2d9-4044faf91f19"],
Cell[331138, 7333, 5466, 117, 403, "Output",ExpressionUUID->"0cab43d1-11c5-4101-8eba-6cdc0f4816ff"]
}, Open  ]],
Cell[CellGroupData[{
Cell[336641, 7455, 265, 6, 30, "Input",ExpressionUUID->"ab372597-5c2f-4cd8-9463-f44e2e08e1ce"],
Cell[336909, 7463, 2627, 59, 616, "Output",ExpressionUUID->"e7eb0dbc-4117-4349-b72a-8ba5ddfc70a7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[339573, 7527, 450, 13, 30, "Input",ExpressionUUID->"8595a656-4667-4b86-b7f9-a9f012205b9e"],
Cell[340026, 7542, 2798, 61, 447, "Output",ExpressionUUID->"8193bec6-4ca5-4f59-8119-0a1937602043"]
}, Open  ]],
Cell[CellGroupData[{
Cell[342861, 7608, 266, 6, 30, "Input",ExpressionUUID->"80295f0c-c48f-4041-9439-10c85afa88e6"],
Cell[343130, 7616, 12399, 240, 340, "Output",ExpressionUUID->"4d91668e-bf9b-4ca2-9189-8b21a11b9be9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[355566, 7861, 2559, 80, 73, "Input",ExpressionUUID->"bc92e87f-1453-4767-be06-72bd987c7c41"],
Cell[358128, 7943, 5523, 117, 403, "Output",ExpressionUUID->"46ce6029-744a-49b9-a178-620f04a74b37"]
}, Open  ]],
Cell[CellGroupData[{
Cell[363688, 8065, 527, 13, 30, "Input",ExpressionUUID->"0dc0dd90-e782-4056-8127-560c813bfa62"],
Cell[364218, 8080, 10924, 215, 526, "Output",ExpressionUUID->"dbb2b02b-4fd9-4d8e-a9af-347dbe55ad95"]
}, Open  ]],
Cell[CellGroupData[{
Cell[375179, 8300, 1302, 41, 52, "Input",ExpressionUUID->"829dd464-68f8-4602-8cf2-5313c4572041"],
Cell[376484, 8343, 9878, 197, 616, "Output",ExpressionUUID->"148e6193-7618-402a-b405-0dc000d50419"]
}, Open  ]],
Cell[CellGroupData[{
Cell[386399, 8545, 266, 6, 30, "Input",ExpressionUUID->"f6719683-9884-4672-bd0d-789e56441844"],
Cell[386668, 8553, 3600, 78, 305, "Output",ExpressionUUID->"ea94c162-5795-49f4-87a7-bd7376c42f47"]
}, Open  ]],
Cell[CellGroupData[{
Cell[390305, 8636, 896, 27, 30, "Input",ExpressionUUID->"30b415fc-4aa7-48b3-a111-bc5b48982a90"],
Cell[391204, 8665, 3933, 83, 485, "Output",ExpressionUUID->"39264bb6-ebc7-41ea-a1f1-5f22dcf103ee"]
}, Open  ]],
Cell[CellGroupData[{
Cell[395174, 8753, 267, 6, 30, "Input",ExpressionUUID->"3cf69406-a80e-47f2-aee2-187938e5fbe4"],
Cell[395444, 8761, 6723, 135, 204, "Output",ExpressionUUID->"5d9d7a31-8f7c-4b75-8a92-82fcabe1417f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[402204, 8901, 2476, 71, 73, "Input",ExpressionUUID->"f374c1f1-dd13-445b-8150-4c62c42c676c"],
Cell[404683, 8974, 5676, 102, 482, "Output",ExpressionUUID->"965c77e2-f87d-4c33-86b9-1e2afaf5bc9c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[410396, 9081, 523, 13, 30, "Input",ExpressionUUID->"27155c11-045b-4bb5-9799-6462aba1ac4f"],
Cell[410922, 9096, 8369, 169, 346, "Output",ExpressionUUID->"9fdb60ca-e0a1-4660-a8a5-fa010e7b3b32"]
}, Open  ]],
Cell[CellGroupData[{
Cell[419328, 9270, 1378, 44, 52, "Input",ExpressionUUID->"52184336-97bc-4e98-bd53-acbca373a93f"],
Cell[420709, 9316, 7811, 159, 485, "Output",ExpressionUUID->"44507d10-7be2-4059-ad8e-e4ddb8451500"]
}, Open  ]],
Cell[CellGroupData[{
Cell[428557, 9480, 266, 6, 30, "Input",ExpressionUUID->"e966ec33-8066-432b-9eec-b77c90ca1ad4"],
Cell[428826, 9488, 9309, 183, 451, "Output",ExpressionUUID->"c853eb91-f843-4548-8071-f38f76e92792"]
}, Open  ]],
Cell[CellGroupData[{
Cell[438172, 9676, 2349, 70, 73, "Input",ExpressionUUID->"e63b1e64-fd2f-4a1e-8fc3-327970a8e5f7"],
Cell[440524, 9748, 5210, 111, 403, "Output",ExpressionUUID->"708bba74-1316-459d-909b-d8e823244a48"]
}, Open  ]],
Cell[CellGroupData[{
Cell[445771, 9864, 1041, 25, 94, "Input",ExpressionUUID->"28d3e2e4-7a5c-448f-8595-d5a87edcf654"],
Cell[446815, 9891, 1102, 27, 67, "Output",ExpressionUUID->"80f5de0f-9601-4e21-98b5-e434382f3ca7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[447954, 9923, 315, 7, 30, "Input",ExpressionUUID->"1f3570e7-61a4-4d99-af98-a09beea78757"],
Cell[448272, 9932, 5798, 121, 329, "Output",ExpressionUUID->"5e914a99-02e5-45f6-ba95-5f4a626eb025"]
}, Open  ]],
Cell[CellGroupData[{
Cell[454107, 10058, 2192, 62, 73, "Input",ExpressionUUID->"c0a24fcb-a15d-49ce-9213-258c33d5c83e"],
Cell[456302, 10122, 4895, 104, 403, "Output",ExpressionUUID->"fad62c40-3bc6-4519-b793-68f7528c0eb2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[461234, 10231, 474, 12, 30, "Input",ExpressionUUID->"8a0dae7e-b3de-48f6-ab37-aacd78edba56"],
Cell[461711, 10245, 10274, 200, 526, "Output",ExpressionUUID->"ba8935fd-0929-4d76-b372-1791d4aac972"]
}, Open  ]],
Cell[CellGroupData[{
Cell[472022, 10450, 1871, 55, 52, "Input",ExpressionUUID->"3cc7687e-616f-4ec6-ab27-66b97d054372"],
Cell[473896, 10507, 8874, 173, 485, "Output",ExpressionUUID->"2e1b0a24-2788-420e-8385-3e4289b0b67a"]
}, Open  ]],
Cell[482785, 10683, 233, 5, 30, "Input",ExpressionUUID->"40b3b51a-9d39-495d-8085-98bac1025990"],
Cell[CellGroupData[{
Cell[483043, 10692, 208, 4, 30, "Input",ExpressionUUID->"49ed6425-9599-4db7-9759-347050818f2b"],
Cell[483254, 10698, 173, 4, 34, "Output",ExpressionUUID->"65c83ede-818b-4414-a4ac-393b772498c3"]
}, Open  ]]
}
]
*)

