(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     39424,       1112]
NotebookOptionsPosition[     37487,       1071]
NotebookOutlinePosition[     37825,       1086]
CellTagsIndexPosition[     37782,       1083]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
This Notebook contains the proofs of all the results in the paper
\"Inequalities For Distances Between Triangle Centers\" by Stanley \
Rabinowitz,
submitted to the International Journal of Computer Discovered Mathematics 
(http : // www.journal - 1. eu/) on Jan. 2022.
 
This Notebook is Copyright \[Copyright] January 2022 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and is published with open access. This \
Notebook is distributed under the terms of the Creative Commons Attribution \
License which permits any use, distribution, and reproduction in any medium, \
provided the original author and the source are credited.\
\>", "Text",
 Evaluatable->False,
 CellChangeTimes->{{3.8517106718981447`*^9, 3.851710701258429*^9}, {
  3.851710753497129*^9, 3.8517107921354513`*^9}},
 FormatType->
  "TextForm",ExpressionUUID->"99588e8c-db7c-4ca5-af07-491a7561ebdc"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "find", " ", "pairs", " ", "of", " ", "centers", " ", "with", " ", "equal", 
   " ", "distances", " ", "between", " ", "them"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.8514195520537443`*^9, 3.851419582773403*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"a2f91b4f-5ee7-4a0f-95c0-a5da3f8b7d73"],

Cell[CellGroupData[{

Cell["Proof of Property 2", "Title",
 CellChangeTimes->{{3.8517108206246357`*^9, 
  3.851710833958391*^9}},ExpressionUUID->"550c9597-0177-4ad3-a58f-\
204501848544"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ETC1", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"X1", ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X2", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X3", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X4", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"X5", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["b", "4"], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ",", 
          RowBox[{
           SuperscriptBox["a", "4"], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ",", 
          RowBox[{
           SuperscriptBox["a", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["b", "4"], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X6", ",", 
        RowBox[{"{", 
         RowBox[{
          SuperscriptBox["a", "2"], ",", 
          SuperscriptBox["b", "2"], ",", 
          SuperscriptBox["c", "2"]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X7", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "+", "c"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}]}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X8", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", "-", "b", "-", "c"}], ",", 
          RowBox[{
           RowBox[{"-", "a"}], "+", "b", "-", "c"}], ",", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "b", "+", "c"}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X9", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "-", "c"}], ")"}]}], ",", 
          RowBox[{"b", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "-", "c"}], ")"}]}], ",", 
          RowBox[{"c", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "-", "b", "+", "c"}], ")"}]}]}], "}"}]}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X10", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"b", "+", "c"}], ",", 
          RowBox[{"a", "+", "c"}], ",", 
          RowBox[{"a", "+", "b"}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X11", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "a"}], "+", "c"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "+", "c"}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "-", "b"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}]}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"X12", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"b", "+", "c"}], ")"}], "2"]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "+", "c"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "+", "b"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}]}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X13", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "+", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "+", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], "2"]}], "+", 
           SuperscriptBox["c", "4"], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "+", 
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"X14", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "+", 
              SuperscriptBox["c", "2"], "-", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "+", 
              SuperscriptBox["c", "2"], "-", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], "2"]}], "+", 
           SuperscriptBox["c", "4"], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "+", 
              SuperscriptBox["b", "2"], "-", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X15", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["a", "2"], "-", 
                SuperscriptBox["b", "2"], "-", 
                SuperscriptBox["c", "2"]}], ")"}]}], "-", 
             RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["b", "2"], "-", 
                SuperscriptBox["c", "2"], "-", 
                SuperscriptBox["a", "2"]}], ")"}]}], "-", 
             RowBox[{"2", " ", "S"}]}], ")"}]}], "\[InvisibleSpace]", ",", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["c", "2"], "-", 
                SuperscriptBox["a", "2"], "-", 
                SuperscriptBox["b", "2"]}], ")"}]}], "-", 
             RowBox[{"2", " ", "S"}]}], ")"}]}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"X16", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["a", "2"], "-", 
                SuperscriptBox["b", "2"], "-", 
                SuperscriptBox["c", "2"]}], ")"}]}], "+", 
             RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["b", "2"], "-", 
                SuperscriptBox["c", "2"], "-", 
                SuperscriptBox["a", "2"]}], ")"}]}], "+", 
             RowBox[{"2", " ", "S"}]}], ")"}]}], "\[InvisibleSpace]", ",", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["c", "2"], "-", 
                SuperscriptBox["a", "2"], "-", 
                SuperscriptBox["b", "2"]}], ")"}]}], "+", 
             RowBox[{"2", " ", "S"}]}], ")"}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X17", ",", 
        FormBox[
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "+", 
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "-", 
              SuperscriptBox["b", "2"], "+", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "+", 
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["a", "2"]}], "+", 
              SuperscriptBox["b", "2"], "+", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["a", "2"], "-", 
              SuperscriptBox["b", "2"], "+", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["a", "2"]}], "+", 
              SuperscriptBox["b", "2"], "+", 
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], "}"}],
         TraditionalForm]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"X18", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", 
              SqrtBox["3"], "S"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "S"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", 
              SqrtBox["3"], "S"}]}], ")"}]}], "\[InvisibleSpace]", ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "S"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "S"}]}], ")"}]}]}], "\[InvisibleSpace]", 
         "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"X19", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], ",", 
          RowBox[{"b", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], ",", 
          RowBox[{"c", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"X20", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["a", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "4"]}], ",", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "4"]}], ",", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}]}], "}"}]}], "}"}]}], 
     "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", 
     RowBox[{"i", "\[LessEqual]", "20"}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "i", "]"}], "=", 
       RowBox[{"ETC1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}]}], ";"}]}], 
    "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "to", " ", "find", " ", "the", " ", "distance", " ", 
    "between", " ", "two", " ", "points", " ", "given", " ", "in", " ", 
    "Barycentric", " ", "coordinates"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"normed", "[", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_", ",", "z_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], "/", 
    RowBox[{"(", 
     RowBox[{"x", "+", "y", "+", "z"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"squaredDistance", "[", 
    RowBox[{"p1_", ",", "p2_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Total", "[", "p2", "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{"Return", "[", "Infinity", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], "=", 
       RowBox[{
        RowBox[{"normed", "[", "p1", "]"}], "-", 
        RowBox[{"normed", "[", "p2", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"a", "^", "2"}]}], "*", "y", "*", "z"}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", "z", "*", "x"}], "-", 
        RowBox[{
         RowBox[{"c", "^", "2"}], "*", "x", "*", "y"}]}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8273470407215*^9, 3.827347044608625*^9}, {
   3.82734774268469*^9, 3.827347843091484*^9}, {3.82734787805133*^9, 
   3.8273480057689247`*^9}, 3.827348096913745*^9, {3.851275935729549*^9, 
   3.851276047174993*^9}, {3.8517109288529043`*^9, 3.851710929953208*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"aac07b70-9918-4e91-afe9-c7dc1abc8909"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"find", " ", "all", " ", "distances"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.851419616598536*^9, 3.851419622997382*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"c6b9f4f9-8399-4ae6-adf8-4f696a33c778"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mmax", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"removeS", "=", 
   RowBox[{"S", "->", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Timing", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"numericVals", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "6"}], ",", 
      RowBox[{"b", "\[Rule]", "9"}], ",", 
      RowBox[{"c", "\[Rule]", "13"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
   RowBox[{"exoticVals", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "Pi"}], ",", 
      RowBox[{"b", "\[Rule]", "E"}], ",", 
      RowBox[{"c", "\[Rule]", 
       RowBox[{"Sqrt", "[", "5", "]"}]}]}], "}"}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", 
     RowBox[{"i", "<=", "mmax"}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"j", "=", 
         RowBox[{"i", "+", "1"}]}], ",", 
        RowBox[{"j", "<=", "mmax"}], ",", 
        RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"p", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "[", "i", "]"}], "/.", "removeS"}], "/.", 
           "numericVals"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"q", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "[", "j", "]"}], "/.", "removeS"}], "/.", 
           "numericVals"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"dist", "[", 
           RowBox[{"i", ",", "j"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{"squaredDistance", "[", 
             RowBox[{"p", ",", "q"}], "]"}], "/.", "numericVals"}], "//", 
           "N"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.8514197582947607`*^9, 3.8514198666145363`*^9}, {
  3.851419903486574*^9, 3.8514199102149563`*^9}, {3.851420038303797*^9, 
  3.851420188760128*^9}, {3.851420256977729*^9, 3.851420299809259*^9}, {
  3.851420415310152*^9, 3.8514204753224382`*^9}, {3.851420544234969*^9, 
  3.851420649219945*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"78cffee8-04f0-4a8e-bbab-ff1f9ac79d31"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.046912`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{
  3.851420190603807*^9, 3.851420301065357*^9, 3.8514203853897038`*^9, {
   3.8514204166993723`*^9, 3.8514204764847107`*^9}, {3.8514206216987143`*^9, 
   3.8514206503529043`*^9}, 3.851710960405246*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"0819e90b-dc65-4153-9508-ac1e881d045e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"form", " ", "pairs"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dist3", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"dist", "[", 
          RowBox[{"i1", ",", "j1"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i1", ",", "j1"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i1", ",", "1", ",", 
         RowBox[{"mmax", "-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j1", ",", 
         RowBox[{"i1", "+", "1"}], ",", "mmax"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "flatten", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dist3a", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"dist3", ",", "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "gather", " ", "together", " ", "the", " ", "ones", " ", "with", " ", 
     "the", " ", "same", " ", "length"}], " ", "*)"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"gat", "=", 
     RowBox[{"Gather", "[", 
      RowBox[{"dist3a", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Chop", "[", 
          RowBox[{
           RowBox[{"#1", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "-", 
           RowBox[{"#2", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "\[Equal]", "0"}], 
        "&"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "select", " ", "ones", " ", "where", " ", "the", " ", "length", " ", 
     "appears", " ", "more", " ", "than", " ", "once"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"sel", "=", 
    RowBox[{"Select", "[", 
     RowBox[{"gat", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "#", "]"}], ">", "1"}], "&"}]}], 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.851420691383954*^9, 3.851420820642331*^9}, {
  3.851420899036706*^9, 3.851420913122888*^9}, {3.8514209803590508`*^9, 
  3.8514209917955112`*^9}, {3.851421045740776*^9, 3.8514210628613377`*^9}, {
  3.851421132496907*^9, 3.85142115262781*^9}, {3.851421203061844*^9, 
  3.8514212054200077`*^9}, {3.8514221243129597`*^9, 3.851422125187154*^9}, {
  3.851422157449827*^9, 3.851422164128551*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"37ad0182-92b1-4135-a35b-6843157cdcee"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.4285714285714284`", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "10"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.4285714285714284`", ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "10"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"209.00401785714286`", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"209.00401785714286`", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "20"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"52.251004464285714`", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "5"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"52.251004464285714`", ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.851422126781023*^9, 3.851422168846882*^9, 
  3.8517109604442587`*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"b52c61c7-41f3-4536-b935-62a02ee201f1"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "Check", " ", "these", " ", "with", " ", "exact", " ", "computations"}], 
  " ", "*)"}]], "Input",
 CellChangeTimes->{{3.851422235578156*^9, 3.8514222513202343`*^9}, 
   3.8514225530098963`*^9},
 CellLabel->"In[14]:=",ExpressionUUID->"ab2f9b4d-6513-4d42-ad34-fd1bd67b17d2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dexact", "[", 
    RowBox[{"1", ",", "10"}], "]"}], "=", 
   RowBox[{
    RowBox[{"squaredDistance", "[", 
     RowBox[{
      RowBox[{"x", "[", "1", "]"}], ",", 
      RowBox[{"x", "[", "10", "]"}]}], "]"}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dexact", "[", 
    RowBox[{"8", ",", "10"}], "]"}], "=", 
   RowBox[{
    RowBox[{"squaredDistance", "[", 
     RowBox[{
      RowBox[{"x", "[", "8", "]"}], ",", 
      RowBox[{"x", "[", "10", "]"}]}], "]"}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dexact", "[", 
    RowBox[{"1", ",", "10"}], "]"}], "-", 
   RowBox[{"dexact", "[", 
    RowBox[{"8", ",", "10"}], "]"}]}], "//", "Simplify"}]}], "Input",
 CellChangeTimes->{{3.85142227042484*^9, 3.851422401816786*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"2f32b5f9-7ef1-4cc8-a389-3e5f379b29ec"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.8514223457127447`*^9, 3.851422403566272*^9}, 
   3.851710960489183*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"70bd7d25-5d93-487a-be3f-24fc6f3467b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dexact", "[", 
    RowBox[{"3", ",", "4"}], "]"}], "=", 
   RowBox[{
    RowBox[{"squaredDistance", "[", 
     RowBox[{
      RowBox[{"x", "[", "3", "]"}], ",", 
      RowBox[{"x", "[", "4", "]"}]}], "]"}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dexact", "[", 
    RowBox[{"3", ",", "20"}], "]"}], "=", 
   RowBox[{
    RowBox[{"squaredDistance", "[", 
     RowBox[{
      RowBox[{"x", "[", "3", "]"}], ",", 
      RowBox[{"x", "[", "20", "]"}]}], "]"}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dexact", "[", 
    RowBox[{"3", ",", "4"}], "]"}], "-", 
   RowBox[{"dexact", "[", 
    RowBox[{"3", ",", "20"}], "]"}]}], "//", "Simplify"}]}], "Input",
 CellChangeTimes->{{3.85142242212962*^9, 3.85142245695284*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"3f43aa7d-b01f-4e8b-a128-889f23a0acd2"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.851422458225481*^9, 3.851710960530409*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"3605bded-0a9e-457a-a09f-92d5955f81f3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dexact", "[", 
    RowBox[{"3", ",", "5"}], "]"}], "=", 
   RowBox[{
    RowBox[{"squaredDistance", "[", 
     RowBox[{
      RowBox[{"x", "[", "3", "]"}], ",", 
      RowBox[{"x", "[", "5", "]"}]}], "]"}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dexact", "[", 
    RowBox[{"4", ",", "5"}], "]"}], "=", 
   RowBox[{
    RowBox[{"squaredDistance", "[", 
     RowBox[{
      RowBox[{"x", "[", "4", "]"}], ",", 
      RowBox[{"x", "[", "5", "]"}]}], "]"}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dexact", "[", 
    RowBox[{"3", ",", "5"}], "]"}], "-", 
   RowBox[{"dexact", "[", 
    RowBox[{"4", ",", "5"}], "]"}]}], "//", "Simplify"}]}], "Input",
 CellChangeTimes->{{3.8514224749135647`*^9, 3.8514224968252296`*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"5b94fb1a-5f69-42f0-bc1a-c8b71762a0c0"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.851422497625113*^9, 3.851710960569414*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"895a99d1-426f-4092-813e-d5e6c0875b43"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{335, Automatic}, {Automatic, 63}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 881, 17, 219, "Text",ExpressionUUID->"99588e8c-db7c-4ca5-af07-491a7561ebdc",
 Evaluatable->False],
Cell[1442, 39, 345, 6, 30, "Input",ExpressionUUID->"a2f91b4f-5ee7-4a0f-95c0-a5da3f8b7d73"],
Cell[CellGroupData[{
Cell[1812, 49, 164, 3, 98, "Title",ExpressionUUID->"550c9597-0177-4ad3-a58f-204501848544"],
Cell[1979, 54, 24639, 694, 1068, "Input",ExpressionUUID->"aac07b70-9918-4e91-afe9-c7dc1abc8909"],
Cell[26621, 750, 251, 4, 30, "Input",ExpressionUUID->"c6b9f4f9-8399-4ae6-adf8-4f696a33c778"],
Cell[CellGroupData[{
Cell[26897, 758, 2752, 74, 300, "Input",ExpressionUUID->"78cffee8-04f0-4a8e-bbab-ff1f9ac79d31"],
Cell[29652, 834, 383, 7, 34, "Output",ExpressionUUID->"0819e90b-dc65-4153-9508-ac1e881d045e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30072, 846, 2405, 63, 178, "Input",ExpressionUUID->"37ad0182-92b1-4135-a35b-6843157cdcee"],
Cell[32480, 911, 1171, 35, 56, "Output",ExpressionUUID->"b52c61c7-41f3-4536-b935-62a02ee201f1"]
}, Open  ]],
Cell[33666, 949, 321, 7, 30, "Input",ExpressionUUID->"ab2f9b4d-6513-4d42-ad34-fd1bd67b17d2"],
Cell[CellGroupData[{
Cell[34012, 960, 942, 28, 73, "Input",ExpressionUUID->"2f32b5f9-7ef1-4cc8-a389-3e5f379b29ec"],
Cell[34957, 990, 201, 3, 34, "Output",ExpressionUUID->"70bd7d25-5d93-487a-be3f-24fc6f3467b9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35195, 998, 938, 28, 73, "Input",ExpressionUUID->"3f43aa7d-b01f-4e8b-a128-889f23a0acd2"],
Cell[36136, 1028, 171, 2, 34, "Output",ExpressionUUID->"3605bded-0a9e-457a-a09f-92d5955f81f3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36344, 1035, 941, 28, 73, "Input",ExpressionUUID->"5b94fb1a-5f69-42f0-bc1a-c8b71762a0c0"],
Cell[37288, 1065, 171, 2, 34, "Output",ExpressionUUID->"895a99d1-426f-4092-813e-d5e6c0875b43"]
}, Open  ]]
}, Open  ]]
}
]
*)

