(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    348881,       9427]
NotebookOptionsPosition[    332020,       9195]
NotebookOutlinePosition[    332360,       9210]
CellTagsIndexPosition[    332317,       9207]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
This Notebook contains the proofs of all the results in the paper
\"Inequalities Derived From Distances Between Triangle Centers\" by Stanley \
Rabinowitz,
submitted to the International Journal of Computer Discovered Mathematics 
(http : // www.journal - 1. eu/) in March 2022.
 
This Notebook is Copyright \[Copyright] March 2022 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and is published with open access. This \
Notebook is distributed under the terms of the Creative Commons Attribution \
License which permits any use, distribution, and reproduction in any medium, \
provided the original author and the source are credited.\
\>", "Text",
 Evaluatable->False,
 CellChangeTimes->{{3.8517106718981447`*^9, 3.851710701258429*^9}, {
   3.851711035640792*^9, 3.851711101569191*^9}, 3.8517113718428907`*^9, {
   3.854099937612275*^9, 3.8540999718038607`*^9}, {3.856473532115179*^9, 
   3.856473571605184*^9}},ExpressionUUID->"ddb836ba-5a27-4f9d-986a-\
06fb645f709a"],

Cell[CellGroupData[{

Cell["Data", "Section",
 CellChangeTimes->{{3.854270562186454*^9, 3.854270570452723*^9}, {
  3.854282919791356*^9, 
  3.854282920310923*^9}},ExpressionUUID->"b2c64fb5-3805-41cc-bbeb-\
51ecbab17a02"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"points", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", " ", 
        SubscriptBox["X", "1"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        SubscriptBox["X", "2"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], ",", 
        SubscriptBox["X", "3"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], ",", 
        SubscriptBox["X", "4"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"]}], "-", 
         SuperscriptBox["b", "4"], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         SuperscriptBox["c", "4"]}], ",", 
        SubscriptBox["X", "5"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "^", "2"}], ",", "  ", 
        SubscriptBox["X", "6"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", "b", "-", "c"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"a", "-", "b", "+", "c"}], ")"}]}], ",", "  ", 
        SubscriptBox["X", "7"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "-", "b", "-", "c"}], ",", "  ", 
        SubscriptBox["X", "8"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"a", "-", "b", "-", "c"}], ")"}]}], ",", "  ", 
        SubscriptBox["X", "9"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"b", "+", "c"}], ",", " ", 
        SubscriptBox["X", "10"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "+", "c", "-", "a"}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", "-", "c"}], ")"}], "2"]}], ",", " ", 
        SubscriptBox["X", "11"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", "+", "c"}], ")"}], "2"]}], ",", " ", 
        SubscriptBox["X", "12"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["a", "4"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"]}], "-", 
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         SuperscriptBox["c", "4"]}], ",", " ", 
        SubscriptBox["X", "20"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", " ", 
        SubscriptBox["X", "21"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "^", "3"}], " ", ",", " ", 
        SubscriptBox["X", "31"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "^", "4"}], " ", ",", " ", 
        SubscriptBox["X", "32"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"b", " ", "c"}], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], ",", " ", 
        SubscriptBox["X", "35"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"b", " ", "c"}], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], ",", " ", 
        SubscriptBox["X", "36"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}], ",", " ", 
        SubscriptBox["X", "37"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], ",", " ", 
        SubscriptBox["X", "38"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], ",", " ", 
        SubscriptBox["X", "39"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "3"], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "b"}], "-", 
           RowBox[{"a", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           SuperscriptBox["b", "3"], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "c"}], "-", 
           RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "c"}], "-", 
           RowBox[{"a", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "3"]}], ")"}]}], ",", " ", 
        SubscriptBox["X", "40"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "3"], " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c", "-", "a"}], ")"}]}], ",", " ", 
        SubscriptBox["X", "41"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}], ",", " ", 
        SubscriptBox["X", "42"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "b"}], "-", 
           RowBox[{"b", " ", "c"}], "+", 
           RowBox[{"c", " ", "a"}]}], ")"}]}], ",", " ", 
        SubscriptBox["X", "43"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c", "-", 
           RowBox[{"2", "a"}]}], ")"}]}], ",", "  ", 
        SubscriptBox["X", "44"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "b"}], "+", 
           RowBox[{"2", "c"}], "-", "a"}], ")"}]}], ",", "  ", 
        SubscriptBox["X", "45"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "3"], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "b"}], "-", 
           RowBox[{"a", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           SuperscriptBox["b", "3"], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "c"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "c"}], "-", 
           RowBox[{"a", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "3"]}], ")"}]}], ",", " ", 
        SubscriptBox["X", "46"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c", "-", "a"}], ")"}]}], ",", " ", 
        SubscriptBox["X", "55"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b", "-", "c"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"c", "+", "a", "-", "b"}], ")"}]}], ",", " ", 
        SubscriptBox["X", "56"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b", "-", "c"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"c", "+", "a", "-", "b"}], ")"}]}], ",", "  ", 
        SubscriptBox["X", "57"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "^", "2"}], 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"c", "+", "a"}], ")"}]}], ",", "  ", 
        SubscriptBox["X", "58"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}], "-", 
           RowBox[{"a", "^", "2"}]}], ")"}]}], ",", "  ", 
        SubscriptBox["X", "63"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"a", "+", "b", "-", "c"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"c", "+", "a", "-", "b"}], ")"}]}], ",", "  ", 
        SubscriptBox["X", "65"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}], "-", 
         RowBox[{"a", "^", "2"}]}], ",", "  ", 
        SubscriptBox["X", "69"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}], "-", 
           RowBox[{"a", "^", "2"}]}], ")"}]}], ",", "  ", 
        SubscriptBox["X", "72"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"b", " ", "c"}], ",", "  ", 
        SubscriptBox["X", "75"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], ",", " ", 
        SubscriptBox["X", "76"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c", "-", "a"}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}], "-", 
           RowBox[{"a", "^", "2"}]}], ")"}]}], ",", "  ", 
        SubscriptBox["X", "78"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "b"}], "+", 
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", " ", "a"}], "+", 
           RowBox[{"c", "^", "2"}], "+", 
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ",", "  ", 
        SubscriptBox["X", "79"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], " ", "b"}], "+", 
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "c"}], " ", "a"}], "+", 
           RowBox[{"c", "^", "2"}], "+", 
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ",", "  ", 
        SubscriptBox["X", "80"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"c", "+", "a"}], ")"}]}], ",", " ", 
        SubscriptBox["X", "81"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", "^", "2"}], "+", 
           RowBox[{"a", "^", "2"}]}], ")"}]}], ",", " ", 
        SubscriptBox["X", "83"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"b", " ", "c", 
         RowBox[{"(", 
          RowBox[{"c", "+", "a", "-", "b"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"a", "+", "b", "-", "c"}], ")"}]}], ",", "  ", 
        SubscriptBox["X", "85"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}], ",", "  ", 
        SubscriptBox["X", "86"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b", "-", 
           RowBox[{"2", "c"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"c", "+", "a", "-", 
           RowBox[{"2", "b"}]}], ")"}]}], ",", "  ", 
        SubscriptBox["X", "88"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "a"}], "+", 
           RowBox[{"2", "b"}], "-", "c"}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "c"}], "+", 
           RowBox[{"2", "a"}], "-", "b"}], ")"}]}], ",", "  ", 
        SubscriptBox["X", "89"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", "^", "2"}], "-", 
           RowBox[{"a", "^", "2"}]}], ")"}]}], ",", "  ", 
        SubscriptBox["X", "99"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ",", " ", 
        SubscriptBox["X", "141"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a", " ", "b"}], "+", " ", 
         RowBox[{"a", " ", "c"}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "-", "c"}], ")"}], "^", "2"}]}], ",", " ", 
        SubscriptBox["X", "142"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"3", "a"}], "-", "b", "-", "c"}], ",", " ", 
        SubscriptBox["X", "145"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"a", "-", "c"}], ")"}]}], ",", " ", 
        SubscriptBox["X", "190"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"c", " ", "a"}], "+", 
         RowBox[{"a", " ", "b"}], "-", 
         RowBox[{"b", " ", "c"}]}], ",", " ", 
        SubscriptBox["X", "192"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"a", "^", "2"}], 
          RowBox[{"b", "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"a", "^", "2"}], 
          RowBox[{"c", "^", "2"}]}], "-", 
         RowBox[{
          RowBox[{"b", "^", "2"}], 
          RowBox[{"c", "^", "2"}]}]}], ",", " ", 
        SubscriptBox["X", "194"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", "c", "-", "a"}], ")"}], "^", "2"}]}], ",", " ", 
        SubscriptBox["X", "200"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"b", "+", "c", "-", "a"}], ")"}]}], ",", " ", 
        SubscriptBox["X", "210"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "^", "3"}], 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}], ",", " ", 
        SubscriptBox["X", "213"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "^", "3"}], "-", 
         RowBox[{"a", " ", "b", " ", "c"}]}], ",", " ", 
        SubscriptBox["X", "238"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", " ", "c"}]}], ",", " ", 
        SubscriptBox["X", "239"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "-", "c"}], ")"}], "^", "2"}]}], ",", " ", 
        SubscriptBox["X", "244"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"b", " ", "c", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}], "-", 
           RowBox[{"a", "^", "2"}]}], ")"}]}], ",", " ", 
        SubscriptBox["X", "304"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}], "-", 
           RowBox[{"a", "^", "2"}]}], ")"}]}], ",", " ", 
        SubscriptBox["X", "306"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"b", " ", "c", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c", "-", "a"}], ")"}]}], ",", " ", 
        SubscriptBox["X", "312"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"b", " ", "c"}], "+", 
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}], "-", 
         RowBox[{"a", "^", "2"}]}], ",", " ", 
        SubscriptBox["X", "319"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"b", " ", "c"}], "-", 
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}], "+", 
         RowBox[{"a", "^", "2"}]}], ",", " ", 
        SubscriptBox["X", "320"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"b", " ", "c", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}], ",", " ", 
        SubscriptBox["X", "321"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "+", "c", "-", "a"}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}], "-", 
           RowBox[{"a", "^", "2"}]}], ")"}]}], ",", " ", 
        SubscriptBox["X", "345"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "b", "-", "c"}], ")"}], "^", "2"}], ",", " ", 
        SubscriptBox["X", "346"]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], 
          RowBox[{"c", "^", "2"}]}], "-", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "b", " ", "c"}]}], ",", " ", 
        SubscriptBox["X", "350"]}], "}"}]}], "\[IndentingNewLine]", "}"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"pLen", "=", 
  RowBox[{"Length", "[", "points", "]"}]}]}], "Input",
 CellChangeTimes->{{3.855568830667963*^9, 3.8555691994531813`*^9}, {
   3.855569265257246*^9, 3.855569496750648*^9}, {3.8555695278473263`*^9, 
   3.855569550807061*^9}, {3.8555695813435717`*^9, 3.855569618175437*^9}, {
   3.855569688960095*^9, 3.8555697026639*^9}, {3.855569747296452*^9, 
   3.8555697600963173`*^9}, {3.8555698914729853`*^9, 
   3.8555699125377893`*^9}, {3.855570641390004*^9, 3.85557064741201*^9}, {
   3.855570831766528*^9, 3.855570842028496*^9}, {3.855570951159112*^9, 
   3.855571015885231*^9}, {3.855571148319645*^9, 3.855571151198031*^9}, {
   3.8555730034816923`*^9, 3.855573025591339*^9}, {3.855635225449319*^9, 
   3.855635236336182*^9}, {3.855635384625959*^9, 3.855635399552992*^9}, {
   3.855635431915092*^9, 3.855635722745447*^9}, {3.8556361459832783`*^9, 
   3.855636324894332*^9}, {3.855656349007049*^9, 3.855656367806053*^9}, {
   3.8556564050215683`*^9, 3.855656727472826*^9}, {3.855656779984767*^9, 
   3.8556567960012817`*^9}, {3.8556568697293043`*^9, 3.855656950734223*^9}, {
   3.855656988233972*^9, 3.855657173351594*^9}, {3.855739723842256*^9, 
   3.8557397585682297`*^9}, {3.855739883593889*^9, 3.855739986688826*^9}, {
   3.855740032633933*^9, 3.855740255057721*^9}, {3.855740313699266*^9, 
   3.855740537273612*^9}, {3.855740681836163*^9, 3.855740804619461*^9}, {
   3.855740850420753*^9, 3.855740866019548*^9}, {3.855741025284678*^9, 
   3.855741040820394*^9}, {3.855741089373424*^9, 3.855741266277376*^9}, {
   3.855741301206222*^9, 3.8557413622451077`*^9}, 3.855742338640458*^9, {
   3.855825030306016*^9, 3.855825037592688*^9}, {3.855825080720718*^9, 
   3.855825085408791*^9}, 3.85647362057202*^9, {3.856473697344077*^9, 
   3.85647371985429*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"24ef5490-c78a-4ed9-bfb7-868b4a544973"],

Cell[BoxData["69"], "Output",
 CellChangeTimes->{3.855742339959746*^9, 3.855825158371827*^9, 
  3.855825271023617*^9, 3.855919205947117*^9, 3.855919245826907*^9, 
  3.856089216665374*^9, 3.856179497397233*^9, 3.856180117430197*^9, 
  3.856357057629524*^9, 3.856474847954723*^9, 3.856476956950037*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"e8d4c6f7-fed4-4f1b-92b1-4ab87bc0eb4c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Support Routines", "Section",
 CellChangeTimes->{{3.854270562186454*^9, 3.854270570452723*^9}, {
  3.854282919791356*^9, 3.854282920310923*^9}, {3.856473684661944*^9, 
  3.856473689477685*^9}},ExpressionUUID->"af06020a-9a82-45b2-8fbd-\
c4df7e3e209f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"triple", "[", "n_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"pa", ",", "pb", ",", "pc"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"pa", "=", 
        RowBox[{
         RowBox[{"points", "[", 
          RowBox[{"[", "n", "]"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"pb", "=", 
        RowBox[{"pa", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"a", "\[Rule]", "b"}], ",", 
           RowBox[{"b", "\[Rule]", "c"}], ",", 
           RowBox[{"c", "\[Rule]", "a"}]}], "}"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"pc", "=", 
        RowBox[{"pb", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"a", "\[Rule]", "b"}], ",", 
           RowBox[{"b", "\[Rule]", "c"}], ",", 
           RowBox[{"c", "\[Rule]", "a"}]}], "}"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        RowBox[{"{", 
         RowBox[{"pa", ",", "pb", ",", "pc"}], "}"}], "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "to", " ", "find", " ", "the", " ", "distance", " ", 
    "between", " ", "two", " ", "points", " ", "given", " ", "in", " ", 
    "Barycentric", " ", "coordinates"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"normed", "[", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_", ",", "z_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], "/", 
    RowBox[{"(", 
     RowBox[{"x", "+", "y", "+", "z"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"squaredDistance", "[", 
    RowBox[{"p1_", ",", "p2_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Total", "[", "p1", "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{"Return", "[", "Infinity", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Total", "[", "p2", "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{"Return", "[", "Infinity", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], "=", 
       RowBox[{
        RowBox[{"normed", "[", "p1", "]"}], "-", 
        RowBox[{"normed", "[", "p2", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"a", "^", "2"}]}], "*", "y", "*", "z"}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", "z", "*", "x"}], "-", 
        RowBox[{
         RowBox[{"c", "^", "2"}], "*", "x", "*", "y"}]}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.855618098189292*^9, 3.855618102707382*^9}, {
  3.856473704974173*^9, 3.856473706985322*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"e7517eac-0fe1-405f-aaf5-059522a9044b"]
}, Closed]],

Cell[CellGroupData[{

Cell["Inequality Support", "Section",
 CellChangeTimes->{{3.854270562186454*^9, 3.854270570452723*^9}, {
  3.854282919791356*^9, 3.854282920310923*^9}, {3.856473684661944*^9, 
  3.856473689477685*^9}, {3.8564737734387207`*^9, 
  3.8564737801261578`*^9}},ExpressionUUID->"35f279b9-3668-4ce4-9b1f-\
153c12760a9e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"convertToRrs", "[", "expression_", "]"}], ":=", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "expr", ",", "num", ",", "den", ",", "num2", ",", "den2", ",", "rem"}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"expr", "=", 
        RowBox[{"Together", "[", "expression", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"num", "=", 
        RowBox[{"Numerator", "[", "expr", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"den", "=", 
        RowBox[{"Denominator", "[", "expr", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"num2", ",", "rem"}], "}"}], "=", 
        RowBox[{"SymmetricReduction", "[", 
         RowBox[{"num", ",", 
          RowBox[{"{", 
           RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"rem", "=!=", "0"}], ",", 
         RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"den2", ",", "rem"}], "}"}], "=", 
        RowBox[{"SymmetricReduction", "[", 
         RowBox[{"den", ",", 
          RowBox[{"{", 
           RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"rem", "=!=", "0"}], ",", 
         RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{
         "See", " ", "Mitrinovic", " ", "page", " ", "7", " ", "for", " ", 
          "how", " ", "to", " ", "convert", " ", "symmetric", " ", 
          "functions", " ", "of", " ", "a"}], ",", " ", "b", ",", " ", 
         RowBox[{"and", " ", "c", " ", "to", " ", "R"}], ",", " ", "r", ",", 
         " ", 
         RowBox[{"and", " ", 
          RowBox[{"s", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"num2", ",", "den2"}], "}"}], "=", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"First", "[", 
            RowBox[{"SymmetricReduction", "[", 
             RowBox[{"#", ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"2", " ", "s"}], ",", 
                RowBox[{
                 SuperscriptBox["s", "2"], "+", 
                 SuperscriptBox["r", "2"], "+", 
                 RowBox[{"4", " ", "R", " ", "r"}]}], ",", 
                RowBox[{"4", " ", "R", " ", "r", " ", "s"}]}], "}"}]}], "]"}],
             "]"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{"num", ",", "den"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"expr", "=", 
        RowBox[{"num2", "/", "den2"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"expr", "=", 
        RowBox[{"Simplify", "[", 
         RowBox[{"Together", "[", "expr", "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "expr", "]"}], ";"}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Removes", " ", "positive", " ", "factors", " ", "from", " ", "a", " ", 
    "rational", " ", "expression"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"removePositiveFactors", "[", 
     RowBox[{"expr_", ",", "constraints_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"num", ",", "den"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"num", ",", "den"}], "}"}], "=", 
        RowBox[{"NumeratorDenominator", "[", 
         RowBox[{"Together", "[", "expr", "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"num", "=", 
        RowBox[{"removePositiveFactorsFromPolynomial", "[", 
         RowBox[{"num", ",", "constraints"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"den", "=", 
        RowBox[{"removePositiveFactorsFromPolynomial", "[", 
         RowBox[{"den", ",", "constraints"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        RowBox[{"num", "/", "den"}], "]"}], ";"}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"isPositive", "[", 
     RowBox[{"expr_", ",", "constraints_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"Quiet", "[", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"expr", ">", "0"}], ",", "constraints"}], "]"}], "]"}], "===",
      "True"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"removePositiveFactorsFromPolynomial", "[", 
    RowBox[{"expr_", ",", "constraints_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"factorList", ",", "removePosFactor"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"factorList", "=", 
       RowBox[{"FactorSquareFreeList", "[", "expr", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"removePosFactor", "=", 
       RowBox[{"Function", "[", 
        RowBox[{"pair", ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"isPositive", "[", 
            RowBox[{
             RowBox[{"pair", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "constraints"}], "]"}], 
           ",", "1", ",", 
           RowBox[{
            RowBox[{"pair", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "^", 
            RowBox[{"pair", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"factorList", "=", 
       RowBox[{"Map", "[", 
        RowBox[{"removePosFactor", ",", "factorList"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"multiply", " ", "the", " ", "factors", " ", "together"}], " ",
        "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"Times", "@@", "factorList"}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8561797317757893`*^9, 3.856179787103929*^9}, {
  3.856179820784121*^9, 3.856179855111684*^9}, {3.85617994699349*^9, 
  3.856179965184067*^9}, {3.856180006776556*^9, 3.8561800073364058`*^9}, {
  3.8561800386166887`*^9, 3.856180040384849*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"47e08a4d-4fd4-4084-a5e3-27b8615a18a8"]
}, Closed]],

Cell[CellGroupData[{

Cell["Check inequalities in Introduction", "Section",
 CellChangeTimes->{{3.854270562186454*^9, 3.854270570452723*^9}, {
  3.854282919791356*^9, 3.854282920310923*^9}, {3.856473684661944*^9, 
  3.856473689477685*^9}, {3.8564737734387207`*^9, 3.8564737801261578`*^9}, {
  3.856473868814726*^9, 3.856473879126322*^9}, {3.856473980054805*^9, 
  3.856473986470439*^9}, {3.856474033230908*^9, 3.856474035950698*^9}, {
  3.856474186007576*^9, 3.856474205559279*^9}, {3.856474381104312*^9, 
  3.85647438865589*^9}, {3.856474465392713*^9, 3.8564744708000507`*^9}, {
  3.856474510992844*^9, 3.8564745116001043`*^9}, {3.856474888649816*^9, 
  3.856474896089609*^9}},ExpressionUUID->"1f03b215-fc6f-473c-b6ea-\
6376cb319c33"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptI", "=", 
  RowBox[{"triple", "[", "1", "]"}]}]], "Input",
 CellChangeTimes->{{3.8558315965918083`*^9, 3.855831601782892*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"4381ff6c-8d10-4a1c-beb2-15d5f054e880"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 CellChangeTimes->{3.855831602861*^9, 3.8559212225522623`*^9, 
  3.856474902904861*^9, 3.856476957077441*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"fde75a34-3da2-42a5-9171-ccce9759b00b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptG", "=", 
  RowBox[{"triple", "[", "2", "]"}]}]], "Input",
 CellChangeTimes->{{3.8564746443405437`*^9, 3.856474651153082*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"d92beb0a-afd9-4720-b73b-e1f99491dd82"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.856474905865799*^9, 3.856476957099531*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"6530bcde-cf18-4423-8e67-33a903a6f7c2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptO", "=", 
  RowBox[{"triple", "[", "3", "]"}]}]], "Input",
 CellChangeTimes->{{3.855571316990738*^9, 3.8555713187984343`*^9}, {
  3.855571374390751*^9, 3.855571393262566*^9}, {3.8555714504961157`*^9, 
  3.855571481207076*^9}, {3.856474672509351*^9, 3.856474675049508*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"cc36f9e5-af01-4d34-84a0-104daf91099f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "-", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8555713952758017`*^9, 3.855571481922921*^9, 
  3.855921222235669*^9, 3.856474908473928*^9, 3.856476957105908*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"788acece-4072-4b78-96ea-791bd59e37f3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptH", "=", 
  RowBox[{"triple", "[", "4", "]"}]}]], "Input",
 CellChangeTimes->{{3.855571316990738*^9, 3.8555713187984343`*^9}, {
  3.855571374390751*^9, 3.855571393262566*^9}, {3.8555714504961157`*^9, 
  3.855571481207076*^9}, {3.856474672509351*^9, 3.856474675049508*^9}, {
  3.856475258692049*^9, 3.8564752620513353`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"c22768b4-eaf6-481f-b41e-636c63da1c30"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8555713952758017`*^9, 3.855571481922921*^9, 
  3.855921222235669*^9, 3.856474908473928*^9, 3.856475262562264*^9, 
  3.856476957112162*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"78c90c8a-1ae3-4dc9-94c1-70ee823b78ec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptGe", "=", 
  RowBox[{"triple", "[", "7", "]"}]}]], "Input",
 CellChangeTimes->{{3.855831574655648*^9, 3.855831581070853*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"4b24675e-6721-4042-b5b5-11dd4aeb1896"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", "b", "+", "c"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8558315821411257`*^9, 3.855921222594524*^9, 
  3.856474911357016*^9, 3.856476957135704*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"da11fcee-1e0d-41b5-b5e7-394c79a5568d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptM", "=", 
  RowBox[{"triple", "[", "9", "]"}]}]], "Input",
 CellChangeTimes->{{3.8555714060311003`*^9, 3.85557144447079*^9}, {
   3.8555716146492987`*^9, 3.855571620575378*^9}, 3.856476718425215*^9},
 CellLabel->"In[15]:=",ExpressionUUID->"b914b804-9196-4fb8-9d36-7c48636274c7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", "b", "-", "c"}], ")"}]}], ",", 
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "+", "b", "-", "c"}], ")"}]}], ",", 
   RowBox[{"c", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "-", "b", "+", "c"}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8555714134540043`*^9, 3.8555714459954243`*^9, 
  3.85557162159544*^9, 3.855921222244356*^9, 3.85647491531213*^9, 
  3.856476720111134*^9, 3.856476957142085*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"9ccd6365-b3a7-411c-a4f9-5b5357cb6caa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GI", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"squaredDistance", "[", 
     RowBox[{"ptG", ",", "ptI"}], "]"}], "//", "convertToRrs"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.8564749352421207`*^9, 3.8564749647893667`*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"423ef415-50a7-4298-b3ec-41567f825136"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "9"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"5", " ", 
     SuperscriptBox["r", "2"]}], "-", 
    RowBox[{"16", " ", "r", " ", "R"}], "+", 
    SuperscriptBox["s", "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.856474955451893*^9, 3.85647496596446*^9}, 
   3.8564769571660852`*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"45cffd5d-ba52-4529-bc60-d7957c4e45c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HI", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"squaredDistance", "[", 
     RowBox[{"ptH", ",", "ptI"}], "]"}], "//", "convertToRrs"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.8564749352421207`*^9, 3.8564749647893667`*^9}, {
  3.856475234459694*^9, 3.8564752414271107`*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"46100400-536b-40a7-8c04-c72b832c3173"],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", 
   SuperscriptBox["r", "2"]}], "+", 
  RowBox[{"4", " ", "r", " ", "R"}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["R", "2"]}], "-", 
  SuperscriptBox["s", "2"]}]], "Output",
 CellChangeTimes->{{3.856474955451893*^9, 3.85647496596446*^9}, {
   3.8564752426391993`*^9, 3.856475269128586*^9}, 3.856476957190073*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"9d46b1b7-169f-455c-8179-4259006f5b9f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OM", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"squaredDistance", "[", 
     RowBox[{"ptO", ",", "ptM"}], "]"}], "//", "convertToRrs"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.8564749950424957`*^9, 3.856475002306403*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"1f244b0e-51b8-416c-8b2f-99330e210e8d"],

Cell[BoxData[
 FractionBox[
  RowBox[{"R", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["r", "2"], " ", "R"}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["R", "3"]}], "-", 
     RowBox[{"4", " ", "R", " ", 
      SuperscriptBox["s", "2"]}], "+", 
     RowBox[{"2", " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["R", "2"]}], "+", 
        SuperscriptBox["s", "2"]}], ")"}]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"r", "+", 
     RowBox[{"4", " ", "R"}]}], ")"}], "2"]]], "Output",
 CellChangeTimes->{3.856475003239959*^9, 3.856476730662516*^9, 
  3.8564769572184067`*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"d2d6d2fc-9b65-416b-85a7-a80d7f44152b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rem", "=", 
  RowBox[{
   RowBox[{"removePositiveFactors", "[", 
    RowBox[{"OM", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"R", "\[GreaterEqual]", 
        RowBox[{"2", "r"}], ">", "0"}], ",", 
       RowBox[{"s", ">", "0"}]}], "}"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.855571733720656*^9, 3.855571739264351*^9}, {
  3.855571806346072*^9, 3.855571851608329*^9}, {3.855571921122774*^9, 
  3.855571922145116*^9}, {3.856475049523395*^9, 3.856475058322703*^9}, {
  3.856475668029701*^9, 3.856475698100399*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"faeec5c0-b720-4c01-94c6-1b2b3249ffc4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["r", "2"], " ", "R"}], "+", 
  RowBox[{"16", " ", 
   SuperscriptBox["R", "3"]}], "-", 
  RowBox[{"4", " ", "R", " ", 
   SuperscriptBox["s", "2"]}], "+", 
  RowBox[{"2", " ", "r", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["R", "2"]}], "+", 
     SuperscriptBox["s", "2"]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.8555717405806503`*^9, {3.8555718360808973`*^9, 3.855571852530738*^9}, 
   3.855571923152191*^9, 3.855921222381702*^9, 3.85647505954708*^9, {
   3.856475669301708*^9, 3.856475699272106*^9}, 3.856475761512478*^9, 
   3.85647673552096*^9, 3.8564769572732077`*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"cf541c49-e715-4267-8fd0-a6f5eb643435"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ans", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"rem", "\[Equal]", "0"}], "/.", 
         RowBox[{
          RowBox[{"s", "^", "2"}], "\[Rule]", "s2"}]}], ",", "s2"}], "]"}], "//",
       "First"}], "//", "First"}], "//", "Last"}], "//", 
   "Factor"}]}]], "Input",
 CellChangeTimes->{{3.855571958609565*^9, 3.855572003761257*^9}, {
  3.8564753489406137`*^9, 3.8564753613553534`*^9}, {3.8564754903414383`*^9, 
  3.856475509139732*^9}, {3.856476756057168*^9, 3.856476812639819*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"7d0fd775-f9e8-43da-a152-4e9ac03c97f2"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"R", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"r", "+", 
       RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"r", "-", 
      RowBox[{"2", " ", "R"}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{{3.8555719667269278`*^9, 3.855571990846648*^9}, 
   3.855572065264288*^9, 3.8559212224368887`*^9, 3.856475309450081*^9, {
   3.856475351886529*^9, 3.856475362507605*^9}, 3.85647551023547*^9, {
   3.856476760755427*^9, 3.8564768138150253`*^9}, 3.856476957279776*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"940eb33f-cb30-49e1-9934-fbfba7fbf42c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Section 3: Finding the Inequalities", "Section",
 CellChangeTimes->{{3.854270562186454*^9, 3.854270570452723*^9}, {
  3.854282919791356*^9, 3.854282920310923*^9}, {3.856473684661944*^9, 
  3.856473689477685*^9}, {3.8564737734387207`*^9, 3.8564737801261578`*^9}, {
  3.856473868814726*^9, 
  3.856473879126322*^9}},ExpressionUUID->"e17f9d1c-d86c-43a4-adbf-\
071145cb8ca1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"checkVar", "[", 
     RowBox[{"expr_", ",", "var_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "clist", ",", "zcount", ",", "len", ",", "nonz", ",", "ans", ",", 
        "\[IndentingNewLine]", "lg", ",", "exp", ",", "expr2", ",", "coef", 
        ",", "left"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"clist", "=", 
        RowBox[{"CoefficientList", "[", 
         RowBox[{"expr", ",", "var"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"len", "=", 
        RowBox[{"Length", "[", "clist", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"zcount", "=", 
        RowBox[{"Count", "[", 
         RowBox[{"clist", ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"nonz", "=", 
        RowBox[{"len", "-", "zcount"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"nonz", ">", "2"}], ",", 
         RowBox[{"Return", "[", 
          RowBox[{"{", "}"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"exp", "=", 
        RowBox[{"Exponent", "[", 
         RowBox[{"expr", ",", "var"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"exp", "\[Equal]", "0"}], ",", 
         RowBox[{"Return", "[", 
          RowBox[{"{", "}"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"coef", "=", 
        RowBox[{"Coefficient", "[", 
         RowBox[{"expr", ",", 
          RowBox[{"var", "^", "exp"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       
       RowBox[{"left", "=", 
        RowBox[{
         RowBox[{"expr", "-", 
          RowBox[{"coef", "*", 
           RowBox[{"var", "^", "exp"}]}]}], "//", "Simplify"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Simplify", "[", 
          RowBox[{
           RowBox[{"coef", ">", "0"}], ",", 
           RowBox[{
            RowBox[{"s", ">", "0"}], "&&", 
            RowBox[{"R", ">", 
             RowBox[{"2", "r"}], ">", "0"}]}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"ans", "=", 
           RowBox[{
            RowBox[{"var", "^", "exp"}], "\[GreaterEqual]", 
            RowBox[{"Factor", "[", 
             RowBox[{"Simplify", "[", 
              RowBox[{"left", "/", 
               RowBox[{"(", 
                RowBox[{"-", "coef"}], ")"}]}], "]"}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Return", "[", "ans", "]"}], ";"}]}], "\[IndentingNewLine]",
         "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Simplify", "[", 
          RowBox[{
           RowBox[{"coef", "<", "0"}], ",", 
           RowBox[{
            RowBox[{"s", ">", "0"}], "&&", 
            RowBox[{"R", ">", 
             RowBox[{"2", "r"}], ">", "0"}]}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"ans", "=", 
           RowBox[{
            RowBox[{"var", "^", "exp"}], "\[LessEqual]", 
            RowBox[{"Factor", "[", 
             RowBox[{"Simplify", "[", 
              RowBox[{"left", "/", 
               RowBox[{"(", 
                RowBox[{"-", "coef"}], ")"}]}], "]"}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Return", "[", "ans", "]"}], ";"}]}], "\[IndentingNewLine]",
         "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"ans", "=", 
        RowBox[{"left", "\[GreaterEqual]", 
         RowBox[{
          RowBox[{"Factor", "[", 
           RowBox[{"-", "coef"}], "]"}], "*", 
          RowBox[{"var", "^", "exp"}]}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "ans", "]"}], ";"}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"show", "[", "result_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"result", "===", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MemberQ", "[", 
          RowBox[{"list", ",", "result"}], "]"}], ",", 
         RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<|\>\"", ",", 
         RowBox[{
          RowBox[{"points", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"points", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"\"\<|\>\"", "^", "2"}], ",", "\"\<:      \>\"", ",", 
         "result"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"list", ",", "result"}], "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rRsList", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"list", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"i", "=", "1"}], ",", 
    RowBox[{"i", "\[LessEqual]", "pLen"}], ",", 
    RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ptI", "=", 
      RowBox[{"triple", "[", "i", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"j", "=", 
        RowBox[{"i", "+", "1"}]}], ",", 
       RowBox[{"j", "\[LessEqual]", "pLen"}], ",", 
       RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ptJ", "=", 
         RowBox[{"triple", "[", "j", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dist", "=", 
         RowBox[{"squaredDistance", "[", 
          RowBox[{"ptI", ",", "ptJ"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"dist", "===", "Infinity"}], ",", 
          RowBox[{"Continue", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"distr", "=", 
         RowBox[{"convertToRrs", "[", "dist", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"distr", "===", "$Failed"}], ",", 
          RowBox[{
           RowBox[{"Print", "[", 
            RowBox[{"\"\<Problem: \>\"", ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "j"}], "}"}]}], "]"}], ";", 
           RowBox[{"Continue", "[", "]"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"rRsList", ",", 
          RowBox[{"Row", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<|\>\"", ",", 
             RowBox[{
              RowBox[{"points", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{
              RowBox[{"points", "[", 
               RowBox[{"[", "j", "]"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"\"\<|\>\"", "^", "2"}], ",", "\"\<:\>\"", ",", 
             "\"\<    \>\"", ",", "distr"}], "}"}], "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"distr", "=", 
         RowBox[{
          RowBox[{"removePositiveFactors", "[", 
           RowBox[{"distr", ",", 
            RowBox[{
             RowBox[{"r", ">", "0"}], "&&", 
             RowBox[{"s", ">", "0"}], "&&", 
             RowBox[{"R", ">", "0"}]}]}], "]"}], "//", "Simplify"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"distr", "===", "1"}], ",", 
          RowBox[{"Continue", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"PolynomialQ", "[", 
            RowBox[{"distr", ",", 
             RowBox[{"{", 
              RowBox[{"r", ",", "R", ",", "s"}], "}"}]}], "]"}]}], ",", 
          RowBox[{"Continue", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"rx", "=", 
         RowBox[{"checkVar", "[", 
          RowBox[{"distr", ",", "r"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"show", "[", "rx", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"rx", "=", 
         RowBox[{"checkVar", "[", 
          RowBox[{"distr", ",", "s"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"show", "[", "rx", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"rx", "=", 
         RowBox[{"checkVar", "[", 
          RowBox[{"distr", ",", "R"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"show", "[", "rx", "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.85557065277953*^9, 3.855570803428142*^9}, {
   3.8555708646298847`*^9, 3.855570949486271*^9}, {3.855571043965667*^9, 
   3.855571067941359*^9}, {3.855571185567233*^9, 3.855571213919972*^9}, {
   3.855572574461364*^9, 3.855572605204979*^9}, {3.855572702725706*^9, 
   3.855572728308682*^9}, {3.8555727692299957`*^9, 3.855572809037404*^9}, {
   3.855572868397717*^9, 3.855572878885394*^9}, {3.85557291722451*^9, 
   3.8555729194935827`*^9}, {3.855573039712617*^9, 3.855573041598218*^9}, {
   3.855573361257066*^9, 3.855573373911763*^9}, 3.85561277333095*^9, {
   3.8556128086182203`*^9, 3.85561281006397*^9}, {3.85561695192738*^9, 
   3.855617072486991*^9}, {3.855617123048087*^9, 3.85561716881514*^9}, 
   3.855617359268117*^9, {3.8556174815702972`*^9, 3.85561748629779*^9}, {
   3.8556178853154993`*^9, 3.8556179098664618`*^9}, {3.855618186189788*^9, 
   3.855618219532156*^9}, {3.85563381426659*^9, 3.855633849185316*^9}, 
   3.855634397469116*^9, {3.8556344359483643`*^9, 3.855634552332671*^9}, {
   3.855634589229377*^9, 3.855634675997636*^9}, {3.855634949207416*^9, 
   3.855635112495572*^9}, {3.8556351464003363`*^9, 3.855635185872343*^9}, {
   3.855635256113579*^9, 3.855635263272032*^9}, {3.855635297801791*^9, 
   3.8556352998566437`*^9}, {3.85563576117188*^9, 3.85563581955466*^9}, {
   3.855821085780871*^9, 3.855821155524023*^9}, {3.855821216343799*^9, 
   3.8558212647005377`*^9}, 3.855821351455009*^9, {3.855824362559669*^9, 
   3.855824363185389*^9}, {3.855824414825967*^9, 3.855824448818543*^9}, {
   3.855825345213841*^9, 3.855825372069726*^9}, 3.8558254435802526`*^9, 
   3.855825545599938*^9, {3.855825624390998*^9, 3.855825625142806*^9}, {
   3.8559192361894712`*^9, 3.855919240613665*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"b00ceb83-6aa3-47f4-b3d7-aa2fc43478ea"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "1"], "\[InvisibleSpace]", 
   SubscriptBox["X", "2"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{
     RowBox[{"-", "r"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", "r"}], "-", 
       RowBox[{"16", " ", "R"}]}], ")"}]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 1], 
   Subscript[$CellContext`X, 2], "|"^2, 
   ":      ", $CellContext`s^2 >= -$CellContext`r (5 $CellContext`r - 
     16 $CellContext`R)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476957368775*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"9a06c535-f372-447b-83b4-d6934595023c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "1"], "\[InvisibleSpace]", 
   SubscriptBox["X", "2"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"R", "\[LessEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["r", "2"]}], "+", 
      SuperscriptBox["s", "2"]}], 
     RowBox[{"16", " ", "r"}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 1], 
   Subscript[$CellContext`X, 2], "|"^2, ":      ", $CellContext`R <= 
   Rational[1, 16] $CellContext`r^(-1) (
     5 $CellContext`r^2 + $CellContext`s^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476957369364*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"a208dcc9-ecbf-4c40-89e2-8766a53cbff9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "1"], "\[InvisibleSpace]", 
   SubscriptBox["X", "3"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"r", "\[LessEqual]", 
    FractionBox["R", "2"]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 1], 
   Subscript[$CellContext`X, 3], "|"^2, ":      ", $CellContext`r <= 
   Rational[1, 2] $CellContext`R],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476957372156*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"daa8924d-12ec-443d-9340-963f2eb3c214"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "1"], "\[InvisibleSpace]", 
   SubscriptBox["X", "3"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"R", "\[GreaterEqual]", 
    RowBox[{"2", " ", "r"}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 1], 
   Subscript[$CellContext`X, 3], "|"^2, ":      ", $CellContext`R >= 
   2 $CellContext`r],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476957373197*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"f3cec373-857e-4e3b-a25b-d2c8e3fa028f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "1"], "\[InvisibleSpace]", 
   SubscriptBox["X", "4"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    RowBox[{
     RowBox[{"3", " ", 
      SuperscriptBox["r", "2"]}], "+", 
     RowBox[{"4", " ", "r", " ", "R"}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["R", "2"]}]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 1], 
   Subscript[$CellContext`X, 4], "|"^2, ":      ", $CellContext`s^2 <= 
   3 $CellContext`r^2 + 4 $CellContext`r $CellContext`R + 4 $CellContext`R^2],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564769573741503`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"45f8c774-c9dc-401d-9d55-bab9b4ff8ac3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "1"], "\[InvisibleSpace]", 
   SubscriptBox["X", "7"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"4", " ", "R"}]}], ")"}], "2"]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 1], 
   Subscript[$CellContext`X, 7], "|"^2, ":      ", $CellContext`s^2 <= 
   Rational[1, 3] ($CellContext`r + 4 $CellContext`R)^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476957431884*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"f1ef6e67-4325-41f2-9b2a-43aca2bbcc08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "1"], "\[InvisibleSpace]", 
   SubscriptBox["X", "9"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
     RowBox[{"r", "+", "R"}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 1], 
   Subscript[$CellContext`X, 9], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r ($CellContext`r + \
$CellContext`R)^(-1) ($CellContext`r + 4 $CellContext`R)^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476957461635*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"395e6473-787f-46fb-bc9b-bd70a93e41e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "1"], "\[InvisibleSpace]", 
   SubscriptBox["X", "21"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"19", " ", "r", " ", "R"}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"2", " ", "r"}], "+", "R"}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 1], 
   Subscript[$CellContext`X, 21], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r (
      2 $CellContext`r + $CellContext`R)^(-1) (6 $CellContext`r^2 + 
     19 $CellContext`r $CellContext`R + 16 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564769575366983`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"88bd3eab-90bf-4973-9411-d10140a4f237"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "1"], "\[InvisibleSpace]", 
   SubscriptBox["X", "79"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{"8", " ", "r", " ", "R"}], "+", 
       RowBox[{"9", " ", 
        SuperscriptBox["R", "2"]}]}], ")"}]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 1], 
   Subscript[$CellContext`X, 79], "|"^2, ":      ", $CellContext`s^2 <= 
   Rational[1, 2] (2 $CellContext`r^2 + 8 $CellContext`r $CellContext`R + 
     9 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476958433516*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"1ef46955-25f1-481e-928a-72e53f9636b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "1"], "\[InvisibleSpace]", 
   SubscriptBox["X", "142"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", "r"}], "-", 
        RowBox[{"4", " ", "R"}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "-", 
        RowBox[{"2", " ", "R"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"2", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 1], 
   Subscript[$CellContext`X, 142], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r (3 $CellContext`r - 
     4 $CellContext`R) ($CellContext`r - 
      2 $CellContext`R)^(-1) ($CellContext`r + 
      2 $CellContext`R)^(-1) ($CellContext`r + 4 $CellContext`R)^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564769589946003`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"fe6c32db-db20-464b-bf28-ccc2230f7556"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "1"], "\[InvisibleSpace]", 
   SubscriptBox["X", "210"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", "R", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"7", " ", "r"}], "+", 
        RowBox[{"64", " ", "R"}]}], ")"}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"2", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 1], 
   Subscript[$CellContext`X, 210], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[1, 2] $CellContext`r $CellContext`R ($CellContext`r + 
      2 $CellContext`R)^(-1) (7 $CellContext`r + 64 $CellContext`R)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476959233129*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"cefe9d94-d89b-4826-b769-dd412b848ab6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "2"], "\[InvisibleSpace]", 
   SubscriptBox["X", "7"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"4", " ", "R"}]}], ")"}], "3"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"r", "-", 
         RowBox[{"2", " ", "R"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "r"}], "+", 
         RowBox[{"2", " ", "R"}]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 2], 
   Subscript[$CellContext`X, 7], "|"^2, 
   ":      ", $CellContext`s^2 >= -$CellContext`r ($CellContext`r - 
      2 $CellContext`R)^(-1) (5 $CellContext`r + 
      2 $CellContext`R)^(-1) ($CellContext`r + 4 $CellContext`R)^3],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.85647696012346*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"886f27d9-71f0-4a48-8090-1b7d39a88bca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "2"], "\[InvisibleSpace]", 
   SubscriptBox["X", "12"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "3"]}], "+", 
        RowBox[{
         SuperscriptBox["r", "2"], " ", "R"}], "+", 
        RowBox[{"4", " ", "r", " ", 
         SuperscriptBox["R", "2"]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["R", "3"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "-", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 2], 
   Subscript[$CellContext`X, 12], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r ($CellContext`r - \
$CellContext`R)^(-1) (2 $CellContext`r + $CellContext`R)^(-1) (
     2 $CellContext`r^3 + $CellContext`r^2 $CellContext`R + 
     4 $CellContext`r $CellContext`R^2 - 16 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564769602288523`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"77321dd2-8122-4e4a-bdf0-8b85f3056062"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "2"], "\[InvisibleSpace]", 
   SubscriptBox["X", "35"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"8", " ", 
        SuperscriptBox["r", "3"]}], "+", 
       RowBox[{"46", " ", 
        SuperscriptBox["r", "2"], " ", "R"}], "+", 
       RowBox[{"61", " ", "r", " ", 
        SuperscriptBox["R", "2"]}], "-", 
       RowBox[{"16", " ", 
        SuperscriptBox["R", "3"]}]}], ")"}]}], "\[GreaterEqual]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", "r"}], "-", "R"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
     SuperscriptBox["s", "2"]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 2], 
   Subscript[$CellContext`X, 35], "|"^2, 
   ":      ", $CellContext`r (8 $CellContext`r^3 + 
     46 $CellContext`r^2 $CellContext`R + 61 $CellContext`r $CellContext`R^2 - 
     16 $CellContext`R^3) >= (4 $CellContext`r - $CellContext`R) (
     2 $CellContext`r + $CellContext`R) $CellContext`s^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476960683876*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"94689236-88e7-4a86-a424-459efe57c81d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "2"], "\[InvisibleSpace]", 
   SubscriptBox["X", "40"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    RowBox[{
     FractionBox["1", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["r", "2"]}], "-", 
       RowBox[{"4", " ", "r", " ", "R"}], "+", 
       RowBox[{"36", " ", 
        SuperscriptBox["R", "2"]}]}], ")"}]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 2], 
   Subscript[$CellContext`X, 40], "|"^2, ":      ", $CellContext`s^2 <= 
   Rational[1, 5] (-$CellContext`r^2 - 4 $CellContext`r $CellContext`R + 
     36 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476961007234*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"4f6277f2-5871-4e3e-9ce8-4b050f07d90e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "2"], "\[InvisibleSpace]", 
   SubscriptBox["X", "65"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"15", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"28", " ", "r", " ", "R"}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"3", " ", "r"}], "+", "R"}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 2], 
   Subscript[$CellContext`X, 65], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r (
      3 $CellContext`r + $CellContext`R)^(-1) (15 $CellContext`r^2 + 
     28 $CellContext`r $CellContext`R + 16 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476961714341*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"485244a1-184c-4bee-88d7-d89778a8aa4b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "2"], "\[InvisibleSpace]", 
   SubscriptBox["X", "72"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"12", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"55", " ", "r", " ", "R"}], "+", 
        RowBox[{"64", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", "r"}], "+", 
        RowBox[{"2", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 2], 
   Subscript[$CellContext`X, 72], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[1, 2] $CellContext`r (3 $CellContext`r + 2 $CellContext`R)^(-1) (
     12 $CellContext`r^2 + 55 $CellContext`r $CellContext`R + 
     64 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564769618197927`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"d85703d4-e964-4574-b142-66ce85212287"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "2"], "\[InvisibleSpace]", 
   SubscriptBox["X", "79"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"8", " ", 
         SuperscriptBox["r", "3"]}], "+", 
        RowBox[{"38", " ", 
         SuperscriptBox["r", "2"], " ", "R"}], "-", 
        RowBox[{"3", " ", "r", " ", 
         SuperscriptBox["R", "2"]}], "-", 
        RowBox[{"144", " ", 
         SuperscriptBox["R", "3"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "r"}], "-", 
        RowBox[{"3", " ", "R"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"14", " ", "r"}], "+", 
        RowBox[{"3", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 2], 
   Subscript[$CellContext`X, 79], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r (4 $CellContext`r - 
      3 $CellContext`R)^(-1) (14 $CellContext`r + 3 $CellContext`R)^(-1) (
     8 $CellContext`r^3 + 38 $CellContext`r^2 $CellContext`R - 
     3 $CellContext`r $CellContext`R^2 - 144 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476961982729*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"2d053061-b99a-4c99-8c2e-97f9a703e346"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "3"], "\[InvisibleSpace]", 
   SubscriptBox["X", "7"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["R", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
     RowBox[{"4", " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{"r", "+", "R"}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 3], 
   Subscript[$CellContext`X, 7], "|"^2, ":      ", $CellContext`s^2 <= 
   Rational[1, 
      4] $CellContext`r^(-1) $CellContext`R^2 ($CellContext`r + \
$CellContext`R)^(-1) ($CellContext`r + 4 $CellContext`R)^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564769639379873`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"b4772162-7f73-4aaa-8e64-e4a746e5cede"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "3"], "\[InvisibleSpace]", 
   SubscriptBox["X", "9"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"R", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "r"}], "+", 
        RowBox[{"2", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 3], 
   Subscript[$CellContext`X, 9], "|"^2, ":      ", $CellContext`s^2 <= 
   Rational[1, 2] $CellContext`R (-$CellContext`r + 
      2 $CellContext`R)^(-1) ($CellContext`r + 4 $CellContext`R)^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476964001013*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"f97575ca-986d-4616-8e0c-c1a94a027d4e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "3"], "\[InvisibleSpace]", 
   SubscriptBox["X", "12"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["r", "4"]}], "+", 
      RowBox[{"7", " ", 
       SuperscriptBox["r", "3"], " ", "R"}], "+", 
      RowBox[{"11", " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox["R", "2"]}], "+", 
      RowBox[{"4", " ", "r", " ", 
       SuperscriptBox["R", "3"]}], "+", 
      SuperscriptBox["R", "4"]}], 
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 3], 
   Subscript[$CellContext`X, 12], "|"^2, 
   ":      ", $CellContext`s^2 <= $CellContext`r^(-1) (
      2 $CellContext`r + $CellContext`R)^(-1) (2 $CellContext`r^4 + 
     7 $CellContext`r^3 $CellContext`R + 11 $CellContext`r^2 $CellContext`R^2 + 
     4 $CellContext`r $CellContext`R^3 + $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476964136841*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"99bbde92-47e9-463d-9c8a-3d3064669a33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "3"], "\[InvisibleSpace]", 
   SubscriptBox["X", "63"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["r", "3"], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["r", "2"], " ", "R"}], "+", 
      RowBox[{"6", " ", "r", " ", 
       SuperscriptBox["R", "2"]}], "-", 
      SuperscriptBox["R", "3"]}], "r"]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 3], 
   Subscript[$CellContext`X, 63], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r^(-1) ($CellContext`r^3 + 
     5 $CellContext`r^2 $CellContext`R + 
     6 $CellContext`r $CellContext`R^2 - $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476965015493*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"ccfa2514-18d6-4a23-85fb-70de9fec451c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "3"], "\[InvisibleSpace]", 
   SubscriptBox["X", "79"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["r", "4"]}], "+", 
      RowBox[{"26", " ", 
       SuperscriptBox["r", "3"], " ", "R"}], "+", 
      RowBox[{"52", " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox["R", "2"]}], "+", 
      RowBox[{"30", " ", "r", " ", 
       SuperscriptBox["R", "3"]}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["R", "4"]}]}], 
     RowBox[{"6", " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 3], 
   Subscript[$CellContext`X, 79], "|"^2, ":      ", $CellContext`s^2 <= 
   Rational[1, 6] $CellContext`r^(-1) (
      2 $CellContext`r + $CellContext`R)^(-1) (4 $CellContext`r^4 + 
     26 $CellContext`r^3 $CellContext`R + 
     52 $CellContext`r^2 $CellContext`R^2 + 
     30 $CellContext`r $CellContext`R^3 + 9 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564769653468943`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"e784e148-cb5a-4507-be00-d644848703f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "3"], "\[InvisibleSpace]", 
   SubscriptBox["X", "145"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "6"}], " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{"32", " ", "r", " ", "R"}], "-", 
       SuperscriptBox["R", "2"]}], ")"}]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 3], 
   Subscript[$CellContext`X, 145], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[1, 2] ((-6) $CellContext`r^2 + 
     32 $CellContext`r $CellContext`R - $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476966639242*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"4e391035-3d37-4966-814f-70f71f300c8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "3"], "\[InvisibleSpace]", 
   SubscriptBox["X", "210"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"R", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "+", 
        RowBox[{"4", " ", "r", " ", "R"}], "-", 
        RowBox[{"9", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"r", "-", "R"}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 3], 
   Subscript[$CellContext`X, 210], "|"^2, ":      ", $CellContext`s^2 <= 
   Rational[1, 
      2] ($CellContext`r - $CellContext`R)^(-1) $CellContext`R \
($CellContext`r^2 + 4 $CellContext`r $CellContext`R - 9 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476967295128*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"168a8d3b-518e-40a2-ad4e-427fb5a6f5cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "4"], "\[InvisibleSpace]", 
   SubscriptBox["X", "12"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["r", "4"]}], "+", 
      RowBox[{"13", " ", 
       SuperscriptBox["r", "3"], " ", "R"}], "+", 
      RowBox[{"26", " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox["R", "2"]}], "+", 
      RowBox[{"16", " ", "r", " ", 
       SuperscriptBox["R", "3"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["R", "4"]}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "+", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 4], 
   Subscript[$CellContext`X, 12], "|"^2, 
   ":      ", $CellContext`s^2 <= ($CellContext`r + $CellContext`R)^(-1) (
      2 $CellContext`r + $CellContext`R)^(-1) (2 $CellContext`r^4 + 
     13 $CellContext`r^3 $CellContext`R + 
     26 $CellContext`r^2 $CellContext`R^2 + 
     16 $CellContext`r $CellContext`R^3 + 4 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476969037097*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"850aae21-9e44-47d3-aacd-dc6047b7af2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "4"], "\[InvisibleSpace]", 
   SubscriptBox["X", "35"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"8", " ", 
       SuperscriptBox["r", "4"]}], "+", 
      RowBox[{"42", " ", 
       SuperscriptBox["r", "3"], " ", "R"}], "+", 
      RowBox[{"67", " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox["R", "2"]}], "+", 
      RowBox[{"28", " ", "r", " ", 
       SuperscriptBox["R", "3"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["R", "4"]}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "r"}], "+", "R"}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 4], 
   Subscript[$CellContext`X, 35], "|"^2, 
   ":      ", $CellContext`s^2 <= (2 $CellContext`r + $CellContext`R)^(-1) (
      4 $CellContext`r + $CellContext`R)^(-1) (8 $CellContext`r^4 + 
     42 $CellContext`r^3 $CellContext`R + 
     67 $CellContext`r^2 $CellContext`R^2 + 
     28 $CellContext`r $CellContext`R^3 + 4 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476969585751*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"fc46af1b-c951-4c42-9e67-da4dc0e47049"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "4"], "\[InvisibleSpace]", 
   SubscriptBox["X", "63"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["r", "4"], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["r", "3"], " ", "R"}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox["R", "2"]}], "+", 
      RowBox[{"8", " ", "r", " ", 
       SuperscriptBox["R", "3"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["R", "4"]}]}], 
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", "r"}], "+", 
        RowBox[{"2", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 4], 
   Subscript[$CellContext`X, 63], "|"^2, 
   ":      ", $CellContext`s^2 <= $CellContext`r^(-1) (3 $CellContext`r + 
      2 $CellContext`R)^(-1) ($CellContext`r^4 + 
     6 $CellContext`r^3 $CellContext`R + 12 $CellContext`r^2 $CellContext`R^2 + 
     8 $CellContext`r $CellContext`R^3 + 4 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476971888399*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"01161aa3-b749-4bc7-aed1-ea4485d3f724"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "4"], "\[InvisibleSpace]", 
   SubscriptBox["X", "65"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["r", "3"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "2"], " ", "R"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["R", "3"]}]}], 
     RowBox[{"r", "-", "R"}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 4], 
   Subscript[$CellContext`X, 65], "|"^2, 
   ":      ", $CellContext`s^2 <= ($CellContext`r - $CellContext`R)^(-1) \
($CellContext`r^3 + 2 $CellContext`r^2 $CellContext`R - 4 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564769719699907`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"c7a9df4b-f11c-4af1-a981-74f3ade75427"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "4"], "\[InvisibleSpace]", 
   SubscriptBox["X", "79"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["r", "3"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["r", "2"], " ", "R"}], "-", 
      RowBox[{"12", " ", "r", " ", 
       SuperscriptBox["R", "2"]}], "-", 
      RowBox[{"36", " ", 
       SuperscriptBox["R", "3"]}]}], 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "-", 
        RowBox[{"3", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 4], 
   Subscript[$CellContext`X, 79], "|"^2, ":      ", $CellContext`s^2 <= 
   Rational[1, 3] (2 $CellContext`r - 3 $CellContext`R)^(-1) (
     2 $CellContext`r^3 + 5 $CellContext`r^2 $CellContext`R - 
     12 $CellContext`r $CellContext`R^2 - 36 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476972187873*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"7e83006e-2cbc-41f1-89e5-d4aef313a1c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "4"], "\[InvisibleSpace]", 
   SubscriptBox["X", "142"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"12", " ", "r", " ", "R"}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"6", " ", "R"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"10", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 4], 
   Subscript[$CellContext`X, 142], "|"^2, 
   ":      ", $CellContext`s^2 <= ($CellContext`r + 
      4 $CellContext`R)^2 ($CellContext`r + 
      6 $CellContext`R)^(-1) ($CellContext`r + 10 $CellContext`R)^(-1) (
     3 $CellContext`r^2 + 12 $CellContext`r $CellContext`R + 
     16 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476973256668*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"977372ad-30e5-4f5f-9de8-fc86b16f87fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "4"], "\[InvisibleSpace]", 
   SubscriptBox["X", "210"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["r", "3"]}], "+", 
       RowBox[{"10", " ", 
        SuperscriptBox["r", "2"], " ", "R"}], "-", 
       RowBox[{"8", " ", "r", " ", 
        SuperscriptBox["R", "2"]}], "-", 
       RowBox[{"36", " ", 
        SuperscriptBox["R", "3"]}]}], 
      RowBox[{"r", "+", 
       RowBox[{"5", " ", "R"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 4], 
   Subscript[$CellContext`X, 210], "|"^2, 
   ":      ", $CellContext`s^2 <= -($CellContext`r + 5 $CellContext`R)^(-1) (
     3 $CellContext`r^3 + 10 $CellContext`r^2 $CellContext`R - 
     8 $CellContext`r $CellContext`R^2 - 36 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564769736034317`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"62972348-68d6-4d32-8016-aede77a9fb82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "5"], "\[InvisibleSpace]", 
   SubscriptBox["X", "7"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"8", " ", "r", " ", "R"}], "-", 
         SuperscriptBox["R", "2"]}], ")"}]}], 
      RowBox[{"6", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{"r", "-", 
         RowBox[{"4", " ", "R"}]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 5], 
   Subscript[$CellContext`X, 7], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[-1, 6] $CellContext`r^(-1) ($CellContext`r - 
      4 $CellContext`R)^(-1) ($CellContext`r + 4 $CellContext`R)^2 (
     2 $CellContext`r^2 + 8 $CellContext`r $CellContext`R - $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476976295601*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"c75f5f26-692b-4381-8ca9-8368186a5e84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "5"], "\[InvisibleSpace]", 
   SubscriptBox["X", "35"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"8", " ", 
       SuperscriptBox["r", "4"]}], "+", 
      RowBox[{"44", " ", 
       SuperscriptBox["r", "3"], " ", "R"}], "+", 
      RowBox[{"64", " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox["R", "2"]}], "+", 
      RowBox[{"8", " ", "r", " ", 
       SuperscriptBox["R", "3"]}], "+", 
      SuperscriptBox["R", "4"]}], 
     RowBox[{"4", " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 5], 
   Subscript[$CellContext`X, 35], "|"^2, ":      ", $CellContext`s^2 <= 
   Rational[1, 4] $CellContext`r^(-1) (
      2 $CellContext`r + $CellContext`R)^(-1) (8 $CellContext`r^4 + 
     44 $CellContext`r^3 $CellContext`R + 
     64 $CellContext`r^2 $CellContext`R^2 + 
     8 $CellContext`r $CellContext`R^3 + $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476977145917*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"7d348ff5-5268-4205-b9ae-8a4f73af0cf8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "5"], "\[InvisibleSpace]", 
   SubscriptBox["X", "40"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"r", "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "R"}], "-", 
         RowBox[{"2", " ", "s"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "R"}], "+", 
         RowBox[{"2", " ", "s"}]}], ")"}]}], 
      RowBox[{"4", " ", "R"}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 5], 
   Subscript[$CellContext`X, 40], "|"^2, ":      ", $CellContext`r >= 
   Rational[-1, 4] $CellContext`R^(-1) (5 $CellContext`R - 2 $CellContext`s) (
     5 $CellContext`R + 2 $CellContext`s)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476977436029*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"5467ee32-11dc-427a-8e4b-d0063dfa4216"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "5"], "\[InvisibleSpace]", 
   SubscriptBox["X", "40"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    RowBox[{
     FractionBox["1", "4"], " ", "R", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", "r"}], "+", 
       RowBox[{"25", " ", "R"}]}], ")"}]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 5], 
   Subscript[$CellContext`X, 40], "|"^2, ":      ", $CellContext`s^2 <= 
   Rational[1, 4] $CellContext`R (4 $CellContext`r + 25 $CellContext`R)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.85647697743747*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"be7d3168-ec75-4bf3-b258-451a2b77a000"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "5"], "\[InvisibleSpace]", 
   SubscriptBox["X", "55"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["r", "4"]}], "+", 
      RowBox[{"14", " ", 
       SuperscriptBox["r", "3"], " ", "R"}], "+", 
      RowBox[{"25", " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox["R", "2"]}], "+", 
      RowBox[{"2", " ", "r", " ", 
       SuperscriptBox["R", "3"]}], "+", 
      SuperscriptBox["R", "4"]}], 
     RowBox[{"2", " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{"r", "+", "R"}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 5], 
   Subscript[$CellContext`X, 55], "|"^2, ":      ", $CellContext`s^2 <= 
   Rational[1, 2] $CellContext`r^(-1) ($CellContext`r + $CellContext`R)^(-1) (
     2 $CellContext`r^4 + 14 $CellContext`r^3 $CellContext`R + 
     25 $CellContext`r^2 $CellContext`R^2 + 
     2 $CellContext`r $CellContext`R^3 + $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564769781563387`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"0aa88203-28a6-49b7-a7a1-3744a9fb8211"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "5"], "\[InvisibleSpace]", 
   SubscriptBox["X", "63"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"R", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"13", " ", 
          SuperscriptBox["r", "2"], " ", "R"}], "-", 
         RowBox[{"22", " ", "r", " ", 
          SuperscriptBox["R", "2"]}], "+", 
         SuperscriptBox["R", "3"]}], ")"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "r"}], "+", "R"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 5], 
   Subscript[$CellContext`X, 63], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[-1, 2] $CellContext`R (-$CellContext`r + $CellContext`R)^(-1) (
      2 $CellContext`r + $CellContext`R)^(-1) ((-2) $CellContext`r^3 - 
     13 $CellContext`r^2 $CellContext`R - 
     22 $CellContext`r $CellContext`R^2 + $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476978483707*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"e89edf8e-bb24-494c-8f53-4b6080be1495"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "5"], "\[InvisibleSpace]", 
   SubscriptBox["X", "65"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["r", "3"]}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["r", "2"], " ", "R"}], "+", 
      RowBox[{"8", " ", "r", " ", 
       SuperscriptBox["R", "2"]}], "-", 
      SuperscriptBox["R", "3"]}], 
     RowBox[{"2", " ", "r"}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 5], 
   Subscript[$CellContext`X, 65], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[1, 2] $CellContext`r^(-1) (6 $CellContext`r^3 + 
     12 $CellContext`r^2 $CellContext`R + 
     8 $CellContext`r $CellContext`R^2 - $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476978533292*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"313a2150-290c-4065-a9c5-8b105c0fd23c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "5"], "\[InvisibleSpace]", 
   SubscriptBox["X", "72"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["r", "3"]}], "+", 
      RowBox[{"26", " ", 
       SuperscriptBox["r", "2"], " ", "R"}], "+", 
      RowBox[{"28", " ", "r", " ", 
       SuperscriptBox["R", "2"]}], "-", 
      SuperscriptBox["R", "3"]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"r", "+", "R"}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 5], 
   Subscript[$CellContext`X, 72], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[1, 2] ($CellContext`r + $CellContext`R)^(-1) (6 $CellContext`r^3 + 
     26 $CellContext`r^2 $CellContext`R + 
     28 $CellContext`r $CellContext`R^2 - $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564769786880283`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"0b7e0289-d8f5-4e01-bb7a-07f1a16b72c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "5"], "\[InvisibleSpace]", 
   SubscriptBox["X", "79"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"R", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"56", " ", 
          SuperscriptBox["r", "2"], " ", "R"}], "-", 
         RowBox[{"96", " ", "r", " ", 
          SuperscriptBox["R", "2"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["R", "3"]}]}], ")"}]}], 
      RowBox[{"8", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "r"}], "+", 
         RowBox[{"3", " ", "R"}]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 5], 
   Subscript[$CellContext`X, 79], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[-1, 8] $CellContext`r^(-1) $CellContext`R ((-2) $CellContext`r + 
      3 $CellContext`R)^(-1) ((-8) $CellContext`r^3 - 
     56 $CellContext`r^2 $CellContext`R - 96 $CellContext`r $CellContext`R^2 + 
     9 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564769789840508`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"1051c195-2129-477e-b6e4-452b3d775c32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "5"], "\[InvisibleSpace]", 
   SubscriptBox["X", "145"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "42"}], " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{"104", " ", "r", " ", "R"}], "-", 
       SuperscriptBox["R", "2"]}], ")"}]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 5], 
   Subscript[$CellContext`X, 145], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[1, 6] ((-42) $CellContext`r^2 + 
     104 $CellContext`r $CellContext`R - $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564769800889883`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"d6bcfef0-4bbf-49d0-81d3-2d1b0ecc868c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "5"], "\[InvisibleSpace]", 
   SubscriptBox["X", "210"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["r", "3"]}], "+", 
      RowBox[{"40", " ", 
       SuperscriptBox["r", "2"], " ", "R"}], "+", 
      RowBox[{"64", " ", "r", " ", 
       SuperscriptBox["R", "2"]}], "-", 
      RowBox[{"9", " ", 
       SuperscriptBox["R", "3"]}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"2", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 5], 
   Subscript[$CellContext`X, 210], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[1, 2] ($CellContext`r + 2 $CellContext`R)^(-1) (
     6 $CellContext`r^3 + 40 $CellContext`r^2 $CellContext`R + 
     64 $CellContext`r $CellContext`R^2 - 9 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476980983913*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"1a98a23b-67b5-4ff9-942a-e20413c16981"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "7"], "\[InvisibleSpace]", 
   SubscriptBox["X", "10"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "r"}], "+", 
         RowBox[{"16", " ", "R"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"r", "-", 
         RowBox[{"4", " ", "R"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", "r"}], "+", 
         RowBox[{"4", " ", "R"}]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 7], 
   Subscript[$CellContext`X, 10], "|"^2, 
   ":      ", $CellContext`s^2 >= -$CellContext`r ($CellContext`r - 
      4 $CellContext`R)^(-1) ($CellContext`r + 4 $CellContext`R)^2 (
      7 $CellContext`r + 4 $CellContext`R)^(-1) (3 $CellContext`r + 
     16 $CellContext`R)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476997269525*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"14a420c4-cbbc-43b0-9768-6975846ffabb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "7"], "\[InvisibleSpace]", 
   SubscriptBox["X", "12"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r"}], "+", 
         RowBox[{"9", " ", "R"}]}], ")"}]}], 
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"r", "-", 
         RowBox[{"3", " ", "R"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 7], 
   Subscript[$CellContext`X, 12], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[-1, 3] $CellContext`r ($CellContext`r - 3 $CellContext`R)^(-1) (
      2 $CellContext`r + $CellContext`R)^(-1) ($CellContext`r + 
      4 $CellContext`R)^2 (2 $CellContext`r + 9 $CellContext`R)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476997442606*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"f8557f18-580c-49ab-8761-0572e0ee4811"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "7"], "\[InvisibleSpace]", 
   SubscriptBox["X", "21"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", "R", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"r", "-", "R"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "r"}], "+", "R"}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 7], 
   Subscript[$CellContext`X, 21], "|"^2, 
   ":      ", $CellContext`s^2 >= -$CellContext`r ($CellContext`r - \
$CellContext`R)^(-1) $CellContext`R (
      4 $CellContext`r + $CellContext`R)^(-1) ($CellContext`r + 
      4 $CellContext`R)^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476997604044*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"30bc29d0-c3ec-4a6d-a9cd-894fcb4423c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "7"], "\[InvisibleSpace]", 
   SubscriptBox["X", "35"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"R", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", 
        RowBox[{"9", " ", "R"}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"8", " ", "r"}], "+", 
        RowBox[{"11", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 7], 
   Subscript[$CellContext`X, 35], "|"^2, 
   ":      ", $CellContext`s^2 <= $CellContext`R (
      2 $CellContext`r + $CellContext`R)^(-1) ($CellContext`r + 
      4 $CellContext`R)^2 (2 $CellContext`r + 9 $CellContext`R)/(
    8 $CellContext`r + 11 $CellContext`R)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856476999245125*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"9ef9c45e-8f32-408b-9692-2fe8cc76be47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "7"], "\[InvisibleSpace]", 
   SubscriptBox["X", "40"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["r", "2"], "+", 
         RowBox[{"4", " ", "r", " ", "R"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}]}], 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "r"}], "+", 
         RowBox[{"8", " ", "R"}]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 7], 
   Subscript[$CellContext`X, 40], "|"^2, 
   ":      ", $CellContext`s^2 <= -$CellContext`r^(-1) ($CellContext`r + 
      4 $CellContext`R)^2 (5 $CellContext`r + 
      8 $CellContext`R)^(-1) ($CellContext`r^2 + 
     4 $CellContext`r $CellContext`R - 4 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564770002753363`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"4be90a09-2757-4382-8e70-fe35066b996b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "7"], "\[InvisibleSpace]", 
   SubscriptBox["X", "55"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"R", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"4", " ", "R"}]}], ")"}], "3"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "+", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "r"}], "+", 
        RowBox[{"7", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 7], 
   Subscript[$CellContext`X, 55], "|"^2, 
   ":      ", $CellContext`s^2 <= $CellContext`R ($CellContext`r + \
$CellContext`R)^(-1) ($CellContext`r + 4 $CellContext`R)^3/(4 $CellContext`r + 
    7 $CellContext`R)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477001225093*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"515b6b7b-c346-4606-9615-72d54962e412"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "7"], "\[InvisibleSpace]", 
   SubscriptBox["X", "72"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"11", " ", "r", " ", "R"}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}], 
     RowBox[{"4", " ", "R", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "+", 
        RowBox[{"8", " ", "r", " ", "R"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 7], 
   Subscript[$CellContext`X, 72], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[1, 4] $CellContext`r $CellContext`R^(-1) ($CellContext`r + 
      4 $CellContext`R)^2 ($CellContext`r^2 + 8 $CellContext`r $CellContext`R + 
      4 $CellContext`R^2)^(-1) (2 $CellContext`r^2 + 
     11 $CellContext`r $CellContext`R + 16 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477001835451*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"65229406-79da-497d-a62f-104c23aab9fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "7"], "\[InvisibleSpace]", 
   SubscriptBox["X", "79"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r"}], "+", 
         RowBox[{"9", " ", "R"}]}], ")"}]}], 
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r"}], "-", 
         RowBox[{"7", " ", "R"}]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 7], 
   Subscript[$CellContext`X, 79], "|"^2, ":      ", $CellContext`s^2 <= 
   Rational[-1, 5] (2 $CellContext`r - 7 $CellContext`R)^(-1) ($CellContext`r + 
      4 $CellContext`R)^2 (2 $CellContext`r + 9 $CellContext`R)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564770022266703`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"2898fe88-4b3e-4c30-8935-525882d3c573"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "7"], "\[InvisibleSpace]", 
   SubscriptBox["X", "210"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"4", " ", "R"}]}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "r"}], "+", 
         RowBox[{"16", " ", "R"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"r", "-", 
         RowBox[{"8", " ", "R"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["r", "2"], "+", 
         RowBox[{"15", " ", "r", " ", "R"}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 7], 
   Subscript[$CellContext`X, 210], "|"^2, 
   ":      ", $CellContext`s^2 >= -$CellContext`r ($CellContext`r - 
      8 $CellContext`R)^(-1) ($CellContext`r + 4 $CellContext`R)^3 (
     3 $CellContext`r + 16 $CellContext`R)/($CellContext`r^2 + 
    15 $CellContext`r $CellContext`R + 8 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477007945423*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"a2ef629c-407a-4687-a37e-5308dc3ee63c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "8"], "\[InvisibleSpace]", 
   SubscriptBox["X", "12"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"21", " ", 
          SuperscriptBox["r", "2"], " ", "R"}], "-", 
         RowBox[{"40", " ", "r", " ", 
          SuperscriptBox["R", "2"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["R", "3"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"r", "+", "R"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 8], 
   Subscript[$CellContext`X, 12], "|"^2, 
   ":      ", $CellContext`s^2 >= -$CellContext`r ($CellContext`r + \
$CellContext`R)^(-1) (2 $CellContext`r + $CellContext`R)^(-1) (
     6 $CellContext`r^3 - 21 $CellContext`r^2 $CellContext`R - 
     40 $CellContext`r $CellContext`R^2 - 16 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477010913623*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"d48fd7b6-3b6e-47d7-ac00-71f542842593"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "8"], "\[InvisibleSpace]", 
   SubscriptBox["X", "21"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["r", "2"], " ", "R"}], "-", 
         RowBox[{"12", " ", "r", " ", 
          SuperscriptBox["R", "2"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["R", "3"]}]}], ")"}]}], 
      RowBox[{"R", " ", 
       RowBox[{"(", 
        RowBox[{"r", "+", "R"}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 8], 
   Subscript[$CellContext`X, 21], "|"^2, 
   ":      ", $CellContext`s^2 >= -$CellContext`r $CellContext`R^(-1) \
($CellContext`r + $CellContext`R)^(-1) (4 $CellContext`r^3 + 
     5 $CellContext`r^2 $CellContext`R - 12 $CellContext`r $CellContext`R^2 - 
     16 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477010983975*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"0cce81ad-d459-4f9d-b997-f64d7d110a2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "8"], "\[InvisibleSpace]", 
   SubscriptBox["X", "35"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"], " ", "R"}], "-", 
         RowBox[{"27", " ", "r", " ", 
          SuperscriptBox["R", "2"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["R", "3"]}]}], ")"}]}], 
      RowBox[{"R", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 8], 
   Subscript[$CellContext`X, 35], "|"^2, 
   ":      ", $CellContext`s^2 >= -$CellContext`r $CellContext`R^(-1) (
      2 $CellContext`r + $CellContext`R)^(-1) (16 $CellContext`r^3 + 
     2 $CellContext`r^2 $CellContext`R - 27 $CellContext`r $CellContext`R^2 - 
     16 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477011500784*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"e5591382-09d4-48e8-83d2-81f5fb333d5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "8"], "\[InvisibleSpace]", 
   SubscriptBox["X", "142"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", "r"}], "-", 
         RowBox[{"36", " ", "R"}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"2", " ", "R"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"6", " ", "R"}]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 8], 
   Subscript[$CellContext`X, 142], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[-1, 3] $CellContext`r (7 $CellContext`r - 
     36 $CellContext`R) ($CellContext`r + 
      2 $CellContext`R)^(-1) ($CellContext`r + 
      4 $CellContext`R)^2/($CellContext`r + 6 $CellContext`R)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564770137547398`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"4b844073-9370-4c49-bde3-cc0d0c80eec8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "8"], "\[InvisibleSpace]", 
   SubscriptBox["X", "210"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"20", " ", "r", " ", "R"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}]}], 
      RowBox[{"r", "-", "R"}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 8], 
   Subscript[$CellContext`X, 210], "|"^2, 
   ":      ", $CellContext`s^2 >= -$CellContext`r ($CellContext`r - \
$CellContext`R)^(-1) (3 $CellContext`r^2 - 20 $CellContext`r $CellContext`R + 
     16 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.85647701397071*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"c49e5b7a-010b-49d4-88f2-c1510a23e7cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "9"], "\[InvisibleSpace]", 
   SubscriptBox["X", "12"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", "R", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"5", " ", "r", " ", "R"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"r", "+", "R"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["r", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 9], 
   Subscript[$CellContext`X, 12], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[-1, 
      2] $CellContext`r $CellContext`R ($CellContext`r + $CellContext`R)^(-1) \
(2 $CellContext`r + $CellContext`R)^(-1) ($CellContext`r + 
      4 $CellContext`R)^2 ($CellContext`r^2 - 2 $CellContext`R^2)^(-1) (
     2 $CellContext`r^2 + 5 $CellContext`r $CellContext`R + 
     4 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477015160569*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"299ae6cc-774e-4095-8697-d105ea07ca41"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "9"], "\[InvisibleSpace]", 
   SubscriptBox["X", "21"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"5", " ", "r", " ", "R"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", "r"}], "+", 
        RowBox[{"2", " ", "R"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"r", " ", "R"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 9], 
   Subscript[$CellContext`X, 21], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r (3 $CellContext`r + 
      2 $CellContext`R)^(-1) ($CellContext`r + 4 $CellContext`R)^2 (
      2 $CellContext`r^2 + $CellContext`r $CellContext`R + 
      2 $CellContext`R^2)^(-1) (2 $CellContext`r^2 + 
     5 $CellContext`r $CellContext`R + 4 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477015345051*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"83d936f6-c010-412c-abf4-2160b782e385"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "9"], "\[InvisibleSpace]", 
   SubscriptBox["X", "35"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      SuperscriptBox["R", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{"r", " ", "R"}], "+", 
        SuperscriptBox["R", "2"]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 9], 
   Subscript[$CellContext`X, 35], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r $CellContext`R^2 (
      2 $CellContext`r + $CellContext`R)^(-1) ($CellContext`r + 
      4 $CellContext`R)^2/($CellContext`r^2 - $CellContext`r $CellContext`R + \
$CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477015769493*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"e7902258-2470-4361-a9c9-8121153f61ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "9"], "\[InvisibleSpace]", 
   SubscriptBox["X", "55"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", "R", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"4", " ", "R"}]}], ")"}], "3"]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"r", "+", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 9], 
   Subscript[$CellContext`X, 55], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[1, 
      2] $CellContext`r $CellContext`R ($CellContext`r + $CellContext`R)^(-1) \
($CellContext`r + 4 $CellContext`R)^3/($CellContext`r^2 + 2 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477016742867*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"b6045926-c7fa-42a6-99b1-c08c4d843de1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "9"], "\[InvisibleSpace]", 
   SubscriptBox["X", "65"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"5", " ", "r", " ", "R"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}], 
     RowBox[{"2", " ", "R", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "+", 
        RowBox[{"6", " ", "r", " ", "R"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 9], 
   Subscript[$CellContext`X, 65], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[1, 2] $CellContext`r $CellContext`R^(-1) ($CellContext`r + 
      4 $CellContext`R)^2 ($CellContext`r^2 + 6 $CellContext`r $CellContext`R + 
      2 $CellContext`R^2)^(-1) (2 $CellContext`r^2 + 
     5 $CellContext`r $CellContext`R + 4 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477017098982*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"d7ca37c1-ca74-46ce-831f-5f068d1102e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "10"], "\[InvisibleSpace]", 
   SubscriptBox["X", "20"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    RowBox[{
     FractionBox["1", "15"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"21", " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{"64", " ", "r", " ", "R"}], "+", 
       RowBox[{"64", " ", 
        SuperscriptBox["R", "2"]}]}], ")"}]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 10], 
   Subscript[$CellContext`X, 20], "|"^2, ":      ", $CellContext`s^2 <= 
   Rational[1, 15] (21 $CellContext`r^2 + 64 $CellContext`r $CellContext`R + 
     64 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477029037887*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"559af568-afb2-4033-af08-5664e2c3be94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "10"], "\[InvisibleSpace]", 
   SubscriptBox["X", "55"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["r", "3"]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["r", "2"], " ", "R"}], "+", 
        RowBox[{"5", " ", "r", " ", 
         SuperscriptBox["R", "2"]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["R", "3"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "-", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"r", "+", "R"}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 10], 
   Subscript[$CellContext`X, 55], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r ($CellContext`r - \
$CellContext`R)^(-1) ($CellContext`r + $CellContext`R)^(-1) (
     3 $CellContext`r^3 + 12 $CellContext`r^2 $CellContext`R + 
     5 $CellContext`r $CellContext`R^2 - 16 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477030176386*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"a3be81bc-08ee-483c-bb24-6c5246614852"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "10"], "\[InvisibleSpace]", 
   SubscriptBox["X", "63"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "3"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"], " ", "R"}], "-", 
        RowBox[{"3", " ", "r", " ", 
         SuperscriptBox["R", "2"]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["R", "3"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "-", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", "r"}], "+", "R"}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 10], 
   Subscript[$CellContext`X, 63], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r ($CellContext`r - \
$CellContext`R)^(-1) (
      3 $CellContext`r + $CellContext`R)^(-1) ($CellContext`r^3 + 
     2 $CellContext`r^2 $CellContext`R - 3 $CellContext`r $CellContext`R^2 - 
     16 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477030402279*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"c9ab54c4-9ba4-4680-860f-91f175f3f6c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "10"], "\[InvisibleSpace]", 
   SubscriptBox["X", "79"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{"40", " ", 
          SuperscriptBox["r", "2"], " ", "R"}], "+", 
         RowBox[{"123", " ", "r", " ", 
          SuperscriptBox["R", "2"]}], "+", 
         RowBox[{"144", " ", 
          SuperscriptBox["R", "3"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r"}], "-", 
         RowBox[{"3", " ", "R"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"10", " ", "r"}], "+", 
         RowBox[{"3", " ", "R"}]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 10], 
   Subscript[$CellContext`X, 79], "|"^2, 
   ":      ", $CellContext`s^2 >= -$CellContext`r (2 $CellContext`r - 
      3 $CellContext`R)^(-1) (10 $CellContext`r + 3 $CellContext`R)^(-1) (
     4 $CellContext`r^3 + 40 $CellContext`r^2 $CellContext`R + 
     123 $CellContext`r $CellContext`R^2 + 144 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477030728437*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"7d463d22-54dc-4ff6-be36-b802a47bb6e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "12"], "\[InvisibleSpace]", 
   SubscriptBox["X", "20"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"18", " ", 
       SuperscriptBox["r", "4"]}], "+", 
      RowBox[{"81", " ", 
       SuperscriptBox["r", "3"], " ", "R"}], "+", 
      RowBox[{"136", " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox["R", "2"]}], "+", 
      RowBox[{"80", " ", "r", " ", 
       SuperscriptBox["R", "3"]}], "+", 
      RowBox[{"16", " ", 
       SuperscriptBox["R", "4"]}]}], 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", "r"}], "+", "R"}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 12], 
   Subscript[$CellContext`X, 20], "|"^2, ":      ", $CellContext`s^2 <= 
   Rational[1, 3] (2 $CellContext`r + $CellContext`R)^(-1) (
      3 $CellContext`r + $CellContext`R)^(-1) (18 $CellContext`r^4 + 
     81 $CellContext`r^3 $CellContext`R + 
     136 $CellContext`r^2 $CellContext`R^2 + 
     80 $CellContext`r $CellContext`R^3 + 16 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477043633449*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"5399321b-0c57-447b-8744-24291d603424"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "12"], "\[InvisibleSpace]", 
   SubscriptBox["X", "21"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"5", " ", "r", " ", "R"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}], "2"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "+", "R"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], "2"]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 12], 
   Subscript[$CellContext`X, 21], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r ($CellContext`r + \
$CellContext`R)^(-1) (2 $CellContext`r + $CellContext`R)^(-2) (
      2 $CellContext`r^2 + 5 $CellContext`r $CellContext`R + 
      4 $CellContext`R^2)^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477043753744*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"6ab3aa57-1e50-47f8-ac0b-f4db8a2ebbb0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "12"], "\[InvisibleSpace]", 
   SubscriptBox["X", "40"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"R", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "3"]}], "+", 
        RowBox[{"13", " ", 
         SuperscriptBox["r", "2"], " ", "R"}], "+", 
        RowBox[{"12", " ", "r", " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["R", "3"]}]}], ")"}]}], 
     RowBox[{"2", " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 12], 
   Subscript[$CellContext`X, 40], "|"^2, ":      ", $CellContext`s^2 <= 
   Rational[1, 2] $CellContext`r^(-1) $CellContext`R (
      2 $CellContext`r + $CellContext`R)^(-1) (2 $CellContext`r^3 + 
     13 $CellContext`r^2 $CellContext`R + 12 $CellContext`r $CellContext`R^2 + 
     4 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564770505660763`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"741ff933-1def-4dff-80d2-e7c81ad0f469"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "12"], "\[InvisibleSpace]", 
   SubscriptBox["X", "63"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", "R", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"28", " ", 
          SuperscriptBox["r", "3"], " ", "R"}], "+", 
         RowBox[{"71", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["R", "2"]}], "+", 
         RowBox[{"60", " ", "r", " ", 
          SuperscriptBox["R", "3"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["R", "4"]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["r", "2"], "-", 
         RowBox[{"r", " ", "R"}], "-", 
         SuperscriptBox["R", "2"]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 12], 
   Subscript[$CellContext`X, 63], "|"^2, 
   ":      ", $CellContext`s^2 >= -$CellContext`r $CellContext`R (
      2 $CellContext`r + $CellContext`R)^(-2) ($CellContext`r^2 - \
$CellContext`r $CellContext`R - $CellContext`R^2)^(-1) (4 $CellContext`r^4 + 
     28 $CellContext`r^3 $CellContext`R + 
     71 $CellContext`r^2 $CellContext`R^2 + 
     60 $CellContext`r $CellContext`R^3 + 16 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477052126195*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"5a3c9684-7adf-464b-8d54-268a386e8656"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "12"], "\[InvisibleSpace]", 
   SubscriptBox["X", "142"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}], "-", 
        RowBox[{"7", " ", "r", " ", "R"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "-", 
        RowBox[{"2", " ", "R"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", "r"}], "-", 
        RowBox[{"2", " ", "R"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 12], 
   Subscript[$CellContext`X, 142], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r ($CellContext`r - 
      2 $CellContext`R)^(-1) (3 $CellContext`r - 2 $CellContext`R)^(-1) (
      2 $CellContext`r + $CellContext`R)^(-1) ($CellContext`r + 
      4 $CellContext`R)^2 (2 $CellContext`r^2 - 
     7 $CellContext`r $CellContext`R + 4 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477065850486*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"d5bfeee6-b791-4579-b43f-dde8c3a573ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "12"], "\[InvisibleSpace]", 
   SubscriptBox["X", "145"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"42", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"75", " ", 
          SuperscriptBox["r", "2"], " ", "R"}], "-", 
         RowBox[{"76", " ", "r", " ", 
          SuperscriptBox["R", "2"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["R", "3"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "r"}], "+", "R"}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 12], 
   Subscript[$CellContext`X, 145], "|"^2, 
   ":      ", $CellContext`s^2 >= -$CellContext`r (
      2 $CellContext`r + $CellContext`R)^(-1) (
      3 $CellContext`r + $CellContext`R)^(-1) (42 $CellContext`r^3 - 
     75 $CellContext`r^2 $CellContext`R - 76 $CellContext`r $CellContext`R^2 - 
     16 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564770659209633`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"156b7e3a-6217-4f77-9ba9-fb7f33041a4f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "20"], "\[InvisibleSpace]", 
   SubscriptBox["X", "35"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"8", " ", 
       SuperscriptBox["r", "4"]}], "+", 
      RowBox[{"38", " ", 
       SuperscriptBox["r", "3"], " ", "R"}], "+", 
      RowBox[{"73", " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox["R", "2"]}], "+", 
      RowBox[{"56", " ", "r", " ", 
       SuperscriptBox["R", "3"]}], "+", 
      RowBox[{"16", " ", 
       SuperscriptBox["R", "4"]}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "r"}], "+", 
        RowBox[{"3", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 20], 
   Subscript[$CellContext`X, 35], "|"^2, 
   ":      ", $CellContext`s^2 <= (2 $CellContext`r + $CellContext`R)^(-1) (
      4 $CellContext`r + 3 $CellContext`R)^(-1) (8 $CellContext`r^4 + 
     38 $CellContext`r^3 $CellContext`R + 
     73 $CellContext`r^2 $CellContext`R^2 + 
     56 $CellContext`r $CellContext`R^3 + 16 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477092683359*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"c4dcced5-5430-4ca0-af97-9a5b4b144b14"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "20"], "\[InvisibleSpace]", 
   SubscriptBox["X", "55"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["r", "4"]}], "+", 
      RowBox[{"11", " ", 
       SuperscriptBox["r", "3"], " ", "R"}], "+", 
      RowBox[{"28", " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox["R", "2"]}], "+", 
      RowBox[{"32", " ", "r", " ", 
       SuperscriptBox["R", "3"]}], "+", 
      RowBox[{"16", " ", 
       SuperscriptBox["R", "4"]}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "+", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", 
        RowBox[{"3", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 20], 
   Subscript[$CellContext`X, 55], "|"^2, 
   ":      ", $CellContext`s^2 <= ($CellContext`r + $CellContext`R)^(-1) (
      2 $CellContext`r + 3 $CellContext`R)^(-1) (2 $CellContext`r^4 + 
     11 $CellContext`r^3 $CellContext`R + 
     28 $CellContext`r^2 $CellContext`R^2 + 
     32 $CellContext`r $CellContext`R^3 + 16 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477094759555*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"45e1d063-6ec7-4abc-aeda-604ea2661360"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "20"], "\[InvisibleSpace]", 
   SubscriptBox["X", "65"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["r", "3"]}], "-", 
       RowBox[{"16", " ", "r", " ", 
        SuperscriptBox["R", "2"]}], "-", 
       RowBox[{"16", " ", 
        SuperscriptBox["R", "3"]}]}], 
      RowBox[{"r", "+", 
       RowBox[{"3", " ", "R"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 20], 
   Subscript[$CellContext`X, 65], "|"^2, 
   ":      ", $CellContext`s^2 <= -($CellContext`r + 3 $CellContext`R)^(-1) (
     3 $CellContext`r^3 - 16 $CellContext`r $CellContext`R^2 - 
     16 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477095130807*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"4edcf1fe-6b90-4862-ab4e-c69ce1f378ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "20"], "\[InvisibleSpace]", 
   SubscriptBox["X", "79"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"24", " ", 
       SuperscriptBox["r", "4"]}], "+", 
      RowBox[{"166", " ", 
       SuperscriptBox["r", "3"], " ", "R"}], "+", 
      RowBox[{"409", " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox["R", "2"]}], "+", 
      RowBox[{"408", " ", "r", " ", 
       SuperscriptBox["R", "3"]}], "+", 
      RowBox[{"144", " ", 
       SuperscriptBox["R", "4"]}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "r"}], "+", 
        RowBox[{"3", " ", "R"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"10", " ", "r"}], "+", 
        RowBox[{"9", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 20], 
   Subscript[$CellContext`X, 79], "|"^2, 
   ":      ", $CellContext`s^2 <= (4 $CellContext`r + 3 $CellContext`R)^(-1) (
      10 $CellContext`r + 9 $CellContext`R)^(-1) (24 $CellContext`r^4 + 
     166 $CellContext`r^3 $CellContext`R + 
     409 $CellContext`r^2 $CellContext`R^2 + 
     408 $CellContext`r $CellContext`R^3 + 144 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477095684678*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"a8741cee-9ffc-4850-b4e7-19413919a401"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "20"], "\[InvisibleSpace]", 
   SubscriptBox["X", "142"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"15", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"60", " ", "r", " ", "R"}], "+", 
        RowBox[{"64", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", "r"}], "+", 
        RowBox[{"10", " ", "R"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"7", " ", "r"}], "+", 
        RowBox[{"22", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 20], 
   Subscript[$CellContext`X, 142], "|"^2, 
   ":      ", $CellContext`s^2 <= ($CellContext`r + 4 $CellContext`R)^2 (
      3 $CellContext`r + 10 $CellContext`R)^(-1) (7 $CellContext`r + 
      22 $CellContext`R)^(-1) (15 $CellContext`r^2 + 
     60 $CellContext`r $CellContext`R + 64 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477097866436*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"a323727e-d4fe-42b0-8b38-7da5466ca72a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "20"], "\[InvisibleSpace]", 
   SubscriptBox["X", "210"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["r", "3"]}], "+", 
       RowBox[{"44", " ", 
        SuperscriptBox["r", "2"], " ", "R"}], "+", 
       RowBox[{"128", " ", "r", " ", 
        SuperscriptBox["R", "2"]}], "+", 
       RowBox[{"144", " ", 
        SuperscriptBox["R", "3"]}]}], 
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"r", "-", 
         RowBox[{"7", " ", "R"}]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 20], 
   Subscript[$CellContext`X, 210], "|"^2, ":      ", $CellContext`s^2 <= 
   Rational[-1, 5] ($CellContext`r - 7 $CellContext`R)^(-1) (
     3 $CellContext`r^3 + 44 $CellContext`r^2 $CellContext`R + 
     128 $CellContext`r $CellContext`R^2 + 144 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.85647709820716*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"0722faba-64d5-4e20-ac83-84f06661b291"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "21"], "\[InvisibleSpace]", 
   SubscriptBox["X", "40"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"10", " ", 
        SuperscriptBox["r", "3"]}], "+", 
       RowBox[{"17", " ", 
        SuperscriptBox["r", "2"], " ", "R"}], "-", 
       RowBox[{"20", " ", "r", " ", 
        SuperscriptBox["R", "2"]}], "-", 
       RowBox[{"36", " ", 
        SuperscriptBox["R", "3"]}]}], 
      RowBox[{
       RowBox[{"2", " ", "r"}], "+", 
       RowBox[{"5", " ", "R"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 21], 
   Subscript[$CellContext`X, 40], "|"^2, 
   ":      ", $CellContext`s^2 <= -(2 $CellContext`r + 
      5 $CellContext`R)^(-1) (10 $CellContext`r^3 + 
     17 $CellContext`r^2 $CellContext`R - 20 $CellContext`r $CellContext`R^2 - 
     36 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477109559973*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"410e3da0-d4f0-4ee3-bd5e-855f724b7842"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "21"], "\[InvisibleSpace]", 
   SubscriptBox["X", "65"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"8", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"34", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"53", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"40", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["R", "4"]}]}], ")"}]}], 
     RowBox[{"R", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"5", " ", "r", " ", "R"}], "+", 
        SuperscriptBox["R", "2"]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 21], 
   Subscript[$CellContext`X, 65], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r $CellContext`R^(-1) (
      2 $CellContext`r^2 + 
      5 $CellContext`r $CellContext`R + $CellContext`R^2)^(-1) (
     8 $CellContext`r^4 + 34 $CellContext`r^3 $CellContext`R + 
     53 $CellContext`r^2 $CellContext`R^2 + 
     40 $CellContext`r $CellContext`R^3 + 16 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477111298162*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"94bbef51-1c1a-4ae6-b6a5-70603bcc2aae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "21"], "\[InvisibleSpace]", 
   SubscriptBox["X", "72"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"34", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"104", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"135", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        RowBox[{"64", " ", 
         SuperscriptBox["R", "4"]}]}], ")"}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"r", "+", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"3", " ", "r", " ", "R"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 21], 
   Subscript[$CellContext`X, 72], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[1, 2] $CellContext`r ($CellContext`r + $CellContext`R)^(-1) (
      2 $CellContext`r^2 + 3 $CellContext`r $CellContext`R + 
      2 $CellContext`R^2)^(-1) (4 $CellContext`r^4 + 
     34 $CellContext`r^3 $CellContext`R + 
     104 $CellContext`r^2 $CellContext`R^2 + 
     135 $CellContext`r $CellContext`R^3 + 64 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477111964663*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"0b4756e6-8f27-49a9-b57d-b1e4ca349ab8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "21"], "\[InvisibleSpace]", 
   SubscriptBox["X", "79"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"11", " ", "r", " ", "R"}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"6", " ", "r"}], "+", "R"}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 21], 
   Subscript[$CellContext`X, 79], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r (
      6 $CellContext`r + $CellContext`R)^(-1) (2 $CellContext`r^2 + 
     11 $CellContext`r $CellContext`R + 16 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477113860029*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"d354a528-6cf4-4eba-a2b2-322d29ded24f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "21"], "\[InvisibleSpace]", 
   SubscriptBox["X", "142"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"r", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["r", "3"]}], "+", 
       RowBox[{"16", " ", 
        SuperscriptBox["r", "2"], " ", "R"}], "+", 
       RowBox[{"15", " ", "r", " ", 
        SuperscriptBox["R", "2"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["R", "3"]}]}], ")"}]}], "\[GreaterEqual]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{"5", " ", "r", " ", "R"}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["R", "2"]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"6", " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{"17", " ", "r", " ", "R"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["R", "2"]}]}], ")"}], " ", 
     SuperscriptBox["s", "2"]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 21], 
   Subscript[$CellContext`X, 142], "|"^2, 
   ":      ", $CellContext`r ($CellContext`r + 4 $CellContext`R)^2 (
     4 $CellContext`r^3 + 16 $CellContext`r^2 $CellContext`R + 
     15 $CellContext`r $CellContext`R^2 - 4 $CellContext`R^3) >= (
     2 $CellContext`r^2 + 5 $CellContext`r $CellContext`R - 
     2 $CellContext`R^2) (6 $CellContext`r^2 + 
     17 $CellContext`r $CellContext`R + 2 $CellContext`R^2) $CellContext`s^2],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477127139093*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"d7be33e0-0aab-4199-8fbc-15e52ec0c776"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "21"], "\[InvisibleSpace]", 
   SubscriptBox["X", "145"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["r", "2"], " ", "R"}], "-", 
         RowBox[{"71", " ", "r", " ", 
          SuperscriptBox["R", "2"]}], "-", 
         RowBox[{"64", " ", 
          SuperscriptBox["R", "3"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"r", "+", "R"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"2", " ", "R"}]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 21], 
   Subscript[$CellContext`X, 145], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[-1, 
      2] $CellContext`r ($CellContext`r + $CellContext`R)^(-1) \
($CellContext`r + 2 $CellContext`R)^(-1) (6 $CellContext`r^3 - 
     10 $CellContext`r^2 $CellContext`R - 71 $CellContext`r $CellContext`R^2 - 
     64 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564771272105417`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"70e58aa5-ad57-4366-be2b-b24227c309b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "21"], "\[InvisibleSpace]", 
   SubscriptBox["X", "210"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", "R", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"10", " ", 
         SuperscriptBox["r", "3"]}], "+", 
        RowBox[{"91", " ", 
         SuperscriptBox["r", "2"], " ", "R"}], "+", 
        RowBox[{"204", " ", "r", " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"144", " ", 
         SuperscriptBox["R", "3"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "r"}], "+", 
        RowBox[{"3", " ", "R"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"r", " ", "R"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 21], 
   Subscript[$CellContext`X, 210], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r $CellContext`R (
      4 $CellContext`r + 3 $CellContext`R)^(-1) (
      2 $CellContext`r^2 + $CellContext`r $CellContext`R + 
      3 $CellContext`R^2)^(-1) (10 $CellContext`r^3 + 
     91 $CellContext`r^2 $CellContext`R + 204 $CellContext`r $CellContext`R^2 + 
     144 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477135393565*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"74b9fd6f-d45f-4c4b-a5b8-85e1580175ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "35"], "\[InvisibleSpace]", 
   SubscriptBox["X", "63"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"30", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"72", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"59", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["R", "4"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"2", " ", "r", " ", "R"}], "+", 
        SuperscriptBox["R", "2"]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 35], 
   Subscript[$CellContext`X, 63], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r (
      2 $CellContext`r + $CellContext`R)^(-1) (2 $CellContext`r^2 + 
      2 $CellContext`r $CellContext`R + $CellContext`R^2)^(-1) (
     4 $CellContext`r^4 + 30 $CellContext`r^3 $CellContext`R + 
     72 $CellContext`r^2 $CellContext`R^2 + 
     59 $CellContext`r $CellContext`R^3 + 16 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477417402506*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"da9d8005-e641-4a55-8a3e-db5d440e2cab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "35"], "\[InvisibleSpace]", 
   SubscriptBox["X", "72"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"24", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"51", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"44", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["R", "4"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"r", " ", "R"}], "+", 
        SuperscriptBox["R", "2"]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 35], 
   Subscript[$CellContext`X, 72], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r (
      2 $CellContext`r + $CellContext`R)^(-1) (
      2 $CellContext`r^2 + $CellContext`r $CellContext`R + \
$CellContext`R^2)^(-1) (4 $CellContext`r^4 + 
     24 $CellContext`r^3 $CellContext`R + 
     51 $CellContext`r^2 $CellContext`R^2 + 
     44 $CellContext`r $CellContext`R^3 + 16 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564774179013577`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"a00307f0-5d95-4f0d-a13a-91d17739b217"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "35"], "\[InvisibleSpace]", 
   SubscriptBox["X", "79"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["r", "4"]}], "+", 
      RowBox[{"32", " ", 
       SuperscriptBox["r", "3"], " ", "R"}], "+", 
      RowBox[{"87", " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox["R", "2"]}], "+", 
      RowBox[{"92", " ", "r", " ", 
       SuperscriptBox["R", "3"]}], "+", 
      RowBox[{"36", " ", 
       SuperscriptBox["R", "4"]}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", "r"}], "+", 
        RowBox[{"5", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 35], 
   Subscript[$CellContext`X, 79], "|"^2, 
   ":      ", $CellContext`s^2 <= (2 $CellContext`r + $CellContext`R)^(-1) (
      6 $CellContext`r + 5 $CellContext`R)^(-1) (4 $CellContext`r^4 + 
     32 $CellContext`r^3 $CellContext`R + 
     87 $CellContext`r^2 $CellContext`R^2 + 
     92 $CellContext`r $CellContext`R^3 + 36 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477419165098*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"decee373-c72b-4d6b-9bc0-45e91bc62f48"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "35"], "\[InvisibleSpace]", 
   SubscriptBox["X", "142"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"r", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["r", "3"]}], "+", 
       RowBox[{"24", " ", 
        SuperscriptBox["r", "2"], " ", "R"}], "+", 
       RowBox[{"35", " ", "r", " ", 
        SuperscriptBox["R", "2"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["R", "3"]}]}], ")"}]}], "\[GreaterEqual]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"r", "+", 
       RowBox[{"2", " ", "R"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"6", " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{"13", " ", "r", " ", "R"}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["R", "2"]}]}], ")"}], " ", 
     SuperscriptBox["s", "2"]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 35], 
   Subscript[$CellContext`X, 142], "|"^2, 
   ":      ", $CellContext`r ($CellContext`r + 4 $CellContext`R)^2 (
     4 $CellContext`r^3 + 24 $CellContext`r^2 $CellContext`R + 
     35 $CellContext`r $CellContext`R^2 - 4 $CellContext`R^3) >= (
     2 $CellContext`r + $CellContext`R) ($CellContext`r + 2 $CellContext`R) (
     6 $CellContext`r^2 + 13 $CellContext`r $CellContext`R - 
     2 $CellContext`R^2) $CellContext`s^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477432422152*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"cc3ebb18-12cf-465a-9c49-8160b7a0844f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "35"], "\[InvisibleSpace]", 
   SubscriptBox["X", "145"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"24", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"106", " ", 
          SuperscriptBox["r", "2"], " ", "R"}], "-", 
         RowBox[{"83", " ", "r", " ", 
          SuperscriptBox["R", "2"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["R", "3"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "r"}], "+", "R"}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 35], 
   Subscript[$CellContext`X, 145], "|"^2, 
   ":      ", $CellContext`s^2 >= -$CellContext`r (
      2 $CellContext`r + $CellContext`R)^(-1) (
      4 $CellContext`r + $CellContext`R)^(-1) (24 $CellContext`r^3 - 
     106 $CellContext`r^2 $CellContext`R - 83 $CellContext`r $CellContext`R^2 - 
     16 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564774324936438`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"3d8f9f9c-2c11-4ec4-9b2a-2da7aa591de6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "35"], "\[InvisibleSpace]", 
   SubscriptBox["X", "210"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", "R", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["r", "3"]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["r", "2"], " ", "R"}], "+", 
        RowBox[{"71", " ", "r", " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"64", " ", 
         SuperscriptBox["R", "3"]}]}], ")"}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}], "-", 
        RowBox[{"r", " ", "R"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 35], 
   Subscript[$CellContext`X, 210], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[1, 2] $CellContext`r $CellContext`R (
      2 $CellContext`r + $CellContext`R)^(-1) (
      2 $CellContext`r^2 - $CellContext`r $CellContext`R + 
      2 $CellContext`R^2)^(-1) (4 $CellContext`r^3 + 
     32 $CellContext`r^2 $CellContext`R + 71 $CellContext`r $CellContext`R^2 + 
     64 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564774412606907`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"b4ad08f7-be58-4d24-8a39-e4506f012c8b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "40"], "\[InvisibleSpace]", 
   SubscriptBox["X", "79"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"R", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "3"], "+", 
        RowBox[{"7", " ", 
         SuperscriptBox["r", "2"], " ", "R"}], "+", 
        RowBox[{"12", " ", "r", " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["R", "3"]}]}], ")"}]}], 
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "r"}], "+", 
        RowBox[{"3", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 40], 
   Subscript[$CellContext`X, 79], "|"^2, 
   ":      ", $CellContext`s^2 <= $CellContext`r^(-1) $CellContext`R (
      4 $CellContext`r + 3 $CellContext`R)^(-1) ($CellContext`r^3 + 
     7 $CellContext`r^2 $CellContext`R + 12 $CellContext`r $CellContext`R^2 + 
     9 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564775948260202`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"52c5c655-2975-4384-98a0-003205d0ca42"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "40"], "\[InvisibleSpace]", 
   SubscriptBox["X", "142"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["r", "2"], "+", 
         RowBox[{"4", " ", "r", " ", "R"}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"2", " ", "R"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "r"}], "+", 
         RowBox[{"14", " ", "R"}]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 40], 
   Subscript[$CellContext`X, 142], "|"^2, 
   ":      ", $CellContext`s^2 <= -($CellContext`r + 
      2 $CellContext`R)^(-1) ($CellContext`r + 4 $CellContext`R)^2 (
      5 $CellContext`r + 14 $CellContext`R)^(-1) ($CellContext`r^2 + 
     4 $CellContext`r $CellContext`R - 16 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477596968174*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"dbf5a6ce-442a-4882-a833-096120c504f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "40"], "\[InvisibleSpace]", 
   SubscriptBox["X", "145"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "7"}], " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{"52", " ", "r", " ", "R"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["R", "2"]}]}], ")"}]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 40], 
   Subscript[$CellContext`X, 145], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[1, 3] ((-7) $CellContext`r^2 + 52 $CellContext`r $CellContext`R - 
     4 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477597006061*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"b253297c-7b29-43a3-a09a-452fd327487a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "40"], "\[InvisibleSpace]", 
   SubscriptBox["X", "210"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{"R", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"20", " ", "r", " ", "R"}], "+", 
        RowBox[{"36", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "r"}], "+", 
        RowBox[{"4", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 40], 
   Subscript[$CellContext`X, 210], "|"^2, ":      ", $CellContext`s^2 <= 
   Rational[1, 2] $CellContext`R (-$CellContext`r + 4 $CellContext`R)^(-1) (
     5 $CellContext`r^2 + 20 $CellContext`r $CellContext`R + 
     36 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477597611999*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"ad1bfbbb-ac62-419e-9c05-db555f46e266"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "55"], "\[InvisibleSpace]", 
   SubscriptBox["X", "72"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "4"], "+", 
        RowBox[{"7", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"20", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"27", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["R", "4"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "+", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "+", 
        RowBox[{"r", " ", "R"}], "+", 
        SuperscriptBox["R", "2"]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 55], 
   Subscript[$CellContext`X, 72], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r ($CellContext`r + \
$CellContext`R)^(-1) ($CellContext`r^2 + $CellContext`r $CellContext`R + \
$CellContext`R^2)^(-1) ($CellContext`r^4 + 7 $CellContext`r^3 $CellContext`R + 
     20 $CellContext`r^2 $CellContext`R^2 + 
     27 $CellContext`r $CellContext`R^3 + 16 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477943608905*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"79df4c43-e578-4a54-b64b-a5d5d16a106f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "55"], "\[InvisibleSpace]", 
   SubscriptBox["X", "79"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[LessEqual]", 
    FractionBox[
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["r", "4"]}], "+", 
      RowBox[{"38", " ", 
       SuperscriptBox["r", "3"], " ", "R"}], "+", 
      RowBox[{"126", " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox["R", "2"]}], "+", 
      RowBox[{"170", " ", "r", " ", 
       SuperscriptBox["R", "3"]}], "+", 
      RowBox[{"81", " ", 
       SuperscriptBox["R", "4"]}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"r", "+", "R"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", "r"}], "+", 
        RowBox[{"7", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 55], 
   Subscript[$CellContext`X, 79], "|"^2, ":      ", $CellContext`s^2 <= 
   Rational[1, 2] ($CellContext`r + $CellContext`R)^(-1) (6 $CellContext`r + 
      7 $CellContext`R)^(-1) (4 $CellContext`r^4 + 
     38 $CellContext`r^3 $CellContext`R + 
     126 $CellContext`r^2 $CellContext`R^2 + 
     170 $CellContext`r $CellContext`R^3 + 81 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856477944539938*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"67c33506-90a5-4941-ba8c-0aa51f63b0ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "55"], "\[InvisibleSpace]", 
   SubscriptBox["X", "142"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"r", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"4", " ", "R"}]}], ")"}], "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["r", "2"], "+", 
       RowBox[{"4", " ", "r", " ", "R"}], "-", 
       SuperscriptBox["R", "2"]}], ")"}]}], "\[GreaterEqual]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"r", "+", "R"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"r", "+", 
       RowBox[{"2", " ", "R"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{"7", " ", "r", " ", "R"}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["R", "2"]}]}], ")"}], " ", 
     SuperscriptBox["s", "2"]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 55], 
   Subscript[$CellContext`X, 142], "|"^2, 
   ":      ", $CellContext`r ($CellContext`r + 
      4 $CellContext`R)^3 ($CellContext`r^2 + 
     4 $CellContext`r $CellContext`R - $CellContext`R^2) >= ($CellContext`r + \
$CellContext`R) ($CellContext`r + 2 $CellContext`R) (3 $CellContext`r^2 + 
     7 $CellContext`r $CellContext`R - 2 $CellContext`R^2) $CellContext`s^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564779535324097`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"4b97e41b-8ed7-44eb-adfd-ad7569f4fa42"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "63"], "\[InvisibleSpace]", 
   SubscriptBox["X", "65"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"10", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"23", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"28", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["R", "4"]}]}], ")"}]}], 
     RowBox[{"R", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "+", 
        RowBox[{"3", " ", "r", " ", "R"}], "+", 
        SuperscriptBox["R", "2"]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 63], 
   Subscript[$CellContext`X, 65], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r $CellContext`R^(-1) \
($CellContext`r^2 + 3 $CellContext`r $CellContext`R + $CellContext`R^2)^(-1) (
     2 $CellContext`r^4 + 10 $CellContext`r^3 $CellContext`R + 
     23 $CellContext`r^2 $CellContext`R^2 + 
     28 $CellContext`r $CellContext`R^3 + 16 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564780665436907`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"0a180153-8a4d-4e8c-8795-dde5f89d215a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "63"], "\[InvisibleSpace]", 
   SubscriptBox["X", "79"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", "R", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"74", " ", 
          SuperscriptBox["r", "3"], " ", "R"}], "+", 
         RowBox[{"240", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["R", "2"]}], "+", 
         RowBox[{"315", " ", "r", " ", 
          SuperscriptBox["R", "3"]}], "+", 
         RowBox[{"144", " ", 
          SuperscriptBox["R", "4"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"12", " ", "r", " ", "R"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 63], 
   Subscript[$CellContext`X, 79], "|"^2, 
   ":      ", $CellContext`s^2 >= -$CellContext`r $CellContext`R (
      2 $CellContext`r^2 - 3 $CellContext`R^2)^(-1) (8 $CellContext`r^2 + 
      12 $CellContext`r $CellContext`R + 3 $CellContext`R^2)^(-1) (
     8 $CellContext`r^4 + 74 $CellContext`r^3 $CellContext`R + 
     240 $CellContext`r^2 $CellContext`R^2 + 
     315 $CellContext`r $CellContext`R^3 + 144 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564780692510138`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"b848bcfc-4720-4473-abeb-45b4f3855907"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "63"], "\[InvisibleSpace]", 
   SubscriptBox["X", "145"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"28", " ", 
          SuperscriptBox["r", "2"], " ", "R"}], "-", 
         RowBox[{"96", " ", "r", " ", 
          SuperscriptBox["R", "2"]}], "-", 
         RowBox[{"64", " ", 
          SuperscriptBox["R", "3"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"2", " ", "R"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "r"}], "+", 
         RowBox[{"2", " ", "R"}]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 63], 
   Subscript[$CellContext`X, 145], "|"^2, 
   ":      ", $CellContext`s^2 >= -$CellContext`r ($CellContext`r + 
      2 $CellContext`R)^(-1) (3 $CellContext`r + 2 $CellContext`R)^(-1) (
     7 $CellContext`r^3 - 28 $CellContext`r^2 $CellContext`R - 
     96 $CellContext`r $CellContext`R^2 - 64 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856478085101604*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"a2d415f1-1a09-483e-9b6a-175b3c484bfb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "63"], "\[InvisibleSpace]", 
   SubscriptBox["X", "210"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", "R", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
      RowBox[{
       SuperscriptBox["r", "2"], "-", 
       RowBox[{"3", " ", "r", " ", "R"}], "-", 
       SuperscriptBox["R", "2"]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 63], 
   Subscript[$CellContext`X, 210], "|"^2, 
   ":      ", $CellContext`s^2 >= -$CellContext`r $CellContext`R \
($CellContext`r + 4 $CellContext`R)^2/($CellContext`r^2 - 
    3 $CellContext`r $CellContext`R - $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856478085797574*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"f12b072c-76a6-486e-ae36-1998e8877005"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "65"], "\[InvisibleSpace]", 
   SubscriptBox["X", "142"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"9", " ", "r", " ", "R"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"2", " ", "R"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"7", " ", "r", " ", "R"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 65], 
   Subscript[$CellContext`X, 142], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r ($CellContext`r + 
      2 $CellContext`R)^(-1) ($CellContext`r + 4 $CellContext`R)^2 (
      2 $CellContext`r^2 + 7 $CellContext`r $CellContext`R + 
      2 $CellContext`R^2)^(-1) (6 $CellContext`r^2 + 
     9 $CellContext`r $CellContext`R + 4 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856478098588472*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"82d31597-3cff-4d0f-9a3c-8773cfcab673"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "72"], "\[InvisibleSpace]", 
   SubscriptBox["X", "79"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"8", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"62", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"183", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"252", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        RowBox[{"144", " ", 
         SuperscriptBox["R", "4"]}]}], ")"}]}], 
     RowBox[{"3", " ", "R", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"9", " ", "r", " ", "R"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 72], 
   Subscript[$CellContext`X, 79], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[1, 3] $CellContext`r $CellContext`R^(-1) (2 $CellContext`r^2 + 
      9 $CellContext`r $CellContext`R + 3 $CellContext`R^2)^(-1) (
     8 $CellContext`r^4 + 62 $CellContext`r^3 $CellContext`R + 
     183 $CellContext`r^2 $CellContext`R^2 + 
     252 $CellContext`r $CellContext`R^3 + 144 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856478113286248*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"107d7cef-b8fc-44fe-bb7f-67d63d68cd30"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "72"], "\[InvisibleSpace]", 
   SubscriptBox["X", "142"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"29", " ", "r", " ", "R"}], "+", 
        RowBox[{"36", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"6", " ", "R"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"11", " ", "r", " ", "R"}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 72], 
   Subscript[$CellContext`X, 142], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r ($CellContext`r + 
      4 $CellContext`R)^2 ($CellContext`r + 6 $CellContext`R)^(-1) (
      2 $CellContext`r^2 + 11 $CellContext`r $CellContext`R + 
      6 $CellContext`R^2)^(-1) (6 $CellContext`r^2 + 
     29 $CellContext`r $CellContext`R + 36 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856478117944409*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"59f38e97-a052-4740-bbb6-e3f850e0a2de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "79"], "\[InvisibleSpace]", 
   SubscriptBox["X", "142"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["r", "3"]}], "+", 
        RowBox[{"24", " ", 
         SuperscriptBox["r", "2"], " ", "R"}], "+", 
        RowBox[{"27", " ", "r", " ", 
         SuperscriptBox["R", "2"]}], "-", 
        RowBox[{"36", " ", 
         SuperscriptBox["R", "3"]}]}], ")"}]}], 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"9", " ", "r", " ", "R"}], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"11", " ", "r", " ", "R"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 79], 
   Subscript[$CellContext`X, 142], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[1, 3] $CellContext`r ($CellContext`r + 4 $CellContext`R)^2 (
      2 $CellContext`r^2 + 9 $CellContext`r $CellContext`R - 
      6 $CellContext`R^2)^(-1) (2 $CellContext`r^2 + 
      11 $CellContext`r $CellContext`R + 2 $CellContext`R^2)^(-1) (
     4 $CellContext`r^3 + 24 $CellContext`r^2 $CellContext`R + 
     27 $CellContext`r $CellContext`R^2 - 36 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856478231310548*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"d831dce8-5fd1-4b75-ae3f-74f2cef32284"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "79"], "\[InvisibleSpace]", 
   SubscriptBox["X", "145"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"56", " ", 
         SuperscriptBox["r", "3"]}], "+", 
        RowBox[{"110", " ", 
         SuperscriptBox["r", "2"], " ", "R"}], "-", 
        RowBox[{"51", " ", "r", " ", 
         SuperscriptBox["R", "2"]}], "-", 
        RowBox[{"144", " ", 
         SuperscriptBox["R", "3"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "-", 
        RowBox[{"3", " ", "R"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "r"}], "+", 
        RowBox[{"3", " ", "R"}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 79], 
   Subscript[$CellContext`X, 145], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r (2 $CellContext`r - 
      3 $CellContext`R)^(-1) (4 $CellContext`r + 3 $CellContext`R)^(-1) (
     56 $CellContext`r^3 + 110 $CellContext`r^2 $CellContext`R - 
     51 $CellContext`r $CellContext`R^2 - 144 $CellContext`R^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856478231374754*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"10951d0b-c04c-48fa-ac54-14a3cd17c545"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "79"], "\[InvisibleSpace]", 
   SubscriptBox["X", "210"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"12", " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"118", " ", 
          SuperscriptBox["r", "3"], " ", "R"}], "+", 
         RowBox[{"436", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["R", "2"]}], "+", 
         RowBox[{"759", " ", "r", " ", 
          SuperscriptBox["R", "3"]}], "+", 
         RowBox[{"576", " ", 
          SuperscriptBox["R", "4"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"r", "-", 
         RowBox[{"3", " ", "R"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"19", " ", "r", " ", "R"}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 79], 
   Subscript[$CellContext`X, 210], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[-1, 2] $CellContext`r ($CellContext`r - 3 $CellContext`R)^(-1) (
      2 $CellContext`r^2 + 19 $CellContext`r $CellContext`R + 
      6 $CellContext`R^2)^(-1) (12 $CellContext`r^4 + 
     118 $CellContext`r^3 $CellContext`R + 
     436 $CellContext`r^2 $CellContext`R^2 + 
     759 $CellContext`r $CellContext`R^3 + 576 $CellContext`R^4)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564782410881147`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"b5197e78-8407-4dcb-a8e5-f9074b0c8f85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "142"], "\[InvisibleSpace]", 
   SubscriptBox["X", "145"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"39", " ", "r"}], "-", 
         RowBox[{"100", " ", "R"}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"10", " ", "R"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "r"}], "+", 
         RowBox[{"10", " ", "R"}]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 142], 
   Subscript[$CellContext`X, 145], "|"^2, 
   ":      ", $CellContext`s^2 >= -$CellContext`r (39 $CellContext`r - 
     100 $CellContext`R) ($CellContext`r + 
      4 $CellContext`R)^2 ($CellContext`r + 10 $CellContext`R)^(-1)/(
    3 $CellContext`r + 10 $CellContext`R)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856478657086339*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"3f29246f-9d88-4c71-ae56-c023d0b04315"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "142"], "\[InvisibleSpace]", 
   SubscriptBox["X", "210"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    FractionBox[
     RowBox[{"r", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"4", " ", "R"}]}], ")"}], "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", "r"}], "+", 
        RowBox[{"25", " ", "R"}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"10", " ", "R"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"15", " ", "r", " ", "R"}], "+", 
        RowBox[{"10", " ", 
         SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 142], 
   Subscript[$CellContext`X, 210], "|"^2, 
   ":      ", $CellContext`s^2 >= $CellContext`r ($CellContext`r + 
      4 $CellContext`R)^3 ($CellContext`r + 10 $CellContext`R)^(-1) (
     6 $CellContext`r + 25 $CellContext`R)/(2 $CellContext`r^2 + 
    15 $CellContext`r $CellContext`R + 10 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.8564786596757097`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"2cd344cf-7c22-4d1b-a461-9eef559a02e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"|\"\>", "\[InvisibleSpace]", 
   SubscriptBox["X", "145"], "\[InvisibleSpace]", 
   SubscriptBox["X", "210"], "\[InvisibleSpace]", 
   SuperscriptBox["\<\"|\"\>", "2"], "\[InvisibleSpace]", "\<\":      \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["s", "2"], "\[GreaterEqual]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"56", " ", "r", " ", "R"}], "-", 
         RowBox[{"400", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}]}], 
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"5", " ", "R"}]}], ")"}]}]]}]}]}],
  SequenceForm["|", 
   Subscript[$CellContext`X, 145], 
   Subscript[$CellContext`X, 210], "|"^2, ":      ", $CellContext`s^2 >= 
   Rational[-1, 5] $CellContext`r ($CellContext`r + 5 $CellContext`R)^(-1) (
     3 $CellContext`r^2 + 56 $CellContext`r $CellContext`R - 
     400 $CellContext`R^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.855742387199416*^9, 3.855821266210017*^9, 
  3.85582135496104*^9, 3.855825395115095*^9, 3.8558256359977016`*^9, 
  3.855825671176668*^9, 3.8559192059926443`*^9, 3.8559192458707247`*^9, 
  3.856478669020713*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"c7e4449f-6b3b-4b2e-b5fa-89f803be7ca7"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["The Distances (large)", "Section",
 CellChangeTimes->{{3.854270562186454*^9, 3.854270570452723*^9}, {
  3.854282919791356*^9, 3.854282920310923*^9}, {3.856473684661944*^9, 
  3.856473689477685*^9}, {3.8564737734387207`*^9, 3.8564737801261578`*^9}, {
  3.856473868814726*^9, 3.856473879126322*^9}, {3.856473980054805*^9, 
  3.856473986470439*^9}, {3.856474033230908*^9, 
  3.856474035950698*^9}},ExpressionUUID->"ea3a8e69-0aee-47c9-b2fa-\
a44cc731d8fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "rRsList", "]"}]], "Input",
 CellChangeTimes->{{3.855922275706757*^9, 3.8559222824257708`*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"a7256200-23b1-4761-9839-0e1641fc9858"],

Cell[BoxData["2346"], "Output",
 CellChangeTimes->{3.85592228377252*^9, 3.856478840980441*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"c63e8630-6755-49e3-98ac-1fbdeb2e4f72"]
}, Open  ]],

Cell["\<\
The complete list of distances between pairs of centers
can also be found in the file RrsDistances.pdf.\
\>", "Text",
 CellChangeTimes->{{3.85647404856816*^9, 3.856474098990964*^9}, {
  3.8564741343835907`*^9, 
  3.8564741400630817`*^9}},ExpressionUUID->"86bf37b1-c3c3-44a9-8fea-\
1e5c6f0868a0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", "rRsList", "]"}]], "Input",
 CellChangeTimes->{{3.8564740196801043`*^9, 3.856474028975286*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"5314dbaa-edc9-436d-9cd3-b3323e09eb5c"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         TagBox[
          TemplateBox[{"1"},
           "OutputSizeLimit`Skeleton"],
          "Column"],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{58., {2., 8.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{50., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 27, 31979572964820102185, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{56., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 27, 31979572964820102185, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{42., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 27, 31979572964820102185, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{74., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[31979572964820102185 === $SessionID, 
   Out[27], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{3.85647884158993*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"88977ccd-18b7-47ba-9f2f-c2f900879a6f"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Section 2.4: The Short Polynomials", "Section",
 CellChangeTimes->{{3.854270562186454*^9, 3.854270570452723*^9}, {
  3.854282919791356*^9, 3.854282920310923*^9}, {3.856473684661944*^9, 
  3.856473689477685*^9}, {3.8564737734387207`*^9, 3.8564737801261578`*^9}, {
  3.856473868814726*^9, 3.856473879126322*^9}, {3.856473980054805*^9, 
  3.856473986470439*^9}, {3.856474033230908*^9, 3.856474035950698*^9}, {
  3.856474186007576*^9, 
  3.856474205559279*^9}},ExpressionUUID->"b403c239-118f-4b39-8a6e-\
aa5be5408a2a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"short", "=", 
   RowBox[{"Select", "[", 
    RowBox[{"rRsList", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"PolynomialQ", "[", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "7"}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "R", ",", "s"}], "}"}]}], "]"}], "&&", 
       RowBox[{
        RowBox[{"Length", "[", 
         RowBox[{"Expand", "[", 
          RowBox[{"#", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "7"}], "]"}], "]"}], "]"}], "]"}], "<", "4"}]}],
       "&"}]}], "]"}]}], ";", 
  RowBox[{"scol", "=", 
   RowBox[{"Column", "[", "short", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8559233573036613`*^9, 3.855923360637686*^9}, {
   3.855926739709991*^9, 3.85592674139596*^9}, 3.856474350764409*^9},
 CellLabel->"In[28]:=",ExpressionUUID->"db0f2f92-3b0e-4f3a-b675-00700ec10e2e"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "1"],SubscriptBox["X", "2"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{
         FractionBox["1", "9"], " ", 
         RowBox[{"(", 
           RowBox[{
             RowBox[{"5", " ", 
               SuperscriptBox["r", "2"]}], "-", 
             RowBox[{"16", " ", "r", " ", "R"}], "+", 
             SuperscriptBox["s", "2"]}], ")"}]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "1"],SubscriptBox["X", "3"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{"R", " ", 
         RowBox[{"(", 
           RowBox[{
             RowBox[{
               RowBox[{"-", "2"}], " ", "r"}], "+", "R"}], ")"}]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "1"],SubscriptBox["X", "5"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{
         FractionBox["1", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                RowBox[{"-", "2"}], " ", "r"}], "+", "R"}], ")"}], "2"]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "1"],SubscriptBox["X", "8"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{
         RowBox[{"5", " ", 
           SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"16", " ", "r", " ", "R"}], "+", 
         SuperscriptBox["s", "2"]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "1"],SubscriptBox["X", "10"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
           RowBox[{
             RowBox[{"5", " ", 
               SuperscriptBox["r", "2"]}], "-", 
             RowBox[{"16", " ", "r", " ", "R"}], "+", 
             SuperscriptBox["s", "2"]}], ")"}]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "1"],SubscriptBox["X", "11"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",SuperscriptBox["r", "2"]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "1"],SubscriptBox["X", "40"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{"4", " ", "R", " ", 
         RowBox[{"(", 
           RowBox[{
             RowBox[{
               RowBox[{"-", "2"}], " ", "r"}], "+", "R"}], ")"}]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "1"],SubscriptBox["X", "80"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{"4", " ", 
         SuperscriptBox["r", "2"]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "1"],SubscriptBox["X", "145"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{
         RowBox[{"5", " ", 
           SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"16", " ", "r", " ", "R"}], "+", 
         SuperscriptBox["s", "2"]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "2"],SubscriptBox["X", "8"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{
         FractionBox["4", "9"], " ", 
         RowBox[{"(", 
           RowBox[{
             RowBox[{"5", " ", 
               SuperscriptBox["r", "2"]}], "-", 
             RowBox[{"16", " ", "r", " ", "R"}], "+", 
             SuperscriptBox["s", "2"]}], ")"}]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "2"],SubscriptBox["X", "10"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{
         FractionBox["1", "36"], " ", 
         RowBox[{"(", 
           RowBox[{
             RowBox[{"5", " ", 
               SuperscriptBox["r", "2"]}], "-", 
             RowBox[{"16", " ", "r", " ", "R"}], "+", 
             SuperscriptBox["s", "2"]}], ")"}]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "2"],SubscriptBox["X", "145"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{
         FractionBox["16", "9"], " ", 
         RowBox[{"(", 
           RowBox[{
             RowBox[{"5", " ", 
               SuperscriptBox["r", "2"]}], "-", 
             RowBox[{"16", " ", "r", " ", "R"}], "+", 
             SuperscriptBox["s", "2"]}], ")"}]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "3"],SubscriptBox["X", "8"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",SuperscriptBox[
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{"-", "2"}], " ", "r"}], "+", "R"}], ")"}], "2"]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "3"],SubscriptBox["X", "40"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{"R", " ", 
         RowBox[{"(", 
           RowBox[{
             RowBox[{
               RowBox[{"-", "2"}], " ", "r"}], "+", "R"}], ")"}]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "3"],SubscriptBox["X", "99"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",SuperscriptBox["R", "2"]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "4"],SubscriptBox["X", "8"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{"4", " ", "R", " ", 
         RowBox[{"(", 
           RowBox[{
             RowBox[{
               RowBox[{"-", "2"}], " ", "r"}], "+", "R"}], ")"}]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "4"],SubscriptBox["X", "145"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                RowBox[{"-", "2"}], " ", "r"}], "+", "R"}], ")"}], "2"]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "5"],SubscriptBox["X", "10"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{
         FractionBox["1", "4"], " ", "R", " ", 
         RowBox[{"(", 
           RowBox[{
             RowBox[{
               RowBox[{"-", "2"}], " ", "r"}], "+", "R"}], ")"}]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "5"],SubscriptBox["X", "11"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",FractionBox[
        SuperscriptBox["R", "2"], "4"]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "5"],SubscriptBox["X", "40"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{
         RowBox[{"r", " ", "R"}], "+", 
         FractionBox[
          RowBox[{"25", " ", 
            SuperscriptBox["R", "2"]}], "4"], "-", 
         SuperscriptBox["s", "2"]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "5"],SubscriptBox["X", "80"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{
         FractionBox["1", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], "2"]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "8"],SubscriptBox["X", "10"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
           RowBox[{
             RowBox[{"5", " ", 
               SuperscriptBox["r", "2"]}], "-", 
             RowBox[{"16", " ", "r", " ", "R"}], "+", 
             SuperscriptBox["s", "2"]}], ")"}]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "8"],SubscriptBox["X", "145"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{"4", " ", 
         RowBox[{"(", 
           RowBox[{
             RowBox[{"5", " ", 
               SuperscriptBox["r", "2"]}], "-", 
             RowBox[{"16", " ", "r", " ", "R"}], "+", 
             SuperscriptBox["s", "2"]}], ")"}]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "10"],SubscriptBox["X", "145"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{
         FractionBox["9", "4"], " ", 
         RowBox[{"(", 
           RowBox[{
             RowBox[{"5", " ", 
               SuperscriptBox["r", "2"]}], "-", 
             RowBox[{"16", " ", "r", " ", "R"}], "+", 
             SuperscriptBox["s", "2"]}], ")"}]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "11"],SubscriptBox["X", "80"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",SuperscriptBox["r", "2"]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "20"],SubscriptBox["X", "145"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{"16", " ", "R", " ", 
         RowBox[{"(", 
           RowBox[{
             RowBox[{
               RowBox[{"-", "2"}], " ", "r"}], "+", "R"}], ")"}]}]},
      "RowDefault"]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 CellChangeTimes->{3.855923362396881*^9, 3.855926743403235*^9, 
  3.856478842152628*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"e6f1d089-4604-4fbc-85aa-cffbde20575a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Section 2.5: The Perfect Squares", "Section",
 CellChangeTimes->{{3.854270562186454*^9, 3.854270570452723*^9}, {
  3.854282919791356*^9, 3.854282920310923*^9}, {3.856473684661944*^9, 
  3.856473689477685*^9}, {3.8564737734387207`*^9, 3.8564737801261578`*^9}, {
  3.856473868814726*^9, 3.856473879126322*^9}, {3.856473980054805*^9, 
  3.856473986470439*^9}, {3.856474033230908*^9, 3.856474035950698*^9}, {
  3.856474186007576*^9, 3.856474205559279*^9}, {3.856474381104312*^9, 
  3.85647438865589*^9}},ExpressionUUID->"58ff8057-b629-4d9a-840c-\
58548e19aec4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"squares", "=", 
   RowBox[{"Select", "[", 
    RowBox[{"rRsList", ",", 
     RowBox[{
      RowBox[{"PolynomialQ", "[", 
       RowBox[{
        RowBox[{"Simplify", "[", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "7"}], "]"}], "]"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"s", ">", "0"}], ",", 
            RowBox[{"R", "\[GreaterEqual]", 
             RowBox[{"2", "r"}], ">", "0"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"r", ",", "R", ",", "s"}], "}"}]}], "]"}], "&"}]}], "]"}]}], 
  ";", 
  RowBox[{"Column", "[", "squares", "]"}]}]], "Input",
 CellChangeTimes->{{3.855926304796979*^9, 3.8559263091860247`*^9}, {
  3.8564744028924913`*^9, 3.8564744054486647`*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"9958afdc-17da-40d6-969f-caf37976b093"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "1"],SubscriptBox["X", "5"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{
         FractionBox["1", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                RowBox[{"-", "2"}], " ", "r"}], "+", "R"}], ")"}], "2"]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "1"],SubscriptBox["X", "11"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",SuperscriptBox["r", "2"]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "1"],SubscriptBox["X", "80"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{"4", " ", 
         SuperscriptBox["r", "2"]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "3"],SubscriptBox["X", "8"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",SuperscriptBox[
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{"-", "2"}], " ", "r"}], "+", "R"}], ")"}], "2"]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "3"],SubscriptBox["X", "99"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",SuperscriptBox["R", "2"]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "4"],SubscriptBox["X", "145"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                RowBox[{"-", "2"}], " ", "r"}], "+", "R"}], ")"}], "2"]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "5"],SubscriptBox["X", "11"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",FractionBox[
        SuperscriptBox["R", "2"], "4"]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "5"],SubscriptBox["X", "80"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",RowBox[{
         FractionBox["1", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], "2"]}]},
      "RowDefault"]},
    {
     TemplateBox[{
      "\"|\"",SubscriptBox["X", "11"],SubscriptBox["X", "80"],SuperscriptBox[
       "\"|\"", "2"],"\":\"","\"    \"",SuperscriptBox["r", "2"]},
      "RowDefault"]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 CellChangeTimes->{3.855926310407596*^9, 3.8564808296345367`*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"3b015569-b15c-4bc8-80e7-aaf9bb30ddba"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Just the inequalities", "Section",
 CellChangeTimes->{{3.854270562186454*^9, 3.854270570452723*^9}, {
  3.854282919791356*^9, 3.854282920310923*^9}, {3.856473684661944*^9, 
  3.856473689477685*^9}, {3.8564737734387207`*^9, 3.8564737801261578`*^9}, {
  3.856473868814726*^9, 3.856473879126322*^9}, {3.856473980054805*^9, 
  3.856473986470439*^9}, {3.856474033230908*^9, 3.856474035950698*^9}, {
  3.856474186007576*^9, 3.856474205559279*^9}, {3.856474381104312*^9, 
  3.85647438865589*^9}, {3.856474465392713*^9, 
  3.8564744708000507`*^9}},ExpressionUUID->"587b802e-e706-4acc-8733-\
bc28d18f6fbd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", "list", "]"}]], "Input",
 CellChangeTimes->{{3.855930629461431*^9, 3.855930646572624*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"002ed174-46d5-49ac-91fd-4a8e7e4a37a5"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{
       RowBox[{"-", "r"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "r"}], "-", 
         RowBox[{"16", " ", "R"}]}], ")"}]}]}]},
    {
     RowBox[{"R", "\[LessEqual]", 
      FractionBox[
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        SuperscriptBox["s", "2"]}], 
       RowBox[{"16", " ", "r"}]]}]},
    {
     RowBox[{"r", "\[LessEqual]", 
      FractionBox["R", "2"]}]},
    {
     RowBox[{"R", "\[GreaterEqual]", 
      RowBox[{"2", " ", "r"}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{"4", " ", "r", " ", "R"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["R", "2"]}]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"4", " ", "R"}]}], ")"}], "2"]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
       RowBox[{"r", "+", "R"}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"19", " ", "r", " ", "R"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", "R"}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"8", " ", "r", " ", "R"}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "r"}], "-", 
          RowBox[{"4", " ", "R"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", "-", 
          RowBox[{"2", " ", "R"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"2", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", "R", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"7", " ", "r"}], "+", 
          RowBox[{"64", " ", "R"}]}], ")"}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"2", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "+", 
            RowBox[{"4", " ", "R"}]}], ")"}], "3"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"r", "-", 
           RowBox[{"2", " ", "R"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", "r"}], "+", 
           RowBox[{"2", " ", "R"}]}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{
           SuperscriptBox["r", "2"], " ", "R"}], "+", 
          RowBox[{"4", " ", "r", " ", 
           SuperscriptBox["R", "2"]}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["R", "3"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", "-", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]},
    {
     RowBox[{
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{"46", " ", 
          SuperscriptBox["r", "2"], " ", "R"}], "+", 
         RowBox[{"61", " ", "r", " ", 
          SuperscriptBox["R", "2"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["R", "3"]}]}], ")"}]}], "\[GreaterEqual]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "r"}], "-", "R"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
       SuperscriptBox["s", "2"]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      RowBox[{
       FractionBox["1", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"4", " ", "r", " ", "R"}], "+", 
         RowBox[{"36", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"15", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"28", " ", "r", " ", "R"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"3", " ", "r"}], "+", "R"}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"12", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"55", " ", "r", " ", "R"}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "r"}], "+", 
          RowBox[{"2", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{"38", " ", 
           SuperscriptBox["r", "2"], " ", "R"}], "-", 
          RowBox[{"3", " ", "r", " ", 
           SuperscriptBox["R", "2"]}], "-", 
          RowBox[{"144", " ", 
           SuperscriptBox["R", "3"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "r"}], "-", 
          RowBox[{"3", " ", "R"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"14", " ", "r"}], "+", 
          RowBox[{"3", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{
        SuperscriptBox["R", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
       RowBox[{"4", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{"r", "+", "R"}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{"R", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "r"}], "+", 
          RowBox[{"2", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"7", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"11", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"4", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        SuperscriptBox["R", "4"]}], 
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{
        SuperscriptBox["r", "3"], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["r", "2"], " ", "R"}], "+", 
        RowBox[{"6", " ", "r", " ", 
         SuperscriptBox["R", "2"]}], "-", 
        SuperscriptBox["R", "3"]}], "r"]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"26", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"52", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"30", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["R", "4"]}]}], 
       RowBox[{"6", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"32", " ", "r", " ", "R"}], "-", 
         SuperscriptBox["R", "2"]}], ")"}]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{"R", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["r", "2"], "+", 
          RowBox[{"4", " ", "r", " ", "R"}], "-", 
          RowBox[{"9", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"r", "-", "R"}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"13", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"26", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"16", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["R", "4"]}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", "+", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{
        RowBox[{"8", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"42", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"67", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"28", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["R", "4"]}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "r"}], "+", "R"}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{
        SuperscriptBox["r", "4"], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"8", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["R", "4"]}]}], 
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "r"}], "+", 
          RowBox[{"2", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{
        SuperscriptBox["r", "3"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"], " ", "R"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["R", "3"]}]}], 
       RowBox[{"r", "-", "R"}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "3"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["r", "2"], " ", "R"}], "-", 
        RowBox[{"12", " ", "r", " ", 
         SuperscriptBox["R", "2"]}], "-", 
        RowBox[{"36", " ", 
         SuperscriptBox["R", "3"]}]}], 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "-", 
          RowBox[{"3", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"12", " ", "r", " ", "R"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"6", " ", "R"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"10", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["r", "2"], " ", "R"}], "-", 
         RowBox[{"8", " ", "r", " ", 
          SuperscriptBox["R", "2"]}], "-", 
         RowBox[{"36", " ", 
          SuperscriptBox["R", "3"]}]}], 
        RowBox[{"r", "+", 
         RowBox[{"5", " ", "R"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "+", 
            RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"8", " ", "r", " ", "R"}], "-", 
           SuperscriptBox["R", "2"]}], ")"}]}], 
        RowBox[{"6", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", 
           RowBox[{"4", " ", "R"}]}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{
        RowBox[{"8", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"44", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"64", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"8", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        SuperscriptBox["R", "4"]}], 
       RowBox[{"4", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]},
    {
     RowBox[{"r", "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", "R"}], "-", 
           RowBox[{"2", " ", "s"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", "R"}], "+", 
           RowBox[{"2", " ", "s"}]}], ")"}]}], 
        RowBox[{"4", " ", "R"}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      RowBox[{
       FractionBox["1", "4"], " ", "R", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "r"}], "+", 
         RowBox[{"25", " ", "R"}]}], ")"}]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"14", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"25", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"2", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        SuperscriptBox["R", "4"]}], 
       RowBox[{"2", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{"r", "+", "R"}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"R", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"13", " ", 
            SuperscriptBox["r", "2"], " ", "R"}], "-", 
           RowBox[{"22", " ", "r", " ", 
            SuperscriptBox["R", "2"]}], "+", 
           SuperscriptBox["R", "3"]}], ")"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "r"}], "+", "R"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{
        RowBox[{"6", " ", 
         SuperscriptBox["r", "3"]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["r", "2"], " ", "R"}], "+", 
        RowBox[{"8", " ", "r", " ", 
         SuperscriptBox["R", "2"]}], "-", 
        SuperscriptBox["R", "3"]}], 
       RowBox[{"2", " ", "r"}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{
        RowBox[{"6", " ", 
         SuperscriptBox["r", "3"]}], "+", 
        RowBox[{"26", " ", 
         SuperscriptBox["r", "2"], " ", "R"}], "+", 
        RowBox[{"28", " ", "r", " ", 
         SuperscriptBox["R", "2"]}], "-", 
        SuperscriptBox["R", "3"]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"r", "+", "R"}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"R", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"56", " ", 
            SuperscriptBox["r", "2"], " ", "R"}], "-", 
           RowBox[{"96", " ", "r", " ", 
            SuperscriptBox["R", "2"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["R", "3"]}]}], ")"}]}], 
        RowBox[{"8", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "r"}], "+", 
           RowBox[{"3", " ", "R"}]}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "42"}], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"104", " ", "r", " ", "R"}], "-", 
         SuperscriptBox["R", "2"]}], ")"}]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{
        RowBox[{"6", " ", 
         SuperscriptBox["r", "3"]}], "+", 
        RowBox[{"40", " ", 
         SuperscriptBox["r", "2"], " ", "R"}], "+", 
        RowBox[{"64", " ", "r", " ", 
         SuperscriptBox["R", "2"]}], "-", 
        RowBox[{"9", " ", 
         SuperscriptBox["R", "3"]}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"2", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "+", 
            RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "r"}], "+", 
           RowBox[{"16", " ", "R"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"r", "-", 
           RowBox[{"4", " ", "R"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"7", " ", "r"}], "+", 
           RowBox[{"4", " ", "R"}]}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "+", 
            RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "r"}], "+", 
           RowBox[{"9", " ", "R"}]}], ")"}]}], 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", 
           RowBox[{"3", " ", "R"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", "R", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "+", 
            RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"r", "-", "R"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", "r"}], "+", "R"}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{"R", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", 
          RowBox[{"9", " ", "R"}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", "r"}], "+", 
          RowBox[{"11", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "+", 
            RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["r", "2"], "+", 
           RowBox[{"4", " ", "r", " ", "R"}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["R", "2"]}]}], ")"}]}], 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", "r"}], "+", 
           RowBox[{"8", " ", "R"}]}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{"R", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"4", " ", "R"}]}], ")"}], "3"]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", "+", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "r"}], "+", 
          RowBox[{"7", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"11", " ", "r", " ", "R"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}], 
       RowBox[{"4", " ", "R", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["r", "2"], "+", 
          RowBox[{"8", " ", "r", " ", "R"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "+", 
            RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "r"}], "+", 
           RowBox[{"9", " ", "R"}]}], ")"}]}], 
        RowBox[{"5", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "r"}], "-", 
           RowBox[{"7", " ", "R"}]}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "+", 
            RowBox[{"4", " ", "R"}]}], ")"}], "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "r"}], "+", 
           RowBox[{"16", " ", "R"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"r", "-", 
           RowBox[{"8", " ", "R"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["r", "2"], "+", 
           RowBox[{"15", " ", "r", " ", "R"}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"21", " ", 
            SuperscriptBox["r", "2"], " ", "R"}], "-", 
           RowBox[{"40", " ", "r", " ", 
            SuperscriptBox["R", "2"]}], "-", 
           RowBox[{"16", " ", 
            SuperscriptBox["R", "3"]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"r", "+", "R"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["r", "2"], " ", "R"}], "-", 
           RowBox[{"12", " ", "r", " ", 
            SuperscriptBox["R", "2"]}], "-", 
           RowBox[{"16", " ", 
            SuperscriptBox["R", "3"]}]}], ")"}]}], 
        RowBox[{"R", " ", 
         RowBox[{"(", 
          RowBox[{"r", "+", "R"}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"], " ", "R"}], "-", 
           RowBox[{"27", " ", "r", " ", 
            SuperscriptBox["R", "2"]}], "-", 
           RowBox[{"16", " ", 
            SuperscriptBox["R", "3"]}]}], ")"}]}], 
        RowBox[{"R", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"7", " ", "r"}], "-", 
           RowBox[{"36", " ", "R"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "+", 
            RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"2", " ", "R"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"6", " ", "R"}]}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"20", " ", "r", " ", "R"}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["R", "2"]}]}], ")"}]}], 
        RowBox[{"r", "-", "R"}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", "R", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "+", 
            RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"5", " ", "r", " ", "R"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["R", "2"]}]}], ")"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"r", "+", "R"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["r", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"5", " ", "r", " ", "R"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "r"}], "+", 
          RowBox[{"2", " ", "R"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"r", " ", "R"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        SuperscriptBox["R", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["r", "2"], "-", 
          RowBox[{"r", " ", "R"}], "+", 
          SuperscriptBox["R", "2"]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", "R", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"4", " ", "R"}]}], ")"}], "3"]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"r", "+", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["r", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"5", " ", "r", " ", "R"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}], 
       RowBox[{"2", " ", "R", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["r", "2"], "+", 
          RowBox[{"6", " ", "r", " ", "R"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      RowBox[{
       FractionBox["1", "15"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"21", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"64", " ", "r", " ", "R"}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{"12", " ", 
           SuperscriptBox["r", "2"], " ", "R"}], "+", 
          RowBox[{"5", " ", "r", " ", 
           SuperscriptBox["R", "2"]}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["R", "3"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", "-", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"r", "+", "R"}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["r", "3"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"], " ", "R"}], "-", 
          RowBox[{"3", " ", "r", " ", 
           SuperscriptBox["R", "2"]}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["R", "3"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", "-", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "r"}], "+", "R"}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{"40", " ", 
            SuperscriptBox["r", "2"], " ", "R"}], "+", 
           RowBox[{"123", " ", "r", " ", 
            SuperscriptBox["R", "2"]}], "+", 
           RowBox[{"144", " ", 
            SuperscriptBox["R", "3"]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "r"}], "-", 
           RowBox[{"3", " ", "R"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", "r"}], "+", 
           RowBox[{"3", " ", "R"}]}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{
        RowBox[{"18", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"81", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"136", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"80", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["R", "4"]}]}], 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "r"}], "+", "R"}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"5", " ", "r", " ", "R"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["R", "2"]}]}], ")"}], "2"]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", "+", "R"}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], "2"]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{"R", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{"13", " ", 
           SuperscriptBox["r", "2"], " ", "R"}], "+", 
          RowBox[{"12", " ", "r", " ", 
           SuperscriptBox["R", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["R", "3"]}]}], ")"}]}], 
       RowBox[{"2", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", "R", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["r", "4"]}], "+", 
           RowBox[{"28", " ", 
            SuperscriptBox["r", "3"], " ", "R"}], "+", 
           RowBox[{"71", " ", 
            SuperscriptBox["r", "2"], " ", 
            SuperscriptBox["R", "2"]}], "+", 
           RowBox[{"60", " ", "r", " ", 
            SuperscriptBox["R", "3"]}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["R", "4"]}]}], ")"}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["r", "2"], "-", 
           RowBox[{"r", " ", "R"}], "-", 
           SuperscriptBox["R", "2"]}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"7", " ", "r", " ", "R"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", "-", 
          RowBox[{"2", " ", "R"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "r"}], "-", 
          RowBox[{"2", " ", "R"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", "R"}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"42", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"75", " ", 
            SuperscriptBox["r", "2"], " ", "R"}], "-", 
           RowBox[{"76", " ", "r", " ", 
            SuperscriptBox["R", "2"]}], "-", 
           RowBox[{"16", " ", 
            SuperscriptBox["R", "3"]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "r"}], "+", "R"}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{
        RowBox[{"8", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"38", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"73", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"56", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["R", "4"]}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "r"}], "+", 
          RowBox[{"3", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"11", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"28", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"32", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["R", "4"]}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", "+", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", 
          RowBox[{"3", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"16", " ", "r", " ", 
          SuperscriptBox["R", "2"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["R", "3"]}]}], 
        RowBox[{"r", "+", 
         RowBox[{"3", " ", "R"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{
        RowBox[{"24", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"166", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"409", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"408", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        RowBox[{"144", " ", 
         SuperscriptBox["R", "4"]}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "r"}], "+", 
          RowBox[{"3", " ", "R"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"10", " ", "r"}], "+", 
          RowBox[{"9", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"15", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"60", " ", "r", " ", "R"}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "r"}], "+", 
          RowBox[{"10", " ", "R"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"7", " ", "r"}], "+", 
          RowBox[{"22", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{"44", " ", 
          SuperscriptBox["r", "2"], " ", "R"}], "+", 
         RowBox[{"128", " ", "r", " ", 
          SuperscriptBox["R", "2"]}], "+", 
         RowBox[{"144", " ", 
          SuperscriptBox["R", "3"]}]}], 
        RowBox[{"5", " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", 
           RowBox[{"7", " ", "R"}]}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"10", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{"17", " ", 
          SuperscriptBox["r", "2"], " ", "R"}], "-", 
         RowBox[{"20", " ", "r", " ", 
          SuperscriptBox["R", "2"]}], "-", 
         RowBox[{"36", " ", 
          SuperscriptBox["R", "3"]}]}], 
        RowBox[{
         RowBox[{"2", " ", "r"}], "+", 
         RowBox[{"5", " ", "R"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"34", " ", 
           SuperscriptBox["r", "3"], " ", "R"}], "+", 
          RowBox[{"53", " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox["R", "2"]}], "+", 
          RowBox[{"40", " ", "r", " ", 
           SuperscriptBox["R", "3"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["R", "4"]}]}], ")"}]}], 
       RowBox[{"R", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"5", " ", "r", " ", "R"}], "+", 
          SuperscriptBox["R", "2"]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"34", " ", 
           SuperscriptBox["r", "3"], " ", "R"}], "+", 
          RowBox[{"104", " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox["R", "2"]}], "+", 
          RowBox[{"135", " ", "r", " ", 
           SuperscriptBox["R", "3"]}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["R", "4"]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"r", "+", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"3", " ", "r", " ", "R"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"11", " ", "r", " ", "R"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"6", " ", "r"}], "+", "R"}]]}]},
    {
     RowBox[{
      RowBox[{"r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["r", "2"], " ", "R"}], "+", 
         RowBox[{"15", " ", "r", " ", 
          SuperscriptBox["R", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["R", "3"]}]}], ")"}]}], "\[GreaterEqual]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"5", " ", "r", " ", "R"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"17", " ", "r", " ", "R"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}], " ", 
       SuperscriptBox["s", "2"]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"10", " ", 
            SuperscriptBox["r", "2"], " ", "R"}], "-", 
           RowBox[{"71", " ", "r", " ", 
            SuperscriptBox["R", "2"]}], "-", 
           RowBox[{"64", " ", 
            SuperscriptBox["R", "3"]}]}], ")"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"r", "+", "R"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"2", " ", "R"}]}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", "R", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"10", " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{"91", " ", 
           SuperscriptBox["r", "2"], " ", "R"}], "+", 
          RowBox[{"204", " ", "r", " ", 
           SuperscriptBox["R", "2"]}], "+", 
          RowBox[{"144", " ", 
           SuperscriptBox["R", "3"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "r"}], "+", 
          RowBox[{"3", " ", "R"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"r", " ", "R"}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"30", " ", 
           SuperscriptBox["r", "3"], " ", "R"}], "+", 
          RowBox[{"72", " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox["R", "2"]}], "+", 
          RowBox[{"59", " ", "r", " ", 
           SuperscriptBox["R", "3"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["R", "4"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "r", " ", "R"}], "+", 
          SuperscriptBox["R", "2"]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"24", " ", 
           SuperscriptBox["r", "3"], " ", "R"}], "+", 
          RowBox[{"51", " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox["R", "2"]}], "+", 
          RowBox[{"44", " ", "r", " ", 
           SuperscriptBox["R", "3"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["R", "4"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"r", " ", "R"}], "+", 
          SuperscriptBox["R", "2"]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"87", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"92", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        RowBox[{"36", " ", 
         SuperscriptBox["R", "4"]}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", "r"}], "+", 
          RowBox[{"5", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      RowBox[{"r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{"24", " ", 
          SuperscriptBox["r", "2"], " ", "R"}], "+", 
         RowBox[{"35", " ", "r", " ", 
          SuperscriptBox["R", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["R", "3"]}]}], ")"}]}], "\[GreaterEqual]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"2", " ", "R"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"13", " ", "r", " ", "R"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}], " ", 
       SuperscriptBox["s", "2"]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"24", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"106", " ", 
            SuperscriptBox["r", "2"], " ", "R"}], "-", 
           RowBox[{"83", " ", "r", " ", 
            SuperscriptBox["R", "2"]}], "-", 
           RowBox[{"16", " ", 
            SuperscriptBox["R", "3"]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", "r"}], "+", "R"}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", "R", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["r", "2"], " ", "R"}], "+", 
          RowBox[{"71", " ", "r", " ", 
           SuperscriptBox["R", "2"]}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["R", "3"]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "+", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"r", " ", "R"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{"R", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["r", "3"], "+", 
          RowBox[{"7", " ", 
           SuperscriptBox["r", "2"], " ", "R"}], "+", 
          RowBox[{"12", " ", "r", " ", 
           SuperscriptBox["R", "2"]}], "+", 
          RowBox[{"9", " ", 
           SuperscriptBox["R", "3"]}]}], ")"}]}], 
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "r"}], "+", 
          RowBox[{"3", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "+", 
            RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["r", "2"], "+", 
           RowBox[{"4", " ", "r", " ", "R"}], "-", 
           RowBox[{"16", " ", 
            SuperscriptBox["R", "2"]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"2", " ", "R"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", "r"}], "+", 
           RowBox[{"14", " ", "R"}]}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "7"}], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"52", " ", "r", " ", "R"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{"R", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"20", " ", "r", " ", "R"}], "+", 
          RowBox[{"36", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "r"}], "+", 
          RowBox[{"4", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["r", "4"], "+", 
          RowBox[{"7", " ", 
           SuperscriptBox["r", "3"], " ", "R"}], "+", 
          RowBox[{"20", " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox["R", "2"]}], "+", 
          RowBox[{"27", " ", "r", " ", 
           SuperscriptBox["R", "3"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["R", "4"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", "+", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["r", "2"], "+", 
          RowBox[{"r", " ", "R"}], "+", 
          SuperscriptBox["R", "2"]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[LessEqual]", 
      FractionBox[
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"38", " ", 
         SuperscriptBox["r", "3"], " ", "R"}], "+", 
        RowBox[{"126", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox["R", "2"]}], "+", 
        RowBox[{"170", " ", "r", " ", 
         SuperscriptBox["R", "3"]}], "+", 
        RowBox[{"81", " ", 
         SuperscriptBox["R", "4"]}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"r", "+", "R"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", "r"}], "+", 
          RowBox[{"7", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      RowBox[{"r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"4", " ", "R"}]}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["r", "2"], "+", 
         RowBox[{"4", " ", "r", " ", "R"}], "-", 
         SuperscriptBox["R", "2"]}], ")"}]}], "\[GreaterEqual]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"r", "+", "R"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"2", " ", "R"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"7", " ", "r", " ", "R"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["R", "2"]}]}], ")"}], " ", 
       SuperscriptBox["s", "2"]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"10", " ", 
           SuperscriptBox["r", "3"], " ", "R"}], "+", 
          RowBox[{"23", " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox["R", "2"]}], "+", 
          RowBox[{"28", " ", "r", " ", 
           SuperscriptBox["R", "3"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["R", "4"]}]}], ")"}]}], 
       RowBox[{"R", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["r", "2"], "+", 
          RowBox[{"3", " ", "r", " ", "R"}], "+", 
          SuperscriptBox["R", "2"]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", "R", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox["r", "4"]}], "+", 
           RowBox[{"74", " ", 
            SuperscriptBox["r", "3"], " ", "R"}], "+", 
           RowBox[{"240", " ", 
            SuperscriptBox["r", "2"], " ", 
            SuperscriptBox["R", "2"]}], "+", 
           RowBox[{"315", " ", "r", " ", 
            SuperscriptBox["R", "3"]}], "+", 
           RowBox[{"144", " ", 
            SuperscriptBox["R", "4"]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["R", "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"12", " ", "r", " ", "R"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"7", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"28", " ", 
            SuperscriptBox["r", "2"], " ", "R"}], "-", 
           RowBox[{"96", " ", "r", " ", 
            SuperscriptBox["R", "2"]}], "-", 
           RowBox[{"64", " ", 
            SuperscriptBox["R", "3"]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"2", " ", "R"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "r"}], "+", 
           RowBox[{"2", " ", "R"}]}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", "R", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "+", 
            RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox["r", "2"], "-", 
         RowBox[{"3", " ", "r", " ", "R"}], "-", 
         SuperscriptBox["R", "2"]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"9", " ", "r", " ", "R"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"2", " ", "R"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"7", " ", "r", " ", "R"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"62", " ", 
           SuperscriptBox["r", "3"], " ", "R"}], "+", 
          RowBox[{"183", " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox["R", "2"]}], "+", 
          RowBox[{"252", " ", "r", " ", 
           SuperscriptBox["R", "3"]}], "+", 
          RowBox[{"144", " ", 
           SuperscriptBox["R", "4"]}]}], ")"}]}], 
       RowBox[{"3", " ", "R", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"9", " ", "r", " ", "R"}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"29", " ", "r", " ", "R"}], "+", 
          RowBox[{"36", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"6", " ", "R"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"11", " ", "r", " ", "R"}], "+", 
          RowBox[{"6", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"4", " ", "R"}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{"24", " ", 
           SuperscriptBox["r", "2"], " ", "R"}], "+", 
          RowBox[{"27", " ", "r", " ", 
           SuperscriptBox["R", "2"]}], "-", 
          RowBox[{"36", " ", 
           SuperscriptBox["R", "3"]}]}], ")"}]}], 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"9", " ", "r", " ", "R"}], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"11", " ", "r", " ", "R"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"56", " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{"110", " ", 
           SuperscriptBox["r", "2"], " ", "R"}], "-", 
          RowBox[{"51", " ", "r", " ", 
           SuperscriptBox["R", "2"]}], "-", 
          RowBox[{"144", " ", 
           SuperscriptBox["R", "3"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "-", 
          RowBox[{"3", " ", "R"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "r"}], "+", 
          RowBox[{"3", " ", "R"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"12", " ", 
            SuperscriptBox["r", "4"]}], "+", 
           RowBox[{"118", " ", 
            SuperscriptBox["r", "3"], " ", "R"}], "+", 
           RowBox[{"436", " ", 
            SuperscriptBox["r", "2"], " ", 
            SuperscriptBox["R", "2"]}], "+", 
           RowBox[{"759", " ", "r", " ", 
            SuperscriptBox["R", "3"]}], "+", 
           RowBox[{"576", " ", 
            SuperscriptBox["R", "4"]}]}], ")"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", 
           RowBox[{"3", " ", "R"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"19", " ", "r", " ", "R"}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["R", "2"]}]}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"39", " ", "r"}], "-", 
           RowBox[{"100", " ", "R"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "+", 
            RowBox[{"4", " ", "R"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"10", " ", "R"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "r"}], "+", 
           RowBox[{"10", " ", "R"}]}], ")"}]}]]}]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      FractionBox[
       RowBox[{"r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"4", " ", "R"}]}], ")"}], "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", "r"}], "+", 
          RowBox[{"25", " ", "R"}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", "+", 
          RowBox[{"10", " ", "R"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"15", " ", "r", " ", "R"}], "+", 
          RowBox[{"10", " ", 
           SuperscriptBox["R", "2"]}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["s", "2"], "\[GreaterEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"56", " ", "r", " ", "R"}], "-", 
           RowBox[{"400", " ", 
            SuperscriptBox["R", "2"]}]}], ")"}]}], 
        RowBox[{"5", " ", 
         RowBox[{"(", 
          RowBox[{"r", "+", 
           RowBox[{"5", " ", "R"}]}], ")"}]}]]}]}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 CellChangeTimes->{{3.855930631433189*^9, 3.855930647727393*^9}, 
   3.856480829805829*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"3f2fe197-a458-40e3-930c-76d4ede2c5b6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "list", "]"}]], "Input",
 CellChangeTimes->{{3.855930659837092*^9, 3.85593066317238*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"d3fc4311-e906-4fab-ba0b-4d817803c54e"],

Cell[BoxData["111"], "Output",
 CellChangeTimes->{3.8559306641302233`*^9, 3.856480829838071*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"676e38fc-aa41-411b-85e6-2394ff4bafc5"]
}, Open  ]]
}, Closed]]
},
WindowSize->{840, 1073},
WindowMargins->{{627, Automatic}, {Automatic, 127}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 988, 18, 219, "Text",ExpressionUUID->"ddb836ba-5a27-4f9d-986a-06fb645f709a",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[1571, 42, 198, 4, 67, "Section",ExpressionUUID->"b2c64fb5-3805-41cc-bbeb-51ecbab17a02"],
Cell[CellGroupData[{
Cell[1794, 50, 23737, 644, 1581, "Input",ExpressionUUID->"24ef5490-c78a-4ed9-bfb7-868b4a544973"],
Cell[25534, 696, 378, 5, 70, "Output",ExpressionUUID->"e8d4c6f7-fed4-4f1b-92b1-4ab87bc0eb4c"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25961, 707, 256, 4, 53, "Section",ExpressionUUID->"af06020a-9a82-45b2-8fbd-c4df7e3e209f"],
Cell[26220, 713, 3326, 92, 325, "Input",ExpressionUUID->"e7517eac-0fe1-405f-aaf5-059522a9044b"]
}, Closed]],
Cell[CellGroupData[{
Cell[29583, 810, 311, 5, 53, "Section",ExpressionUUID->"35f279b9-3668-4ce4-9b1f-153c12760a9e"],
Cell[29897, 817, 6796, 172, 774, "Input",ExpressionUUID->"47e08a4d-4fd4-4084-a5e3-27b8615a18a8"]
}, Closed]],
Cell[CellGroupData[{
Cell[36730, 994, 713, 10, 53, "Section",ExpressionUUID->"1f03b215-fc6f-473c-b6ea-6376cb319c33"],
Cell[CellGroupData[{
Cell[37468, 1008, 231, 4, 30, "Input",ExpressionUUID->"4381ff6c-8d10-4a1c-beb2-15d5f054e880"],
Cell[37702, 1014, 272, 5, 34, "Output",ExpressionUUID->"fde75a34-3da2-42a5-9171-ccce9759b00b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38011, 1024, 231, 4, 30, "Input",ExpressionUUID->"d92beb0a-afd9-4720-b73b-e1f99491dd82"],
Cell[38245, 1030, 226, 4, 34, "Output",ExpressionUUID->"6530bcde-cf18-4423-8e67-33a903a6f7c2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38508, 1039, 377, 6, 30, "Input",ExpressionUUID->"cc36f9e5-af01-4d34-84a0-104daf91099f"],
Cell[38888, 1047, 928, 28, 37, "Output",ExpressionUUID->"788acece-4072-4b78-96ea-791bd59e37f3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39853, 1080, 428, 7, 30, "Input",ExpressionUUID->"c22768b4-eaf6-481f-b41e-636c63da1c30"],
Cell[40284, 1089, 1310, 41, 37, "Output",ExpressionUUID->"78c90c8a-1ae3-4dc9-94c1-70ee823b78ec"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41631, 1135, 230, 4, 30, "Input",ExpressionUUID->"4b24675e-6721-4042-b5b5-11dd4aeb1896"],
Cell[41864, 1141, 757, 22, 34, "Output",ExpressionUUID->"da11fcee-1e0d-41b5-b5e7-394c79a5568d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42658, 1168, 304, 5, 30, "Input",ExpressionUUID->"b914b804-9196-4fb8-9d36-7c48636274c7"],
Cell[42965, 1175, 643, 17, 34, "Output",ExpressionUUID->"9ccd6365-b3a7-411c-a4f9-5b5357cb6caa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43645, 1197, 344, 8, 30, "Input",ExpressionUUID->"423ef415-50a7-4298-b3ec-41567f825136"],
Cell[43992, 1207, 414, 11, 51, "Output",ExpressionUUID->"45cffd5d-ba52-4529-bc60-d7957c4e45c4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44443, 1223, 395, 9, 30, "Input",ExpressionUUID->"46100400-536b-40a7-8c04-c72b832c3173"],
Cell[44841, 1234, 441, 10, 34, "Output",ExpressionUUID->"9d46b1b7-169f-455c-8179-4259006f5b9f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45319, 1249, 342, 8, 30, "Input",ExpressionUUID->"1f244b0e-51b8-416c-8b2f-99330e210e8d"],
Cell[45664, 1259, 763, 23, 59, "Output",ExpressionUUID->"d2d6d2fc-9b65-416b-85a7-a80d7f44152b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46464, 1287, 656, 15, 30, "Input",ExpressionUUID->"faeec5c0-b720-4c01-94c6-1b2b3249ffc4"],
Cell[47123, 1304, 752, 19, 37, "Output",ExpressionUUID->"cf541c49-e715-4267-8fd0-a6f5eb643435"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47912, 1328, 677, 17, 30, "Input",ExpressionUUID->"7d0fd775-f9e8-43da-a152-4e9ac03c97f2"],
Cell[48592, 1347, 663, 16, 55, "Output",ExpressionUUID->"940eb33f-cb30-49e1-9934-fbfba7fbf42c"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49304, 1369, 377, 6, 53, "Section",ExpressionUUID->"e17f9d1c-d86c-43a4-adbf-071145cb8ca1"],
Cell[CellGroupData[{
Cell[49706, 1379, 10870, 252, 1123, "Input",ExpressionUUID->"b00ceb83-6aa3-47f4-b3d7-aa2fc43478ea"],
Cell[CellGroupData[{
Cell[60601, 1635, 1065, 27, 25, "Print",ExpressionUUID->"9a06c535-f372-447b-83b4-d6934595023c"],
Cell[61669, 1664, 1059, 26, 43, "Print",ExpressionUUID->"a208dcc9-ecbf-4c40-89e2-8766a53cbff9"],
Cell[62731, 1692, 870, 20, 40, "Print",ExpressionUUID->"daa8924d-12ec-443d-9340-963f2eb3c214"],
Cell[63604, 1714, 862, 20, 25, "Print",ExpressionUUID->"f3cec373-857e-4e3b-a25b-d2c8e3fa028f"],
Cell[64469, 1736, 1103, 27, 25, "Print",ExpressionUUID->"45f8c774-c9dc-401d-9d55-bab9b4ff8ac3"],
Cell[65575, 1765, 1058, 26, 40, "Print",ExpressionUUID->"f1ef6e67-4325-41f2-9b2a-43aca2bbcc08"],
Cell[66636, 1793, 1132, 28, 43, "Print",ExpressionUUID->"395e6473-787f-46fb-bc9b-bd70a93e41e4"],
Cell[67771, 1823, 1327, 33, 44, "Print",ExpressionUUID->"88bd3eab-90bf-4973-9411-d10140a4f237"],
Cell[69101, 1858, 1210, 30, 40, "Print",ExpressionUUID->"1ef46955-25f1-481e-928a-72e53f9636b8"],
Cell[70314, 1890, 1528, 40, 45, "Print",ExpressionUUID->"fe6c32db-db20-464b-bf28-ccc2230f7556"],
Cell[71845, 1932, 1267, 31, 42, "Print",ExpressionUUID->"cefe9d94-d89b-4826-b769-dd412b848ab6"],
Cell[73115, 1965, 1420, 37, 45, "Print",ExpressionUUID->"886f27d9-71f0-4a48-8090-1b7d39a88bca"],
Cell[74538, 2004, 1614, 41, 46, "Print",ExpressionUUID->"77321dd2-8122-4e4a-bdf0-8b85f3056062"],
Cell[76155, 2047, 1623, 41, 27, "Print",ExpressionUUID->"94689236-88e7-4a86-a424-459efe57c81d"],
Cell[77781, 2090, 1206, 30, 40, "Print",ExpressionUUID->"4f6277f2-5871-4e3e-9ce8-4b050f07d90e"],
Cell[78990, 2122, 1327, 33, 44, "Print",ExpressionUUID->"485244a1-184c-4bee-88d7-d89778a8aa4b"],
Cell[80320, 2157, 1431, 36, 46, "Print",ExpressionUUID->"d85703d4-e964-4574-b142-66ce85212287"],
Cell[81754, 2195, 1728, 44, 46, "Print",ExpressionUUID->"2d053061-b99a-4c99-8c2e-97f9a703e346"],
Cell[83485, 2241, 1268, 32, 45, "Print",ExpressionUUID->"b4772162-7f73-4aaa-8e64-e4a746e5cede"],
Cell[84756, 2275, 1260, 32, 45, "Print",ExpressionUUID->"f97575ca-986d-4616-8e0c-c1a94a027d4e"],
Cell[86019, 2309, 1579, 39, 45, "Print",ExpressionUUID->"99bbde92-47e9-463d-9c8a-3d3064669a33"],
Cell[87601, 2350, 1249, 30, 43, "Print",ExpressionUUID->"ccfa2514-18d6-4a23-85fb-70de9fec451c"],
Cell[88853, 2382, 1646, 41, 45, "Print",ExpressionUUID->"e784e148-cb5a-4507-be00-d644848703f0"],
Cell[90502, 2425, 1213, 30, 40, "Print",ExpressionUUID->"4e391035-3d37-4966-814f-70f71f300c8f"],
Cell[91718, 2457, 1325, 33, 46, "Print",ExpressionUUID->"168a8d3b-518e-40a2-ad4e-427fb5a6f5cc"],
Cell[93046, 2492, 1693, 43, 45, "Print",ExpressionUUID->"850aae21-9e44-47d3-aacd-dc6047b7af2c"],
Cell[94742, 2537, 1724, 44, 45, "Print",ExpressionUUID->"fc46af1b-c951-4c42-9e67-da4dc0e47049"],
Cell[96469, 2583, 1610, 40, 45, "Print",ExpressionUUID->"01161aa3-b749-4bc7-aed1-ea4485d3f724"],
Cell[98082, 2625, 1201, 29, 43, "Print",ExpressionUUID->"c7a9df4b-f11c-4af1-a981-74f3ade75427"],
Cell[99286, 2656, 1487, 37, 45, "Print",ExpressionUUID->"7e83006e-2cbc-41f1-89e5-d4aef313a1c7"],
Cell[100776, 2695, 1659, 44, 46, "Print",ExpressionUUID->"977372ad-30e5-4f5f-9de8-fc86b16f87fa"],
Cell[102438, 2741, 1421, 35, 43, "Print",ExpressionUUID->"62972348-68d6-4d32-8016-aede77a9fb82"],
Cell[103862, 2778, 1564, 39, 46, "Print",ExpressionUUID->"c75f5f26-692b-4381-8ca9-8368186a5e84"],
Cell[105429, 2819, 1612, 40, 45, "Print",ExpressionUUID->"7d348ff5-5268-4205-b9ae-8a4f73af0cf8"],
Cell[107044, 2861, 1272, 32, 40, "Print",ExpressionUUID->"5467ee32-11dc-427a-8e4b-d0063dfa4216"],
Cell[108319, 2895, 1084, 26, 40, "Print",ExpressionUUID->"be7d3168-ec75-4bf3-b258-451a2b77a000"],
Cell[109406, 2923, 1576, 38, 45, "Print",ExpressionUUID->"0aa88203-28a6-49b7-a7a1-3744a9fb8211"],
Cell[110985, 2963, 1717, 43, 46, "Print",ExpressionUUID->"e89edf8e-bb24-494c-8f53-4b6080be1495"],
Cell[112705, 3008, 1322, 32, 43, "Print",ExpressionUUID->"313a2150-290c-4065-a9c5-8b105c0fd23c"],
Cell[114030, 3042, 1400, 34, 45, "Print",ExpressionUUID->"0b7e0289-d8f5-4e01-bb7a-07f1a16b72c0"],
Cell[115433, 3078, 1711, 43, 46, "Print",ExpressionUUID->"1051c195-2129-477e-b6e4-452b3d775c32"],
Cell[117147, 3123, 1219, 30, 40, "Print",ExpressionUUID->"d6bcfef0-4bbf-49d0-81d3-2d1b0ecc868c"],
Cell[118369, 3155, 1461, 36, 45, "Print",ExpressionUUID->"1a98a23b-67b5-4ff9-942a-e20413c16981"],
Cell[119833, 3193, 1596, 42, 45, "Print",ExpressionUUID->"14a420c4-cbbc-43b0-9768-6975846ffabb"],
Cell[121432, 3237, 1581, 40, 45, "Print",ExpressionUUID->"f8557f18-580c-49ab-8761-0572e0ee4811"],
Cell[123016, 3279, 1386, 36, 45, "Print",ExpressionUUID->"30bc29d0-c3ec-4a6d-a9cd-894fcb4423c2"],
Cell[124405, 3317, 1548, 41, 45, "Print",ExpressionUUID->"9ef9c45e-8f32-408b-9692-2fe8cc76be47"],
Cell[125956, 3360, 1579, 41, 46, "Print",ExpressionUUID->"4be90a09-2757-4382-8e70-fe35066b996b"],
Cell[127538, 3403, 1342, 35, 45, "Print",ExpressionUUID->"515b6b7b-c346-4606-9615-72d54962e412"],
Cell[128883, 3440, 1745, 43, 50, "Print",ExpressionUUID->"65229406-79da-497d-a62f-104c23aab9fc"],
Cell[130631, 3485, 1442, 37, 45, "Print",ExpressionUUID->"2898fe88-4b3e-4c30-8935-525882d3c573"],
Cell[132076, 3524, 1712, 44, 49, "Print",ExpressionUUID->"a2ef629c-407a-4687-a37e-5308dc3ee63c"],
Cell[133791, 3570, 1667, 42, 46, "Print",ExpressionUUID->"d48fd7b6-3b6e-47d7-ac00-71f542842593"],
Cell[135461, 3614, 1557, 39, 46, "Print",ExpressionUUID->"0cce81ad-d459-4f9d-b997-f64d7d110a2c"],
Cell[137021, 3655, 1596, 40, 46, "Print",ExpressionUUID->"e5591382-09d4-48e8-83d2-81f5fb333d5d"],
Cell[138620, 3697, 1588, 41, 45, "Print",ExpressionUUID->"4b844073-9370-4c49-bde3-cc0d0c80eec8"],
Cell[140211, 3740, 1323, 33, 44, "Print",ExpressionUUID->"c49e5b7a-010b-49d4-88f2-c1510a23e7cd"],
Cell[141537, 3775, 1945, 50, 50, "Print",ExpressionUUID->"299ae6cc-774e-4095-8697-d105ea07ca41"],
Cell[143485, 3827, 1879, 49, 50, "Print",ExpressionUUID->"83d936f6-c010-412c-abf4-2160b782e385"],
Cell[145367, 3878, 1513, 39, 49, "Print",ExpressionUUID->"e7902258-2470-4361-a9c9-8121153f61ad"],
Cell[146883, 3919, 1431, 36, 49, "Print",ExpressionUUID->"b6045926-c7fa-42a6-99b1-c08c4d843de1"],
Cell[148317, 3957, 1741, 43, 50, "Print",ExpressionUUID->"d7ca37c1-ca74-46ce-831f-5f068d1102e5"],
Cell[150061, 4002, 1220, 30, 40, "Print",ExpressionUUID->"559af568-afb2-4033-af08-5664e2c3be94"],
Cell[151284, 4034, 1597, 40, 46, "Print",ExpressionUUID->"a3be81bc-08ee-483c-bb24-6c5246614852"],
Cell[152884, 4076, 1601, 41, 46, "Print",ExpressionUUID->"c9ab54c4-9ba4-4680-860f-91f175f3f6c0"],
Cell[154488, 4119, 1776, 45, 46, "Print",ExpressionUUID->"7d463d22-54dc-4ff6-be36-b802a47bb6e4"],
Cell[156267, 4166, 1757, 44, 45, "Print",ExpressionUUID->"5399321b-0c57-447b-8744-24291d603424"],
Cell[158027, 4212, 1545, 40, 48, "Print",ExpressionUUID->"6ab3aa57-1e50-47f8-ac0b-f4db8a2ebbb0"],
Cell[159575, 4254, 1583, 39, 46, "Print",ExpressionUUID->"741ff933-1def-4dff-80d2-e7c81ad0f469"],
Cell[161161, 4295, 2031, 51, 50, "Print",ExpressionUUID->"5a3c9684-7adf-464b-8d54-268a386e8656"],
Cell[163195, 4348, 1850, 48, 46, "Print",ExpressionUUID->"d5bfeee6-b791-4579-b43f-dde8c3a573ae"],
Cell[165048, 4398, 1719, 44, 46, "Print",ExpressionUUID->"156b7e3a-6217-4f77-9ba9-fb7f33041a4f"],
Cell[166770, 4444, 1759, 45, 45, "Print",ExpressionUUID->"c4dcced5-5430-4ca0-af97-9a5b4b144b14"],
Cell[168532, 4491, 1728, 44, 45, "Print",ExpressionUUID->"45e1d063-6ec7-4abc-aeda-604ea2661360"],
Cell[170263, 4537, 1305, 33, 43, "Print",ExpressionUUID->"4edcf1fe-6b90-4862-ab4e-c69ce1f378ee"],
Cell[171571, 4572, 1802, 46, 45, "Print",ExpressionUUID->"a8741cee-9ffc-4850-b4e7-19413919a401"],
Cell[173376, 4620, 1721, 45, 46, "Print",ExpressionUUID->"a323727e-d4fe-42b0-8b38-7da5466ca72a"],
Cell[175100, 4667, 1500, 37, 45, "Print",ExpressionUUID->"0722faba-64d5-4e20-ac83-84f06661b291"],
Cell[176603, 4706, 1460, 37, 43, "Print",ExpressionUUID->"410e3da0-d4f0-4ee3-bd5e-855f724b7842"],
Cell[178066, 4745, 1873, 47, 50, "Print",ExpressionUUID->"94bbef51-1c1a-4ae6-b6a5-70603bcc2aae"],
Cell[179942, 4794, 2008, 50, 50, "Print",ExpressionUUID->"0b4756e6-8f27-49a9-b57d-b1e4ca349ab8"],
Cell[181953, 4846, 1327, 33, 44, "Print",ExpressionUUID->"d354a528-6cf4-4eba-a2b2-322d29ded24f"],
Cell[183283, 4881, 2153, 56, 27, "Print",ExpressionUUID->"d7be33e0-0aab-4199-8fbc-15e52ec0c776"],
Cell[185439, 4939, 1705, 43, 46, "Print",ExpressionUUID->"70e58aa5-ad57-4366-be2b-b24227c309b3"],
Cell[187147, 4984, 1912, 49, 50, "Print",ExpressionUUID->"74b9fd6f-d45f-4c4b-a5b8-85e1580175ab"],
Cell[189062, 5035, 1978, 50, 50, "Print",ExpressionUUID->"da9d8005-e641-4a55-8a3e-db5d440e2cab"],
Cell[191043, 5087, 1970, 51, 50, "Print",ExpressionUUID->"a00307f0-5d95-4f0d-a13a-91d17739b217"],
Cell[193016, 5140, 1759, 45, 45, "Print",ExpressionUUID->"decee373-c72b-4d6b-9bc0-45e91bc62f48"],
Cell[194778, 5187, 2101, 54, 27, "Print",ExpressionUUID->"cc3ebb18-12cf-465a-9c49-8160b7a0844f"],
Cell[196882, 5243, 1721, 44, 46, "Print",ExpressionUUID->"3d8f9f9c-2c11-4ec4-9b2a-2da7aa591de6"],
Cell[198606, 5289, 1902, 48, 50, "Print",ExpressionUUID->"b4ad08f7-be58-4d24-8a39-e4506f012c8b"],
Cell[200511, 5339, 1555, 39, 46, "Print",ExpressionUUID->"52c5c655-2975-4384-98a0-003205d0ca42"],
Cell[202069, 5380, 1693, 44, 46, "Print",ExpressionUUID->"dbf5a6ce-442a-4882-a833-096120c504f0"],
Cell[203765, 5426, 1246, 31, 40, "Print",ExpressionUUID->"b253297c-7b29-43a3-a09a-452fd327487a"],
Cell[205014, 5459, 1422, 36, 46, "Print",ExpressionUUID->"ad1bfbbb-ac62-419e-9c05-db555f46e266"],
Cell[206439, 5497, 1853, 46, 50, "Print",ExpressionUUID->"79df4c43-e578-4a54-b64b-a5d5d16a106f"],
Cell[208295, 5545, 1757, 44, 45, "Print",ExpressionUUID->"67c33506-90a5-4941-ba8c-0aa51f63b0ef"],
Cell[210055, 5591, 1850, 47, 27, "Print",ExpressionUUID->"4b97e41b-8ed7-44eb-adfd-ad7569f4fa42"],
Cell[211908, 5640, 1831, 45, 50, "Print",ExpressionUUID->"0a180153-8a4d-4e8c-8795-dde5f89d215a"],
Cell[213742, 5687, 2192, 55, 50, "Print",ExpressionUUID->"b848bcfc-4720-4473-abeb-45b4f3855907"],
Cell[215937, 5744, 1740, 44, 46, "Print",ExpressionUUID->"a2d415f1-1a09-483e-9b6a-175b3c484bfb"],
Cell[217680, 5790, 1335, 33, 44, "Print",ExpressionUUID->"f12b072c-76a6-486e-ae36-1998e8877005"],
Cell[219018, 5825, 1864, 48, 50, "Print",ExpressionUUID->"82d31597-3cff-4d0f-9a3c-8773cfcab673"],
Cell[220885, 5875, 1929, 47, 50, "Print",ExpressionUUID->"107d7cef-b8fc-44fe-bb7f-67d63d68cd30"],
Cell[222817, 5924, 1870, 48, 50, "Print",ExpressionUUID->"59f38e97-a052-4740-bbb6-e3f850e0a2de"],
Cell[224690, 5974, 2232, 56, 50, "Print",ExpressionUUID->"d831dce8-5fd1-4b75-ae3f-74f2cef32284"],
Cell[226925, 6032, 1736, 44, 46, "Print",ExpressionUUID->"10951d0b-c04c-48fa-ac54-14a3cd17c545"],
Cell[228664, 6078, 2098, 52, 50, "Print",ExpressionUUID->"b5197e78-8407-4dcb-a8e5-f9074b0c8f85"],
Cell[230765, 6132, 1603, 42, 45, "Print",ExpressionUUID->"3f29246f-9d88-4c71-ae56-c023d0b04315"],
Cell[232371, 6176, 1713, 44, 49, "Print",ExpressionUUID->"2cd344cf-7c22-4d1b-a461-9eef559a02e2"],
Cell[234087, 6222, 1438, 36, 46, "Print",ExpressionUUID->"c7e4449f-6b3b-4b2e-b5fa-89f803be7ca7"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[235586, 6265, 458, 7, 53, "Section",ExpressionUUID->"ea3a8e69-0aee-47c9-b2fa-a44cc731d8fa"],
Cell[CellGroupData[{
Cell[236069, 6276, 212, 3, 30, "Input",ExpressionUUID->"a7256200-23b1-4761-9839-0e1641fc9858"],
Cell[236284, 6281, 173, 2, 34, "Output",ExpressionUUID->"c63e8630-6755-49e3-98ac-1fbdeb2e4f72"]
}, Open  ]],
Cell[236472, 6286, 305, 7, 58, "Text",ExpressionUUID->"86bf37b1-c3c3-44a9-8fea-1e5c6f0868a0"],
Cell[CellGroupData[{
Cell[236802, 6297, 212, 3, 30, "Input",ExpressionUUID->"5314dbaa-edc9-436d-9cd3-b3323e09eb5c"],
Cell[237017, 6302, 8724, 228, 93, "Output",ExpressionUUID->"88977ccd-18b7-47ba-9f2f-c2f900879a6f"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[245790, 6536, 520, 8, 53, "Section",ExpressionUUID->"b403c239-118f-4b39-8a6e-aa5be5408a2a"],
Cell[CellGroupData[{
Cell[246335, 6548, 928, 25, 52, "Input",ExpressionUUID->"db0f2f92-3b0e-4f3a-b675-00700ec10e2e"],
Cell[247266, 6575, 9287, 254, 605, "Output",ExpressionUUID->"e6f1d089-4604-4fbc-85aa-cffbde20575a"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[256602, 6835, 563, 8, 53, "Section",ExpressionUUID->"58ff8057-b629-4d9a-840c-58548e19aec4"],
Cell[CellGroupData[{
Cell[257190, 6847, 941, 25, 73, "Input",ExpressionUUID->"9958afdc-17da-40d6-969f-caf37976b093"],
Cell[258134, 6874, 2764, 75, 213, "Output",ExpressionUUID->"3b015569-b15c-4bc8-80e7-aaf9bb30ddba"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[260947, 6955, 603, 9, 53, "Section",ExpressionUUID->"587b802e-e706-4acc-8733-bc28d18f6fbd"],
Cell[CellGroupData[{
Cell[261575, 6968, 207, 3, 30, "Input",ExpressionUUID->"002ed174-46d5-49ac-91fd-4a8e7e4a37a5"],
Cell[261785, 6973, 69786, 2206, 3691, "Output",ExpressionUUID->"3f2fe197-a458-40e3-930c-76d4ede2c5b6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[331608, 9184, 206, 3, 30, "Input",ExpressionUUID->"d3fc4311-e906-4fab-ba0b-4d817803c54e"],
Cell[331817, 9189, 175, 2, 34, "Output",ExpressionUUID->"676e38fc-aa41-411b-85e6-2394ff4bafc5"]
}, Open  ]]
}, Closed]]
}
]
*)

