(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    161495,       3332]
NotebookOptionsPosition[    154501,       3201]
NotebookOutlinePosition[    154839,       3216]
CellTagsIndexPosition[    154796,       3213]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Equidiagonal Quadrilaterals", "Title",
 CellChangeTimes->{{3.8503675053983097`*^9, 3.8503675314147863`*^9}, {
  3.850400399761656*^9, 
  3.850400400729137*^9}},ExpressionUUID->"d6915b80-afa1-4011-9eb6-\
6d67402ddf17"],

Cell["\<\
This Notebook contains the proofs of some of the results for equidiagonal \
quadrilaterals in the paper
\"The Shape of Central Quadrilaterals\" by Stanley Rabinowitz and Ercole Suppa.
submitted to the International Journal of Computer Discovered Mathematics 
(http : // www.journal - 1. eu/) in January 2022.
 
This Notebook is Copyright \[Copyright] January 2022 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and is published with open access. This \
Notebook is distributed under the terms of the Creative Commons Attribution \
License which permits any use, distribution, and reproduction in any medium, \
provided the original author and the source are credited.\
\>", "Text",
 Evaluatable->False,
 CellChangeTimes->{{3.823362867312365*^9, 3.823362892123764*^9}, {
   3.823362940554699*^9, 3.823363012293025*^9}, {3.823423241988761*^9, 
   3.8234232521964083`*^9}, {3.848655919648938*^9, 3.8486559295098267`*^9}, {
   3.850294942155574*^9, 3.8502949868845367`*^9}, {3.850318925958982*^9, 
   3.850318971044919*^9}, 3.850400385778439*^9, {3.8504004260582657`*^9, 
   3.8504004271219893`*^9}},ExpressionUUID->"4236d41f-5597-4866-8f87-\
94c2f1fb6f59"],

Cell[CellGroupData[{

Cell["Set up", "Section",
 CellChangeTimes->{{3.8503675908573427`*^9, 
  3.850367597134454*^9}},ExpressionUUID->"8c693eaf-fcc9-4a77-a5ee-\
cee338c3cad4"],

Cell[TextData[{
 "Without loss of generality, we can place E at the origin and AC along the \
x-axis with C at (1,0).\nLet the coordinates for A, B, C, and D be as show \
below.\n",
 Cell[GraphicsData["PDF", "\<\
9E14ARda;S<:9LCUl^G[Yo>Pd<C62S@P<21_HVX:?3`P;daUKVMdJ20e830PDR0_
AVU/M6Eb82m6K65dIDAUHfmTIB0n?PYcM79UHFd:N06EETe_e30@_O]G39afYCJe
ahVc@@RY;KgdESDgbX4^@U2a@;DPfWo?O7QRMk=M@2]UKLnWGijOL`mGL0lAOT>0
Bd2hPi?cKH3cJo3b^chWLi3Q<OmQUf2m0Hbaj@07NV`PMO@GfUGC^Jm`;@WW4LF9
8T;/>AciZB61>]P]i:Q@kOVTk3mFR]S^=<MkgJg4FjXlZL=ZPo/[cI^[4fR<@;WN
IRRgjjT^`g<LERgG?A]MJ<F5oY3F43f<6cPIad38SioP7Ba>]m]OBcSf3L9Rll=6
?iLP:em/hO_BZLlgFmVnF/9k62oQHZaNS=C7h;Dn_K/WmF>dn/kZOk1l3jnm3Hmb
MLSo7lg`L:PThgHfERESk1W]G19ebh/GBaS_3SK]6nlm^W5MifX9_RUGQVoQSn2F
N_Y;_P92k2F;diMP7KglW`b[D?La`CS3K/;/lLg<I[SN6Zj?Q;d[;i>?36la@<F/
nY26_VmF?^[Ai5<gcHLVnCJid:MVl7f2d7Tn9GfWoS8SG?^fBL>:3=TLLcX=9k/]
l=5WOi_gCAbj]T[@YSZoc=SObVNc]J_Qe9h]D7iH`fLh8`j[;UEK5S;gLbiC>8C4
a79dUPR6O9H^3=RKa@ccJN5VFI<h==PYf_@ZZm8efZRJYY:XTaRJgPml[6<W8e3I
U2Lo23@T9aclT4dRZBE>Y_8PCigdk;i:9A1IOTF_W0`iIbjGCB:f9DjVg>M1B37P
k:`R[ZR=O5@;XVn=X@EI8[I84idkERBg<;D``j?5k21mR=29VRJaI3K@[L<kH6Hb
a93j37GXT=Ke]Y7Q6U;<T6EKZ09MTYWT94nM97dS9JkUBbCOH3`TcjVNf[@c2iCF
L/i3[>gf/=KCYV;FWP;ajA8RWAIH58R;9Q^DQW7=hRN2LDP/F]jkG/TT5GTf:;XQ
j/0aF`UeYKZ<jAPCfhC1IYA?0b:[_9RPU9N[WWgEZ16^Q2:_ffG?HoK=:E2=^JEL
c3YT<Q>?gO?BP15WmeaP8]=UXA9OH3hc^QJHBGi[9/?4I3=DC=k3ION<G4AT6Q^I
llcH735Um8C2nL^2aj@H4E7aESY75>d^XC;=i<]6dUOEV2VDFN_/RdDYGHX:YJg1
:KCd>mL=TTGFII5R4_ki7DngJ=O=h3hgiQJhPgg2k2=cmBUcm@N^3Akb2VE^I7=d
LVEQK@YUKVA_HVX:=B0`86mRJPXh=cH:IFiTKf9Z2S8P<21_HVX:?3`P;eAiL6DP
;e1QIfDP;e1QLVE^M20c830PDR0_DVEcKgEbHfEc83HP<21B82m3KfidIFidLb0d
830PDR0_CFETJF52KgPPFc0P<20d=cHP<SDfG@Xn?PYUKVA_HVX:=R0`86mRJPXl
?20_D79_He=UM21K82m@A4HP;eAUN7@PGB0_@fm/Kg9CL65SIB0l?20_@g<a83LP
<21B83hn82m6Kfid83`l82mDE3<P<C0P<21B2RmDE34P>20`858P;eAD<R0i830P
DR0n?R0n?PYUKVA_HVX:<C4P<21_HVX:?3`P;daUKVMdJ20a<R0`858P;dhP<b0_
@FadIG9^HGAU82m4IGIYHfEBAd8P;dIYK7AULR0_AVaQM6E4IF=_I6DP?Sh:LgAb
IF5]2WP1WIIgE5?I5XO?_CNmd18R82Gd6WX98=8kB1D4DHU9P502QX@VMT@5AQ@A
:EITE<01AhLRHdDD2h>2H]L9lQ1@a/5AA4GUgHa[2Nn]=O?NV_g7FMoIikOGfFO_
OMNj053lPPC2M5P1P3BQF1C^jl5L4Q?;a?L261013UP1`>5VIPA7n4@2e?bm?IVI
Z4S6/oK^;X1T^m//_e0VLmKoOi4R=d<T1P0:AMDf?7hV5nD2U5>caATbo`C:m9DY
<XHa<QJQ2J:/8^?4[fcfYnH[^lVHUbKTXAYIcQVl=9j<^e3NVRGQXh`4XEbH9N1W
Xg`7IKeDBIX0iOLXdm?hW4`0<1BIGlcW9Z5/RC9551W^RO8200RDa3VlLPj;nCUX
WP1hYVOTRPB9BF:V4MNHJNGXb6KjlK=CnF8a:iC3CN68N4c?m;@<SS0GP:m_UTD1
9EU]VFRAkJdLkNeIe^IXnKoIgainDodmb7[kEO4Vk<nN@HbNFMm/k:`__AH0mRAJ
Vafc_YEE0;A]1T3UhJa?kb00lPD0]=jLlaj6K5jBa>8<9`^;k>a/L`6OJbh[j3Ok
Wh9_b[n6>ONIbnkkES^V5cn18dTE<fE5iJJWYT]4c<`<3YO?I?gg4?oS`3UYcLW3
;9bO`1OaQNQEDNRD2HB9J;^5?85HT2iT2XAoeN5o63HW1aUnWF/DJ7EO07f5>E2h
B@O8Kcd0@b<396hoNP9mje/@<@[8_[aX[I6_LhlbN_kWnQl;G8Y^hDa18U?VmPb?
I78UXR`IXmn4K<424Y07M:0:=84^<08/H0dLP3=`0mhP08B0B103UP<^B09Y@0Bb
@CkH00Y1<MP1MX=ZL03DPG[@14j2=W06G0AG`0e`2`b0Ad0:Q/5;<07NPFT8P_0@
5J91ZY0FY0nI@]H@6eX8ND=1D3PD0lE3RI0@TT3id2JX62Z3ZZ53D3gd8g@J^PQM
PoZP1m0P=0Km0Gf44IP2df4=f02fP=V`>a`8Al;;h4Ah5I`75l3KhDZh5Sh>]l8G
hA_`02b5Gl:C243820?AAUP86o54@Y1H904A8F^A8Z@2ZDFJT0jT6kV=B95ai0<6
Qj5QV1PFaQWSQeV<hF9FHMIRBS3EV6>HET`GiSIV43>1nH:UH]FaYUPW[3mf2CHA
Vhd]a5IPSf1K/9Na0mQQk3/L3/O06N8LL7jh65`bKSF^1;L?ehbkP>_33N4VlGRl
:]hDkh8?`G?`HW`Q_PYo77lNghlOa[lWT0UJ16^23b6F82A/95@@6PSW2?f44L8d
DH6XCg@RQQ1ia5aR:K6>f46lBA`VCY<DBHHT5e8T:IVdPEA9JR9M9SdV_B6CbCYT
Ag8HFD1NCjhTWb1O9@nB?e2D:2HDCdXLAD;ICSU:^D1i@7U3YE8=Z6kDF:ZH^YeJ
Cke4ODYm;dNC<iOcUn?9[I>[TF^EjiMk9DnDeiMgUel^WbMO8Gm:oZKl^09A`D31
Dh6S/5JQA^6d`Sf5BDFJXYERR6:JHXURPn8eaE4U_9:1T[LBCjU0jK3B9JDQ6T;C
YGWB^;A=]3[JIMX`7DLgY?_CTnW5m1oX_O@9IBEUFnDXiAcU6^FcbU86`S1Pn3=B
6JF<ThbkS8oc=>Jicn??fcJ_JEko_2VEnBY^:WbE8YEVU@6ESjY<EFoE5=FMZVfZ
Cm@`JRIZHF[IJ__E;Z^=cjO?Mik?WEldonClQnZ`^XUj^?YZmL?Z?NZC6YXJ_QXI
6UDJUcC6=AVJKY[9V^FJicC7]6QJ2kD4F^EJikEN<9FIk/aDIRFcRcVQ[Jk]YbgA
?ZCMZcf]HjRcF6NSC[?>4efB;U/g@KML]e=g@Tm;;eP_GjmAkj4nDIn]WjBoAkmK
Ol[0d23JH8]1Vl6XXHZQ_f6NHJ?QHb>ZTJ_A:Z=JXc_6>6>fLH[a?^=K9[29WDVB
BHg9CE?He=iDH;[?]<l<JnIX9SB[=K_7X[3LFEV/A]JP>L<lb7bSNI_i:`/mReR;
WAKM5Ul/kBaC;N//7eTYF@EHKKCZ/?[3f/BJJeeSOLN6J^=S/ljVgNJe[JT]ggJo
kGdkVUf`gAJkC[_?mPkf8_/Vnc47?HMhQkd>mmQdMRRkQ7gE4N_XhKS>lHcS1bMk
9k7CBJOOWEW>:Lh=cZ<;31O`5m@]67;ALN6h77:A;V@^S5mhL:7DEM^Ehe[[n/a=
ehgWM/A]a=gH?MWm^?/[3d/?TDN;aiBWTnLJc`]NR9N_Ei5G[kNBmf;_J^nW?SXn
RCj=?Q>nM[j[OBohHOd2oGKjgO?Gl>Ojeo]?13P4[0WX2Z@4APAF1ch;<PTB1GD4
`l41`K^27boBGbALe1H2@_a3MXDl2CD<GAGjLaP^;3B/9^ai^5EhOWQg12eRADA3
a;]8SlSBb4N;SAI;5WM6bDO5AME7CDEkAIM5BiMH;5Vci4J<FX`PYSdF7a/ENbAf
LZWgd]e;Qn?/hP[SkRhcG9Jck=Yb]NFYbln^T5o1FG4Z7Q/O7Ml@ohTC`ZWUC:kd
GkUgi@CGTk^7ni;WaR_WSO5Mn6GlT@BGQ;:4dDBGa5f9HdV^BAE9h`9?@KGPMK9O
lX7TZIB@U:<Y<jWAZLeYQ;Ch]==29F6:/2]M<cdW_Bo3=:<`@k[:JMG^EA>R@=6A
C2QcFFJkV8knC?E8S2BK9H=I2k=Z/]iWAfFObU7<4NKdi9[TK//MbO?9ngheISEg
MFNnM_j6o<4ekV/>[HGF[UcK^DigGL6jhOFnjhm]86e8fO3;A/^=IA_OKX[Ne56P
DK2nH6RcknK6@[U2DN6m;LiK3Vc5K1E/kMeV/jeZfiLRG]7eH/_RR^9?9MbBjmmI
OEOigLcfQ>fmYOJUngOPMPQgg=gY^_=HVF9IG]W@[^1M[NG<lZ;b]k]Gk;iFHE]a
H0mYSfB?]3:X/[e:[fY7eJOZY>Z16XnJi[gZNkO]WM[7fmNogfeod`6=0lD7?QhD
7;aob?M@Jje1KLEQg>6/`lo[X^Zj_fMoGgm4kDSaTLm7QDNUal:?MMDke=LgZ3ND
=/:=T/Jahg77KogPmD=k4j_YD3>S^OP4>24ilN;7n1o_WP`lfGV:OJ[Y9ofOm[K@
FXYJXMKLeXVfY3IYNdakgnV0didMcQd]?i_oO?B<mYVJ/lYWBlnAcQFLVcVOMgkb
@/J5lH^95hLjEg@n^[CTdYf^/:kNbh6G[eka^G:Yfkgko5FGZfN^>EdkOIem_Nf6
oHgF7[^NUUo/OVWY]Nm]_NU`/ofFhjf>_PEmioYMnboNm[YmiHkoWA/3R`KjkRjn
NomNg3gYOMkmd@NY3ehoc7XhoFSmHncSXRL:CbZNZSn]oMGhefJY_OC/X=MPck>8
Ihn6^4<_oiGi[do31LnYcb]6]4KZAje7chciS=ej/OC5l<^<Um?SQKlYo[KgUM6[
WgignkeWH/W4l6_AjiToB]jX_SWje_I]ifCXi==gJNnVYh[NZkhomX7mXO]Sm<NA
jNa?n4nEWhdoMg`9o?9h9VeVi]ogQ??k2VE^I7=dLVEQK@YUKVA_HVX:<C8P<21_
HVX:<SHa<PYUKVA_HVX:=b0`86mRJPYK82m9@d=2HG=UI20a<B0`858PG@YUKVA_
HVX:<b0`86mRJPXl?20_E7U`IB0_D65WIG<P;deUI6UQ@Vmh85/`830P=3Lf838e
=UdP;d=_MFid834P;d]YI7<PFb0b830PDR1M83hn2VE^I6mRJPXa<b0`86mRJPXl
?20_E7U`IB0_@f5dHFa_Ib0_D65WIG<P<b0`858P?Sh:IFiTKf9Z2S4`830PKf9Z
2S`l82mDNG1U82m6Kfid82mCMF9dNG1U82mDLWEUE7U`IB0_@V5cIDI_KW@P;e1;
@DM;C2]1LVUQK2e2KfaTCE@P;dI_KWA4IG=SLVU`M6mb2S4d830PDR0_AFiSKfAY
KVLP;deQHe9_KF5^AFiSKfAYKVLP;dIYLW=d@fQQLR0c<R0_C65cM4=XHG8P<C8a
82mGJFAdJ7<PFb0b=cP:<20`830P<20`830P<20c<c<P<c<c830P<20b=cPP<20`
830P=CDf83De=R0`830P<20`830P<20`830P<20`830P<20`830P<0Xg<S8P=c8b
83Lb<R0g<S8P=SHg830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`
830P<20`830P<20`830P<20`2SDe=R0f<C4P<20f<C4P<20`830P<20`830P<20`
830P<20`830P<20`830P<20`830P<20e=CHP=CDf85dP?Sh:IFiTKf9Z2S4d830P
Kf9Z2S`l82mDNG1U82m6KfidA6EcHg9YL7A_LR0_AVm^M4iQKFDP;e1;@DM;C2]1
LVUQK2e2KfaTCE@P;dI/HFMc83<b82m6Kfid@T9_N0YK;CHb>20]<cLf838`<30P
<C0a>5dP;dUdHFaYHd5^IfaU830P;d5cHfE^M20i<3DP;dAULf=UKW@P;C8a<R0_
@f5`B6EYIfQd2SLa=R0_DgAUKEHP<20_C6EQI6U^Ib0c<b0_F4QUJFMXM20e<CTP
;d5fIeMYI7AX83@g>B0_CF5hEfUTM6PP<S0`<20_AVm^M4IYK6Db2S4e830PDR0n
?PYUKVA_HVX:<CDP<21_HVX:?3`P;daUKVMdJ20a=R0`858P;daUKVMdJ34P<C8i
<cHP;dIYK7AULR0_AVaQM6E4IF=_I6DP?Sh:LgAbIF5]2WP1WGX;O5CE]OOJnkaV
9YUT<WVoV3>II18b2HATTQ28i2@TDHa04<@<6TV0l?158^2[[L@W47c4BZWF:]4:
F=1b<T58N9Ch[;JeH]FF]_JJGh^eF[Wb]ORhU/cLochCDG^moGkOMbI[[oeHooeH
Nneem]hWjjoKd4Gae4/B6L^_jN`Vjm6O0?_Ul^_Gjk5dLPVA]VAUmjY[H^V/cDC:
KeMMOM?:F=ZkSLReNGEGihYHV/j2Eje6ARc=P^3iZjmIOf</[GN0=ejmM_U4^ENd
Vgm=ihdCkM?KB>_GMUkC1HjW_0=1DOOJMN]52^TL18gMegE=b;<fXZAOFdFKea/F
7e]R44</ROi>]G@OZLC9AE?Y4XbTUSm72]:RG4Vlo2Mc=kfh=;7fHe^VcH8no^OJ
G15ilN5UUgcnnMUa5mWb8F^gi4D1L=Z/b3bJkJ;??oolIYNE8`[>?DV3Rg[[WM9C
]0n4QQ7ZX04@52dm=J@ibheQL7N:aL=YPO:Aj:SdE7Q6QIEO^ZflmhRdUiIB1K;g
QRlAfG^7S4HQ_WNXHVJ<CieVlK0]EZbUU7_Z/`2K2^:D>16K3ghOJ0OX64Q5QoKB
>j0XB9:NU1h?=g]@lDiDU5RO8^g440f4[h6R80VmghVak:B?9W9Tm>Y7@oIhdOb?
;5Bfm2>P4Q6j@;fPOJ3G@0Z]AKP350E9R3f>//N9Bhm;ShEM7UNm@gZD=X:hm0=:
I8`lZ?g18INUVhN64Y?;SGZGm3eZ1G4bYKTd2^:XmWk0kRL>lII`jCA;QBe3SXAb
5nBgX]=KdI6]J7808K?B1V92O^]@LY[Xo>gQa2@;mje`FC0F6G9UU;M22cLBTkZT
JlU77^TFl4WPbl5c`IM9:lQYmM<HBWBEmj:m>XSGBJTd6LGeDQZEPcM:FIA]RFd8
9lCJfA0^:Rk7R6M;6II8X^BT84A]TQH^mnR79F6gQ[Aib1hWn[Lik4X]?b[M:FVD
0ZUNB:Ek4Xm:3/ba`a[9XR6k/kbo?UiJQ64^PUXlj2>3UTEXB=N6DE5mT]@TiE0J
bZjBLRTE_5VJI?7MdV?DS?@S@ohLcnQQj@4;mEeA:IZO5C>]FD?>Q?;AN[/d2jFV
M2lVh5j[lOhQooAbZ_M;AE@6h]3aA/@f8^JBnQ3[`jceHJKj<5=mj5@O[8nT;BSI
0YVYd/gD;Me0oJ0MR0^cBPe3XF8aY8KcRlY7Y4`Y0hYa7HHZ6G:cQ^`9XVLIHGNb
9IHa59m@GWMDFTOc@Aa3GSnDWU6nm[1DK0fUI2PSF`2j`c3GXe9jK6Y@DiZHTZ=B
3Q@Q59<[C@ZWN/aj3m;2T3g4n<oiLJ4ToPIoBd`gO`eY`Gla`EnMh;n:lNPX?aiK
5?cGPXoEio1gDMUBoTOJPASWQoWcE8H:O/n7aNccgo4AZP<oPO@:l17`2_13HNo;
WV4n?0B6_SlLMZJ9`O;W`h6Y4a5?`D@T?G/RhTh[[boPco5W:@MEo1Hl7oaI?TYi
h<O0<l17nGYj6O`IGTTc`OM?l1Oh4F7Ro20o@=?1Ql89XP]VF1=/GePEk2MQRZEJ
YgZ>l9o`_I@5dJO3oR`D?SWTcoLT7TImS>oTjl>i7WNmPco6f]PI20g@2L79cAl?
Eh]:n/=7M<l8knOmATJeDF2D6[^T/X:bd[9MTUjPUn[EnRjmg/G_Q@?I`K5nnEJ4
eJAcF0o80?Gc;F6ifZ`OaiS4^3Se8Qb`HQd8^jdH8GAI<E5jfX[ElC]Y?XRSSU]0
6d6mX5]9AWPcj5^PKh>nHnF/Af`3j0IhTfhP^X7X1Z;K@W@3d@e4=a3M5T:dg0e4
]hGX0:83R0hP>Ra41a0M@7@0dF4QA7lkP>R`4:e0]0;A2TB[QFP5XQF8ER1J;D@[
4:e0]5X80`P320<8`d8H@1Q0640H5/80`P32/11U@9@1D@I4VHDX0j8<R38PbRa4
6A1U@9AI21d87@PM2=e2j43X@>Q0j1I21d87@[L@;R1L@;R0L5T85a0^85a0^2b4
2`PG42h;<@K4611S@8aIR34PaX0H0f;<@X`1<@K46;mQD3YNob8Pa`4i3/Qa2g8L
T>>070OT^0Di3/Qa@8i?35dX@QS<:;2S`8h2>fYQAh4M1GHDf54;>`[9DF17;J`9
Q0V42HAY8D`PC21<84`;H@9Q0V5JR04P1X0H06;0@P`0<@3401035V80R04P1Ra4
?a3m@?@3dFlQnX7X1j8OR7h;d@m4?a3m5^;oNF[h[Jc=QWL]kfFC;KjA?[Ch;GC2
h]nQ@H]oVgIIo5]dVlE_YVZ;gd1nRf>Z;KjN?3HFmU@WeZO11L`7;@F]1Nd0k@<M
0fUFk3G4gP55NJFA9bMZlkDMfSk]V:K/dlHdWZS>EgNXnmASZ[9?7E>iGYo=WIHO
QF^Qnh1S]17QAb2lA13FFK4j7TBk@OSIB_b2?6PTWM8o:VJ_5K=SaFaO<K^_V=GK
nOU<]SbMC]DL2V1]A[aoU^L4Z=YO>0^NjMh37jIk`_hZcc0k4V>CS@2B7h86@K]0
]h6Z@NFPDU01b0>ZmQL3eVKTCEAi1;`@i0GYX6Y:Bl<ndIeT<dJhTndJN]59M]5>
HA5`Ql>5IF33hL;iH0O3QL/lmGIfP0[5[XPmPdFe5gaOf7<BaDo7f5=Qcf6TWPak
PV3]hL8YH9N52eoee3_I9NBA1GCA15n82AOYRl>NaA1K4?I<1P^42oe2^QP=5J1d
<WKD9l4A]m3i/IIlHLm<B>N5?CE2fTJ5H^:IBZEFmaC4AEXJ@XLn6V5]<S?R?:Ll
3gPnA7oo1/G2?7jW3l]P[aD</lF6`g>Tm548eg_2m@hQSoO3h0@g1Go6/j]PRnMQ
e<D:3WPNlTcag5/jK4?f?NSg5Z^9/>LfOIS_=I8m_Ihbco[BTiieWP/mWIj;?Nd5
b0mk;_LL4MfT46_SN`mhFU7Q78bR8>`i_`1m@ANK?CMi34nQYdHo8_A;ddGC/>CB
8d83E1i[_@Cj;Bi0jf7?9MG3;<TXeTi[oMYUFX<fDo=YNMXT;EM;/KU];U^2;MkV
/=U/ZTffLA_IDXJSHdI0W1=BE>^hX<XR8E]a5aMa10R9<a^W2lU<UUYhbl86eV:>
;ZNFIK[ibD;O<7</F68Z_PIV^U^XIE63>Cg@<Za5;cJ[0bfVeWYIfb1SmhJ@Jo;=
`h`F]@fcZ<Rj<m]dcdHQgGU?mPPaUWWW?J4@IJAMGiMAiijEE=?Ln0e1QiGIdASh
l/WhJSCGg=jb/<gLTa/bbdDTVQ]Z<FmMZ5oN=/8C^K>YLH@W21IZ6i6kNF;CaB9O
kVh<@NbT9@I[CX0H5@X6<E/3jD8<oZA1R66>HW9n`27W5@ab3ROi;CVo`fW9bDc8
3Ik@VaX7M@B@:B0jHLVL::2_b<1RP6dLm2>0U4mWKD::]OUdZf>C[HXl7XRD8X08
`gk?Z/S3[<K<ZEn:54b8E9hCZKCJTV;m/JXA0JY9:OY29ZD8<UlZl_l_e]D@H4?C
=]cbO5>G[jW3em@5jS2gG[lj`naMY^^3]f`@1KXYnC^F;El]N6NG^L7GeFSNhV_D
1jMI^7lYOUhDCo<e3];cCH_J1Ylg^Q[3dhaYCKk>a]1@GFeKoMOJfW:^[KKJKfR[
EUCF9]ZZ/g3odUJm::hCKMF;]^Y5FgE6WMEFdaYQmje]PcIZ2<g6_0Xna><L/>6>
K6nX8LgE?D/Hm<Q<KlH]fHMTHTmBG21Ta_/JC2M859GFUmJ;8Z`cDIB0k<B9XXaK
IWZc3k4W9hYLb4kb=M0G4d42gf9F;VPa_@^G]0UC<@fXh9_VK9eh[>8<JU[CR3nT
ee^dO]gj;fXDW8CTogcFOm>cHL>6MN/AK0R/8fXaRaNfV5D;d1==@e<MSB7TCOTR
Ci:/_46k_FTh>X[203[1eX_VA2c00]2PhB2E=3jP3VQLW2;F3fGUUZlmRWg3AQ2>
`ob6<:hBA=4=@gT5>2e1I6YUS>>h:];Q;6liFQRZ1UC`PQPgTTXAjBoX;nf_7RPH
:1fXEU5jH1Lb?K_4Zc@lMIM4j`?[_U06X^]3D3Jj9MYk;9bCJcDl82:1@2R`SUWj
nT;nBfkU8oVUHS56jeUWEBodKFTHXHQ2jJ8Dla5[OH=8RBLF/K3@/`E2;ZAR:B];
15lnB>6Zj13UF;BKLV@ocUPD?OT5AMI4ChXb`OT7l>Bh@A8dlHCY:OX]:f8j3K7?
:IdnHiU/6/f1MGj:ll@n6ZO_hGRoR;Hc=nGS=7X9cF4bI09d=g/hNWgdOCZ?_T^?
A`nbfj9kD7hO_DBOX@OoPCMV=Lf3o2GDANm;ke8XnP>bdBJ:XiUd<D^SC_X=OQnS
7`o@=_XYngKd<kBJ@[NQ_UZZYo[X/m6cE4agbog:2O/cM3lMIVYdNG@=MTQie<L3
dMm4gb4oQNQ7m1Cj562SlPGTYJ_XCWZ@IDX_8OHmNX8R;9jgBk>EHfQY3RfVJnT6
jZ<mm7?VIZg:2NEdm5_Amf25bEB4?ZfQmeTUVl]gb_7AFM7OdfDd@RmS_>8g:UlV
keH^RmA57hTnQm?g@NIPAmRcB[UbkoR]dLNR?l5mYInV@B?cd<hb^YfNYEOXom3O
nLKXA[Z05Z;U5eT^diTO6_l=cnBgl5^T=fP:A]^>gVjP7FABV0kAHCX:gOb1a^QM
U/:bfHE/6K^OoIg7laGl=NUQJKodY/cT7d?O?RZ0S]KCCSY0_jAGjCFVX?hbe/Z^
I6_ImmTSK8bKo4?nZFbCKiOo:Hl[o/QHi9oANM6?LNK>XX_XI]X8gOj8QVPooH[N
`ZgT?nPCiV;CfF[f63?I6?^@fgTNWlnknGJLWYnFiTWgBlo:UG:3O9GlZ_akiBiU
ZmJYALk^RS`@NC[bN_APm7GHCP;Zmn<2I`gM2Z_HBLOX3MCn>oXSoDWH3nZObIJ`
:m3:>[JIKF=?/aOIjn`3S18k3_cbn4cNR5KGl^^PYm_h0g`KFWm=g7CPT^:?o6ol
HdVAlZ@ZZDMjC3:UHNVhm1OI9O_U:O8dNKjlA8iRI/ZEliF5bY?:G^DiiKAJZji@
^mFoJ[MYMmQn>EhloQlARZb>V94Qf:h=UW@c=?4XhA8@^SQ<?hM6OhDNSm4Ic48F
lk92m;^6=K<F=YMMbRiWGN`f]XUmUcg87VJ?/imP11P3em3g0:oW2gTWkn9gl4gl
7]aUk>N7n2_l=kQ@>HFNYd/n:B1=TnI8BjC;Y6/aQ_Fhb[/3V[eOfR>m9[dQ_BOm
ECZ5FD^G9lTKi9_UQnCMlWkiMNDRiA[l7UN>:J?:jlYIiJc:eB`eAifZGZTnZOi9
DkDZ[EGKX[fYoL?FcG9H<GZ^`oK??C`CJg0Bgl=Ci8g/5;9cLNY8a<P3V8N5F1Go
X3XYPWU94>GXFb[?U9<5G3ET4a_1mN``EK8GJJ?:9F`<iC4:/kOiV?`l?hoNHQd/
Dmh]GJ_lW7]Y;kaA?co23k<6f/m[nF;n@hWH^gP[_P]k_i6f/J_H>][;C[4Ik3^/
VVfT=gVJ]93M@KGAakW<k6`>>dgX0MdZ[j0[cPgQ6b>/1[OckdLNUIgb]n6OQVTk
I_@YNXOmV3iWB_A3N3L9gZPCG^I^f?^M9;aN>mKIAZc7C7R@ZmGGJ3mCLHMN[LjB
KjKCm5od_W885]D0KoYNI8glZ?cWJ7Fd52/<ZhbNa;YKCNMSaK`;:cV:]4QMSYG^
P2o1iB>edQ9LWWd7G^onZ1WmHOCfj4gA]O@;H3mW9Nac=X0E<@a4;NjmG/HZnAgK
RWEhoSL>konJ6EU1Xo@1bf05[1c[hIAb_M:_k57f:cmEGUFW@M]gd<>`j3o1VQdH
`G9jWCjPCiT=Li=99AA4OjNSkfed=@m9AfTfbj9^[=TRn?66RI6/@bfg@G/oa7Xn
R[Ea6WkRL_XYk/lhBlN8UZ=m6nYYPIjGdS[JQAVlW@dQI`FlMS7m3N=>H==a?E12
1V[J3ZleRSjmCGn1]Z=F_d[P5a[IH]Ce:Ee::m125KFb@Lc00JZ1IffDOPUmic<G
=K0lmPA`7ERQ2KSl[U7nc3REA>I5Yo<edU6lHj;87l3K:i_>HcgXAB;6<DjYK3iE
ARi67miPTVbbGe^mN8QgACM9=dB^YUo@Sc4WQWbmeTQTe2lbjVJMEc]cA/gdj/YP
AOVd/ZUCBT/2aI>;2_d5nKhl[njIU9^CWIFITIjFVY;/CW8U9SSShaafVjHZ//@I
UCCiVS]ddmmQbWkO1ANDR[B_4aVMGlWX<7ET=GmMa]@5[Q=5Gi<d8;WbGbB=V:Aa
CY:im5ZZ;BgAVgbjnFZSCamVBaKP=67NdnP;jNHY:ckGR_MKLBORGRl0NU?6jTKM
I1ejTmUloNZnYXk6dQ8f6>NHkI_MiBP]XD577:9aR9WY_^i1USj;FA6NgSAST9?=
RB6JFKk69S?C1bRZT@ZJ>UNH[@_JVQZc_Mi@JHW9IRog;C=9k7h3UPS=]YXaeMVV
ISFS[l7^eZB]nV39J=oM`biJeQ68Gn5KdGUiVbUeXXhV<bV0MQ_=m9]?IWbIA>GH
9fojJVVfe=ND/DHG`WemVgAcM47KEk3IGU53:8@jP>D5cAemcFSjK/aDRcQBVOc>
D9_9kTBC>2`DF:>:SBmfTRWX^58gkKh6gnZn:c/`=EUm9UelTcNLUFF<A<LXZdW_
FmCVliYefKi@If?>H0[eGGcCD:JQIgjmY;ATd9DDDnaP@^949=kieDPGU1h[/f:F
^8ReG7a>/dcddCL7ng5CGjjS9fdnS6Vj2;ZVDmobjIP0?246U;T2<k;6]<o^j7?=
4?TH8S>E0YM?ko^HH06nDamn?JMc8TL]L7e<XU3HbCUC<eWW5g4c432;RhF9J;<a
YnSS;2]MFEYboC2_lWFkL3MBQH<P]D:gWJ4IDj5n[eM<l=IQPiHQHOH^J8^UMEZF
7BIS:/i;_4>DH09S9JVGR9;N;d[>`C]l/>Cmh]j2DTfKomaOXR/]^FWe39>UoI_R
[UQibd9O2dhgNU=OahCE]RcjFRYF;Q@:_J5/8VHVcfjC/SWbA8aWBeHYS?;b9NM4
T6R;=nD2o:VRdePM4XcBbV1j/nWZ^20FQQaNklBBnInHHLgf5M1`m;A0FNa;f<@X
c1V1RGk6NVg>o5[jJkf;ki=J5/7Sl9I5Bo[j75l[JhH_jn][m^W=OAemWL?AgVDn
gNG[6n6knNjnkRIhXMR43TL?KLdfVnl>HBR[f@bH;JN6@AoK_63@H9]aO1g15I>n
NE5KV3<n^j<Q=9R?/[HA7BkGb^GWLXF<;U;D`V3XHFjcR[973:9NBeJf<ZcdLU`_
FGTa8N@aFSk<HgT^BbhD2YER`hnK[A[/I_K@EJ3IR6n@em5Rd>?:cg2VnQU]1gF2
]RV;jG_8Wb?oVCJ15R4N3dXP@RG2a0PkOaG_@B8MKoaHSYE]1Ack3_7PF6lm2VCo
oJ=Q=f[7;R;^gh_m[jGan1I8E_onEi6_52CRo`o4DhDO?RkP37Pc>la_U4ZTEnAI
lR?:4fZNnP?]CU/SkP0QY^274FWD/9ncR:X=lcXSVA@i8Y53Tb><<VfZ4^7B4NHW
>`h@6I@AL7eB>ehkcgFVM^ih;MDQkSZ;H5ZI=lVKE800=hidEYM6caX:oI=dNEAX
mZ[80[iJN@>mJcHBRQ9gBmaVaglk^<Q]>l[ba;lm82BncG3Hoa7o/2jGbE`Ni]^7
TWIN9EY/?cEniYC[5=GE^FYMJ8^e<inOEkZBZjX[>4m=LJNWlJiW7aYH__R>dBf[
cZ_dAAJlaokn?[KiO>aXi?G8YOoiA>C9QeN:W/a6C`b[9g><S49Nj5S5EcVn3i=o
<T6cfo1_6>RCBoB9<6:[Co]]oe0NSQNmLEliFoCVe?S9[gLVNIID6NABAIXk=DGS
D]?2aQTi:kLLnok^QYJW8P_2?og/W@gobGk<Y_hf<^Vcecn:W8WlDoAT@fB4kFAR
1eogS=dFYcZdHCK9b5Iob:K7>AcG<KnFWhR;HAgOLVG:S5meODH0JVnONg8LRYQk
j/`hBjZQY9ZJJFG9g]@DEMD:ZjZZOGNcc>8=BjX_^H1_IYV_g7a?]khnIaWn8HGC
h^QkLX8b2U_Bj@6SiDK7I/M^]TOKHmnML=3n/]ff>2VD5/YJk5VE]3Y]MMHZSjf6
ejQEmR[W73i7KK8g>gOKOl5ODEn`_n3l7On3nZKmCFNB:d??h1VhS34:g6W1S5df
YbMaJR9?=91:g4E:kXWi>=eViJFLR<_d__6L=H:iYnJi?^VIRd6L2_@84_=9kNf/
?3d]bJFY_Sa:LUEGYNNYVY[TBT^[::nZ[TYbnOflo:dKkn^ohJgOA3i7F=6JUQ^L
Ga5Sb^R3nb=;8ad7]^>H/H/mNV3knoF;[XWPNAJk_Z^aYnG?eT?WSl?LoM21WAHK
mZ_h]o2iEh:U/LU3BaFV3?<[3][/2Z=h>fhXfZ0ca]/=Yd:bAmIUDiKUC<LQ]Q]k
oMQDe<hEJ`6;X:kfC?/YC0BeNke9ZUIIUEmM8OTSkogPmF/I;c/YnoZKX_V_g2EV
@JbjHkS5dLS1jTM8Rih`k=De@KD8PBHDJBnZ3:X60ZA>6:gN@Y@QV4c5L[5Bi9PJ
?ifZUK[h:nU:gRF]E5KKESWn:RENZ3:aY2B7gBi[M/IddU9`nU7]/Z`[JXZRZ3J7
TIDkbb6JR<_:3CX:^2BY/_PZI2BX6UMTG??Hh]?C/fRHMn9k1N[0iD<_TmP`ccO/
7S/[/oOJ^Od@cbLI4WHM6/^<^f;iQ5V>IgkBgW>V_BMSO5iCEn=OX1D/eK[J^JNB
g3ECJlL3PMY=bYC0Y^nl/6U:QV2JZkIfd`/_3:YlmZ:foOJPgAVT@0Rfd6;6hN9a
4UkG8bA58f6Kk3PDSD1CI`MENKYh@ZbW?GI_i_E:n35_/R@Yab8okAdoL5?T9CjC
eACoo2Df=c:T73[KaoGa<N7U]T?cbj3iI=Qo2Id`jVhXIZ/CKRcnRob9;=^mZGJe
Z<AKT>KfY<i?iFFYne9iJVZ:;jo0WFcCD`[`R/T^k5IkLDA_:B[L5loRXDWlod`@
W^5^`e/faISB>ZESB_NDgRWmD`JVf?@YIE?hU9@lWOCT/VBN?<bg3YE>FoR5hHcG
cWFemg`B`3Z0jEQnE?SBY9ZYkCgReY9BXkgQg9YD=1;>4Zag<;T6H`i1R46S13ZW
ZdAaLN_@XAN/XfA_nBBhA5E;`aT6GT5E_2bYX[bjZZXbj2odnj@TkdC2km_>;oc9
gTe;eRjmZkom/N/_S;`KLK:Riih^_^SBUP];G]o3g0>1QXG6CCmG3^ENo]3BEDl5
2Xm/G76dafWSlT^AYaGkYNLgGV9GaTLR=m[SfnLeG5h/o5YWm3gU2WSH;?Z=<Nl^
niJD;FTkj47eIoHgYCOS?YK/1OJRn2;Wi9C9JA^D3OJk59^F[:FW9jNWCnK5DX6R
5BT?:Mng_b:m6:OD/OUH^QNkR8gQL<Q9Z3`Y8fQa1n`5ib0S?J=D]RDH2NiP@/_B
A3HoTBDJZAW1a65FI>BiBaeBhTL9RnTS/Z[::/]Q>JV50aY;e3aJVBKQUGOgD?H]
4o>2fISWJ_nT7I>2>ATo4fS_>AT@G4CJaOYVkG1DRR[kM3PYl^[YJNV:gno;4ih:
STZ^Hij6b:/OA]j>K<J[=lRLCjhXSo`QJnOe?o[5b`?Gkn7IUienWmf7fk9[fOMf
G64fGgO71i7?8aml2>?T^3/UYA<FjX;KgfQD566iWioN9GO5:lGY=NTGY8GBEZLY
=NUEfI^b7e:fabVN966FbNj2A9L]/g2OaX@34CHYAVDTmgZIkRgcLVnB6eKX:W=a
Uk12oA^]l9`9RU7f<656jFWF2`dV1:LL<j9I74HT[6PKccgHLN]`AfWeb[Vg;g]R
o0eFm<M_Een`];KfjXFcWU4>iORORkcgZfM^7eSND^bAWc]KVN1No>:N?@MF^[7E
H[S=9OTdAQY7oLIi=TGFK0FZfj>`<VFO`QG5;/T5L=T>Nd4LhNcM8_4;/8=RLEVj
/laY>2FWK=OQh/Z4BF14lElMTCF1]G??e9j9KDnn_Z`D[:OL6PG[2L]:/2nGUJC0
8dd[ZdSbYV8KHm7gi;Zcko>aLEfZD0im5SWlJJCWDk@i9oYGg4c>`Xe]>N/aEV]I
]Q`U=bg[`^`;L^HDo<7eCY:m:[<ile;ob/aEo[_lglel86]GeTSfck9NcXiGEFMZ
VYZIEZQ>CPeUg/3_h[_DImBGe?QS`MniN6innKBT4VNn4IPBc3ObRQ1TiPKGiYo=
ioW=^IQLXb`Q<GQN;Z=LEjjIneniLVi^2J/P0kUR[l3Y4ZnATeCW=K9M23:bPUil
EGU6e^:MSQ9Q6bRc>8X]3XTBB1Q6B]bTJGkKI7^A<nB9ga7??O4/2QmW9:@5hk?V
1eV`0k=fKaUS[6:bMfTjNbNMcDmOV[hfGD[?[5QC7g=[?MMQhOBLJQMCP1DSDRO5
no4D71MNTWP71<jd1dkROM3N4hPio_3DG=HC>QE;S51nM?APMVi`DOj:O=hN20T_
3dLW9F1Va;J_1oj]Qf6ODe4>kbJUY:EkHHb5:_H<o/XP]SmE^=LAZi49aiNJPRF9
[:Y:eQD=o?Ze8l<]DWI1i8<hUbIMl4Ck4dLG?ocM5bmZGM^bR5eAmD5nME_SADdE
[SSnYbTof1KJLS0bO?NM5nEDImZJVl>KUmcCTU>PibaXVQWi]K/lXk1fi^9bOgEn
5eBn2MJ`3KJLR6lUShb@>oZI<Bf^YS[ko6c^GZ`^MRa>Fi`Ab_UDDb_UVLjIbIGI
CG:;/bFi:G^KmY3M4Il03dMIh^>GXZF8^DR>Rd/TAk[GU]DmRDebCNJB7li//Q7?
^ZTGkFGVe/GdgH>GjgS]GnJiNShA^jWJ^U?h@DgD0cLe^lf8FjV^M:a<FiVa9TMY
3e5k0:JM1=GQGX^P/<;Di9AdhKAR:]_4<Vl;?aN9S8mL=VRhPg=^J[omSUEMMbV7
aTm_Rk`GnJo8jLS_;`_mT1O_W=nmHnn1aahA7V/AaRhlUQQk_e7Z3ZTQAlPM6o63
6=iWMW_gY=i9O8HDS9nA6/blD6Z<_c2e<O<Q^ef<=Jc4RI4K2G5J@R8<c94n>L7Y
If:dRHVDMIlH_mNFVM]FJaVHl<hmWlA6;LI[SMSbbSeR_<hejQ[76WM/a6XkK/0Z
QFG0DK/[b]=a<_WZL>G>b3o[1iLLS?`clUch=YHikYkJN7?WiS]F[MSd`l]2n3aP
`oEViSK^>]^mij9[Mcial;4Mj60lo5H7K/;Sf8?6eR;]IIToZ8f`]mUKfVTWGVAI
LXIJY5KCM=/5;<BncCIX3Sl;J5E/Q]K<;]@NS?]<oDbc5lQn[MPAU6LhI/_c7<o;
]X/LRnB@HhElSN=6mQg7=WVkM/SaU_bfhjc3:LVJIWNTHO]Ik:R@jac=/SdE^m0I
SWV>ZabkiH?b:hi?I3_lo^TQMdI@aYIa:3EMl34S=ChYb6BLhg3F4`cWD9/TXNC0
i=9PE68RJRBVi@LU?kNWL6iGe;RhRN;CL;JR>1g5LGiB/9MDE4FA^6Zcfn<8>nE[
`VZ57Lb8/gG=Mni`S/4[Bb:KElB9K?MYZ0]_/]SaYB_nQH6<@:Hh_oATR;M[9[Ho
WePaVQ[K:6:g:3J8PIh_mXRa63HkjF:gTehCla7?>7BkeaYP61`OGk5U59mPfg]j
[V<RZ63H3RIk4DYB?=/H^ImMN^@UMV7T@KHU/__4kkV?Bi6gFGk4?_hjVa<i:=i6
2I45l/FHeF@Fg>l^DURb67Y6O6;@U^I<36XRD4FPY26?2cO/bIXAE5AEM/HUZ2i>
bJZLc6E9`WlVZLTM;^HJI_/<MebRLfY24NVYIJTMZM;YE2IfLd=ioZ3PQS]WDS0E
fffiAS8b<X<KaHB`@/?>[ACNOR;UaYL@8jLZ67_GIJH8;@XU1^J>Ib;4glAf6gZk
KZk[c4ThfoJYMM2UZiJiJl@1dEgS[T54P`lEVXYmh6i_<EgHI<o0aS6<Oa0j5<E/
ADl?B_QF:?KGePiDROkEB70VeBFkTS<A^3?Zl;hl?HB4h66THgF5TRemJ`VB;jn`
D3RDjP@FR7c6O94]/`]VGkZaML6lc8K:IEMTb_ka1?kg/gbTOMUiNDU_>mN59Ti4
n29@B;nUKgZBT2UQWa0?7i><Kl[in4[ZYd9lbfRT9WaO^@cgnf8>gL;Ll8R__mCJ
DWmnbdF1n^_FM5iMf[3fjQEc5j7X_`5BF=A82VE^I7=dLVEQK@YUKVA_HVX:<CHP
<21_HVX:>C4a<`YUKVA_HVX:>20`86mRJPXl?20_E7U`IB0_AVm^M20_DgERM7U`
IB0_E79eIEAiL6DP;d9QLfE6Kfid82m9ETE3Adl[B6E/MVEdJF=Q82m6KfidA6Ec
Hg9YL7A_LPXa=b0`858P;dE^HfmTJFiW82m=HF=BKfeQKTE^HfmTJFiW82m6JG9c
M4=XHG8P<c8P;daQLgA3J65b834b<B0_EfUTM6Qc85/P<SLh2S0P<20`830P<20`
830P<20`830P<20b=cPP<20`830P=CDf830P<20`830P<20`830P<20`838g>20`
83Dh=20`83Dh=20`830:=SHg830P<20`830P<20`830P<20`830P<20`830P<20`
830P<20`830P<20`830P<20`830P<20`830P<20`830P=CDf83De=PX`83De=R0`
830P<20`838b<R0`830P<20h<c<P=CDf83De=R0e=CHP<20`83D`<20b=cPP=CDf
830P<20e<30P=C0`85dP?Sh:IFiTKf9Z2S4g830PKf9Z2S`l82mDNG1U82m6Kfid
A6EcHg9YL7A_LR0_AVm^M4iQKFDP;dUFAD=7Cb]8IFafIGAYHf4P;dI/HFMc83<b
82m6Kfid@T9_N21K;CTe<B0]=3Pa834d=3DP<C4b<Ud:;dUdHFaYHd5^IfaU830P
;d5cHfE^M20g=c0P;dAULf=UKW@P;C8c<20_@f5`B6EYIfQd83La=b0_DgAUKEHP
>CPP;eQ8IFUWJ7@:=C8c82mCM6E]B20h=B0_@GIWEfUTM6PP=3@a82m=HGQGJFAd
J20a=C0`82m6KfidAVU/IC8P<CPP<21B83hn2VE^I6mRJPXa>20`86mRJPXl?20_
C6E^IgAX834i830PDR0_C6E^IgAX<B0i=cH`82m6JFadIG8P;dI/HGAUA6ESKfAU
83hn2W=dLVEQK@Yh0KeJ2gbCAKHolkfC]6VB9/fSBI<dCM;gTiKFUSJD]YA7Jj48
;E9XB`/]PR3F8[Y`Zl825E54X3h^;^ZF0X^4dXD0j[9LO;/[^Ska/KZ2jnjejkek
dJ]2TW_VBnU2Ojhok^oWKkl_IfK>c7`ciocWc9WiiT_Gb]_J8AYjP8Fj^Bd[5X5l
9Md>@0HF;V]I4N5S9HaOFmSMiHS`O380^gCAR/G;8[cd483B]WSYjY7WmIR]TC[J
FmXRiG09hh8>c8S`I1c6BAg;^[0ON^V6<9ReM?W2TO;H]i1?GmIbndSol27bSY]K
U[ESS5OB;1Z/F7i[Ula24YE_nXZEkB?eB@?:mcX@c3G0Pj20Vd041SAh=`68GbQ]
`64Y;LN[]_NIG@]RB[h6;Fd6H47=oG;lk_<3MgoKO/V[fRYmQaV:boEY;:B4DP2R
29H?ZkJ>U/S?HF08@7eJ0:HPUB7U8jFUCCA13nV71i1nPLA29kTGER=]@WXHRA]=
kDG^6;UgT9=lalUZ/92Y?QEWWjDgfde:UOg=0166M]WO=gefPYQam3hUi/5XD4aD
TUn@aj4=k>BGh2Ig@3DTTdL>Ybbe=f?AGUR1e8?4bR4QN`LCL^g?TGA`L`BOlD02
AhkHoibCHCnO4f38X?fD=l1Qm=/4i7`amY>fGOKOf1KKWd?J7bWJUh8eS]SgfYKJ
]bD4b2>3mPM]0H;?K8e4]mW`dB?fIBTkk6diL_Wd7@5Voj2m2<]WneCfPT:W?Mmf
cYkU3DP4n@cKM7]Zc^o/BOPPEW=PXfjOeVjeKK=OQdD9]T[_MDPWb3kb::BBA`OM
Dng7<HWZ7YjBD[PS@>hlG9fLh`j@>g`5eLTkDZZmkYCYMWM:UMN;jMT_RN_46lF9
HZjH9RJ;7]4YaX]jBBMY9;DD9BTUBA83i5N3IGKQ1=T?I@S;o/>B8?41lSAVLRO8
0CWc`569TaP997dPo0TJ;`5mP>`Od]0D9Xh8LTX8T0>78eT7O7J>YSRi@<?@=0HH
0T<T1ZJ2Wm`G461mG7NIZDaGZRfZZ_QW@K=LLSU<nnNGRMSl>jKE=oSgfA[m^C@A
]SEN[VjjW?RWLMM]F=ANWYHfKNKZ`md[URbZK7ME=[/Zfi6JoOMfMiSl?Jd>aj4U
:fR1`lmjVU/GM]2hYMfo`]ENhEoRZW0LjYJO6e>lR1Ig^bX>`J;:F@f75_WJ:`Jk
OMfE[YJ:a/>]iB^K[^Y[dfQO:l]oX:mbf]Q:fUN[o=bH_YYXLB_]ZhWfeDCkJ_Fe
bWeAiB/kjl]_kD;[M5AfCW?hTn_mDfK<KO0kFQX[0Z@O<b]^0ohTJ?QW8IW_0@^G
1GJ0l?]8IfTL^R7l>OlRJ4;;`_o=5^>P7Z?4Q<Y:h2CL1ho2@A1P0=?9<1ojh6Fb
1>Of?1R2MdP2I:;_iB00dn4e4Pjo0H_P:JcO1JMP>ab2:7aV6OZ`jK25^<=g8>o3
M2^/2cl1BE08?hMWX@QKg@;3hKgQ`ePj4fj0OK0OWgnE^9Q3G6chjO0iT606][T>
Bmh8C`lO11fT@cWDHNhjN8jhfK?Q3S11<D[g63`>^n6gl2FiV`b5>l;MhC?QCm5D
CF25N[cGT27b:G^@ngWh/O1O`b548QUB/MMVf0I?H_/7lCj9[[FBg4Bjb3JbWO4a
Mc=3g7[N60XR3RT`6NmZF0hK4H5SL1[n3]nA[aPCZf6kf>O3nN7o0AE<@bfY9^g@
SOL6_;NPCRN8@;;99597eY27b7Kb1bJE^H5YH5Ha]c>O/kG/?7Hen`O^EVj@glcg
2J[@en4ChAO3Kh<AK70S[8BeZ=dY>0<Gh7_2HU]FhRK5Y9c<ak^7?<XL8k_9<JJ>
W2AWV7gTSn@clQFib?1<56=PdYP^IQ^cWcW5o9k]I;Nc3k=oI;oVBWV6glfO5mcR
1j7Fd:K@kl?5hDo3gj:;UL298e<>]K00FU3K5C0>oPfe>83g@Abedo0l_2cOWa4[
3<>gR08@7K6@G5:3MbfiWR`RWF@G>HkgLk8/gc0h48b2dC96a/[D<jg<<ZJ7NI_Y
HN?IE7HZ>iLmR?M;k3_/AOHRag>aW86Kc4f1cM`bkQ6lnkT1KY1kWBoRBoUJOSKO
`foR=k<;nCOhMhBe`QIQD?Q:n2mdRm?5iN9V79fGdFIoRkKlSh/SBBQm;]`<2dT5
JHDM>1ZkB@_dXWFeTHf8e`Y83SNaJmW9C3IJ`g=`9e[[8k06=[7cH7Oh?GHO_8^F
/QBKk84mG3WHn9dh>WM3=U[Ab>e;BDe9mW[LBJi4Y`=M_SGNHSHIh`cjF9eF4afU
DRXTDN0iUR6@G^VZJWKh?Lenc^>Z[/jP_:/5<eZ^b6S6ZNc`EeeMannPckEPdEDe
OEQcdIRJ_TQ=gfQ=XW6D@4U6^Z?BiO3o[/;U292i<aX`OEn5Zm7Q7iKC=G;j0CTM
SFVW4am`E9Xj:Qand^bXm5MeMoAF=UMTY9=S?XA3VI5>7HL?E;AQ?daZFH<>5RKA
6YEnRj^RdVmfHA[;F7MUBi^oKTI3IDFldmV8NIPe/`7kb4S_m:>LL6mDVj_]gX0?
FY]YZVENPim]JO@ccK@]KI[Oj:[`6nlhKoX7NcUE^OV:@SoS[VYYkjgbni[_AG0Y
fdbiU/g8CJ]gH;?<n/H6?eTo8PBEL@U:B/F=[0W^iRD>_l9Ek^[XGM:<h<;<QT6;
cb8kGcoD=@bJOFJIbDPoIUYKk4C]SfE<c9Q8hf:WJFdTo_<mTO`gCm;H]?Kd9aQ?
VcT:0:48^:JPW7k7@[TC5`YKB8?f@^QMF8PhhME8D<e>U6NBWd6KHMengSfUaMmC
OeV<SXZ8L<e;:PHEIX^l29DgH_gVG/ee>59HGn=bm7j=ZgFcJoS;Zg=JAW84]nI[
X8EdX4M]aDmJ;ZNkjF;YAZdkC:h>>[kMlYPRkc9EGY61?8F6b^cGh`9Nen3d>aXa
0gNCjM<2X:Q[>4C8U/H02Jl?@8G]6>iAf@Gc/CRMVUYW1OJ?C4HjIZ@j<IFIkZS2
WZ^X[CQj7KeCfWXMEHh>=2K>;LMHd=kKV8D8eSLPCS0;No@eaXlVfa/K[l=f/VPk
n0QFkfg45YJ<]82aW9DEa4[IjKRH/YjjQQT=oYj:N;n_XQ570LggI5f3obAJKV<S
e/XIUA@UG]=Y6Y4i5fG>BLGb_4P[^7OY`BHJNg]YVoD=;ZOoI6m_O2nMKa4n@61/
QVlT8`2d2XDl@7[Zl5V<G<ihN@bL;RN:eDPa7HLVOMVRL<onh`PGS<Z=Chi7J@]T
Q0]o8XB;[PGQjjh9hN9ABJm2^0AU;ZH8CoSG8Eaj5L9U?hj`KeA^578RB^^C4Bko
RA2NM2d8Ee`C`YFSTUj5L1G:G4TAW_b_@kSj:XBWo3S2DdOUAR6WXKACIHBWod@8
ee`;`[GGQ?3eXi9NQG0MbW`mAGS6_`kQVELQG?oS2<lJUA^5_06UWBDS??/W@WS>
]B3LL4d8=hi:NQG2Le7VAX[`SJ<8nn;mL:DOkQWSM^4WMlcc[X0LMdZl3/ZI8Waa
;X9mg:gP`oPckUMPYLC?aU><Ff4VDSMB8GTAePWkH1fV:AG;nB0oKlAd3kjDZi0<
f>cUlj0XO4]i3WT7c:F_icmh<B>ik0nDHW?08`UbVOP3=OhoFA:^jKPi77e4=I::
`W<O=LC8W0Jdn4I7[eS@bg415407_UlbI3[YHi:H_k4=k6Wfkmc=g2]l>ClT?2BL
4d_5VbD>GbS:0KPcn6k;hQWIY<RiUI@E00i9dP@0cR1A7]?/QiS6F<BHaESa8Ac7
Y`1VYag7UWR</g?b]4j]5jVLfa:hm2OnfNlW1KRJRgP>PVS^2idQ?G0F9Lo`aH5;
[FbCU1ZSdB:>DkJ1I8iIf6i:ZmELZ2T93]MF]UMl3VDe`fl=if@K2lHGi8ocN5gi
N@Jm8>j[]<H@I]TkcMe_A=f@TBZZa;>_[1ZRPhQBn<;_LeJn3k6a`Rdnh`JNE4V6
o1SNVRm6j`[IiJI2EL9TVjKk]>V]hN0`U0fGH@NCE__6@GbdQkP]7XFKmlBYCLV8
YBjIa4^HdPRH<THITTT/Ph5IJDd6;HL1?ClP=92_^o1hdARWeHR<dn7eJ<N=ecUe
1MYaS2^AdNZ=LGV/kfO=LmJ6oQ@:[Nd/jbKi_Ofg7gQlFeKedgcOnD>Qed8OoRKd
]dm>T>8;1dWEmnNo9C<_T>;@fj6??USoJTBgca348LhYSeF^cl:WRV`Z2:9BPASb
Y8d3/jAXLmkn<ccLZJDXUXbPR31ZD<_H?8=;RoCI6gQac[?1KGR0@LO56QkV3W39
J;=;O;hik69f0l^2@lNb3>?@hL@@<<faW4?7l`8[L0b`?4n8`2]I81c3/l@R2F0F
YHg>1KnFnbkAO6</dNZ:H49IVEIW;<[RJT`K=6VJ3FTHhRlWVcC54X>268REfgZY
PWgVhW9V?WUU:;@c]6>8_7ZEC4]mi@g@`7J`6eV>B/F`E1jFXo88?9F@`8QD10DT
E2X1;1;QN9JiDRXSRTFUVP2SDVg@V:jFBT7blDNh0aNG/bL^EG9KbI7@n26bQ7@>
Q@[`F1TBL7Y?`?W2h:aD`EUOGCEY81d4QM_9mBWg:P>:P598EQ8@1H4`TT:1PA94
WV`VR:1NZGC[<4o?lfhMEU2YN5JQi0BNZ1S20Y<PBP7Bj5?PjjfPD;8lLP<nGG@d
7N1MI9OB71FmfkUi?X9/[[ePZPT6cO8@EeFHX<aHDUIB4lAAeaJE4EBc27oJXZ`=
VFU[===`5ljMS?McYa/gI9Y6<US<H4lgYXgDgJ0Y:A6Aj>0d@A=ATMPlhV:M[8^`
Fohh_?iCaW1fNo34hjla3c1cVDg1ENc2kbNA@:QJmQhc`ao:Y`daN8iD0Qoi2U>c
RE:SRXnbN_>Z=If:9AZaB=95:MShG359HM=4fH[CV<bDhZ?5C75^ZU^W4GW9jTdd
FP>TenLbf^bReiJYHVciZQ:aY<BZ5e=B1i8/YO4YeZTagT;cQ=9Wb4hlI3U6MT34
g8L_3=MZ_ZTi5cb]:l[24LJ9GCHl[2^Rm]N4:VH>I`iCF;C68WW29aN<=b@2<K]9
@H`CC0WaCXQcj9g4V@SS6BMHK4HW<CPaX;>LJ4[X5;o[;YcSY2TY;RmgO<44XRHa
A1050hWh9eNR:8R^DY:GRlLEFSeF`RkDa9GXmGQYi<TOEc0nUZQGeRiXg>7/b5gF
VU=?QTX=DOOLLEnaDcW0onnCcgKOIWA79FQCdce=ZG6:lKoofOIWSno/OGe^nYCn
[@J[X8jfIRdVBjEdDlJln^VYmBllFUgM5maYCFCImE52^L]G_NCG6kLo5D_>DEoH
7OjHLo>WL7e8P1Fnc7iaSoEM:i/XaB@`^4@IKKbXEBKHE2ZmEk8h;9VJC982F[?M
/L7iK5=T7]L4cifSZ<Z>4P7EXTG9j9UdLH8bC]1kR4j9PD4dNTR/8/63H:53Y335
iVTY53Z]7QdP8V1`9E4WkTXD3=@IMQl/OZ[iYNnn>G_7[=bROVKAeZgggGW<<oTD
Ob[hWcDc@/>Q2j6@_mQE/fW=5lo]oOS86c_W7i;mNf7h;3^<>ZW`g6RE;gNlN[9j
SWX?]cNNMd]j9/JV0LUV4f>ES<fXhS=S<cDYFYg5[_9Jc0Wf3LjEiB?6PT[QI3Ug
SRh0EnYU<ETEBR34Y?:0`XX1V1T?:><U3jXUJhJZjNS@S^R27]nXcM>jl^T8@ohh
GMhg3niN/k_oSXekBFmmmX@3CiCmJ_WQd?MOOD`FO?7^bjonaiUGV?7S4ZHa]^m;
]bm/81WOoiG<`K5JQhjhN6@M;_1IaO<L>T61UGdk>Y8DTJGNOInc=J91BLgYH<WY
bojm13dlmNmJfKn_>hXGUg[a7OkIefCoSVd;KVhbN62m[eRDA;D@HiB<JV><Eo:Z
_C7Ei]VZaJXXUe]Y/KW<BXHc^YdfXbeJ4468]k[IF6DbnQm]2WkT88>F5?Y]ahLH
IKYC?63f9PM8m>5oR1DlYkT`O24h8QWj97A:`l=d4];9Yd?[XJIQ`1U3YhWalVaa
JB>VPAZ<llY6XWF]6oB=JkbUYcHmZNB9m_MZDdoLE;?ThJ>FU1F;mPaaFGgG9ddX
BjZJGOoH[2g1lL`G=mE]j@m^IDh/biffjoGPBmCnDFmf64m0cF21nKjLXl:;0/<9
N/6[kaJjA5hOaNQ=6Y`589QDBX]X/D1DR/9R9IVV53>Hhm4E2EMY9/n4R7M1_HJe
ADDTXQ2^IWV6:eBQ6Z0_D1>3eTGFkInn[n=LGOYAFoIJGl[D`Xch8K87iIlolo4i
C`AW<4nfU[A5aiGWgm8IO1f5aCFV6?L`CZhFco]=:?/3_[`nJHOVhKQOLP=B_fI_
G41jBGZG>jonRckZ>TV`VL@XVdiU5/eV0n>=/L@[_0Jc9Ci058NM:b?C^4KfS>P;
AobR?8?C`LQiE;4:=74]hb6R4E=l=:JDnRP?40d6DYcP8J`J0n[li20=cCm9Uclb
A^SSM:3E<>PclcF@9c:O[<nNO_bG>gHlRAlg;XGnmj?@9J;k/m15H_Ygc7oXd^3n
LncId9Lh]H>QYdWJ9GBP?YkjZM0=W1]EEd<RM?WBmdYkS4bbi;1ZeH;=8<H8JY]E
UJQV_2I;TQ:mU3<U<LK/B_Y1;bE?Ije/IkRY/lK50foaL1j8AlGh>0b8FNd1eRS[
96]4OAGeC94aTgdC6K5??70F1MUiJEg<2g_LELM?E;Xa36DN;?3MN>NAd=6^AeK?
c2hNF_f7=g_V7C[Am/S?i_BcQkI<BBh9o@EeO6;7P_b4:L6?Z2fFQmmUSg3Cl8]?
5/WdgEnXj>=gj1kFmaWjDXGT9;Ng`5WUW9`dfC/kJHigDM9RcnZXeM6[eMf^[Z@^
MiNW?f4P?IH5UH7?h39S`F:8=eY=QPamIW:<ZU?b^0_LS3/aF/VUaIYN/=YRALjF
nDRJ:T]DZ3F<25W>;8_M56Ob6T^C?J8gfI:S]W/eYN3==6OW33[k;e_9QF0A=O5P
T@ICM5M@U4DGc:8R^YcBeIA>he]TjiU><QR?0KO;C[GM2@[lU4[HM5b?LDoZ93HM
i/G[CDkRR4UdPS=A7BeiUDkRLB^D90<g/48:1PUJZi>Hhc2@mm6J4UaSiB1RJ?9j
2dfhg<K6hGY17JkGTdDlG[Z<D]lQ^S0m/YcH2MK1M`=LI;gT:lUM<M3F=l5kjofK
9WImL>c_=deRm_6NdXLGMEHVejhjEMkio/MO_BRBXjA^K_JL>CMF9/GITQ9CYmcE
mlbF^AdCLROGnZYBcK6f[?C:Qnholoh_V>o@5A_3Gc4:ORk>b9VoS/iDWUBC02Wc
^KVh8R<[Z9EJ2kY8o:ZD0PJe8HJehbkeDYcIK;WTG;`V/^@4VhY>In7^C1=aSEWD
<@I;QSG1Lk;WYW]c^RiNgS=hlW5=bA/h/Wnoai0CWJ2gCo:^WK]e:clgm?JfH6EQ
[8X`FaCBGH^IikO9jf9?n3?fHia3AYA`_^njP?hU?J>8UOCVF;<nFES5_R^:4_1Z
9@SABQkmQDTdVEAaZ4U:U<YR8BUDf3L_^g7IHM3e4HLohS?:BZQ1D>M=VTQ4D7`W
X`_ON=`1dCVB[gFC@T_f?LmD^8Of<JiaRkNM[llP1kV/H=7<LLd3LonMDEmlHmN4
e5T?cmc4_6NQkagh=/]nbVEQk893BZW<;n@M0Z7<cnHAOeBF?oXMo0JZe>X><E9A
DGI>K5hl<BZ82glThBoOO?M1J2MIoGWXVe3X75W=IHDfT=Ell6;`0o9Pj6K6CNNL
8CB5o@8aXEkd5Mo=_HJ=YSdVEQB<@Z6^F]NPFbb^HUN9VoEm/9?_<nb<ffTLP84h
CCE<<d`f_VcP:_PGN6H3g`omI0loH>BCTWVC`AR7jk8QBQESTmCDjLK5dldiT8=6
PnUPe?eaj7_OLRiNRh>>FoBJLjIPDA7n8_]dD`A>W66iiRaCFDU92DhbPQoHOCZ3
0N;RU^V<AQ>nFRg3mgTCK]`eJdk;TH@aJL:IM`^Q>o<lPFE4ASKfo0CLHaF<;bGS
BAiQFNN;WW]Jbao[NLbCTY2EZ/W=d_2UjU3GJlA>^:c5XJfQ;il>;AXBY:NR1JM9
NRR9ZkgDami=/I:_L3^dAe9S@_YbcN8kMBc^^^`hcI>P0R[aBnidnB_bC?`b?1_V
@0=nIif7=@VNAdC>CPClc`e<VEdiJO;eJMG]Bk_K^cXG]/Pe;WM0jgLPgHjd4JT?
J@09SaX05g5h3nT;Y6naF@W9Q9B<E8QDSMB0e85d>m96Y;k`b8G?`6RJP6<<Wcj6
cak3GcN6;aW3UhkQ9hkQZIIGm]ljQVlK`gN>hNGoEUdQoleSbYN?hEN<hFlM`l_o
UKZR_M_6U2=nElVkV_;o1cm>mgd:IFiTLgAbIF5]2VE^I6mRJPXa>B0`86mRJPXf
<S@i2VE^I6mRJPXi830PKf9Z2S`l82mDNG1U82m6Kfid82mCMF9dNG1U82mDLWEU
E7U`IB0_@V5cIDI_KW@P;e9ICU54B2]8IFafIGAYHf4P;dI_KWA4IG=SLVU`M6mb
2S8`830PDR0_E6mEKVUSKfAU838a830PDR0_AVUbLgA3J65b83<c82m<HG=d@fQQ
LR0c=20_EfUTM6Qc85/P=C@i83Dd>B1M83hn2VE^I6mRJPXb<B0`86mRJPXl?20_
C6E^IgAX838b830PDR0_AVU/M6Eb82m6K65dIDAUHfmTIB0n?PYcM79UHFd:N05M
T<5^`b0<Q^llQHoMXB91Fdl8JFYE:HMfdk8m004W@UX<8^B@]ao@[Y=fn0nfolol
V1nkDdL^0Gn?g_BHH7AT8binS@IQ`<TAJ`EHIm:mZSdcjl1hQ_]]BCQg=7Z@TP7`
Sh`/:Fj`NkEn`:OBNh/FXj<9MUo7_WKj=HA_W94B=4`Y/3SVMALM[WY6h1GMMcK?
GM[fVOYcO6h18BO:A7^;I;c59FR3DM>4C3J=T^NcHTSfgdSLP66l>dF[I9Dh_2PV
QLQUeN6ih[o6/ZWln97@[37VL?D/=GO9h`POU`/nU?N[OP1c_7<^2VE^I7=dLVEQ
K@YUKVA_HVX:<S8P<21_HVX:<S<d2VE^I6mRJPXb<20`86mRJPXl?20_E7U`IB0_
AVm^M4AULf=bJG1dKg8P;dI_KWA>HFeU82mBFDiAA4P[B6E/MVEdJF=Q82m6K65W
Lb0d82m6Kfid@T9_N21K;CTe<B0]=3Pa834d=3DP<C4b<Ud:;dUdHFaYHd5^IfaU
830P;d5cHfE^M20g=c0P;dAULf=UKW@P;C8c<20_@f5`B6EYIfQd83La=b0_DgAU
KEHP>CPP;eQ8IFUWJ7@:=C8c82mCM6E]B20h=B0_@GIWEfUTM6PP=3@a82m=HGQG
JFAdJ20a=C0`82m6KfidAVU/IC8P<S<P<21B83hn2VE^I6mRJPXb<b0`86mRJPXl
?20_C6E^IgAX838d830PDR0_C6E^IgAX<B0e=38`82m6JFadIG8P;dI/HGAUA6ES
KfAU83hn2W=dLVEQK@Yh0KeHNg1DeAWo___H_I^4VRa1=PW;_N^bi0d4QA:BT/^b
6a82<A2P^aQT=lW691;9H4P51iZQA6A1ZR9D`@7CQaDXLTTbm0JDATI6WEI57K5J
YdY5kGC<f1LM5LS]MnhV:j5:l`OS?G_^mccWo<k_W;f_][G[8S06>X27ZQGQePH`
SmC?B:Qe;N7FV6g_9cVQ[[e=RMUR5P2o^Z7e[YJH;Cd6T>2lJoGjXOKf2`3hG6<T
G1n;`fFB<a_94K?a=Y:C6U_JkX_ImUjBBJ_Ge0g5kNnC;KF4ka/J7iR]g1=^RLCb
DelV>JUecKe]@oIC9;=JedJ6lS50n5h792l?Sh8=kPH[L91<IBF0mJl9CQ0Xb^9d
E4JOfkoZY^:;T2:ImZY5?cGU>fNNfOa5i79VhR?BUnB`3NLcJLTNc2K8B?61a4OR
4K<MWGPMZW=e::MJ@WD6eMcL^@kX`:OQHJY?DNFQ2KO3NZ[KZ3i1EHQ[1lWZ`ngM
PZBN`?F@SP_DA45NVYXV>a8BiCMe]?C^UmmeO7@BdfSecV=JmaR`cDg0Yo00e8><
_`8?KX0bb<:m?MV[iA253T8[e@jZ_7U6?=PmLKYl2_?08b2eV@`C1C`^OeZ@;gmL
X7?H;Io>e0DB;d`TBke9kWO^UgoW_4/nAOE`;7@XVc:>b`NMZnEM4gGLfbdoj]BA
fS`B4n^Le?Bhg9:mAjh_<><;mnSLhFjiT>;;eDAiiRbG?<=i@IjJZD]8M[icXIaC
l:XlRAYBVT:MN]@DNH9cUcbK@Q>Mo/cIE4oR8M`7>KR_fk=0?T4ZCKNW?7_F7Qg_
kbW;:_3X^46MFIJe9k//di>mD?ITUfIVT[klIN/FjagF^MKYeUa[UWFbeFG=/:I:
MRUInYjD92E8TVCElCOM9K;U91j64Z;UL8mTTD@MWbFWL1:?V<hS_iD4RI=0B]F=
3fWc8ZCZN;PgVFVT7;NHVTG78cdaea5E5YPVV85TS^UdXS=`:76`03AlB;M0ilg]
9HhBnibD`U;O]ie2IVChW?_]Q`>MfYj:jX1fb1WDYS?5L0J7dag3b[O:]WDDRWQc
Lb^F[>mYKfe^l4OLoY3K7j4Jd[Jg=cZdSUY5>MKLbP::aTl>eMHe<QV>J:g^R4m[
M_^DHneV^f_23BcLk_HMP`Kod/2a1SGRjfiGfog^/2oHDn]M^g;4F=_RHjgeO/=H
G]KIFSIF[MW^V[5F/W0]6f/U6f/U6j]F[CG7HY?g=eEkkffSgJWhVbXD;J]J:enl
8Z0YhJ1?ajO9jE/7HSlTRlm3U]P1jL9DT06<MjVnanCP<^<ClBE87V`ao/4GdJ;f
/LX=UQA3?c`4nn0XF>0Id[?PCWPLG/5VnVoG@2nL`hT`QJjm0^R`4?j0Q_46=<0_
:Kl=C/=^>0I9e:H5aU5d9gZ<3FB[Y=O25^?W<0UV`@?`?1AB[c]Q`3QXm51d2Bb3
@g2Hf_lNgM`aHJca[74195Q<OFjQb1_6@^<Xf24?_515gRe`2SglNdHS>:28d3d9
1j0;GX3?L3?f6Xe6^g7F>4mKe@4CX9[:A^c5loaAh@7SBN=_aR0aT@Di=6X8M/4_
Z?nSE?[Yd^[7^k4=Mn5^C^DfLke2YcQnl0[aT0gcZIC16WR@6>R35n6Ol2EncSWh
I;j=?f?<<?h5RE11/f@cRD0kUJeDM]:LCZ85Yn4l[<:=n1S^a[Nh76hI5n1na=g7
OL9GlSGlN_h]hEjQFm`Q?Vi97;aXW3AN<]j6lN24>f0]K:;IWHJcl6oh2WWZJ`9j
/0RmN2NE3]c7mF4GmW5Ef8mW^D?h0Gj4Wn<UC^BB^75L;]O6kN8>LjNieoPVOSOo
1?l1Oe6H8g9RUoRaaF?mdf3]h;K1eh`Rhkca1EeR9G3AbWRQ4UI1V6KK2[O1SfTF
AjPLYEEk4Lk0:fKi22O007a1;03J<AfWhb8ZUGPk=V0Ck/LCE4jIF?k3dD9`=Rj5
6lm=h:ZiFZj5jn3NiS[h33j7Gl2_h8mBNIToaeoR;`VR<5HH9l`GbV67d2;/YO:d
l8c@;K`^5XYca4Ya^MPQKQ=gl7GR6n8ibbK;CT^giG?;gnVb^=2ja[Z3E^LEf[<_
d5knnQ1`4Z6O3_M07OZ`5_K@JWAQ6::d^n[a@N:[5K:<UO`VOShgSGK3:KROM^]N
f0SKn1[X<_k87h9gJ:N/YRhkh=N25icRcfQe=/<dfTE3ALg>bLk:W>bIi;k5YM0U
Od96NYYSo<gSD/OJDi;792DVf2B[AAAh3R7?kbh=:M[TT2I<MYNEiC?K7BI7n2Y7
R?k:RUHj<TMCF;/`QDITZYCIL4fV6/]DhiVH[1A3LGjNhWL[fZ/n]j;SR/D1dQob
^H>:=V3ZRdcmHE<O@k[;A@dD_j?AYfPHD_aJJG]Se1obiNMQWdYd9>CW/@^72XV/
H`gVQCOB1AKV/@boU^kfnKDd=nTDhcgnL;eF]CSPmfFhG47bTF]9P<K8cf_B22M/
CjYgefoGEJP=<BeL4m3hL53S@Zb_U5a]_=^WSMo`/N=[LeSckkPZZ76NdW0TFZZY
XNe4;S=3c0[_8:^RFZ5^^LiP@<?>8A0<Hc<QIG1Sm`A?Z5WAK6j_^c7J729bHDVP
>ee==bnn6U@5^]?D==?8cn]cK2YbdNckl^OVcfFbb>GH59>OoRCVOk>OBLNV5clT
FK4TCP0b1]cUQ5=Cj/a1g0Af5S]5IT6dKQKaA4L@JIY=Q6NNa]6NhCfJj2T?JagE
`c0JOC5`XFIO]bd]gK`9NH>D7hXVcjJEX_aT]a:mB7O[T7_P/i6Nl937hTVn22c8
5SZnEc@<3n_]k6KYXETg>]b=K7gKcCDUfng`GnDPVe73<6^YM0>_2[Pd9DP>NY[<
Zm31EQDhQ[PcZ:?AZH??fDO?Z?bZ>bVLakIJTho69b<oSa`i;]:Vi2VU=78Yfb]:
E8VFedNEDZFA=Y?P<BD58]7PE6:`>T0l`E8JD@eVa=E8<3RKnYW:nZ4VU1h=DPo=
@cf@=5eC[e3B]3bjVO:CZ`:;0eZ7;d=COD5J1MZnoED1[ImfKS18F@EaY8AhHi=S
2?=d`Ub@@o5KHkg@/d/7MA6<AUVOe@6gBn^?AS>Rk?lF/gF4JagZT4<7U/8Xek6S
R]ZBL;/bc3E`^Ed4:lPh_Hffm?2>XVOfjc<l<hjKFWjOd<hd6IiePaP^70g3/dO5
L54Lj@R6R`Uc4F?h1mlM`g=6<5abOHKE>6h2>IO@ZRK3gQ_4l;cA<>`K5L?n>=8A
39LBISmSN?igag3I28K;[lo`PSQ^0UU1J1NH32nl@@`_6Pg3UJ=Rn?HhdQ4<Ea7V
faW3RklkQYN<H;SjnP`_SN<VT</8kE:ChNDgR>4OSXKQ`:PH3/JASV1h1F4><XK_
R3>/IVQ`mGFhhi[;;]c`2g?=EICCTi9X1jm@3b^XeY0io1dWRMh^_TNfRcdT/aM[
>VKB6m:ObO8226OYoHfWkd3cH]mVY:Tj25BUI1gP;5EVTljoCcY9:dVNY>em>46]
09KWWZ2NA9;C2Vi=LJETD_D:>oG;Oa6OofZN;RbjA>ojU;62aVXA/VR/16QARd/]
bbfLCI8D^mEZBA04aBj:UPBKQDO9:PY24XP9@ZO=J^VDN4h1C83d94a;C:Ya5Mm:
[nRE5i8oPI;RAEN:dlhi[Q@FdPmCk><;jBM/WI:k<OW<eRT>9PZVhLY/W>5:6FO3
LCQ3J;Td88bmO9ZOLfVPRmoJJl3PUEh<7bAla9V`Q_1I25nkFU8^1TG>UP1F:HTh
Dn`FRlSa_68G194mI0_09B7BQ`U>43]iJh8RfA8`?@Wn7lCoAHPYQHGdHd37<XPf
KYa[AXd`m]80?nObJBJ5[<431`L?m=;;6Ec9knYR:lRa4keUAnQMl9/>WYb?dK/b
f`OfXEFgd7LnF1:/G>`[bbf;[6j?]3GEQLf<hAiBBE6XCS>63QJ8jgR;nMgb:]/L
nkn>fkRl2VE^I7=dLVEQK@YUKVA_HVX:<S@P<21_HVX:<STf>0YUKVA_HVX:<SDP
<21_HVX::6eQHdmC85IULW=YKfhP<C0^<C@^=R1L:49eJFaT834hAcTc<S=L:B1A
MF5bM7XPD4A6@fm^M6EhM2T:IFiTKf9Z2S8f830PKf9Z2RQ4>S8`<S8`<C0i<S<`
<S<aFS0`9c0`9bT:IFiTKf9Z2S4P<21_HVX:?3`P;e1bKfAeHfEb838e830PDR0_
@g9UHGAYKfi4HGAU838f830PDR0_CFmTA65dIB0b=R0`858P?Sh:IFiTKf9Z2WQb
IFH:<20b=`X`<30`<30`<30`83He=C<e86HP2S0`<30`<S@i<c4P<30`<30PKR0:
<30`<30`<3Ti<B0`<30`<21^80X`<30`<30c>CPg830`<30`86hP2S0`<30`<30`
<S8P<30`<30PKR0:<30`<30`<3Tg<R0`<30`<21^80X`<30`<30a<3Te830`<30`
86hP2S0`<30`<3<i=C4P<30`<30PKR0:<30`<30a<cTh=R0`<30`<21^80X`<30`
<38`>CPg830`<30`86hP2S0`<30`<3@a<S0P<30`<30PKR0:<30`<30`<C8a=B0`
<30`<21^80X`<30`<30c>C<`830`<30`86hP2S0`<30`<3@`=c0P<30`<30PKR0:
<30`<30`=3D`=b0`<30`<21^80X`<30`<30d=cHa830`<30`86hP2S0`<30`<C<i
=SDP<30`<30PKR0:<30`<30a=3<g=b0`<30`<21^80X`<30`<34d=S8g830`<30`
86hP2S0`<30`<S0i=SHP<30`<30PKR0:<30`<30b<C@h=B0`<30`<21^80X`<30`
<38a<CDe830`<30`86hP2S0`<30`<S4d=SDP<30`<30PKR0:<30`<30b<CLc=20`
<30`<21^80X`<30`<38d=cTb830`<30`86hP2S0`<30`<S@h<C<P<30`<30PKR0:
<30`<30b=3Ph>B0`<30`<21^80YdLV5YK6Eb2S`l82mCJGYU838g82mBKfmd834c
830PDR0_BFiVKb0a830PDR0_BD@PFb0lI3IT<VAR<C5SHcLa=fIU<3@b<FASIV9T
<3Di>35UHcTn2SaT=V@bI68a<F=S=c4gIVD`=38aI6=VHV@`=CTh<FES>ChPGB0n
?PYcM65bM7QbIFH:<SD`<3H:9BE5CdH:\>"], "Graphics",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  ImageSize->{476, 256},
  ImageMargins->{{96.71484375, 0.}, {0., -0.4921875}},ExpressionUUID->
  "d0dad4a6-ea54-495a-8470-3f92e91a5119"]
}], "Text",
 CellChangeTimes->{{3.815654632263982*^9, 3.815654724079246*^9}, {
  3.816461411911804*^9, 3.816461459767501*^9}, {3.816461608632382*^9, 
  3.816461624128017*^9}, {3.816516190315185*^9, 3.8165162080751553`*^9}, {
  3.81737908735784*^9, 3.8173790965047207`*^9}, {3.817379497634728*^9, 
  3.817379502230784*^9}, {3.8504742580599337`*^9, 3.850474264211351*^9}, {
  3.8507581336536627`*^9, 
  3.8507581685555573`*^9}},ExpressionUUID->"6c77ebfc-22f8-4071-8dd1-\
2f722f3c0b60"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ay", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cy", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cx", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"ax", ",", "bx", ",", "by", ",", "dx", ",", "dy"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pa", "=", 
   RowBox[{"{", 
    RowBox[{"ax", ",", "ay"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pb", "=", 
   RowBox[{"{", 
    RowBox[{"bx", ",", "by"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pc", "=", 
   RowBox[{"{", 
    RowBox[{"cx", ",", "cy"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pd", "=", 
   RowBox[{"{", 
    RowBox[{"dx", ",", "dy"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pe", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.817381306488296*^9, 3.817381315623238*^9}, {
  3.850401594061968*^9, 3.8504016280214033`*^9}, {3.850401714182131*^9, 
  3.8504017225419617`*^9}, {3.85047428925249*^9, 3.850474298155818*^9}, {
  3.850474608765664*^9, 3.850474612636983*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"cb996674-2f35-4f5f-8356-c7337b1bb14b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"WLOG", " ", "we", " ", "can", " ", "assume", " ", "ax"}], "<", 
     "0"}], ",", " ", 
    RowBox[{"ay", "=", "0"}], ",", " ", 
    RowBox[{"cx", "=", "1"}], ",", " ", 
    RowBox[{"cy", "=", "0"}], ",", " ", 
    RowBox[{"bx", "\[LessEqual]", 
     RowBox[{"0", " ", "by"}], "<", "0"}], ",", " ", 
    RowBox[{"dx", "\[GreaterEqual]", "0"}], ",", " ", 
    RowBox[{"dy", ">", "0"}]}], " ", "*)"}], 
  RowBox[{"$Assumptions", "=", 
   RowBox[{
    RowBox[{"ax", "<", "0"}], "&&", 
    RowBox[{"bx", "\[LessEqual]", "0"}], "&&", 
    RowBox[{"by", "<", "0"}], "&&", 
    RowBox[{"dx", "\[GreaterEqual]", "0", " "}]}]}]}]], "Input",
 CellChangeTimes->{
  3.8503124697402277`*^9, {3.8504743043161716`*^9, 3.850474315675459*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"04c746c4-062d-4729-88b9-a3e96c597d64"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ax", "<", "0"}], "&&", 
  RowBox[{"bx", "\[LessEqual]", "0"}], "&&", 
  RowBox[{"by", "<", "0"}], "&&", 
  RowBox[{"dx", "\[GreaterEqual]", "0"}]}]], "Output",
 CellChangeTimes->{
  3.850312337071247*^9, 3.850312417779364*^9, {3.850312513652459*^9, 
   3.8503125406481447`*^9}, 3.85031623965526*^9, 3.850400241880913*^9, 
   3.8504015538836603`*^9, 3.850401731160514*^9, 3.850402193585154*^9, 
   3.850403606078186*^9, 3.850410620577271*^9, 3.850474368117415*^9, 
   3.850580654553296*^9, 3.850649765255762*^9, 3.85075719532195*^9, 
   3.850759467237185*^9, 3.851256711953865*^9, 3.8512567638555193`*^9, 
   3.8512579463917303`*^9, 3.851260120842767*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"07bf9854-9cb8-47f6-9b9e-6786ad618d06"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Find", " ", "the", " ", "relationships", " ", "that", " ", "make", " ", 
    "E", " ", "the", " ", "origin"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"bedEquation", "=", 
   RowBox[{
    RowBox[{"dy", "/", "dx"}], "==", 
    RowBox[{"by", "/", "bx"}]}]}]}]], "Input",
 CellChangeTimes->{{3.815654846966208*^9, 3.8156549764241257`*^9}, {
   3.81565501364832*^9, 3.8156551744006853`*^9}, {3.8164616524332848`*^9, 
   3.816461748992742*^9}, {3.8164617892734747`*^9, 3.8164617934645576`*^9}, 
   3.817201891123839*^9},
 CellLabel->"In[11]:=",ExpressionUUID->"b2570c19-013b-4a4c-a6e3-3b7cce44cbe5"],

Cell[BoxData[
 RowBox[{
  FractionBox["dy", "dx"], "\[Equal]", 
  FractionBox["by", "bx"]}]], "Output",
 CellChangeTimes->{
  3.815655042219037*^9, {3.81565511356851*^9, 3.815655151957675*^9}, {
   3.815664250889575*^9, 3.815664268869597*^9}, 3.815664855543708*^9, {
   3.816461714241712*^9, 3.81646171878368*^9}, 3.816461750137148*^9, 
   3.816466350323002*^9, 3.816514835339962*^9, 3.81651558971667*^9, 
   3.816515922508329*^9, 3.816518690390963*^9, 3.816518762701787*^9, 
   3.816531949477352*^9, 3.816534797898213*^9, 3.816534949189004*^9, 
   3.816536755068502*^9, 3.816549555569641*^9, 3.816554534489481*^9, 
   3.817201866463285*^9, 3.817219785348542*^9, 3.8173846631492434`*^9, 
   3.817384733797765*^9, 3.81738478683832*^9, 3.817387747172526*^9, 
   3.817390044116159*^9, 3.817390244490293*^9, 3.81739039098899*^9, 
   3.817390581229566*^9, 3.817391610831465*^9, 3.817392102173284*^9, 
   3.817478212735671*^9, 3.850308287046575*^9, 3.850310396860958*^9, 
   3.850310485167324*^9, 3.850311296450955*^9, 3.850312153453148*^9, 
   3.850312337080207*^9, 3.850312417823805*^9, {3.850312513660605*^9, 
   3.850312540693947*^9}, 3.850316239701021*^9, 3.850400241927011*^9, 
   3.850401556332693*^9, 3.850401734569437*^9, 3.850402193623753*^9, 
   3.8504036093748627`*^9, 3.8504106206145144`*^9, 3.850474381368602*^9, 
   3.8505805847619123`*^9, 3.850649765287127*^9, 3.850757195363721*^9, 
   3.8507594672468653`*^9, 3.851256711981642*^9, 3.851256763861373*^9, 
   3.851257946426073*^9, 3.8512601208699093`*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"aa8c3676-e9b3-4fc3-8f9f-3aa0658f5a97"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Create", " ", "a", " ", "function", " ", "to", " ", "find", " ", "the", 
    " ", "distance", " ", "between", " ", "two", " ", "points"}], " ", "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"dist", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2_", ",", "y2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x2", "-", "x1"}], ")"}], "^", "2"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"y2", "-", "y1"}], ")"}], "^", "2"}]}], "]"}], "]"}], "//", 
    "PowerExpand"}]}]}]], "Input",
 CellChangeTimes->{{3.850319805216095*^9, 3.850319832359462*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"0e986210-256b-4c47-8679-cb9e187dde16"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "set", " ", "dy", " ", "so", " ", "that", " ", "E", " ", "is", " ", 
    "always", " ", "at", " ", "the", " ", 
    RowBox[{"origin", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"dy", "=", 
    RowBox[{"dx", "*", 
     RowBox[{"by", "/", "bx"}]}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.816462144146599*^9, 3.8164621670096407`*^9}, {
  3.816515650819026*^9, 3.816515676386238*^9}, {3.817379545459263*^9, 
  3.8173795828501787`*^9}, {3.8504743868931417`*^9, 3.850474413787758*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"e0eab32a-a04b-4bb8-8fe6-976248c8c0b2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Find", " ", "the", " ", "condition", " ", "for", " ", "the", " ", 
    "reference", " ", "quadrilateral", " ", "to", " ", "be", " ", 
    "equidiagonal"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"lenAC", "=", 
     RowBox[{"dist", "[", 
      RowBox[{"Pa", ",", "Pc"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lenBD", "=", 
     RowBox[{"dist", "[", 
      RowBox[{"Pb", ",", "Pd"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"equidiagonal", "=", 
    RowBox[{
     RowBox[{"lenAC", "^", "2"}], "\[Equal]", 
     RowBox[{"lenBD", "^", "2"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.817202185492014*^9, 3.8172022227637043`*^9}, {
   3.8172022721005087`*^9, 3.81720235554778*^9}, 3.81738026950108*^9, {
   3.8503086230169373`*^9, 3.850308624293433*^9}, {3.8503089358059473`*^9, 
   3.850308939438429*^9}, {3.850309108839055*^9, 3.8503091121190367`*^9}, {
   3.850309184095037*^9, 3.850309188103294*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"a4b1562b-2ad2-4d92-923f-b9bfb3213cda"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "ax"}], ")"}], "2"], "\[Equal]", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["bx", "2"], "+", 
      SuperscriptBox["by", "2"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"bx", "-", "dx"}], ")"}], "2"]}], 
   SuperscriptBox["bx", "2"]]}]], "Output",
 CellChangeTimes->{
  3.817202232194413*^9, {3.817202310315505*^9, 3.817202357670076*^9}, 
   3.8172197860384283`*^9, 3.81738027135126*^9, 3.817384663619063*^9, 
   3.817384733969985*^9, 3.817384787041974*^9, 3.81738774775578*^9, 
   3.817390044661435*^9, 3.817390244988245*^9, 3.817390391475441*^9, 
   3.817390581684738*^9, 3.817391611316469*^9, 3.817392102559157*^9, 
   3.817478213311894*^9, 3.850308630600835*^9, 3.8503089130243587`*^9, 
   3.8503089481861563`*^9, 3.850309113019285*^9, 3.850309188873468*^9, 
   3.850310397312224*^9, 3.850310485622499*^9, 3.850311453206266*^9, 
   3.850311587779955*^9, 3.8503121539242373`*^9, 3.850312337556898*^9, 
   3.850312418457615*^9, {3.850312513885634*^9, 3.850312541341921*^9}, 
   3.8503162403639507`*^9, 3.850400242448267*^9, 3.8504013530203657`*^9, 
   3.8504018657452307`*^9, 3.8504021940381193`*^9, 3.850403779438355*^9, 
   3.850410621026517*^9, 3.850580624315823*^9, 3.8506497653683157`*^9, 
   3.850757195435972*^9, 3.850759071694213*^9, 3.8507591229489517`*^9, 
   3.850759467342063*^9, 3.8512567120304813`*^9, 3.851256763914728*^9, 
   3.851257946475112*^9, 3.8512601209321833`*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"6ef67695-7531-4f82-abe8-f75851c2032a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lenAC", "^", "2"}]], "Input",
 CellChangeTimes->{{3.850758845775626*^9, 3.850758847390167*^9}, {
  3.8507589041763563`*^9, 3.850758904702341*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"c9f651b8-ed4b-4f0f-aa8a-2b9a7dabd3f0"],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "-", "ax"}], ")"}], "2"]], "Output",
 CellChangeTimes->{3.850758849039166*^9, 3.850758905565145*^9, 
  3.8507590812751007`*^9, 3.850759126105857*^9, 3.850759467349863*^9, 
  3.851256712036564*^9, 3.851256763920495*^9, 3.851257946481924*^9, 
  3.851260120938158*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"5b443b9f-70c6-447e-94d7-20663428c4c1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lenBD", "^", "2"}]], "Input",
 CellChangeTimes->{{3.850758985567913*^9, 3.850758988342897*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"42b6dbb4-7e7c-4520-a644-78e8837a630c"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["bx", "2"], "+", 
     SuperscriptBox["by", "2"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"bx", "-", "dx"}], ")"}], "2"]}], 
  SuperscriptBox["bx", "2"]]], "Output",
 CellChangeTimes->{3.850758990202281*^9, 3.850759140805208*^9, 
  3.85075946741059*^9, 3.85125671206361*^9, 3.851256763947404*^9, 
  3.851257946515765*^9, 3.851260120964447*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"0283412b-a00b-4e24-99d2-e504a967ee32"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Get", " ", "the", " ", "general", " ", "symbolic", " ", "condition", " ", 
    "that", " ", "makes", " ", "the", " ", "reference", " ", "quadrilateral", 
    " ", "equidiagonal"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"equidiagonalCondition", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"equidiagonal", ",", "ax"}], "]"}], "//", 
    "Simplify"}]}]}]], "Input",
 CellChangeTimes->{{3.8504042072138853`*^9, 3.850404239781537*^9}, 
   3.850474788902082*^9, 3.8504748331896753`*^9, {3.8504749048148947`*^9, 
   3.850474948799077*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"2197fd1d-639b-4f6f-b9ae-1619502811e5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ax", "\[Rule]", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox["bx", "2"], "+", 
          SuperscriptBox["by", "2"]}]], " ", 
        RowBox[{"(", 
         RowBox[{"bx", "-", "dx"}], ")"}]}], "bx"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ax", "\[Rule]", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox["bx", "2"], "+", 
          SuperscriptBox["by", "2"]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "bx"}], "+", "dx"}], ")"}]}], "bx"]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8504042457994127`*^9, 3.8504106211742973`*^9, 3.8504747900091677`*^9, 
   3.8504748342951612`*^9, {3.850474936051304*^9, 3.850474949963765*^9}, {
   3.850475493918931*^9, 3.8504755087479897`*^9}, 3.850580663367983*^9, 
   3.85064976540622*^9, 3.850757195478341*^9, 3.8507594674803123`*^9, 
   3.85125671210567*^9, 3.851256763986318*^9, 3.851257946556679*^9, 
   3.8512601210035963`*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"6f92b4ce-c2f8-4b62-b450-4d05c2e95b25"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"ax", " ", "must", " ", "be", " ", "negative"}], " ", ",", " ", 
    RowBox[{"so", " ", "choose", " ", "the", " ", "second", " ", 
     RowBox[{"solution", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "set", " ", "ax", " ", "so", " ", "that", " ", "the", " ", "quadrilateral",
     " ", "is", " ", "always", " ", 
    RowBox[{"equidiagonal", "."}]}], " ", "*)"}], " ", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"ax", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"equidiagonalCondition", "//", "Last"}], "//", "Last"}], "//", 
    "Last"}]}]}]], "Input",
 CellChangeTimes->{{3.850474909638358*^9, 3.850474917069783*^9}, {
  3.85047495954179*^9, 3.85047507684768*^9}, {3.8504751711760683`*^9, 
  3.85047517879058*^9}, {3.850475471680273*^9, 3.850475472951586*^9}, {
  3.850475519489274*^9, 3.850475541160232*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"c2f44073-245f-4ea7-a415-36fd72d309fb"],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox["bx", "2"], "+", 
      SuperscriptBox["by", "2"]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "bx"}], "+", "dx"}], ")"}]}], "bx"]}]], "Output",
 CellChangeTimes->{
  3.8504751332047873`*^9, 3.8504751799214907`*^9, 3.85047547576714*^9, {
   3.850475520469901*^9, 3.850475543538319*^9}, 3.850580703791958*^9, 
   3.850649765418425*^9, 3.8507571954864817`*^9, 3.8507594674883537`*^9, 
   3.851256712111485*^9, 3.851256763992293*^9, 3.851257946563737*^9, 
   3.8512601210099297`*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"7df4fffc-ca76-4790-acc3-0ab4369a7eea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Pa", ",", "Pb", ",", "Pc", ",", "Pd", ",", "Pe"}], "}"}]], "Input",\

 CellChangeTimes->{{3.8504758020894947`*^9, 3.8504758083531*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"9559d8b9-0dcc-4661-952c-cbc669cc9f7c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox["bx", "2"], "+", 
          SuperscriptBox["by", "2"]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "bx"}], "+", "dx"}], ")"}]}], "bx"]}], ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"bx", ",", "by"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"dx", ",", 
     FractionBox[
      RowBox[{"by", " ", "dx"}], "bx"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.850475809469644*^9, 3.850580724458001*^9, 
  3.850649765451415*^9, 3.850757195527254*^9, 3.850759467549046*^9, 
  3.851256712139854*^9, 3.851256764020946*^9, 3.85125794659799*^9, 
  3.851260121037672*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"19b0757a-dd13-42b3-8b46-a1242f48517d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Draw", " ", "an", " ", "illustrative", " ", "figure", " ", "using", " ", 
     "numerical", " ", "values", " ", "for", " ", "the", " ", "coordinates", 
     " ", "of", " ", "A"}], ",", " ", "B", ",", " ", "C", ",", " ", 
    RowBox[{"and", " ", "D"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "step", " ", "is", " ", "not", " ", "needed", " ", "for", " ",
     "the", " ", "proof"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Get", " ", "the", " ", "numerical", " ", "coordinates", " ", "for", " ", 
    "the", " ", "example", " ", "reference", " ", "triangle", " ", "when", 
    " ", "it", " ", "is", " ", "equidiagonal"}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"figCoords", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"bx", "\[Rule]", 
        RowBox[{"-", "1"}]}], ",", 
       RowBox[{"by", "->", 
        RowBox[{"-", "2"}]}], ",", 
       RowBox[{"dx", "\[Rule]", "1"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"quadrilateral", "=", 
     RowBox[{"{", 
      RowBox[{"Thick", ",", 
       RowBox[{"AbsolutePointSize", "[", "6", "]"}], ",", 
       "\[IndentingNewLine]", "Black", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Pa", ",", "Pb"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pb", ",", "Pc"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pc", ",", "Pd"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pd", ",", "Pa"}], "}"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", "Red", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Pa", ",", "Pc"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pb", ",", "Pd"}], "}"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", "Black", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"Pa", ",", "Pb", ",", "Pc", ",", "Pd"}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", "Red", ",", 
       RowBox[{"Point", "[", "Pe", "]"}], ",", "\[IndentingNewLine]", "Black",
        ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<A\>\"", ",", "Pa", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<B\>\"", ",", "Pb", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<C\>\"", ",", "Pc", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<D\>\"", ",", "Pd", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<E\>\"", ",", "Pe", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"quad", "=", 
    RowBox[{
     RowBox[{"Graphics", "[", "quadrilateral", "]"}], "/.", 
     "figCoords"}]}]}]}]], "Input",
 CellChangeTimes->{{3.815655196881085*^9, 3.815655665795712*^9}, {
   3.8156556968515377`*^9, 3.8156557838031483`*^9}, {3.815655932701605*^9, 
   3.81565593438804*^9}, {3.815656005926347*^9, 3.815656046238167*^9}, {
   3.81565607933572*^9, 3.815656161061664*^9}, {3.8156610836465673`*^9, 
   3.8156611441494503`*^9}, {3.815661184126947*^9, 3.815661356574294*^9}, 
   3.815662134195237*^9, {3.815662260514454*^9, 3.815662261833972*^9}, {
   3.815664778415156*^9, 3.815664791225912*^9}, {3.8164618179778214`*^9, 
   3.816461822233035*^9}, {3.816461857305646*^9, 3.816462023977612*^9}, {
   3.816462173467621*^9, 3.816462177898312*^9}, {3.816462241491837*^9, 
   3.816462261219623*^9}, {3.816462345388227*^9, 3.8164624189880238`*^9}, {
   3.816462451684333*^9, 3.816462491794331*^9}, {3.8165158499477177`*^9, 
   3.816515856962716*^9}, {3.817379606635366*^9, 3.8173796318906727`*^9}, {
   3.8173796694442043`*^9, 3.8173797649400797`*^9}, 3.817380042437455*^9, 
   3.817380081429166*^9, {3.8173801294133873`*^9, 3.8173801780053387`*^9}, {
   3.81738073302332*^9, 3.8173807427835608`*^9}, {3.817380773351468*^9, 
   3.8173807985674963`*^9}, {3.817381325449265*^9, 3.817381329167783*^9}, {
   3.850474442413533*^9, 3.85047446383805*^9}, 3.850474597936153*^9, 
   3.8504753619710703`*^9, {3.8504756946186657`*^9, 3.850475713512816*^9}, {
   3.8504757477138233`*^9, 3.8504757691705523`*^9}, {3.8504758640111017`*^9, 
   3.85047589568948*^9}, {3.8504759424511642`*^9, 3.850475970107188*^9}, {
   3.850476290196115*^9, 3.850476299452039*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"0ec44dc8-aa5a-464b-8044-17659b67bb95"],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0], AbsolutePointSize[6], Thickness[Large], 
   LineBox[NCache[{{{1 - 2 5^Rational[1, 2], 0}, {-1, -2}}, {{-1, -2}, {1, 
      0}}, {{1, 0}, {1, 
      2}}, {{1, 2}, {
       1 - 2 5^Rational[1, 2], 0}}}, {{{-3.4721359549995796`, 
        0}, {-1, -2}}, {{-1, -2}, {1, 0}}, {{1, 0}, {1, 
      2}}, {{1, 2}, {-3.4721359549995796`, 0}}}]], 
   {RGBColor[1, 0, 0], 
    LineBox[NCache[{{{1 - 2 5^Rational[1, 2], 0}, {1, 0}}, {{-1, -2}, {1, 
       2}}}, {{{-3.4721359549995796`, 0}, {1, 0}}, {{-1, -2}, {1, 2}}}]]}, 
   {GrayLevel[0], 
    PointBox[NCache[{{1 - 2 5^Rational[1, 2], 0}, {-1, -2}, {1, 0}, {1, 
       2}}, {{-3.4721359549995796`, 0}, {-1, -2}, {1, 0}, {1, 2}}]]}, 
   {RGBColor[1, 0, 0], PointBox[{0, 0}]}, 
   {GrayLevel[0], 
    InsetBox["\<\"A\"\>", 
     NCache[{1 - 2 5^Rational[1, 2], 0}, {-3.4721359549995796`, 0}], {2, -1}],
     InsetBox["\<\"B\"\>", {-1, -2}, {2, 2}], 
    InsetBox["\<\"C\"\>", {1, 0}, {-2, 2}], 
    InsetBox["\<\"D\"\>", {1, 2}, {-3, -1}], 
    InsetBox["\<\"E\"\>", {0, 0}, {1, -1}]}}]], "Output",
 CellChangeTimes->{
  3.816462049939418*^9, 3.816462179107874*^9, {3.816462242755986*^9, 
   3.8164622621842737`*^9}, {3.8164623458879557`*^9, 3.816462419472068*^9}, {
   3.8164624531794243`*^9, 3.816462492790411*^9}, 3.816466350545558*^9, 
   3.8165148355612507`*^9, 3.816515589826886*^9, 3.816515691669691*^9, 
   3.81651582396458*^9, 3.816515858081271*^9, 3.816515922711725*^9, 
   3.816518690480853*^9, 3.816518762786619*^9, 3.816531949573564*^9, 
   3.8165347980398827`*^9, 3.816534949328771*^9, 3.8165367552998123`*^9, 
   3.816549555775288*^9, 3.81655453458237*^9, 3.817201866712212*^9, 
   3.817204845864737*^9, 3.817219785593481*^9, {3.817379662479807*^9, 
   3.817379765612761*^9}, 3.817380042922923*^9, 3.817380081884473*^9, {
   3.8173801323566227`*^9, 3.8173801789828787`*^9}, {3.8173807341330023`*^9, 
   3.817380743471135*^9}, {3.8173807748194*^9, 3.817380799041993*^9}, 
   3.817381330404955*^9, 3.8173846632242002`*^9, 3.817384733834264*^9, 
   3.817384786889031*^9, 3.8173877472494583`*^9, 3.817390044172037*^9, 
   3.8173902445743732`*^9, 3.817390391043858*^9, 3.817390581284728*^9, 
   3.817391610889443*^9, 3.817392102220469*^9, 3.817478212799431*^9, 
   3.850308297687948*^9, 3.8503103969100733`*^9, 3.85031048526088*^9, 
   3.8503113047503843`*^9, 3.850311541074573*^9, 3.850312153544965*^9, 
   3.850312337169289*^9, 3.850312417886739*^9, {3.8503125137210913`*^9, 
   3.850312540758005*^9}, 3.850316239759533*^9, 3.85040024198278*^9, 
   3.850401766091164*^9, 3.8504021936800747`*^9, 3.8504036231225348`*^9, 
   3.850410620670888*^9, {3.8504744530884447`*^9, 3.8504744642977047`*^9}, 
   3.850475366403253*^9, 3.850475561519389*^9, {3.850475748945277*^9, 
   3.85047576959524*^9}, {3.850475865628743*^9, 3.850475896368105*^9}, 
   3.850475942992655*^9, 3.850475976465205*^9, {3.8504762909025717`*^9, 
   3.85047632916786*^9}, 3.85058073080765*^9, 3.850649765464471*^9, 
   3.850757195541894*^9, 3.8507594676108503`*^9, 3.851256712170824*^9, 
   3.851256764051816*^9, 3.851257946605729*^9, 3.851260121068956*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"0af3851e-df73-469f-8cf8-fcf065932cb0"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Specify", " ", "a", " ", "center", " ", "function", " ", "by", " ", 
    "giving", " ", "its", " ", "first", " ", "trilinear", " ", "coordinate"}],
    " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"centerFunction", "=", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Multiply", " ", "the", " ", "1", "st", " ", "trilinear", " ", 
     "coordinate", " ", "by", " ", "\"\<a\>\"", " ", "to", " ", "get", " ", 
     "the", " ", "1", "st", " ", "barycentric", " ", "coordinate"}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bary1", "=", 
     RowBox[{"centerFunction", "*", "a"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bary2", "=", 
     RowBox[{"bary1", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "b"}], ",", 
        RowBox[{"b", "\[Rule]", "c"}], ",", 
        RowBox[{"c", "\[Rule]", "a"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bary3", "=", 
     RowBox[{"bary2", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "b"}], ",", 
        RowBox[{"b", "\[Rule]", "c"}], ",", 
        RowBox[{"c", "\[Rule]", "a"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"barySum", "=", 
     RowBox[{"bary1", "+", "bary2", "+", "bary3"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.850319716976005*^9, 3.850319773635038*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"9c52c674-4fbb-4699-b31c-908f94972694"]
}, Closed]],

Cell[CellGroupData[{

Cell["Support for trig functions", "Section",
 CellChangeTimes->{{3.850393856653619*^9, 
  3.850393866588462*^9}},ExpressionUUID->"8a0b3e8c-80ca-4eeb-9ff2-\
3eedce0a98fe"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"convertToABCrule", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "A", "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}], "-", 
          RowBox[{"a", "^", "2"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "b", "*", "c"}], ")"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Cos", "[", "B", "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", "^", "2"}], "+", 
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c", "*", "a"}], ")"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Cos", "[", "C", "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "+", 
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "a", "*", "b"}], ")"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Sec", "[", "A", "]"}], "\[Rule]", 
       RowBox[{"2", "*", "b", "*", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}], "-", 
           RowBox[{"a", "^", "2"}]}], ")"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Sec", "[", "B", "]"}], "\[Rule]", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"a", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", "^", "2"}], "+", 
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Sec", "[", "C", "]"}], "\[Rule]", 
       RowBox[{"2", "*", "a", "*", 
        RowBox[{"b", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Sin", "[", "A", "]"}], "\[Rule]", " ", 
       RowBox[{"a", "/", 
        RowBox[{"(", 
         RowBox[{"2", "R"}], ")"}]}]}], ",", 
      RowBox[{
       RowBox[{"Sin", "[", "B", "]"}], "\[Rule]", " ", 
       RowBox[{"b", "/", 
        RowBox[{"(", 
         RowBox[{"2", "R"}], ")"}]}]}], ",", 
      RowBox[{
       RowBox[{"Sin", "[", "C", "]"}], "\[Rule]", " ", 
       RowBox[{"c", "/", 
        RowBox[{"(", 
         RowBox[{"2", "R"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"R", "\[Rule]", 
       RowBox[{"a", " ", "b", " ", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{"4", "K"}], ")"}]}]}]}], ",", " ", 
      RowBox[{"r", "\[Rule]", 
       RowBox[{"K", "/", "s"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Tan", "[", "A", "]"}], "\[Rule]", 
       RowBox[{"a", " ", "b", " ", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{"R", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", "^", "2"}], "+", 
             RowBox[{"c", "^", "2"}], "-", 
             RowBox[{"a", "^", "2"}]}], ")"}]}], ")"}]}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Tan", "[", "B", "]"}], "\[Rule]", 
       RowBox[{"a", " ", "b", " ", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{"R", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"c", "^", "2"}], "+", 
             RowBox[{"a", "^", "2"}], "-", 
             RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Tan", "[", "C", "]"}], "\[Rule]", 
       RowBox[{"a", " ", "b", " ", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{"R", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "+", 
             RowBox[{"b", "^", "2"}], "-", 
             RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"K", "\[Rule]", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"s", 
         RowBox[{"(", 
          RowBox[{"s", "-", "a"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"s", "-", "b"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"s", "-", "c"}], ")"}]}], "]"}]}], ",", " ", 
      RowBox[{"s", "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "+", "c"}], ")"}], "/", "2"}]}]}], 
     "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"convertToABC", "[", "expr_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"expr1", ",", "expr2"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"expr1", "=", "expr"}], ";", "\[IndentingNewLine]", 
      RowBox[{"expr2", "=", 
       RowBox[{"TrigExpand", "[", "expr1", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"expr2", "=", 
       RowBox[{"expr2", "//.", "convertToABCrule"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"expr2", "=", 
       RowBox[{"Simplify", "[", "expr2", "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"Return", "[", "expr2", "]"}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8503329681305847`*^9, 3.8503329938647223`*^9}, {
   3.850370074226844*^9, 3.8503700831932487`*^9}, {3.850371565003121*^9, 
   3.8503716308544807`*^9}, {3.850372531578465*^9, 3.850372578585475*^9}, {
   3.850372612945743*^9, 3.850372712573848*^9}, 3.8507376582241087`*^9, {
   3.8512566814020023`*^9, 3.85125668199259*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"8079a364-db9f-41d3-a7e8-9b0c27f40b60"]
}, Closed]],

Cell[CellGroupData[{

Cell["Quarter Triangles", "Section",
 CellChangeTimes->{{3.850367662817922*^9, 
  3.850367681472711*^9}},ExpressionUUID->"a1f9849a-0d65-4848-b72a-\
369351090f95"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Locate", " ", "the", " ", "points", " ", "F"}], ",", " ", "G", 
    ",", " ", "H", ",", " ", 
    RowBox[{
    "I", " ", "inside", " ", "the", " ", "quarter", " ", "triangles"}]}], " ",
    "*)"}], "\[IndentingNewLine]", Cell[GraphicsData["PDF", "\<\
9E14ARda;S<:9LCUl^G[Yo>Pd<C62S@P<21_HVX:?3`P;daUKVMdJ20e830PDR0_
AVU/M6Eb82m6K65dIDAUHfmTIB0n?PYcM79UHFd:N06=ETf?fcP<_N]Gl=PNa[ET
Fi:?>k=]MoMFC?j1PJ8XVT<aQogknai9fDjLc@@175;l4?W<3onFKo9K1_UGX_`S
BGk:YiNg:2n_d^__m@GRZ>@Cof:MICU;BMdTDlKS;:WR;nJYVl8_NEEoAh==RAH9
bS0Il;a]4W37GP]LGj2Mn;Q]`[1fB[/H?Jb896oULQWJNmL`/X_/3kTXC?8o`=DA
2M@ISg>8TOoUOTXkYC?AQdF<4LoK:32l_AJhTMYah<FgKHSLG^//S3;XGFJQ=K6l
XA3hNe_^5dLT97THI4iMR_dl1OQOchI^R=>DL39f>IMIi]6dL8:2D;]f/^0/MN=D
jjXEHT8nZ[EiJRMnWm2^WLD^mWVX>dnmAkGMibMZej9ZIe_TVjO[o1Ki8LnXO>/I
h=?ZS;G`U;AUWTl0FCG`QkLZ@4I>IoUd>Q7DdgOil?US>?fDcbMhRUfJ]2TMl>K`
XPWIOmj4ANWJUGj6nc8J4G8?5BeGYAHYB6_^JaKU<e]gJUK6dM4RA^<mZ7:c2Q?k
g/ZO5?ciCF8BSF:eF^<khQ=/A?1IhNL/5o1<1Oj^`?WSXjcP]3:lAXGE?c0`7DNH
=<hDQD>6g_69VGgTSDmbTI@mEiNa0f9f@iAZl`U=H`KZcg/kmYWk9;W/kl=1l63L
L1OW4AhTb5[BlT4^1h0RI:F4bo9iOP0QWI99YhR>GhiIL4Qe<X`BARb;213Z`?Ga
AQZYXd<ejbITWS]CIVUSWKXVA2D[CZ_YY=RKGjFYfbieX@EXYT4Sm7Ga7UC30JXd
4:_LZPV5aeIkNA@[WKFjMP2E<K=EDDRmDC8`Dm/mBR:QO[:dGLA=1ib]>e>_[4=:
9P0=jkCET;>`kC>Bm>WGVLQRFNgF><=MR>9h;2HhaQ]X0?T/nY<01I]5k`fRbTJg
YBI:cgfGna5MG2LWIYJ6;SmBb:IRN/oCR2E1_[9Y=b]bjPmjBUMGKUJQ4SeKYXKS
NY=9=:;EJXg_R<e^43dMig@^<Um?jBl?U8j^HFd0GNoLOdbcE8LS9TDXBm5:]`l1
T]QLdL9^8Z@G=[_8K=DW=IG9S/eVZ5mGiY<T]f6k3[a]D<76/1OPXAV<MoKHSLZ1
:KK1eASjn`5lf:EaI5gKQhUc8@iJ<1W2A:Q037aikO>4==8INhfm2@L5LCDU2dlL
dm1eXIGKgUCgQ7lLTJKOmE8CFX1V6_Ka7^_XHV;giC2625DLJn/b7d=O7lE:^l@n
o82ELaI]R=Hh`2YZ`?jAJ5<SERnW9^AkS[4UZ]eROY4o>GbF=WAGDd`N69UOYJ6k
GVY23jVITXDWjoDkAODdgX1Z;^b21YD>Y?3Q[`fZKol1H765D@YUKVAcM79UHFd:
IFiTKf9Z2SDP<21_HVX:<C0a=@YUKVA_HVX:<R0`86mRJPXl?20_E7U`IB0_D65W
IB0_D65bIFid83<P<21B82mBIG=_MG9SIG<P=R0`858P;d=_KWAUKWAc83@P<21B
82m=IFAYHD9_N21K<20`838e<R0a>3UM2Shn2VE^I6mRJPXf830PKf9Z2S`l82m@
LVmSDfEd85/P;e14AR0_E6EhM21M82m3Kfa_LU=`HF=U83`l82m3Lc4P=b0`858P
?ShP;dI_KW@P?3`P;eAD<B0h830PDPXn?R0n?PYUKVA_HVX:>B0`86mRJPXl?20_
C6E^IgAX834`830PDR0_CR0c82m1K7AULViQM6DP;dAUMVUSIE97@R0_AVU/M6Eb
82m6K65dIDAUHfmTIB0n?PYcM79UHFd:N06MUWMDDmTFQlnm=kg@4R8P9O@JNPTP
dS]85@AARDV0D0:6Q2IfA0E6514YEVAD`057Qb9SAA@;Ph9Re`Wb4536`E54ANGM
S6/9kjdelmjJoLMIgmWW]mOIInmmekX0D?b21<9dF060=:5H5>k[`E`B4l_4m`8H
404>F070hFIV14OhA0;Do;dmVIVXB<Jcm^h^P6BkfbboD2Ice_moTB8g@b@600Y5
eCHlORHGi@:DDk?56C;o1<[dUBTbQS4b5Z49XZ`RhlB_K?JWiR^kbIRG9^BQ6UW>
6K`dWXbkD=jJ9N6SS0BQG9PUh6NSO0MU_EA9VP3UmbSCdoRLC00`59UOc>LVXFb9
<TDD6Nj9lP8029C4>Kab3X_i>FRN07RVInB:18U9HZHAeiQYiNS8I_[a/e?iHS4[
U<==hHQhC<od]0b><1N0[fnFA@4UFFfIJ97][Ac]kEWFiVSi_mWO7WiCoCg8N_]E
lBK/cii1S9iIgfc/[2nm5P3f95ZK7K>nUED0]6d6@>GQ[4o_803b1@2dgYcc7XI/
GY;4hP`W2h_/k6ac0Im[;R_X=o^OPVo:_hHimiW;k_]F>jHG?h4SBADcIDGUYZNV
BdC<c0`>UlmToOL@on?0>FW=bL</W9o05o65j5EAj9@9Q8UX^hDlPER@;V@:Q7oE
hGlH=RL76GjMJaAXMEl0OHDiD;Q91lQ_?@138`<TKSmj0Wg[Fa0a2/Rn_6R]TJmc
Sc9jo^Oj7`]LRVkQC44RDnKf38mTLRFR;1VSghA/`@8BT0MdX0XdPBh`0RaP3Ab0
<g03gR00Q81840>F0bi80VU01;91?]P02T4af05fPfY`0=B1N]04CX8fL0IL15O0
3G0;3817@0Z6`D/`0Mj1J@R2l10EXT6ZT1JT3iU2eQ0KFPQi@d5@>1@3aD>9T12B
@?W@9ZPH:X>ZXD=@?O@SM1Zj25f3nZ07d20d1_d1OH@AV0;CH@gH0;J0fK0k70Q7
`/_PA7PEW0LG`=_QB[PF?Pjg`QOQ6o00;8EO`Y<8@<P80m56F0PKlDA2T5PT0A4Q
Ji4RY0:YAIZ@3Z@K^He8TG7T0`J7XF6H61K66N>7FHcQHUIQeV9:<=FHHiQFC1OV
=VH@<h7iPZEReK6VF2N/?gH9=Q6KSBg4EV2?H5^`Uk43f67/>a`>al0IhQa`O[PH
G39^=Jh4]`oGS;^0jl<=hBKaN;`ZgQC_PPo1Lo1RO26n2WlLOakOSao6_bN@2EX4
Jh8?8IHP96`TE10J2>L8oH@A`SAAPJQ?M2:647W4G68Y/HkH@Ka972I>TaA9QR@G
DR@YVKB1E4UZ8UdV?BJm8I?9>VA7LQQI@5i?[RBO85lU3i8oD9@X9QA?BQa5@]U>
>DZi@7U0ND>UDPfXK]AHZYRjWEY?_DAmBWd_Ai<cUo>GhlV]Tj^AJiG[Ug/UCiCG
UgNGGbjO9elQOd[nY_bh0U71@<5CPJ>`EZ56hKC2?HE9AIZRUF:8HYYRRF:3hSG5
DBFlTX6B]a9?ZD3Y/=8UYB4J@]>UNM:h]4fd>]YUfS0MAcNTnm>CjLGd7nRmm0UU
9FEKiBSU7>DJiK?:DPK2<63h<e8IYHbCS;^<So<di[W?hloK=ZmYG_nl:IGi:VhZ
O9DRUFJE0IF?ZTaEKmDDeIfZKJY?e31Z9VYQJ]UZnmD^Zhg?YlmgW/nMGcCoi?b7
j[2jRGZhnV[e`nXmjY<JVQZn6QTJEAZG=<He6IY^V/VJiI[W=<NdJ5X;]@AJiE[W
]Eh`UIW^c5AV9K>;>J6][^fW;M4nY=f[?JeSZ;=HIj=>/lhCGI8^FcM1]ebgDgM2
Cd/_F2mO[e7_XCiAWjfOY;m7_e]ob/3@8=YPRd6K`JRQRZ6oHIiQXn5S8jZAZm4Z
XeZS>lHhHkIaR_4nhe/V/8VMBI99SLU=DmSDgUAP^/ndc`a[iVPV=:/e^lNR/=aI
FJa6eZ0i`cc8O:=iVoT[2cf;F8^M5]dFGbc];5<]jb`OFBUI1EQ]]>Z`n/?Ja9Y[
GF=mahIZhf>ccZKMi[F]ZBgOM[o]OC^JGK3M5[]>^lof3_HRnbKk<@LmQgR7_@kg
f7Af:;^4OMDAjnSQ^<kaS><79g/W/M=9YmnMFLhYcPg>X`/<5o0Ge2dHL]5ahKPL
LY4^I2j<GgQ`XMAEfiGSF^_jc4gGSNMfa6g4gMPmfOfhnb/?B`nAAh_7U:NCia[?
2ej8UjmGTEN_]i;gH^mZkjLn>Sj9?Xdn4kif_Z]m;oQQo@;mM_[MlmO`io[Gndl4
>0B/2NP:Y0A615H7?P/b2A85M@C3`@71^h8O;m9O95cD5P92o4=fQC`9=@aM5OYc
62h/=:`Vk7VhEGQnN7L4;F95A4?4^dR?b=;8Ah^=5T/FMdK9AlE5eDM=AG]5UdE;
UeP/FK?TAXaJS22V?AHO6aEk97IbZOOBgD^7hncR2^?^;S=LU[?/fW:eiJW;cjj@
Gl5ILBXN6alMga3oRA?2ZNE<[_AO^GOU1=NC^hOkT^O6:nN=lEghIObA19N4/XCA
A9O4GHUSBJi95DWS0Tm1]N1e/UobPNBYU92DXbTcZM6YcFV4]?Rddd8UHHZ`:edc
?BNm;l<dXc13^/YYeNiE4j90dI5<:7=II[^HS_i<mDR<99/UPeT;/fZbgVM7IIo:
DL`Ai_CTV^A^bag9llWkOSEV=GMeIkifoXKl`CG^J`j]QMJ^G=^iCWMM`K[QmKk[
SfdPKDSIl<]6bheU6mm^R]kDDJ1A/;iPJ;?_i/I2^D9AhKd]cU/>K<E/5Fc]gFJc
[F[KUb9NdOERbn::hTlUg9;[geUmEoWMc?J4kKfUmZGkMn1f27OLgNVjleRIHUUN
fM2^h5f]iLcbX_:g^eO/_UIQFg5P3fV?I8nd<ZRb_DZ_JTOEYnZTjX4JSi[V_NYk
]nfMf/OKekoOKGoC0Hd3a@Ln7Q@L_7o8me1[[D5]aF7LhJc3cn^Rj[ZoIgmOOdC]
B?6AcdN5AjG7`XmeeC_DecNX=i@f`XfBa[7SLLM_oN3e@g/CZnU@<j>in0@h8CWa
h/Oh7nnN33cINHYmZ^TWoIof]]1JRUZQe]cFRKJT=VUkC7_OjH3CWAg>7BdoVoml
m8cfVIZcbVM;ci7>5IbK>ImgO_92aXGaRhTGQcYGM3jj]>CBWJj`[]k;PIN_G_6i
LZWK_O_lEIN[IjhiGC]mWGfmkHKmSMHN^ijFGnanJNVekffmjG2coIKS[Hjn1GgW
nUgk;mkf^WgUS_nM6`>;1_[^;[ikoekL?NUmg_gA1jT?GSo<NSSmJ?eSk>>R9`Y?
:YjZ?jgmeOSGIZVmm>bPef3?/hQWShJh@booUOV_Cl<5cjW?:dJdA^Y7[DO?S?V<
gGZam<G`bhbGdn>5_bWn]_NEdJ^OOWOk_FMRbLC`Jm7[VCm:gZRn>O[FmVgWI>ST
dgMYkjJWR]j[_SofPOfQnf?dai7Yk4ohCiFOSCmgO0WllWPVKFKVgoN4lo/:IFiT
LgAbIF5]2VE^I6mRJPXa<20`86mRJPXb=S4b2VE^I6mRJPXg830PKf9Z2U/P;dU3
@d9QLfET83TP<21B85d:IFiTKf9Z2S<P<21_HVX:?3`P;eAiL6DP;e1QIfEc82m=
IFAYHD9_N21K<20`838e<R0a>3UM82m3KgE^M20a82m;JFAc85/P<R0`858PGB0n
?PYUKVA_HVX:<C4P<21_HVX:?3`P;eAiL6DP;d=QM65/KfLP;e1QIfEc83<P<21B
83hn2VE^I6mRJPXh830PKf9Z2S`l82mDNG1U82m6Kfid82mCMF9dNG1U82mDLWEU
E7U`IB0_@V5cIDI_KW@P;dUHC4=ADB]1LVUQK2e2KfaTBGAQK6USCE@P;dI_KWA4
IG=SLVU`M6mb2S4b830PDR0_AFiSKfAYKVLP;deQHe9_KF5^AFiSKfAYKVLP;dIY
LW=d@fQQLR0f=B0_C65cM4=XHG8P=c<P;eMYI7AXLb1K83Lb<PXg<S8P=c8b83Lb
<R0f=SLP=S4a83Lg>20g<S8P<SLh85dP?Sh:IFiTKf9Z2S4b830PKf9Z2S`l82mD
NG1U82m6KfidA6EcHg9YL7A_LR0_AVm^M4iQKFDP;dUHC4=ADB]1LVUQK2e2KfaT
BGAQK6USCE@P;dI/HFMc83Tf82m6Kfid@T9_N0YK;CDf<20]<cLf834c>C0P<C0a
>5dP;dUdHFaYHd5^IfaU82df82m1Lf=UKW@P>C0e82m4IG=SIFid82db<C8P;d=Q
L4QUJFMXM0Xg<CDP;e=dIFeF830P;daUHFAYKVLP<c<P;eQ8IFUWJ7@P=C4i82m1
MVMGJFAdJ20d=cTP;deQN5MYI7AX834c<c<P;dI_KWA6JFaU<PXa<b0`858P?Sh:
IFiTKf9Z2S4c830PKf9Z2S`l82m<IFiWM6PP<C@P<21B82m<IFiWM6Pa83Th<3@P
;dIYK7AULR0_AVaQM6E4IF=_I6DP?Sh:LgAbIF5]2WP1WGYkH1CEmOniMfIfmY77
iT6NT9UUTnbb6i:@1b@@bNB5@8@422B;a6`4U;@P112[]H9FAJ>EZ?eJgj5OABUl
:i=4<8T?hZ=Zl@4n_jfe@U]/]AFU;N3gRfCgmiVI1J7emo_S]i=cckgWWW__>FO>
?OO<C3J^_gXUaM4F4TQK_ZIc7IVo[9^10//gKEB]M[a>I=>_F7OU6Z^M6RJB_[Ub
mKEGF>f/ehULjZZEWB^/=Yd1W[X:1:_=bX1cEjgIn0>[WKD<f;mjkO9HOaKVYk@e
WCn8[DlOXjeNeKUVYLFO[`8G[5^kHJ?Ec_/<^6;MnYDaO]I65=MZmQfoDS=aN956
33DWoH>ZZ9DTh^BV8UX<bD]h1hUX6oeBh[;Ufnn;M2AFWKAWf/fQSbgH?mFXo>ZQ
biMlLn^I<IMRchEm72JodH5al/c8O:Yck_[Ve]<;G@YiB3Hjc_fLoBg5c`X;`:T9
C@>EYMZ@d3CX7UL2g3`HUfcPNH=5YBHNV6Udca]/V6<eVlgV`58;[BcMHWAVIe]S
TU<]k8X_BJ`I9lbScH2_009EXf`2K0=40B8UXSCj^G3989^XQ9lG6]5^Q>JJ<6N`
[ZiTlgiQ3_D13P?P0J0FVd;=6B`_=aJJ<ePdaL8nWhDWiV7Q>;1G0cH33P:<hI8i
g95BDUCS4NJRJbkFfHIb?n0Ph33P:h04^NIB4J0940Kd0BbZ`F=8=gM`dWAS_KV3
U/9c1eg^T^HJ]c0K4lo6P=T@ebPIYYf=JFNK`fH?>]`UbL?ADOkaP5ICHUDZZlc:
9h=E=BG_efCbCc2XV7m<6Z0I40HL0Q`170OPCZ;/1F`7j9Q:W=IK<i6oPG6mo7GS
WYYecJ`GVoER/jjJMCG6/h<Hgd6K<>Iac?@hLOjhU]Maa7I4i_]]nfFnakI7iWff
?YTgfIYTWVQ;S=4BJmZ5FQRX5PJZQIJeiZf/QLE[Z@>`1c0:R09/E<BWdVH0YdBD
2/2PE0>J0=/0OH3m03_]@LU<_[<l7J1/1T@1=W;cL[C:cKW:<Dli35<>Ba/dI_IF
XmITd8Bi^6Z5FSh=eeALiK`LMWmc`5=VV_^=/iD3Ib^o?U]igJP<ADL7efAEVOSc
[79S3;]d01FShoXHgQC3hAP^]?10X:`DK0>1DP^EF6R:QHX]E6BQP8DVFLQ_8Hn5
dRfDIZ5a5TZeD8Z5TRdDKj4h2kT<=1R82N>cQ?5I`_P/HGbF<3i;69lUS<lBaVL9
hk>4lEW2n2aQO9H`?T/HWbF<ca;6I`WS/hCaFL;h;65l<@]i38bkT5^^3?4g;7C0
@[nfd>^J2ie[LZ^Dc`dVMZVV05l?f0@80`X10H0?h04<2MD3Mdd2VSVXNYF>6XM`
4Jd5K0I/0hQ2iJ3ZDAC4X`ZhK@DL]@:^F`6gkD>i1k0O89c[hd;i?/bk[KX:jfO^
PbQO6l^`@E=2]]]2Bbbdf4;IfWc`W0Kl5O0^h1[0EH1F`2F0>/15P7;0=4K9AmQa
aY?G/Bf/U`V<TH=aK87dM0CYi2BkmRa?@lg1KaoXB/7JN`OlEd83mSCiADH:6f@M
9]JYblBkbLOb@=l5_0Ch?`L2Sf9Hgd2P1>RAP@0<a5H>n2L0[AS`Zd3;1oc5@9d3
oQZPB`MlSbXe3]I:?[^a`18:/0N15`l4KTMgRhDF3@CZd5:/6G86o?LZ=BhfPK[h
K_1VTlo4VACP^`NDdkhQT@dXon/Kh[_g:El7VYBo1XK/K9obNN1Ji@?o46MJX_9n
hE_:^ijgU9OmALY;GN3DG<YXee_:2f3_ccDWN30`a9J0o42P@[Tk06LX11W]Jc1d
Df2g/PiCHKVeR/UmUFN8?HSN=KikUIF16iF`3nemBTLPX;@F3[6l0FDQUX5LUj2e
I9oBR<GWa1Jn>11Dj[5hWB7WP5;S=fOD<0?C/YF;?4NE6I1QF^6cBWUPQS:Ul:SR
3C@X4k/`dC?:hWQ7_6=Jka3cJU?Ug]o;_N_Ug/EbKiWLFbCg1^GNO;TgCnk=TG/W
b:WfI;_KWV2?/c_]M[_=;]ZiWNbY@m4SFX5aOZOJg0JbRDHYVWDg=nXXD19WMTic
:EU?4AYihj9J_B;H>2A75n[CPXfj_OWB]Wk6kPXIE7ed>CEN[^ZW5WV7V7?1DUgb
eS8m^I4JFfXcM7kK4:>F=WRi<N2FK3fi[VfH6<^liBOI<A`:eKF=84JW4M/@X[A=
eAWEbC>C:VOEOdLA=XWQn^2g_ha_Zl5PHo>e`g2CWH>b<UE6La6J_DJcefQVC=3_
JecDY^nJ4=9;S4Yd@ZQA_gfA^Za]V6O`]8KjHIi^X53K/3S8<aXF6WAa/3hDJ/@]
=_U81KenV78=1;h4>jT67jT9MY>?kkKh59i^l?T=1;j<7JBHO4[63Y=?I0IOOiOJ
D=n_XP2?UjS;i>WbdWTl`jb3L/6ERl;Pf/hj32kFhMe^L>U1Lb:O3bb5:<32aY??
W<S7aY//iMnbN68/7NMH>TbF>kmU2EP/0[Jj=H^`2bcWfoWo]kjb]Z5[DBe[K6k[
]e=]Z0h6<72JNme<dc?R<fO^b1jQMhFoTB/HdYgNF]gUaL5OWA5dEk6RMP`Hf<aH
NlR/OFGDK76j3F`b`?2]6Ij<6k97A68kcAWR@8j?MDf^VEaSM<7WSLTC@4j<MFGL
<<>C?L9fa[[L82MQgNmBLl>6SL4=igMl9mOi3?og>VDdM=EKOdK=04ao]@TK=f`d
OQ/Jj_6gTA[e`:96_F;1d[InFFk@]G1m2;C2/cA1<6Wm3PM`IgeX@n`Gg7SeAZ`?
^fUC=6@=6U86;E02V08X1QBEJSS0=IcN6Xi^3NNfQT=K`hVm_LIYiW?KcGb^cjcg
lMNeDZH50QPi2Ec0><fe@38`8>071P@lP0W8X7eVhBVm`4R6K>LK9DA1J0d:E;hj
I]b[Pfc3FO8igXe1TTHXfh@W:5_<YfbRj:MW8O;mj:M6GfAem5?n5lBalAK4WTZ^
X`nISfG@BII<Ng2T7:2WjCL/@=OCFf`5YE4jWN6iY389RF06]M0^>/1T2]5Pm7?J
RBNX;g0>gTe7F04]XCMI0/kcaO@8cFOSX[_YKha7Sf26jMB<P9<ZKI9n`fhRR@Wl
UVPAaF?TSbVEI];3m1jkg[4gnP5=XnO5Bj9oYo]I1Pm@0ZfS?m=ab3NIEo3fj1[Z
Y<gd8[<9MM:md@:jR/h8]dHOPb@b;L:j7G@3o@b[cVBSO8ndP/IC=Le6`6jW=O@4
oI9O8AdgPgTn[HK/[m5Wk9O/Ml9W`_n:M_4blDhY;e:==BMB:EE0/`jjW3K@WG@o
_L28:F`QNd0Z6K/A=U4YWjJ0I`_MA;OC87XCF18KaiJ`AoP=o23oD_b5m9_X@G2E
dBK8m6=jTGi5Oj=o<1/[I<G/9SK<g^6<Gl]?2fZDX/nAWbjVQKB<[Z4KZILNX05j
3]IlTLlCjXA[15glVoQ=i1DlTBn5C3nT@OXeOH3kU/c6lgcnQN0AKQ4N4mhDCT:C
5?77h3d2;HXQhbFh5T7o3G@MKJFkj>NdVoKA2>@iA>o@knQCB5g1_/n^IhnbImTY
MYYkn4ANaMObon0j7n5o5=:41D:;d2gL9c`X_2Zl9bJ9]F:Sn8RhCoc8=]WfVM`I
fA7iDgAn]2ejHoBNj;?AUj;_AKo4Dg4l9?1B0GG1e]g@Jc</nABmP>]enVoj;Gf4
YoU?hGG4hUPf:fMcfB:fV:eVjmUMK1_k:K^OoHZmcIdlRHoSCKbIGlU_iJocPd:U
<4<H4_eRRMPP;QFo;fhDKiE:L<fCkYAfB[^TgM9ajH`]fKH;9o^KHh6aCb:[8Y/R
_hljX`WAW6Qa]2]j4TnE>KQkWG@UK?8@K?8h_>>oJ9ANXCMQUOLQgLOdNoZ43T?2
Om8IU/[BF0J^K5H0gi[?_/Mn`6k4GKbO?L@NHo_H47^>_LcNHXOH>naMmQ_f1oI7
mUOf9C_>1Ik95NkU@Mk1Eo7=^6kUmo87n8?l0?cT83o4?nBOlF>2FiPX84O6EBGD
h06ZAmP]71;7RNV`MY=h]GPM;?j4>2Zn:;hSoTTRbBfUB;UBPM@XgB6=BZnI>ROH
<Vci]Z]/?kKMK=]Q6i95>DfN:]lTgbho9?mLO]nNJ_OJ]m^OQAInU/VbH__OA:b=
_HZ<o18FHU]I2h]W?Ba4ZCa8?aNknEcaHKj=8kDdF6fEXViPhAMdUl1hX]P[g<en
BW^ABLnPVmU<^XKMPc_m:U/7kbZP1hGm@XC?HPP;k75F@JN4PhQ;7l1JIF`:^iSV
l]O5]jGGUVgU^O`bmU_a<Y]3O9G^iLn:HK5LI;3]]LRkKQ=n@U?YBf63L1BkHXgH
Raei?A?Y8Sj3CP1o21mb/caNB=E/SY39VXD[F1Kd=<InP2SAaO]i=Kg2O/Zo;oSI
3eT9WJ@83DX_d`?B@_63j7aaKe@5iCY3<mZ5NJ0S^e<8Ri>R[I6_fEHQPklXi?>;
f3o4C]hENHXe/C;nZC25KN0KfCMh:_33P`k`NKb6IN6I?QkcO`4O>T=oY`7aG^4W
dDn4gI45o3W:UIKA^hQX=U[0AmPojCg4daOP5GK4g5n:DfV_L1DM5l9lR8na[oWG
m2PmQBRlQo_HkkQ6af`MhQ7fjMX4UR=LPIS6J@NRl^G2Ue@Co@<b_8gAPm7m;1_k
I@AajNoBbg`]gH=hl@8RbPf8Hig`i]DDajk53TS0=@SOo`OR@cY^Sh@HNQGfjH>8
Ub>85alPJWb6oXoY5?K^0o@kcZSImS0T?dh_@KoCc4k3E88c8`5kjFSdU?P^K?Ld
gBh`NUU>/LdDKjGWYOgbC=XEWHJhOQE=X_]X7o]8g4T_J;D]F_G<RjYVC:n/V3Je
_:bdI4YaDN7TPV1PT]nGWiO[WNQAUI`9hk>c<S?BdlJUYR@W^A<Ch^=LCXMM]TVR
064:6[bc`ZZN7mK5O>o/fI>=][LCQ<kc265M1FWFQCbjJXc[A=L5W1Xh[oPGC/gR
e<ia<[MJAEFC2m@6[jZoENmEQmSB1FfXojCN6e;eHfImWUTGlle6?1XN3dJX3AV[
jUFMQMD6OMJVECd=hO[91JcOiJcceZedCRjPOZL;EAMZN[YgGCm;WlW<2Y;UjOeh
BXf7SWZF]ki1coAR::HAlQXjEnS=2mXJj[<mW]3T0YgE;OMN[Y>Aa@E=5ZXcUm5]
MKY/;Z=f8AOBj@je_f2dilhQ=edN3/J]l:kXG=JV2ifHXd5?2V;MNSgm^Z<IgcHa
>E;9[NOgIP/m3AUMZ/7Ldk=EeDLG]9dg=]]Sc10:H@j<iGVc`Sfc/?BM^5D/X`S2
6N8KZUQ:[O@f69C`meCMhJge[^[iGQPg9:]7YhGGNPJb/[AQi19I3FY?Bi_GXeMW
Nd>MmN?kDjUWhKF3VIZJNF7?i89nMi9UcOj4a5PU;_klbTYHf^XcJbJkDF]LN<jL
c938>`N9YJh^Eb59VaN:E1S5bP[ZFEh1Zn<GHQRU[l1]j=8MMN4NmgB33U<bGLYc
NmFNThCKkSgfaHFDcQS5U^LnBDJWhAcW74aWWFO[NS2X1`:6GlQe^96@LJKI;YmL
/6V8;o6^Lj]0<1le]f5HJ7XAK>ka67OeSR6=;TM3gk:PcFZ[M7Wf06U5B?Iif>S1
GK=jaRdfN[JLkCTg?>b5nci]?03C>=fNOnh_dIfFd[1Z^/kBoQoM:jgnaTGNAZCY
JT=?>>JZSBdG]:an`j2`6oYR=FH=Q<5e<DngiLga`^<F;Vdc2?RClVIi6k[2/k73
8:>ND]LVI7=S7j36/`Ec:[S]/ZEWic<JKG76G6:NcM0@ndN0fiX4Y/kBgN7IEQUb
NSbaCOG_HhITngV3QZ;7SE4VnWIHC6EmNS2VU:FR?^>2mPGBaOD8SBd8B[baIFU?
So>2_UT8Mcdm/kcZ[9i`CnM@M<_UG]G]kAU6QUSG/jh1PLZjnd?ATC^bmEUgQZ3:
:SHM?/jY]]o;KU_@[k7K5Re]6lJ;3OFfU[H1I:1ehMY@ObkjfXIE8/fTlW=DPdLe
F]C8/2/6^=g/bQkFR;JH_:99<=_;lDk3Y5U<X35J?/@]V]_T2hE2Tg5P<I9NRgh^
_DH;0Bl1@]8BJQ7oQ?>UT_HJKEj9O9S0J?PL?^9P49iJZ<Klf/9aFXTh[f`h/NbP
F;mBnYPmQ6chBF6Z/1>iO:KDR`jL4oRHP`]SI:YjV[=WK?8@?jUUT2@n8i1C5YmQ
U6VgBLm`@GO/o`B?e:NZaZ[V^dmDcA^[XV[DgFM@C2Wf97VBlU3PcA2MDHGA<iY4
gi0ZSV8E?86@]1a?FC8iFI[FL]S1]3RVaZf;ndQhGaBKhZhEmlLMRS/N9nD;0M7_
F28/LMh_o/`Y>a`D=hLJKG?]FYb=k0jI>Ad>;]U/4fE7ZR`kA46Hb1fYW3/L@c`d
8=ZM@gSFC<2k8T4B^DfF^F2g3O6K=9LZKiIi/gaHi_:cK1c<8_2@iUAh4Eo7Sg0A
6LDn;I4LVV>Mhi1398OK`Ag?8A=bl@7n36D4<mdWf[]?]FLL<b/Iaj1jUK^Z^RZi
//R``K6]DV7`AniG]QIV64QfEeE]OJFZglK[F]Xd]d=;bRacn1eaIDd>iY14UYAL
BNg1H6Q:<N]^KnmVjjVKN@@?ljAh1869ZF??jY43`TF/jL_87iL/SSc:jR??BB>W
In4aKokHP76g5/:RCl6RbLSEoCBVcE@3K8VKkFA?:]/3X`5aAMc?K4oBXH3HV]:Z
Q5g70f;@iH/[3PPYORG7UNYcfC=b54DQUPXoBTdac9K^>nQWO]Eof<n;o4engCoZ
5og:Q1cd`C4hG/j2JG8bhDF/>l>_fUVAOBgN4;jAjmL2S1;L2FY2LD8hXBmQOh:L
L=Vj00_TS?1kl74UEd/Ja@<E;bH=CkX2EDfRm16nRkO2[_2Wm^jaXnkfDng[Sl74
ao3>aW@[`kFB:]^kRkYAREWG]1]/9d]El3SFSQne/niBiRU9cn7SDVeb6[8QVnPE
BT^V8Vo:mnEk_H;7ZW/m2eTY>oUHcN[ki]mfEoOVnb;olnW1?cmdFkdf`g?3GmmV
gVMne;SjQ/SmdXPcLNUmUehgF:Sd[KSif2[QN`D[:R]VamW>n8YFElgY<?KMBm4o
Bem;kn5=`X1Ff4A=C4_@4TDi?Cdmj0PjPjVcYJK4Re?WIXChDV5Yg7f>N6bRQ:K4
STBN><9nBLWl3LgY4X[`o:g17PHY4jCYXX?lJmUnaY]H1n_3noLK4of6HGW26mX4
MV@2DbMX4iXWQ2N84m;lV]`/QfG/FcMlNXPo>3Rn//CHW[2Q^k]moHUfV;<MOSYf
];ejk4Ak9NaVf0`6TfcTEBVY;3Vg]4A<Uo;c_A=]/5hJS2INahY3THNoR_`cl/hK
K=GkGk;l[<SQS=_GonRg=ogRQZ]Oi^k2[b?O/7YFMY[eOAcmN?bF3OM7W_ni?WXo
/^d@O?9=n6@B:OB@=_6F33J=bY<Kde^CFiFALL?Y1lHMB7<XbLTa[d]9=S`[RN`i
YVMU`LOPFIUnL[ZMg9VUNISZHO^a:ICWh4K9N<g2N?fo^Y9:jD=lEcld=eDo>WId
_[^mNofYmWTGN5;<PB`3F?hRST_U/TffNGg@Nm[Di9RkQ>0TMn`X_7CKeH/;mmkN
mLAU;coa`1?o<C=dgLZiIKO/TDHTAlG:^hJ_>QJiNgF;?nf;BAD;F<8c3cnBUFch
A@//l2]H`4FOJL5FAio@9oNia:T>SF]2ZbSJVNYDGM=8U>`>DG@hHXJ`BLK>BYC]
AOHV^fhOaH]gQb36]YdCTNgeOBicelTS71l_l@e_J[W=Z;YhkEk=6HJeS8dVl5X]
YATfi6j4]FH^m/6RFO6RHCg7Me/_c[;Nj_>]MjZmOOflXbOJSih87_fGcFR4^YPU
iK<k4<JD4KY<J64UHWGYVJmVlJm;aac;Q<EUd/S9b>39b?ZCQWFJHIeKH1d7kMDb
kJaEK;Go]d>dBj;SGfbaEkK7;:0iXH?3DWj8enhkI6>jSD7i>U?Me5i;gE6lBLQB
GJcIaEcRLg1b1`mmUkLhcL23V7Nn`TIL=cG^S^U[QIioEoIKEI]IZLS;aP[VlUM;
ajKOI6RioNAH;gCL6of;K@hRPhNeh?DnKUE:Y@OO?KG^U<Y<`NnZ5>H8KJj]>Co;
NCaW^n;Hc`Mc^<bISM/4=g=c]i2NiLia:fjeP?_R2g<V:M=]5HTEkTZUVBe;G>K^
HgdiSbYmj^?d9=l]O/PoE4jcW:AabJZRC>@<ib1CE2j=EoMPeaPniF:ZJGMlf1^?
;i^J@g9d93?l9A/aIia1BA3hA3oSK_3GJ^>XREPcmN7ECQCWN:KbaSJE8GW>gM]<
fk0m3Ih9bGh]RE4BLbNaY1gNC;oVJ7J47OQG3n?<A23J=a4OA2Hj:hOiDjJMZf91
jBA>>/BT/OHCIU`gS1edSiX1Z[]j3;BRmZZamR[4ZNC:[@V5@@T7:LFR5^^VkWJl
3lHYRO2^n_:CbZI=YGl;Gm>VNHBKNNo=6b=kmTB>gogZhR_H3b8AEUXBnD_NSQoM
Lj9Wigmf_SUgLZA7B1bkXg7E3gNbjPmOnH:9GoaA_Oj6nb<_?COL?bgo8l=G4L]/
>NI>?Z`E;W4fag>kf<YKKJfbB?1>5k=94WLhWH[;W^YbfBG>5D5<5@AlA30<WbWK
R^6WX]?U@P[R/<?9^MdU2Vkk2k`NhD54RO@:>DQZQn^Pjk1;>>aRi>Y3;NXBGD=/
mM=J?8]7FQ;BDTJ5@`8_5SBQFA24ZSQG^V36_>_Pa37C8]Yg[coV?^XfS6XNX6Ib
PR8II_efeijGWQPYRWV6FXV7P=B3NLB;agimNnAMQ<39VoRdJmSTb=^AMoVf/FiY
I>`0WgYj5Rb3c9<o2L/8M6RH97cB[k^hC38nkEM[5Zjjb<:UIAH^:SJaE^>KG=H[
<C^n4VYB:fnF`]9VJK_d6_l;?h8gM75^ZD?ZTgCYT2AY4^>240^?R0226@7hlhKE
/;?Qe3P9e7Eh5kbMM1:=a29<PY_H4F9Qd3Sm@K`P]<4ljc>?IXfI>cbS6XWK]bO2
NYbFe]L2K71f/J5li6dSfh:RN1]g0^33>mW_nSU1c:Dl_<Wf8@^KA04:hZfNlL>>
0aPo6fDBcFVkY6k1PV3=nZk>eI=[ejiN<FMSinZ^iO=Jj?l0gcHGO0YUKVAcM79U
HFd:IFiTKf9Z2S4d830PKf9Z2SHh<SD:IFiTKf9Z2S4e830PKf9Z2RQ]HF=?Db1F
IG9cJFm^834`;S4d;SHPG2Q2MFU/I20a>4Le<3<cG2TPDGEQLWAj8514AT=_KWAU
N7@Y2VE^I6mRJPXa=R0`86mRJPXXA3Xb<38`<C8`>C0`<c4b>EX`<2L`<2LY2VE^
I6mRJPXa830PKf9Z2S`l82m@LVmTMF=ULR0a=B0`858P;d=bIF5dJFm^A65dIB0a
=R0`858P;de_I4AQM6DP<CHP<21B83hn2VE^I6mRJPYhLVEV2S0P<CL:<30`<30`
<30`<20f=CDc=B1V80X`<30`<34a=cHe830`<30`86hP2S0`<30`<34a<c4P<30`
<30PKR0:<30`<30`=34`<R0`<30`<21^80X`<30`<30`<38b830`<30`86hP2S0`
<30`<34a<C4P<30`<30PKR0:<30`<30`<C8c=B0`<30`<21^80X`<30`<30d<3Hg
830`<30`86hP2S0`<30`<3@b<cDP<30`<30PKR0:<30`<30`<C<c<R0`<30`<21^
80X`<30`<30d<3@f830`<30`86hP2S0`<30`<3@a>3DP<30`<30PKR0:<30`<30`
=3@e<20`<30`<21^80X`<30`<30d=c4a830`<30`86hP2S0`<30`<C4f<SHP<30`
<30PKR0:<30`<30a<CHd=b0`<30`<21^80X`<30`<34a=c8c830`<30`86hP2WAb
HFU/IG8:?3`P;e=YNVDP<CLP;e9_Kg@P<C4P<21B82m9KVI_834P<21B82m9A21K
83`gISMV>FH`Hf8iHC1U=S8hHSQUISHc>6Dd<FIR<3LcHch:?3MV=fHiIS1SHSUQ
<6Df<SQR>6EV=S<hIC@aIV8`=c=S?R1M83hn2W=dHG9dN79UIPXa<CPd<0XU9DE?
APX\>"], "Graphics",
   GeneratedCell->False,
   CellAutoOverwrite->False,
   ImageSize->{252, 189},
   ImageMargins->{{164.45703125, 0.}, {0., -7.07421875}},ExpressionUUID->
   "021fe669-d1bd-491e-875c-db050a36468c"]}]], "Text",
 CellChangeTimes->{{3.8156609506852617`*^9, 3.8156609731963797`*^9}, {
   3.816462695289666*^9, 3.8164626988159447`*^9}, 3.816466372101927*^9, {
   3.850476220731615*^9, 
   3.850476222338129*^9}},ExpressionUUID->"04ba5bdd-4f3f-4dab-9c2e-\
3fe6017dc953"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"lenAB", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"Pa", ",", "Pb"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenBC", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"Pb", ",", "Pc"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenCD", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"Pc", ",", "Pd"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenDA", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"Pd", ",", "Pa"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenAE", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"Pa", ",", "Pe"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenBE", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"Pb", ",", "Pe"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenCE", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"Pc", ",", "Pe"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lenDE", "=", 
    RowBox[{"dist", "[", 
     RowBox[{"Pd", ",", "Pe"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Get", " ", "the", " ", "symbolic", " ", "coordinates", " ", "for", " ", 
    "the", " ", "four", " ", "centers"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sF", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"bary1", "*", "Pa"}], "+", 
       RowBox[{"bary2", "*", "Pb"}], "+", 
       RowBox[{"bary3", "*", "Pe"}]}], ")"}], "/", "barySum"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "lenBE"}], ",", 
      RowBox[{"b", "\[Rule]", "lenAE"}], ",", 
      RowBox[{"c", "\[Rule]", "lenAB"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sG", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"bary1", "*", "Pb"}], "+", 
       RowBox[{"bary2", "*", "Pc"}], "+", 
       RowBox[{"bary3", "*", "Pe"}]}], ")"}], "/", "barySum"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "lenCE"}], ",", 
      RowBox[{"b", "\[Rule]", "lenBE"}], ",", 
      RowBox[{"c", "\[Rule]", "lenBC"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sH", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"bary1", "*", "Pc"}], "+", 
       RowBox[{"bary2", "*", "Pd"}], "+", 
       RowBox[{"bary3", "*", "Pe"}]}], ")"}], "/", "barySum"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "lenDE"}], ",", 
      RowBox[{"b", "\[Rule]", "lenCE"}], ",", 
      RowBox[{"c", "\[Rule]", "lenCD"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sI", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"bary1", "*", "Pd"}], "+", 
       RowBox[{"bary2", "*", "Pa"}], "+", 
       RowBox[{"bary3", "*", "Pe"}]}], ")"}], "/", "barySum"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "lenAE"}], ",", 
      RowBox[{"b", "\[Rule]", "lenDE"}], ",", 
      RowBox[{"c", "\[Rule]", "lenDA"}]}], "}"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.815661387716498*^9, 3.8156615010146523`*^9}, {
   3.81566160607171*^9, 3.815661611046569*^9}, {3.8156616927911587`*^9, 
   3.815661699214929*^9}, {3.815661841335532*^9, 3.815661925647656*^9}, 
   3.815662103644033*^9, {3.815662460580462*^9, 3.815662518195291*^9}, {
   3.815662565763628*^9, 3.815662629779756*^9}, {3.815664082697843*^9, 
   3.815664090775828*^9}, {3.815664144065123*^9, 3.815664155984667*^9}, {
   3.816464357959372*^9, 3.8164643635645514`*^9}, {3.816465285047518*^9, 
   3.8164653339757547`*^9}, {3.816466090418483*^9, 3.8164661133853188`*^9}, {
   3.816467403742345*^9, 3.8164674096454287`*^9}, {3.8164674507103863`*^9, 
   3.816467473789586*^9}, {3.850401478390545*^9, 3.850401508501005*^9}, {
   3.850401846903339*^9, 3.8504018486064463`*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"c7cea900-0b63-49ac-8fc9-c28887904f3f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Add", " ", "these", " ", "points", " ", "to", " ", "our", " ", 
    "illustrative", " ", "figure", " ", "using", " ", "a", " ", "simple", " ",
     "center", " ", "function"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"for", " ", "our", " ", "figure"}], ",", " ", 
    RowBox[{"use", " ", "the", " ", "symmedian", " ", "point"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "step", " ", "is", " ", "not", " ", "needed", " ", "for", " ",
     "the", " ", "proof"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"figF", "[", 
      RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", "a"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"symmedian", " ", "point"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pF", "=", 
     RowBox[{
      RowBox[{"sF", "/.", 
       RowBox[{"f", "\[Rule]", "figF"}]}], "/.", "figCoords"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pG", "=", 
     RowBox[{
      RowBox[{"sG", "/.", 
       RowBox[{"f", "\[Rule]", "figF"}]}], "/.", "figCoords"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pH", "=", 
     RowBox[{
      RowBox[{"sH", "/.", 
       RowBox[{"f", "\[Rule]", "figF"}]}], "/.", "figCoords"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pI", "=", 
     RowBox[{
      RowBox[{"sI", "/.", 
       RowBox[{"f", "\[Rule]", "figF"}]}], "/.", "figCoords"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"points", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"pF", ",", "pG", ",", "pH", ",", "pI"}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<F\>\"", ",", "pF", ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "0"}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<G\>\"", ",", "pG", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "2"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<H\>\"", ",", "pH", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "0"}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<I\>\"", ",", "pI", ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
       "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lines", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"Blue", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"pF", ",", "pG"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pH", ",", "pI"}], "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", "Green", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"pF", ",", "pI"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pG", ",", "pH"}], "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", "Red", ",", "Dashed", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"pF", ",", "pH"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pG", ",", "pI"}], "}"}]}], "}"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"quad", ",", "points", ",", "lines"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.815662121889491*^9, 3.815662179057414*^9}, {
   3.8156623720757227`*^9, 3.815662448706707*^9}, {3.815662687244935*^9, 
   3.8156627885161667`*^9}, {3.8156628214615097`*^9, 3.815662824788678*^9}, {
   3.8156628571094217`*^9, 3.815662886724581*^9}, {3.815662932765666*^9, 
   3.815662935316457*^9}, {3.815662966415786*^9, 3.815663171981433*^9}, {
   3.8156632514395847`*^9, 3.815663481583969*^9}, {3.8156645570750103`*^9, 
   3.815664617305335*^9}, {3.815664815458685*^9, 3.81566481585273*^9}, {
   3.8164627890102997`*^9, 3.816462796273087*^9}, {3.8164628868495703`*^9, 
   3.816462969757353*^9}, 3.816463293803825*^9, {3.816463358933813*^9, 
   3.816463480171934*^9}, {3.81646352447656*^9, 3.816463535298666*^9}, {
   3.816463639372245*^9, 3.8164636440668592`*^9}, {3.816463725523726*^9, 
   3.816463765427142*^9}, {3.816463858812983*^9, 3.816463948955366*^9}, 
   3.816464043789238*^9, {3.8164644141422157`*^9, 3.8164644277243643`*^9}, {
   3.8164646986724854`*^9, 3.816464714809638*^9}, {3.8164653613771667`*^9, 
   3.8164653619274273`*^9}, {3.8164661569787617`*^9, 3.816466157353188*^9}, {
   3.816467531430943*^9, 3.816467537565777*^9}, {3.8164678918074913`*^9, 
   3.816467897830579*^9}, {3.816515889199285*^9, 3.816515894006166*^9}, {
   3.8165187526197233`*^9, 3.816518754282189*^9}, {3.817204929716588*^9, 
   3.817204932178385*^9}, {3.817379895332776*^9, 3.8173799618846607`*^9}, {
   3.8503084285166597`*^9, 3.850308469843956*^9}, 3.850310996837255*^9, {
   3.850401519751309*^9, 3.850401534477363*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"713cfbd3-2529-45e2-8882-82288ff468e7"],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsolutePointSize[6], Thickness[Large], 
    LineBox[NCache[{{{1 - 2 5^Rational[1, 2], 0}, {-1, -2}}, {{-1, -2}, {1, 
       0}}, {{1, 0}, {1, 
       2}}, {{1, 2}, {
        1 - 2 5^Rational[1, 2], 0}}}, {{{-3.4721359549995796`, 
         0}, {-1, -2}}, {{-1, -2}, {1, 0}}, {{1, 0}, {1, 
       2}}, {{1, 2}, {-3.4721359549995796`, 0}}}]], 
    {RGBColor[1, 0, 0], 
     LineBox[NCache[{{{1 - 2 5^Rational[1, 2], 0}, {1, 0}}, {{-1, -2}, {1, 
        2}}}, {{{-3.4721359549995796`, 0}, {1, 0}}, {{-1, -2}, {1, 2}}}]]}, 
    {GrayLevel[0], 
     PointBox[NCache[{{1 - 2 5^Rational[1, 2], 0}, {-1, -2}, {1, 0}, {1, 
        2}}, {{-3.4721359549995796`, 0}, {-1, -2}, {1, 0}, {1, 2}}]]}, 
    {RGBColor[1, 0, 0], PointBox[{0, 0}]}, 
    {GrayLevel[0], 
     InsetBox["\<\"A\"\>", 
      NCache[{1 - 2 5^Rational[1, 2], 0}, {-3.4721359549995796`, 
        0}], {2, -1}], InsetBox["\<\"B\"\>", {-1, -2}, {2, 2}], 
     InsetBox["\<\"C\"\>", {1, 0}, {-2, 2}], 
     InsetBox["\<\"D\"\>", {1, 2}, {-3, -1}], 
     InsetBox["\<\"E\"\>", {0, 0}, {1, -1}]}}, {
    PointBox[NCache[{{(
         5 (1 - 2 5^Rational[1, 2]) - (-1 + 2 5^Rational[1, 2])^2)/(
        9 + (-2 + 2 5^Rational[1, 2])^2 + (-1 + 
          2 5^Rational[1, 2])^2), (-2) (-1 + 2 5^Rational[1, 2])^2/(
        9 + (-2 + 2 5^Rational[1, 2])^2 + (-1 + 2 5^Rational[1, 2])^2)}, {
       Rational[2, 7], Rational[-1, 7]}, {
       Rational[3, 5], Rational[
        1, 5]}, {(29 + (-1 + 2 5^Rational[1, 2])^2)^(-1) (
         5 (1 - 2 5^Rational[1, 2]) + (-1 + 2 5^Rational[1, 2])^2), 
        2 (-1 + 2 5^Rational[1, 2])^2/(
        29 + (-1 + 
          2 5^Rational[
             1, 2])^2)}}, {{-1.082791929139295, -0.8875213544535451}, {
      0.2857142857142857, -0.14285714285714285`}, {0.6, 
      0.2}, {-0.12921343578093994`, 0.5872860451322516}}]], 
    InsetBox["\<\"F\"\>", 
     NCache[{(5 (1 - 2 5^Rational[1, 2]) - (-1 + 2 5^Rational[1, 2])^2)/(
       9 + (-2 + 2 5^Rational[1, 2])^2 + (-1 + 
         2 5^Rational[1, 2])^2), (-2) (-1 + 2 5^Rational[1, 2])^2/(
       9 + (-2 + 2 5^Rational[1, 2])^2 + (-1 + 
         2 5^Rational[
            1, 2])^2)}, {-1.082791929139295, -0.8875213544535451}], {2, 0}], 
    InsetBox["\<\"G\"\>", 
     NCache[{Rational[2, 7], Rational[-1, 7]}, {
      0.2857142857142857, -0.14285714285714285`}], {0, 2}], 
    InsetBox["\<\"H\"\>", 
     NCache[{Rational[3, 5], Rational[1, 5]}, {0.6, 0.2}], {-3, 0}], 
    InsetBox["\<\"I\"\>", 
     NCache[{(29 + (-1 + 2 5^Rational[1, 2])^2)^(-1) (
        5 (1 - 2 5^Rational[1, 2]) + (-1 + 2 5^Rational[1, 2])^2), 
       2 (-1 + 2 5^Rational[1, 2])^2/(
       29 + (-1 + 2 5^Rational[1, 2])^2)}, {-0.12921343578093994`, 
      0.5872860451322516}], {3, -1}]}, {
    {RGBColor[0, 0, 1], 
     LineBox[NCache[{{{(
           5 (1 - 2 5^Rational[1, 2]) - (-1 + 2 5^Rational[1, 2])^2)/(
          9 + (-2 + 2 5^Rational[1, 2])^2 + (-1 + 
            2 5^Rational[1, 2])^2), (-2) (-1 + 2 5^Rational[1, 2])^2/(
          9 + (-2 + 2 5^Rational[1, 2])^2 + (-1 + 2 5^Rational[1, 2])^2)}, {
         Rational[2, 7], Rational[-1, 7]}}, {{
         Rational[3, 5], Rational[
          1, 5]}, {(29 + (-1 + 2 5^Rational[1, 2])^2)^(-1) (
           5 (1 - 2 5^Rational[1, 2]) + (-1 + 2 5^Rational[1, 2])^2), 
          2 (-1 + 2 5^Rational[1, 2])^2/(
          29 + (-1 + 
            2 5^Rational[
               1, 2])^2)}}}, {{{-1.082791929139295, -0.8875213544535451}, {
       0.2857142857142857, -0.14285714285714285`}}, {{0.6, 
       0.2}, {-0.12921343578093994`, 0.5872860451322516}}}]]}, 
    {RGBColor[0, 1, 0], 
     LineBox[NCache[{{{(
           5 (1 - 2 5^Rational[1, 2]) - (-1 + 2 5^Rational[1, 2])^2)/(
          9 + (-2 + 2 5^Rational[1, 2])^2 + (-1 + 
            2 5^Rational[1, 2])^2), (-2) (-1 + 2 5^Rational[1, 2])^2/(
          9 + (-2 + 2 5^Rational[1, 2])^2 + (-1 + 2 5^Rational[1, 2])^2)}, {(
            29 + (-1 + 2 5^Rational[1, 2])^2)^(-1) (
           5 (1 - 2 5^Rational[1, 2]) + (-1 + 2 5^Rational[1, 2])^2), 
          2 (-1 + 2 5^Rational[1, 2])^2/(
          29 + (-1 + 2 5^Rational[1, 2])^2)}}, {{
         Rational[2, 7], Rational[-1, 7]}, {
         Rational[3, 5], Rational[
          1, 5]}}}, {{{-1.082791929139295, -0.8875213544535451}, \
{-0.12921343578093994`, 0.5872860451322516}}, {{
       0.2857142857142857, -0.14285714285714285`}, {0.6, 0.2}}}]]}, 
    {RGBColor[1, 0, 0], Dashing[{Small, Small}], 
     LineBox[NCache[{{{(
           5 (1 - 2 5^Rational[1, 2]) - (-1 + 2 5^Rational[1, 2])^2)/(
          9 + (-2 + 2 5^Rational[1, 2])^2 + (-1 + 
            2 5^Rational[1, 2])^2), (-2) (-1 + 2 5^Rational[1, 2])^2/(
          9 + (-2 + 2 5^Rational[1, 2])^2 + (-1 + 2 5^Rational[1, 2])^2)}, {
         Rational[3, 5], Rational[1, 5]}}, {{
         Rational[2, 7], 
          Rational[-1, 7]}, {(29 + (-1 + 2 5^Rational[1, 2])^2)^(-1) (
           5 (1 - 2 5^Rational[1, 2]) + (-1 + 2 5^Rational[1, 2])^2), 
          2 (-1 + 2 5^Rational[1, 2])^2/(
          29 + (-1 + 
            2 5^Rational[
               1, 2])^2)}}}, {{{-1.082791929139295, -0.8875213544535451}, {
       0.6, 0.2}}, {{
       0.2857142857142857, -0.14285714285714285`}, {-0.12921343578093994`, 
       0.5872860451322516}}}]]}}}]], "Output",
 CellChangeTimes->{
  3.815663275757093*^9, {3.815663320225317*^9, 3.815663365112501*^9}, {
   3.815663410317318*^9, 3.815663482068825*^9}, 3.8156640957418833`*^9, {
   3.81566425126334*^9, 3.815664269046691*^9}, 3.815664648394862*^9, 
   3.815664856154194*^9, 3.816462970728364*^9, 3.816463080802454*^9, 
   3.816463294895287*^9, {3.816463476062026*^9, 3.8164634809733353`*^9}, {
   3.816463524988563*^9, 3.816463536209791*^9}, {3.8164637452685547`*^9, 
   3.816463766373105*^9}, 3.8164638948750067`*^9, {3.816463930445312*^9, 
   3.816463949875998*^9}, 3.816464044364971*^9, 3.816464429468474*^9, {
   3.816464715581526*^9, 3.8164647356303997`*^9}, 3.816465384862759*^9, 
   3.816466175149794*^9, 3.816466351169098*^9, 3.816467417415003*^9, {
   3.8164674585103083`*^9, 3.816467479333193*^9}, 3.8164675464074173`*^9, 
   3.8164678988429613`*^9, {3.8165148361947403`*^9, 3.816514863425167*^9}, 
   3.8165155900391207`*^9, 3.8165157345717297`*^9, {3.8165158975265627`*^9, 
   3.81651592294133*^9}, 3.816518690649674*^9, 3.816518762924447*^9, 
   3.816531949781299*^9, 3.8165347982278757`*^9, 3.81653494950203*^9, 
   3.8165367555069647`*^9, 3.816549555993355*^9, 3.816554534738628*^9, 
   3.81720186693859*^9, 3.817203678748114*^9, 3.817203711122027*^9, 
   3.8172042694425783`*^9, 3.817204638542727*^9, {3.817204908119493*^9, 
   3.817204933076929*^9}, 3.817219785810746*^9, {3.817379906747785*^9, 
   3.817379962360981*^9}, 3.817380062024741*^9, {3.817380158665976*^9, 
   3.8173801849019003`*^9}, 3.817381365005926*^9, 3.8173846635439777`*^9, 
   3.8173847339234247`*^9, 3.817384786978799*^9, 3.817387747669712*^9, 
   3.817390044557222*^9, 3.817390244907435*^9, 3.817390391392181*^9, 
   3.81739058160493*^9, 3.817391611239596*^9, 3.81739210250627*^9, 
   3.817478213220179*^9, 3.850308475021591*^9, 3.850308890452951*^9, 
   3.8503103972293997`*^9, 3.850310485563078*^9, 3.850311002582596*^9, 
   3.850311418256613*^9, {3.85031152095544*^9, 3.850311560943492*^9}, 
   3.850312153830852*^9, 3.850312337460504*^9, 3.8503124183587933`*^9, {
   3.8503125138179607`*^9, 3.850312541234692*^9}, 3.8503162402617693`*^9, 
   3.85040024235036*^9, 3.850401806715081*^9, 3.850402193993841*^9, 
   3.850403744274446*^9, 3.850410620984145*^9, 3.8504762712545843`*^9, 
   3.8504763416803627`*^9, {3.850580785617324*^9, 3.850580800530572*^9}, 
   3.850649766095439*^9, 3.850757196187806*^9, 3.850759467949597*^9, 
   3.8512567127464113`*^9, 3.851256764303916*^9, 3.8512579470061274`*^9, 
   3.85126012164349*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"bf20de7c-1b0c-4d50-abc3-a912170948db"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Find", " ", "the", " ", "slopes", " ", "of", " ", "the", " ", 
    "diagonals"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{
    RowBox[{"slopeFH", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sH", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "-", 
        RowBox[{"sF", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sH", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "-", 
        RowBox[{"sF", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopeGI", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sG", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "-", 
        RowBox[{"sI", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sG", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "-", 
        RowBox[{"sI", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"productOfSlopes", "=", 
     RowBox[{"slopeFH", "*", "slopeGI"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.850322639228096*^9, 3.850322697840695*^9}, {
  3.850322856962872*^9, 3.8503228590574636`*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"5dd6f535-967b-487b-9db9-cd62760a2753"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Note", " ", "that", " ", "the", " ", "central", " ", "quadrilateral", " ",
     "is", " ", "not", " ", "necessarily", " ", "orthodiagonal"}], " ", 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"numericProductOfSlopes", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"productOfSlopes", "/.", 
        RowBox[{"f", "->", "figF"}]}], "/.", "figCoords"}], "//", "N"}]}], 
    ";"}], "\[IndentingNewLine]", "numericProductOfSlopes"}]}]], "Input",
 CellChangeTimes->{{3.8503218384065027`*^9, 3.850321896488906*^9}, {
   3.850322408809058*^9, 3.850322432959783*^9}, {3.850322773434289*^9, 
   3.8503227935534153`*^9}, {3.850322829826659*^9, 3.850322830625092*^9}, {
   3.8503228710748*^9, 3.8503228844986687`*^9}, {3.850322965250971*^9, 
   3.850323001754963*^9}, {3.85040951389107*^9, 3.850409524286318*^9}, 
   3.8504756437292967`*^9, 3.850476435694084*^9, 3.8504764701292353`*^9},
 CellLabel->"In[55]:=",ExpressionUUID->"a9cd24ac-33fd-46d5-aead-445dd7e49a43"],

Cell[BoxData[
 RowBox[{"-", "1.1372159953854875`"}]], "Output",
 CellChangeTimes->{
  3.85032288551582*^9, {3.850322998672515*^9, 3.8503230028240223`*^9}, 
   3.850331289827099*^9, 3.850367476685074*^9, 3.8503735676391172`*^9, 
   3.85038287668193*^9, 3.8503919802323713`*^9, 3.850402043284421*^9, 
   3.8504021166287317`*^9, 3.850402194142832*^9, 3.850403840290118*^9, 
   3.850409471662073*^9, {3.8504095150082693`*^9, 3.850409525465934*^9}, 
   3.850409669007843*^9, 3.850409835986038*^9, 3.850409943327735*^9, 
   3.850410147185019*^9, 3.850410178152935*^9, 3.850410251624864*^9, 
   3.850410331264875*^9, {3.850410390523424*^9, 3.850410419168539*^9}, 
   3.8504105289529953`*^9, 3.8504106211287622`*^9, 3.850476400950192*^9, 
   3.850476471001485*^9, 3.850580812326132*^9, 3.8506497661101227`*^9, 
   3.850757196288055*^9, 3.850759467963777*^9, 3.851256712778921*^9, 
   3.8512567643357267`*^9, 3.851257947056797*^9, 3.851260121673958*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"366f7f7d-0d51-48e0-80c0-181bdab79b1d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Theorem 5.15: center function Cos[B]Cos[C]+k Cos[A] implies FGHI is \
orthodiagonal\
\>", "Section",
 CellChangeTimes->{{3.851257617085289*^9, 3.851257643876066*^9}, 
   3.85125777766862*^9, {3.851259735692519*^9, 
   3.851259763583303*^9}},ExpressionUUID->"0f0ef62d-c66b-480e-9286-\
bd25211831af"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"abcFn", "=", 
  RowBox[{"convertToABC", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "B", "]"}], 
     RowBox[{"Cos", "[", "C", "]"}]}], "+", 
    RowBox[{"k", " ", 
     RowBox[{"Cos", "[", "A", "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8512600000789623`*^9, 3.8512600061655293`*^9}, {
  3.851260041582959*^9, 3.851260054901395*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"73fd5c51-061b-496c-ba28-ac4405cbd368"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
   RowBox[{
    SuperscriptBox["a", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2", " ", "k"}]}], ")"}]}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}], " ", "k"}]}], 
  RowBox[{"4", " ", 
   SuperscriptBox["a", "2"], " ", "b", " ", "c"}]]], "Output",
 CellChangeTimes->{
  3.851259768626322*^9, 3.851260009122427*^9, {3.8512600421678333`*^9, 
   3.851260056097581*^9}, 3.851260121703479*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"25ef5d72-5f8a-45a3-9ac9-e1e79dc91e68"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"abcFn", "=", 
  RowBox[{"abcFn", "*", "4", "*", 
   RowBox[{"a", "^", "2"}], "*", 
   RowBox[{"b", "^", "2"}], "*", 
   RowBox[{"c", "^", "2"}]}]}]], "Input",
 CellChangeTimes->{{3.85126001575878*^9, 3.85126002507727*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"419ff430-3d19-46fb-963c-0707d8577630"],

Cell[BoxData[
 RowBox[{"b", " ", "c", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "k"}]}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}], " ", "k"}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.851259791047043*^9, {3.851260026072147*^9, 3.851260059278578*^9}, 
   3.851260121710026*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"4358ce75-f80f-46b8-9ae0-d0dcdd2b3de1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"givenF3", "=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "->", "abcFn"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{"productOfSlopes", "/.", "givenF3"}], "]"}]}], "Input",
 CellLabel->"In[59]:=",ExpressionUUID->"6fe1a0ca-a7fa-4e7a-bbec-58f3a9895e10"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellChangeTimes->{
  3.851259819841763*^9, {3.851260033913292*^9, 3.851260063473386*^9}, 
   3.8512601218862057`*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"78492d4c-d533-44d0-bd34-682c205663ec"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Theorem 5.19: center function (b+c)/a+k implies FGHI is orthodiagonal\
\>", "Section",
 CellChangeTimes->{{3.850367720388095*^9, 3.8503677251030617`*^9}, {
  3.8503677897854433`*^9, 3.850367862617402*^9}, {3.8504023111196527`*^9, 
  3.8504023133991833`*^9}, {3.851257547740082*^9, 
  3.851257577652051*^9}},ExpressionUUID->"505d4006-5ae1-49ef-9d54-\
ffcc4e938306"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Now", " ", "use", " ", "the", " ", "given", " ", "condition", " ", "as", 
    " ", "the", " ", "center", " ", "function"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"givenF1", "=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], "/", "a"}], "+", "k"}]}]}]}]], "Input",\

 CellChangeTimes->{{3.81720506346701*^9, 3.8172051253142433`*^9}, {
   3.8172051768348513`*^9, 3.817205193314537*^9}, {3.8172053727563887`*^9, 
   3.817205382059059*^9}, {3.8173808592948647`*^9, 3.81738086541411*^9}, {
   3.8173920548160343`*^9, 3.817392059696986*^9}, {3.817392238819682*^9, 
   3.817392245881591*^9}, {3.817392386027884*^9, 3.817392387369844*^9}, {
   3.81747843608337*^9, 3.817478439745685*^9}, {3.8174785936456537`*^9, 
   3.81747859787539*^9}, 3.8504025457537003`*^9},
 CellLabel->"In[61]:=",ExpressionUUID->"be4741a9-f594-45ec-9201-c43bd1ff8c41"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "\[RuleDelayed]", 
  RowBox[{
   FractionBox[
    RowBox[{"b", "+", "c"}], "a"], "+", "k"}]}]], "Output",
 CellChangeTimes->{
  3.817205383121191*^9, 3.817219786200631*^9, 3.817380869122233*^9, 
   3.817384663971994*^9, 3.817384734121406*^9, 3.817384787266623*^9, 
   3.817387747995879*^9, 3.8173900449395847`*^9, 3.817390245225836*^9, 
   3.817390391705298*^9, 3.817390581914713*^9, 3.817391611562098*^9, 
   3.817392102782095*^9, 3.817392247487204*^9, 3.817392389368908*^9, 
   3.817478213680212*^9, 3.817478441299059*^9, 3.817478598395262*^9, 
   3.85030905924467*^9, 3.850309843596888*^9, 3.850310397494874*^9, 
   3.850310485872279*^9, 3.850311921998684*^9, 3.850312154197091*^9, 
   3.850312337738441*^9, 3.8503124186702337`*^9, {3.850312514119074*^9, 
   3.850312541619026*^9}, 3.85031624068705*^9, 3.8504002426681347`*^9, 
   3.8504021942421007`*^9, 3.850402340821672*^9, 3.8504025516792097`*^9, 
   3.850404366434116*^9, 3.850410621224955*^9, 3.850476979080327*^9, 
   3.850580839383409*^9, 3.850649766119021*^9, 3.850757196327014*^9, 
   3.8507594679702682`*^9, 3.851256712786151*^9, 3.851256764342042*^9, 
   3.85125794706594*^9, 3.8512601219330053`*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"47325a71-12a0-4ede-aae2-2e6c5b657fd7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "FGHI", " ", "is", " ", "orthodiagonal", " ", "if", " ", "the", " ", 
     "product", " ", "of", " ", "the", " ", "slopes", " ", "of", " ", "FH", 
     " ", "and", " ", "GI", " ", "is"}], " ", "-", "1"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"symbolicProductOfSlopes", "=", 
     RowBox[{"productOfSlopes", "/.", "givenF1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", "symbolicProductOfSlopes", "]"}]}]}]], "Input",
 CellChangeTimes->{3.850402429528145*^9, 3.850402547953463*^9},
 CellLabel->"In[62]:=",ExpressionUUID->"70447667-a813-4eba-a6f7-bec7715346b9"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellChangeTimes->{3.8504024326120768`*^9, 3.850402554676573*^9, 
  3.8504043826264887`*^9, 3.850410621336453*^9, 3.85047698569486*^9, 
  3.850580841993114*^9, 3.8506497662180977`*^9, 3.8507571964355164`*^9, 
  3.8507594680624638`*^9, 3.851256712883678*^9, 3.851256764424074*^9, 
  3.851257947158071*^9, 3.851260122035345*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"41a06881-8451-4ab9-b83f-027e90f885b3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Draw", " ", "a", " ", "figure", " ", "illustrating", " ", "the", " ", 
    "situation"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{
    RowBox[{"quadrilateral", "=", 
     RowBox[{"{", 
      RowBox[{"Thick", ",", 
       RowBox[{"AbsolutePointSize", "[", "6", "]"}], ",", 
       "\[IndentingNewLine]", "Black", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Pa", ",", "Pb"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pb", ",", "Pc"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pc", ",", "Pd"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pd", ",", "Pa"}], "}"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", "Red", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Pa", ",", "Pc"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pb", ",", "Pd"}], "}"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", "Black", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"Pa", ",", "Pb", ",", "Pc", ",", "Pd"}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", "Red", ",", 
       RowBox[{"Point", "[", "Pe", "]"}], ",", "\[IndentingNewLine]", "Black",
        ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<A\>\"", ",", "Pa", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<B\>\"", ",", "Pb", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<C\>\"", ",", "Pc", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<D\>\"", ",", "Pd", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<E\>\"", ",", "Pe", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]}], 
      "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"figK", "=", "4"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"quad", "=", 
     RowBox[{
      RowBox[{"Graphics", "[", "quadrilateral", "]"}], "/.", "figCoords"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pF", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"sF", "/.", "givenF1"}], "/.", "figCoords"}], "/.", 
      RowBox[{"k", "\[Rule]", "figK"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pG", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"sG", "/.", "givenF1"}], "/.", "figCoords"}], "/.", 
      RowBox[{"k", "\[Rule]", "figK"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"sH", "/.", "givenF1"}], "/.", "figCoords"}], "/.", 
      RowBox[{"k", "\[Rule]", "figK"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pI", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"sI", "/.", "givenF1"}], "/.", "figCoords"}], "/.", 
      RowBox[{"k", "\[Rule]", "figK"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"points", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"pF", ",", "pG", ",", "pH", ",", "pI"}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<F\>\"", ",", "pF", ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "0"}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<G\>\"", ",", "pG", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1.5"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<H\>\"", ",", "pH", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "0"}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<I\>\"", ",", "pI", ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "0"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
       "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lines", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"Blue", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"pF", ",", "pG"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pH", ",", "pI"}], "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", "Green", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"pF", ",", "pI"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pG", ",", "pH"}], "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", "Red", ",", "Dashed", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"pF", ",", "pH"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pG", ",", "pI"}], "}"}]}], "}"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"quad", ",", "points", ",", "lines"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.817206626685647*^9, 3.817206657965901*^9}, {
   3.8172067076555023`*^9, 3.817206725213376*^9}, {3.817210929752697*^9, 
   3.817210934415297*^9}, {3.817381852322447*^9, 3.81738186680901*^9}, {
   3.817381928234779*^9, 3.817381938521343*^9}, {3.8174783684371023`*^9, 
   3.8174783818993893`*^9}, {3.8504024806421127`*^9, 3.850402493744297*^9}, {
   3.850402571741178*^9, 3.8504025741287527`*^9}, {3.8504044491129827`*^9, 
   3.850404455918991*^9}, {3.850475661866561*^9, 3.8504756716728697`*^9}, 
   3.8504770147022133`*^9, {3.850477114455222*^9, 3.850477118886238*^9}, {
   3.850477213369287*^9, 3.8504772168631372`*^9}, {3.850477264144039*^9, 
   3.8504773165997972`*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"7cd079cd-9a54-4708-96e7-8cbae0795f61"],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsolutePointSize[6], Thickness[Large], 
    LineBox[NCache[{{{1 - 2 5^Rational[1, 2], 0}, {-1, -2}}, {{-1, -2}, {1, 
       0}}, {{1, 0}, {1, 
       2}}, {{1, 2}, {
        1 - 2 5^Rational[1, 2], 0}}}, {{{-3.4721359549995796`, 
         0}, {-1, -2}}, {{-1, -2}, {1, 0}}, {{1, 0}, {1, 
       2}}, {{1, 2}, {-3.4721359549995796`, 0}}}]], 
    {RGBColor[1, 0, 0], 
     LineBox[NCache[{{{1 - 2 5^Rational[1, 2], 0}, {1, 0}}, {{-1, -2}, {1, 
        2}}}, {{{-3.4721359549995796`, 0}, {1, 0}}, {{-1, -2}, {1, 2}}}]]}, 
    {GrayLevel[0], 
     PointBox[NCache[{{1 - 2 5^Rational[1, 2], 0}, {-1, -2}, {1, 0}, {1, 
        2}}, {{-3.4721359549995796`, 0}, {-1, -2}, {1, 0}, {1, 2}}]]}, 
    {RGBColor[1, 0, 0], PointBox[{0, 0}]}, 
    {GrayLevel[0], 
     InsetBox["\<\"A\"\>", 
      NCache[{1 - 2 5^Rational[1, 2], 0}, {-3.4721359549995796`, 
        0}], {2, -1}], InsetBox["\<\"B\"\>", {-1, -2}, {2, 2}], 
     InsetBox["\<\"C\"\>", {1, 0}, {-2, 2}], 
     InsetBox["\<\"D\"\>", {1, 2}, {-3, -1}], 
     InsetBox["\<\"E\"\>", {0, 0}, {-1, 2}]}}, {
    PointBox[NCache[{{((4 + (-2 + 2 5^Rational[1, 2])^2)^Rational[1, 2] (
            4 + (-1 + 3 5^Rational[1, 2]) (4 + (-2 + 2 5^Rational[1, 2])^2)^
              Rational[-1, 2]) + (-1 + 2 5^Rational[1, 2]) (
            4 + (-1 + 2 5^Rational[1, 2])^(-1) (
              5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
               Rational[1, 2])) + 
          5^Rational[1, 2] (4 + 
            5^Rational[-1, 2] (-1 + 
              2 5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
               Rational[1, 2])))^(-1) (-(-1 + 2 5^Rational[1, 2]) (
           4 + (-1 + 2 5^Rational[1, 2])^(-1) (
             5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
              Rational[1, 2])) + 
         5^Rational[1, 2] (1 - 2 5^Rational[1, 2]) (4 + 
           5^Rational[-1, 2] (-1 + 
             2 5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
              Rational[1, 2]))), (-2) (-1 + 2 5^Rational[1, 2]) (
         4 + (-1 + 2 5^Rational[1, 2])^(-1) (
           5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
            Rational[1, 2]))/((4 + (-2 + 2 5^Rational[1, 2])^2)^
          Rational[1, 2] (
          4 + (-1 + 3 5^Rational[1, 2]) (4 + (-2 + 2 5^Rational[1, 2])^2)^
            Rational[-1, 2]) + (-1 + 2 5^Rational[1, 2]) (
          4 + (-1 + 2 5^Rational[1, 2])^(-1) (
            5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
             Rational[1, 2])) + 
        5^Rational[1, 2] (4 + 
          5^Rational[-1, 2] (-1 + 
            2 5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
             Rational[1, 2])))}, {(-4 - 2 2^Rational[1, 2] - 5^Rational[1, 2] + 
         5^Rational[1, 2] (4 + 5^Rational[-1, 2] (1 + 2 2^Rational[1, 2])))/(
        4 + 2 2^Rational[1, 2] + 5^Rational[1, 2] + 
        5^Rational[1, 2] (4 + 5^Rational[-1, 2] (1 + 2 2^Rational[1, 2])) + 
        2 2^Rational[1, 2] (4 + 
          Rational[1, 2] 2^Rational[-1, 2] (1 + 5^Rational[1, 2]))), (-2) (4 + 
         2 2^Rational[1, 2] + 5^Rational[1, 2])/(4 + 2 2^Rational[1, 2] + 
        5^Rational[1, 2] + 
        5^Rational[1, 2] (4 + 5^Rational[-1, 2] (1 + 2 2^Rational[1, 2])) + 
        2 2^Rational[1, 2] (4 + 
          Rational[1, 2] 2^Rational[-1, 2] (1 + 5^Rational[1, 2])))}, {(6 + 
         5^Rational[1, 2] + 5^Rational[1, 2] (4 + 3 5^Rational[-1, 2]))/(6 + 
        5^Rational[1, 2] + 5^Rational[1, 2] (4 + 3 5^Rational[-1, 2]) + 
        2 (4 + Rational[1, 2] (1 + 5^Rational[1, 2]))), 
        2 (6 + 5^Rational[1, 2])/(6 + 5^Rational[1, 2] + 
        5^Rational[1, 2] (4 + 3 5^Rational[-1, 2]) + 
        2 (4 + Rational[1, 2] (1 + 5^Rational[1, 2])))}, {(
          2 6^Rational[1, 2] (4 + 
            Rational[1, 2] 6^Rational[-1, 2] (-1 + 3 5^Rational[1, 2])) + (-1 + 
            2 5^Rational[1, 2]) (
            4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
              2 6^Rational[1, 2])) + 
          5^Rational[1, 2] (4 + 
            5^Rational[-1, 2] (-1 + 2 5^Rational[1, 2] + 
              2 6^Rational[1, 2])))^(-1) ((-1 + 2 5^Rational[1, 2]) (
           4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
             2 6^Rational[1, 2])) + 
         5^Rational[1, 2] (1 - 2 5^Rational[1, 2]) (4 + 
           5^Rational[-1, 2] (-1 + 2 5^Rational[1, 2] + 2 6^Rational[1, 2]))),
         2 (-1 + 2 5^Rational[1, 2]) (
         4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
           2 6^Rational[1, 2]))/(
        2 6^Rational[1, 2] (4 + 
          Rational[1, 2] 6^Rational[-1, 2] (-1 + 3 5^Rational[1, 2])) + (-1 + 
          2 5^Rational[1, 2]) (
          4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
            2 6^Rational[1, 2])) + 
        5^Rational[1, 2] (4 + 
          5^Rational[-1, 2] (-1 + 2 5^Rational[1, 2] + 
            2 6^Rational[
               1, 2])))}}, {{-1.3774440763331732`, -0.7239852530260705}, {
      0.1019102131883999, -0.49822752207291215`}, {0.6423503277082808, 
      0.5243163389583859}, {-0.6143287708998498, 0.6606714982495709}}]], 
    InsetBox["\<\"F\"\>", 
     NCache[{((4 + (-2 + 2 5^Rational[1, 2])^2)^Rational[1, 2] (
           4 + (-1 + 3 5^Rational[1, 2]) (4 + (-2 + 2 5^Rational[1, 2])^2)^
             Rational[-1, 2]) + (-1 + 2 5^Rational[1, 2]) (
           4 + (-1 + 2 5^Rational[1, 2])^(-1) (
             5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
              Rational[1, 2])) + 
         5^Rational[1, 2] (4 + 
           5^Rational[-1, 2] (-1 + 
             2 5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
              Rational[1, 2])))^(-1) (-(-1 + 2 5^Rational[1, 2]) (
          4 + (-1 + 2 5^Rational[1, 2])^(-1) (
            5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
             Rational[1, 2])) + 
        5^Rational[1, 2] (1 - 2 5^Rational[1, 2]) (4 + 
          5^Rational[-1, 2] (-1 + 
            2 5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
             Rational[1, 2]))), (-2) (-1 + 2 5^Rational[1, 2]) (
        4 + (-1 + 2 5^Rational[1, 2])^(-1) (
          5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
           Rational[1, 2]))/((4 + (-2 + 2 5^Rational[1, 2])^2)^
         Rational[1, 2] (
         4 + (-1 + 3 5^Rational[1, 2]) (4 + (-2 + 2 5^Rational[1, 2])^2)^
           Rational[-1, 2]) + (-1 + 2 5^Rational[1, 2]) (
         4 + (-1 + 2 5^Rational[1, 2])^(-1) (
           5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
            Rational[1, 2])) + 
       5^Rational[1, 2] (4 + 
         5^Rational[-1, 2] (-1 + 
           2 5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
            Rational[
             1, 2])))}, {-1.3774440763331732`, -0.7239852530260705}], {2, 0}],
     InsetBox["\<\"G\"\>", 
     NCache[{(-4 - 2 2^Rational[1, 2] - 5^Rational[1, 2] + 
        5^Rational[1, 2] (4 + 5^Rational[-1, 2] (1 + 2 2^Rational[1, 2])))/(4 + 
       2 2^Rational[1, 2] + 5^Rational[1, 2] + 
       5^Rational[1, 2] (4 + 5^Rational[-1, 2] (1 + 2 2^Rational[1, 2])) + 
       2 2^Rational[1, 2] (4 + 
         Rational[1, 2] 2^Rational[-1, 2] (1 + 5^Rational[1, 2]))), (-2) (4 + 
        2 2^Rational[1, 2] + 5^Rational[1, 2])/(4 + 2 2^Rational[1, 2] + 
       5^Rational[1, 2] + 
       5^Rational[1, 2] (4 + 5^Rational[-1, 2] (1 + 2 2^Rational[1, 2])) + 
       2 2^Rational[1, 2] (4 + 
         Rational[1, 2] 2^Rational[-1, 2] (1 + 5^Rational[1, 2])))}, {
      0.1019102131883999, -0.49822752207291215`}], {0, 1.5}], 
    InsetBox["\<\"H\"\>", 
     NCache[{(6 + 5^Rational[1, 2] + 
        5^Rational[1, 2] (4 + 3 5^Rational[-1, 2]))/(6 + 5^Rational[1, 2] + 
       5^Rational[1, 2] (4 + 3 5^Rational[-1, 2]) + 
       2 (4 + Rational[1, 2] (1 + 5^Rational[1, 2]))), 
       2 (6 + 5^Rational[1, 2])/(6 + 5^Rational[1, 2] + 
       5^Rational[1, 2] (4 + 3 5^Rational[-1, 2]) + 
       2 (4 + Rational[1, 2] (1 + 5^Rational[1, 2])))}, {0.6423503277082808, 
      0.5243163389583859}], {-4, 0}], 
    InsetBox["\<\"I\"\>", 
     NCache[{(2 
          6^Rational[1, 2] (4 + 
           Rational[1, 2] 6^Rational[-1, 2] (-1 + 3 5^Rational[1, 2])) + (-1 + 
           2 5^Rational[1, 2]) (
           4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
             2 6^Rational[1, 2])) + 
         5^Rational[1, 2] (4 + 
           5^Rational[-1, 2] (-1 + 2 5^Rational[1, 2] + 
             2 6^Rational[1, 2])))^(-1) ((-1 + 2 5^Rational[1, 2]) (
          4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
            2 6^Rational[1, 2])) + 
        5^Rational[1, 2] (1 - 2 5^Rational[1, 2]) (4 + 
          5^Rational[-1, 2] (-1 + 2 5^Rational[1, 2] + 2 6^Rational[1, 2]))), 
       2 (-1 + 2 5^Rational[1, 2]) (
        4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
          2 6^Rational[1, 2]))/(
       2 6^Rational[1, 2] (4 + 
         Rational[1, 2] 6^Rational[-1, 2] (-1 + 3 5^Rational[1, 2])) + (-1 + 
         2 5^Rational[1, 2]) (
         4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
           2 6^Rational[1, 2])) + 
       5^Rational[1, 2] (4 + 
         5^Rational[-1, 2] (-1 + 2 5^Rational[1, 2] + 
           2 6^Rational[1, 2])))}, {-0.6143287708998498, 
      0.6606714982495709}], {4, 0}]}, {
    {RGBColor[0, 0, 1], 
     LineBox[NCache[{{{((4 + (-2 + 2 5^Rational[1, 2])^2)^Rational[1, 2] (
              4 + (-1 + 3 5^Rational[1, 2]) (4 + (-2 + 2 5^Rational[1, 2])^2)^
                Rational[-1, 2]) + (-1 + 2 5^Rational[1, 2]) (
              4 + (-1 + 2 5^Rational[1, 2])^(-1) (
                5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
                 Rational[1, 2])) + 
            5^Rational[1, 2] (4 + 
              5^Rational[-1, 2] (-1 + 
                2 5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
                 Rational[1, 2])))^(-1) (-(-1 + 2 5^Rational[1, 2]) (
             4 + (-1 + 2 5^Rational[1, 2])^(-1) (
               5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
                Rational[1, 2])) + 
           5^Rational[1, 2] (1 - 2 5^Rational[1, 2]) (4 + 
             5^Rational[-1, 2] (-1 + 
               2 5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
                Rational[1, 2]))), (-2) (-1 + 2 5^Rational[1, 2]) (
           4 + (-1 + 2 5^Rational[1, 2])^(-1) (
             5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
              Rational[1, 2]))/((4 + (-2 + 2 5^Rational[1, 2])^2)^
            Rational[1, 2] (
            4 + (-1 + 3 5^Rational[1, 2]) (4 + (-2 + 2 5^Rational[1, 2])^2)^
              Rational[-1, 2]) + (-1 + 2 5^Rational[1, 2]) (
            4 + (-1 + 2 5^Rational[1, 2])^(-1) (
              5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
               Rational[1, 2])) + 
          5^Rational[1, 2] (4 + 
            5^Rational[-1, 2] (-1 + 
              2 5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
               Rational[1, 2])))}, {(-4 - 2 2^Rational[1, 2] - 5^
           Rational[1, 2] + 
           5^Rational[1, 2] (4 + 
             5^Rational[-1, 2] (1 + 2 2^Rational[1, 2])))/(4 + 
          2 2^Rational[1, 2] + 5^Rational[1, 2] + 
          5^Rational[1, 2] (4 + 5^Rational[-1, 2] (1 + 2 2^Rational[1, 2])) + 
          2 2^Rational[1, 2] (4 + 
            Rational[1, 2] 2^Rational[-1, 2] (1 + 5^Rational[1, 2]))), (-2) (
           4 + 2 2^Rational[1, 2] + 5^Rational[1, 2])/(4 + 2 2^Rational[1, 2] + 
          5^Rational[1, 2] + 
          5^Rational[1, 2] (4 + 5^Rational[-1, 2] (1 + 2 2^Rational[1, 2])) + 
          2 2^Rational[1, 2] (4 + 
            Rational[1, 2] 2^Rational[-1, 2] (1 + 5^Rational[1, 2])))}}, {{(6 + 
           5^Rational[1, 2] + 5^Rational[1, 2] (4 + 3 5^Rational[-1, 2]))/(6 + 
          5^Rational[1, 2] + 5^Rational[1, 2] (4 + 3 5^Rational[-1, 2]) + 
          2 (4 + Rational[1, 2] (1 + 5^Rational[1, 2]))), 
          2 (6 + 5^Rational[1, 2])/(6 + 5^Rational[1, 2] + 
          5^Rational[1, 2] (4 + 3 5^Rational[-1, 2]) + 
          2 (4 + Rational[1, 2] (1 + 5^Rational[1, 2])))}, {(
            2 6^Rational[1, 2] (4 + 
              Rational[1, 2] 
               6^Rational[-1, 2] (-1 + 3 5^Rational[1, 2])) + (-1 + 
              2 5^Rational[1, 2]) (
              4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
                2 6^Rational[1, 2])) + 
            5^Rational[1, 2] (4 + 
              5^Rational[-1, 2] (-1 + 2 5^Rational[1, 2] + 
                2 6^Rational[1, 2])))^(-1) ((-1 + 2 5^Rational[1, 2]) (
             4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
               2 6^Rational[1, 2])) + 
           5^Rational[1, 2] (1 - 2 5^Rational[1, 2]) (4 + 
             5^Rational[-1, 2] (-1 + 2 5^Rational[1, 2] + 
               2 6^Rational[1, 2]))), 
          2 (-1 + 2 5^Rational[1, 2]) (
           4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
             2 6^Rational[1, 2]))/(
          2 6^Rational[1, 2] (4 + 
            Rational[1, 2] 6^Rational[-1, 2] (-1 + 3 5^Rational[1, 2])) + (-1 + 
            2 5^Rational[1, 2]) (
            4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
              2 6^Rational[1, 2])) + 
          5^Rational[1, 2] (4 + 
            5^Rational[-1, 2] (-1 + 2 5^Rational[1, 2] + 
              2 6^Rational[
                 1, 2])))}}}, {{{-1.3774440763331732`, -0.7239852530260705}, {
       0.1019102131883999, -0.49822752207291215`}}, {{0.6423503277082808, 
       0.5243163389583859}, {-0.6143287708998498, 0.6606714982495709}}}]]}, 
    {RGBColor[0, 1, 0], 
     LineBox[NCache[{{{((4 + (-2 + 2 5^Rational[1, 2])^2)^Rational[1, 2] (
              4 + (-1 + 3 5^Rational[1, 2]) (4 + (-2 + 2 5^Rational[1, 2])^2)^
                Rational[-1, 2]) + (-1 + 2 5^Rational[1, 2]) (
              4 + (-1 + 2 5^Rational[1, 2])^(-1) (
                5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
                 Rational[1, 2])) + 
            5^Rational[1, 2] (4 + 
              5^Rational[-1, 2] (-1 + 
                2 5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
                 Rational[1, 2])))^(-1) (-(-1 + 2 5^Rational[1, 2]) (
             4 + (-1 + 2 5^Rational[1, 2])^(-1) (
               5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
                Rational[1, 2])) + 
           5^Rational[1, 2] (1 - 2 5^Rational[1, 2]) (4 + 
             5^Rational[-1, 2] (-1 + 
               2 5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
                Rational[1, 2]))), (-2) (-1 + 2 5^Rational[1, 2]) (
           4 + (-1 + 2 5^Rational[1, 2])^(-1) (
             5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
              Rational[1, 2]))/((4 + (-2 + 2 5^Rational[1, 2])^2)^
            Rational[1, 2] (
            4 + (-1 + 3 5^Rational[1, 2]) (4 + (-2 + 2 5^Rational[1, 2])^2)^
              Rational[-1, 2]) + (-1 + 2 5^Rational[1, 2]) (
            4 + (-1 + 2 5^Rational[1, 2])^(-1) (
              5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
               Rational[1, 2])) + 
          5^Rational[1, 2] (4 + 
            5^Rational[-1, 2] (-1 + 
              2 5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
               Rational[1, 2])))}, {(
            2 6^Rational[1, 2] (4 + 
              Rational[1, 2] 
               6^Rational[-1, 2] (-1 + 3 5^Rational[1, 2])) + (-1 + 
              2 5^Rational[1, 2]) (
              4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
                2 6^Rational[1, 2])) + 
            5^Rational[1, 2] (4 + 
              5^Rational[-1, 2] (-1 + 2 5^Rational[1, 2] + 
                2 6^Rational[1, 2])))^(-1) ((-1 + 2 5^Rational[1, 2]) (
             4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
               2 6^Rational[1, 2])) + 
           5^Rational[1, 2] (1 - 2 5^Rational[1, 2]) (4 + 
             5^Rational[-1, 2] (-1 + 2 5^Rational[1, 2] + 
               2 6^Rational[1, 2]))), 
          2 (-1 + 2 5^Rational[1, 2]) (
           4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
             2 6^Rational[1, 2]))/(
          2 6^Rational[1, 2] (4 + 
            Rational[1, 2] 6^Rational[-1, 2] (-1 + 3 5^Rational[1, 2])) + (-1 + 
            2 5^Rational[1, 2]) (
            4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
              2 6^Rational[1, 2])) + 
          5^Rational[1, 2] (4 + 
            5^Rational[-1, 2] (-1 + 2 5^Rational[1, 2] + 
              2 6^Rational[1, 2])))}}, {{(-4 - 2 2^Rational[1, 2] - 5^
           Rational[1, 2] + 
           5^Rational[1, 2] (4 + 
             5^Rational[-1, 2] (1 + 2 2^Rational[1, 2])))/(4 + 
          2 2^Rational[1, 2] + 5^Rational[1, 2] + 
          5^Rational[1, 2] (4 + 5^Rational[-1, 2] (1 + 2 2^Rational[1, 2])) + 
          2 2^Rational[1, 2] (4 + 
            Rational[1, 2] 2^Rational[-1, 2] (1 + 5^Rational[1, 2]))), (-2) (
           4 + 2 2^Rational[1, 2] + 5^Rational[1, 2])/(4 + 2 2^Rational[1, 2] + 
          5^Rational[1, 2] + 
          5^Rational[1, 2] (4 + 5^Rational[-1, 2] (1 + 2 2^Rational[1, 2])) + 
          2 2^Rational[1, 2] (4 + 
            Rational[1, 2] 2^Rational[-1, 2] (1 + 5^Rational[1, 2])))}, {(6 + 
           5^Rational[1, 2] + 5^Rational[1, 2] (4 + 3 5^Rational[-1, 2]))/(6 + 
          5^Rational[1, 2] + 5^Rational[1, 2] (4 + 3 5^Rational[-1, 2]) + 
          2 (4 + Rational[1, 2] (1 + 5^Rational[1, 2]))), 
          2 (6 + 5^Rational[1, 2])/(6 + 5^Rational[1, 2] + 
          5^Rational[1, 2] (4 + 3 5^Rational[-1, 2]) + 
          2 (4 + Rational[1, 2] (1 + 
              5^Rational[
                1, 2])))}}}, {{{-1.3774440763331732`, -0.7239852530260705}, \
{-0.6143287708998498, 0.6606714982495709}}, {{
       0.1019102131883999, -0.49822752207291215`}, {0.6423503277082808, 
       0.5243163389583859}}}]]}, 
    {RGBColor[1, 0, 0], Dashing[{Small, Small}], 
     LineBox[NCache[{{{((4 + (-2 + 2 5^Rational[1, 2])^2)^Rational[1, 2] (
              4 + (-1 + 3 5^Rational[1, 2]) (4 + (-2 + 2 5^Rational[1, 2])^2)^
                Rational[-1, 2]) + (-1 + 2 5^Rational[1, 2]) (
              4 + (-1 + 2 5^Rational[1, 2])^(-1) (
                5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
                 Rational[1, 2])) + 
            5^Rational[1, 2] (4 + 
              5^Rational[-1, 2] (-1 + 
                2 5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
                 Rational[1, 2])))^(-1) (-(-1 + 2 5^Rational[1, 2]) (
             4 + (-1 + 2 5^Rational[1, 2])^(-1) (
               5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
                Rational[1, 2])) + 
           5^Rational[1, 2] (1 - 2 5^Rational[1, 2]) (4 + 
             5^Rational[-1, 2] (-1 + 
               2 5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
                Rational[1, 2]))), (-2) (-1 + 2 5^Rational[1, 2]) (
           4 + (-1 + 2 5^Rational[1, 2])^(-1) (
             5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
              Rational[1, 2]))/((4 + (-2 + 2 5^Rational[1, 2])^2)^
            Rational[1, 2] (
            4 + (-1 + 3 5^Rational[1, 2]) (4 + (-2 + 2 5^Rational[1, 2])^2)^
              Rational[-1, 2]) + (-1 + 2 5^Rational[1, 2]) (
            4 + (-1 + 2 5^Rational[1, 2])^(-1) (
              5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
               Rational[1, 2])) + 
          5^Rational[1, 2] (4 + 
            5^Rational[-1, 2] (-1 + 
              2 5^Rational[1, 2] + (4 + (-2 + 2 5^Rational[1, 2])^2)^
               Rational[1, 2])))}, {(6 + 5^Rational[1, 2] + 
           5^Rational[1, 2] (4 + 3 5^Rational[-1, 2]))/(6 + 5^Rational[1, 2] + 
          5^Rational[1, 2] (4 + 3 5^Rational[-1, 2]) + 
          2 (4 + Rational[1, 2] (1 + 5^Rational[1, 2]))), 
          2 (6 + 5^Rational[1, 2])/(6 + 5^Rational[1, 2] + 
          5^Rational[1, 2] (4 + 3 5^Rational[-1, 2]) + 
          2 (4 + Rational[1, 2] (1 + 5^Rational[1, 2])))}}, {{(-4 - 2 
           2^Rational[1, 2] - 5^Rational[1, 2] + 
           5^Rational[1, 2] (4 + 
             5^Rational[-1, 2] (1 + 2 2^Rational[1, 2])))/(4 + 
          2 2^Rational[1, 2] + 5^Rational[1, 2] + 
          5^Rational[1, 2] (4 + 5^Rational[-1, 2] (1 + 2 2^Rational[1, 2])) + 
          2 2^Rational[1, 2] (4 + 
            Rational[1, 2] 2^Rational[-1, 2] (1 + 5^Rational[1, 2]))), (-2) (
           4 + 2 2^Rational[1, 2] + 5^Rational[1, 2])/(4 + 2 2^Rational[1, 2] + 
          5^Rational[1, 2] + 
          5^Rational[1, 2] (4 + 5^Rational[-1, 2] (1 + 2 2^Rational[1, 2])) + 
          2 2^Rational[1, 2] (4 + 
            Rational[1, 2] 2^Rational[-1, 2] (1 + 5^Rational[1, 2])))}, {(
            2 6^Rational[1, 2] (4 + 
              Rational[1, 2] 
               6^Rational[-1, 2] (-1 + 3 5^Rational[1, 2])) + (-1 + 
              2 5^Rational[1, 2]) (
              4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
                2 6^Rational[1, 2])) + 
            5^Rational[1, 2] (4 + 
              5^Rational[-1, 2] (-1 + 2 5^Rational[1, 2] + 
                2 6^Rational[1, 2])))^(-1) ((-1 + 2 5^Rational[1, 2]) (
             4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
               2 6^Rational[1, 2])) + 
           5^Rational[1, 2] (1 - 2 5^Rational[1, 2]) (4 + 
             5^Rational[-1, 2] (-1 + 2 5^Rational[1, 2] + 
               2 6^Rational[1, 2]))), 
          2 (-1 + 2 5^Rational[1, 2]) (
           4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
             2 6^Rational[1, 2]))/(
          2 6^Rational[1, 2] (4 + 
            Rational[1, 2] 6^Rational[-1, 2] (-1 + 3 5^Rational[1, 2])) + (-1 + 
            2 5^Rational[1, 2]) (
            4 + (-1 + 2 5^Rational[1, 2])^(-1) (5^Rational[1, 2] + 
              2 6^Rational[1, 2])) + 
          5^Rational[1, 2] (4 + 
            5^Rational[-1, 2] (-1 + 2 5^Rational[1, 2] + 
              2 6^Rational[
                 1, 2])))}}}, {{{-1.3774440763331732`, -0.7239852530260705}, {
       0.6423503277082808, 0.5243163389583859}}, {{
       0.1019102131883999, -0.49822752207291215`}, {-0.6143287708998498, 
       0.6606714982495709}}}]]}}}]], "Output",
 CellChangeTimes->{
  3.817206658736291*^9, {3.81720671345438*^9, 3.817206726127185*^9}, {
   3.817210922804921*^9, 3.817210935162405*^9}, 3.817219811592348*^9, 
   3.8173819013308897`*^9, {3.817381932158146*^9, 3.8173819392140408`*^9}, 
   3.817384388553771*^9, 3.8173847134067802`*^9, 3.817384768438349*^9, 
   3.817384951382186*^9, 3.817387779220295*^9, 3.8173900753972197`*^9, 
   3.817390280566463*^9, 3.817390425247439*^9, 3.817390612387314*^9, 
   3.817391627779409*^9, 3.817392116915063*^9, 3.8174782353485937`*^9, {
   3.8174783702022877`*^9, 3.8174783789038153`*^9}, 3.817478703773345*^9, 
   3.8503103415297413`*^9, 3.850310452561599*^9, 3.850310532252194*^9, 
   3.850312168062413*^9, 3.850312350716899*^9, 3.8503124297259007`*^9, 
   3.8503125168418407`*^9, 3.850312552691597*^9, 3.850316241152089*^9, 
   3.8504002432483053`*^9, 3.850402194778451*^9, 3.850402497153192*^9, 
   3.85040258607559*^9, 3.850404398216007*^9, 3.850404457605329*^9, 
   3.850410621399654*^9, 3.850477022592182*^9, 3.8504771200128098`*^9, 
   3.850477217615065*^9, {3.850477269876568*^9, 3.850477317027563*^9}, 
   3.850580847174097*^9, 3.850649766302698*^9, 3.850757196481861*^9, 
   3.850759468114571*^9, 3.851256712948749*^9, 3.851256764458774*^9, 
   3.851257947199163*^9, 3.851260122078261*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"1ed7489b-a6f5-4001-878b-a36713e13ee1"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Theorem 5.24 (k=1): center function Cos[B]+Cos[C]-1-Cos[A] implies FGHI is \
orthodiagonal\
\>", "Section",
 CellChangeTimes->{{3.850367720388095*^9, 3.8503677251030617`*^9}, {
   3.8503677897854433`*^9, 3.850367862617402*^9}, {3.8504023111196527`*^9, 
   3.8504023133991833`*^9}, {3.850402727908643*^9, 3.85040274456111*^9}, {
   3.850581445042459*^9, 3.850581445658276*^9}, {3.851257701284854*^9, 
   3.85125772672479*^9}, 
   3.851257773836954*^9},ExpressionUUID->"762ac1d1-b008-427f-b56f-\
0d36164871c0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"abcFn", "=", 
  RowBox[{"convertToABC", "[", " ", 
   RowBox[{
    RowBox[{"Cos", "[", "B", "]"}], "+", 
    RowBox[{"Cos", "[", "C", "]"}], "-", "1", "-", 
    RowBox[{"Cos", "[", "A", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8503130699225597`*^9, 3.850313103178587*^9}, {
   3.850313223114545*^9, 3.850313224010507*^9}, 3.850313611725259*^9, {
   3.85031380056129*^9, 3.850313841228526*^9}, 3.8503138766785088`*^9, {
   3.850315043969968*^9, 3.8503150499041147`*^9}, {3.8503162986933517`*^9, 
   3.850316314236519*^9}, 3.850402718784292*^9, {3.850402755841168*^9, 
   3.850402788569271*^9}, {3.850402938033072*^9, 3.8504029573458223`*^9}, 
   3.850404672833333*^9, {3.850404725024185*^9, 3.850404735407531*^9}, {
   3.850478628997179*^9, 3.850478633723165*^9}, {3.850483283700939*^9, 
   3.850483284307755*^9}, {3.8505814518838997`*^9, 3.850581452434311*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"b2ab2978-e7e9-424b-b8c7-5c0dc8a83d4e"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["a", "3"], "+", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "c"}], ")"}]}], "-", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "c"}], ")"}]}], "-", 
   RowBox[{"a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}], "2"]}]}], 
  RowBox[{"2", " ", "a", " ", "b", " ", "c"}]]], "Output",
 CellChangeTimes->{3.850402790104416*^9, 3.850402962007489*^9, 
  3.850404527082244*^9, 3.850404675577964*^9, 3.850404736411371*^9, 
  3.850410570777226*^9, 3.850410621591782*^9, 3.850410666034371*^9, 
  3.8504773839389887`*^9, 3.850478635129608*^9, 3.850483286731669*^9, 
  3.850581455468048*^9, 3.850649766415313*^9, 3.850757196606883*^9, 
  3.850759468279948*^9, 3.8512567130579844`*^9, 3.851256764564279*^9, 
  3.851257947239519*^9, 3.85126012210672*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"8a19046b-d2ac-42c5-8426-5f213b5a2ce5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"abcFn", "=", 
  RowBox[{"abcFn", "*", "2", "*", "a", "*", "b", "*", "c"}]}]], "Input",
 CellChangeTimes->{{3.850402794913603*^9, 3.8504028116650743`*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"06601790-9720-4db4-bc32-c841e4ea32aa"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "3"], "+", 
  RowBox[{
   SuperscriptBox["a", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"b", "+", "c"}], ")"}]}], "-", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"b", "+", "c"}], ")"}]}], "-", 
  RowBox[{"a", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", "+", "c"}], ")"}], "2"]}]}]], "Output",
 CellChangeTimes->{3.850402812503913*^9, 3.850402967364345*^9, 
  3.850404529890333*^9, 3.850404678508553*^9, 3.850404739675798*^9, 
  3.85041057457064*^9, 3.850410621602138*^9, 3.8504106689056053`*^9, 
  3.850477387430881*^9, 3.850478639405941*^9, 3.850483290753254*^9, 
  3.850581459756763*^9, 3.8506497664255133`*^9, 3.85075719661554*^9, 
  3.850759468289055*^9, 3.8512567130646877`*^9, 3.8512567645704317`*^9, 
  3.85125794724641*^9, 3.851260122114049*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"fb811fad-a245-4449-bfb7-195706101f7e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"givenF3", "=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "->", "abcFn"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{"productOfSlopes", "/.", "givenF3"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.850402827140429*^9, 3.850402919594879*^9, {3.85040492036937*^9, 
   3.850404959081105*^9}, {3.8504106616520967`*^9, 3.850410662777914*^9}, {
   3.850483018647149*^9, 3.850483048244937*^9}, {3.850483087293096*^9, 
   3.850483107349298*^9}, {3.850483262157103*^9, 3.8504832632434053`*^9}, {
   3.8504840072235107`*^9, 3.850484013710253*^9}, {3.850484069343993*^9, 
   3.850484071510212*^9}, {3.8504849395789747`*^9, 3.85048494021738*^9}, {
   3.850485464604711*^9, 3.8504855339719467`*^9}, 3.8505814991395273`*^9},
 CellLabel->"In[76]:=",ExpressionUUID->"f3efadf4-b7fc-4415-940c-173b1c72819c"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellChangeTimes->{
  3.8504028603727903`*^9, 3.850402975224478*^9, 3.850404538676841*^9, {
   3.850404719468809*^9, 3.850404744281982*^9}, {3.850404924653132*^9, 
   3.850404960289122*^9}, 3.8504105797479753`*^9, 3.850410623280073*^9, 
   3.850410674801401*^9, 3.850477391573797*^9, 3.850478646456246*^9, 
   3.850483019880886*^9, {3.850483062168088*^9, 3.850483108271186*^9}, 
   3.850483214673177*^9, 3.850483266710723*^9, 3.8504840025113792`*^9, 
   3.8504840627676497`*^9, 3.850484936688024*^9, 3.850484973796608*^9, {
   3.850485475684059*^9, 3.850485538645849*^9}, 3.850581574150867*^9, 
   3.850649769633844*^9, 3.850757199690907*^9, 3.8507594711171093`*^9, 
   3.851256715864958*^9, 3.851256767248596*^9, 3.851257950664133*^9, 
   3.8512601249307947`*^9},
 CellLabel->"Out[77]=",ExpressionUUID->"ffb57387-d553-4924-8b98-495090f8dd94"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Theorem 5.28: center function r/R+k Sin[B]Sin[C] implies FGHI is orthodiagonal\
\>", "Section",
 CellChangeTimes->{{3.850367720388095*^9, 3.8503677251030617`*^9}, {
   3.8503677897854433`*^9, 3.850367862617402*^9}, {3.8504023111196527`*^9, 
   3.8504023133991833`*^9}, {3.8504026897928867`*^9, 3.850402690824613*^9}, {
   3.850479156134707*^9, 3.850479160572928*^9}, {3.8506498799944353`*^9, 
   3.850649885442007*^9}, 3.851257841725196*^9, {3.8512598702370234`*^9, 
   3.851259884380678*^9}},ExpressionUUID->"f172cd96-8ba2-4c46-96b4-\
51d99a8db2e8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Proof", " ", "when", " ", "using", " ", "center", " ", "function", " ", 
     RowBox[{"r", "/", "R"}]}], "+", 
    RowBox[{"k", " ", 
     RowBox[{"Sin", "[", "B", "]"}], 
     RowBox[{"Sin", "[", "C", "]"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"givenF4", "=", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "->", 
      RowBox[{"convertToABC", "[", " ", 
       RowBox[{
        RowBox[{"r", "/", "R"}], "+", 
        RowBox[{"k", " ", 
         RowBox[{"Sin", "[", "B", "]"}], 
         RowBox[{"Sin", "[", "C", "]"}]}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{"productOfSlopes", "/.", "givenF4"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.850315080744782*^9, 3.8503151067205477`*^9}, 
   3.850316292282464*^9, {3.85031637061327*^9, 3.850316390580514*^9}, {
   3.850479143325762*^9, 3.850479148077012*^9}, {3.850649821618896*^9, 
   3.850649833185235*^9}, {3.850649892763404*^9, 3.850649969154956*^9}, {
   3.851257914582726*^9, 3.851257918253677*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"5c227681-b8d9-48ec-bbbf-f73029d88932"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellChangeTimes->{
  3.8503151092560387`*^9, 3.850316241541628*^9, 3.850400243646583*^9, 
   3.850402195160371*^9, 3.8504026975184393`*^9, 3.850404562969687*^9, 
   3.850410623626402*^9, 3.850477366484009*^9, 3.850479151623663*^9, 
   3.850649842424253*^9, {3.850649910706959*^9, 3.8506499707399406`*^9}, 
   3.851258082331738*^9, 3.851260125312229*^9},
 CellLabel->"Out[79]=",ExpressionUUID->"0e67c74b-1a7e-41da-9e80-2ebda0236c65"]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
WindowSize->{918, 1215},
WindowMargins->{{240, Automatic}, {Automatic, 5}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 223, 4, 98, "Title",ExpressionUUID->"d6915b80-afa1-4011-9eb6-6d67402ddf17"],
Cell[806, 28, 1170, 20, 196, "Text",ExpressionUUID->"4236d41f-5597-4866-8f87-94c2f1fb6f59",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[2001, 52, 153, 3, 67, "Section",ExpressionUUID->"8c693eaf-fcc9-4a77-a5ee-cee338c3cad4"],
Cell[2157, 57, 35711, 554, 316, "Text",ExpressionUUID->"6c77ebfc-22f8-4071-8dd1-2f722f3c0b60"],
Cell[37871, 613, 1285, 35, 199, "Input",ExpressionUUID->"cb996674-2f35-4f5f-8356-c7337b1bb14b"],
Cell[CellGroupData[{
Cell[39181, 652, 889, 22, 52, "Input",ExpressionUUID->"04c746c4-062d-4729-88b9-a3e96c597d64"],
Cell[40073, 676, 768, 14, 70, "Output",ExpressionUUID->"07bf9854-9cb8-47f6-9b9e-6786ad618d06"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40878, 695, 663, 14, 52, "Input",ExpressionUUID->"b2570c19-013b-4a4c-a6e3-3b7cce44cbe5"],
Cell[41544, 711, 1594, 25, 70, "Output",ExpressionUUID->"aa8c3676-e9b3-4fc3-8f9f-3aa0658f5a97"]
}, Open  ]],
Cell[43153, 739, 912, 26, 52, "Input",ExpressionUUID->"0e986210-256b-4c47-8679-cb9e187dde16"],
Cell[44068, 767, 648, 14, 52, "Input",ExpressionUUID->"e0eab32a-a04b-4bb8-8fe6-976248c8c0b2"],
Cell[CellGroupData[{
Cell[44741, 785, 1135, 26, 115, "Input",ExpressionUUID->"a4b1562b-2ad2-4d92-923f-b9bfb3213cda"],
Cell[45879, 813, 1614, 32, 70, "Output",ExpressionUUID->"6ef67695-7531-4f82-abe8-f75851c2032a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47530, 850, 249, 4, 30, "Input",ExpressionUUID->"c9f651b8-ed4b-4f0f-aa8a-2b9a7dabd3f0"],
Cell[47782, 856, 407, 8, 70, "Output",ExpressionUUID->"5b443b9f-70c6-447e-94d7-20663428c4c1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48226, 869, 198, 3, 30, "Input",ExpressionUUID->"42b6dbb4-7e7c-4520-a644-78e8837a630c"],
Cell[48427, 874, 536, 14, 70, "Output",ExpressionUUID->"0283412b-a00b-4e24-99d2-e504a967ee32"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49000, 893, 722, 16, 73, "Input",ExpressionUUID->"2197fd1d-639b-4f6f-b9ae-1619502811e5"],
Cell[49725, 911, 1214, 34, 70, "Output",ExpressionUUID->"6f92b4ce-c2f8-4b62-b450-4d05c2e95b25"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50976, 950, 1017, 22, 94, "Input",ExpressionUUID->"c2f44073-245f-4ea7-a415-36fd72d309fb"],
Cell[51996, 974, 684, 17, 70, "Output",ExpressionUUID->"7df4fffc-ca76-4790-acc3-0ab4369a7eea"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52717, 996, 254, 5, 30, "Input",ExpressionUUID->"9559d8b9-0dcc-4661-952c-cbc669cc9f7c"],
Cell[52974, 1003, 996, 30, 70, "Output",ExpressionUUID->"19b0757a-dd13-42b3-8b46-a1242f48517d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54007, 1038, 5115, 113, 367, "Input",ExpressionUUID->"0ec44dc8-aa5a-464b-8044-17659b67bb95"],
Cell[59125, 1153, 3197, 52, 70, "Output",ExpressionUUID->"0af3851e-df73-469f-8cf8-fcf065932cb0"]
}, Open  ]],
Cell[62337, 1208, 1694, 44, 199, "Input",ExpressionUUID->"9c52c674-4fbb-4699-b31c-908f94972694"]
}, Closed]],
Cell[CellGroupData[{
Cell[64068, 1257, 171, 3, 53, "Section",ExpressionUUID->"8a0b3e8c-80ca-4eeb-9ff2-3eedce0a98fe"],
Cell[64242, 1262, 5950, 164, 472, "Input",ExpressionUUID->"8079a364-db9f-41d3-a7e8-9b0c27f40b60"]
}, Closed]],
Cell[CellGroupData[{
Cell[70229, 1431, 162, 3, 53, "Section",ExpressionUUID->"a1f9849a-0d65-4848-b72a-369351090f95"],
Cell[70394, 1436, 17511, 276, 258, "Text",ExpressionUUID->"04ba5bdd-4f3f-4dab-9c2e-3fe6017dc953"],
Cell[87908, 1714, 4018, 110, 325, "Input",ExpressionUUID->"c7cea900-0b63-49ac-8fc9-c28887904f3f"],
Cell[CellGroupData[{
Cell[91951, 1828, 5485, 129, 430, "Input",ExpressionUUID->"713cfbd3-2529-45e2-8882-82288ff468e7"],
Cell[97439, 1959, 7836, 140, 70, "Output",ExpressionUUID->"bf20de7c-1b0c-4d50-abc3-a912170948db"]
}, Open  ]],
Cell[105290, 2102, 1483, 45, 115, "Input",ExpressionUUID->"5dd6f535-967b-487b-9db9-cd62760a2753"],
Cell[CellGroupData[{
Cell[106798, 2151, 1068, 21, 94, "Input",ExpressionUUID->"a9cd24ac-33fd-46d5-aead-445dd7e49a43"],
Cell[107869, 2174, 1023, 15, 70, "Output",ExpressionUUID->"366f7f7d-0d51-48e0-80c0-181bdab79b1d"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[108941, 2195, 308, 7, 91, "Section",ExpressionUUID->"0f0ef62d-c66b-480e-9286-bd25211831af"],
Cell[CellGroupData[{
Cell[109274, 2206, 463, 11, 30, "Input",ExpressionUUID->"73fd5c51-061b-496c-ba28-ac4405cbd368"],
Cell[109740, 2219, 830, 25, 70, "Output",ExpressionUUID->"25ef5d72-5f8a-45a3-9ac9-e1e79dc91e68"]
}, Open  ]],
Cell[CellGroupData[{
Cell[110607, 2249, 325, 7, 30, "Input",ExpressionUUID->"419ff430-3d19-46fb-963c-0707d8577630"],
Cell[110935, 2258, 791, 24, 70, "Output",ExpressionUUID->"4358ce75-f80f-46b8-9ae0-d0dcdd2b3de1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[111763, 2287, 365, 9, 52, "Input",ExpressionUUID->"6fe1a0ca-a7fa-4e7a-bbec-58f3a9895e10"],
Cell[112131, 2298, 243, 5, 70, "Output",ExpressionUUID->"78492d4c-d533-44d0-bd34-682c205663ec"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[112423, 2309, 374, 7, 53, "Section",ExpressionUUID->"505d4006-5ae1-49ef-9d54-ffcc4e938306"],
Cell[CellGroupData[{
Cell[112822, 2320, 1053, 23, 52, "Input",ExpressionUUID->"be4741a9-f594-45ec-9201-c43bd1ff8c41"],
Cell[113878, 2345, 1337, 23, 70, "Output",ExpressionUUID->"47325a71-12a0-4ede-aae2-2e6c5b657fd7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[115252, 2373, 694, 16, 73, "Input",ExpressionUUID->"70447667-a813-4eba-a6f7-bec7715346b9"],
Cell[115949, 2391, 451, 7, 70, "Output",ExpressionUUID->"41a06881-8451-4ab9-b83f-027e90f885b3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116437, 2403, 6501, 166, 619, "Input",ExpressionUUID->"7cd079cd-9a54-4708-96e7-8cbae0795f61"],
Cell[122941, 2571, 23404, 428, 70, "Output",ExpressionUUID->"1ed7489b-a6f5-4001-878b-a36713e13ee1"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[146394, 3005, 518, 10, 91, "Section",ExpressionUUID->"762ac1d1-b008-427f-b56f-0d36164871c0"],
Cell[CellGroupData[{
Cell[146937, 3019, 973, 16, 30, "Input",ExpressionUUID->"b2ab2978-e7e9-424b-b8c7-5c0dc8a83d4e"],
Cell[147913, 3037, 1055, 26, 70, "Output",ExpressionUUID->"8a19046b-d2ac-42c5-8426-5f213b5a2ce5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[149005, 3068, 257, 4, 30, "Input",ExpressionUUID->"06601790-9720-4db4-bc32-c841e4ea32aa"],
Cell[149265, 3074, 978, 24, 70, "Output",ExpressionUUID->"fb811fad-a245-4449-bfb7-195706101f7e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[150280, 3103, 902, 17, 52, "Input",ExpressionUUID->"f3efadf4-b7fc-4415-940c-173b1c72819c"],
Cell[151185, 3122, 889, 14, 70, "Output",ExpressionUUID->"ffb57387-d553-4924-8b98-495090f8dd94"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[152123, 3142, 560, 9, 91, "Section",ExpressionUUID->"f172cd96-8ba2-4c46-96b4-51d99a8db2e8"],
Cell[CellGroupData[{
Cell[152708, 3155, 1271, 31, 94, "Input",ExpressionUUID->"5c227681-b8d9-48ec-bbbf-f73029d88932"],
Cell[153982, 3188, 479, 8, 34, "Output",ExpressionUUID->"0e67c74b-1a7e-41da-9e80-2ebda0236c65"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)

