(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    205058,       5383]
NotebookOptionsPosition[    186541,       5046]
NotebookOutlinePosition[    186879,       5061]
CellTagsIndexPosition[    186836,       5058]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Orthodiagonal Quadrilaterals", "Title",
 CellChangeTimes->{{3.8503675053983097`*^9, 
  3.8503675314147863`*^9}},ExpressionUUID->"bd04f0fd-e510-4437-adb9-\
c495525650d1"],

Cell["\<\
This Notebook contains the proofs of some of the results for orthodiagonal \
quadrilaterals in the paper
\"The Shape of Central Quadrilaterals\" by Stanley Rabinowitz and Ercole Suppa.
submitted to the International Journal of Computer Discovered Mathematics 
(http : // www.journal - 1. eu/) in January 2022.
 
This Notebook is Copyright \[Copyright] January 2022 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and is published with open access. This \
Notebook is distributed under the terms of the Creative Commons Attribution \
License which permits any use, distribution, and reproduction in any medium, \
provided the original author and the source are credited.\
\>", "Text",
 Evaluatable->False,
 CellChangeTimes->{{3.823362867312365*^9, 3.823362892123764*^9}, {
  3.823362940554699*^9, 3.823363012293025*^9}, {3.823423241988761*^9, 
  3.8234232521964083`*^9}, {3.848655919648938*^9, 3.8486559295098267`*^9}, {
  3.850294942155574*^9, 3.8502949868845367`*^9}, {3.850318910197069*^9, 
  3.850318919556775*^9}, {3.850318983141321*^9, 3.850319001844956*^9}, {
  3.850400416090372*^9, 
  3.850400417273543*^9}},ExpressionUUID->"d9ae5b00-24cb-42ef-bf55-\
b83f8fbee47e"],

Cell[CellGroupData[{

Cell["Set up", "Section",
 CellChangeTimes->{{3.8503675908573427`*^9, 
  3.850367597134454*^9}},ExpressionUUID->"ea83c584-a5df-4c70-979c-\
98bd92cc2e7a"],

Cell[TextData[{
 "Without loss of generality, we can translate the quadrilateral ABCD so that \
the diagonal point, E,\nlies at the origin. We can then rotate the \
quadrilateral so that AC lies along the x-axis.\nFinally, we can scale the \
figure so that point C has coordinates (1,0).\nWe therefore set up a \
Cartesian coordinate system as follows:\n",
 Cell[GraphicsData["PDF", "\<\
9E14ARda;S<:9LCUl^G[Yo>Pd<C62S@P<21_HVX:?3`P;daUKVMdJ20e830PDR0_
AVU/M6Eb82m6K65dIDAUHfmTIB0n?PYcM79UHFd:N06=UC^?fc0<P7Om2Xhad?Q4
:I;]/DU_^Nd@Kdf7WX6R:7[3hHJfokjTB2[:/dD0aiC4edNJNX=WN0>49`S`0aif
k`Rk?OSbfno:5P][Y4OH82b_<62O07>Rib_4=9WTO/:N[4GhmFlec9kD`]B?L@PI
A9?SJ9diLWIfl<CQ3CF>/@V;PRa6G<3@ScjV>f[Zc@jNi2Xa8VOWC^=TQaMaWYUB
kChT<U0`;nnD;Y:YmnDZ[iRSTFG>:Pgmh2LT4ND5<o<_jCYiGdPJnS3iRH:BCBhE
IU==8_:CchXDAL=DbAIGfC3b>idm>RfK6Y:Y=_4^l1ffe0]DCNOK11WL6WeTI=/I
L5<:CWla3h13P?TE7^JI`<3l3Ck3jU<7Jml7F47Wb_mQQKKdXH>bi6gQd7G`1NHW
N9c9>A^iAML=A`QDIA4Dd10;fXgRdgIWTP/@D28kI]dSYXU@ZB9;]25PEE0hSAjS
Di^2]O572aJI:SIa=U29F]<e1NXdGC15CdRm>dMjF;dX^=l6kPY9d3?K1RTejffT
U?VVi/lOQ4S:1W=X6eJnB6]HC6?K/9Qb<FBZ:PYGfe@nYZX=:enM=>m2<EBWS=Y2
<]DVgXK]UHHMZ?AWoHZINR2=5ogjJ=`>:mliJMd[M1^XMo]DHkI1jHa[3;gOI6iA
cC167JE2X8X4`N3F]H;@EA<5[gVP7QO2HNQc634LmD<jLE75QMQ[57E=D1m]5=B=
ScXN;S/IYh47olUdH=[QLSQlk6Q^m1<?1iT435gWQD1gZjnfl<MNoWm:67fm3b[m
P:Wg66QReL@abmeRHeo51WnXAaPhgDIV@oSKWE?i8mf@dhI:K?D;OScaXJ8SSA[6
l@QoOJ7J4?i77gOh[`=N:D2:E83YX]eg1_E>1AHkLj<2cgl1DgN/1PYUKVAcM79U
HFd:IFiTKf9Z2SDP<21_HVX:=SPb2VE^I6mRJPXb830PKf9Z2S`l82mDNG1U82m@
HFMU82m@HG9UKW@P<b0`858P;e9ULfmeLV=ULb0f830PDR0_@fm^M6E^M7<P=20`
858P;deUI6UQ@Vmh85/`830P=38a838d<Ed:?Sh:IFiTKf9Z2SHP<21_HVX:?3`P
;e1bKf=CIG@PFb0_D4A682mDIGQd85dP;d=_K6mbDg1QHfDP?3`P;d=c<B0g830P
DR0n?R0_AVm^M20l?20_E5@a83PP<21B2Shn83hn2VE^I6mRJPXi830PKf9Z2S`l
82m<IFiWM6PP<C0P<21B82m>83<P;d5/M6EbKV5dIB0_A6EfJF=UDTM282m6JFad
IG8P;dI/HGAUA6ESKfAU83hn2W=dLVEQK@Yh0IfFMeACfAJ7ckdg_M0B8R0Um1Yj
2B3B>dPE1569BH1@0XJ49WI41DHD4BUFI5C00DN78V=550^3PV;G2O8@D<K1DDA5
iMf<J`W_[CGcgY[maeWOfNNgemUWkggG^P1@o884`WAH0H0dXEPDk^_1G18CblCg
0QP@0@iH0L3QIVH4AoQ40]Cl_CfIVJQ8a[?fkRj0I;_K;;m@9W?FognA8SM390H0
2TGE=San9QOU0YAC/lDI<_l4b_BE:C:6<C8FX@VR[2;Sa:m/mZOV:k_9V9LVi:4J
FLhI_3BNS;]@gYXUhJ><1:5LV2GPIj=l1fFmE4VJ0>Gg:=?Cn9a<030DVEo<ibJQ
K8TbAA@IkXWb0P08U<@i_78>RoTiJ9h0N:IWi8X4RDURYQ7GV6WUj<QVn_6cDoUR
<B^D`dgQR7Q<coBd38h`5h2_KiI50BEIKIUXTNf]7>g]FMKVJ?VofMlNOU?m?LQj
neGa9^c?WT6<WUWOK>b/;kdF0?HTFY/M/kjEE@2dK@I0iN6/CnlP0?850;CNW?<N
QVaNT/CR32L;Rnc/K7<1Wf/^:nPgnin2KlZoQSWgVL_^neHkYQLoPB=95C=UANFV
YjI;A<c<30jGcfCmma3ohl0iJLg9`bbLWl0GlHGXEE7XU0V4RFRkQCb1F90^I0Z4
OmGQOaPf9`LIOYe[56QeG`1mQCU@^4T7b6lm04<S0bA^?gX2ON]K434:b;jlJ:fA
[g>?<W[nioXO2eb:K^5<@B9Ci_H<SfAb9J8/6J?OQ6c10Q:@1gBP2SB1;S02;60=
780cL0?N8024P4P@0iH3;TP2JD04/T4nf00:@C7H0GJ3JW00e85jd0A>PSI`1U`4
El0=L0/<P4M02XK1Bc01gX5Y28;`41FR@JZ@5Z@?VD;F41]J27U3@E0h50?5@hV@
4990nM0VZ1PZPjZQ@e0mm2=d6[X8GH?jX0O@83@6o@5mQ16H0]=Q3MP0]X3I/3/L
24O2bn14N1FL1aO0fn5:^1Hn3[O25n4Kl00/QEo2T`Q0b0P3dDIH21_aA4:@F2@1
4B5[TB:T0ZU5VY0>Y1^iSDRALN@31XNQHIPH5/HIhhMIS>5REV7FHTX`eIQSV5I<
5nHfIQ0cPOV2YF;E/JIH9j`oMPTf4I^=;LAFH8mPFk2G/@?HHN`k70k7`1WR771n
^1QL<Vhe[PBg3mN<^h3[``gQ9_5h_2[N5>n23l5cl69l8Kh:Oaao7]n?7lJo9i09
FPA[PPlQUR0TK2AD41X8i`SmQ172=561Z4md8XH@NLALHRVaS]Q1_4TL9TjC54V6
91MB92VI]85DBFXRGBHm9[dQTlTjI4Mb65U0GTn^99lPGbD?TSm@U2PV54m:74E2
fDhiB[U0ND1i@jEB3JQ^e5RZV;ZMFTnmA7e:OBm7Tc>GliOSbJfCZi5[UN^GNbE?
U=NGMiMO;YlWGb5oB_jVo;P2DL50`E>1Xk1FXDKQ]<8mQDU5VZ:EHXQRVV:9HX?R
=LEA9KbBPI:g4TnY@>V`dRFU8AY2djEid[RdCK@jfVGJ<1e7=jCkdi?YaO@Oj;gd
2FDUIE_U:>DLiA[U/lYB1/8`H?PcDQVUS9><^hb?lcCV^LoScm/f[fUNok`YUOTZ
KRYlUB:EIYD1UHnZC5E_eACEWJY]ZToD<6XVJV5ZfF[keBj[SLnWcgNNcieO=?oT
o8OZ/;Z9N[SjJ_G3jSgZTaZJ6[hJ6AYE6YLdaSDIVVjJbI[UV^LdakAXFP^e15[U
F^NeGS2EVNk<E6HU/h/iXJf^kJL]dCjTgJ/m[F>X/eQWXdjccQ=MTRiK=d6gG;MC
Md9?BbmH;en_DNnQ?U6O[InT_dNoFgo:`=0PfV2;@I_1Z:6:XKmQWV6ShF<SZY6[
dBZSFZ<kaSQS]W6:lCkSFbJ`RIe9TTV=bDeCf=CNE62jckC?36_VJ2HdZcFkaj:`
g5UI[4KFX3W3?<QlXgVKnB/;?H]HRidFgAIO;>d/Dbg[;1mI:ET5F6fdj[3j`m[4
VV]MHgg7QV[SHk?>Y]gV]JfY;Mmf_nem>iYM/=dF^djkcoH>mR;k9_/a1cf7N8Nm
3_OHM7HX^hAmeA7[j>6hc_6<h`LWNbNaddVWgieIcRW>3LjS2``Gl1OD;AQbdG7Q
^1abTBiT;XaON72Qe5GKUN=Jjo[<CMN=igK4KLCMf3gIoKSk:`m;3i57RlNDYi?W
6/l;GXRG[eNAEjngT_MRkf[_Ychj?XTnSChC_WJnZgd_n67m0_efn]gceo3Wn]Ok
C`@h1:`9j0ZT14H4EPLn2c894PEe1<?10L6kPQl_dUlTG=@F0T;l@gJ5?0Te35dE
nW<H;R`d[2K/NKQEN7ihM`@]HTE4@lBkB8o8d/Q7RhdFBaIgA/U7aDGEAde5NdFG
AD^GF2aI/nA6S5Z<8:Hm5QlK5G/TMW:Ymm;MBhOSk>8:hnh^<ebF/ncJL[GUZL_?
[Y1O`EUa:QhK7agO4?n94l:YiDb^m5niMnD4ei>kQo^BilH[ihgaGOQUo944UhBb
Q=54UlAMRF=9[TTEBN<2Cd6eh7FbGo:1i:VDT9BS:C>YdJW=JHBdn;CC@REQR[0[
GC<m9kd_`cBS<4>jbVWEkUDCXT3ATD`XLeUV^iR>oTceB8`TVbF3F@^cJ[;NIdMU
WlYAc17Vm>BJi6k;7LWcbO]n=FHeMgEW_WKnQ_c1=Ni[3Zf5eZiLfkU>Meg1^^7e
_^^?KB1]B=W`bdK;SFDKgfj:g]AAX56`_V1X/noVaT:i@U7Q_Bg>F`i/aF`EK>gM
I[>]J]^G8UkAmF;;hX[RCbGLT^_OFGeGnMg<mXC]_JGfYO]gh7H8MmcMjK[cF9UR
FEkId:kPGJgUc?:Rl[NkEnbnEV5KLF0?JHmTSk@bZ;:mBZmZAmFWjZCZPAZ?V^Jm
jW^gkIgJam_G_mm]Om<1S@?51chN51blOlSgD6^]@Fg5HMcQ[<??jj;Z^[mWOemo
A>e8lI7?AhE7YLO2SgGE>mCG=jPgU3K2SI;6/N=aafomh?E3Na>[jE0cXkWh13PQ
>O7RaoPOkih<?=UiRWfZjBOmWoJfd5Z:FZ7Fg=J9]Z@fJG]<NmoYP=>M7LhM;CnK
ogcdS?JIV[?:Id_?TLhEW9/iWgMnlT;6QO6;RAN7>UMd?[Zdi=:M[[2^g/^1UjmN
lKUbZM^mnoaEUj]W[SUM>gfMOKg]Q_f=eQjkWYIOk7iYjKG_KKgYL;?mU^>]S[h5
ONOjGO/_g_JjONF>oidK0h/6n^h^_W_oG]`mjGgNoM47Z@mN?laj>?eXoF?/hj8W
2TlZWZXo[OgEn=MVZKgdk:3GH<ncR6N?Q[Q3;onEnJm?``G?ZLl[A[A6jTN]Aln<
nHcMN[7daO3;S9OChhFo:OjfmiGAZimnMo^mIf;9a?1[dN^I?d[NZ;hin]KfKNMT
j>CCMfW_YZN:gZ^n?oJ1oJ7kHoC7TNW/CoQ?UIn=?gMl2OcbN2I]I^KOmhCcn`YU
KVAcM79UHFd:IFiTKf9Z2S4`830PKf9Z2S8f<C8:IFiTKf9Z2SLP<21_HVX:Fb0_
BD=3@V5cIF@P>B0`858PG@YUKVA_HVX:<b0`86mRJPXl?20_E7U`IB0_D65WIG<P
;deUI6UQ@Vmh85/`830P=38a838d<EdP;d=_MFid834P;d]YI7<PFb0b830PDR1M
83hn2VE^I6mRJPXa<B0`86mRJPXl?20_E7U`IB0_@f5dHFa_Ib0_D65WIG<P<b0`
858P?Sh:IFiTKf9Z2SPP<21_HVX:?3`P;eAiL6DP;dI_KW@P;e=eHWAiL6DP;eAb
MFEDNG1U82m2HG=UAVm^M20_CDUF@e5;:d5bJF5/;D9_K6A9M65/JF==E20_AVm^
M4AULf=bJG1dKg8:<C8P<21B82m5KV=_I6U^Ib0_CF5SDVm]HFi5KV=_I6U^Ib0_
AVUbLgA3J65b83<b82m<HG=d@fQQLR0a<S4P;eMYI7AXLb1K838g>0X`830P<20`
830P<20`83<c<b0c<c<P<20`838g>20`830P<20e=CHP=CDf830P<20`830P<20`
830P<20`830P<20`830P<20`2SLb<R0g<S8P=c8b83Lb<R0f=SLP<20`830P<20`
830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830:=CDf
83Ha<B0e=CHP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`
83De=R0e=CHPGB0n?PYUKVA_HVX:<C8P<21_HVX:?3`P;eAiL6DP;dI_KWA4IG=S
LVU`M6mb82m6KfidCV5]IB0_CDUF@e5;:d5bJF5/;D9_K6A9M65/JF==E20_AVaQ
Ig<P>CHP;dI_KWA2@Vmh2U/]=CH`82dc=cHP<C<i<20a<34hGB0_BGAQK6US@FiW
K6DP;CHP;d5cHfE^M20i<3DP;dAULf=UKW@P;C8a<R0_@f5`B6EYIfQd2SLa=B0_
DgAUKEHP<20_C6EQI6U^Ib0c<b0_F4QUJFMXM20e<CTP;d5fIeMYI7AX83@g>B0_
CF5hEfUTM6PP<C<c<b0_AVm^M4IYK6Db2S4c830PDR0n?PYUKVA_HVX:<C<P<21_
HVX:?3`P;daUKVMdJ20a=20`858P;daUKVMdJ34P<C4i>3PP;dIYK7AULR0_AVaQ
M6E4IF=_I6DP?Sh:LgAbIF5]2WP1WGYkH5C5mOnIVO_H^i]T=i/UKmQM=VC3QY2@
5`@R^@T91B:4=eTT9[bD:0P1a?ZXX:9P]1ZemMe2ZeP;]F`fPT]4XHZ?nRSh@:eJ
YFe@[8eB1F`EM[nONfm@k:o]7kmkmlbIaiVI<nNN>G=VI]N^_W`Y9M464Z@_G[5`
5IU?mUJPEaJ_Fn/cTi@L8E8R5jfjN8FEm[@AbMmL_?c:RjadCQNAnleUBaL^/M9d
6[Qb6C:/=2/7cU^fH^d?[GCf0^3jiB/G3iCW;3O:EbclhD3om3kB_//F[UQZdHml
57S4ZYE[ePjTSGkZEjeN>T3?VXVBiYUUGD]d0dl][MJ98I9:Ge0ecB>I>;VXV>J0
le;NBQ;BA[W/G;1hjmgaEVOeBE^FcJQ:3lgHEfWPiaiH=?NKVdjOLGQ]NI2?I]8K
1JRWSXm?X`WfkMoLm?E<QiOlY1X5gcjYgK=;WQ@c@:V;YVQEVAhCCCf^@JG0dg^B
g0JNfU=LI^;XN:=hJTo3I2/igDa6ie]XJMT6Xc0Waj[SmUSHTEcZ[1dTY]9j`>L0
@CD8V`2g0a80RI`8SG8^c^mQ@ke]ChU6Y1/aLUe<kYT`XGCm?S6I]P0n1403T5]R
<SFiYj;2j6QbCo4X2`N35Qhj31dWPK`6/1i`461DUlgZFUYYLJeOC47A5?Ac>l9m
P8>03`6O0fC`=HF:0Df0=/0FP9E[d1SLCNTI?]KXKdZ?=N0Y?@iGjOAJUiR4QRNQ
`RB`Jh@<cDi2/i?<JY=j=5NYNdmR?gloZ]NFFY6ZJS?b@DmeKNVK]EWl0e@ZhNnC
3YP>J0<L0Q`170OPBb;/0V`5A=2D=;Z[MRQo6OFjn8_6=cGS^QT_<N<UI]aWaWd3
==^8lFfd3WDNAT/?4nL?jl=JSbQ7E;i?fJObWLY>UFmA]ZRlBFUB^E=a3^@iJe]4
7@AD1`7EHIAeiZN/PlC[Z1F`4k0OT00XE<`[JCf0Ta>Q5f3Te02J0;L3]P3f0Fbd
4b4cjLkB]29W?B01D<S5:i2Z<=^Z@3/E44`596gT<K>d1[4V8dm<`E/Wj_QX_9Eh
:gP5i?i:e5m^R__U/i6GcTInOcKbXQ699OKg[<R^=_4WfAE67GI1516Sh9X1_6h0
]`gPTAJ>Q/[;@1H=UEVXe4:S;5ARXF8;QB`dg4855_9K:<=2jAHJI26?QM8/i;I@
/XFB;>@`D4mXP9VPaDc@HRIX<A>dV0UJc0@]IX8F<d6;VJ35C=1R9VPa4kBH2E[<
12eVPQHc@H^IX<E<d68VJ34C792@gl3h2WTEgQQofD8_FNSg5WYAMj1`AEjema>3
R5fPNh6_0J`3]0560T:08<0?R8VJj6g3PLKgn0;NeUY=W4L[0N/1]`<TDMGSlg^m
/4MSX;ISX:QSX;YSX;IK4>h4k0>8Kl^hZ=R=MVn_ZDKoFK_1bUM6=jc7i93]/=1L
2lfaD8hn3CAO0oh6N1e`1N0b`3c0nH09P?<05H3AS=a7f776gJ_H1]K516>T<HhY
T9418ne>]NU?lWC4=7ic]3d=ONn:5Ub<4K37ZD1Ri6Dm[=G44FXgl@h:/V78g`hl
5oRGdM3?DFe;=5@:m;=X209RBj<5Ph6FA0]l@8^S1BE02j<5]D0GA8<ommIZK1h5
KDH7LbW4kPNN4`gMS>;I5YXE3De0bV^e<2AJL9Nge/46Dc_O0MXL2YXhRd9lAmCk
MC0V/JSgGl4Hgk7KneFXbO^gD<c6MW/o2EgY?E`@hdagN]lLnJ[gMOn[gVL;R[g?
]8=BMgSg]koZOA[TgGUV0oN7HV`^/^l;SO7N4H8bS4@fdUNPj[[@3^lZ=8G^EWY=
j/_l<GHoBUL4ko8^3EgWK@/R_M_K6PYiihf</F5Akdad0kk>Af[^KVlS>Ylld?4?
@XGNNW@n`N0cjZd]<5_Dd@;CLkcWnO^lhl33j95?NR]2hkbSA_Ii0j46km1f=?B4
MdjbUZb=kXZaP5jYM_e9kEZ]M/eA^l[E[V:eZe3]bUNkQZUM@mB^`J[7i[JiK2Vf
99_MI[<Y=/W6KFCca197m176n^eAG0IB92>Dc;R;6g4428Tc6jLYi8jTRDKN>:/^
<ZJ`<JHVITI65cI6K=<_J>iVk;J`TA_I_iPJ5oTRYfH5H/`nHgi43]BaR;^A6VOG
IDKhiQRSfLg@LZ?2SCTAmhCV?LAHeXdocQW0hO24iUkHj7ARJl:D_ZhV/lHm?[EZ
H_eo2=[<c;Kj`^nNc>nRQHF=djoL0cEi]4OeEZY8cT:bbdQf6LW<`I6k6fLeAkH?
3TM:SDQRL;PaL_</gh;V?CbCYcODkn4I1PXgki5jN6K3C2=OjZT?Qa_aRDdjlR6o
OPoU6@Qd:CKb6GCTBk6IM7b7ANOU6@IMPH50UkV=_2JM=g>KBBLaPjjkgMM@gne3
09X0DK]9dajPLfSf/5K:0eDN0X=Z:f/eZ5Q[H:]15BTd6`X6@C8B0DQH;PG=QX8/
ebBYn8k4?d3BnRe9ZdUbjgLT8H]4H:YK[HS]83UGc_nolJEe3NfcjUSSm>I^6mF5
9d001Tig[AY_JTIbe_Q]>Kgd^_RD78GQR3e@5g44/?3GI1JjZUUa2bY4ec?F4SIS
Wa/a9BVRP4`56;XecYmiKDj_A>aA/hDTI2L?51GE5]DJAM1iXo4DI3/7RS:_7NO?
jFF?3QBiT9f:O_oC<=N/FE^hi]b2odQe;/5oSe=V@g^mmC=R1Z3ibdeH^fJ]lJaY
Z<M_;CE6@[<J8f=Vc6o^E]F6R=iF7dKNb;=i@YQigIX6_;0n_6KP:EaknE[d3kWY
XgAh3CYL1SeD2QP5:04DUnUH`7F/gSZFKQg[]Xi5FlN:_KGFK_YcFdeoKX/Igl9O
e<^H7PZQiW1@0F<eed=^H42X01P@lP<6`h<>VX6ok7]2<WPkEbQQ:/BXTH<QGchP
g</;fIZcfMoB[RdT^IMbC7R4LZAlbR5:73d;lD/CAhfbn?;4DOhak5R^1@>kTZ_X
;AITVGBB^FTWUYBGj75jQhGX6WZE;J5dbZ3C?8mlC8HSV4VcJC^ma5@:DdoR4gXD
>jRoHaflPhj`4CBGGV4YF<oWd<mX6Q^Df46O<YhhPQK6dW@H78nlCWj7GDlb4oc6
A34UXnH=i:7am22m`JkAMRD>dfQjBSXol@njUfGb4:G@:_Z8SX>o8Sj6]bAFd49J
CkmSRYPPgiDH@IOAJG5ChR5`X]8/m=]:em8mj7DlflmgbT/XUfYX4Paf2jfPAnPa
OY5lg3CVnK@L_;m0amQSk3eaC?a;/TTGB[O:`n8ej7<XUM4HS:bE5]4J^YG^YJLI
<BnKbNjCBlmL1iWh:9m6PFH3GDlgD`m:DePZ6lCV/YoaJoU1oYWdJoVMa45@UM<j
l7@3oHjNXdoY2jJ`TJb4GLof/=LhheOb[hD_@HVmE40oX9VdP:jPjjR;kZ<XkHDd
OlNWRPWR2Q6A?YFnRAo0SW`nN;ZJN^SgM1SOcLebNCko^o2;6lE3hQEa4R=9Tfh0
kA6<XP@lWXmg5/JoQZjRCG@KoH9fd6kZ1Cn7j3EjShj2jc7/DWH=ncUkTYeRGg<o
7lZ[nD[nDakQ_O`_8Ug<4;=5QkQKg2nN5fm8ZE:Me2SmC=X]_J/D:LODQO5]lKlV
YRFJ4mLUkT`lVGPVlDKR<nb:Tl51P4I@>fCMPG6]QbAoBdoSOI7NYSoB^mS=7hGF
4D]R>Jb2CF6cf1bfW:eV]k7KfDoH_N`imPM^ijUl46oRdoW5o2Kn8SlXZ/@h4I<:
Y5:Y@IX_GBZ]UFjBBo5>UFnE7iFgbc_Tho9YaJe/al[nbYW@V@oRbn;[hWm:f1<Y
RB69TTAkhRAfUD?`mAKBaI390i39`m2>gm1n>T2_@2Y_P[_gjDod0Gd83[nTdlc3
dUTVgQ`f0[XeSEg2O/R^`eNlUcg07V:kFHc]ILnbEmTQmQYkWKg3o/cn`_k6?V?7
^N1Ig</3_92glVEl?MjKn5gl?WhoO`UjLY0OhVoaHkaO^<A@0AlIKkFXa@JZDn`@
QjA1DPJTgBAM;Ud5RClRkIMn9kdVoEDVfBFWbGWb2;UA_TGN;kmPSSU5bECbUL^D
6iB=bSHUYTYZ^UZYGZoN[3jPoT9mdnJa1FaKKDmR50D/RfD?c7lC/FKf?3cbleVH
KF:cFC;[I67bl4;jQMC1YdP?l]/iG4^3E:VB8PHF_jKK1>=>ZD_L`Gi2^n19Sj>=
K3aM`Nk4UgjN[H9fSJ3kaChAia<Ic09kV8fQDn8Pk=9QB:^LSF8oX2WlANT?lP/;
=_4lOR7kXgBQXTW?deglBJU=ZY0HI7/Uo:k=h/MDBIn9=J8?/f:5e8DIN@fCj3`n
STh0_`DML[5QO2CE/<TRRddG5k5/S=>XNaQFXYeglaXj`7k2;aD5k6YFBRLYCSgb
/gBO?5<jW9PVkD[hT7>E<C;JSWH`AWJ[J9>69nK5_f:KA2KoWLSWik4_Y8Fl?OiK
e/C:nE4aRZgQJmTgf1DD@8=NhU=i;L_6WShIkOlM>WBJoT5AjBkahl@7HTMl1]m;
NO82NQdFCJ4I_9MmBFo0WSh=[K31iShVEM8^LATM5fdla/n`[oQGm7?j;Jc`CQiT
kg6MnYEFj@Pk^S:53A4G`JIafPJ[_4QlA[F9?l?3Fi/hV=S7LS1ONV6GoR4obeOB
WK0GCl>RG0/k]Q3J_9bBf9FH0BUhNj3kGl0nI>3cb;2QUf6NgPmkf@]kLAQFhaS:
gjMCV;_gdG^LdGCU@G1nW9k1n;iV=]Y3YEPcDS2GnQ:WY=LQ^lOYI/7XFCE=6BoM
A4o9nmCa]3da6WKm<QY>Mm=^mZkd:3f]elgFJlJOEce^K=FHdIDEiFFUXdZ:AaJ=
:0`=;`SV3l/;3?Gk_4<6inITIfEVY0obY;UCGLjDi2B7GK>YRR`9<3>R8C2acAO9
Kh]8nH59ThZ<M60Q<QJNTm4FlB5[h_MY8SjSgT8DOHmB1nE5odJYFiCj]iC<iJ^V
jZ8A_XJ0;o9ZOL0GHo=W=2?nhoY0f1OY=n=CcKRDKbJBTO3kDL?GT;V/gQMQKKj6
b<AebcXKf^Z;A[1^Qge2H<9BNm48j[Hk47DP5/T8[>YV6N>I6H6c?;HK^mATS36B
7JQ_R6@5D1G=R64=2iM4Y/mXKZS?lO_3AB<RK<;R`:886EiLXDU24la^8/Z4R6Yf
hf^7;aBQFgcM8oIggQYcdJ:f`Z@UPBD;5cA7a4:ddA19;DBomI6<ZoXb_d^RLKRB
Vlh]cA6M3IW]?X>h/g>C;k9oA_<iMG?lAP_Q<=Y0GCi/HU_WA7Am:chEbb`6L`Kk
aU2/@Bd==1PiKIOh8UZP;[2/li8fO93/cPS=_=8OcLkFml2Gb6k`MLi^3_PS=CV1
l<;jg6h?MLjl/RM;mfEm_jAXA;L[eI9VMhYc89:DO6iT:BA]UITaTmb8=LklEYc<
h2P`6HiUa;OH1djJ0aS862=H>XHj5hn1e?646FY5U^0c]4Nd2FfM[[56?TC98_8`
El3GNI;`f@?mOomnc/:176FHjb@IQHIbO:]P4KK`K3aBF1P9Q@bmD2OP@h;7lFJj
XVS4^QRO6eSUlP51O3Bm6MG2Hh/QLkoOn:Zga7AJQ4AT`haV:nfSACUAdX_Qk?<f
X`AOcBXI=<LXfG2fi=_ZK@6Xkn?61YP6AFcigojL[_BdQVES8bcmOa@_]LXKI`DJ
hJKk6S[K1UBeLOKgDUJi8E383FD3<FIEQ<0Sd[28<Vab01XgLgjcTH6O?6aRX:6m
KA9V67R<Y4eX5SWLV0N8lAaQ=PFeGC3oK7]6XSW9J4/JYQPSa?`AD5/cPoTVAUa]
Tj``K?Ok1bKEoe/WY][>ZAA;73MZVNRkJP=3SX`]71RD=LC8^>nU_lMMDZMXW0fS
a1]Wcno/]7n_K2;<GFOWa81_HVMKil9HH/>RP<lEj=`33g52ijX662[[jlLB_KOT
A2KN6/I@U[6ad75>MMd1]WU6]lhfci[O_0L76kk=/i^Sl40W]=F5^o=@e[c7AjBK
^OcKG8?6IjBXTF5FA;W=;<[IXa=]<6TU<l=<;lJIQYUW4B6?dN8H]o9L9Udh72k2
PXGcU2XLYVbWCGakXPga@M8JfPShDWhQlHWl0/d4?0<8bg=Y=_8GB7nU:L1GBf/B
K`0W4j4A@ama`H<6W`Kf`CNfL/a/<n1Heh`76eSc<OH`oo]ALAJXTIdLoi_/_iHV
PKNDoe[jk`E>g3dICaWNZnQIiV3]k1En^BPGnbAM>RQo[]bVI]YVJiOPi0UTl?_P
N66M[WjL/bLD=LI?jYTTBdl8/Z_B4hbbK8[l11LAKMl7>1XhEGfVNY[[A?GD<mED
PkS[=89A9OiDOnX`13SQX]<n/Ond;]<gi9?f6c;M59lQ[Y7O05n=nV07=U0ImV:J
acM[R^K21_7j5?JaI?lJQjHJS_Cdi9Ai>2JCFRDQIJE^g0>O<[<@?KI<kCoAdNoZ
LoGQS69D2F]QPGaNDNhNGCVjC>5lT<O=?WefI]<=VnK/OGOO`H^:hS?f/Dd?_L8N
>;cil14hjbDOg1g_0cN9=_Q<Lda^Y^_>I9k;OB@f^9WVIZkD65^T9h4QnmM>SGT7
64YR7jO<Zh77c:E/Mhc]kYiR<7@:3?FMJ35Hn/SRZ:<U[BcM?LS3EDD=E;[M5NGl
7bI7LimlmnV35hf@ggPjo/=O_Q9OnQHhHY_IJaoNPe=Fb6M@o1UhNh>P8Fgjl5_4
;NZ6966g/Dk1K:ZV:39WM^DYFI<gdFBkWFThGWIY7;:JXK_/K;;mDAmfIIanjiRh
a_Q0;GePZJF3J_[kZUgmZNhZMaF2ZU4U;@`LnUE5DDMGEXh>g<Wl9L=gMNE>JT[K
b0HMOGjK^=4eJbjV46e<O2cM:Nn7c_UXRYiZUfb:i52BSjGo<edIcUU>S>E6IAVR
b=DmBLVIkHCcCfk;7^Y/YbcogW_<ccFega8Af:SY7eE2;J`U[GbdVlY:3@UAH2PO
iTT_:aeMV@I?;Cl`E5F4/[5a0MK6j=5OaO^RdHmIm_WEdlO?d/^VEYloKUi=9O_C
Woj:SFE:?7kZcg57o2CS_N_JYRaVPHlgGKI`lRGaTlHa17f9RIT>7ebSWnXiSCAE
JjEFeZ[98k37Zi@[UKWRGiXRbG:<]D;I?A26B[gl<V8R@gL8PA8UBEEL0ROQ_bB9
GD@Zoc4>5b:Tl<]abMJQYkX<Re13CM@6GLnb:aTahNWn4VNSQY9fC>dkeGoRC3o>
d30mJZYM9liDKI975_k8ML3@FFY9Bl/KGLKlJH[bIBEKlo;>n<_a3`o?oeA<HOC;
]klnCoacK1]aW3f@_1SW:b[IFKXnnd>=jDW<Uk@ZjEgaYR@e9EdYkD/jU7@lBLhG
8JU0Vb_Vf^nEk[6[VTI9TjUAVF;CTaBbJBZcJaZG5FFXZWUDEI>46<Xe3nNJ5^?Q
Z6Bcag3:U89CHR5;7;;P`ZK4n?Fj`jN^EoUdmD>EZdm2=CDB?:cK_KbH[n97^8Bm
a6kMBIZ^[M8>JI:UTG^a1g;`:7l2<cK;4<JYU/an<i;I3fUD^b0@MeFaHCGj1hBb
JFBV8A_EEEfmjD1e]l8Wc6kFGIZNVUF^5FQ9iDfHPk;4X<3DDUPHQP`kFUXjf6[Z
H7kQQacm@S39LnK9B?`ULAi[nRcnUkUchSmWmO6mL^oG4g70<ne<e;1_<b7Agd:R
K^cB2nR<?]hGHW=Mk57f:noFd?j@]2CY7^EGM2PTcD^Kifec70m9QHiPDTU8Y1Eh
QcPl@HL]LhSGjbGVPIIidPbaI@@?5[02Gl671KbhX:TPD[2o@2[`3Qj2<YQBSV/I
41Fi2EL`[/`2WhdEfeIRW[bLEj276:FhDW`Y9BU]:E]BmZFX:AN^2[7@T5in9jiE
loCDoCQ:hBFThha;D?E`b^SUfoTlb=FHh1eWnU`]YeYFma_Vam:d<a3]VN[DZYJ>
hPi41ZA[bPfbDnEZf6SFPPLC/@?jEiXa12ICDM>a3e:TP2P[[CCVHC0o411n:ak`
cfAUk>A3]L__W[Ki]XkeMlOoNOCPA`m/[]O7nJomfamHh8TO=Bjo=Wj_g6]gc[ok
PZ]jAWZg;=WH_daL<V99eIQ9BL[YH?7bj/V]aZal9_6Ao1E/KPi5mI5=e<Cd5=dY
ZATI6HEJXKg@<dU^L_k0<bDcc>N;nDUgJlUHMU:JW:e>k^aUSi6K_jcK7J8Hddj7
?8b/;6B=UC@ZF<Wf<Mk4F]TFg;aMib``1<]CG]H7/b>3VFn`?WSjh;K1d^3d0UfM
[[JYF>ULd>TH_klW]j[D]9L`hAd]Zdnd@9`]d=<cOBdeIdjd64KCV[9<ERSPXmAb
MeiIZI@Qil=L:I0Nc5NUM1D[2LLOo3cnIObeUmVb=cmSnMWa3c=_G_fS?ekojf/_
OiJkAWhEohKE/o:_fIKg4noWKUQcKobYGdCfg`/k6hI>_P:MC2D_?J0?_C6CSJH:
Mf?6??LlKnnP?AT_3GXYGO>jg@=JUnHf=2^EK4=<cLZ6ST6c/P[8k[9cNkK^Icho
fhM9hMd;=G;SP9GanWmG9AmUa?SfKXcLe:Bn<ggCG2dMZhgEk5a=nYk=/_A5/UHf
9A34^4MGHWTceBD<9KUUflP;K[mlc/QM=kLoL^6cSmcgb4o7QjmJ>ZGlaYeb[jb=
FG[KW/_jhgL/Wef@o_OQHfJ`U2LNo5Vffm2;fI30Li20PhkYQO>d;F:;^/DQEFXj
elDlBK8aWmgW64fBK=<TBM<61:78a/abZ[IRFi<]H]^?:cM=B0?CcPk;m^9^QcW[
e5j>_bgPm[jb@S6R3UjgBkNg@E[6A1>lCTnK3QUb5lcJM2i]PDBcTbE3N]YoUUjB
9KgUid[_E4_;jZW`1?Y>5?JM:d9<A/?D3DQB?C/38D`EY/^4fJaDZRTkoOU4oUGI
6Ff1V5<^mij<mib<[ciY[<<;/0kGBcDhlAc5OZF_n671CMWGimbHfeTP^bFQn:Q<
>=`C/n]c9PLgImlLg9?mnncg/]l;W/YgY6Nah[:ga;7RHbE7bThGWR`nFF;;ba[[
3[_KgL^b[/kJ@dmT_l/?IkjEMBckKl5?2e:J/mRX_5`a94E=INA?i;6l6=JMk=bB
G3egENjQg2>iLZhoaFTGAFU5o7PA:c;nU52JEF?R0Xn50fhCjkU3W3E5@@nlGBma
9h92W7Z_Q44kS_D/9_;dhGhMMOdj:_Yee?;[Z>7d/`Ad=bBYJ[eg27<=l@gQ<:D=
NWKBc=@b0P5OiMc_a5m?G4jO/lBIL<[>6:oAkFDn:5:NTc5VD6N6jS?dVX[F35JB
XFLLc?P`@l[8:ZekbO8Q>`Y=;k;5F9aFWnPogK7JV?0]7LJe1gbVVWhS0VaHd^;n
3YP0`hBj<f09Z0D^3:g^H1g63Hn;jOHZ0S1M0`HH=L>`[/<Z:l]:3J^Z:X<l6Okl
X:84Q^IGU6?:68MBQ^eP:3=:3@=B>IYm73mFl_Uc[ai8;@]UaSm9UFXNW[Ga=dmm
nFZ3Nl[TZF76/P_OZB^N=:ifCEDjoeOVKE^gGE6bo:>WcjnO=GKla<K7=]nk>bde
/cY_i?RJn5iEbBk=>jndXFIa>oAW2_CWd81mNE__V>aRnICW69[TMoWMoSBO9bnS
eSe??8XKRjA3OUH_gFOS`XDc/EC^6Y@RLQGQhVig:^LnG6;S:1Hc9CNTZ8>2:HiD
n2D`?GTJ;[K:MfX7=KiCPiMe^iK@l>LeUnKCSV/B?=C6af6Bo70FO=7D:o1mkWVR
2Ao[=/<8/CgMDjeY11_TPZ_@dK6jl:cO19nai^c<HIUEaJUEEH@?PMlV6mb553QC
aT;F@/IJ9PHTcPe91mDdBjh3G^DDE/Yl5cOM?>?AUeZgk6c[^gCH]EO>W7C3_<]W
;ImfZM`KCjl^no?KMl@ogc7[aIf/nm:KU_F]kKQ^bLgPlVY8Kb=VG`k]e/OTi;1@
DYR7aJDhkKfJGbf^TUL=gYbcTgk=]h_OI?lj9lYflBMB8h?C2^eSn2@^F1JU^9dD
hd=eAeI@LWRMK9nC@F>7jSG^X4>U?5K3E^:/6gM0?<5H<I9=^:?HP^E<HLijbcl@
:MV3do><9L^W7/OInm7LhG?==F_0^lIj_gYe/KEX[LK:ILW8G>Yaib5SICMDceRg
dPOF[@6e4d=IAT?lRnS;WgFaXHo]?I8Bom`NWSB[JnZ2QXH=[:^XmiT_gWb<UGLO
f3Xh??^J[iION=4Bf>_46o2^?i;bHDP[mCnjId=:bBk^4VU:V^Y;WYkLUVbc2eUf
>4ZBmN@5=9nefYZe^@ik]IPT9RTGdLFRTkKPn?h^AA/^RZ@R>Eo=/aGIOLWhDiNX
]5EZ9LV==9U=h]=4Xm@XCeDVZM>d<5dP`]ZUe<hFRCIYRK;HLKWd@ndZnaF>cG@3
fjA]8Mc[J?OJ7gAd9GlTAPQ5hO3S<L5T5AZQJSSM]L]2L2`bc855a0j^7CQWeQ@Q
HH>Ub[:Tf1d>a[QMje<ffQTFQoTHh@md^f5In/A6dkC<Oia_]35KS<oGTm[D[FY4
gJlNDFEh4/7MbRMRXlcT_JPWlBTTf<_jD2mWC]cB]7;QaG57:bjoe^?2HbOOQ`^J
3oWWg86SNS^>c@Me_hX_2Q^d^^m4Oh/;WPM28m9R90fofFDjcTH8@jCJG=FfjTe6
n:<3@0L64PLf^@iHk_<^dUdIi@X/]:hQ@PFJddRm4`Ff[=B0Ff>jdHHaBgFhg5D2
8>T6CZ/2nJ7MSR[b>J[/>7oJWEXUK:UE<_kB4Tf]XUSR;e7hhk745dSId;9AW^Tb
b_O[MVNE8m>9];>:6BKAN]2_VH8eln>GIXIlG?bOlJg/doPGK=@3^1iZRJNaY?Q1
5XZo1HTYlMMHlIToa[7IPYK5IdQO@Nllk0?mlGb1@h?dRKHKKDOBSm]T[dM?ilOB
C/TWU:lLdU7LX1bE?W98cl_?:Foc`n:`9>nFMbW?lnO4Li:lCFaGMo77aN>BO9Nh
DkY7^L?f49LgR9_Tfm9^m=c5iGElWKQ2_S9]4iO3]^WYUk1;]9DN^D5ZC9_;IhQV
EJh@HfaEfTAN;nAQO9RD[eE`ZDKKU=J59EVF/86B9:IMhG:jTkFn3A:C[_100FgH
K^Y1EL8N3<FBbXJB1a/93m@?o`ab1i>McS;M]L75EkVH:lIWjITNFnd6UOWD4]G`
Fk^PL4MP0Fa@]aYmQ4@ccGnL/KGB9bDNgK?1dnFAG0P>NHih9?:h?3i?VfLoTXZW
Ugm6PoP;gHl=J9VQH<Kbefm/972F0T<;cC:l5<>b0VLFYR12VCGm7LKY@BW[gfAT
7=RDLV10`oHH?UF?8kWLn>8mFW:i11be9i_ZQCdJC;>aeCSk[3IFC:?>LJR=2RGJ
kJjB2iaE6Z:kW5DNeeUE2N><`9nFWU4i>/g?DSR<nFSSR6076c8YAhaI56LUIeK=
J;UQ`@F[/lY7KI`SiIoio9FI3neRKgncnXjeMKjgW2lJGQ<UCP22^0onCdlZ<PE<
@A8i:@go4lRSHKQA3f9?F4l==94^`7fiXG5^P?4XU8EoN4nN>f56Hf7]j_J5bh_Z
ERiO<WW]`^G]RjO>Y_l3QWdhU@YUKVAcM79UHFd:IFiTKf9Z2S4d830PKf9Z2SPf
=30:IFiTKf9Z2S4e830PKf9Z2RQ]HF=?Db1FIG9cJFm^834`;S4d;SHPG2Q2MFU/
I20a>4Li<c8cG2TPDGEQLWAj8514AT=_KWAUN7@Y2VE^I6mRJPXa=R0`86mRJPXX
A3Xb<38b<34`=C4e=C8a=EX`<2L`<2LY2VE^I6mRJPXa830PKf9Z2S`l82m@LVmT
MF=ULR0a=B0`858P;d=bIF5dJFm^A65dIB0a=R0`858P;de_I4AQM6DP<CHP<21B
83hn2VE^I6mRJPYhLVEV2S0P<CL:<30`<30`<30`<20f=CDc=B1V80X`<30`<34c
=38d830`<30`86hP2S0`<30`<30g>CLP<30`<30PKR0:<30`<30`<cLf>20`<30`
<21^80X`<30`<30`<38b830`<30`86hP2S0`<30`<30g=cPP<30`<30PKR0:<30`
<30`<3T`<B0`<30`<21^80X`<30`<30c=c<c830`<30`86hP2S0`<30`<3<i<34P
<30`<30PKR0:<30`<30`<3Ti>20`<30`<21^80X`<30`<30c=c4b830`<30`86hP
2S0`<30`<3<h=C4P<30`<30PKR0:<30`<30`=38i<b0`<30`<21^80X`<30`<30d
=CDd830`<30`86hP2S0`<30`<C<b>3DP<30`<30PKR0:<30`<30a<c<`=R0`<30`
<21^80X`<30`<34c<cPb830`<30`86hP2WAbHFU/IG8:?3`P;e=YNVDP<CLP;e9_
Kg@P<C4P<21B82m9KVI_834P<21B82m9A21K83`c=c@dHCLhIS5UHCLg<39VHS5U
<f9S<SMVHCTbIC=T<Ch:?3<g=3AQ=cQV<FEQ=cL`<VIR<FDcHV<b=fIQ>C9U<f@a
?R1M83hn2W=dHG9dN79UIPXa<c@i>@XU9DE?APX\>"], "Graphics",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  ImageSize->{421, 241},
  ImageMargins->{{152.546875, 0.}, {0., -3.37890625}},ExpressionUUID->
  "850fe8b2-8f78-421c-a987-92b88f540db4"]
}], "Text",
 CellChangeTimes->{{3.8503190251576653`*^9, 3.8503191170851393`*^9}, {
  3.8503191483893347`*^9, 3.850319167085294*^9}, {3.850321555029256*^9, 
  3.8503215976735067`*^9}, {3.850323533827321*^9, 3.850323535103259*^9}, {
  3.850386726593082*^9, 
  3.850386741445951*^9}},ExpressionUUID->"18c97685-4e73-4a02-a407-\
1ee84d57cc63"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{
    RowBox[{"ay", ">", "0"}], "&&", 
    RowBox[{"bx", "<", "0"}], "&&", 
    RowBox[{"cy", "<", "0"}]}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pa", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "ay"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pb", "=", 
   RowBox[{"{", 
    RowBox[{"bx", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pc", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "cy"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pd", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pe", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.850319276437792*^9, 3.850319293493816*^9}, {
  3.850319547808049*^9, 3.85031955023884*^9}, {3.8503202264899673`*^9, 
  3.850320240896768*^9}, {3.8503213729579773`*^9, 3.85032139342047*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"be809f6e-3aac-47e7-bf7c-c72473994155"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Draw", " ", "an", " ", "illustrative", " ", "figure", " ", "using", " ", 
     "numerical", " ", "values", " ", "for", " ", "the", " ", "coordinates", 
     " ", "of", " ", "A"}], ",", " ", "B", ",", " ", "C", ",", " ", 
    RowBox[{"and", " ", "D"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "step", " ", "is", " ", "not", " ", "needed", " ", "for", " ",
     "the", " ", "proof"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"figCoords", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ay", "\[Rule]", 
        RowBox[{"3", "/", "5"}]}], ",", 
       RowBox[{"bx", "\[Rule]", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "4"}]}], ",", 
       RowBox[{"cy", "\[Rule]", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "3"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"quadrilateral", "=", 
     RowBox[{"{", 
      RowBox[{"Thick", ",", 
       RowBox[{"AbsolutePointSize", "[", "6", "]"}], ",", 
       "\[IndentingNewLine]", "Black", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Pa", ",", "Pb"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pb", ",", "Pc"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pc", ",", "Pd"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pd", ",", "Pa"}], "}"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", "Red", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Pa", ",", "Pc"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pb", ",", "Pd"}], "}"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", "Black", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"Pa", ",", "Pb", ",", "Pc", ",", "Pd"}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", "Red", ",", 
       RowBox[{"Point", "[", "Pe", "]"}], ",", "\[IndentingNewLine]", "Black",
        ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<A\>\"", ",", "Pa", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<B\>\"", ",", "Pb", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<C\>\"", ",", "Pc", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<D\>\"", ",", "Pd", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<E\>\"", ",", "Pe", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"quad", "=", 
    RowBox[{
     RowBox[{"Graphics", "[", "quadrilateral", "]"}], "/.", 
     "figCoords"}]}]}]}]], "Input",
 CellChangeTimes->{{3.8503193414142027`*^9, 3.850319539378461*^9}, {
   3.8503195907596684`*^9, 3.850319591607209*^9}, 3.850320545467311*^9, {
   3.850321408774033*^9, 3.850321415293414*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"69b15f4a-620d-4ff7-80c0-3387e1bb2120"],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0], AbsolutePointSize[6], Thickness[Large], 
   LineBox[NCache[{{{0, Rational[3, 5]}, {Rational[-1, 4], 0}}, {{
       Rational[-1, 4], 0}, {0, Rational[-1, 3]}}, {{0, Rational[-1, 3]}, {1, 
       0}}, {{1, 0}, {0, Rational[3, 5]}}}, {{{
       0, 0.6}, {-0.25, 0}}, {{-0.25, 0}, {0, -0.3333333333333333}}, {{
       0, -0.3333333333333333}, {1, 0}}, {{1, 0}, {0, 0.6}}}]], 
   {RGBColor[1, 0, 0], 
    LineBox[NCache[{{{0, Rational[3, 5]}, {0, Rational[-1, 3]}}, {{
        Rational[-1, 4], 0}, {1, 0}}}, {{{0, 0.6}, {
        0, -0.3333333333333333}}, {{-0.25, 0}, {1, 0}}}]]}, 
   {GrayLevel[0], 
    PointBox[NCache[{{0, Rational[3, 5]}, {Rational[-1, 4], 0}, {
       0, Rational[-1, 3]}, {1, 0}}, {{0, 0.6}, {-0.25, 0}, {
       0, -0.3333333333333333}, {1, 0}}]]}, 
   {RGBColor[1, 0, 0], PointBox[{0, 0}]}, 
   {GrayLevel[0], 
    InsetBox["\<\"A\"\>", NCache[{0, Rational[3, 5]}, {0, 0.6}], {2, -1}], 
    InsetBox["\<\"B\"\>", NCache[{Rational[-1, 4], 0}, {-0.25, 0}], {2, 2}], 
    InsetBox["\<\"C\"\>", 
     NCache[{0, Rational[-1, 3]}, {0, -0.3333333333333333}], {-2, 2}], 
    InsetBox["\<\"D\"\>", {1, 0}, {-3, -1}], 
    InsetBox["\<\"E\"\>", {0, 0}, {1, -1}]}}]], "Output",
 CellChangeTimes->{{3.850319434569591*^9, 3.850319522326097*^9}, 
   3.850319592459196*^9, 3.850320546899192*^9, 3.85032141648195*^9, 
   3.850321506240107*^9, 3.850331289659361*^9, 3.850367476525526*^9, 
   3.850373567547866*^9, 3.8503828765917883`*^9, 3.8503919800996647`*^9, {
   3.851077045057419*^9, 3.8510770663088017`*^9}, 3.851264919011772*^9, 
   3.851268124817192*^9, 3.851268548914646*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"bc664a9a-9b76-4aba-a48a-eb2cd8809289"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Specify", " ", "a", " ", "center", " ", "function", " ", "by", " ", 
    "giving", " ", "its", " ", "first", " ", "trilinear", " ", "coordinate"}],
    " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"centerFunction", "=", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Multiply", " ", "the", " ", "1", "st", " ", "trilinear", " ", 
     "coordinate", " ", "by", " ", "\"\<a\>\"", " ", "to", " ", "get", " ", 
     "the", " ", "1", "st", " ", "barycentric", " ", "coordinate"}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bary1", "=", 
     RowBox[{"centerFunction", "*", "a"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bary2", "=", 
     RowBox[{"bary1", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "b"}], ",", 
        RowBox[{"b", "\[Rule]", "c"}], ",", 
        RowBox[{"c", "\[Rule]", "a"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bary3", "=", 
     RowBox[{"bary2", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "b"}], ",", 
        RowBox[{"b", "\[Rule]", "c"}], ",", 
        RowBox[{"c", "\[Rule]", "a"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"barySum", "=", 
     RowBox[{"bary1", "+", "bary2", "+", "bary3"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.850319716976005*^9, 3.850319773635038*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"9f75c4ac-89c6-4b35-a81c-090440708f08"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Create", " ", "a", " ", "function", " ", "to", " ", "find", " ", "the", 
    " ", "distance", " ", "between", " ", "two", " ", "points"}], " ", "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"dist", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2_", ",", "y2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x2", "-", "x1"}], ")"}], "^", "2"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"y2", "-", "y1"}], ")"}], "^", "2"}]}], "]"}], "]"}], "//", 
    "PowerExpand"}]}]}]], "Input",
 CellChangeTimes->{{3.850319805216095*^9, 3.850319832359462*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"c25bf0f5-b532-4c6a-a7a2-b2ff16a46513"]
}, Closed]],

Cell[CellGroupData[{

Cell["Support for trig functions and miscellaneous functions", "Section",
 CellChangeTimes->{{3.850393856653619*^9, 3.850393866588462*^9}, {
  3.85126554736345*^9, 
  3.85126555392312*^9}},ExpressionUUID->"34d4cd20-b178-4c84-a892-\
921bf698231d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"convertToABCrule", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "A", "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}], "-", 
          RowBox[{"a", "^", "2"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "b", "*", "c"}], ")"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Cos", "[", "B", "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", "^", "2"}], "+", 
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c", "*", "a"}], ")"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Cos", "[", "C", "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "+", 
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "a", "*", "b"}], ")"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Sec", "[", "A", "]"}], "\[Rule]", 
       RowBox[{"2", "*", "b", "*", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}], "-", 
           RowBox[{"a", "^", "2"}]}], ")"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Sec", "[", "B", "]"}], "\[Rule]", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"a", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", "^", "2"}], "+", 
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Sec", "[", "C", "]"}], "\[Rule]", 
       RowBox[{"2", "*", "a", "*", 
        RowBox[{"b", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Sin", "[", "A", "]"}], "\[Rule]", " ", 
       RowBox[{"a", "/", 
        RowBox[{"(", 
         RowBox[{"2", "R"}], ")"}]}]}], ",", 
      RowBox[{
       RowBox[{"Sin", "[", "B", "]"}], "\[Rule]", " ", 
       RowBox[{"b", "/", 
        RowBox[{"(", 
         RowBox[{"2", "R"}], ")"}]}]}], ",", 
      RowBox[{
       RowBox[{"Sin", "[", "C", "]"}], "\[Rule]", " ", 
       RowBox[{"c", "/", 
        RowBox[{"(", 
         RowBox[{"2", "R"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"R", "\[Rule]", 
       RowBox[{"a", " ", "b", " ", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{"4", "K"}], ")"}]}]}]}], ",", " ", 
      RowBox[{"r", "\[Rule]", 
       RowBox[{"K", "/", "s"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Tan", "[", "A", "]"}], "\[Rule]", 
       RowBox[{"a", " ", "b", " ", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{"R", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", "^", "2"}], "+", 
             RowBox[{"c", "^", "2"}], "-", 
             RowBox[{"a", "^", "2"}]}], ")"}]}], ")"}]}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Tan", "[", "B", "]"}], "\[Rule]", 
       RowBox[{"a", " ", "b", " ", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{"R", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"c", "^", "2"}], "+", 
             RowBox[{"a", "^", "2"}], "-", 
             RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Tan", "[", "C", "]"}], "\[Rule]", 
       RowBox[{"a", " ", "b", " ", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{"R", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "+", 
             RowBox[{"b", "^", "2"}], "-", 
             RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"K", "\[Rule]", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"s", 
         RowBox[{"(", 
          RowBox[{"s", "-", "a"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"s", "-", "b"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"s", "-", "c"}], ")"}]}], "]"}]}], ",", " ", 
      RowBox[{"s", "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "+", "c"}], ")"}], "/", "2"}]}]}], "}"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"convertToABC", "[", "expr_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"expr1", ",", "expr2"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"expr1", "=", "expr"}], ";", "\[IndentingNewLine]", 
       RowBox[{"expr2", "=", 
        RowBox[{"TrigExpand", "[", "expr1", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"expr2", "=", 
        RowBox[{"expr2", "//.", "convertToABCrule"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"expr2", "=", 
        RowBox[{"Simplify", "[", "expr2", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "expr2", "]"}], ";"}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"factorNormal", "[", "expr_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "d1", ",", "d2", ",", "d3", ",", "den", ",", "e2", ",", "e3", ",", 
        "dif"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"e1", "=", 
        RowBox[{
         RowBox[{"convertToABC", "[", "expr", "]"}], "//", "Together"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"d1", "=", 
        RowBox[{"Denominator", "[", "e1", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"d2", "=", 
        RowBox[{"d1", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"a", "\[Rule]", "b"}], ",", 
           RowBox[{"b", "\[Rule]", "c"}], ",", 
           RowBox[{"c", "\[Rule]", "a"}]}], "}"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"d3", "=", 
        RowBox[{"d2", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"a", "\[Rule]", "b"}], ",", 
           RowBox[{"b", "\[Rule]", "c"}], ",", 
           RowBox[{"c", "\[Rule]", "a"}]}], "}"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "get", " ", "equivalent", " ", "function", " ", "with", " ", "no", 
         " ", "denominator"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"e2", "=", 
        RowBox[{"e1", "*", "d1", "*", "d2", "*", "d3"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"e3", "=", 
        RowBox[{"e2", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"a", "\[Rule]", "b"}], ",", 
           RowBox[{"b", "\[Rule]", "a"}]}], "}"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"dif", "=", 
        RowBox[{"e2", "-", "e3"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        RowBox[{"Factor", "[", "dif", "]"}], "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"factorNormalPlus", "[", "expr_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "d1", ",", "d2", ",", "d3", ",", "den", ",", "e2", ",", "e3", ",", 
      "sum"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"e1", "=", 
      RowBox[{
       RowBox[{"convertToABC", "[", "expr", "]"}], "//", "Together"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"d1", "=", 
      RowBox[{"Denominator", "[", "e1", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"d2", "=", 
      RowBox[{"d1", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "\[Rule]", "b"}], ",", 
         RowBox[{"b", "\[Rule]", "c"}], ",", 
         RowBox[{"c", "\[Rule]", "a"}]}], "}"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"d3", "=", 
      RowBox[{"d2", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "\[Rule]", "b"}], ",", 
         RowBox[{"b", "\[Rule]", "c"}], ",", 
         RowBox[{"c", "\[Rule]", "a"}]}], "}"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "get", " ", "equivalent", " ", "function", " ", "with", " ", "no", " ", 
       "denominator"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"e2", "=", 
      RowBox[{"e1", "*", "d1", "*", "d2", "*", "d3"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"e3", "=", 
      RowBox[{"e2", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "\[Rule]", "b"}], ",", 
         RowBox[{"b", "\[Rule]", "a"}]}], "}"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"sum", "=", 
      RowBox[{"e2", "+", "e3"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"Factor", "[", "sum", "]"}], "]"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.8503329681305847`*^9, 3.8503329938647223`*^9}, {
   3.850370074226844*^9, 3.8503700831932487`*^9}, {3.850371565003121*^9, 
   3.8503716308544807`*^9}, {3.850372531578465*^9, 3.850372578585475*^9}, {
   3.850372612945743*^9, 3.850372712573848*^9}, {3.851076730734282*^9, 
   3.851076731567481*^9}, {3.851076761751886*^9, 3.8510770552363234`*^9}, {
   3.8510777886677713`*^9, 3.851077803178615*^9}, 3.851077903285462*^9, {
   3.8510779521576853`*^9, 3.851077993157138*^9}, {3.851078282993573*^9, 
   3.851078305920265*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"f0f2e5ae-e9fa-4f25-9139-cd37393fad58"],

Cell[CellGroupData[{

Cell["Formula for intersection point of two lines", "Subsection",
 CellChangeTimes->{{3.8503836118447733`*^9, 
  3.850383632419755*^9}},ExpressionUUID->"06517a25-69eb-4688-8600-\
12e42e19bdf8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"equationOfLine", "[", 
     RowBox[{"P1_", ",", "P2_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1", ",", "y1", ",", "x2", ",", "y2", ",", "line"}], "}"}], 
      ",", "\n", 
      RowBox[{
       RowBox[{"x1", "=", 
        RowBox[{"P1", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ";", "\n", 
       RowBox[{"y1", "=", 
        RowBox[{"P1", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ";", "\n", 
       RowBox[{"x2", "=", 
        RowBox[{"P2", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ";", "\n", 
       RowBox[{"y2", "=", 
        RowBox[{"P2", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ";", "\n", 
       RowBox[{"line", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"YY", "-", "y1"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"x2", "-", "x1"}], ")"}]}], "==", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"y2", "-", "y1"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"XX", "-", "x1"}], ")"}]}]}]}], ";", "\n", 
       RowBox[{"Return", "[", "line", "]"}], ";"}]}], "\n", "]"}]}], ";"}], 
  "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Get", " ", "formula", " ", "for", " ", "point", " ", "of", " ", 
    "intersection", " ", "of", " ", "two", " ", "lines"}], " ", "*)"}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"pointOfIntersectionOfLines", "[", 
     RowBox[{"L1_", ",", "L2_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"sol", ",", "ans"}], "}"}], ",", "\n", 
      RowBox[{
       RowBox[{"sol", "=", 
        RowBox[{
         RowBox[{"Solve", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"L1", ",", "L2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"XX", ",", "YY"}], "}"}]}], "]"}], "//", "First"}]}], ";",
        "\n", 
       RowBox[{"ans", "=", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"XX", ",", "YY"}], "}"}], "/.", "sol"}]}], ";", "\n", 
       RowBox[{"Return", "[", "ans", "]"}], ";"}]}], "\n", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"pointOfIntersectionOfLines", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ax_", ",", "ay_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"bx_", ",", "by_"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"cx_", ",", "cy_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dx_", ",", "dy_"}], "}"}]}], "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"L1", ",", "L2", ",", "intersectionPoint"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"L1", "=", 
       RowBox[{"equationOfLine", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"ax", ",", "ay"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"bx", ",", "by"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"L2", "=", 
       RowBox[{"equationOfLine", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"cx", ",", "cy"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"dx", ",", "dy"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"intersectionPoint", "=", 
       RowBox[{"pointOfIntersectionOfLines", "[", 
        RowBox[{"L1", ",", "L2"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "intersectionPoint", "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.85038314361898*^9, {3.850383274652006*^9, 3.8503834518679457`*^9}, {
   3.8503835515162897`*^9, 3.85038357970826*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"e8f24f1b-ac05-4bcf-93e7-320c44a53fe5"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Quarter Triangles", "Section",
 CellChangeTimes->{{3.850367662817922*^9, 
  3.850367681472711*^9}},ExpressionUUID->"527f0677-9581-4518-b280-\
24f6883010ec"],

Cell[CellGroupData[{

Cell["Set up", "Subsection",
 CellChangeTimes->{{3.8510774599361773`*^9, 
  3.851077465628462*^9}},ExpressionUUID->"f7c42966-a1ae-46e5-bf1e-\
c809011485dd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Locate", " ", "the", " ", "points", " ", "F"}], ",", " ", "G", 
    ",", " ", "H", ",", " ", 
    RowBox[{
    "I", " ", "inside", " ", "the", " ", "quarter", " ", "triangles"}]}], " ",
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"lenAB", "=", 
     RowBox[{"dist", "[", 
      RowBox[{"Pa", ",", "Pb"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lenBC", "=", 
     RowBox[{"dist", "[", 
      RowBox[{"Pb", ",", "Pc"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lenCD", "=", 
     RowBox[{"dist", "[", 
      RowBox[{"Pc", ",", "Pd"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lenDA", "=", 
     RowBox[{"dist", "[", 
      RowBox[{"Pd", ",", "Pa"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lenAE", "=", 
     RowBox[{"dist", "[", 
      RowBox[{"Pa", ",", "Pe"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lenBE", "=", 
     RowBox[{"dist", "[", 
      RowBox[{"Pb", ",", "Pe"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lenCE", "=", 
     RowBox[{"dist", "[", 
      RowBox[{"Pc", ",", "Pe"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lenDE", "=", 
     RowBox[{"dist", "[", 
      RowBox[{"Pd", ",", "Pe"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sF", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"bary1", "*", "Pa"}], "+", 
         RowBox[{"bary2", "*", "Pb"}], "+", 
         RowBox[{"bary3", "*", "Pe"}]}], ")"}], "/", "barySum"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "lenBE"}], ",", 
        RowBox[{"b", "\[Rule]", "lenAE"}], ",", 
        RowBox[{"c", "\[Rule]", "lenAB"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sG", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"bary1", "*", "Pb"}], "+", 
         RowBox[{"bary2", "*", "Pc"}], "+", 
         RowBox[{"bary3", "*", "Pe"}]}], ")"}], "/", "barySum"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "lenCE"}], ",", 
        RowBox[{"b", "\[Rule]", "lenBE"}], ",", 
        RowBox[{"c", "\[Rule]", "lenBC"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"bary1", "*", "Pc"}], "+", 
         RowBox[{"bary2", "*", "Pd"}], "+", 
         RowBox[{"bary3", "*", "Pe"}]}], ")"}], "/", "barySum"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "lenDE"}], ",", 
        RowBox[{"b", "\[Rule]", "lenCE"}], ",", 
        RowBox[{"c", "\[Rule]", "lenCD"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sI", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"bary1", "*", "Pd"}], "+", 
         RowBox[{"bary2", "*", "Pa"}], "+", 
         RowBox[{"bary3", "*", "Pe"}]}], ")"}], "/", "barySum"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "lenAE"}], ",", 
        RowBox[{"b", "\[Rule]", "lenDE"}], ",", 
        RowBox[{"c", "\[Rule]", "lenDA"}]}], "}"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.85032008733659*^9, 3.85032008870809*^9}, {
   3.850321623729926*^9, 3.850321625533457*^9}, {3.850322159784513*^9, 
   3.850322160274661*^9}, 3.8503222039440517`*^9, {3.850392116408276*^9, 
   3.850392118015023*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"383fc154-a099-4c2d-86bd-455bb560b852"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Add", " ", "these", " ", "points", " ", "to", " ", "our", " ", 
    "illustrative", " ", "figure", " ", "using", " ", "a", " ", "simple", " ",
     "center", " ", "function"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"for", " ", "our", " ", "figure"}], ",", " ", 
    RowBox[{"use", " ", "the", " ", "symmedian", " ", "point"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "step", " ", "is", " ", "not", " ", "needed", " ", "for", " ",
     "the", " ", "proof"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"figF", "[", 
      RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", "a"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"symmedian", " ", "point"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pF", "=", 
     RowBox[{
      RowBox[{"sF", "/.", 
       RowBox[{"f", "\[Rule]", "figF"}]}], "/.", "figCoords"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pG", "=", 
     RowBox[{
      RowBox[{"sG", "/.", 
       RowBox[{"f", "\[Rule]", "figF"}]}], "/.", "figCoords"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pH", "=", 
     RowBox[{
      RowBox[{"sH", "/.", 
       RowBox[{"f", "\[Rule]", "figF"}]}], "/.", "figCoords"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pI", "=", 
     RowBox[{
      RowBox[{"sI", "/.", 
       RowBox[{"f", "\[Rule]", "figF"}]}], "/.", "figCoords"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"points", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"pF", ",", "pG", ",", "pH", ",", "pI"}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<F\>\"", ",", "pF", ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "0"}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<G\>\"", ",", "pG", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "2"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<H\>\"", ",", "pH", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "0"}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<I\>\"", ",", "pI", ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
       "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lines", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"Blue", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"pF", ",", "pG"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pH", ",", "pI"}], "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", "Green", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"pF", ",", "pI"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pG", ",", "pH"}], "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", "Red", ",", "Dashed", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"pF", ",", "pH"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pG", ",", "pI"}], "}"}]}], "}"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"quad", ",", "points", ",", "lines"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8503221721931343`*^9, 3.8503221940233994`*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"3f761a6d-a820-4a5d-b767-9a9acb1237d5"],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsolutePointSize[6], Thickness[Large], 
    LineBox[NCache[{{{0, Rational[3, 5]}, {Rational[-1, 4], 0}}, {{
        Rational[-1, 4], 0}, {0, Rational[-1, 3]}}, {{0, Rational[-1, 3]}, {1,
         0}}, {{1, 0}, {0, Rational[3, 5]}}}, {{{
        0, 0.6}, {-0.25, 0}}, {{-0.25, 0}, {0, -0.3333333333333333}}, {{
        0, -0.3333333333333333}, {1, 0}}, {{1, 0}, {0, 0.6}}}]], 
    {RGBColor[1, 0, 0], 
     LineBox[NCache[{{{0, Rational[3, 5]}, {0, Rational[-1, 3]}}, {{
         Rational[-1, 4], 0}, {1, 0}}}, {{{0, 0.6}, {
         0, -0.3333333333333333}}, {{-0.25, 0}, {1, 0}}}]]}, 
    {GrayLevel[0], 
     PointBox[NCache[{{0, Rational[3, 5]}, {Rational[-1, 4], 0}, {
        0, Rational[-1, 3]}, {1, 0}}, {{0, 0.6}, {-0.25, 0}, {
        0, -0.3333333333333333}, {1, 0}}]]}, 
    {RGBColor[1, 0, 0], PointBox[{0, 0}]}, 
    {GrayLevel[0], 
     InsetBox["\<\"A\"\>", NCache[{0, Rational[3, 5]}, {0, 0.6}], {2, -1}], 
     InsetBox["\<\"B\"\>", NCache[{Rational[-1, 4], 0}, {-0.25, 0}], {2, 2}], 
     InsetBox["\<\"C\"\>", 
      NCache[{0, Rational[-1, 3]}, {0, -0.3333333333333333}], {-2, 2}], 
     InsetBox["\<\"D\"\>", {1, 0}, {-3, -1}], 
     InsetBox["\<\"E\"\>", {0, 0}, {1, -1}]}}, {
    PointBox[NCache[{{Rational[-18, 169], Rational[15, 338]}, {
       Rational[-2, 25], Rational[-3, 50]}, {
       Rational[1, 20], Rational[-3, 20]}, {
       Rational[9, 68], Rational[15, 68]}}, {{-0.10650887573964497`, 
      0.04437869822485207}, {-0.08, -0.06}, {0.05, -0.15}, {
      0.1323529411764706, 0.22058823529411764`}}]], 
    InsetBox["\<\"F\"\>", 
     NCache[{Rational[-18, 169], Rational[15, 338]}, {-0.10650887573964497`, 
      0.04437869822485207}], {2, 0}], 
    InsetBox["\<\"G\"\>", 
     NCache[{Rational[-2, 25], Rational[-3, 50]}, {-0.08, -0.06}], {0, 2}], 
    InsetBox["\<\"H\"\>", 
     NCache[{Rational[1, 20], Rational[-3, 20]}, {0.05, -0.15}], {-3, 0}], 
    InsetBox["\<\"I\"\>", 
     NCache[{Rational[9, 68], Rational[15, 68]}, {0.1323529411764706, 
      0.22058823529411764`}], {3, -1}]}, {
    {RGBColor[0, 0, 1], 
     LineBox[NCache[{{{Rational[-18, 169], Rational[15, 338]}, {
         Rational[-2, 25], Rational[-3, 50]}}, {{
         Rational[1, 20], Rational[-3, 20]}, {
         Rational[9, 68], Rational[15, 68]}}}, {{{-0.10650887573964497`, 
       0.04437869822485207}, {-0.08, -0.06}}, {{0.05, -0.15}, {
       0.1323529411764706, 0.22058823529411764`}}}]]}, 
    {RGBColor[0, 1, 0], 
     LineBox[NCache[{{{Rational[-18, 169], Rational[15, 338]}, {
         Rational[9, 68], Rational[15, 68]}}, {{
         Rational[-2, 25], Rational[-3, 50]}, {
         Rational[1, 20], Rational[-3, 20]}}}, {{{-0.10650887573964497`, 
       0.04437869822485207}, {0.1323529411764706, 
       0.22058823529411764`}}, {{-0.08, -0.06}, {0.05, -0.15}}}]]}, 
    {RGBColor[1, 0, 0], Dashing[{Small, Small}], 
     LineBox[NCache[{{{Rational[-18, 169], Rational[15, 338]}, {
         Rational[1, 20], Rational[-3, 20]}}, {{
         Rational[-2, 25], Rational[-3, 50]}, {
         Rational[9, 68], Rational[15, 68]}}}, {{{-0.10650887573964497`, 
       0.04437869822485207}, {0.05, -0.15}}, {{-0.08, -0.06}, {
       0.1323529411764706, 0.22058823529411764`}}}]]}}}]], "Output",
 CellChangeTimes->{
  3.850320392276561*^9, 3.850320472061535*^9, 3.85032143550299*^9, 
   3.850321506370639*^9, 3.85032163689233*^9, 3.850322233893065*^9, 
   3.850331289787881*^9, 3.850367476646245*^9, 3.8503735676052017`*^9, 
   3.850382876649686*^9, 3.850391980194425*^9, {3.851077045159865*^9, 
   3.851077066388832*^9}, 3.851264919120661*^9, 3.851268124930071*^9, 
   3.8512685490057573`*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"ea4090a9-4642-4aaf-b380-22e4a38432a9"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Find", " ", "the", " ", "slopes", " ", "of", " ", "the", " ", 
    "diagonals"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{
    RowBox[{"slopeFH", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sH", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "-", 
        RowBox[{"sF", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sH", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "-", 
        RowBox[{"sF", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopeGI", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sG", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "-", 
        RowBox[{"sI", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sG", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "-", 
        RowBox[{"sI", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"productOfSlopes", "=", 
     RowBox[{"slopeFH", "*", "slopeGI"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.850322639228096*^9, 3.850322697840695*^9}, {
  3.850322856962872*^9, 3.8503228590574636`*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"19bea53b-4943-4f68-b0cd-771ccb694c5b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Note", " ", "that", " ", "the", " ", "central", " ", "quadrilateral", " ",
     "is", " ", "not", " ", "necessarily", " ", "orthodiagonal"}], " ", 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"numericProductOfSlopes", "=", 
     RowBox[{
      RowBox[{"productOfSlopes", "/.", 
       RowBox[{"f", "->", "figF"}]}], "/.", "figCoords"}]}], ";"}], 
   "\[IndentingNewLine]", "numericProductOfSlopes"}]}]], "Input",
 CellChangeTimes->{{3.8503218384065027`*^9, 3.850321896488906*^9}, {
  3.850322408809058*^9, 3.850322432959783*^9}, {3.850322773434289*^9, 
  3.8503227935534153`*^9}, {3.850322829826659*^9, 3.850322830625092*^9}, {
  3.8503228710748*^9, 3.8503228844986687`*^9}, {3.850322965250971*^9, 
  3.850323001754963*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"12d15a83-0565-40af-83bd-452df32833a7"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["313389", "190969"]}]], "Output",
 CellChangeTimes->{
  3.85032288551582*^9, {3.850322998672515*^9, 3.8503230028240223`*^9}, 
   3.850331289827099*^9, 3.850367476685074*^9, 3.8503735676391172`*^9, 
   3.85038287668193*^9, 3.8503919802323713`*^9, {3.851077045194253*^9, 
   3.851077066423512*^9}, 3.851264919147381*^9, 3.851268124956483*^9, 
   3.851268549039649*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"931433bb-d51a-48e4-9233-5be854fcaf41"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Theorem 5.34: Proof or normality", "Subsection",
 CellChangeTimes->{{3.85107757512109*^9, 3.8510776164642677`*^9}, {
  3.8510776674731073`*^9, 3.851077667905012*^9}, {3.851078019380568*^9, 
  3.85107802418854*^9}, {3.851265068534601*^9, 
  3.8512650729530582`*^9}},ExpressionUUID->"a0c9fe65-5704-4e64-a05f-\
f52c2ac54a26"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"factorNormal", "[", 
  RowBox[{"Sec", "[", "A", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.851078133614181*^9, 3.851078183758626*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"a9562b58-444b-40de-a2c3-c9e47050d454"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "a"}], "+", "b"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", "c", " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.851078135594619*^9, 3.851078184346032*^9}, 
   3.851264919170043*^9, 3.851268124964553*^9, 3.8512685490479927`*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"1e6064d8-857e-4172-b76d-c171313b4e2a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"factorNormal", "[", 
  RowBox[{"Tan", "[", "A", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.851078195918849*^9, 3.8510781964946623`*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"eb39ad6c-9dd5-408e-b818-5943368da257"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"(", 
   RowBox[{"a", "-", "b"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  SqrtBox[
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    SuperscriptBox["b", "4"], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    SuperscriptBox["c", "4"]}]]}]], "Output",
 CellChangeTimes->{3.8510781976176367`*^9, 3.851264919203176*^9, 
  3.851268124992865*^9, 3.851268549088417*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"38e000c3-5cff-4af7-b2be-d4838bf17990"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"factorNormal", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "B", "]"}], 
   RowBox[{"Cos", "[", "C", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.851077641138834*^9, 3.851077670672949*^9}, {
  3.851077817108317*^9, 3.8510778185544786`*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"90d07f02-38f6-43a4-acb1-44d4df2ca302"],

Cell[BoxData[
 RowBox[{"16", " ", 
  SuperscriptBox["a", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"a", "-", "b"}], ")"}], " ", 
  SuperscriptBox["b", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
  SuperscriptBox["c", "3"], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.851077910851832*^9, 3.851078007209138*^9, 
  3.8512649192252274`*^9, 3.8512681249998913`*^9, 3.851268549095995*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"bf006def-9086-4e76-b822-7adb54186d22"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"factorNormal", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "B", "]"}], "+", 
   RowBox[{"Tan", "[", "C", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.85107821021502*^9, 3.851078218078988*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"4a1fd764-cfeb-4f55-bb00-0bac238502ad"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{"a", "-", "b"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  SqrtBox[
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    SuperscriptBox["b", "4"], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    SuperscriptBox["c", "4"]}]]}]], "Output",
 CellChangeTimes->{3.8510782190405893`*^9, 3.8512649192529583`*^9, 
  3.851268125023971*^9, 3.8512685491358213`*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"27758cbc-aee2-4229-99ac-5ae1467085b0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"factorNormal", "[", 
  RowBox[{
   RowBox[{"Sec", "[", "B", "]"}], "+", 
   RowBox[{"Sec", "[", "C", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8510782454393167`*^9, 3.851078250727404*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"c50af15f-9b11-460a-a06b-469a02361d8d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "a"}], "+", "b"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", "c", " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "+", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.851078251442337*^9, 3.851264919275826*^9, 
  3.851268125052321*^9, 3.851268549184106*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"9ef854ed-7b1f-4d08-ae83-f0f39346fe16"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"factorNormalPlus", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{"2", "A"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.851078328152087*^9, 3.851078365209825*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"87e0735b-f73f-485a-b99d-2c0479f5e479"],

Cell[BoxData[
 RowBox[{"4", " ", 
  SuperscriptBox["a", "2"], " ", 
  SuperscriptBox["b", "2"], " ", 
  SuperscriptBox["c", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "4"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    SuperscriptBox["b", "4"], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.851078333648761*^9, 3.8510783658621607`*^9}, 
   3.851264919283257*^9, 3.851268125061083*^9, 3.851268549223284*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"a35a69a2-3329-4eec-b5b3-267784ec7cb1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"factorNormalPlus", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "B", "]"}], "+", 
   RowBox[{"Cos", "[", "C", "]"}], "-", 
   RowBox[{"Cos", "[", "A", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.851078387377133*^9, 3.851078400592991*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"d2bc3402-90fa-4b4e-8a19-bae2178d27ed"],

Cell[BoxData[
 RowBox[{"8", " ", 
  SuperscriptBox["a", "2"], " ", 
  SuperscriptBox["b", "2"], " ", 
  SuperscriptBox["c", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.851078393519382*^9, 3.8510784014999943`*^9}, 
   3.8512649193131847`*^9, 3.8512681250893183`*^9, 3.8512685492326*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"c08f6538-bc23-43e3-905d-e1d20280f9fb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"factorNormalPlus", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Cos", "[", "B", "]"}], "+", 
     RowBox[{"Cos", "[", "C", "]"}], "-", 
     RowBox[{"Cos", "[", "A", "]"}]}], ")"}], "^", 
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.851078428081235*^9, 3.851078436457683*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"a4088408-a403-4149-8fd2-63b941af97c1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "4"}], " ", "a", " ", "b", " ", 
  SuperscriptBox["c", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "3"], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b"}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"]}], "+", 
    SuperscriptBox["b", "3"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "c"}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "2"]}], "-", 
    SuperscriptBox["c", "3"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.85107843756645*^9, 3.851264919318781*^9, 
  3.8512681250961943`*^9, 3.8512685492715397`*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"33d0c40b-0b13-4073-8463-5626bc2af8ba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"factorNormalPlus", "[", 
  RowBox[{"Sec", "[", 
   RowBox[{"2", "A"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.851078454249498*^9, 3.851078455153358*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"b9d2411a-45f5-4a9b-bf18-1d49fd527aa9"],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox["c", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "4"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    SuperscriptBox["b", "4"], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "4"], "+", 
    SuperscriptBox["b", "4"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    SuperscriptBox["c", "4"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.851078455819323*^9, 3.851264919325783*^9, 
  3.8512681251029863`*^9, 3.8512685492787037`*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"dafd6af2-c910-473c-8c43-72beab37850e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"factorNormal", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"2", "A"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.851078473121936*^9, 3.851078539298006*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"959aa094-6085-428f-94ac-192255a3958e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "4"}], " ", 
  SuperscriptBox["a", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"a", "-", "b"}], ")"}], " ", 
  SuperscriptBox["b", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b"}], ")"}], " ", 
  SuperscriptBox["c", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  SqrtBox[
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    SuperscriptBox["b", "4"], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    SuperscriptBox["c", "4"]}]]}]], "Output",
 CellChangeTimes->{{3.851078481960088*^9, 3.851078540324766*^9}, 
   3.8512649193521633`*^9, 3.851268125129016*^9, 3.85126854931866*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"7c2e9efa-381e-465a-8ed1-41addb0a241c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"factorNormalPlus", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"4", "A"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.851078557810548*^9, 3.851078581970338*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"f14d3430-8219-4943-a901-418279b8fe12"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "4"}], " ", 
  SuperscriptBox["a", "4"], " ", 
  SuperscriptBox["b", "4"], " ", 
  SuperscriptBox["c", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  SqrtBox[
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    SuperscriptBox["b", "4"], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    SuperscriptBox["c", "4"]}]], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "8"], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "4"]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "6"]}], "+", 
    SuperscriptBox["b", "8"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "4"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.851078558473865*^9, 3.851078583037928*^9}, 
   3.851264919415619*^9, 3.851268125190757*^9, 3.851268549383765*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"612b245f-d0d7-4fff-8b43-e97828f84886"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"factorNormalPlus", "[", 
  RowBox[{
   RowBox[{"Sec", "[", "B", "]"}], "-", 
   RowBox[{"Sec", "[", "C", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.851078601419075*^9, 3.851078611147085*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"a5f1ca02-d0b4-479d-8ccd-8431cb81fe74"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "+", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", "b"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "4"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", "c"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["b", "4"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "4"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.851078612174057*^9, 3.8512649194377317`*^9, 
  3.851268125213663*^9, 3.8512685494258223`*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"24d52d9f-b38d-427b-9613-f25073105971"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"factorNormalPlus", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "B", "]"}], "-", 
   RowBox[{"Tan", "[", "C", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.851078657315543*^9, 3.85107866153959*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"d00e202b-375b-4791-a945-546977ed605a"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "+", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "4"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    SuperscriptBox["b", "4"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["c", "4"]}]}], ")"}], " ", 
  SqrtBox[
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    SuperscriptBox["b", "4"], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    SuperscriptBox["c", "4"]}]]}]], "Output",
 CellChangeTimes->{3.8510786625567627`*^9, 3.851264919470973*^9, 
  3.851268125245118*^9, 3.851268549468605*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"341e19fd-d0e9-4295-805c-f4fec56bb057"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"factorNormalPlus", "[", 
  RowBox[{"Tan", "[", "B", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.851078678611676*^9, 3.851078682851635*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"89d0217a-0dfb-4e62-9c57-9af5f81d84c5"],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox["c", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  SqrtBox[
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    SuperscriptBox["b", "4"], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    SuperscriptBox["c", "4"]}]]}]], "Output",
 CellChangeTimes->{3.851078683842358*^9, 3.851264919485138*^9, 
  3.8512681252702217`*^9, 3.8512685494832287`*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"813750da-3f9f-4bd5-93ab-4e0667ffadfa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"factorNormal", "[", 
  RowBox[{
   RowBox[{"Sec", "[", "B", "]"}], "-", 
   RowBox[{"Sec", "[", "C", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.85108879128339*^9, 3.851088850181156*^9}, {
  3.8510890500475283`*^9, 3.851089056718072*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"8c970b04-a6df-4fbb-b21e-0c969a1aa741"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "a"}], "+", "b"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", "c", " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "+", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.851088805506905*^9, 3.851088851337778*^9}, 
   3.851089058994479*^9, 3.851264919507408*^9, 3.851268125278109*^9, 
   3.851268549522354*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"d8e0f5a4-63d0-4f8a-8203-16cec4d5979e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"factorNormal", "[", 
  RowBox[{"Sec", "[", "B", "]"}], "]"}]], "Input",
 CellChangeTimes->{3.8510891064866743`*^9},
 CellLabel->"In[63]:=",ExpressionUUID->"bfe0eb25-2268-4555-87b9-5a1068bbb709"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "a"}], "+", "b"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", "c", " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.85108910788693*^9, 3.851264919513578*^9, 
  3.851268125298707*^9, 3.8512685495288763`*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"3a3c363f-dc11-4015-9abc-5dec3bb6695b"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Proof that if the center is the incenter, then FGHI is orthodiagonal\
\>", "Subsection",
 CellChangeTimes->{{3.850367720388095*^9, 3.8503677251030617`*^9}, {
  3.8503677897854433`*^9, 3.850367862617402*^9}, {3.850368005229785*^9, 
  3.850368032410331*^9}, {3.850368421491611*^9, 
  3.850368434323867*^9}},ExpressionUUID->"4f7bb391-bb1e-4f3d-804d-\
b7067ad7b5db"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"givenF3", "=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "\[Rule]", "1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"symbolicProductOfSlopes", "=", 
   RowBox[{"productOfSlopes", "/.", "givenF3"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "symbolicProductOfSlopes", "]"}]}], "Input",
 CellChangeTimes->{{3.8503264870771027`*^9, 3.850326495612938*^9}, 
   3.850326578750822*^9, {3.850331379886306*^9, 3.850331380428259*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"64a65b6a-6a25-4096-bdb3-1c15f7c598fd"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellChangeTimes->{
  3.850326505300095*^9, 3.8503265799627*^9, 3.850331297467287*^9, 
   3.850331381854508*^9, 3.850367476873391*^9, 3.850373572186325*^9, 
   3.850382881387603*^9, 3.850391985081602*^9, {3.851077049805987*^9, 
   3.851077070878286*^9}, 3.851264919536508*^9, 3.851268125306535*^9, 
   3.851268549567277*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"72b44ae8-1455-4086-912f-801d5ea98986"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Theorem 5.35: if the center is X(151), then FGHI is equidiagonal\
\>", "Subsection",
 CellChangeTimes->{{3.8503749575296717`*^9, 3.8503750118242064`*^9}, {
  3.851265390690812*^9, 
  3.851265399898448*^9}},ExpressionUUID->"192f5fdb-dcbf-4271-b8ea-\
12d18778659d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Find", " ", "the", " ", "lengths", " ", "of", " ", "the", " ", 
    "diagonals", " ", "of", " ", "quadrilateral", " ", "FGHI"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"lenFH", "=", 
     RowBox[{"dist", "[", 
      RowBox[{"sF", ",", "sH"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lenGI", "=", 
     RowBox[{"dist", "[", 
      RowBox[{"sG", ",", "sI"}], "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.8503753047536707`*^9, 3.850375317345728*^9}, {
  3.85037534957097*^9, 3.850375364507098*^9}, {3.850375510394163*^9, 
  3.850375522473875*^9}, {3.850375561562639*^9, 3.850375587370152*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"3dabcd7b-7286-4d88-9e0a-4b91a1fa5451"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Get", " ", "the", " ", "center", " ", "function", " ", "for", " ", "X", 
    RowBox[{"(", "151", ")"}], " ", "from", " ", "ETC"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"givenF", "=", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "\[Rule]", 
     RowBox[{"b", " ", "c", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "12"}], "+", 
        RowBox[{
         RowBox[{"a", "^", "11"}], " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"a", "^", "10"}], " ", "b", " ", "c"}], "+", 
        RowBox[{
         RowBox[{"a", "^", "9"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            RowBox[{"b", "^", "3"}]}], "-", 
           RowBox[{
            RowBox[{"b", "^", "2"}], " ", "c"}], "-", 
           RowBox[{"b", " ", 
            RowBox[{"c", "^", "2"}]}], "+", 
           RowBox[{"3", " ", 
            RowBox[{"c", "^", "3"}]}]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"a", "^", "8"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            RowBox[{"b", "^", "4"}]}], "+", 
           RowBox[{
            RowBox[{"b", "^", "3"}], " ", "c"}], "+", 
           RowBox[{"b", " ", 
            RowBox[{"c", "^", "3"}]}], "+", 
           RowBox[{"3", " ", 
            RowBox[{"c", "^", "4"}]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"a", "^", "7"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"7", " ", 
            RowBox[{"b", "^", "5"}]}], "+", 
           RowBox[{
            RowBox[{"b", "^", "4"}], " ", "c"}], "-", 
           RowBox[{"4", " ", 
            RowBox[{"b", "^", "3"}], " ", 
            RowBox[{"c", "^", "2"}]}], "-", 
           RowBox[{"4", " ", 
            RowBox[{"b", "^", "2"}], " ", 
            RowBox[{"c", "^", "3"}]}], "+", 
           RowBox[{"b", " ", 
            RowBox[{"c", "^", "4"}]}], "+", 
           RowBox[{"7", " ", 
            RowBox[{"c", "^", "5"}]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"a", "^", "6"}], " ", "b", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "4"}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"b", "^", "3"}], " ", "c"}], "-", 
           RowBox[{"6", " ", 
            RowBox[{"b", "^", "2"}], " ", 
            RowBox[{"c", "^", "2"}]}], "-", 
           RowBox[{"2", " ", "b", " ", 
            RowBox[{"c", "^", "3"}]}], "+", 
           RowBox[{"c", "^", "4"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"a", "^", "5"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"7", " ", 
            RowBox[{"b", "^", "7"}]}], "+", 
           RowBox[{
            RowBox[{"b", "^", "6"}], " ", "c"}], "-", 
           RowBox[{"5", " ", 
            RowBox[{"b", "^", "5"}], " ", 
            RowBox[{"c", "^", "2"}]}], "-", 
           RowBox[{"3", " ", 
            RowBox[{"b", "^", "4"}], " ", 
            RowBox[{"c", "^", "3"}]}], "-", 
           RowBox[{"3", " ", 
            RowBox[{"b", "^", "3"}], " ", 
            RowBox[{"c", "^", "4"}]}], "-", 
           RowBox[{"5", " ", 
            RowBox[{"b", "^", "2"}], " ", 
            RowBox[{"c", "^", "5"}]}], "+", 
           RowBox[{"b", " ", 
            RowBox[{"c", "^", "6"}]}], "+", 
           RowBox[{"7", " ", 
            RowBox[{"c", "^", "7"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"a", "^", "4"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            RowBox[{"b", "^", "8"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"b", "^", "7"}], " ", "c"}], "-", 
           RowBox[{"4", " ", 
            RowBox[{"b", "^", "6"}], " ", 
            RowBox[{"c", "^", "2"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"b", "^", "5"}], " ", 
            RowBox[{"c", "^", "3"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"b", "^", "4"}], " ", 
            RowBox[{"c", "^", "4"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"b", "^", "3"}], " ", 
            RowBox[{"c", "^", "5"}]}], "-", 
           RowBox[{"4", " ", 
            RowBox[{"b", "^", "2"}], " ", 
            RowBox[{"c", "^", "6"}]}], "+", 
           RowBox[{"2", " ", "b", " ", 
            RowBox[{"c", "^", "7"}]}], "+", 
           RowBox[{"3", " ", 
            RowBox[{"c", "^", "8"}]}]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"a", "^", "3"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            RowBox[{"b", "^", "9"}]}], "-", 
           RowBox[{
            RowBox[{"b", "^", "8"}], " ", "c"}], "+", 
           RowBox[{"8", " ", 
            RowBox[{"b", "^", "6"}], " ", 
            RowBox[{"c", "^", "3"}]}], "-", 
           RowBox[{"10", " ", 
            RowBox[{"b", "^", "5"}], " ", 
            RowBox[{"c", "^", "4"}]}], "-", 
           RowBox[{"10", " ", 
            RowBox[{"b", "^", "4"}], " ", 
            RowBox[{"c", "^", "5"}]}], "+", 
           RowBox[{"8", " ", 
            RowBox[{"b", "^", "3"}], " ", 
            RowBox[{"c", "^", "6"}]}], "-", 
           RowBox[{"b", " ", 
            RowBox[{"c", "^", "8"}]}], "+", 
           RowBox[{"3", " ", 
            RowBox[{"c", "^", "9"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"a", "^", "2"}], " ", "b", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "8"}], "-", 
           RowBox[{"4", " ", 
            RowBox[{"b", "^", "7"}], " ", "c"}], "-", 
           RowBox[{"12", " ", 
            RowBox[{"b", "^", "6"}], " ", 
            RowBox[{"c", "^", "2"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"b", "^", "5"}], " ", 
            RowBox[{"c", "^", "3"}]}], "+", 
           RowBox[{"22", " ", 
            RowBox[{"b", "^", "4"}], " ", 
            RowBox[{"c", "^", "4"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"b", "^", "3"}], " ", 
            RowBox[{"c", "^", "5"}]}], "-", 
           RowBox[{"12", " ", 
            RowBox[{"b", "^", "2"}], " ", 
            RowBox[{"c", "^", "6"}]}], "-", 
           RowBox[{"4", " ", "b", " ", 
            RowBox[{"c", "^", "7"}]}], "+", 
           RowBox[{"c", "^", "8"}]}], ")"}]}], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "11"}], "+", 
           RowBox[{
            RowBox[{"b", "^", "10"}], " ", "c"}], "-", 
           RowBox[{"3", " ", 
            RowBox[{"b", "^", "9"}], " ", 
            RowBox[{"c", "^", "2"}]}], "-", 
           RowBox[{"3", " ", 
            RowBox[{"b", "^", "8"}], " ", 
            RowBox[{"c", "^", "3"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"b", "^", "7"}], " ", 
            RowBox[{"c", "^", "4"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"b", "^", "6"}], " ", 
            RowBox[{"c", "^", "5"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"b", "^", "5"}], " ", 
            RowBox[{"c", "^", "6"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"b", "^", "4"}], " ", 
            RowBox[{"c", "^", "7"}]}], "-", 
           RowBox[{"3", " ", 
            RowBox[{"b", "^", "3"}], " ", 
            RowBox[{"c", "^", "8"}]}], "-", 
           RowBox[{"3", " ", 
            RowBox[{"b", "^", "2"}], " ", 
            RowBox[{"c", "^", "9"}]}], "+", 
           RowBox[{"b", " ", 
            RowBox[{"c", "^", "10"}]}], "+", 
           RowBox[{"c", "^", "11"}]}], ")"}]}], "-", 
        RowBox[{"b", "^", "12"}], "-", 
        RowBox[{
         RowBox[{"b", "^", "11"}], " ", "c"}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"b", "^", "10"}], " ", 
         RowBox[{"c", "^", "2"}]}], "+", 
        RowBox[{"3", " ", 
         RowBox[{"b", "^", "9"}], " ", 
         RowBox[{"c", "^", "3"}]}], "-", 
        RowBox[{"7", " ", 
         RowBox[{"b", "^", "8"}], " ", 
         RowBox[{"c", "^", "4"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"b", "^", "7"}], " ", 
         RowBox[{"c", "^", "5"}]}], "+", 
        RowBox[{"8", " ", 
         RowBox[{"b", "^", "6"}], " ", 
         RowBox[{"c", "^", "6"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"b", "^", "5"}], " ", 
         RowBox[{"c", "^", "7"}]}], "-", 
        RowBox[{"7", " ", 
         RowBox[{"b", "^", "4"}], " ", 
         RowBox[{"c", "^", "8"}]}], "+", 
        RowBox[{"3", " ", 
         RowBox[{"b", "^", "3"}], " ", 
         RowBox[{"c", "^", "9"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"b", "^", "2"}], " ", 
         RowBox[{"c", "^", "10"}]}], "-", 
        RowBox[{"b", " ", 
         RowBox[{"c", "^", "11"}]}], "-", 
        RowBox[{"c", "^", "12"}]}], ")"}]}]}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.850375388121984*^9, 3.850375424955517*^9}, 
   3.850376565168343*^9},
 CellLabel->"In[69]:=",ExpressionUUID->"a10531a8-4c9b-4fea-a781-1ee72483bc55"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"FGHI", " ", "is", " ", "equidiagonal", " ", "if", " ", "FH"}], 
   "=", 
   RowBox[{
    RowBox[{"GI", " ", "or", " ", "equivalently", " ", 
     RowBox[{"FH", "^", "2"}]}], "=", 
    RowBox[{"GI", "^", "2"}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.850375446643217*^9, 3.850375485369809*^9}, {
  3.8503756624584103`*^9, 3.8503757117064953`*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"36ce98ad-cd9e-426f-9389-243e6797726d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"symbolicDif", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"lenFH", "^", "2"}], "-", 
     RowBox[{"lenGI", "^", "2"}]}], "/.", "givenF"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"symbolicDif", ",", 
    RowBox[{"TimeConstraint", "\[Rule]", "1"}]}], "]"}], "//", 
  "Quiet"}]}], "Input",
 CellChangeTimes->{{3.8503757689951277`*^9, 3.8503757947902107`*^9}, 
   3.8503760517732763`*^9, 3.850376091845244*^9, {3.850380999652454*^9, 
   3.85038100433988*^9}, {3.850381041653077*^9, 3.8503810438916388`*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"231127d0-9944-4960-ba74-0ee74ff9d6ad"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.850375844303219*^9, {3.850376088089755*^9, 3.850376095069427*^9}, 
   3.850376638853696*^9, {3.850381021436108*^9, 3.8503810451625757`*^9}, 
   3.85038288961812*^9, 3.850382939896657*^9, 3.8503919931988792`*^9, {
   3.8510770577205772`*^9, 3.851077077837825*^9}, 3.8512649241366253`*^9, 
   3.851268129842325*^9, 3.8512685542476063`*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"db8e023c-baf7-479c-9e77-1ad74af347b6"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Theorem 5.36: if the center is X(6), then FGHI is cyclic", "Subsection",
 CellChangeTimes->{{3.8503749575296717`*^9, 3.8503750118242064`*^9}, {
   3.85038368170011*^9, 3.850383685612054*^9}, {3.8512654670589867`*^9, 
   3.851265474418703*^9}, 
   3.851265585875127*^9},ExpressionUUID->"deb3417f-1391-40c9-838b-\
9982ece4fe00"],

Cell["\<\
Let P be the intersection of FH and GI.
Then FGHI will be cyclic if PF*PH=PG*PI.\
\>", "Text",
 CellChangeTimes->{{3.850383694942358*^9, 3.850383758140072*^9}, 
   3.850388568843919*^9},ExpressionUUID->"ca43bcfc-1b5f-47e9-baf5-\
1f597b91d86a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"givenF", "=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "\[Rule]", "a"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"sF", ",", "sH"}], "}"}], "/.", "givenF"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"sG", ",", "sI"}], "}"}], "/.", "givenF"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"gP", "=", 
  RowBox[{
   RowBox[{"pointOfIntersectionOfLines", "[", 
    RowBox[{"p1", ",", "p2"}], "]"}], "//", "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.850383777934346*^9, 3.850383843062056*^9}, {
   3.8503838765015697`*^9, 3.8503839388687153`*^9}, 3.850383991758665*^9, 
   3.850384263247272*^9},
 CellLabel->"In[73]:=",ExpressionUUID->"3b57d3c0-3a01-4765-bd80-6182f4b77fdb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["ay", "2"], " ", "bx", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "bx"}], ")"}], " ", 
     SuperscriptBox["cy", "2"]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["bx", "2"], " ", 
        SuperscriptBox["cy", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["ay", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["cy", "2"], "+", 
          RowBox[{
           SuperscriptBox["bx", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["cy", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}]], ",", 
   FractionBox[
    RowBox[{"ay", " ", 
     SuperscriptBox["bx", "2"], " ", "cy", " ", 
     RowBox[{"(", 
      RowBox[{"ay", "+", "cy"}], ")"}]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["bx", "2"], " ", 
        SuperscriptBox["cy", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["ay", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["cy", "2"], "+", 
          RowBox[{
           SuperscriptBox["bx", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["cy", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}]]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.850383825072455*^9, {3.850383929471216*^9, 3.85038393997548*^9}, 
   3.85038399287724*^9, 3.850384263919498*^9, 3.850387625884363*^9, 
   3.850391993266129*^9, {3.85107705780164*^9, 3.8510770778897943`*^9}, 
   3.851264924203801*^9, 3.851268129901209*^9, 3.851268554337593*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"1dd2831a-d1f2-4f8b-a19b-20d0e663d20b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"gF", "=", 
   RowBox[{"sF", "/.", "givenF"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gG", "=", 
   RowBox[{"sG", "/.", "givenF"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gH", "=", 
   RowBox[{"sH", "/.", "givenF"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gI", "=", 
   RowBox[{"sI", "/.", "givenF"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenPF", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"gP", ",", "gF"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenPG", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"gP", ",", "gG"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenPH", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"gP", ",", "gH"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenPI", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"gP", ",", "gI"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prod1", "=", 
   RowBox[{
    RowBox[{"lenPF", "^", "2"}], "*", 
    RowBox[{"lenPH", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prod2", "=", 
   RowBox[{
    RowBox[{"lenPG", "^", "2"}], "*", 
    RowBox[{"lenPI", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"prod1", "-", "prod2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.850383964543879*^9, 3.850383965069236*^9}, {
  3.850383996189036*^9, 3.850384123069797*^9}, {3.850384172023942*^9, 
  3.850384354591378*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"3fc84274-b0b3-4479-a898-6799ee165b00"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.8503843555314827`*^9, 3.850387630600873*^9, 3.8503919933585443`*^9, {
   3.851077058065201*^9, 3.8510770778966208`*^9}, 3.851264924466927*^9, 
   3.851268130167725*^9, 3.851268554620891*^9},
 CellLabel->"Out[87]=",ExpressionUUID->"3cbd4729-f002-47a4-8c0d-5bd294be7a00"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["gP"], "Input",
 CellChangeTimes->{{3.850387633234809*^9, 3.8503876488339233`*^9}, 
   3.85038803737926*^9},
 CellLabel->"In[88]:=",ExpressionUUID->"0caac5cb-3658-4376-b9f6-54099e8141b3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["ay", "2"], " ", "bx", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "bx"}], ")"}], " ", 
     SuperscriptBox["cy", "2"]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["bx", "2"], " ", 
        SuperscriptBox["cy", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["ay", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["cy", "2"], "+", 
          RowBox[{
           SuperscriptBox["bx", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["cy", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}]], ",", 
   FractionBox[
    RowBox[{"ay", " ", 
     SuperscriptBox["bx", "2"], " ", "cy", " ", 
     RowBox[{"(", 
      RowBox[{"ay", "+", "cy"}], ")"}]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["bx", "2"], " ", 
        SuperscriptBox["cy", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["ay", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["cy", "2"], "+", 
          RowBox[{
           SuperscriptBox["bx", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["cy", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}]]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.850387634972534*^9, 3.850387649309044*^9}, 
   3.850388038360695*^9, 3.850391993365684*^9, {3.851077058071968*^9, 
   3.8510770779306107`*^9}, 3.85126492447379*^9, 3.851268130174666*^9, 
   3.851268554627617*^9},
 CellLabel->"Out[88]=",ExpressionUUID->"a5125932-f694-4317-8591-97bf203d597a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Theorem 5.37: if the center is k Cos[A]+Sin[A](Tan[A]+Tan[B]+Tan[C]), then \
FGHI is cyclic\
\>", "Subsection",
 CellChangeTimes->{{3.8503749575296717`*^9, 3.8503750118242064`*^9}, {
  3.85038368170011*^9, 3.850383685612054*^9}, {3.8512654670589867`*^9, 
  3.851265474418703*^9}, {3.851265578819463*^9, 3.8512655952431087`*^9}, {
  3.851266104976555*^9, 
  3.8512661090446444`*^9}},ExpressionUUID->"d52d2e33-a473-41d4-a9a9-\
ff584660e09e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"abcFn", "=", 
  RowBox[{"convertToABC", "[", 
   RowBox[{
    RowBox[{"k", " ", 
     RowBox[{"Cos", "[", "A", "]"}]}], "+", 
    RowBox[{
     RowBox[{"Sin", "[", "A", "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Tan", "[", "A", "]"}], "+", 
       RowBox[{"Tan", "[", "B", "]"}], "+", 
       RowBox[{"Tan", "[", "C", "]"}]}], ")"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851265747651463*^9, 3.851265774325132*^9}, {
  3.8512658988773003`*^9, 3.8512659228515673`*^9}},
 CellLabel->"In[89]:=",ExpressionUUID->"1e756ef6-dc67-4fe4-9132-21c2b2f2abc2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "k"}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["a", "8"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "k"}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", "k"}], ")"}]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["b", "4"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["c", "4"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "k"}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["b", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "k"}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["c", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "k"}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "k"}], ")"}]}]}], ")"}]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"2", " ", "b", " ", "c", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.8512657656083193`*^9, 3.851265775589469*^9}, 
   3.851265831702639*^9, 3.8512659239970493`*^9, 3.851268130228077*^9, 
   3.851268554683247*^9},
 CellLabel->"Out[89]=",ExpressionUUID->"eb7d1d05-2cab-43b7-bfcf-2756146fbffb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"abcFn", "=", 
  RowBox[{"a", "*", 
   RowBox[{"Numerator", "[", "abcFn", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.851265788907606*^9, 3.851265801515279*^9}, {
  3.851265946245282*^9, 3.851265961076323*^9}},
 CellLabel->"In[90]:=",ExpressionUUID->"65db897a-87a3-4e3d-87ca-8abd731c2ad0"],

Cell[BoxData[
 RowBox[{"a", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "k"}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["a", "8"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "k"}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", "k"}], ")"}]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["b", "4"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["c", "4"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "k"}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["b", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "k"}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["c", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "k"}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "k"}], ")"}]}]}], ")"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.851265802562842*^9, 3.8512658348370657`*^9}, 
   3.851265966880365*^9, 3.851268130235327*^9, 3.851268554690401*^9},
 CellLabel->"Out[90]=",ExpressionUUID->"3667574d-3d76-49c5-a191-87079223e08e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"abcFn", ",", "k", ",", "Factor"}], "]"}]], "Input",
 CellChangeTimes->{{3.851265973660336*^9, 3.851265984515848*^9}},
 CellLabel->"In[91]:=",ExpressionUUID->"cf2c93b3-fab3-4751-9333-48565112230d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "a"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "-", "b", "-", "c"}], ")"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "-", "c"}], ")"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "-", "b", "+", "c"}], ")"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}], "2"]}], "-", 
  RowBox[{"a", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], ")"}], " ", "k"}]}]], "Output",
 CellChangeTimes->{3.851265985424947*^9, 3.85126813025774*^9, 
  3.851268554727564*^9},
 CellLabel->"Out[91]=",ExpressionUUID->"4bc24384-225e-42ff-b45e-8dbec3612d19"]
}, Open  ]],

Cell["\<\
Let P be the intersection of FH and GI.
Then FGHI will be cyclic if PF*PH=PG*PI.\
\>", "Text",
 CellChangeTimes->{{3.850383694942358*^9, 3.850383758140072*^9}, 
   3.850388568843919*^9},ExpressionUUID->"0f2e5b44-5fea-439b-a5a2-\
c01d8deef252"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"givenF", "=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "\[Rule]", "abcFn"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"sF", ",", "sH"}], "}"}], "/.", "givenF"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"sG", ",", "sI"}], "}"}], "/.", "givenF"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"gP", "=", 
  RowBox[{
   RowBox[{"pointOfIntersectionOfLines", "[", 
    RowBox[{"p1", ",", "p2"}], "]"}], "//", "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.850383777934346*^9, 3.850383843062056*^9}, {
   3.8503838765015697`*^9, 3.8503839388687153`*^9}, 3.850383991758665*^9, 
   3.850384263247272*^9, 3.851265812687378*^9},
 CellLabel->"In[92]:=",ExpressionUUID->"820ee153-4da0-4840-bdfd-f6c760c5c3b0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["ay", "2"], " ", "bx", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "bx"}], ")"}], " ", 
     SuperscriptBox["cy", "2"]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["bx", "2"], " ", 
        SuperscriptBox["cy", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["ay", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["cy", "2"], "+", 
          RowBox[{
           SuperscriptBox["bx", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["cy", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}]], ",", 
   FractionBox[
    RowBox[{"ay", " ", 
     SuperscriptBox["bx", "2"], " ", "cy", " ", 
     RowBox[{"(", 
      RowBox[{"ay", "+", "cy"}], ")"}]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["bx", "2"], " ", 
        SuperscriptBox["cy", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["ay", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["cy", "2"], "+", 
          RowBox[{
           SuperscriptBox["bx", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["cy", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}]]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.850383825072455*^9, {3.850383929471216*^9, 3.85038393997548*^9}, 
   3.85038399287724*^9, 3.850384263919498*^9, 3.850387625884363*^9, 
   3.850391993266129*^9, {3.85107705780164*^9, 3.8510770778897943`*^9}, 
   3.851264924203801*^9, {3.851265815069612*^9, 3.851265844150022*^9}, 
   3.851266065859565*^9, 3.8512681303723288`*^9, 3.8512685548464746`*^9},
 CellLabel->"Out[95]=",ExpressionUUID->"d70a32d9-bfd0-4fbc-b9c6-4696b66da362"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"gF", "=", 
   RowBox[{"sF", "/.", "givenF"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gG", "=", 
   RowBox[{"sG", "/.", "givenF"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gH", "=", 
   RowBox[{"sH", "/.", "givenF"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gI", "=", 
   RowBox[{"sI", "/.", "givenF"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenPF", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"gP", ",", "gF"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenPG", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"gP", ",", "gG"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenPH", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"gP", ",", "gH"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenPI", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"gP", ",", "gI"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prod1", "=", 
   RowBox[{
    RowBox[{"lenPF", "^", "2"}], "*", 
    RowBox[{"lenPH", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prod2", "=", 
   RowBox[{
    RowBox[{"lenPG", "^", "2"}], "*", 
    RowBox[{"lenPI", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"prod1", "-", "prod2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.850383964543879*^9, 3.850383965069236*^9}, {
  3.850383996189036*^9, 3.850384123069797*^9}, {3.850384172023942*^9, 
  3.850384354591378*^9}},
 CellLabel->"In[96]:=",ExpressionUUID->"63ff9faa-88a9-4606-93c5-2a89c8afa9ab"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.8503843555314827`*^9, 3.850387630600873*^9, 3.8503919933585443`*^9, {
   3.851077058065201*^9, 3.8510770778966208`*^9}, 3.851264924466927*^9, 
   3.851265855739558*^9, 3.851266031620708*^9, 3.851266073176914*^9, 
   3.8512681304891787`*^9, 3.851268554987822*^9},
 CellLabel->
  "Out[106]=",ExpressionUUID->"30f6796b-cd38-4fcd-a0dc-929426091e13"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Theorem 5.38: if the center is Cos[A]+k Cos[B]Cos[C], then FGHI is cyclic\
\>", "Subsection",
 CellChangeTimes->{{3.8503749575296717`*^9, 3.8503750118242064`*^9}, {
  3.85038368170011*^9, 3.850383685612054*^9}, {3.8512654670589867`*^9, 
  3.851265474418703*^9}, {3.851265578819463*^9, 3.8512655952431087`*^9}, {
  3.851266104976555*^9, 3.8512661090446444`*^9}, {3.851266192997129*^9, 
  3.851266211452551*^9}},ExpressionUUID->"bae6a17f-22b5-4e10-958b-\
3d48f1a42e35"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"abcFn", "=", 
  RowBox[{"convertToABC", "[", 
   RowBox[{
    RowBox[{"Cos", "[", "A", "]"}], "+", 
    RowBox[{"k", " ", 
     RowBox[{"Cos", "[", "B", "]"}], 
     RowBox[{"Cos", "[", "C", "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851265747651463*^9, 3.851265774325132*^9}, {
   3.8512658988773003`*^9, 3.8512659228515673`*^9}, 3.8512662243057423`*^9},
 CellLabel->
  "In[107]:=",ExpressionUUID->"3450c249-c06c-445e-971d-c4f69b4151f7"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"2", " ", 
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}], "+", 
   RowBox[{
    SuperscriptBox["a", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "k"}], ")"}]}], "-", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}], "2"], " ", "k"}]}], 
  RowBox[{"4", " ", 
   SuperscriptBox["a", "2"], " ", "b", " ", "c"}]]], "Output",
 CellChangeTimes->{{3.8512657656083193`*^9, 3.851265775589469*^9}, 
   3.851265831702639*^9, 3.8512659239970493`*^9, 3.851266226244246*^9, 
   3.8512681305120573`*^9, 3.851268554996234*^9},
 CellLabel->
  "Out[107]=",ExpressionUUID->"642a3a4e-d7f7-4d0f-b7b2-e743544e4cc7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"abcFn", "=", 
  RowBox[{"abcFn", "*", "4", 
   RowBox[{"a", "^", "2"}], 
   RowBox[{"b", "^", "2"}], 
   RowBox[{"c", "^", "2"}]}]}]], "Input",
 CellChangeTimes->{{3.851265788907606*^9, 3.851265801515279*^9}, {
  3.851265946245282*^9, 3.851265961076323*^9}, {3.851266235992988*^9, 
  3.8512662431728983`*^9}},
 CellLabel->
  "In[108]:=",ExpressionUUID->"bc6e3978-3380-44e4-8d8d-ad89de844298"],

Cell[BoxData[
 RowBox[{"b", " ", "c", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "k"}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], "2"], " ", "k"}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{{3.851265802562842*^9, 3.8512658348370657`*^9}, 
   3.851265966880365*^9, 3.851266244147423*^9, 3.8512681305192842`*^9, 
   3.851268555033896*^9},
 CellLabel->
  "Out[108]=",ExpressionUUID->"ebd00705-469a-469f-82cf-6396b04e7f50"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"abcFn", ",", "k", ",", "Factor"}], "]"}]], "Input",
 CellChangeTimes->{{3.851265973660336*^9, 3.851265984515848*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"007e86a3-3878-4643-a8be-0fb71b5069e5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "2"]}], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], ")"}]}], "-", 
  RowBox[{"b", " ", "c", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "2"]}], "+", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}], ")"}], " ", "k"}]}]], "Output",
 CellChangeTimes->{3.851265985424947*^9, 3.8512662524117126`*^9, 
  3.851268130542102*^9, 3.8512685550411987`*^9},
 CellLabel->
  "Out[109]=",ExpressionUUID->"501a948f-f62b-469c-b014-a387ac64338a"]
}, Open  ]],

Cell["\<\
Let P be the intersection of FH and GI.
Then FGHI will be cyclic if PF*PH=PG*PI.\
\>", "Text",
 CellChangeTimes->{{3.850383694942358*^9, 3.850383758140072*^9}, 
   3.850388568843919*^9},ExpressionUUID->"8c5bb719-90e9-4ba5-99f2-\
8ab03f57801e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"givenF", "=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "\[Rule]", "abcFn"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"sF", ",", "sH"}], "}"}], "/.", "givenF"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"sG", ",", "sI"}], "}"}], "/.", "givenF"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"gP", "=", 
  RowBox[{
   RowBox[{"pointOfIntersectionOfLines", "[", 
    RowBox[{"p1", ",", "p2"}], "]"}], "//", "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.850383777934346*^9, 3.850383843062056*^9}, {
   3.8503838765015697`*^9, 3.8503839388687153`*^9}, 3.850383991758665*^9, 
   3.850384263247272*^9, 3.851265812687378*^9},
 CellLabel->
  "In[110]:=",ExpressionUUID->"bc8a1524-02d9-4898-a908-c66812042899"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "+", "bx"}], 
    RowBox[{"4", "+", 
     RowBox[{"2", " ", "k"}]}]], ",", 
   FractionBox[
    RowBox[{"ay", "+", "cy"}], 
    RowBox[{"4", "+", 
     RowBox[{"2", " ", "k"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.850383825072455*^9, {3.850383929471216*^9, 3.85038393997548*^9}, 
   3.85038399287724*^9, 3.850384263919498*^9, 3.850387625884363*^9, 
   3.850391993266129*^9, {3.85107705780164*^9, 3.8510770778897943`*^9}, 
   3.851264924203801*^9, {3.851265815069612*^9, 3.851265844150022*^9}, 
   3.851266065859565*^9, 3.8512662581053762`*^9, 3.851268130775455*^9, 
   3.851268555278022*^9},
 CellLabel->
  "Out[113]=",ExpressionUUID->"6eb6b919-306f-4980-bb9c-14671ad0dcc0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"gF", "=", 
   RowBox[{"sF", "/.", "givenF"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gG", "=", 
   RowBox[{"sG", "/.", "givenF"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gH", "=", 
   RowBox[{"sH", "/.", "givenF"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gI", "=", 
   RowBox[{"sI", "/.", "givenF"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenPF", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"gP", ",", "gF"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenPG", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"gP", ",", "gG"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenPH", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"gP", ",", "gH"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenPI", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"gP", ",", "gI"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prod1", "=", 
   RowBox[{
    RowBox[{"lenPF", "^", "2"}], "*", 
    RowBox[{"lenPH", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prod2", "=", 
   RowBox[{
    RowBox[{"lenPG", "^", "2"}], "*", 
    RowBox[{"lenPI", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"prod1", "-", "prod2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.850383964543879*^9, 3.850383965069236*^9}, {
  3.850383996189036*^9, 3.850384123069797*^9}, {3.850384172023942*^9, 
  3.850384354591378*^9}},
 CellLabel->
  "In[114]:=",ExpressionUUID->"0c0514c3-8ae5-4084-b513-d78d13655646"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.8503843555314827`*^9, 3.850387630600873*^9, 3.8503919933585443`*^9, {
   3.851077058065201*^9, 3.8510770778966208`*^9}, 3.851264924466927*^9, 
   3.851265855739558*^9, 3.851266031620708*^9, 3.851266073176914*^9, 
   3.8512662647407722`*^9, 3.8512681308560867`*^9, 3.851268555403654*^9},
 CellLabel->
  "Out[124]=",ExpressionUUID->"a0a296b5-6ed9-4c04-b479-90d0b9d46a0e"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Squares", "Subsection",
 CellChangeTimes->{{3.851268323561762*^9, 
  3.851268340702712*^9}},ExpressionUUID->"d1b23e91-6622-424a-8a61-\
85a911fac350"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"squareCondition", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"bx", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"ay", "\[Rule]", "1"}], ",", 
     RowBox[{"cy", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenFG", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"sF", ",", "sG"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8512683496215277`*^9, 3.851268379014991*^9}, 
   3.851268543165413*^9, {3.851268856991765*^9, 3.851268864102092*^9}, {
   3.851269003528013*^9, 3.8512690039935713`*^9}},
 CellLabel->
  "In[189]:=",ExpressionUUID->"03c85062-7029-4307-b182-c806db9ce06d"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Theorem 5.54: if the center is X(80), then FGHI is congruent to ABCD\
\>", "Subsection",
 CellChangeTimes->{{3.851268401124967*^9, 
  3.851268446580455*^9}},ExpressionUUID->"cefecce3-28f2-4f69-8973-\
3a3b42b410e9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x80", "=", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2", 
       RowBox[{"Cos", "[", "A", "]"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"abcFn", "=", 
  RowBox[{"convertToABC", "[", "x80", "]"}]}]}], "Input",
 CellChangeTimes->{3.851268715927099*^9},
 CellLabel->
  "In[203]:=",ExpressionUUID->"d2da9581-16f8-42f0-87b7-c900a34f91b3"],

Cell[BoxData[
 FractionBox[
  RowBox[{"b", " ", "c"}], 
  RowBox[{
   SuperscriptBox["a", "2"], "-", 
   SuperscriptBox["b", "2"], "+", 
   RowBox[{"b", " ", "c"}], "-", 
   SuperscriptBox["c", "2"]}]]], "Output",
 CellChangeTimes->{3.851268716723637*^9, 3.851269166244362*^9},
 CellLabel->
  "Out[204]=",ExpressionUUID->"7c70addf-24b2-439d-9cfb-8eec287f28d8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"givenF", "=", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "\[Rule]", "abcFn"}]}], 
   ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "It", " ", "suffices", " ", "to", " ", "prove", " ", "that", " ", "FG"}], 
    "=", "AB"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"symbolicDif", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"lenFG", "^", "2"}], "-", 
      RowBox[{"lenAB", "^", "2"}]}], "/.", "squareCondition"}], "/.", 
    "givenF"}], "//", "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.8512684539651537`*^9, 3.851268473284645*^9}, {
   3.851268524405196*^9, 3.8512685249121237`*^9}, {3.851268590262463*^9, 
   3.851268610245308*^9}, {3.851268652856977*^9, 3.851268817829885*^9}, {
   3.851268883527667*^9, 3.851268893518667*^9}, {3.85126892935884*^9, 
   3.8512689387027607`*^9}, 3.851268999673636*^9, 3.851269163175712*^9},
 CellLabel->
  "In[205]:=",ExpressionUUID->"76f2625b-8e28-4257-86af-a61dc6933ea8"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.85126878409191*^9, 3.851268795746092*^9}, 
   3.851268829011936*^9, 3.85126887212889*^9, 3.8512689451639977`*^9, 
   3.8512691700065937`*^9},
 CellLabel->
  "Out[206]=",ExpressionUUID->"eefed3a3-2557-4487-8cb5-02fdf47d775c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Theorem 5.54: if the center is X(40), then FGHI is congruent to ABCD\
\>", "Subsection",
 CellChangeTimes->{{3.851268401124967*^9, 3.851268446580455*^9}, {
  3.851269027495118*^9, 
  3.8512690277665358`*^9}},ExpressionUUID->"c982a1f2-604b-4270-82fe-\
69d2f81e3697"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x40", "=", 
   RowBox[{
    RowBox[{"Cos", "[", "B", "]"}], "+", 
    RowBox[{"Cos", "[", "C", "]"}], "-", 
    RowBox[{"Cos", "[", "A", "]"}], "-", "1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"abcFn", "=", 
  RowBox[{"convertToABC", "[", "x40", "]"}]}]}], "Input",
 CellChangeTimes->{
  3.851268715927099*^9, 3.851269034151973*^9, {3.8512690760290728`*^9, 
   3.851269085128784*^9}, {3.851269118208576*^9, 3.851269128206834*^9}},
 CellLabel->
  "In[195]:=",ExpressionUUID->"d8a24e04-af16-4ae4-b83d-3ed79cbfedd9"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["a", "3"], "+", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "c"}], ")"}]}], "-", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "c"}], ")"}]}], "-", 
   RowBox[{"a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}], "2"]}]}], 
  RowBox[{"2", " ", "a", " ", "b", " ", "c"}]]], "Output",
 CellChangeTimes->{
  3.851268716723637*^9, {3.851269080224305*^9, 3.8512690856534843`*^9}, 
   3.8512691300996532`*^9},
 CellLabel->
  "Out[196]=",ExpressionUUID->"350558b7-b83a-417a-a9d0-6a90ed00267d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"givenF", "=", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "\[Rule]", "abcFn"}]}], 
   ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "It", " ", "suffices", " ", "to", " ", "prove", " ", "that", " ", "FG"}], 
    "=", "AB"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"symbolicDif", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"lenFG", "^", "2"}], "-", 
      RowBox[{"lenAB", "^", "2"}]}], "/.", "squareCondition"}], "/.", 
    "givenF"}], "//", "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.8512684539651537`*^9, 3.851268473284645*^9}, {
   3.851268524405196*^9, 3.8512685249121237`*^9}, {3.851268590262463*^9, 
   3.851268610245308*^9}, {3.851268652856977*^9, 3.851268817829885*^9}, {
   3.851268883527667*^9, 3.851268893518667*^9}, {3.85126892935884*^9, 
   3.8512689387027607`*^9}, 3.851268999673636*^9, 3.851269145225132*^9},
 CellLabel->
  "In[201]:=",ExpressionUUID->"65b4c073-4af1-40ae-bdc9-cb35d954a859"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.85126878409191*^9, 3.851268795746092*^9}, 
   3.851268829011936*^9, 3.85126887212889*^9, 3.8512689451639977`*^9, {
   3.8512691364923286`*^9, 3.851269146270115*^9}},
 CellLabel->
  "Out[202]=",ExpressionUUID->"992f89f9-549d-40b3-9861-ce482f2dc43f"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Theorem 5.54: if the center is X(84), then FGHI is congruent to ABCD\
\>", "Subsection",
 CellChangeTimes->{{3.851268401124967*^9, 3.851268446580455*^9}, {
  3.851269027495118*^9, 3.8512690277665358`*^9}, {3.8512691916557093`*^9, 
  3.851269192111144*^9}},ExpressionUUID->"6b158d4b-a1ad-48a1-8d06-\
927c8bf6e004"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x84", "=", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cos", "[", "B", "]"}], "+", 
      RowBox[{"Cos", "[", "C", "]"}], "-", 
      RowBox[{"Cos", "[", "A", "]"}], "-", "1"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"abcFn", "=", 
  RowBox[{"convertToABC", "[", "x84", "]"}]}]}], "Input",
 CellChangeTimes->{
  3.851268715927099*^9, 3.851269034151973*^9, {3.8512690760290728`*^9, 
   3.851269085128784*^9}, {3.851269118208576*^9, 3.851269128206834*^9}, {
   3.851269198472207*^9, 3.851269247424773*^9}},
 CellLabel->
  "In[211]:=",ExpressionUUID->"a5afea4f-9a34-46d1-94a2-05c0ed15d72d"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "a", " ", "b", " ", "c"}], 
  RowBox[{
   SuperscriptBox["a", "3"], "+", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "c"}], ")"}]}], "-", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "c"}], ")"}]}], "-", 
   RowBox[{"a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}], "2"]}]}]]], "Output",
 CellChangeTimes->{
  3.851268716723637*^9, {3.851269080224305*^9, 3.8512690856534843`*^9}, 
   3.8512691300996532`*^9, {3.851269238568083*^9, 3.851269248714529*^9}},
 CellLabel->
  "Out[212]=",ExpressionUUID->"e880c009-5dda-4d3f-ab09-ad9f38ee2aa8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"givenF", "=", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "\[Rule]", "abcFn"}]}], 
   ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "It", " ", "suffices", " ", "to", " ", "prove", " ", "that", " ", "FG"}], 
    "=", "AB"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"symbolicDif", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"lenFG", "^", "2"}], "-", 
      RowBox[{"lenAB", "^", "2"}]}], "/.", "squareCondition"}], "/.", 
    "givenF"}], "//", "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.8512684539651537`*^9, 3.851268473284645*^9}, {
   3.851268524405196*^9, 3.8512685249121237`*^9}, {3.851268590262463*^9, 
   3.851268610245308*^9}, {3.851268652856977*^9, 3.851268817829885*^9}, {
   3.851268883527667*^9, 3.851268893518667*^9}, {3.85126892935884*^9, 
   3.8512689387027607`*^9}, 3.851268999673636*^9, 3.851269145225132*^9},
 CellLabel->
  "In[213]:=",ExpressionUUID->"421c997c-2be8-4f33-83d1-0c37dadfd2de"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.85126878409191*^9, 3.851268795746092*^9}, 
   3.851268829011936*^9, 3.85126887212889*^9, 3.8512689451639977`*^9, {
   3.8512691364923286`*^9, 3.851269146270115*^9}, {3.8512692424302607`*^9, 
   3.851269253339622*^9}},
 CellLabel->
  "Out[214]=",ExpressionUUID->"fd8550d4-2348-4f7b-98f9-10f31ffd03f5"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Half Triangles", "Section",
 CellChangeTimes->{{3.850367662817922*^9, 3.850367681472711*^9}, {
  3.850392062358953*^9, 
  3.850392063214595*^9}},ExpressionUUID->"1bf555aa-1d24-4de9-8078-\
f38936dd20fa"],

Cell[CellGroupData[{

Cell["set up", "Subsection",
 CellChangeTimes->{{3.851077521384935*^9, 
  3.851077527365077*^9}},ExpressionUUID->"eeef88fc-30a6-4e9d-8171-\
8401d5d340bf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Locate", " ", "the", " ", "points", " ", "E"}], ",", " ", "F", 
    ",", " ", "G", ",", " ", 
    RowBox[{
    "H", " ", "inside", " ", "the", " ", "half", " ", "triangles", " ", "to", 
     " ", "match", " ", "the", " ", "notation", " ", "in", " ", "the", " ", 
     "paper"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Note", " ", "that", " ", "we", " ", "are", " ", "no", " ", "longer", " ", 
    "using", " ", "E", " ", "to", " ", "name", " ", "the", " ", "diagonal", 
    " ", 
    RowBox[{"point", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"lenAC", "=", 
     RowBox[{"dist", "[", 
      RowBox[{"Pa", ",", "Pc"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lenBD", "=", 
     RowBox[{"dist", "[", 
      RowBox[{"Pb", ",", "Pd"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tE", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"bary1", "*", "Pb"}], "+", 
         RowBox[{"bary2", "*", "Pc"}], "+", 
         RowBox[{"bary3", "*", "Pd"}]}], ")"}], "/", "barySum"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "lenCD"}], ",", 
        RowBox[{"b", "\[Rule]", "lenBD"}], ",", 
        RowBox[{"c", "\[Rule]", "lenBC"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tF", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"bary1", "*", "Pa"}], "+", 
         RowBox[{"bary2", "*", "Pc"}], "+", 
         RowBox[{"bary3", "*", "Pd"}]}], ")"}], "/", "barySum"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "lenCD"}], ",", 
        RowBox[{"b", "\[Rule]", "lenDA"}], ",", 
        RowBox[{"c", "\[Rule]", "lenAC"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tG", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"bary1", "*", "Pa"}], "+", 
         RowBox[{"bary2", "*", "Pb"}], "+", 
         RowBox[{"bary3", "*", "Pd"}]}], ")"}], "/", "barySum"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "lenBD"}], ",", 
        RowBox[{"b", "\[Rule]", "lenDA"}], ",", 
        RowBox[{"c", "\[Rule]", "lenAB"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"bary1", "*", "Pa"}], "+", 
         RowBox[{"bary2", "*", "Pb"}], "+", 
         RowBox[{"bary3", "*", "Pc"}]}], ")"}], "/", "barySum"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "lenBC"}], ",", 
        RowBox[{"b", "\[Rule]", "lenAC"}], ",", 
        RowBox[{"c", "\[Rule]", "lenAB"}]}], "}"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.85032008733659*^9, 3.85032008870809*^9}, {
   3.850321623729926*^9, 3.850321625533457*^9}, {3.850322159784513*^9, 
   3.850322160274661*^9}, 3.8503222039440517`*^9, {3.850392143960351*^9, 
   3.850392165903569*^9}, {3.850393888842619*^9, 3.850394017021467*^9}, {
   3.850394060525907*^9, 3.850394067797659*^9}, {3.8503941077339277`*^9, 
   3.850394246982943*^9}, {3.850394878417495*^9, 3.850394895560533*^9}, {
   3.850394928257715*^9, 3.8503949406404448`*^9}, {3.850394977289814*^9, 
   3.8503950294649343`*^9}},
 CellLabel->
  "In[127]:=",ExpressionUUID->"792aba18-16d8-4161-820d-df95ec9bc2ac"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Add", " ", "these", " ", "points", " ", "to", " ", "our", " ", 
    "illustrative", " ", "figure", " ", "using", " ", "a", " ", "simple", " ",
     "center", " ", "function"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"for", " ", "our", " ", "figure"}], ",", " ", 
    RowBox[{"use", " ", "the", " ", "symmedian", " ", "point"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "step", " ", "is", " ", "not", " ", "needed", " ", "for", " ",
     "the", " ", "proof"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"quadrilateral", "=", 
     RowBox[{"{", 
      RowBox[{"Thick", ",", 
       RowBox[{"AbsolutePointSize", "[", "6", "]"}], ",", 
       "\[IndentingNewLine]", "Black", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Pa", ",", "Pb"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pb", ",", "Pc"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pc", ",", "Pd"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pd", ",", "Pa"}], "}"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", "Red", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Pa", ",", "Pc"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pb", ",", "Pd"}], "}"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", "Black", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"Pa", ",", "Pb", ",", "Pc", ",", "Pd"}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", "Black", ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<A\>\"", ",", "Pa", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<B\>\"", ",", "Pb", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<C\>\"", ",", "Pc", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<D\>\"", ",", "Pd", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"quad", "=", 
     RowBox[{
      RowBox[{"Graphics", "[", "quadrilateral", "]"}], "/.", "figCoords"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"figF", "[", 
      RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", "a"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"symmedian", " ", "point"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pE", "=", 
     RowBox[{
      RowBox[{"tE", "/.", 
       RowBox[{"f", "\[Rule]", "figF"}]}], "/.", "figCoords"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pF", "=", 
     RowBox[{
      RowBox[{"tF", "/.", 
       RowBox[{"f", "\[Rule]", "figF"}]}], "/.", "figCoords"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pG", "=", 
     RowBox[{
      RowBox[{"tG", "/.", 
       RowBox[{"f", "\[Rule]", "figF"}]}], "/.", "figCoords"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pH", "=", 
     RowBox[{
      RowBox[{"tH", "/.", 
       RowBox[{"f", "\[Rule]", "figF"}]}], "/.", "figCoords"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"points", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"pE", ",", "pF", ",", "pG", ",", "pH"}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<E\>\"", ",", "pE", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "2"}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<F\>\"", ",", "pF", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "0"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<G\>\"", ",", "pG", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<H\>\"", ",", "pH", ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
       "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lines", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"Blue", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"pE", ",", "pF"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pG", ",", "pH"}], "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", "Green", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"pE", ",", "pH"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pF", ",", "pG"}], "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", "Red", ",", "Dashed", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"pE", ",", "pG"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pF", ",", "pH"}], "}"}]}], "}"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"quad", ",", "points", ",", "lines"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8503221721931343`*^9, 3.8503221940233994`*^9}, {
   3.850394280544249*^9, 3.850394378070765*^9}, {3.850394408958906*^9, 
   3.8503944541990356`*^9}, {3.850394585690234*^9, 3.850394604863515*^9}, {
   3.850394658249092*^9, 3.850394711201742*^9}, 3.8503950446981087`*^9, {
   3.850395075330172*^9, 3.850395144457006*^9}, {3.850396045525466*^9, 
   3.850396087741726*^9}},
 CellLabel->
  "In[133]:=",ExpressionUUID->"51663677-b119-4996-a82d-941aa201ce28"],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsolutePointSize[6], Thickness[Large], 
    LineBox[NCache[{{{0, Rational[3, 5]}, {Rational[-1, 4], 0}}, {{
        Rational[-1, 4], 0}, {0, Rational[-1, 3]}}, {{0, Rational[-1, 3]}, {1,
         0}}, {{1, 0}, {0, Rational[3, 5]}}}, {{{
        0, 0.6}, {-0.25, 0}}, {{-0.25, 0}, {0, -0.3333333333333333}}, {{
        0, -0.3333333333333333}, {1, 0}}, {{1, 0}, {0, 0.6}}}]], 
    {RGBColor[1, 0, 0], 
     LineBox[NCache[{{{0, Rational[3, 5]}, {0, Rational[-1, 3]}}, {{
         Rational[-1, 4], 0}, {1, 0}}}, {{{0, 0.6}, {
         0, -0.3333333333333333}}, {{-0.25, 0}, {1, 0}}}]]}, 
    {GrayLevel[0], 
     PointBox[NCache[{{0, Rational[3, 5]}, {Rational[-1, 4], 0}, {
        0, Rational[-1, 3]}, {1, 0}}, {{0, 0.6}, {-0.25, 0}, {
        0, -0.3333333333333333}, {1, 0}}]]}, 
    {GrayLevel[0], 
     InsetBox["\<\"A\"\>", NCache[{0, Rational[3, 5]}, {0, 0.6}], {2, -1}], 
     InsetBox["\<\"B\"\>", NCache[{Rational[-1, 4], 0}, {-0.25, 0}], {2, 2}], 
     InsetBox["\<\"C\"\>", 
      NCache[{0, Rational[-1, 3]}, {0, -0.3333333333333333}], {-2, 2}], 
     InsetBox["\<\"D\"\>", {1, 0}, {-3, -1}]}}, {
    PointBox[NCache[{{Rational[-3, 82], Rational[-15, 82]}, {
       Rational[49, 188], Rational[3, 47]}, {
       Rational[11, 446], Rational[125, 446]}, {
       Rational[-392, 2641], 
        Rational[-66, 
         2641]}}, {{-0.036585365853658534`, -0.18292682926829268`}, {
      0.26063829787234044`, 0.06382978723404255}, {0.02466367713004484, 
      0.2802690582959641}, {-0.14842862552063613`, -0.024990533888678532`}}]],
     InsetBox["\<\"E\"\>", 
     NCache[{Rational[-3, 82], 
       Rational[-15, 
        82]}, {-0.036585365853658534`, -0.18292682926829268`}], {0, 2}], 
    InsetBox["\<\"F\"\>", 
     NCache[{Rational[49, 188], Rational[3, 47]}, {0.26063829787234044`, 
      0.06382978723404255}], {-3, 0}], 
    InsetBox["\<\"G\"\>", 
     NCache[{Rational[11, 446], Rational[125, 446]}, {0.02466367713004484, 
      0.2802690582959641}], {0, -1}], 
    InsetBox["\<\"H\"\>", 
     NCache[{Rational[-392, 2641], 
       Rational[-66, 
        2641]}, {-0.14842862552063613`, -0.024990533888678532`}], {2, 1}]}, {
    {RGBColor[0, 0, 1], 
     LineBox[NCache[{{{Rational[-3, 82], Rational[-15, 82]}, {
         Rational[49, 188], Rational[3, 47]}}, {{
         Rational[11, 446], Rational[125, 446]}, {
         Rational[-392, 2641], 
          Rational[-66, 
           2641]}}}, {{{-0.036585365853658534`, -0.18292682926829268`}, {
       0.26063829787234044`, 0.06382978723404255}}, {{0.02466367713004484, 
       0.2802690582959641}, {-0.14842862552063613`, \
-0.024990533888678532`}}}]]}, 
    {RGBColor[0, 1, 0], 
     LineBox[NCache[{{{Rational[-3, 82], Rational[-15, 82]}, {
         Rational[-392, 2641], Rational[-66, 2641]}}, {{
         Rational[49, 188], Rational[3, 47]}, {
         Rational[11, 446], Rational[
          125, 446]}}}, {{{-0.036585365853658534`, -0.18292682926829268`}, \
{-0.14842862552063613`, -0.024990533888678532`}}, {{0.26063829787234044`, 
       0.06382978723404255}, {0.02466367713004484, 0.2802690582959641}}}]]}, 
    {RGBColor[1, 0, 0], Dashing[{Small, Small}], 
     LineBox[NCache[{{{Rational[-3, 82], Rational[-15, 82]}, {
         Rational[11, 446], Rational[125, 446]}}, {{
         Rational[49, 188], Rational[3, 47]}, {
         Rational[-392, 2641], 
          Rational[-66, 
           2641]}}}, {{{-0.036585365853658534`, -0.18292682926829268`}, {
       0.02466367713004484, 0.2802690582959641}}, {{0.26063829787234044`, 
       0.06382978723404255}, {-0.14842862552063613`, \
-0.024990533888678532`}}}]]}}}]], "Output",
 CellChangeTimes->{
  3.850320392276561*^9, 3.850320472061535*^9, 3.85032143550299*^9, 
   3.850321506370639*^9, 3.85032163689233*^9, 3.850322233893065*^9, 
   3.850331289787881*^9, 3.850367476646245*^9, 3.8503735676052017`*^9, 
   3.850382876649686*^9, 3.850391980194425*^9, {3.850394457655387*^9, 
   3.850394486324997*^9}, 3.850394606205844*^9, {3.8503946590309067`*^9, 
   3.850394712267947*^9}, 3.850394901245038*^9, 3.8503949550896053`*^9, 
   3.850395003945455*^9, {3.850395035057262*^9, 3.850395045262629*^9}, {
   3.8503950787900248`*^9, 3.850395154857901*^9}, 3.850395273158082*^9, {
   3.850396066596531*^9, 3.850396088663239*^9}, {3.8510770581178923`*^9, 
   3.851077077973377*^9}, 3.8512649245132093`*^9, 3.85126813091313*^9, 
   3.8512685555023193`*^9},
 CellLabel->
  "Out[142]=",ExpressionUUID->"a9b70bbb-ad9b-4454-ae47-13bf24713633"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Find", " ", "the", " ", "slopes", " ", "of", " ", "the", " ", 
    "diagonals"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{
    RowBox[{"slopeFH", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"tH", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "-", 
        RowBox[{"tF", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"tH", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "-", 
        RowBox[{"tF", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopeEG", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"tE", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "-", 
        RowBox[{"tG", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"tE", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "-", 
        RowBox[{"tG", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"productOfSlopes", "=", 
     RowBox[{"slopeFH", "*", "slopeEG"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.850322639228096*^9, 3.850322697840695*^9}, {
  3.850322856962872*^9, 3.8503228590574636`*^9}, {3.850395203578001*^9, 
  3.850395260144888*^9}},
 CellLabel->
  "In[143]:=",ExpressionUUID->"57303260-3b64-487b-841f-7afa7407084d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Note", " ", "that", " ", "the", " ", "central", " ", "quadrilateral", " ",
     "is", " ", "not", " ", "necessarily", " ", "orthodiagonal"}], " ", 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"numericProductOfSlopes", "=", 
     RowBox[{
      RowBox[{"productOfSlopes", "/.", 
       RowBox[{"f", "->", "figF"}]}], "/.", "figCoords"}]}], ";"}], 
   "\[IndentingNewLine]", "numericProductOfSlopes"}]}]], "Input",
 CellChangeTimes->{{3.8503218384065027`*^9, 3.850321896488906*^9}, {
  3.850322408809058*^9, 3.850322432959783*^9}, {3.850322773434289*^9, 
  3.8503227935534153`*^9}, {3.850322829826659*^9, 3.850322830625092*^9}, {
  3.8503228710748*^9, 3.8503228844986687`*^9}, {3.850322965250971*^9, 
  3.850323001754963*^9}},
 CellLabel->
  "In[146]:=",ExpressionUUID->"294503a6-c302-41f1-9b86-cc946b67b353"],

Cell[BoxData[
 FractionBox["5445", "3316"]], "Output",
 CellChangeTimes->{
  3.85032288551582*^9, {3.850322998672515*^9, 3.8503230028240223`*^9}, 
   3.850331289827099*^9, 3.850367476685074*^9, 3.8503735676391172`*^9, 
   3.85038287668193*^9, 3.8503919802323713`*^9, {3.850395266397291*^9, 
   3.85039528088634*^9}, {3.851077058132536*^9, 3.8510770779871597`*^9}, 
   3.851264924540337*^9, 3.85126813094199*^9, 3.8512685555504103`*^9},
 CellLabel->
  "Out[147]=",ExpressionUUID->"76844400-cdec-45f8-8a0a-1a67d3b346d6"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Theorem 6.16: center function Cos[B]Cos[C]+kCos[A] implies EFGH is \
orthodiagonal\
\>", "Subsection",
 CellChangeTimes->{{3.850367720388095*^9, 3.8503677251030617`*^9}, {
   3.8503677897854433`*^9, 3.850367862617402*^9}, {3.8503953283452578`*^9, 
   3.850395336177104*^9}, 3.850396243740274*^9, {3.851266691422876*^9, 
   3.8512667032227373`*^9}},ExpressionUUID->"a999bf34-38d0-445f-b191-\
6f239af15e4e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Now", " ", "use", " ", 
     RowBox[{"Cos", "[", "B", "]"}], 
     RowBox[{"Cos", "[", "C", "]"}]}], "+", 
    RowBox[{"k", " ", 
     RowBox[{"Cos", "[", "A", "]"}], " ", "as", " ", "the", " ", "center", 
     " ", "function"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"abcFn", "=", 
   RowBox[{"convertToABC", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "B", "]"}], 
      RowBox[{"Cos", "[", "C", "]"}]}], "+", 
     RowBox[{"k", " ", 
      RowBox[{"Cos", "[", "A", "]"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8503222654156637`*^9, 3.8503222834478817`*^9}, {
   3.8503223259914837`*^9, 3.8503223435599127`*^9}, {3.850322379833313*^9, 
   3.850322381087789*^9}, {3.850323394964088*^9, 3.850323398555464*^9}, 
   3.850323453876525*^9, {3.8503234861406097`*^9, 3.850323508139471*^9}, {
   3.8503263581257544`*^9, 3.850326399061891*^9}, {3.8503678877426987`*^9, 
   3.850367900337617*^9}, {3.850395344634968*^9, 3.850395370241869*^9}, {
   3.850395465274781*^9, 3.8503955012669086`*^9}, {3.850395607447566*^9, 
   3.8503956139311543`*^9}, 3.850395696898078*^9, 3.850395728148027*^9},
 CellLabel->
  "In[148]:=",ExpressionUUID->"bc41c0cf-26b9-4fc2-aa49-a38e3de4909c"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
   RowBox[{
    SuperscriptBox["a", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2", " ", "k"}]}], ")"}]}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}], " ", "k"}]}], 
  RowBox[{"4", " ", 
   SuperscriptBox["a", "2"], " ", "b", " ", "c"}]]], "Output",
 CellChangeTimes->{
  3.8503956148584023`*^9, 3.8503956484863*^9, 3.850395698058226*^9, 
   3.8503957299550743`*^9, 3.850396119297983*^9, {3.8510770581421022`*^9, 
   3.851077077993759*^9}, 3.851264924549568*^9, 3.8512681309520197`*^9, 
   3.851268555592828*^9},
 CellLabel->
  "Out[148]=",ExpressionUUID->"b06e3b6f-5b6b-4c9c-a6ac-ac0760b252f6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"abcFn", "=", 
  RowBox[{"abcFn", "*", "4", "*", 
   RowBox[{"a", "^", "2"}], "*", 
   RowBox[{"b", "^", "2"}], "*", 
   RowBox[{"c", "^", "2"}]}]}]], "Input",
 CellChangeTimes->{{3.850395520506577*^9, 3.85039554510585*^9}, {
  3.850395641859372*^9, 3.850395662218252*^9}},
 CellLabel->
  "In[149]:=",ExpressionUUID->"db13c463-4ab0-4630-a840-61e4fe2bea07"],

Cell[BoxData[
 RowBox[{"b", " ", "c", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "k"}]}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}], " ", "k"}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.850395537924292*^9, 3.850395547909449*^9}, 
   3.850395618574678*^9, 3.850395663905307*^9, 3.850395701206102*^9, 
   3.850395733349463*^9, 3.850396123928252*^9, {3.851077058170907*^9, 
   3.851077078022666*^9}, 3.851264924571464*^9, 3.851268130975402*^9, 
   3.851268555599764*^9},
 CellLabel->
  "Out[149]=",ExpressionUUID->"95d60543-72ef-4410-8b18-bb068ea0dfdd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"givenF10", "=", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "\[Rule]", 
   "abcFn"}]}]], "Input",
 CellLabel->
  "In[150]:=",ExpressionUUID->"b20fb6e1-a15d-45ad-86ee-ec04f5419ebd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "\[Rule]", 
  RowBox[{"b", " ", "c", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["a", "4"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "k"}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", "k"}]}], ")"}]}]}]], "Output",\

 CellChangeTimes->{
  3.850395627081925*^9, 3.8503956682577972`*^9, 3.850395704104434*^9, 
   3.850395737561109*^9, 3.8503961270776863`*^9, {3.8510770581786413`*^9, 
   3.851077078029057*^9}, 3.851264924578529*^9, 3.851268130982407*^9, 
   3.851268555641159*^9},
 CellLabel->
  "Out[150]=",ExpressionUUID->"cc667253-34e2-48f8-8702-79deb14964be"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "EFGH", " ", "is", " ", "orthodiagonal", " ", "if", " ", "FH", " ", "is", 
    " ", "horizontal", " ", "and", " ", "EG", " ", "is", " ", "vertical"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Simplify", "[", 
   RowBox[{"slopeFH", "/.", "givenF10"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.850323023034013*^9, 3.850323035677452*^9}, {
   3.850323148350926*^9, 3.850323175043686*^9}, {3.850323360540249*^9, 
   3.8503233873471127`*^9}, 3.8503234824003973`*^9, 3.850326403437895*^9, {
   3.850367911371696*^9, 3.850367973041936*^9}, {3.850395378362175*^9, 
   3.8503954089394417`*^9}, {3.850395567267385*^9, 3.850395568937983*^9}, {
   3.850396158813326*^9, 3.8503961995797367`*^9}},
 CellLabel->
  "In[151]:=",ExpressionUUID->"fe85beae-4d8d-4e32-93b7-68a541feeb71"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.850323036650879*^9, {3.85032314972884*^9, 3.850323176506872*^9}, 
   3.850323257956277*^9, 3.850323366640108*^9, 3.850323404489972*^9, 
   3.8503234589710207`*^9, {3.850323492773278*^9, 3.850323512456037*^9}, 
   3.850326207621525*^9, 3.850326240404155*^9, {3.850326363128134*^9, 
   3.8503264042689238`*^9}, 3.850331289877302*^9, 3.85036747676048*^9, 
   3.850370103180328*^9, 3.850373567678563*^9, 3.850382876725748*^9, 
   3.850391980281293*^9, 3.8503954101792316`*^9, 3.850395630645425*^9, 
   3.850395672109173*^9, 3.850395707236992*^9, 3.850396173879451*^9, {
   3.8510770582066803`*^9, 3.85107707805856*^9}, 3.851264924601404*^9, 
   3.851268131006206*^9, 3.851268555686858*^9},
 CellLabel->
  "Out[151]=",ExpressionUUID->"359528da-ed91-4246-a908-861d5fc16839"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "/", "slopeEG"}], ")"}], "/.", "givenF10"}], "]"}]], "Input",\

 CellChangeTimes->{
  3.850395805772977*^9, {3.850396209126482*^9, 3.8503962201276827`*^9}},
 CellLabel->
  "In[152]:=",ExpressionUUID->"94d2dc86-3943-41dc-a295-bec545c57dc1"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.850395776394073*^9, 3.850395807136022*^9, 3.850395838371851*^9, 
   3.8503962213394547`*^9, {3.851077058235406*^9, 3.851077078088965*^9}, 
   3.851264924623804*^9, 3.85126813102917*^9, 3.851268555700449*^9},
 CellLabel->
  "Out[152]=",ExpressionUUID->"6b9cc840-916f-487b-806c-066a31508b53"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Equidiagonal Orthodiagonal Quadrilaterals", "Subsection",
 CellChangeTimes->{{3.8503972208171377`*^9, 
  3.8503972413269987`*^9}},ExpressionUUID->"fb8d3196-f17a-44f2-baea-\
df18afb8a593"],

Cell[BoxData[
 RowBox[{
  RowBox[{"equidiagonalCondition", "=", 
   RowBox[{"cy", "\[Rule]", 
    RowBox[{"ay", "+", "bx", "-", "1"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.850397310924724*^9, 3.850397324999784*^9}, {
  3.850397464296226*^9, 3.8503974730001793`*^9}, {3.85039823084452*^9, 
  3.8503982365869017`*^9}},
 CellLabel->
  "In[153]:=",ExpressionUUID->"8d82821c-89af-406a-beff-c33dd57bdc2f"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Theorem 6.19: if the center is X(51), then EFGH is orthodiagonal and \
equidiagonal\
\>", "Subsection",
 CellChangeTimes->{{3.850367720388095*^9, 3.8503677251030617`*^9}, {
   3.8503677897854433`*^9, 3.850367862617402*^9}, {3.8503953283452578`*^9, 
   3.850395336177104*^9}, 3.850396243740274*^9, {3.8503972794235077`*^9, 
   3.850397297455221*^9}, {3.850398803284553*^9, 3.850398812412092*^9}, {
   3.851266909599285*^9, 
   3.851266927559298*^9}},ExpressionUUID->"aa60c6cb-06f4-4b10-a2d7-\
ffa71db94324"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"The", " ", "center", " ", "function", " ", "for", " ", "X", 
    RowBox[{"(", "51", ")"}], " ", "is", " ", 
    RowBox[{"a", "^", "2"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"B", "-", "C"}], "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"abcFn", "=", 
   RowBox[{"convertToABC", "[", 
    RowBox[{
     RowBox[{"a", "^", "2"}], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"B", "-", "C"}], "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8503222654156637`*^9, 3.8503222834478817`*^9}, {
   3.8503223259914837`*^9, 3.8503223435599127`*^9}, {3.850322379833313*^9, 
   3.850322381087789*^9}, {3.850323394964088*^9, 3.850323398555464*^9}, 
   3.850323453876525*^9, {3.8503234861406097`*^9, 3.850323508139471*^9}, {
   3.8503263581257544`*^9, 3.850326399061891*^9}, {3.8503678877426987`*^9, 
   3.850367900337617*^9}, {3.850395344634968*^9, 3.850395370241869*^9}, {
   3.850395465274781*^9, 3.8503955012669086`*^9}, {3.850395607447566*^9, 
   3.8503956139311543`*^9}, 3.850395696898078*^9, 3.850395728148027*^9, {
   3.8503974907292624`*^9, 3.850397543120285*^9}, {3.85039881954923*^9, 
   3.8503988575337257`*^9}},
 CellLabel->
  "In[154]:=",ExpressionUUID->"bfa6ba8a-fcec-4a03-bcf2-4853bb553aa2"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}], 
  RowBox[{"2", " ", "b", " ", "c"}]]], "Output",
 CellChangeTimes->{
  3.8503956148584023`*^9, 3.8503956484863*^9, 3.850395698058226*^9, 
   3.8503957299550743`*^9, 3.850396119297983*^9, 3.8503975473811913`*^9, 
   3.850397714335268*^9, 3.850398858319343*^9, {3.851077058826625*^9, 
   3.8510770781966257`*^9}, 3.851264925153824*^9, 3.851267809793486*^9, 
   3.8512681310594788`*^9, 3.85126855574748*^9},
 CellLabel->
  "Out[154]=",ExpressionUUID->"24060242-91a4-4e2b-9997-6d845a870c58"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"abcFn", "=", 
  RowBox[{"abcFn", "*", "2", "*", "a", "*", "b", "*", "c"}]}]], "Input",
 CellChangeTimes->{{3.850395520506577*^9, 3.85039554510585*^9}, {
  3.850395641859372*^9, 3.850395662218252*^9}, {3.8503977233624077`*^9, 
  3.850397730713174*^9}},
 CellLabel->
  "In[155]:=",ExpressionUUID->"bd220b39-fc5b-4ad9-b0da-e0e5a8b02797"],

Cell[BoxData[
 RowBox[{"a", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.850395537924292*^9, 3.850395547909449*^9}, 
   3.850395618574678*^9, 3.850395663905307*^9, 3.850395701206102*^9, 
   3.850395733349463*^9, 3.850396123928252*^9, 3.850397732390554*^9, 
   3.85039887238006*^9, {3.851077058833473*^9, 3.851077078206056*^9}, 
   3.851264925186079*^9, 3.851267813334586*^9, 3.851268131065999*^9, 
   3.851268555788437*^9},
 CellLabel->
  "Out[155]=",ExpressionUUID->"842f904c-9c16-4ef8-9220-49dce09ccdf4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"givenF12", "=", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "\[Rule]", 
   "abcFn"}]}]], "Input",
 CellChangeTimes->{3.8503977433376923`*^9, 3.850398888398138*^9},
 CellLabel->
  "In[156]:=",ExpressionUUID->"e5de7394-f872-4609-a0ea-885c76f0d8b2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "\[Rule]", 
  RowBox[{"a", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.850395627081925*^9, 3.8503956682577972`*^9, 3.850395704104434*^9, 
   3.850395737561109*^9, 3.8503961270776863`*^9, 3.850397745769992*^9, {
   3.8503988772632713`*^9, 3.85039889353098*^9}, {3.851077058840418*^9, 
   3.8510770782382727`*^9}, 3.85126492520786*^9, 3.8512678172613564`*^9, 
   3.851268131089068*^9, 3.851268555795549*^9},
 CellLabel->
  "Out[156]=",ExpressionUUID->"ddf10f4d-4f9f-4285-b05e-4e9f8bdc77d6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "EFGH", " ", "is", " ", "orthodiagonal", " ", "if", " ", "the", " ", 
     "product", " ", "of", " ", "the", " ", "slopes", " ", "of", " ", "FH", 
     " ", "and", " ", "EG", " ", "is"}], " ", "-", "1"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"symbolicProductOfSlopes", "=", 
     RowBox[{
      RowBox[{"productOfSlopes", "/.", "equidiagonalCondition"}], "/.", 
      "givenF12"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", "symbolicProductOfSlopes", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.850323023034013*^9, 3.850323035677452*^9}, {
   3.850323148350926*^9, 3.850323175043686*^9}, {3.850323360540249*^9, 
   3.8503233873471127`*^9}, 3.8503234824003973`*^9, 3.850326403437895*^9, {
   3.850367911371696*^9, 3.850367973041936*^9}, {3.850395378362175*^9, 
   3.8503954089394417`*^9}, {3.850395567267385*^9, 3.850395568937983*^9}, {
   3.850396158813326*^9, 3.8503961995797367`*^9}, {3.850397758841399*^9, 
   3.85039777208892*^9}, {3.850397812833973*^9, 3.8503978483858*^9}, {
   3.850398333716131*^9, 3.850398340930708*^9}, {3.850398553284445*^9, 
   3.850398584244698*^9}, 3.850398891036722*^9, {3.851267829126257*^9, 
   3.851267848435363*^9}},
 CellLabel->
  "In[157]:=",ExpressionUUID->"a5d075b8-8410-4d3e-a52c-cbda7213b40d"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellChangeTimes->{
  3.850323036650879*^9, {3.85032314972884*^9, 3.850323176506872*^9}, 
   3.850323257956277*^9, 3.850323366640108*^9, 3.850323404489972*^9, 
   3.8503234589710207`*^9, {3.850323492773278*^9, 3.850323512456037*^9}, 
   3.850326207621525*^9, 3.850326240404155*^9, {3.850326363128134*^9, 
   3.8503264042689238`*^9}, 3.850331289877302*^9, 3.85036747676048*^9, 
   3.850370103180328*^9, 3.850373567678563*^9, 3.850382876725748*^9, 
   3.850391980281293*^9, 3.8503954101792316`*^9, 3.850395630645425*^9, 
   3.850395672109173*^9, 3.850395707236992*^9, 3.850396173879451*^9, {
   3.850397823833192*^9, 3.850397851271137*^9}, 3.850398087754899*^9, 
   3.850398244950474*^9, 3.850398343002091*^9, 3.850398574551634*^9, 
   3.850398897091425*^9, {3.851077058870008*^9, 3.8510770782731857`*^9}, 
   3.8512649252191973`*^9, {3.851267832673641*^9, 3.851267855149425*^9}, 
   3.851268131112817*^9, 3.851268555836815*^9},
 CellLabel->
  "Out[158]=",ExpressionUUID->"b928a57c-ac57-41b3-9360-238f2b34ee33"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"EFGH", " ", "is", " ", "equidiagonal", " ", "if", " ", "EG"}], 
     "=", 
     RowBox[{"FH", " ", "or", " ", "equivalently"}]}], ",", " ", 
    RowBox[{
     RowBox[{"EG", "^", "2"}], "=", 
     RowBox[{"FH", "^", "2"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"lenEG", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"dist", "[", 
        RowBox[{"tE", ",", "tG"}], "]"}], "/.", "equidiagonalCondition"}], "/.",
       "givenF12"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lenFH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"dist", "[", 
        RowBox[{"tF", ",", "tH"}], "]"}], "/.", "equidiagonalCondition"}], "/.",
       "givenF12"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"lenEG", "^", "2"}], "-", 
     RowBox[{"lenFH", "^", "2"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.850398919596998*^9, 3.850398988660727*^9}, {
  3.850399020446682*^9, 3.8503990571654*^9}, {3.8503991051575623`*^9, 
  3.850399138125573*^9}},
 CellLabel->
  "In[159]:=",ExpressionUUID->"d280047b-64e3-49c2-b62c-fea5a228da3c"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.850398989558436*^9, {3.8503990237646933`*^9, 3.850399031082075*^9}, 
   3.850399140084742*^9, {3.851077060549179*^9, 3.851077078281958*^9}, 
   3.851264926912079*^9, 3.8512678600692167`*^9, 3.8512681328118963`*^9, 
   3.851268557587061*^9},
 CellLabel->
  "Out[161]=",ExpressionUUID->"a6f0f011-4174-4911-96e9-98c4716a0add"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Theorem 6.19: if the center is X(373), then EFGH is orthodiagonal and \
equidiagonal\
\>", "Subsection",
 CellChangeTimes->{{3.850367720388095*^9, 3.8503677251030617`*^9}, {
   3.8503677897854433`*^9, 3.850367862617402*^9}, {3.8503953283452578`*^9, 
   3.850395336177104*^9}, 3.850396243740274*^9, {3.8503972794235077`*^9, 
   3.850397297455221*^9}, {3.850398803284553*^9, 3.850398812412092*^9}, {
   3.851266909599285*^9, 3.851266927559298*^9}, {3.8512669972159557`*^9, 
   3.8512669977354403`*^9}},ExpressionUUID->"23de70e7-e610-48c1-8ab6-\
f706c7f3b7eb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"givenF12", "=", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "\[Rule]", 
   RowBox[{"a", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", "^", "4"}], "+", 
      RowBox[{"c", "^", "4"}], "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], 
       RowBox[{"b", "^", "2"}]}], "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], 
       RowBox[{"c", "^", "2"}]}], "-", 
      RowBox[{"6", 
       RowBox[{"b", "^", "2"}], 
       RowBox[{"c", "^", "2"}]}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{3.8503977433376923`*^9, 3.850398888398138*^9, 
  3.851267082284671*^9},
 CellLabel->
  "In[162]:=",ExpressionUUID->"43c5f55e-0638-4b2a-8e71-e8cb3c6c9571"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "\[Rule]", 
  RowBox[{"a", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      SuperscriptBox["b", "2"]}], "+", 
     SuperscriptBox["b", "4"], "-", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     RowBox[{"6", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "+", 
     SuperscriptBox["c", "4"]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.850395627081925*^9, 3.8503956682577972`*^9, 3.850395704104434*^9, 
   3.850395737561109*^9, 3.8503961270776863`*^9, 3.850397745769992*^9, {
   3.8503988772632713`*^9, 3.85039889353098*^9}, {3.851077058840418*^9, 
   3.8510770782382727`*^9}, 3.85126492520786*^9, 3.851267096828454*^9, 
   3.8512681328508*^9, 3.851268557669918*^9},
 CellLabel->
  "Out[162]=",ExpressionUUID->"1fb4bb7e-9ca0-4337-a58f-d7d09f12df4c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "EFGH", " ", "is", " ", "orthodiagonal", " ", "if", " ", "the", " ", 
     "product", " ", "of", " ", "the", " ", "slopes", " ", "of", " ", "FH", 
     " ", "and", " ", "EG", " ", "is"}], " ", "-", "1"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"symbolicProductOfSlopes", "=", 
     RowBox[{
      RowBox[{"productOfSlopes", "/.", "equidiagonalCondition"}], "/.", 
      "givenF12"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{"symbolicProductOfSlopes", ",", 
     RowBox[{
      RowBox[{"ay", "+", "bx", "-", "1"}], "<", "0"}]}], "]"}], 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"subject", " ", "to", " ", "condition", " ", "cy"}], "<", "0"}], 
    " ", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.850323023034013*^9, 3.850323035677452*^9}, {
   3.850323148350926*^9, 3.850323175043686*^9}, {3.850323360540249*^9, 
   3.8503233873471127`*^9}, 3.8503234824003973`*^9, 3.850326403437895*^9, {
   3.850367911371696*^9, 3.850367973041936*^9}, {3.850395378362175*^9, 
   3.8503954089394417`*^9}, {3.850395567267385*^9, 3.850395568937983*^9}, {
   3.850396158813326*^9, 3.8503961995797367`*^9}, {3.850397758841399*^9, 
   3.85039777208892*^9}, {3.850397812833973*^9, 3.8503978483858*^9}, {
   3.850398333716131*^9, 3.850398340930708*^9}, {3.850398553284445*^9, 
   3.850398584244698*^9}, 3.850398891036722*^9},
 CellLabel->
  "In[163]:=",ExpressionUUID->"d9cc3233-c6d6-4e8a-a1dd-50b4fb70b42d"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellChangeTimes->{
  3.850323036650879*^9, {3.85032314972884*^9, 3.850323176506872*^9}, 
   3.850323257956277*^9, 3.850323366640108*^9, 3.850323404489972*^9, 
   3.8503234589710207`*^9, {3.850323492773278*^9, 3.850323512456037*^9}, 
   3.850326207621525*^9, 3.850326240404155*^9, {3.850326363128134*^9, 
   3.8503264042689238`*^9}, 3.850331289877302*^9, 3.85036747676048*^9, 
   3.850370103180328*^9, 3.850373567678563*^9, 3.850382876725748*^9, 
   3.850391980281293*^9, 3.8503954101792316`*^9, 3.850395630645425*^9, 
   3.850395672109173*^9, 3.850395707236992*^9, 3.850396173879451*^9, {
   3.850397823833192*^9, 3.850397851271137*^9}, 3.850398087754899*^9, 
   3.850398244950474*^9, 3.850398343002091*^9, 3.850398574551634*^9, 
   3.850398897091425*^9, {3.851077058870008*^9, 3.8510770782731857`*^9}, 
   3.8512649252191973`*^9, 3.851267106569421*^9, 3.8512681328788977`*^9, 
   3.851268557711499*^9},
 CellLabel->
  "Out[164]=",ExpressionUUID->"04b0b036-6d12-47e3-ade4-7eb7571a1791"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"EFGH", " ", "is", " ", "equidiagonal", " ", "if", " ", "EG"}], 
     "=", 
     RowBox[{"FH", " ", "or", " ", "equivalently"}]}], ",", " ", 
    RowBox[{
     RowBox[{"EG", "^", "2"}], "=", 
     RowBox[{"FH", "^", "2"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"lenEG", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"dist", "[", 
        RowBox[{"tE", ",", "tG"}], "]"}], "/.", "equidiagonalCondition"}], "/.",
       "givenF12"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lenFH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"dist", "[", 
        RowBox[{"tF", ",", "tH"}], "]"}], "/.", "equidiagonalCondition"}], "/.",
       "givenF12"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"lenEG", "^", "2"}], "-", 
     RowBox[{"lenFH", "^", "2"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.850398919596998*^9, 3.850398988660727*^9}, {
  3.850399020446682*^9, 3.8503990571654*^9}, {3.8503991051575623`*^9, 
  3.850399138125573*^9}},
 CellLabel->
  "In[165]:=",ExpressionUUID->"facbd850-a887-4c22-93b0-ce25589a5092"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.850398989558436*^9, {3.8503990237646933`*^9, 3.850399031082075*^9}, 
   3.850399140084742*^9, {3.851077060549179*^9, 3.851077078281958*^9}, 
   3.851264926912079*^9, 3.851267110077746*^9, 3.851268132910302*^9, 
   3.851268557754368*^9},
 CellLabel->
  "Out[167]=",ExpressionUUID->"c3ceb33b-68f8-4988-a1eb-07d57737ff66"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Theorem 6.21: if the center is the inner Vecten point, then EFGH is \
orthodiagonal\
\>", "Subsection",
 CellChangeTimes->{{3.850367720388095*^9, 3.8503677251030617`*^9}, {
   3.8503677897854433`*^9, 3.850367862617402*^9}, {3.8503953283452578`*^9, 
   3.850395336177104*^9}, 3.850396243740274*^9, {3.8503972794235077`*^9, 
   3.850397297455221*^9}, {3.851266864111401*^9, 
   3.8512668779111137`*^9}},ExpressionUUID->"435ead1d-17dd-4df5-8f58-\
07870d25ae86"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "The", " ", "center", " ", "function", " ", "for", " ", "the", " ", 
     "inner", " ", "Vecten", " ", "point", " ", "is", " ", 
     RowBox[{"Sin", "[", "A", "]"}]}], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"B", "-", "C"}], "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"abcFn", "=", 
   RowBox[{"convertToABC", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "A", "]"}], "-", 
     RowBox[{"Cos", "[", 
      RowBox[{"B", "-", "C"}], "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8503222654156637`*^9, 3.8503222834478817`*^9}, {
   3.8503223259914837`*^9, 3.8503223435599127`*^9}, {3.850322379833313*^9, 
   3.850322381087789*^9}, {3.850323394964088*^9, 3.850323398555464*^9}, 
   3.850323453876525*^9, {3.8503234861406097`*^9, 3.850323508139471*^9}, {
   3.8503263581257544`*^9, 3.850326399061891*^9}, {3.8503678877426987`*^9, 
   3.850367900337617*^9}, {3.850395344634968*^9, 3.850395370241869*^9}, {
   3.850395465274781*^9, 3.8503955012669086`*^9}, {3.850395607447566*^9, 
   3.8503956139311543`*^9}, 3.850395696898078*^9, 3.850395728148027*^9, {
   3.8503974907292624`*^9, 3.850397543120285*^9}},
 CellLabel->
  "In[168]:=",ExpressionUUID->"1dcedd23-ffdb-4649-934e-d45003cb79d7"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["c", "2"], "+", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}]]}], ")"}]}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["a", "2"], " ", "b", " ", "c"}]]], "Output",
 CellChangeTimes->{
  3.8503956148584023`*^9, 3.8503956484863*^9, 3.850395698058226*^9, 
   3.8503957299550743`*^9, 3.850396119297983*^9, 3.8503975473811913`*^9, 
   3.850397714335268*^9, {3.8510770582917147`*^9, 3.851077078123982*^9}, 
   3.851264924673444*^9, 3.851268132954976*^9, 3.851268557807087*^9},
 CellLabel->
  "Out[168]=",ExpressionUUID->"043f0998-c150-4776-bf70-a73d37362623"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"abcFn", "=", 
  RowBox[{"abcFn", "*", "2", "*", "a", "*", "b", "*", "c"}]}]], "Input",
 CellChangeTimes->{{3.850395520506577*^9, 3.85039554510585*^9}, {
  3.850395641859372*^9, 3.850395662218252*^9}, {3.8503977233624077`*^9, 
  3.850397730713174*^9}},
 CellLabel->
  "In[169]:=",ExpressionUUID->"93a640ee-66cf-4749-b0a9-819d2f267b5c"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["c", "2"], "+", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}]]}], ")"}]}]}], 
  "a"]], "Output",
 CellChangeTimes->{{3.850395537924292*^9, 3.850395547909449*^9}, 
   3.850395618574678*^9, 3.850395663905307*^9, 3.850395701206102*^9, 
   3.850395733349463*^9, 3.850396123928252*^9, 3.850397732390554*^9, {
   3.851077058299172*^9, 3.851077078130424*^9}, 3.851264924680265*^9, 
   3.8512681329830713`*^9, 3.8512685578139677`*^9},
 CellLabel->
  "Out[169]=",ExpressionUUID->"0dcc00a9-e3a9-48b9-9409-645a6bcffc1e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"givenF11", "=", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "\[Rule]", 
   "abcFn"}]}]], "Input",
 CellChangeTimes->{3.8503977433376923`*^9},
 CellLabel->
  "In[170]:=",ExpressionUUID->"27b94af1-2e60-406b-a1c2-2b58f0fd71a9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "\[Rule]", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], "-", 
       SuperscriptBox["c", "2"], "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "4"]}], "-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "+", 
            SuperscriptBox["c", "2"]}], ")"}]}]}]]}], ")"}]}]}], 
   "a"]}]], "Output",
 CellChangeTimes->{
  3.850395627081925*^9, 3.8503956682577972`*^9, 3.850395704104434*^9, 
   3.850395737561109*^9, 3.8503961270776863`*^9, 3.850397745769992*^9, {
   3.8510770583269863`*^9, 3.851077078159566*^9}, 3.851264924701199*^9, 
   3.8512681329914703`*^9, 3.8512685578548594`*^9},
 CellLabel->
  "Out[170]=",ExpressionUUID->"ad9e02fe-32b4-42c4-8266-5bdac4f4e103"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "EFGH", " ", "is", " ", "orthodiagonal", " ", "if", " ", "the", " ", 
     "product", " ", "of", " ", "the", " ", "slopes", " ", "of", " ", "FH", 
     " ", "and", " ", "EG", " ", "is"}], " ", "-", "1"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"symbolicProductOfSlopes", "=", 
     RowBox[{
      RowBox[{"productOfSlopes", "/.", "equidiagonalCondition"}], "/.", 
      "givenF11"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{"symbolicProductOfSlopes", ",", 
     RowBox[{
      RowBox[{"ay", "+", "bx", "-", "1"}], "<", "0"}]}], "]"}], 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"subject", " ", "to", " ", "condition", " ", "cy"}], "<", "0"}], 
    " ", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.850323023034013*^9, 3.850323035677452*^9}, {
   3.850323148350926*^9, 3.850323175043686*^9}, {3.850323360540249*^9, 
   3.8503233873471127`*^9}, 3.8503234824003973`*^9, 3.850326403437895*^9, {
   3.850367911371696*^9, 3.850367973041936*^9}, {3.850395378362175*^9, 
   3.8503954089394417`*^9}, {3.850395567267385*^9, 3.850395568937983*^9}, {
   3.850396158813326*^9, 3.8503961995797367`*^9}, {3.850397758841399*^9, 
   3.85039777208892*^9}, {3.850397812833973*^9, 3.8503978483858*^9}, {
   3.850398333716131*^9, 3.850398340930708*^9}, {3.850398553284445*^9, 
   3.850398584244698*^9}},
 CellLabel->
  "In[171]:=",ExpressionUUID->"878525ef-b740-436b-805b-06897b17b4a7"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellChangeTimes->{
  3.850323036650879*^9, {3.85032314972884*^9, 3.850323176506872*^9}, 
   3.850323257956277*^9, 3.850323366640108*^9, 3.850323404489972*^9, 
   3.8503234589710207`*^9, {3.850323492773278*^9, 3.850323512456037*^9}, 
   3.850326207621525*^9, 3.850326240404155*^9, {3.850326363128134*^9, 
   3.8503264042689238`*^9}, 3.850331289877302*^9, 3.85036747676048*^9, 
   3.850370103180328*^9, 3.850373567678563*^9, 3.850382876725748*^9, 
   3.850391980281293*^9, 3.8503954101792316`*^9, 3.850395630645425*^9, 
   3.850395672109173*^9, 3.850395707236992*^9, 3.850396173879451*^9, {
   3.850397823833192*^9, 3.850397851271137*^9}, 3.850398087754899*^9, 
   3.850398244950474*^9, 3.850398343002091*^9, 3.850398574551634*^9, {
   3.8510770587641497`*^9, 3.85107707816726*^9}, 3.8512649251463423`*^9, 
   3.851268133459844*^9, 3.851268558349531*^9},
 CellLabel->
  "Out[172]=",ExpressionUUID->"fc9e5f46-a9b7-4459-a52d-f44d2e63a047"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{914, 906},
WindowMargins->{{72, Automatic}, {Automatic, 123}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 175, 3, 98, "Title",ExpressionUUID->"bd04f0fd-e510-4437-adb9-c495525650d1"],
Cell[758, 27, 1189, 21, 196, "Text",ExpressionUUID->"d9ae5b00-24cb-42ef-bf55-b83f8fbee47e",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[1972, 52, 153, 3, 67, "Section",ExpressionUUID->"ea83c584-a5df-4c70-979c-98bd92cc2e7a"],
Cell[2128, 57, 19888, 310, 350, "Text",ExpressionUUID->"18c97685-4e73-4a02-a407-1ee84d57cc63"],
Cell[22019, 369, 1082, 30, 136, "Input",ExpressionUUID->"be809f6e-3aac-47e7-bf7c-c72473994155"],
Cell[CellGroupData[{
Cell[23126, 403, 3593, 93, 325, "Input",ExpressionUUID->"69b15f4a-620d-4ff7-80c0-3387e1bb2120"],
Cell[26722, 498, 1712, 30, 70, "Output",ExpressionUUID->"bc664a9a-9b76-4aba-a48a-eb2cd8809289"]
}, Open  ]],
Cell[28449, 531, 1694, 44, 199, "Input",ExpressionUUID->"9f75c4ac-89c6-4b35-a81c-090440708f08"],
Cell[30146, 577, 912, 26, 52, "Input",ExpressionUUID->"c25bf0f5-b532-4c6a-a7a2-b2ff16a46513"]
}, Closed]],
Cell[CellGroupData[{
Cell[31095, 608, 246, 4, 53, "Section",ExpressionUUID->"34d4cd20-b178-4c84-a892-921bf698231d"],
Cell[31344, 614, 9970, 269, 955, "Input",ExpressionUUID->"f0f2e5ae-e9fa-4f25-9139-cd37393fad58"],
Cell[CellGroupData[{
Cell[41339, 887, 193, 3, 54, "Subsection",ExpressionUUID->"06517a25-69eb-4688-8600-12e42e19bdf8"],
Cell[41535, 892, 3917, 114, 514, "Input",ExpressionUUID->"e8f24f1b-ac05-4bcf-93e7-320c44a53fe5"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[45501, 1012, 162, 3, 53, "Section",ExpressionUUID->"527f0677-9581-4518-b280-24f6883010ec"],
Cell[CellGroupData[{
Cell[45688, 1019, 156, 3, 54, "Subsection",ExpressionUUID->"f7c42966-a1ae-46e5-bf1e-c809011485dd"],
Cell[45847, 1024, 3732, 106, 325, "Input",ExpressionUUID->"383fc154-a099-4c2d-86bd-455bb560b852"],
Cell[CellGroupData[{
Cell[49604, 1134, 4019, 109, 430, "Input",ExpressionUUID->"3f761a6d-a820-4a5d-b767-9a9acb1237d5"],
Cell[53626, 1245, 3736, 68, 70, "Output",ExpressionUUID->"ea4090a9-4642-4aaf-b380-22e4a38432a9"]
}, Open  ]],
Cell[57377, 1316, 1483, 45, 115, "Input",ExpressionUUID->"19bea53b-4943-4f68-b0cd-771ccb694c5b"],
Cell[CellGroupData[{
Cell[58885, 1365, 914, 19, 94, "Input",ExpressionUUID->"12d15a83-0565-40af-83bd-452df32833a7"],
Cell[59802, 1386, 488, 9, 70, "Output",ExpressionUUID->"931433bb-d51a-48e4-9233-5be854fcaf41"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60339, 1401, 328, 5, 38, "Subsection",ExpressionUUID->"a0c9fe65-5704-4e64-a05f-f52c2ac54a26"],
Cell[CellGroupData[{
Cell[60692, 1410, 240, 4, 30, "Input",ExpressionUUID->"a9562b58-444b-40de-a2c3-c9e47050d454"],
Cell[60935, 1416, 641, 17, 70, "Output",ExpressionUUID->"1e6064d8-857e-4172-b76d-c171313b4e2a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61613, 1438, 242, 4, 30, "Input",ExpressionUUID->"eb39ad6c-9dd5-408e-b818-5943368da257"],
Cell[61858, 1444, 961, 29, 70, "Output",ExpressionUUID->"38e000c3-5cff-4af7-b2be-d4838bf17990"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62856, 1478, 341, 7, 30, "Input",ExpressionUUID->"90d07f02-38f6-43a4-acb1-44d4df2ca302"],
Cell[63200, 1487, 695, 18, 70, "Output",ExpressionUUID->"bf006def-9086-4e76-b822-7adb54186d22"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63932, 1510, 294, 6, 30, "Input",ExpressionUUID->"4a1fd764-cfeb-4f55-bb00-0bac238502ad"],
Cell[64229, 1518, 1266, 39, 70, "Output",ExpressionUUID->"27758cbc-aee2-4229-99ac-5ae1467085b0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65532, 1562, 297, 6, 30, "Input",ExpressionUUID->"c50af15f-9b11-460a-a06b-469a02361d8d"],
Cell[65832, 1570, 975, 30, 70, "Output",ExpressionUUID->"9ef854ed-7b1f-4d08-ae83-f0f39346fe16"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66844, 1605, 263, 5, 30, "Input",ExpressionUUID->"87e0735b-f73f-485a-b99d-2c0479f5e479"],
Cell[67110, 1612, 890, 25, 70, "Output",ExpressionUUID->"a35a69a2-3329-4eec-b5b3-267784ec7cb1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68037, 1642, 340, 7, 30, "Input",ExpressionUUID->"d2bc3402-90fa-4b4e-8a19-bae2178d27ed"],
Cell[68380, 1651, 506, 12, 70, "Output",ExpressionUUID->"c08f6538-bc23-43e3-905d-e1d20280f9fb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68923, 1668, 439, 11, 30, "Input",ExpressionUUID->"a4088408-a403-4149-8fd2-63b941af97c1"],
Cell[69365, 1681, 967, 28, 70, "Output",ExpressionUUID->"33d0c40b-0b13-4073-8463-5626bc2af8ba"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70369, 1714, 263, 5, 30, "Input",ExpressionUUID->"b9d2411a-45f5-4a9b-bf18-1d49fd527aa9"],
Cell[70635, 1721, 1142, 34, 70, "Output",ExpressionUUID->"dafd6af2-c910-473c-8c43-72beab37850e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71814, 1760, 259, 5, 30, "Input",ExpressionUUID->"959aa094-6085-428f-94ac-192255a3958e"],
Cell[72076, 1767, 1087, 32, 70, "Output",ExpressionUUID->"7c2e9efa-381e-465a-8ed1-41addb0a241c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73200, 1804, 263, 5, 30, "Input",ExpressionUUID->"f14d3430-8219-4943-a901-418279b8fe12"],
Cell[73466, 1811, 2026, 61, 70, "Output",ExpressionUUID->"612b245f-d0d7-4fff-8b43-e97828f84886"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75529, 1877, 299, 6, 30, "Input",ExpressionUUID->"a5f1ca02-d0b4-479d-8ccd-8431cb81fe74"],
Cell[75831, 1885, 2086, 65, 70, "Output",ExpressionUUID->"24d52d9f-b38d-427b-9613-f25073105971"]
}, Open  ]],
Cell[CellGroupData[{
Cell[77954, 1955, 298, 6, 30, "Input",ExpressionUUID->"d00e202b-375b-4791-a945-546977ed605a"],
Cell[78255, 1963, 1609, 51, 70, "Output",ExpressionUUID->"341e19fd-d0e9-4295-805c-f4fec56bb057"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79901, 2019, 244, 4, 30, "Input",ExpressionUUID->"89d0217a-0dfb-4e62-9c57-9af5f81d84c5"],
Cell[80148, 2025, 865, 25, 70, "Output",ExpressionUUID->"813750da-3f9f-4bd5-93ab-4e0667ffadfa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81050, 2055, 345, 7, 30, "Input",ExpressionUUID->"8c970b04-a6df-4fbb-b21e-0c969a1aa741"],
Cell[81398, 2064, 1026, 31, 70, "Output",ExpressionUUID->"d8e0f5a4-63d0-4f8a-8203-16cec4d5979e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82461, 2100, 218, 4, 30, "Input",ExpressionUUID->"bfe0eb25-2268-4555-87b9-5a1068bbb709"],
Cell[82682, 2106, 597, 16, 70, "Output",ExpressionUUID->"3a3c363f-dc11-4015-9abc-5dec3bb6695b"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[83328, 2128, 372, 7, 38, "Subsection",ExpressionUUID->"4f7bb391-bb1e-4f3d-804d-b7067ad7b5db"],
Cell[CellGroupData[{
Cell[83725, 2139, 618, 14, 73, "Input",ExpressionUUID->"64a65b6a-6a25-4096-bdb3-1c15f7c598fd"],
Cell[84346, 2155, 449, 8, 70, "Output",ExpressionUUID->"72b44ae8-1455-4086-912f-801d5ea98986"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[84844, 2169, 273, 6, 38, "Subsection",ExpressionUUID->"192f5fdb-dcbf-4271-b8ea-12d18778659d"],
Cell[85120, 2177, 799, 19, 73, "Input",ExpressionUUID->"3dabcd7b-7286-4d88-9e0a-4b91a1fa5451"],
Cell[85922, 2198, 9111, 245, 283, "Input",ExpressionUUID->"a10531a8-4c9b-4fea-a781-1ee72483bc55"],
Cell[95036, 2445, 492, 11, 30, "Input",ExpressionUUID->"36ce98ad-cd9e-426f-9389-243e6797726d"],
Cell[CellGroupData[{
Cell[95553, 2460, 664, 16, 52, "Input",ExpressionUUID->"231127d0-9944-4960-ba74-0ee74ff9d6ad"],
Cell[96220, 2478, 469, 7, 34, "Output",ExpressionUUID->"db8e023c-baf7-479c-9e77-1ad74af347b6"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[96738, 2491, 332, 5, 38, "Subsection",ExpressionUUID->"deb3417f-1391-40c9-838b-9982ece4fe00"],
Cell[97073, 2498, 253, 6, 58, "Text",ExpressionUUID->"ca43bcfc-1b5f-47e9-baf5-1f597b91d86a"],
Cell[CellGroupData[{
Cell[97351, 2508, 896, 26, 94, "Input",ExpressionUUID->"3b57d3c0-3a01-4765-bd80-6182f4b77fdb"],
Cell[98250, 2536, 1757, 52, 70, "Output",ExpressionUUID->"1dd2831a-d1f2-4f8b-a19b-20d0e663d20b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100044, 2593, 1569, 44, 241, "Input",ExpressionUUID->"3fc84274-b0b3-4479-a898-6799ee165b00"],
Cell[101616, 2639, 322, 5, 70, "Output",ExpressionUUID->"3cbd4729-f002-47a4-8c0d-5bd294be7a00"]
}, Open  ]],
Cell[CellGroupData[{
Cell[101975, 2649, 200, 3, 30, "Input",ExpressionUUID->"0caac5cb-3658-4376-b9f6-54099e8141b3"],
Cell[102178, 2654, 1690, 51, 70, "Output",ExpressionUUID->"a5125932-f694-4317-8591-97bf203d597a"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[103917, 2711, 449, 9, 38, "Subsection",ExpressionUUID->"d52d2e33-a473-41d4-a9a9-ff584660e09e"],
Cell[CellGroupData[{
Cell[104391, 2724, 593, 15, 30, "Input",ExpressionUUID->"1e756ef6-dc67-4fe4-9132-21c2b2f2abc2"],
Cell[104987, 2741, 2804, 89, 70, "Output",ExpressionUUID->"eb7d1d05-2cab-43b7-bfcf-2756146fbffb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[107828, 2835, 311, 6, 30, "Input",ExpressionUUID->"65db897a-87a3-4e3d-87ca-8abd731c2ad0"],
Cell[108142, 2843, 2208, 69, 70, "Output",ExpressionUUID->"3667574d-3d76-49c5-a191-87079223e08e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[110387, 2917, 247, 4, 30, "Input",ExpressionUUID->"cf2c93b3-fab3-4751-9333-48565112230d"],
Cell[110637, 2923, 1136, 35, 70, "Output",ExpressionUUID->"4bc24384-225e-42ff-b45e-8dbec3612d19"]
}, Open  ]],
Cell[111788, 2961, 253, 6, 58, "Text",ExpressionUUID->"0f2e5b44-5fea-439b-a5a2-c01d8deef252"],
Cell[CellGroupData[{
Cell[112066, 2971, 922, 26, 94, "Input",ExpressionUUID->"820ee153-4da0-4840-bdfd-f6c760c5c3b0"],
Cell[112991, 2999, 1833, 53, 70, "Output",ExpressionUUID->"d70a32d9-bfd0-4fbc-b9c6-4696b66da362"]
}, Open  ]],
Cell[CellGroupData[{
Cell[114861, 3057, 1569, 44, 241, "Input",ExpressionUUID->"63ff9faa-88a9-4606-93c5-2a89c8afa9ab"],
Cell[116433, 3103, 398, 7, 70, "Output",ExpressionUUID->"30f6796b-cd38-4fcd-a0dc-929426091e13"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[116880, 3116, 477, 8, 38, "Subsection",ExpressionUUID->"bae6a17f-22b5-4e10-958b-3d48f1a42e35"],
Cell[CellGroupData[{
Cell[117382, 3128, 471, 11, 30, "Input",ExpressionUUID->"3450c249-c06c-445e-971d-c4f69b4151f7"],
Cell[117856, 3141, 873, 26, 58, "Output",ExpressionUUID->"642a3a4e-d7f7-4d0f-b7b2-e743544e4cc7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[118766, 3172, 416, 10, 30, "Input",ExpressionUUID->"bc6e3978-3380-44e4-8d8d-ad89de844298"],
Cell[119185, 3184, 838, 26, 38, "Output",ExpressionUUID->"ebd00705-469a-469f-82cf-6396b04e7f50"]
}, Open  ]],
Cell[CellGroupData[{
Cell[120060, 3215, 251, 5, 30, "Input",ExpressionUUID->"007e86a3-3878-4643-a8be-0fb71b5069e5"],
Cell[120314, 3222, 843, 25, 37, "Output",ExpressionUUID->"501a948f-f62b-469c-b014-a387ac64338a"]
}, Open  ]],
Cell[121172, 3250, 253, 6, 58, "Text",ExpressionUUID->"8c5bb719-90e9-4ba5-99f2-8ab03f57801e"],
Cell[CellGroupData[{
Cell[121450, 3260, 926, 27, 94, "Input",ExpressionUUID->"bc8a1524-02d9-4898-a908-c66812042899"],
Cell[122379, 3289, 757, 19, 51, "Output",ExpressionUUID->"6eb6b919-306f-4980-bb9c-14671ad0dcc0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[123173, 3313, 1573, 45, 241, "Input",ExpressionUUID->"0c0514c3-8ae5-4084-b513-d78d13655646"],
Cell[124749, 3360, 422, 7, 70, "Output",ExpressionUUID->"a0a296b5-6ed9-4c04-b479-90d0b9d46a0e"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[125220, 3373, 155, 3, 38, "Subsection",ExpressionUUID->"d1b23e91-6622-424a-8a61-85a911fac350"],
Cell[125378, 3378, 691, 18, 52, "Input",ExpressionUUID->"03c85062-7029-4307-b182-c806db9ce06d"]
}, Closed]],
Cell[CellGroupData[{
Cell[126106, 3401, 224, 5, 38, "Subsection",ExpressionUUID->"cefecce3-28f2-4f69-8973-3a3b42b410e9"],
Cell[CellGroupData[{
Cell[126355, 3410, 426, 13, 52, "Input",ExpressionUUID->"d2da9581-16f8-42f0-87b7-c900a34f91b3"],
Cell[126784, 3425, 360, 10, 53, "Output",ExpressionUUID->"7c70addf-24b2-439d-9cfb-8eec287f28d8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[127181, 3440, 1102, 28, 94, "Input",ExpressionUUID->"76f2625b-8e28-4257-86af-a61dc6933ea8"],
Cell[128286, 3470, 275, 5, 34, "Output",ExpressionUUID->"eefed3a3-2557-4487-8cb5-02fdf47d775c"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[128610, 3481, 275, 6, 38, "Subsection",ExpressionUUID->"c982a1f2-604b-4270-82fe-69d2f81e3697"],
Cell[CellGroupData[{
Cell[128910, 3491, 557, 14, 52, "Input",ExpressionUUID->"d8a24e04-af16-4ae4-b83d-3ed79cbfedd9"],
Cell[129470, 3507, 721, 23, 54, "Output",ExpressionUUID->"350558b7-b83a-417a-a9d0-6a90ed00267d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[130228, 3535, 1102, 28, 94, "Input",ExpressionUUID->"65b4c073-4af1-40ae-bdc9-cb35d954a859"],
Cell[131333, 3565, 299, 5, 34, "Output",ExpressionUUID->"992f89f9-549d-40b3-9861-ce482f2dc43f"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[131681, 3576, 323, 6, 38, "Subsection",ExpressionUUID->"6b158d4b-a1ad-48a1-8d06-927c8bf6e004"],
Cell[CellGroupData[{
Cell[132029, 3586, 664, 17, 52, "Input",ExpressionUUID->"a5afea4f-9a34-46d1-94a2-05c0ed15d72d"],
Cell[132696, 3605, 767, 23, 55, "Output",ExpressionUUID->"e880c009-5dda-4d3f-ab09-ad9f38ee2aa8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133500, 3633, 1102, 28, 94, "Input",ExpressionUUID->"421c997c-2be8-4f33-83d1-0c37dadfd2de"],
Cell[134605, 3663, 351, 6, 34, "Output",ExpressionUUID->"fd8550d4-2348-4f7b-98f9-10f31ffd03f5"]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[135017, 3676, 208, 4, 67, "Section",ExpressionUUID->"1bf555aa-1d24-4de9-8078-f38936dd20fa"],
Cell[CellGroupData[{
Cell[135250, 3684, 154, 3, 54, "Subsection",ExpressionUUID->"eeef88fc-30a6-4e9d-8171-8401d5d340bf"],
Cell[135407, 3689, 3561, 95, 220, "Input",ExpressionUUID->"792aba18-16d8-4161-820d-df95ec9bc2ac"],
Cell[CellGroupData[{
Cell[138993, 3788, 6456, 171, 640, "Input",ExpressionUUID->"51663677-b119-4996-a82d-941aa201ce28"],
Cell[145452, 3961, 4502, 85, 70, "Output",ExpressionUUID->"a9b70bbb-ad9b-4454-ae47-13bf24713633"]
}, Open  ]],
Cell[149969, 4049, 1536, 47, 115, "Input",ExpressionUUID->"57303260-3b64-487b-841f-7afa7407084d"],
Cell[CellGroupData[{
Cell[151530, 4100, 918, 20, 94, "Input",ExpressionUUID->"294503a6-c302-41f1-9b86-cc946b67b353"],
Cell[152451, 4122, 518, 9, 70, "Output",ExpressionUUID->"76844400-cdec-45f8-8a0a-1a67d3b346d6"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[153018, 4137, 415, 8, 38, "Subsection",ExpressionUUID->"a999bf34-38d0-445f-b191-6f239af15e4e"],
Cell[CellGroupData[{
Cell[153458, 4149, 1271, 27, 52, "Input",ExpressionUUID->"bc41c0cf-26b9-4fc2-aa49-a38e3de4909c"],
Cell[154732, 4178, 956, 28, 70, "Output",ExpressionUUID->"b06e3b6f-5b6b-4c9c-a6ac-ac0760b252f6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[155725, 4211, 379, 9, 30, "Input",ExpressionUUID->"db13c463-4ab0-4630-a840-61e4fe2bea07"],
Cell[156107, 4222, 982, 27, 70, "Output",ExpressionUUID->"95d60543-72ef-4410-8b18-bb068ea0dfdd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[157126, 4254, 243, 7, 30, "Input",ExpressionUUID->"b20fb6e1-a15d-45ad-86ee-ec04f5419ebd"],
Cell[157372, 4263, 1056, 31, 70, "Output",ExpressionUUID->"cc667253-34e2-48f8-8702-79deb14964be"]
}, Open  ]],
Cell[CellGroupData[{
Cell[158465, 4299, 838, 16, 52, "Input",ExpressionUUID->"fe85beae-4d8d-4e32-93b7-68a541feeb71"],
Cell[159306, 4317, 821, 13, 70, "Output",ExpressionUUID->"359528da-ed91-4246-a908-861d5fc16839"]
}, Open  ]],
Cell[CellGroupData[{
Cell[160164, 4335, 325, 9, 30, "Input",ExpressionUUID->"94d2dc86-3943-41dc-a295-bec545c57dc1"],
Cell[160492, 4346, 343, 6, 70, "Output",ExpressionUUID->"6b9cc840-916f-487b-806c-066a31508b53"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[160884, 4358, 193, 3, 38, "Subsection",ExpressionUUID->"fb8d3196-f17a-44f2-baea-df18afb8a593"],
Cell[161080, 4363, 405, 9, 30, "Input",ExpressionUUID->"8d82821c-89af-406a-beff-c33dd57bdc2f"]
}, Closed]],
Cell[CellGroupData[{
Cell[161522, 4377, 516, 10, 38, "Subsection",ExpressionUUID->"aa60c6cb-06f4-4b10-a2d7-ffa71db94324"],
Cell[CellGroupData[{
Cell[162063, 4391, 1273, 25, 52, "Input",ExpressionUUID->"bfa6ba8a-fcec-4a03-bcf2-4853bb553aa2"],
Cell[163339, 4418, 856, 23, 56, "Output",ExpressionUUID->"24060242-91a4-4e2b-9997-6d845a870c58"]
}, Open  ]],
Cell[CellGroupData[{
Cell[164232, 4446, 358, 7, 30, "Input",ExpressionUUID->"bd220b39-fc5b-4ad9-b0da-e0e5a8b02797"],
Cell[164593, 4455, 878, 23, 38, "Output",ExpressionUUID->"842f904c-9c16-4ef8-9220-49dce09ccdf4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[165508, 4483, 309, 8, 30, "Input",ExpressionUUID->"e5de7394-f872-4609-a0ea-885c76f0d8b2"],
Cell[165820, 4493, 972, 26, 38, "Output",ExpressionUUID->"ddf10f4d-4f9f-4285-b05e-4e9f8bdc77d6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[166829, 4524, 1365, 27, 73, "Input",ExpressionUUID->"a5d075b8-8410-4d3e-a52c-cbda7213b40d"],
Cell[168197, 4553, 1055, 17, 34, "Output",ExpressionUUID->"b928a57c-ac57-41b3-9360-238f2b34ee33"]
}, Open  ]],
Cell[CellGroupData[{
Cell[169289, 4575, 1208, 34, 94, "Input",ExpressionUUID->"d280047b-64e3-49c2-b62c-fea5a228da3c"],
Cell[170500, 4611, 376, 7, 70, "Output",ExpressionUUID->"a6f0f011-4174-4911-96e9-98c4716a0add"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[170925, 4624, 567, 10, 38, "Subsection",ExpressionUUID->"23de70e7-e610-48c1-8ab6-f706c7f3b7eb"],
Cell[CellGroupData[{
Cell[171517, 4638, 719, 22, 30, "Input",ExpressionUUID->"43c5f55e-0638-4b2a-8e71-e8cb3c6c9571"],
Cell[172239, 4662, 994, 26, 70, "Output",ExpressionUUID->"1fb4bb7e-9ca0-4337-a58f-d7d09f12df4c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[173270, 4693, 1538, 33, 94, "Input",ExpressionUUID->"d9cc3233-c6d6-4e8a-a1dd-50b4fb70b42d"],
Cell[174811, 4728, 1033, 17, 70, "Output",ExpressionUUID->"04b0b036-6d12-47e3-ade4-7eb7571a1791"]
}, Open  ]],
Cell[CellGroupData[{
Cell[175881, 4750, 1208, 34, 94, "Input",ExpressionUUID->"facbd850-a887-4c22-93b0-ce25589a5092"],
Cell[177092, 4786, 372, 7, 70, "Output",ExpressionUUID->"c3ceb33b-68f8-4988-a1eb-07d57737ff66"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[177513, 4799, 468, 9, 38, "Subsection",ExpressionUUID->"435ead1d-17dd-4df5-8f58-07870d25ae86"],
Cell[CellGroupData[{
Cell[178006, 4812, 1277, 26, 52, "Input",ExpressionUUID->"1dcedd23-ffdb-4649-934e-d45003cb79d7"],
Cell[179286, 4840, 1314, 38, 81, "Output",ExpressionUUID->"043f0998-c150-4776-bf70-a73d37362623"]
}, Open  ]],
Cell[CellGroupData[{
Cell[180637, 4883, 358, 7, 30, "Input",ExpressionUUID->"93a640ee-66cf-4749-b0a9-819d2f267b5c"],
Cell[180998, 4892, 1272, 37, 79, "Output",ExpressionUUID->"0dcc00a9-e3a9-48b9-9409-645a6bcffc1e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[182307, 4934, 287, 8, 30, "Input",ExpressionUUID->"27b94af1-2e60-406b-a1c2-2b58f0fd71a9"],
Cell[182597, 4944, 1354, 40, 79, "Output",ExpressionUUID->"ad9e02fe-32b4-42c4-8266-5bdac4f4e103"]
}, Open  ]],
Cell[CellGroupData[{
Cell[183988, 4989, 1516, 33, 94, "Input",ExpressionUUID->"878525ef-b740-436b-805b-06897b17b4a7"],
Cell[185507, 5024, 982, 16, 34, "Output",ExpressionUUID->"fc9e5f46-a9b7-4459-a52d-f44d2e63a047"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)

