(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



(* ::Input::Initialization:: *)
<<ETCAll.mx;


(* ::Input::Initialization::RGBColor[0., 0., 0.]:: *)
ETC::"usage"= "ETC es una variable con las coordendadas puntos de la ETC.";
NombreETC::"usage"= "NombreETC es una variable con los nombres de los puntos de la ETC.";
CentralLines::"usage"= "CentralLines es una variable con las rectas en ETC.";
TrilinealesETC::"usage"= "Trilineales es una variable con las coordenadas de b\[UAcute]squeda en ETC.";
iETC::"usage"="iETC es una variable con los \[IAcute]ndices en ETC correspondientes a puntos infinitos."
ECUACIONES::"usage"="ECUACIONES es una base de datos de ecuaciones de rectas, circunferencias, c\[OAcute]nicas, c\[UAcute]bicas y curvas de grado superior";


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
GetETCInfo::usage="Informa de las variables contenidas en el fichero ETCAll.mx";


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
infoBaricentricas::"usage" = "Muestra informaci\[OAcute]n de funciones definidas en Baricentricas.nb.";


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
NombreValido::usage="NombreValido[name] devuelve True si name parece ser el nombre de un procedimiento o funci\[OAcute]n.";


(* ::Input::Initialization:: *)
NombreValido[name_]:=And[MemberQ[CharacterRange["A","Z"],StringTake[name,1]],And[StringLength[name]>2],Not[DigitQ[StringTake[name,{2}]]]]
infoBaricentricas:=Map[Information[#,"Usage"]&,Select[Names["Global`*"],NombreValido]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
s::"usage" = "La constante \!\(\*
StyleBox[\"s\",\nFontSlant->\"Italic\"]\) representa el semiper\[IAcute]metro del tri\[AAcute]ngulo de referencia";


(* ::Input::Initialization:: *)
s=(a+b+c)/2;


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
fSA::"usage" = "fSA, fSB, fSC are used with the Conway notation.";
fSB::"usage" = "fSA, fSB, fSC are used with the Conway notation.";
fSC::"usage" = "fSA, fSB, fSC are used with the Conway notation.";
fSW::"usage" = "Sw is related with the value of Brocard angle.";


(* ::Input::Initialization:: *)
fSA=(b^2+c^2-a^2)/2;fSB=(c^2+a^2-b^2)/2;fSC=(a^2+b^2-c^2)/2;fSW=(a^2+b^2+c^2)/2;


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
fS2::"usage" = "fS2 representa la f\[OAcute]rmula del cuadrado del doble del \[AAcute]rea del tri\[AAcute]ngulo ABC";
fJ2::"usage" = "fJ2 representa la f\[OAcute]rmula del cuadrado de J=OH/R";
fe2::"usage" = "fe2 representa la f\[OAcute]rmula (1-4Sin[w]^2) siendo w el \[AAcute]ngulo de Brocard";


(* ::Input::Initialization:: *)
fA=ArcCos[(-a^2+b^2+c^2)/(2 b c)];fB=ArcCos[(a^2-b^2+c^2)/(2 a c)];fC=ArcCos[(a^2+b^2-c^2)/(2 a b)];
fS2=Expand[4s(s-a)(s-b)(s-c)];
fJ2=(a^6-a^4 b^2-a^2 b^4+b^6-a^4 c^2+3 a^2 b^2 c^2-b^4 c^2-a^2 c^4-b^2 c^4+c^6)/(a^2 b^2 c^2);
fe2=(a^4-a^2 b^2+b^4-a^2 c^2-b^2 c^2+c^4)/(a^2 b^2+a^2 c^2+b^2 c^2);
fsa=(-a+b+c)/2;
fsb=(a-b+c)/2;
fsc=(a+b-c)/2;
fW=ArcCot[(a^2+b^2+c^2)/Sqrt[(a+b-c) (a-b+c) (-a+b+c) (a+b+c)]];
fD2=((a+b-c) (a-b+c) (-a+b+c) (a+b+c))/16;
fR2=a^2 b^2 c^2/((-a+b+c) (a+b-c) (a-b+c) (a+b+c));
fr2=((-a+b+c) (a+b-c) (a-b+c))/(4(a+b+c)) ;
fOH2=-((a^6-a^4 b^2-a^2 b^4+b^6-a^4 c^2+3 a^2 b^2 c^2-b^4 c^2-a^2 c^4-b^2 c^4+c^6)/((a-b-c) (a+b-c) (a-b+c) (a+b+c)));


(* ::Input::Initialization:: *)
Evaluar::"usage" = "Evaluar[expr] sustituye SA, SB, SC, SW por sus valores en t\[EAcute]rminos de a, b, c";


(* ::Input::Initialization:: *)
Evaluar[expr_]:=expr/.{A->fA,B->fB,C->fC,SA->fSA,SB->fSB,SC->fSC,SW->fSW,sa->fsa,sb->fsb,sc->fsc,R->Sqrt[fR2],r->Sqrt[fr2],\[CapitalDelta]->Sqrt[fD2],S->Sqrt[fS2],J->Sqrt[fJ2],e->Sqrt[fe2],W->fW,\[Tau]->(Sqrt[5]+1)/2,OH->Sqrt[fOH2]}; 


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ptA::"usage" = "ptA, ptB, ptC are the vertices of the reference triangle.";
ptB::"usage" = "ptA, ptB, ptC are the vertices of the reference triangle.";
ptC::"usage" = "ptA, ptB, ptC are the vertices of the reference triangle.";
rtBC::"usage" = "rtBC, rtCA, ptAB are the sidelines of the reference triangle.";
rtCA::"usage" = "rtBC, rtCA, ptAB are the sidelines of the reference triangle.";
rtAB::"usage" = "rtBC, rtCA, ptAB are the sidelines of the reference triangle.";


(* ::Input::Initialization:: *)
rtBC = ptA = {1, 0, 0};
rtCA = ptB = {0, 1, 0};
rtAB = ptC = {0, 0, 1};


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ptI::"usage" = "ptI is the incenter of the reference triangle.";
ptG::"usage" = "ptG is the centroid of the reference triangle.";
ptO::"usage" =  "ptO is the circumcenter of the reference triangle.";
ptH::"usage" =  "ptH is the orthocenter of the reference triangle.";
ptN::"usage" =  "ptN is the nine point center of the reference triangle.";
ptK::"usage" =  "ptK is the symmedian point of the reference triangle.";


(* ::Input::Initialization:: *)
{ptI,ptG,ptO,ptH,ptN,ptK}=ETC[[Range[1,6],2]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ptIa::"usage" = "ptIa, ptIb, ptIc are the excenters of the referenc triangle.";
ptIb::"usage" = "ptIa, ptIb, ptIc are the excenters of the referenc triangle.";
ptIc::"usage" = "ptIa, ptIb, ptIc are the excenters of the referenc triangle.";


(* ::Input::Initialization:: *)
ptIa = {-a, b, c};
ptIb = {a, -b, c};
ptIc = {a, b, -c};


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ptIX::"usage" = "ptIX, ptIY, ptIZ are contact points of the incircle and the sidelines.";
ptIY::"usage" = "ptIX, ptIY, ptIZ are contact points of the incircle and the sidelines.";
ptIZ::"usage" = "ptIX, ptIY, ptIZ are contact points of the incircle and the sidelines.";


(* ::Input::Initialization:: *)
ptIX = {0, s - c, s - b};
ptIY = {s - c, 0, s - a};
ptIZ = {s - b, s - a, 0};


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ptIaX::"usage" = "ptIaX, ptIaY, ptIaZ are contact points of the A-excircle and the sidelines.";
ptIaY::"usage" = "ptIaX, ptIaY, ptIaZ are contact points of the A-excircle and the sidelines.";
ptIaZ::"usage" = "ptIaX, ptIaY, ptIaZ are contact points of the A-excircle and the sidelines.";
ptIbX::"usage" = "ptIbX, ptIbY, ptIaZ are contact points of the B-excircle and the sidelines.";
ptIbY::"usage" = "ptIbX, ptIbY, ptIaZ are contact points of the B-excircle and the sidelines.";
ptIbZ::"usage" = "ptIbX, ptIbY, ptIaZ are contact points of the B-excircle and the sidelines.";
ptIcX::"usage" = "ptIcX, ptIcY, ptIaZ are contact points of the C-excircle and the sidelines.";
ptIcY::"usage" = "ptIcX, ptIcY, ptIaZ are contact points of the C-excircle and the sidelines.";
ptIcZ::"usage" = "ptIcX, ptIcY, ptIaZ are contact points of the C-excircle and the sidelines.";


(* ::Input::Initialization:: *)
ptIaX = {0, s-b, s-c}; ptIaY={s-b,0,-s};    ptIaZ = {s-c,-s,0};
ptIbX = {0, s-a, -s};    ptIbY = {s - a, 0, s - c}; ptIbZ = {-s, s - c, 0};
ptIcX = {0, -s, s - a};    ptIcY = {-s, 0, s - b};    ptIcZ = {s - a, s - b, 0};



(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PuntosIguales::"usage" = "PuntosIguales[ptP,ptQ] devuelve True y P y Q corresponden al mismo punto.";


(* ::Input::Initialization:: *)
PuntosIguales[ptP_,ptQ_]:=Simplify[Cross[ptP,ptQ]//.trVarsSubs ]==={0,0,0};


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ReglaDePermutacion::"usage" = "ReglaPermutacion is a list of substitution rules that allows to calculate a cyclic permutation of an expression. The set of affected by default is {a,b,c,\[Alpha],\[Beta],\[Gamma],u,v,w,p,q,r,x,y,z,A,B,C}.";


(* ::Input::Initialization:: *)
ReglaDePermutacion=ReglaDePermutacion={a->b,b->c,c->a,\[Alpha]->\[Beta],\[Beta]->\[Gamma],\[Gamma]->\[Alpha],u->v,v->w,w->u,p->q,q->r,r->p,x->y,y->z,z->x,A->B,B->C,C->A,SA->SB,SB->SC,SC->SA,sa->sb,sb->sc,sc->sa};


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Permutar::"usage"="Permutar[expr] returns a cyclic permutation of expr, according to the definition of ReglaDePermutacion.";


(* ::Input::Initialization::GrayLevel[0]:: *)
Permutar[expr_]:= expr /.ReglaDePermutacion;


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PermutarTerna::"usage"="PermutarTerna[list_] cycles list to the right and makes the subtitutions given by ReglaDePermutacion. In this way, expressions relative to A, B,C turn into expresions relative to B C A respectively";


(* ::Input::Initialization:: *)
PermutarTerna[list_]:=RotateRight[list] /.ReglaDePermutacion;


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
TernaCiclica::"usage" = "TernaCiclica[expr] returns {expr1,expr2,expr3} where expr1=expr, expr2=Permutar[expr1] and expr3=Permutar[expr2]";


(* ::Input::Initialization::GrayLevel[0]:: *)
TernaCiclica[expr_] :={expr, Permutar[expr],Permutar[Permutar[expr]]}


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
TernaCiclicaPuntos::"usage" = "TernaCiclica[expr] returns {expr1,expr2,expr3} where expr1=expr, expr2=PermutarTerna[expr1] and expr3=PermutarTerna[expr2]";


(* ::Input::Initialization::GrayLevel[0]:: *)
TernaCiclicaPuntos[expr_] :={expr, PermutarTerna[expr],PermutarTerna[PermutarTerna[expr]]}


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SumaCiclica::"usage" = "SumaCiclica[f] returns the sum of the elementos of TernaCiclica[expr].";


(* ::Input::Initialization::GrayLevel[0]:: *)
SumaCiclica[f_]:= Total[TernaCiclica[f]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EsCiclica::"usage" = "EsCiclica[\!\(\*
StyleBox[\"expr\",\nFontSlant->\"Italic\"]\)] devuelve True si \!\(\*
StyleBox[\"expr\",\nFontSlant->\"Italic\"]\) es c\[IAcute]clica";


(* ::Input::Initialization:: *)
EsCiclica[expr_]:=TernaCiclica[expr]==={expr,expr,expr};


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
GeneradorCiclico::"usage" = "GeneradorCiclico[expr] devuelve el generador c\[IAcute]clico de la exprexi\[OAcute]n c\[IAcute]clica expr";


(* ::Input::Initialization:: *)
GeneradorCiclico[expr_,vars_]:=Module[{expr1,t,gen,sumando},
If[EsCiclica[expr],
gen=0;expr1=expr;
While[expr1=!=0,
t=If[Head[expr1]===Plus,First[expr1],expr1];
sumando=If[EsCiclica[t],t/3,t];
If[Length[Intersection[vars,Variables[sumando]]]==2,sumando=Permutar[sumando]];
gen=gen+sumando;
expr1=expr1-If[EsCiclica[sumando],sumando,SumaCiclica[sumando]]];
gen,
Print["Uncyclic expression"]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Sustituir::"usage" = "Sustituir[expr,variable,valor] replaces the point variable by \!\(\*
StyleBox[\"valor\",\nFontSlant->\"Italic\"]\) in \!\(\*
StyleBox[\"expr\",\nFontSlant->\"Italic\"]\). For example, Sustituir[\!\(\*
StyleBox[\"expr\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\",\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"{\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"x\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\",\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"y\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\",\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"z\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"}\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\",\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"ptO\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"]\",\nFontSlant->\"Italic\"]\) replaces {x,y,z} with the coordinates of the circumcenter.";


(* ::Input::Initialization:: *)
Sustituir[expr_,variable_,valor_]:=Factor[expr /. Thread[variable->valor]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Sustituiruvw::"usage" = "Sustituiruvw[f, {x,y,z}] sustituye {u,v,w} por {x,y,z}";


(* ::Input::Initialization:: *)
Sustituiruvw[f_,{\[Alpha]_,\[Beta]_,\[Gamma]_}]:=Sustituir[f,{u,v,w},{\[Alpha],\[Beta],\[Gamma]}] ;


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Sustituirxyz::"usage" = "Sustituirxyz[f, {u,v,w}] sustituye {x,y,z} por {u,v,w}";


(* ::Input::Initialization:: *)
Sustituirxyz[f_,{\[Alpha]_,\[Beta]_,\[Gamma]_}]:=Sustituir[f,{x,y,z},{\[Alpha],\[Beta],\[Gamma]}] ;


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EliminarFactoresConstantes::"usage"="EliminarFactoresCostantes[expr] elimine los factores en los cuales las variables x, y, z no aparecen.";


(* ::Input::Initialization:: *)
EliminarFactoresConstantes[expr_]:=If[Head[expr]===Times,Apply[Times,Select[Table[expr[[i]],{i,1,Length[expr]}],Intersection[Variables[#],{x,y,z}]!={}&]],expr];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
sustS::"usage" = "sustS reduce expresiones en las que aparezcan potencias de S, j, o e";


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
sustH::"usage" = "sustH sustituye S, J y e por sus expresiones (con ra\[IAcute]ces) en t\[EAcute]rminos de a,b,c.";
susta4::"usage" = "susta4 expresa a^4 en t\[EAcute]rminos de b, c y S.";


(* ::Input::Initialization:: *)
susta4={a^4->2 a^2 b^2-b^4+2 a^2 c^2+2 b^2 c^2-c^4-4 S^2};
sustS={S^n_->fS2^Quotient[n,2] S^Mod[n,2],\[CapitalDelta]^n_->fD2^Quotient[n,2] \[CapitalDelta]^Mod[n,2],J^n_->fJ2^Quotient[n,2] J^Mod[n,2],e^n_->fe2^Quotient[n,2] e^Mod[n,2],R^n_->fR2^Quotient[n,2] R^Mod[n,2],r^n_->fr2^Quotient[n,2] r^Mod[n,2]};
sustH={S->Sqrt[fS2],J->Sqrt[fJ2],e->Sqrt[fe2],R->Sqrt[fR2],r->Sqrt[fr2]};


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
sustSASBSC::"usage" = "sustS expresar una f\[OAcute]rmula dada en terminos de a, b, c en otra dada en t\[EAcute]rminos de SA, SB, SC";


(* ::Input::Initialization:: *)
sustSASBSC={a^n_->(SB+SC)^Quotient[n,2] a^Mod[n,2],b^n_->(SC+SA)^Quotient[n,2] b^Mod[n,2],c^n_->(SA+SB)^Quotient[n,2] c^Mod[n,2]};


(* ::Input::Initialization:: *)
fb2=(-(a/2)+x)^2+y^2;fc2=(a/2+x)^2+y^2;


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
sustbcxy::"usage" = "sustbcxy expresar una f\[OAcute]rmula dada en terminos de a, b, c en otra dada en t\[EAcute]rminos de a,x,y";


(* ::Input::Initialization:: *)
sustbc={b^n_->fb2^Quotient[n,2] b^Mod[n,2],c^n_->fc2^Quotient[n,2] c^Mod[n,2]};
sustbcxy={b->Sqrt[fb2],c->Sqrt[fc2]};


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Simplificar::"usage" = "Simplificar devuelve una terna dividida por su M\[AAcute]ximo Com\[UAcute]n Divisor";


(* ::Input::Initialization:: *)
Simplificar[list_]:=Module[{gcd,lista},
lista=Factor[list];
If[SameQ[lista,{0,0,0}],lista,
gcd=Apply[PolynomialGCD,lista];lista=Simplify[Divide[lista,gcd]];
If[UnsameQ[Denominator[gcd],1],lista=Simplificar[lista Denominator[gcd]]]];
lista
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SimplificarLCM::"usage" = "SimplificarLCM es una alternativa a Simplificar que puede usarse para que un punto como {v w,w u,u v} se devuelva como {1/u,1/v,1/w}";


(* ::Input::Initialization:: *)
SimplificarLCM[list_]:=Factor[list/Apply[PolynomialLCM,list]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SimplificarPunto::"usage" = "SimplificarPunto[ptP] returns coordinates of P without S in its first coordinate. ";


(* ::Input::Initialization:: *)
SimplificarPunto[ptP_]:=Simplificar[Expand[(First[ptP]/.S->-S) ptP]/.sustS]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SimplificarFraccion::"usage" = "SimplificarFraccion[frac] returns an equivalent fraction without S in the denominator.\n SimplificarFraccion[frac,f] returns an equivalent fraction after applying conjugation S -> -S to f[expr]. \n SimplificarFraccion[frac] is equivalent to SimplificarFraccion[frac, Denominator].";


(* ::Input::Initialization:: *)
SimplificarFraccion[expr_,f_]:=Module[{conj},
conj=f[expr]/. S->-S;
Factor[(Expand[Numerator[expr] conj]/. sustS)/(Expand[Denominator[expr] conj]/. sustS)]
]
SimplificarFraccion[expr_]:=SimplificarFraccion[expr,Denominator]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Simetrizar::"usage" = "Simetrizar convierte en sim\[EAcute]tricas coordenadas de un punto que no lo son. Normalmente, por la presencia de alguna ra\[IAcute]z cuadrada";


(* ::Input::Initialization:: *)
Simetrizar[ptP_]:=Simplificar[Total[Table[Nest[PermutarTerna, ptP,n],{n,0,2}]]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ReducirS::"usage"="Busca la expresi\[OAcute]n de S^2 como sumando en t\[EAcute]rminos de a,b,c en las coordenadas de un punto y la sustituye por S";
ReducirS[ptP_]:=Module[{assumptions},assumptions={(a-b-c) (a+b-c) (a-b+c) (a+b+c)==-4 S^2,S>0};
Simplificar[TernaCiclica[Collect[First[ptP],S,Simplify[Factor[#],assumptions]&]]]];

SimplificarS::"usage"="Intenta simplificar coordenadas un punto que contienen S. Las coordenadas del punto deben ser c\[IAcute]clicas para que el SimplificarS funcione correctamente. ";
SimplificarS[ptP_]:=If[Cross[ptP,PermutarTerna[ptP]]==={0,0,0},
ReducirS[Simetrizar[SimplificarPunto[ptP]]]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
AlgSubs::"usage" = "AlgSubs[poly,eqns,var] La funci\[OAcute]n AlgSubs realiza una sustituci\[OAcute]n algebraica, reemplazando las identidades algebraicas contenidas en <eqn> en el polinomio <poly>.
Ejemplo: AlgSubs[2a*b^2-a*b*d,{a*b\[Equal]c},{a,b,c,d}] reenplaza a*b por c en la expresi\[OAcute]n 2a*b^2-a*b*d";


(* ::Input::Initialization:: *)
AlgSubs[poly_,eqns_,var_]:=Last[PolynomialReduce[poly,GroebnerBasis[eqns,var],var]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Shinagawa::"usage" = "Devuelve el coeficiente de Shinagawa de un punto de la recta de Euler.";


(* ::Input::Initialization:: *)
Shinagawa[ptP_]:=CalcularCombo[ptP,{ptG,ptH}]/{3,1}/.{R^2-> e/4,SW->e+f}


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CalcularCombo::"usage" = "CalcularCombo[ptX,{ptP,ptQ}] devuelve las coordenadas de ptX como combinaci\[OAcute]n lineal de ptP y ptQ";


(* ::Input::Initialization:: *)
CalcularCombo[ptX_,{ptP_,ptQ_,ptR_}]:=Module[{ptX1,ptP1,ptQ1,ptR1,sol},
sol=If[EsInfinito[ptX],{2,-1,-1},{}];
If[And[Not[EsInfinito[ptX]],Not[EsInfinito[ptP]],Not[EsInfinito[ptQ]],Not[EsInfinito[ptR]]],
{ptX1,ptP1,ptQ1,ptR1}=Map[#/Total[#]/.sustS/.sustH&,{ptX,ptP,ptQ,ptR}];
sol=Solve[ptX1==\[Lambda] ptP1+\[Mu] ptQ1+\[Nu] ptR1,{\[Lambda],\[Mu],\[Nu]}];
If[sol!={},sol=Simplificar[Map[ToRSABCW,Simplify[{\[Lambda],\[Mu],\[Nu]}/.sol[[1]]]]]];
If[sol!={},If[And[NumericQ[sol[[1]]],sol[[1]]<0],sol=-sol]];
];
sol
]


(* ::Input::Initialization:: *)
CalcularCombo[ptX_,{ptP_,ptQ_}]:=Module[{ptX1,ptP1,ptQ1,sol},
sol=If[EsInfinito[ptX],{1,-1},{}];
If[And[Not[EsInfinito[ptX]],Not[EsInfinito[ptP]],Not[EsInfinito[ptQ]]],
{ptX1,ptP1,ptQ1}=Map[#/Total[#]/.sustS/.sustH&,{ptX,ptP,ptQ}];
sol=Solve[ptX1==\[Lambda] ptP1+\[Mu] ptQ1,{\[Lambda],\[Mu]}];
If[sol!={},sol=Simplificar[Map[ToRSABCW,Simplify[{\[Lambda],\[Mu]}/.sol[[1]]]]]];
If[sol!={},If[And[NumericQ[sol[[1]]],sol[[1]]<0],sol=-sol]];
];
sol
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ComplejoQ::"usage" = "ComplejoQ[z] devuelve True si z es un n\[UAcute]mero complejo no real.";
Conjugado::"usage" = "Conjugado[z] devuelve el conjugado complejo de z.";


(* ::Input::Initialization:: *)
Conjugado[z_]:=ComplexExpand[Conjugate[z]];
ComplejoQ[\[Lambda]_]:=UnsameQ[Chop[N[ComplexExpand[Im[\[Lambda]]/.sustABCabc]]],0];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
TiempoMaximo::"usage"="TiempoMaximo es una constante usada para indicar el tiempo maximo de calculo. Su valor por defecto es 10";
TiempoMaximo=10;


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
AgruparFactores::"usage" = "AgruparFactores intenta buscar expresiones del tipo (\!\(\*SuperscriptBox[\(x\), \(n\)]\)-\!\(\*SuperscriptBox[\(y\), \(n\)]\)) en una expresi\[OAcute]n factorizada.";


(* ::Input::Initialization:: *)
AgruparFactores[expr_]:=Module[{res},
res=Factor[expr];
TimeConstrained[
res=res//. (x_-y_) (x_+y_)->x^2-y^2;
res=res//. (x_-y_)^2 (x_+y_)^2->(x^2-y^2)^2;  (*ho aggiunto questo pattern *)
res=res//. (x_-y_) (x_^2+x_ y_+y_^2):>x^3-y^3;res=res//. (x_^2-y_^2) (x_^4+x_^2 y_^2+y_^4):>x^6-y^6;res=res//. (x_+y_) (x_^2-x_ y_+y_^2):>x^3+y^3;res=res//. (x_^2+y_^2) (x_^4-x_^2 y_^2+y_^4):>x^6+y^6;res=res//. (x_^kk_-y_^kk_)^mm_ (x_^kk_+y_^kk_)^nn_:>(x^(2 kk)-y^(2 kk))^Min[mm,nn] (x^kk-y^kk)^(mm-Min[mm,nn]) (x^kk+y^kk)^(nn-Min[mm,nn]),TiempoMaximo,res]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SimplificarFactores::"usage" = "Simplifica y agrupa los factores de un punto.";


(* ::Input::Initialization:: *)
SimplificarFactores[expr_]:=AgruparFactores[Simplificar[expr]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EliminarConstantes::"usage" = "EliminarConstantes[expr] elimina factores constantes que pueda tener expr";


(* ::Input::Initialization:: *)
EliminarConstantes[expr_]:=If[Head[expr]===Times,Apply[Times,Select[Table[expr[[i]],{i,1,Length[expr]}],Intersection[Variables[#],{x,y,z}]!={}&]],expr];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
AgruparMonomios::"usage"="AgruparMonomios[expr,monomios] agrupa factorizados los monomios que se indiquen.";


(* ::Input::Initialization:: *)
AgruparMonomios[eqn_,monomios_]:=Factor[Coefficient[eqn,monomios] . monomios];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PuntoSobreRecta::"usage" = "PuntoSobreRecta[{p,q,r},t] devuelve un punto gen\[EAcute]rico de la recta {p,q,r}.";
PuntoSobreRecta::"usage" = "PuntoSobreRecta[ptA,ptB,t] devuelve un punto gen\[EAcute]rico de la recta AB.";


(* ::Input::Initialization:: *)
PuntoSobreRecta[{p_,q_,r_},var_:t]:=Simplificar[{r,r var,-p-q var}];
PuntoSobreRecta[ptA_,ptB_,var_:t]:=DividirRazon[ptA,ptB,var,1-var];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EsInfinito::"usage" = "EsInfinito[ptP] devuelve True si ptP es un punto infinito.";


(* ::Input::Initialization:: *)
EsInfinito[ptX_]:=SameQ[Factor[Total[ptX]],0];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Recta::"usage"="Recta[P,Q] halla los coeficientes de la ecuaci\[OAcute]n de la recta PQ";


(* ::Input::Initialization:: *)
Recta[P_,Q_] :=Simplificar[Cross[P,Q]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Punto::"usage"="Punto[r,s] halla las coordenadas de la intersecci\[OAcute]n de las rectas r y s";


(* ::Input::Initialization:: *)
Punto[r_,s_] := Simplificar[Cross[r,s]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PuntoInfinito::"usage" = "PuntoInfinito[{p,q,r}] devuelve el punto del infinito de la recta px + qy + rz=0";


(* ::Input::Initialization:: *)
PuntoInfinito[{p_,q_,r_}] := {q-r,r-p,p-q};


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Paralela::"usage" = "Paralela[\!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\),\!\(\*
StyleBox[\"r\",\nFontSlant->\"Italic\"]\)] devuelve la recta paralela a \!\(\*
StyleBox[\"r\",\nFontSlant->\"Italic\"]\) que pasa por el punto \!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\). \nParalela[\!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\), \!\(\*
StyleBox[\"Q\",\nFontSlant->\"Italic\"]\), \!\(\*
StyleBox[\"R\",\nFontSlant->\"Italic\"]\)] devuelve la recta paralela a la recta \!\(\*
StyleBox[\"QR\",\nFontSlant->\"Italic\"]\) que pasa por el punto \!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\).";


(* ::Input::Initialization:: *)
Paralela[P_, r_] := Recta[P,PuntoInfinito[r]];


(* ::Input::Initialization:: *)
Paralela[P_, Q_,R_] := Paralela[P, Recta[Q,R]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PuntoInfinitoPerpendicular::"usage"="PuntoInfinitoPerpendicular[ptJ] devuelve el punto del infinito de una recta perpendicular a una recta cuyo punto del infinito es ptJ.";


(* ::Input::Initialization:: *)
PuntoInfinitoPerpendicular[ptJ_] :=PuntoInfinito[{fSA,fSB,fSC}ptJ];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Perpendicular::"usage" = "Perpendicular[\!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\),\!\(\*
StyleBox[\"r\",\nFontSlant->\"Italic\"]\)] devuelve la recta perpendicular a \!\(\*
StyleBox[\"r\",\nFontSlant->\"Italic\"]\) que pasa por el punto \!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\). \nPerpendicular[\!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\), \!\(\*
StyleBox[\"Q\",\nFontSlant->\"Italic\"]\), \!\(\*
StyleBox[\"R\",\nFontSlant->\"Italic\"]\)] devuelve la recta perpendicular a la recta \!\(\*
StyleBox[\"QR\",\nFontSlant->\"Italic\"]\) que pasa por el punto \!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\).";


(* ::Input::Initialization:: *)
Perpendicular[P_,r_] :=Recta[P,PuntoInfinitoPerpendicular[PuntoInfinito[r]]];


(* ::Input::Initialization:: *)
Perpendicular[P_,Q_,R_]:=Perpendicular[P,Recta[Q,R]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SonParalelas::"usage" = "SonParalelas[r,s] devuelve True si las rectas r y s son paralelas";


(* ::Input::Initialization::GrayLevel[0]:: *)
SonParalelas[r_, s_] := Factor[PuntoInfinito[r] . s] == 0;


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SonPerpendiculares::"usage" = "SonPerpendiculares[r,s] devuelve True si las rectas r y s son perpendiculares";


(* ::Input::Initialization::GrayLevel[0]:: *)
SonPerpendiculares[r_,s_]:=Simplify[PuntoInfinitoPerpendicular[PuntoInfinito[r]] . s]==0;


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SonIsotomicas::"usage" = "SonIsotomicas[r,s] devuelve True si las rectas r y s son isot\[OAcute]micas.";


(* ::Input::Initialization::GrayLevel[0]:: *)
SonIsotomicas[rtL1_,rtL2_]:=Or[And[rtL1[[1]]==0,rtL2[[1]]==0,Simplify[Det[{{1,1},rtL1[[{2,3}]] rtL2[[{2,3}]]}]]===0],And[rtL1[[2]]==0,rtL2[[2]]==0,Simplify[Det[{{1,1},rtL1[[{3,1}]] rtL2[[{3,1}]]}]]===0],And[rtL1[[3]]==0,rtL2[[3]]==0,Simplify[Det[{{1,1},rtL1[[{1,2}]] rtL2[[{1,2}]]}]]===0],Simplify[Cross[{1,1,1},rtL1 rtL2]]==={0,0,0}]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PuntoInfinitoCuartaRecta::"usage" = "PuntoInfinitoCuartaRecta[r1,r2,r3] devuelve el punto del infinito de la recta r4 que forma con la recta r3 el mismo \[AAcute]ngulo que la recta r1 forma con la recta r2";


(* ::Input::Initialization:: *)
PuntoInfinitoCuartaRecta[r1_,r2_,r3_] := Module[
{S2,u1,v1,w1,u2,v2,w2,u3,v3,w3,U1,V1,W1,U3,V3,W3},
S2=fSB fSC + fSC fSA +fSA fSB;
{u1,v1,w1}=PuntoInfinito[r1];
{u2,v2,w2}=PuntoInfinito[r2];
{u3,v3,w3}=PuntoInfinito[r3];
{U1,V1,W1}=PuntoInfinitoPerpendicular[{u1,v1,w1}];
{U3,V3,W3}=PuntoInfinitoPerpendicular[{u3,v3,w3}];
S2(fSA u1 u2 + fSB v1 v2 + fSC w1 w2){u3,v3,w3}+(fSA U1 u2 +fSB V1 v2+ fSC W1 w2) {U3,V3,W3}
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CuartaRecta::"usage" = "CuartaRecta[ptP, r1,r2,r3] devuelve la recta que pasa por el punto ptP y que forma con la recta r3 el mismo \[AAcute]ngulo que la recta r1 forma con la recta r2";


(* ::Input::Initialization:: *)
CuartaRecta[ptP_,r1_,r2_,r3_] := Module[
{S2,u1,v1,w1,u2,v2,w2,u3,v3,w3,U1,V1,W1,U3,V3,W3},
S2=fSB fSC + fSC fSA +fSA fSB;
{u1,v1,w1}=PuntoInfinito[r1];
{u2,v2,w2}=PuntoInfinito[r2];
{u3,v3,w3}=PuntoInfinito[r3];
{U1,V1,W1}=PuntoInfinitoPerpendicular[{u1,v1,w1}];
{U3,V3,W3}=PuntoInfinitoPerpendicular[{u3,v3,w3}];
Recta[ptP,
S2(fSA u1 u2 + fSB v1 v2 + fSC w1 w2){u3,v3,w3}+(fSA U1 u2 +fSB V1 v2+ fSC W1 w2) {U3,V3,W3}]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
DividirRazon::usage="DividirRazon[ptP,ptQ,m,n] divide al segmento de extremos ptP y ptQ en la raz\[OAcute]n m:n";


(* ::Input::Initialization:: *)
DividirRazon[ptP_,ptQ_, m_, n_] :=Simplificar[n Tr[ptQ] ptP + m Tr[ptP] ptQ]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Medio::usage="Medio[ptP,ptQ] halla el punto medio del segmento de extremos ptP y ptQ";


(* ::Input::Initialization:: *)
Medio[ptP_,ptQ_] := DividirRazon[ptP,ptQ, 1,1]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Mediatriz::usage="Mediatriz[ptP,ptQ] halla la mediatriz del segmento de extremos ptP y ptQ";


(* ::Input::Initialization:: *)
Mediatriz[ptP_,ptQ_]:=Perpendicular[Medio[ptP,ptQ],ptP,ptQ];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Mediana::usage="Mediana[ptP,ptQ,ptR] halla la mediana del tri\[AAcute]ngulo PQR correspondiente al punto P.";


(* ::Input::Initialization:: *)
Mediana[P_,Q_,R_] := Recta[P, Medio[Q, R ]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Altura::usage="Altura[ptP,ptQ,ptR] halla la altura del tri\[AAcute]ngulo PQR correspondiente al punto P.";


(* ::Input::Initialization:: *)
Altura[P_,Q_,R_] := Perpendicular[P, Q, R];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
BisectrizInterior::"usage"=
"BisectrizInterior[ptA, ptB, ptC] devuelve la bisectriz interna del angulo A del tri\[AAcute]ngulo ABC.";


(* ::Input::Initialization:: *)
BisectrizInterior[{ptA_,ptB_,ptC_}]:=
Recta[ptA,DividirRazon[ptB,ptC,Sqrt[CuadradoDistancia[ptA,ptB]],Sqrt[CuadradoDistancia[ptA,ptC]]]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Pie::"usage"=
"Pie[ptP,r] devuelve la proyecci\[OAcute]n ortogonal del punto P sobre la recta r.\nPie[ptP,ptQ,ptR] devuelve la proyecci\[OAcute]n ortogonal del punto P sobre la recta QR.";


(* ::Input::Initialization:: *)
Pie[P_,r_] :=Punto[Perpendicular[P,r],r];


(* ::Input::Initialization:: *)
Pie[P_,Q_,R_] := Pie[P,Recta[Q,R]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SimetriaCentral::"usage"=
"SimetriaCentral[ptP,ptO] devuelve el punto sim\[EAcute]trico del punto P respecto del punto O.";


(* ::Input::Initialization::GrayLevel[0]:: *)
SimetriaCentral[ptP_,ptO_] :=DividirRazon[ptP, ptO, 2,-1];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SimetriaAxial::"usage"=
"SimetriaAxial[ptP,r] devuelve el punto sim\[EAcute]trico del punto P respecto dela recta r.\nSimetriaAxial[ptP,ptQ,ptR] devuelve el punto sim\[EAcute]trico del punto P respecto dela recta QR.";


(* ::Input::Initialization:: *)
SimetriaAxial[P_,r_] :=
DividirRazon[P, Pie[P,r], 2,-1];


(* ::Input::Initialization:: *)
SimetriaAxial[P_, Q_, R_] := 
SimetriaAxial[P, Recta[Q,R]];


(* ::Input::Initialization:: *)
SimetriaAxialRecta::"usage"=
"SimetriaAxialRecta[r,s] devuelve la reflexi\[OAcute]n de la recta r respecto de la recta s.\n
SimetriaAxial[ptP,ptQ,ptR,ptS] devuelve la reflexi\[OAcute]n de la recta PQ respecto de la recta RS.";


(* ::Input::Initialization:: *)
SimetriaAxialRecta[{p1_,p2_,p3_},{q1_,q2_,q3_}]:=Simplificar[{(-a^2 (q1-q2) (q1-q3)+(q2-q3) (b^2 (q1-q2)+c^2 (-q1+q3))) (a^2 (q1 (p1 q1-(p2+p3) q1+p3 q2)+(p2 q1-p1 q2) q3)-b^2 (p3 q1 (-q1+q2)+p1 q2 (q2-q3)+p2 q1 (q1-2 q2+q3))-c^2 (p3 q1 (q1+q2-2 q3)+p2 q1 (-q1+q3)+p1 q3 (-q2+q3))),(-b^2 (-q1+q2) (q2-q3)+(a^2 (q1-q2)+c^2 (q2-q3)) (-q1+q3)) (-c^2 (p3 q2 (q1+q2-2 q3)+p2 q3 (-q1+q3)+p1 q2 (-q2+q3))-a^2 (p3 (q1-q2) q2+p2 q1 (q1-q3)+p1 q2 (-2 q1+q2+q3))+b^2 (q2 (p2 q2-(p1+p3) q2+p1 q3)+q1 (p3 q2-p2 q3))),(-c^2 (-q1+q3) (-q2+q3)+(q1-q2) (b^2 (q2-q3)+a^2 (-q1+q3))) (-b^2 (p3 q2 (-q1+q2)+p1 (q2-q3) q3+p2 q3 (q1-2 q2+q3))-a^2 (p3 q1 (q1-q2)+p2 (q1-q3) q3+p1 q3 (-2 q1+q2+q3))+c^2 (q2 (-p3 q1+p1 q3)+q3 (p2 q1-(p1+p2) q3+p3 q3)))}];


(* ::Input::Initialization:: *)
SimetriaAxialRecta[P_, Q_, R_,S_] := SimetriaAxialRecta[Recta[P,Q], Recta[R,S]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CuadradoCosenoRectas::"usage"=
"CuadradoCosenoRectas[recta1,recta2] devuelve el cuadrado del coseno del \[AAcute]ngulo formado por las rectas recta1 y recta2.";


(* ::Input::Initialization:: *)
CuadradoCosenoRectas[recta1_,recta2_]:=Module[
{ptP,ptQ,ptS},
{ptP,ptQ} = Map[PuntoInfinito,{recta1,recta2}];
ptS={fSA,fSB,fSC};
Simplify[Dot[ptS ptP,  ptQ]^2/(Dot[ptS, ptP^2]Dot[ptS, ptQ^2])]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Ortopolo::"usage"=
"Ortopolo[recta, {ptA, ptB, ptC}] devuelve el ortopolo de una recta respecto del tri\[AAcute]ngulo especificado ABC.\nOrtopolo[recta] devuelve el ortopolo de una recta respecto del tri\[AAcute]ngulo de referencia.";


(* ::Input::Initialization:: *)
Ortopolo[recta_, {ptA_, ptB_, ptC_}] :=  
   Punto[
  Perpendicular[Pie[ptB, recta], ptC, ptA], 
  Perpendicular[Pie[ptC, recta], ptA, ptB]]


(* ::Input::Initialization:: *)
Ortopolo[recta_] :=  
   Punto[
  Perpendicular[Pie[ptB, recta], ptC, ptA], 
  Perpendicular[Pie[ptC, recta], ptA, ptB]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Baricentro::"usage" = "Baricentro[trT] devuelve el baricentro del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Circuncentro::"usage" = "Circuncentro[trT] devuelve el circuncentro del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Ortocentro::"usage" = "Ortocentro[trT] devuelve el ortocentro del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
Baricentro[{ptA_,ptB_,ptC_}] :=Punto[
Mediana[ptA,ptB,ptC],
Mediana[ptB,ptC,ptA]];


(* ::Input::Initialization:: *)
Circuncentro[{ptA_,ptB_,ptC_}] :=Punto[
Mediatriz[ptA,ptB],
Mediatriz[ptA,ptC]];


(* ::Input::Initialization:: *)
Ortocentro[{ptA_,ptB_,ptC_}] := 
Punto[Perpendicular[ptA,ptB,ptC],
Perpendicular[ptB,ptC,ptA]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Incentro::"usage" = "Incentro[trT] devuelve el incentro del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
Incentro[{ptA_,ptB_,ptC_}]:=Punto[BisectrizInterior[{ptB,ptA,ptC}],BisectrizInterior[{ptA,ptB,ptC}]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PolarTrilineal::"usage" = "PolarTrilineal[ptP] devuelve la polar trilineal de ptP respecto  del tri\[AAcute]ngulo de referencia.
PolarTrilineal[ptP,trT] devuelve la polar trilineal de ptP respecto  del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization::GrayLevel[0]:: *)
PolarTrilineal[ptP_,{ptA_,ptB_,ptC_}]:=Module[{ptX,ptY,ptZ,ptY1,ptZ1},
{ptX,ptY,ptZ}=TrianguloCeviano[ptP,{ptA,ptB,ptC}];
ptY1=Punto[Recta[ptZ,ptX],Recta[ptC,ptA]];
ptZ1=Punto[Recta[ptX,ptY],Recta[ptA,ptB]];
Recta[ptY1,ptZ1]
]


(* ::Input::Initialization::GrayLevel[0]:: *)
PolarTrilineal[ptP_] := PolarTrilineal[ptP,{ptA,ptB,ptC}]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PoloTrilineal::"usage" = "PoloTrilineal[rtL] devuelve el polo trilineal de rtL respecto  del tri\[AAcute]ngulo de referencia.
PoloTrilineal[ptP,trT] devuelve el polo trilineal de rtL respecto  del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization::GrayLevel[0]:: *)
PoloTrilineal[rtL_,{ptA_,ptB_,ptC_}]:=Module[{ptX,ptY,ptZ,ptA1,ptB1,ptC1},
ptX=Punto[rtL,Recta[ptB,ptC]];
ptY=Punto[rtL,Recta[ptC,ptA]];
ptZ=Punto[rtL,Recta[ptA,ptB]];
ptB1=Punto[Recta[ptA,ptX],Recta[ptC,ptZ]];
ptC1=Punto[Recta[ptA,ptX],Recta[ptB,ptY]];
Punto[Recta[ptB,ptB1],Recta[ptC,ptC1]]
]


(* ::Input::Initialization::GrayLevel[0]:: *)
PoloTrilineal[r_]:=PolarTrilineal[r,{ptA,ptB,ptC}];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ConjugadoArmonico::"usage" = "ConjugadoArmonico[ptC,ptA,ptB] devuelve el conjugado arm\[OAcute]nico de \!\(\*
StyleBox[\"ptC\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\",\",\nFontSlant->\"Plain\"]\)\!\(\*
StyleBox[\" \",\nFontSlant->\"Plain\"]\)\!\(\*
StyleBox[\"respecto\",\nFontSlant->\"Plain\"]\)\!\(\*
StyleBox[\" \",\nFontSlant->\"Plain\"]\)\!\(\*
StyleBox[\"de\",\nFontSlant->\"Plain\"]\)\!\(\*
StyleBox[\" \",\nFontSlant->\"Plain\"]\)\!\(\*
StyleBox[\"ptA\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",\nFontSlant->\"Plain\"]\)\!\(\*
StyleBox[\"y\",\nFontSlant->\"Plain\"]\)\!\(\*
StyleBox[\" \",\nFontSlant->\"Plain\"]\)\!\(\*
StyleBox[\"ptB\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\",\",\nFontSlant->\"Plain\"]\)\!\(\*
StyleBox[\" \",\nFontSlant->\"Plain\"]\)\!\(\*
StyleBox[\"siendo\",\nFontSlant->\"Plain\"]\)\!\(\*
StyleBox[\" \",\nFontSlant->\"Plain\"]\)\!\(\*
StyleBox[\"ptA\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\",\",\nFontSlant->\"Plain\"]\)\!\(\*
StyleBox[\" \",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"ptB\",\nFontSlant->\"Italic\"]\) y \!\(\*
StyleBox[\"ptC\",\nFontSlant->\"Italic\"]\) tres puntos alineados";


(* ::Input::Initialization::GrayLevel[0]:: *)
ConjugadoArmonico[ptC_,ptA_,ptB_]:=Module[{ptP,ptQ,ptR,ptS},
ptP=Table[Unique[],3];
ptQ=Medio[ptP,ptA];
ptR=Punto[Recta[ptB,ptQ],Recta[ptC,ptP]];
ptS=Punto[Recta[ptA,ptR],Recta[ptB,ptP]];
Punto[Recta[ptQ,ptS],Recta[ptA,ptB]]
];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
VertexConjugate::"usage" = "VertexConjugate[ptP] devuelve el VertexConjugate de P y Q";


(* ::Input::Initialization:: *)
VertexConjugate[ptP_,ptQ_]:=Module[{trP,trQ},
trP=TrianguloCircunceviano[ptP];
trQ=TrianguloCircunceviano[ptQ];
PerspectorConABC[TrianguloRectas[MapThread[Recta,{trP,trQ}]]]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ConjugadoCicloceviano::"usage" = "ConjugadoCicloceviano[ptP] devuelve el conjugado cicloceviano de ptP respecto del tri\[AAcute]ngulo de referencia.
ConjugadoCicloceviano[ptP,trT] devuelve el conjugado cicloceviano de ptP respecto del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
ConjugadoCicloceviano[ptP_,trT_]:=ConjugadoIsotomico[Anticomplemento[ConjugadoIsogonal[Complemento[ConjugadoIsotomico[ptP,trT],trT],trT],trT],trT];

ConjugadoCicloceviano[ptP_]:=ConjugadoCicloceviano[ptP,{ptA,ptB,ptC}];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CocienteCeviano::"usage" = "CocienteCeviano[ptP,ptQ] devuelve el producto ceviano de ptP y ptQ.";


(* ::Input::Initialization:: *)
CocienteCeviano[ptP_,ptQ_]:=Perspector[TrianguloCeviano[ptP],TrianguloAnticeviano[ptQ]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ProductoCeviano::"usage" = "ProductoCeviano[ptP,ptQ] devuelve el producto ceviano de ptP y ptQ.";


(* ::Input::Initialization:: *)
ProductoCeviano[ptP_,ptQ_]:=Module[{ptA1,ptB1,ptC1,ptA2,ptB2,ptC2},
{ptA1,ptB1,ptC1}=TrianguloAnticeviano[ptP];
{ptA2,ptB2,ptC2}=TrianguloAnticeviano[ptQ];
PerspectorConABC[{
Punto[Recta[ptP,ptA2],Recta[ptQ,ptA1]],
Punto[Recta[ptP,ptB2],Recta[ptQ,ptB1]],
Punto[Recta[ptP,ptC2],Recta[ptQ,ptC1]]}]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Anticomplemento::"usage"= "Anticomplemento[ptP] devuelve el complemento de ptP respecto de ABC.\nAnticomplemento[ptP,trT] devuelve el complemento de ptP respecto de trT.";


(* ::Input::Initialization:: *)
Anticomplemento[ptP_,trT_]:=DividirRazon[Baricentro[trT],ptP,-2,3]
Anticomplemento[ptP_]:=DividirRazon[ptG,ptP,-2,3];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Antigonal::"usage"= "Antigonal[ptP] devuelve el punto antigonal de ptP.";


(* ::Input::Initialization:: *)
Antigonal[{u_,v_,w_}]:=Simplificar[{u (a^2 u v-b^2 u v+a^2 v^2-b^2 v^2+c^2 v^2-b^2 u w-b^2 v w+c^2 v w) (-c^2 u v+a^2 u w-c^2 u w+b^2 v w-c^2 v w+a^2 w^2+b^2 w^2-c^2 w^2),v (a^2 u^2-b^2 u^2-c^2 u^2+a^2 u v-b^2 u v+a^2 u w-c^2 u w+a^2 v w) (c^2 u v-a^2 u w+c^2 u w-b^2 v w+c^2 v w-a^2 w^2-b^2 w^2+c^2 w^2),-w (a^2 u^2-b^2 u^2-c^2 u^2+a^2 u v-b^2 u v+a^2 u w-c^2 u w+a^2 v w) (a^2 u v-b^2 u v+a^2 v^2-b^2 v^2+c^2 v^2-b^2 u w-b^2 v w+c^2 v w)}];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CentroNuevePuntos::"usage"= "CentroNuevePuntos[trT] devuelve el centro de la circunferencia de nueve puntos del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
CentroNuevePuntos[trT_] := Medio[Ortocentro[trT],Circuncentro[trT]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CevaPoint::"usage"= "CevaPoint[ptP,ptQ] devuelve el Cevapunto de ptP y ptQ.";


(* ::Input::Initialization:: *)
CevaPoint[ptP_,ptQ_]:=Module[{ptA1,ptB1,ptC1,ptA2,ptB2,ptC2},
{ptA2,ptB2,ptC2}=TrianguloAnticeviano[ptQ];
ptA1=Punto[Recta[ptA2,ptP],rtBC];
ptB1=Punto[Recta[ptB2,ptP],rtCA];
ptC1=Punto[Recta[ptC2,ptP],rtAB];
PerspectorConABC[{ptA1,ptB1,ptC1}]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CevaConjugate::"usage"= "CevaConjugate[ptP,ptQ] devuelve el CevaConjugado de ptP y ptQ.";


(* ::Input::Initialization:: *)
CevaConjugate[{p_,q_,r_},{u_,v_,w_}]:=
 Simplificar[{u(-q r u +r p v+ p q w),v(q r u - r p v + p q w), w(q r u  + r p v - p q w)}]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
RectasEulerConcurrentes::"usage"= "RectasEulerConcurrentes[{trT1,trT2,trT3}] devuelve True si las rectas de Euler de los tri\[AAcute]ngulos trT1,trT2 y trT3 son concurrentes.";


(* ::Input::Initialization:: *)
RectasEulerConcurrentes[triad_]:=Factor[Det[Map[RectaEuler, triad]]]===0;


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
InterseccionRectasEuler::"usage"= "InterseccionRectasEuler[{trT1,trT2,trT3}] devuelve el punto de intersecci\[OAcute]n de las rectas de Euler de los tri\[AAcute]ngulos trT1, trT2 y trT3 son concurrentes.";


(* ::Input::Initialization:: *)
InterseccionRectasEuler[{trA_,trB_,trC_}]:=Punto[RectaEuler[trB],RectaEuler[trC]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PuntoSimediano::"usage"= "PuntoSimediano[trT] devuelve el punto simediano del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
PuntoSimediano[{ptA_,ptB_,ptC_}]:=Module[{ptO},
ptO=Circuncentro[{ptA,ptB,ptC}];
Perspector[{ptA,ptB,ptC},TrianguloRectas[{
Perpendicular[ptA,ptA,ptO],
Perpendicular[ptB,ptB,ptO],
Perpendicular[ptC,ptC,ptO]}]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
RectaSimson::"usage"= "RectaSimson[ptP] devuelve la recta de Simson del punto ptP.";


(* ::Input::Initialization:: *)
RectaSimson[ptP_]:=
Recta[Pie[ptP,ptA,ptC],Pie[ptP,ptA,ptB]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
RectaEuler::"usage"= "RectaEuler[trT] devuelve la recta de Euler del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
RectaEuler[trT_] :=Recta[Baricentro[trT],Circuncentro[trT]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ConjugadoIsotomico::"usage" = "ConjugadoIsotomico[ptP] devuelve el conjugado isot\[OAcute]mico de ptP respecto del tri\[AAcute]ngulo de referencia.
ConjugadoIsotomico[ptP,trT] devuelve el conjugado isot\[OAcute]mico de ptP respecto del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
ConjugadoIsotomico[{u_,v_,w_}]:=Simplificar[{v w, w u,u v}]
ConjugadoIsotomico[ptP_,{ptA_,ptB_,ptC_}]:=Module[{ptA1,ptB1,ptC1,ptY,ptZ,ptB2,ptC2},
{ptA1,ptB1,ptC1}=TrianguloCeviano[ptP,{ptA,ptB,ptC}];
ptB2=SimetriaCentral[ptB1,Medio[ptA,ptC]];
ptC2=SimetriaCentral[ptC1,Medio[ptA,ptB]];
Punto[Recta[ptB,ptB2],Recta[ptC,ptC2]]
]


(* ::Input::Initialization:: *)
Complemento::"usage" = "Complemento[ptP] devuelve el complemento de ptP respecto del tri\[AAcute]ngulo de referencia.
Complemento[ptP,trT] devuelve el complemento de ptP respecto del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
Complemento[ptP_,trT_]:=DividirRazon[Baricentro[trT],ptP,-1,3]
Complemento[ptP_]:=DividirRazon[ptG,ptP,-1,3]


(* ::Input::Initialization:: *)
ConjugadoIsogonal::"usage" = "ConjugadoIsogonal[ptP] devuelve el conjugado isogonal de ptP respecto del tri\[AAcute]ngulo de referencia.
ConjugadoIsogonal[ptP,trT] devuelve el conjugado isogonal de ptP respecto del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
ConjugadoIsogonal[{u_,v_,w_}]:=Simplificar[{a^2 v w,b^2 w  u,c^2 u v}];


(* ::Input::Initialization:: *)
ConjugadoIsogonal[ptP_,{ptD_,ptE_,ptF_}]:=Simplificar[Punto[
CuartaRecta[ptD,Recta[ptD,ptP],Recta[ptD,ptF],Recta[ptD,ptE]],
CuartaRecta[ptE,Recta[ptE,ptP],Recta[ptE,ptD],Recta[ptE,ptF]]]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
InversoCircunscrita::"usage" = "InversoCircunscrita[ptP] devuelve el inverso de P respecto de la circunferencia circunscrita.";


(* ::Input::Initialization:: *)
InversoCircunscrita[{u_,v_,w_}]:=Simplificar[
{a^2 (b^2 c^2 u^2+a^2 c^2 u v-c^4 u v+a^2 b^2 u w-b^4 u w+a^4 v w-a^2 b^2 v w-a^2 c^2 v w),b^2 (b^2 c^2 u v-c^4 u v+a^2 c^2 v^2-a^2 b^2 u w+b^4 u w-b^2 c^2 u w-a^4 v w+a^2 b^2 v w),c^2 (-a^2 c^2 u v-b^2 c^2 u v+c^4 u v-b^4 u w+b^2 c^2 u w-a^4 v w+a^2 c^2 v w+a^2 b^2 w^2)}];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
TangenteCurva::"usage" = "TangenteCurva[curva,ptP] devuelve la tangente a una curva en el punto ptP.";


(* ::Input::Initialization:: *)
TangenteCurva[curva_,ptP_]:=Simplificar[{
D[curva,x]/.Thread[{x,y,z}->ptP],D[curva,y]/.Thread[{x,y,z}->ptP],D[curva,z]/.Thread[{x,y,z}->ptP]}]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CrossPoint::"usage" = "CrossPoint[ptP,ptQ] devuelve el crosspoint de ptP y ptQ.";


(* ::Input::Initialization:: *)
CrossPoint[{p_,q_,r_},{u_,v_,w_}] := Simplificar[{p u (r v+q w),q v (r u+p w),r w(q u+p v)}];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CrossSum::"usage" = "CrossSum[ptP,ptQ] devuelve el crosspoint de ptP y ptQ.";


(* ::Input::Initialization:: *)
(* The CrossSum of P and Q is the crosspoint of the isogonal conjugate of P and the isogonal conjugate of Q. *)
CrossSum[{p_,q_,r_},{u_,v_,w_}]:=Simplificar[{a^2 (r v+q w),b^2 (r u+p w),c^2 (q u+p v)}]


(* ::Input::Initialization:: *)
CrossDifference::"usage" = "CrossDifference[ptP,ptQ] devuelve la crossdiferencia de ptP y ptQ.";

(* The crossdifference of two points P and Q is the isogonal conjugate of the trilinear pole of line PQ. *)

CrossDifference[ptP_,ptQ_]:=ConjugadoIsogonal[PoloTrilineal[Recta[ptP,ptQ]]]

(*The crossconjugate of P and Q (or P-conjugate of Q) is the perspector of ABC and the cevian triangle of P with respect the cevian triangle of Q. *)

CrossConjugate::"usage" = "CrossConjugate[ptP,ptQ] devuelve el P-conjugate de ptQ.";

CrossConjugate[ptP_,ptQ_]:=PerspectorConABC[TrianguloCeviano[ptP,TrianguloCeviano[ptQ]]]


(* ::Input::Initialization:: *)
PuntoDePoncelet::"usage" = "PuntoDePoncelet[ptP,{ptA,ptB,ptC}] returns the Poncelet point of quadrilateral ABCP.";


(* ::Input::Initialization:: *)
PuntoDePoncelet[ptP_,{ptA_,ptB_,ptC_}]:=Module[{ptK,ptM,ptN,ptX,ptY,ptZ,ptO1,ptO2},
{ptK,ptM,ptN}={Medio[ptB,ptC],Medio[ptA,ptC],Medio[ptB,ptA]};
{ptX,ptY,ptZ}=Map[Medio[ptP,#]&,{ptA,ptB,ptC}];
ptO1=Circuncentro[{ptK,ptY,ptZ}];
ptO2=Circuncentro[{ptM,ptX,ptZ}];
SimetriaAxial[ptZ,Recta[ptO1,ptO2]]
];


(* ::Input::Initialization:: *)



(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CentroHazRectas::"usage" = "CentroHazRectas[eqn,par] devuelve devuelve el centro de un haz de rectas que dependen de un par\[AAcute]metro.";


(* ::Input::Initialization:: *)
CentroHazRectas[eqn_,par_]:=Apply[Punto,Transpose[CoefficientList[eqn,par]]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
HutsonExtouchTriangle::"usage" = "HutsonExtouchTriangle devuelve el tri\[AAcute]ngulo de contacto exterior de Hutson.";
HutsonIntouchTriangle::"usage" = "HutsonExtouchTriangle devuelve el tri\[AAcute]ngulo de contacto interior de Hutson.";


(* ::Input::Initialization::GrayLevel[0]:: *)
HutsonExtouchTriangle={
{-4 a^2,(a+b+c) (a+b-c),(a+b+c) (a-b+c)},
{(a+b+c) (b-c+a),-4 b^2,(a+b+c) (b+c-a)}, 
{(a+b+c) (c+a-b),(a+b+c) (c-a+b),-4 c^2}};
HutsonIntouchTriangle={
{4 a^2,(-a+b+c) (a-b+c),(-a+b+c) (a+b-c)},
{(-b+c+a) (b+c-a),4 b^2,(-b+c+a) (b-c+a)}, 
{(-c+a+b) (c-a+b),(a+b-c) (c+a-b),4 c^2}};


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
TrianguloTangencial::"usage" = "TrianguloTangencial returns the tangential triangle of a given triangle.";


(* ::Input::Initialization::GrayLevel[0]:: *)
TrianguloTangencial[{ptA_,ptB_,ptC_}]:=TrianguloRectas[
TernaCiclicaPuntos[Perpendicular[ptA,ptA,Circuncentro[{ptA,ptB,ptC}]]]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
HatzipolakisLozadaTriangle::"usage" = "HatzipolakisLozadaTriangle[ptP] returns the HatzipolakisLozada triangle of a given point.";


(* ::Input::Initialization::GrayLevel[0]:: *)
HatzipolakisLozadaTriangle[ptP_]:=Module[{ptPa,ptPb,ptPc,ptPab,ptPac},
{ptPa,ptPb,ptPc}=TernaCiclicaPuntos[SimetriaAxial[ptP,rtBC]];
ptPab=SimetriaAxial[ptPa,ptP,ptB];
ptPac=SimetriaAxial[ptPa,ptP,ptC];
TernaCiclicaPuntos[CentroNuevePuntos[{ptPa,ptPab,ptPac}]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SonSemejantes::"usage" = "SonSemejantes[trT1,trT2] devuelve True si los tri\[AAcute]ngulos trT1 y trT2 son semejantes";


(* ::Input::Initialization::GrayLevel[0]:: *)
SonSemejantes[{ptA1_, ptB1_, ptC1_}, {ptA2_, ptB2_, ptC2_}]:=And[   Simplify[CuadradoDistancia[ptA1, ptB1]*CuadradoDistancia[ptA2, ptC2] - CuadradoDistancia[ptA2, ptB2]*CuadradoDistancia[ptA1, ptC1]] == 0,   Simplify[CuadradoDistancia[ptA1, ptB1]*CuadradoDistancia[ptB2, ptC2] - CuadradoDistancia[ptA2, ptB2]*CuadradoDistancia[ptB1, ptC1]] == 0
];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SonHomoteticos::"usage" = "SonHomoteticos[{ptA1,ptB1,ptC1},{ptA2,ptB2,ptC2}]] devuelve True si los tri\[AAcute]ngulos {ptA1,ptB1,ptC1} y {ptA2, ptB2, ptC2}] tienen paralelos sus lados hom\[OAcute]logos";


(* ::Input::Initialization::GrayLevel[0]:: *)
SonHomoteticos[{ptA1_,ptB1_,ptC1_},{ptA2_,ptB2_,ptC2_}]:=And[
SonParalelas[Recta[ptB1,ptC1],Recta[ptB2,ptC2]],
SonParalelas[Recta[ptA1,ptC1],Recta[ptA2,ptC2]],
SonParalelas[Recta[ptA1,ptB1],Recta[ptA2,ptB2]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
TrianguloCeviano::"usage" = "TrianguloCeviano[ptP] devuelve el tri\[AAcute]ngulo ceviano de ptP respecto del tri\[AAcute]ngulo de referencia.
TrianguloCeviano[ptP,trT] devuelve el tri\[AAcute]ngulo ceviano de ptP respecto del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
TrianguloCeviano[ptP_,{ptA_,ptB_,ptC_}]:=
{Punto[Recta[ptA,ptP],Recta[ptB,ptC]],
Punto[Recta[ptB,ptP],Recta[ptC,ptA]],
Punto[Recta[ptC,ptP],Recta[ptA,ptB]]};
TrianguloCeviano[ptP_]:=TrianguloCeviano[ptP,{ptA,ptB,ptC}]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
TrianguloPedal::"usage" = "TrianguloPedal[ptP] devuelve el tri\[AAcute]ngulo pedal de ptP respecto del tri\[AAcute]ngulo de referencia ABC. TrianguloPedal[ptP,trT] devuelve el tri\[AAcute]ngulo pedal de ptP respecto del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
TrianguloPedal[ptP_,{ptA_,ptB_,ptC_}] :={
Pie[ptP,ptB,ptC],
Pie[ptP,ptC,ptA],
Pie[ptP,ptA,ptB]};
TrianguloPedal[ptP_]:=TrianguloPedal[ptP,{ptA,ptB,ptC}];


(* ::Input::Initialization:: *)
TrianguloAnticeviano[{u_,v_,w_}] :={{-u,v,w},{u,-v,w},{u,v,-w}};


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
TrianguloAnticeviano::"usage" = "TrianguloAnticeviano[ptP] devuelve el tri\[AAcute]ngulo anticeviano de ptP respecto del tri\[AAcute]ngulo de referencia ABC. TrianguloAnticeviano[ptP,trT] devuelve el tri\[AAcute]ngulo pedal de ptP respecto del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
TrianguloAnticeviano[ptP_,{ptA_,ptB_,ptC_}]:=Module[{ptA1,ptB1,ptC1,ptA2,ptB2,ptC2,ptX},
{ptA1,ptB1,ptC1}=TrianguloCeviano[ptP,{ptA,ptB,ptC}];
ptX=Punto[Recta[ptB,ptC],Recta[ptB1,ptC1]];
ptB2=Punto[Recta[ptB,ptP],Recta[ptA,ptX]];
ptC2=Punto[Recta[ptC,ptP],Recta[ptA,ptX]];
ptA2=Punto[Recta[ptB,ptC2],Recta[ptC,ptB2]];
{ptA2,ptB2,ptC2}
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
TrianguloAntipedal::"usage" = "TrianguloAntipedal[ptP] devuelve el tri\[AAcute]ngulo antipedal de ptP respecto del tri\[AAcute]ngulo de referencia ABC. TrianguloAntipedal[ptP,trT] devuelve el tri\[AAcute]ngulo antipedal de ptP respecto del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
TrianguloAntipedal[ptP_,{ptA_,ptB_,ptC_}] :={
Punto[Perpendicular[ptB,ptB,ptP],Perpendicular[ptC,ptC,ptP]],
Punto[Perpendicular[ptC,ptC,ptP],Perpendicular[ptA,ptA,ptP]],
Punto[Perpendicular[ptA,ptA,ptP],Perpendicular[ptB,ptB,ptP]]};
TrianguloAntipedal[ptP_]:=TrianguloAntipedal[ptP,{ptA,ptB,ptC}];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
TrianguloCicloceviano::"usage" = "TrianguloCicloceviano[ptP] devuelve el tri\[AAcute]ngulo cicloceviano de ptP respecto del tri\[AAcute]ngulo de referencia ABC. TrianguloCicloceviano[ptP,trT] devuelve el tri\[AAcute]ngulo cicloceviano de ptP respecto del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
TrianguloCicloceviano[ptP_,trT_]:=TrianguloCeviano[ConjugadoCicloceviano[ptP,trT],trT];
TrianguloCicloceviano[ptP_]:=TrianguloCicloceviano[ptP,{ptA,ptB,ptC}];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
TrianguloCircunceviano::"usage" = "TrianguloCircunceviano[ptP] devuelve el tri\[AAcute]ngulo circunceviano de ptP respecto del tri\[AAcute]ngulo de referencia ABC. TrianguloCircunceviano[ptP,trT] devuelve el tri\[AAcute]ngulo circunceviano de ptP respecto del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
TrianguloCircunceviano[ptP_,{ptA_,ptB_,ptC_}]:={
SegundaInterseccionCircunferencia[ptP,{ptA,ptB,ptC}],
SegundaInterseccionCircunferencia[ptP,{ptB,ptC,ptA}],
SegundaInterseccionCircunferencia[ptP,{ptC,ptA,ptB}]};
TrianguloCircunceviano[ptP_]:=TrianguloCircunceviano[ptP,{ptA,ptB,ptC}]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
TrianguloCirculoceviano::"usage" = "TrianguloCirculoceviano[ptP] devuelve el tri\[AAcute]ngulo circuloceviano de ptP respecto del tri\[AAcute]ngulo de referencia ABC. TrianguloCirculoceviano[ptP,trT] devuelve el tri\[AAcute]ngulo circuloceviano de ptP respecto del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
TrianguloCirculoceviano[ptP_,{ptA_,ptB_,ptC_}]:={
SegundaInterseccionCircunferencia[ptA,{ptP,ptB,ptC}],
SegundaInterseccionCircunferencia[ptB,{ptP,ptA,ptC}],
SegundaInterseccionCircunferencia[ptC,{ptP,ptA,ptB}]};
TrianguloCirculoceviano[ptP_]:=TrianguloCirculoceviano[ptP,{ptA,ptB,ptC}];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
TrianguloTangencial::"usage" = "TrianguloTangencial[ptP] devuelve el tri\[AAcute]ngulo tangencial del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
TrianguloTangencial[{ptA_,ptB_,ptC_}]:=Module[{ptO},
ptO=Circuncentro[{ptA,ptB,ptC}];
TrianguloRectas[{Perpendicular[ptA,ptA,ptO],Perpendicular[ptB,ptB,ptO],Perpendicular[ptC,ptC,ptO]}]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SonOrtologicos::"usage" = "SonOrtologicos[trT1,trT2] devuelve True si los tri\[AAcute]ngulos trT1 y trT2 son ortol\[OAcute]gicos.";


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
OrtologicoConABC::"usage" = "OrtologicoConABC[trT] devuelve True si trT es ortologico con ABC.";


(* ::Input::Initialization:: *)
SonOrtologicos[{ptA1_,ptB1_,ptC1_},{ptA2_,ptB2_,ptC2_}]:=Factor[Det[{
Perpendicular[ptA1,ptB2,ptC2],
Perpendicular[ptB1,ptC2,ptA2],
Perpendicular[ptC1,ptA2,ptB2]}]]==0


(* ::Input::Initialization:: *)
OrtologicoConABC[trT_]:=SonOrtologicos[trT,{ptA,ptB,ptC}]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CentroOrtologia::"usage" = "CentroOrtologia[trT1,trT2] devuelve el centro de ortolog\[IAcute]a de trT1 respecto de trT2.";


(* ::Input::Initialization:: *)
CentroOrtologia[{ptA1_,ptB1_,ptC1_},{ptA2_,ptB2_,ptC2_}]:=Punto[
Perpendicular[ptA1,ptB2,ptC2],
Perpendicular[ptB1,ptC2,ptA2]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SonParalelogicos::"usage" = "SonParalelogicos[trT1,trT2] devuelve True si los tri\[AAcute]ngulos trT1 y trT2 son paralel\[OAcute]gico.";


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ParalelogicoConABC::"usage" = "ParalelogicoConABC[trT] devuelve True si trT es paralel\[OAcute]gico con ABC.";


(* ::Input::Initialization:: *)
SonParalelogicos[{ptA1_,ptB1_,ptC1_},{ptA2_,ptB2_,ptC2_}]:=Factor[Det[{
Paralela[ptA1,ptB2,ptC2],
Paralela[ptB1,ptC2,ptA2],
Paralela[ptC1,ptA2,ptB2]}]]==0


(* ::Input::Initialization:: *)
ParalelogicoConABC[trT_]:=SonParalelogicos[trT,{ptA,ptB,ptC}]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CentroParalelogia::"usage" = "CentroParalelogia[trT1,trT2] devuelve el centro de paralelogia de trT1 respecto de trT2.";


(* ::Input::Initialization:: *)
CentroParalelogia[{ptA1_,ptB1_,ptC1_},{ptA2_,ptB2_,ptC2_}]:=Punto[
Paralela[ptA1,ptB2,ptC2],
Paralela[ptB1,ptC2,ptA2]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SonCiclologicos::"usage" = "SonCiclologicos[trT1,trT2] devuelve True si los tri\[AAcute]ngulos trT1 y trT2 son ciclol\[OAcute]gicos.";


(* ::Input::Initialization:: *)
SonCiclologicos[{ptA1_,ptB1_,ptC1_},{ptA2_,ptB2_,ptC2_}]:=Module[{ptOa,ptOb,ptOc,ra2,rb2,rc2,ptR,da2,db2,dc2},
{ptOa,ptOb,ptOc}={Circuncentro[{ptA1,ptB2,ptC2}],Circuncentro[{ptB1,ptA2,ptC2}],Circuncentro[{ptC1,ptA2,ptB2}]};
{ra2,rb2,rc2}={CuadradoDistancia[ptOa,ptA1],CuadradoDistancia[ptOb,ptB1],CuadradoDistancia[ptOc,ptC1]};
ptR=CentroRadical[ptOa,ptOb,ptOc,ra2,rb2,rc2];
{da2,db2,dc2}=Map[Apply[CuadradoDistancia,#]&,{{ptOa,ptR},{ptOb,ptR},{ptOc,ptR}}];
Factor[{da2-ra2,db2-rb2,dc2-rc2}]=={0,0,0}
]


(* ::Input::Initialization:: *)
CentroCiclologia::"usage" = "CentroCiclologia[trT1,trT2] devuelve el centro de ciclologia de trT1 respecto de trT2.";


(* ::Input::Initialization:: *)
CentroCiclologia[{ptA1_,ptB1_,ptC1_},{ptA2_,ptB2_,ptC2_}]:=Module[{ptOa,ptOb,ptOc,ra2,rb2,rc2,circA,circB,circC,ptR},
{ptOa,ptOb,ptOc}={Circuncentro[{ptA1,ptB2,ptC2}],Circuncentro[{ptB1,ptA2,ptC2}],Circuncentro[{ptC1,ptA2,ptB2}]};
{ra2,rb2,rc2}={CuadradoDistancia[ptOa,ptA1],CuadradoDistancia[ptOb,ptB1],CuadradoDistancia[ptOc,ptC1]};
{circA,circB,circC}={Circunferencia[ptOa,ra2],Circunferencia[ptOb,rb2],Circunferencia[ptOc,rc2]};
ptR=CentroRadical[ptOa,ptOb,ptOc,ra2,rb2,rc2]
]


(* ::Input::Initialization:: *)
SonSemiEulerologicos::"usage" = "SonSemiEulerologicos[A1B1C1,A2B2C2] devuelve True si las rectas A1B2C2, B1C2A2 y C1A2B2 son concurrentes.";


(* ::Input::Initialization:: *)
SonSemiEulerologicos[{ptA1_,ptB1_,ptC1_},{ptA2_,ptB2_,ptC2_}]:=Factor[Det[{RectaEuler[{ptA1,ptB2,ptC2}],RectaEuler[{ptB1,ptC2,ptA2}],RectaEuler[{ptC1,ptA2,ptB2}]}]]==0;


(* ::Input::Initialization:: *)
SonEulerologicos::"usage" = "SonEulerologicos[trT1,trT2] devuelve True si los tri\[AAcute]ngulos trT1 y trT2 son Eulerol\[OAcute]gicos.";


(* ::Input::Initialization:: *)
SonEulerologicos[{ptA1_,ptB1_,ptC1_},{ptA2_,ptB2_,ptC2_}]:=And[
Factor[Det[{RectaEuler[{ptA1,ptB2,ptC2}],RectaEuler[{ptB1,ptC2,ptA2}],RectaEuler[{ptC1,ptA2,ptB2}]}]]==0,
Factor[Det[{RectaEuler[{ptA2,ptB1,ptC1}],RectaEuler[{ptB2,ptC1,ptA1}],RectaEuler[{ptC2,ptA1,ptB1}]}]]==0
];


(* ::Input::Initialization:: *)
CentroEulerologia::"usage" = "CentroEulerologia[trT1,trT2] devuelve el centro de Eulerologia de trT1 respecto de trT2.";


(* ::Input::Initialization:: *)
CentroEulerologia[{ptA1_,ptB1_,ptC1_},{ptA2_,ptB2_,ptC2_}]:=Punto[RectaEuler[{ptA1,ptB2,ptC2}],RectaEuler[{ptB1,ptC2,ptA2}]];


(* ::Input::Initialization:: *)
TrianguloRectas::"usage" = "TrianguloRectas[{r1,r2,r3}] devuelve el tri\[AAcute]ngulo formado por r1, r2 y r3.";


(* ::Input::Initialization:: *)
TrianguloRectas[ {r1_,r2_,r3_}]:={Punto[r2,r3],Punto[r3,r1],Punto[r1,r2]};


(* ::Input::Initialization:: *)
RadicalTrace::"usage"= "RadicalTrace[O1,O2,r12,r22] devuelve el punto de intersecci\[OAcute]n entre la l\[IAcute]nea O1O2 y el eje radical de las circunferencias con centros O1, O2 y radios al cuadrado r12, r22.";


(* ::Input::Initialization:: *)
RadicalTrace[{u1_,v1_,w1_},{u2_,v2_,w2_},r12_,r22_]:={u2 (u1+v1+w1) (c^2 u2^2 v1^2-2 c^2 u1 u2 v1 v2+c^2 u1^2 v2^2-a^2 u2^2 v1 w1+b^2 u2^2 v1 w1+c^2 u2^2 v1 w1+a^2 u1 u2 v2 w1-b^2 u1 u2 v2 w1-c^2 u1 u2 v2 w1-a^2 u2 v1 v2 w1+b^2 u2 v1 v2 w1-c^2 u2 v1 v2 w1+a^2 u1 v2^2 w1-b^2 u1 v2^2 w1+c^2 u1 v2^2 w1+b^2 u2^2 w1^2+a^2 u2 v2 w1^2+b^2 u2 v2 w1^2-c^2 u2 v2 w1^2+a^2 v2^2 w1^2+a^2 u1 u2 v1 w2-b^2 u1 u2 v1 w2-c^2 u1 u2 v1 w2+a^2 u2 v1^2 w2-b^2 u2 v1^2 w2+c^2 u2 v1^2 w2-a^2 u1^2 v2 w2+b^2 u1^2 v2 w2+c^2 u1^2 v2 w2-a^2 u1 v1 v2 w2+b^2 u1 v1 v2 w2-c^2 u1 v1 v2 w2-2 b^2 u1 u2 w1 w2-a^2 u2 v1 w1 w2-b^2 u2 v1 w1 w2+c^2 u2 v1 w1 w2-a^2 u1 v2 w1 w2-b^2 u1 v2 w1 w2+c^2 u1 v2 w1 w2-2 a^2 v1 v2 w1 w2+b^2 u1^2 w2^2+a^2 u1 v1 w2^2+b^2 u1 v1 w2^2-c^2 u1 v1 w2^2+a^2 v1^2 w2^2+r12 (u1+v1+w1)^2 (u2+v2+w2)^2-r22 (u1+v1+w1)^2 (u2+v2+w2)^2)+u1 (u2+v2+w2) (c^2 u2^2 v1^2-2 c^2 u1 u2 v1 v2+c^2 u1^2 v2^2-a^2 u2^2 v1 w1+b^2 u2^2 v1 w1+c^2 u2^2 v1 w1+a^2 u1 u2 v2 w1-b^2 u1 u2 v2 w1-c^2 u1 u2 v2 w1-a^2 u2 v1 v2 w1+b^2 u2 v1 v2 w1-c^2 u2 v1 v2 w1+a^2 u1 v2^2 w1-b^2 u1 v2^2 w1+c^2 u1 v2^2 w1+b^2 u2^2 w1^2+a^2 u2 v2 w1^2+b^2 u2 v2 w1^2-c^2 u2 v2 w1^2+a^2 v2^2 w1^2+a^2 u1 u2 v1 w2-b^2 u1 u2 v1 w2-c^2 u1 u2 v1 w2+a^2 u2 v1^2 w2-b^2 u2 v1^2 w2+c^2 u2 v1^2 w2-a^2 u1^2 v2 w2+b^2 u1^2 v2 w2+c^2 u1^2 v2 w2-a^2 u1 v1 v2 w2+b^2 u1 v1 v2 w2-c^2 u1 v1 v2 w2-2 b^2 u1 u2 w1 w2-a^2 u2 v1 w1 w2-b^2 u2 v1 w1 w2+c^2 u2 v1 w1 w2-a^2 u1 v2 w1 w2-b^2 u1 v2 w1 w2+c^2 u1 v2 w1 w2-2 a^2 v1 v2 w1 w2+b^2 u1^2 w2^2+a^2 u1 v1 w2^2+b^2 u1 v1 w2^2-c^2 u1 v1 w2^2+a^2 v1^2 w2^2-r12 (u1+v1+w1)^2 (u2+v2+w2)^2+r22 (u1+v1+w1)^2 (u2+v2+w2)^2),v2 (u1+v1+w1) (c^2 u2^2 v1^2-2 c^2 u1 u2 v1 v2+c^2 u1^2 v2^2-a^2 u2^2 v1 w1+b^2 u2^2 v1 w1+c^2 u2^2 v1 w1+a^2 u1 u2 v2 w1-b^2 u1 u2 v2 w1-c^2 u1 u2 v2 w1-a^2 u2 v1 v2 w1+b^2 u2 v1 v2 w1-c^2 u2 v1 v2 w1+a^2 u1 v2^2 w1-b^2 u1 v2^2 w1+c^2 u1 v2^2 w1+b^2 u2^2 w1^2+a^2 u2 v2 w1^2+b^2 u2 v2 w1^2-c^2 u2 v2 w1^2+a^2 v2^2 w1^2+a^2 u1 u2 v1 w2-b^2 u1 u2 v1 w2-c^2 u1 u2 v1 w2+a^2 u2 v1^2 w2-b^2 u2 v1^2 w2+c^2 u2 v1^2 w2-a^2 u1^2 v2 w2+b^2 u1^2 v2 w2+c^2 u1^2 v2 w2-a^2 u1 v1 v2 w2+b^2 u1 v1 v2 w2-c^2 u1 v1 v2 w2-2 b^2 u1 u2 w1 w2-a^2 u2 v1 w1 w2-b^2 u2 v1 w1 w2+c^2 u2 v1 w1 w2-a^2 u1 v2 w1 w2-b^2 u1 v2 w1 w2+c^2 u1 v2 w1 w2-2 a^2 v1 v2 w1 w2+b^2 u1^2 w2^2+a^2 u1 v1 w2^2+b^2 u1 v1 w2^2-c^2 u1 v1 w2^2+a^2 v1^2 w2^2+r12 (u1+v1+w1)^2 (u2+v2+w2)^2-r22 (u1+v1+w1)^2 (u2+v2+w2)^2)+v1 (u2+v2+w2) (c^2 u2^2 v1^2-2 c^2 u1 u2 v1 v2+c^2 u1^2 v2^2-a^2 u2^2 v1 w1+b^2 u2^2 v1 w1+c^2 u2^2 v1 w1+a^2 u1 u2 v2 w1-b^2 u1 u2 v2 w1-c^2 u1 u2 v2 w1-a^2 u2 v1 v2 w1+b^2 u2 v1 v2 w1-c^2 u2 v1 v2 w1+a^2 u1 v2^2 w1-b^2 u1 v2^2 w1+c^2 u1 v2^2 w1+b^2 u2^2 w1^2+a^2 u2 v2 w1^2+b^2 u2 v2 w1^2-c^2 u2 v2 w1^2+a^2 v2^2 w1^2+a^2 u1 u2 v1 w2-b^2 u1 u2 v1 w2-c^2 u1 u2 v1 w2+a^2 u2 v1^2 w2-b^2 u2 v1^2 w2+c^2 u2 v1^2 w2-a^2 u1^2 v2 w2+b^2 u1^2 v2 w2+c^2 u1^2 v2 w2-a^2 u1 v1 v2 w2+b^2 u1 v1 v2 w2-c^2 u1 v1 v2 w2-2 b^2 u1 u2 w1 w2-a^2 u2 v1 w1 w2-b^2 u2 v1 w1 w2+c^2 u2 v1 w1 w2-a^2 u1 v2 w1 w2-b^2 u1 v2 w1 w2+c^2 u1 v2 w1 w2-2 a^2 v1 v2 w1 w2+b^2 u1^2 w2^2+a^2 u1 v1 w2^2+b^2 u1 v1 w2^2-c^2 u1 v1 w2^2+a^2 v1^2 w2^2-r12 (u1+v1+w1)^2 (u2+v2+w2)^2+r22 (u1+v1+w1)^2 (u2+v2+w2)^2),(u1+v1+w1) w2 (c^2 u2^2 v1^2-2 c^2 u1 u2 v1 v2+c^2 u1^2 v2^2-a^2 u2^2 v1 w1+b^2 u2^2 v1 w1+c^2 u2^2 v1 w1+a^2 u1 u2 v2 w1-b^2 u1 u2 v2 w1-c^2 u1 u2 v2 w1-a^2 u2 v1 v2 w1+b^2 u2 v1 v2 w1-c^2 u2 v1 v2 w1+a^2 u1 v2^2 w1-b^2 u1 v2^2 w1+c^2 u1 v2^2 w1+b^2 u2^2 w1^2+a^2 u2 v2 w1^2+b^2 u2 v2 w1^2-c^2 u2 v2 w1^2+a^2 v2^2 w1^2+a^2 u1 u2 v1 w2-b^2 u1 u2 v1 w2-c^2 u1 u2 v1 w2+a^2 u2 v1^2 w2-b^2 u2 v1^2 w2+c^2 u2 v1^2 w2-a^2 u1^2 v2 w2+b^2 u1^2 v2 w2+c^2 u1^2 v2 w2-a^2 u1 v1 v2 w2+b^2 u1 v1 v2 w2-c^2 u1 v1 v2 w2-2 b^2 u1 u2 w1 w2-a^2 u2 v1 w1 w2-b^2 u2 v1 w1 w2+c^2 u2 v1 w1 w2-a^2 u1 v2 w1 w2-b^2 u1 v2 w1 w2+c^2 u1 v2 w1 w2-2 a^2 v1 v2 w1 w2+b^2 u1^2 w2^2+a^2 u1 v1 w2^2+b^2 u1 v1 w2^2-c^2 u1 v1 w2^2+a^2 v1^2 w2^2+r12 (u1+v1+w1)^2 (u2+v2+w2)^2-r22 (u1+v1+w1)^2 (u2+v2+w2)^2)+w1 (u2+v2+w2) (c^2 u2^2 v1^2-2 c^2 u1 u2 v1 v2+c^2 u1^2 v2^2-a^2 u2^2 v1 w1+b^2 u2^2 v1 w1+c^2 u2^2 v1 w1+a^2 u1 u2 v2 w1-b^2 u1 u2 v2 w1-c^2 u1 u2 v2 w1-a^2 u2 v1 v2 w1+b^2 u2 v1 v2 w1-c^2 u2 v1 v2 w1+a^2 u1 v2^2 w1-b^2 u1 v2^2 w1+c^2 u1 v2^2 w1+b^2 u2^2 w1^2+a^2 u2 v2 w1^2+b^2 u2 v2 w1^2-c^2 u2 v2 w1^2+a^2 v2^2 w1^2+a^2 u1 u2 v1 w2-b^2 u1 u2 v1 w2-c^2 u1 u2 v1 w2+a^2 u2 v1^2 w2-b^2 u2 v1^2 w2+c^2 u2 v1^2 w2-a^2 u1^2 v2 w2+b^2 u1^2 v2 w2+c^2 u1^2 v2 w2-a^2 u1 v1 v2 w2+b^2 u1 v1 v2 w2-c^2 u1 v1 v2 w2-2 b^2 u1 u2 w1 w2-a^2 u2 v1 w1 w2-b^2 u2 v1 w1 w2+c^2 u2 v1 w1 w2-a^2 u1 v2 w1 w2-b^2 u1 v2 w1 w2+c^2 u1 v2 w1 w2-2 a^2 v1 v2 w1 w2+b^2 u1^2 w2^2+a^2 u1 v1 w2^2+b^2 u1 v1 w2^2-c^2 u1 v1 w2^2+a^2 v1^2 w2^2-r12 (u1+v1+w1)^2 (u2+v2+w2)^2+r22 (u1+v1+w1)^2 (u2+v2+w2)^2)};


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
BuscarConjugaciones::"usage"="BuscarConjugaciones[ptP] identifica las conjugaciones de un punto de un punto P respecto al tri\[AAcute]ngulo de referencia y otros tri\[AAcute]ngulos notables.";


(* ::Input::Initialization:: *)
BuscarConjugaciones[ptP_]:=Module[{n,i,f,conjugations,legends,ptQ,answers},
conjugations={ConjugadoIsogonal,ConjugadoIsotomico,ConjugadoIsogonal[#,TrianguloCeviano[ptG]]&,ConjugadoIsotomico[#,TrianguloCeviano[ptG]]&,ConjugadoIsogonal[#,TrianguloAnticeviano[ptG]]&,ConjugadoIsotomico[#,TrianguloAnticeviano[ptG]]&,ConjugadoIsogonal[#,TrianguloCeviano[ptH]]&,ConjugadoIsotomico[#,TrianguloCeviano[ptH]]&,ConjugadoIsogonal[#,TrianguloAnticeviano[ptI]]&,
ConjugadoIsotomico[#,TrianguloAnticeviano[ptI]]&};
legends={
"isogonal conjugate of ","isotomic conjugate of ","medial-isogonal conjugate of ","medial-isotomic conjugate of ","anticomplementay-isogonal conjugate of ","anticomplementary-isotomic conjugate of ","orthic-isogonal conjugate of ","orthic-isotomic conjugate of ","excentral-isogonal conjugate of ","excentral-isotomic conjugate of "};
answers={};n=0;
ptQ=If [FreeQ[ptP,S],ptP,ptP/.sustH];
If[UnsameQ[ptQ,{0,0,0}],
For[i=1,i<=Length[conjugations],i++,
f=conjugations[[i]];
n=IndiceTrilinealesETC[ObtenerTrilinealesETC[f[ptQ]]];
If[n!=0,AppendTo[answers,legends[[i]] <> "X"<>ToString[n]]]];
];
answers
]


(* ::Input::Initialization:: *)
ComplementaryConjugate::"usage" = "ComplementaryConjugate[ptP,prU] devuelve el punto P-complementary conjugate de U\n ComplementaryConjugate[ptU] devuelve el punto I-complementary conjugate de U, que se puede abreviar como complementary conjugate de U";


(* ::Input::Initialization:: *)
ComplementaryConjugate[{p_,q_,r_},{u_,v_,w_}]:=Simplificar[{a b c p (u-v-w) (b^3 r (u+v-w)+c^3 q (u-v+w)),-a b c q (u-v+w) (a^3 r (u+v-w)+c^3 p (-u+v+w)),-a b c r (u+v-w) (a^3 q (u-v+w)+b^3 p (-u+v+w))}];


(* ::Input::Initialization:: *)
ComplementaryConjugate[{u_,v_,w_}]:=ComplementaryConjugate[ptI,{u,v,w}];


(* ::Input::Initialization:: *)
AntiComplementaryConjugate::"usage" = "AntiComplementaryConjugate[ptP,prU] devuelve el punto P-anticomplementary conjugate de U\n AntiComplementaryConjugate[ptU] devuelve el punto I-anticomplementary conjugate de U, que se puede abreviar como anticomplementary conjugate de U";


(* ::Input::Initialization:: *)
AntiComplementaryConjugate[{p_,q_,r_},{u_,v_,w_}]:=Simplificar[{-a^3 q r (u+v) (u+w)+p (v+w) (b^3 r (u+v)+c^3 q (u+w)),a^3 q r (u+v) (u+w)+p (v+w) (-b^3 r (u+v)+c^3 q (u+w)),a^3 q r (u+v) (u+w)+p (v+w) (b^3 r (u+v)-c^3 q (u+w))}];


(* ::Input::Initialization:: *)
AntiComplementaryConjugate[{u_,v_,w_}]:=AntiComplementaryConjugate[ptI,{u,v,w}];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SonCoaxiales::"usage" = "SonCoaxiales[ptO1,ptO2,ptO3,r12,r22,r23_] deber\[IAcute]a devolver {0,0,0} True si las circunferencias (O1), (O2), (O3) son coaxiales.";


(* ::Input::Initialization:: *)
SonCoaxiales[ptO1_,ptO2_,ptO3_,r12_,r22_,r23_]:=Cross[Simplificar[EjeRadical[ptO1,ptO2,r12,r22]],Simplificar[EjeRadical[ptO1,ptO3,r12,r23]]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EcuacionReducidaConica::"usage"= "EcuacionReducidaConica[eqn] transforma eqn en una ecuaci\[OAcute]n de la forma
k circunconica+ x+y+z)(\!\(\*SuperscriptBox[\(p\), \(2\)]\)x+\!\(\*SuperscriptBox[\(q\), \(2\)]\)y+\!\(\*SuperscriptBox[\(r\), \(2\)]\)z).";


(* ::Input::Initialization:: *)
EcuacionReducidaConica[conic_]:=Module[{circun,resto},
circun=CircunconicaHomotetica[conic];
resto=Collect[Factor[(conic-circun)/(x+y+z)],{x,y,z},AgruparFactores[Factor[#]]&];
circun+(x+y+z) resto
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EcuacionReducidaCircunferencia::"usage"= "EcuacionReducidaCircunferencia[eqn] transforma eqn en una ecuaci\[OAcute]n de la forma \!\(\*SuperscriptBox[\(c\), \(2\)]\) x y+\!\(\*SuperscriptBox[\(b\), \(2\)]\) x z+\!\(\*SuperscriptBox[\(a\), \(2\)]\) y z+(x+y+z)(\!\(\*SuperscriptBox[\(p\), \(2\)]\)x+\!\(\*SuperscriptBox[\(q\), \(2\)]\)y+\!\(\*SuperscriptBox[\(r\), \(2\)]\)z).";


(* ::Input::Initialization:: *)
EcuacionReducidaCircunferencia[eqn_]:=Module[{coef,tt,pp,qq,rr,solpqr},
coef=Coefficient[eqn,{x^2,y^2,z^2,y z,z x,x y}];
solpqr=Solve[Map[Evaluar[#]&,tt coef]=={pp,qq,rr,a^2+qq+rr,b^2+pp+rr,c^2+pp+qq},{tt,pp,qq,rr}][[1]];
c^2 x y+b^2 x z+a^2 y z+(x+y+z)(pp x+qq y+rr z)/.solpqr
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SonTangentes::"usage"= "SonTangentes[ptOa,ptb,ra2,rb2] , devuelve True si la circunferencias (ptOa,ra) y (ptOb,rb) son tangentes.";


(* ::Input::Initialization:: *)
SonTangentes[ptOa_,ptOb_,ra2_,rb2_]:=Numerator[Factor[CuadradoDistanciaPuntoRecta[ptOa,EjeRadical[ptOa,ptOb,ra2,rb2]]-ra2]]==0;


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PuntoTangenciaCircunferencias::"usage"= "PuntoTangenciaCircunferencias[ptOa,ptOb,ra2,rb2]\!\(\*
StyleBox[\",\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"devuelve\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"el\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"punto\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"de\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"tangencia\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"de\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"dos\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"circunferencias\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"que\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"lo\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"son\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\".\",\nFontColor->GrayLevel[0.5]]\)";


(* ::Input::Initialization:: *)
PuntoTangenciaCircunferencias[ptOa_,ptOb_,ra2_,rb2_]:=Punto[EjeRadical[ptOa,ptOb,ra2,rb2],Recta[ptOa,ptOb]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CentroHagge::"usage" = "CentroHagge[ptP,{ptU,ptV,ptW}] devuelve el centro de la circunferencia de Hagge de P respecto del tri\[AAcute]ngulo UVW.";


(* ::Input::Initialization:: *)
CentroHagge[ptP_,{ptU_,ptV_,ptW_}]:=Module[{ptA1,ptB1,ptC1,ptA2,ptB2,ptC2},
{ptA1,ptB1,ptC1}=TrianguloCircunceviano[ptP,{ptU,ptV,ptW}];
{ptA2,ptB2,ptC2}=TernaCiclicaPuntos[SimetriaAxial[ptA1,Recta[ptV,ptW]]];
Circuncentro[{ptA2,ptB2,ptC2}]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CentroHagge[ptP_]:=CentroHagge[ptP,{ptA,ptB,ptC}]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PuntosLimiteCircunferencias::"usage" = "PuntosLimiteCircunferencias[ptO1,ptO2,r12,r22] devuelve los puntos l\[IAcute]mite de dos circunferencias.";


(* ::Input::Initialization:: *)
PuntosLimiteCircunferencias[ptO1_,ptO2_,r12_,r22_]:=Module[{ptM},
ptM=Punto[Recta[ptO1,ptO2],EjeRadical[ptO1,ptO2,r12,r22]];
InterseccionConicaRecta[
Circunferencia[ptM,CuadradoDistancia[ptM,ptO1]-r12],
Recta[ptO1,ptO2] . {x,y,z}
]
]


(* ::Input::Initialization:: *)
Inversion::"usage" = "Inversion[ptP,ptO,r2] devuelve el punto inverso del punto ptP mediante una inversi\[OAcute]n con centro ptO y radio de inversi\[OAcute]n al cuadrado r2.";


(* ::Input::Initialization:: *)
Inversion[ptP_, ptO_, r2_] := Punto[  Recta[ptP, ptO], Simplificar[Potencias[ptO, r2] - Potencias[Medio[ptP, ptO], CuadradoDistancia[ptP, ptO]/4]]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Polo::"usage" = "Polo[ptP,ptO,r2] devuelve la polar de un punto respecto de una circunferencia con centro ptO y radio al cuadrado r2.";


(* ::Input::Initialization:: *)
Polo[r_,ptO_,r2_]:=Inversion[Pie[ptO,r],ptO,r2]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Potencias::"usage" = "Polo[ptP,r2] devuelve las potencias de los v\[EAcute]rtices A, B, C respecto de la circunferencia con centro ptP y radio al cuadrado r2.";


(* ::Input::Initialization:: *)
Potencias[{u_,v_,w_},r2_]:=
{(c^2 v^2+2 fSA v w +b^2 w^2)/(u+v+w)^2-r2,(a^2 w^2+2 fSB w u +c^2 u^2)/(u+v+w)^2-r2,(b^2 u^2+2 fSC u v +a^2 v^2)/(u+v+w)^2-r2};


(* ::Input::Initialization:: *)
steiner= y z + z x + x y;


(* ::Input::Initialization:: *)
circunscrita=a^2 y z + b^2  z x + c^2 x y;


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Circunferencia::"usage" = "Circunferencia[ptP,r2] devuelve la ecuaci\[OAcute]n de la circunferencia con centro ptP y radio al cuadrado r2.";


(* ::Input::Initialization:: *)
Circunferencia[ptP_,r2_]:=circunscrita-(x+y+z)Potencias[ptP,r2] . {x,y,z}


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CoeficientesCircunferencia::"usage"= "Devuelve los valores de p, q, r al poner la circunferencia en la forma  a^2yz+b^2zx+c^2xy-(x+y+z)(px+qy+rz)=0";


(* ::Input::Initialization:: *)
CoeficientesCircunferencia[circun_]:=Module[{cconic,coefyz},
cconic=CircunconicaHomotetica[circun];
coefyz=Coefficient[cconic,y z]/a^2;
-Coefficient[Factor[(circun-cconic)/(x+y+z)/coefyz],{x,y,z}]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CuadradoRadioCircunferencia::"usage"= "Devuelve el cuadrado del radio de una circunferencia dada por su ecuaci\[OAcute]n";


(* ::Input::Initialization:: *)
CuadradoRadioCircunferencia[eqn_]:=Module[{f,g,h, p, q, r,e,\[EmptyDownTriangle],\[CapitalDelta]},
{f,g,h}=Map[Coefficient[eqn,#] &, {x^2,y^2,z^2}];
{p,q,r}=Map[Coefficient[eqn,#] &, {y z,z x,x y}]/2;
\[EmptyDownTriangle]=Det[{{a,a^2 f,a b r,a c q},{b,a b r,b^2 g,b c p},{c,a c q,b c p,c^2 h},{0,a,b,c}}];
e=a^2 f+b^2 g+c^2 h-p(b^2+c^2-a^2)-q(a^2-b^2+c^2)-r(a^2+b^2-c^2);
\[CapitalDelta]=Det[{{a^2 f,a b r,a c q},{a b r,b^2 g,b c p},{a c q,b c p,c^2 h}}];
Factor[Divide[(a-b-c) (a+b-c) (a-b+c) (a+b+c) \[CapitalDelta],2e \[EmptyDownTriangle]]/.sustS]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Potencia::"usage"="Potencia[ptP,eqn] devuelve la potencia del punto P respecto a la circunferencia de ecuaci\[OAcute]n <eqn>.";


(* ::Input::Initialization:: *)
Potencia[ptP_,eqn_]:=Factor[CuadradoDistancia[ptP,CentroConica[eqn]]-CuadradoRadioCircunferencia[eqn]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EjeRadical::"usage"= "EjeRadical[O1,O2,r12,r22] devuelve el eje radical de las circunferencias con centros O1, O2 y radios al cuadrado r12, r22.\n
EjeRadical[circ1, circ2] devuelve el eje radical de las circunferencias con ecuaciones.";


(* ::Input::Initialization:: *)
EjeRadical[ptOa_,ptOb_,ra2_,rb2_]:=Potencias[ptOa,ra2]-Potencias[ptOb,rb2];
EjeRadical[circ1_,circ2_]:=Simplificar[CoeficientesCircunferencia[circ1]-CoeficientesCircunferencia[circ2]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EjeRadicalDosTriangulos::"usage"= "EjeRadicalDosTriangulos devuelve el eje radical de las circunferencias circunscritas a dos tri\[AAcute]ngulos.";


(* ::Input::Initialization:: *)
EjeRadicalDosTriangulos[{ptA1_,ptB1_,ptC1_},{ptA2_,ptB2_,ptC2_}]:=Module[{ptO1,pO2,r12,r22,ptO2,ra12,ra22},
ptO1=Circuncentro[{ptA1,ptB1,ptC1}];
ptO2=Circuncentro[{ptA2,ptB2,ptC2}];
ra12=CuadradoDistancia[ptO1,ptA1];
ra22=CuadradoDistancia[ptO2,ptA2];
Factor[Simplificar[EjeRadical[ptO1,ptO2,ra12,ra22]]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CentroRadical::"usage"= "CentroRadical[O1,O2,O3,r12,r22,r32] devuelve el centro radical de las circunferencias con centros O1, O2, O3 y radios al cuadrado r12, r22, r32./n
CentroRadical[circ1,circ2,circ3] devuelve el centro radical de las circunferencias con ecuaciones circ1, circ2, circ3.";


(* ::Input::Initialization:: *)
CentroRadical[O1_,O2_,O3_,r12_,r22_,r32_]:=Module[{p1,q1,r1,p2,q2,r2,p3,q3,r3},
{p1,q1,r1}=Potencias[O1,r12];
{p2,q2,r2}=Potencias[O2,r22];
{p3,q3,r3}=Potencias[O3,r32];
Simplificar[Factor[{Det[({
 {1, q1, r1},
 {1, q2, r2},
 {1, q3, r3}
})],Det[({
 {p1, 1, r1},
 {p2, 1, r2},
 {p3, 1, r3}
})],Det[({
 {p1, q1, 1},
 {p2, q2, 1},
 {p3, q3, 1}
})]}]]
];

CentroRadical[circ1_,circ2_,circ3_]:=Punto[EjeRadical[circ1,circ2],EjeRadical[circ1,circ3]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EcuacionReducidaCircunferencia::"usage"= "EcuacionReducidaCircunferencia[eqn] transforma eqn en una ecuaci\[OAcute]n de la forma \!\(\*SuperscriptBox[\(c\), \(2\)]\) x y+\!\(\*SuperscriptBox[\(b\), \(2\)]\) x z+\!\(\*SuperscriptBox[\(a\), \(2\)]\) y z+(x+y+z)(\!\(\*SuperscriptBox[\(p\), \(2\)]\)x+\!\(\*SuperscriptBox[\(q\), \(2\)]\)y+\!\(\*SuperscriptBox[\(r\), \(2\)]\)z).";


(* ::Input::Initialization:: *)
EcuacionReducidaCircunferencia[eqn_]:=Module[{coef},
coef=Coefficient[eqn,{x^2,y^2,z^2,y z,z x,x y}];
solpqr=Solve[Map[Evaluar[#]&,tt coef]=={pp,qq,rr,a^2+qq+rr,b^2+pp+rr,c^2+pp+qq},{tt,pp,qq,rr}][[1]];
c^2 x y+b^2 x z+a^2 y z+(x+y+z)(pp x+qq y+rr z)/.solpqr
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SonTangentes::"usage"= "SonTangentes[ptOa,ptb,ra2,rb2] , devuelve True si la circunferencias (ptOa,ra) y (ptOb,rb) son tangentes.";


(* ::Input::Initialization:: *)
SonTangentes[ptOa_,ptOb_,ra2_,rb2_]:=Numerator[Factor[CuadradoDistanciaPuntoRecta[ptOa,EjeRadical[ptOa,ptOb,ra2,rb2]]-ra2]]==0;


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PuntoTangenciaCircunferencias::"usage"= "PuntoTangenciaCircunferencias[ptOa,ptOb,ra2,rb2]\!\(\*
StyleBox[\",\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"devuelve\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"el\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"punto\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"de\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"tangencia\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"de\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"dos\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"circunferencias\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"que\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"lo\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\" \",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\"son\",\nFontColor->GrayLevel[0.5]]\)\!\(\*
StyleBox[\".\",\nFontColor->GrayLevel[0.5]]\)";


(* ::Input::Initialization:: *)
PuntoTangenciaCircunferencias[ptOa_,ptOb_,ra2_,rb2_]:=Punto[EjeRadical[ptOa,ptOb,ra2,rb2],Recta[ptOa,ptOb]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CentroHagge::"usage" = "CentroHagge[ptP,{ptU,ptV,ptW}] devuelve el centro de la circunferencia de Hagge de P respecto del tri\[AAcute]ngulo UVW.";


(* ::Input::Initialization:: *)
CentroHagge[ptP_,{ptU_,ptV_,ptW_}]:=Module[{ptA1,ptB1,ptC1,ptA2,ptB2,ptC2},
{ptA1,ptB1,ptC1}=TrianguloCircunceviano[ptP,{ptU,ptV,ptW}];
{ptA2,ptB2,ptC2}=TernaCiclicaPuntos[SimetriaAxial[ptA1,Recta[ptV,ptW]]];
Circuncentro[{ptA2,ptB2,ptC2}]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CentroHagge[ptP_]:=CentroHagge[ptP,{ptA,ptB,ptC}]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PuntosLimiteCircunferencias::"usage" = "PuntosLimiteCircunferencias[ptO1,ptO2,r12,r22] devuelve los puntos l\[IAcute]mite de dos circunferencias.";


(* ::Input::Initialization:: *)
PuntosLimiteCircunferencias[ptO1_,ptO2_,r12_,r22_]:=Module[{ptM},
ptM=Punto[Recta[ptO1,ptO2],EjeRadical[ptO1,ptO2,r12,r22]];
InterseccionConicaRecta[
Circunferencia[ptM,CuadradoDistancia[ptM,ptO1]-r12],
Recta[ptO1,ptO2] . {x,y,z}
]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ConicaEsCircunferencia::"usage"="Dada una conica cuyos coeficientes son funciones de u,v,w ConicaEsCircunferencia[conica] devuelve tres curvas en x,y,z cuya interseccion ser\[AAcute]n los puntos u:v:w para los que dicha c\[OAcute]nica es una circunferencia.";


(* ::Input::Initialization:: *)
ConicaEsCircunferencia[conica_]:=
Sustituiruvw[Cross[PerspectorConica[CircunconicaHomotetica[conica]],ptK],{x,y,z}]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SustituirPuntosCiclicos::"usage"="Sustituye una ecuaci\[OAcute]n por los puntos c\[IAcute]clicos, comunes a todas las circunferencias.";


(* ::Input::Initialization:: *)
SustituirPuntosCiclicos[locus_]:=Factor[Map[Sustituirxyz[locus,#]&,
{{-a^2,fSC - S I, fSB + S I},{-a^2,fSC + S I, fSB - S I}}]/.sustS]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ContienePuntosCiclicos::"usage"="ContienePuntosCiclicos[locus] devuelve True si locus contiene los puntos c\[IAcute]clicos.";


(* ::Input::Initialization:: *)
ContienePuntosCiclicos[locus_]:=SustituirPuntosCiclicos[locus]==={0,0}


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CentroRadicalTresTriangulos::"usage"= "CentroRadicalTresTriangulos el centro radical de las circunferencias circunscritas a tres tri\[AAcute]ngulos.";


(* ::Input::Initialization:: *)
CentroRadicalTresTriangulos[trT1_,trT2_,trT3_]:=Module[{ptO1,ptO2,ptO3,r12,r22,r32},
{ptO1,ptO2,ptO3}=Map[Circuncentro,{trT1,trT2,trT3}];
r12=CuadradoDistancia[ptO1,trT1[[1]]];
r22=CuadradoDistancia[ptO2,trT2[[1]]];
r32=CuadradoDistancia[ptO3,trT3[[1]]];
CentroRadical[ptO1,ptO2,ptO3,r12,r22,r32]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CircunferenciaTresPuntos::"usage"="CircunferenciaTresPuntos devuelve la ecuaci\[OAcute]n de la circunferencia que pasa por tres puntos.";


(* ::Input::Initialization:: *)
CircunferenciaTresPuntos[{{x1_,y1_,z1_},{x2_,y2_,z2_},{x3_,y3_,z3_}}]:=EliminarFactoresConstantes[Factor[Det[{{a^2 y z+b^2 x z+c^2 x y,x(x+y+z),y(x+y+z),z(x+y+z)},{a^2 y1 z1+b^2 x1 z1+c^2 x1 y1,x1(x1+y1+z1),y1(x1+y1+z1),z1(x1+y1+z1)},{a^2 y2 z2+b^2 x2 z2+c^2 x2 y2,x2(x2+y2+z2),y2(x2+y2+z2),z2(x2+y2+z2)},{a^2 y3 z3+b^2 x3 z3+c^2 x3 y3,x3(x3+y3+z3),y3(x3+y3+z3),z3(x3+y3+z3)}}]]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CircunferenciaTresPuntos2::"usage"="CircunferenciaTresPuntos2 (una versi\[OAcute]n antigua) devuelve la ecuaci\[OAcute]n de la circunferencia que pasa por tres puntos.";


(* ::Input::Initialization:: *)
CircunferenciaTresPuntos2[{ptA_,ptB_,ptC_}]:=Module[{eqn,eqns,solpqr},
eqn=circunscrita-(x+y+z)(p x + q y + r z);
eqns=Map[Sustituirxyz[eqn,#]==0&,{ptA,ptB,ptC}];
solpqr=Solve[eqns,{p,q,r}][[1]];
Numerator[Factor[eqn/.solpqr]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
MixtilinearIncircles::"usage"="MixtilinearIncircles devuelve las ecuaciones de las tres circunferencias mixtil\[IAcute]neas interiores (las que son tangentes interiormente a la circunferencia circunscrita).";


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
MixtilinearIncenters::"usage"="MixtilinearIncenters devuelve los centros de las tres circunferencias mixtil\[IAcute]neas interiores (las que son tangentes interiormente a la circunferencia circunscrita).";


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
MixtilinearInternalContacts::"usage"="MixtilinearInternalContacts devuelve los puntos de contacto de las tres circunferencias mixtil\[IAcute]neas interiores con la circunferencia circunscrita).";


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
MixtilinearExcenters::"usage"= "MixtilinearExcenters devuelve los centros de las tres circunferencias mixtil\[IAcute]neas exteriores (las que son tangentes exteriormente a la circunferencia circunscrita).";


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
MixtilinearExternalContacts::"usage"="MixtilinearExternalContacts devuelve los puntos de contacto de las tres circunferencias mixtil\[IAcute]neas exteriores con la circunferencia circunscrita).";


(* ::Input::Initialization:: *)
MixtilinearExcircles={4 b^2 c^2 x^2+4 a b c^2 x y+4 b^2 c^2 x y-4 b c^3 x y+a^2 c^2 y^2+2 a b c^2 y^2+b^2 c^2 y^2-2 a c^3 y^2-2 b c^3 y^2+c^4 y^2+4 a b^2 c x z-4 b^3 c x z+4 b^2 c^2 x z-a^4 y z+2 a^3 b y z-2 a b^3 y z+b^4 y z+2 a^3 c y z-2 a^2 b c y z+2 a b^2 c y z-2 b^3 c y z+2 a b c^2 y z+2 b^2 c^2 y z-2 a c^3 y z-2 b c^3 y z+c^4 y z+a^2 b^2 z^2-2 a b^3 z^2+b^4 z^2+2 a b^2 c z^2-2 b^3 c z^2+b^2 c^2 z^2,a^2 c^2 x^2+2 a b c^2 x^2+b^2 c^2 x^2-2 a c^3 x^2-2 b c^3 x^2+c^4 x^2+4 a^2 c^2 x y+4 a b c^2 x y-4 a c^3 x y+4 a^2 c^2 y^2+a^4 x z-2 a^3 b x z+2 a b^3 x z-b^4 x z-2 a^3 c x z+2 a^2 b c x z-2 a b^2 c x z+2 b^3 c x z+2 a^2 c^2 x z+2 a b c^2 x z-2 a c^3 x z-2 b c^3 x z+c^4 x z-4 a^3 c y z+4 a^2 b c y z+4 a^2 c^2 y z+a^4 z^2-2 a^3 b z^2+a^2 b^2 z^2-2 a^3 c z^2+2 a^2 b c z^2+a^2 c^2 z^2,a^2 b^2 x^2-2 a b^3 x^2+b^4 x^2+2 a b^2 c x^2-2 b^3 c x^2+b^2 c^2 x^2+a^4 x y-2 a^3 b x y+2 a^2 b^2 x y-2 a b^3 x y+b^4 x y-2 a^3 c x y+2 a^2 b c x y+2 a b^2 c x y-2 b^3 c x y-2 a b c^2 x y+2 a c^3 x y+2 b c^3 x y-c^4 x y+a^4 y^2-2 a^3 b y^2+a^2 b^2 y^2-2 a^3 c y^2+2 a^2 b c y^2+a^2 c^2 y^2+4 a^2 b^2 x z-4 a b^3 x z+4 a b^2 c x z-4 a^3 b y z+4 a^2 b^2 y z+4 a^2 b c y z+4 a^2 b^2 z^2};


(* ::Input::Initialization:: *)
MixtilinearIncircles={4 b^2 c^2 x^2-4 a b c^2 x y+4 b^2 c^2 x y-4 b c^3 x y+a^2 c^2 y^2-2 a b c^2 y^2+b^2 c^2 y^2+2 a c^3 y^2-2 b c^3 y^2+c^4 y^2-4 a b^2 c x z-4 b^3 c x z+4 b^2 c^2 x z-a^4 y z-2 a^3 b y z+2 a b^3 y z+b^4 y z-2 a^3 c y z-2 a^2 b c y z-2 a b^2 c y z-2 b^3 c y z-2 a b c^2 y z+2 b^2 c^2 y z+2 a c^3 y z-2 b c^3 y z+c^4 y z+a^2 b^2 z^2+2 a b^3 z^2+b^4 z^2-2 a b^2 c z^2-2 b^3 c z^2+b^2 c^2 z^2,a^2 c^2 x^2-2 a b c^2 x^2+b^2 c^2 x^2-2 a c^3 x^2+2 b c^3 x^2+c^4 x^2+4 a^2 c^2 x y-4 a b c^2 x y-4 a c^3 x y+4 a^2 c^2 y^2+a^4 x z+2 a^3 b x z-2 a b^3 x z-b^4 x z-2 a^3 c x z-2 a^2 b c x z-2 a b^2 c x z-2 b^3 c x z+2 a^2 c^2 x z-2 a b c^2 x z-2 a c^3 x z+2 b c^3 x z+c^4 x z-4 a^3 c y z-4 a^2 b c y z+4 a^2 c^2 y z+a^4 z^2+2 a^3 b z^2+a^2 b^2 z^2-2 a^3 c z^2-2 a^2 b c z^2+a^2 c^2 z^2,a^2 b^2 x^2-2 a b^3 x^2+b^4 x^2-2 a b^2 c x^2+2 b^3 c x^2+b^2 c^2 x^2+a^4 x y-2 a^3 b x y+2 a^2 b^2 x y-2 a b^3 x y+b^4 x y+2 a^3 c x y-2 a^2 b c x y-2 a b^2 c x y+2 b^3 c x y-2 a b c^2 x y-2 a c^3 x y-2 b c^3 x y-c^4 x y+a^4 y^2-2 a^3 b y^2+a^2 b^2 y^2+2 a^3 c y^2-2 a^2 b c y^2+a^2 c^2 y^2+4 a^2 b^2 x z-4 a b^3 x z-4 a b^2 c x z-4 a^3 b y z+4 a^2 b^2 y z-4 a^2 b c y z+4 a^2 b^2 z^2};


(* ::Input::Initialization:: *)
MixtilinearIncenters={
{-a^3-a^2 b+a b^2+b^3-a^2 c+2 a b c-b^2 c+a c^2-b c^2+c^3,4 b^2 c,4 b c^2},{4 a^2 c,a^3+a^2 b-a b^2-b^3-a^2 c+2 a b c-b^2 c-a c^2+b c^2+c^3,4 a c^2},{4 a^2 b,4 a b^2,a^3-a^2 b-a b^2+b^3+a^2 c+2 a b c+b^2 c-a c^2-b c^2-c^3}};


(* ::Input::Initialization:: *)
MixtilinearInternalContacts={
{-a (a+b-c) (a-b+c),2 b^2 (a+b-c),2 c^2 (a-b+c)},
{2 a^2 (a+b-c),-b (a+b-c) (-a+b+c),2 c^2 (-a+b+c)},
{2 a^2 (a-b+c),2 b^2 (-a+b+c),-c (a-b+c) (-a+b+c)}};


(* ::Input::Initialization:: *)
MixtilinearExcenters={{a^3-a^2 b-a b^2+b^3-a^2 c-2 a b c-b^2 c-a c^2-b c^2+c^3,4 b^2 c,4 b c^2},{4 a^2 c,a^3-a^2 b-a b^2+b^3-a^2 c-2 a b c-b^2 c-a c^2-b c^2+c^3,4 a c^2},{4 a^2 b,4 a b^2,a^3-a^2 b-a b^2+b^3-a^2 c-2 a b c-b^2 c-a c^2-b c^2+c^3}};


(* ::Input::Initialization:: *)
MixtilinearExternalContacts={
{-a (a+b-c) (a-b+c),-2 b^2 (-a+b-c),2 (a+b-c) c^2},
{-2 a^2 (a-b-c),-b (a+b-c) (-a+b+c),-2 c^2 (-a-b+c)},{-2 a^2 (a-b-c),-2 b^2 (-a+b-c),-c (a-b+c) (-a+b+c)}};


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SonCircunferenciasOrtogonales::"usage"="SonCircunferenciasOrtogonales[eqn1,eqn2] devuelve 0 si las circunferencias eqn1 y eqn2 son ortogonales.
SonCircunferenciasOrtogonales[ptO1,ptO2,r12,r22] devuelve 0 si las circunferencias (O1,r12) y (O2,r22) son ortogonales.";


(* ::Input::Initialization:: *)
SonCircunferenciasOrtogonales[eqn1_,eqn2_]:=Module[{ptO1,ptO2,r12,r22},
{ptO1,ptO2}=Map[CentroConica,{eqn1,eqn2}];
{r12,r22}=Map[CuadradoRadioCircunferencia,{eqn1,eqn2}];
Factor[CuadradoDistancia[ptO1,ptO2]-r12-r22]]


(* ::Input::Initialization:: *)
SonCircunferenciasOrtogonales[ptO1_,ptO2_,r12_,r22_]:=Factor[CuadradoDistancia[ptO1,ptO2]-r12-r22]


(* ::Input::Initialization:: *)
ReducirConica::"usage"="ReducirConica[conic] devuelve la ecuaci\[OAcute]n de la c\[OAcute]nica en la forma circunconic-(x+y+z)(p x+ q y + r z).";


(* ::Input::Initialization:: *)
ReducirConica[conic_]:=Module[{circun,resto},circun=CircunconicaHomotetica[conic];
resto=Factor[conic-circun];
circun+resto]


(* ::Input::Initialization:: *)
ParametrosCircunconicaHomotetica::"usage"="ParametrosHomoteciaCircunconica[conic] devuelve los centros de homotecia y razones de homotecia de una conica respecto de su circunc\[OAcute]nica circunscrita";


(* ::Input::Initialization:: *)
ParametrosCircunconicaHomotetica[conic_]:=Module[{k,circun,ptS1,ptS2},
k=PowerExpand[Sqrt[CuadradoRazonCircunconicaHomotetica[conic]]];
circun=CircunconicaHomotetica[conic];
ptS1=DividirRazon[CentroConica[conic],CentroConica[circun],-k,1];
ptS2=DividirRazon[CentroConica[conic],CentroConica[circun],k,1];
{{ptS1,k},{ptS2,-k}}
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ConicaCincoPuntos::"usage"= "ConicaCincoPuntos devuelve la ecuaci\[OAcute]n de la c\[OAcute]nica que pasa por cinco puntos.";


(* ::Input::Initialization:: *)
ConicaCincoPuntos[{
{x1_,y1_,z1_},{x2_,y2_,z2_},{x3_,y3_,z3_},{x4_,y4_,z4_},{x5_,y5_,z5_}}] :=
Factor[Det[({
 {x^2, y^2, z^2, y z, z x, x y},
 {x1^2, y1^2, z1^2, y1 z1, z1 x1, x1 y1},
 {x2^2, y2^2, z2^2, y2 z2, z2 x2, x2 y2},
 {x3^2, y3^2, z3^2, y3 z3, z3 x3, x3 y3},
 {x4^2, y4^2, z4^2, y4 z4, z4 x4, x4 y4},
 {x5^2, y5^2, z5^2, y5 z5, z5 x5, x5 y5}
})]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
MatrizConica::"usage"= "MatrizConica halla la matriz asociada a una c\[OAcute]nica.";


(* ::Input::Initialization:: *)
MatrizConica[conica_] := Module[{f,g,h, p, q, r},
{f,g,h}=Map[Coefficient[conica,#] &, {x^2,y^2,z^2}];
{p,q,r}=Map[Coefficient[conica,#] &, {y z,z x,x y}]/2;
({
 {f, r, q},
 {r, g, p},
 {q, p, h}
})
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
MatrizAdjunta::"usage"= "MatrizAdjunta devuelve la matriz adjunta de una matriz.";


(* ::Input::Initialization:: *)
MatrizAdjunta[{{a_,b_,c_},{d_,e_,f_},{g_,h_,i_}}]:=
{{-f h+e i,c h-b i,-c e+b f},{f g-d i,-c g+a i,c d-a f},{-e g+d h,b g-a h,-b d+a e}}


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CentroConica::"usage"= "CentroConica halla el centro de una c\[OAcute]nica hallando el polo de la recta del infinito.";


(* ::Input::Initialization:: *)
CentroConica[conica_] := Simplificar[Simplify[{1, 1, 1} . MatrizAdjunta[MatrizConica[conica]]]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
DiscriminanteConica::"usage"= "DiscriminanteConica devuelve un n\[UAcute]mero que es positivo, nulo o negativo seg\[UAcute]n la c\[OAcute]nica sea una hip\[EAcute]rbola, una par\[AAcute]bola o una elipse, es decir, seg\[UAcute]n sean dos, uno o cero los puntos de corte con la recta del infinito.";


(* ::Input::Initialization:: *)
DiscriminanteConica[conica_] := 
Factor[-{1,1,1} . MatrizAdjunta[MatrizConica[conica]] . {1,1,1}]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SegundaInterseccion::"usage"= "SegundaInterseccion[ptP,{ptA,ptB,ptC,ptD,ptE}] halla la segunda intersecci\[OAcute]n de la c\[OAcute]nica que pasa por A, B, C, D, E con una recta r que pasa por el punto A. Usando el teorema de Pascal podemos conseguir esto usando s\[OAcute]lo intersecciones de rectas.  
SegundaInterseccion[ptP,ptQ,eqn] halla el segundo punto de intersecci\[OAcute]n con la c\[OAcute]nica eqn de la recta que pasa por el punto exterior P y el punto Q de la c\[OAcute]nica";


(* ::Input::Initialization:: *)
SegundaInterseccion[ptP_,ptQ_,eqn_]:=Module[{\[Lambda]},
\[Lambda]=-Divide[ptQ . {Sustituirxyz[D[eqn,x],ptP],Sustituirxyz[D[eqn,y],ptP], Sustituirxyz[D[eqn,z],ptP]},Sustituirxyz[eqn,ptP]];
Simplificar[ptQ+\[Lambda] ptP]
]


(* ::Input::Initialization:: *)
SegundaInterseccion[ptP_,{ptA_,ptB_,ptC_,ptD_,ptE_}]:= Module[{r,ptU,ptV,ptW},
r=Recta[ptP,ptA];
ptU=Punto[Recta[ptA,ptB],Recta[ptD,ptE]];
ptW=Punto[r,Recta[ptC,ptD]];
ptV=Punto[Recta[ptU,ptW],Recta[ptB,ptC]];
Punto[r,Recta[ptV,ptE]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SegundaInterseccionCircunferencia::"usage"="SegundaInterseccionCircunferencia[ptP_,{ptA_,ptB_,ptC_}] usa SegundaInterseccion para obtener el segundo punto de intersecci\[OAcute]n de la recta PA y la circunferencia ABC";


(* ::Input::Initialization:: *)
SegundaInterseccionCircunferencia[ptP_,trT_]:=SimetriaCentral[First[trT],Pie[Circuncentro[trT],Recta[ptP,First[trT]]]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
InterseccionConicaRecta::"usage"="InterseccionConicaRecta devuelve los puntos de interseccion de una conica y una recta";


(* ::Input::Initialization:: *)
InterseccionConicaRecta[conica_,recta_]:=Map[Simplificar,{x,y,z}/.Solve[{conica==0,recta==0,x+y+z==1},{x,y,z}]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
TangenteConicaCincoPuntos::"usage"="Si de una c\[OAcute]nica conocemos los puntos A, B, C, D, E, hallamos la recta tangente por A a la c\[OAcute]nica.";


(* ::Input::Initialization:: *)
TangenteConicaCincoPuntos[{ptA_,ptB_,ptC_,ptD_,ptE_}]:= Module[{ptP,ptQ,ptR},
ptP=Punto[Recta[ptA,ptC],Recta[ptB,ptD]];
ptQ=Punto[Recta[ptA,ptD],Recta[ptC,ptE]];
ptR=Punto[Recta[ptP,ptQ],Recta[ptB,ptE]];
Recta[ptA,ptR]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PuntoTangenciaConicaCincoTangentes::"usage"="PuntoTangenciaConicaCincoTangentes gives the contact point of a conic with the first of five tangents.";


(* ::Input::Initialization:: *)
PuntoTangenciaConicaCincoTangentes[{t1_,t2_,t3_,t4_,t5_}] := 
Module[{ptP,ptV1,ptV2,ptV3,ptV4,ptV5},
ptV1=Punto[t1,t2];
ptV2=Punto[t2,t3];
ptV3=Punto[t3,t4];
ptV4=Punto[t4,t5];
ptV5=Punto[t5,t1];
ptP=Punto[Recta[ptV1,ptV4],Recta[ptV2,ptV5]];
Punto[Recta[ptV3,ptP],t1]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ConicaCincoTangentes::"usage"="ConicaCincoTangentes returns the conic tangent to five given lines.";


(* ::Input::Initialization:: *)
ConicaCincoTangentes[{rt1_,rt2_,rt3_,rt4_,rt5_}]:=ConicaDual[ConicaCincoPuntos[{rt1,rt2,rt3,rt4,rt5}]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ConicaBiceviana::"usage"="ConicaBiceviana devuelve la ecuaci\[OAcute]n de la c\[OAcute]nica biceviana que pasa por las trazas de \!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\) y \!\(\*
StyleBox[\"Q\",\nFontSlant->\"Italic\"]\).";


(* ::Input::Initialization:: *)
ConicaBiceviana[ptP_,ptQ_]:=
ConicaCincoPuntos[Drop[Join[TrianguloCeviano[ptP],TrianguloCeviano[ptQ]],1]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PolarConica::"usage"="PolarConica devuelve la polar del punto P respecto de una c\[OAcute]nica.";


(* ::Input::Initialization::GrayLevel[0]:: *)
PolarConica[ptP_,conica_]:= Simplificar[Factor[ptP . MatrizConica[conica]]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PoloConica::"usage"="PoloConica devuelve el polo de una recta r respecto de una c\[OAcute]nica dada.";


(* ::Input::Initialization::GrayLevel[0]:: *)
PoloConica[r_,conica_]:=  Simplificar[Factor[r . MatrizAdjunta[MatrizConica[conica]]]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PuntosInfinito::"usage"="PuntosInfinito devuelve los puntos del infinito de una curva.";


(* ::Input::Initialization:: *)
PuntosInfinito[conica_]:=Quiet[Map[Simplificar,
FullSimplify[{x,y,z}/. Solve[{conica==0,x+y+z==0},{x,y,z}],{x>0,y>0,z>0}]]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ConicaFocoDirectriz::"usage"="ConicaFocoDirectriz dada por un foco, directriz y excentricidad.";


(* ::Input::Initialization::GrayLevel[0]:: *)
ConicaFocoDirectriz[ptF_,r_,k_]:=Factor[
CuadradoDistancia[{x,y,z},ptF]-k^2*CuadradoDistancia[{x,y,z},Pie[{x,y,z},r]]
];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
FocosConica::"usage"="FocosConica devuelve los focos de una c\[OAcute]nica.";


(* ::Input::Initialization:: *)
FocosConica[conica_]:=Module[{uu, vv, ww, u,v,w,u1,v1,w1,k,focos,U1,V1,W1},
{u,v,w}=Map[Coefficient[conica,#] &, {x^2,y^2,z^2}];
{u1,v1,w1}=Map[Coefficient[conica,#] &, {y z,z x,x y}]/2; 
{{uu,W1,V1},{W1,vv,U1},{V1,U1,ww}}=MatrizAdjunta[({
 {u, w1, v1},
 {w1, v, u1},
 {v1, u1, w}
})];
{uu,vv,ww,U1,V1,W1}=Simplificar[{uu,vv,ww,U1,V1,W1}];
k=uu+vv+ww+2U1+2V1+2W1;
focos=Map[Simplificar, {x,y,1-x-y}/.Simplify[Solve[
{-a^2 k+c^2 uu+2 a^2 U1+2 a^2 V1+a^2 ww+2 a^2 k x-2 c^2 uu x-2 a^2 U1 x-2 a^2 V1 x-2 c^2 V1 x-2 a^2 ww x-2 c^2 W1 x-a^2 k x^2+c^2 k x^2+2 a^2 k y-2 a^2 U1 y-2 a^2 V1 y-2 a^2 ww y-2 a^2 k x y-a^2 k y^2,b^2 uu-a^2 vv-2 b^2 uu x-2 b^2 V1 x-2 b^2 W1 x+b^2 k x^2+2 a^2 U1 y+2 a^2 vv y+2 a^2 W1 y-a^2 k y^2}=={0,0},{x,y}]]];
Select[focos,(Im[PuntoBarCar[#,cA,cB,cC]]=={0,0})&]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
FocoParabola::"usage"="FocoParabola devuelve el foco de una par\[AAcute]bola.";


(* ::Input::Initialization:: *)
FocoParabola[conica_]:=Module[{u,v,w,u1,v1,w1},
{u,v,w}=Map[Coefficient[conica,#] &, {x^2,y^2,z^2}];
{u1,v1,w1}=Map[Coefficient[conica,#] &, {y z,z x,x y}]/2; 
{{u,w1,v1},{w1,v,u1},{v1,u1,w}}=MatrizAdjunta[({
 {u, w1, v1},
 {w1, v, u1},
 {v1, u1, w}
})];
Simplificar[Factor[{x,y,z}/.Solve[
{(2(v1+w1+u) x-u)/a^2 ==(2(w1+u1+v) y-v)/b^2,(2(v1+w1+u) x- u)/a^2 ==(2(u1+v1+w)z-w)/c^2,x+y+z==1},{x,y,z}]][[1]]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EjeParabola::"usage"="EjeParabola devuelve el eje de una par\[AAcute]bola.";


(* ::Input::Initialization:: *)
EjeParabola[eqn_]:=Recta[FocoParabola[eqn],First[PuntosInfinito[eqn]]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
DirectrizParabola::"usage"="DirectrizParabola devuelve la directriz de una par\[AAcute]bola.";


(* ::Input::Initialization:: *)
DirectrizParabola[eqn_]:=PolarConica[FocoParabola[eqn],eqn]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
VerticeParabola::"usage"="VerticeParabola devuelve el foco de una par\[AAcute]bola.";


(* ::Input::Initialization:: *)
VerticeParabola[eqn_]:=Medio[FocoParabola[eqn],Punto[DirectrizParabola[eqn],EjeParabola[eqn]]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ParabolaDosPuntosEje::"usage"="Obtiene la ecuaci\[OAcute]n de una par\[AAcute]bola a partir de dos puntos y el eje.";


(* ::Input::Initialization:: *)
ParabolaDosPuntosEje[ptA_,ptB_,eje_]:=ConicaCincoPuntos[{ptA,ptB,
PuntoInfinito[eje],SimetriaAxial[ptA,eje],SimetriaAxial[ptB,eje]}]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CuadradoParametroParabola::"usage"="Devuelve el cuadrado del par\[AAcute]metro de una par\[AAcute]bola.";


(* ::Input::Initialization::GrayLevel[0]:: *)
CuadradoParametroParabola[conica_]:=CuadradoDistanciaPuntoRecta[FocoParabola[conica],DirectrizParabola[conica]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
TangenteConica::"usage"="TangenteConica[ptP,conica] devuelve la recta tangente a una c\[OAcute]nica en un punto P de ella.";


(* ::Input::Initialization:: *)
TangenteConica[ptP_,conica_]:=PolarConica[ptP,conica];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
NormalConica::"usage"="Normal[ptP,conica] devuelve la recta normal a una c\[OAcute]nica en un punto P de ella.";


(* ::Input::Initialization:: *)
NormalConica[ptP_,conica_]:=Perpendicular[ptP,TangenteConica[ptP,conica]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
DiametroConjugado::"usage"="DiametroConjugado[r,conica] obtiene el di\[AAcute]metro conjugado de un di\[AAcute]metro dado de una c\[OAcute]nica.";


(* ::Input::Initialization:: *)
DiametroConjugado[r_,conica_]:= Paralela[CentroConica[conica],
PolarConica[Simplificar[{x,y,z}/.Solve[{conica==0,r . {x,y,z}==0},{y,z}][[1]]],conica]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SonDiametrosConjugados::"usage"="Devuelve True si rt1 y rt2 son di\[AAcute]metros conjugados de una c\[OAcute]nica .";


(* ::Input::Initialization:: *)
SonDiametrosConjugados[rt1_,rt2_,conica_]:=Module[{ptZ,p1,q1,r1,p2,q2,r2,u,v,w,e,u1,v1,w1},
{p1,q1,r1}=rt1;
{p2,q2,r2}=rt2;
ptZ=CentroConica[conica];
{{u,w1,v1},{w1,v,u1},{v1,u1,w}}=MatrizAdjunta[MatrizConica[conica]];
And[
SameQ[FullSimplify[ptZ . rt1],0],
SameQ[FullSimplify[ptZ . rt2],0],
SameQ[FullSimplify[u p1 p2+v q1 q2+w r1 r2+u1 (q2 r1+q1 r2)+v1 (p2 r1+p1 r2)+w1 (p2 q1+p1 q2)],0]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
AsintotasHiperbola::"usage"="AsintotasHiperbola[conica] devuelve (como rectas) las as\[IAcute]ntotas de una c\[OAcute]nica dada por su ecuaci\[OAcute]n.";


(* ::Input::Initialization:: *)
AsintotasHiperbola[conica_]:= Map[Recta[CentroConica[conica],#]&,PuntosInfinito[conica]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
RectasConicaDegenerada::"usage"="RectasConicaDegenerada[eqn] obtiene las rectas incluidas en una c\[OAcute]nica degenerada dada.";


(* ::Input::Initialization:: *)
RectasConicaDegenerada[eqn_]:=Module[{ptJ,pinf,ptW,ptP1,ptP2},
pinf=PuntosInfinito[eqn];
If[Length[pinf]==1,
ptJ=First[pinf];{ptP1,ptP2}=InterseccionConicaRectaDosPuntos[eqn,ptB,ptC],
ptJ=CentroConica[eqn];{ptP1,ptP2}=pinf
];
{Recta[ptJ,ptP1],Recta[ptJ,ptP2]}
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EcuacionEjesConica::"usage"="EcuacionEjesConica[conica] devuelve un polinomio de segundo grado conteniendo los ejes de una c\[OAcute]nica central.";


(* ::Input::Initialization:: *)
EcuacionEjesConica[conica_]:=Det[{{1,1,1},PolarConica[{x,y,z},conica],PolarConica[{x,y,z},CircunferenciaDeMonge[conica]]}]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EjesConica::"usage"= "EjesConica devuelve los ejes (como rectas) de una c\[OAcute]nica.";


(* ::Input::Initialization::GrayLevel[0]:: *)
EjesConica[conica_]:=AsintotasHiperbola[EcuacionEjesConica[conica]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ConicaInscritaFoco::"usage"= "ConicaInscritaFoco[ptF1] devuelve la c\[OAcute]nica inscrita con un foco dado.";


(* ::Input::Initialization:: *)
ConicaInscritaFoco[ptF1_]:=Module[{ptF2,ptX,ptY,ptD,ptE,p,q,r},
ptF2=ConjugadoIsogonal[ptF1];
{ptX,ptY}=Map[SimetriaAxial[ptF1,ptC,#]&,{ptB,ptA}];
ptD=Punto[Recta[ptB,ptC],Recta[ptF2,ptX]];
ptE=Punto[Recta[ptA,ptC],Recta[ptF2,ptY]];
{p,q,r}=Punto[Recta[ptA,ptD],Recta[ptB,ptE]];
q^2 r^2 x^2+p^2 r^2 y^2+p^2 q^2 z^2-2 p q^2 r x z-2 p^2 q r y z-2 p q r^2 x y
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
VerticesConica::"usage"= "Devuelve los v\[EAcute]rtices de una c\[OAcute]nica.";


(* ::Input::Initialization::RGBColor[1, 0, 0]:: *)
VerticesConica[conica_]:=Join[
InterseccionConicaRecta[conica,EjesConica[conica][[1]] . {x,y,z}],
InterseccionConicaRecta[conica,EjesConica[conica][[2]] . {x,y,z}]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CuadradoSemiejesElipse::"usage"="CuadradoSemiejesElipse devuelve los cuadrados de las longitudes de los semiejes de una elipse.";


(* ::Input::Initialization:: *)
CuadradoSemiejesElipse[eqn_]:=Module[{f,g,h, p, q, r,e,H,K,res},
{f,g,h}=Map[Coefficient[eqn,#] &, {x^2,y^2,z^2}];
{p,q,r}=Map[Coefficient[eqn,#] &, {y z,z x,x y}]/2;
e=Simplify[a^2 f+b^2 g+c^2 h-p(b^2+c^2-a^2)-q(a^2-b^2+c^2)-r(a^2+b^2-c^2)];
H=Simplify[Det[{{f,r,q},{r,g,p},{q,p,h}}]];
K=Simplify[Det[{{f, r, q,1},{ r,g, p,1},{ q, p,h,1},{1,1,1,0}}]];
res=Simplify[K^3 \[Lambda]^2+  e H K \[Lambda]-  fS2 H^2];
Map[Factor,\[Lambda]/.Solve[res==0,\[Lambda]]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CuadradoAreaElipse::"usage"="CuadradoAreaElipse[eqn] devuelve el cuadrado del \[AAcute]rea de una elipse.";


(* ::Input::Initialization:: *)
CuadradoAreaElipse[eqn_]:=Apply[Times,CuadradoSemiejesElipse[eqn]]\[Pi]^2


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PerspectorConica::"usage"= "PerspectorConica devuelve el perspector de una c\[OAcute]nica.";


(* ::Input::Initialization:: *)
PerspectorConica[conica_,{ptA_,ptB_,ptC_}]:=Module[{mt,poA,poB,poC,tr},mt=MatrizConica[conica];poA=ptA . mt;poB=ptB . mt;poC=ptC . mt;Perspector[{ptA,ptB,ptC},TrianguloRectas[{poA,poB,poC}]]]


(* ::Input::Initialization:: *)
PerspectorConica[conica_]:=PerspectorConica[conica,{ptA,ptB,ptC}]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PuntoSobreConica::"usage"= "PuntoSobreConica[ptA,ptB,ptC,ptD,ptE,{v,w}] obtiene un punto gen\[EAcute]rico en funci\[OAcute]n de los par\[AAcute]metros v,w de la c\[OAcute]nica que pasa por los puntos A, B, C, D, E";


(* ::Input::Initialization:: *)
PuntoSobreConica[{ptA_,ptB_,ptC_,ptD_,ptE_},{v_,w_}]:=
Module[{ptX,ptY,ptZ},
ptX=Punto[Recta[ptA,ptB],Recta[ptD,ptE]];
ptY=DividirRazon[ptB,ptC,v,w];
ptZ=Punto[Recta[ptX,ptY],Recta[ptC,ptD]];
Punto[Recta[ptA,ptZ],Recta[ptE,ptY]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PuntoSobreConicaBiceviana::"usage"= "PuntoSobreConicaBiceviana obtiene un punto gen\[EAcute]rico de una c\[OAcute]nica biceviana.";


(* ::Input::Initialization:: *)
PuntoSobreConicaBiceviana[ptP_,ptQ_]:=PuntoSobreConica[
Drop[Join[TrianguloCeviano[ptP],TrianguloCeviano[ptQ]],1],{{t,1}}]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ConicaEnvolventeRectas::"usage"="ConicaEnvolventeRectas[r,variable] devuelve la ecuaci\[OAcute]n de la c\[OAcute]nica que envuelve a las rectas r al variar la variable";


(* ::Input::Initialization:: *)
ConicaEnvolventeRectas[rectas_,variable_]:=Module[{a0,a1,a2,b0,b1,b2,c0,c1,c2},
{{a0,a1,a2},{b0,b1,b2},{c0,c1,c2}}=Map[PadRight[#,3]&,CoefficientList[rectas,variable]];
Factor[(a1 x+b1 y+c1 z)^2-4(a0 x+b0 y+c0 z)(a2 x+b2 y+c2 z)]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ConicaParametricas::"usage"="ConicaParametricas[ptP,variable] devuelve la ecuaci\[OAcute]n de la c\[OAcute]nica que contiene a todos los puntos de la forma ptP={\!\(\*SubscriptBox[\(a\), \(0\)]\)+\!\(\*SubscriptBox[\(a\), \(1\)]\)t+\!\(\*SubscriptBox[\(a\), \(2\)]\)\!\(\*SuperscriptBox[\(t\), \(2\)]\),\!\(\*SubscriptBox[\(b\), \(0\)]\)+\!\(\*SubscriptBox[\(b\), \(1\)]\)t+\!\(\*SubscriptBox[\(b\), \(2\)]\)\!\(\*SuperscriptBox[\(t\), \(2\)]\),\!\(\*SubscriptBox[\(c\), \(0\)]\)+\!\(\*SubscriptBox[\(c\), \(1\)]\)t+\!\(\*SubscriptBox[\(c\), \(2\)]\)\!\(\*SuperscriptBox[\(t\), \(2\)]\)}";


(* ::Input::Initialization:: *)
ConicaParametricas[ptP_,variable_]:=Module[{p0,q0,r0,p1,q1,r1,p2,q2,r2},{{p0,q0,r0},{p1,q1,r1},{p2,q2,r2}}=MatrizAdjunta[Map[PadRight[#,3]&,CoefficientList[ptP,variable]]];Factor[(p1 x+q1 y+r1 z)^2-(p0 x+q0 y+r0 z) (p2 x+q2 y+r2 z)]]


(* ::Input::Initialization:: *)
ParametrosHomoteciaCircunconica::"usage"= "ParametrosHomoteciaCircunconica[conic] devuelve los centros de homotecia y razones de homotecia de una conica respecto de su circunc\[OAcute]nica circunscrita";


(* ::Input::Initialization:: *)
ParametrosHomoteciaCircunconica[conic_]:=Module[{k,circun,ptS1,ptS2},
k=PowerExpand[Sqrt[CuadradoRazonCircunconicaHomotetica[conic]]];
circun=CircunconicaHomotetica[conic];
ptS1=DividirRazon[CentroConica[conic],CentroConica[circun],-k,1];
ptS2=DividirRazon[CentroConica[conic],CentroConica[circun],k,1];
{{ptS1,k},{ptS2,-k}}
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CircunconicaHomotetica::"usage"="Obtiene la circunc\[OAcute]nica con los mismos puntos del infinito que una c\[OAcute]nica dada. Si la c\[OAcute]nica es no degenerada, ambas ser\[AAcute]n homot\[EAcute]ticas.";


(* ::Input::Initialization:: *)
CircunconicaHomotetica[conica_]:=Module[{f,g,h,p,q,r},
{f,g,h,p,q,r}=Coefficient[conica,{x^2,y^2,z^2,y z, z x,x y}];
Factor[{-g-h+p,-f-h+q,-f-g+r} . { y z,z x, x y}]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CuadradoRazonCircunconicaHomotetica::"usage"="Razon de homotecia con la circunc\[OAcute]nica homot\[EAcute]tica a una c\[OAcute]nica.";


(* ::Input::Initialization:: *)
CuadradoRazonCircunconicaHomotetica[conica_]:=Module[{f,g,h,p,q,r},
{f,g,h,p,q,r}=Coefficient[conica,{x^2,y^2,z^2,y z,z x,x y}];
Factor[-((4 f g h-f p^2-g q^2+p q r-h r^2)/((g+h-p) (f+h-q) (f+g-r)))]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ConicaDual::"usage"="ConicaDual[eqn] devuelve c\[OAcute]nica dual de la c\[OAcute]nica puntual \!\(\*
StyleBox[\"eqn\",\nFontSlant->\"Italic\"]\).";


(* ::Input::Initialization:: *)
ConicaDual[eqn_]:= Factor[{x,y,z} . MatrizAdjunta[MatrizConica[eqn]] . {x,y,z}];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CircunferenciaDeMonge::"usage"="Circunferencia de Monge devuelve la circunferencia de Monge de una c\[OAcute]nica.";


(* ::Input::Initialization:: *)
CircunferenciaDeMonge[conic_]:=Module[{f,g,h,p,q,r},
{f,g,h}=(Coefficient[conic,#1]&)/@{x^2,y^2,z^2};
{p,q,r}=1/2 (Coefficient[conic,#1]&)/@{y z,z x,x y};
-b^2 f g x^2-c^2 f h x^2-a^2 f p x^2+b^2 f p x^2+c^2 f p x^2+c^2 q^2 x^2+a^2 q r x^2-b^2 q r x^2-c^2 q r x^2+b^2 r^2 x^2-a^2 f g x y-b^2 f g x y+c^2 f g x y-a^2 f p x y+b^2 f p x y-c^2 f p x y+a^2 g q x y-b^2 g q x y-c^2 g q x y+2 c^2 p q x y-2 c^2 h r x y-a^2 p r x y+b^2 p r x y+c^2 p r x y+a^2 q r x y-b^2 q r x y+c^2 q r x y+a^2 r^2 x y+b^2 r^2 x y-c^2 r^2 x y-a^2 f g y^2-c^2 g h y^2+c^2 p^2 y^2+a^2 g q y^2-b^2 g q y^2+c^2 g q y^2-a^2 p r y^2+b^2 p r y^2-c^2 p r y^2+a^2 r^2 y^2-a^2 f h x z+b^2 f h x z-c^2 f h x z-a^2 f p x z-b^2 f p x z+c^2 f p x z-2 b^2 g q x z-a^2 p q x z+b^2 p q x z+c^2 p q x z+a^2 q^2 x z-b^2 q^2 x z+c^2 q^2 x z+a^2 h r x z-b^2 h r x z-c^2 h r x z+2 b^2 p r x z+a^2 q r x z+b^2 q r x z-c^2 q r x z+a^2 g h y z-b^2 g h y z-c^2 g h y z-2 a^2 f p y z-a^2 p^2 y z+b^2 p^2 y z+c^2 p^2 y z-a^2 g q y z-b^2 g q y z+c^2 g q y z+a^2 p q y z-b^2 p q y z+c^2 p q y z-a^2 h r y z+b^2 h r y z-c^2 h r y z+a^2 p r y z+b^2 p r y z-c^2 p r y z+2 a^2 q r y z-a^2 f h z^2-b^2 g h z^2+b^2 p^2 z^2-a^2 p q z^2-b^2 p q z^2+c^2 p q z^2+a^2 q^2 z^2+a^2 h r z^2+b^2 h r z^2-c^2 h r z^2
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CuadradoCosenoEcuacionRectas::"usage"="CuadradoCosenoEcuacionRectas[eqn] devuelve el cuadrado del coseno del \[AAcute]ngulo formado por las rectas contenidas en un polinomio de segundo grado.";


(* ::Input::Initialization:: *)
CuadradoCosenoEcuacionRectas[eqn_]:=Module[{f,g,h, p, q, r,e,K},
{f,g,h}=Map[Coefficient[eqn,#] &, {x^2,y^2,z^2}];
{p,q,r}=Map[Coefficient[eqn,#] &, {y z,z x,x y}]/2;
e=Factor[a^2 f+b^2 g+c^2 h-p(b^2+c^2-a^2)-q(a^2-b^2+c^2)-r(a^2+b^2-c^2)];
K=Factor[Det[{{f, r, q,1},{ r,g, p,1},{ q, p,h,1},{1,1,1,0}}]];
Factor[Divide[e^2,e^2+4S^2 K]/.sustS]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
InterseccionesPolarConica::"usage"="InterseccionesPolarConica[ptP,eqn] halla los puntos de intersecci\[OAcute]n de una c\[OAcute]nica con la polar desde un punto.";


(* ::Input::Initialization:: *)
 InterseccionesPolarConica[ptP_,eqn_]:=Module[{polar,ptP1,ptP2},
polar=PolarConica[ptP,eqn];
InterseccionConicaRecta[eqn,polar . {x,y,z}]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
InterseccionConicaRectaDosPuntos::"usage"="InterseccionConicaRectaDosPuntos devuelve los puntes de intersecci\[OAcute]n y la recta que pasa por dos puntos dados.";


(* ::Input::Initialization:: *)
InterseccionConicaRectaDosPuntos[eqn_,ptP_,ptQ_]:=InterseccionConicaRecta[eqn,Recta[ptP,ptQ] . {x,y,z}]


(* ::Input::Initialization:: *)
(* InterseccionConicaRectaDosPuntos[eqn_,ptP_,ptQ_]:=Module[{sols,pts},
If[And[Sustituirxyz[eqn,ptP]===0,Sustituirxyz[eqn,ptQ]===0],{ptP,ptQ},
sols=Solve[\[Lambda]^2Sustituirxyz[eqn,ptP]+\[Lambda] (ptQ. {Sustituirxyz[D[eqn,x],ptP], Sustituirxyz[D[eqn,y],ptP],Sustituirxyz[D[eqn,z],ptP]})+Sustituirxyz[eqn,ptQ]\[Equal]0,\[Lambda]];
pts=Map[Simplificar,ptQ+\[Lambda] ptP/.sols];
If[Sustituirxyz[eqn,ptP]===0,Join[{ptP},pts] ,pts]
]
] *)


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EcuacionTangentesConica::"usage"="EcuacionTangentesConica[ptP,eqn] devuelve una ecuaci\[OAcute]n de segundo grado conteniendo las dos tangentes desde el punto P a la c\[OAcute]nica eqn";


(* ::Input::Initialization:: *)
EcuacionTangentesConica[ptP_,eqn_]:=Factor[(ptP . MatrizConica[eqn] . {x,y,z})^2-eqn Sustituirxyz[eqn,ptP]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
TangentesConica::"usage"="TangentesCnoica[ptP,eqn] devuelve las tangentes desde el punto P a la c\[OAcute]nica eqn";


(* ::Input::Initialization:: *)
TangentesConica[ptP_,eqn_]:=Map[Recta[ptP,#]&,PuntosInfinito[EcuacionTangentesConica[ptP,eqn]]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EcuacionAsintotasHiperbola::"usage"="EcuacionAsintotasHiperbola[conica] devuelve un polinomio de segundo grado conteniendo las as\[IAcute]ntotas de una hip\[EAcute]rbola.";


(* ::Input::Initialization:: *)
EcuacionAsintotasHiperbola[conica_]:=Module[{f,g,h, p, q, r,H,K},
{f,g,h}=Map[Coefficient[conica,#] &, {x^2,y^2,z^2}];
{p,q,r}=Map[Coefficient[conica,#] &, {y z,z x,x y}]/2;
K=Det[{{f,r,q,1},{r,g,p,1},{q,p,h,1},{1,1,1,0}}];
H=Det[{{f, r, q},{ r,g, p},{ q, p,h}}];
{H,K}=Simplificar[{H,K}];
Factor[K conica+H (x+y+z)^2]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CuadradoCosenoAsintotas::"usage"="CuadradoCosenoAsintotas devuelve el cuadrado del coseno del \[AAcute]ngulo formado por las as\[IAcute]ntotas de una hip\[EAcute]rbola.";


(* ::Input::Initialization:: *)
CuadradoCosenoAsintotas[conica_]:=Module[{f,g,h, p, q, r,e,K},
{f,g,h}=Map[Coefficient[conica,#] &, {x^2,y^2,z^2}];
{p,q,r}=Map[Coefficient[conica,#] &, {y z,z x,x y}]/2;
K=Det[{{f,r,q,1},{r,g,p,1},{q,p,h,1},{1,1,1,0}}];
e=Factor[a^2 f+b^2 g+c^2 h-p(b^2+c^2-a^2)-q(a^2-b^2+c^2)-r(a^2+b^2-c^2)];
Factor[Divide[e^2,e^2+4S^2 K]/.sustS]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EsHiperbolaEquilatera::"usage"="EsHiperbolaEquilatera[conica] devuelve True si conica es una hip\[EAcute]rbola equil\[AAcute]tera.";


(* ::Input::Initialization:: *)
EsHiperbolaEquilatera[conica_]:=CuadradoCosenoAsintotas[conica]===0


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CuadradoCuerdaConicaRecta::"usage"="CuadradoCuerdaConicaRecta[conica,rtL] devuelve el cuadrado de la cuerda intersecci\[OAcute]n de una c\[OAcute]nica y una recta.";


(* ::Input::Initialization:: *)
CuadradoCuerdaConicaRecta[conica_,{l_,m_,n_}]:=Module[{f,g,h, p, q, r,\[Phi],P,\[EmptyDownTriangle]},
{f,g,h}=Map[Coefficient[conica,#] &, {x^2,y^2,z^2}];
{p,q,r}=Map[Coefficient[conica,#] &, {y z,z x,x y}]/2;
\[Phi]=Det[{{f,r,q,l},{r,g,p,m},{q,p,h,n},{l,m,n,0}}];
P=a^2 l^2+b^2 m^2+c^2 n^2-m n(b^2+c^2-a^2)-l n(a^2+c^2-b^2)-l m(a^2+b^2-c^2);
\[EmptyDownTriangle]=Det[{{f,r,q,l,1},{r,g,p,m,1},{q,p,h,n,1},{l,m,n,0,0},{1,1,1,0,0}}];
Factor[Divide[4P \[Phi],\[EmptyDownTriangle]^2]]
];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CuadradoLatusRectum::"usage"="CuadradoLatusRectum[eqn] devuelve el cuadrado de la cuerda que pasa por el foco y es paralela a la directriz.";


(* ::Input::Initialization:: *)
CuadradoLatusRectum[eqn_]:=CuadradoCuerdaConicaRecta[eqn,Perpendicular[First[FocosConica[eqn]],EjeParabola[eqn]]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EcuacionDirectricesConica::"usage"="EcuacionDirectricesConica[eqn] devuelve dos polinomios de segundo grado conteniendo las directrices (reales y imaginarias) de una c\[OAcute]nica central.";


(* ::Input::Initialization:: *)
EcuacionDirectricesConica[eqn_]:=Module[{f,g,h, p, q, r,H,K},
{f,g,h}=Map[Coefficient[eqn,#] &, {x^2,y^2,z^2}];
{p,q,r}=Map[Coefficient[eqn,#] &, {y z,z x,x y}]/2;
H=Det[{{a^2 f,a b r,a c q},{a b r,b^2 g,b c p},{a c q,b c p,c^2 h}}];
K=Det[{{a,a^2 f,a b r,a c q},{b,a b r,b^2 g,b c p},{c, a c q,b c p,c^2 h},{0,a,b,c}}];
Factor[Map[H eqn S^2-CircunferenciaDeMonge[eqn] K #&,CuadradoSemiejesElipse[eqn]]/.sustS]
];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ExcentricidadCircunconica::"usage"="ExcentricidadCircunconica[ptP,ptQ] ...";


(* ::Input::Initialization:: *)
ExcentricidadCircunconica[{p_,q_,r_},{u_,v_,w_}]:=Module[{X1,X2,pu,qv,rw},
pu=p u(q w-r v);
qv=q v(r u-p w);
rw=r w(p v-q u);
X1=Sqrt[a^4 qv rw+b^4 pu rw+c^4 pu qv-b^2 c^2 pu (-pu+qv+rw)-c^2 a^2 qv (pu-qv+rw)-a^2 b^2 rw (pu+qv-rw)];
     X2=fSA pu+fSB qv+fSC rw;
(2X1)/(X1-X2)
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CuadradoExcentricidad::"usage"="CuadradoExcentricidad[conica] devuelve la excentricidad de una c\[OAcute]nica.";


(* ::Input::Initialization:: *)
CuadradoExcentricidad[conica_]:=Module[{f,g,h,p,q,r,u,v,w,U,V},
{f,g,h}=Coefficient[conica,{x^2,y^2,z^2}];
{p,q,r}=Coefficient[conica,{y z,z x, x y}]/2;
{u,v,w}={(g+h-2p)/a^2,(h+f-2q)/b^2,(f+g-2r)/c^2};
U=a^2 (f+p-q-r)+b^2 (g+q-r-p)+c^2 (h+r-p-q);
V=fSA (v-w)^2+fSB (w-u)^2+fSC (u-v)^2;
Select[Factor[e2/.Solve[a^2 b^2 c^2 (e2-2)^2 V==e2^2 U^2,e2]],Sustituir[#,{a,b,c},{6,9,13}]>0&][[1]]
];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ConicaHiperOsculatriz::"usage"="ConicaHiperOsculatriz[eqn_,T_,P_] es la c\[OAcute]nica con cuatro puntos comunes en ptT con la c\[OAcute]nica de ecuaci\[OAcute]n <eqn> y que pasa por el punto ptP.";


(* ::Input::Initialization:: *)
ConicaHiperOsculatriz[eqn_,ptT_,ptP_]:=Module[{tang,haz,sol},
tang=Simplificar[PolarConica[ptT,eqn]];
haz=eqn+\[Lambda] (tang . {x,y,z})^2;
sol=Solve[Sustituirxyz[haz,ptP]==0,\[Lambda]];
Numerator[Factor[haz/.sol[[1]]]]
];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PuntoSobreConicaInscrita::"usage"="PuntoSobreConicaInscrita[ptP][t] devuelve un punto g\[EAcute]nerico con par\[AAcute]metro t de la c\[OAcute]nica inscrita con perspector P.";


(* ::Input::Initialization:: *)
PuntoSobreConicaInscrita[{p_,q_,r_}][t_]:={-p^3 (q-r)^2 (1+q r t)^2,-q^3 (p-r)^2 (1+p r t)^2,-(p-q)^2 r^3 (1+p q t)^2}


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ConicaInscrita::"usage"="ConicaInscrita[ptP] devuele la c\[OAcute]nica inscrita de perspector {p,q,r}.";


(* ::Input::Initialization:: *)
ConicaInscrita[{p_,q_,r_}]:=x^2/p^2+y^2/q^2+z^2/r^2-(2 y z)/(q r)-(2 z x)/(r p)-(2x y)/(p q);


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
InterseccionConicas::"usage"="InterseccionConicaRecta[conica1,conica2] devuelve los puntos de interseccion de conica1 y conica2";


(* ::Input::Initialization:: *)
InterseccionConicas[conica1_,conica2_]:=Module[{pts,inf,points},
pts=Map[Simplificar,{x,y,z}/.Solve[{conica1==0,conica2==0,x+y+z==1},{x,y,z}]];
inf={x,y,x}/.Solve[{conica1==0,conica2==0,x+y+z==0},{x,y,z}];
points=Join[pts,Complement[inf,{{0,0,0}}]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
InversoConica::"usage"="InversoConica[ptP,conic] devuelve el inverso del punto P respecto de la c\[OAcute]nica conic.";


(* ::Input::Initialization:: *)
InversoConica[ptP_,conic_]:=Punto[Recta[ptP,CentroConica[conic]],PolarConica[ptP,conic]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
AgruparCubica::"usage" = "AgruparCubica[eqn] agrupa los monomios de una c\[UAcute]bica.";


(* ::Input::Initialization:: *)
AgruparCubica[eqn_]:=Total[Map[AgruparMonomios[eqn,#]&,
{{x y^2,x z^2},{y z^2,y x^2},{z x^2,z y^2},{x y z}}]];


(* ::Input::Initialization:: *)
PivoteCubica::"usage" = "PivoteCubica[eqn] calcula el pivote de una isoc\[UAcute]bica pivotal.";


(* ::Input::Initialization:: *)
PivoteCubica[cubic_]:=Simplificar[Coefficient[cubic,{x y^2,y z^2,z x^2}]/PoloCubica[cubic][[{3,1,2}]]]


(* ::Input::Initialization:: *)
PoloCubica::"usage" = "PoloCubica[eqn] calcula el polo de una isoc\[UAcute]bica.";


(* ::Input::Initialization:: *)
PoloCubica[cubic_]:=Module[{p,q,r,p1,q1,r1,p2,q2,r2,signo},{p1,q1,r1}=Coefficient[cubic,{y z^2,z x^2,x y^2}];
{p2,q2,r2}=Coefficient[cubic,{y^2 z,z^2 x,x^2 y}];
signo=If[Coefficient[cubic,x y z]===0,-1,1];
Simplificar[{p,q,r}/. Solve[{r1/q2==signo r/q,p1/r2==signo p/r,q1/p2==signo q/p},{q,r}][[1]]]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CubicaNuevePuntos::"usage"="CubicaNuevePuntos[ptP1,...,ptP9] returns the cubic through nine points.";


(* ::Input::Initialization:: *)
CubicaNuevePuntos[{{p1_,q1_,r1_},{p2_,q2_,r2_},{p3_,q3_,r3_},{p4_,q4_,r4_},{p5_,q5_,r5_},{p6_,q6_,r6_},{p7_,q7_,r7_},{p8_,q8_,r8_},{p9_,q9_,r9_}}]:=Det[{{x^3,y^3,z^3,x^2 y,x^2 z,y^2 z,x y^2,x z^2,y z^2,x y z},{p1^3,q1^3,r1^3,p1^2 q1,p1^2 r1,q1^2 r1,p1 q1^2,p1 r1^2,q1 r1^2,p1 q1 r1},{p2^3,q2^3,r2^3,p2^2 q2,p2^2 r2,q2^2 r2,p2 q2^2,p2 r2^2,q2 r2^2,p2 q2 r2},{p3^3,q3^3,r3^3,p3^2 q3,p3^2 r3,q3^2 r3,p3 q3^2,p3 r3^2,q3 r3^2,p3 q3 r3},{p4^3,q4^3,r4^3,p4^2 q4,p4^2 r4,q4^2 r4,p4 q4^2,p4 r4^2,q4 r4^2,p4 q4 r4},{p5^3,q5^3,r5^3,p5^2 q5,p5^2 r5,q5^2 r5,p5 q5^2,p5 r5^2,q5 r5^2,p5 q5 r5},{p6^3,q6^3,r6^3,p6^2 q6,p6^2 r6,q6^2 r6,p6 q6^2,p6 r6^2,q6 r6^2,p6 q6 r6},{p7^3,q7^3,r7^3,p7^2 q7,p7^2 r7,q7^2 r7,p7 q7^2,p7 r7^2,q7 r7^2,p7 q7 r7},{p8^3,q8^3,r8^3,p8^2 q8,p8^2 r8,q8^2 r8,p8 q8^2,p8 r8^2,q8 r8^2,p8 q8 r8},{p9^3,q9^3,r9^3,p9^2 q9,p9^2 r9,q9^2 r9,p9 q9^2,p9 r9^2,q9 r9^2,p9 q9 r9}}]


(* ::Input::Initialization::GrayLevel[0]:: *)
GradoPolinomio::"usage"="GradoPolinomio[eqn,vars] devuelve el grado del polinomio eqn en las variables vars.";


(* ::Input::Initialization:: *)
GradoPolinomio[eqn_,vars_]:=Module[{eeqn=Expand[eqn]},
If[UnsameQ[Head[eeqn],Plus],
Total[Exponent[eeqn,vars]],
Max[Map[Total[Exponent[#,vars]]&,Level[eeqn,1]]]]]


(* ::Input::Initialization::GrayLevel[0]:: *)
TipoEcuacion::"usage"="TipoEcuacion[ecuacion] devuelve 1,2,3,4,5 seg\[UAcute]n ecuacion sea una recta, circunferencia, c\[OAcute]nica, c\[UAcute]bica o una curva de grado superior.";


(* ::Input::Initialization:: *)
TipoEcuacion[ecuacion_]:=With[
{d=GradoPolinomio[ecuacion,{x,y,z}]},
Which[d==1,1,
d==2,If[ConicaEsCircunferencia[ecuacion]==={0,0,0},2,3],
d==3,4,
True,5]
]


(* ::Input::Initialization::GrayLevel[0]:: *)
NombreEcuacion::"usage"="NombreEcuacion[ecuacion] busca una ecuaci\[OAcute]n dentro de la base de datos ECUACIONES que contiene una lista de rectas, c\[OAcute]nicas, c\[UAcute]bicas y curvas de grado superior.";


(* ::Input::Initialization:: *)
NombreEcuacion[ecuacion_]:=Module[{encontrado=False,n=1,ec,id},
id=TipoEcuacion[ecuacion];
n=1;
While[!encontrado&&n<=Length[ECUACIONES],
If[ECUACIONES[[n,1]]==id,
ec=ECUACIONES[[n,3]];If[Factor[ecuacion-ec]===0||Factor[ecuacion+ec]===0,encontrado=True]];
n++
];
If[encontrado,ECUACIONES[[n-1,2]],"No encontrada"]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
BuscarEcuaciones::"usage"="BuscarEcuaciones[clave] busca los nombres que llevan un nombre conteniendo clave. Si solo encuentra una, devuelve la ecuaci\[OAcute]n. En caso contrario devuelve la lista de nombres.";


(* ::Input::Initialization:: *)
BuscarEcuaciones[clave_,OptionsPattern[{info->False,exact->False}]]:=Module[{f,sols,info1,exact1},
info1=OptionValue[info];
exact1=OptionValue[exact];
If[exact1,
f=ToUpperCase[#[[2]]]==ToUpperCase[clave]&,
f=StringPosition[#[[2]],clave,IgnoreCase->True]!={}&
];
sols=Select[ECUACIONES, f];
If[And[Length[sols]==1,Not[info1]],
Last[First[sols]],
Map[#[[2]]&,sols]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EstanAlineados::"usage"="EstanAlineados[lista] devuelve True si los puntos de la lista est\[AAcute]n alineados.";


(* ::Input::Initialization:: *)
EstanAlineados[lista_] := MatrixRank[lista] <3;


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SonConcurrentes::"usage"="SonConcurrentes[lista] devuelve True si las rectas de la lista son concurrentes.";


(* ::Input::Initialization:: *)
SonConcurrentes[lista_] := EstanAlineados[lista];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SonPerspectivos::"usage"="SonPerspectivos[trT1,trT2] devuelve True los tri\[AAcute]ngulos trT1 y trT2 son perspectivos.";


(* ::Input::Initialization:: *)
SonPerspectivos[{ptA1_,ptB1_,ptC1_},{ptA2_,ptB2_,ptC2_}]:=
Factor [Det[{Recta[ptA1,ptA2],Recta[ptB1,ptB2],Recta[ptC1,ptC2]}]]==0;


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PerspectivoConABC::"usage"="PerspectivoConABC[trT] devuelve True el tri\[AAcute]ngulo trT es perspectivo con ABC.";


(* ::Input::Initialization:: *)
PerspectivoConABC[T_] := SonPerspectivos[{ptA,ptB,ptC},T];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Perspector::"usage"="Perspector[trT1,trT2] devuelve el perspector de los tri\[AAcute]ngulos trT1 y trT2.";


(* ::Input::Initialization:: *)
Perspector[{ptA1_,ptB1_,ptC1_},{ptA2_,ptB2_,ptC2_}]:=
Punto[Recta[ptA1,ptA2],Recta[ptB1,ptB2]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PerspectorConABC::"usage"="PerspectorConABC[trT] devuelve el perspector de los tri\[AAcute]ngulos trT y ABC.";


(* ::Input::Initialization:: *)
PerspectorConABC[T_] := Perspector[{ptA,ptB,ptC},T];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
SonConciclicos::"usage"= "SonConciclicos[lista] devuelve True si los puntos de la lista no est\[AAcute]n alineados y son conc\[IAcute]clicos";


(* ::Input::Initialization:: *)
 SonConciclicos[lista_]:=With[{lista1=Union[lista]},
!EstanAlineados[lista1]&&SonConcurrentes[(Mediatriz[lista1[[1]],#1]&)/@Drop[lista1,1]]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
AreaTriangulo::"usage"="AreaTriangulo[{ptP,ptQ,ptR}] devuelve el cociente de \[AAcute]reas (PQR)/(ABC).";


(* ::Input::Initialization:: *)
AreaTriangulo[{P_,Q_,R_}] :=Factor[Det[{P,Q,R}]/(Tr[P] Tr[Q] Tr[R])];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CuadradoDistancia::"usage"="CuadradoDistancia[ptP,ptQ] devuelve el cuadrado de la distancia entre dos puntos..";


(* ::Input::Initialization:: *)
CuadradoDistancia[{u_,v_,w_},{x_,y_,z_}] := Factor[
Divide[fSA ((v+w)x-u(y+z))^2+fSB ((w+u)y-v(z+x))^2+fSC ((u+v)z-w(x+y))^2,
(u+v+w)^2 (x+y+z)^2]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
RazonSimple::"usage"="RazonSimple[ptA,ptB,ptC] devuelve la raz\[OAcute]n simple AB:BC.";


(* ::Input::Initialization:: *)
RazonSimple[ptA_,ptB_,ptC_]:=Module[{ptP1,ptP2,ptP3,num,den,k,plist,ilist},
plist=Union[{ptA,ptB,ptC},SameTest->PuntosIguales];
Which[
Or[Length[plist]==2,EsInfinito[ptA],EsInfinito[ptB],EsInfinito[ptC]],
Which[
PuntosIguales[ptA,ptB],0,
PuntosIguales[ptA,ptC],-1,
PuntosIguales[ptB,ptC],Infinity,
EsInfinito[ptA],Infinity,
EsInfinito[ptB],-1,
EsInfinito[ptC],0
],
Length[plist]==3,
{ptP1,ptP2,ptP3}=Simplify[(#1/Total[#1]&)/@{ptA,ptB,ptC}];{num,den}={ptP1-ptP2,ptP2-ptP3};k=Which[den[[1]]=!=0,1,den[[2]]=!=0,2,den[[3]]=!=0,3];FullSimplify[num[[k]]/den[[k]]],
True,Undefined
]
]



(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
RazonDoble::"usage"="RazonDoble[ptA,ptB,ptX,ptY] devuelve la raz\[OAcute]n doble (AX/XB)/(AY/YB)";


(* ::Input::Initialization:: *)
RazonDoble[ptA_,ptB_,ptX_,ptY_]:=Module[{m,n},
m=RazonSimple[ptA,ptX,ptB];
n=RazonSimple[ptA,ptY,ptB];
Which[
And[m===Infinity,n===Infinity],1,
m===Infinity,Infinity,
n===Infinity,0,
n===0,Infinity,
True,Simplify[m/n]
]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CuadradoRadioNuevePuntos::"usage"="CuadradoRadioNuevePuntos[trT] devuelve el cuadrado del radio de la circunferencia de los nueve puntos del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
CuadradoRadioNuevePuntos[{ptA_,ptB_,ptC_}]:=
CuadradoDistancia[CentroNuevePuntos[{ptA,ptB,ptC}],Medio[ptB,ptC]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
CuadradoDistanciaPuntoRecta::"usage"="CuadradoDistanciaPuntoRecta[ptP,r] devuelve el cuadrado de la distancia del punto ptP a la recta r.";


(* ::Input::Initialization:: *)
CuadradoDistanciaPuntoRecta[ptP_,r_]:=CuadradoDistancia[ptP,Pie[ptP,r]];


(* ::Input::Initialization:: *)
Coordenadas::"usage"="Coodenadas[ptP,trT] devuelve las coordenadas del punto ptP respecto del tri\[AAcute]ngulo trT.";


(* ::Input::Initialization:: *)
Coordenadas[ptP_,{ptA_,ptB_,ptC_}] :=Simplificar[{AreaTriangulo[{ptP,ptB,ptC}],AreaTriangulo[{ptP,ptC,ptA}],AreaTriangulo[{ptP,ptA,ptB}]}];


(* ::Input::Initialization:: *)
CentroETCTriangulo::"usage"="CentroTriangulo[ptX,trT] returns the barycentric coordinates of the center ptX of the triangle trT.";


(* ::Input::Initialization:: *)
CentroETCTriangulo[{x_,y_,z_},{ptP_,ptQ_,ptR_}]:=Module[{S1,SS,siderules},
SS=S*AreaTriangulo[{ptP,ptQ,ptR}];
siderules=Thread[{a,b,c}->Sqrt[MapThread[CuadradoDistancia,{{ptQ,ptR,ptP},{ptR,ptP,ptQ}}]]];
Transpose[{ptP,ptQ,ptR}] . {(x/. {S->S1}/. siderules/. {S1->SS})/Total[ptP],(y/. {S->S1}/. siderules/. {S1->SS})/Total[ptQ],(z/. {S->S1}/. siderules/. {S1->SS})/Total[ptR]}]


(* ::Input::Initialization::GrayLevel[0]:: *)
cA={1,3};cB={0,0};cC={4,0};


(* ::Input::Initialization:: *)
{{xmin,xmax},{ymin,ymax}}={{-1,5},{-2,4}};


(* ::Input::Initialization:: *)
VerticesTriangulo::"usage"="VerticesTriangulo[{a,b,c}] devuelve las coordenadas cartesianas de un tri\[AAcute]ngulo ABC cuyos laods miden a, b y c.";


(* ::Input::Initialization::GrayLevel[0]:: *)
VerticesTriangulo[trT_:{6,9,13}]:={{(a^2-b^2+c^2)/(2a),Sqrt[(-a+b+c) (a+b-c) (a-b+c) (a+b+c)]/(2a)},{0,0},{a,0}}/.Thread[{a,b,c}->trT];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
BarCar::"usage"="BarCar[f,cA,cB,cC] transforma una expresi\[OAcute]n en baric\[EAcute]ntricas en la correspondiente en cartesianas, usando el tri\[AAcute]ngulo dado.";


(* ::Input::Initialization:: *)
BarCar[f_,cA_,cB_,cC_]:=f /.
{x-> Det[({
 {cB[[1]]-x, cC[[1]]-x},
 {cB[[2]]-y, cC[[2]]-y}
})],
y->Det[({
 {cC[[1]]-x, cA[[1]]-x},
 {cC[[2]]-y, cA[[2]]-y}
})],
z-> Det[({
 {cA[[1]]-x, cB[[1]]-x},
 {cA[[2]]-y, cB[[2]]-y}
})],
a->Norm[cB-cC],b->Norm[cC-cA],c->Norm[cA-cB]};


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PuntoBarCar::"usage"="PuntoBarCar[ptP,cA,cB,cC] transforma un punto en baric\[EAcute]ntricas en el correspondiente en cartesianas, usando el tri\[AAcute]ngulo dado.";


(* ::Input::Initialization:: *)
PuntoBarCar[{u_,v_,w_},cA_,cB_,cC_] := 
(u cA + v cB + w cC)/(u+v+w)  /. {a->Norm[cB-cC],b->Norm[cC-cA],c->Norm[cA-cB]};


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ListaPuntoBarCar::"usage"="ListaPuntoBarCar[ptP,cA,cB,cC] transforma una lista de puntos en baric\[EAcute]ntricas en los correspondientes en cartesianas, usando el tri\[AAcute]ngulo dado.";


(* ::Input::Initialization:: *)
ListaPuntoBarCar[lista_,cA_,cB_,cC_] := 
Map[PuntoBarCar[#,cA,cB,cC]&,lista]



(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Cartesianas::"usage"="Cartesianas[f] convierte la expresi\[OAcute]n f, dada en baric\[EAcute]ntricas, en coordenadas cartesianas, usando los valores por defecto de cA, cB y cC";


(* ::Input::Initialization::GrayLevel[0]:: *)
Cartesianas[f_]:= Factor[BarCar[f,cA,cB,cC]];


(* ::Input::Initialization:: *)
kiA={(4 Sqrt[35])/3,13/3};kiB={0,-6};kiC={0,0};
sustABCabc={a->6,b->9,c->13,A->ArcCos[107/117],B->ArcCos[31/39],C->ArcCos[-(13/27)]};


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
KimberlingOrdinario::"usage" = "KimberlingOrdinario[P] devuelve la coordenada de b\[UAcute]squeda 6-9-13 del punto ordinario P en la ETC.";


(* ::Input::Initialization:: *)
KimberlingOrdinario[{u_,v_,w_}] :=Module[{k},
k=N[(u kiA+ v kiB+ w kiC)/(u+v+w),20] [[1]]/. sustABCabc; 
If[Abs[Im[k]]<10^-8,k,Arg[k]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
KimberlingInfinito::"usage" = "KimberlingInfinito[P] devuelve la coordenada de b\[UAcute]squeda 6-9-13 del punto ordinario P en la ETC.";


(* ::Input::Initialization:: *)
KimberlingInfinito[{u_,v_,w_}] :=Module[{k},
k=N[(c u v+b u w+a v w)/(a v w),20]/. sustABCabc; 
If[Abs[Im[k]]<10^-8,k,Arg[k]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Kimberling::"usage"="Kimberling[P] devuelve la coordenada de b\[UAcute]squeda 6-9-13 del punto P en la ETC.";


(* ::Input::Initialization:: *)
Kimberling[ptP_] :=If[Factor[Total[ptP]]=== 0,KimberlingInfinito[ptP],KimberlingOrdinario[ptP]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
GetETCSearchNumbers::"usage"="GetETCSearchNumbers devuelve las coordenadas de b\[UAcute]squeda en la ETC del punto de intersecci\[OAcute]n de varias curvas (por Peter Moses)";


(* ::Input::Initialization:: *)
GetETCSearchNumbers[equations_,sides_]:=Module[{eqns,results,ans},eqns=Join[{Equal@@(equations/. Thread[{a,b,c}->sides]),x+y+z==1}];results=RootReduce[{x,y,z}/. Solve[eqns,{x,y,z}]];ans=Select[DeleteCases[N[results,12],{___,0,___}],Im[#1]=={0,0,0}&];((#1 Sqrt[(a+b+c) (a+b-c) (a-b+c) (-a+b+c)])/({a,b,c} 2)&)/@ans/. Thread[{a,b,c}->sides]]


(* ::Input::Initialization:: *)
GetETCSearchNumbers[equations_]:=GetETCSearchNumbers[equations,{6,9,13}]


(* ::Input::Initialization:: *)



(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ToleranciaDeBusqueda::"usage"="ToleranciaDeBusqueda es una constante usada por BuscarPuntosTrilineales para indicar que un punto cumple determinada ecuaci\[OAcute]n. Su valor por defecto es \!\(\*SuperscriptBox[\(10\), \(-15\)]\)";


(* ::Input::Initialization:: *)
ToleranciaDeBusqueda=10^-15;


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
IndiceTrilinealesETC::"usage"="IndiceTrilinealesETC[list_] devuelve el indice i del punto X[i] en la ETC de Clark Kimberling que corresponde a la coordenadas de b\[UAcute]squeda list. Si no se encuentra ninguno, devuelve 0.";


(* ::Input::Initialization:: *)
IndiceTrilinealesETC[list_]:=Module[{pos},
pos=Position[TrilinealesETC,list];
If[pos !={},First[First[pos]],0]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ObtenerTrilinealesETC::"usage"="ObtenerTrilinealesETC[ptP] devuelve los n\[UAcute]meros de b\[UAcute]squeda de un punto en la ETC.";


(* ::Input::Initialization:: *)
ObtenerTrilinealesETC[{u_,v_,w_},triangle_:{6,9,13}]:=Module[{x,y,z,res,zero,sust,a0,b0,c0},$MaxExtraPrecision=1000;{a0,b0,c0}=triangle;zero=1/10^10;sust={a->a0,b->b0,c->c0};If[{u,v,w}=={0,0,0},Return[{0,0,0}]];{x,y,z}=Evaluar[{u,v,w}];If[N[Chop[Simplify[x+y+z/. sust],zero]]==0,res=Chop[{x,y,z}/. sust,zero];If[res[[1]]==0,Return[{0,-c0,b0}]];If[res[[2]]==0,Return[{c0,0,-b0}]];If[res[[3]]==0,Return[{-b0,a0,0}]];res=(c x y+b x z+a y z)/{a y z,b x z,c x y}/. sust,res=(Sqrt[fS2] {x,y,z})/((x+y+z) {a,b,c})/. sust];res=(If[Head[N[#1]]===Complex,Arg[#1],#1]&)/@res;res=Chop[(SetAccuracy[N[#1,{\[Infinity],40}],40]&)/@res];VeinteDigitos/@res
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
BuscarPorCoordenadas::"usage"="BuscarPorCoordenadas[ptP] identifica el punto P en la enciclopedia de Clark Kimberling. Si no se encuentra el punto, se intenta buscar su conjugado isogonal o su conjugado isot\[OAcute]mico.";


(* ::Input::Initialization:: *)
BuscarPorCoordenadas[ptP_]:=Module[{j,n,i,f,transformations,legends,ptQ,found},
transformations={Identity,ConjugadoIsogonal,ConjugadoIsotomico};
legends={"","isogonal conjugate of ","isotomic conjugate of "};
j=0;n=0;found=False;
ptQ=If [FreeQ[ptP,S],ptP,ptP/.sustH];
If[UnsameQ[ptQ,{0,0,0}],
For[i=1,And[!found,i<=Length[transformations]],i++,
f=transformations[[i]];
n=IndiceTrilinealesETC[ObtenerTrilinealesETC[f[ptQ]]];
If[n!=0,j=i;found=True]
]];
If[j==0,"?",legends[[j]] <> "X"<>ToString[n]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
BuscarPuntosNum::"usage"="BuscarPuntosNum[eqn] busca num\[EAcute]ricamente puntos que puedan satisfacer la ecuaci\[OAcute]n eqn.
Podemos indicar opcionalmente los l\[IAcute]mites de b\[UAcute]squeda y que muestre informaci\[OAcute]n del progreso.";


(* ::Input::Initialization:: *)
BuscarPuntosNum[eqn_,OptionsPattern[{limits->0,info->False}]]:=Module[{lista={},n1,n2,np,found=0,trieqn,info1=OptionValue[info],limits1=OptionValue[limits]},
trieqn=eqn/. {x->a x,y->y b,z->z c};
np=Length[TrilinealesETC];
If[limits1==0,n1=1;n2=np];
If[IntegerQ[limits1]&&limits1>0,n1=1;n2=Min[limits1,np]];
If[ListQ[limits1]&&limits1[[1]]>0&&limits1[[2]]>0,n1=Min[limits1[[1]],np];n2=Min[limits1[[2]],np]];
If[info1==True,
Monitor[
Do[If[N[Abs[trieqn/. Thread[{x,y,z}->TrilinealesETC[[i]]]/. sustABCabc]]<ToleranciaDeBusqueda,found++;lista=Append[lista,i]],{i,n1,n2}],
Row[{"Analizando los centros de ETC ",ProgressIndicator[i,{1,n2}]," ",i,"/",n2," - Encontrados: ",found}]
],
Do[If[N[Abs[trieqn/. Thread[{x,y,z}->TrilinealesETC[[i]]]/. sustABCabc]]<ToleranciaDeBusqueda,found++;lista=Append[lista,i]],{i,n1,n2}]
];
lista
];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
BuscarPropiedades::"usage"="BuscarPropiedades[ptP] extiende la b\[UAcute]squeda realizada por BuscarPorCoordenadas para identificar las propieades de un punto como perteneciente a la ETC o alg\[UAcute]n transformado.";


(* ::Input::Initialization:: *)
BuscarPropiedades[ptP_]:=Module[{n,i,f,transformations,legends,ptQ,answers},
transformations={Identity,ConjugadoIsogonal,ConjugadoIsotomico,Complemento[ConjugadoIsogonal[#]]&,Anticomplemento[ConjugadoIsogonal[#]]&,Complemento[ConjugadoIsotomico[#]]&,Anticomplemento[ConjugadoIsotomico[#]]&,ConjugadoIsogonal[Complemento[#]]&,ConjugadoIsotomico[Complemento[#]]&,ConjugadoIsogonal[Anticomplemento[#]]&,ConjugadoIsotomico[Anticomplemento[#]]&};
legends={"","isogonal conjugate of ","isotomic conjugate of ","isogonal conjugate of anticomplement of ","isogonal conjugate of complement of ","isotomic conjugate of anticomplement of ","isotomic conjugate of complement of ","anticomplement of isogonal conjugate ","anticomplement of isotomic conjugate ","complement of isogonal conjugate ","complement of isotomic conjugate "};
answers={};n=0;
ptQ=If [FreeQ[ptP,S],ptP,ptP/.sustH];
If[UnsameQ[ptQ,{0,0,0}],
For[i=1,i<=Length[transformations],i++,
f=transformations[[i]];
n=IndiceTrilinealesETC[ObtenerTrilinealesETC[f[ptQ]]];
If[n!=0,AppendTo[answers,legends[[i]] <> "X"<>ToString[n]]]];
];
answers
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
BuscarPares::usage="BuscarPares[ptQ] sustituye en ptQ las variables {x,y,z} por los puntos de ETC indizados en la variable puntos. Las opciones por defecto son puntos\[Rule]Range[12], maxpares\[Rule]Infinity e info->False. Ejemplos:
    BuscarPares[ptQ,puntos->iETC[[Range[15]]],info->True]\[IndentingNewLine]BuscarPares[ptQ,maxpares->4,puntos->iETC[[Range[15]]],info->True]";


(* ::Input::Initialization:: *)
BuscarPares[ptQ_,OptionsPattern[{puntos->Range[12], maxpares->Infinity,info->True}]]:=Module[{n,m,expr,res={},puntos1,maxpares1,info1},
puntos1=OptionValue[puntos];
maxpares1=OptionValue[maxpares];
info1=OptionValue[info];
Monitor[
For[n=1,n<=Length[puntos1],n++,
expr=BuscarPorCoordenadas[Sustituirxyz[ptQ,ETC[[puntos1[[n]],2]]]];
m=If[StringTake[expr,1]=="X",ToExpression[StringDrop[expr,1]],0];
If[m>0,AppendTo[res,{puntos1[[n]],m}]];
If[Length[res]>maxpares1,
res=Take[res, maxpares1];Break[]
];
],
If[info1==True,Row[{"Analizando pares: ",ProgressIndicator[n,{1,Length[puntos1]}]," ",n,"/",Length[puntos1]," - Encontrados: ",Length[res]}],""]
];
res
];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
BuscarPuntos::"usage"="BuscarPuntos[eqn] searchs for ETC points on a locus, using their symbolic barycentric coordinates.";


(* ::Input::Initialization:: *)
BuscarPuntos[lugar_,OptionsPattern[{Limite->Length[ETC]}]]:=Module[{limite,lista},
limite=OptionValue[Limite];
lista={};
For[i=1,i<=limite,i++,
If[Simplify[Sustituirxyz[lugar,ETC[[i,2]]]]==0,
lista=Append[lista,ETC[[i,1]]]
]
];
lista
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
BuscarLineas::"usage"="BuscarLineas[P] searchs for lines X[i]X[j] through the given point P, using its symbolic barycentric coordinates.";


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PrintToTaggedCell::"usage"="PrintToTaggedCell[expr,celltag] escribe en una celda que tiene un tag.";


(* ::Input::Initialization:: *)
PrintToTaggedCell[expr_, celltag_] := If[NotebookFind[EvaluationNotebook[], ToString[celltag], All, CellTags] ===  $Failed, CellPrint[ Cell[ToString[expr], "Print", CellTags -> ToString[celltag]]], NotebookWrite[EvaluationNotebook[], Cell[ToString[expr], "Print", CellTags -> ToString[celltag]]]]; 


(* ::Input::Initialization::GrayLevel[0]:: *)
BuscarLineas[ptP_,OptionsPattern[{MostrarProgreso->False,Limite->Length[ETC]}]]:=Module[{mostrarprogreso,limite, resultado,existente, terna},
limite=OptionValue[Limite];
mostrarprogreso=OptionValue[MostrarProgreso];
resultado={};
For[i=1,i< limite,i++,If[mostrarprogreso,PrintToTaggedCell[i,"progreso"]];
For[j=i+1,j<=limite,j++,
If[Det[{ptP,ETC[[i,2]],ETC[[j,2]]}]==0,
existente=False;
For[k=1,k<=Length[resultado],k++,
terna=Append[ETC[[resultado[[k]],2]],ETC[[j,2]]];
If[Det[{ptP,ETC[[i,2]],ETC[[j,2]]}]==0,existente=True;Break]
];
If[Not[existente],If[mostrarprogreso,Print[{i,j}]];resultado=Append[resultado,{i,j}]]]
]
];
resultado
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
BuscarCentralLines::"usage"="BuscarCentralLines[P] searchs for lines X[i]X[j] using the table of relevant lines in ETC.";


(* ::Input::Initialization::GrayLevel[0]:: *)
BuscarCentralLines[ptP_]:=Module[{i,sols},
sols={};
For[i=1,i<=Length[CentralLines],i++,
If[Factor[Factor[Det[Append[ETC[[CentralLines[[i,5,{1,2}]]]][[All,2]],ptP]] /.sustS]]==0,
sols=Append[sols,CentralLines[[i,5,{1,2}]]]
]
];
sols
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Traslacion::"usage"="Traslacion[ptP, {ptA, ptB}] devuelve el resultado de aplicar a P una traslaci\[OAcute]n mediante el vector AB.";


(* ::Input::Initialization:: *)
Traslacion[ptP_,{ptA_,ptB_}]:=SimetriaCentral[ptA,Medio[ptB,ptP]]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Homotecia::"usage"="Homotecia[ptP, ptO, k] devuelve el resultado de aplicar a P una homotecia de centro O y raz\[OAcute]n k.";


(* ::Input::Initialization:: *)
Homotecia[ptP_,ptO_,k_]:=DividirRazon[ptO,ptP,k,1-k]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Rotacion::"usage"="Rotacion[ptP, ptQ,\[Alpha]] devuelve el resultado de aplicar a P una rotaci\[OAcute]n con centro Q y \[AAcute]ngulo \[Alpha]";


(* ::Input::Initialization:: *)
Rotacion[ptP_,ptQ_,theta_]:=Module[{ptM},
ptM={-a^2,fSC+S Cot[theta],fSB+S Cot[(\[Pi]-theta)/2]};
Punto[
CuartaRecta[ptP,rtBC,Recta[ptB,ptM],Recta[ptP,ptQ]],
CuartaRecta[ptQ,rtBC,Recta[ptC,ptM],Recta[ptP,ptQ]]]]


(* ::Input::Initialization:: *)
SimetriaCentralRecta::"usage"=
"SimetriaCentralRecta[r,ptC] devuelve la recta sim\[EAcute]trica de r con respecto al punto C.\n
SimetriaCentral[ptP,ptQ,ptC] devuelve la recta sim\[EAcute]trica de PQ con respecto al punto C.";


(* ::Input::Initialization:: *)
SimetriaCentralRecta[{p_,q_,r_},{u_,v_,v_}]:=Simplificar[{p u-p v+2 q v-p w+2 r w,2 p u-q u+q v-q w+2 r w,2 p u-r u+2 q v-r v+r w};];


(* ::Input::Initialization:: *)
SimetriaCentralRecta[P_, Q_, R_] := SimetriaCentralRecta[Recta[P,Q], R];


(* ::Input::Initialization:: *)
RotacionRecta::"usage"=
"RotacionRecta[r,ptC,t] devuelve la imagen de la recta r por una rotaci\[OAcute]n de centro C y \[AAcute]ngulo t.";


(* ::Input::Initialization:: *)
RotacionRecta[{p_,q_,r_},{u_,v_,w_},t_]:=Simplificar[{(a-b-c) (a+b-c) (a-b+c) (a+b+c) (p u+q v+r w)+2 S (a^2 (-q v+p (v-w)+r w)+c^2 (q v+p (v+w)-r (2 v+w))-b^2 (r w+p (v+w)-q (v+2 w))-2 S (-q v-r w+p (v+w)+(p u+q v+r w) Cos[t]) Cot[t]) Csc[t],(a-b-c) (a+b-c) (a-b+c) (a+b+c) (p u+q v+r w)+2 S ((b^2 (p-q)-c^2 (p+q-2 r)) u+(b-c) (b+c) (q-r) w+a^2 (r w+q (u+w)-p (u+2 w))-2 S (-p u-r w+q (u+w)+(p u+q v+r w) Cos[t]) Cot[t]) Csc[t],(a-b-c) (a+b-c) (a-b+c) (a+b+c) (p u+q v+r w)+2 S ((c^2 (-p+r)+b^2 (p-2 q+r)) u-(b-c) (b+c) (q-r) v+a^2 (-q v-r (u+v)+p (u+2 v))-2 S (-p u-q v+r (u+v)+(p u+q v+r w) Cos[t]) Cot[t]) Csc[t]}];


(* ::Input::Initialization:: *)
RotacionRecta[P_, Q_, R_,t_] := RotacionRecta[Recta[P,Q], R,t];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PuntoFijoAfin::"usage"="PuntoFijoAfin[{ptA1, ptB1, ptC1},{ptA2, ptB2, ptC2}] devuelve el punto fijo de la aplicaci\[OAcute]n afin que transforma el tri\[AAcute]ngulo A1B1C1 en el tri\[AAcute]ngulo A2B2C2. (Angel Montesdeoca) Si la transformaci\[OAcute]n es una homolog\[IAcute]a, PuntoFijoAfin devuelve el centro y eje de la homolog\[IAcute]a.
Tambi\[EAcute]n se puede obtener con PuntoFijoAfin[ptQ] ";


(* ::Input::Initialization:: *)
PuntoFijoAfin[ptQ_]:=Module[{ptA1,ptB1,ptC1},
{ptA1,ptB1,ptC1}=Map[Sustituirxyz[ptQ,#]&,{ptA,ptB,ptC}];
PuntoFijoAfin[{ptA,ptB,ptC},{ptA1,ptB1,ptC1}]
]


(* ::Input::Initialization:: *)
PuntoFijoAfin[{ptA1_,ptB1_,ptC1_},{ptA2_,ptB2_,ptC2_}]:=Module[{ptD1,ptD2,aa,bb,cc,dd},If[Det[{Recta[ptA1,ptA2],Recta[ptB1,ptB2],Recta[ptC1,ptC2]}]===0&&Det[{Recta[ptA1,ptA2],Recta[ptB1,ptB2],{1,1,1}}]===0,{Punto[Recta[ptA1,ptA2],Recta[ptB1,ptB2]],Recta[Punto[Recta[ptA1,ptB1],Recta[ptA2,ptB2]],Punto[Recta[ptA1,ptC1],Recta[ptA2,ptC2]]]},ptD1=Punto[Paralela[ptA1,ptB1,ptC1],Paralela[ptC1,ptA1,ptB1]];
ptD2=Punto[Paralela[ptA2,ptB2,ptC2],Paralela[ptC2,ptA2,ptB2]];
aa=Punto[Recta[ptA1,ptB1],Recta[ptA2,ptB2]];
bb=Punto[Recta[ptB1,ptC1],Recta[ptB2,ptC2]];
cc=Punto[Recta[ptC1,ptD1],Recta[ptC2,ptD2]];
dd=Punto[Recta[ptD1,ptA1],Recta[ptD2,ptA2]];
Punto[Recta[aa,cc],Recta[bb,dd]]]
];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ImagenAfin::"usage"="ImagenAfin[{ptA1, ptB1, ptC1},{ptA2, ptB2, ptC2}, ptM] la imagen del punto M por la aplicaci\[OAcute]n afin que transforma el tri\[AAcute]ngulo A1B1C1 en el tri\[AAcute]ngulo A2B2C2";


(* ::Input::Initialization:: *)
ImagenAfin[{ptA1_,ptB1_,ptC1_},{ptA2_,ptB2_,ptC2_},ptM_]:=Module[{ptD1,ptD2,a,b,c,d,ptU,ptV},
ptD1=Punto[Paralela[ptA1,ptB1,ptC1],Paralela[ptC1,ptA1,ptB1]];
ptD2=Punto[Paralela[ptA2,ptB2,ptC2],Paralela[ptC2,ptA2,ptB2]];
a=Punto[Recta[ptA1,ptB1],Recta[ptA2,ptB2]];
b=Punto[Recta[ptB1,ptC1],Recta[ptB2,ptC2]];
c=Punto[Recta[ptC1,ptD1],Recta[ptC2,ptD2]];
d=Punto[Recta[ptD1,ptA1],Recta[ptD2,ptA2]];
ptU=Punto[Recta[a,c],Paralela[ptM,ptA1,ptB1]];
ptV=Punto[Recta[b,d],Paralela[ptM,ptA1,ptD1]];
Punto[
Paralela[ptU,ptA2,ptB2],
Paralela[ptV,ptA2,ptD2]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EscribirTexto::"usage" = "EscribirTexto[texto, pt, desp_] dibuja un texto en un punto con un desplazamiento.";


(* ::Input::Initialization:: *)
EscribirTexto[texto_,{x_,y_},{dx_,dy_}]:=
Text[Style[texto,FontFamily->"Times",FontSlant->"Italic",12],{x+dx,y+dy}];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Circulito::"usage" = "Circulito[centro,(Color,Size)] dibuja un circulito relleno que representa un punto.";


(* ::Input::Initialization:: *)
Circulito[centro_,OptionsPattern[{Color->Red,Size->0.01}]]:=
Module[{color,size},
color=OptionValue[Color];
size=OptionValue[Size];
{color,
Disk[centro,size],
RGBColor[0,0,0],
Circle[centro,size]}
];


(* ::Input::RGBColor[0., 0.5019607843137255, 0.]:: *)
GraficaPuntos::"usage"="GraficaPuntos[list] crea un gr\[AAcute]fico con una lista de puntos dados por sus coordenadas baric\[EAcute]ntricas.";


(* ::Input::Initialization:: *)
GraficaPuntos[pts_,OptionsPattern[{LabelSize->14,Labels->{},Positions->{},Size->0.04`,Color->Yellow}]]:=Module[{nl,np,cpts,cir,tbl,
labelsize=OptionValue[LabelSize],
positions=OptionValue[Positions],
labels=OptionValue[Labels],
size=OptionValue[Size],
color=OptionValue[Color]
},
nl=Length[labels];np=Length[positions];If[np==0,positions=Table[{1,1},{nl}],If[np==1,positions=Table[First[positions],{nl}]]];cpts=ListaPuntoBarCar[pts/. sustS/. sustH,cA,cB,cC];cir=(Circulito[#1,Color->color,Size->size]&)/@cpts;tbl=If[nl>0,Table[Text[labels[[i]],cpts[[i]],positions[[i]],BaseStyle->{labelsize,Black,FontFamily->"Times",Italic}],{i,1,nl}],{}];Graphics[{cir,tbl}]
]


(* ::Input::RGBColor[0., 0.5019607843137255, 0.]:: *)
GraficaSegmentos::"usage"="GraficaSegmentos[list] crea un gr\[AAcute]fico con una lista de segmentos dados por sus coordenadas baric\[EAcute]ntricas.";


(* ::Input::Initialization:: *)
GraficaSegmentos[segs_, OptionsPattern[{Size->{},Colors->{}}]]:=Module[{nsegs,csegs,gsegs,gr,nsizes,ncol,sizes=OptionValue[Size],colors=OptionValue[Colors]},
csegs=Map[ListaPuntoBarCar[#/. sustS/. sustH,cA,cB,cC]&,segs];
sizes=Map[If[NumericQ[#],Thickness[#],#]&,sizes];
{nsegs,nsizes,ncol}=Map[Length,{segs,sizes,colors}];
sizes=Which[
sizes=={},Table[Thickness[0.001],{nsegs}],
nsizes<nsegs,Table[First[sizes],{nsegs}],
True,sizes
];
colors=Which[
colors=={},Table[Black,{nsegs}],
ncol<nsegs,Table[First[colors],{nsegs}],
True,colors
];
gsegs=Map[Line[#]&,csegs];
gr=Table[{sizes[[i]],colors[[i]],gsegs[[i]]},{i,1,nsegs}];
Graphics[gr]
];


(* ::Input::RGBColor[0., 0.5019607843137255, 0.]:: *)
GraficaPoligono::"usage"="GraficaPoligono[list,opciones] crea un gr\[AAcute]fico de un pol\[IAcute]gono dado por sus v\[EAcute]rtices en coordenadas baric\[EAcute]ntricas.";


(* ::Input::Initialization:: *)
GraficaPoligono[poligono_,parametros_:{}]:=Module[{vertices,tipo,size,col1,col2,gr,closePoly},
closePoly[lis_]:=Join[lis,{First[lis]}];
vertices=ListaPuntoBarCar[poligono/. sustS/. sustH,cA,cB,cC];
(* tipo=0,1,2 : bordo, interno, bordo+interno *)
{tipo,size,col1,col2}=Which[
Length[parametros]!=4,{0,0.001,Black,LightYellow},
True,parametros
];
If[!MemberQ[{0,1,2},tipo],tipo=0];
If[!NumberQ[size],size=0.001];
If[!ColorQ[col1],col1=Black];
If[!ColorQ[col2],col2=LightYellow];
gr=Which[
tipo==0,{Thickness[size],col1,Line[closePoly[vertices]]},
tipo==1,{col2,Polygon[closePoly[vertices]]},
tipo==2,{col2,Polygon[closePoly[vertices]],Thickness[size],col1,Line[closePoly[vertices]]},
True,{Thickness[size],col1,Line[closePoly[vertices]]}
];
Graphics[gr]
];


(* ::Input::RGBColor[0., 0.5019607843137255, 0.]:: *)
GraficaRegion::"usage"="GraficaRegion[ecuacion,color] crea un gr\[AAcute]fico de una regi\[OAcute]n dada por su ecuaci\[OAcute]n.";


(* ::Input::Initialization:: *)
GraficaRegion[ecuacion_,fillcol_, OptionsPattern[{Interior->True}]]:=Module[{cartesianas,triangulo,vertices,etiquetas,grafica,interior1=OptionValue[Interior]},
triangulo=Graphics[{Blue,AbsoluteThickness[1.5`],Line[{cA,cB,cC,cA}]}];vertices=Graphics[(Circulito[#1,Color->Red,Size->0.05`]&)/@{cA,cB,cC}];
etiquetas=Graphics[{
EscribirTexto["A",cA,OffA],
EscribirTexto["B",cB,OffB],
EscribirTexto["C",cC,OffC]
}]; 
cartesianas=Cartesianas[ecuacion];
grafica=RegionPlot[If[interior1,cartesianas<0,cartesianas>0],{x,xmin,xmax},{y,ymin,ymax},Frame->None,PlotStyle->fillcol];Show[{grafica,triangulo,vertices,etiquetas},AspectRatio->Automatic]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
OffA::usage="OffA es el offset de la etiqueta del v\[EAcute]rtice A";
OffB::usage="OffB es el offset de la etiqueta del v\[EAcute]rtice B";
OffC::usage="OffC es el offset de la etiqueta del v\[EAcute]rtice C";


(* ::Input::Initialization:: *)
{OffA,OffB,OffC}={{0,.2},{-0.2,-0.2},{0.2,-0.15}};


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EscribirTexto::usage="EscribirTexto[texto,ptP,offset] escribe un texto en una posici\[OAcute]n con un offset determinado.";


(* ::Input::Initialization:: *)
GraficaBaricentricas[ecuacion_]:=Module[{cartesianas,triangulo, vertices, etiquetas,grafica},
triangulo=Graphics[{Blue,AbsoluteThickness[1.5],Line[{cA,cB,cC,cA}]}];
     vertices=Graphics[Map[Circulito[#,Color->Red,Size->0.05]&,{cA,cB,cC}]];
     etiquetas=Graphics[{
EscribirTexto["A",cA,OffA],
EscribirTexto["B",cB,OffB],
EscribirTexto["C",cC,OffC]
}]; 
cartesianas =Cartesianas[ecuacion];
grafica =ContourPlot[cartesianas==0,{x,xmin, xmax},{y,ymin,ymax},Frame->None,ContourStyle->Red];
Show[{triangulo,grafica,vertices,etiquetas},AspectRatio->Automatic]
]


(* ::Input::Initialization:: *)
GraficaBaricentricas[ecuacion_,opciones_]:=Module[{cartesianas,triangulo,vertices,etiquetas,grafica,args},triangulo=Graphics[{Blue,AbsoluteThickness[1.5`],Line[{cA,cB,cC,cA}]}];
vertices=Graphics[Map[Circulito[#,Color->Red,Size->0.05]&,{cA,cB,cC}]];
     etiquetas=Graphics[{
EscribirTexto["A",cA,OffA],
EscribirTexto["B",cB,OffB],
EscribirTexto["C",cC,OffC]
}]; 
cartesianas=Cartesianas[ecuacion];
If[Head[ecuacion!=List],ecuacion={ecuacion}];
args=Join[{Thread[cartesianas==Table[0,{Length[ecuacion]}]],{x,xmin,xmax},{y,ymin,ymax}},opciones];
grafica=ContourPlot@@args;
Show[{triangulo,grafica,vertices,etiquetas},AspectRatio->Automatic]
]


(* ::Input::Initialization:: *)
trVarsSubs::"usage" = "Regla de sustituci\[OAcute]n para variables utilizadas en la geometr\[IAcute]a del tri\[AAcute]ngulo";
trVarsSubs={Sin[A/2]->Sqrt[(a+b-c)*(a-b+c)/(4*b*c)],Sin[B/2]->Sqrt[(a+b-c)*(-a+b+c)/(4*a*c)],Sin[C/2]->Sqrt[(-a+b+c)*(a-b+c)/(4*a*b)],
Cos[A/2]->Sqrt[(-a+b+c)*(a+b+c)/(4*b*c)],Cos[B/2]->Sqrt[(a-b+c)*(a+b+c)/(4*a*c)],Cos[C/2]->Sqrt[(a+b-c)*(a+b+c)/(4*a*b)],
Tan[A/2]->Sqrt[(a-b+c)*(a+b-c)/((a+b+c)(-a+b+c))],Tan[B/2]->Sqrt[(a+b-c)*(-a+b+c)/((a-b+c)(a+b+c))],Tan[C/2]->Sqrt[(a-b+c)*(-a+b+c)/((a+b+c)(a+b-c))],
Sin[A]->a/(2*R),Sin[B]->b/(2*R),Sin[C]->c/(2*R),Cos[A]->(-a^2+b^2+c^2)/(2*b*c),Cos[B]->(a^2-b^2+c^2)/(2*c*a),Cos[C]->(a^2+b^2-c^2)/(2*a*b),
Tan[A]->4\[CapitalDelta]/(b^2+c^2-a^2),Tan[B]->4\[CapitalDelta]/(a^2-b^2+c^2),Tan[C]->4\[CapitalDelta]/(a^2+b^2-c^2),
Cot[A]->(b^2+c^2-a^2)/(4\[CapitalDelta]),Cot[B]->(a^2-b^2+c^2)/(4\[CapitalDelta]),Cot[C]->(a^2+b^2-c^2)/(4\[CapitalDelta]),
A->ArcCos[(-a^2+b^2+c^2)/(2*b*c)],B->ArcCos[(a^2-b^2+c^2)/(2*c*a)],C->ArcCos[(a^2+b^2-c^2)/(2*a*b)],
SA->(b^2+c^2-a^2)/2,SB->(c^2+a^2-b^2)/2,SC->(a^2+b^2-c^2)/2,
\[Omega]->omega,W->omega,omega->ArcTan[S/SW],J->OH/R,OH->Sqrt[9*R^2-2*SW],SW->(a^2+b^2+c^2)/2,
e-> Sqrt[(-3*S^2+SW^2)/(SW^2+S^2)],\[Tau]-> Sqrt[3/2+Sqrt[5]/2],
R->a*b*c/(4*Delta),r->Delta/s,s->(a+b+c)/2,S->2*Delta,
sa->(-a+b+c)/2,sb->(a-b+c)/2,sc->(a+b-c)/2,\[CapitalDelta]->Delta,
Delta->Sqrt[(a+b+c)*(-a+b+c)*(a-b+c)*(a+b-c)]/4,Delta->S/2};


(* ::Input::Initialization:: *)
PolynomialToRrp::"usage"=
"PolynomialToRrp[expr] convierte una expresi\[OAcute]n (polin\[OAcute]mica) sim\[EAcute]trica a, b, c en t\[EAcute]rminos de R, r y p.";


(* ::Input::Initialization:: *)
PolynomialToRrp[expr_]:=If[SymmetricReduction[expr,{a,b,c}][[2]]===0,
Factor[SymmetricReduction[expr,{a,b,c},{2 p,p^2+r^2+4 R r,4 R r p}][[1]]],expr]


(* ::Input::Initialization:: *)
RationalToRrp::"usage"=
"RationalToRrp[expr] convierte una expresi\[OAcute]n (racional) sim\[EAcute]trica a, b, c en t\[EAcute]rminos de R, r y p.";


(* ::Input::Initialization:: *)
RationalToRrp[expr_]:=Factor[PolynomialToRrp[Numerator[Factor[expr]]]/PolynomialToRrp[Denominator[Factor[expr]]]]


(* ::Input::Initialization:: *)
ToRrp::usage =
"ToRrp[expr] convierte una expresi\[OAcute]n en a,b,c en t\[EAcute]rminos de R,r y p.
ToRrp[expr] puede convertir las expresiones formadas por una parte racional sim\[EAcute]trica R(a, b, c) y por uno o m\[AAcute]s sumandos de tipo \!\(\*SqrtBox[\(f \((a, \\\ b, \\\ c)\)\)]\) y g(a,b,c)\!\(\*SqrtBox[\(h\\\  \((a, b, c)\)\)]\), donde f, g son funciones racionales sim\[EAcute]tricas en a, b, c";


(* ::Input::Initialization:: *)
ToRrp[expr_]:=Module[{racional,irracional,expr1,expr2},
racional=expr/.(x_^y_/;Head[y]===Rational)->0;
irracional=Factor[expr-racional];
expr1=RationalToRrp[racional];
expr2=irracional/.(Power[b_,n_]/;Head[n]===Rational) :>Power[RationalToRrp[b],n] ;
expr2=expr2/.( a_ Power[b_,n_]/;Head[n]===Rational&&(Head[a]==Symbol||Head[a]==Plus||Head[a]==Times)) :>RationalToRrp[a]Power[RationalToRrp[b],n];
FullSimplify[PowerExpand[expr1+expr2],{p>0,R>0,r>0}]
]


(* ::Input::Initialization:: *)
sustLados::usage ="sustLados is a list of replacement rules for A, B, C, \[Omega], r, R, etc. in terms of side lengths a,b,c";


(* ::Input::Initialization:: *)
sustLados=Join[
{S-> 2Sqrt[s(s-a)(s-b)(s-c)],\[CapitalDelta]->Sqrt[s(s-a)(s-b)(s-c)],
w->ArcCot[(a^2+b^2+c^2)/Sqrt[(a+b-c)(a-b+c)(-a+b+c)(a+b+c)]],
R->(a b c)/Sqrt[(a+b-c)(a-b+c)(-a+b+c)(a+b+c)],
r->1/2 Sqrt[((a+b-c)(a-b+c)(-a+b+c))/(a+b+c)],
ra->Sqrt[s(s-a)(s-b)(s-c)]/(s-a),rb->Sqrt[s(s-a)(s-b)(s-c)]/(s-b),rc->Sqrt[s(s-a)(s-b)(s-c)]/(s-c),
ma->1/2 Sqrt[2b^2+2c^2-a^2],mb->1/2 Sqrt[2a^2+2c^2-b^2],mc->1/2 Sqrt[2a^2+2b^2-c^2],
ha->(2Sqrt[s(s-a)(s-b)(s-c)])/a,hb->(2Sqrt[s(s-a)(s-b)(s-c)])/b,hc->(2Sqrt[s(s-a)(s-b)(s-c)])/c,
wa->Sqrt[b c (-a+b+c) (a+b+c)]/(b+c),wb->Sqrt[a c (a-b+c) (a+b+c)]/(a+c),wc->Sqrt[a b (a+b-c) (a+b+c)]/(a+b),
va->Sqrt[b c (a-b+c) (a+b-c)]/Abs[b-c],vb->Sqrt[a c (-a+b+c) (a+b-c)]/Abs[a-c],vc->Sqrt[a b (-a+b+c) (a-b+c)]/Abs[a-b],
p->(a+b+c)/2,sa->fSA,sb->fSB,sc->fSC,sw->fSW},
MapThread[#1->#2&,Transpose[Flatten[Map[TernaCiclica,
{{ Sin[A],(2Sqrt[s(s-a)(s-b)(s-c)])/(b c)},{Cos[A],(b^2+c^2-a^2)/(2b c)},{Tan[A],(4Sqrt[s(s-a)(s-b)(s-c)])/(b^2+c^2-a^2)},{Cot[A],(b^2+c^2-a^2)/(4Sqrt[s(s-a)(s-b)(s-c)])},
{Sec[A],(2 b c)/(b^2+c^2-a^2)},{Csc[A],(b c)/(2Sqrt[s(s-a)(s-b)(s-c)])},
{Cos[A/2],Sqrt[(s(s-a))/(b c)]},{Sin[A/2],Sqrt[((s-b)(s-c))/(b c)]},{Tan[A/2],Sqrt[((s-b)(s-c))/(s(s-a))]},{Cot[A/2],Sqrt[(s(s-a))/((s-b)(s-c))]},
{Cot[w],(a^2+b^2+c^2)/(4Sqrt[s(s-a)(s-b)(s-c)])},{Tan[w],( 4Sqrt[s(s-a)(s-b)(s-c)])/(a^2+b^2+c^2)},
{ (Sin^n_)[A],((2Sqrt[s(s-a)(s-b)(s-c)])/(b c))^n},{(Cos^n_)[A],((b^2+c^2-a^2)/(2b c))^n},{(Tan^n_)[A],((4Sqrt[s(s-a)(s-b)(s-c)])/(b^2+c^2-a^2))^n},{(Cot^n_)[A],((b^2+c^2-a^2)/(4Sqrt[s(s-a)(s-b)(s-c)]))^n},
{(Sec^n_)[A],((2 b c)/(b^2+c^2-a^2))^n},{(Csc^n_)[A],((b c)/S)^n},
{(Cos^n_)[A/2],((s(s-a))/(b c))^Quotient[n,2] (Sqrt[(s(s-a))/(b c)])^Mod[n,2]},{(Sin^n_)[A/2],(((s-b)(s-c))/(b c))^Quotient[n,2] (Sqrt[((s-b)(s-c))/(b c)])^Mod[n,2]},
{(Tan^n_)[A/2],(((s-b)(s-c))/(s(s-a)))^Quotient[n,2] (Sqrt[((s-b)(s-c))/(s(s-a))])^Mod[n,2]},{(Cot^n_)[A/2],((s(s-a))/((s-b)(s-c)))^Quotient[n,2] (Sqrt[(s(s-a))/((s-b)(s-c))])^Mod[n,2]}}
],1]]]
];


(* ::Input::Initialization:: *)
ToLados::usage =
"ToLados[expr] Devuelve una expresi\[OAcute]n equivalente en el que los \[AAcute]ngulos A, B, y C son expresado en t\[EAcute]rminos de longitudes de lados a, b, y c usando la ley de
cosenos.";


(* ::Input::Initialization:: *)
ToLados[expr_]:=Factor[FullSimplify[PowerExpand[Refine[expr/.sustLados,{a,b,c}\[Element]Reals] ]]]



(* ::Input::Initialization:: *)
sustAngulos::usage =
"sustAngulos applies various transformations to attempt to replace expressions in terms of the sidelengths a, b, and c with simpler combinations of trig functions of angles A, B, and C.";


(* ::Input::Initialization:: *)
sustAngulos=MapThread[#1->#2&,Transpose[Flatten[Map[TernaCiclica,
{{( b^2+c^2-a^2), (2 b c Cos[A])},{-(b^2+c^2-a^2), -(2 b c Cos[A])},
{( b^2+c^2-a^2)^n_, (2 b c Cos[A])^n},{-(b^2+c^2-a^2)^n_, -(2 b c Cos[A])^n},
{(-a^2+b^2+c^2)Sqrt[(a+b-c) (a-b+c) (-a+b+c) (a+b+c)] ,2 b^2 c^2 Sin[2A]},
{(-a^2+b^2+c^2)Sqrt[-(a-b-c) (a+b-c) (a-b+c) (a+b+c)] ,2 b^2 c^2 Sin[2A]},
{(-a^2+b^2+c^2)Sqrt[-a^4+2 a^2 b^2-b^4+2 a^2 c^2+2 b^2 c^2-c^4] ,2 b^2 c^2 Sin[2A]},
{-(-a^2+b^2+c^2) Sqrt[(a+b-c) (a-b+c) (-a+b+c) (a+b+c)] ,-2 b^2 c^2 Sin[2A]},
{-(-a^2+b^2+c^2) Sqrt[-(a-b-c) (a+b-c) (a-b+c) (a+b+c)] ,-2 b^2 c^2 Sin[2A]},
{-(-a^2+b^2+c^2) Sqrt[-a^4+2 a^2 b^2-b^4+2 a^2 c^2+2 b^2 c^2-c^4] ,-2 b^2 c^2 Sin[2A]},
{a^4-2 a^2 b^2+b^4-2 a^2 c^2+c^4,2 b^2 c^2 Cos[2A]},
{-a^4+2 a^2 b^2-b^4+2 a^2 c^2-c^4,-2 b^2 c^2 Cos[2A]},
{-(((-a+b-c) (a+b-c))/(4 b c)),(Sin^2)[A/2]},
{((a+b-c) (a-b+c))/(4 b c),(Sin^2)[A/2]},
{((a+b-c) (a-b+c) (a+b+c))/(8a b c), Sin[A/2]Cos[B/2]Cos[C/2]},
{(-(a+b-c) (a-b+c) (a+b+c))/(8 a b c),-Sin[A/2]Cos[B/2]Cos[C/2]},
{((a + b - c) (a - b + c) (-a + b + c))/(8a b c),Sin[A/2]Sin[B/2]Sin[C/2]},
{((a-b-c) (a+b-c) (a-b+c))/(8a b c),-Sin[A/2]Sin[B/2]Sin[C/2]},
{(a+b+c)Sqrt[(a+b-c) (a-b+c) (-a+b+c)(a+b+c)],8a b c Cos[A/2]Cos[B/2]Cos[C/2]},
{(a+b+c)Sqrt[-(a-b-c) (a+b-c) (a-b+c) (a+b+c)],8a b c Cos[A/2]Cos[B/2]Cos[C/2]},
{-(a+b+c) Sqrt[(a+b-c) (a-b+c) (-a+b+c)(a+b+c)],-8a b c Cos[A/2]Cos[B/2]Cos[C/2]},
{-(a+b+c) Sqrt[-(a-b-c) (a+b-c) (a-b+c) (a+b+c)],-8a b c Cos[A/2]Cos[B/2]Cos[C/2]},
{(a+b+c)Sqrt[-a^4+2 a^2 b^2-b^4+2 a^2 c^2+2 b^2 c^2-c^4],8a b c Cos[A/2]Cos[B/2]Cos[C/2]},
{-(a+b+c) Sqrt[-a^4+2 a^2 b^2-b^4+2 a^2 c^2+2 b^2 c^2-c^4],-8a b c Cos[A/2]Cos[B/2]Cos[C/2]},
{a^3+a^2 b-a b^2-b^3+a^2 c+2 a b c+b^2 c-a c^2+b c^2-c^3,8a b c  Sin[A/2]Cos[B/2]Cos[C/2]},
{-a^3-a^2 b+a b^2+b^3-a^2 c-2 a b c-b^2 c+a c^2-b c^2+c^3,-8a b c  Sin[A/2]Cos[B/2]Cos[C/2]},
{(a+b-c) Sqrt[(a+b-c)(a-b+c) (-a+b+c) (a+b+c)],8a b c  Sin[A/2]Sin[B/2]Cos[C/2]},
{(a+b-c) Sqrt[-(a-b-c) (a+b-c) (a-b+c) (a+b+c)],8a b c  Sin[A/2]Sin[B/2]Cos[C/2]},
{(a+b-c) Sqrt[-a^4+2 a^2 b^2-b^4+2 a^2 c^2+2 b^2 c^2-c^4],8a b c  Sin[A/2]Sin[B/2]Cos[C/2]},
{-(a+b-c) Sqrt[(a+b-c)(a-b+c) (-a+b+c) (a+b+c)],-8a b c  Sin[A/2]Sin[B/2]Cos[C/2]},
{-(a+b-c) Sqrt[-(a-b-c) (a+b-c) (a-b+c) (a+b+c)],-8a b c  Sin[A/2]Sin[B/2]Cos[C/2]},
{-(a+b-c) Sqrt[-a^4+2 a^2 b^2-b^4+2 a^2 c^2+2 b^2 c^2-c^4],-8a b c  Sin[A/2]Sin[B/2]Cos[C/2]},
{(a-b-c) (a+b-c) (a-b+c) (a+b+c)^3,-64 a^2 b^2 c^2 (Cos^2)[A/2](Cos^2)[B/2](Cos^2)[C/2]},
{-(a-b-c) (a+b-c) (a-b+c) (a+b+c)^3,64 a^2 b^2 c^2 (Cos^2)[A/2](Cos^2)[B/2](Cos^2)[C/2]},
{(a-b-c)^2 (a+b-c)^2 (a-b+c)^2,64 a^2 b^2 c^2 (Sin^2)[A/2](Sin^2)[B/2](Sin^2)[C/2]},
{-(a-b-c)^2 (a+b-c)^2 (a-b+c)^2,-64 a^2 b^2 c^2 (Sin^2)[A/2](Sin^2)[B/2](Sin^2)[C/2]},
{(a+b-c)^2 (a-b+c)^2 (a+b+c)^2,64 a^2 b^2 c^2 (Sin^2)[A/2](Cos^2)[B/2](Cos^2)[C/2]},
{-(a+b-c)^2 (a-b+c)^2 (a+b+c)^2,-64 a^2 b^2 c^2 (Sin^2)[A/2](Cos^2)[B/2](Cos^2)[C/2]},
{(a-b-c) (a+b-c)^3 (a-b+c) (a+b+c),-64 a^2 b^2 c^2 (Sin^2)[A/2](Sin^2)[B/2](Cos^2)[C/2]},
{-(a-b-c) (a+b-c)^3 (a-b+c) (a+b+c),64 a^2 b^2 c^2 (Sin^2)[A/2](Sin^2)[B/2](Cos^2)[C/2]},
{-a^4-b^4-c^4+2b^2 a^2+2c^2 a^2+2b^2 c^2,2a b c Sin[A/2]Sin[B/2]Sin[C/2]},
{a^4+b^4+c^4-2b^2 a^2-2c^2 a^2-2b^2 c^2,-2a b c Sin[A/2]Sin[B/2]Sin[C/2]},
{(a+b+c) Sqrt[(a+b-c) (a-b+c) (-a+b+c) (a+b+c)],2a b c(Sin[A]+Sin[B]+Sin[C])},
{(a+b+c) Sqrt[-(a-b-c) (a+b-c) (a-b+c) (a+b+c)],2a b c(Sin[A]+Sin[B]+Sin[C])},
{(a+b+c) Sqrt[-a^4+2 a^2 b^2-b^4+2 a^2 c^2+2 b^2 c^2-c^4],2a b c(Sin[A]+Sin[B]+Sin[C])},
{-(a+b+c) Sqrt[(a+b-c) (a-b+c) (-a+b+c) (a+b+c)],-2a b c(Sin[A]+Sin[B]+Sin[C])},
{-(a+b+c) Sqrt[-(a-b-c) (a+b-c) (a-b+c) (a+b+c)],-2a b c(Sin[A]+Sin[B]+Sin[C])},
{-(a+b+c) Sqrt[-a^4+2 a^2 b^2-b^4+2 a^2 c^2+2 b^2 c^2-c^4],-2a b c(Sin[A]+Sin[B]+Sin[C])},
{(-a+b+c) Sqrt[(a+b-c) (a-b+c) (-a+b+c) (a+b+c)],2a b c(- Sin[A]+Sin[B]+Sin[C])},
{(-a+b+c) Sqrt[-(a-b-c) (a+b-c) (a-b+c) (a+b+c)],2a b c(- Sin[A]+Sin[B]+Sin[C])},
{(-a+b+c) Sqrt[-a^4+2 a^2 b^2-b^4+2 a^2 c^2+2 b^2 c^2-c^4],2a b c(- Sin[A]+Sin[B]+Sin[C])},
{-(-a+b+c) Sqrt[(a+b-c) (a-b+c) (-a+b+c) (a+b+c)],-2a b c(- Sin[A]+Sin[B]+Sin[C])},
{-(-a+b+c) Sqrt[-(a-b-c) (a+b-c) (a-b+c) (a+b+c)],-2a b c(- Sin[A]+Sin[B]+Sin[C])},
{-(-a+b+c) Sqrt[-a^4+2 a^2 b^2-b^4+2 a^2 c^2+2 b^2 c^2-c^4],-2a b c(- Sin[A]+Sin[B]+Sin[C])},
{(a-b+c) Sqrt[(a+b-c) (a-b+c) (-a+b+c) (a+b+c)],2a b c( Sin[A]-Sin[B]+Sin[C])},
{(a-b+c) Sqrt[-(a-b-c) (a+b-c) (a-b+c) (a+b+c)],2a b c( Sin[A]-Sin[B]+Sin[C])},
{(a-b+c) Sqrt[-a^4+2 a^2 b^2-b^4+2 a^2 c^2+2 b^2 c^2-c^4],2a b c( Sin[A]-Sin[B]+Sin[C])},
{-(a-b+c) Sqrt[(a+b-c) (a-b+c) (-a+b+c) (a+b+c)],-2a b c( Sin[A]-Sin[B]+Sin[C])},
{-(a-b+c) Sqrt[-(a-b-c) (a+b-c) (a-b+c) (a+b+c)],-2a b c( Sin[A]-Sin[B]+Sin[C])},
{-(a-b+c) Sqrt[-a^4+2 a^2 b^2-b^4+2 a^2 c^2+2 b^2 c^2-c^4],-2a b c( Sin[A]-Sin[B]+Sin[C])},
{(a+b-c) Sqrt[(a+b-c)(a-b+c) (-a+b+c) (a+b+c)],2a b c(Sin[A]+Sin[B]-Sin[C])},
{(a+b-c) Sqrt[-(a-b-c) (a+b-c) (a-b+c) (a+b+c)],2a b c(Sin[A]+Sin[B]-Sin[C])},
{(a+b-c) Sqrt[-a^4+2 a^2 b^2-b^4+2 a^2 c^2+2 b^2 c^2-c^4],2a b c(Sin[A]+Sin[B]-Sin[C])},
{-(a+b-c) Sqrt[(a+b-c)(a-b+c) (-a+b+c) (a+b+c)],-2a b c(Sin[A]+Sin[B]-Sin[C])},
{-(a+b-c) Sqrt[-(a-b-c) (a+b-c) (a-b+c) (a+b+c)],-2a b c(Sin[A]+Sin[B]-Sin[C])},
{-(a+b-c) Sqrt[-a^4+2 a^2 b^2-b^4+2 a^2 c^2+2 b^2 c^2-c^4],-2a b c(Sin[A]+Sin[B]-Sin[C])},
{-a^3+a^2 b+a b^2-b^3+a^2 c+b^2 c+a c^2+b c^2-c^3,2a b c(Cos[A]+Cos[B]+Cos[C])},
{a^3-a^2 b-a b^2+b^3-a^2 c-b^2 c-a c^2-b c^2+c^3,-2a b c(Cos[A]+Cos[B]+Cos[C])},
{ a^3 + a^2 b - a b^2 - b^3 + a^2 c + b^2 c - a c^2 + b c^2 - c^3, 2a b c(-Cos[A]+Cos[B]+Cos[C])},
{ a^3 + a^2 b - a b^2 -  b^3 + a^2 c + b^2 c - a c^2 + b c^2 -  c^3, -2a b c(-Cos[A]+Cos[B]+Cos[C])},
{-a^3 - a^2 b +a b^2 + b^3 + a^2 c  + b^2 c + a c^2 - b c^2 -  c^3, 2a b c(Cos[A]-Cos[B]+Cos[C])},
{-a^3 - a^2 b + a b^2 +  b^3 + a^2 c + b^2 c + a c^2 -b c^2 -  c^3, -2a b c(Cos[A]-Cos[B]+Cos[C])},
{-a^3 + a^2 b + a b^2 -  b^3 - a^2 c  - b^2 c +a c^2 + b c^2 +  c^3, 2a b c(Cos[A]+Cos[B]-Cos[C])},
{-a^3 + a^2 b + a b^2 -  b^3 - a^2 c - b^2 c + a c^2 + b c^2 +  c^3, -2a b c(Cos[A]+Cos[B]-Cos[C])},
{ a^4 - 2 a^2 b^2 + b^4 - a^2 c^2 - b^2 c^2,-(2a b c^2)Cos[A-B]},
{-a^4 +  2 a^2 b^2 - b^4 + a^2 c^2 + b^2 c^2, (2a b c^2)Cos[A-B]},
{ a^4 +   a^2 b^2 - 2b^4 + a^2 c^2 + 4b^2 c^2 - 2c^4, 2a^2 b c(2Cos[B-C]-Cos[A])},
{-a^4 -  a^2 b^2 + 2b^4 - a^2 c^2 - 4b^2 c^2 + 2c^4,-2 a^2 b c(2Cos[B-C]-Cos[A])},
{-2 a^4 + a^2 b^2 + b^4 + a^2 c^2 - 2b^2 c^2 + c^4, 2 a^2 b c(Cos[A]-2 Cos[B] Cos[C])},
{2a^4 - a^2 b^2 - b^4 - a^2 c^2 + 2b^2 c^2 - c^4, -2 a^2 b c(Cos[A]-2 Cos[B] Cos[C])},
{a^4 - 2a^2 b^2 + b^4 - 2a^2 c^2 + c^4, 2b^2 c^2 Cos[2A]},
{-a^4 + 2a^2 b^2 - b^4 + 2a^2 c^2 - c^4, -2 b^2 c^2 Cos[2A]},
{a^4-b^4+2a^2 b c+2b^2 c^2-c^4,2a^2 b c(1+2Cos[B]Cos[C])},
{-a^4 + b^4 - 2a^2 b c - 2b^2 c^2 + c^4,-2 a^2 b c(1+2Cos[B]Cos[C])},
{-3 a^4 + 2a^2 b^2 + b^4 + 2a^2 c^2 - 2b^2 c^2 + c^4,a(Cos[A]-Cos[B]Cos[C])}, 
{ 3a^4 - 2a^2 b^2 - b^4 - 2a^2 c^2 + 2b^2 c^2 - c^4,a(-Cos[A]+Cos[B]Cos[C])},
{ a^6-a^4 b^2-a^2 b^4+b^6-a^4 c^2+a^2 b^2 c^2-b^4 c^2-a^2 c^4-b^2 c^4+c^6,-a^2 b^2 c^2 (1+8Cos[A]Cos[B]Cos[C])},
{-a^6+a^4 b^2+a^2 b^4-b^6+a^4 c^2-a^2 b^2 c^2+b^4 c^2+a^2 c^4+b^2 c^4-c^6, a^2 b^2 c^2 (1+8Cos[A]Cos[B]Cos[C])},
{-a^6+3a^4 b^2-3a^2 b^4+b^6+3a^4 c^2+2a^2 b^2 c^2-b^4 c^2-3a^2 c^4-b^2 c^4+c^6, 4a^2 b^2 c^2 (-(Cos^2)[A]+Cos[B]^2+(Cos^2)[C])},
{ a^6-3a^4 b^2+3a^2 b^4-b^6-3a^4 c^2-2a^2 b^2 c^2+b^4 c^2+3a^2 c^4+b^2 c^4-c^6, 4a^2 b^2 c^2 ( (Cos^2)[A]-(Cos^2)[B]-(Cos^2)[C])},
{-a^8+2a^6 b^2-2a^2 b^6+b^8+2a^6 c^2-2b^6 c^2+2 b^4 c^4-2a^2 c^6-2b^2 c^6+c^8,2a^2 b^2 c^2 (-a^2Cos[2A]+b^2 Cos[2B]+c^2 Cos[2C])},
{a^8-2a^6 b^2+2a^2 b^6-b^8-2a^6 c^2+2b^6 c^2-2 b^4 c^4+2a^2 c^6+2b^2 c^6-c^8,2a^2 b^2 c^2 (a^2 Cos[2A]-b^2 Cos[2B]-c^2 Cos[2C])},
{a^2+b^2+c^2,2S Cot[\[Omega]]},
{(a^2+b^2+c^2)/Sqrt[(a+b-c) (a-b+c) (-a+b+c) (a+b+c)],Cot[\[Omega]]},
{(a^2+b^2+c^2)/Sqrt[-(a-b-c) (a+b-c) (a-b+c) (a+b+c)],Cot[\[Omega]]},
{ Sqrt[((a+b-c) (a-b+c) (-a+b+c) (a+b+c))/(b^2 c^2+a^2 (b^2+c^2))],2Sin[\[Omega]]},
{ Sqrt[-(((a-b-c) (a+b-c) (a-b+c) (a+b+c))/(b^2 c^2+a^2 (b^2+c^2)))],2Sin[\[Omega]]},
{(a^2+b^2+c^2)/ Sqrt[b^2 c^2+a^2 b^2+a^2 c^2],2Cos[\[Omega]]}
}
],1]]];


(* ::Input::Initialization:: *)
ToAngulos::"usage"=
"ToAngulos[expr] intenta convertir una expresi\[OAcute]n en t\[EAcute]rminos de a,b,c en otra en t\[EAcute]rminos de A, B, C.";


(* ::Input::Initialization:: *)
ToAngulos[expr_]:=FullSimplify[expr/.sustAngulos]


(* ::Input::Initialization:: *)
PolynomialToRSABCW::"usage"=
"PolynomialToRSABCW[expr] convierte una expresi\[OAcute]n (polin\[OAcute]mica) en t\[EAcute]rminos de R, S, SA, SB, SC, SW.";


(* ::Input::Initialization:: *)
PolynomialToRSABCW[expr_]:=Module[{f},
f=AlgSubs[expr,{a^2==SB+SC,b^2==SC+SA,c^2==SA+SB},{a,b,c}];
f=AlgSubs[f,{a b c==2S R,a b+b c+c a==2p^2-SW},{a,b,c}];
f=AlgSubs[f,{p^2-r^2-4R r==SW},{r,R,p}];
Factor[AlgSubs[f,{SB^2+SC^2==SW^2-2*S^2-SA^2,SB+SC==-SA+SW,SA*SB*SC==S^2*(SW-4*R^2)},{SA,SB,SC}]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
ToRSABCW::"usage"=
"ToRSABCW[expr] convierte una expresi\[OAcute]n (racional) en t\[EAcute]rminos de R, S, SA, SB, SC, SW.";


(* ::Input::Initialization:: *)
ToRSABCW[expr_]:=Factor[PolynomialToRSABCW[Numerator[Factor[expr]]]/PolynomialToRSABCW[Denominator[Factor[expr]]]]


(* ::Input::Initialization:: *)
ToRSABCW2::"usage"=
"ToRSABCW2[expr] convierte una expresi\[OAcute]n (racional) en t\[EAcute]rminos de R, S, SA, SB, SC, SW.";


(* ::Input::Initialization:: *)
(* ---------- da revisionare ---------- *)
ToRSABCW2[expr_]:=Module[{res},
res=Map[ToRSABCW,expr];
res=Map[Collect[#,S]&,res];
res=StandardForm[TraditionalForm[res,ParameterVariables:>{a,b,c,SA,SB,SC,SW,p,R,r}]]
]


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
PolynomialToSASBSC::"usage"="PolynomialToSASBSC[expr] devuelve el polinomio expr in t\[EAcute]rminos de SA, SB, SC."
ToSASBSC::"usage"="ToSASBSC[expr] devuelve expr in t\[EAcute]rminos de SA, SB, SC."


(* ::Input::Initialization:: *)
PolynomialToSASBSC[expr_] := Expand[expr] /. sustSASBSC; 


(* ::Input::Initialization:: *)
ToSASBSC[expr_]:=Factor[PolynomialToSASBSC[Numerator[expr]]/PolynomialToSASBSC[Denominator[expr]]];


(* ::Input::Initialization:: *)
PolynomialToSASBSCSW::"usage" = "PolynomialToSASBSC[expr] returns expr in terms of SA, SB, SC, SW.";


(* ::Input::Initialization:: *)
PolynomialToSASBSCSW[expr_]:=Module[{q,r},{q,r}=SymmetricReduction[Expand[expr]/.sustSASBSC,{sa,sb,sc}]/.{sa sb+sa sc+sb sc->S^2,sa+sb+sc->sw};Factor[q+r]];


(* ::Input::Initialization:: *)
ToSASBSCSW::"usage" = "ToSASBSC[expr] returns expr in terms of SA, SB, SC, SW.";


(* ::Input::Initialization:: *)
ToSASBSCSW[expr_]:=Factor[PolynomialToSASBSCSW[Numerator[expr]]/PolynomialToSASBSCSW[Denominator[expr]]];


(* ::Input::Initialization:: *)
PolynomialToRS2SW::"usage" = "PolynomialToRS2SW[expr] returns expr in terms of R, S2, SW.";


(* ::Input::Initialization:: *)
PolynomialToRS2SW[expr_]:=Module[{q,r},{q,r}=SymmetricReduction[Expand[expr]/.sustSASBSC,{SA,SB,SC}]/.{SA SB+SA SC+SB SC->S^2,SA+SB+SC->SW,SA SB SC->S^2 SW-4S^2 R^2};Factor[q+r]];


(* ::Input::Initialization:: *)
ToRS2SW::"usage" = "ToRS2SW[expr] returns expr in terms of R, S2, SW.";


(* ::Input::Initialization:: *)
ToRS2SW[expr_]:=Factor[PolynomialToRS2SW[Numerator[expr]]/PolynomialToRS2SW[Denominator[expr]]];


(* ::Input::Initialization:: *)
PolynomialToRS2J::"usage" = "PolynomialToRS2J[expr] returns expr in terms of R, S2, J=|OH|/R";


(* ::Input::Initialization:: *)
PolynomialToRS2J[expr_]:=Module[{q,r},{q,r}=SymmetricReduction[Expand[expr]/.sustSASBSC,{sa,sb,sc}]/.{sa sb+sa sc+sb sc->S^2,sa+sb+sc->1/2 (9-J^2)R^2,sa sb sc->1/2 R^2 S^2 (1-J^2)};Factor[q+r]];


(* ::Input::Initialization:: *)
ToRS2J::"usage" = "ToRS2J[expr] returns expr in terms of R, S2, J=|OH|/R";


(* ::Input::Initialization:: *)
ToRS2J[expr_]:=Factor[PolynomialToRS2J[Numerator[expr]]/PolynomialToRS2J[Denominator[expr]]];


(* ::Input::Initialization:: *)
ToPolinomioSinA2CosBC2::"usage" = "ToPolinomioSinA2CosBC2[expr] convierte una expresi\[OAcute]n polin\[OAcute]mica f(a,b,c) en una expresi\[OAcute]n en p=Sin[A/2] y q=Cos[(B-C)/2].\n
Obtenemos una expresi\[OAcute]n polin\[OAcute]mica en p y q si en cada monomio de f(a,b,c) la variable a tiene un exponente par y las variables b, c tienen los mismos exponentes.";


(* ::Input::Initialization:: *)
ToPolinomioSinA2CosBC2[expr_]:=Module[{sust1,sust2,expr1,expr2},
sust1={Sin[A]->2 p Sqrt[1-p^2],Sin[B]->Sqrt[1-p^2] q+p Sqrt[1-q^2],Sin[C]->Sqrt[1-p^2] q-p Sqrt[1-q^2]};
sust2={Sin[A]^n_->(2 p Sqrt[1-p^2])^n,Sin[B]^n_->(Sqrt[1-p^2] q+p Sqrt[1-q^2])^n,Sin[C]^n_->(Sqrt[1-p^2] q-p Sqrt[1-q^2])^n};
expr1=Factor[expr/.{a->2R Sin[A],b->2R Sin[B],c->2R Sin[C]}];
expr2=Factor[expr1/.Join[sust1,sust2]]
];


(* ::Input::Initialization:: *)
ToCocienteSinA2CosBC2::"usage" = "ToCocienteSinA2CosBC2[expr] convierte una expresi\[OAcute]n en a, b, c en una expresi\[OAcute]n en p=Sin[A/2] y q=Cos[(B-C)/2]";


(* ::Input::Initialization:: *)
ToCocienteSinA2CosBC2[expr_]:=Factor[FullSimplify[ToPolinomioSinA2CosBC2[Numerator[expr]]/ToPolinomioSinA2CosBC2[Denominator[expr]],{p>0,q>0}]];


(* ::Input::Initialization:: *)
ToTrigSinA2CosBC2::"usage" = "ToTrigSinA2CosBC2[expr] convierte una una expresi\[OAcute]n en a,b,c en una expresi\[OAcute]n en Sin[A/2] y Cos[(B-C)/2]";


(* ::Input::Initialization:: *)
ToTrigSinA2CosBC2[expr_]:=Module[{poly,eTrig},
poly=ToCocienteSinA2CosBC2[expr];
eTrig=Factor[poly/.{p->Sin[A/2],p^n_->Sin[A/2]^n,q->Cos[(B-C)/2],q^n_->Cos[(B-C)/2]^n}]
]


(* ::Input::Initialization:: *)
ToSinA2CosBC2::"usage" = "ToSinA2CosBC2[expr] convierte una expresi\[OAcute]n f(a,b,c) en una expresi\[OAcute]n en p=Sin[A/2] y q=Cos[(B-C)/2].
Obtenemos una expresi\[OAcute]n polin\[OAcute]mica en p y q si en cada monomio de f(a,b,c) la variable a tiene un exponente par y las variables b, c tienen los mismos exponentes.
Trig-> True convierte f(a,b,c) en una suma de t\[EAcute]rminos de la forma \!\(\*SuperscriptBox[\(Sin\), \(m\)]\)[A/2] y \!\(\*SuperscriptBox[\(Cos\), \(n\)]\)[(B-C)/2] con coeficientes apropiados. (default = False).
En muchos casos, la expresi\[OAcute]n final se simplifica a\[UAcute]n m\[AAcute]s si aplicamos la sustituci\[OAcute]n /.{Cos[A]+Cos[B-C]->2 Sin[B] Sin[C]}  o /.{A->\[Pi]-B-C} ";


(* ::Input::Initialization:: *)
ToSinA2CosBC2[expr_,OptionsPattern[{Trig->False}]]:=Module[{trig},
trig=OptionValue[Trig];
If[trig,ToTrigSinA2CosBC2[expr],ToCocienteSinA2CosBC2[expr]]
];


(* ::Input::Initialization:: *)
LinealizarCoseno::"usage" = "LinealizarCoseno[n,x] convierte una una potencia del coseno \!\(\*SuperscriptBox[\(Cos\), \(n\)]\)[x] en una expresi\[OAcute]n lineal del tipo \!\(\*SubscriptBox[\(\[Alpha]\), \(1\)]\)Cos[x]+\!\(\*SubscriptBox[\(\[Alpha]\), \(2\)]\)Cos[2x]+...+\!\(\*SubscriptBox[\(\[Alpha]\), \(n\)]\)Cos[nx]";


(* ::Input::Initialization:: *)
LinealizarCoseno[n_Integer/;n>0,x_]:=2^-n Sum[Binomial[n,k]Cos[(2k-n)x],{k,0,n}];


(* ::Input::Initialization:: *)
ToPolinomioCosACosBC::"usage" = "ToPolinomioCosACosBC[expr] convierte una expresi\[OAcute]n polin\[OAcute]mica f(a,b,c) en una expresi\[OAcute]n en p=Cos[A] y q=Cos[B-C].\n
Obtenemos una expresi\[OAcute]n polin\[OAcute]mica en p y q si en cada monomio de f(a,b,c) las variables b, c tienen los mismos exponentes.";


(* ::Input::Initialization:: *)
ToPolinomioCosACosBC[expr_]:=Module[{sust1,sust2,expr1,expr2},
sust1={Sin[A]->Sqrt[1-p^2],Sin[B]->Sqrt[1/2+(p q)/2+1/2 Sqrt[1-p^2] Sqrt[1-q^2]],Sin[C]->Sqrt[1/2+(p q)/2-1/2 Sqrt[1-p^2] Sqrt[1-q^2]]};
sust2={Sin[A]^n_->(1-p^2)^(n/2),Sin[B]^n_->(1/2+(p q)/2+1/2 Sqrt[1-p^2] Sqrt[1-q^2])^(n/2),Sin[C]^n_->(1/2+(p q)/2-1/2 Sqrt[1-p^2] Sqrt[1-q^2])^(n/2)};
expr1=Factor[expr/.{a->2R Sin[A],b->2R Sin[B],c->2R Sin[C]}];
expr2=Factor[expr1/.Join[sust1,sust2]]
];


(* ::Input::Initialization:: *)
ToCocienteCosACosBC::"usage" = "ToCocienteCosACosBC[expr] convierte una expresi\[OAcute]n (racional) en a, b, c en una expresi\[OAcute]n (racional) en p=Cos[A] y q=Cos[B-C]";


(* ::Input::Initialization:: *)
ToCocienteCosACosBC[expr_]:=Factor[FullSimplify[ToPolinomioCosACosBC[Numerator[expr]]/ToPolinomioCosACosBC[Denominator[expr]],{p>0,q>0}]];


(* ::Input::Initialization:: *)
ToTrigCosACosBC::"usage" = "ToTrigCosACosBC[expr] convierte una una expresi\[OAcute]n polin\[OAcute]mica f(a,b,c) en una suma de t\[EAcute]rminos de la forma Cos[mA] y Cos[n(B-C)] con coeficientes apropiados.
En muchos casos, la expresi\[OAcute]n final se simplifica a\[UAcute]n m\[AAcute]s si aplicamos la sustituci\[OAcute]n /.{Cos[A]+Cos[B-C]->2 Sin[B] Sin[C]}";


(* ::Input::Initialization:: *)
ToTrigCosACosBC[expr_]:=Module[{cociente,eCosACosBC,eTrig},
cociente=ToCocienteCosACosBC[expr];
eCosACosBC=Factor[cociente/.{p->Cos[A],p^n_->LinealizarCoseno[n,A],q->Cos[B-C],q^n_->LinealizarCoseno[n,B-C]}];
eTrig=Simplify[eCosACosBC];
eTrig/.{Cos[(m_Integer* B+n_Integer* C)/;m>0&&n<0&&m==Abs[n]]->Cos[m( B- C)]}/.{Cos[A]+Cos[B-C]->2 Sin[B] Sin[C]}
]


(* ::Input::Initialization:: *)
ToCosACosBC::"usage" = "ToCosACosBC[expr] convierte una expresi\[OAcute]n f(a,b,c) en una expresi\[OAcute]n en p=Cos[A] y q=Cos[B-C].
Obtenemos una expresi\[OAcute]n polin\[OAcute]mica en p y q si f(a,b,c) es un polinomio y en cada monomio las variables b, c tienen los mismos exponentes.
Trig-> True convierte f(a,b,c) en una suma de t\[EAcute]rminos de la forma Cos[mA] y Cos[n(B-C)] con coeficientes apropiados. (default = False).";


(* ::Input::Initialization:: *)
ToCosACosBC[expr_,OptionsPattern[{Trig->False}]]:=Module[{trig},
trig=OptionValue[Trig];
If[trig,ToTrigCosACosBC[expr],ToCocienteCosACosBC[expr]]
];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
grid::"usage"="grid[data,colors_] muestra los datos en una rejilla.";


(* ::Input::Initialization:: *)
(*utility for display data on a grid*)
grid[data_,colors_:{LightPink,LightYellow}]:=Module[{lis},
lis=If[Length[Dimensions[data]]==1,{#}&/@data,data];
Grid[lis,Frame->All,Background->{None,{colors}}]
];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Truncar::"usage"="Truncar[x,n] devuelve el n\[UAcute]mero x con n d\[IAcute]gitos.";


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
VeinteDigitos::"usage"="VeinteDigitos[x] devuelve el n\[UAcute]mero x con 20 d\[IAcute]gitos despu\[EAcute]s de la coma.";


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
VeinteDigitosLista::"usage"="VeinteDigitosLista[lista] aplica la funci\[OAcute]n VeinteDigitos a una lista.";


(* ::Input::Initialization:: *)
Truncar[x_,n_]:=Sign [x]N[FromDigits[RealDigits[x,10,n]],n];
VeinteDigitos[x_]:=Truncar[x,20+Last[RealDigits[x]]]
VeinteDigitosLista[lista_]:=Map[VeinteDigitos,lista]


(* ::Input::Initialization:: *)
EsInteriorTriangulo::"usage"=
"EsInterior[ptP,{ptA,ptB,ptC}] devuelve True si el punto P es interior al tri\[AAcute]ngulo ABC";


(* ::Input::Initialization:: *)
EsInteriorTriangulo[ptP_,{ptA_,ptB_,ptC_}]:=Module[{s,t},
{s,t}={s,t}/.Solve[ptP-ptA==s(ptB-ptA)+t(ptC-ptA)][[1]];
And[
Or[Abs[s]<10^-8,Abs[1-s]<10^-8,And[s>0,s<1]],
Or[Abs[t]<10^-8,Abs[1-t]<10^-8,And[t>0,t<1]]]
]


(* ::Input::Initialization:: *)
EsInteriorAngulo::"usage"=
"EsInterior[P,{A,B,C}] devuelve True si el punto P es interior al \[AAcute]ngulo ABC";


(* ::Input::Initialization:: *)
EsInteriorAngulo[ptP_,{ptB_,ptA_,ptC_}]:=Module[{s,t},
{s,t}={s,t}/.Solve[ptP-ptA==s(ptB-ptA)+t(ptC-ptA)][[1]];
And[
Or[Abs[s]<10^-8,s>0],
Or[Abs[t]<10^-8,t>0]]
]


(* ::Input::Initialization:: *)
EvaluarExpresion::"usage"=
"EvaluarExpresion[expr] evalua una expresi\[OAcute]n en a, b, c para 10 tri\[AAcute]ngulos elegidos al azar. Se puede usar para investigar si una desigualdad es cierta o no";


(* ::Input::Initialization:: *)
EvaluarExpresion[expr_]:=Module[{n,x,y,z,a1,b1,c1,lista},
lista={};
For[n=1,n<= 10,n++,
{x,y,z}=RandomReal[{0,1},3];
{a1,b1,c1}={y+z,z+x,x+y};
lista=Append[lista,{a1,b1,c1, expr/.Thread[{a,b,c}-> {a1,b1,c1}]}]
];
lista //ColumnForm
]


(* ::Input::Initialization:: *)
MismoSemiplano::"usage"="MismoSemiplano[X,Y,P,Q}] devuelve True si el punto X,Y pertenece al mismo semiplano que la recta PQ";

MismoSemiplano[ptX_,ptY_,ptP_,ptQ_,testT_:{6,9,13}]:=Module[{cX,cY,cP,cQ,cA,cB,cC},{cA,cB,cC}=VerticesTriangulo[testT];{cX,cY,cP,cQ}=(PuntoBarCar[#1,cA,cB,cC]&)/@{ptX,ptY,ptP,ptQ};
Cross@@Transpose[{cX,cP,cQ}] . {1,1,1} Cross@@Transpose[{cY,cP,cQ}] . {1,1,1}>0]



(* ::Input::Initialization:: *)
NucleoEcuacion::"usage" = "NucleoEcuacion[eqn] elimina en el polinomio <eqn>, los factores multiplos e los factores numericos";
NucleoEcuacion[eqn_]:=Apply[Times,Select[First[#]&/@FactorList[eqn],!NumericQ[#]&]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EcuacionImplicitaOld::"usage"="EcuacionImplicitaOld[ptP,vars] devuelve la ecuaci\[OAcute]n de un punto en coordenadas param\[EAcute]tricas. (versi\[OAcute]n antigua)";


(* ::Input::Initialization:: *)
EcuacionImplicitaOld[ptP_,vars_]:=Module[{factor},First[GroebnerBasis[factor {x,y,z}-ptP,{x,y,z},Flatten[{factor,vars}],MonomialOrder->EliminationOrder,CoefficientDomain->RationalFunctions]]];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
EcuacionImplicita::"usage"= "EcuacionImplicita halla la curva a la que pertenece el punto P dado en funci\[OAcute]n de la variable var. Esta funci\[OAcute]n ofrece el \[UAcute]ltimo factor devuelto por la funci\[OAcute]n Resultant. Para que la funci\[OAcute]n devuelva la expresi\[OAcute]n completa usar el par\[AAcute]metro opcional UsarLast->False";


(* ::Input::Initialization:: *)
EcuacionImplicita[ptP_,var_,OptionsPattern[{UsarLast->True}]]:=Module[{eqxy,eqxz,locus},
eqxy=Resultant[x-\[Lambda] ptP[[1]],y-\[Lambda] ptP[[2]],\[Lambda]];
eqxz=Resultant[x-\[Lambda] ptP[[1]],z-\[Lambda] ptP[[3]],\[Lambda]];
locus=Factor[Resultant[eqxy,eqxz,var]];
If[OptionValue[UsarLast],locus=Last[locus]];
locus
];


(* ::Input::Initialization::RGBColor[0., 0.5019607843137255, 0.]:: *)
Envolvente::"usage"="Envolvente[curvas, variable] devuelve la ecuaci\[OAcute]n de la envolvente de la familia de curvas que dependen de un par\[AAcute]metro.";


(* ::Input::Initialization:: *)
Envolvente[curvas_,variable_]:=Factor[Resultant[curvas,D[curvas,variable],variable]];



