(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    614332,      15218]
NotebookOptionsPosition[    599731,      14967]
NotebookOutlinePosition[    600201,      14984]
CellTagsIndexPosition[    600158,      14981]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Kites", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, {
  3.947144439694456*^9, 3.947144443366682*^9}, {3.9472976682425385`*^9, 
  3.9472976689218636`*^9}},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about kites in the paper \
\"More Relationships between a Central Quadrilateral and its Reference \
Quadrilateral\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in \
February 2025.

This Notebook is Copyright \[Copyright] February 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947148657900776*^9, 3.947148664004244*^9}, {
  3.9472976764024563`*^9, 
  3.9472976773625336`*^9}},ExpressionUUID->"22c83543-03f0-524a-b077-\
52bf40ea5d06"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.94550589477663*^9, 3.9455059090976067`*^9}, {
  3.947131190260437*^9, 
  3.947131192227951*^9}},ExpressionUUID->"5e4c6aa2-710c-4599-941e-\
5f13e499af78"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", ">", "0"}], ",", 
     RowBox[{"b", ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ptD", "=", 
  RowBox[{"SimetriaAxial", "[", 
   RowBox[{"ptB", ",", "rtCA"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.945504565162958*^9, 3.94550458198252*^9}, {
   3.9455170892604294`*^9, 3.945517091156999*^9}, {3.946437513579389*^9, 
   3.946437514387348*^9}, {3.946437922994858*^9, 3.946437998083948*^9}, {
   3.947131229988783*^9, 3.9471312337408752`*^9}, {3.94713126947538*^9, 
   3.947131271053065*^9}, {3.9471314397563486`*^9, 3.947131528028438*^9}, {
   3.947131689741032*^9, 3.947131695924305*^9}, {3.947131733918829*^9, 
   3.947131775067988*^9}, 3.94713185451009*^9, {3.947132455427481*^9, 
   3.947132456035076*^9}, {3.947133799219084*^9, 3.947133799613205*^9}, {
   3.9471447897267284`*^9, 3.9471448143356647`*^9}, {3.947297709787621*^9, 
   3.947297720666094*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ",", 
   RowBox[{"-", 
    SuperscriptBox["b", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "+", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947297735025563*^9, {3.9475695095991*^9, 3.9475695144217014`*^9}},
 CellLabel->"Out[6]=",ExpressionUUID->"5a41ecdf-0ee5-7447-a5f9-2d923e1cb5f6"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"cf60f297-bbcd-8748-b453-\
e7118b4e0a98"],

Cell[CellGroupData[{

Cell["QAP centers", "Subsection",
 CellChangeTimes->{{3.945853740709931*^9, 3.945853743438184*^9}, {
  3.9464394595455627`*^9, 
  3.9464394652171745`*^9}},ExpressionUUID->"c8cca55e-04f1-8f4a-b670-\
3c3179eed91e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP", "=", 
   RowBox[{"<|", 
    RowBox[{
     RowBox[{"1", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ",", 
        RowBox[{"p", "+", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ",", 
        RowBox[{"p", "+", "q", "+", 
         RowBox[{"2", " ", "r"}]}]}], "}"}]}], ",", 
     RowBox[{"2", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", "SB"}], "-", 
           RowBox[{"r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "SA"}], "+", 
           RowBox[{"r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "SA"}], "-", 
           RowBox[{"q", " ", "SB"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"3", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}]}], 
          ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", 
              RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"4", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", "SA"}], "-", 
           RowBox[{"2", " ", "p", " ", "q", " ", "SA"}], "-", 
           RowBox[{"2", " ", "p", " ", "r", " ", "SA"}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}]}], ")"}]}],
         ",", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p"}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q"}], "-", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}], 
             ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"5", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"6", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"q", " ", 
                SuperscriptBox["SB", "2"]}], "-", 
               RowBox[{"r", " ", 
                SuperscriptBox["SC", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"p", " ", 
                SuperscriptBox["SA", "2"]}], "-", 
               RowBox[{"r", " ", 
                SuperscriptBox["SC", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"p", " ", 
                SuperscriptBox["SA", "2"]}], "-", 
               RowBox[{"q", " ", 
                SuperscriptBox["SB", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"7", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SB", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 SuperscriptBox["SB", "2"], "+", 
                 RowBox[{"2", " ", "SB", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"2", " ", "SB", " ", "SC"}], "+", 
                 SuperscriptBox["SC", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"3", " ", "r", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"r", " ", "SC", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "SA"}], "+", "SC"}], ")"}]}], "+", 
              RowBox[{"p", " ", "SA", " ", 
               RowBox[{"(", 
                RowBox[{"SA", "+", 
                 RowBox[{"2", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SA", " ", "SC"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"3", " ", "q", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"q", " ", "SB", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "SA"}], "+", "SB"}], ")"}]}], "+", 
              RowBox[{"p", " ", "SA", " ", 
               RowBox[{"(", 
                RowBox[{"SA", "+", 
                 RowBox[{"2", " ", "SB"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SA", " ", "SB"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}],
        "}"}]}], ",", 
     RowBox[{"8", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "p"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "p"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "q"}], "+", 
            RowBox[{"4", " ", "r", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}]}], "}"}]}],
      ",", 
     RowBox[{"9", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p", " ", "q"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"]}], "+", 
                 RowBox[{"3", " ", "p", " ", "r"}], "+", 
                 RowBox[{"q", " ", "r"}], "-", 
                 SuperscriptBox["r", "2"]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "p", " ", "q"}], "-", 
                 SuperscriptBox["q", "2"], "+", 
                 RowBox[{"2", " ", "p", " ", "r"}], "+", 
                 RowBox[{"q", " ", "r"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "q"}], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"4", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "q"}], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "-", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"5", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"3", " ", "p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "8"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "8"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", 
                 RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"p", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
              "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"p", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"8", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"4", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["c", "6"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["p", "2"]}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "q", " ", 
                  SuperscriptBox["r", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"12", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"9", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["q", "3"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"12", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"13", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "r"}], "-", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["p", "2"], "-", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "6"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "q", " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"5", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "-", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["q", "2"], " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "3"}], " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  SuperscriptBox["q", "3"], " ", "r"}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  SuperscriptBox["r", "3"]}], "+", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["p", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"8", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "3"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"12", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["c", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["q", "2"]}]}], ")"}], " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "r"}], "-", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "6"]}], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["p", "2"]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["q", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"5", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "-", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["q", "2"], " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"8", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"6", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "3"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    RowBox[{"2", " ", "q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"12", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"13", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"9", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"10", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"11", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"12", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
          ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", "q", " ", "SB"}], "+", 
           RowBox[{"p", " ", "r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{"p", " ", "q", " ", "SA"}], "+", 
           RowBox[{"q", " ", "r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r", " ", "SA"}], "+", 
           RowBox[{"q", " ", "r", " ", "SB"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", "q", " ", 
            SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"13", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"14", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "r"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"5", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"2", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"2", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}]}], "}"}]}], 
     ",", 
     RowBox[{"15", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"q", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["q", "2"]}], "+", 
               RowBox[{"5", " ", "q", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"5", " ", "q", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["p", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["q", "2"]}], "+", 
               RowBox[{"22", " ", "q", " ", "r"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "p"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"5", " ", "p", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"5", " ", "p", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["q", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"22", " ", "p", " ", "r"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["q", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               SuperscriptBox["q", "2"]}], ")"}], " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "p"}], "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"5", " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"5", " ", "p", " ", "q"}], "+", 
               SuperscriptBox["q", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"5", " ", "p", " ", "q"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["q", "2"]}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"22", " ", "p", " ", "q"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["q", "2"]}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"10", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"16", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"17", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["q", "2"], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"18", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"19", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"20", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"21", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"22", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"23", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", "q", " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
         RowBox[{"p", " ", "q", " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
         RowBox[{"p", " ", "r", " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", "SB"}]}]}], "}"}]}], ",", 
     RowBox[{"24", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", "SB", " ", 
          "SC"}], "-", 
         RowBox[{"4", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "SC"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], ")"}], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", "SC"}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "SA", " ", 
          "SC"}], "-", 
         RowBox[{"4", " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "SC"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], ")"}], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", "SC"}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "SA", " ", 
          "SB"}], "-", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"25", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"2", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"26", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"5", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"5", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"5", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"27", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["p", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"], " ", "q"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"p", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{"q", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "3"]}], " ", "q"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           SuperscriptBox["q", "4"], "+", 
           RowBox[{
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"q", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["p", "3"], " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"2", " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           SuperscriptBox["r", "4"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"28", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "4"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["b", "2"], "-", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", "r"}]}], 
             ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "4"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["q", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "+", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", "r"}], "+", 
              RowBox[{
               SuperscriptBox["a", "4"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"3", " ", "q", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", 
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "+", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["a", "2"], "-", 
                   SuperscriptBox["b", "2"]}], ")"}], " ", "p", " ", "q"}], 
                "+", 
                RowBox[{
                 SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "4"], " ", "q", " ", "r"}]}], ")"}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"3", " ", "q", " ", "r"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
       "}"}]}], ",", 
     RowBox[{"29", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["a", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "3"], " ", "r"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["p", "2"]}], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"30", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "q"}], ")"}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "-", 
              RowBox[{"3", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "p"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"3", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "p"}], "+", "q"}], ")"}], " ", "r", 
            " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"3", " ", "q"}]}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
       "}"}]}], ",", 
     RowBox[{"31", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"32", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", "q", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}]}], "}"}]}],
      ",", 
     RowBox[{"33", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB", " ", 
             "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA", " ", 
             "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA", " ", 
             "SB"}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"34", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"4", " ", "q"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p"}], "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"35", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"15", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "3"], " ", "r"}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"5", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"15", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"12", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"5", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["p", "2"]}], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"15", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"15", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"12", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"36", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["c", "2"]}], " ", "q"}], "-", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "-", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q", " ", "r"}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
               RowBox[{
                SuperscriptBox["a", "4"], " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["b", "4"], " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["c", "2"]}], " ", "p"}], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "p"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "r"}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "4"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["c", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["b", "2"], " ", 
                SuperscriptBox["c", "2"], " ", "q", " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["b", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["c", "4"], " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "-", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "q"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}]}], ")"}]}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["b", "2"]}], " ", "p"}], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "4"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["c", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["a", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["c", "4"], " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "p"}], "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}]}], "}"}]}], ",", 
     RowBox[{"37", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"p", " ", "q", " ", "SB"}], "+", 
            RowBox[{"p", " ", "r", " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"p", " ", "q", " ", "SA"}], "+", 
            RowBox[{"q", " ", "r", " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r", " ", "SA"}], "+", 
            RowBox[{"q", " ", "r", " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"38", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["b", "2"]}], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "-", "q", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", "p"}], "+", "q", "+", "r"}], 
                ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", 
                 RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", 
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "q", "+", 
             RowBox[{"2", " ", "r"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "-", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "-", "q", "-", 
                   RowBox[{"2", " ", "r"}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "-", "q", "+", 
                   RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          ")"}]}]}], "}"}]}], ",", 
     RowBox[{"39", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["b", "2"], "-", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "-", "r"}], ")"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "+", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "p"}], "+", "r"}], ")"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               RowBox[{"2", " ", "p", " ", "r"}], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["a", "2"], "-", 
                 SuperscriptBox["b", "2"]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "q"}], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}]}], "}"}]}], ",", 
     RowBox[{"40", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], "+", 
            SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", 
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "p"}], "+", 
                   RowBox[{"2", " ", "q"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "q"}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["q", "2"]}]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", "p"}], "+", 
                  RowBox[{"2", " ", "q"}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "r", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", 
                  RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["p", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", "q"}], "+", 
                  RowBox[{"9", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["q", "2"]}], "+", 
                  RowBox[{"15", " ", "q", " ", "r"}], "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["a", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"9", " ", "p"}], "+", 
                  RowBox[{"7", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"12", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "r"}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "q"}], "+", 
                   RowBox[{"2", " ", "r"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["p", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", "q"}], "+", 
                  RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", 
                   SuperscriptBox["q", "2"]}], "+", 
                  RowBox[{"15", " ", "q", " ", "r"}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], "+", 
            SuperscriptBox["b", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", 
                  RowBox[{"2", " ", "q"}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "q"}], "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["q", "2"]}]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", "p"}], "+", 
                  RowBox[{"9", " ", "q"}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "p"}], "+", 
                   RowBox[{"3", " ", "r"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "p"}], "+", 
                  RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"6", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "r"}], "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"41", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "4"]}], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "4"]}], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"42", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q", " ", "r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "SB"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"43", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", "p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", "p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"44", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "q"}], "-", 
            RowBox[{"q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p", " ", "q"}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            SuperscriptBox["q", "3"], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            SuperscriptBox["r", "3"]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "3"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            SuperscriptBox["r", "3"]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "3"], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            SuperscriptBox["q", "3"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}]}], "|>"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945841589546528*^9, 3.945841604944151*^9}, {
   3.9458416486015606`*^9, 3.945841701130226*^9}, 3.94584180266897*^9, {
   3.945841855521532*^9, 3.945841865133842*^9}, {3.9458419743855267`*^9, 
   3.94584197851943*^9}, {3.945842012120521*^9, 3.945842016064451*^9}, {
   3.945842114756489*^9, 3.945842119338508*^9}, {3.945842170028664*^9, 
   3.945842174123476*^9}, {3.945842254968681*^9, 3.9458422593104534`*^9}, {
   3.94584246069957*^9, 3.945842465998068*^9}, {3.945842501032144*^9, 
   3.9458425325383263`*^9}, {3.945842735167492*^9, 3.945842742091593*^9}, {
   3.945842846919035*^9, 3.945842850061655*^9}, {3.945842936494915*^9, 
   3.945842969633366*^9}, {3.945843125849571*^9, 3.94584313274209*^9}, {
   3.945843174894972*^9, 3.945843178277809*^9}, {3.9458432197775517`*^9, 
   3.9458432370243473`*^9}, {3.945843287330616*^9, 3.9458432907977543`*^9}, {
   3.945843326923149*^9, 3.9458433430906563`*^9}, {3.945843384493232*^9, 
   3.945843387811741*^9}, {3.945843423557177*^9, 3.945843427076299*^9}, {
   3.9458460856414566`*^9, 3.9458460903603935`*^9}, {3.9458461244501*^9, 
   3.945846127392929*^9}, {3.945846273464027*^9, 3.945846279270181*^9}, {
   3.945846311960058*^9, 3.945846315350111*^9}, {3.945846366817175*^9, 
   3.945846382831234*^9}, {3.945846756353731*^9, 3.9458467662170296`*^9}, {
   3.945846811099188*^9, 3.945846841686339*^9}, {3.945846884211832*^9, 
   3.945847260236458*^9}, {3.945847371762398*^9, 3.9458473779483223`*^9}, {
   3.945847468577452*^9, 3.945847473866535*^9}, {3.9458476375888367`*^9, 
   3.945847641254919*^9}, {3.945847770316178*^9, 3.9458477741893463`*^9}, {
   3.94584781182493*^9, 3.9458478153183575`*^9}, {3.94584788583465*^9, 
   3.945847888720951*^9}, {3.94584794845273*^9, 3.9458479545306664`*^9}, {
   3.945848036235821*^9, 3.945848039850874*^9}, {3.945848209145437*^9, 
   3.945848213365254*^9}, {3.945848428704586*^9, 3.945848437990104*^9}, {
   3.945848526693582*^9, 3.945848534626331*^9}, {3.945848666528978*^9, 
   3.94584868269029*^9}, {3.945848775077949*^9, 3.945848778998434*^9}, {
   3.945848877398905*^9, 3.945848886629158*^9}, {3.9458491238654*^9, 
   3.945849128054989*^9}, {3.945849197156975*^9, 3.9458492011715355`*^9}, {
   3.9458492397412167`*^9, 3.945849244243763*^9}, 3.945849479846901*^9, {
   3.945851715909244*^9, 3.945851732617178*^9}, 3.945853235726444*^9, {
   3.945853633264748*^9, 3.9458536354922667`*^9}, {3.946058981146543*^9, 
   3.946058983238126*^9}, {3.946113816440451*^9, 3.946113833217655*^9}, 
   3.946113923272053*^9, 3.9462998579964046`*^9},
 CellLabel->"In[8]:=",ExpressionUUID->"90297db1-2eea-6346-9338-a3e8dcfe0024"]
}, Closed]],

Cell[CellGroupData[{

Cell["QAP constructions", "Subsection",
 CellChangeTimes->{{3.946258018000845*^9, 3.9462580514460297`*^9}, {
  3.946439582465828*^9, 
  3.94643958360841*^9}},ExpressionUUID->"79ef6085-3de7-3c49-8561-\
f943fbd2d431"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP1", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258220966779*^9, 3.946258253166219*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"e725b315-4161-274c-8798-a4e0c807d6a8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP2", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"PonceletPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258127112749*^9, 3.946258205014044*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"60fea3de-a36e-734d-b67f-75eab8f36838"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP3", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258267006763*^9, 3.946258272798765*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"422bd8e2-a85e-d748-b542-6c9b62c11efd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP4", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsogonal", "[", 
        RowBox[{"P", ",", 
         RowBox[{"{", 
          RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsogonal", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"{", 
          RowBox[{"P", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258285271057*^9, 3.946258529254532*^9}, {
  3.946258821686931*^9, 3.946258862614427*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"d021f1ab-c58d-b74b-8aa5-a62365464cc5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP5", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsotomico", "[", 
        RowBox[{"P", ",", 
         RowBox[{"{", 
          RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", "P"}], 
      "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsotomico", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"{", 
          RowBox[{"P", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", "Q"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946552139912605*^9, 3.946552177047758*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"023d4850-e194-b941-a762-4c9a532e11d1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP6", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Medio", "[", 
    RowBox[{
     RowBox[{"QAP2", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}], ",", 
     RowBox[{"QAP4", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946554002925066*^9, 3.946554042045203*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"62ef2468-c328-714d-8bf7-299b142a086d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP7", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Q1", ",", "Q2", ",", "Q3", ",", "Q4", ",", "R1", ",", "R2"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Q1", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q2", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q3", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q4", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R1", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q2", ",", "Q3", ",", "Q4"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R2", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q1", ",", "Q3", ",", "Q4"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R1"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R2"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946258285271057*^9, 3.946258529254532*^9}, {
  3.946258821686931*^9, 3.946258862614427*^9}, {3.946290848591799*^9, 
  3.946291021534954*^9}, {3.946291111031261*^9, 3.946291120455242*^9}, {
  3.946696200711548*^9, 3.946696200806263*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"d734f707-6812-364b-b359-ac3a6bb66e72"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MiquelPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"U", ",", "V", ",", "O1", ",", "O2"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"U", "=", 
       RowBox[{"Punto", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "Q"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"V", "=", 
       RowBox[{"Punto", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "S"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"O1", "=", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "S", ",", "U"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"O2", "=", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"R", ",", "S", ",", "V"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimetriaAxial", "[", 
       RowBox[{"S", ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"O1", ",", "O2"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]",
     "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946294457093628*^9, 3.946294688202664*^9}, {
   3.9462961458488*^9, 3.9462961471441994`*^9}, 3.9462963028076897`*^9, {
   3.9462973681984005`*^9, 3.946297370950136*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"34f7e383-98aa-bc47-9867-166186424dd4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MiquelCircle", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"U", ",", "V", ",", "W", ",", "O1", ",", "O2", ",", "O3"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"U", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"V", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O1", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "S", ",", "U"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O2", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"R", ",", "S", ",", "V"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O3", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"Q", ",", "R", ",", "U"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CircunferenciaTresPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"O1", ",", "O2", ",", "O3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946295931650831*^9, 3.9462959921519623`*^9}, {
  3.9462960978401566`*^9, 3.946296126960247*^9}, {3.946296309416164*^9, 
  3.946296387663599*^9}, {3.946296507206955*^9, 3.946296515015978*^9}, {
  3.9462965951590157`*^9, 3.9462966339272327`*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"4370c731-693f-a941-82c8-1f6a14f724b2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP8", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"SimetriaCentral", "[", 
    RowBox[{
     RowBox[{"QAP4", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}], ",", 
     RowBox[{"QAP2", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946554262541748*^9, 3.946554276084837*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"6e2024d9-4541-ea4e-a308-49a8bb9b87a5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP9", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c1", ",", "c2", ",", "c3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"c1", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c2", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "Q", ",", "S", ",", "R"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c3", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "R", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CentroRadical", "[", 
      RowBox[{"c1", ",", "c2", ",", "c3"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9462975678957386`*^9, 3.94629768995805*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"384fc915-4ebd-5342-9174-a166a5e7f52d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP10", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Baricentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946554372389721*^9, 3.94655438207695*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"e878baba-ea71-dd4f-b972-2e4c3753c774"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP11", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Circuncentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946554416053346*^9, 3.946554423653038*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"4200ee2b-abeb-b246-85fa-68f1ce5d836b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP12", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->"In[22]:=",ExpressionUUID->"8131db8a-5012-e741-93f3-ec6da52923f1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP34", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"P1", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P2", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P3", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P4", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"QAP2", "[", 
       RowBox[{"{", 
        RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946362022452154*^9, 3.9463621697479362`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"3e5eb206-464c-7e4f-b628-98c50c5a4629"]
}, Closed]],

Cell[CellGroupData[{

Cell["Auxiliary functions", "Subsection",
 CellChangeTimes->{
  3.818667972143658*^9, {3.8186680382464933`*^9, 3.818668041714528*^9}, {
   3.818668136826049*^9, 3.818668143553762*^9}, {3.818685183717651*^9, 
   3.818685185711126*^9}},ExpressionUUID->"d004e03f-8f12-9a43-865f-\
339812029417"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"EqualPointsQ", "[", 
      RowBox[{"ptP_", ",", "ptQ_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cross", "[", 
           RowBox[{"ptP", ",", "ptQ"}], "]"}], "/.", "sustS"}], "/.", 
         "sustC"}], ",", "cond"}], "]"}], "===", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.947132996916015*^9, 3.9471330125156*^9}, {
  3.947133479684403*^9, 3.947133480044634*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],

Cell[CellGroupData[{

Cell["Quadrilateral routines", "Subsection",
 CellChangeTimes->{{3.945509919017998*^9, 
  3.945509932600797*^9}},ExpressionUUID->"2a49be25-3c4e-430e-86c6-\
869880736f30"],

Cell[CellGroupData[{

Cell["Vertex centroid", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.947132319963703*^9, 
  3.947132328106987*^9}},ExpressionUUID->"a576f9af-1f5b-4213-b4d3-\
e7b66981337e"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3Qd8FGX+P3D+v7v7nb+zAPZTT7EgoJyn56moZ0fQKBq6dIggATVSgmBo
oSS0DUgI0oOIQREUAYl0iAkdEiCFkl43bdPbZtt/yk7dmdnZlt2Ez/s1+iK7
M88888wzM999nmdmHg74ot8n/9OuXbupNxH/6zdm+htTpoz5qn8H4o+BQVMn
jA8aN/bdoOBx48dN6RHwJ+LDV4h5k4n/yH9bAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQJXcmLE9KeHxCnOd
ifDr3ZOhOGfbVrg7yI8th4CYPG/nR4J29yReFrfmejs/PiYh3H7JtIK9DNAK
VCZZZvax3HuTpV07aupgeaaPZWOS0iKfMjP7bVO3joNM4jbTvV0tU6MtlQaZ
BQ2WfZPJ2botdXCr+PTa+K0RQWP8rSeM3n6DxgRFbI3X6mWX0O0Ksp5ahqxN
d3R1Rl36vuiQiYO4y3GfQQGTQqMTdC5sg1eoCzwI5yP8vRp46AvjY5YFBfT3
4xV4REyCwh72jNIdTL3x2UtSbex09wYeem1CTMSkAH/2cuznP2hiSOSu9JYu
fNepCTwsrWIvA/gwg+XnMdYAYOZRSyPxSS33ycOfWyollzpquYmNHPpQS6mx
hws2hu6hPqm1bOzLfPgfS5pN7NGYbPG71zqD04GHPiMmkDol+s+KzW0gP9Cd
jwnuT502+gfvzpZcSLfjc/ZHzaC11xxZX3Fs6CBquZHhR/LIU6++MDaEXl2Y
J67JTGwwNsYDP19VBx55MQFeCzz06VutezhkX67eSO7hpK3BdCDkH7w719iS
mYkP9/lLUvr6QW4LPGpToyf60YdSzHkdWd11SWvHe65CcrFBeIIHE7dXMq1g
LwP4rJOfWy/rb64XfK7pbv38meUSS8X0FTRZ7JNrrBBJt3QTBR4WMvJhG08E
oYXBcnK2YC1OBh6lu4PoZof+kUm8C5A+Idz6C71/+JkGm6Uyoof35Dhwfq6N
D6djjN5Bu0t5qzsU4rHA40x4b0+e51XyXuDBtk35r+Q30unjw6x72H/xmRb8
6d0KLkm5WwPcE3gYc2PGW8s4kl/29OHjmQqp3R7owcBDrVawlwF8FC8SiKkV
fNO4jbvii76yaC1vUo0hfrZRhOrV8ReJ6SNuPGlMt3z8mKXdTRa/IZYOLgUe
3NVn0HpRh0n62iHWc8fwTeK+lKSV/j17h0Qut/4wVH8KJRfsKdW40RAb4pnA
Q3c01N/BTHqEtwKPhngmgrRpmLq2ltl/w6MzWixDreCS5K7Ag+uOFNc96uDy
RIXUp0ePZeoZAg+AVijxK66bI0v03RXpIIGgjSQ/1KRbNr5hneGmz9WtTybw
2DdCnI3KbZZnxlm0VEPKUFcCD/pyT5+mTom/jJ/fU/q0aUwixysQQUJSJBNG
BO1WMzrDGB/ODOoI2W/nR7YuaQfXLd7bb9DE0B1JzDoEo9eonBfHR04a7kfN
GbAsXmttutHuDubNx1si3mb8G7G60LH0R34RZ3iZ4I2L8OsfEBQVm85uqfIg
uuIzMfMDB/WxLuo/yI9bu9J267VHeaNfqA0XjMQQj1Ml5o8MGkYl3jtwR6FN
cvuZPdw7/IzoO2N8KJt76gqr3cXbIGann1kmM9hSX5t+fkd0SOAgbtzI8JCt
qaIw3FKbHhvFK8NB7EgHpsTU7IsGbepRcpgEU57EvgiMiNMy6xCMCO25+IzF
qI2PCqIqRE+/sRHxxcIyKTwSyUuK4efXx7rVsoGHXntkE7HB/PpwRH6UDNsN
ZxvV21BM+cxy3taN36G11KbuDA2g8u83LCQmmSnyM5H+UvWd2ApBCmFkrTnC
lE/PiTu0Unno2WdQ4PyY+EJe1RMl4tBeBgB1NP9hrvgjJL7lrvjhgs9ndrK0
62EhjuWspcziN1lOqlmfTOChHMAoBR5Mh6xsS8IpZgap8wN7+u3ZMzSe3wtD
dov4R5wXBBJBu1REHlygEhCdrTRj7laqudg/ZDdx3jPqziynO3b8wxOYc2xt
bDCTVOS+tYHctZgkaKJhC0EUPnEpBEV+G+zPW5z+qVh7PnI4lax/WLyO2Hwd
00nkF7gj2zYRQQGyy/YcH02OINTrjoSxa5APPIy5u+mM9A6MziAXS//W2mw+
aHE8d0FPjrS2VPQPj14p6PKy3YlnFjNfSvy+5q6MPedbM6XbafsjXWqwZeGO
QGvhHNHpBT+0BRfr7N3MYKHweKKCGLktEuRWeV8QsRb178Bv08kBKrojTBsW
UR/0FttMRsVaB1GwhkWzFaKW6UNkdiuTGq/vTzrwYHoJA6KSiAX1hTusfZTj
Y6QHyeh2M0XZMzRObperTTk1immdmr8jdha/hIichxzhOkO5fSpq8WBT8A+L
jhzJW5ze0eyestbY9Gi6DHsP4g46fjb4pxSVexkAVGAHVygHHoJv48lhpdYB
IbxAYuY5FeuTDDxqLf2YDz+VumK5EnhwTcF2Ag/+t7rdk7gu6/gwZpaQWLvj
BJRXx2HiE+60z57D/SOYgShsWy5xuguJpeITtttIcJGVCzz4KRAn2wbuGkSe
sRvOWMMMYsOYszrXesBdyKSalI1JkdZleV0Y2dF2u1pymd553g9krsMr5BBT
wFyvjfW6r8+gE7ctVWpnSW++RRB4sN9KFRe7l7k9Ys1D0A7mYs0VznjmFzRv
7VzmuWYWfm4V9wWdJW7Xc4M/ycYNm0xSY2jJ1gJdXLi/eF3sJnMdT2z3H7t1
UoEHsy29w9kgnF0waKdU1M2F2cq9HqpS5h2MPQPXU/FJRjQbb/PSlw08eCn4
hx8la036pgBmR+fuGC8uFq4njhfYcIlwpxT1exkA7JMOLRS/PTJBMOpjJnPL
ycOzVazPJvBo1FqimHGqz8j0pLgSeMiEForfUjfKsU0KvJZ8/s8uacqrY+iP
zLKeHnnj8dgLE/sh9wnZ9kLjTvW8i7v9wEM48E+0XWOiuaWIn/k9RednqcAj
QSph+2M8uBiD/wOZa7JgQzsuKbs9XFKhhfK3KgMPW7YLSudTsvdfaV9IbJXE
5Y/LpP9yNglehUiQXbttahKBBzuaehK3KdyCk6T2QwIXTCkFHupS5j75fAcz
G3fF5+0XFYGHbW650T78ts0zth2jEiXvwF4GAPvUBh5jmI/o1om+3P2z7E0x
7bpzo0TYO2LEAQMv8OCmmyzd3lB6ZogrYzxUBx7c4IH0TcMFP+R57cnciY53
yqW/iVexOgbvh6IUhSuI9MXdfuAhkRluEKxgKe6HOXMqVryQ8Ze1G3hIliQ/
NfZ5KQ6MU1UdeLDNFG4MPLhqwM+ncuCh6jqlHHgoXoXTo4fRH3A/7W1vnrUN
PHiNdVIkh4mqCzxUpuzCJisVmk0e+HtKYoyKRCIO7GUAsI+LEBQDD/aOWv6t
LraTJt0mWfnAQ+2NMC4OLuVOGoqBBzcukftVLkHiXCQ8IymujqHylOXZwINr
t5cJPJhTvUQi0svajRZ4HSjSgQe7oCM3yMhsiDXtmLHMt2yfhSOBhz4vacem
iJCJg7jxpT2lrpVuCDz0urQjMVGhQWMGCQaFOn4VthnjwQzd6R/ODqOxDTwU
rtqyZHaoiMqUPRp4yOwpXvWwaQuS+ASBB4A7cLeTdLWkib7LtjxjM/QiqgfZ
QHGE/9SOWu6mWtGTQCS0fODBOzfajn/jGvnZtlnq8ZuiHm2uw91uMzk3zkHh
VMw28Con59nAQ2ZMJhd4KDS8cAXCf6ar3WiB68eRCTwkujDsBx5yI4TprZQY
G6wy8DDm7p5ObWb/4OiE9NoGiQW57ireOBlnAo/apMgxVGAzMjw2TVurd/Eq
rE9dM9x6DwvFerMS724c28CDfTiGdK+KJJubhiSpTNmjgQeXB5nAQyEAc2Qv
A4B9/BaMjVrhd+xTRjsxMUmy5eF2lpsmiBPhnsLxhkUr/lKo5QMPruVZ9HQp
C/+0w4wZo0dfcOMJrbgOYruRB7c68Q2GdEcDeTbjeq4HRaXKJ+V44MEfrSGX
ApsdyQfCc3cfs4tIJMJruOaVFVdKctEC18fEv9eYC2MketVVPBKEe9Sbzd5h
0+GPz2GLi9twPbfZzAWI7YrishrHXGbZiIXbIN44HIkylC5GBlsfuM6R3G+d
vwrTN0zxxoFIkBjjwW1LcKz4hmE57Ggl26HXVHJ0QalL2YnAQ/RTQqlphVf1
eMED17zJKz2bRBzYywCgCntHreiyzoYTH8daP6GHlQ79RZxCWrj8o8ZE3B54
2L2dljg5nmJG/vuHx/NHh15ba71gjd9hPanR718QX74Fv+zsPq+glv19JFxd
7b5gNp+8CzfziG8in8WpscsChoexzeGqAw/RPbz69Ojp9DNalX9lx4b0tvmW
fd8K9+NUKhHeY12Z9vwk3g2estFC+npmOd4tA8yj6Xlhg2PPItOfWezPZoZ/
+WNXF7idt0u5xIdHJpP3VWr3hbCDbpgLHO+38Cbq5svS+AgmpOQCj4YjIext
ztabNLW8W0FVBh7cuNPQo2Sp66/tCGLTcDjwsDby+C+O18s/KJ4NbLhonLtT
idiWtUmlVEHqa9MTooOHBcZkyyTEHkSi7aJviKYLSl3KqgMPLm73n08eLLq4
8FCqOUsp8DCmr2V2H9dOwr5vhfdMY4lEHNjLAKBOpeVj5s6UftGWRoPF0mg5
wjxYrB/7Argr1p4Xv2hxAtxTyGye+CHGe8OLbTq2GistadHck0vbdbL8nEzl
kKUi8LBQd3Fan9Y0MZo+7+nzrC9PIT5hHghVa71ZdUhkquiMzXsKGXFxiLfz
e7A2dZN1df7BMaLVWfNpzN0xUfLBX/7Bu7hnSzBPfpAc1Mr78cg/sdMGUb35
vBS42wD5GWUHA4TsJm/ObGCebMAbDCCdDbasOH6B26Pt32DIPWE7IJJ8Wppe
d9Sah0B+Wz37HA+VTxzlytMvcFMS+dgNoz7XGk4Qn4ge+cW1SrHFFRMlvtyk
Rok2kNg1R6LHWIszlrv7MlA4W89Bi2Mix9qUmNK+0HHf0XoPjzy121qYXLMM
9xwPrrbznjMTvK9WeuvYPTQoMOIo/cguXlLTuXpE1IdBvaWWHBmZJF/ntftD
rUuxbyYqFb+rRU3K3AM0uC4w3uBPXtugzWhVPzqw5FLgPdWEkx1jvTl3rLXq
WZ8801sQVkllQ/VeBgD1DJbEaMubXYUjQidYEsuYGQ7yXgnXzvLmN9yiRyaL
h5jKPsVUmAgxdZislKmh7cQpcxM7FFZd4GGhX13KPWaTMiQ4mntgpuDJkH79
I7mnJxTuDhY9AdIvaLfN8zPFq8s7InjiZU8//yGDAkMiuLfTGnVJO0MDhzDP
PxQ/RJF5pBStN/V8S8EjPQXPH7UUx0dM9Geea0o/EFIqBYliETzikrg2hQre
2CufCP3kTPrZkiNDYshTOe9RFX7+kVKrk9hwP/+ASZGx13id/8yTu9SXNr0p
2oSYUP7rgImrw/Ro/nMpOURx0Q8O9fMPpIqL/xAJv+DdWnoDlwXSuZTYwD7B
TK7IZ2wGUjuafNYoeWXnDVns7Re8S2t/X9SmxoQMp3Lu5z8x4giRZ97YJLo2
8h+vSn64nKoQgpppTbb2aKhkUEsjwh7B8zmJxZZxuRHWBz//MUGR+9J19l6x
R0Qa5PNvB/GOoEHku5j5b6dVTlm7U3Bl95tE7ALhw1qJ0HQn25Fbm7o1ZDj7
XFPqeb9SKdjQJe2Yzx2V4uf0KiWiZi8DgFNqLR93YC7uUu+KbQNyuWFm/vwn
FkJbwT4qSth0c4PIs4ZtIft5W85/0qZHXlMIAOCCeK5ro0NfS1Yj2fMS9S53
q2zrx3vWZe/AtdTPJd2pyKBlLfkCU/Ak9n3EPalBBeQzrnVnVgZFnGr7e5gZ
E2tzgw/bhILAAwB8T9pSm66NDpaNV7ydLTdi31zPM3ylQj82tDLs8BVO7+GR
59v+HmZuEeLfu0Fhhs0E71N7sywAQEvK+snyDNPn8swIy8lKb2fI7XRJTK96
T79hQZFx6KJta8g9PNI64nT4pEjR+1vbLKarxX9WbHqV9Sbx2ozYUCrs8A+7
4bqeAAAAwKPIcdTLggKG8F4g32dQwKSImAT599sDAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACK0HAAAAcBO7gUdCQkIFAAAAgDu0
QJsJAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAgNflbg3oSRgbk+vtnHhSbsxYcisDtjqxlfHh
PWnh8e7PmNNc2SLHxIdRWx/mS1vvLP62uLhdN8aBw+ebB4LTfHNzWu64tvjA
oe31DNhqS8e117fFmgEbdPUmv3U1b9bjxcp7W0rWZOm1k+cZxw9ncqnwBPof
zp2g2PMbWd4xec4koZByy52gHDk5yO8F7+Nvi6PbJeKOA6e1cP1AcHyVHqxF
OK6Zlbl2CHgxA56rHl45rj20Od49FXMlmRcTYD3iyFDBTYEHdQyyKSSEu3Ik
kplx4UCQL2duex1AbosLp1mqtNmV0uEfVfhu4dQWOcV3Ag8Xq4fFtcBDtHYf
CTxcLxP7XDwQnMKvRW7eRhzXDAQeFt84rlVujqMHgnfPUcTarccFF3iQR59b
Ag/quOMfxcSB43zg4bEDwQuBh01dotqF3FYNfDfw8BzXc+JK4CGa30cCj5bY
O94IPPjcvI04rhleP7S9ngHbPPjIcS3Jmd9KvrAt/MCDweRNutPT2g0n2xlK
HXTyRSGxeEI486dojTb9NVRuqW+Zr5gVCTqPRB/yMsNbe0CA/OEsmRqTT9lt
5ycuFWhJNJlSK6JmphO3VgmJjl25xKW3SKagJBKRLXwuzwJUDkW1XblKiPeC
NW+y86vbWGJLT1s3jc2YU2UoFXhwFY9tDLTJrURnomsHju0G5souqP6QkUtB
/lCS2Hc9hTPYORCk6ozaCilb8ru4WiTaxtWrZRaRrYqObU4rOK6l0/H8oc1R
lTFh7RUcKdLHo7ryIQtHcJJxasPZXWfNP+8rl45rxY21qLlyOXSw2zu7WreF
m423y1QcQW4jF3iw6xW2IvJje5m2IKUeSdnFubIVpyCO6KiOmwCqCYVtZRK2
sVB7R+o3LFVDBCdeyXwqpCb/y4j/q0SmBKTWyJ2gxLEoPxHZxJW2SFxQu2Rz
KFv4/BhSEE+KS9VOleDPz3amW2T60xU3lrci+nPF3yaqy1Biu0Q7kfhT4qIj
sXbnDxz5DXTtkFFMQXwo8Tl9IEjWGdUVUrgUWYzWFcm3TanaWW30uI5XyqTn
D22OVHWSS0FwpAgbiHgZcOFU4PiG87n3uFbYWJVXLtUHu92zq2h8KZsZVUeQ
Oym1eFj/Eu19bmZyWdvsKQQe8osLDnxB06Jk4CFcqXiN/L0pc8kTr0Vlauqa
ZGXqs2Sow9sc+WKXS1xxi5SG1theESQLX5A+P3uypSpdJcTzq24bVNhY25TF
mVRXhrKXM/F+V3mCcu3AsdlA1w8Z5RQUTi/OHQiydUZ9heSviPi3vRBRKm8S
O+tGOK5tMun5Q1tykxkqa69gWZm+AwdPBY5vuGxSrh7XChur8srl2MGufHYV
bTK7RjWnO3dyKPAQNONYSZ4qpbOtsLgrgYftJkhWY/FsMmcAxdQUT1DUocGS
OfWJPhedY+VPUFKJK2+RxHlAJoeyha/iZ5GqKiF1dFAzOlCSUhXVJmXHy9De
72im7VH6lKt27WpKSXIDXT9k7KQgfylx8kCQ/0WpvkLK3GOiOBrH3s5qy8e1
fCY9f2hzZM7MKmqvQuDh7KnA8Q2XTcrVC6L8xqq8ciltjvSBQGdEsj6LYy1h
FKR8unMnV1o8ZAjaCa0piDbNRgu0eKgMPJz7ZSSIdeXqM/W5/CA0xeotlbhD
JyiFHMoXPq8aC3Iu344kTfJXjM0gZMV8uhh4yG++wuWMbjuNl+qGcGztakpJ
egNdP2SUU3B7i4dFrs44UCGZTeA3d1gU95TF/s5qo8e1ciY9f2hz7LZ4iGe2
F3i4cipwfMNlk3L5gtiCLR4c6bOrfIuHRcXpzp2oziPVgYfoEJPpCaLjQIlf
OvKL2xSsbT9jfBg7WEu8UirUYT+06SkT92cx2yjTJaSQmuwJSvzrSabNR/gV
vyNY9Cc9YMmaPdnEFbdIVFAKOZQtfNnQV9QPa7dKcHuBqBvKbe/qNpa9A0tU
PRwvQ8XLmfUXjezVWWLtzh84khvo+iGjnILSTxtnDgSFn0vqKyT7ie0oPpv+
dOtpwaJuZ7W941o5kx45tGU60+VatGTrHnvdEczGZcDZU4FzGy4uBLcd1/Y2
1v6VS/XBftbe2VVcOYVHgb0jyG0SuNCPiz3YD9lBzoIZqK1mPpMNjERtUNJN
Z6IB9uI1ipqzyAwIxuIK8IYWcwcFN2CYP8DAOk88nRP52EOcmsLaBdsVFi84
vSiVjMQPBKa0rQkKhxnbJi6zRRJZlUlEqfD5O4vLMFuqgqNPtmSEe0FYMaR+
LKjaWNuuBN6QKgfKkL8tNttlkW8WE+9NchVuOHCkNtDFQ8ZuCopjG1w6EJjl
2FZl4SLKh4y45MXHsngbJRZx8+b46HEtn46nDm2pwEO2DGWqPe/Sw+bQYhFl
wIFTgfRJRvWGy+1N9xzXMhtrLU27Vy5nro/8HAr3B/kkDcnzjEXNEQStnENj
LL2E3zpBkWvWa7uII9GT95S1Pd6sM76ws1rDcW1xbTfx7jNynqrRvB7glfrp
rY11mC8cQeBhVBjMNBL64u626SVUulG6bbEegKIxBmCXN+qMj+0snz+uLS7t
JlVdFY5noIV45ZzmrY1VzceOIPAwtj3NfU9Xdi9xs+QNUy2ZDff9n64+p+Xr
jM/tLJ8/ri1ePrSFnRctq8U33Jsbq5LPHUEAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAADgddanyuOxJAAAANAibry3ewAAAIDXIPAAAACAFoPA
AwAAAGjWMRjU64zipT8PiNkabn2NDv2yG+ubbqyvleG/YUewVB7vQ9vAg0sq
Ppz3Ah0mBcHbDyWTpV7NbJN5yQ/lNlNmZgAAAPAE8nLMvC9P/G/hpZyNLsi3
LnKv2OO/UJiMQ5h/C140LNfiwbzAkVoRGYcEBIylX+ZIhTTWReSSJf/NvPmR
+DedW8kP5TZTemYAAADwDP6Vlw4w6PYEQdggvPSLAg/BVzz8yEE58GAv94LM
yCzCT5ZqJxHPI/uh3GaiDwgAAKCFCDoamP6GBOvn3JXagcDD2vli5bbAQzpZ
C9tHI2issPlQbjNlUwAAAABPEDYFCD93uMWDa0mwuLPFQz5ZmXRsP5TbTDsp
AAAAgFtR13HBgA36Ei/4nB6JIQg8mEiAHrHJG3fKRAj0wFG3BB5yyRIBCZtz
dh7JD+U2Uy4Fe1EKAAAAOIvfiyHZYUHEFfHC/hTuq/AE6+LciFCmN4SNSZgR
pDZDQRKYZMirP7ssefUXLiKdrKgDxRoqSH4ot5nyKSDwAAAA8B65EaQAAAAA
bic9sgIAAADA7dhHb6HRAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAMA3Wd+Wwr1YzedYH2uG56m2Cb5f39oQ63uLWufzANkXRd2w75Ju
sd3nzqLGAQ4s9l1sInSVJr/17Xoi99Jb8DSy5FXUDZWzOTFza9TyGyi/RvKa
4uKVyxv7i32BNfEP3wo8PFEaHt19dlfu9qL2/QsKtAyuJnCvZOXeB+f79cQr
gQdZLL4X7XgiVwpp8k+JKmdTtTrfrm+OEpWMLwUebnjto8rNcWfNJN9n7Vvx
BkvlEeF0mkKef2unB4q67R3gPsg3L08iRCYl3gWfEI7Aw9dWapcncqUyTXet
2vfrm6N8s6pQWu590+4sBB8OPPg8v98ReIA0Hz7nSOEHHgymnkj39LFvjpOu
nwnhvB49m05JanWCxZXnF6wuICaP96G4kK3L9uTFUWwOmUREf9JpihZk/+Rv
HTcPv79S0GMlv9N5q+M2TXpZujTIVUsVvrj0bHJlnYH3FZGyAyVMfH5acksF
eSZzK10gNrPJ7HTRnqPrGzcbPY+a/eLWElYufPmar1yAp/mlYWcV7IfSBcvb
lcyc1AxMBqwHiLj8hRU+gL1y2abGO8TkCjBX1eZIVQ971cDeLpNdUGkpya1z
asMtUptg94iwc7a0k6bi7lNI32NFLXk2lp9H1IQufVipL23ZTbZ35Cpnz05p
2DvcnKxOTpxtHDrcfJxc4MFuFDUDu4P4bYBy7YHC+JbfKcn2Hlr4HYjy8/PD
e0Hnpkx0J/g5QO84m9VJpinqOSX+lDisRCulSomtKlRNkIo9RCXGHYlyy3K1
S1XpiYuCXJw4O5H5Zxvf5EtYOnsKwTP/K3WzSWebTzj8jDqIrP9WvV/cU8JK
X8nVfDUFKPhTdhXUhltn4/9bqqy4oJ28EnGBmdSuoQ4EpiiEh7MgNUHJKxWg
us0RFYLKaqCwyxQuoNJL2ds6Rzfc/gEosd/tnC3VpSmz+2TS91BRy56NBdsj
ezBKX1CcKW3JIlU4qFVlT0UVkj/cnDuOnDjbqD7cfJ5Si4f1L1F942Yml5W4
ECgvbls48vML5pI7r8okFR8eFs/NxvQiyaUpqB7EzpULIYQnUn6awgpm4c8m
Kl47ywoOfPulJxl4iHaK2h0ql6bMV+oDD+UjQtQSyy8NFfvFjSVsp/Clar6q
ArS5UttfhVzrtO15jF1EZteIcqiwvfzKo1SA6jZH4nhRrAbqd5mzS/EPDWc2
3P4BKB9ryZ0t7aapsPuU6qQHippPLjCWPhyUzz+OlLZ8kSoc1Hayp1QaKg83
544jx8826g83n+dQ4CFo+7JypJpZLFLNSorzUzWcZfeSx+6jhHAyY8RusjaO
8Q95yTTZfU18K92KKFipbblJXfEli9fOskpHkETpuRR4SGbPzYGHdLblsyfa
BHv7xb0lLPeVXM1XV4DqrtT8k7ncid3xwEOcQ3WBh2IBOhV4WOxUAwd2mbNL
qfnKznFt5wC0PUXYPVvaSVNh9yml74GiZtZuezZWSpleTP35R7m0FTZZTeDh
+LnC1cDDuRORU5vZlgMPmYBWRE0LhjiqlK2WbCUUnIrlC5lePD5mLBs2B8Qk
xASw6SunOTYmfqvinRqOtnhIH4nO/h6Xmr81BB5SmymbPfFsdvaLe0tY5W8Q
O2t3LvCw8M60sh21LRR4uL/FQ24TuEJy6md4S7Z4SG+C2hYPe6TTVNp99tN3
Z1HLnzmF87irxUNyK+Q32enAw/dbPNRtZisLPKg+I9WBB1XfBKMFZLpa+D+O
evIuc4K+Kn5UKTW/+ESh6pInHJplDdG5DZRPk4kzFQdN8dpPqKwKg3OZYSf8
HjpuDIDcsjZVizsFSZWeKFeygYdkCStkT6KlSLA6tbPJZFsuexIlaWe/uK+E
lb6Sq/mqCtCml1ZuFbJ1T1hW6gIPiTEz1qNDNKaFSUEwp0IBqtscYSGctV8N
VO8yh5aS3jpnNtzeASje5DwVZ0v7aSrsPpn0VRxxzhS1wpmTI304KPwUdbC0
5YtU4aC2lz2F0nAk8HD4OHL8bKP6cLN3GvEy3hhm4aWZ+80VHyaawXoppz+T
CbC4H27hCbxLv7AFiRftyMzPXxc9YIM66NhBwtK3lQnDWpsQWjpN9iulW9WY
/AvqHkN+Qd7PWNGvYNtl2SISFj45g1zp8XMlvjHEbgnLZM9mS3mFyZtTzWyy
O10wf3iCdCnR39vZL24vYduvmGyw2xGvvHZeyUiXhsQq+OlbPxafQATHJjs/
M5CYSUq8m3g5pBoDeRsluItB3MwiWYCqN0euZjKfSO5I5V2mFHvYLKW8dY5v
uOQm2Dsi7J0t1aSpsPsk0/dUUSucOQUJiw8HOxcUB0rb/iZLH7mK2VPIg7rD
TTAnLxtqi1r92Ub94QatSS7TQQM+5cbYL/yfeJSWaDtVNZKw1VLYura94dDC
UJ3AYdbrGhHEKv6shhZ2Y+0Xm6Y52VsCPbnSNkVh69r2hkMLQ3UCxzGNWq1o
ZM4N4UbbL+KuFo+HW8I28LZGYeva9oZDC0N1AgAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAgLbD+igk33ngpPWx9q32AS/W/N8oj9ICAIC2ivfG
HPm3sjqdsnLgIXjHpSdRV22PP892aDtLO2bSpIu/3TeC+1ZyBtv5uy0VfSZ6
ZSEAAECrQr3MTvTSSfe92M7uG0VbKvAQvqzWI9It3dpxcULWUjK0GLqH+17T
3dKuuyWL+XNoO9ugQpxaO8l5yG3x+VceAwAASLG57rv3B7X9wKOFkA/S9+zF
mmzN4MUVFmGkQcch+/gL7JENPMiZqQVlgpOWeHEYAACAB0hcwqhGD+oaTb/1
xhqESAzYsA45sOmg4X8ewAYeVJsD1dnBvfaLbmDhDVrgd/oIxmNY5+wpHORg
fS8PkSa7oOrXUFrzI16Kl3nB/HKfs2yDBDrYoPtTyCBkhNRiimQCD6oAMdID
AABaHWE/C40LPOh/c60f/CiF35QhiF4EQylE6VPNDgFjycTJlKlLJzm/9RrK
v54Krq3CsIGKMSRiD3FOxBslaMYh52R6Xoh/WxPnt/+o+TdH2M9C4wcedjpW
ZCDwAACANkUq8OD3Sgiv13L9JvzrIP+CbrOIVH8HL/AQLMtbtTicEMQhZJps
TCLbsyMZeNhcu4WZ54ZSyH3OIxV4WPbIBh5kA0g7ZhAIM5zDdkSHXLjCKzQA
AIBWROL6y7+sKwYeTI8Jv/tDPIbTocBDpsXDdlwoPx0nAw+LxbZ3RtD5wnyX
IP+5EHk/i7AzhT+uw/ZbNZ0vCDwAAKBtsR1KKvhENvAQ/OpXCBIcCjwsgjEe
0l08TK5cbfEQfsXrqZG680XucwHRTSuiT+gbafeJvnUy8EBXCwAAtFr0GAnB
aAouNuD/SY+utF7WxW0OwpYK4YhQ+4EHN35V+sYTatXsV7ZjPASBh+QVWTy4
lAiQ2DiEy5UoDCNWpPy5ENWxwsYS/AEeJLo/ZYTMnzLsBx4tcJswAACAewm6
EkSXVK4JIjzB2rdCXeZ4/Sxh8YKYhLdIwNZ4ejbyK24tXADA3atCXkaFfTfC
zPBuKuFFMmyaVFTAziPR6CGKeYS9J6ImGvZjXgQj97kQb7SGxPPB+N92t2Tt
kQ88hOm0E4covCYgBB4AANBaSY63bEH8Vgg6Q24cydCyF2jbER3uhAeIAQBA
20B1mtA/pePDPP50cRGbR224+TFZLfPIdKs93C0q+0YInxvmKjwyHQAA2g62
78Mbrffirha3P5yzJV8SR4/xED013UV4SRwAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAADIsT5JDE/I9Kq2/cQw/tZ5ektdrM9te0d4hbfP
MLnca6RaH/Z9WLKPYnZr8fpoWbX5o9Lbx4incO9oE6IrmMKr5EEZ75W77kiK
ObLcmKyPEG+dJ88hLtbntr0jFHhuY1vmDCOffze8lMEbNYHMNvVkaeIfSu+A
cGvxCsrKd+q/p08aXueOnci9ttX27fDcWlrw/V/cRnHvUCODW7cEHuTibbpK
8Ik2FoGHSh4NPEQ7BYGHSp6rzO7dIyrJ558713kgceGa3HgyJN+oJR1veLJ4
BWXlO/XfFwIPJ3auwiJu3onUlZ3dcXRTg837UFq6RYvIhjUP/Je3JoS7JfDw
hSrRYjy3sW27GD0aeIgSRH1WqcUqs7fbVN0QeKjkziKVDzw8WbwtV1YO8YWj
0ok8KCzi/rOWYHGpd4wSNSos3jvBpNRb45lNlu5PtPavSfczCl/3Nnb1auZP
NrZhl2LSsf4p6P2R35u8tYvDOfGyCeFM+jYbovCV4jYK135auLExp+ls0Bmw
swp+I5h1cdGuZ+thrgPJyuSc2suSWyS1IK/lTWlBbl8r71zJLKkMPFzJFVuq
LtRnQfbcsCNkt64NV2Z37xE6M/zFqTSZpaz1RLCzxMkGBLAXU9vUhC3PkrtD
XU2Q2HA1R6JiBbBd0P0VXq6slIuUV2iy9cHhui2/FsFJQ7lU1VUY5cKx+Vxq
58qXIbUKhUXcvhMlOhNte1WIRMhTN1k+LdfbYiUXeLBbJGyx4UdHcpGS8Dpi
01LHrY7rqaTWyBYgVdRSVyLR2nmHg8yyXJW2iPeF/Fdy2yi5dtFFU/Cn7Cqo
amadjf9v2WJUl6xcbtmuYUGZ8/D3ET9BhxaU3rlKhWkn8HA6V1K/HdxUn13b
ETbJ3pCV2eLyHhEsTp02iYsj218subOoyskUrFQrtOCCIrhQSu8OB2oCt+H2
q669CqC6xcPFCi9TVrwVyR2esvXBqbottxZ+TlSWqroKo+JgkTyJiVaoItti
7tyJwvl5CQp/vvEuEC3dqKXU4mH9S1SG3MzkshKRknyTUXw43bDD/FKQ3DUW
cRXlEg63yaqdZQWHqrDNUPYruW2UXLvdc7X9Vcg1qSle7xzOueomQf6RaH9B
eztXtsI42NXiWK4UGy1dqs+u7QhBqjdsZbaZzeE9YnsJYxeR2Vmi7VUoPf4P
QKXdoa5wJAIPxaqrvgIIF3Nn8SqVlcJvBMmiFpwfnKvb0msR71z7pyn7FUbd
wSJzElNYuVwwLOLOnSgVeIhaNoj0pYfu8JqPPBiNOBR4CFq0rOyevriSSQi3
NuxYW7qYQrDNg2Tjj1RW7SzrxLlabhsl1+7kudr1Fg9Hck4lEM58IHOcUNlg
iU6VCgsq71z5LKkLPJzMldpD2PH67PKO4JfbDVqZLS7vEYcDD/H2qgs8FHeH
U4GHxU7VdaACCLizeBXLyrY12+bwlKkPTtdtmZOAREQnf0JQVWEUDxbJQlMM
PNRkW8Ctx4hEMCbR4iTQsr0trrR4yLApWzqF+JixbEtaQEwC285jUdviIX22
9PCPRDtrd+5cbRHsd5mBPa7+0JYiX7BsrZO+dsi0QVns7VzZLNkPPFzIlZO/
HWR4YkfcyJXZ4vIeaaHAw/0tHnKbwGrZFg9JKgMPpcNTsj44Vbfl1yJZsHIn
BGdaPDiqTmICDmZb8ivXjhFqpQqDS6lhpaJtbNHeFqpzTXXgIdoc6ioj2TQt
bNMQjkqyhoL8lVK9imxSck1n4qLjOqbllrWpzyq+kttG+bXzNlbQZqW0Cvvh
pfgUqipZqZzn8WI8yaYk8U8P3rlFeUF6rUo7V7bC2A88XMiVaKe4oT67ZUcI
i+2Gq8zu2yMOBB7WpATJ0jVWNEJGssYq7A51hSPc8LPqqq6qCuC54lUqK26r
5Q5P+frgTN2WXYswBLJXquoqjLqDRXQSE7Xe22bDNtuSi7j7GBGtVzjAQ/TD
wTZND+ONlObCAPZDwdBf4YHJfCYdujFtQcJ+KGHHn82y7Ip6KoVevFha9NPM
dlm2SUq4IeQMCl8pbaPU2nkby43ZJr5VWgU/fevHoprDJkXMrzpZmZwLm+ak
QmXeUvQ4DVEpyS6oZudKZEly62x2ugu54tdA1+qzO3eE2I1Smd27R4SLszMz
52omY4L8C7eXaqDjFZHghhHx6VdydzhQE/gbru6AslMB5Pto3FO88mUlLFKZ
w1OxPjhct2XWIjhp2C1VdRVGsXBkPre90tnOLygchUXcvhNF9U0Y8gnzwO2X
Fos9oOXxQ3SKukFKAL6nDVRm+ZYEcFgbqA9tjUM3F0CbZdMm4I27mQDcoQ1U
ZvnxS+CwNlAf2iCq/YTpTkVVv2GJWyNxYEKr1cors7BNG1zWyutDG8V2Ktkd
uQ0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADgDtZn0eARNAAA
AG2C8Clz3nt2n+BVj8Jv8MRdAACANoF6d4yK956rQT6R1YXX0MgHHrYv8AUA
AIDWR+r15c4HHh57BSECDwAAgDaA6mSRDxXIQMKKCU6sb1Mi/owPF3xl01+T
FxNg/Zb5ilkR+6oaiQ95meGtPSAAgQcAAECrpzR2gt/xIegE4WIPcQriFg+q
4yaAakJhe2GEbSxU9MIswl+cijqY2agYBoEHAABAK6cQeJBfcS/PJS/9TBcM
GU6wkYOgE0Qy8BB23IjXyI9DeIsL146uFgAAgLZA0OAgYO0oEbBGAq4EHlSy
vIhCMA+3uHg2BB4AAABtgaBHg8QOLhW1OfC0QIsHAg8AAIA2iW7ZYKMFLlSg
RoRyN7cSAYNsV4tgYAa1SHwYNbPUzblUqMN+aDPGw7pGwdrpcafWwMO2zQQA
AABaEVGvCtdkwb9RRTDOk33OGHvjCT8qsHbKcMmGi/pyeLercO0Y3K0uvGEe
zDzxdE7ImRF4AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAwA3MbDbp66vKhCpqGkwms82shrramoaGJpsvAAAA
AFQxNTee3TB+wKChH4/ljAtZnpia02ww8uesq8icGTg+JuG6AZEHAAAAOMWo
r0+IHN5r9NdF5Zx1Cye+/8H4C8XVbLNHU33N9/NH+fV+b8Ph5GaTV3MMAAAA
rRYVeIx4Z+xaPe9Dk/5aYJ93V+w43WQggwyToTFxb9SnE6b37zsAgQcAAAA4
TTLwMBuLpw7xC9t8uNFgJP+4mjDyk6D8jNTAUcMReAAAAIDT6K6W3gFRVQ2c
orPbPvygz84z+QaTWV+VNXVkwO6U4uaqggkIPAAAAMAFVOAx9K13+o4dxwr4
8H2/uRv21+sNRkPz9wsDZn17vK7JYKktROABAAAArqACj2G9hocnX+UUV9aZ
zOS40nO7VgYGL8/XVesJFbnjRw5de+BiY7MR97UAAACAEyTHeLC2hI3r3avn
W7Q333yD9ObHYd/XNRmlZgcAAABQohx4WMgnjDFqqK6WQ+hqAQAAACfZDTw4
GOMBAAAArjGbjNrkI/vi0uxHE4aGuKOHrxRW2j5MHQAAAEAlMxF8mNS0YphN
JpPZjLADAAAAPGLfvn39+vX7gFJYWOjt7AAAAEBb9ssvv/Tq1et1Sk5Ojrez
AwAAAG0ZP/AYO6bXV9P60dO6tYs3MI4dO+btbPoGs/n60e2bNm7YeSK9iT8A
tyrnj3OXqxpwAzIAAIAdiYmJw4cv/LDPlC8+G5OVuqA4axE95V0LS7+8gJ52
/fj55KAP6Wna1CE/Unbs2FFeXu7t7Lcgs6k2c8sj/3p9xIiR/+3abe3hq3rr
U9aatswd+mL/T4uqm72cQwAAAJ9nMBg2b246Hbdp+JAL2szlVUUa20mXv1Sb
tYieCtLDrybNJ6eLC2bNGDjhk/fpSbNs/u+/x+6jXL9+nUjW21vmpOb6iqKs
xNyinMNHj1/Kq6qvLTtw4OCh5CKz2RS/cvyeSzl1dfUHZg8eu3JPA/Vi33O/
rRszaOCrH31RUIXAAwAAwL4Jn2TlX4/6eNTFooyVkoGH5FRZqCnOXlyUGU5P
6Zfnp12Yl0pNR38PGT2y95iR7xLTqZNH/2BkZWV5e1vtayjPmT3eb9SInm+8
9tpzr747deDbb7715n2PPVnWYDA0NRjN5r49//P3x98+X1CmN5lrtXGjh0/U
Jv78XsA0BB4AAABqfDklpTjr64N7tqVf+kZ94KEwleYsLsoIL6SmtMTQxJOz
6Sls3tAxo/rQ06LwGecYly9f9nYZcOpLM2d/9GxMYl5xbtqkl7tuv5JbXlo4
+/W7LlQ30jOkpVw+vnXWPwcvqKrQLvii77bzJU3pB/p8jMADAADAvr17LZfP
fleev/zU0W+vJq0py5XubXHLVJa7pCA9jJ6uXwqNO/AlPR3bP/3zT4fS077f
diclJSVSKisrTaoeP+JOROCxcEzvkzVN9bqchf2fS63XN9dXRb1379mKuqLU
5Bq9wWyxmA3lr3YfcDJW8/BjXZ574aXXnnviH4927T9heY0ej3wFAABQsmqV
JTNlHdVMsWLIwFSHelvcNVUULsu/HkZPx/cH7/vlC3ravH7K9GnjZnz5CTHN
nDk1OfnyJUpJSYnnCoQOPE7VWgOPNCbwOFdRdyi056dRsRcvXUr4KezNkYuL
si4dOrBvD2FT+D//+07sybQ6PGseAABAUcj0vPzrUXQAsDNmZ8q5dS0feMhN
2qxFZDRybSExJZ2atX1r4I9byGnu7E8Wzg+mp9h9O1MYbhlDoq8p/XrKmOQm
g76uZNXEATl6g1Ff//0nL6fVNRkasxeM9nvxxRf9AqYn55Ub2CfLF50bPTm0
oh630wIAANgxJySxJHsFfaFPPLnxwolN5Xke7G1xy1ScvTjv6kJ6Ovb7lA2r
x9DTN5Hjv14xj55WRIReZTQ0NKh/DrzZ2NysbyCCCrPJ2NxQZyTf2mvS19fS
YYa+vqaqqqqmsdnET9Cob2o2GPCGGwAAAEVxcZb9u3exkQYRgYwefskrvS1u
mXT5S3OvLKCn7NQFy5cMpacNa0M3rNNsXB9BTD/v/DE9Pf06paKiouXHkAAA
ANywwsIsOVfW8K/d61bFXjqzweshhHunguthOVcW0NNvOz+fP6f/vFn9iGnN
qs9jtq75Ydt6Yrp69VIWo7i4OCUlZfHixStWrGhuxr0qAAAA7jE/tIQd4EFP
cQe2Htob4/VQoWUmbdYism0kbT4xfbNyWPCk9+hp6eIvpn/5Rbt27W7v2GH3
rz/m8uDVvQAAAE5bNP90ac4K/rX44qmNG1f/5vvDPDw6leUuWb188D1339r5
0bviDkwJHNvTOo17+8jhPUeP/EZMly8nFTDq6+sRkAAAACi7etWyddMB2xhj
/McXslJWe/3q781Ju2LPjqAribNzry6oKFjG/yordX5W6jxiWrJw0LCPXhk6
mJyWa2acPnXs7Jk4Yor/42hxsZZWXV3t7Z0MAADgK2bMsORfkwgwzhzfvHfH
du9f/b03VRevbqw5KQo5FKaC9DAiIMlMmUdMp4/P+LDP833ee46YNqxfnpaa
SE85OdfLGDqdzts7HwAAoKXNnlVXkB5lexk9n7Bp2+ZfdfkRXg8AvDKV5S7J
vhZNxB6uJ1WctSgjeR49bd0U8PprT9FTP/83cnOvs1NlZQUNA1kBAKANW7H0
D7kHpE+bdCorVSImuRGmtAuzZ0ztpb65w4mJSDwjOZSdXni+67P/7kJMW7/b
UFZWpCvXElNpaXE1o7Gx0WfHkJiaG8tLtXzFxcXVdQ0GKr9ms8nQWFvGfF5X
1+Sr2wEAAJ5VX2+J1BwvkxlEej5+07bNu7weA3hlunxm5peT3/bKqnOvLMi4
HJpOTZvXBXTp0unxzg8R0zvvvNlQX61vqiOmpqb6OkZDQ4O365GlIvPsiL5v
9XrH731Wnz4Dh396WttIxB3NjdXb5/h/4Pce+fl7fv36LatuMiL0AAC4AU2c
aCnKWCV3BTwbF7110+7KwhuwtyWiqmRXRaFv3dRTlBGecm5W8rmZxDRtsl+X
Lo/R09ixY0zGZnoyGpubeFqshYQIPEZ+NPhQchH7SUOl9uvgwaMmh5sshsyk
n/p8NKasRk82fjTo3n37raVHdXihDQDADeizz0xFmbKBBzEtmHM896rSDG1y
qinZ2Fgd7/VsqJyIgORM3DR6+uPQlKee6s5ONTVVZpORmIxGA8sTj2m1DTws
luZzses+HBiYbjY1VZUUFJbSn5qNzYt79/pkc0qTAW0eAAA3nDUrDys/rIMM
PK7ccIHH6hWDizLDvZ4N16c/Dk4+9vsXxDQl6MPnn3+ONmPGDCr2MNMTy5WK
JBV4NCbsWtF3eJCW95HJaDi/afxbb76ZWV6PsAMA4AZkN/A4+0f06hW/e/0C
2pLT2T++XLrQ3+vZcMtUWWidKgqW6ZgpM2V+7K7PYn/5lJg2rRnzFhEHUKKi
opyuSDaBhyH5+E8f9fefHrmPnaemvOAtYmVvvNF3VFB1fZNrNRcAAFqfgACL
NitS+cpVlLFyVcT+gut2ZmtLU2n+tktnZns9G56bqFBkWQU16fKXluUuKaWm
Cwlf/fxDID1t+GbshzwGg4GtNgMHDuxF2bp1K/shObjU/8233urZy+rtfh+N
3332UrWB69Yxm816UtOepaP8hgZW1CL2AAC4sYwYYSnJtvMKWuIitXzxoZwr
N8pNtTUl6+urDhNb7fWctPxEN4zQExGQaLMWs9O2zeNimOn993q9TtmyZQtb
l8gWj8EDf0/MbmA0NTUZZbpvDPrk997pXVCGB7oCANxY1q06VJ5v/8aNi6c2
aMIPe/2y2DLTrh8DE0/O9Ho2fG0i4hB6+ixw6euvywQe4jEeVmZ9fdzaoPGT
VnOf6I779X67SFfbErUcAAB8xuZ1sWoeTFpwPXLNytjCdDttI21gunxmZtjc
D8pyl3g9Jz44fTlZE7FIk3NF0+vt51evXr1t27aLFy+ydUkh8LCYjQUph97u
M3h/Wg35l8kY9tkH4xbE1jcbW6yqAwCAd5nNlp9+ssQd+F7NMzoqCiPWRsbm
pLX93paCjHUXToR4PRs+NZXnaWbP0CxeoMlM0ZTmkN0xu3/9saGhwWAw8G+E
UQo8LBajQZ94YMuUYX37EwYM2LhhQ3mtAQ8vBQC4cRDn/P79LaU5X6u8+qSe
X7dg9nGvXwQ9PdVXnago8K2Hhnlr0mZploVpFs3ThIVqrl8iQw768w1rZxsM
etsaZWiqra6srK2X+IqucSaDvrq8hIaX0QAA3GiIwGPqpFydigEe9JR0amPI
tASvXw09Ol04MePIvi/IZ5Z6OyfenfKvazav00yformSqLmaxIUcxLRt85iz
Z0757PtiAADAZxHXjpjoPRUFai+yhRkr16z8vSC9Ld9UO3LoCxnJoV7Phhen
nDTNrh81nwWK4w12mjZ1TFNTo7crLwAAtDImkyUx0Xxg9w8O3TS6ee3eU8e+
9frF0UNTWd7q3KsRuvylXs+JV6bMZM2x3zVjRmjSLkiHHMTUu2e3ykodmjsA
AMBRBoPFz8+s/MBS2ynl3LpJn53x+iXSQ1NDTUpF4Q33ZHhiunZRcz5eM6if
UshBTwcPxur1ckM4AAAAZBmN5iGDKxx952z+tcj1UfsKM9rgTbVXEmePHf16
5Q02uuNKomb0cM3RWM25eDshBzG9986TjY313q65AADQKplMpl+2/ezEwzl/
3LLrwolNXr9iun06eXTqtYtzb5ynlaae14wbo4k7oEk5pynLtTNzZeGyhMNT
tm/fhltRAADACUajJTvbdGRfjBMXrCuJa8eOTvL6ddO9U3Xxms8C3y7JXuz1
nLTAREQaU4M0v+0kO1bshhz0RMRj/335OaMRD/sCAABnNDVZevY0qnlgqe2U
e3XVqoj92iy1T/9oFVNt+Q9V2tVtu7kj+azmTJxm3kxNTDTZw1Kep3ZBXcGy
E0eCKyowphQAAJyk15vf86t2+hJ2cM+2jORvvH4ldeP049av2vBDw4iQY/d2
zcK55NPArl3UlOc7tnh53rIXe/wHUQcAADjNYDD+/ut2py9kiSc3rln5u9ev
p+6aTh+ftjNmXHleG7yLNvmc5pcfyFaO+EManYPxBj0RxbJwbv+amhpv11kA
AGitjEZLcbEh4fAWpy9n2alRASMvluau8PqF1S3TwrkfpF9uUw8NqyzUpJzX
7PqBfPTo+XiNrsD5pDKT58+YMcPbdRYAAFqxhgbLK68YnBvgQU/Essd+35qV
strrV1jXp5rSTbXlu9rMM9J1+WRnyq/bNeM/JgdyVLgQclRRzR0bVo9FJwsA
ALiiocH86iu1Ll7gEk9s3Bmz0+vXWdenyxc2VmnbQgRVnqe5dFrz+y7NiCGa
3Csa1wfKElHHqaPTJgQGervCAgBA69asN/xx8HsXr0rZaVF9+1x19MGnvjal
nJu1ac3w1j66oyxXc/mM5odvNZ9+oilId0PIQU/518P79//A27UVAABaN5PJ
UlXVfC4+2sWrki4/4szxzZmtvLdlwZzWPbqjNJd8FsfaSM20SZrCdHemrMtf
uu+XydXV1d6usAAA0LrV1lqef17vlpaKy2c2nDzail8YV639Wqf9zbl7Pbw+
leVqMpKJwEkzf7amKMP96V+7GDoh8GNv11YAAGj1amrMzzzd4JZrU1bq6hdf
KPD6JdjpqUZ3tEob5fVsODSV5ZEhhzZLEzhWsypCo830yFp0+Ut375hqMpm8
XVsBAKDVq65uPhvnnmaK7LSoV17Oc/Q1cz4ylectXblsQGlOq3lGui6fnBIO
a/77kib9sqdCDnq6kjhn2NCh3q6qAADQFlRX65PPrnfXFSr98jfXktZ4/aLs
xDTl87euJs1pFc9IJzJJTDu+1/T9gLxVttLza0Rzh5PMZrPJKMIvSeLfrt6Z
TKzBZOIn7t5bneUSpFZr8tx91WZqBbbpU6t1oCqazczN39YEcSc4gJdVV1v6
9a1z460oOVei3nk7w+uXZmdynnmgojDS69lQM61eQd6uknLObberKE+7tk8p
LCz0dlVtlaq11/v96//x/c+f/vfh//Qqor5tritv36FjfGGZ0yGd2ahP3Dn3
0U73sKk/3OWfe/JLDW7Kv7Gu/K7b79maUWD7BuKU3zRPPPv6H5nlblqVgNnQ
mLTl89vv73oiu57/uUHfEDXuma6vB6mNeAwNJ/ZtO5VbQfyzPP/qS93/viEu
wxMZBgD1Kistz/67zo0Xqdyrq7o/Wer1S7MTU13FnqoiX78XODxUEzpTk3TK
yaedOzGlnJsV8lUQfic6hwg8Bjzf4aOQjadpp07t37GBCA/uf7o3+UPcZDh3
7lyN3skwwdBYG/NV77/85c+3PdCVTj7+SOytN//fX/73r1/9dKXeNlZwnLGu
7I6Od38nFXg0VGqTLqXWOpt5e8y6/Isvdv37uJX7eB+aGkovPXfbXz/7/prK
+njt+Jan/t3jSHoZ8W9Dc1PyxfOltU0eyS8AqFZaot/27R43XqcqCyNyrkRd
SVzr9Wu0Q9OQgf/Jvx7m9WwoTB++R/atJJ0kHwvWkv1Bu3+aeu3aNW/X09aK
CDwG9rhz8saTZprJRPxmP/7NiD+1f0BLBXNOR3RmkzHr9PaOf7v5+Slb6hsa
mOSNdbU5H913d/sOXS5ll7ief4XAg+7D8Fw8qq/TLRny4gPPji9jPiHK7vS2
uTd16lHcoHa1V45Gd3/6OTrwsPC7XQDAe4oKm9IurHPvpargeuTHo5K8fqV2
aNq6cZTPPjRsQF/Nj1uIUm3pkKOKfKPczHmhUzC6w2l04DFl0yn2E7NRn7J7
xp86PlhnNjfXV9z/wD9OFpULyteonzfhg/ZCHe+467O1xwVzNdX8OKffPV1e
K2oUtTmYK9N+uf/O28P3Xmw0GjaPH/BmwKLiGnIek6FxU8jAN/qF15D/bjq5
feEzD95Hp/9At5ciNp8gFzYbi64c7vXyk+Snt985bMiy/7upIxV4mH6c3GvI
qE9efKpr+/Z3jA7dfH7/qn//912qF8NcnHn6kw+f69i+fYeOd/b+IKh/n38H
RRykNqVxz8rx3f5OreP2u/3HTGxoJBscastin3ni8ekfDX/iH3cT39z72LOR
2+MaRZth0l+PW/XYXf/45ZK1N0dfXz3T/4GX+i8iYoemsoy+77/RoQNVOA/9
5+NvjlY1ENto/GXuoH4Dh77ybPf27e/s0ePVfzzQ/n//8pebO94zetWxiqLM
N5577LtT2URSTfXV60JHPkyuvP1DXZ5buj+T7rtpri4cPvTD2zuS6Xb8x1Nj
lu8qr9UTn1dcPTby/Repj9v//cGng0Nj6i0A4KSioqYrF9zcOlGYHtn18XKv
X6/VTyfituryfa6TpaJAM2yw5vtNmtyrZMjhlTwsXzIGb6F1hSjwIC7r2vQ/
3vrXvXd26kVc6fR15be17xBfIBzjYTYlJvy+Wejbb7ckXC3lz9VYUxby/l3P
9A6y/QVvbKh88pF7e4XurmhoWjvc78Wh8wqqyBYLU3PD6sl9evjNrbKYtNeP
P/1I5xnfJZSXlxcXJk8f8Nrd/xlcbTE3Vub263r7W8GbiM9LtQVzP3rqpr/c
TAUexu8CX7r3ztsjf/qjtExboNVd3rus279fi8ssb6oqCPH/58uDJ+UWlpQW
F66cNuDmWzqOXbjPZNQn/brk9vu7fLf/ApFaQdbpvl1v6TlyW21Dc3Xx7ofv
6vDq8K+Ss0rLyvIWBbzV/a1RacWimmauLsl974VHx674lfrLWJ0d9/Bt925O
qjQ1FI/694NdhizILC4lUk7e/81DDz2yIe56k8n445fv33f3neHfHiotK87M
zLsQ+03nbv/aczGzrr6hLP/qi0/euz4uw6CvP7D807s7vxh7MaOstGRb2JBb
73sx3Wg0N1dOer1Lpw+/TM4rIpJNO7bl6e7dwrafrKurnjPar9eI2eklZeVl
ZYc2z+natfuha8XurCgAN4zKSsv7frqyXDdfcysKIrLTopJObfT6tVvlVFP2
s0+N7iAijc/Ga6LXaDJTNOXee5pZ4skZGzd+4+1K2rqRg0uf/vNNN3e4x+ru
O+/s+NeOf//ueLqFGlwqEXhQN5KI74QR3gtDaKgqmfTGX194f7btSk1NNU91
vv/dBbGVjc0ygYe5LiN+/bodpXXU54bGYxundbjr5VST4VrcppvvfjKzge5a
MVcWxHW4pSMbeNz/xNDkoko61En5jQ48SvOSYrs/8eQvqQVmM3njSHnB2dcf
vo0IPJrqq2b2/cdL/ZYa6NtizKb0Y2Ht7320tKKGDDzuu++nhDTqK/OlHXO7
Pvb24fRS0YYYmmr3hg+/r8f4crLxpH6vZuw9T/epNJiKknb+9fbHUyvr6GYK
k0G/fkyXbkOXFVfXEYFHpyf7X8jX0Znkd7WwgUdDdVng+//qO/VbA5VjvS57
5cr1WfVmXcbRDnc/craonM4wkewP03s+2Xd6TqH2i0H/ffiZ3lsPXjBYLPrG
uqrKiroGd4yhAbjxlJVZXn9V54lrli4/4uwfrj6DvWWmr5cOSDo10+vZIKa8
a5qFc4n8aDZ9Qz6Xw+sPUJ078yPid5+3K2nrRg4ufe7WF/qMW8BYuGx1epHW
SF3apAMPU/OSyYMfEHrwoYeDN5/iz9VcV7E84OnHXxlsu9LmutyuD947Z/eF
BpNBJvCwmI3NuRePzJw1a9bMmSPfff7OO+5of+dLl436U9tn3dblZbYVxVBb
ekfHu9jA46H+ofm6BvorJvAouXRw5ROPP3OpwNr5UFdeMPqNx8Yu/K2+OmdY
978NWBrHZqwq78TNt993oayiqnj3Yw92OpGaR3+eHqt5ovPbEm0IZqM2dc8z
ne7fcVlXX130yesPfRQeazYZL+6Z9z9//t+/33ff/dbiub/jLf9794Nj0ksr
icCj84dTs8usmZEMPGp0RQNfuH1aNFueZoPBSGxy1qnIv918yz333ssle+tN
9zw4IDGvPPvCb31fe/bOjrff/8A/3hw6+ZvoX6sRdwA45coVfeJJjzzhvCR7
xcsv5nv9Uq5mmvnlO14f3ZGVqolaTkYdRLxRmuv9kIOYTsfNz825hqF4LqK7
WiZtOGFgGY3st9KBh9l48Ke104S+nD7jp1N5/LlMhqaELbP/ekunqPNF1nVl
xy7/elVxQ92BkMEd23eOv1JosggCD6O+bsXEt4jAo9LYfPXUti7dnhw0bmpI
SMjq7Qd3R35KBR7N53YtvOnRHuxa9NXFd3TgAo9Og+bnV1jHYrCBR+qxNV26
PHUux/oSn5qyvGEv3zd24b6GmsKPn73pvSk/s6mVZe66+Y77rpRVEoFH54ce
PpmaT38uG3hYLPVVJUF9X/IPidZe2vXIA12O5jYRgUfK70v/547HkzIysnM4
BUW6Jn0TEXg83m9aTrk1OpIOPMoL+z172xerrRGRydjw+8alO88XZp1d/7c7
HzyVkpYlSLa8obHZbGquLC/Nzbq6ZclXgaMHd374wY+j4hF6ADjh+vWGq0ke
uf2kPH/59Ckn0y9/4/ULqOIUUV+x58KJr7z40DAi0vh+k+arYM31S+STz71d
INbp8pmZ04LHGXmXSHCO7eBSPrmuFqLkDTaMoiG+ZnNdcfIHT955S+cXN2/b
SXxQcf77CeMGd+7SuePNt36xcl9Do55I6buJ73d6IzC9pI6YobEkbdRLDxOB
h05fvXLkCw/1nFZQ20Sk3FBdHjW+NxF4JJuN5VcP33XT39dcLKYjzrwT39z2
t9sUA48yXea5l/7ZbdGhi2SmTIbc5B2Ptm9PBB7NTbVRX7zeqccQZhymcf/s
t+6877/llXXVqgMPU3PDqejPbn/8naj5457pO6OZ7JkxVVw/csefb5u751qz
gSqT5vrZQ179cMb26maDmsCjsVY346MXnx04p5HKcXVOwqN/uz06rb668OID
t94+eVtSfZOBTvbrL/q/91lUSXVx0MC3Zm4+Vm8gnwZXVZITPqRL99dCGm2z
CwCKqqsto0dqtVlfe+jiVZa7PG7/Vq9fQxWnCH1doreijqtJmr07NEETyUeP
lvpMyEFPp+PmpaYke7uGtgXOBR4qmQz6wgt7er/U5aa/3dyV8Hjnhx+6709/
+lO7//nz0FmryipriMtqzvF1XR595P3x82JiYoJH9n6kUyeqxaPp1MYJD3S8
U7N2c0zM95P79ur2xBO3dOz8e6HZ0NTw7czBtzz07zXEF99uePzB7n/5862K
gUe5oak2ft34rg/fu3bTlu+3bn35X107dbqXCDyIi3RJcuwLXe95w3/Ktm3b
1q6Y9Pe77pgZc1nfbFQfeBCBgU6b8mbXDo916zb3x0vWz4xNP4eNaH/3Y1NW
fR8Ts21VUM97Ovf47XJBs1EceBQm7un+6ENjl245nniNDTxMxubS8z/9q/O9
o2ZoiK38pM+/urz/Ra3BZDbpj0WNv/v+R8YvjSaS/ebL/vd3eX7zsbSGpsZ9
q6Y/+fhjk5Zt3bYt5ptlwZ27dV+8Px9xOYCjSkosfd4r8tzFqzxv+bu9fP0R
poknZ7X8Sk8c0XwSoBk3hgw5fKeVg52STn114XwC8UPY2zW0LdDXVYR+PnAL
NZTUllFfN2BA/xRdjdMdWmaToaY8/+juqPdpfT48mHgxLnraM4/c03vA4pJm
M7GK1OPb+vr79+3bN/poxo8Rkz/78vsmi7lGV/b70uEffEh+Hvnz8bTrZyb0
HxhzrpQcbFlffXT3avKLQUPTUtL79R1wpLjCZDEf/2ba0IUxNczdu4VJe0eN
n5pRSV7i66vLsk6u70em1m/X/kMDXn1ofMRhCxkaNZfmXZoX8CGRmP+Q0SlX
rjdRDxzT158LGDrsamEVnVTpxT2jRnyZWiF9i2pzY92WORP7DfgyvZ4rJ2Nj
zdk/fiYzSaTs/1lyVnEDmbL5xJZ5I0I3VDdYM9lUV3Hi+7kf9O0/Yclv9TW6
iWMGH6cfJqZvLMo+P3kEmcDns77JLqujOxUNjTVpKccH9KOTDTx7vai2kexR
aazRXYnfSRdj3+Fjr2XmVrrlAW0AbUt+1rXisgoD81OqtkxbVlio58XoZ87o
z8V7sEVClx8xcujlvKurfPPtJ+X5S3u//URx1qKWXOn5eE3/D8mHgF1N8omB
HJLTwH6v4QHp7kK+qcXQbDDKNWmYm5ubXR9IQ6xFT6NSM5uatZlpBWU1TQYy
ZSoLJPpmGYPRSK+P+ItagswesRAxj4F5KwuZBJMa9TF9l4eBmpNZqYnsDzKZ
zJV5l99/+41d17KaySX0xbnnXut819J97JPJzcZma974GSaWZTec7MAgu5Jk
yoEuxGaD2eZjIvNkwgYjmxSZKaORnxKxyXpyG41UMgYjt43EJlObbzDKJGvg
7xo6E/TnHnxFDUCrVVt05YNunebsyqD7KitLipYP8/t41to6XpCemFh/7aJn
3+ZWlrs89pcfffNltbr8Zft++bzFVpd4QjN0kObCCbKVw2dDDmI6fXza9WsX
MaYU1Gsoyxz4dJf7O3WOO3HmzOmTA9955ZFOA5Mr9d7OFwC4E/EToq4su6Sq
Ou1SYkpOqcmsv5ZyMfFaXiP93oTGyj3LJ4wc+tasX643GizVxScn9O8z8qMP
hsxYxQYeNTWWkBkFBemefSdaRUHEqGGXif97/XpqMy1vbrhSVeSp8S386UKC
ZsJYzdFYchxpRYHXN1xpSj0/q3/fNwoKCrxYt6HVMZuaC7PSvp744gs9XuzR
o8eYudGXrhQhcgVoY4z6uuNhL02dOfb1l57r9uxrq1Yu7fnKC/d1/ff2swUG
k/nS/nWDwnbuDBsyf08mEXhUFWWkpmZc+EUTMGcNHXgcOXLkvfeGPNW9f2FG
uEcvZLqCiJdfzPPBh4KW5S4ryf/Bo6tIOqnZ/p1mzleaX37QZCb7eshBT4dj
vyooyPd27YbWyGw0GpuamvR6PUYHAbRJxqa6I/Of85/3c21D/bqAl/sEb9TV
1W+ZPXjSuqPZl04MHTgiR1d98OvRC6jAg3Zl39ds4LFx48Z27drdeutNcQeC
i3M82OhRWRjxw7e7Eg5v8alhHmW5S87FT8+7usBD6Sed0ny3UbN4vuZ8gqY4
u3WEHFXkXTZzvgj6GFcNAACwRQQex8N6LD+RYTYZ937VK+L3FIPJfGLtxOAN
x1ZMePPt/mMmTQn2f+2fr/cdd/BaOT2Wih94bN++/dFHH33owfu+XjakOO/n
ypI9F0995bkr2vqofeV5PtToUZy9+M3XulUWLnNvskSAcfGUZvNazaJ55D90
rSTeYKed274oKMhTrngAAHBjogOPFScybQOPPTGr5s6eFRISMvqdp14eNP1Y
SoHBJvCorTWuXJ6VmbKigrz4RuRfXzR/1vvRa0fkX19erXX/sIf33k0vzVnh
9QurddIurynZ7N5AqDxfk3qeiK80oSGaK4mtpomDP8UdmHz40G40dwAAgCRT
c+PpyPejE/PMJtORJSPWH7tmNJkvbJsT+v1JPXMD7bktU5cfLmLvn82Li54U
sY3uecnLs3zy8TX+dYf4+V+as7Su8lB9ZWzC4anJZ2fq8t32FPHliw+dOb7Z
R3pbKou+3rt7DRFuuSW10hzN2TjNlg2aGVM1OWkt/c56N05zZg7Pz0dzBwAA
yDGbjM3sKxTpO9OJT/h3whsMgj/pF1zSf54/b1y94rjMdXn50oX+o4f3SDy1
qLp4jbve2bpmZWyZD/S2lOUt+ePg5JwrbhjdUZKtOX1Ms2U9GXIQ4UfrDTmI
6dSx4IMHduEWWgAA8JDf99XYfYtKRWGEvj75aGzw8f2TtFmLKgpcGhExZGCK
NrMl7l1VnvKuhff94HkXR3cUZ5Ehx/oo8o4VIuTw+ka5OBFh2JdTB+bn42YW
AADwCL3e8kNMSXZalJqrUmnO4q0bRy1dOFBXuKng+qKS7MXOXd1mfplw6cwG
7zcLaNfUVp52enEi5Dj3hyZiEXnHig8+6ty5adb0D4qK8JxSAADwlJwcy9Qv
Ljt4eVpeV/5TP/8X9+4ILM/TOPck0g3evrdFl7/00tnF1VqHbx8uySZDjqRT
mpBpmtUr2k7IQUyF6WHfbVmHt9ACAIDnXLlimj/nrHPXqbLcJTOmDS7N/z4j
eX5pzmKH+l+iIvaX5Xoz8Eg5P2vUsBccWqQ0h3xv7N4dmr59NHnXNETQ5cX8
e2L6NLB3cbHW21USAADash3bqzOS7QzwsDctP58wo9db3a5dDK3SrqjSqgon
xn+cmH/Ns09oV5wiDu39Iv/aQpXzl+WRLRs7YzTv9tIUZUiMHa0sWKbLXVJJ
/1lI/Htxcfbi0jw3PxvEo1P+9bAD+3/FmFIAAPAc4iKz/ceqzJTVrl+2dPlL
KwrXGQ3VjbWnK4ircP5S5SEcZbnLV0Uc8Nq9Ldpv6qsv2t2i8jxiWlZRoFm/
SjO4v0abJX27SmXhsuzzU6b1eqaUet1bWeaCsNdvueXW/3sheEK5a6NwW3Lq
+8EzJSXF3q6SAADQlmVmWkJnnnfv9aske/HKZQO6dL4nK3We8pyRmgPe6m2p
Lf+xusTOq3g7PXhHhw5/69jB77PxS/OuKt0hmx7/6XN33PTE891K8jUVOWEH
5z3RfsiwzMuhE+67ecYPIa3lmaXHj+1HcwcAAHiUJwKPKqoFQFewrKb026z0
+Mxk2fBj0mdncq6savkrbNqF2UETXrd7T03HDn9r167dtElvl+YsIf5cFvzf
mG8HPv/EnR8vHHs14dP3n73rjVF+xbnLMk9/Fvj2swe3jfrPq92JwKOqcFn+
5dnF+WTPy8yuHZYcmK3z+s07KqYjh/eaTBhTCgAAnvXzzppz8Zs9djmLqCyM
uJAw4/Txr/JzL9jOcP3Smg2r97V8o8fenRPOx09XmOHfT2vOnT7XoUMHIvCY
PuXtsjwy8Jg96L7eI94+8tsnHz5990t+r+z/ddxHvTvPXPuFjhrdkXYk8Dk6
8KBS0KYvvPO2v/zl/27ee35+hc8HHv39n9Fqi7xdGQEAoO2L3uSeAR4KU2Uh
OVUULi8v3PTSC4/EH5zMf2DXkgVHSnNb9L0tNSXr8jJ3ST4BXpev6fG8Ju6A
ZsyI14qyIosyFxWkh5XnLaWHjM7u/3j0oZnlBeELRzwZ9XOwLn/RxlmvTo/8
jP72ijDwILaxMD0s68wn93d6KSfXbU+b99C0Z/d23EILAACelptrWb40ucUe
pkGEH7lXFyQcnlqUd7i2/Ef69SjzZx9X+ewyd001JRuaasUPDcu/rnmvt+bQ
XiKHmomfvJZ4cobtrcGz+3eNiZtVUbQ4bNRTG36dXlm0eNOc120Dj5Lr81cM
fv5iFtlIUlkw5++3Pp1B9dT47DRq2Ato7gAAgBZw/bolYvGJFr7MVRYuq9ZG
1pZu2bNjwsihL3w2/qCnm1xE07frRhdlWoMKIswYOVQzehj5aI6sVDI0OrZ/
5uUzMyukHqKuMvCoyF8c9+1rT/33X/0+fPq9HnfP/XaKzrdvbElMPIvmDgAA
aAGHDtYe2vujt653RASSmTLvt1/Cwubn7YyZXJrbEs0CKedmLVnor8tfmpmi
+SpYsyFKk5GsyUym71iJqK/8TeEprCd2jE7JWFxZtOzUzoBLKWFV/7+9u46L
Iv3jAP67tE/P7lbsOvv07LO7EwMLC0VRUBDpWJAQRFFQsAsDFBUVBQFBSmLp
he1dtrv3NwuItMTCwPl9v54/YHZn5tmQ5+PzPPMM2THhlf6HSPPCR2lpZv7+
ewqmczgy8TYvvde6YdZee3SCRmi8qQP5CEYO7y6RiNH+JgIAAPghuLmyclIa
tLehwnLqeGzkW/vTRguuXtxCy63lzV+qWYKfmsaE2dpbYVwdNV0cxaudM/AO
HufXa1Y/q6qZLrqitvwPxe14yZ9ZJEf0b0bzvRIfH6dUKtH+JgIAAPjvIxLV
GPtMem6DTuyssNhbvklP8MSlWhAz7fnM51c8t316f6I+TsSjXUr8HGRzzjk7
6VvkIGXZONmuOm+/mt64Z2JovbCIGO9LGEgdDUvFIoXP799/6OhZT9OEJTYr
KfHXBwwYMFrXXyJTKGSi2X//9SwpF/lsEu8YTl52KJMhrPyYVRCfHKIzqH9/
w4dpItm3D1rCSNSdM2bYjK1JNJ5SLr5mvGDhER9p2ZoqiNEPh49cmlqrEzPx
yXP/mfgC+5316GhfXrMVsgrXjpHwiV4mRhdeZyikQn/jOf1LGbB4x4ngWM0N
lOVSse2Wwdsc3pRZgUYmYC6YPqbUPgNGHD1/O4fO15w3M3r2zGlheJZaJY+5
bXXU7ib0+gHQANLS1JcvvEW9+eNoLqr1NDoa8fWiWqespHMYm5UvHhsxyPe4
FBetnOLhLcz1y5h9uzeQs11K3tONS3Hj5j9PjTOt756Wxlby8+ydbNeKxfDn
toGpKBnBo379tXWXvkcufCzeqpCLr+/S+emn/7Wb7yGUyFUKmaXZyVh8PtKW
4iNvmtj70IWyWp1OtLN582adOnVecJ7BlRTXIfGuefd2zVoNXBCBY6qU8g+3
LK19Q8vM8kG257z3b91uXHytTixkk8+ZGSdReVU8h09OHjBwaJpIVEH2Vcre
XrNatedsPkckF3Pd9o3vOWyq/pEi+/S2j+nfocvoZUlMtVIhf3zBwPNZcpn0
ImGTRg7qOX/NxoNf99q6fGaPrp2WHPViidU8Os78rGkmW4S8Ti6DvHXu+Osh
mbV6oQCAGoiPEzy++wj1FrCwHNoXk1Niiimb5MgguDCJ7pc9Dj25u5eSbVvr
Iwfcxhzaj/kchnn3wvSk4cLCFTkKCz7dKijAmEe7hPrLb/hCz3Xcu3cP2t/B
H5AmeIxp2Xb01H/HrzpZvFHMwo1o237P4v+1X6AJHsgmpVJZ2JKqVCpl7deT
1QSPNuv0/2jfL53AKjqZXGypt/ifv4b0GKUJHoWnKH+GOgaPooNWWW9Obkyz
dr2S+YLywUNAjt0wbbJfaC4ShzTBQ3/imA2OQmURqYiXeP9sh9btzB6mFZyq
gndIEzx0+l0P+yL9upeASbTe/nePMQtTyfyS1VNIhZ+uGwyccYAmKVcPAIBW
2VgzG/g61iqKp8sLbJxX+e34NCtsnNkJg3lCzks+43aNjvn8EWb3DkxqrGb6
KJuEwWEdXz8zKH40L83yvP2a5M9nUH/tDV9oOLt5c/6Sy+Vofwd/QJrgMfaP
znvNbAd3mRTNLtiklOdGXevQZ/a1Tf/ruFATPJQy8dJ/p79IwSMtcsqjM7PW
ncAh/zcvQcYhrZg/bXRpE6ZMe55V5nSa4NFht/+ILl3c32VICjo1JMykJRMn
njm2bdB4TfBQyqW3zZevPHFDhqQdhQSH/bxz4UzkaGOX6990tioMHgo5/ciY
MSfuxJpvG1t4roehaQKx5vuDxJiIsMBV08dotk5d+OhjPEOg2c4hZyz5d+bb
rHyFTHTr5K6lh20DHY4W7DrGyDWAhWQtKnbUsMG//NZi0LDhu6+nSuQlkoNS
FnLx2NjF+rk0zQBTUfDYiPnWPadS5OPfDm3Z9pDvZ4VM6rR73D7X92WihyZ4
DOnnF5787VuuED/EHOo2ZPZHPCcfl7Bowb+fyNzCD4BNS104uo9POKnOny8A
oFJUqtr0NJmao52BjLqXlM+XDuz5XOEN4woncHIp7pGhlpamS14+OUjOsqn6
aG+fY3ZsxSREFl0hy9HM7rgo5n9ik4uPf37PzhlJ0adRf+GolMRPpvHxcWh/
B39MBcGjXdcTvh8OzRlw5LLmU0Ca5gcnJ8wwe39900+FwUMu5g3q0/Xu5wwk
KUR6beozaVMiiVPyKHI+TXf98rmlLVyy7G1umdNpgkfn/Q/uHBw7ZPNFZsFo
S9Yz8wnrTz7zMBhcEDwUUsH5fRPHb3ESq5T5xOwZ44cN03WI+Rzz5MKx4b17
FgQPlUxCWvbTT+366Ky0uBMTE+N/amaHHjohKRSZUpFw41yffiN2m15Fdrnv
cXLoiNFWz7KQ01DSIsYM6XUzOk8mZl/YOb9Nu46bjS59jol54GHcp/0fJk+y
lFLhh6Cbv7bscP9jRDaNL1V8yw0KCddw4+wdZ25wC8aXygUPlYjHeOms92fb
zldjmDKxwGjub/NOPivT6VEueKhoOcnHlo4YPntjHluKTwwZNXTA0xRK4WNi
Pstw498rja9r62MGAJSXkqK+dS0Y9RawZDmiH111EEIiBD7dKjzkGIcRzaVe
LR8/Podh3gRhtm/BRIVicrGlrjdhENzjoyy//uosYD1hk1C6Ky7ahZpju2nD
PFi4AyWFwaOb6YP4J7YHZqy30oyzCAgre/Z4x5Jf31zd4FE4AlNeuZGNwuDx
iJz9cFDPeWlEllop9zi4/KTb0483TcoED6Fc9NRqUb/+67M4mnmmMjHvntnW
ksGj11QTiUzTjMsl/MNje486eJXJYa+bOmzjmet0vibSyKXcO9a7R0xfnsuR
lAkeHcduwAs0tZMKOUZz205d762ufKhFzElbPmWI2c0Phd/Rgjkef3Xs1mvi
1EJTxo0e3qVtq14rjNkydVXBY1D3QcNHTC7aa7JOn24dO/fY7vlepFCXCR7I
K3piu6XTrD21m0kDAKiOnGxRwJ0A1BvBkiXgzv3qXttLceHS/I/ozzphMI+W
p5mhEROGueSOsbdEDoIhpFewi+HhOaSCoMLAOwQ9OsLR0pzVJlco2bZ+3jvD
wj6g/QX8YRUFj7NP0yifA/oPmY2XKIhfArsNna9UKvyqHTzkfNquLasXlrZs
5erQvDKnKwoebC5nxvDBdyPTRQL6ylnjH0cR4u+VDR58Mdtq2XSdLTZFFVXI
M9/6FgeP5T//vPFajvxrtHl+angvnb1puQlThvVzePTxa3utjL5vN3DY1Hc5
rFLBQ2/R2E2mhc9AcsJ53WGTl15QVx48BIzwucMGewQWzS4pCB7jOnTpPnb8
N9Y+AalkXuEBKw0eA7v31xkyrnifWWueRX+h8TQZqUzwUEhFH7z1241Yw6j1
BwsA+B6TU4xcbGOZ4FFYXj29lZ5wsfrrt7OIjgw85n3IdSY1bO9Ow+gP1sxK
luriUj0+vTdNTzDDxpkF3NlDxf1YF7CULKQs+x07tqP97fuRFQUP82cZfEbG
9tE9rZ9nPj+/fsquO6qaBA8Zh7Ry/vQxpU2cMv1FRXM8kODBFUu8N4xfcfZ+
5luXMXMOYSm8hHLBgydmnVs8bbiufVFFlfKs0OslgscvBx7RFV8jwmvTsb0G
6GFxsZOH9Tv/JPLrcIYy9hFm0PApb7KZJYOHh97iCVvNi2pejeDBLx88Sk8u
1fTtfI0ZVQWP0pNLS85ALRs8ZKKwqwcgeABQf5hMteFRKjnbFfV2sGRhk5z2
7IijZFerLwKJHImfMPZWGHcMJvOLk8f5DRec14W+PMOluBXeAqZkEfM/8fJv
ZKc/CLj9Q6cOSrbtDZ/9Mhl0J6OoOHhkIu2p35nV41Yc2jS0s1cCv0bBo6ZD
LVyxnBqOGThs2cGlE3ba3mKLFeWDh1AmfOW8rc/IHTmcgnETieCtl0GJoZaf
pxrckRckD6VMbDaz7/SjfjQmY8VEnXVnfJgizZdKKRfcNt82dPKSbKaoLsFD
xE5eMmGI5d2PhdsrmFxaQrXneJRSwVCL3dYO03bA5eUA1JMvX9TPHjxBvR0s
X276PMalfKcfhorDxEdibMwxF5wx2cnftrNJjgLGAyE7yN1pfXLMaVKWDTbO
NOaD0af3JyLf25Hygnl0H9RfILolL812//69aH/7fnDfgodKKc9479umWYtO
OjN4mh6GGgWPavoWPOQi8vRhPVu26ugfmooctnzwEKsU1KzPE0eOmL3XNQmL
jQny+Wd475JzPNr3GujyKAqLxd6zPdCr/7AniRSpUv7O+WivQVPPeT1Ftr99
4DZl3Mjd51+LSk8urSx4CMlJzVt3vPQhIYfOkyq+pQ+5hHtkzbQdpr4F18fU
IHjI+bRTp05e+UiTK1U1Ch4SAdtMd9b8I561epMBAN+XliZ5+eQB6u1g+RIa
7J8ae4lJqHi0hZKNPAHj4YwxN8Hg0yo9CJJA7CyWX72oN3BAp59//gnxZ7uW
mimpBY/m51hnxZpcc1p22mgBUhwd9ZI/n2WVW9g84eFm05MLAsPMmcRKTxT/
dCvynMLjFBYL6/UpyNFKPw33fv+5S4dQv08cJcf2gqsBdHegTbNy6eJREy6+
z0N+FjCy14/VWX3osrpgMYqAY4PG7bghkWtWLp0zbXxgwcqldQse4lNDh44z
fSWSKpD44L53xcipOzKpmkOlv3T5Z/G2ZBpfKZdcN1m46Iiv5nJauTQ1/NGa
KX8NGjRIZ/oqJ7OzI0Ytw34NHouNPVZOHow8NGjgv1dDs4XSgt4PqfC2j/P0
0ZrNg8ZOc7n2iFJwLQqLkDJvxqTgNBoSbPwMty0/UdSmK2Tiq8fnr9nrX1A7
lvGOBch+Ewwe8KUlZzvLXzkf+nulAZ6h6XvRrFx6euH8Q+XWVi18qkxsu1VH
11Gzcqk0P2tQv26rL6UgdZMJmAtn/x0Qm1XhLOrSwUPFzc9aOXGA55vsWr3J
AIDvO3yQnpfmjnrMqCgzYLZuTCJnlR0DImdpLlfxdME4WGGqf/eTAf07/a/A
2DEDKDmaLbQs60CnRZP7t5o4Y/TeXdOQsmhi14F9+/g+PsUoFTAcDkzuOrRP
6+nbVuRlVbqO+i3Tce26d9XdMa3wUEiZPbZzz346kel2X1+OY0qMwaIuLX9e
sIyEc0D3vX359IjP1Stof/VA2ZW1Sv5SciGs4q3hFzb1nrI1kVzVEqDfO1sF
5yr5S5mlvgpHcQq2FG4vmlyqeyNXrigzV6LsLqpS24p+L3/80tWo4IC87NDF
E/7xDc1UVFTDcmcvPoIy9aWlwROyqGBVkMr3UeUmvB45dOCzNLpmH7k46bHV
X9MO0Wu7TBsAoGp8vvrAfiops3FN8CgubpiXWV88i38lZWoih6sjxsWhBpHj
a/DoWBg8/ho3kkEJJGY6vvRaMLJ9SwOLLTR80XNomecuHxzRsWPboOhvF+fS
k/X7tW1+FTOvc+vuzyIsmJWcFwkeQ/6ZlFYiUaRHHBnWodVcw31szdxX24Dz
6zu0b922+c8/oR08qDg7n8tGsGJY06JUiGk0stvu2UPXnspjobiqZongUX4W
ST1RSp+cN1q12zpfWGE/R2V7Cc/MX5YsElZxrbhSLuGwaB8e2OsMHZlA5COv
js+i6i+e6hqQWOdKAwAqFh+vDg2+h3rAqKyEBN4MD7lOydbcqv7tc81cjsvu
NY4cSMnDWm5aN6Fjh9ZLFow4dmgO0vLami0e2/b3oVPHk/GuJSegklJN1w5s
/ee/q4qHSPx29+oyaDI28+zi4W12mO8g5VacGcoHD3LKaf1RLQeM/JdJdiBn
6PXs3H3xvs1uKzr8ugjN4EHD2T24udfT8wLaXz1QM1Lay8nDB3ftqmP7IJyP
ZmZUyaUU3W7dDj0gKBoseKjVIm7muR37/SLKrolWte+uLi9mpm2eOrZr195b
jjszpJoXl/rCbeMBJ0EdqgoAqNqXL/IPr++gHjAqDx7Xr3g8uXrRaeG/mNvX
ahM5SJnWWUnnrl7c4n9VN6XEiuj4GIO5Q9odtDomFManJWBysZaEdCtkOyvX
+o3Z0DZte5MLu0GI1mP6tjrqZUAnON4+OLb1iDGxyVbsagQPFsE+/f3BGe1a
/b1XtzDDaCpPcry0qiO6wSMpxszK0gLt7x2ohWrc76ShoFMPVUHR+lHLvauN
4z0G4D9r53YaPr0xTvCg4TCUHM09ZKdNTcjD1rKGXIqLm9N2B+uV+XgnwyPz
St5zNu3d9tEd/zR0PYikAmyc2fSpA3Q3T+bRLnEJmET3ia3atMjNdkByQl7Q
kjbNW4dGW2liw8cd/To1O3flKL2iFUKQ4DFg/IgHTw+HBhsg5fmd7WuHtug/
YnBCTolpIWgHj/w8e3fn3TCnFAAAACqQ9meHLpWY4YZ6zChZ6LmaK1YuumD0
tmuyR2iwf/Djmt0PjlMUXezEvCguVXNBrogTXOa2s7iog//otD/qvL/kVSf8
/BtCVlLwudGa4JHlwCI4HNZp9/P02RGhRnEfTyFl5ZROI5fMykq34xDtU6OM
CzcmfDJjEDXBo2Wr5n37duzfr7B0W71pPaNMFw3awSMk8AgMsgAAAEDLp0/q
z+E3UE8axSU/D0PNwdicwxzR1/R4FG4Me+336Pb9mg6y5OPtd+/4G18weqIJ
IYRHXGqp4EFPMdk8rdPcbQspeZpf2STHfJxtfp4DNf3siQnN23Rom5Niy8QZ
dWnxv/btW3fq+LW0b/HzT22vBZsy041Wju3WuWDj6KmT4rH25ed4VFBQDR4s
oqOH60Ho7gAAAICWxhM8WERN6ujSGXPKEEPPK/uowYFPNeqWYRIc1q0aR8q0
Lv7VzHhRyXGWwhLitaB73y5Xgi2R1EFKOrVnbKth4yZGvtrerm0ru9fWbKID
1mP2T7/8nIi1ZX+bfWo0q3vrJXpr8Xllk0PjDx5hr49dvOiB9pcOAADAj6vx
BI+2bTG4VE38qLBn490L/wc3H1b/aFzanZI3arGzXI6NMyv/NDbJ2m3/6Ga/
tFyrt4lBxtDTzl7e3fvn5s377N6OVIOeazewW4ulVkepufahoa/YpKLF2933
jGzVc1BorEWZKaaNP3jYWu6QSmtyNSIAAACgVRvWUQmozixlEDCdO2mWOqfn
VnXFSthrv3v+1Q0eAsbdMvdnoRKeVnbXexbRISvK8NiSbr///uvvv//SsWdn
71vrWzb7pVuPP32eLmv96y9RCbZIwGCTnbkUd73tU10d11I+7xvbtfVux335
paeY3jL9a8iMydUIHp1+QyN4ONjoicVCtL9xAAAAfmib1lPQmllKysQMG4LB
xmmWIf3ukxl4Z+PjH0mZ36kqm+QY9Ei/TOoQcd9zqZ5V7UhyZOTZkbNskELN
sWUQHMiZlnERxvl4e0q2Tck4RMPZ4dOtKHlPRQIKk+RVJikx8Pb0XPvyy62X
fS25tuRch1pcF1yXEvb62A1/X7S/bgAAAH5oYWHqtARfFrHszVvrteRiMXNm
YmbNwMSGYwjpNdjxtFE4Ib3S4EHJtl2ycGTQo/1MQtmeBC+3rQy8Nm+MwqW4
cClucREmK5eNjg0/1ZDvXq0Lxm43i8VC+xsHAADghxYSosbGX22wti8rCbN9
C+bxXUxemiZ+1HT3mDAfvysV30KXS3GVCL4Q0q0Z5VKHk+0q5D/7bFK93JGN
mGn9/uUxEfu5l7s+DVd25mrjKeEhhteuXW4kC08BAAD4YW3ZRManf+em81op
afEYgwOadUfx6RgGvpYHoeS4eLq8IJW7YRwh3crwyHwuteKZKrGRroyKFvvS
YkFiD5t03uP8+pOGa5jk2qw3Uq+FTcLobl3M5dbuZqYAAACAdiD//d2pm1ff
94ZL+Yw5a4y5elHTy5Ff28hRXGzM35VZZDUXa3nCYC4u1aLC5wtZL/j5N8pM
+ainQsq0IWTYc+m3bl074HNxSz31sdSivH52OD0tCbo7AAAAoOvdO3XGF18m
oV4aZeR/2V8+YZxsMW4YTG6qZoEOrRw2Mcr7sntQ8a9cqpffFb3s5HOVPf+6
914mUTunrn4hZlo/e7D/jt8BMfc9h+LSwGcv90E47t61EmZ3AAAAQF1AABI8
vOuhpcN4nsdYmGpuW4/TXuQoatMz3K54BJKzNb00SOoQMB9yKOeraHN9vbYy
8OisTK6ZgEq9+CnsvJnxIozNqobpdSlfgp+ek0kF0N0BAAAAddu3EfHpHlps
45DIcckdc9oIkxSj6eWoj2YUOYWLQ3Au1i0l9szju/uqSB1IeRPsXLA2CJpD
HlScbXyE8bsXR0ScVyJOCIvYoJV5+/zIeWc7SB0AAABQh7RF+nszC7sO6l5Y
JMx1b8zJY5jkGM1cjrocik2yuOu5yc1hTdCrU7QS18CmfDB48+ZkcqzZqBF9
BvbvYWa8iF5u/fNSVSI6ijgvq04mDVoozizyFZtzy9yd1uWlWbHr+3QFHT63
rp9gMhlof9cAAAAA9evX6swkXwa+4sU8q920aVY4v+ePMTyMifuIIWTUvbm0
dTo4YeHCUSuXjZk1bdDF4DOFS4MSE03WjOm87fS2929OtGnT/H//+9/endOq
PtR+vekMvBNaAxyVFSQOfXp/gk0LErKDb13bRc62qb9z+XnrUsi50N0BAACg
MfDzU2UnX65L5Ah/jfFy00SOyHfVWnq0ZKHk2L0KPvHltX7Anb2EHIf0d4ce
3dqdjrVhkcwObp9PyNIsUR58efHqzStJuQ7sHItA26m7No/SPbMtNfHcovnD
p0wcaW+5oepTeJxfn59nj3rSqKzw6b7hIccP68+k5npzKJ5aD0hskuOJ43ug
uwMAAEAjobcDX7sJHkwCJvoDxvYc5qJL0T3danGQzFiTXpOm/Duz38TRnTcb
r900f8CkYe3/3raCkuvwtd20uWYwbpvtfireISl027/HdB87zdYz16UWXJDr
hnkZG17Vumd8+rXXgYcbzwWtVb2fJG8+M+DMyYVZSeZM7c0A8fbYnE8nKpVK
tL9oAAAAgGaCh+GRZEpOza70pOdhEiIxxscxft6ae7rV5VYjmZ+N+/QYkJZl
S0s36NZ+cHyGHTv92PCJE9Oy7DS3Y8uzCrqydP7CORkp1hmfTs6aMvhz9LnQ
i/N2ndWlFMz6SIj0NjoWUcXxpaJUDrlOo0gNXKJCTzy+u9fZfjuPdplDuVDH
27jEfTx17Og+FouJ9hcN1JhK+VUlY2QqVeGDVY+gqb4dp/h4FT9PayNxqm8V
R2F0DzlpZe9YZa8dANCQ3rxRx0XczM+rbtNMxWlmjR7Wx9y/oYkcdW9nMz+f
HtB7KpXsSM817jNxBkWz0Wz835PSs+3o6Wc9Tk1avmphapIVi4S5bTRy7Lh+
ixeNmjCyi86w3pjrR5GNOckeTrYhNFwFE0dZRMfYj6e+RFe8nljjL3zGbdNT
a7BxZukJZ2t9CYyt5VYmE1JHk6JSCXkcbHzIodVFDtvdTcGSyzaZKuVbb4t1
q9f4vEmVVN6bJRVyLA+vLm3L3YhUSemmWS7lu50++imDWte6yyWpKSlOO7cW
num4861cKlssr3Vrr+IzKVJFDfZXKeUpQZgthu6Ccg/JOMT167fHSaXQ9wcA
ujwuqHKxXt9tv5D/dxMzMW+fY0xOaCIHTntXyFYaPLIsz+8ZMnHt/KBAg8jQ
E9hkyw/P9l522+Bxfr3lruFTVswOfnmKWdAb4Ov1LDGqgkVImASHf+cMbRKD
LFWUJ/f2Pru/X8D+yCZdYOAdavRykqJP+/ldgUGWpkSl5HFYxruX/9msRcfe
g4cPHz50yODu7X5t3W6M16t0RYmPUinjrZkydOKwnn9tPIO07ZUdj0vNWjW2
2R+d+gwvMGzYsMGDBvza/A99l6fF3QIyMfuR4+72nTo/jUyrU93lko++J1q2
bNGx50CdoZq6d27TeuDY2QFx1No19lIebd38KV843OrvrVRIo2+emLzahFvu
ITElpWWL7kEcnrw2dQEAaI3RcTKhygkeSOQgpGNeBGAcrZEmXvsNa16i6fTJ
8+ma+8ifmb5iMU2z0XzF6tk5iQenjew+qH+ngQVl2eY1pLyiWR9f7iw/fn5/
/tcpJUnRl/V3f66w5tEfjFFPDlopPNrlxGiMneWK6A+n2WSP6kxA1cwpPboC
BlmaFpmQ43VsTcvWbfTOuETihMgWhUwS98x2Xr+uv7dsH54vLO73YMf59OvV
74bbyf69Rz+KJlbWNCPBY+3kDseuRhX9rlIJWSS9BQObdx0kViiQ35mELKPD
q/oN6P1bmz8rCR6qCkZrKhqzIH681KJlq/6L9N9gWRKFpu6fnzxYMKr7hJXH
cGxR8bFU5UZhVAWKh2iKH+GRU1v92e0TjVHQ5aEqUmL34pqVOZqyzK8FxJRk
CB4AoA7513n6ZBwNV/EED6Thxqcj/+PGnLfHXL+MfuNbWclK8rCzfEvPKzPa
4iTivOVSL6JePe2WxE9WPOY7Ov5qWrxZ+dvvlix+3rqZGSnf6e5QyXk8RnZ2
NpFElio0z1TKpSxSTnYOjlT5f6JBvVHR8eHT+rZaduJi6c1KLul9++Y/Ddtz
XyxTFGxReOlO6D3NIAufsv7vIdvN/XiV9CmUDR6aXWXJz0x+at0jT6FQqRXu
ywYNnqsbHPducP9eFQYPhSDf2cHKtLRzltbYMpdJKUUGo35v03MaiycsuRn3
wWPOQt00vCYASwScnKTQswXMPYModAbyJ0illH1+4ufs9ywn8nnhQw8+pIlV
armAcfq4fvPWf+oZHr8SihOLaZ5ONp+iP9idPWth5ZBEFEsE7Iy4V2fNzJBd
rL1f0hmsguyiwEXetfJ8JC6Y3SIWsEMDfDQHtXPJjAtv1qwrBA8A0PX5s/rZ
wyf5pZtsJG8URo6A2xiMDeaWL/qt7XfLk3v3cKmlbq3LJjnTCC9Qr1g9lXcv
jpieWuh9YQuXqun9KD/+gmw5ZbSbw6n6LrRKPj3x4Np5fXr3HjJ22sVH7xQK
GfFL0MIR3Xr36Td2jQmriqkDoD4oFQmPbNt06XP3S9kZCiql1Gd9t9btRvOF
EuRXhRA/bnCPQ5dD+RK5/6mNOpM2xFMr/qyR4LFGEzwiv3ZUKCQizj2Lpc26
DlNoejyUMS8/y6RyCT95xMCKg4eYljZ3ysjepemMGPMiu9TTFCzc77/9NsE6
SlhJBFJIha8uGQ7TGbjvmOFxQ8P1//QcNntNDokll3B9j67s2H/gvKlLjh83
1NuwoG2LDl6JDBmPeuLIvl9+a7714OHLbzLzqXETBnfr0nOk7kFD/UP22DzK
U7dDOv0GbDtmaGh4ZGqP7pOX7qIxRQqZ6I3Hrs7jt7LUKpmY72G4uO2Av44f
P35477ZBfSb98nMnCB4A1J0S+dfFZTNKYLI4ArG0zNNUSqWAx5HKS/1NsLVV
49M9S7RWmlU4iBmasGFlpgkeqLew1SxRob63rwUU/8okOFx235SReBb1itVr
4VLdJfwoSq7/o9u7M7+Yl3zo4a09adgvxf3PbJ6YzcjPp5L5AoFEwGPSyBwu
V6mS3rM+au4VjHwnyOlRsyb/QxIw/U8uPR6AlQh59uN7WkSLYMmxhqRSyILd
9Tr2mhJZbnwM+fcb4zCzxR/tuXwR8hvhpWm3rkPeJ+ORj5ga5TO8VyeLG+EV
TsFEgsfqCX/M3nLycoFLXhctT27/5bdmE9djSvaGVRE81N8GOUor/RwJPQMJ
HkefCwsGWSpATwqcMGTEuYDIwr159Lz9/w5ffPqWVML1ObKibZ+/Ismap8kk
HMOpzf7a6KtQqvgUbOs/u8XQWUhFhaz4Mf06770QzC3425af/nyazrDT10Jl
BRWkZkX806/XQe+w4uDBVMoJMbd6tOp1M7louseHS9ua/QbBAwAtENKzD+mu
WLBw8Yqvlq/ZcMbtPp4pKv7LgPzV4rFyjLati8lhl9z3rCmTmKnpKNBEjmwM
KVMzqmJ6SvMD6q1qjUpGoueeHXFMQtG1OaQsm/27Z6BeqwYruBSLDWvHc+m3
uVSP7ORzWUnm69fOY7O/3YX2sN4W+9MbhvRqv/qw1Ttf0zF9249dthvPEH19
XMnKidq0aCGtYLQFSbK3/H0X9RjzUSSD3NGQVAr5O2+D9j1GvS03ZUOlVIQY
j2nz51C+UKxSyozmD/xzyFLXy9du375947rbxMFdp2w4TeXJVEo5n8+hF8pn
8vgiJHisHP1rs1ZtO33VuUf/NfuPlzl+FcFDKeYGPn5wu7R7Dx4SeaWeJmPm
tPjtt+03SWWuYUFqLpEp5UrFu8sn+w6bYHPB924BpN7HNkzpM2kfDQkeR1f3
Xahf+HyFTHx5z/CRMzAKhbJs8Bjc1/dtQuFQU9RN48E6/4Rk0Ar3kgpoFovG
DVxnK/0aPPJl4hCvo63HrSiuCS/vc4sW3SB4AFB3muCht+1+GLb4TxU1K+7Q
9rW7DVyFmnYE+XcvY+MSzTevnjtvXnHw4PP5PB7v9MlQJGNQsjVXqbg4YIyO
auIH6s1o7UpI4M2clMJZsk4Cxv2CMQj0a9WwxUkuyW7XttX/CpS8ivbw0hGG
l16JBTjdyTobrW4LOQT9dfPPByYVzM9TSEQkj1P6B88+K2ww2HTC0sULZ4/v
5xmBgx6PBqVS5kRc69qpm8OztMI3XqmQMmhsrkAiF+VvHvxztwl2Iolcysvq
37XdH3/88edXbdu0bN1mxL1ogkyMPzx1VOHGjp17n/H7WH6OR4WqCB4icvL0
Mf3/LK1nv8FPM0o/T8ac36Z5p7/PcIWlultF7BxzC9uIdEqQ0+GOrTvMnPPv
wm+WbNttT5ZwfY+tGb2mKAtVFTyG9n8YllL4xry7dGzw1BUJxKLeDLmYe+3I
3/3nm/C+BQ/RU4c93adtKK6JmJzUEoIHANpQPngg8T8x9Pq69buSWEKVUoKN
vLFs/oKde3ctnP8teMyfP39mgdMnt1ubO5w2wlBzUG8361Qi3157/exmwc+u
8bFvUK8PWkVncJeff/4JUTp4rHyZTlap+Wd0VwVjkR8kXsY7XYOSlEq5gJJ8
bu+m/WevKTXT/JRSYeF1EyqJMKP5r7tECpjm0aD4dNz2aR27TVyaTWFJZAo+
MWHkH+2GLz8b4H/i1xYdHubJFCpVurduh859E3JoxXuJ0oPG9uuma3UbebjM
AesePKov8vyS5n/8GRiVJpYplAXjKRKR8NUF/T69B94MS42+azVw6NSgFMrX
TCUnp8VGJ+VKvxc8oisIHuqkp7Y6/cbe+0woPJqQjdebNGL0fq/ioRaGXBJz
z6K1zr8sWdHYDx0b0qI5TC4FQAsqCB4qWXL43XXrtkcx+BIB+/bZM2E0jliE
27y0guDhYLOdnlfVxRFNpWQmeq5ejmUSMGnxZjkpTXXRsLqXf+dNHjVq1MiR
I9nsb8NqlQSPL9zcz1uXTTf2fi8SiyUSCTc/99CoYZF0gVgkpOOCO/U5JYbg
0bBUSkVqiE/Hti2bt+lw+FLoly+JsdHvtwz6308//9Jjz22BRKFSiP/t0bnv
Pn+mUPZtL7nEQm9O77/XYqnCMgdsyOAh51GG9W6L5N7VNkFRsV++fIk9MWtC
m9+arTfzY4rUQnLsmok6c3Za4TkCkUhESQ2bNX7QAffn8sqDh5CW3rpd11c5
ZJFMIWCWCh4iTsqWScOX6DtRBUKRiBcZ4DG4ew+fD5nfJpeqlHzS50ld2i+1
DuSLxUI+22XHiN9/7QDBA4C6KwgeW+++T5EpiggYhOtWelsOmHBExdO8VP/5
4IGUyHfXYj86ThrfF/WaoFVSY01xuOzy61QfXbH6VQbyP03+2R1rXqUhP0gu
mexyfx7hfnjF778W6dRzfKRUlBl3pUNL5Lff2nYfgK3DipOgDlT09NC/e3dv
+fWjadm2c59ePX/99ZcZlu/o1PBuHTv4JefKSu+THuw0qMcfNg/iyxyLR8te
P7XLCd9PVZ9Swk8ZrdP3WVR6HauuELLGjhrevFnR16pF2466dg9YX6/Mpia+
+GdM799/0zz0e4s/p+k6IDlJLuFdN1w3br1R0RFkkiv7Ro2Z7YwED+Sv29B+
XX/77dfuu64RCDF/DR/0KDy1+FzEmEdTR/YsONpvrTr31XN7pdZMthe9vbi7
26TtrIJVTLPD/Lp1aqc5X7MWUyfr//57t+dcCB4A1JUmeGxbOrOEWbPnrNt2
OIbJL/GsssFj9erVSws42B6g5zbttT2Ly6dQ35S4Oz/k7A5NYRIcdAb3kslk
FX5PQJOGhEk+LaL3AB2+ENZXAQCgrKjHIzRZKv9GUfa+UmWDx9feEeSJymOH
UyjZrqi3m3UvWUkec2biUK8GWoWWa4/H41G5LRdoECrkXzbadQAAgAonl5ZX
NniUJJMh2QNLzmry2SM72WPu7Gw26fvLif/3Sn4ehkSC1AEAAKDe1T14ICQS
xXEDLCnLDfUGtNaFRXT88MowJNCjzBKmP0KhZNv+NW4A3AwOAABAA9BK8EBI
xIqThlhiZlPNHlyqR27W67R4j/WrU1GvTAMXfLrdp0/fuWwBAAAA0AqlXJqB
TaFzRVU/TaUUp3xJ4ImrmtAtlcqtzJObYvZgER3ZlBs8mlcu9sKUicQfarSF
nGWzaf1M6O4AAADQFEmlMhfMF0KGO+rtaY1KVtK5A3tncMjODIJzfMSVPGwT
q3+tC5vkGBdhSiQS0P7iAAAAALUkkcgueyY0rezx8NbulM9nCn/OSfE4vD8a
9So1TCFm2ixdMgu6OwAAADRpSPZwtMsIfHivSYxZcKmeqYm++Xn2hb8SMtyG
D6U3iZrXsbBJjmGvT+bm4tD+vgAAAAB1xWSqfX3Eb1/cb/wtOI9+TcAMKP6V
gXdO/OT99YZx/+WSlWz7POi+QgFrOwAAAPgv4PHUN2+I3wU36uyRlWSOsV3N
ITuX3EjJdkmOuYR63eq15GEt7ay2y+Ww/DMAAID/DiR73L4l/vCq8Y65fHpv
5OO1pcxGKs5l0gQS6nWrv8IiOiZFn3N3d0P7CwIAAABoGZI97t0Tf3x7p1Fm
D6cn9wxo5e41k5/nvEs3Hp/WlObH1qjkpVmdNTOA7g4AAAD/SUj2CHgkjgm7
2diyB5dyQch6zqGcL/8Qi+gU/d4H9RrWR2ERHX0v6aWnY9H+XgAAAAD1hc9X
BwZKkqKvN57sgbS/Hi66+fiKF0jPz3OeNzsH9UrWR8lLszrvfBa6OwAAAPy3
CQTql8GStHifRpI9clIsblzdTsPZVfgoA++8eEEmJdsF9XpqOXVgLU2NV6al
paL9dQAAAADqXWH2SE9oFNnDxnxFYtSZKp6AVDI02J9NQj8taLFkJFpfuABz
SgEAAPwoRCL18yApNg7l7MEmuwo5HziUqjo0WESnHVsTGkNG0lbBp1vZWOjK
ZDK0vwUAAABAwxGL1QGP5IlRaM73oOMvxEVWPMhSXBh453FjKEzCfyR4FFxC
a371qjfanz8AAADQ0CQS9c0bithwP1QGMggZ1oZH5lCybat+GhI5Lrq+SIj0
ZqOdGbRS8OlWd265QncHAACAHxPSAF65ooz+4N/w/R5xESaBD/Wr+eR7/g9Z
xCbf6cEmObo7bQkP/4D2xw4AAACgRqFQe3iookJvNGTLziafF/OjuRTX6rXX
mGlTCPS8Chb6aFqFkGF9ww8D3R0AAAB+cCqV2tVVHfmu4bIHOcczt9pLkiLB
w8w4LCn6cpO+toWaY+vmtDk8PAztTxsAAABoFJDs0TD9HmySo5fbxo9vDGu0
112/R016iunHN0YhIa/Q/pABAACARgTJHp/e+9d39qDnOthbraTkfGdaaZky
f242JaepriTGwDscPrhOKpWi/QkDAAAAjcuFC+qYML96zR4C1hMevcZ3YDmw
53NawsUmem2L/1W9+LhYtD9bAAAAoDHy8lLHR16rp+tcyFk2fFY4t8pFwyor
d64HNMXRFuQlmxjrw5xSAAAAoEIqlfr6dc11Lgy8s9Zb4cd39yZGmdRu36ue
gfVRpfou92/shduyAAAAAFVQKNRKpfLg/mxSlpt2W2E93amkLJva7btudSop
s1pX4DaeQsmxPXxom0QiQfsjBQAAABo7uVy5Vw9HzNRa9hAyH9HzLrBJjrXb
HamJ/5UnTEJT6vQwNzsglYhVKhXaHyYAAADQBMikiv17cMSM6q658Z3gwf3I
IdfpypSLrs/z85pM8PD12hoXFwOpAwAAAKg+mUxufCKLUOfscct3x8c3x+t4
kH16sYR0LY/+1F9xsDsmEAjQ/gABAACAJkYmldtapRPS65Q9vC9sSk8wq2NT
Hvvx6j3/h4ymMNpyy3f3p6hw6O4AAAAAakEqlbufx+Jrmz24FJePoZ75ebWc
3VGyuDi8ouc29vu2UHNsLcxPCIVCtD83AAAAoKmSSmTeF1Pw6Rdq0RDzGU85
FGRHLazCYXLiY1617/OCVnF13ECjkaC7AwAAAKgLiUR27UoyPq1m2YOGs7O1
WMfQ0tpfJwwic5I9GvMN46g5trY2Z4RCmN0BAAAA1BWSPa771Cx7eDivx6VY
sIhaGGdBSmaiJ8YmpDGvJHbnhoVELIDuDgAAAEArJOKa9Xvc9jtOz3XQYstu
ciK80Y623Lm+M+T1C0gdAAAAgBZJJDJvr2rN92CQrvEZAVqZ3VFczp1+n/nF
sxGOtlBxtnbWB+ESWgAAAEDrkOxxwQX73ezhd0VfW7M7iktq7CWLM+8b4WjL
yWMLuFwmdHcAAAAA9QHJHvY26VVcYxv2+tj1y9uYWprdUbIcPxKZh21coy00
nN3lS24ikQjtjwUAAAD4z5JKZadPVbquqZ3lOhrOvj5aeYxNSFq8V6MabTly
YC6Px4buDgAAAKBeSaXy/Xtyy2cPep69kBXIIdfLgEhilLfR0YjGc8O42PCT
vj6X4S60AAAAQANAssdevTxiZqnsYX12KZPoqt1ppSXLKcMIak6dbjmnxbJ6
5QxIHQAAAECDkckUB/fjSJlFd3DLz7O3Nl9Kz7Wrv7be/8oTXGptllHVevny
ySQhPg4GWQAAAICGpJArTYwySFlOSN64fGFnaqypthYNq7Dc8n2cFu/FItZX
j0o1Cz3XftbMcTKZDO23HwAAAPjhyOXyQ/o79+ycdmD/Niah3ht9gwOfKKiO
tiDJ6rTRIhYLLqEFAAAAUCCVSsePH/+/AuRs2/pu9694BOaiOtpCw9lbW51V
KpVov/EAAADAj0gmk82ZM6djgTdB15nE+r3q5MGNh8kxl9gkdEZbWERHjM1a
NpuN9rsOAAAAALWPj/pd8N36vuJ1765YSjYKoy1I6sj8cu74cQO032YAAADg
R6QqMdyA/KxUKBRK5dWrBdmjPvs9HK1DcrEojLaQs2wGDeqL4hsOAAAA/KhU
cqko6fVrWUH0UCnl6WHvniJCYvhSuY+P+v2rO/V37UnAnftxH682cOpgkzCZ
SdY8Hg/tdx4AAAD4D1N9u3ZD9fVnlUom5gTfOtO1YxeWGEkdCtI72yHDJ86a
NWv2xKFzjl3hi2X+/uqwkNv1lD3ePr8RcPt+A19Um51sobttM4qfBAAAAPDf
xiTjqPk07JdYbA5JKhFkJ8clpmbIlSoeLUuvT+/Jkzf07d8XCR4Kmcx3+5rY
XI5SE0wos4YuS2XzlWr1nTvqyNCb9RQPtm9JbMiLahl4h6BHhgKBAO3PBAAA
APjPume7ec3ySaNHDx08bOjWnTtGjxgyYLDOUb94JF4o5HIGCTdkUD8keCCU
CkVhXwj7rUuf1WZsgWYhcaVS/fSp8nP4jfrIHm+Cbnx45deA3R2WmzauQfXT
AAAAAP7j7piuOnP1JU/Eu2N39JDVfYGEHxrgue70XUXBo2wafujX4FGIRXs9
uc/MaCJf8XV0Ri5Xh4QokmKuaz17RLy5Fhrs3zCjLQy8/cunxzkcDgqfAQAA
APDDuGO63vVJhEwtfeB66rT3G4Va/jHw8jqTO+WDh0qlxN482LvvJiyDo1CW
Ws9TKlVHRMjTEny1GxLy85z37IxrmNGW96+M2WwGrFMKAAAA1Ks7phtcn0TK
keDhZnz6SqXBQ6WQZ902+HOhYWJKFoVKpdHYMkWpVT0lEnVUlCw+UssdFK+e
3nr97GZ9p47MRPPdehtgnVIAAACgvj213X75VZxCLQu8ZG5z86NSLY95eW2X
9ZPCNpjHIE0aP5YjUctlsg0zR3fq3mfw4ME6GhvT+eIyvQNisfrDB2lkqDav
sY0K9UWyR32PtrwONMKmpqLw7gMAAAA/GJFQLBJJVGqVWCIRiCRqtUoqk/EE
RaFCoVBwOWyFSnOVLZvFyP+GI1dU0D8gEqnfhEhDX2rtMlhKjsvh/dHU+hxt
waVYWZw7irzSBn7nAQAAAFB3QqH6ZbDkdeAjbWWPQ/tj6m8J0/w8+6sX99Bo
VLTfNgAAAADUkkCgDgqSBD95rJXsEfPBJ+D2/XoKHllJlg725tDdAQAAADRp
SPYIfCYJCnhS9+yRi71wwTmYhjuv9dRBz7N3c9pOoZDRfrcAAAAAUFdI9nj2
VDvZw/j4x9xU7Y+2hL0+HR8XAd0dAAAAwH+DJns8k7x4XNcxl4Qo75s+j7Wb
OjISz2Lsj8lkMrTfJAAAAABojWa+R6Dk5dOAumSP7CSPK56B9FytjbbQ8+xf
PD7+JuQ12m8PAAAAALQMyR7BLzTXuZCyXGsdFazPvsNpb7QlI9Ei8NlduVyO
9nsDAAAAAO0TCtWhoTJbq6y8tFqGh5TPl654BmoldeTn2R85uJRIwKP9rgAA
AACgHsmk8uNHCfj02mSP2I9XXR1fsUlauD43I9Hiw/vn0N0BAAAA/OfJZYod
upRaZI+cFA9zkw+0Ok/zyE4+t3njHDKZiPY7AQAAAICGIJcrdbdSCBnuNc0M
DlZvUj5fqmPwiIswj4qKQPs9AAAAAEDDUSiUhw8QiJk1yx7xEVcsTUPZpNqn
jtxUi927VkmlUrTfAAAAAAA0KKVSZXISR8pyq36QyE72sLV4W+uLahl4h4i3
JklJiWi/dAAAAACgw+pcFlmTPao7ZdTL7Xla/MXaBY+kaNOwDy9gTikAAADw
I8PYZ5Cz3auZPRKjvI8fiazFaAuT4GBkuJpIJKD9cgEAAACAMjfn9Gpmj6wk
T1uLt/l5NR5tiY80CQq8B90dAAAAAEBccEmrZva4cz0gL61ms1KpODsLs01w
CS0AAAAAirlrssf355q+fX4j4M79GgUPL7fNubhstF8fAAAAABoXF6eM717n
khxzae+uuOpP82ARHS3PGcEltAAAAAAoz942i5TpVnWWePbgLj69uqMtdpZb
qVQK2i8LAAAAAI2RSqWyOJtDrHJd01dPb4UG+1cndSR+MvH18YQ5pQAAAACo
jFKpOnUij1B5nwY2zmvj2uRqdXdYbc7Pp6H9ggAAAADQqCkUSv19pMruJcck
OAU/vk3I+M6ITFq8mddFF5lMhvarAQAAAEBjJ5crNq6n5aVVnD1ePb2VFH25
6uDh6+MulUrQfh0AAAAAaBpkMsX+PZQ8rEf5UJH1xXPF0vQqUofBwdlUKkml
UqH9IgAAAADQZEilcpOThNxy2QOXcmHj2mQGwbmy4OF9+bxEAt0dAAAAAKgZ
qUR+xoT+9P4TJuHbuqYMvPOboBuVTfOwObeOSMRDdwcAAAAAakEgUIeGSp89
eFYye2DjvA7s/Vw+deSkWNy54w9zSgEAAABQayKR+t1bScDdoOLskYd1XzQ/
k1lutGXPrjkCAQ+6OwAAAABQF0Kh+k2I5NGdouyRn+f84aUfsfQyp7hUi4BH
cBdaAAAAAGhBYfYI+Jo90uIvWpi+L3UJ7VV7iUQM3R0AAAAA0AqRSP3mjfTx
vUAkexDS3aZNwReGEBbJ0cVxTW4uDlIHAAAAALSoYL6HNPDhU2qOS8Tba6RM
VzbJMRdrdeL4AaVSiXbtAAAAAPBfg2SPD++lL58+zki8mBp7iUlwXLpoPCzc
AQAAAIB6IharIz4KXj41nflPwIvHhu5uLjDIAgAAAID6w+Pxli5dOrPAnDlz
IHgAAAAAoP5A8AAAAABAg+Hz+WvXrl1YYMmSJRA8AAAAAFB/pFJpcnJyXIH4
+Hi0qwMAAAAAAAAAAABQJyqlXCxgM0tj84RyZdFoi0ohF3I5rILtPIFArlCg
W2EAAAAANF1SAfO26bI58xYs/2bFqr3GQbE4hSZ7qAgJr4337Vyp2b5Md9+x
gGi8VAbZAwAAAAC1oQkeZ9fsOPu4eKFSlVJ51+nAnNmbMvIFSjnZYPMqY9cA
llCKPPe1v8PKDftiyWyYewoAAACAWigfPJDooVZnrJs/515sTn6k75qV+qn5
/MKkoWIk712/3C0oVQ7rqQMAAACg5ioMHkpF+roFc+/G5hTP9Cjczs8O37Rm
5Y1IvAK6PAAAAABQc0XBwyxAriyikHMfOe6bu2x7Tr6wVOwQ0F1N96/Zb0lm
C1GrLgAAAACaMk3wOLNk5sxZxWbPnr3HyCQsL19ZYhkxGYfofHrPkjWbXyfR
ldDdAQAAAIBaKezx2G72SCr/RqFQlFy7lEPKOr1n5dqthz/lMhUQOwAAAABQ
WxXN8SiFkRe+d+WyLYfscpk8JaQOAAAAANRB1cFDzss8smXZ5lPu+WwBpA4A
AAAA1FHVweO9t9mCeXPm/rtgyZKly746/yxZDiEEAAAAADWnUspFPBaLK6rw
URGXnZ9PL0MgksDdawEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADUk/8D
S35aOw==
    "], {{0, 389.2075471698113}, {491.0943396226415, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{491.0943396226415, 389.2075471698113},
  PlotRange->{{0, 491.0943396226415}, {0, 389.2075471698113}}]], "Text",
 CellChangeTimes->{
  3.945509787103263*^9},ExpressionUUID->"f7950398-57cb-4ee6-bf14-\
597b39eb91df"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"P", ",", "Q"}], "]"}], ",", 
       RowBox[{"Medio", "[", 
        RowBox[{"R", ",", "S"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"P", ",", "S"}], "]"}], ",", 
       RowBox[{"Medio", "[", 
        RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
  3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
  3.9455136200666037`*^9}, {3.946439211017157*^9, 3.946439211737526*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"cf738f77-0d96-4e62-81a0-f2a504594dc8"]
}, Closed]],

Cell[CellGroupData[{

Cell["Poncelet point", "Subsubsection",
 CellChangeTimes->{{3.945509682961616*^9, 3.945509705247427*^9}, {
   3.945516718286007*^9, 3.945516720220911*^9}, 
   3.947132291355841*^9},ExpressionUUID->"f7957972-a4e9-446f-bafd-\
6774f0dd3699"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "PuntoDePoncelet", " ", "is", " ", "implemented", " ", "in", " ", "the", 
    " ", "baricentricas", " ", "package"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"PonceletPoint", "[", 
     RowBox[{"{", 
      RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
    RowBox[{"PuntoDePoncelet", "[", 
     RowBox[{"P", ",", 
      RowBox[{"{", 
       RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.945506298668439*^9, 3.9455064957646704`*^9}, {
  3.945508100242526*^9, 3.945508119954049*^9}, {3.9455093671686244`*^9, 
  3.945509538952415*^9}, {3.9455167413982186`*^9, 3.945516826125304*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"44de57fd-6e7d-4d98-94a0-c7b93947eadd"]
}, Closed]],

Cell[CellGroupData[{

Cell["Steiner point", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.947132277507908*^9, 
  3.947132283924074*^9}},ExpressionUUID->"ae32c2db-9871-344f-aabd-\
a2543db56100"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "X", ",", "Y", ",", "Z", ",", "T", ",", "U", ",", "V", ",", "W"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"X", ",", "Y", ",", "Z", ",", "U", ",", "T"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Apply", "[", 
          RowBox[{"Medio", ",", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"P", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"R", ",", "Q"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "R"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"S", ",", "Q"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"V", ",", "W"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Circuncentro", "[", "#", "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"X", ",", "Y", ",", "U"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Y", ",", "Z", ",", "T"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimetriaAxial", "[", 
       RowBox[{"Y", ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"V", ",", "W"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945506298668439*^9, 3.9455064957646704`*^9}, {
  3.945508100242526*^9, 3.945508119954049*^9}, {3.9455093671686244`*^9, 
  3.945509538952415*^9}, {3.945518206235336*^9, 3.945518260181164*^9}, {
  3.945518437370175*^9, 3.9455184493471375`*^9}, {3.947132243612131*^9, 
  3.947132244379742*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"db0fcba9-9144-4df7-981b-db22bb466a6e"]
}, Closed]],

Cell[CellGroupData[{

Cell["Diagonal point", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
   3.945521331783347*^9, 3.9455213360947638`*^9}, 
   3.947132343027188*^9},ExpressionUUID->"29f12ada-9fd0-4747-b323-\
2cf96d6fb52e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"P", ",", "R"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
  3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
  3.9455136200666037`*^9}, {3.945521346455207*^9, 3.9455213813107405`*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"158fb412-c771-43ab-b43b-a357380f4a11"]
}, Closed]],

Cell[CellGroupData[{

Cell["Central  quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.9464416787367783`*^9, 
  3.946441687230852*^9}},ExpressionUUID->"5a543829-5641-9144-8dd0-\
57eb7cf1938d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentralQuadrilateral", "[", "n_", "]"}], ":=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptB", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}]}], "]"}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.947157407080984*^9, 3.947157416769724*^9}, 
   3.947159936232693*^9},
 CellLabel->"In[32]:=",ExpressionUUID->"35cb8ff3-829e-654a-a95d-e2c972de6be9"]
}, Closed]],

Cell[CellGroupData[{

Cell["Area of a quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 
  3.945509840152308*^9}},ExpressionUUID->"e039afe9-d89d-4ec4-94b9-\
ddb3f9f259e0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AreaQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"AreaTriangulo", "[", 
     RowBox[{"{", 
      RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}], "+", 
    RowBox[{"AreaTriangulo", "[", 
     RowBox[{"{", 
      RowBox[{"R", ",", "S", ",", "P"}], "}"}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945518557002711*^9, 3.945518607763227*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"2db3c5dc-e4da-4371-937a-22cb108c81e1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Perspective  quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945619500071995*^9, 3.9456195111611595`*^9}, {
   3.94561961722077*^9, 3.945619628845907*^9}, {3.945620201468649*^9, 
   3.945620207996176*^9}, {3.946093948975952*^9, 3.946093951552325*^9}, 
   3.94619393871496*^9},ExpressionUUID->"bd16b166-d506-5544-b5d0-\
7aa6edfca35b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PerspectiveQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "P2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"R1", ",", "R2"}], "]"}]}], "}"}], "]"}], "==", "0"}], "&&", 
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "P2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"S1", ",", "S2"}], "]"}]}], "}"}], "]"}], "==", 
    "0"}]}]}]], "Input",
 CellChangeTimes->{{3.945619541933253*^9, 3.945619598797678*^9}, {
  3.945620227236483*^9, 3.945620398996369*^9}, {3.946093956887635*^9, 
  3.9460940140877304`*^9}, {3.9460946192084503`*^9, 3.9460946637685833`*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"6cd12b17-ccf6-1f40-8216-e746f72a898c"]
}, Closed]],

Cell[CellGroupData[{

Cell["Similar and homothetic quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 3.945509840152308*^9}, {
  3.945518917754542*^9, 3.945518929298341*^9}, {3.94551954978488*^9, 
  3.945519554745524*^9}, {3.9471326902197247`*^9, 3.9471326941873684`*^9}, {
  3.947132774954735*^9, 
  3.947132785771118*^9}},ExpressionUUID->"d546f79d-5ed9-4f99-846e-\
3ac1a3756b86"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SimilarQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SonSemejantes", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "Q1", ",", "R1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"P2", ",", "Q2", ",", "R2"}], "}"}]}], "]"}], "&&", 
    RowBox[{"SonSemejantes", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Q1", ",", "R1", ",", "S1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q2", ",", "R2", ",", "S2"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945518557002711*^9, 3.945518607763227*^9}, {
  3.9455189375627*^9, 3.945519039097607*^9}, {3.945519562008997*^9, 
  3.945519564865857*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"5668c7c2-b2f3-48b4-bb4e-3f493e46ab9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SonHomoteticos", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "Q1", ",", "R1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"P2", ",", "Q2", ",", "R2"}], "}"}]}], "]"}], "&&", 
    RowBox[{"SonHomoteticos", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Q1", ",", "R1", ",", "S1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q2", ",", "R2", ",", "S2"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.9455195703380117`*^9, 3.945519605171223*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"d07dfa48-d9b6-433c-9d4d-8f2532f1bec3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Congruent  quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945619500071995*^9, 3.9456195111611595`*^9}, {
   3.94561961722077*^9, 3.945619628845907*^9}, {3.945620201468649*^9, 
   3.945620207996176*^9}, 
   3.946437820730978*^9},ExpressionUUID->"8f461d45-0647-c84b-9fe0-\
f72d3601c63f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CongruentQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P1", ",", "Q1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P2", ",", "Q2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"Q1", ",", "R1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"Q2", ",", "R2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"R1", ",", "S1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"R2", ",", "S2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"S1", ",", "P1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"S2", ",", "P2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P1", ",", "R1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P2", ",", "R2"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945619541933253*^9, 3.945619598797678*^9}, {
  3.945620227236483*^9, 3.945620398996369*^9}, {3.946287549140295*^9, 
  3.946287549827748*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"5485ed32-34f6-e64e-bd2a-b4e163c2b97f"]
}, Closed]],

Cell[CellGroupData[{

Cell["Orthogonal  quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.946437760717503*^9, 
  3.9464377702703495`*^9}},ExpressionUUID->"54169a90-c35c-7a4a-a37f-\
78c9753e8eeb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OrthogonalQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "Q1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"P2", ",", "Q2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "R1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q2", ",", "R2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"R1", ",", "S1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"R2", ",", "S2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"S1", ",", "P1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"S2", ",", "P2"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9455195703380117`*^9, 3.945519605171223*^9}, {
  3.9460039858449364`*^9, 3.946003994260566*^9}, {3.946004044908913*^9, 
  3.946004131276815*^9}, {3.946004174101141*^9, 3.946004205589377*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"c1bc4c8d-1ecd-654a-b9e2-f902b4037dfa"]
}, Closed]],

Cell[CellGroupData[{

Cell["Conconic quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.946188760871956*^9, 3.946188779525741*^9}, {
  3.9464378271237335`*^9, 
  3.946437830963283*^9}},ExpressionUUID->"e126572d-bdab-a047-b925-\
c2661290f09e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "returns", " ", "TRUE", " ", "if", " ", "ABCD", " ", "and", " ", "EFGH", 
    " ", "are", " ", "conconic"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"conconicQuadQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA_", ",", "ptB_", ",", "ptC_", ",", "ptD_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE_", ",", "ptF_", ",", "ptG_", ",", "ptH_"}], "}"}]}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "conic", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"conic", "=", 
        RowBox[{"ConicaCincoPuntos", "[", 
         RowBox[{"{", 
          RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD", ",", "ptE"}], 
          "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sustituirxyz", "[", 
            RowBox[{"conic", ",", "#"}], "]"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{"ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], "==", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.946440275192674*^9, 3.946440364775547*^9}, {
  3.946557553720074*^9, 3.94655756021654*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"3eac6f83-9820-5d4f-9acd-4f2df1b13510"]
}, Closed]],

Cell[CellGroupData[{

Cell["Find QA center", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 3.945509840152308*^9}, {
  3.945518917754542*^9, 3.945518929298341*^9}, {3.94551954978488*^9, 
  3.945519554745524*^9}, {3.946186993811855*^9, 
  3.946187000755444*^9}},ExpressionUUID->"1d12da59-37f1-9842-ad9c-\
eb916041816f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "findQACenter", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"findQACenter", "[", 
    RowBox[{"ptP_", ",", 
     RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"found", "=", "0"}], ",", "sustCS", ",", 
       RowBox[{"nc", "=", 
        RowBox[{"Length", "[", "QAP", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sustCS", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"sustS", ",", "sustC"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Monitor", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "<=", "nc"}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"Simplify", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Cross", "[", 
                   RowBox[{"ptP", ",", 
                    RowBox[{"QAP", "[", "i", "]"}]}], "]"}], "//.", 
                  "sustCS"}], ",", "cond"}], "]"}], ")"}], "==", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
             RowBox[{
              RowBox[{"found", "=", "i"}], ";", 
              RowBox[{"Break", "[", "]"}]}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<Identifying the center... \>\"", ",", 
           RowBox[{"ProgressIndicator", "[", 
            RowBox[{"i", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "nc"}], "}"}]}], "]"}], ",", "\"\< \>\"", ",",
            "i", ",", "\"\</\>\"", ",", "nc"}], "}"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"found", "==", "0"}], ",", "\"\<unknown\>\"", ",", 
        RowBox[{"\"\<QA-P\>\"", "<>", 
         RowBox[{"ToString", "[", "found", "]"}]}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.946187173054329*^9, 3.946187213931603*^9}, {
   3.946187246486248*^9, 3.9461872843092823`*^9}, 3.946187365054121*^9, {
   3.946187480278492*^9, 3.9461874874540024`*^9}, 3.9461880462086487`*^9, {
   3.9461881054797783`*^9, 3.9461881291423397`*^9}, {3.946188268454359*^9, 
   3.9461883008316956`*^9}, {3.94618835627853*^9, 3.946188455318756*^9}, 
   3.946257761266403*^9, {3.946258916015583*^9, 3.94625896478343*^9}, {
   3.946259615877109*^9, 3.946259655534961*^9}, {3.947132891348004*^9, 
   3.947132924188181*^9}, {3.9471329718839912`*^9, 3.9471329845888424`*^9}, {
   3.947133025988367*^9, 3.94713303106756*^9}, {3.9471334511324477`*^9, 
   3.94713348841169*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"806c98e7-c027-de46-8fc2-cc2eda959f64"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Properties ", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 
  3.946441726397751*^9}},ExpressionUUID->"2609bf4c-7f5c-314e-a744-\
f86d4be283dd"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQt8DNf//5/1d4lHt/WjHz58qi1N45Kqtoki6FfiErdGaAUl7ndxaYSK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    "], {{0, 152.83018867924528`}, {612.6792452830189, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{612.6792452830189, 152.83018867924528`},
  PlotRange->{{0, 612.6792452830189}, {0, 152.83018867924528`}}]], "Text",
 CellChangeTimes->{3.946440201275278*^9, 3.947156733497298*^9, 
  3.9472978101973276`*^9, 
  3.947338775172636*^9},ExpressionUUID->"20c7ab22-8503-fd4d-9d34-\
15585b88ac29"],

Cell[CellGroupData[{

Cell["X (402)", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, {
  3.9464610917155704`*^9, 3.9464611026600075`*^9}, {3.946632411021583*^9, 
  3.946632434229698*^9}, {3.947297866154175*^9, 
  3.947297868570019*^9}},ExpressionUUID->"ff518d65-a0f8-c747-9b61-\
6945dd0bc981"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "402", "]"}]}]], "Input",
 CellChangeTimes->{3.947297875586096*^9},
 CellLabel->"In[42]:=",ExpressionUUID->"e0b01da5-a897-cd4f-b0b1-2357223a2632"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ",", "0", ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["c", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "14"], "+", 
      RowBox[{
       SuperscriptBox["a", "12"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "10"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"10", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"23", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"20", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         SuperscriptBox["c", "6"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"17", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"29", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"14", " ", 
          SuperscriptBox["b", "8"]}], "-", 
         RowBox[{"40", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"20", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"19", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{"15", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "8"]}], "-", 
         RowBox[{"19", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "4"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "14"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "10"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "12"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "17"}], " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"30", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"15", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "8"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "-", 
         SuperscriptBox["c", "8"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "8"]}], "-", 
         RowBox[{"13", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"29", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"23", " ", 
          SuperscriptBox["b", "8"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"59", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"19", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "10"]}], "+", 
         RowBox[{"37", " ", 
          SuperscriptBox["b", "8"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"56", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"20", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"29", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "8"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "10"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["c", "2"]}], ",", "0", ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "4"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "4"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.947297876392441*^9, 3.947569529264515*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"7f432fca-979b-e64d-8a0e-0de4c27a8544"]
}, Open  ]],

Cell[CellGroupData[{

Cell["m[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946461158294985*^9, 
  3.946461160123913*^9}},ExpressionUUID->"d3491785-d0cb-0845-94a3-\
8b5adb09187e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9466318167345757`*^9, 3.946631837510996*^9}, {
  3.947297873107735*^9, 3.947297881129851*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"6fa8cf10-f258-4140-89d7-41f8092c971a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946631855582459*^9, 3.946789458565813*^9, 
  3.94678982276914*^9, 3.947297883751475*^9, 3.9475695324918747`*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"c9e4c1b3-3037-a04d-805f-4560628ac039"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (618)", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, {
  3.9464610917155704`*^9, 3.9464611026600075`*^9}, {3.946632411021583*^9, 
  3.946632434229698*^9}, {3.947297866154175*^9, 3.947297868570019*^9}, {
  3.9472979066258087`*^9, 
  3.947297907377695*^9}},ExpressionUUID->"20ffb748-f353-044a-9825-\
a1db78291d18"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "618", "]"}]}]], "Input",
 CellChangeTimes->{
  3.947297875586096*^9, {3.9472979107627506`*^9, 3.9472979128582344`*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"fdc9ef69-9d21-a84c-b657-ee8eaf2860eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"3", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"4", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "8"], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"3", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         SuperscriptBox["c", "4"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "7"}], " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "6"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "6"]}], "+", 
      SuperscriptBox["c", "6"], "-", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "4"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"11", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "7"}], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "+", 
              RowBox[{
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "6"], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "6"]}], "-", 
      SuperscriptBox["c", "6"], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "4"], " ", "S"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"11", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"4", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "8"], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "8"]}], "+", 
      SuperscriptBox["c", "8"], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "6"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["b", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "4"], "-", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"8", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "12"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "7"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{"3", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
     ",", "0", ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "-", 
      SuperscriptBox["b", "8"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"11", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"3", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947297876392441*^9, 3.947297914267094*^9, 
  3.947569540172283*^9, 3.9475696024878445`*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"c5d918c0-c412-db48-bd0d-971594bfa099"],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"m", "[", "ABCD", "]"}], "=", 
   RowBox[{"stein", "[", "EFGH", "]"}]}], "Subsubsection",
  FontWeight->"Plain"]], "Input",
 CellChangeTimes->{{3.9475696222580605`*^9, 
  3.9475696423217144`*^9}},ExpressionUUID->"6c84246d-e297-f04f-a775-\
ae52438730cd"],

Cell[TextData[{
 "The direct calculation of stein[EFGH] requires enormous computation time. \n\
To reduce the computation time we can use the theorem 23.1\n\n",
 Cell[BoxData[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJzs3XdcFNfaB3DWa8E3qNckemNiJ0Q0lkQsAfUKagA1WGKNIhYUCzbEHhPs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     "], {{0, 292.0754716981132}, {751.2452830188679, 0}}, {0, 255},
     ColorFunction->RGBColor,
     ImageResolution->{106., 106.},
     RasterInterpolation->"High"],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   DefaultBaseStyle->"ImageGraphics",
   ImageSize->Automatic,
   ImageSizeRaw->{751.2452830188679, 292.0754716981132},
   PlotRange->{{0, 751.2452830188679}, {0, 292.0754716981132}}]], "Input",
  ExpressionUUID->"b7da0568-5588-9c4a-a69e-f0423831ff2a"]
}], "Text",
 CellChangeTimes->{{3.9472994194356136`*^9, 3.9472994693454742`*^9}, {
  3.947299504017752*^9, 3.947299614105875*^9}, {3.947316266713835*^9, 
  3.947316274962055*^9}, {3.94731630533972*^9, 3.947316332010044*^9}, {
  3.9473170586576843`*^9, 3.947317095497717*^9}, {3.947317194849718*^9, 
  3.947317298889639*^9}, {3.947317341938032*^9, 3.9473174231060047`*^9}, {
  3.947317467121708*^9, 3.947317585185892*^9}, {3.947317624762827*^9, 
  3.9473176385870953`*^9}, {3.94731768902536*^9, 3.947317755081932*^9}, {
  3.947318676394398*^9, 3.947318721785651*^9}, {3.947318769673577*^9, 
  3.947318770169335*^9}, {3.947318885656594*^9, 3.947319002434046*^9}, {
  3.947319034378628*^9, 3.947319072050034*^9}, {3.947319174193917*^9, 
  3.947319329201998*^9}, {3.947338828541483*^9, 
  3.947338877275997*^9}},ExpressionUUID->"b20de945-a789-2543-a56d-\
f3eb989cf2b9"],

Cell["The  Steiner  point  of EFGH is the midpoint M of EG", "Text",
 CellChangeTimes->{{3.9473389110944614`*^9, 
  3.9473389372600956`*^9}},ExpressionUUID->"980d7889-767d-3d43-b328-\
4c45ebd37351"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptM", "=", 
  RowBox[{"Simplificar", "[", 
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Medio", "[", 
      RowBox[{"ptE", ",", "ptG"}], "]"}], "]"}], "/.", "sustS"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947316586708475*^9, 3.947316611107062*^9}, 
   3.947316762026855*^9, {3.9473177820497856`*^9, 3.947317784745724*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"773b1ca5-7e72-3141-9504-5d8f61c7d5e6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"]}], "-", 
    SuperscriptBox["c", "2"]}], ",", "0", ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"]}], "+", 
    SuperscriptBox["c", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.947316612378044*^9, 3.9473167680877457`*^9, 
  3.947317785340342*^9, 3.947569552431711*^9, 3.9475696072020435`*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"c548acb3-ba4e-2d43-95f8-9f8bb048237b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", " ", "ptB", ",", " ", "ptC", ",", " ", "ptD"}], 
     "}"}], "]"}], ",", " ", "ptM"}], "]"}]], "Input",
 CellChangeTimes->{{3.947316914378315*^9, 3.947316915610934*^9}, {
  3.9473182611859217`*^9, 3.947318277700171*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"58fac083-b8d6-1741-b3d4-23437142fc47"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.947316917317274*^9, 3.9473183027152214`*^9, 
  3.947569553666149*^9, 3.947569608216854*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"ef31907a-08f2-7e49-98d4-50f3eaae71e5"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (619)", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, {
  3.9464610917155704`*^9, 3.9464611026600075`*^9}, {3.946632411021583*^9, 
  3.946632434229698*^9}, {3.947297866154175*^9, 3.947297868570019*^9}, {
  3.9472979066258087`*^9, 3.947297907377695*^9}, {3.9473183218492584`*^9, 
  3.947318321881201*^9}, {3.9475697627113304`*^9, 
  3.9475697632956944`*^9}},ExpressionUUID->"29a27573-e2e0-6747-bce6-\
b442d0ae4014"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "619", "]"}]}]], "Input",
 CellChangeTimes->{
  3.947297875586096*^9, {3.9472979107627506`*^9, 3.9472979128582344`*^9}, {
   3.947318327273796*^9, 3.9473183273300457`*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"fd791b5b-4532-734e-aeee-3fcdf9e2c81d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "8"], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "7"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"4", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "10"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"4", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
     ",", "0", ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "9"}], " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "6"], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "6"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "11"}], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "7"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "6"]}], "+", 
      SuperscriptBox["c", "6"], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "4"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"11", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"4", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "8"]}], "-", 
      SuperscriptBox["c", "8"], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "6"], " ", "S"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "4"], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{"8", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"12", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"3", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "4"]}], "-", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
     ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "8"], "+", 
      SuperscriptBox["b", "8"], "+", 
      SuperscriptBox["c", "8"], "-", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "6"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["b", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"11", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{"3", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "4"]}], "-", 
            RowBox[{
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox["c", "4"], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "5"}], " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "5"}], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947297876392441*^9, 3.947297914267094*^9, 
  3.947318328225025*^9, 3.9475697773990574`*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"f5c6c555-629d-3242-8466-63aab49960d2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["m[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946461158294985*^9, 
  3.946461160123913*^9}},ExpressionUUID->"981769b9-968f-2343-88d0-\
4c0c6a58cec9"],

Cell["\<\
The Steiner point of EFGH coincides with the midpoint M of EG\
\>", "Text",
 CellChangeTimes->{{3.9472994194356136`*^9, 3.9472994693454742`*^9}, {
  3.9472995040177517`*^9, 3.947299614105875*^9}, {3.947316266713835*^9, 
  3.947316274962055*^9}, {3.94731630533972*^9, 3.947316332010044*^9}, {
  3.9473170586576824`*^9, 3.947317095497717*^9}, {3.947317194849718*^9, 
  3.947317298889639*^9}, {3.947317341938032*^9, 3.9473174231060047`*^9}, {
  3.947317467121708*^9, 3.947317585185892*^9}, {3.947317624762827*^9, 
  3.9473176385870934`*^9}, {3.94731768902536*^9, 3.947317755081932*^9}, {
  3.9473183548624*^9, 
  3.947318393185173*^9}},ExpressionUUID->"2bc316b1-c8bf-874b-a6b1-\
0bd1fe6d62cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptM", "=", 
  RowBox[{"Simplificar", "[", 
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Medio", "[", 
      RowBox[{"ptE", ",", "ptG"}], "]"}], "]"}], "/.", "sustS"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947316586708475*^9, 3.947316611107062*^9}, 
   3.9473167620268545`*^9, {3.9473177820497856`*^9, 3.947317784745724*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"14712789-9c7e-6243-b204-6b1462e84175"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"]}], "+", 
    SuperscriptBox["c", "2"]}], ",", "0", ",", 
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"]}], "-", 
    SuperscriptBox["c", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.947316612378044*^9, 3.9473167680877447`*^9, 
  3.947317785340342*^9, 3.9473183980116653`*^9, 3.9475697820938263`*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"e6dfe0d2-4160-3c44-ba16-239f74c0ef25"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", " ", "ptB", ",", " ", "ptC", ",", " ", "ptD"}], 
     "}"}], "]"}], ",", " ", "ptM"}], "]"}]], "Input",
 CellChangeTimes->{{3.947316914378315*^9, 3.947316915610934*^9}, {
  3.9473182611859217`*^9, 3.947318277700171*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"c7a40bb7-f2fd-8b42-970a-5ca0f062368a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.947316917317274*^9, 3.9473183027152214`*^9, 
  3.9473184198500843`*^9, 3.947569783088663*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"452a9115-77ac-864e-8735-29432ec84507"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (620)", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, {
  3.9464610917155704`*^9, 3.9464611026600075`*^9}, {3.946632411021583*^9, 
  3.946632434229698*^9}, {3.947297866154175*^9, 3.947297868570019*^9}, {
  3.9472979066258087`*^9, 3.947297907377695*^9}, {3.9473183218492584`*^9, 
  3.947318321881201*^9}, {3.947318432785877*^9, 
  3.9473184336815796`*^9}},ExpressionUUID->"b9b1decb-eb8e-1a40-9c9b-\
aafc9e52c336"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "620", "]"}]}]], "Input",
 CellChangeTimes->{
  3.947297875586096*^9, {3.9472979107627506`*^9, 3.9472979128582344`*^9}, {
   3.947318327273796*^9, 3.9473183273300457`*^9}, {3.947318435745249*^9, 
   3.9473184366572647`*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"2e4b2399-2b43-ae4f-9db5-1b5b7bedf272"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ",", "0", ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["c", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "6"], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "6"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      SuperscriptBox["c", "6"], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "6"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      SuperscriptBox["c", "6"], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["c", "2"]}], ",", "0", ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox["c", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947297876392441*^9, 3.947297914267094*^9, 
  3.947318328225025*^9, 3.947318437547436*^9, 3.9475697891295033`*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"4fa9d98b-48f9-5441-ac73-2419c8dc9fcc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["m[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946461158294985*^9, 
  3.946461160123913*^9}},ExpressionUUID->"5f3e8620-3e38-3948-914b-\
2a851826cd04"],

Cell["\<\
The Steiner point of EFGH coincides with the midpoint M of EG\
\>", "Text",
 CellChangeTimes->{{3.9472994194356136`*^9, 3.9472994693454742`*^9}, {
  3.947299504017752*^9, 3.947299614105875*^9}, {3.947316266713835*^9, 
  3.947316274962055*^9}, {3.94731630533972*^9, 3.947316332010044*^9}, {
  3.9473170586576834`*^9, 3.947317095497717*^9}, {3.947317194849718*^9, 
  3.947317298889639*^9}, {3.947317341938032*^9, 3.9473174231060047`*^9}, {
  3.947317467121708*^9, 3.947317585185892*^9}, {3.947317624762827*^9, 
  3.9473176385870943`*^9}, {3.94731768902536*^9, 3.947317755081932*^9}, {
  3.9473183548624*^9, 
  3.947318393185173*^9}},ExpressionUUID->"9b089b96-2db4-9447-85cb-\
2202147e6438"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptM", "=", 
  RowBox[{"Simplificar", "[", 
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Medio", "[", 
      RowBox[{"ptE", ",", "ptG"}], "]"}], "]"}], "/.", "sustS"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947316586708475*^9, 3.947316611107062*^9}, 
   3.9473167620268545`*^9, {3.9473177820497856`*^9, 3.947317784745724*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"620b541b-8ded-7245-90d8-3684834fd6d4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"]}], "-", 
    SuperscriptBox["c", "2"]}], ",", "0", ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"]}], "+", 
    SuperscriptBox["c", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.947316612378044*^9, 3.9473167680877447`*^9, 
  3.947317785340342*^9, 3.9473183980116653`*^9, 3.9473184410821896`*^9, 
  3.9475697909178905`*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"e4430824-94fc-2444-a0fb-bfb83bab3980"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", " ", "ptB", ",", " ", "ptC", ",", " ", "ptD"}], 
     "}"}], "]"}], ",", " ", "ptM"}], "]"}]], "Input",
 CellChangeTimes->{{3.947316914378315*^9, 3.947316915610934*^9}, {
  3.9473182611859217`*^9, 3.947318277700171*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"416f0031-fbfe-8643-bb0e-bd8a8a608bcd"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.947316917317274*^9, 3.9473183027152214`*^9, {3.9473184198500843`*^9, 
   3.947318443002928*^9}, 3.9475697920236607`*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"e5aaa5cb-15e9-7247-a249-178b71fbf3a4"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (13)", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, {
  3.9464610917155704`*^9, 3.9464611026600075`*^9}, {3.946632411021583*^9, 
  3.946632434229698*^9}, {3.947297866154175*^9, 3.947297868570019*^9}, {
  3.9472979066258087`*^9, 3.947297907377695*^9}, {3.9473183218492584`*^9, 
  3.947318321881201*^9}, {3.947318432785877*^9, 3.9473184336815796`*^9}, {
  3.9473184757622204`*^9, 
  3.9473184761049557`*^9}},ExpressionUUID->"12f4816d-dcb8-a44b-83ae-\
274443f12cfc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "13", "]"}]}]], "Input",
 CellChangeTimes->{
  3.947297875586096*^9, {3.9472979107627506`*^9, 3.9472979128582344`*^9}, {
   3.947318327273796*^9, 3.9473183273300457`*^9}, {3.947318435745249*^9, 
   3.9473184366572647`*^9}, {3.947318484433624*^9, 3.9473184855371513`*^9}, {
   3.947318525185936*^9, 3.9473185339776936`*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"5ce7482a-e11d-0248-981b-db7e88cd8394"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "8"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", "0", ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "8"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"4", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"4", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"]}], "-", 
      SuperscriptBox["b", "6"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "8"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
     ",", "0", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "8"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "8"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "8"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"12", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"13", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "4"], "-", 
         RowBox[{
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "-", 
            RowBox[{
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947297876392441*^9, 3.947297914267094*^9, 3.947318328225025*^9, 
   3.947318437547436*^9, 3.9473184862926807`*^9, {3.947318525895252*^9, 
   3.947318534684498*^9}, 3.947569797708109*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"85157b95-67c0-b643-ad1f-1e387673282f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ponce[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946461158294985*^9, 3.946461160123913*^9}, {
  3.947318493409826*^9, 
  3.947318495017134*^9}},ExpressionUUID->"022cae0b-4742-8e43-a47f-\
339fbd70b313"],

Cell["\<\
The Steiner point of EFGH coincides with the midpoint M of EG\
\>", "Text",
 CellChangeTimes->{{3.9472994194356136`*^9, 3.9472994693454742`*^9}, {
  3.947299504017752*^9, 3.947299614105875*^9}, {3.947316266713835*^9, 
  3.947316274962055*^9}, {3.94731630533972*^9, 3.947316332010044*^9}, {
  3.9473170586576834`*^9, 3.947317095497717*^9}, {3.947317194849718*^9, 
  3.947317298889639*^9}, {3.947317341938032*^9, 3.9473174231060047`*^9}, {
  3.947317467121708*^9, 3.947317585185892*^9}, {3.947317624762827*^9, 
  3.9473176385870943`*^9}, {3.94731768902536*^9, 3.947317755081932*^9}, {
  3.9473183548624*^9, 
  3.947318393185173*^9}},ExpressionUUID->"991873da-fd4c-1a41-8ed4-\
d3bcb996290b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptM", "=", 
  RowBox[{"Simplificar", "[", 
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Medio", "[", 
      RowBox[{"ptE", ",", "ptG"}], "]"}], "]"}], "/.", "sustS"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947316586708475*^9, 3.947316611107062*^9}, 
   3.9473167620268545`*^9, {3.9473177820497856`*^9, 3.947317784745724*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"a1ee0ab4-735e-ad40-ab99-f5b2123ea782"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ",", "0", ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "+", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947316612378044*^9, 3.9473167680877447`*^9, 3.947317785340342*^9, 
   3.9473183980116653`*^9, 3.9473184410821896`*^9, {3.947318501749605*^9, 
   3.9473185365177402`*^9}, 3.9475698000182247`*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"22797821-b131-e549-a483-a7184b04d4b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"PonceletPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", " ", "ptB", ",", " ", "ptC", ",", " ", "ptD"}], 
     "}"}], "]"}], ",", " ", "ptM"}], "]"}]], "Input",
 CellChangeTimes->{{3.947316914378315*^9, 3.947316915610934*^9}, {
  3.9473182611859217`*^9, 3.947318277700171*^9}, {3.947318507746224*^9, 
  3.9473185144261265`*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"cd091f7b-86b4-4544-bd59-89eeaa4a93d1"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.947316917317274*^9, 3.9473183027152214`*^9, {3.9473184198500843`*^9, 
   3.947318443002928*^9}, {3.947318517878388*^9, 3.947318537512417*^9}, 
   3.947569800821722*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"71137c2b-7ac0-fd43-814a-d2806f1d13ae"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (14)", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, {
  3.9464610917155704`*^9, 3.9464611026600075`*^9}, {3.946632411021583*^9, 
  3.946632434229698*^9}, {3.947297866154175*^9, 3.947297868570019*^9}, {
  3.9472979066258087`*^9, 3.947297907377695*^9}, {3.9473183218492584`*^9, 
  3.947318321881201*^9}, {3.947318432785877*^9, 3.9473184336815796`*^9}, {
  3.9473184757622204`*^9, 3.9473184761049557`*^9}, {3.9473185523292084`*^9, 
  3.947318552354141*^9}},ExpressionUUID->"0a923f5f-d1b7-394f-aa1b-\
b07a6073a35c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "14", "]"}]}]], "Input",
 CellChangeTimes->{
  3.947297875586096*^9, {3.9472979107627506`*^9, 3.9472979128582344`*^9}, {
   3.947318327273796*^9, 3.9473183273300457`*^9}, {3.947318435745249*^9, 
   3.9473184366572647`*^9}, {3.947318484433624*^9, 3.9473184855371513`*^9}, {
   3.947318525185936*^9, 3.947318555514384*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"efd150eb-7be5-d249-9d93-7ad0c0945677"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "8"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", "0", ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "8"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"4", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "4"]}], "-", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"4", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"]}], "-", 
      SuperscriptBox["b", "6"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{"4", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "8"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["c", "4"]}], "-", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "-", 
            RowBox[{
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
     ",", "0", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "8"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "8"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "8"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"12", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"13", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "4"], "+", 
         RowBox[{
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947297876392441*^9, 3.947297914267094*^9, 3.947318328225025*^9, 
   3.947318437547436*^9, 3.9473184862926807`*^9, {3.947318525895252*^9, 
   3.947318556341215*^9}, 3.9475698065402393`*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"c0c53fc7-f316-144b-9054-39607408a0a8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ponce[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946461158294985*^9, 3.946461160123913*^9}, {
  3.947318493409826*^9, 
  3.947318495017134*^9}},ExpressionUUID->"8f956881-75dc-ac46-885d-\
e1fbcf7e2dbc"],

Cell["\<\
The Steiner point of EFGH coincides with the midpoint M of EG\
\>", "Text",
 CellChangeTimes->{{3.9472994194356136`*^9, 3.9472994693454742`*^9}, {
  3.947299504017752*^9, 3.947299614105875*^9}, {3.947316266713835*^9, 
  3.947316274962055*^9}, {3.94731630533972*^9, 3.947316332010044*^9}, {
  3.9473170586576834`*^9, 3.947317095497717*^9}, {3.947317194849718*^9, 
  3.947317298889639*^9}, {3.947317341938032*^9, 3.9473174231060047`*^9}, {
  3.947317467121708*^9, 3.947317585185892*^9}, {3.947317624762827*^9, 
  3.9473176385870943`*^9}, {3.94731768902536*^9, 3.947317755081932*^9}, {
  3.9473183548624*^9, 
  3.947318393185173*^9}},ExpressionUUID->"e2650aa1-5c09-7141-81e3-\
0d1d6fe227f4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptM", "=", 
  RowBox[{"Simplificar", "[", 
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Medio", "[", 
      RowBox[{"ptE", ",", "ptG"}], "]"}], "]"}], "/.", "sustS"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947316586708475*^9, 3.947316611107062*^9}, 
   3.9473167620268545`*^9, {3.9473177820497856`*^9, 3.947317784745724*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"41f0c6c7-f093-8b46-95b2-da687906b222"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "-", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}], ",", "0", ",", 
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947316612378044*^9, 3.9473167680877447`*^9, 3.947317785340342*^9, 
   3.9473183980116653`*^9, 3.9473184410821896`*^9, {3.947318501749605*^9, 
   3.9473185585108852`*^9}, 3.9475698091018867`*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"06d15365-3154-d849-885b-e88396ffa407"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"PonceletPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", " ", "ptB", ",", " ", "ptC", ",", " ", "ptD"}], 
     "}"}], "]"}], ",", " ", "ptM"}], "]"}]], "Input",
 CellChangeTimes->{{3.947316914378315*^9, 3.947316915610934*^9}, {
  3.9473182611859217`*^9, 3.947318277700171*^9}, {3.947318507746224*^9, 
  3.9473185144261265`*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"b503d5cd-8e2a-544e-b256-c4f549e35e9e"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.947316917317274*^9, 3.9473183027152214`*^9, {3.9473184198500843`*^9, 
   3.947318443002928*^9}, {3.947318517878388*^9, 3.947318560079983*^9}, 
   3.9475698098065624`*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"7a7ffe5b-5da1-b84c-8f48-d344b63f37a2"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (616)", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, {
  3.9464610917155704`*^9, 3.9464611026600075`*^9}, {3.946632411021583*^9, 
  3.946632434229698*^9}, {3.947297866154175*^9, 3.947297868570019*^9}, {
  3.9472979066258087`*^9, 3.947297907377695*^9}, {3.9473183218492584`*^9, 
  3.947318321881201*^9}, {3.947318432785877*^9, 3.9473184336815796`*^9}, {
  3.9473184757622204`*^9, 3.9473184761049557`*^9}, {3.9473185748570824`*^9, 
  3.9473185763454876`*^9}},ExpressionUUID->"f3db108b-995f-904c-b422-\
6bc32f6960fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "616", "]"}]}]], "Input",
 CellChangeTimes->{
  3.947297875586096*^9, {3.9472979107627506`*^9, 3.9472979128582344`*^9}, {
   3.947318327273796*^9, 3.9473183273300457`*^9}, {3.947318435745249*^9, 
   3.9473184366572647`*^9}, {3.947318484433624*^9, 3.9473184855371513`*^9}, {
   3.947318525185936*^9, 3.9473185339776936`*^9}, {3.9473185795378094`*^9, 
   3.947318580809675*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"7f2f46ef-0263-c843-b981-f661df99c0ff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"], "+", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", "0", ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{"11", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"4", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "6"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "6"]}], "+", 
      RowBox[{"7", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "4"], "-", 
         RowBox[{"3", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           SuperscriptBox["c", "2"], "+", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "8"]}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "8"], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "6"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "7"}], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"13", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "15"}], " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "11"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"4", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", "0", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"], "-", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         SuperscriptBox["c", "2"], "+", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947297876392441*^9, 3.947297914267094*^9, 3.947318328225025*^9, 
   3.947318437547436*^9, 3.9473184862926807`*^9, {3.947318525895252*^9, 
   3.947318534684498*^9}, 3.9473185828611574`*^9, 3.947569816112301*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"814453f4-02ed-0e47-8bbc-ede87573f893"]
}, Open  ]],

Cell[CellGroupData[{

Cell["stein[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946461158294985*^9, 3.946461160123913*^9}, {
  3.947318493409826*^9, 3.947318495017134*^9}, {3.947318589873333*^9, 
  3.947318590937098*^9}},ExpressionUUID->"9895b8ea-aefd-9e46-997b-\
a6c5b5123cc4"],

Cell["\<\
The Steiner point of EFGH coincides with the midpoint M of EG\
\>", "Text",
 CellChangeTimes->{{3.9472994194356136`*^9, 3.9472994693454742`*^9}, {
  3.947299504017752*^9, 3.947299614105875*^9}, {3.947316266713835*^9, 
  3.947316274962055*^9}, {3.94731630533972*^9, 3.947316332010044*^9}, {
  3.9473170586576834`*^9, 3.947317095497717*^9}, {3.947317194849718*^9, 
  3.947317298889639*^9}, {3.947317341938032*^9, 3.9473174231060047`*^9}, {
  3.947317467121708*^9, 3.947317585185892*^9}, {3.947317624762827*^9, 
  3.9473176385870943`*^9}, {3.94731768902536*^9, 3.947317755081932*^9}, {
  3.9473183548624*^9, 
  3.947318393185173*^9}},ExpressionUUID->"82b1185f-f519-d447-80e8-\
41133e1db0d3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptM", "=", 
  RowBox[{"Simplificar", "[", 
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Medio", "[", 
      RowBox[{"ptE", ",", "ptG"}], "]"}], "]"}], "/.", "sustS"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947316586708475*^9, 3.947316611107062*^9}, 
   3.9473167620268545`*^9, {3.9473177820497856`*^9, 3.947317784745724*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"9082369c-989f-1544-87cb-746952db7757"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{
  3.947316612378044*^9, 3.9473167680877447`*^9, 3.947317785340342*^9, 
   3.9473183980116653`*^9, 3.9473184410821896`*^9, {3.947318501749605*^9, 
   3.9473185365177402`*^9}, 3.947318597148739*^9, 3.9475698182015705`*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"5a83a01f-cef8-824c-b6b5-cd5436e1e6d0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", " ", "ptB", ",", " ", "ptC", ",", " ", "ptD"}], 
     "}"}], "]"}], ",", " ", "ptM"}], "]"}]], "Input",
 CellChangeTimes->{{3.947316914378315*^9, 3.947316915610934*^9}, {
  3.9473182611859217`*^9, 3.947318277700171*^9}, {3.947318507746224*^9, 
  3.9473185144261265`*^9}, {3.9473186027457542`*^9, 3.947318604210066*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"437e6c97-d8a9-fb4e-b22c-d74ffdc58155"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.947316917317274*^9, 3.9473183027152214`*^9, {3.9473184198500843`*^9, 
   3.947318443002928*^9}, {3.947318517878388*^9, 3.947318537512417*^9}, 
   3.9473186051719112`*^9, 3.9475698189906254`*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"1a834ebf-a61c-434d-994e-b71b928c48e9"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (617)", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, {
  3.9464610917155704`*^9, 3.9464611026600075`*^9}, {3.946632411021583*^9, 
  3.946632434229698*^9}, {3.947297866154175*^9, 3.947297868570019*^9}, {
  3.9472979066258087`*^9, 3.947297907377695*^9}, {3.9473183218492584`*^9, 
  3.947318321881201*^9}, {3.947318432785877*^9, 3.9473184336815796`*^9}, {
  3.9473184757622204`*^9, 3.9473184761049557`*^9}, {3.9473185748570824`*^9, 
  3.9473185763454876`*^9}, {3.94731861752207*^9, 
  3.9473186175529575`*^9}},ExpressionUUID->"9d55d619-4866-7f43-b259-\
7a4d6466d0aa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "617", "]"}]}]], "Input",
 CellChangeTimes->{
  3.947297875586096*^9, {3.9472979107627506`*^9, 3.9472979128582344`*^9}, {
   3.947318327273796*^9, 3.9473183273300457`*^9}, {3.947318435745249*^9, 
   3.9473184366572647`*^9}, {3.947318484433624*^9, 3.9473184855371513`*^9}, {
   3.947318525185936*^9, 3.9473185339776936`*^9}, {3.9473185795378094`*^9, 
   3.947318580809675*^9}, {3.947318622938017*^9, 3.947318622970112*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"1a449ef2-393d-dc43-9639-c3aea504a10a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{
              SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"], "+", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     "0", ",", 
     RowBox[{
      SuperscriptBox["a", "8"], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "9"}], " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{"4", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "6"]}], "-", 
      RowBox[{"7", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "6"], "-", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "4"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "4"], "+", 
         RowBox[{"3", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"], "+", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "6"], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "7"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "8"], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "8"]}], "-", 
      RowBox[{"9", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "8"], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "6"], " ", "S"}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"13", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"15", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"11", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"4", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
     ",", "0", ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"], "+", 
          SuperscriptBox["c", "4"], "+", 
          RowBox[{"2", " ", 
           SqrtBox["3"], " ", 
           SuperscriptBox["c", "2"], " ", "S"}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"], "+", 
             RowBox[{
              SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ")"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"], "+", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947297876392441*^9, 3.947297914267094*^9, 3.947318328225025*^9, 
   3.947318437547436*^9, 3.9473184862926807`*^9, {3.947318525895252*^9, 
   3.947318534684498*^9}, 3.9473185828611574`*^9, 3.947318624372526*^9, 
   3.9475698250361176`*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"3a888469-de42-df45-a523-53e2454b2f6a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["stein[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946461158294985*^9, 3.946461160123913*^9}, {
  3.947318493409826*^9, 3.947318495017134*^9}, {3.947318589873333*^9, 
  3.947318590937098*^9}},ExpressionUUID->"fba1f077-ec30-954d-9185-\
e9f0dd965589"],

Cell["\<\
The Steiner point of EFGH coincides with the midpoint M of EG\
\>", "Text",
 CellChangeTimes->{{3.9472994194356136`*^9, 3.9472994693454742`*^9}, {
  3.947299504017752*^9, 3.947299614105875*^9}, {3.947316266713835*^9, 
  3.947316274962055*^9}, {3.94731630533972*^9, 3.947316332010044*^9}, {
  3.9473170586576834`*^9, 3.947317095497717*^9}, {3.947317194849718*^9, 
  3.947317298889639*^9}, {3.947317341938032*^9, 3.9473174231060047`*^9}, {
  3.947317467121708*^9, 3.947317585185892*^9}, {3.947317624762827*^9, 
  3.9473176385870943`*^9}, {3.94731768902536*^9, 3.947317755081932*^9}, {
  3.9473183548624*^9, 
  3.947318393185173*^9}},ExpressionUUID->"0b9c58df-08bd-dd42-aaf7-\
1f63cddae9da"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptM", "=", 
  RowBox[{"Simplificar", "[", 
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Medio", "[", 
      RowBox[{"ptE", ",", "ptG"}], "]"}], "]"}], "/.", "sustS"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947316586708475*^9, 3.947316611107062*^9}, 
   3.9473167620268545`*^9, {3.9473177820497856`*^9, 3.947317784745724*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"0c88f817-646d-d942-970e-0536f8505de0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "0", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947316612378044*^9, 3.9473167680877447`*^9, 3.947317785340342*^9, 
   3.9473183980116653`*^9, 3.9473184410821896`*^9, {3.947318501749605*^9, 
   3.9473185365177402`*^9}, {3.947318597148739*^9, 3.947318627035221*^9}, 
   3.94756982679706*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"2429c644-c4c8-984b-9fa6-6e4fc3d60f0a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", " ", "ptB", ",", " ", "ptC", ",", " ", "ptD"}], 
     "}"}], "]"}], ",", " ", "ptM"}], "]"}]], "Input",
 CellChangeTimes->{{3.947316914378315*^9, 3.947316915610934*^9}, {
  3.9473182611859217`*^9, 3.947318277700171*^9}, {3.947318507746224*^9, 
  3.9473185144261265`*^9}, {3.9473186027457542`*^9, 3.947318604210066*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"703e3ed4-8c96-af41-9fae-a029a0cd8c96"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.947316917317274*^9, 3.9473183027152214`*^9, {3.9473184198500843`*^9, 
   3.947318443002928*^9}, {3.947318517878388*^9, 3.947318537512417*^9}, {
   3.9473186051719112`*^9, 3.947318628252388*^9}, 3.947569827831526*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"649a37a0-b713-0643-bd07-961bb4096bbe"]
}, Closed]]
}, Closed]]
},
CellGrouping->Manual,
WindowSize->{1293.2830188679245`, 654.7924528301886},
WindowMargins->{{0, Automatic}, {Automatic, -0.6792452830188679}},
FrontEndVersion->"14.0 for Microsoft Windows (64-bit) (December 12, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"804b5677-3157-c646-b166-03c5a5ac69c8"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 247, 4, 98, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[808, 26, 1396, 24, 173, "Text",ExpressionUUID->"22c83543-03f0-524a-b077-52bf40ea5d06"],
Cell[CellGroupData[{
Cell[2229, 54, 200, 4, 67, "Section",ExpressionUUID->"5e4c6aa2-710c-4599-941e-5f13e499af78"],
Cell[CellGroupData[{
Cell[2454, 62, 1399, 30, 67, "Input",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"],
Cell[3856, 94, 542, 16, 35, "Output",ExpressionUUID->"5a41ecdf-0ee5-7447-a5f9-2d923e1cb5f6"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[4447, 116, 255, 4, 53, "Section",ExpressionUUID->"cf60f297-bbcd-8748-b453-e7118b4e0a98"],
Cell[CellGroupData[{
Cell[4727, 124, 212, 4, 54, "Subsection",ExpressionUUID->"c8cca55e-04f1-8f4a-b670-3c3179eed91e"],
Cell[4942, 130, 271222, 7062, 3643, "Input",ExpressionUUID->"90297db1-2eea-6346-9338-a3e8dcfe0024"]
}, Closed]],
Cell[CellGroupData[{
Cell[276201, 7197, 215, 4, 38, "Subsection",ExpressionUUID->"79ef6085-3de7-3c49-8561-f943fbd2d431"],
Cell[276419, 7203, 433, 11, 28, "Input",ExpressionUUID->"e725b315-4161-274c-8798-a4e0c807d6a8"],
Cell[276855, 7216, 435, 11, 28, "Input",ExpressionUUID->"60fea3de-a36e-734d-b67f-75eab8f36838"],
Cell[277293, 7229, 434, 11, 28, "Input",ExpressionUUID->"422bd8e2-a85e-d748-b542-6c9b62c11efd"],
Cell[277730, 7242, 1078, 29, 28, "Input",ExpressionUUID->"d021f1ab-c58d-b74b-8aa5-a62365464cc5"],
Cell[278811, 7273, 816, 23, 28, "Input",ExpressionUUID->"023d4850-e194-b941-a762-4c9a532e11d1"],
Cell[279630, 7298, 599, 16, 28, "Input",ExpressionUUID->"62ef2468-c328-714d-8bf7-299b142a086d"],
Cell[280232, 7316, 2069, 53, 181, "Input",ExpressionUUID->"d734f707-6812-364b-b359-ac3a6bb66e72"],
Cell[282304, 7371, 1710, 46, 143, "Input",ExpressionUUID->"34f7e383-98aa-bc47-9867-166186424dd4"],
Cell[284017, 7419, 1910, 50, 162, "Input",ExpressionUUID->"4370c731-693f-a941-82c8-1f6a14f724b2"],
Cell[285930, 7471, 609, 16, 28, "Input",ExpressionUUID->"6e2024d9-4541-ea4e-a308-49a8bb9b87a5"],
Cell[286542, 7489, 1127, 29, 124, "Input",ExpressionUUID->"384fc915-4ebd-5342-9174-a166a5e7f52d"],
Cell[287672, 7520, 1391, 39, 124, "Input",ExpressionUUID->"e878baba-ea71-dd4f-b972-2e4c3753c774"],
Cell[289066, 7561, 1394, 39, 124, "Input",ExpressionUUID->"4200ee2b-abeb-b246-85fa-68f1ce5d836b"],
Cell[290463, 7602, 1326, 38, 124, "Input",ExpressionUUID->"8131db8a-5012-e741-93f3-ec6da52923f1"],
Cell[291792, 7642, 1364, 37, 143, "Input",ExpressionUUID->"3e5eb206-464c-7e4f-b628-98c50c5a4629"]
}, Closed]],
Cell[CellGroupData[{
Cell[293193, 7684, 291, 5, 38, "Subsection",ExpressionUUID->"d004e03f-8f12-9a43-865f-339812029417"],
Cell[293487, 7691, 3314, 100, 130, "Input",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],
Cell[CellGroupData[{
Cell[296838, 7796, 170, 3, 38, "Subsection",ExpressionUUID->"2a49be25-3c4e-430e-86c6-869880736f30"],
Cell[CellGroupData[{
Cell[297033, 7803, 217, 4, 45, "Subsubsection",ExpressionUUID->"a576f9af-1f5b-4213-b4d3-e7b66981337e"],
Cell[297253, 7809, 53880, 889, 404, "Text",ExpressionUUID->"f7950398-57cb-4ee6-bf14-597b39eb91df"],
Cell[351136, 8700, 995, 24, 86, "Input",ExpressionUUID->"cf738f77-0d96-4e62-81a0-f2a504594dc8"]
}, Closed]],
Cell[CellGroupData[{
Cell[352168, 8729, 238, 4, 37, "Subsubsection",ExpressionUUID->"f7957972-a4e9-446f-bafd-6774f0dd3699"],
Cell[352409, 8735, 813, 18, 48, "Input",ExpressionUUID->"44de57fd-6e7d-4d98-94a0-c7b93947eadd"]
}, Closed]],
Cell[CellGroupData[{
Cell[353259, 8758, 215, 4, 37, "Subsubsection",ExpressionUUID->"ae32c2db-9871-344f-aabd-a2543db56100"],
Cell[353477, 8764, 2072, 56, 101, "Input",ExpressionUUID->"db0fcba9-9144-4df7-981b-db22bb466a6e"]
}, Closed]],
Cell[CellGroupData[{
Cell[355586, 8825, 242, 4, 37, "Subsubsection",ExpressionUUID->"29f12ada-9fd0-4747-b323-2cf96d6fb52e"],
Cell[355831, 8831, 660, 15, 28, "Input",ExpressionUUID->"158fb412-c771-43ab-b43b-a357380f4a11"]
}, Closed]],
Cell[CellGroupData[{
Cell[356528, 8851, 175, 3, 37, "Subsubsection",ExpressionUUID->"5a543829-5641-9144-8dd0-57eb7cf1938d"],
Cell[356706, 8856, 1655, 44, 124, "Input",ExpressionUUID->"35cb8ff3-829e-654a-a95d-e2c972de6be9"]
}, Closed]],
Cell[CellGroupData[{
Cell[358398, 8905, 174, 3, 37, "Subsubsection",ExpressionUUID->"e039afe9-d89d-4ec4-94b9-ddb3f9f259e0"],
Cell[358575, 8910, 558, 14, 28, "Input",ExpressionUUID->"2db3c5dc-e4da-4371-937a-22cb108c81e1"]
}, Closed]],
Cell[CellGroupData[{
Cell[359170, 8929, 347, 5, 37, "Subsubsection",ExpressionUUID->"bd16b166-d506-5544-b5d0-7aa6edfca35b"],
Cell[359520, 8936, 1243, 33, 52, "Input",ExpressionUUID->"6cd12b17-ccf6-1f40-8216-e746f72a898c"]
}, Closed]],
Cell[CellGroupData[{
Cell[360800, 8974, 384, 6, 37, "Subsubsection",ExpressionUUID->"d546f79d-5ed9-4f99-846e-3ac1a3756b86"],
Cell[361187, 8982, 968, 26, 28, "Input",ExpressionUUID->"5668c7c2-b2f3-48b4-bb4e-3f493e46ab9c"],
Cell[362158, 9010, 879, 24, 28, "Input",ExpressionUUID->"d07dfa48-d9b6-433c-9d4d-8f2532f1bec3"]
}, Closed]],
Cell[CellGroupData[{
Cell[363074, 9039, 300, 5, 37, "Subsubsection",ExpressionUUID->"8f461d45-0647-c84b-9fe0-f72d3601c63f"],
Cell[363377, 9046, 1682, 40, 157, "Input",ExpressionUUID->"5485ed32-34f6-e64e-bd2a-b4e163c2b97f"]
}, Closed]],
Cell[CellGroupData[{
Cell[365096, 9091, 179, 3, 37, "Subsubsection",ExpressionUUID->"54169a90-c35c-7a4a-a37f-78c9753e8eeb"],
Cell[365278, 9096, 1627, 39, 124, "Input",ExpressionUUID->"c1bc4c8d-1ecd-654a-b9e2-f902b4037dfa"]
}, Closed]],
Cell[CellGroupData[{
Cell[366942, 9140, 225, 4, 37, "Subsubsection",ExpressionUUID->"e126572d-bdab-a047-b925-c2661290f09e"],
Cell[367170, 9146, 1438, 37, 105, "Input",ExpressionUUID->"3eac6f83-9820-5d4f-9acd-4f2df1b13510"]
}, Closed]],
Cell[CellGroupData[{
Cell[368645, 9188, 308, 5, 37, "Subsubsection",ExpressionUUID->"1d12da59-37f1-9842-ad9c-eb916041816f"],
Cell[368956, 9195, 3086, 70, 219, "Input",ExpressionUUID->"806c98e7-c027-de46-8fc2-cc2eda959f64"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[372103, 9272, 211, 4, 53, "Section",ExpressionUUID->"2609bf4c-7f5c-314e-a744-f86d4be283dd"],
Cell[372317, 9278, 36279, 600, 167, "Text",ExpressionUUID->"20c7ab22-8503-fd4d-9d34-15585b88ac29"],
Cell[CellGroupData[{
Cell[408621, 9882, 303, 5, 54, "Subsection",ExpressionUUID->"ff518d65-a0f8-c747-9b61-6945dd0bc981"],
Cell[CellGroupData[{
Cell[408949, 9891, 294, 6, 28, "Input",ExpressionUUID->"e0b01da5-a897-cd4f-b0b1-2357223a2632"],
Cell[409246, 9899, 16976, 511, 187, "Output",ExpressionUUID->"7f432fca-979b-e64d-8a0e-0de4c27a8544"]
}, Open  ]],
Cell[CellGroupData[{
Cell[426259, 10415, 172, 3, 45, "Subsubsection",ExpressionUUID->"d3491785-d0cb-0845-94a3-8b5adb09187e"],
Cell[CellGroupData[{
Cell[426456, 10422, 525, 12, 28, "Input",ExpressionUUID->"6fa8cf10-f258-4140-89d7-41f8092c971a"],
Cell[426984, 10436, 244, 3, 32, "Output",ExpressionUUID->"c9e4c1b3-3037-a04d-805f-4560628ac039"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[427289, 10446, 354, 6, 38, "Subsection",ExpressionUUID->"20ffb748-f353-044a-9825-a1db78291d18"],
Cell[427646, 10454, 347, 7, 28, "Input",ExpressionUUID->"fdc9ef69-9d21-a84c-b657-ee8eaf2860eb"],
Cell[427996, 10463, 17543, 547, 232, "Output",ExpressionUUID->"c5d918c0-c412-db48-bd0d-971594bfa099"],
Cell[445542, 11012, 300, 8, 36, "Input",ExpressionUUID->"6c84246d-e297-f04f-a775-ae52438730cd"],
Cell[445845, 11022, 49960, 823, 373, "Text",ExpressionUUID->"b20de945-a789-2543-a56d-f3eb989cf2b9"],
Cell[495808, 11847, 198, 3, 35, "Text",ExpressionUUID->"980d7889-767d-3d43-b328-4c45ebd37351"],
Cell[CellGroupData[{
Cell[496031, 11854, 442, 10, 28, "Input",ExpressionUUID->"773b1ca5-7e72-3141-9504-5d8f61c7d5e6"],
Cell[496476, 11866, 596, 16, 35, "Output",ExpressionUUID->"c548acb3-ba4e-2d43-95f8-9f8bb048237b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[497109, 11887, 431, 9, 28, "Input",ExpressionUUID->"58fac083-b8d6-1741-b3d4-23437142fc47"],
Cell[497543, 11898, 223, 3, 32, "Output",ExpressionUUID->"ef31907a-08f2-7e49-98d4-50f3eaae71e5"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[497815, 11907, 455, 7, 38, "Subsection",ExpressionUUID->"29a27573-e2e0-6747-bce6-b442d0ae4014"],
Cell[CellGroupData[{
Cell[498295, 11918, 399, 8, 28, "Input",ExpressionUUID->"fd791b5b-4532-734e-aeee-3fcdf9e2c81d"],
Cell[498697, 11928, 17705, 554, 232, "Output",ExpressionUUID->"f5c6c555-629d-3242-8466-63aab49960d2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[516439, 12487, 172, 3, 45, "Subsubsection",ExpressionUUID->"981769b9-968f-2343-88d0-4c0c6a58cec9"],
Cell[516614, 12492, 700, 12, 35, "Text",ExpressionUUID->"2bc316b1-c8bf-874b-a6b1-0bd1fe6d62cb"],
Cell[CellGroupData[{
Cell[517339, 12508, 444, 10, 28, "Input",ExpressionUUID->"14712789-9c7e-6243-b204-6b1462e84175"],
Cell[517786, 12520, 598, 16, 35, "Output",ExpressionUUID->"e6dfe0d2-4160-3c44-ba16-239f74c0ef25"]
}, Open  ]],
Cell[CellGroupData[{
Cell[518421, 12541, 431, 9, 28, "Input",ExpressionUUID->"c7a40bb7-f2fd-8b42-970a-5ca0f062368a"],
Cell[518855, 12552, 225, 3, 32, "Output",ExpressionUUID->"452a9115-77ac-864e-8735-29432ec84507"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[519141, 12562, 453, 7, 38, "Subsection",ExpressionUUID->"b9b1decb-eb8e-1a40-9c9b-aafc9e52c336"],
Cell[CellGroupData[{
Cell[519619, 12573, 451, 9, 28, "Input",ExpressionUUID->"2e4b2399-2b43-ae4f-9db5-1b5b7bedf272"],
Cell[520073, 12584, 4484, 138, 78, "Output",ExpressionUUID->"4fa9d98b-48f9-5441-ac73-2419c8dc9fcc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[524594, 12727, 172, 3, 45, "Subsubsection",ExpressionUUID->"5f3e8620-3e38-3948-914b-2a851826cd04"],
Cell[524769, 12732, 698, 12, 35, "Text",ExpressionUUID->"9b089b96-2db4-9447-85cb-2202147e6438"],
Cell[CellGroupData[{
Cell[525492, 12748, 444, 10, 28, "Input",ExpressionUUID->"620b541b-8ded-7245-90d8-3684834fd6d4"],
Cell[525939, 12760, 625, 17, 35, "Output",ExpressionUUID->"e4430824-94fc-2444-a0fb-bfb83bab3980"]
}, Open  ]],
Cell[CellGroupData[{
Cell[526601, 12782, 431, 9, 28, "Input",ExpressionUUID->"416f0031-fbfe-8643-bb0e-bd8a8a608bcd"],
Cell[527035, 12793, 255, 4, 32, "Output",ExpressionUUID->"e5aaa5cb-15e9-7247-a249-178b71fbf3a4"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[527351, 12804, 505, 8, 38, "Subsection",ExpressionUUID->"12f4816d-dcb8-a44b-83ae-274443f12cfc"],
Cell[CellGroupData[{
Cell[527881, 12816, 550, 10, 28, "Input",ExpressionUUID->"5ce7482a-e11d-0248-981b-db7e88cd8394"],
Cell[528434, 12828, 14075, 443, 166, "Output",ExpressionUUID->"85157b95-67c0-b643-ad1f-1e387673282f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[542546, 13276, 225, 4, 45, "Subsubsection",ExpressionUUID->"022cae0b-4742-8e43-a47f-339fbd70b313"],
Cell[542774, 13282, 698, 12, 35, "Text",ExpressionUUID->"991873da-fd4c-1a41-8ed4-d3bcb996290b"],
Cell[CellGroupData[{
Cell[543497, 13298, 444, 10, 28, "Input",ExpressionUUID->"a1ee0ab4-735e-ad40-ab99-f5b2123ea782"],
Cell[543944, 13310, 626, 16, 35, "Output",ExpressionUUID->"22797821-b131-e549-a483-a7184b04d4b9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[544607, 13331, 483, 10, 28, "Input",ExpressionUUID->"cd091f7b-86b4-4544-bd59-89eeaa4a93d1"],
Cell[545093, 13343, 303, 5, 32, "Output",ExpressionUUID->"71137c2b-7ac0-fd43-814a-d2806f1d13ae"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[545457, 13355, 553, 8, 38, "Subsection",ExpressionUUID->"0a923f5f-d1b7-394f-aa1b-b07a6073a35c"],
Cell[CellGroupData[{
Cell[546035, 13367, 548, 10, 28, "Input",ExpressionUUID->"efd150eb-7be5-d249-9d93-7ad0c0945677"],
Cell[546586, 13379, 14135, 445, 166, "Output",ExpressionUUID->"c0c53fc7-f316-144b-9054-39607408a0a8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[560758, 13829, 225, 4, 45, "Subsubsection",ExpressionUUID->"8f956881-75dc-ac46-885d-e1fbcf7e2dbc"],
Cell[560986, 13835, 698, 12, 35, "Text",ExpressionUUID->"e2650aa1-5c09-7141-81e3-0d1d6fe227f4"],
Cell[CellGroupData[{
Cell[561709, 13851, 444, 10, 28, "Input",ExpressionUUID->"41f0c6c7-f093-8b46-95b2-da687906b222"],
Cell[562156, 13863, 626, 16, 35, "Output",ExpressionUUID->"06d15365-3154-d849-885b-e88396ffa407"]
}, Open  ]],
Cell[CellGroupData[{
Cell[562819, 13884, 483, 10, 28, "Input",ExpressionUUID->"b503d5cd-8e2a-544e-b256-c4f549e35e9e"],
Cell[563305, 13896, 305, 5, 32, "Output",ExpressionUUID->"7a7ffe5b-5da1-b84c-8f48-d344b63f37a2"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[563671, 13908, 556, 8, 38, "Subsection",ExpressionUUID->"f3db108b-995f-904c-b422-6bc32f6960fa"],
Cell[CellGroupData[{
Cell[564252, 13920, 603, 11, 28, "Input",ExpressionUUID->"7f2f46ef-0263-c843-b981-f661df99c0ff"],
Cell[564858, 13933, 13822, 427, 188, "Output",ExpressionUUID->"814453f4-02ed-0e47-8bbc-ede87573f893"]
}, Open  ]],
Cell[CellGroupData[{
Cell[578717, 14365, 271, 4, 45, "Subsubsection",ExpressionUUID->"9895b8ea-aefd-9e46-997b-a6c5b5123cc4"],
Cell[578991, 14371, 698, 12, 35, "Text",ExpressionUUID->"82b1185f-f519-d447-80e8-41133e1db0d3"],
Cell[CellGroupData[{
Cell[579714, 14387, 444, 10, 28, "Input",ExpressionUUID->"9082369c-989f-1544-87cb-746952db7757"],
Cell[580161, 14399, 403, 7, 32, "Output",ExpressionUUID->"5a83a01f-cef8-824c-b6b5-cd5436e1e6d0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[580601, 14411, 530, 10, 28, "Input",ExpressionUUID->"437e6c97-d8a9-fb4e-b22c-d74ffdc58155"],
Cell[581134, 14423, 329, 5, 32, "Output",ExpressionUUID->"1a834ebf-a61c-434d-994e-b71b928c48e9"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[581524, 14435, 606, 9, 38, "Subsection",ExpressionUUID->"9d55d619-4866-7f43-b259-7a4d6466d0aa"],
Cell[CellGroupData[{
Cell[582155, 14448, 649, 11, 28, "Input",ExpressionUUID->"1a449ef2-393d-dc43-9639-c3aea504a10a"],
Cell[582807, 14461, 14038, 432, 188, "Output",ExpressionUUID->"3a888469-de42-df45-a523-53e2454b2f6a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[596882, 14898, 271, 4, 45, "Subsubsection",ExpressionUUID->"fba1f077-ec30-954d-9185-e9f0dd965589"],
Cell[597156, 14904, 698, 12, 35, "Text",ExpressionUUID->"0b9c58df-08bd-dd42-aaf7-1f63cddae9da"],
Cell[CellGroupData[{
Cell[597879, 14920, 444, 10, 28, "Input",ExpressionUUID->"0c88f817-646d-d942-970e-0536f8505de0"],
Cell[598326, 14932, 466, 10, 32, "Output",ExpressionUUID->"2429c644-c4c8-984b-9fa6-6e4fc3d60f0a"]
}, Open  ]],
Cell[598807, 14945, 530, 10, 28, "Input",ExpressionUUID->"703e3ed4-8c96-af41-9fae-a029a0cd8c96"]
}, Open  ]],
Cell[599352, 14958, 351, 5, 32, "Output",ExpressionUUID->"649a37a0-b713-0643-bd07-961bb4096bbe"]
}, Closed]]
}, Closed]]
}
]
*)

