(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    695268,      17683]
NotebookOptionsPosition[    671219,      17267]
NotebookOutlinePosition[    671689,      17284]
CellTagsIndexPosition[    671646,      17281]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Rectangles", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, 
   3.947147906503248*^9, {3.947481336744753*^9, 3.947481338032559*^9}, {
   3.947482272199051*^9, 
   3.947482274311268*^9}},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about rectangles in the \
paper \"More Relationships between a Central Quadrilateral and its Reference \
Quadrilateral\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in \
February 2025.

This Notebook is Copyright \[Copyright] February 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947481344697075*^9, 3.947481347432724*^9}, {
  3.9474822817822647`*^9, 
  3.947482284055073*^9}},ExpressionUUID->"08758b0a-705f-b842-b1d6-\
6a28a79b6218"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.94550589477663*^9, 3.9455059090976067`*^9}, {
  3.947131190260437*^9, 
  3.947131192227951*^9}},ExpressionUUID->"5e4c6aa2-710c-4599-941e-\
5f13e499af78"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", ">", "0"}], ",", 
     RowBox[{"b", ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ptD", "=", 
  RowBox[{"SimetriaCentral", "[", 
   RowBox[{"ptB", ",", 
    RowBox[{"Medio", "[", 
     RowBox[{"ptA", ",", "ptC"}], "]"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.945504565162958*^9, 3.94550458198252*^9}, {
   3.9455170892604294`*^9, 3.945517091156999*^9}, {3.946437513579389*^9, 
   3.946437514387348*^9}, {3.946437922994858*^9, 3.946437998083948*^9}, {
   3.947131229988783*^9, 3.9471312337408752`*^9}, {3.94713126947538*^9, 
   3.947131271053065*^9}, {3.9471314397563486`*^9, 3.947131528028438*^9}, {
   3.947131689741032*^9, 3.947131695924305*^9}, {3.947131733918829*^9, 
   3.947131775067988*^9}, 3.94713185451009*^9, {3.947132455427481*^9, 
   3.947132456035076*^9}, {3.947133799219084*^9, 3.947133799613205*^9}, {
   3.947481378154803*^9, 3.947481389864706*^9}},
 CellLabel->
  "In[133]:=",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "1"}], ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.947481395665182*^9, 3.9474816145492115`*^9, 
  3.947481680153954*^9, 3.9474823730894623`*^9, 3.9475555964164085`*^9, 
  3.947557816984436*^9},
 CellLabel->
  "Out[135]=",ExpressionUUID->"fbbbb472-2c5e-1249-bc79-2ea15ed2049d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"rectangle", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"p", "-", "r"}], "==", "0"}], "&&", 
    RowBox[{
     RowBox[{"q", "+", "r"}], "==", "0"}], "&&", 
    RowBox[{
     SuperscriptBox["b", "2"], "==", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["c", "2"]}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.947482363135172*^9, {3.947555922084621*^9, 3.947555935116661*^9}, {
   3.9475592740451717`*^9, 3.9475592813813*^9}},
 CellLabel->
  "In[212]:=",ExpressionUUID->"d0c5b345-9e88-e04a-9131-1e258249750e"]
}, Closed]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"cf60f297-bbcd-8748-b453-\
e7118b4e0a98"],

Cell[CellGroupData[{

Cell["QAP centers", "Subsection",
 CellChangeTimes->{{3.945853740709931*^9, 3.945853743438184*^9}, {
  3.9464394595455627`*^9, 
  3.9464394652171745`*^9}},ExpressionUUID->"c8cca55e-04f1-8f4a-b670-\
3c3179eed91e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP", "=", 
   RowBox[{"<|", 
    RowBox[{
     RowBox[{"1", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ",", 
        RowBox[{"p", "+", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ",", 
        RowBox[{"p", "+", "q", "+", 
         RowBox[{"2", " ", "r"}]}]}], "}"}]}], ",", 
     RowBox[{"2", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", "SB"}], "-", 
           RowBox[{"r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "SA"}], "+", 
           RowBox[{"r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "SA"}], "-", 
           RowBox[{"q", " ", "SB"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"3", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}]}], 
          ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", 
              RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"4", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", "SA"}], "-", 
           RowBox[{"2", " ", "p", " ", "q", " ", "SA"}], "-", 
           RowBox[{"2", " ", "p", " ", "r", " ", "SA"}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}]}], ")"}]}],
         ",", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p"}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q"}], "-", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}], 
             ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"5", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"6", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"q", " ", 
                SuperscriptBox["SB", "2"]}], "-", 
               RowBox[{"r", " ", 
                SuperscriptBox["SC", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"p", " ", 
                SuperscriptBox["SA", "2"]}], "-", 
               RowBox[{"r", " ", 
                SuperscriptBox["SC", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"p", " ", 
                SuperscriptBox["SA", "2"]}], "-", 
               RowBox[{"q", " ", 
                SuperscriptBox["SB", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"7", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SB", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 SuperscriptBox["SB", "2"], "+", 
                 RowBox[{"2", " ", "SB", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"2", " ", "SB", " ", "SC"}], "+", 
                 SuperscriptBox["SC", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"3", " ", "r", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"r", " ", "SC", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "SA"}], "+", "SC"}], ")"}]}], "+", 
              RowBox[{"p", " ", "SA", " ", 
               RowBox[{"(", 
                RowBox[{"SA", "+", 
                 RowBox[{"2", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SA", " ", "SC"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"3", " ", "q", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"q", " ", "SB", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "SA"}], "+", "SB"}], ")"}]}], "+", 
              RowBox[{"p", " ", "SA", " ", 
               RowBox[{"(", 
                RowBox[{"SA", "+", 
                 RowBox[{"2", " ", "SB"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SA", " ", "SB"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}],
        "}"}]}], ",", 
     RowBox[{"8", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "p"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "p"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "q"}], "+", 
            RowBox[{"4", " ", "r", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}]}], "}"}]}],
      ",", 
     RowBox[{"9", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p", " ", "q"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"]}], "+", 
                 RowBox[{"3", " ", "p", " ", "r"}], "+", 
                 RowBox[{"q", " ", "r"}], "-", 
                 SuperscriptBox["r", "2"]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "p", " ", "q"}], "-", 
                 SuperscriptBox["q", "2"], "+", 
                 RowBox[{"2", " ", "p", " ", "r"}], "+", 
                 RowBox[{"q", " ", "r"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "q"}], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"4", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "q"}], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "-", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"5", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"3", " ", "p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "8"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "8"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", 
                 RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"p", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
              "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"p", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"8", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"4", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["c", "6"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["p", "2"]}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "q", " ", 
                  SuperscriptBox["r", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"12", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"9", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["q", "3"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"12", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"13", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "r"}], "-", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["p", "2"], "-", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "6"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "q", " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"5", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "-", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["q", "2"], " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "3"}], " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  SuperscriptBox["q", "3"], " ", "r"}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  SuperscriptBox["r", "3"]}], "+", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["p", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"8", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "3"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"12", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["c", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["q", "2"]}]}], ")"}], " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "r"}], "-", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "6"]}], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["p", "2"]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["q", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"5", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "-", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["q", "2"], " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"8", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"6", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "3"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    RowBox[{"2", " ", "q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"12", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"13", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"9", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"10", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"11", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"12", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
          ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", "q", " ", "SB"}], "+", 
           RowBox[{"p", " ", "r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{"p", " ", "q", " ", "SA"}], "+", 
           RowBox[{"q", " ", "r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r", " ", "SA"}], "+", 
           RowBox[{"q", " ", "r", " ", "SB"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", "q", " ", 
            SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"13", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"14", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "r"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"5", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"2", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"2", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}]}], "}"}]}], 
     ",", 
     RowBox[{"15", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"q", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["q", "2"]}], "+", 
               RowBox[{"5", " ", "q", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"5", " ", "q", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["p", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["q", "2"]}], "+", 
               RowBox[{"22", " ", "q", " ", "r"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "p"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"5", " ", "p", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"5", " ", "p", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["q", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"22", " ", "p", " ", "r"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["q", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               SuperscriptBox["q", "2"]}], ")"}], " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "p"}], "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"5", " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"5", " ", "p", " ", "q"}], "+", 
               SuperscriptBox["q", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"5", " ", "p", " ", "q"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["q", "2"]}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"22", " ", "p", " ", "q"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["q", "2"]}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"10", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"16", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"17", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["q", "2"], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"18", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"19", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"20", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"21", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"22", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"23", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", "q", " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
         RowBox[{"p", " ", "q", " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
         RowBox[{"p", " ", "r", " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", "SB"}]}]}], "}"}]}], ",", 
     RowBox[{"24", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", "SB", " ", 
          "SC"}], "-", 
         RowBox[{"4", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "SC"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], ")"}], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", "SC"}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "SA", " ", 
          "SC"}], "-", 
         RowBox[{"4", " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "SC"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], ")"}], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", "SC"}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "SA", " ", 
          "SB"}], "-", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"25", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"2", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"26", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"5", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"5", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"5", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"27", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["p", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"], " ", "q"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"p", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{"q", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "3"]}], " ", "q"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           SuperscriptBox["q", "4"], "+", 
           RowBox[{
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"q", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["p", "3"], " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"2", " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           SuperscriptBox["r", "4"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"28", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "4"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["b", "2"], "-", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", "r"}]}], 
             ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "4"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["q", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "+", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", "r"}], "+", 
              RowBox[{
               SuperscriptBox["a", "4"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"3", " ", "q", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", 
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "+", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["a", "2"], "-", 
                   SuperscriptBox["b", "2"]}], ")"}], " ", "p", " ", "q"}], 
                "+", 
                RowBox[{
                 SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "4"], " ", "q", " ", "r"}]}], ")"}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"3", " ", "q", " ", "r"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
       "}"}]}], ",", 
     RowBox[{"29", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["a", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "3"], " ", "r"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["p", "2"]}], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"30", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "q"}], ")"}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "-", 
              RowBox[{"3", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "p"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"3", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "p"}], "+", "q"}], ")"}], " ", "r", 
            " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"3", " ", "q"}]}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
       "}"}]}], ",", 
     RowBox[{"31", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"32", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", "q", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}]}], "}"}]}],
      ",", 
     RowBox[{"33", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB", " ", 
             "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA", " ", 
             "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA", " ", 
             "SB"}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"34", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"4", " ", "q"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p"}], "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"35", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"15", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "3"], " ", "r"}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"5", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"15", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"12", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"5", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["p", "2"]}], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"15", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"15", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"12", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"36", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["c", "2"]}], " ", "q"}], "-", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "-", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q", " ", "r"}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
               RowBox[{
                SuperscriptBox["a", "4"], " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["b", "4"], " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["c", "2"]}], " ", "p"}], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "p"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "r"}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "4"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["c", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["b", "2"], " ", 
                SuperscriptBox["c", "2"], " ", "q", " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["b", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["c", "4"], " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "-", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "q"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}]}], ")"}]}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["b", "2"]}], " ", "p"}], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "4"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["c", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["a", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["c", "4"], " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "p"}], "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}]}], "}"}]}], ",", 
     RowBox[{"37", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"p", " ", "q", " ", "SB"}], "+", 
            RowBox[{"p", " ", "r", " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"p", " ", "q", " ", "SA"}], "+", 
            RowBox[{"q", " ", "r", " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r", " ", "SA"}], "+", 
            RowBox[{"q", " ", "r", " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"38", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["b", "2"]}], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "-", "q", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", "p"}], "+", "q", "+", "r"}], 
                ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", 
                 RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", 
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "q", "+", 
             RowBox[{"2", " ", "r"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "-", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "-", "q", "-", 
                   RowBox[{"2", " ", "r"}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "-", "q", "+", 
                   RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          ")"}]}]}], "}"}]}], ",", 
     RowBox[{"39", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["b", "2"], "-", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "-", "r"}], ")"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "+", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "p"}], "+", "r"}], ")"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               RowBox[{"2", " ", "p", " ", "r"}], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["a", "2"], "-", 
                 SuperscriptBox["b", "2"]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "q"}], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}]}], "}"}]}], ",", 
     RowBox[{"40", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], "+", 
            SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", 
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "p"}], "+", 
                   RowBox[{"2", " ", "q"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "q"}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["q", "2"]}]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", "p"}], "+", 
                  RowBox[{"2", " ", "q"}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "r", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", 
                  RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["p", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", "q"}], "+", 
                  RowBox[{"9", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["q", "2"]}], "+", 
                  RowBox[{"15", " ", "q", " ", "r"}], "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["a", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"9", " ", "p"}], "+", 
                  RowBox[{"7", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"12", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "r"}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "q"}], "+", 
                   RowBox[{"2", " ", "r"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["p", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", "q"}], "+", 
                  RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", 
                   SuperscriptBox["q", "2"]}], "+", 
                  RowBox[{"15", " ", "q", " ", "r"}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], "+", 
            SuperscriptBox["b", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", 
                  RowBox[{"2", " ", "q"}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "q"}], "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["q", "2"]}]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", "p"}], "+", 
                  RowBox[{"9", " ", "q"}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "p"}], "+", 
                   RowBox[{"3", " ", "r"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "p"}], "+", 
                  RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"6", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "r"}], "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"41", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "4"]}], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "4"]}], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"42", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q", " ", "r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "SB"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"43", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", "p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", "p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"44", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "q"}], "-", 
            RowBox[{"q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p", " ", "q"}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            SuperscriptBox["q", "3"], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            SuperscriptBox["r", "3"]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "3"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            SuperscriptBox["r", "3"]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "3"], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            SuperscriptBox["q", "3"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}]}], "|>"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945841589546528*^9, 3.945841604944151*^9}, {
   3.9458416486015606`*^9, 3.945841701130226*^9}, 3.94584180266897*^9, {
   3.945841855521532*^9, 3.945841865133842*^9}, {3.9458419743855267`*^9, 
   3.94584197851943*^9}, {3.945842012120521*^9, 3.945842016064451*^9}, {
   3.945842114756489*^9, 3.945842119338508*^9}, {3.945842170028664*^9, 
   3.945842174123476*^9}, {3.945842254968681*^9, 3.9458422593104534`*^9}, {
   3.94584246069957*^9, 3.945842465998068*^9}, {3.945842501032144*^9, 
   3.9458425325383263`*^9}, {3.945842735167492*^9, 3.945842742091593*^9}, {
   3.945842846919035*^9, 3.945842850061655*^9}, {3.945842936494915*^9, 
   3.945842969633366*^9}, {3.945843125849571*^9, 3.94584313274209*^9}, {
   3.945843174894972*^9, 3.945843178277809*^9}, {3.9458432197775517`*^9, 
   3.9458432370243473`*^9}, {3.945843287330616*^9, 3.9458432907977543`*^9}, {
   3.945843326923149*^9, 3.9458433430906563`*^9}, {3.945843384493232*^9, 
   3.945843387811741*^9}, {3.945843423557177*^9, 3.945843427076299*^9}, {
   3.9458460856414566`*^9, 3.9458460903603935`*^9}, {3.9458461244501*^9, 
   3.945846127392929*^9}, {3.945846273464027*^9, 3.945846279270181*^9}, {
   3.945846311960058*^9, 3.945846315350111*^9}, {3.945846366817175*^9, 
   3.945846382831234*^9}, {3.945846756353731*^9, 3.9458467662170296`*^9}, {
   3.945846811099188*^9, 3.945846841686339*^9}, {3.945846884211832*^9, 
   3.945847260236458*^9}, {3.945847371762398*^9, 3.9458473779483223`*^9}, {
   3.945847468577452*^9, 3.945847473866535*^9}, {3.9458476375888367`*^9, 
   3.945847641254919*^9}, {3.945847770316178*^9, 3.9458477741893463`*^9}, {
   3.94584781182493*^9, 3.9458478153183575`*^9}, {3.94584788583465*^9, 
   3.945847888720951*^9}, {3.94584794845273*^9, 3.9458479545306664`*^9}, {
   3.945848036235821*^9, 3.945848039850874*^9}, {3.945848209145437*^9, 
   3.945848213365254*^9}, {3.945848428704586*^9, 3.945848437990104*^9}, {
   3.945848526693582*^9, 3.945848534626331*^9}, {3.945848666528978*^9, 
   3.94584868269029*^9}, {3.945848775077949*^9, 3.945848778998434*^9}, {
   3.945848877398905*^9, 3.945848886629158*^9}, {3.9458491238654*^9, 
   3.945849128054989*^9}, {3.945849197156975*^9, 3.9458492011715355`*^9}, {
   3.9458492397412167`*^9, 3.945849244243763*^9}, 3.945849479846901*^9, {
   3.945851715909244*^9, 3.945851732617178*^9}, 3.945853235726444*^9, {
   3.945853633264748*^9, 3.9458536354922667`*^9}, {3.946058981146543*^9, 
   3.946058983238126*^9}, {3.946113816440451*^9, 3.946113833217655*^9}, 
   3.946113923272053*^9, 3.9462998579964046`*^9},
 CellLabel->
  "In[138]:=",ExpressionUUID->"90297db1-2eea-6346-9338-a3e8dcfe0024"]
}, Closed]],

Cell[CellGroupData[{

Cell["QAP constructions", "Subsection",
 CellChangeTimes->{{3.946258018000845*^9, 3.9462580514460297`*^9}, {
  3.946439582465828*^9, 
  3.94643958360841*^9}},ExpressionUUID->"79ef6085-3de7-3c49-8561-\
f943fbd2d431"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP1", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258220966779*^9, 3.946258253166219*^9}},
 CellLabel->
  "In[139]:=",ExpressionUUID->"e725b315-4161-274c-8798-a4e0c807d6a8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP2", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"PonceletPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258127112749*^9, 3.946258205014044*^9}},
 CellLabel->
  "In[140]:=",ExpressionUUID->"60fea3de-a36e-734d-b67f-75eab8f36838"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP3", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258267006763*^9, 3.946258272798765*^9}},
 CellLabel->
  "In[141]:=",ExpressionUUID->"422bd8e2-a85e-d748-b542-6c9b62c11efd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP4", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsogonal", "[", 
        RowBox[{"P", ",", 
         RowBox[{"{", 
          RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsogonal", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"{", 
          RowBox[{"P", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258285271057*^9, 3.946258529254532*^9}, {
  3.946258821686931*^9, 3.946258862614427*^9}},
 CellLabel->
  "In[142]:=",ExpressionUUID->"d021f1ab-c58d-b74b-8aa5-a62365464cc5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP5", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsotomico", "[", 
        RowBox[{"P", ",", 
         RowBox[{"{", 
          RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", "P"}], 
      "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsotomico", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"{", 
          RowBox[{"P", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", "Q"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946552139912605*^9, 3.946552177047758*^9}},
 CellLabel->
  "In[143]:=",ExpressionUUID->"023d4850-e194-b941-a762-4c9a532e11d1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP6", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Medio", "[", 
    RowBox[{
     RowBox[{"QAP2", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}], ",", 
     RowBox[{"QAP4", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946554002925066*^9, 3.946554042045203*^9}},
 CellLabel->
  "In[144]:=",ExpressionUUID->"62ef2468-c328-714d-8bf7-299b142a086d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP7", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Q1", ",", "Q2", ",", "Q3", ",", "Q4", ",", "R1", ",", "R2"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Q1", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q2", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q3", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q4", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R1", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q2", ",", "Q3", ",", "Q4"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R2", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q1", ",", "Q3", ",", "Q4"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R1"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R2"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946258285271057*^9, 3.946258529254532*^9}, {
  3.946258821686931*^9, 3.946258862614427*^9}, {3.946290848591799*^9, 
  3.946291021534954*^9}, {3.946291111031261*^9, 3.946291120455242*^9}, {
  3.946696200711548*^9, 3.946696200806263*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"d734f707-6812-364b-b359-ac3a6bb66e72"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MiquelPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"U", ",", "V", ",", "O1", ",", "O2"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"U", "=", 
       RowBox[{"Punto", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "Q"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"V", "=", 
       RowBox[{"Punto", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "S"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"O1", "=", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "S", ",", "U"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"O2", "=", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"R", ",", "S", ",", "V"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimetriaAxial", "[", 
       RowBox[{"S", ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"O1", ",", "O2"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]",
     "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946294457093628*^9, 3.946294688202664*^9}, {
   3.9462961458488*^9, 3.9462961471441994`*^9}, 3.9462963028076897`*^9, {
   3.9462973681984005`*^9, 3.946297370950136*^9}},
 CellLabel->
  "In[146]:=",ExpressionUUID->"34f7e383-98aa-bc47-9867-166186424dd4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MiquelCircle", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"U", ",", "V", ",", "W", ",", "O1", ",", "O2", ",", "O3"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"U", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"V", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O1", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "S", ",", "U"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O2", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"R", ",", "S", ",", "V"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O3", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"Q", ",", "R", ",", "U"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CircunferenciaTresPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"O1", ",", "O2", ",", "O3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946295931650831*^9, 3.9462959921519623`*^9}, {
  3.9462960978401566`*^9, 3.946296126960247*^9}, {3.946296309416164*^9, 
  3.946296387663599*^9}, {3.946296507206955*^9, 3.946296515015978*^9}, {
  3.9462965951590157`*^9, 3.9462966339272327`*^9}},
 CellLabel->
  "In[147]:=",ExpressionUUID->"4370c731-693f-a941-82c8-1f6a14f724b2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP8", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"SimetriaCentral", "[", 
    RowBox[{
     RowBox[{"QAP4", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}], ",", 
     RowBox[{"QAP2", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946554262541748*^9, 3.946554276084837*^9}},
 CellLabel->
  "In[148]:=",ExpressionUUID->"6e2024d9-4541-ea4e-a308-49a8bb9b87a5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP9", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c1", ",", "c2", ",", "c3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"c1", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c2", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "Q", ",", "S", ",", "R"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c3", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "R", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CentroRadical", "[", 
      RowBox[{"c1", ",", "c2", ",", "c3"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9462975678957386`*^9, 3.94629768995805*^9}},
 CellLabel->
  "In[149]:=",ExpressionUUID->"384fc915-4ebd-5342-9174-a166a5e7f52d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP10", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Baricentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946554372389721*^9, 3.94655438207695*^9}},
 CellLabel->
  "In[150]:=",ExpressionUUID->"e878baba-ea71-dd4f-b972-2e4c3753c774"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP11", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Circuncentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946554416053346*^9, 3.946554423653038*^9}},
 CellLabel->
  "In[151]:=",ExpressionUUID->"4200ee2b-abeb-b246-85fa-68f1ce5d836b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP12", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->
  "In[152]:=",ExpressionUUID->"8131db8a-5012-e741-93f3-ec6da52923f1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP34", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"P1", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P2", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P3", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P4", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"QAP2", "[", 
       RowBox[{"{", 
        RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946362022452154*^9, 3.9463621697479362`*^9}},
 CellLabel->
  "In[153]:=",ExpressionUUID->"3e5eb206-464c-7e4f-b628-98c50c5a4629"]
}, Closed]],

Cell[CellGroupData[{

Cell["Auxiliary functions", "Subsection",
 CellChangeTimes->{
  3.818667972143658*^9, {3.8186680382464933`*^9, 3.818668041714528*^9}, {
   3.818668136826049*^9, 3.818668143553762*^9}, {3.818685183717651*^9, 
   3.818685185711126*^9}},ExpressionUUID->"d004e03f-8f12-9a43-865f-\
339812029417"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"EqualPointsQ", "[", 
      RowBox[{"ptP_", ",", "ptQ_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cross", "[", 
           RowBox[{"ptP", ",", "ptQ"}], "]"}], "/.", "sustS"}], "/.", 
         "sustC"}], ",", "cond"}], "]"}], "===", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.947132996916015*^9, 3.9471330125156*^9}, {
  3.947133479684403*^9, 3.947133480044634*^9}},
 CellLabel->
  "In[154]:=",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],

Cell[CellGroupData[{

Cell["Quadrilateral routines", "Subsection",
 CellChangeTimes->{{3.945509919017998*^9, 
  3.945509932600797*^9}},ExpressionUUID->"2a49be25-3c4e-430e-86c6-\
869880736f30"],

Cell[CellGroupData[{

Cell["Vertex centroid", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.947132319963703*^9, 
  3.947132328106987*^9}},ExpressionUUID->"a576f9af-1f5b-4213-b4d3-\
e7b66981337e"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3Qd8FGX+P3D+v7v7nb+zAPZTT7EgoJyn56moZ0fQKBq6dIggATVSgmBo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    "], {{0, 389.2075471698113}, {491.0943396226415, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{491.0943396226415, 389.2075471698113},
  PlotRange->{{0, 491.0943396226415}, {0, 389.2075471698113}}]], "Text",
 CellChangeTimes->{
  3.945509787103263*^9},ExpressionUUID->"f7950398-57cb-4ee6-bf14-\
597b39eb91df"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"P", ",", "Q"}], "]"}], ",", 
       RowBox[{"Medio", "[", 
        RowBox[{"R", ",", "S"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"P", ",", "S"}], "]"}], ",", 
       RowBox[{"Medio", "[", 
        RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
  3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
  3.9455136200666037`*^9}, {3.946439211017157*^9, 3.946439211737526*^9}},
 CellLabel->
  "In[158]:=",ExpressionUUID->"cf738f77-0d96-4e62-81a0-f2a504594dc8"]
}, Closed]],

Cell[CellGroupData[{

Cell["Poncelet point", "Subsubsection",
 CellChangeTimes->{{3.945509682961616*^9, 3.945509705247427*^9}, {
   3.945516718286007*^9, 3.945516720220911*^9}, 
   3.947132291355841*^9},ExpressionUUID->"f7957972-a4e9-446f-bafd-\
6774f0dd3699"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "PuntoDePoncelet", " ", "is", " ", "implemented", " ", "in", " ", "the", 
    " ", "baricentricas", " ", "package"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"PonceletPoint", "[", 
     RowBox[{"{", 
      RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
    RowBox[{"PuntoDePoncelet", "[", 
     RowBox[{"P", ",", 
      RowBox[{"{", 
       RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.945506298668439*^9, 3.9455064957646704`*^9}, {
  3.945508100242526*^9, 3.945508119954049*^9}, {3.9455093671686244`*^9, 
  3.945509538952415*^9}, {3.9455167413982186`*^9, 3.945516826125304*^9}},
 CellLabel->
  "In[159]:=",ExpressionUUID->"44de57fd-6e7d-4d98-94a0-c7b93947eadd"]
}, Closed]],

Cell[CellGroupData[{

Cell["Steiner point", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.947132277507908*^9, 
  3.947132283924074*^9}},ExpressionUUID->"ae32c2db-9871-344f-aabd-\
a2543db56100"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "X", ",", "Y", ",", "Z", ",", "T", ",", "U", ",", "V", ",", "W"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"X", ",", "Y", ",", "Z", ",", "U", ",", "T"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Apply", "[", 
          RowBox[{"Medio", ",", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"P", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"R", ",", "Q"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "R"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"S", ",", "Q"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"V", ",", "W"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Circuncentro", "[", "#", "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"X", ",", "Y", ",", "U"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Y", ",", "Z", ",", "T"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimetriaAxial", "[", 
       RowBox[{"Y", ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"V", ",", "W"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945506298668439*^9, 3.9455064957646704`*^9}, {
  3.945508100242526*^9, 3.945508119954049*^9}, {3.9455093671686244`*^9, 
  3.945509538952415*^9}, {3.945518206235336*^9, 3.945518260181164*^9}, {
  3.945518437370175*^9, 3.9455184493471375`*^9}, {3.947132243612131*^9, 
  3.947132244379742*^9}},
 CellLabel->
  "In[160]:=",ExpressionUUID->"db0fcba9-9144-4df7-981b-db22bb466a6e"]
}, Closed]],

Cell[CellGroupData[{

Cell["Diagonal point", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
   3.945521331783347*^9, 3.9455213360947638`*^9}, 
   3.947132343027188*^9},ExpressionUUID->"29f12ada-9fd0-4747-b323-\
2cf96d6fb52e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"P", ",", "R"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
  3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
  3.9455136200666037`*^9}, {3.945521346455207*^9, 3.9455213813107405`*^9}},
 CellLabel->
  "In[161]:=",ExpressionUUID->"158fb412-c771-43ab-b43b-a357380f4a11"]
}, Closed]],

Cell[CellGroupData[{

Cell["Central quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.9464416787367783`*^9, 3.946441687230852*^9}, 
   3.947147898383025*^9},ExpressionUUID->"5a543829-5641-9144-8dd0-\
57eb7cf1938d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentralQuadrilateral", "[", "n_", "]"}], ":=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptB", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}]}], "]"}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellLabel->
  "In[162]:=",ExpressionUUID->"35cb8ff3-829e-654a-a95d-e2c972de6be9"]
}, Closed]],

Cell[CellGroupData[{

Cell["Area of a quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 
  3.945509840152308*^9}},ExpressionUUID->"e039afe9-d89d-4ec4-94b9-\
ddb3f9f259e0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AreaQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"AreaTriangulo", "[", 
     RowBox[{"{", 
      RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}], "+", 
    RowBox[{"AreaTriangulo", "[", 
     RowBox[{"{", 
      RowBox[{"R", ",", "S", ",", "P"}], "}"}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945518557002711*^9, 3.945518607763227*^9}},
 CellLabel->
  "In[163]:=",ExpressionUUID->"2db3c5dc-e4da-4371-937a-22cb108c81e1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Perspective quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945619500071995*^9, 3.9456195111611595`*^9}, {
   3.94561961722077*^9, 3.945619628845907*^9}, {3.945620201468649*^9, 
   3.945620207996176*^9}, {3.946093948975952*^9, 3.946093951552325*^9}, 
   3.94619393871496*^9, 
   3.947147899655007*^9},ExpressionUUID->"bd16b166-d506-5544-b5d0-\
7aa6edfca35b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PerspectiveQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "P2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"R1", ",", "R2"}], "]"}]}], "}"}], "]"}], "==", "0"}], "&&", 
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "P2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"S1", ",", "S2"}], "]"}]}], "}"}], "]"}], "==", 
    "0"}]}]}]], "Input",
 CellChangeTimes->{{3.945619541933253*^9, 3.945619598797678*^9}, {
  3.945620227236483*^9, 3.945620398996369*^9}, {3.946093956887635*^9, 
  3.9460940140877304`*^9}, {3.9460946192084503`*^9, 3.9460946637685833`*^9}},
 CellLabel->
  "In[164]:=",ExpressionUUID->"6cd12b17-ccf6-1f40-8216-e746f72a898c"]
}, Closed]],

Cell[CellGroupData[{

Cell["Similar and homothetic quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 3.945509840152308*^9}, {
  3.945518917754542*^9, 3.945518929298341*^9}, {3.94551954978488*^9, 
  3.945519554745524*^9}, {3.9471326902197247`*^9, 3.9471326941873684`*^9}, {
  3.947132774954735*^9, 
  3.947132785771118*^9}},ExpressionUUID->"d546f79d-5ed9-4f99-846e-\
3ac1a3756b86"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SimilarQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SonSemejantes", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "Q1", ",", "R1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"P2", ",", "Q2", ",", "R2"}], "}"}]}], "]"}], "&&", 
    RowBox[{"SonSemejantes", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Q1", ",", "R1", ",", "S1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q2", ",", "R2", ",", "S2"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945518557002711*^9, 3.945518607763227*^9}, {
  3.9455189375627*^9, 3.945519039097607*^9}, {3.945519562008997*^9, 
  3.945519564865857*^9}},
 CellLabel->
  "In[165]:=",ExpressionUUID->"5668c7c2-b2f3-48b4-bb4e-3f493e46ab9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SonHomoteticos", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "Q1", ",", "R1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"P2", ",", "Q2", ",", "R2"}], "}"}]}], "]"}], "&&", 
    RowBox[{"SonHomoteticos", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Q1", ",", "R1", ",", "S1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q2", ",", "R2", ",", "S2"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.9455195703380117`*^9, 3.945519605171223*^9}},
 CellLabel->
  "In[166]:=",ExpressionUUID->"d07dfa48-d9b6-433c-9d4d-8f2532f1bec3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Congruent quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945619500071995*^9, 3.9456195111611595`*^9}, {
   3.94561961722077*^9, 3.945619628845907*^9}, {3.945620201468649*^9, 
   3.945620207996176*^9}, 3.946437820730978*^9, 
   3.9471479009831057`*^9},ExpressionUUID->"8f461d45-0647-c84b-9fe0-\
f72d3601c63f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CongruentQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P1", ",", "Q1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P2", ",", "Q2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"Q1", ",", "R1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"Q2", ",", "R2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"R1", ",", "S1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"R2", ",", "S2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"S1", ",", "P1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"S2", ",", "P2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P1", ",", "R1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P2", ",", "R2"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945619541933253*^9, 3.945619598797678*^9}, {
  3.945620227236483*^9, 3.945620398996369*^9}, {3.946287549140295*^9, 
  3.946287549827748*^9}},
 CellLabel->
  "In[167]:=",ExpressionUUID->"5485ed32-34f6-e64e-bd2a-b4e163c2b97f"]
}, Closed]],

Cell[CellGroupData[{

Cell["Orthogonal quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.946437760717503*^9, 3.9464377702703495`*^9}, 
   3.947147903551467*^9},ExpressionUUID->"54169a90-c35c-7a4a-a37f-\
78c9753e8eeb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OrthogonalQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "Q1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"P2", ",", "Q2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "R1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q2", ",", "R2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"R1", ",", "S1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"R2", ",", "S2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"S1", ",", "P1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"S2", ",", "P2"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9455195703380117`*^9, 3.945519605171223*^9}, {
  3.9460039858449364`*^9, 3.946003994260566*^9}, {3.946004044908913*^9, 
  3.946004131276815*^9}, {3.946004174101141*^9, 3.946004205589377*^9}},
 CellLabel->
  "In[168]:=",ExpressionUUID->"c1bc4c8d-1ecd-654a-b9e2-f902b4037dfa"]
}, Closed]],

Cell[CellGroupData[{

Cell["Conconic quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.946188760871956*^9, 3.946188779525741*^9}, {
  3.9464378271237335`*^9, 
  3.946437830963283*^9}},ExpressionUUID->"e126572d-bdab-a047-b925-\
c2661290f09e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "returns", " ", "TRUE", " ", "if", " ", "ABCD", " ", "and", " ", "EFGH", 
    " ", "are", " ", "conconic"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"conconicQuadQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA_", ",", "ptB_", ",", "ptC_", ",", "ptD_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE_", ",", "ptF_", ",", "ptG_", ",", "ptH_"}], "}"}]}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "conic", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"conic", "=", 
        RowBox[{"ConicaCincoPuntos", "[", 
         RowBox[{"{", 
          RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD", ",", "ptE"}], 
          "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sustituirxyz", "[", 
            RowBox[{"conic", ",", "#"}], "]"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{"ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], "==", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.946440275192674*^9, 3.946440364775547*^9}, {
  3.946557553720074*^9, 3.94655756021654*^9}},
 CellLabel->
  "In[169]:=",ExpressionUUID->"3eac6f83-9820-5d4f-9acd-4f2df1b13510"]
}, Closed]],

Cell[CellGroupData[{

Cell["Find QA center", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 3.945509840152308*^9}, {
  3.945518917754542*^9, 3.945518929298341*^9}, {3.94551954978488*^9, 
  3.945519554745524*^9}, {3.946186993811855*^9, 
  3.946187000755444*^9}},ExpressionUUID->"1d12da59-37f1-9842-ad9c-\
eb916041816f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "findQACenter", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"findQACenter", "[", 
    RowBox[{"ptP_", ",", 
     RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"found", "=", "0"}], ",", "sustCS", ",", 
       RowBox[{"nc", "=", 
        RowBox[{"Length", "[", "QAP", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sustCS", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"sustS", ",", "sustC"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Monitor", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "<=", "nc"}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"Simplify", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Cross", "[", 
                   RowBox[{"ptP", ",", 
                    RowBox[{"QAP", "[", "i", "]"}]}], "]"}], "//.", 
                  "sustCS"}], ",", "cond"}], "]"}], ")"}], "==", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
             RowBox[{
              RowBox[{"found", "=", "i"}], ";", 
              RowBox[{"Break", "[", "]"}]}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<Identifying the center... \>\"", ",", 
           RowBox[{"ProgressIndicator", "[", 
            RowBox[{"i", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "nc"}], "}"}]}], "]"}], ",", "\"\< \>\"", ",",
            "i", ",", "\"\</\>\"", ",", "nc"}], "}"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"found", "==", "0"}], ",", "\"\<unknown\>\"", ",", 
        RowBox[{"\"\<QA-P\>\"", "<>", 
         RowBox[{"ToString", "[", "found", "]"}]}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.946187173054329*^9, 3.946187213931603*^9}, {
   3.946187246486248*^9, 3.9461872843092823`*^9}, 3.946187365054121*^9, {
   3.946187480278492*^9, 3.9461874874540024`*^9}, 3.9461880462086487`*^9, {
   3.9461881054797783`*^9, 3.9461881291423397`*^9}, {3.946188268454359*^9, 
   3.9461883008316956`*^9}, {3.94618835627853*^9, 3.946188455318756*^9}, 
   3.946257761266403*^9, {3.946258916015583*^9, 3.94625896478343*^9}, {
   3.946259615877109*^9, 3.946259655534961*^9}, {3.947132891348004*^9, 
   3.947132924188181*^9}, {3.9471329718839912`*^9, 3.9471329845888424`*^9}, {
   3.947133025988367*^9, 3.94713303106756*^9}, {3.9471334511324463`*^9, 
   3.94713348841169*^9}},
 CellLabel->
  "In[170]:=",ExpressionUUID->"806c98e7-c027-de46-8fc2-cc2eda959f64"]
}, Closed]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Properties ", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 
  3.946441726397751*^9}},ExpressionUUID->"2609bf4c-7f5c-314e-a744-\
f86d4be283dd"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvW9MG1f+/+t7f/fBfTAPLg95EClXyBIPIlURQvolilbmAVErJIgaIZQU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    "], {{0, 315.8490566037736}, {736.3018867924528, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{736.3018867924528, 315.8490566037736},
  PlotRange->{{0, 736.3018867924528}, {0, 315.8490566037736}}]], "Text",
 CellChangeTimes->{3.946440201275278*^9, 3.947481441080046*^9, 
  3.9474823186352863`*^9},ExpressionUUID->"20c7ab22-8503-fd4d-9d34-\
15585b88ac29"],

Cell[CellGroupData[{

Cell["X (23)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 
  3.947482389079651*^9}},ExpressionUUID->"10edca6a-71a7-f647-bea6-\
6609a23bef9a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "23", "]"}]}]], "Input",
 CellChangeTimes->{{3.947482791814049*^9, 3.9474827919895*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"608068da-e44e-e64e-86b4-717062a1c7a6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["a", "6"]}], "-", 
      SuperscriptBox["b", "6"], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"11", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "7"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"18", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"22", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"21", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "6"], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "6"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["a", "6"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "11"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"21", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"11", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9474827926584473`*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"3c46ebb9-daf6-474f-8d1e-c3e4880821f5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[EFGH] = 9[ABCD]", "Subsubsection",
 CellChangeTimes->{{3.946524882039469*^9, 
  3.946524911797131*^9}},ExpressionUUID->"0783a5c2-3bae-714e-a912-\
12a39b395ebb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    FractionBox[
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], 
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}]], 
    "]"}], ",", "rectangle"}], "]"}]], "Input",
 CellChangeTimes->{{3.9464063788878155`*^9, 3.946406402599588*^9}, {
  3.9464065127606697`*^9, 3.946406551870569*^9}, {3.946524914124859*^9, 
  3.9465249170207653`*^9}, {3.947482786871868*^9, 3.947482801630083*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"4b77511b-10fb-a448-b2b2-99f2ba87fb11"],

Cell[BoxData["9"], "Output",
 CellChangeTimes->{{3.946406385898546*^9, 3.9464064038679943`*^9}, 
   3.946406513551883*^9, 3.946406552621641*^9, 3.946524918187322*^9, 
   3.946544260037796*^9, 3.9474828027557487`*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"942511a8-882a-a04b-a5ce-36640f536303"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (46)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.9474824105425835`*^9}, {
   3.947560895329899*^9, 3.9475608959850025`*^9}, 
   3.9475613920791416`*^9},ExpressionUUID->"a5e5c071-1076-6a41-8df9-\
aafa3cef069e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"CentralQuadrilateral", "[", "46", "]"}], ",", "rectangle"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.947484260243071*^9, {3.947493538776322*^9, 3.947493538824068*^9}, {
   3.9475582468309765`*^9, 3.9475582539835014`*^9}, {3.947558372174795*^9, 
   3.947558398142996*^9}, {3.94756031675494*^9, 3.94756031681925*^9}, {
   3.9475603900108795`*^9, 3.9475604021060257`*^9}, {3.947560470379175*^9, 
   3.947560470491228*^9}, {3.9475605740187016`*^9, 3.9475605755302544`*^9}, {
   3.94756062665864*^9, 3.9475606588980103`*^9}, {3.9475607070819817`*^9, 
   3.9475607071463985`*^9}, {3.9475607468502045`*^9, 3.947560770690239*^9}, {
   3.947560817313364*^9, 3.9475608504013615`*^9}, {3.9475613368330994`*^9, 
   3.947561337128458*^9}},
 CellLabel->
  "In[431]:=",ExpressionUUID->"a38f9cae-8e08-a14a-bb71-02f7c22c36e1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "a", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"b", " ", "c"}], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", "b", " ", "c"}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "c"}], ")"}], " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"b", " ", "c"}], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", "b", " ", "c"}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "a", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"2", " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "c"}], ")"}], " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.947559326477148*^9, 3.9475603175811043`*^9, {3.947560390701107*^9, 
   3.947560403602785*^9}, 3.947560471375843*^9, 3.947560576254633*^9, {
   3.947560628809662*^9, 3.9475606597449703`*^9}, 3.947560707977207*^9, {
   3.9475607476735*^9, 3.9475607709284306`*^9}, {3.947560819585764*^9, 
   3.9475608506221657`*^9}, 3.947560899458584*^9, 3.9475613382422905`*^9, {
   3.9475613837193546`*^9, 3.947561396805687*^9}, 3.9475614326363525`*^9, 
   3.9475619860701656`*^9},
 CellLabel->
  "Out[431]=",ExpressionUUID->"330fb815-be1c-b14c-877b-f2099b7b8a63"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[PartialD][ABCD] = \[PartialD][EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9465254705348263`*^9, 
  3.946525501211181*^9}},ExpressionUUID->"5bc9917e-997c-f64b-9f34-\
0f29d7b72f43"],

Cell["\<\
\[PartialD][ABCD] = \[PartialD][EFGH] \[DoubleLeftRightArrow]
AB + BC = EF + FG \[DoubleLeftRightArrow]
c+a=EF + FG\
\>", "Text",
 CellChangeTimes->{{3.946538680851864*^9, 3.9465389176666584`*^9}, {
   3.9465396813205853`*^9, 3.9465397227444587`*^9}, {3.947560170370344*^9, 
   3.947560173107441*^9}, 3.947560547033951*^9},
 Background->RGBColor[
  1, 1, 0.85],ExpressionUUID->"b7c5fe34-4a10-9f49-a2f0-3ce403908d6a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"EF", "=", 
   SqrtBox[
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptE", ",", "ptF"}], "]"}], ",", "rectangle"}], "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FG", "=", 
   SqrtBox[
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptF", ",", "ptG"}], "]"}], ",", "rectangle"}], "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", "a"}], ")"}], "^", "2"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"EF", "+", "FG"}], ")"}], "^", "2"}]}], "]"}], ",", 
   "rectangle"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946407066112732*^9, 3.946407180038402*^9}, {
   3.9464072508311253`*^9, 3.946407252046749*^9}, {3.946525523428076*^9, 
   3.946525636931619*^9}, {3.946525709283523*^9, 3.946525724331518*^9}, {
   3.946525829939558*^9, 3.9465258504273815`*^9}, {3.946538543666399*^9, 
   3.9465386015784225`*^9}, 3.946538668035082*^9, {3.947484256940251*^9, 
   3.947484264354975*^9}, {3.947560151235359*^9, 3.9475601546920547`*^9}, {
   3.947560301618988*^9, 3.947560304611885*^9}, {3.9475603454264393`*^9, 
   3.9475603796357384`*^9}, {3.9475604159070034`*^9, 
   3.9475604220749893`*^9}, {3.9475609079698772`*^9, 
   3.9475609105297737`*^9}, {3.9475611797538166`*^9, 3.9475612131125755`*^9}, 
   3.9475613627209015`*^9},
 CellLabel->
  "In[432]:=",ExpressionUUID->"b996a175-ce2e-9a43-8e90-8ad98be6b7d9"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9475603054719353`*^9, 3.9475603212536583`*^9}, {
   3.9475603536084995`*^9, 3.9475604232826023`*^9}, 3.947560474663357*^9, 
   3.9475605785855007`*^9, {3.9475606328068104`*^9, 3.9475606634121666`*^9}, 
   3.947560710806631*^9, {3.947560750014347*^9, 3.9475607734719715`*^9}, {
   3.947560822673813*^9, 3.9475608528118515`*^9}, 3.947560914608612*^9, {
   3.947561186212696*^9, 3.947561214317852*^9}, {3.947561343558655*^9, 
   3.9475613995192986`*^9}, 3.947561435174528*^9, 3.947561990428999*^9},
 CellLabel->
  "Out[434]=",ExpressionUUID->"52bfd9ee-39b5-9140-b431-0c6327343a52"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (47)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 
  3.9474824105425835`*^9}},ExpressionUUID->"f51aa334-7c35-a546-b30b-\
d89ea1d89696"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"CentralQuadrilateral", "[", "47", "]"}], ",", "rectangle"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.947484260243071*^9, {3.947493538776322*^9, 3.947493538824068*^9}, {
   3.9475582468309765`*^9, 3.9475582539835014`*^9}, {3.947558372174795*^9, 
   3.947558398142996*^9}, {3.94756031675494*^9, 3.94756031681925*^9}, {
   3.9475603900108795`*^9, 3.9475604021060257`*^9}, {3.947560470379175*^9, 
   3.947560470491228*^9}, {3.9475605740187016`*^9, 3.9475605755302544`*^9}, {
   3.94756062665864*^9, 3.9475606588980103`*^9}, {3.9475607070819817`*^9, 
   3.9475607071463985`*^9}, {3.9475607468502045`*^9, 3.947560770690239*^9}, {
   3.947560817313364*^9, 3.9475608504013615`*^9}, {3.947561444128504*^9, 
   3.947561444576023*^9}, {3.947561842663908*^9, 3.9475618449441223`*^9}, {
   3.947562006103512*^9, 3.947562006575802*^9}},
 CellLabel->
  "In[435]:=",ExpressionUUID->"c0f1b7d4-631c-624d-964f-12f5efd1cbbb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "a", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"4", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "3"]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "3"]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "a", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "4"]}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947559326477148*^9, 3.9475603175811043`*^9, {3.947560390701107*^9, 
   3.947560403602785*^9}, 3.947560471375843*^9, 3.947560576254633*^9, {
   3.947560628809662*^9, 3.9475606597449703`*^9}, 3.947560707977207*^9, {
   3.9475607476735*^9, 3.9475607709284306`*^9}, {3.947560819585764*^9, 
   3.9475608506221657`*^9}, 3.9475614453966064`*^9, 3.9475616292922173`*^9, 
   3.9475618463276157`*^9, 3.9475620073866367`*^9},
 CellLabel->
  "Out[435]=",ExpressionUUID->"cac0bd99-ed26-f349-9cfe-eb18e06e56b0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[PartialD][ABCD] = \[PartialD][EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9465254705348263`*^9, 
  3.946525501211181*^9}},ExpressionUUID->"803d34fd-e52b-2e42-9889-\
b1a2a43db251"],

Cell["\<\
\[PartialD][ABCD] = \[PartialD][EFGH] \[DoubleLeftRightArrow]
AB + BC = EF + FG \[DoubleLeftRightArrow]
c+a=EF + FG\
\>", "Text",
 CellChangeTimes->{{3.946538680851864*^9, 3.9465389176666584`*^9}, {
   3.9465396813205853`*^9, 3.9465397227444587`*^9}, {3.947560170370344*^9, 
   3.947560173107441*^9}, 3.947560547033951*^9},
 Background->RGBColor[
  1, 1, 0.85],ExpressionUUID->"f34be930-e86a-1a4a-8b8a-da8f74c8cfd9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"EF", "=", 
   SqrtBox[
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptE", ",", "ptF"}], "]"}], ",", "rectangle"}], "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FG", "=", 
   SqrtBox[
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptF", ",", "ptG"}], "]"}], ",", "rectangle"}], "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PowerExpand", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", "a"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"EF", "+", "FG"}], ")"}], "^", "2"}]}], "]"}], "]"}], ",", 
   "rectangle"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946407066112732*^9, 3.946407180038402*^9}, {
   3.9464072508311253`*^9, 3.946407252046749*^9}, {3.946525523428076*^9, 
   3.946525636931619*^9}, {3.946525709283523*^9, 3.946525724331518*^9}, {
   3.946525829939558*^9, 3.9465258504273815`*^9}, {3.946538543666399*^9, 
   3.9465386015784225`*^9}, 3.946538668035082*^9, {3.947484256940251*^9, 
   3.947484264354975*^9}, {3.947560151235359*^9, 3.9475601546920547`*^9}, {
   3.947560301618988*^9, 3.947560304611885*^9}, {3.9475603454264393`*^9, 
   3.9475603796357384`*^9}, {3.9475604159070034`*^9, 3.9475604220749893`*^9}},
 CellLabel->
  "In[436]:=",ExpressionUUID->"83adc57e-85ae-1649-a0bc-39927c2710fa"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9475603054719353`*^9, 3.9475603212536583`*^9}, {
   3.9475603536084995`*^9, 3.9475604232826023`*^9}, 3.947560474663357*^9, 
   3.9475605785855007`*^9, {3.9475606328068104`*^9, 3.9475606634121666`*^9}, 
   3.947560710806631*^9, {3.947560750014347*^9, 3.9475607734719715`*^9}, {
   3.947560822673813*^9, 3.9475608528118515`*^9}, 3.947561448205076*^9, 
   3.9475616348221207`*^9, 3.9475618502860985`*^9, 3.9475620118900795`*^9},
 CellLabel->
  "Out[438]=",ExpressionUUID->"c72dc9bd-557f-504a-a114-ca1cfea20570"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (95)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.947482389079651*^9}, {
  3.947482420174528*^9, 
  3.947482420741987*^9}},ExpressionUUID->"cce76eb4-599e-1347-9d4c-\
fed4bfb4f3ee"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "95", "]"}]}]], "Input",
 CellChangeTimes->{3.947482683262121*^9},
 CellLabel->"In[40]:=",ExpressionUUID->"feabeb96-eb56-4a4a-9621-2b1e901ccd9d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"6", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "4"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"6", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "4"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "4"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"5", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"6", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "4"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ")"}]}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9474826839055233`*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"4ab49ab0-3443-ed4b-914f-c4f38ed2ca2c"],

Cell[CellGroupData[{

Cell["[ABCD] = 25[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946524758383976*^9, 
  3.946524760090557*^9}},ExpressionUUID->"72d62beb-c377-e14a-beac-\
311b374f4b84"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    FractionBox[
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], 
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]], 
    "]"}], ",", "rectangle"}], "]"}]], "Input",
 CellChangeTimes->{{3.946404183748872*^9, 3.9464044327380733`*^9}, {
   3.946404486826443*^9, 3.946404554738617*^9}, {3.94640460175342*^9, 
   3.9464047397539177`*^9}, {3.9464047757300878`*^9, 
   3.9464047905780525`*^9}, {3.94640483618565*^9, 3.946404847377804*^9}, {
   3.946405338474016*^9, 3.9464053461775513`*^9}, {3.946405564265072*^9, 
   3.946405572424937*^9}, {3.9464062522955456`*^9, 3.9464062538159084`*^9}, {
   3.946406288176468*^9, 3.946406321944195*^9}, 3.946406496895973*^9, {
   3.946524805509257*^9, 3.9465248084287834`*^9}, {3.947482680655676*^9, 
   3.947482696022192*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"4cc6b00a-a7d5-9d45-b581-02dcb33d1d3d"],

Cell[BoxData["25"], "Output",
 CellChangeTimes->{
  3.946404494053547*^9, 3.946404531126602*^9, {3.94640461943964*^9, 
   3.9464046760177784`*^9}, {3.946404726934759*^9, 3.946404740560858*^9}, {
   3.946404777408226*^9, 3.946404848276568*^9}, {3.946405339690002*^9, 
   3.946405346895933*^9}, 3.946405392446514*^9, 3.946405447838981*^9, 
   3.946405507479025*^9, {3.946405579254486*^9, 3.946405583367338*^9}, 
   3.946405702397927*^9, 3.9464062549703045`*^9, 3.9464062903211193`*^9, 
   3.946406322597061*^9, 3.946406498366089*^9, 3.946524811200499*^9, 
   3.946544198863571*^9, 3.946544236123455*^9, 3.9474826969737988`*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"95437533-9e98-f846-98f2-246a1de8da6f"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (117)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.9474824105425835`*^9}, {
  3.9475605036181755`*^9, 
  3.9475605039789867`*^9}},ExpressionUUID->"bb573515-b83d-6946-9083-\
d3fd7c59b610"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"CentralQuadrilateral", "[", "117", "]"}], ",", "rectangle"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.947484260243071*^9, {3.947493538776322*^9, 3.947493538824068*^9}, {
   3.9475582468309765`*^9, 3.9475582539835014`*^9}, {3.947558372174795*^9, 
   3.947558398142996*^9}, {3.94756031675494*^9, 3.94756031681925*^9}, {
   3.9475603900108795`*^9, 3.9475604021060257`*^9}, {3.947560470379175*^9, 
   3.9475604970982323`*^9}},
 CellLabel->
  "In[440]:=",ExpressionUUID->"982b71e3-0533-e148-93de-c546cc31c107"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"8", " ", 
      SuperscriptBox["c", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "-", 
        RowBox[{"2", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}], ",", 
     RowBox[{"8", " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], " ", 
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["b", "3"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"3", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"b", " ", "c"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"3", " ", "a", " ", "c"}], "-", 
        RowBox[{"3", " ", "b", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "3"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", "c"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "3"]}]}], ")"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "3"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", "c"}], "-", 
           RowBox[{"b", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "3"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["b", "3"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"3", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"b", " ", "c"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], " ", 
      SuperscriptBox["c", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"3", " ", "a", " ", "c"}], "-", 
        RowBox[{"3", " ", "b", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"8", " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "3"], "-", 
           RowBox[{"2", " ", "b", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "3"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "-", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "3"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", "c"}], "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "3"]}]}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "3"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", "c"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "3"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "-", "c"}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"b", "+", "c"}], ")"}], "2"]}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"b", " ", "c"}], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.947559326477148*^9, 3.9475603175811043`*^9, {3.947560390701107*^9, 
   3.947560403602785*^9}, {3.947560471375843*^9, 3.9475604979255123`*^9}, {
   3.947561458757374*^9, 3.9475614844384537`*^9}, 3.9475620897114697`*^9},
 CellLabel->
  "Out[440]=",ExpressionUUID->"f41aa1dc-9cd4-ed4d-87e7-d591317bed9d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[PartialD][ABCD] = \[PartialD][EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9465254705348263`*^9, 
  3.946525501211181*^9}},ExpressionUUID->"feca4cf1-559b-5540-833e-\
41e652fbf182"],

Cell["\<\
\[PartialD][ABCD] = \[PartialD][EFGH] \[DoubleLeftRightArrow]
AB + BC = EF + FG \[DoubleLeftRightArrow]
c+a=EF + FG \
\>", "Text",
 CellChangeTimes->{{3.946538680851864*^9, 3.9465389176666584`*^9}, {
  3.9465396813205853`*^9, 3.9465397227444587`*^9}, {3.947560170370344*^9, 
  3.947560173107441*^9}, {3.9475605176427097`*^9, 3.9475605203384056`*^9}},
 Background->RGBColor[
  1, 1, 0.85],ExpressionUUID->"beae711b-937c-e84f-912e-0588976025d5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"EF", "=", 
   SqrtBox[
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptE", ",", "ptF"}], "]"}], ",", "rectangle"}], "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FG", "=", 
   SqrtBox[
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptF", ",", "ptG"}], "]"}], ",", "rectangle"}], "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", "a"}], ")"}], "^", "2"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"EF", "+", "FG"}], ")"}], "^", "2"}]}], "]"}], ",", 
   "rectangle"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946407066112732*^9, 3.946407180038402*^9}, {
   3.9464072508311253`*^9, 3.946407252046749*^9}, {3.946525523428076*^9, 
   3.946525636931619*^9}, {3.946525709283523*^9, 3.946525724331518*^9}, {
   3.946525829939558*^9, 3.9465258504273815`*^9}, {3.946538543666399*^9, 
   3.9465386015784225`*^9}, 3.946538668035082*^9, {3.947484256940251*^9, 
   3.947484264354975*^9}, {3.947560151235359*^9, 3.9475601546920547`*^9}, {
   3.947560301618988*^9, 3.947560304611885*^9}, {3.9475603454264393`*^9, 
   3.9475603796357384`*^9}, {3.9475604159070034`*^9, 3.9475604220749893`*^9}, 
   3.947561497584837*^9},
 CellLabel->
  "In[441]:=",ExpressionUUID->"690e391c-6aae-1e48-a74e-92c914b7826d"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9475603054719353`*^9, 3.9475603212536583`*^9}, {
   3.9475603536084995`*^9, 3.9475604232826023`*^9}, {3.947560474663357*^9, 
   3.9475605292562885`*^9}, {3.947561460693716*^9, 3.9475614984190826`*^9}, 
   3.9475620927902927`*^9},
 CellLabel->
  "Out[443]=",ExpressionUUID->"c1953fc9-8d2e-814a-a4bb-6a0c3830ce5e"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (163)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.9474824105425835`*^9}, {
  3.94756059089752*^9, 
  3.947560593257656*^9}},ExpressionUUID->"45e15fb3-9637-0f45-b9f9-\
2e286b04e863"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"CentralQuadrilateral", "[", "163", "]"}], ",", "rectangle"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.947484260243071*^9, {3.947493538776322*^9, 3.947493538824068*^9}, {
   3.9475582468309765`*^9, 3.9475582539835014`*^9}, {3.947558372174795*^9, 
   3.947558398142996*^9}, {3.94756031675494*^9, 3.94756031681925*^9}, {
   3.9475603900108795`*^9, 3.9475604021060257`*^9}, {3.947560470379175*^9, 
   3.947560470491228*^9}, {3.9475605740187016`*^9, 3.9475605755302544`*^9}},
 CellLabel->
  "In[444]:=",ExpressionUUID->"d960c159-514d-514a-8877-faaab322bac0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "-", "c"}], ")"}], "2"]}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"4", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "3"]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "3"]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "3"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "5"]}], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "4"]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "3"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947559326477148*^9, 3.9475603175811043`*^9, {3.947560390701107*^9, 
   3.947560403602785*^9}, 3.947560471375843*^9, {3.947560576254633*^9, 
   3.9475605954697514`*^9}, 3.9475615183388042`*^9, 3.94756210978249*^9},
 CellLabel->
  "Out[444]=",ExpressionUUID->"835a17d0-cf4b-9b4e-84e7-89d9f5d4dc9b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[PartialD][ABCD] = \[PartialD][EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9465254705348263`*^9, 
  3.946525501211181*^9}},ExpressionUUID->"9c063ed8-5888-924b-9ae8-\
924770328d73"],

Cell["\<\
\[PartialD][ABCD] = \[PartialD][EFGH] \[DoubleLeftRightArrow]
AB + BC = EF + FG \[DoubleLeftRightArrow]
c+a=EF + FG\
\>", "Text",
 CellChangeTimes->{{3.946538680851864*^9, 3.9465389176666584`*^9}, {
   3.9465396813205853`*^9, 3.9465397227444587`*^9}, {3.947560170370344*^9, 
   3.947560173107441*^9}, 3.947560547033951*^9},
 Background->RGBColor[
  1, 1, 0.85],ExpressionUUID->"a04e03dd-8f89-1944-bc5a-713d4f4d9c5f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"EF", "=", 
   SqrtBox[
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptE", ",", "ptF"}], "]"}], ",", "rectangle"}], "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FG", "=", 
   SqrtBox[
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptF", ",", "ptG"}], "]"}], ",", "rectangle"}], "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PowerExpand", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", "a"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"EF", "+", "FG"}], ")"}], "^", "2"}]}], "]"}], "]"}], ",", 
   "rectangle"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946407066112732*^9, 3.946407180038402*^9}, {
   3.9464072508311253`*^9, 3.946407252046749*^9}, {3.946525523428076*^9, 
   3.946525636931619*^9}, {3.946525709283523*^9, 3.946525724331518*^9}, {
   3.946525829939558*^9, 3.9465258504273815`*^9}, {3.946538543666399*^9, 
   3.9465386015784225`*^9}, 3.946538668035082*^9, {3.947484256940251*^9, 
   3.947484264354975*^9}, {3.947560151235359*^9, 3.9475601546920547`*^9}, {
   3.947560301618988*^9, 3.947560304611885*^9}, {3.9475603454264393`*^9, 
   3.9475603796357384`*^9}, {3.9475604159070034`*^9, 3.9475604220749893`*^9}},
 CellLabel->
  "In[445]:=",ExpressionUUID->"20281e6f-f376-c440-b67d-ee97d642568b"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9475603054719353`*^9, 3.9475603212536583`*^9}, {
   3.9475603536084995`*^9, 3.9475604232826023`*^9}, 3.947560474663357*^9, {
   3.9475605785855007`*^9, 3.9475605977243576`*^9}, {3.9475615213359413`*^9, 
   3.9475615377004547`*^9}, 3.947562112156332*^9},
 CellLabel->
  "Out[447]=",ExpressionUUID->"d294ef6a-d0b9-6f4b-b92c-8f8f76d73600"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (233)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.947482389079651*^9}, 
   3.9474824548707485`*^9},ExpressionUUID->"715efd71-2e75-d943-8568-\
66b6eb6e502c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "233", "]"}]}]], "Input",
 CellChangeTimes->{3.947483145964533*^9},
 CellLabel->"In[48]:=",ExpressionUUID->"ec17c3ac-978a-e740-9535-a14c2c3a9219"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"6", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["a", "8"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"50", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"21", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"22", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"11", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"10", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "8"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"44", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"21", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"25", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "4"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"5", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["b", "4"]}], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "4"]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9474831464638233`*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"ac461e37-541e-d94e-824b-750b5d665d88"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[ABCD] = [EFGH] = 25/ 4", "Subsubsection",
 CellChangeTimes->{{3.9465445375174885`*^9, 
  3.9465445440896664`*^9}},ExpressionUUID->"f2f527bb-fe34-9648-8825-\
61f813504765"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    FractionBox[
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], 
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]], 
    "]"}], ",", "rectangle"}], "]"}]], "Input",
 CellChangeTimes->{{3.94640641179108*^9, 3.9464064551194487`*^9}, {
  3.9465249293408165`*^9, 3.946524932669447*^9}, {3.9474831437989597`*^9, 
  3.9474831554365597`*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"e2544b87-5d1f-8845-9579-7b6124cb0c5b"],

Cell[BoxData[
 FractionBox["25", "4"]], "Output",
 CellChangeTimes->{3.9465249505398617`*^9, 3.946544267863398*^9, 
  3.9474831567973976`*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"fe518494-7408-d049-8b9e-3e83b58084bc"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (251)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.947482389079651*^9}, {
  3.947482457678459*^9, 
  3.947482458966942*^9}},ExpressionUUID->"9702b9fc-09d6-6848-8faf-\
d4af7edb6c4f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "251", "]"}]}]], "Input",
 CellChangeTimes->{3.947483724372011*^9},
 CellLabel->"In[68]:=",ExpressionUUID->"8f09bc09-afca-1f4d-bc3a-d932efecf117"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["c", "2"]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"11", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"11", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947483724924324*^9, 3.94748389566094*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"0e7564ae-435d-444c-a25b-970c08ea8545"]
}, Open  ]],

Cell[CellGroupData[{

Cell["QA - P1 = hyperb (ABCD, EFGH) = QA - P1", "Subsubsection",
 CellChangeTimes->{{3.9465258767933865`*^9, 
  3.9465258848836727`*^9}},ExpressionUUID->"7fab42e8-bc10-d64f-b25b-\
ad2e23ec0e56"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"conconicQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "rectangle"}], "]"}]], "Input",
 CellChangeTimes->{{3.946525894595516*^9, 3.946525922651211*^9}, {
  3.946526000243641*^9, 3.946526046163637*^9}, {3.947483721854244*^9, 
  3.9474837267239513`*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"a6285f78-9d7e-fd48-9101-9feb9fc27c31"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.946526021268524*^9, 3.946526046951521*^9}, 
   3.946526692105444*^9, 3.9465442915057774`*^9, 3.9474837275889263`*^9, 
   3.947483909177473*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"36c8dcfc-bc8a-ee40-b28b-425a3288781c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"con", "=", 
    RowBox[{"Last", "[", 
     RowBox[{"ConicaCincoPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD", ",", "ptE"}], "}"}],
       "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "the", " ", "conic", " ", "is", " ", "an", " ", "hyperbola", " ", "by", 
    " ", "Poncelet", " ", "Theorem"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sustituirxyz", "[", 
    RowBox[{"con", ",", 
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}], "]"}]}], "]"}], ",", 
   "rectangle"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946526060469745*^9, 3.946526154123197*^9}, {
  3.9465261949225063`*^9, 3.9465261958350143`*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"3c92ef03-4c7f-4343-b2ac-f84546de8fae"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.946526075391356*^9, 3.9465260998825626`*^9}, {
   3.946526140656185*^9, 3.946526156430397*^9}, 3.946526188687067*^9, 
   3.946526648843258*^9, 3.946526693542494*^9, 3.946544294302807*^9, 
   3.947483732167448*^9, 3.947483909206402*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"be0828f1-bc22-5f44-bc03-1044c31c46e1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ptP", "=", 
   RowBox[{"CentroConica", "[", "con", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"findQACenter", "[", 
  RowBox[{"ptP", ",", "rectangle"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946526216413479*^9, 3.946526246075087*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"1467531f-8b46-df4f-b52a-1a3f46e08cc7"],

Cell[BoxData["\<\"QA-P1\"\>"], "Output",
 CellChangeTimes->{3.94652624704187*^9, 3.946526388591912*^9, 
  3.946526651521225*^9, 3.946526694990248*^9, 3.946544296114605*^9, 
  3.9474837385059795`*^9, 3.947483909240305*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"eb907235-9f50-2c45-b3af-c12526711c09"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{"ptP", ",", 
   RowBox[{"QAP1", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9465263938849583`*^9, 3.946526423345928*^9}, {
  3.947483900268175*^9, 3.947483902861326*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"843e8d0c-068e-a34a-895b-e287ee9ee692"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.946526427818035*^9, {3.946526668062388*^9, 3.9465266969218197`*^9}, 
   3.9465442978950043`*^9, 3.9474839094467545`*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"7d8905fc-4ee8-ce4e-aafb-cf8a6688eb5f"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (315)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.947482389079651*^9}, {
  3.9474824775580406`*^9, 
  3.9474824790617123`*^9}},ExpressionUUID->"0425f9f1-c859-0741-92d8-\
7caa0335972a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "315", "]"}]}]], "Input",
 CellChangeTimes->{3.947483798291731*^9},
 CellLabel->"In[75]:=",ExpressionUUID->"41fd1140-9786-b54f-b686-0217eeed3e72"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["c", "4"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "4"]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["c", "4"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "4"]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      SuperscriptBox["b", "4"], "-", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox["c", "4"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9474837988238583`*^9, 3.947483917964657*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"868a2a27-4edd-ea46-bbde-43ddabdda5ba"]
}, Open  ]],

Cell["QA - P1 = hyperb (ABCD, EFGH) = QA - P1", "Subsubsection",
 CellChangeTimes->{{3.9465258767933865`*^9, 
  3.9465258848836727`*^9}},ExpressionUUID->"3386577b-77e3-c240-b621-\
59a246d4a1b2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"conconicQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "rectangle"}], "]"}]], "Input",
 CellChangeTimes->{{3.946525894595516*^9, 3.946525922651211*^9}, {
  3.946526000243641*^9, 3.946526046163637*^9}, {3.9465264723230515`*^9, 
  3.946526474378029*^9}, {3.9474837960612087`*^9, 3.9474838004122715`*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"b013180d-99ba-774d-b11c-90c4bc1c7a99"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.946526021268524*^9, 3.946526046951521*^9}, 
   3.946526475888895*^9, 3.946544300422788*^9, 3.9474838010215473`*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"76d80fae-2d7a-0a47-9398-06e81281d50e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"con", "=", 
    RowBox[{"Last", "[", 
     RowBox[{"ConicaCincoPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD", ",", "ptE"}], "}"}],
       "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "the", " ", "conic", " ", "is", " ", "an", " ", "hyperbola", " ", "by", 
    " ", "Poncelet", " ", "Theorem"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sustituirxyz", "[", 
    RowBox[{"con", ",", 
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}], "]"}]}], "]"}], ",", 
   "rectangle"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946526060469745*^9, 3.946526154123197*^9}, {
  3.9465261949225063`*^9, 3.9465261958350143`*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"256d6574-4069-a648-b925-0905fe79c74d"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.946526075391356*^9, 3.9465260998825626`*^9}, {
   3.946526140656185*^9, 3.946526156430397*^9}, 3.946526188687067*^9, 
   3.946526481021187*^9, 3.9465443020378265`*^9, 3.9474838041587296`*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"1900d19f-9083-a94f-9f1c-e85fcf90d8ac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ptP", "=", 
   RowBox[{"CentroConica", "[", "con", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"findQACenter", "[", 
  RowBox[{"ptP", ",", "rectangle"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946526216413479*^9, 3.946526246075087*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"1966d6c8-670c-b240-a1af-11c59bd307b1"],

Cell[BoxData["\<\"QA-P1\"\>"], "Output",
 CellChangeTimes->{3.94652624704187*^9, 3.946526388591912*^9, 
  3.9465264854258747`*^9, 3.9474838054014225`*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"9222ad38-3189-8347-90a7-3503a00be8cc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{"ptP", ",", 
   RowBox[{"QAP1", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9465263938849583`*^9, 3.946526423345928*^9}, {
  3.947483923411497*^9, 3.9474839271233273`*^9}},
 CellLabel->"In[76]:=",ExpressionUUID->"1f60b127-c88c-0b40-8274-84607c565dea"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946526427818035*^9, 3.946526487578926*^9, 
  3.9474838065366726`*^9, 3.9474839293264103`*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"1cde81b9-1192-db4f-ac4b-7effb95e58e3"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (402)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.947482389079651*^9}, {
  3.9474824968945827`*^9, 
  3.9474824979108505`*^9}},ExpressionUUID->"0400839e-498c-ea48-8aea-\
71d4437355c5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "402", "]"}]}]], "Input",
 CellChangeTimes->{3.9474830992206135`*^9},
 CellLabel->"In[46]:=",ExpressionUUID->"a36aa6f2-af9e-9c49-b0c9-3e6af78916c2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"21", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"7", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"11", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"51", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"62", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"39", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"83", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"49", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"7", " ", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "19"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"35", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"18", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"65", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"60", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "7"}], " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"37", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"65", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"35", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"29", " ", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "77"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"133", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"11", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"70", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"231", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"184", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "25"}], " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"115", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"167", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"77", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"7", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["b", "4"]}], "+", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "8"], "+", 
          RowBox[{
           SuperscriptBox["a", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "4"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "4"], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "2"]}], "-", 
             SuperscriptBox["c", "4"]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "6"], "-", 
             RowBox[{"5", " ", 
              SuperscriptBox["b", "4"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "4"]}], "+", 
             SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "4"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"9", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"9", " ", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "29"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"77", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"19", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"29", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"34", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"167", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"184", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "17"}], " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"115", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"231", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"133", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"7", " ", 
           SuperscriptBox["a", "8"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "19"}], " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"35", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "4"], "-", 
             RowBox[{"5", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"7", " ", 
              SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"18", " ", 
              SuperscriptBox["b", "4"]}], "-", 
             RowBox[{"65", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"60", " ", 
              SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "7"}], " ", 
              SuperscriptBox["b", "6"]}], "+", 
             RowBox[{"37", " ", 
              SuperscriptBox["b", "4"], " ", 
              SuperscriptBox["c", "2"]}], "-", 
             RowBox[{"65", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "4"]}], "+", 
             RowBox[{"35", " ", 
              SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"11", " ", 
         SuperscriptBox["a", "8"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "29"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"49", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"26", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"83", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"62", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "4"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "4"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.947483099773409*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"e8cb7b56-151a-8c4f-9b3c-b3e33bec6bf8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[ABCD] = 4[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946524844351292*^9, 
  3.946524858117388*^9}},ExpressionUUID->"9b9f672e-c5dd-3d4c-98ee-\
70863f902b68"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    FractionBox[
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], 
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]], 
    "]"}], ",", "rectangle"}], "]"}]], "Input",
 CellChangeTimes->{{3.946406352215348*^9, 3.946406367448263*^9}, 
   3.946406509968422*^9, {3.946524861325182*^9, 3.9465248666207886`*^9}, {
   3.9474830967429276`*^9, 3.947483109620964*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"612bc564-a70c-dd49-ade4-5df5f12d3c9f"],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.946406367975569*^9, 3.946406510789118*^9, 
  3.9465248680512943`*^9, 3.946544251860434*^9, 3.9474831105688343`*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"d605dc95-bc42-3e4d-a48f-93b9cdaa51e2"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (481)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.947482389079651*^9}, {
  3.947482510646536*^9, 
  3.9474825114458313`*^9}},ExpressionUUID->"5c900a6b-bb26-7e47-97a8-\
db1ac4dc7b03"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "481", "]"}]}]], "Input",
 CellChangeTimes->{3.9474838641157665`*^9},
 CellLabel->"In[63]:=",ExpressionUUID->"dece4e25-315e-8a46-b7ef-3b089b81521b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", "c", "-", 
          SqrtBox[
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"]}], "-", 
            SuperscriptBox["b", "2"], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}]}]]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "-", "c", "+", 
          SqrtBox[
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"]}], "-", 
            SuperscriptBox["b", "2"], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}]}]]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], "+", 
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", 
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "-", 
          RowBox[{"2", " ", "S"}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "-", 
        SqrtBox[
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"]}]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"2", " ", "a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"4", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c", "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"]}]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", " ", 
            SqrtBox[
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["a", "2"]}], "-", 
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}]}]]}], "+", 
           RowBox[{"4", " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}], "-", 
        RowBox[{"4", " ", "a", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "b"}], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"b", " ", "c"}], "-", 
          RowBox[{"2", " ", "S"}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "+", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"4", " ", "c", " ", "S"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c", "-", 
        SqrtBox[
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"]}]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", "c"}], "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "c"}], "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "-", 
        RowBox[{"4", " ", "a", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "c", "-", 
          SqrtBox[
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"]}], "-", 
            SuperscriptBox["b", "2"], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}]}]]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"2", " ", "a", " ", "c"}], "+", 
          SuperscriptBox["c", "2"], "-", 
          RowBox[{"4", " ", "S"}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "-", "c", "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"]}]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "c", "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"]}]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "c"}], "-", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"c", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], "-", 
        RowBox[{"2", " ", "S"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "b"}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "-", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"b", " ", "c"}], "-", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"2", " ", "S"}]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947483864770666*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"7b2e50b3-6341-6345-9582-91a022e0703f"]
}, Open  ]],

Cell["QA - P1 = hyperb (ABCD, EFGH) = QA - P1", "Subsubsection",
 CellChangeTimes->{{3.9465258767933865`*^9, 
  3.9465258848836727`*^9}},ExpressionUUID->"d2ea3273-a245-524f-9541-\
bfa1c23c0b3e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"conconicQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "rectangle"}], "]"}]], "Input",
 CellChangeTimes->{{3.946525894595516*^9, 3.946525922651211*^9}, {
  3.946526000243641*^9, 3.946526046163637*^9}, {3.9465264723230515`*^9, 
  3.946526474378029*^9}, {3.946526516362326*^9, 3.946526518562634*^9}, {
  3.947483862213251*^9, 3.9474838668275127`*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"e0411395-352d-b74e-bdf5-e38a28d6dbf6"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.946526021268524*^9, 3.946526046951521*^9}, 
   3.946526475888895*^9, 3.946526520257557*^9, 3.9474838685721283`*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"aeb6eac7-5ef2-5e41-bbd0-e735bcfd7b25"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"con", "=", 
    RowBox[{"Last", "[", 
     RowBox[{"ConicaCincoPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD", ",", "ptE"}], "}"}],
       "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "the", " ", "conic", " ", "is", " ", "an", " ", "hyperbola", " ", "by", 
    " ", "Poncelet", " ", "Theorem"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sustituirxyz", "[", 
    RowBox[{"con", ",", 
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}], "]"}]}], "]"}], ",", 
   "rectangle"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946526060469745*^9, 3.946526154123197*^9}, {
  3.9465261949225063`*^9, 3.9465261958350143`*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"f4000789-c233-f448-ade0-474ce135554b"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.946526075391356*^9, 3.9465260998825626`*^9}, {
   3.946526140656185*^9, 3.946526156430397*^9}, 3.946526188687067*^9, 
   3.946526481021187*^9, 3.946526521813209*^9, 3.947483868878561*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"6fe8b983-132b-564e-b2f9-02225aa172c7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ptP", "=", 
   RowBox[{"CentroConica", "[", "con", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"findQACenter", "[", 
  RowBox[{"ptP", ",", "rectangle"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946526216413479*^9, 3.946526246075087*^9}},
 CellLabel->
  "In[159]:=",ExpressionUUID->"e57855fb-23d7-c742-b6be-66a1fd717c7d"],

Cell[BoxData["\<\"QA-P1\"\>"], "Output",
 CellChangeTimes->{3.94652624704187*^9, 3.946526388591912*^9, 
  3.9465264854258747`*^9, 3.9465265236601925`*^9},
 CellLabel->
  "Out[160]=",ExpressionUUID->"84e6bbed-53db-d04c-8b23-95246739cfdb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{"ptP", ",", 
   RowBox[{"QAP1", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9465263938849583`*^9, 3.946526423345928*^9}, {
  3.947483876700264*^9, 3.9474838796694717`*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"d586a522-cc79-544a-892a-7e8bd6b503a2"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946526427818035*^9, 3.946526487578926*^9, 
  3.946526531544691*^9, 3.947483887108721*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"a17765dd-efb9-e44f-a4fb-497606b96814"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (579)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.947482389079651*^9}, {
  3.947482433789985*^9, 3.947482434214666*^9}, {3.947493681942986*^9, 
  3.9474936822316937`*^9}, {3.947493724894987*^9, 
  3.9474937262148476`*^9}},ExpressionUUID->"27d3565e-81d7-2a4b-bd05-\
e2e88a793766"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"CentralQuadrilateral", "[", "579", "]"}], "/.", 
    RowBox[{"b", "->", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "+", 
       RowBox[{"c", "^", "2"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.947562826677761*^9, 3.947562827430094*^9}},
 CellLabel->
  "In[492]:=",ExpressionUUID->"cd352085-8be8-d94b-8023-067c216a8c07"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "-", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}], ",", 
     RowBox[{"a", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "a"}], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}], ",", 
     RowBox[{"a", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["a", "2"], "+", 
            SuperscriptBox["c", "2"]}]]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "c", "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["a", "2"], "+", 
            SuperscriptBox["c", "2"]}]]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["a", "2"], "+", 
            SuperscriptBox["c", "2"]}]]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "a"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}], ",", 
     RowBox[{"a", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "a"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9475628283745823`*^9, 3.947562844448223*^9}, 
   3.947562881949707*^9},
 CellLabel->
  "Out[492]=",ExpressionUUID->"3e55df53-3e8f-1448-8c95-4cad47087f11"]
}, Open  ]],

Cell["\[PartialD][ABCD] = \[PartialD][EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9465254705348263`*^9, 
  3.946525501211181*^9}},ExpressionUUID->"fadc6656-4520-af40-b473-\
576d0efeb75c"],

Cell["\<\
\[PartialD][ABCD] = \[PartialD][EFGH] \[DoubleLeftRightArrow]
AB + BC = EF + FG \[DoubleLeftRightArrow]
c+a=EF + FG\
\>", "Text",
 CellChangeTimes->{{3.946538680851864*^9, 3.9465389176666584`*^9}, {
  3.9465396813205853`*^9, 3.9465397227444587`*^9}, {3.9475628508373127`*^9, 
  3.947562854518299*^9}},
 Background->RGBColor[
  1, 1, 0.85],ExpressionUUID->"b1af2457-7cac-a743-902f-bdde1294cb77"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"EF", "=", 
   SqrtBox[
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptE", ",", "ptF"}], "]"}], ",", "rectangle"}], "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FG", "=", 
   SqrtBox[
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptF", ",", "ptG"}], "]"}], ",", "rectangle"}], "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"Factor", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "+", "a"}], ")"}], "^", "2"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"EF", "+", "FG"}], ")"}], "^", "2"}]}], "]"}], ",", 
      "rectangle"}], "]"}], "/.", 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}]], "->", "a"}]}], ",", "rectangle"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.946407066112732*^9, 3.946407180038402*^9}, {
   3.9464072508311253`*^9, 3.946407252046749*^9}, {3.946525523428076*^9, 
   3.946525636931619*^9}, {3.946525709283523*^9, 3.946525724331518*^9}, {
   3.946525829939558*^9, 3.9465258504273815`*^9}, {3.946538543666399*^9, 
   3.9465386015784225`*^9}, 3.946538668035082*^9, {3.947484256940251*^9, 
   3.947484264354975*^9}, {3.9475616748089848`*^9, 3.9475617002887287`*^9}, 
   3.947561771536318*^9, {3.947562368822859*^9, 3.947562371886177*^9}, 
   3.9475625364636497`*^9, 3.9475631263744965`*^9, {3.9475632144452477`*^9, 
   3.947563219308176*^9}},
 CellLabel->
  "In[519]:=",ExpressionUUID->"1732af5e-d9c4-aa4a-a8e7-ca54125f2700"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.946407196639036*^9, 3.9464072703071556`*^9, {3.9465255451395206`*^9, 
   3.946525573941233*^9}, {3.9465256214057713`*^9, 3.946525640307389*^9}, 
   3.9465258521459656`*^9, 3.946534738690588*^9, 3.946537571498244*^9, 
   3.946538603357843*^9, 3.946538661573969*^9, 3.9465389231094933`*^9, 
   3.946544323708246*^9, 3.947484267278601*^9, 3.9474935894484825`*^9, 
   3.947493696740328*^9, 3.947493754828724*^9, 3.9475615961579876`*^9, {
   3.9475616758885784`*^9, 3.9475617122021866`*^9}, 3.9475617725582047`*^9, 
   3.947562191558424*^9, 3.947562373168707*^9, 3.947562537524622*^9, {
   3.9475628332672215`*^9, 3.947562884055332*^9}, {3.9475631285503044`*^9, 
   3.947563151254303*^9}, 3.947563220302849*^9, 3.947563335093981*^9},
 CellLabel->
  "Out[521]=",ExpressionUUID->"38547fc8-8f66-bc4d-980d-2fa5628fa6c4"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (580)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.9474824063665905`*^9}, {
  3.947556309602747*^9, 
  3.9475563393630753`*^9}},ExpressionUUID->"64c45fba-f67c-494f-81c4-\
2074ccc32fdf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"CentralQuadrilateral", "[", "580", "]"}], "/.", 
    RowBox[{"b", "->", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "+", 
       RowBox[{"c", "^", "2"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.947556162237044*^9, 3.947556219371363*^9}, {
  3.947556254484295*^9, 3.947556318387467*^9}},
 CellLabel->
  "In[480]:=",ExpressionUUID->"ce59fb54-7d16-5348-8076-4dbd0b487a16"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947555756253805*^9, 3.9475560927367*^9, {3.9475561630961304`*^9, 
   3.947556220146906*^9}, {3.9475562573450003`*^9, 3.947556319382393*^9}, {
   3.947562688669628*^9, 3.9475627110228767`*^9}, 3.9475627449583645`*^9},
 CellLabel->
  "Out[480]=",ExpressionUUID->"80175a37-5130-6043-80d9-6e3b7b83b0c0"]
}, Open  ]],

Cell["\[PartialD][ABCD] = \[PartialD][EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9465254705348263`*^9, 
  3.946525501211181*^9}},ExpressionUUID->"08837014-187d-5644-8ae0-\
d6cfc3eb0d81"],

Cell["\<\
\[PartialD][ABCD] = \[PartialD][EFGH] \[DoubleLeftRightArrow]
AB + BC = EF + FG \[DoubleLeftRightArrow]
c+a=EF + FG \
\>", "Text",
 CellChangeTimes->{{3.946538680851864*^9, 3.9465389176666584`*^9}, {
  3.9465396813205853`*^9, 3.9465397227444587`*^9}, {3.947560170370344*^9, 
  3.947560173107441*^9}, {3.9475605176427097`*^9, 3.9475605203384056`*^9}},
 Background->RGBColor[
  1, 1, 0.85],ExpressionUUID->"1966cb3e-6486-c04a-8f7f-3d64be2858cf"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"EF", "=", 
   SqrtBox[
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptE", ",", "ptF"}], "]"}], ",", "rectangle"}], "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FG", "=", 
   SqrtBox[
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptF", ",", "ptG"}], "]"}], ",", "rectangle"}], "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", "a"}], ")"}], "^", "2"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"EF", "+", "FG"}], ")"}], "^", "2"}]}], "]"}], ",", 
   "rectangle"}], "]"}]}], "Input",
 CellLabel->
  "In[481]:=",ExpressionUUID->"5ef205ec-6986-be44-94e1-4ad1c0980b66"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.947562714803911*^9, 3.947562748365116*^9},
 CellLabel->
  "Out[483]=",ExpressionUUID->"1a417ee7-a446-ba4e-b532-6ecdc2ed6a63"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (850)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.947482389079651*^9}, {
  3.947482645845553*^9, 
  3.947482646765738*^9}},ExpressionUUID->"225c47ff-0b56-c24b-973f-\
16cfde3e2c92"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "850", "]"}]}]], "Input",
 CellChangeTimes->{3.94748398119466*^9},
 CellLabel->"In[77]:=",ExpressionUUID->"958a0d09-307f-1e41-977f-eeefcb6781fd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "b"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}], " ", 
        SuperscriptBox["c", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}], "2"]}], ")"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "4"]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9474839817991657`*^9},
 CellLabel->"Out[77]=",ExpressionUUID->"45d4fef6-c42e-7f47-bbc5-d90887ea464a"]
}, Open  ]],

Cell["QA - P1 = hyperb (ABCD, EFGH) = QA - P1", "Subsubsection",
 CellChangeTimes->{{3.9465258767933865`*^9, 
  3.9465258848836727`*^9}},ExpressionUUID->"8fae9f90-2f29-8440-9110-\
1e7a924cfccd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"conconicQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "rectangle"}], "]"}]], "Input",
 CellChangeTimes->{{3.946525894595516*^9, 3.946525922651211*^9}, {
  3.946526000243641*^9, 3.946526046163637*^9}, {3.9465264723230515`*^9, 
  3.946526474378029*^9}, {3.9465265315706215`*^9, 3.9465265345865993`*^9}, {
  3.947483979412586*^9, 3.947483983379179*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"b48021b9-6413-c345-a334-ffb6bee2d206"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.946526021268524*^9, 3.946526046951521*^9}, 
   3.946526475888895*^9, 3.946526535800808*^9, 3.947483983942751*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"09e2010a-875b-c54e-b1cd-a97ff1ee76aa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"con", "=", 
    RowBox[{"Last", "[", 
     RowBox[{"ConicaCincoPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD", ",", "ptE"}], "}"}],
       "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "the", " ", "conic", " ", "is", " ", "an", " ", "hyperbola", " ", "by", 
    " ", "Poncelet", " ", "Theorem"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sustituirxyz", "[", 
    RowBox[{"con", ",", 
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}], "]"}]}], "]"}], ",", 
   "rectangle"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946526060469745*^9, 3.946526154123197*^9}, {
  3.9465261949225063`*^9, 3.9465261958350143`*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"ee0887f2-f1cf-514d-bfd2-067a90b2c7ec"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.946526075391356*^9, 3.9465260998825626`*^9}, {
   3.946526140656185*^9, 3.946526156430397*^9}, 3.946526188687067*^9, 
   3.946526481021187*^9, 3.946526537742434*^9, 3.9474839849416294`*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"f6b68083-5889-2f4d-aa29-573613f4bbb9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ptP", "=", 
   RowBox[{"CentroConica", "[", "con", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"findQACenter", "[", 
  RowBox[{"ptP", ",", "rectangle"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946526216413479*^9, 3.946526246075087*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"c56001b8-7fda-1e4e-9ad4-105bf522e3c0"],

Cell[BoxData["\<\"QA-P1\"\>"], "Output",
 CellChangeTimes->{3.94652624704187*^9, 3.946526388591912*^9, 
  3.9465264854258747`*^9, 3.9465265396118984`*^9, 3.947483987811825*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"d8110769-cd21-964d-b67f-dc46c0efc2e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{"ptP", ",", 
   RowBox[{"QAP1", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9465263938849583`*^9, 3.946526423345928*^9}, {
  3.9474839908350105`*^9, 3.9474839935491657`*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"5fd291f7-807a-5649-8155-05e4dcdecff3"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946526427818035*^9, 3.946526487578926*^9, 
  3.946526541156275*^9, 3.9474839942843113`*^9},
 CellLabel->"Out[83]=",ExpressionUUID->"ae2fbbce-3837-c64b-bb56-6a7ec21c5f38"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (920)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.9474824105425835`*^9}, {
  3.947560675809471*^9, 
  3.947560678769884*^9}},ExpressionUUID->"d7317eec-da23-5745-b10e-\
5dac9a7890d2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"CentralQuadrilateral", "[", "920", "]"}], ",", "rectangle"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.947484260243071*^9, {3.947493538776322*^9, 3.947493538824068*^9}, {
   3.9475582468309765`*^9, 3.9475582539835014`*^9}, {3.947558372174795*^9, 
   3.947558398142996*^9}, {3.94756031675494*^9, 3.94756031681925*^9}, {
   3.9475603900108795`*^9, 3.9475604021060257`*^9}, {3.947560470379175*^9, 
   3.947560470491228*^9}, {3.9475605740187016`*^9, 3.9475605755302544`*^9}, {
   3.94756062665864*^9, 3.9475606588980103`*^9}},
 CellLabel->
  "In[449]:=",ExpressionUUID->"ef596d7f-351a-7c4f-9390-d6295dd444cf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", "a", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"4", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "3"]}]}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "3"]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", "a", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "4"]}]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947559326477148*^9, 3.9475603175811043`*^9, {3.947560390701107*^9, 
   3.947560403602785*^9}, 3.947560471375843*^9, 3.947560576254633*^9, {
   3.947560628809662*^9, 3.9475606597449703`*^9}, 3.947562153176626*^9},
 CellLabel->
  "Out[449]=",ExpressionUUID->"26672b81-96e2-454d-b8ad-8c050d3b6042"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[PartialD][ABCD] = \[PartialD][EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9465254705348263`*^9, 
  3.946525501211181*^9}},ExpressionUUID->"d9135fca-efb2-7c49-9db3-\
2e124a920236"],

Cell["\<\
\[PartialD][ABCD] = \[PartialD][EFGH] \[DoubleLeftRightArrow]
AB + BC = EF + FG \[DoubleLeftRightArrow]
c+a=EF + FG\
\>", "Text",
 CellChangeTimes->{{3.946538680851864*^9, 3.9465389176666584`*^9}, {
   3.9465396813205853`*^9, 3.9465397227444587`*^9}, {3.947560170370344*^9, 
   3.947560173107441*^9}, 3.947560547033951*^9},
 Background->RGBColor[
  1, 1, 0.85],ExpressionUUID->"610437cd-e84f-2549-94d7-b97b95cd9166"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"EF", "=", 
   SqrtBox[
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptE", ",", "ptF"}], "]"}], ",", "rectangle"}], "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FG", "=", 
   SqrtBox[
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptF", ",", "ptG"}], "]"}], ",", "rectangle"}], "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PowerExpand", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", "a"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"EF", "+", "FG"}], ")"}], "^", "2"}]}], "]"}], "]"}], ",", 
   "rectangle"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946407066112732*^9, 3.946407180038402*^9}, {
   3.9464072508311253`*^9, 3.946407252046749*^9}, {3.946525523428076*^9, 
   3.946525636931619*^9}, {3.946525709283523*^9, 3.946525724331518*^9}, {
   3.946525829939558*^9, 3.9465258504273815`*^9}, {3.946538543666399*^9, 
   3.9465386015784225`*^9}, 3.946538668035082*^9, {3.947484256940251*^9, 
   3.947484264354975*^9}, {3.947560151235359*^9, 3.9475601546920547`*^9}, {
   3.947560301618988*^9, 3.947560304611885*^9}, {3.9475603454264393`*^9, 
   3.9475603796357384`*^9}, {3.9475604159070034`*^9, 3.9475604220749893`*^9}},
 CellLabel->
  "In[450]:=",ExpressionUUID->"5fb6cdf8-8ba5-e94b-b691-f1af9b9abafe"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9475603054719353`*^9, 3.9475603212536583`*^9}, {
   3.9475603536084995`*^9, 3.9475604232826023`*^9}, 3.947560474663357*^9, 
   3.9475605785855007`*^9, {3.9475606328068104`*^9, 3.9475606634121666`*^9}, 
   3.9475621558395176`*^9},
 CellLabel->
  "Out[452]=",ExpressionUUID->"79f39378-167a-7848-af3e-18aa2bc5d5f3"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (946)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.947482389079651*^9}, {
  3.947482569798256*^9, 
  3.9474825708937073`*^9}},ExpressionUUID->"0c229d01-69b6-824b-b235-\
6ccaca18fcdb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "946", "]"}]}]], "Input",
 CellChangeTimes->{3.9474830562537613`*^9},
 CellLabel->"In[44]:=",ExpressionUUID->"24c6cd40-a272-a745-9f1e-bfbf24b334cf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", "c"}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "c"}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"c", " ", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "c"}], "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"c", " ", 
            RowBox[{"(", 
             RowBox[{"c", "-", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{
                 RowBox[{"2", " ", 
                  SuperscriptBox["a", "2"]}], "-", 
                 SuperscriptBox["b", "2"], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "c"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"c", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"]}], "-", 
            SuperscriptBox["b", "2"], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"c", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "c"}], "+", 
            SqrtBox[
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["a", "2"]}], "-", 
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}]}]]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"a", " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"c", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", "c"}], "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}]}], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", "b", " ", "c"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "b"}], "-", 
      RowBox[{"a", " ", "b", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "-", "c"}], ")"}], "2"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], " ", "c", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "+", "c"}], ")"}], "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"b", " ", "c"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "c"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "-", "c"}], ")"}], "2"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"3", " ", "b", " ", "c"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"b", " ", "c"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", "c"}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "-", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "c"}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"c", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "c"}], "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "3"], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "c"}], "+", 
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", 
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "-", 
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"c", " ", 
              RowBox[{"(", 
               RowBox[{"c", "-", 
                RowBox[{"2", " ", 
                 SqrtBox[
                  RowBox[{
                   RowBox[{"2", " ", 
                    SuperscriptBox["a", "2"]}], "-", 
                   SuperscriptBox["b", "2"], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"c", " ", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            SqrtBox[
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["a", "2"]}], "-", 
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}]}]]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"c", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "c"}], "+", 
            SqrtBox[
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["a", "2"]}], "-", 
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}]}]]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"a", " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"c", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", "c"}], "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "-", "c"}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}]}], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "b"}], "+", 
      RowBox[{"a", " ", "b", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "-", "c"}], ")"}], "2"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], " ", "c", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "+", "c"}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"b", " ", "c"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "c"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "-", "c"}], ")"}], "2"], " ", "c"}], "-", 
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "+", "c"}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"b", " ", "c"}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9474830573176136`*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"3a3d94b2-0d45-d149-9e28-52689254a8ce"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[ABCD] = 2[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946524783328291*^9, 
  3.946524794829315*^9}},ExpressionUUID->"21f19122-0f6c-9847-a0d2-\
3130cea6f671"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    FractionBox[
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], 
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]], 
    "]"}], ",", "rectangle"}], "]"}]], "Input",
 CellChangeTimes->{{3.946406337736004*^9, 3.9464063446791573`*^9}, 
   3.94640650524839*^9, {3.9465248293492737`*^9, 3.9465248332933865`*^9}, {
   3.9474830528785973`*^9, 3.9474830702370586`*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"42df4626-f315-f042-80e4-71765e9fd275"],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{3.946406346255917*^9, 3.946406506003332*^9, 
  3.9465248352160625`*^9, 3.946544245445519*^9, 3.947483071148699*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"7793cf4c-79d3-e047-a621-e8919ce807e6"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (961)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.947482389079651*^9}, {
  3.947482573798126*^9, 
  3.9474825748306904`*^9}},ExpressionUUID->"ec386b63-1f6b-fc4f-aa73-\
b1f67d54692d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "961", "]"}]}]], "Input",
 CellChangeTimes->{{3.9474840412197*^9, 3.9474840422190704`*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"0ed87c6f-b31f-8a4c-9d59-08e6195215ad"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "-", 
        SqrtBox[
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"]}]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c", "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"]}]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"a", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "c"}], "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "c", "-", 
          SqrtBox[
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"]}], "-", 
            SuperscriptBox["b", "2"], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}]}]]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          RowBox[{"a", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], "+", 
          RowBox[{"c", " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", 
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}]]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["a", "3"]}], "-", 
          RowBox[{"a", " ", 
           SuperscriptBox["b", "2"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", 
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"3", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", 
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "+", 
          RowBox[{"a", " ", "c", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", "c"}], "+", 
             RowBox[{"4", " ", 
              SqrtBox[
               RowBox[{
                RowBox[{"2", " ", 
                 SuperscriptBox["a", "2"]}], "-", 
                SuperscriptBox["b", "2"], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c", "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"]}]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "c"}], "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "3"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "3"]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"c", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "c"}], "+", 
              SqrtBox[
               RowBox[{
                RowBox[{"2", " ", 
                 SuperscriptBox["a", "2"]}], "-", 
                SuperscriptBox["b", "2"], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["c", "2"]}]}]]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"c", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"7", " ", "c"}], "+", 
              RowBox[{"3", " ", 
               SqrtBox[
                RowBox[{
                 RowBox[{"2", " ", 
                  SuperscriptBox["a", "2"]}], "-", 
                 SuperscriptBox["b", "2"], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "3"], " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "3"], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "c"}], "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "3"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "b"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", "c"}], "+", 
        RowBox[{"a", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "3"], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "c"}], "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "3"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c", "-", 
          SqrtBox[
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"]}], "-", 
            SuperscriptBox["b", "2"], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}]}]]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", 
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}]]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", 
           SuperscriptBox["a", "4"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "5"}], " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"7", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "3"], " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", 
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "-", 
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"3", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", 
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}]]}], ")"}]}]}], ")"}]}], ")"}]}], 
     ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "-", 
        SqrtBox[
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"]}]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"a", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "3"]}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "+", 
        RowBox[{"a", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "c"}], "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["a", "2"]}], "-", 
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "-", 
        SqrtBox[
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"]}]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "c", "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"]}]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"a", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], ")"}]}]}], ")"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"a", " ", "b"}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"a", " ", "b"}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9474840430886574`*^9},
 CellLabel->"Out[84]=",ExpressionUUID->"e6f7219d-4c8d-784d-96f2-15514487a26e"]
}, Open  ]],

Cell["QA - P1 = hyperb (ABCD, EFGH) = QA - P1", "Subsubsection",
 CellChangeTimes->{{3.9465258767933865`*^9, 
  3.9465258848836727`*^9}},ExpressionUUID->"8253f0b2-495c-dc4e-a57c-\
4abf7c058827"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"conconicQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "rectangle"}], "]"}]], "Input",
 CellChangeTimes->{{3.946525894595516*^9, 3.946525922651211*^9}, {
   3.946526000243641*^9, 3.946526046163637*^9}, {3.9465264723230515`*^9, 
   3.946526474378029*^9}, {3.946526554235041*^9, 3.9465265564424896`*^9}, 
   3.9474840377483864`*^9},
 CellLabel->"In[85]:=",ExpressionUUID->"c43eef23-d739-2a41-bbec-5938d40651ac"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.946526021268524*^9, 3.946526046951521*^9}, 
   3.946526475888895*^9, 3.9465265582349815`*^9, 3.946526594000028*^9, 
   3.9474840532866974`*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"7ed44d4b-9f1a-8f49-ac0c-ff79e9c2e0ad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"con", "=", 
    RowBox[{"Last", "[", 
     RowBox[{"ConicaCincoPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD", ",", "ptE"}], "}"}],
       "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "the", " ", "conic", " ", "is", " ", "an", " ", "hyperbola", " ", "by", 
    " ", "Poncelet", " ", "Theorem"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sustituirxyz", "[", 
    RowBox[{"con", ",", 
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}], "]"}]}], "]"}], ",", 
   "rectangle"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946526060469745*^9, 3.946526154123197*^9}, {
  3.9465261949225063`*^9, 3.9465261958350143`*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"f4ff317d-c7ec-194b-bbd2-c450293c5efa"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.946526075391356*^9, 3.9465260998825626`*^9}, {
   3.946526140656185*^9, 3.946526156430397*^9}, 3.946526188687067*^9, 
   3.946526481021187*^9, 3.9465265593411083`*^9, 3.946526595391487*^9, 
   3.9474840538606167`*^9},
 CellLabel->"Out[87]=",ExpressionUUID->"7c3d9dff-5253-7f4e-93a0-6df423eb471e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ptP", "=", 
   RowBox[{"CentroConica", "[", "con", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"findQACenter", "[", 
  RowBox[{"ptP", ",", "rectangle"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946526216413479*^9, 3.946526246075087*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"f2ad35e3-d2da-b74a-aade-10a021a40c8c"],

Cell[BoxData["\<\"QA-P1\"\>"], "Output",
 CellChangeTimes->{3.94652624704187*^9, 3.946526388591912*^9, 
  3.9465264854258747`*^9, 3.946526562916716*^9, 3.946526597092503*^9, 
  3.947484055237261*^9},
 CellLabel->"Out[89]=",ExpressionUUID->"cf572f97-3f4a-a949-a3dc-fad8a97ec772"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{"ptP", ",", 
   RowBox[{"QAP1", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9465263938849583`*^9, 3.946526423345928*^9}, {
  3.947484058563671*^9, 3.947484061101204*^9}},
 CellLabel->"In[90]:=",ExpressionUUID->"e69edb9c-e31b-8d42-8ddc-a6bf9b298d2e"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.946526427818035*^9, 3.946526487578926*^9, {3.946526588172117*^9, 
   3.946526610776953*^9}, 3.947484083114771*^9},
 CellLabel->"Out[90]=",ExpressionUUID->"15b20867-c4bf-f646-8049-dd716c50e654"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (998)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.947482389079651*^9}, {
  3.9474825829340134`*^9, 
  3.9474825838384953`*^9}},ExpressionUUID->"7f7586c2-b1d4-2844-a923-\
7669adb84c99"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "998", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.947484134026991*^9, 3.9474841401789436`*^9}},
 CellLabel->"In[92]:=",ExpressionUUID->"f330c6e3-0dc6-8e40-8310-475183f90f3f"],

Cell["QA - P1 = hyperb (ABCD, EFGH) = QA - P1", "Subsubsection",
 CellChangeTimes->{{3.9465258767933865`*^9, 
  3.9465258848836727`*^9}},ExpressionUUID->"9c24fbcf-78a6-7543-90c8-\
b15d3f6c02e2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"conconicQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "rectangle"}], "]"}]], "Input",
 CellChangeTimes->{{3.946525894595516*^9, 3.946525922651211*^9}, {
  3.946526000243641*^9, 3.946526046163637*^9}, {3.9465264723230515`*^9, 
  3.946526474378029*^9}, {3.9465267376906796`*^9, 3.946526737994684*^9}, {
  3.947484132140356*^9, 3.947484145099127*^9}},
 CellLabel->"In[93]:=",ExpressionUUID->"5b88f579-2f53-c647-9bbe-6d883dc9443b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.946526021268524*^9, 3.946526046951521*^9}, 
   3.946526475888895*^9, 3.946526740927227*^9, 3.947484147800543*^9},
 CellLabel->"Out[93]=",ExpressionUUID->"c3d908f8-d1b5-ae45-b497-347b65c17ad2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"con", "=", 
    RowBox[{"Last", "[", 
     RowBox[{"ConicaCincoPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD", ",", "ptE"}], "}"}],
       "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "the", " ", "conic", " ", "is", " ", "an", " ", "hyperbola", " ", "by", 
    " ", "Poncelet", " ", "Theorem"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sustituirxyz", "[", 
    RowBox[{"con", ",", 
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}], "]"}]}], "]"}], ",", 
   "rectangle"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946526060469745*^9, 3.946526154123197*^9}, {
  3.9465261949225063`*^9, 3.9465261958350143`*^9}},
 CellLabel->"In[94]:=",ExpressionUUID->"75637022-fe4d-6b43-8d83-46d8b8135fcc"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.946526075391356*^9, 3.9465260998825626`*^9}, {
   3.946526140656185*^9, 3.946526156430397*^9}, 3.946526188687067*^9, 
   3.946526481021187*^9, 3.946526742718918*^9, 3.9474841481365833`*^9},
 CellLabel->"Out[95]=",ExpressionUUID->"36e45519-71c3-8043-8279-dae6c3500aad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ptP", "=", 
   RowBox[{"CentroConica", "[", "con", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"findQACenter", "[", 
  RowBox[{"ptP", ",", "rectangle"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946526216413479*^9, 3.946526246075087*^9}},
 CellLabel->"In[96]:=",ExpressionUUID->"8517559b-6797-d347-af6c-c06a5b63d257"],

Cell[BoxData["\<\"QA-P1\"\>"], "Output",
 CellChangeTimes->{3.94652624704187*^9, 3.946526388591912*^9, 
  3.9465264854258747`*^9, 3.946526745791298*^9, 3.9474841508805904`*^9},
 CellLabel->"Out[97]=",ExpressionUUID->"e7fd1dd2-6c54-0541-87ed-44639c63d9bd"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{"ptP", ",", 
   RowBox[{"QAP1", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9465263938849583`*^9, 3.946526423345928*^9}, {
  3.9474841532356167`*^9, 3.947484155612831*^9}},
 CellLabel->"In[98]:=",ExpressionUUID->"77047386-dfc8-dc4b-9d07-2a1489fb404a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946526427818035*^9, 3.946526487578926*^9, 
  3.94652676843622*^9, 3.947484176082403*^9},
 CellLabel->"Out[98]=",ExpressionUUID->"31c49e3c-245e-ac4f-9388-061bff0f7654"]
}, Closed]]
}, Closed]]
},
CellGrouping->Manual,
WindowSize->{1293.2830188679245`, 654.7924528301886},
WindowMargins->{{0, Automatic}, {Automatic, -0.6792452830188679}},
FrontEndVersion->"14.0 for Microsoft Windows (64-bit) (December 12, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"be3740c5-6cf4-6e44-a959-8ed4dbb0b0da"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 276, 5, 98, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[837, 27, 1399, 24, 173, "Text",ExpressionUUID->"08758b0a-705f-b842-b1d6-6a28a79b6218"],
Cell[CellGroupData[{
Cell[2261, 55, 200, 4, 67, "Section",ExpressionUUID->"5e4c6aa2-710c-4599-941e-5f13e499af78"],
Cell[CellGroupData[{
Cell[2486, 63, 1413, 32, 67, "Input",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"],
Cell[3902, 97, 349, 8, 32, "Output",ExpressionUUID->"fbbbb472-2c5e-1249-bc79-2ea15ed2049d"]
}, Open  ]],
Cell[4266, 108, 574, 17, 28, "Input",ExpressionUUID->"d0c5b345-9e88-e04a-9131-1e258249750e"]
}, Closed]],
Cell[CellGroupData[{
Cell[4877, 130, 255, 4, 53, "Section",ExpressionUUID->"cf60f297-bbcd-8748-b453-e7118b4e0a98"],
Cell[CellGroupData[{
Cell[5157, 138, 212, 4, 54, "Subsection",ExpressionUUID->"c8cca55e-04f1-8f4a-b670-3c3179eed91e"],
Cell[5372, 144, 271227, 7063, 3643, "Input",ExpressionUUID->"90297db1-2eea-6346-9338-a3e8dcfe0024"]
}, Closed]],
Cell[CellGroupData[{
Cell[276636, 7212, 215, 4, 38, "Subsection",ExpressionUUID->"79ef6085-3de7-3c49-8561-f943fbd2d431"],
Cell[276854, 7218, 438, 12, 28, "Input",ExpressionUUID->"e725b315-4161-274c-8798-a4e0c807d6a8"],
Cell[277295, 7232, 439, 12, 28, "Input",ExpressionUUID->"60fea3de-a36e-734d-b67f-75eab8f36838"],
Cell[277737, 7246, 438, 12, 28, "Input",ExpressionUUID->"422bd8e2-a85e-d748-b542-6c9b62c11efd"],
Cell[278178, 7260, 1082, 30, 28, "Input",ExpressionUUID->"d021f1ab-c58d-b74b-8aa5-a62365464cc5"],
Cell[279263, 7292, 820, 24, 28, "Input",ExpressionUUID->"023d4850-e194-b941-a762-4c9a532e11d1"],
Cell[280086, 7318, 603, 17, 28, "Input",ExpressionUUID->"62ef2468-c328-714d-8bf7-299b142a086d"],
Cell[280692, 7337, 2073, 54, 181, "Input",ExpressionUUID->"d734f707-6812-364b-b359-ac3a6bb66e72"],
Cell[282768, 7393, 1714, 47, 143, "Input",ExpressionUUID->"34f7e383-98aa-bc47-9867-166186424dd4"],
Cell[284485, 7442, 1914, 51, 162, "Input",ExpressionUUID->"4370c731-693f-a941-82c8-1f6a14f724b2"],
Cell[286402, 7495, 613, 17, 28, "Input",ExpressionUUID->"6e2024d9-4541-ea4e-a308-49a8bb9b87a5"],
Cell[287018, 7514, 1131, 30, 124, "Input",ExpressionUUID->"384fc915-4ebd-5342-9174-a166a5e7f52d"],
Cell[288152, 7546, 1395, 40, 124, "Input",ExpressionUUID->"e878baba-ea71-dd4f-b972-2e4c3753c774"],
Cell[289550, 7588, 1398, 40, 124, "Input",ExpressionUUID->"4200ee2b-abeb-b246-85fa-68f1ce5d836b"],
Cell[290951, 7630, 1330, 39, 124, "Input",ExpressionUUID->"8131db8a-5012-e741-93f3-ec6da52923f1"],
Cell[292284, 7671, 1368, 38, 143, "Input",ExpressionUUID->"3e5eb206-464c-7e4f-b628-98c50c5a4629"]
}, Closed]],
Cell[CellGroupData[{
Cell[293689, 7714, 291, 5, 38, "Subsection",ExpressionUUID->"d004e03f-8f12-9a43-865f-339812029417"],
Cell[293983, 7721, 3318, 101, 130, "Input",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],
Cell[CellGroupData[{
Cell[297338, 7827, 170, 3, 38, "Subsection",ExpressionUUID->"2a49be25-3c4e-430e-86c6-869880736f30"],
Cell[CellGroupData[{
Cell[297533, 7834, 217, 4, 45, "Subsubsection",ExpressionUUID->"a576f9af-1f5b-4213-b4d3-e7b66981337e"],
Cell[297753, 7840, 53880, 889, 404, "Text",ExpressionUUID->"f7950398-57cb-4ee6-bf14-597b39eb91df"],
Cell[351636, 8731, 999, 25, 86, "Input",ExpressionUUID->"cf738f77-0d96-4e62-81a0-f2a504594dc8"]
}, Closed]],
Cell[CellGroupData[{
Cell[352672, 8761, 238, 4, 37, "Subsubsection",ExpressionUUID->"f7957972-a4e9-446f-bafd-6774f0dd3699"],
Cell[352913, 8767, 817, 19, 48, "Input",ExpressionUUID->"44de57fd-6e7d-4d98-94a0-c7b93947eadd"]
}, Closed]],
Cell[CellGroupData[{
Cell[353767, 8791, 215, 4, 37, "Subsubsection",ExpressionUUID->"ae32c2db-9871-344f-aabd-a2543db56100"],
Cell[353985, 8797, 2076, 57, 101, "Input",ExpressionUUID->"db0fcba9-9144-4df7-981b-db22bb466a6e"]
}, Closed]],
Cell[CellGroupData[{
Cell[356098, 8859, 242, 4, 37, "Subsubsection",ExpressionUUID->"29f12ada-9fd0-4747-b323-2cf96d6fb52e"],
Cell[356343, 8865, 664, 16, 28, "Input",ExpressionUUID->"158fb412-c771-43ab-b43b-a357380f4a11"]
}, Closed]],
Cell[CellGroupData[{
Cell[357044, 8886, 197, 3, 37, "Subsubsection",ExpressionUUID->"5a543829-5641-9144-8dd0-57eb7cf1938d"],
Cell[357244, 8891, 1567, 43, 124, "Input",ExpressionUUID->"35cb8ff3-829e-654a-a95d-e2c972de6be9"]
}, Closed]],
Cell[CellGroupData[{
Cell[358848, 8939, 174, 3, 37, "Subsubsection",ExpressionUUID->"e039afe9-d89d-4ec4-94b9-ddb3f9f259e0"],
Cell[359025, 8944, 562, 15, 28, "Input",ExpressionUUID->"2db3c5dc-e4da-4371-937a-22cb108c81e1"]
}, Closed]],
Cell[CellGroupData[{
Cell[359624, 8964, 372, 6, 37, "Subsubsection",ExpressionUUID->"bd16b166-d506-5544-b5d0-7aa6edfca35b"],
Cell[359999, 8972, 1247, 34, 52, "Input",ExpressionUUID->"6cd12b17-ccf6-1f40-8216-e746f72a898c"]
}, Closed]],
Cell[CellGroupData[{
Cell[361283, 9011, 384, 6, 37, "Subsubsection",ExpressionUUID->"d546f79d-5ed9-4f99-846e-3ac1a3756b86"],
Cell[361670, 9019, 972, 27, 28, "Input",ExpressionUUID->"5668c7c2-b2f3-48b4-bb4e-3f493e46ab9c"],
Cell[362645, 9048, 883, 25, 28, "Input",ExpressionUUID->"d07dfa48-d9b6-433c-9d4d-8f2532f1bec3"]
}, Closed]],
Cell[CellGroupData[{
Cell[363565, 9078, 323, 5, 37, "Subsubsection",ExpressionUUID->"8f461d45-0647-c84b-9fe0-f72d3601c63f"],
Cell[363891, 9085, 1686, 41, 157, "Input",ExpressionUUID->"5485ed32-34f6-e64e-bd2a-b4e163c2b97f"]
}, Closed]],
Cell[CellGroupData[{
Cell[365614, 9131, 201, 3, 35, "Subsubsection",ExpressionUUID->"54169a90-c35c-7a4a-a37f-78c9753e8eeb"],
Cell[365818, 9136, 1631, 40, 124, "Input",ExpressionUUID->"c1bc4c8d-1ecd-654a-b9e2-f902b4037dfa"]
}, Closed]],
Cell[CellGroupData[{
Cell[367486, 9181, 225, 4, 35, "Subsubsection",ExpressionUUID->"e126572d-bdab-a047-b925-c2661290f09e"],
Cell[367714, 9187, 1442, 38, 105, "Input",ExpressionUUID->"3eac6f83-9820-5d4f-9acd-4f2df1b13510"]
}, Closed]],
Cell[CellGroupData[{
Cell[369193, 9230, 308, 5, 35, "Subsubsection",ExpressionUUID->"1d12da59-37f1-9842-ad9c-eb916041816f"],
Cell[369504, 9237, 3090, 71, 219, "Input",ExpressionUUID->"806c98e7-c027-de46-8fc2-cc2eda959f64"]
}, Closed]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[372655, 9315, 211, 4, 53, "Section",ExpressionUUID->"2609bf4c-7f5c-314e-a744-f86d4be283dd"],
Cell[372869, 9321, 76634, 1261, 330, "Text",ExpressionUUID->"20c7ab22-8503-fd4d-9d34-15585b88ac29"],
Cell[CellGroupData[{
Cell[449528, 10586, 156, 3, 54, "Subsection",ExpressionUUID->"10edca6a-71a7-f647-bea6-6609a23bef9a"],
Cell[CellGroupData[{
Cell[449709, 10593, 315, 6, 28, "Input",ExpressionUUID->"608068da-e44e-e64e-86b4-717062a1c7a6"],
Cell[450027, 10601, 7418, 236, 100, "Output",ExpressionUUID->"3c46ebb9-daf6-474f-8d1e-c3e4880821f5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[457482, 10842, 167, 3, 45, "Subsubsection",ExpressionUUID->"0783a5c2-3bae-714e-a912-12a39b395ebb"],
Cell[CellGroupData[{
Cell[457674, 10849, 691, 15, 48, "Input",ExpressionUUID->"4b77511b-10fb-a448-b2b2-99f2ba87fb11"],
Cell[458368, 10866, 295, 4, 32, "Output",ExpressionUUID->"942511a8-882a-a04b-a5ce-36640f536303"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[458724, 10877, 235, 4, 38, "Subsection",ExpressionUUID->"a5e5c071-1076-6a41-8df9-aafa3cef069e"],
Cell[CellGroupData[{
Cell[458984, 10885, 978, 19, 28, "Input",ExpressionUUID->"a38f9cae-8e08-a14a-bb71-02f7c22c36e1"],
Cell[459965, 10906, 4328, 131, 57, "Output",ExpressionUUID->"330fb815-be1c-b14c-877b-f2099b7b8a63"]
}, Open  ]],
Cell[CellGroupData[{
Cell[464330, 11042, 190, 3, 45, "Subsubsection",ExpressionUUID->"5bc9917e-997c-f64b-9f34-0f29d7b72f43"],
Cell[464523, 11047, 426, 9, 97, "Text",ExpressionUUID->"b7c5fe34-4a10-9f49-a2f0-3ce403908d6a"],
Cell[CellGroupData[{
Cell[464974, 11060, 1604, 40, 75, "Input",ExpressionUUID->"b996a175-ce2e-9a43-8e90-8ad98be6b7d9"],
Cell[466581, 11102, 629, 9, 32, "Output",ExpressionUUID->"52bfd9ee-39b5-9140-b431-0c6327343a52"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[467271, 11118, 158, 3, 38, "Subsection",ExpressionUUID->"f51aa334-7c35-a546-b30b-d89ea1d89696"],
Cell[CellGroupData[{
Cell[467454, 11125, 1074, 20, 28, "Input",ExpressionUUID->"c0f1b7d4-631c-624d-964f-12f5efd1cbbb"],
Cell[468531, 11147, 5328, 162, 78, "Output",ExpressionUUID->"cac0bd99-ed26-f349-9cfe-eb18e06e56b0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[473896, 11314, 190, 3, 45, "Subsubsection",ExpressionUUID->"803d34fd-e52b-2e42-9889-b1a2a43db251"],
Cell[474089, 11319, 426, 9, 97, "Text",ExpressionUUID->"f34be930-e86a-1a4a-8b8a-da8f74c8cfd9"],
Cell[CellGroupData[{
Cell[474540, 11332, 1515, 38, 75, "Input",ExpressionUUID->"83adc57e-85ae-1649-a0bc-39927c2710fa"],
Cell[476058, 11372, 559, 8, 32, "Output",ExpressionUUID->"c72dc9bd-557f-504a-a114-ca1cfea20570"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[476678, 11387, 205, 4, 38, "Subsection",ExpressionUUID->"cce76eb4-599e-1347-9d4c-fed4bfb4f3ee"],
Cell[476886, 11393, 293, 6, 28, "Input",ExpressionUUID->"feabeb96-eb56-4a4a-9621-2b1e901ccd9d"],
Cell[477182, 11401, 12415, 384, 143, "Output",ExpressionUUID->"4ab49ab0-3443-ed4b-914f-c4f38ed2ca2c"],
Cell[CellGroupData[{
Cell[489622, 11789, 168, 3, 45, "Subsubsection",ExpressionUUID->"72d62beb-c377-e14a-beac-311b374f4b84"],
Cell[CellGroupData[{
Cell[489815, 11796, 1069, 21, 48, "Input",ExpressionUUID->"4cc6b00a-a7d5-9d45-b581-02dcb33d1d3d"],
Cell[490887, 11819, 704, 10, 32, "Output",ExpressionUUID->"95437533-9e98-f846-98f2-246a1de8da6f"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[491652, 11836, 212, 4, 38, "Subsection",ExpressionUUID->"bb573515-b83d-6946-9083-d3fd7c59b610"],
Cell[CellGroupData[{
Cell[491889, 11844, 674, 15, 28, "Input",ExpressionUUID->"982b71e3-0533-e148-93de-c546cc31c107"],
Cell[492566, 11861, 9011, 275, 122, "Output",ExpressionUUID->"f41aa1dc-9cd4-ed4d-87e7-d591317bed9d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[501614, 12141, 190, 3, 45, "Subsubsection",ExpressionUUID->"feca4cf1-559b-5540-833e-41e652fbf182"],
Cell[501807, 12146, 453, 9, 97, "Text",ExpressionUUID->"beae711b-937c-e84f-912e-0588976025d5"],
Cell[CellGroupData[{
Cell[502285, 12159, 1494, 38, 75, "Input",ExpressionUUID->"690e391c-6aae-1e48-a74e-92c914b7826d"],
Cell[503782, 12199, 363, 6, 32, "Output",ExpressionUUID->"c1953fc9-8d2e-814a-a4bb-6a0c3830ce5e"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[504206, 12212, 207, 4, 38, "Subsection",ExpressionUUID->"45e15fb3-9637-0f45-b9f9-2e286b04e863"],
Cell[CellGroupData[{
Cell[504438, 12220, 722, 15, 28, "Input",ExpressionUUID->"d960c159-514d-514a-8877-faaab322bac0"],
Cell[505163, 12237, 4960, 157, 57, "Output",ExpressionUUID->"835a17d0-cf4b-9b4e-84e7-89d9f5d4dc9b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[510160, 12399, 190, 3, 45, "Subsubsection",ExpressionUUID->"9c063ed8-5888-924b-9ae8-924770328d73"],
Cell[510353, 12404, 426, 9, 97, "Text",ExpressionUUID->"a04e03dd-8f89-1944-bc5a-713d4f4d9c5f"],
Cell[CellGroupData[{
Cell[510804, 12417, 1515, 38, 75, "Input",ExpressionUUID->"20281e6f-f376-c440-b67d-ee97d642568b"],
Cell[512322, 12457, 387, 6, 32, "Output",ExpressionUUID->"d294ef6a-d0b9-6f4b-b92c-8f8f76d73600"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[512770, 12470, 182, 3, 38, "Subsection",ExpressionUUID->"715efd71-2e75-d943-8568-66b6eb6e502c"],
Cell[CellGroupData[{
Cell[512977, 12477, 294, 6, 28, "Input",ExpressionUUID->"ec17c3ac-978a-e740-9535-a14c2c3a9219"],
Cell[513274, 12485, 14378, 444, 165, "Output",ExpressionUUID->"ac461e37-541e-d94e-824b-750b5d665d88"]
}, Open  ]],
Cell[CellGroupData[{
Cell[527689, 12934, 178, 3, 45, "Subsubsection",ExpressionUUID->"f2f527bb-fe34-9648-8825-61f813504765"],
Cell[CellGroupData[{
Cell[527892, 12941, 646, 15, 48, "Input",ExpressionUUID->"e2544b87-5d1f-8845-9579-7b6124cb0c5b"],
Cell[528541, 12958, 221, 4, 48, "Output",ExpressionUUID->"fe518494-7408-d049-8b9e-3e83b58084bc"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[528823, 12969, 206, 4, 38, "Subsection",ExpressionUUID->"9702b9fc-09d6-6848-8faf-d4af7edb6c4f"],
Cell[CellGroupData[{
Cell[529054, 12977, 294, 6, 28, "Input",ExpressionUUID->"8f09bc09-afca-1f4d-bc3a-d932efecf117"],
Cell[529351, 12985, 6139, 197, 100, "Output",ExpressionUUID->"0e7564ae-435d-444c-a25b-970c08ea8545"]
}, Open  ]],
Cell[CellGroupData[{
Cell[535527, 13187, 194, 3, 45, "Subsubsection",ExpressionUUID->"7fab42e8-bc10-d64f-b25b-ad2e23ec0e56"],
Cell[CellGroupData[{
Cell[535746, 13194, 569, 13, 28, "Input",ExpressionUUID->"a6285f78-9d7e-fd48-9101-9feb9fc27c31"],
Cell[536318, 13209, 276, 4, 32, "Output",ExpressionUUID->"36c8dcfc-bc8a-ee40-b28b-425a3288781c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[536631, 13218, 916, 23, 67, "Input",ExpressionUUID->"3c92ef03-4c7f-4343-b2ac-f84546de8fae"],
Cell[537550, 13243, 365, 5, 32, "Output",ExpressionUUID->"be0828f1-bc22-5f44-bc03-1044c31c46e1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[537952, 13253, 357, 7, 48, "Input",ExpressionUUID->"1467531f-8b46-df4f-b52a-1a3f46e08cc7"],
Cell[538312, 13262, 300, 4, 32, "Output",ExpressionUUID->"eb907235-9f50-2c45-b3af-c12526711c09"]
}, Open  ]],
Cell[CellGroupData[{
Cell[538649, 13271, 400, 9, 28, "Input",ExpressionUUID->"843e8d0c-068e-a34a-895b-e287ee9ee692"],
Cell[539052, 13282, 255, 4, 32, "Output",ExpressionUUID->"7d8905fc-4ee8-ce4e-aafb-cf8a6688eb5f"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[539368, 13293, 210, 4, 38, "Subsection",ExpressionUUID->"0425f9f1-c859-0741-92d8-7caa0335972a"],
Cell[CellGroupData[{
Cell[539603, 13301, 294, 6, 28, "Input",ExpressionUUID->"41fd1140-9786-b54f-b686-0217eeed3e72"],
Cell[539900, 13309, 2666, 87, 57, "Output",ExpressionUUID->"868a2a27-4edd-ea46-bbde-43ddabdda5ba"]
}, Open  ]],
Cell[542581, 13399, 194, 3, 45, "Subsubsection",ExpressionUUID->"3386577b-77e3-c240-b621-59a246d4a1b2"],
Cell[CellGroupData[{
Cell[542800, 13406, 619, 13, 24, "Input",ExpressionUUID->"b013180d-99ba-774d-b11c-90c4bc1c7a99"],
Cell[543422, 13421, 248, 3, 32, "Output",ExpressionUUID->"76d80fae-2d7a-0a47-9398-06e81281d50e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[543707, 13429, 916, 23, 67, "Input",ExpressionUUID->"256d6574-4069-a648-b925-0905fe79c74d"],
Cell[544626, 13454, 321, 4, 32, "Output",ExpressionUUID->"1900d19f-9083-a94f-9f1c-e85fcf90d8ac"]
}, Open  ]],
Cell[CellGroupData[{
Cell[544984, 13463, 357, 7, 48, "Input",ExpressionUUID->"1966d6c8-670c-b240-a1af-11c59bd307b1"],
Cell[545344, 13472, 233, 3, 32, "Output",ExpressionUUID->"9222ad38-3189-8347-90a7-3503a00be8cc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[545614, 13480, 402, 9, 28, "Input",ExpressionUUID->"1f60b127-c88c-0b40-8274-84607c565dea"],
Cell[546019, 13491, 225, 3, 32, "Output",ExpressionUUID->"1cde81b9-1192-db4f-ac4b-7effb95e58e3"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[546293, 13500, 210, 4, 38, "Subsection",ExpressionUUID->"0400839e-498c-ea48-8aea-71d4437355c5"],
Cell[CellGroupData[{
Cell[546528, 13508, 296, 6, 28, "Input",ExpressionUUID->"a36aa6f2-af9e-9c49-b0c9-3e6af78916c2"],
Cell[546827, 13516, 27280, 813, 273, "Output",ExpressionUUID->"e8cb7b56-151a-8c4f-9b3c-b3e33bec6bf8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[574144, 14334, 167, 3, 45, "Subsubsection",ExpressionUUID->"9b9f672e-c5dd-3d4c-98ee-70863f902b68"],
Cell[CellGroupData[{
Cell[574336, 14341, 667, 15, 48, "Input",ExpressionUUID->"612bc564-a70c-dd49-ade4-5df5f12d3c9f"],
Cell[575006, 14358, 244, 3, 32, "Output",ExpressionUUID->"d605dc95-bc42-3e4d-a48f-93b9cdaa51e2"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[575311, 14368, 208, 4, 38, "Subsection",ExpressionUUID->"5c900a6b-bb26-7e47-97a8-db1ac4dc7b03"],
Cell[CellGroupData[{
Cell[575544, 14376, 296, 6, 28, "Input",ExpressionUUID->"dece4e25-315e-8a46-b7ef-3b089b81521b"],
Cell[575843, 14384, 9568, 294, 173, "Output",ExpressionUUID->"7b2e50b3-6341-6345-9582-91a022e0703f"]
}, Open  ]],
Cell[585426, 14681, 194, 3, 45, "Subsubsection",ExpressionUUID->"d2ea3273-a245-524f-9541-bfa1c23c0b3e"],
Cell[CellGroupData[{
Cell[585645, 14688, 666, 14, 24, "Input",ExpressionUUID->"e0411395-352d-b74e-bdf5-e38a28d6dbf6"],
Cell[586314, 14704, 248, 3, 32, "Output",ExpressionUUID->"aeb6eac7-5ef2-5e41-bbd0-e735bcfd7b25"]
}, Open  ]],
Cell[CellGroupData[{
Cell[586599, 14712, 916, 23, 67, "Input",ExpressionUUID->"f4000789-c233-f448-ade0-474ce135554b"],
Cell[587518, 14737, 317, 4, 32, "Output",ExpressionUUID->"6fe8b983-132b-564e-b2f9-02225aa172c7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[587872, 14746, 361, 8, 48, "Input",ExpressionUUID->"e57855fb-23d7-c742-b6be-66a1fd717c7d"],
Cell[588236, 14756, 237, 4, 32, "Output",ExpressionUUID->"84e6bbed-53db-d04c-8b23-95246739cfdb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[588510, 14765, 402, 9, 28, "Input",ExpressionUUID->"d586a522-cc79-544a-892a-7e8bd6b503a2"],
Cell[588915, 14776, 221, 3, 32, "Output",ExpressionUUID->"a17765dd-efb9-e44f-a4fb-497606b96814"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[589185, 14785, 305, 5, 38, "Subsection",ExpressionUUID->"27d3565e-81d7-2a4b-bd05-e2e88a793766"],
Cell[CellGroupData[{
Cell[589515, 14794, 527, 14, 28, "Input",ExpressionUUID->"cd352085-8be8-d94b-8023-067c216a8c07"],
Cell[590045, 14810, 5588, 181, 124, "Output",ExpressionUUID->"3e55df53-3e8f-1448-8c95-4cad47087f11"]
}, Open  ]],
Cell[595648, 14994, 190, 3, 45, "Subsubsection",ExpressionUUID->"fadc6656-4520-af40-b473-576d0efeb75c"],
Cell[595841, 14999, 404, 9, 93, "Text",ExpressionUUID->"b1af2457-7cac-a743-902f-bdde1294cb77"],
Cell[596248, 15010, 1744, 47, 84, "Input",ExpressionUUID->"1732af5e-d9c4-aa4a-a8e7-ca54125f2700"],
Cell[597995, 15059, 864, 13, 32, "Output",ExpressionUUID->"38547fc8-8f66-bc4d-980d-2fa5628fa6c4"]
}, Closed]],
Cell[CellGroupData[{
Cell[598896, 15077, 210, 4, 38, "Subsection",ExpressionUUID->"64c45fba-f67c-494f-81c4-2074ccc32fdf"],
Cell[CellGroupData[{
Cell[599131, 15085, 576, 15, 28, "Input",ExpressionUUID->"ce59fb54-7d16-5348-8076-4dbd0b487a16"],
Cell[599710, 15102, 5713, 180, 124, "Output",ExpressionUUID->"80175a37-5130-6043-80d9-6e3b7b83b0c0"]
}, Open  ]],
Cell[605438, 15285, 190, 3, 45, "Subsubsection",ExpressionUUID->"08837014-187d-5644-8ae0-d6cfc3eb0d81"],
Cell[605631, 15290, 453, 9, 93, "Text",ExpressionUUID->"1966cb3e-6486-c04a-8f7f-3d64be2858cf"],
Cell[606087, 15301, 876, 29, 75, "Input",ExpressionUUID->"5ef205ec-6986-be44-94e1-4ad1c0980b66"],
Cell[606966, 15332, 175, 3, 32, "Output",ExpressionUUID->"1a417ee7-a446-ba4e-b532-6ecdc2ed6a63"]
}, Closed]],
Cell[CellGroupData[{
Cell[607178, 15340, 206, 4, 38, "Subsection",ExpressionUUID->"225c47ff-0b56-c24b-973f-16cfde3e2c92"],
Cell[CellGroupData[{
Cell[607409, 15348, 293, 6, 28, "Input",ExpressionUUID->"958a0d09-307f-1e41-977f-eeefcb6781fd"],
Cell[607705, 15356, 5695, 182, 78, "Output",ExpressionUUID->"45d4fef6-c42e-7f47-bbc5-d90887ea464a"]
}, Open  ]],
Cell[613415, 15541, 194, 3, 45, "Subsubsection",ExpressionUUID->"8fae9f90-2f29-8440-9110-1e7a924cfccd"],
Cell[CellGroupData[{
Cell[613634, 15548, 668, 14, 24, "Input",ExpressionUUID->"b48021b9-6413-c345-a334-ffb6bee2d206"],
Cell[614305, 15564, 246, 3, 32, "Output",ExpressionUUID->"09e2010a-875b-c54e-b1cd-a97ff1ee76aa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[614588, 15572, 916, 23, 67, "Input",ExpressionUUID->"ee0887f2-f1cf-514d-bfd2-067a90b2c7ec"],
Cell[615507, 15597, 319, 4, 32, "Output",ExpressionUUID->"f6b68083-5889-2f4d-aa29-573613f4bbb9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[615863, 15606, 357, 7, 48, "Input",ExpressionUUID->"c56001b8-7fda-1e4e-9ad4-105bf522e3c0"],
Cell[616223, 15615, 255, 3, 32, "Output",ExpressionUUID->"d8110769-cd21-964d-b67f-dc46c0efc2e7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[616515, 15623, 404, 9, 28, "Input",ExpressionUUID->"5fd291f7-807a-5649-8155-05e4dcdecff3"],
Cell[616922, 15634, 223, 3, 32, "Output",ExpressionUUID->"ae2fbbce-3837-c64b-bb56-6a7ec21c5f38"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[617194, 15643, 208, 4, 38, "Subsection",ExpressionUUID->"d7317eec-da23-5745-b10e-5dac9a7890d2"],
Cell[CellGroupData[{
Cell[617427, 15651, 773, 16, 28, "Input",ExpressionUUID->"ef596d7f-351a-7c4f-9390-d6295dd444cf"],
Cell[618203, 15669, 5126, 159, 78, "Output",ExpressionUUID->"26672b81-96e2-454d-b8ad-8c050d3b6042"]
}, Open  ]],
Cell[CellGroupData[{
Cell[623366, 15833, 190, 3, 45, "Subsubsection",ExpressionUUID->"d9135fca-efb2-7c49-9db3-2e124a920236"],
Cell[623559, 15838, 426, 9, 97, "Text",ExpressionUUID->"610437cd-e84f-2549-94d7-b97b95cd9166"],
Cell[CellGroupData[{
Cell[624010, 15851, 1515, 38, 75, "Input",ExpressionUUID->"5fb6cdf8-8ba5-e94b-b691-f1af9b9abafe"],
Cell[625528, 15891, 363, 6, 32, "Output",ExpressionUUID->"79f39378-167a-7848-af3e-18aa2bc5d5f3"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[625952, 15904, 208, 4, 38, "Subsection",ExpressionUUID->"0c229d01-69b6-824b-b235-6ccaca18fcdb"],
Cell[CellGroupData[{
Cell[626185, 15912, 296, 6, 28, "Input",ExpressionUUID->"24c6cd40-a272-a745-9f1e-bfbf24b334cf"],
Cell[626484, 15920, 15176, 475, 250, "Output",ExpressionUUID->"3a3d94b2-0d45-d149-9e28-52689254a8ce"]
}, Open  ]],
Cell[CellGroupData[{
Cell[641697, 16400, 167, 3, 45, "Subsubsection",ExpressionUUID->"21f19122-0f6c-9847-a0d2-3130cea6f671"],
Cell[CellGroupData[{
Cell[641889, 16407, 672, 15, 48, "Input",ExpressionUUID->"42df4626-f315-f042-80e4-71765e9fd275"],
Cell[642564, 16424, 242, 3, 32, "Output",ExpressionUUID->"7793cf4c-79d3-e047-a621-e8919ce807e6"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[642867, 16434, 208, 4, 38, "Subsection",ExpressionUUID->"ec386b63-1f6b-fc4f-aa73-b1f67d54692d"],
Cell[CellGroupData[{
Cell[643100, 16442, 318, 6, 28, "Input",ExpressionUUID->"0ed87c6f-b31f-8a4c-9d59-08e6195215ad"],
Cell[643421, 16450, 19636, 595, 299, "Output",ExpressionUUID->"e6f7219d-4c8d-784d-96f2-15514487a26e"]
}, Open  ]],
Cell[663072, 17048, 194, 3, 45, "Subsubsection",ExpressionUUID->"8253f0b2-495c-dc4e-a57c-4abf7c058827"],
Cell[CellGroupData[{
Cell[663291, 17055, 647, 14, 24, "Input",ExpressionUUID->"c43eef23-d739-2a41-bbec-5938d40651ac"],
Cell[663941, 17071, 276, 4, 32, "Output",ExpressionUUID->"7ed44d4b-9f1a-8f49-ac0c-ff79e9c2e0ad"]
}, Open  ]],
Cell[CellGroupData[{
Cell[664254, 17080, 916, 23, 67, "Input",ExpressionUUID->"f4ff317d-c7ec-194b-bbd2-c450293c5efa"],
Cell[665173, 17105, 347, 5, 32, "Output",ExpressionUUID->"7c3d9dff-5253-7f4e-93a0-6df423eb471e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[665557, 17115, 357, 7, 48, "Input",ExpressionUUID->"f2ad35e3-d2da-b74a-aade-10a021a40c8c"],
Cell[665917, 17124, 278, 4, 32, "Output",ExpressionUUID->"cf572f97-3f4a-a949-a3dc-fad8a97ec772"]
}, Open  ]],
Cell[CellGroupData[{
Cell[666232, 17133, 400, 9, 28, "Input",ExpressionUUID->"e69edb9c-e31b-8d42-8ddc-a6bf9b298d2e"],
Cell[666635, 17144, 249, 4, 32, "Output",ExpressionUUID->"15b20867-c4bf-f646-8049-dd716c50e654"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[666933, 17154, 210, 4, 38, "Subsection",ExpressionUUID->"7f7586c2-b1d4-2844-a923-7669adb84c99"],
Cell[667146, 17160, 341, 7, 28, "Input",ExpressionUUID->"f330c6e3-0dc6-8e40-8310-475183f90f3f"],
Cell[667490, 17169, 194, 3, 45, "Subsubsection",ExpressionUUID->"9c24fbcf-78a6-7543-90c8-b15d3f6c02e2"],
Cell[CellGroupData[{
Cell[667709, 17176, 666, 14, 24, "Input",ExpressionUUID->"5b88f579-2f53-c647-9bbe-6d883dc9443b"],
Cell[668378, 17192, 246, 3, 32, "Output",ExpressionUUID->"c3d908f8-d1b5-ae45-b497-347b65c17ad2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[668661, 17200, 916, 23, 67, "Input",ExpressionUUID->"75637022-fe4d-6b43-8d83-46d8b8135fcc"],
Cell[669580, 17225, 319, 4, 32, "Output",ExpressionUUID->"36e45519-71c3-8043-8279-dae6c3500aad"]
}, Open  ]],
Cell[CellGroupData[{
Cell[669936, 17234, 357, 7, 48, "Input",ExpressionUUID->"8517559b-6797-d347-af6c-c06a5b63d257"],
Cell[670296, 17243, 255, 3, 32, "Output",ExpressionUUID->"e7fd1dd2-6c54-0541-87ed-44639c63d9bd"]
}, Open  ]],
Cell[670566, 17249, 402, 9, 28, "Input",ExpressionUUID->"77047386-dfc8-dc4b-9d07-2a1489fb404a"],
Cell[670971, 17260, 220, 3, 32, "Output",ExpressionUUID->"31c49e3c-245e-ac4f-9388-061bff0f7654"]
}, Closed]]
}, Closed]]
}
]
*)

