(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    517204,      12958]
NotebookOptionsPosition[    505325,      12763]
NotebookOutlinePosition[    505795,      12780]
CellTagsIndexPosition[    505752,      12777]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Rhombi", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, 
   3.947147906503248*^9, {3.947481336744753*^9, 3.947481338032559*^9}, {
   3.947482272199051*^9, 3.947482274311268*^9}, {3.94749391578257*^9, 
   3.9474939175186405`*^9}},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about rhombi in the paper \
\"More Relationships between a Central Quadrilateral and its Reference \
Quadrilateral\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in \
February 2025.

This Notebook is Copyright \[Copyright] February 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947481344697075*^9, 3.947481347432724*^9}, {
  3.9474822817822647`*^9, 3.947482284055073*^9}, {3.9474939233585796`*^9, 
  3.947493924694851*^9}},ExpressionUUID->"08758b0a-705f-b842-b1d6-\
6a28a79b6218"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.94550589477663*^9, 3.9455059090976067`*^9}, {
  3.947131190260437*^9, 
  3.947131192227951*^9}},ExpressionUUID->"5e4c6aa2-710c-4599-941e-\
5f13e499af78"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", ">", "0"}], ",", 
     RowBox[{"b", ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ptD", "=", 
  RowBox[{"Punto", "[", 
   RowBox[{
    RowBox[{"Paralela", "[", 
     RowBox[{"ptA", ",", "rtBC"}], "]"}], ",", 
    RowBox[{"Paralela", "[", 
     RowBox[{"ptC", ",", "rtAB"}], "]"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.945504565162958*^9, 3.94550458198252*^9}, {
   3.9455170892604294`*^9, 3.945517091156999*^9}, {3.946437513579389*^9, 
   3.946437514387348*^9}, {3.946437922994858*^9, 3.946437998083948*^9}, {
   3.947131229988783*^9, 3.9471312337408752`*^9}, {3.94713126947538*^9, 
   3.947131271053065*^9}, {3.9471314397563486`*^9, 3.947131528028438*^9}, {
   3.947131689741032*^9, 3.947131695924305*^9}, {3.947131733918829*^9, 
   3.947131775067988*^9}, 3.94713185451009*^9, {3.947132455427481*^9, 
   3.947132456035076*^9}, {3.947133799219084*^9, 3.947133799613205*^9}, {
   3.947481378154803*^9, 3.947481389864706*^9}, 3.94749400024761*^9},
 CellLabel->
  "In[142]:=",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947481395665182*^9, 3.9474816145492115`*^9, 3.947481680153954*^9, 
   3.9474823730894623`*^9, {3.947494001639185*^9, 3.9474940201693153`*^9}},
 CellLabel->
  "Out[144]=",ExpressionUUID->"4acf0693-2759-1d45-ae80-6e20e8d29da7"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"rhombus", "=", 
   RowBox[{
    RowBox[{"p", "==", "r"}], "&&", 
    RowBox[{
     RowBox[{"p", "+", "q"}], "==", "0"}], "&&", 
    RowBox[{"a", "==", "c"}]}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.947482363135172*^9, {3.947493977977209*^9, 3.9474939853595448`*^9}},
 CellLabel->
  "In[146]:=",ExpressionUUID->"d0c5b345-9e88-e04a-9131-1e258249750e"]
}, Closed]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"cf60f297-bbcd-8748-b453-\
e7118b4e0a98"],

Cell[CellGroupData[{

Cell["QAP centers", "Subsection",
 CellChangeTimes->{{3.945853740709931*^9, 3.945853743438184*^9}, {
  3.9464394595455627`*^9, 
  3.9464394652171745`*^9}},ExpressionUUID->"c8cca55e-04f1-8f4a-b670-\
3c3179eed91e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP", "=", 
   RowBox[{"<|", 
    RowBox[{
     RowBox[{"1", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ",", 
        RowBox[{"p", "+", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ",", 
        RowBox[{"p", "+", "q", "+", 
         RowBox[{"2", " ", "r"}]}]}], "}"}]}], ",", 
     RowBox[{"2", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", "SB"}], "-", 
           RowBox[{"r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "SA"}], "+", 
           RowBox[{"r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "SA"}], "-", 
           RowBox[{"q", " ", "SB"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"3", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}]}], 
          ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", 
              RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"4", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", "SA"}], "-", 
           RowBox[{"2", " ", "p", " ", "q", " ", "SA"}], "-", 
           RowBox[{"2", " ", "p", " ", "r", " ", "SA"}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}]}], ")"}]}],
         ",", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p"}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q"}], "-", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}], 
             ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"5", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"6", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"q", " ", 
                SuperscriptBox["SB", "2"]}], "-", 
               RowBox[{"r", " ", 
                SuperscriptBox["SC", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"p", " ", 
                SuperscriptBox["SA", "2"]}], "-", 
               RowBox[{"r", " ", 
                SuperscriptBox["SC", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"p", " ", 
                SuperscriptBox["SA", "2"]}], "-", 
               RowBox[{"q", " ", 
                SuperscriptBox["SB", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"7", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SB", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 SuperscriptBox["SB", "2"], "+", 
                 RowBox[{"2", " ", "SB", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"2", " ", "SB", " ", "SC"}], "+", 
                 SuperscriptBox["SC", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"3", " ", "r", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"r", " ", "SC", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "SA"}], "+", "SC"}], ")"}]}], "+", 
              RowBox[{"p", " ", "SA", " ", 
               RowBox[{"(", 
                RowBox[{"SA", "+", 
                 RowBox[{"2", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SA", " ", "SC"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"3", " ", "q", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"q", " ", "SB", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "SA"}], "+", "SB"}], ")"}]}], "+", 
              RowBox[{"p", " ", "SA", " ", 
               RowBox[{"(", 
                RowBox[{"SA", "+", 
                 RowBox[{"2", " ", "SB"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SA", " ", "SB"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}],
        "}"}]}], ",", 
     RowBox[{"8", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "p"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "p"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "q"}], "+", 
            RowBox[{"4", " ", "r", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}]}], "}"}]}],
      ",", 
     RowBox[{"9", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p", " ", "q"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"]}], "+", 
                 RowBox[{"3", " ", "p", " ", "r"}], "+", 
                 RowBox[{"q", " ", "r"}], "-", 
                 SuperscriptBox["r", "2"]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "p", " ", "q"}], "-", 
                 SuperscriptBox["q", "2"], "+", 
                 RowBox[{"2", " ", "p", " ", "r"}], "+", 
                 RowBox[{"q", " ", "r"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "q"}], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"4", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "q"}], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "-", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"5", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"3", " ", "p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "8"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "8"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", 
                 RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"p", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
              "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"p", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"8", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"4", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["c", "6"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["p", "2"]}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "q", " ", 
                  SuperscriptBox["r", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"12", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"9", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["q", "3"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"12", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"13", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "r"}], "-", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["p", "2"], "-", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "6"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "q", " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"5", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "-", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["q", "2"], " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "3"}], " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  SuperscriptBox["q", "3"], " ", "r"}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  SuperscriptBox["r", "3"]}], "+", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["p", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"8", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "3"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"12", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["c", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["q", "2"]}]}], ")"}], " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "r"}], "-", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "6"]}], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["p", "2"]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["q", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"5", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "-", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["q", "2"], " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"8", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"6", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "3"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    RowBox[{"2", " ", "q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"12", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"13", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"9", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"10", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"11", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"12", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
          ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", "q", " ", "SB"}], "+", 
           RowBox[{"p", " ", "r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{"p", " ", "q", " ", "SA"}], "+", 
           RowBox[{"q", " ", "r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r", " ", "SA"}], "+", 
           RowBox[{"q", " ", "r", " ", "SB"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", "q", " ", 
            SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"13", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"14", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "r"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"5", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"2", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"2", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}]}], "}"}]}], 
     ",", 
     RowBox[{"15", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"q", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["q", "2"]}], "+", 
               RowBox[{"5", " ", "q", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"5", " ", "q", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["p", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["q", "2"]}], "+", 
               RowBox[{"22", " ", "q", " ", "r"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "p"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"5", " ", "p", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"5", " ", "p", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["q", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"22", " ", "p", " ", "r"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["q", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               SuperscriptBox["q", "2"]}], ")"}], " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "p"}], "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"5", " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"5", " ", "p", " ", "q"}], "+", 
               SuperscriptBox["q", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"5", " ", "p", " ", "q"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["q", "2"]}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"22", " ", "p", " ", "q"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["q", "2"]}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"10", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"16", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"17", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["q", "2"], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"18", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"19", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"20", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"21", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"22", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"23", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", "q", " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
         RowBox[{"p", " ", "q", " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
         RowBox[{"p", " ", "r", " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", "SB"}]}]}], "}"}]}], ",", 
     RowBox[{"24", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", "SB", " ", 
          "SC"}], "-", 
         RowBox[{"4", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "SC"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], ")"}], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", "SC"}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "SA", " ", 
          "SC"}], "-", 
         RowBox[{"4", " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "SC"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], ")"}], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", "SC"}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "SA", " ", 
          "SB"}], "-", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"25", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"2", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"26", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"5", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"5", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"5", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"27", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["p", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"], " ", "q"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"p", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{"q", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "3"]}], " ", "q"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           SuperscriptBox["q", "4"], "+", 
           RowBox[{
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"q", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["p", "3"], " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"2", " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           SuperscriptBox["r", "4"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"28", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "4"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["b", "2"], "-", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", "r"}]}], 
             ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "4"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["q", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "+", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", "r"}], "+", 
              RowBox[{
               SuperscriptBox["a", "4"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"3", " ", "q", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", 
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "+", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["a", "2"], "-", 
                   SuperscriptBox["b", "2"]}], ")"}], " ", "p", " ", "q"}], 
                "+", 
                RowBox[{
                 SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "4"], " ", "q", " ", "r"}]}], ")"}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"3", " ", "q", " ", "r"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
       "}"}]}], ",", 
     RowBox[{"29", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["a", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "3"], " ", "r"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["p", "2"]}], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"30", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "q"}], ")"}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "-", 
              RowBox[{"3", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "p"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"3", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "p"}], "+", "q"}], ")"}], " ", "r", 
            " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"3", " ", "q"}]}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
       "}"}]}], ",", 
     RowBox[{"31", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"32", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", "q", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}]}], "}"}]}],
      ",", 
     RowBox[{"33", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB", " ", 
             "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA", " ", 
             "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA", " ", 
             "SB"}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"34", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"4", " ", "q"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p"}], "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"35", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"15", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "3"], " ", "r"}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"5", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"15", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"12", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"5", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["p", "2"]}], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"15", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"15", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"12", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"36", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["c", "2"]}], " ", "q"}], "-", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "-", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q", " ", "r"}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
               RowBox[{
                SuperscriptBox["a", "4"], " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["b", "4"], " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["c", "2"]}], " ", "p"}], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "p"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "r"}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "4"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["c", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["b", "2"], " ", 
                SuperscriptBox["c", "2"], " ", "q", " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["b", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["c", "4"], " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "-", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "q"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}]}], ")"}]}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["b", "2"]}], " ", "p"}], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "4"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["c", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["a", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["c", "4"], " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "p"}], "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}]}], "}"}]}], ",", 
     RowBox[{"37", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"p", " ", "q", " ", "SB"}], "+", 
            RowBox[{"p", " ", "r", " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"p", " ", "q", " ", "SA"}], "+", 
            RowBox[{"q", " ", "r", " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r", " ", "SA"}], "+", 
            RowBox[{"q", " ", "r", " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"38", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["b", "2"]}], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "-", "q", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", "p"}], "+", "q", "+", "r"}], 
                ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", 
                 RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", 
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "q", "+", 
             RowBox[{"2", " ", "r"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "-", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "-", "q", "-", 
                   RowBox[{"2", " ", "r"}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "-", "q", "+", 
                   RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          ")"}]}]}], "}"}]}], ",", 
     RowBox[{"39", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["b", "2"], "-", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "-", "r"}], ")"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "+", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "p"}], "+", "r"}], ")"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               RowBox[{"2", " ", "p", " ", "r"}], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["a", "2"], "-", 
                 SuperscriptBox["b", "2"]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "q"}], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}]}], "}"}]}], ",", 
     RowBox[{"40", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], "+", 
            SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", 
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "p"}], "+", 
                   RowBox[{"2", " ", "q"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "q"}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["q", "2"]}]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", "p"}], "+", 
                  RowBox[{"2", " ", "q"}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "r", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", 
                  RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["p", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", "q"}], "+", 
                  RowBox[{"9", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["q", "2"]}], "+", 
                  RowBox[{"15", " ", "q", " ", "r"}], "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["a", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"9", " ", "p"}], "+", 
                  RowBox[{"7", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"12", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "r"}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "q"}], "+", 
                   RowBox[{"2", " ", "r"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["p", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", "q"}], "+", 
                  RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", 
                   SuperscriptBox["q", "2"]}], "+", 
                  RowBox[{"15", " ", "q", " ", "r"}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], "+", 
            SuperscriptBox["b", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", 
                  RowBox[{"2", " ", "q"}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "q"}], "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["q", "2"]}]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", "p"}], "+", 
                  RowBox[{"9", " ", "q"}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "p"}], "+", 
                   RowBox[{"3", " ", "r"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "p"}], "+", 
                  RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"6", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "r"}], "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"41", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "4"]}], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "4"]}], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"42", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q", " ", "r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "SB"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"43", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", "p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", "p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"44", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "q"}], "-", 
            RowBox[{"q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p", " ", "q"}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            SuperscriptBox["q", "3"], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            SuperscriptBox["r", "3"]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "3"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            SuperscriptBox["r", "3"]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "3"], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            SuperscriptBox["q", "3"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}]}], "|>"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945841589546528*^9, 3.945841604944151*^9}, {
   3.9458416486015606`*^9, 3.945841701130226*^9}, 3.94584180266897*^9, {
   3.945841855521532*^9, 3.945841865133842*^9}, {3.9458419743855267`*^9, 
   3.94584197851943*^9}, {3.945842012120521*^9, 3.945842016064451*^9}, {
   3.945842114756489*^9, 3.945842119338508*^9}, {3.945842170028664*^9, 
   3.945842174123476*^9}, {3.945842254968681*^9, 3.9458422593104534`*^9}, {
   3.94584246069957*^9, 3.945842465998068*^9}, {3.945842501032144*^9, 
   3.9458425325383263`*^9}, {3.945842735167492*^9, 3.945842742091593*^9}, {
   3.945842846919035*^9, 3.945842850061655*^9}, {3.945842936494915*^9, 
   3.945842969633366*^9}, {3.945843125849571*^9, 3.94584313274209*^9}, {
   3.945843174894972*^9, 3.945843178277809*^9}, {3.9458432197775517`*^9, 
   3.9458432370243473`*^9}, {3.945843287330616*^9, 3.9458432907977543`*^9}, {
   3.945843326923149*^9, 3.9458433430906563`*^9}, {3.945843384493232*^9, 
   3.945843387811741*^9}, {3.945843423557177*^9, 3.945843427076299*^9}, {
   3.9458460856414566`*^9, 3.9458460903603935`*^9}, {3.9458461244501*^9, 
   3.945846127392929*^9}, {3.945846273464027*^9, 3.945846279270181*^9}, {
   3.945846311960058*^9, 3.945846315350111*^9}, {3.945846366817175*^9, 
   3.945846382831234*^9}, {3.945846756353731*^9, 3.9458467662170296`*^9}, {
   3.945846811099188*^9, 3.945846841686339*^9}, {3.945846884211832*^9, 
   3.945847260236458*^9}, {3.945847371762398*^9, 3.9458473779483223`*^9}, {
   3.945847468577452*^9, 3.945847473866535*^9}, {3.9458476375888367`*^9, 
   3.945847641254919*^9}, {3.945847770316178*^9, 3.9458477741893463`*^9}, {
   3.94584781182493*^9, 3.9458478153183575`*^9}, {3.94584788583465*^9, 
   3.945847888720951*^9}, {3.94584794845273*^9, 3.9458479545306664`*^9}, {
   3.945848036235821*^9, 3.945848039850874*^9}, {3.945848209145437*^9, 
   3.945848213365254*^9}, {3.945848428704586*^9, 3.945848437990104*^9}, {
   3.945848526693582*^9, 3.945848534626331*^9}, {3.945848666528978*^9, 
   3.94584868269029*^9}, {3.945848775077949*^9, 3.945848778998434*^9}, {
   3.945848877398905*^9, 3.945848886629158*^9}, {3.9458491238654*^9, 
   3.945849128054989*^9}, {3.945849197156975*^9, 3.9458492011715355`*^9}, {
   3.9458492397412167`*^9, 3.945849244243763*^9}, 3.945849479846901*^9, {
   3.945851715909244*^9, 3.945851732617178*^9}, 3.945853235726444*^9, {
   3.945853633264748*^9, 3.9458536354922667`*^9}, {3.946058981146543*^9, 
   3.946058983238126*^9}, {3.946113816440451*^9, 3.946113833217655*^9}, 
   3.946113923272053*^9, 3.9462998579964046`*^9},
 CellLabel->
  "In[147]:=",ExpressionUUID->"90297db1-2eea-6346-9338-a3e8dcfe0024"]
}, Closed]],

Cell[CellGroupData[{

Cell["QAP constructions", "Subsection",
 CellChangeTimes->{{3.946258018000845*^9, 3.9462580514460297`*^9}, {
  3.946439582465828*^9, 
  3.94643958360841*^9}},ExpressionUUID->"79ef6085-3de7-3c49-8561-\
f943fbd2d431"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP1", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258220966779*^9, 3.946258253166219*^9}},
 CellLabel->
  "In[148]:=",ExpressionUUID->"e725b315-4161-274c-8798-a4e0c807d6a8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP2", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"PonceletPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258127112749*^9, 3.946258205014044*^9}},
 CellLabel->
  "In[149]:=",ExpressionUUID->"60fea3de-a36e-734d-b67f-75eab8f36838"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP3", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258267006763*^9, 3.946258272798765*^9}},
 CellLabel->
  "In[150]:=",ExpressionUUID->"422bd8e2-a85e-d748-b542-6c9b62c11efd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP4", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsogonal", "[", 
        RowBox[{"P", ",", 
         RowBox[{"{", 
          RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsogonal", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"{", 
          RowBox[{"P", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258285271057*^9, 3.946258529254532*^9}, {
  3.946258821686931*^9, 3.946258862614427*^9}},
 CellLabel->
  "In[151]:=",ExpressionUUID->"d021f1ab-c58d-b74b-8aa5-a62365464cc5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP5", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsotomico", "[", 
        RowBox[{"P", ",", 
         RowBox[{"{", 
          RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", "P"}], 
      "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsotomico", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"{", 
          RowBox[{"P", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", "Q"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946552139912605*^9, 3.946552177047758*^9}},
 CellLabel->
  "In[152]:=",ExpressionUUID->"023d4850-e194-b941-a762-4c9a532e11d1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP6", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Medio", "[", 
    RowBox[{
     RowBox[{"QAP2", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}], ",", 
     RowBox[{"QAP4", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946554002925066*^9, 3.946554042045203*^9}},
 CellLabel->
  "In[153]:=",ExpressionUUID->"62ef2468-c328-714d-8bf7-299b142a086d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP7", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Q1", ",", "Q2", ",", "Q3", ",", "Q4", ",", "R1", ",", "R2"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Q1", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q2", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q3", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q4", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R1", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q2", ",", "Q3", ",", "Q4"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R2", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q1", ",", "Q3", ",", "Q4"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R1"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R2"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946258285271057*^9, 3.946258529254532*^9}, {
  3.946258821686931*^9, 3.946258862614427*^9}, {3.946290848591799*^9, 
  3.946291021534954*^9}, {3.946291111031261*^9, 3.946291120455242*^9}, {
  3.946696200711548*^9, 3.946696200806263*^9}},
 CellLabel->
  "In[154]:=",ExpressionUUID->"d734f707-6812-364b-b359-ac3a6bb66e72"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MiquelPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"U", ",", "V", ",", "O1", ",", "O2"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"U", "=", 
       RowBox[{"Punto", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "Q"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"V", "=", 
       RowBox[{"Punto", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "S"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"O1", "=", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "S", ",", "U"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"O2", "=", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"R", ",", "S", ",", "V"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimetriaAxial", "[", 
       RowBox[{"S", ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"O1", ",", "O2"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]",
     "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946294457093628*^9, 3.946294688202664*^9}, {
   3.9462961458488*^9, 3.9462961471441994`*^9}, 3.9462963028076897`*^9, {
   3.9462973681984005`*^9, 3.946297370950136*^9}},
 CellLabel->
  "In[155]:=",ExpressionUUID->"34f7e383-98aa-bc47-9867-166186424dd4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MiquelCircle", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"U", ",", "V", ",", "W", ",", "O1", ",", "O2", ",", "O3"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"U", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"V", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O1", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "S", ",", "U"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O2", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"R", ",", "S", ",", "V"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O3", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"Q", ",", "R", ",", "U"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CircunferenciaTresPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"O1", ",", "O2", ",", "O3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946295931650831*^9, 3.9462959921519623`*^9}, {
  3.9462960978401566`*^9, 3.946296126960247*^9}, {3.946296309416164*^9, 
  3.946296387663599*^9}, {3.946296507206955*^9, 3.946296515015978*^9}, {
  3.9462965951590157`*^9, 3.9462966339272327`*^9}},
 CellLabel->
  "In[156]:=",ExpressionUUID->"4370c731-693f-a941-82c8-1f6a14f724b2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP8", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"SimetriaCentral", "[", 
    RowBox[{
     RowBox[{"QAP4", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}], ",", 
     RowBox[{"QAP2", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946554262541748*^9, 3.946554276084837*^9}},
 CellLabel->
  "In[157]:=",ExpressionUUID->"6e2024d9-4541-ea4e-a308-49a8bb9b87a5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP9", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c1", ",", "c2", ",", "c3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"c1", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c2", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "Q", ",", "S", ",", "R"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c3", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "R", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CentroRadical", "[", 
      RowBox[{"c1", ",", "c2", ",", "c3"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9462975678957386`*^9, 3.94629768995805*^9}},
 CellLabel->
  "In[158]:=",ExpressionUUID->"384fc915-4ebd-5342-9174-a166a5e7f52d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP10", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Baricentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946554372389721*^9, 3.94655438207695*^9}},
 CellLabel->
  "In[159]:=",ExpressionUUID->"e878baba-ea71-dd4f-b972-2e4c3753c774"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP11", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Circuncentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946554416053346*^9, 3.946554423653038*^9}},
 CellLabel->
  "In[160]:=",ExpressionUUID->"4200ee2b-abeb-b246-85fa-68f1ce5d836b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP12", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->
  "In[161]:=",ExpressionUUID->"8131db8a-5012-e741-93f3-ec6da52923f1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP34", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"P1", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P2", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P3", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P4", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"QAP2", "[", 
       RowBox[{"{", 
        RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946362022452154*^9, 3.9463621697479362`*^9}},
 CellLabel->
  "In[162]:=",ExpressionUUID->"3e5eb206-464c-7e4f-b628-98c50c5a4629"]
}, Closed]],

Cell[CellGroupData[{

Cell["Auxiliary functions", "Subsection",
 CellChangeTimes->{
  3.818667972143658*^9, {3.8186680382464933`*^9, 3.818668041714528*^9}, {
   3.818668136826049*^9, 3.818668143553762*^9}, {3.818685183717651*^9, 
   3.818685185711126*^9}},ExpressionUUID->"d004e03f-8f12-9a43-865f-\
339812029417"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"EqualPointsQ", "[", 
      RowBox[{"ptP_", ",", "ptQ_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cross", "[", 
           RowBox[{"ptP", ",", "ptQ"}], "]"}], "/.", "sustS"}], "/.", 
         "sustC"}], ",", "cond"}], "]"}], "===", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.947132996916015*^9, 3.9471330125155983`*^9}, {
  3.947133479684403*^9, 3.947133480044634*^9}},
 CellLabel->
  "In[163]:=",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],

Cell[CellGroupData[{

Cell["Quadrilateral routines", "Subsection",
 CellChangeTimes->{{3.945509919017998*^9, 
  3.945509932600797*^9}},ExpressionUUID->"2a49be25-3c4e-430e-86c6-\
869880736f30"],

Cell[CellGroupData[{

Cell["Vertex centroid", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.947132319963703*^9, 
  3.947132328106987*^9}},ExpressionUUID->"a576f9af-1f5b-4213-b4d3-\
e7b66981337e"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3Qd8FGX+P3D+v7v7nb+zAPZTT7EgoJyn56moZ0fQKBq6dIggATVSgmBo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    "], {{0, 389.2075471698113}, {491.0943396226415, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{491.0943396226415, 389.2075471698113},
  PlotRange->{{0, 491.0943396226415}, {0, 389.2075471698113}}]], "Text",
 CellChangeTimes->{
  3.945509787103263*^9},ExpressionUUID->"f7950398-57cb-4ee6-bf14-\
597b39eb91df"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"P", ",", "Q"}], "]"}], ",", 
       RowBox[{"Medio", "[", 
        RowBox[{"R", ",", "S"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"P", ",", "S"}], "]"}], ",", 
       RowBox[{"Medio", "[", 
        RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
  3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
  3.9455136200666037`*^9}, {3.946439211017157*^9, 3.946439211737526*^9}},
 CellLabel->
  "In[167]:=",ExpressionUUID->"cf738f77-0d96-4e62-81a0-f2a504594dc8"]
}, Closed]],

Cell[CellGroupData[{

Cell["Poncelet point", "Subsubsection",
 CellChangeTimes->{{3.945509682961616*^9, 3.945509705247427*^9}, {
   3.945516718286007*^9, 3.945516720220911*^9}, 
   3.947132291355841*^9},ExpressionUUID->"f7957972-a4e9-446f-bafd-\
6774f0dd3699"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "PuntoDePoncelet", " ", "is", " ", "implemented", " ", "in", " ", "the", 
    " ", "baricentricas", " ", "package"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"PonceletPoint", "[", 
     RowBox[{"{", 
      RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
    RowBox[{"PuntoDePoncelet", "[", 
     RowBox[{"P", ",", 
      RowBox[{"{", 
       RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.945506298668439*^9, 3.9455064957646704`*^9}, {
  3.945508100242526*^9, 3.945508119954049*^9}, {3.9455093671686244`*^9, 
  3.945509538952415*^9}, {3.9455167413982186`*^9, 3.945516826125304*^9}},
 CellLabel->
  "In[168]:=",ExpressionUUID->"44de57fd-6e7d-4d98-94a0-c7b93947eadd"]
}, Closed]],

Cell[CellGroupData[{

Cell["Steiner point", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.947132277507908*^9, 
  3.947132283924074*^9}},ExpressionUUID->"ae32c2db-9871-344f-aabd-\
a2543db56100"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "X", ",", "Y", ",", "Z", ",", "T", ",", "U", ",", "V", ",", "W"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"X", ",", "Y", ",", "Z", ",", "U", ",", "T"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Apply", "[", 
          RowBox[{"Medio", ",", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"P", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"R", ",", "Q"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "R"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"S", ",", "Q"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"V", ",", "W"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Circuncentro", "[", "#", "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"X", ",", "Y", ",", "U"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Y", ",", "Z", ",", "T"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimetriaAxial", "[", 
       RowBox[{"Y", ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"V", ",", "W"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945506298668439*^9, 3.9455064957646704`*^9}, {
  3.945508100242526*^9, 3.945508119954049*^9}, {3.9455093671686244`*^9, 
  3.945509538952415*^9}, {3.945518206235336*^9, 3.945518260181164*^9}, {
  3.945518437370175*^9, 3.9455184493471375`*^9}, {3.947132243612131*^9, 
  3.947132244379742*^9}},
 CellLabel->
  "In[169]:=",ExpressionUUID->"db0fcba9-9144-4df7-981b-db22bb466a6e"]
}, Closed]],

Cell[CellGroupData[{

Cell["Diagonal point", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
   3.945521331783347*^9, 3.9455213360947638`*^9}, 
   3.947132343027188*^9},ExpressionUUID->"29f12ada-9fd0-4747-b323-\
2cf96d6fb52e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"P", ",", "R"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
  3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
  3.9455136200666037`*^9}, {3.945521346455207*^9, 3.9455213813107405`*^9}},
 CellLabel->
  "In[170]:=",ExpressionUUID->"158fb412-c771-43ab-b43b-a357380f4a11"]
}, Closed]],

Cell[CellGroupData[{

Cell["Central quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.9464416787367783`*^9, 3.946441687230852*^9}, 
   3.947147898383025*^9},ExpressionUUID->"5a543829-5641-9144-8dd0-\
57eb7cf1938d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentralQuadrilateral", "[", "n_", "]"}], ":=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptB", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}]}], "]"}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellLabel->
  "In[171]:=",ExpressionUUID->"35cb8ff3-829e-654a-a95d-e2c972de6be9"]
}, Closed]],

Cell[CellGroupData[{

Cell["Area of a quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 
  3.945509840152308*^9}},ExpressionUUID->"e039afe9-d89d-4ec4-94b9-\
ddb3f9f259e0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AreaQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"AreaTriangulo", "[", 
     RowBox[{"{", 
      RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}], "+", 
    RowBox[{"AreaTriangulo", "[", 
     RowBox[{"{", 
      RowBox[{"R", ",", "S", ",", "P"}], "}"}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945518557002711*^9, 3.945518607763227*^9}},
 CellLabel->
  "In[172]:=",ExpressionUUID->"2db3c5dc-e4da-4371-937a-22cb108c81e1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Perspective quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945619500071995*^9, 3.9456195111611595`*^9}, {
   3.94561961722077*^9, 3.945619628845907*^9}, {3.945620201468649*^9, 
   3.945620207996176*^9}, {3.946093948975952*^9, 3.946093951552325*^9}, 
   3.94619393871496*^9, 
   3.947147899655007*^9},ExpressionUUID->"bd16b166-d506-5544-b5d0-\
7aa6edfca35b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PerspectiveQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "P2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"R1", ",", "R2"}], "]"}]}], "}"}], "]"}], "==", "0"}], "&&", 
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "P2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"S1", ",", "S2"}], "]"}]}], "}"}], "]"}], "==", 
    "0"}]}]}]], "Input",
 CellChangeTimes->{{3.945619541933253*^9, 3.945619598797678*^9}, {
  3.945620227236483*^9, 3.945620398996369*^9}, {3.946093956887635*^9, 
  3.9460940140877304`*^9}, {3.9460946192084503`*^9, 3.9460946637685833`*^9}},
 CellLabel->
  "In[173]:=",ExpressionUUID->"6cd12b17-ccf6-1f40-8216-e746f72a898c"]
}, Closed]],

Cell[CellGroupData[{

Cell["Similar and homothetic quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 3.945509840152308*^9}, {
  3.945518917754542*^9, 3.945518929298341*^9}, {3.94551954978488*^9, 
  3.945519554745524*^9}, {3.9471326902197247`*^9, 3.9471326941873684`*^9}, {
  3.947132774954735*^9, 
  3.947132785771118*^9}},ExpressionUUID->"d546f79d-5ed9-4f99-846e-\
3ac1a3756b86"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SimilarQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SonSemejantes", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "Q1", ",", "R1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"P2", ",", "Q2", ",", "R2"}], "}"}]}], "]"}], "&&", 
    RowBox[{"SonSemejantes", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Q1", ",", "R1", ",", "S1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q2", ",", "R2", ",", "S2"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945518557002711*^9, 3.945518607763227*^9}, {
  3.9455189375627*^9, 3.945519039097607*^9}, {3.945519562008997*^9, 
  3.945519564865857*^9}},
 CellLabel->
  "In[174]:=",ExpressionUUID->"5668c7c2-b2f3-48b4-bb4e-3f493e46ab9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SonHomoteticos", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "Q1", ",", "R1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"P2", ",", "Q2", ",", "R2"}], "}"}]}], "]"}], "&&", 
    RowBox[{"SonHomoteticos", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Q1", ",", "R1", ",", "S1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q2", ",", "R2", ",", "S2"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.9455195703380117`*^9, 3.945519605171223*^9}},
 CellLabel->
  "In[175]:=",ExpressionUUID->"d07dfa48-d9b6-433c-9d4d-8f2532f1bec3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Congruent quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945619500071995*^9, 3.9456195111611595`*^9}, {
   3.94561961722077*^9, 3.945619628845907*^9}, {3.945620201468649*^9, 
   3.945620207996176*^9}, 3.946437820730978*^9, 
   3.9471479009831057`*^9},ExpressionUUID->"8f461d45-0647-c84b-9fe0-\
f72d3601c63f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CongruentQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P1", ",", "Q1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P2", ",", "Q2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"Q1", ",", "R1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"Q2", ",", "R2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"R1", ",", "S1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"R2", ",", "S2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"S1", ",", "P1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"S2", ",", "P2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P1", ",", "R1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P2", ",", "R2"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945619541933253*^9, 3.945619598797678*^9}, {
  3.945620227236483*^9, 3.945620398996369*^9}, {3.946287549140295*^9, 
  3.946287549827748*^9}},
 CellLabel->
  "In[176]:=",ExpressionUUID->"5485ed32-34f6-e64e-bd2a-b4e163c2b97f"]
}, Closed]],

Cell[CellGroupData[{

Cell["Orthogonal quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.946437760717503*^9, 3.9464377702703495`*^9}, 
   3.947147903551467*^9},ExpressionUUID->"54169a90-c35c-7a4a-a37f-\
78c9753e8eeb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OrthogonalQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "Q1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"P2", ",", "Q2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "R1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q2", ",", "R2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"R1", ",", "S1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"R2", ",", "S2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"S1", ",", "P1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"S2", ",", "P2"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9455195703380117`*^9, 3.945519605171223*^9}, {
  3.9460039858449364`*^9, 3.946003994260566*^9}, {3.946004044908913*^9, 
  3.946004131276815*^9}, {3.946004174101141*^9, 3.946004205589377*^9}},
 CellLabel->
  "In[177]:=",ExpressionUUID->"c1bc4c8d-1ecd-654a-b9e2-f902b4037dfa"]
}, Closed]],

Cell[CellGroupData[{

Cell["Conconic quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.946188760871956*^9, 3.946188779525741*^9}, {
  3.9464378271237335`*^9, 
  3.946437830963283*^9}},ExpressionUUID->"e126572d-bdab-a047-b925-\
c2661290f09e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "returns", " ", "TRUE", " ", "if", " ", "ABCD", " ", "and", " ", "EFGH", 
    " ", "are", " ", "conconic"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"conconicQuadQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA_", ",", "ptB_", ",", "ptC_", ",", "ptD_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE_", ",", "ptF_", ",", "ptG_", ",", "ptH_"}], "}"}]}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "conic", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"conic", "=", 
        RowBox[{"ConicaCincoPuntos", "[", 
         RowBox[{"{", 
          RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD", ",", "ptE"}], 
          "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sustituirxyz", "[", 
            RowBox[{"conic", ",", "#"}], "]"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{"ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], "==", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.946440275192674*^9, 3.946440364775547*^9}, {
  3.946557553720074*^9, 3.94655756021654*^9}},
 CellLabel->
  "In[178]:=",ExpressionUUID->"3eac6f83-9820-5d4f-9acd-4f2df1b13510"]
}, Closed]],

Cell[CellGroupData[{

Cell["Find QA center", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 3.945509840152308*^9}, {
  3.945518917754542*^9, 3.945518929298341*^9}, {3.94551954978488*^9, 
  3.945519554745524*^9}, {3.946186993811855*^9, 
  3.946187000755444*^9}},ExpressionUUID->"1d12da59-37f1-9842-ad9c-\
eb916041816f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "findQACenter", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"findQACenter", "[", 
    RowBox[{"ptP_", ",", 
     RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"found", "=", "0"}], ",", "sustCS", ",", 
       RowBox[{"nc", "=", 
        RowBox[{"Length", "[", "QAP", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sustCS", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"sustS", ",", "sustC"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Monitor", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "<=", "nc"}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"Simplify", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Cross", "[", 
                   RowBox[{"ptP", ",", 
                    RowBox[{"QAP", "[", "i", "]"}]}], "]"}], "//.", 
                  "sustCS"}], ",", "cond"}], "]"}], ")"}], "==", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
             RowBox[{
              RowBox[{"found", "=", "i"}], ";", 
              RowBox[{"Break", "[", "]"}]}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<Identifying the center... \>\"", ",", 
           RowBox[{"ProgressIndicator", "[", 
            RowBox[{"i", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "nc"}], "}"}]}], "]"}], ",", "\"\< \>\"", ",",
            "i", ",", "\"\</\>\"", ",", "nc"}], "}"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"found", "==", "0"}], ",", "\"\<unknown\>\"", ",", 
        RowBox[{"\"\<QA-P\>\"", "<>", 
         RowBox[{"ToString", "[", "found", "]"}]}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.946187173054329*^9, 3.946187213931603*^9}, {
   3.946187246486248*^9, 3.9461872843092823`*^9}, 3.946187365054121*^9, {
   3.946187480278492*^9, 3.9461874874540024`*^9}, 3.9461880462086487`*^9, {
   3.9461881054797783`*^9, 3.9461881291423397`*^9}, {3.946188268454359*^9, 
   3.9461883008316956`*^9}, {3.94618835627853*^9, 3.946188455318756*^9}, 
   3.946257761266403*^9, {3.946258916015583*^9, 3.94625896478343*^9}, {
   3.946259615877109*^9, 3.946259655534961*^9}, {3.947132891348004*^9, 
   3.947132924188181*^9}, {3.9471329718839912`*^9, 3.9471329845888424`*^9}, {
   3.947133025988367*^9, 3.94713303106756*^9}, {3.9471334511324444`*^9, 
   3.94713348841169*^9}},
 CellLabel->
  "In[179]:=",ExpressionUUID->"806c98e7-c027-de46-8fc2-cc2eda959f64"]
}, Closed]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Properties ", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 
  3.946441726397751*^9}},ExpressionUUID->"2609bf4c-7f5c-314e-a744-\
f86d4be283dd"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvV9MW1fa/+tzfjfnYl8cLrmIlCNkiYtIVYWQfomikX1B1MoSRI0QCkXI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    "], {{0, 211.92452830188677`}, {484.9811320754717, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{484.9811320754717, 211.92452830188677`},
  PlotRange->{{0, 484.9811320754717}, {0, 211.92452830188677`}}]], "Text",
 CellChangeTimes->{
  3.946440201275278*^9, 3.947481441080046*^9, 3.9474823186352863`*^9, {
   3.9474940454153843`*^9, 
   3.9474940539954433`*^9}},ExpressionUUID->"20c7ab22-8503-fd4d-9d34-\
15585b88ac29"],

Cell[CellGroupData[{

Cell["X (13) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, {
   3.9464610917155704`*^9, 3.9464611026600075`*^9}, 3.9464755653200665`*^9, {
   3.946476149223778*^9, 3.946476151423614*^9}, 3.946476294286831*^9, {
   3.9464874584475737`*^9, 3.946487462816326*^9}, 
   3.9474940815106525`*^9},ExpressionUUID->"db3e31cc-0570-9d4c-8a3d-\
de0271c7746a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "13", "]"}]}]], "Input",
 CellChangeTimes->{3.947494090302723*^9},
 CellLabel->
  "In[181]:=",ExpressionUUID->"ca44ed3d-52c9-0e4b-bd50-62c3f35c4d61"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{"6", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["b", "2"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"2", " ", 
           SqrtBox["3"], " ", "S"}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"7", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947494091063757*^9},
 CellLabel->
  "Out[181]=",ExpressionUUID->"99dbdb60-8b1e-1d40-8233-e6dc3435998e"]
}, Open  ]],

Cell["[ABCD]=3[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946461158294985*^9, 3.946461160123913*^9}, 
   3.946475582867805*^9, {3.946487469952313*^9, 
   3.9464874813913975`*^9}},ExpressionUUID->"a547a802-ecb9-1041-a3a4-\
19319b3e85b4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Numerator", "[", 
     RowBox[{"Factor", "[", 
      RowBox[{
       RowBox[{"AreaQuad", "[", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], 
       "-", 
       RowBox[{"3", 
        RowBox[{"AreaQuad", "[", 
         RowBox[{"{", 
          RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], 
         "]"}]}]}], "]"}], "]"}], "/.", "sustS"}], ",", "rhombus"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.946475753103716*^9, 3.946475755984558*^9}, {
  3.946487489224434*^9, 3.9464874917522564`*^9}, {3.9464879763518333`*^9, 
  3.9464879770962105`*^9}, {3.9474940873525333`*^9, 3.9474940930550823`*^9}},
 CellLabel->
  "In[182]:=",ExpressionUUID->"4e33e18e-b764-cc4c-99d8-a3be99736348"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9464757569541473`*^9, 3.9464757718265495`*^9}, 
   3.9464876738616314`*^9, 3.946487978288828*^9, 3.9474940960541134`*^9},
 CellLabel->
  "Out[182]=",ExpressionUUID->"59076b03-a83c-0f4f-84cd-b45eaf8059ed"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (14) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, {
   3.9464610917155704`*^9, 3.9464611026600075`*^9}, 3.9464755653200665`*^9, {
   3.946476149223778*^9, 3.946476151423614*^9}, 3.946476294286831*^9, {
   3.9464874584475737`*^9, 3.946487462816326*^9}, 
   3.9474941059816666`*^9},ExpressionUUID->"92c60775-7ca3-4947-b746-\
079da942726b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "14", "]"}]}]], "Input",
 CellChangeTimes->{{3.9474941154148293`*^9, 3.947494116694456*^9}},
 CellLabel->
  "In[183]:=",ExpressionUUID->"ee1c21c3-95e8-7644-aa8a-38a41361b0fc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"11", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["b", "2"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"2", " ", 
           SqrtBox["3"], " ", "S"}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"7", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947494117653145*^9},
 CellLabel->
  "Out[183]=",ExpressionUUID->"414a2f4c-208c-1749-87e4-fa6ac54a644f"]
}, Open  ]],

Cell["[ABCD]=3[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946461158294985*^9, 3.946461160123913*^9}, 
   3.946475582867805*^9, {3.946487469952313*^9, 
   3.9464874813913975`*^9}},ExpressionUUID->"c3e0a4d6-1f2f-264b-b0f2-\
85231be0d988"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Numerator", "[", 
     RowBox[{"Factor", "[", 
      RowBox[{
       RowBox[{"AreaQuad", "[", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], 
       "-", 
       RowBox[{"3", 
        RowBox[{"AreaQuad", "[", 
         RowBox[{"{", 
          RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], 
         "]"}]}]}], "]"}], "]"}], "/.", "sustS"}], ",", "rhombus"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.946475753103716*^9, 3.946475755984558*^9}, {
  3.946487489224434*^9, 3.9464874917522564`*^9}, {3.9464879763518333`*^9, 
  3.9464879770962105`*^9}, {3.9474941127599983`*^9, 3.9474941195019245`*^9}},
 CellLabel->
  "In[184]:=",ExpressionUUID->"7d573faa-d3e5-254e-8971-a47fb9b38417"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9464757569541473`*^9, 3.9464757718265495`*^9}, 
   3.9464876738616314`*^9, 3.946487978288828*^9, 3.9474941201082478`*^9},
 CellLabel->
  "Out[184]=",ExpressionUUID->"eec9a72d-101f-1c45-a9b1-028d3acae950"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (290)", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, {
   3.9464610917155704`*^9, 3.9464611321713753`*^9}, 3.946475602754768*^9, {
   3.946476857109905*^9, 3.946476858142927*^9}, {3.946488004487486*^9, 
   3.946488008863096*^9}, 3.946488105936834*^9, 
   3.9474943406295376`*^9},ExpressionUUID->"6fbe65de-d60d-3548-8446-\
54fd411b102f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "290", "]"}]}]], "Input",
 CellChangeTimes->{3.94749435100601*^9},
 CellLabel->
  "In[189]:=",ExpressionUUID->"abf68f74-0add-5249-aeef-d87332203cbf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "4"]}], "+", 
          SuperscriptBox["b", "4"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "4"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "4"]}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["a", "4"]}], "+", 
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["b", "2"]}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], "2"]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         SuperscriptBox["c", "4"], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "+", 
            SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], "2"]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "4"]}], "-", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "4"]}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "4"], "+", 
         SuperscriptBox["b", "4"], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"]}], "+", 
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", 
             SuperscriptBox["b", "2"]}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], "2"]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "4"]}], "-", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "4"]}], "-", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.947494351754074*^9},
 CellLabel->
  "Out[189]=",ExpressionUUID->"87a8cce9-4891-d143-a07a-0f45e8ceccf6"]
}, Open  ]],

Cell["[ABCD]=9[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946461171158417*^9, 3.946461174443907*^9}, 
   3.946475613161922*^9, 3.946477093094621*^9, {3.9464880234319763`*^9, 
   3.9464880258399277`*^9}, {3.9464880829600697`*^9, 
   3.9464880830153637`*^9}},ExpressionUUID->"66db4db0-b263-df42-83fa-\
2b9e53d5d99b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Numerator", "[", 
     RowBox[{"Factor", "[", 
      RowBox[{
       RowBox[{"AreaQuad", "[", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], 
       "-", 
       RowBox[{"9", 
        RowBox[{"AreaQuad", "[", 
         RowBox[{"{", 
          RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], 
         "]"}]}]}], "]"}], "]"}], "/.", "sustS"}], ",", "rhombus"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.946475753103716*^9, 3.946475755984558*^9}, {
  3.946487489224434*^9, 3.9464874917522564`*^9}, {3.9464879763518333`*^9, 
  3.9464879770962105`*^9}, {3.946488048344164*^9, 3.946488053079422*^9}, {
  3.9464881130479527`*^9, 3.946488120326805*^9}, {3.9474943490394382`*^9, 
  3.947494356294546*^9}},
 CellLabel->
  "In[190]:=",ExpressionUUID->"4f8294d3-4387-fb48-9e8b-537fe011f6b4"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9464757569541473`*^9, 3.9464757718265495`*^9}, 
   3.9464876738616314`*^9, 3.946487978288828*^9, 3.946488053955501*^9, 
   3.946488121081962*^9, 3.94749436598452*^9},
 CellLabel->
  "Out[190]=",ExpressionUUID->"6d72f4d2-5a80-5d49-b334-9cd4fbc65e0d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (402)", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, {
   3.9464610917155704`*^9, 3.9464611321713753`*^9}, 3.946475602754768*^9, {
   3.946476857109905*^9, 3.946476858142927*^9}, {3.946488004487486*^9, 
   3.946488008863096*^9}, 
   3.9474942540454617`*^9},ExpressionUUID->"3bacdd8a-6bc4-cf45-9449-\
0b6a098c6b09"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "402", "]"}]}]], "Input",
 CellChangeTimes->{3.947494250469843*^9},
 CellLabel->
  "In[185]:=",ExpressionUUID->"7156365f-ddb4-194e-9554-73894e89ea5d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"21", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"7", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"11", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"51", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"62", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"39", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"83", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"49", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"7", " ", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "19"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"35", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"18", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"65", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"60", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "7"}], " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"37", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"65", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"35", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"29", " ", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "77"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"133", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"11", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"70", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"231", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"184", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "25"}], " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"115", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"167", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"77", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"7", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["b", "4"]}], "+", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "8"], "+", 
          RowBox[{
           SuperscriptBox["a", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "4"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "4"], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "2"]}], "-", 
             SuperscriptBox["c", "4"]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "6"], "-", 
             RowBox[{"5", " ", 
              SuperscriptBox["b", "4"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "4"]}], "+", 
             SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "4"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"9", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"9", " ", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "29"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"77", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"19", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"29", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"34", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"167", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"184", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "17"}], " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"115", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"231", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"133", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"7", " ", 
           SuperscriptBox["a", "8"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "19"}], " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"35", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "4"], "-", 
             RowBox[{"5", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"7", " ", 
              SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"18", " ", 
              SuperscriptBox["b", "4"]}], "-", 
             RowBox[{"65", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"60", " ", 
              SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "7"}], " ", 
              SuperscriptBox["b", "6"]}], "+", 
             RowBox[{"37", " ", 
              SuperscriptBox["b", "4"], " ", 
              SuperscriptBox["c", "2"]}], "-", 
             RowBox[{"65", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "4"]}], "+", 
             RowBox[{"35", " ", 
              SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"11", " ", 
         SuperscriptBox["a", "8"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "29"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"49", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"26", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"83", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"62", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "4"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "4"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9474942557293434`*^9},
 CellLabel->
  "Out[185]=",ExpressionUUID->"b40b9d0a-1010-c743-b28f-7b86b33a56c0"]
}, Open  ]],

Cell["[ABCD]=4[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946461171158417*^9, 3.946461174443907*^9}, 
   3.946475613161922*^9, 3.946477093094621*^9, {3.9464880234319763`*^9, 
   3.9464880258399277`*^9}},ExpressionUUID->"96fbab32-10ae-cf40-9738-\
8db78fa91ed3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Numerator", "[", 
     RowBox[{"Factor", "[", 
      RowBox[{
       RowBox[{"AreaQuad", "[", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], 
       "-", 
       RowBox[{"4", 
        RowBox[{"AreaQuad", "[", 
         RowBox[{"{", 
          RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], 
         "]"}]}]}], "]"}], "]"}], "/.", "sustS"}], ",", "rhombus"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.946475753103716*^9, 3.946475755984558*^9}, {
  3.946487489224434*^9, 3.9464874917522564`*^9}, {3.9464879763518333`*^9, 
  3.9464879770962105`*^9}, {3.946488048344164*^9, 3.946488053079422*^9}, {
  3.9474942469762993`*^9, 3.9474942590697117`*^9}},
 CellLabel->
  "In[186]:=",ExpressionUUID->"a2382154-998d-3648-b1d6-6c070e23de83"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9464757569541473`*^9, 3.9464757718265495`*^9}, 
   3.9464876738616314`*^9, 3.946487978288828*^9, 3.946488053955501*^9, 
   3.9474942597925625`*^9},
 CellLabel->
  "Out[186]=",ExpressionUUID->"64ca8677-9818-734e-b7ff-1103a1323464"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (446)", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, {
   3.9464610917155704`*^9, 3.9464611321713753`*^9}, 3.946475602754768*^9, {
   3.946476857109905*^9, 3.946476858142927*^9}, {3.946488004487486*^9, 
   3.946488008863096*^9}, 3.946488105936834*^9, {3.9464882207430763`*^9, 
   3.94648822130319*^9}},ExpressionUUID->"cd2a4b57-8e7c-a045-9b26-\
5cd6e13f81b3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "446", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.947494492901287*^9, 3.947494496509823*^9}},
 CellLabel->
  "In[196]:=",ExpressionUUID->"254389c5-ac2f-2a43-87ed-5a7559ae416f"],

Cell["[EFGH]=4[ABCD]", "Subsubsection",
 CellChangeTimes->{{3.946461171158417*^9, 3.946461174443907*^9}, 
   3.946475613161922*^9, 3.946477093094621*^9, {3.9464880234319763`*^9, 
   3.9464880258399277`*^9}, {3.9464880829600697`*^9, 
   3.9464880830153637`*^9}, {3.9464882329911766`*^9, 
   3.94648823951071*^9}},ExpressionUUID->"1451f0d6-c6e8-bd49-8ce7-\
3ebbd1dc539a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Numerator", "[", 
     RowBox[{"Factor", "[", 
      RowBox[{
       RowBox[{"AreaQuad", "[", 
        RowBox[{"{", 
         RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], 
       "-", 
       RowBox[{"4", 
        RowBox[{"AreaQuad", "[", 
         RowBox[{"{", 
          RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], 
         "]"}]}]}], "]"}], "]"}], "/.", "sustS"}], ",", "rhombus"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.946475753103716*^9, 3.946475755984558*^9}, {
  3.946487489224434*^9, 3.9464874917522564`*^9}, {3.9464879763518333`*^9, 
  3.9464879770962105`*^9}, {3.946488048344164*^9, 3.946488053079422*^9}, {
  3.9464881130479527`*^9, 3.946488120326805*^9}, {3.946488261000618*^9, 
  3.946488290575777*^9}, {3.947494491008152*^9, 3.9474944986614933`*^9}},
 CellLabel->
  "In[197]:=",ExpressionUUID->"37199edf-6669-5f47-8608-654fd50ffa94"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9464757569541473`*^9, 3.9464757718265495`*^9}, 
   3.9464876738616314`*^9, 3.946487978288828*^9, 3.946488053955501*^9, 
   3.946488121081962*^9, {3.946488273643266*^9, 3.946488291663225*^9}, 
   3.9474944993525047`*^9},
 CellLabel->
  "Out[197]=",ExpressionUUID->"41223239-4906-6048-8edc-69061de34903"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (620)", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, {
   3.9464610917155704`*^9, 3.9464611321713753`*^9}, 3.946475602754768*^9, {
   3.946476857109905*^9, 3.946476858142927*^9}, {3.946488004487486*^9, 
   3.946488008863096*^9}, 3.9474942540454617`*^9, {3.9474942942859287`*^9, 
   3.947494295029913*^9}},ExpressionUUID->"9c46969c-e2cb-334c-a3ee-\
79aef2ec19d0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "620", "]"}]}]], "Input",
 CellChangeTimes->{
  3.947494250469843*^9, {3.9474943011024914`*^9, 3.9474943018458023`*^9}},
 CellLabel->
  "In[187]:=",ExpressionUUID->"08022650-50ce-274a-908a-4c8b480653d6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"7", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"7", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["c", "2"]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox["c", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9474942557293434`*^9, 3.9474943034096584`*^9},
 CellLabel->
  "Out[187]=",ExpressionUUID->"4e3a44de-7da0-ec42-8165-66fd7bcf6a9e"]
}, Open  ]],

Cell["[ABCD]=4[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946461171158417*^9, 3.946461174443907*^9}, 
   3.946475613161922*^9, 3.946477093094621*^9, {3.9464880234319763`*^9, 
   3.9464880258399277`*^9}},ExpressionUUID->"e8769028-817a-1a43-a792-\
cb168e1a5717"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Numerator", "[", 
     RowBox[{"Factor", "[", 
      RowBox[{
       RowBox[{"AreaQuad", "[", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], 
       "-", 
       RowBox[{"4", 
        RowBox[{"AreaQuad", "[", 
         RowBox[{"{", 
          RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], 
         "]"}]}]}], "]"}], "]"}], "/.", "sustS"}], ",", "rhombus"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.946475753103716*^9, 3.946475755984558*^9}, {
  3.946487489224434*^9, 3.9464874917522564`*^9}, {3.9464879763518333`*^9, 
  3.9464879770962105`*^9}, {3.946488048344164*^9, 3.946488053079422*^9}, {
  3.9474942469762993`*^9, 3.9474942590697117`*^9}},
 CellLabel->
  "In[188]:=",ExpressionUUID->"1631ccfb-7c64-e44b-afe5-ec03b94fe49c"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9464757569541473`*^9, 3.9464757718265495`*^9}, 
   3.9464876738616314`*^9, 3.946487978288828*^9, 3.946488053955501*^9, 
   3.9474942597925625`*^9, 3.947494308160906*^9},
 CellLabel->
  "Out[188]=",ExpressionUUID->"504b5f4a-1283-fb4b-9c9a-c93c04fca26e"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (671)", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, {
   3.9464610917155704`*^9, 3.9464611321713753`*^9}, 3.946475602754768*^9, {
   3.946476857109905*^9, 3.946476858142927*^9}, {3.946488004487486*^9, 
   3.946488008863096*^9}, 3.946488105936834*^9, 3.9474943406295376`*^9, {
   3.947494405445202*^9, 
   3.947494406181488*^9}},ExpressionUUID->"c2349227-79fd-f141-a33f-\
a4a280635dda"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "671", "]"}]}]], "Input",
 CellChangeTimes->{
  3.94749435100601*^9, {3.9474944123982353`*^9, 3.9474944132773914`*^9}},
 CellLabel->
  "In[191]:=",ExpressionUUID->"1eb61338-bf74-3442-bb11-83ac907868cf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["c", "2"]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["a", "2"]}], "+", 
         SuperscriptBox["b", "2"]}], ")"}], "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["a", "2"]}], "+", 
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "3"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["c", "2"]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["a", "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["c", "2"]}]}], ")"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], "+", 
          SuperscriptBox["c", "2"]}], ")"}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.947494351754074*^9, 3.947494413768959*^9},
 CellLabel->
  "Out[191]=",ExpressionUUID->"8f7811bc-0b4d-2843-9a87-afe9150a3571"]
}, Open  ]],

Cell["[ABCD]=9[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946461171158417*^9, 3.946461174443907*^9}, 
   3.946475613161922*^9, 3.946477093094621*^9, {3.9464880234319763`*^9, 
   3.9464880258399277`*^9}, {3.9464880829600697`*^9, 
   3.9464880830153637`*^9}},ExpressionUUID->"75496117-43d2-5e4e-8f24-\
6113ffce931d"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Numerator", "[", 
     RowBox[{"Factor", "[", 
      RowBox[{
       RowBox[{"AreaQuad", "[", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], 
       "-", 
       RowBox[{"9", 
        RowBox[{"AreaQuad", "[", 
         RowBox[{"{", 
          RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], 
         "]"}]}]}], "]"}], "]"}], "/.", "sustS"}], ",", "rhombus"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.946475753103716*^9, 3.946475755984558*^9}, {
  3.946487489224434*^9, 3.9464874917522564`*^9}, {3.9464879763518333`*^9, 
  3.9464879770962105`*^9}, {3.946488048344164*^9, 3.946488053079422*^9}, {
  3.9464881130479527`*^9, 3.946488120326805*^9}, {3.9474943490394382`*^9, 
  3.947494356294546*^9}},
 CellLabel->
  "In[192]:=",ExpressionUUID->"ef123388-c7c6-c84e-a78a-07279b1a320e"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9464757569541473`*^9, 3.9464757718265495`*^9}, 
   3.9464876738616314`*^9, 3.946487978288828*^9, 3.946488053955501*^9, 
   3.946488121081962*^9, 3.94749436598452*^9, 3.947494419760336*^9},
 CellLabel->
  "Out[192]=",ExpressionUUID->"1814cedd-9056-bc45-801a-8db6f0092b6a"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (903)", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, {
   3.9464610917155704`*^9, 3.9464611321713753`*^9}, 3.946475602754768*^9, {
   3.946476857109905*^9, 3.946476858142927*^9}, {3.946488004487486*^9, 
   3.946488008863096*^9}, 3.946488105936834*^9, 3.9474943406295376`*^9, {
   3.947494440485235*^9, 
   3.9474944412049923`*^9}},ExpressionUUID->"66f7cff5-f2c5-5f4e-947f-\
808f3130a9b6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "903", "]"}]}]], "Input",
 CellChangeTimes->{
  3.94749435100601*^9, {3.947494448717989*^9, 3.947494449285389*^9}},
 CellLabel->
  "In[193]:=",ExpressionUUID->"3bce8ced-1141-974f-9845-79cdd7486f48"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "-", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"2", " ", "c"}], "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"]}]}]]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "3"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "-", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "-", 
         RowBox[{"2", " ", "c"}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], ")"}], "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "a"}], "+", "b", "+", "c"}], ")"}], "2"]}],
      ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "-", "b", "-", "c"}], ")"}]}], ",", 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "b", "-", 
         RowBox[{"2", " ", "c"}]}], ")"}], "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "a"}], "+", "c", "+", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], ")"}], "2"]}], ",", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "-", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "a"}], "+", "c", "+", 
          SqrtBox[
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"]}], "-", 
            SuperscriptBox["b", "2"], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}]}]]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "c", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}], ")"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"2", " ", "b"}], "+", "c"}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "-", 
          RowBox[{"2", " ", "c"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "a"}], "-", "b", "-", "c"}], ")"}]}], ")"}]}], 
     ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "a"}], "-", "b", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "-", 
          RowBox[{"2", " ", "b"}], "+", "c"}], ")"}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.947494351754074*^9, 3.9474944499734383`*^9},
 CellLabel->
  "Out[193]=",ExpressionUUID->"7501e73e-552a-d048-978f-edca7b589949"]
}, Open  ]],

Cell["[ABCD]=9[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946461171158417*^9, 3.946461174443907*^9}, 
   3.946475613161922*^9, 3.946477093094621*^9, {3.9464880234319763`*^9, 
   3.9464880258399277`*^9}, {3.9464880829600697`*^9, 
   3.9464880830153637`*^9}},ExpressionUUID->"a5125d41-e10c-d24d-aeb4-\
88ae7e57f765"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Numerator", "[", 
     RowBox[{"Factor", "[", 
      RowBox[{
       RowBox[{"AreaQuad", "[", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], 
       "-", 
       RowBox[{"9", 
        RowBox[{"AreaQuad", "[", 
         RowBox[{"{", 
          RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], 
         "]"}]}]}], "]"}], "]"}], "/.", "sustS"}], ",", "rhombus"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.946475753103716*^9, 3.946475755984558*^9}, {
  3.946487489224434*^9, 3.9464874917522564`*^9}, {3.9464879763518333`*^9, 
  3.9464879770962105`*^9}, {3.946488048344164*^9, 3.946488053079422*^9}, {
  3.9464881130479527`*^9, 3.946488120326805*^9}, {3.9474943490394382`*^9, 
  3.947494356294546*^9}},
 CellLabel->
  "In[194]:=",ExpressionUUID->"5ae1df3e-f533-e042-8478-259fa7ed22b0"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9464757569541473`*^9, 3.9464757718265495`*^9}, 
   3.9464876738616314`*^9, 3.946487978288828*^9, 3.946488053955501*^9, 
   3.946488121081962*^9, 3.94749436598452*^9, 3.947494456016636*^9},
 CellLabel->
  "Out[194]=",ExpressionUUID->"04c3ba73-36dd-7747-ba38-058c13616de4"]
}, Closed]]
}, Closed]]
},
CellGrouping->Manual,
WindowSize->{1293.2830188679245`, 654.7924528301886},
WindowMargins->{{0, Automatic}, {Automatic, -0.6792452830188679}},
FrontEndVersion->"14.0 for Microsoft Windows (64-bit) (December 12, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"214a42d8-cbfa-984d-8bbc-535a5c442cc3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 319, 5, 98, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[880, 27, 1443, 24, 173, "Text",ExpressionUUID->"08758b0a-705f-b842-b1d6-6a28a79b6218"],
Cell[CellGroupData[{
Cell[2348, 55, 200, 4, 67, "Section",ExpressionUUID->"5e4c6aa2-710c-4599-941e-5f13e499af78"],
Cell[CellGroupData[{
Cell[2573, 63, 1494, 34, 67, "Input",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"],
Cell[4070, 99, 371, 9, 32, "Output",ExpressionUUID->"4acf0693-2759-1d45-ae80-6e20e8d29da7"]
}, Open  ]],
Cell[4456, 111, 389, 11, 28, "Input",ExpressionUUID->"d0c5b345-9e88-e04a-9131-1e258249750e"]
}, Closed]],
Cell[CellGroupData[{
Cell[4882, 127, 255, 4, 53, "Section",ExpressionUUID->"cf60f297-bbcd-8748-b453-e7118b4e0a98"],
Cell[CellGroupData[{
Cell[5162, 135, 212, 4, 54, "Subsection",ExpressionUUID->"c8cca55e-04f1-8f4a-b670-3c3179eed91e"],
Cell[5377, 141, 271227, 7063, 3643, "Input",ExpressionUUID->"90297db1-2eea-6346-9338-a3e8dcfe0024"]
}, Closed]],
Cell[CellGroupData[{
Cell[276641, 7209, 215, 4, 38, "Subsection",ExpressionUUID->"79ef6085-3de7-3c49-8561-f943fbd2d431"],
Cell[276859, 7215, 438, 12, 28, "Input",ExpressionUUID->"e725b315-4161-274c-8798-a4e0c807d6a8"],
Cell[277300, 7229, 439, 12, 28, "Input",ExpressionUUID->"60fea3de-a36e-734d-b67f-75eab8f36838"],
Cell[277742, 7243, 438, 12, 28, "Input",ExpressionUUID->"422bd8e2-a85e-d748-b542-6c9b62c11efd"],
Cell[278183, 7257, 1082, 30, 28, "Input",ExpressionUUID->"d021f1ab-c58d-b74b-8aa5-a62365464cc5"],
Cell[279268, 7289, 820, 24, 28, "Input",ExpressionUUID->"023d4850-e194-b941-a762-4c9a532e11d1"],
Cell[280091, 7315, 603, 17, 28, "Input",ExpressionUUID->"62ef2468-c328-714d-8bf7-299b142a086d"],
Cell[280697, 7334, 2073, 54, 181, "Input",ExpressionUUID->"d734f707-6812-364b-b359-ac3a6bb66e72"],
Cell[282773, 7390, 1714, 47, 143, "Input",ExpressionUUID->"34f7e383-98aa-bc47-9867-166186424dd4"],
Cell[284490, 7439, 1914, 51, 162, "Input",ExpressionUUID->"4370c731-693f-a941-82c8-1f6a14f724b2"],
Cell[286407, 7492, 613, 17, 28, "Input",ExpressionUUID->"6e2024d9-4541-ea4e-a308-49a8bb9b87a5"],
Cell[287023, 7511, 1131, 30, 124, "Input",ExpressionUUID->"384fc915-4ebd-5342-9174-a166a5e7f52d"],
Cell[288157, 7543, 1395, 40, 124, "Input",ExpressionUUID->"e878baba-ea71-dd4f-b972-2e4c3753c774"],
Cell[289555, 7585, 1398, 40, 124, "Input",ExpressionUUID->"4200ee2b-abeb-b246-85fa-68f1ce5d836b"],
Cell[290956, 7627, 1330, 39, 124, "Input",ExpressionUUID->"8131db8a-5012-e741-93f3-ec6da52923f1"],
Cell[292289, 7668, 1368, 38, 143, "Input",ExpressionUUID->"3e5eb206-464c-7e4f-b628-98c50c5a4629"]
}, Closed]],
Cell[CellGroupData[{
Cell[293694, 7711, 291, 5, 38, "Subsection",ExpressionUUID->"d004e03f-8f12-9a43-865f-339812029417"],
Cell[293988, 7718, 3322, 101, 130, "Input",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],
Cell[CellGroupData[{
Cell[297347, 7824, 170, 3, 38, "Subsection",ExpressionUUID->"2a49be25-3c4e-430e-86c6-869880736f30"],
Cell[CellGroupData[{
Cell[297542, 7831, 217, 4, 45, "Subsubsection",ExpressionUUID->"a576f9af-1f5b-4213-b4d3-e7b66981337e"],
Cell[297762, 7837, 53880, 889, 404, "Text",ExpressionUUID->"f7950398-57cb-4ee6-bf14-597b39eb91df"],
Cell[351645, 8728, 999, 25, 86, "Input",ExpressionUUID->"cf738f77-0d96-4e62-81a0-f2a504594dc8"]
}, Closed]],
Cell[CellGroupData[{
Cell[352681, 8758, 238, 4, 37, "Subsubsection",ExpressionUUID->"f7957972-a4e9-446f-bafd-6774f0dd3699"],
Cell[352922, 8764, 817, 19, 48, "Input",ExpressionUUID->"44de57fd-6e7d-4d98-94a0-c7b93947eadd"]
}, Closed]],
Cell[CellGroupData[{
Cell[353776, 8788, 215, 4, 37, "Subsubsection",ExpressionUUID->"ae32c2db-9871-344f-aabd-a2543db56100"],
Cell[353994, 8794, 2076, 57, 101, "Input",ExpressionUUID->"db0fcba9-9144-4df7-981b-db22bb466a6e"]
}, Closed]],
Cell[CellGroupData[{
Cell[356107, 8856, 242, 4, 37, "Subsubsection",ExpressionUUID->"29f12ada-9fd0-4747-b323-2cf96d6fb52e"],
Cell[356352, 8862, 664, 16, 28, "Input",ExpressionUUID->"158fb412-c771-43ab-b43b-a357380f4a11"]
}, Closed]],
Cell[CellGroupData[{
Cell[357053, 8883, 197, 3, 37, "Subsubsection",ExpressionUUID->"5a543829-5641-9144-8dd0-57eb7cf1938d"],
Cell[357253, 8888, 1567, 43, 124, "Input",ExpressionUUID->"35cb8ff3-829e-654a-a95d-e2c972de6be9"]
}, Closed]],
Cell[CellGroupData[{
Cell[358857, 8936, 174, 3, 37, "Subsubsection",ExpressionUUID->"e039afe9-d89d-4ec4-94b9-ddb3f9f259e0"],
Cell[359034, 8941, 562, 15, 28, "Input",ExpressionUUID->"2db3c5dc-e4da-4371-937a-22cb108c81e1"]
}, Closed]],
Cell[CellGroupData[{
Cell[359633, 8961, 372, 6, 37, "Subsubsection",ExpressionUUID->"bd16b166-d506-5544-b5d0-7aa6edfca35b"],
Cell[360008, 8969, 1247, 34, 52, "Input",ExpressionUUID->"6cd12b17-ccf6-1f40-8216-e746f72a898c"]
}, Closed]],
Cell[CellGroupData[{
Cell[361292, 9008, 384, 6, 37, "Subsubsection",ExpressionUUID->"d546f79d-5ed9-4f99-846e-3ac1a3756b86"],
Cell[361679, 9016, 972, 27, 28, "Input",ExpressionUUID->"5668c7c2-b2f3-48b4-bb4e-3f493e46ab9c"],
Cell[362654, 9045, 883, 25, 28, "Input",ExpressionUUID->"d07dfa48-d9b6-433c-9d4d-8f2532f1bec3"]
}, Closed]],
Cell[CellGroupData[{
Cell[363574, 9075, 323, 5, 37, "Subsubsection",ExpressionUUID->"8f461d45-0647-c84b-9fe0-f72d3601c63f"],
Cell[363900, 9082, 1686, 41, 157, "Input",ExpressionUUID->"5485ed32-34f6-e64e-bd2a-b4e163c2b97f"]
}, Closed]],
Cell[CellGroupData[{
Cell[365623, 9128, 201, 3, 35, "Subsubsection",ExpressionUUID->"54169a90-c35c-7a4a-a37f-78c9753e8eeb"],
Cell[365827, 9133, 1631, 40, 124, "Input",ExpressionUUID->"c1bc4c8d-1ecd-654a-b9e2-f902b4037dfa"]
}, Closed]],
Cell[CellGroupData[{
Cell[367495, 9178, 225, 4, 35, "Subsubsection",ExpressionUUID->"e126572d-bdab-a047-b925-c2661290f09e"],
Cell[367723, 9184, 1442, 38, 105, "Input",ExpressionUUID->"3eac6f83-9820-5d4f-9acd-4f2df1b13510"]
}, Closed]],
Cell[CellGroupData[{
Cell[369202, 9227, 308, 5, 35, "Subsubsection",ExpressionUUID->"1d12da59-37f1-9842-ad9c-eb916041816f"],
Cell[369513, 9234, 3090, 71, 219, "Input",ExpressionUUID->"806c98e7-c027-de46-8fc2-cc2eda959f64"]
}, Closed]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[372664, 9312, 211, 4, 53, "Section",ExpressionUUID->"2609bf4c-7f5c-314e-a744-f86d4be283dd"],
Cell[372878, 9318, 42924, 709, 226, "Text",ExpressionUUID->"20c7ab22-8503-fd4d-9d34-15585b88ac29"],
Cell[CellGroupData[{
Cell[415827, 10031, 382, 6, 54, "Subsection",ExpressionUUID->"db3e31cc-0570-9d4c-8a3d-de0271c7746a"],
Cell[CellGroupData[{
Cell[416234, 10041, 297, 7, 28, "Input",ExpressionUUID->"ca44ed3d-52c9-0e4b-bd50-62c3f35c4d61"],
Cell[416534, 10050, 8124, 263, 101, "Output",ExpressionUUID->"99dbdb60-8b1e-1d40-8233-e6dc3435998e"]
}, Open  ]],
Cell[424673, 10316, 240, 4, 45, "Subsubsection",ExpressionUUID->"a547a802-ecb9-1041-a3a4-19319b3e85b4"],
Cell[CellGroupData[{
Cell[424938, 10324, 824, 21, 24, "Input",ExpressionUUID->"4e33e18e-b764-cc4c-99d8-a3be99736348"],
Cell[425765, 10347, 255, 4, 32, "Output",ExpressionUUID->"59076b03-a83c-0f4f-84cd-b45eaf8059ed"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[426069, 10357, 382, 6, 38, "Subsection",ExpressionUUID->"92c60775-7ca3-4947-b746-079da942726b"],
Cell[CellGroupData[{
Cell[426476, 10367, 323, 7, 28, "Input",ExpressionUUID->"ee1c21c3-95e8-7644-aa8a-38a41361b0fc"],
Cell[426802, 10376, 8244, 268, 101, "Output",ExpressionUUID->"414a2f4c-208c-1749-87e4-fa6ac54a644f"]
}, Open  ]],
Cell[435061, 10647, 240, 4, 45, "Subsubsection",ExpressionUUID->"c3e0a4d6-1f2f-264b-b0f2-85231be0d988"],
Cell[435304, 10653, 824, 21, 24, "Input",ExpressionUUID->"7d573faa-d3e5-254e-8971-a47fb9b38417"],
Cell[436131, 10676, 255, 4, 32, "Output",ExpressionUUID->"eec9a72d-101f-1c45-a9b1-028d3acae950"]
}, Closed]],
Cell[CellGroupData[{
Cell[436423, 10685, 378, 6, 38, "Subsection",ExpressionUUID->"6fbe65de-d60d-3548-8446-54fd411b102f"],
Cell[CellGroupData[{
Cell[436826, 10695, 297, 7, 28, "Input",ExpressionUUID->"abf68f74-0add-5249-aeef-d87332203cbf"],
Cell[437126, 10704, 11676, 366, 143, "Output",ExpressionUUID->"87a8cce9-4891-d143-a07a-0f45e8ceccf6"]
}, Open  ]],
Cell[448817, 11073, 318, 5, 45, "Subsubsection",ExpressionUUID->"66db4db0-b263-df42-83fa-2b9e53d5d99b"],
Cell[CellGroupData[{
Cell[449160, 11082, 922, 23, 24, "Input",ExpressionUUID->"4f8294d3-4387-fb48-9e8b-537fe011f6b4"],
Cell[450085, 11107, 300, 5, 32, "Output",ExpressionUUID->"6d72f4d2-5a80-5d49-b334-9cd4fbc65e0d"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[450434, 11118, 356, 6, 38, "Subsection",ExpressionUUID->"3bacdd8a-6bc4-cf45-9449-0b6a098c6b09"],
Cell[CellGroupData[{
Cell[450815, 11128, 298, 7, 28, "Input",ExpressionUUID->"7156365f-ddb4-194e-9554-73894e89ea5d"],
Cell[451116, 11137, 27286, 814, 273, "Output",ExpressionUUID->"b40b9d0a-1010-c743-b28f-7b86b33a56c0"]
}, Open  ]],
Cell[478417, 11954, 264, 4, 45, "Subsubsection",ExpressionUUID->"96fbab32-10ae-cf40-9738-8db78fa91ed3"],
Cell[CellGroupData[{
Cell[478706, 11962, 873, 22, 24, "Input",ExpressionUUID->"a2382154-998d-3648-b1d6-6c070e23de83"],
Cell[479582, 11986, 281, 5, 32, "Output",ExpressionUUID->"64ca8677-9818-734e-b7ff-1103a1323464"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[479912, 11997, 401, 6, 38, "Subsection",ExpressionUUID->"cd2a4b57-8e7c-a045-9b26-5cd6e13f81b3"],
Cell[480316, 12005, 343, 8, 28, "Input",ExpressionUUID->"254389c5-ac2f-2a43-87ed-5a7559ae416f"],
Cell[480662, 12015, 369, 6, 45, "Subsubsection",ExpressionUUID->"1451f0d6-c6e8-bd49-8ce7-3ebbd1dc539a"],
Cell[CellGroupData[{
Cell[481056, 12025, 968, 23, 24, "Input",ExpressionUUID->"37199edf-6669-5f47-8608-654fd50ffa94"],
Cell[482027, 12050, 353, 6, 32, "Output",ExpressionUUID->"41223239-4906-6048-8edc-69061de34903"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[482429, 12062, 404, 6, 38, "Subsection",ExpressionUUID->"9c46969c-e2cb-334c-a3ee-79aef2ec19d0"],
Cell[CellGroupData[{
Cell[482858, 12072, 351, 8, 28, "Input",ExpressionUUID->"08022650-50ce-274a-908a-4c8b480653d6"],
Cell[483212, 12082, 5936, 187, 100, "Output",ExpressionUUID->"4e3a44de-7da0-ec42-8165-66fd7bcf6a9e"]
}, Open  ]],
Cell[489163, 12272, 264, 4, 45, "Subsubsection",ExpressionUUID->"e8769028-817a-1a43-a792-cb168e1a5717"],
Cell[489430, 12278, 873, 22, 24, "Input",ExpressionUUID->"1631ccfb-7c64-e44b-afe5-ec03b94fe49c"],
Cell[490306, 12302, 303, 5, 32, "Output",ExpressionUUID->"504b5f4a-1283-fb4b-9c9a-c93c04fca26e"]
}, Closed]],
Cell[CellGroupData[{
Cell[490646, 12312, 428, 7, 38, "Subsection",ExpressionUUID->"c2349227-79fd-f141-a33f-a4a280635dda"],
Cell[CellGroupData[{
Cell[491099, 12323, 350, 8, 28, "Input",ExpressionUUID->"1eb61338-bf74-3442-bb11-83ac907868cf"],
Cell[491452, 12333, 4976, 162, 78, "Output",ExpressionUUID->"8f7811bc-0b4d-2843-9a87-afe9150a3571"]
}, Open  ]],
Cell[496443, 12498, 318, 5, 45, "Subsubsection",ExpressionUUID->"75496117-43d2-5e4e-8f24-6113ffce931d"],
Cell[496764, 12505, 922, 23, 24, "Input",ExpressionUUID->"ef123388-c7c6-c84e-a78a-07279b1a320e"],
Cell[497689, 12530, 322, 5, 32, "Output",ExpressionUUID->"1814cedd-9056-bc45-801a-8db6f0092b6a"]
}, Closed]],
Cell[CellGroupData[{
Cell[498048, 12540, 430, 7, 38, "Subsection",ExpressionUUID->"66f7cff5-f2c5-5f4e-947f-808f3130a9b6"],
Cell[CellGroupData[{
Cell[498503, 12551, 346, 8, 28, "Input",ExpressionUUID->"3bce8ced-1141-974f-9845-79cdd7486f48"],
Cell[498852, 12561, 4862, 158, 118, "Output",ExpressionUUID->"7501e73e-552a-d048-978f-edca7b589949"]
}, Open  ]],
Cell[503729, 12722, 318, 5, 45, "Subsubsection",ExpressionUUID->"a5125d41-e10c-d24d-aeb4-88ae7e57f765"],
Cell[504050, 12729, 922, 23, 24, "Input",ExpressionUUID->"5ae1df3e-f533-e042-8478-259fa7ed22b0"],
Cell[504975, 12754, 322, 5, 32, "Output",ExpressionUUID->"04c3ba73-36dd-7747-ba38-058c13616de4"]
}, Closed]]
}, Closed]]
}
]
*)

