(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    546781,      13801]
NotebookOptionsPosition[    534499,      13587]
NotebookOutlinePosition[    534969,      13604]
CellTagsIndexPosition[    534926,      13601]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Squares", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, 
   3.947147906503248*^9, {3.947481336744753*^9, 
   3.9474813380325584`*^9}},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about squares in the paper \
\"More Relationships between a Central Quadrilateral and its Reference \
Quadrilateral\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in \
February 2025.

This Notebook is Copyright \[Copyright] February 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947481344697075*^9, 
  3.947481347432724*^9}},ExpressionUUID->"08758b0a-705f-b842-b1d6-\
6a28a79b6218"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.94550589477663*^9, 3.9455059090976067`*^9}, {
  3.947131190260437*^9, 
  3.947131192227951*^9}},ExpressionUUID->"5e4c6aa2-710c-4599-941e-\
5f13e499af78"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", ">", "0"}], ",", 
     RowBox[{"b", ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ptD", "=", 
  RowBox[{"SimetriaCentral", "[", 
   RowBox[{"ptB", ",", 
    RowBox[{"Medio", "[", 
     RowBox[{"ptA", ",", "ptC"}], "]"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.945504565162958*^9, 3.94550458198252*^9}, {
   3.9455170892604294`*^9, 3.945517091156999*^9}, {3.946437513579389*^9, 
   3.946437514387348*^9}, {3.946437922994858*^9, 3.946437998083948*^9}, {
   3.947131229988783*^9, 3.9471312337408752`*^9}, {3.94713126947538*^9, 
   3.947131271053065*^9}, {3.9471314397563486`*^9, 3.947131528028438*^9}, {
   3.947131689741032*^9, 3.947131695924305*^9}, {3.947131733918829*^9, 
   3.947131775067988*^9}, 3.94713185451009*^9, {3.947132455427481*^9, 
   3.947132456035076*^9}, {3.947133799219084*^9, 3.947133799613205*^9}, {
   3.9474813781548023`*^9, 3.947481389864706*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "1"}], ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.947481395665182*^9, 3.9474816145492115`*^9, 
  3.9474816801539536`*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"55f3717f-3585-594b-914b-995d2ccd4855"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"square", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"p", "-", "r"}], "==", "0"}], "&&", 
    RowBox[{
     RowBox[{"q", "+", "r"}], "==", "0"}], "&&", 
    RowBox[{"b", "==", 
     RowBox[{
      SqrtBox["2"], "a"}]}], "&&", 
    RowBox[{"c", "==", "a"}]}]}], ";"}]], "Input",
 CellLabel->"In[15]:=",ExpressionUUID->"d0c5b345-9e88-e04a-9131-1e258249750e"]
}, Closed]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"cf60f297-bbcd-8748-b453-\
e7118b4e0a98"],

Cell[CellGroupData[{

Cell["QAP centers", "Subsection",
 CellChangeTimes->{{3.945853740709931*^9, 3.945853743438184*^9}, {
  3.9464394595455627`*^9, 
  3.9464394652171745`*^9}},ExpressionUUID->"c8cca55e-04f1-8f4a-b670-\
3c3179eed91e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP", "=", 
   RowBox[{"<|", 
    RowBox[{
     RowBox[{"1", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ",", 
        RowBox[{"p", "+", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ",", 
        RowBox[{"p", "+", "q", "+", 
         RowBox[{"2", " ", "r"}]}]}], "}"}]}], ",", 
     RowBox[{"2", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", "SB"}], "-", 
           RowBox[{"r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "SA"}], "+", 
           RowBox[{"r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "SA"}], "-", 
           RowBox[{"q", " ", "SB"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"3", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}]}], 
          ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", 
              RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"4", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", "SA"}], "-", 
           RowBox[{"2", " ", "p", " ", "q", " ", "SA"}], "-", 
           RowBox[{"2", " ", "p", " ", "r", " ", "SA"}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}]}], ")"}]}],
         ",", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p"}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q"}], "-", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}], 
             ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"5", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"6", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"q", " ", 
                SuperscriptBox["SB", "2"]}], "-", 
               RowBox[{"r", " ", 
                SuperscriptBox["SC", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"p", " ", 
                SuperscriptBox["SA", "2"]}], "-", 
               RowBox[{"r", " ", 
                SuperscriptBox["SC", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"p", " ", 
                SuperscriptBox["SA", "2"]}], "-", 
               RowBox[{"q", " ", 
                SuperscriptBox["SB", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"7", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SB", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 SuperscriptBox["SB", "2"], "+", 
                 RowBox[{"2", " ", "SB", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"2", " ", "SB", " ", "SC"}], "+", 
                 SuperscriptBox["SC", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"3", " ", "r", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"r", " ", "SC", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "SA"}], "+", "SC"}], ")"}]}], "+", 
              RowBox[{"p", " ", "SA", " ", 
               RowBox[{"(", 
                RowBox[{"SA", "+", 
                 RowBox[{"2", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SA", " ", "SC"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"3", " ", "q", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"q", " ", "SB", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "SA"}], "+", "SB"}], ")"}]}], "+", 
              RowBox[{"p", " ", "SA", " ", 
               RowBox[{"(", 
                RowBox[{"SA", "+", 
                 RowBox[{"2", " ", "SB"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SA", " ", "SB"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}],
        "}"}]}], ",", 
     RowBox[{"8", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "p"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "p"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "q"}], "+", 
            RowBox[{"4", " ", "r", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}]}], "}"}]}],
      ",", 
     RowBox[{"9", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p", " ", "q"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"]}], "+", 
                 RowBox[{"3", " ", "p", " ", "r"}], "+", 
                 RowBox[{"q", " ", "r"}], "-", 
                 SuperscriptBox["r", "2"]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "p", " ", "q"}], "-", 
                 SuperscriptBox["q", "2"], "+", 
                 RowBox[{"2", " ", "p", " ", "r"}], "+", 
                 RowBox[{"q", " ", "r"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "q"}], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"4", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "q"}], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "-", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"5", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"3", " ", "p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "8"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "8"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", 
                 RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"p", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
              "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"p", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"8", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"4", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["c", "6"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["p", "2"]}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "q", " ", 
                  SuperscriptBox["r", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"12", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"9", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["q", "3"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"12", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"13", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "r"}], "-", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["p", "2"], "-", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "6"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "q", " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"5", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "-", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["q", "2"], " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "3"}], " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  SuperscriptBox["q", "3"], " ", "r"}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  SuperscriptBox["r", "3"]}], "+", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["p", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"8", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "3"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"12", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["c", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["q", "2"]}]}], ")"}], " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "r"}], "-", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "6"]}], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["p", "2"]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["q", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"5", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "-", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["q", "2"], " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"8", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"6", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "3"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    RowBox[{"2", " ", "q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"12", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"13", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"9", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"10", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"11", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"12", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
          ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", "q", " ", "SB"}], "+", 
           RowBox[{"p", " ", "r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{"p", " ", "q", " ", "SA"}], "+", 
           RowBox[{"q", " ", "r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r", " ", "SA"}], "+", 
           RowBox[{"q", " ", "r", " ", "SB"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", "q", " ", 
            SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"13", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"14", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "r"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"5", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"2", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"2", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}]}], "}"}]}], 
     ",", 
     RowBox[{"15", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"q", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["q", "2"]}], "+", 
               RowBox[{"5", " ", "q", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"5", " ", "q", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["p", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["q", "2"]}], "+", 
               RowBox[{"22", " ", "q", " ", "r"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "p"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"5", " ", "p", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"5", " ", "p", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["q", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"22", " ", "p", " ", "r"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["q", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               SuperscriptBox["q", "2"]}], ")"}], " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "p"}], "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"5", " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"5", " ", "p", " ", "q"}], "+", 
               SuperscriptBox["q", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"5", " ", "p", " ", "q"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["q", "2"]}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"22", " ", "p", " ", "q"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["q", "2"]}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"10", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"16", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"17", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["q", "2"], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"18", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"19", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"20", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"21", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"22", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"23", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", "q", " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
         RowBox[{"p", " ", "q", " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
         RowBox[{"p", " ", "r", " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", "SB"}]}]}], "}"}]}], ",", 
     RowBox[{"24", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", "SB", " ", 
          "SC"}], "-", 
         RowBox[{"4", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "SC"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], ")"}], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", "SC"}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "SA", " ", 
          "SC"}], "-", 
         RowBox[{"4", " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "SC"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], ")"}], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", "SC"}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "SA", " ", 
          "SB"}], "-", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"25", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"2", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"26", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"5", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"5", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"5", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"27", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["p", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"], " ", "q"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"p", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{"q", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "3"]}], " ", "q"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           SuperscriptBox["q", "4"], "+", 
           RowBox[{
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"q", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["p", "3"], " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"2", " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           SuperscriptBox["r", "4"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"28", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "4"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["b", "2"], "-", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", "r"}]}], 
             ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "4"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["q", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "+", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", "r"}], "+", 
              RowBox[{
               SuperscriptBox["a", "4"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"3", " ", "q", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", 
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "+", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["a", "2"], "-", 
                   SuperscriptBox["b", "2"]}], ")"}], " ", "p", " ", "q"}], 
                "+", 
                RowBox[{
                 SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "4"], " ", "q", " ", "r"}]}], ")"}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"3", " ", "q", " ", "r"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
       "}"}]}], ",", 
     RowBox[{"29", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["a", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "3"], " ", "r"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["p", "2"]}], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"30", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "q"}], ")"}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "-", 
              RowBox[{"3", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "p"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"3", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "p"}], "+", "q"}], ")"}], " ", "r", 
            " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"3", " ", "q"}]}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
       "}"}]}], ",", 
     RowBox[{"31", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"32", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", "q", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}]}], "}"}]}],
      ",", 
     RowBox[{"33", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB", " ", 
             "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA", " ", 
             "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA", " ", 
             "SB"}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"34", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"4", " ", "q"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p"}], "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"35", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"15", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "3"], " ", "r"}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"5", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"15", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"12", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"5", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["p", "2"]}], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"15", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"15", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"12", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"36", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["c", "2"]}], " ", "q"}], "-", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "-", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q", " ", "r"}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
               RowBox[{
                SuperscriptBox["a", "4"], " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["b", "4"], " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["c", "2"]}], " ", "p"}], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "p"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "r"}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "4"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["c", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["b", "2"], " ", 
                SuperscriptBox["c", "2"], " ", "q", " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["b", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["c", "4"], " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "-", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "q"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}]}], ")"}]}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["b", "2"]}], " ", "p"}], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "4"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["c", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["a", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["c", "4"], " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "p"}], "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}]}], "}"}]}], ",", 
     RowBox[{"37", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"p", " ", "q", " ", "SB"}], "+", 
            RowBox[{"p", " ", "r", " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"p", " ", "q", " ", "SA"}], "+", 
            RowBox[{"q", " ", "r", " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r", " ", "SA"}], "+", 
            RowBox[{"q", " ", "r", " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"38", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["b", "2"]}], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "-", "q", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", "p"}], "+", "q", "+", "r"}], 
                ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", 
                 RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", 
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "q", "+", 
             RowBox[{"2", " ", "r"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "-", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "-", "q", "-", 
                   RowBox[{"2", " ", "r"}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "-", "q", "+", 
                   RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          ")"}]}]}], "}"}]}], ",", 
     RowBox[{"39", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["b", "2"], "-", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "-", "r"}], ")"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "+", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "p"}], "+", "r"}], ")"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               RowBox[{"2", " ", "p", " ", "r"}], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["a", "2"], "-", 
                 SuperscriptBox["b", "2"]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "q"}], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}]}], "}"}]}], ",", 
     RowBox[{"40", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], "+", 
            SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", 
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "p"}], "+", 
                   RowBox[{"2", " ", "q"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "q"}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["q", "2"]}]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", "p"}], "+", 
                  RowBox[{"2", " ", "q"}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "r", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", 
                  RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["p", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", "q"}], "+", 
                  RowBox[{"9", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["q", "2"]}], "+", 
                  RowBox[{"15", " ", "q", " ", "r"}], "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["a", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"9", " ", "p"}], "+", 
                  RowBox[{"7", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"12", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "r"}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "q"}], "+", 
                   RowBox[{"2", " ", "r"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["p", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", "q"}], "+", 
                  RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", 
                   SuperscriptBox["q", "2"]}], "+", 
                  RowBox[{"15", " ", "q", " ", "r"}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], "+", 
            SuperscriptBox["b", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", 
                  RowBox[{"2", " ", "q"}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "q"}], "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["q", "2"]}]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", "p"}], "+", 
                  RowBox[{"9", " ", "q"}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "p"}], "+", 
                   RowBox[{"3", " ", "r"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "p"}], "+", 
                  RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"6", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "r"}], "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"41", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "4"]}], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "4"]}], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"42", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q", " ", "r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "SB"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"43", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", "p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", "p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"44", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "q"}], "-", 
            RowBox[{"q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p", " ", "q"}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            SuperscriptBox["q", "3"], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            SuperscriptBox["r", "3"]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "3"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            SuperscriptBox["r", "3"]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "3"], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            SuperscriptBox["q", "3"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}]}], "|>"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945841589546528*^9, 3.945841604944151*^9}, {
   3.9458416486015606`*^9, 3.945841701130226*^9}, 3.94584180266897*^9, {
   3.945841855521532*^9, 3.945841865133842*^9}, {3.9458419743855267`*^9, 
   3.94584197851943*^9}, {3.945842012120521*^9, 3.945842016064451*^9}, {
   3.945842114756489*^9, 3.945842119338508*^9}, {3.945842170028664*^9, 
   3.945842174123476*^9}, {3.945842254968681*^9, 3.9458422593104534`*^9}, {
   3.94584246069957*^9, 3.945842465998068*^9}, {3.945842501032144*^9, 
   3.9458425325383263`*^9}, {3.945842735167492*^9, 3.945842742091593*^9}, {
   3.945842846919035*^9, 3.945842850061655*^9}, {3.945842936494915*^9, 
   3.945842969633366*^9}, {3.945843125849571*^9, 3.94584313274209*^9}, {
   3.945843174894972*^9, 3.945843178277809*^9}, {3.9458432197775517`*^9, 
   3.9458432370243473`*^9}, {3.945843287330616*^9, 3.9458432907977543`*^9}, {
   3.945843326923149*^9, 3.9458433430906563`*^9}, {3.945843384493232*^9, 
   3.945843387811741*^9}, {3.945843423557177*^9, 3.945843427076299*^9}, {
   3.9458460856414566`*^9, 3.9458460903603935`*^9}, {3.9458461244501*^9, 
   3.945846127392929*^9}, {3.945846273464027*^9, 3.945846279270181*^9}, {
   3.945846311960058*^9, 3.945846315350111*^9}, {3.945846366817175*^9, 
   3.945846382831234*^9}, {3.945846756353731*^9, 3.9458467662170296`*^9}, {
   3.945846811099188*^9, 3.945846841686339*^9}, {3.945846884211832*^9, 
   3.945847260236458*^9}, {3.945847371762398*^9, 3.9458473779483223`*^9}, {
   3.945847468577452*^9, 3.945847473866535*^9}, {3.9458476375888367`*^9, 
   3.945847641254919*^9}, {3.945847770316178*^9, 3.9458477741893463`*^9}, {
   3.94584781182493*^9, 3.9458478153183575`*^9}, {3.94584788583465*^9, 
   3.945847888720951*^9}, {3.94584794845273*^9, 3.9458479545306664`*^9}, {
   3.945848036235821*^9, 3.945848039850874*^9}, {3.945848209145437*^9, 
   3.945848213365254*^9}, {3.945848428704586*^9, 3.945848437990104*^9}, {
   3.945848526693582*^9, 3.945848534626331*^9}, {3.945848666528978*^9, 
   3.94584868269029*^9}, {3.945848775077949*^9, 3.945848778998434*^9}, {
   3.945848877398905*^9, 3.945848886629158*^9}, {3.9458491238654*^9, 
   3.945849128054989*^9}, {3.945849197156975*^9, 3.9458492011715355`*^9}, {
   3.9458492397412167`*^9, 3.945849244243763*^9}, 3.945849479846901*^9, {
   3.945851715909244*^9, 3.945851732617178*^9}, 3.945853235726444*^9, {
   3.945853633264748*^9, 3.9458536354922667`*^9}, {3.946058981146543*^9, 
   3.946058983238126*^9}, {3.946113816440451*^9, 3.946113833217655*^9}, 
   3.946113923272053*^9, 3.9462998579964046`*^9},
 CellLabel->"In[16]:=",ExpressionUUID->"90297db1-2eea-6346-9338-a3e8dcfe0024"]
}, Closed]],

Cell[CellGroupData[{

Cell["QAP constructions", "Subsection",
 CellChangeTimes->{{3.946258018000845*^9, 3.9462580514460297`*^9}, {
  3.946439582465828*^9, 
  3.94643958360841*^9}},ExpressionUUID->"79ef6085-3de7-3c49-8561-\
f943fbd2d431"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP1", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258220966779*^9, 3.946258253166219*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"e725b315-4161-274c-8798-a4e0c807d6a8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP2", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"PonceletPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258127112749*^9, 3.946258205014044*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"60fea3de-a36e-734d-b67f-75eab8f36838"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP3", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258267006763*^9, 3.946258272798765*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"422bd8e2-a85e-d748-b542-6c9b62c11efd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP4", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsogonal", "[", 
        RowBox[{"P", ",", 
         RowBox[{"{", 
          RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsogonal", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"{", 
          RowBox[{"P", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258285271057*^9, 3.946258529254532*^9}, {
  3.946258821686931*^9, 3.946258862614427*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"d021f1ab-c58d-b74b-8aa5-a62365464cc5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP5", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsotomico", "[", 
        RowBox[{"P", ",", 
         RowBox[{"{", 
          RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", "P"}], 
      "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsotomico", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"{", 
          RowBox[{"P", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", "Q"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946552139912605*^9, 3.946552177047758*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"023d4850-e194-b941-a762-4c9a532e11d1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP6", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Medio", "[", 
    RowBox[{
     RowBox[{"QAP2", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}], ",", 
     RowBox[{"QAP4", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946554002925066*^9, 3.946554042045203*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"62ef2468-c328-714d-8bf7-299b142a086d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP7", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Q1", ",", "Q2", ",", "Q3", ",", "Q4", ",", "R1", ",", "R2"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Q1", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q2", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q3", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q4", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R1", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q2", ",", "Q3", ",", "Q4"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R2", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q1", ",", "Q3", ",", "Q4"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R1"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R2"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946258285271057*^9, 3.946258529254532*^9}, {
  3.946258821686931*^9, 3.946258862614427*^9}, {3.946290848591799*^9, 
  3.946291021534954*^9}, {3.946291111031261*^9, 3.946291120455242*^9}, {
  3.946696200711548*^9, 3.946696200806263*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"d734f707-6812-364b-b359-ac3a6bb66e72"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MiquelPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"U", ",", "V", ",", "O1", ",", "O2"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"U", "=", 
       RowBox[{"Punto", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "Q"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"V", "=", 
       RowBox[{"Punto", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "S"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"O1", "=", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "S", ",", "U"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"O2", "=", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"R", ",", "S", ",", "V"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimetriaAxial", "[", 
       RowBox[{"S", ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"O1", ",", "O2"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]",
     "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946294457093628*^9, 3.946294688202664*^9}, {
   3.9462961458488*^9, 3.9462961471441994`*^9}, 3.9462963028076897`*^9, {
   3.9462973681984005`*^9, 3.946297370950136*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"34f7e383-98aa-bc47-9867-166186424dd4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MiquelCircle", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"U", ",", "V", ",", "W", ",", "O1", ",", "O2", ",", "O3"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"U", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"V", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O1", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "S", ",", "U"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O2", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"R", ",", "S", ",", "V"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O3", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"Q", ",", "R", ",", "U"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CircunferenciaTresPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"O1", ",", "O2", ",", "O3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946295931650831*^9, 3.9462959921519623`*^9}, {
  3.9462960978401566`*^9, 3.946296126960247*^9}, {3.946296309416164*^9, 
  3.946296387663599*^9}, {3.946296507206955*^9, 3.946296515015978*^9}, {
  3.9462965951590157`*^9, 3.9462966339272327`*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"4370c731-693f-a941-82c8-1f6a14f724b2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP8", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"SimetriaCentral", "[", 
    RowBox[{
     RowBox[{"QAP4", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}], ",", 
     RowBox[{"QAP2", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946554262541748*^9, 3.946554276084837*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"6e2024d9-4541-ea4e-a308-49a8bb9b87a5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP9", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c1", ",", "c2", ",", "c3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"c1", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c2", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "Q", ",", "S", ",", "R"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c3", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "R", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CentroRadical", "[", 
      RowBox[{"c1", ",", "c2", ",", "c3"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9462975678957386`*^9, 3.94629768995805*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"384fc915-4ebd-5342-9174-a166a5e7f52d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP10", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Baricentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946554372389721*^9, 3.94655438207695*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"e878baba-ea71-dd4f-b972-2e4c3753c774"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP11", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Circuncentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946554416053346*^9, 3.946554423653038*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"4200ee2b-abeb-b246-85fa-68f1ce5d836b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP12", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->"In[30]:=",ExpressionUUID->"8131db8a-5012-e741-93f3-ec6da52923f1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP34", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"P1", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P2", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P3", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P4", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"QAP2", "[", 
       RowBox[{"{", 
        RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946362022452154*^9, 3.9463621697479362`*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"3e5eb206-464c-7e4f-b628-98c50c5a4629"]
}, Closed]],

Cell[CellGroupData[{

Cell["Auxiliary functions", "Subsection",
 CellChangeTimes->{
  3.818667972143658*^9, {3.8186680382464933`*^9, 3.818668041714528*^9}, {
   3.818668136826049*^9, 3.818668143553762*^9}, {3.818685183717651*^9, 
   3.818685185711126*^9}},ExpressionUUID->"d004e03f-8f12-9a43-865f-\
339812029417"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"EqualPointsQ", "[", 
      RowBox[{"ptP_", ",", "ptQ_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cross", "[", 
           RowBox[{"ptP", ",", "ptQ"}], "]"}], "/.", "sustS"}], "/.", 
         "sustC"}], ",", "cond"}], "]"}], "===", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.9471329969160147`*^9, 3.9471330125155973`*^9}, {
  3.947133479684403*^9, 3.947133480044634*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],

Cell[CellGroupData[{

Cell["Quadrilateral routines", "Subsection",
 CellChangeTimes->{{3.945509919017998*^9, 
  3.945509932600797*^9}},ExpressionUUID->"2a49be25-3c4e-430e-86c6-\
869880736f30"],

Cell[CellGroupData[{

Cell["Vertex centroid", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.947132319963703*^9, 
  3.947132328106987*^9}},ExpressionUUID->"a576f9af-1f5b-4213-b4d3-\
e7b66981337e"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3Qd8FGX+P3D+v7v7nb+zAPZTT7EgoJyn56moZ0fQKBq6dIggATVSgmBo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    "], {{0, 389.2075471698113}, {491.0943396226415, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{491.0943396226415, 389.2075471698113},
  PlotRange->{{0, 491.0943396226415}, {0, 389.2075471698113}}]], "Text",
 CellChangeTimes->{
  3.945509787103263*^9},ExpressionUUID->"f7950398-57cb-4ee6-bf14-\
597b39eb91df"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"P", ",", "Q"}], "]"}], ",", 
       RowBox[{"Medio", "[", 
        RowBox[{"R", ",", "S"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"P", ",", "S"}], "]"}], ",", 
       RowBox[{"Medio", "[", 
        RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
  3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
  3.9455136200666037`*^9}, {3.946439211017157*^9, 3.946439211737526*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"cf738f77-0d96-4e62-81a0-f2a504594dc8"]
}, Closed]],

Cell[CellGroupData[{

Cell["Poncelet point", "Subsubsection",
 CellChangeTimes->{{3.945509682961616*^9, 3.945509705247427*^9}, {
   3.945516718286007*^9, 3.945516720220911*^9}, 
   3.947132291355841*^9},ExpressionUUID->"f7957972-a4e9-446f-bafd-\
6774f0dd3699"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "PuntoDePoncelet", " ", "is", " ", "implemented", " ", "in", " ", "the", 
    " ", "baricentricas", " ", "package"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"PonceletPoint", "[", 
     RowBox[{"{", 
      RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
    RowBox[{"PuntoDePoncelet", "[", 
     RowBox[{"P", ",", 
      RowBox[{"{", 
       RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.945506298668439*^9, 3.9455064957646704`*^9}, {
  3.945508100242526*^9, 3.945508119954049*^9}, {3.9455093671686244`*^9, 
  3.945509538952415*^9}, {3.9455167413982186`*^9, 3.945516826125304*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"44de57fd-6e7d-4d98-94a0-c7b93947eadd"]
}, Closed]],

Cell[CellGroupData[{

Cell["Steiner point", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.947132277507908*^9, 
  3.947132283924074*^9}},ExpressionUUID->"ae32c2db-9871-344f-aabd-\
a2543db56100"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "X", ",", "Y", ",", "Z", ",", "T", ",", "U", ",", "V", ",", "W"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"X", ",", "Y", ",", "Z", ",", "U", ",", "T"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Apply", "[", 
          RowBox[{"Medio", ",", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"P", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"R", ",", "Q"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "R"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"S", ",", "Q"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"V", ",", "W"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Circuncentro", "[", "#", "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"X", ",", "Y", ",", "U"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Y", ",", "Z", ",", "T"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimetriaAxial", "[", 
       RowBox[{"Y", ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"V", ",", "W"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945506298668439*^9, 3.9455064957646704`*^9}, {
  3.945508100242526*^9, 3.945508119954049*^9}, {3.9455093671686244`*^9, 
  3.945509538952415*^9}, {3.945518206235336*^9, 3.945518260181164*^9}, {
  3.945518437370175*^9, 3.9455184493471375`*^9}, {3.947132243612131*^9, 
  3.947132244379742*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"db0fcba9-9144-4df7-981b-db22bb466a6e"]
}, Closed]],

Cell[CellGroupData[{

Cell["Diagonal point", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
   3.945521331783347*^9, 3.9455213360947638`*^9}, 
   3.947132343027188*^9},ExpressionUUID->"29f12ada-9fd0-4747-b323-\
2cf96d6fb52e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"P", ",", "R"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
  3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
  3.9455136200666037`*^9}, {3.945521346455207*^9, 3.9455213813107405`*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"158fb412-c771-43ab-b43b-a357380f4a11"]
}, Closed]],

Cell[CellGroupData[{

Cell["Central quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.9464416787367783`*^9, 3.946441687230852*^9}, 
   3.947147898383025*^9},ExpressionUUID->"5a543829-5641-9144-8dd0-\
57eb7cf1938d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentralQuadrilateral", "[", "n_", "]"}], ":=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptB", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}]}], "]"}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellLabel->"In[40]:=",ExpressionUUID->"35cb8ff3-829e-654a-a95d-e2c972de6be9"]
}, Closed]],

Cell[CellGroupData[{

Cell["Area of a quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 
  3.945509840152308*^9}},ExpressionUUID->"e039afe9-d89d-4ec4-94b9-\
ddb3f9f259e0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AreaQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"AreaTriangulo", "[", 
     RowBox[{"{", 
      RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}], "+", 
    RowBox[{"AreaTriangulo", "[", 
     RowBox[{"{", 
      RowBox[{"R", ",", "S", ",", "P"}], "}"}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945518557002711*^9, 3.945518607763227*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"2db3c5dc-e4da-4371-937a-22cb108c81e1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Perspective quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945619500071995*^9, 3.9456195111611595`*^9}, {
   3.94561961722077*^9, 3.945619628845907*^9}, {3.945620201468649*^9, 
   3.945620207996176*^9}, {3.946093948975952*^9, 3.946093951552325*^9}, 
   3.94619393871496*^9, 
   3.947147899655007*^9},ExpressionUUID->"bd16b166-d506-5544-b5d0-\
7aa6edfca35b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PerspectiveQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "P2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"R1", ",", "R2"}], "]"}]}], "}"}], "]"}], "==", "0"}], "&&", 
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "P2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"S1", ",", "S2"}], "]"}]}], "}"}], "]"}], "==", 
    "0"}]}]}]], "Input",
 CellChangeTimes->{{3.945619541933253*^9, 3.945619598797678*^9}, {
  3.945620227236483*^9, 3.945620398996369*^9}, {3.946093956887635*^9, 
  3.9460940140877304`*^9}, {3.9460946192084503`*^9, 3.9460946637685833`*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"6cd12b17-ccf6-1f40-8216-e746f72a898c"]
}, Closed]],

Cell[CellGroupData[{

Cell["Similar and homothetic quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 3.945509840152308*^9}, {
  3.945518917754542*^9, 3.945518929298341*^9}, {3.94551954978488*^9, 
  3.945519554745524*^9}, {3.9471326902197247`*^9, 3.9471326941873684`*^9}, {
  3.947132774954735*^9, 
  3.947132785771118*^9}},ExpressionUUID->"d546f79d-5ed9-4f99-846e-\
3ac1a3756b86"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SimilarQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SonSemejantes", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "Q1", ",", "R1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"P2", ",", "Q2", ",", "R2"}], "}"}]}], "]"}], "&&", 
    RowBox[{"SonSemejantes", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Q1", ",", "R1", ",", "S1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q2", ",", "R2", ",", "S2"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945518557002711*^9, 3.945518607763227*^9}, {
  3.9455189375627*^9, 3.945519039097607*^9}, {3.945519562008997*^9, 
  3.945519564865857*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"5668c7c2-b2f3-48b4-bb4e-3f493e46ab9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SonHomoteticos", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "Q1", ",", "R1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"P2", ",", "Q2", ",", "R2"}], "}"}]}], "]"}], "&&", 
    RowBox[{"SonHomoteticos", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Q1", ",", "R1", ",", "S1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q2", ",", "R2", ",", "S2"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.9455195703380117`*^9, 3.945519605171223*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"d07dfa48-d9b6-433c-9d4d-8f2532f1bec3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Congruent quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945619500071995*^9, 3.9456195111611595`*^9}, {
   3.94561961722077*^9, 3.945619628845907*^9}, {3.945620201468649*^9, 
   3.945620207996176*^9}, 3.946437820730978*^9, 
   3.9471479009831057`*^9},ExpressionUUID->"8f461d45-0647-c84b-9fe0-\
f72d3601c63f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CongruentQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P1", ",", "Q1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P2", ",", "Q2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"Q1", ",", "R1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"Q2", ",", "R2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"R1", ",", "S1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"R2", ",", "S2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"S1", ",", "P1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"S2", ",", "P2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P1", ",", "R1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P2", ",", "R2"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945619541933253*^9, 3.945619598797678*^9}, {
  3.945620227236483*^9, 3.945620398996369*^9}, {3.946287549140295*^9, 
  3.946287549827748*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"5485ed32-34f6-e64e-bd2a-b4e163c2b97f"]
}, Closed]],

Cell[CellGroupData[{

Cell["Orthogonal quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.946437760717503*^9, 3.9464377702703495`*^9}, 
   3.947147903551467*^9},ExpressionUUID->"54169a90-c35c-7a4a-a37f-\
78c9753e8eeb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OrthogonalQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "Q1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"P2", ",", "Q2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "R1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q2", ",", "R2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"R1", ",", "S1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"R2", ",", "S2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"S1", ",", "P1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"S2", ",", "P2"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9455195703380117`*^9, 3.945519605171223*^9}, {
  3.9460039858449364`*^9, 3.946003994260566*^9}, {3.946004044908913*^9, 
  3.946004131276815*^9}, {3.946004174101141*^9, 3.946004205589377*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"c1bc4c8d-1ecd-654a-b9e2-f902b4037dfa"]
}, Closed]],

Cell[CellGroupData[{

Cell["Conconic quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.946188760871956*^9, 3.946188779525741*^9}, {
  3.9464378271237335`*^9, 
  3.946437830963283*^9}},ExpressionUUID->"e126572d-bdab-a047-b925-\
c2661290f09e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "returns", " ", "TRUE", " ", "if", " ", "ABCD", " ", "and", " ", "EFGH", 
    " ", "are", " ", "conconic"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"conconicQuadQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA_", ",", "ptB_", ",", "ptC_", ",", "ptD_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE_", ",", "ptF_", ",", "ptG_", ",", "ptH_"}], "}"}]}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "conic", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"conic", "=", 
        RowBox[{"ConicaCincoPuntos", "[", 
         RowBox[{"{", 
          RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD", ",", "ptE"}], 
          "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sustituirxyz", "[", 
            RowBox[{"conic", ",", "#"}], "]"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{"ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], "==", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.946440275192674*^9, 3.946440364775547*^9}, {
  3.946557553720074*^9, 3.94655756021654*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"3eac6f83-9820-5d4f-9acd-4f2df1b13510"]
}, Closed]],

Cell[CellGroupData[{

Cell["Find QA center", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 3.945509840152308*^9}, {
  3.945518917754542*^9, 3.945518929298341*^9}, {3.94551954978488*^9, 
  3.945519554745524*^9}, {3.946186993811855*^9, 
  3.946187000755444*^9}},ExpressionUUID->"1d12da59-37f1-9842-ad9c-\
eb916041816f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "findQACenter", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"findQACenter", "[", 
    RowBox[{"ptP_", ",", 
     RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"found", "=", "0"}], ",", "sustCS", ",", 
       RowBox[{"nc", "=", 
        RowBox[{"Length", "[", "QAP", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sustCS", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"sustS", ",", "sustC"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Monitor", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "<=", "nc"}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"Simplify", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Cross", "[", 
                   RowBox[{"ptP", ",", 
                    RowBox[{"QAP", "[", "i", "]"}]}], "]"}], "//.", 
                  "sustCS"}], ",", "cond"}], "]"}], ")"}], "==", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
             RowBox[{
              RowBox[{"found", "=", "i"}], ";", 
              RowBox[{"Break", "[", "]"}]}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<Identifying the center... \>\"", ",", 
           RowBox[{"ProgressIndicator", "[", 
            RowBox[{"i", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "nc"}], "}"}]}], "]"}], ",", "\"\< \>\"", ",",
            "i", ",", "\"\</\>\"", ",", "nc"}], "}"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"found", "==", "0"}], ",", "\"\<unknown\>\"", ",", 
        RowBox[{"\"\<QA-P\>\"", "<>", 
         RowBox[{"ToString", "[", "found", "]"}]}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.946187173054329*^9, 3.946187213931603*^9}, {
   3.946187246486248*^9, 3.9461872843092823`*^9}, 3.946187365054121*^9, {
   3.946187480278492*^9, 3.9461874874540024`*^9}, 3.9461880462086487`*^9, {
   3.9461881054797783`*^9, 3.9461881291423397`*^9}, {3.946188268454359*^9, 
   3.9461883008316956`*^9}, {3.94618835627853*^9, 3.946188455318756*^9}, 
   3.946257761266403*^9, {3.946258916015583*^9, 3.94625896478343*^9}, {
   3.946259615877109*^9, 3.946259655534961*^9}, {3.947132891348004*^9, 
   3.947132924188181*^9}, {3.9471329718839912`*^9, 3.9471329845888424`*^9}, {
   3.947133025988367*^9, 3.94713303106756*^9}, {3.9471334511324434`*^9, 
   3.94713348841169*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"806c98e7-c027-de46-8fc2-cc2eda959f64"]
}, Closed]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Properties ", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 
  3.946441726397751*^9}},ExpressionUUID->"2609bf4c-7f5c-314e-a744-\
f86d4be283dd"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvW9MG1fex+v758V9MS8uL3mBlCtkiReRqggh3UTRCl4QbWQJokYIkUSW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    "], {{0, 212.60377358490564`}, {739.6981132075471, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{739.6981132075471, 212.60377358490564`},
  PlotRange->{{0, 739.6981132075471}, {0, 212.60377358490564`}}]], "Text",
 CellChangeTimes->{3.946440201275278*^9, 
  3.9474814410800457`*^9},ExpressionUUID->"20c7ab22-8503-fd4d-9d34-\
15585b88ac29"]
}, Open  ]],

Cell[CellGroupData[{

Cell["X (13)", "Subsection",
 CellChangeTimes->{{3.94748145699555*^9, 
  3.9474814622333145`*^9}},ExpressionUUID->"990a55c4-883d-5442-8fbf-\
2dbb85b093b7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "13", "]"}]}]], "Input",
 CellChangeTimes->{{3.947481663496107*^9, 3.947481665447899*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"a51e3372-af24-ce43-8f2d-a262f2467327"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{"6", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["b", "2"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"2", " ", 
           SqrtBox["3"], " ", "S"}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"7", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.947481666678438*^9, 3.947481684054268*^9}},
 CellLabel->"Out[50]=",ExpressionUUID->"30581973-f30b-cf46-9f35-c0c2fd6ecd89"]
}, Open  ]],

Cell["[ABCD] = 3[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946524758383976*^9, 3.946524760090557*^9}, {
  3.946554741596716*^9, 
  3.946554741892283*^9}},ExpressionUUID->"a391f71e-f986-7743-bd67-\
91fb9d7f7783"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Factor", "[", 
     FractionBox[
      RowBox[{"AreaQuad", "[", 
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], 
      RowBox[{"AreaQuad", "[", 
       RowBox[{"{", 
        RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]], 
     "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"S", "->", 
      RowBox[{"a", "^", "2"}]}], "}"}]}], ",", "square"}], "]"}]], "Input",
 CellChangeTimes->{{3.946404183748872*^9, 3.9464044327380733`*^9}, {
   3.946404486826443*^9, 3.946404554738617*^9}, {3.94640460175342*^9, 
   3.9464047397539177`*^9}, {3.9464047757300878`*^9, 
   3.9464047905780525`*^9}, {3.94640483618565*^9, 3.946404847377804*^9}, {
   3.946405338474016*^9, 3.9464053461775513`*^9}, {3.946405564265072*^9, 
   3.946405572424937*^9}, {3.9464062522955456`*^9, 3.9464062538159084`*^9}, {
   3.946406288176468*^9, 3.946406321944195*^9}, 3.946406496895973*^9, {
   3.946524805509257*^9, 3.9465248084287834`*^9}, {3.946554749740492*^9, 
   3.946554760492401*^9}, {3.946554837268652*^9, 3.946554840100405*^9}, {
   3.946555045875881*^9, 3.946555046900019*^9}, 3.946555649083729*^9, {
   3.946556028970593*^9, 3.946556075515137*^9}, {3.9465561282822514`*^9, 
   3.946556169659782*^9}, {3.9465562101868362`*^9, 3.946556236842209*^9}, 
   3.9474816598897305`*^9, {3.947481738816206*^9, 3.947481741880028*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"6cbe327a-3800-744a-9ca4-36b428ff2919"],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{3.947481743466856*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"3a198fa9-92f7-a541-b067-1f68c3946927"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (14)", "Subsection",
 CellChangeTimes->{{3.94748145699555*^9, 
  3.947481475449194*^9}},ExpressionUUID->"ca969abc-f772-1849-9f1d-\
57b0d16b2450"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "14", "]"}]}]], "Input",
 CellChangeTimes->{{3.947481663496107*^9, 3.947481665447899*^9}, {
  3.9474817636555023`*^9, 3.947481763728752*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"61a84cdc-281b-1144-99d8-2c4bce4cb8fc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"11", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["b", "2"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"2", " ", 
           SqrtBox["3"], " ", "S"}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"7", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.947481666678438*^9, 3.947481684054268*^9}, 
   3.947481764718275*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"94202046-bc25-c548-8b04-e3619cc6eea4"]
}, Open  ]],

Cell["[ABCD] = 3[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946524758383976*^9, 3.946524760090557*^9}, {
  3.946554741596716*^9, 
  3.946554741892283*^9}},ExpressionUUID->"db05976e-5c98-254a-9533-\
340b3684c183"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Factor", "[", 
     FractionBox[
      RowBox[{"AreaQuad", "[", 
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], 
      RowBox[{"AreaQuad", "[", 
       RowBox[{"{", 
        RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]], 
     "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"S", "->", 
      RowBox[{"a", "^", "2"}]}], "}"}]}], ",", "square"}], "]"}]], "Input",
 CellChangeTimes->{{3.946404183748872*^9, 3.9464044327380733`*^9}, {
   3.946404486826443*^9, 3.946404554738617*^9}, {3.94640460175342*^9, 
   3.9464047397539177`*^9}, {3.9464047757300878`*^9, 
   3.9464047905780525`*^9}, {3.94640483618565*^9, 3.946404847377804*^9}, {
   3.946405338474016*^9, 3.9464053461775513`*^9}, {3.946405564265072*^9, 
   3.946405572424937*^9}, {3.9464062522955456`*^9, 3.9464062538159084`*^9}, {
   3.946406288176468*^9, 3.946406321944195*^9}, 3.946406496895973*^9, {
   3.946524805509257*^9, 3.9465248084287834`*^9}, {3.946554749740492*^9, 
   3.946554760492401*^9}, {3.946554837268652*^9, 3.946554840100405*^9}, {
   3.946555045875881*^9, 3.946555046900019*^9}, 3.946555649083729*^9, {
   3.946556028970593*^9, 3.946556075515137*^9}, {3.9465561282822514`*^9, 
   3.946556169659782*^9}, {3.9465562101868362`*^9, 3.946556236842209*^9}, 
   3.9474816598897305`*^9, {3.947481738816206*^9, 3.947481741880028*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"92b2645c-4d54-d340-86f9-b447c8242fbf"],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{{3.947481743466856*^9, 3.9474817682935276`*^9}},
 CellLabel->"Out[53]=",ExpressionUUID->"2b26f2fc-47e9-2448-80b5-0d3939a1e489"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (183)", "Subsection",
 CellChangeTimes->{{3.94748145699555*^9, 
  3.94748148305665*^9}},ExpressionUUID->"8571e662-dc6e-c94d-9178-\
5a36d05c5564"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "183", "]"}]}]], "Input",
 CellChangeTimes->{{3.9474818184158783`*^9, 3.9474818189595776`*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"8d2985b4-8289-ac49-8f45-3a00d95d4959"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "4"]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.94748181956073*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"df6b6337-1f96-e940-8339-d48b40b3b6f8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[ABCD] = 49[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946524783328291*^9, 3.946524794829315*^9}, {
  3.946555093308216*^9, 
  3.9465550939712267`*^9}},ExpressionUUID->"e8eba0e2-018a-be4a-9ccf-\
dabd4af88463"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    FractionBox[
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], 
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]], 
    "]"}], ",", "square"}], "]"}]], "Input",
 CellChangeTimes->{{3.946406337736004*^9, 3.9464063446791573`*^9}, 
   3.94640650524839*^9, {3.9465248293492737`*^9, 3.9465248332933865`*^9}, {
   3.946555098604175*^9, 3.946555106828182*^9}, {3.9474818150094337`*^9, 
   3.947481831136442*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"23c230fb-0385-9b4a-a4b2-74f970c25759"],

Cell[BoxData["49"], "Output",
 CellChangeTimes->{3.946406346255917*^9, 3.946406506003332*^9, 
  3.9465248352160625`*^9, 3.946544245445519*^9, 3.946555108083671*^9, 
  3.947481832026369*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"0e764dd0-431c-f34c-93de-39ce446358bf"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (252)", "Subsection",
 CellChangeTimes->{{3.94748145699555*^9, 
  3.9474814925201015`*^9}},ExpressionUUID->"43c3888e-a2fd-ac41-a99c-\
eb28cd9466ce"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "252", "]"}]}]], "Input",
 CellChangeTimes->{{3.9474818184158783`*^9, 3.9474818189595776`*^9}, {
  3.9474818632315693`*^9, 3.947481865095457*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"8a860fbb-1ffb-ca4d-a3f4-bd56db5e05d1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"6", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["a", "4"]}], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["b", "2"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "4"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
           SuperscriptBox["c", "3"]}], ")"}], "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"11", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "8"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["a", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"7", " ", 
              SuperscriptBox["b", "4"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"7", " ", 
              SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "8"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "4"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"7", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"11", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"6", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "6"], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
             SuperscriptBox["c", "3"]}], ")"}], "2"], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "4"], "-", 
             RowBox[{"6", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["b", "2"]}], "+", 
          SuperscriptBox["b", "4"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["c", "4"]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"6", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "4"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ")"}]}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.94748181956073*^9, 3.947481866145033*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"b58d38ca-14a6-d344-814f-16396b88bbe5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[ABCD] = 49[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946524783328291*^9, 3.946524794829315*^9}, {
  3.946555093308216*^9, 
  3.9465550939712267`*^9}},ExpressionUUID->"13faa8b4-8655-9445-a1f2-\
72421585932a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    FractionBox[
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], 
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]], 
    "]"}], ",", "square"}], "]"}]], "Input",
 CellChangeTimes->{{3.946406337736004*^9, 3.9464063446791573`*^9}, 
   3.94640650524839*^9, {3.9465248293492737`*^9, 3.9465248332933865`*^9}, {
   3.946555098604175*^9, 3.946555106828182*^9}, {3.9474818150094337`*^9, 
   3.947481831136442*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"8ee3c6e2-a7e6-794a-ad35-f9c8d2a991c0"],

Cell[BoxData["49"], "Output",
 CellChangeTimes->{3.946406346255917*^9, 3.946406506003332*^9, 
  3.9465248352160625`*^9, 3.946544245445519*^9, 3.946555108083671*^9, 
  3.947481832026369*^9, 3.947481870942478*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"452ad5da-f045-4547-8d92-e54fa57daaa7"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (352)", "Subsection",
 CellChangeTimes->{{3.94748145699555*^9, 3.9474814622333145`*^9}, {
  3.94748150072785*^9, 
  3.947481502376354*^9}},ExpressionUUID->"16d27243-ccad-6840-8ee7-\
904d956ae870"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "352", "]"}]}]], "Input",
 CellChangeTimes->{3.947482041639263*^9},
 CellLabel->"In[64]:=",ExpressionUUID->"27a1df2a-a50e-f84d-ae46-681b65924b39"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"15", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "9"}], " ", 
       SuperscriptBox["a", "6"]}], "-", 
      SuperscriptBox["b", "6"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "6"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      SuperscriptBox["c", "6"], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "6"], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", 
       SuperscriptBox["a", "6"]}], "-", 
      SuperscriptBox["b", "6"], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"9", " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "15"}], " ", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"9", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.947482042209549*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"b0b0723b-e532-fd46-8428-92477d0152f1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[EFGH] = 25[ABCD]", "Subsubsection",
 CellChangeTimes->{{3.946524882039469*^9, 3.946524911797131*^9}, {
  3.9465552587798004`*^9, 
  3.946555259266997*^9}},ExpressionUUID->"1bfe84dc-e2ab-2a41-a751-\
cfa311c2763f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    FractionBox[
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], 
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}]], 
    "]"}], ",", "square"}], "]"}]], "Input",
 CellChangeTimes->{{3.9464063788878155`*^9, 3.946406402599588*^9}, {
  3.9464065127606697`*^9, 3.946406551870569*^9}, {3.946524914124859*^9, 
  3.9465249170207653`*^9}, {3.946555263419544*^9, 3.9465552700352535`*^9}, {
  3.947482039001007*^9, 3.9474820540155907`*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"69ba7802-f556-d84f-bdb0-77255e869cc3"],

Cell[BoxData["25"], "Output",
 CellChangeTimes->{{3.946406385898546*^9, 3.9464064038679943`*^9}, 
   3.946406513551883*^9, 3.946406552621641*^9, 3.946524918187322*^9, 
   3.946544260037796*^9, 3.946555271014698*^9, 3.946556341052319*^9, 
   3.947482055452793*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"3dc6d3a2-0ef8-b644-a3c6-afbf1d91b9da"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (496)", "Subsection",
 CellChangeTimes->{{3.94748145699555*^9, 3.9474814622333145`*^9}, {
  3.94748151931295*^9, 
  3.9474815217041492`*^9}},ExpressionUUID->"e8e5cdc4-1e15-c741-8b36-\
55a5a40b37ec"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "496", "]"}]}]], "Input",
 CellChangeTimes->{3.947481919295038*^9},
 CellLabel->"In[58]:=",ExpressionUUID->"1a8fe7e4-8c4d-f944-b721-cc7d1aeadb71"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"c", " ", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"4", " ", 
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "3"], "-", 
          RowBox[{"a", " ", 
           SuperscriptBox["b", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", "c"}], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", "c"}], "+", 
          SuperscriptBox["c", "3"], "+", 
          RowBox[{"a", " ", "c", " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"4", " ", 
              SqrtBox[
               RowBox[{
                RowBox[{"2", " ", 
                 SuperscriptBox["a", "2"]}], "-", 
                SuperscriptBox["b", "2"], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}], 
       ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "3"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "2"], " ", "c"}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["c", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"c", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "5"}], " ", "c"}], "+", 
            RowBox[{"4", " ", 
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"4", " ", "a", " ", "b", " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"4", " ", "a", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"4", " ", "a", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", "b", " ", "c"}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"8", " ", 
       SuperscriptBox["a", "3"], " ", "c"}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{"4", " ", "a", " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"c", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "c"}], "+", 
            SqrtBox[
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["a", "2"]}], "-", 
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}]}]]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        SuperscriptBox["c", "3"], "+", 
        RowBox[{"a", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["a", "2"]}], "-", 
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"4", " ", "a", " ", 
       SuperscriptBox["c", "2"], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"]}], "-", 
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "b", " ", "c"}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      RowBox[{"4", " ", "a", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"4", " ", "a", " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.94748192002569*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"1618e6d3-8570-fb4b-a8cd-88436a091bba"],

Cell[CellGroupData[{

Cell["[ABCD] = 8[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946524844351292*^9, 3.946524858117388*^9}, {
  3.9465551882674503`*^9, 
  3.946555189292087*^9}},ExpressionUUID->"c3b2abee-7cb0-0247-bde4-\
fc450a0f72b6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    FractionBox[
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], 
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]], 
    "]"}], ",", "square"}], "]"}]], "Input",
 CellChangeTimes->{{3.946406352215348*^9, 3.946406367448263*^9}, 
   3.946406509968422*^9, {3.946524861325182*^9, 3.9465248666207886`*^9}, {
   3.946555144204262*^9, 3.946555150140274*^9}, {3.9474819160813255`*^9, 
   3.947481931895302*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"438da6c3-7a1e-7241-a61d-417f2eace056"],

Cell[BoxData["8"], "Output",
 CellChangeTimes->{3.946406367975569*^9, 3.946406510789118*^9, 
  3.946524868051295*^9, 3.946544251860434*^9, 3.946555153136755*^9, 
  3.946556322145399*^9, 3.947481934775057*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"13b89ade-3989-c74f-9298-9810e83f58c6"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (613)", "Subsection",
 CellChangeTimes->{{3.94748145699555*^9, 3.9474814622333145`*^9}, 
   3.9474815268000793`*^9},ExpressionUUID->"f2f73996-ca76-b84f-90bb-\
e5167ca527c9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "613", "]"}]}]], "Input",
 CellChangeTimes->{
  3.947481919295038*^9, {3.947481970591791*^9, 3.9474819725031166`*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"4ad2ec31-863f-514e-b4f6-fd94de76a0d9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "3"], " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"6", " ", 
            SqrtBox[
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["a", "2"]}], "-", 
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"c", " ", 
            RowBox[{"(", 
             RowBox[{"c", "-", 
              RowBox[{"3", " ", 
               SqrtBox[
                RowBox[{
                 RowBox[{"2", " ", 
                  SuperscriptBox["a", "2"]}], "-", 
                 SuperscriptBox["b", "2"], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "5"], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", "c"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "c", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"c", " ", 
              RowBox[{"(", 
               RowBox[{"c", "-", 
                RowBox[{"3", " ", 
                 SqrtBox[
                  RowBox[{
                   RowBox[{"2", " ", 
                    SuperscriptBox["a", "2"]}], "-", 
                   SuperscriptBox["b", "2"], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}], 
          "+", 
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "4"], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"], " ", "c", " ", 
              RowBox[{"(", 
               RowBox[{"c", "+", 
                SqrtBox[
                 RowBox[{
                  RowBox[{"2", " ", 
                   SuperscriptBox["a", "2"]}], "-", 
                  SuperscriptBox["b", "2"], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["c", "3"], " ", 
              RowBox[{"(", 
               RowBox[{"c", "+", 
                RowBox[{"6", " ", 
                 SqrtBox[
                  RowBox[{
                   RowBox[{"2", " ", 
                    SuperscriptBox["a", "2"]}], "-", 
                   SuperscriptBox["b", "2"], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "5"], " ", "c"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "10"}], " ", 
          SuperscriptBox["b", "2"], " ", "c"}], "+", 
         RowBox[{"24", " ", 
          SuperscriptBox["c", "3"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", "a", " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "7"}], " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"6", " ", "c", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"]}], "-", 
            SuperscriptBox["b", "2"], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", "c", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "c"}], "+", 
            SqrtBox[
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["a", "2"]}], "-", 
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "c"}], "+", 
            RowBox[{"6", " ", 
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{"2", " ", "a", " ", "b", " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "3"], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "c"}], "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "3"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "3"], " ", "c"}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"2", " ", "a", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "6"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{"2", " ", "a", " ", 
       SuperscriptBox["b", "2"], " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", "b", " ", "c"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "3"], "-", 
         RowBox[{"b", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], "2"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "3"], " ", "c"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "b", " ", 
          SuperscriptBox["c", "3"]}], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "5"], " ", "c"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         SuperscriptBox["c", "4"]}], ")"}]}], "+", 
      RowBox[{"2", " ", "a", " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"c", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "c"}], "+", 
            SqrtBox[
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["a", "2"]}], "-", 
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}]}]]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "5"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"3", " ", "c", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "c"}], "+", 
            SqrtBox[
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["a", "2"]}], "-", 
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}]}]]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "5"], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", "c"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"c", " ", 
            RowBox[{"(", 
             RowBox[{"c", "-", 
              RowBox[{"3", " ", 
               SqrtBox[
                RowBox[{
                 RowBox[{"2", " ", 
                  SuperscriptBox["a", "2"]}], "-", 
                 SuperscriptBox["b", "2"], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", "c", " ", 
            RowBox[{"(", 
             RowBox[{"c", "+", 
              SqrtBox[
               RowBox[{
                RowBox[{"2", " ", 
                 SuperscriptBox["a", "2"]}], "-", 
                SuperscriptBox["b", "2"], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"6", " ", 
               SqrtBox[
                RowBox[{
                 RowBox[{"2", " ", 
                  SuperscriptBox["a", "2"]}], "-", 
                 SuperscriptBox["b", "2"], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "3"], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], "-", 
        RowBox[{"2", " ", "a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "3"], " ", "c"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", "b", " ", 
         SuperscriptBox["c", "3"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "3"], " ", "c"}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"2", " ", "a", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "3"], " ", "b"}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.94748192002569*^9, 3.9474819735208874`*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"0d09f034-b662-4546-8200-8517c99111e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[ABCD] = 8[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946524844351292*^9, 3.946524858117388*^9}, {
  3.9465551882674503`*^9, 
  3.946555189292087*^9}},ExpressionUUID->"5b5af5e6-d514-2646-99c4-\
15ab247e97ce"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    FractionBox[
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], 
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]], 
    "]"}], ",", "square"}], "]"}]], "Input",
 CellChangeTimes->{{3.946406352215348*^9, 3.946406367448263*^9}, 
   3.946406509968422*^9, {3.946524861325182*^9, 3.9465248666207886`*^9}, {
   3.946555144204262*^9, 3.946555150140274*^9}, {3.9474819160813255`*^9, 
   3.947481931895302*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"8305524c-efcd-f746-9da3-f38232a4a0a0"],

Cell[BoxData["8"], "Output",
 CellChangeTimes->{3.946406367975569*^9, 3.946406510789118*^9, 
  3.946524868051295*^9, 3.946544251860434*^9, 3.946555153136755*^9, 
  3.946556322145399*^9, 3.947481934775057*^9, 3.947481982162121*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"33fb2ed4-e375-cf40-92f5-132174550154"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (988)", "Subsection",
 CellChangeTimes->{{3.94748145699555*^9, 3.9474814622333145`*^9}, {
  3.947481531663824*^9, 
  3.947481532159704*^9}},ExpressionUUID->"f093b193-dced-7d4f-9700-\
2b552fd364e8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "988", "]"}]}]], "Input",
 CellChangeTimes->{
  3.947481919295038*^9, {3.94748198925585*^9, 3.9474819907506027`*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"d2f7624f-ca22-de4e-9bc2-56b624e6feed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "5"}], " ", 
         SuperscriptBox["a", "3"]}], "+", 
        RowBox[{"3", " ", "a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["a", "3"]}], "-", 
        RowBox[{"3", " ", "a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"5", " ", "a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}], 
         RowBox[{"3", "/", "2"}]]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "7"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "c"}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"]}], "-", 
            SuperscriptBox["b", "2"], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"]}], "-", 
            SuperscriptBox["b", "2"], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "c"}], "+", 
         RowBox[{"3", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"]}], "-", 
            SuperscriptBox["b", "2"], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"c", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"13", " ", "c"}], "+", 
            RowBox[{"3", " ", 
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "3"]}], " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "b", " ", "c"}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", "b", " ", "c"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "3"], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "c"}], "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "3"]}], ")"}]}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"3", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "b"}], "+", "c"}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "b"}], "+", "c"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"b", " ", "c"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "3"], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "c"}], "-", 
         RowBox[{"3", " ", "b", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         SuperscriptBox["c", "3"]}], ")"}]}], "-", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "3"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "c"}], "+", 
         RowBox[{"2", " ", "b", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "3"]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"c", "+", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{"c", "+", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"c", "+", 
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", "c"}], "+", 
         RowBox[{"6", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"]}], "-", 
            SuperscriptBox["b", "2"], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"c", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"13", " ", "c"}], "+", 
            RowBox[{"6", " ", 
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SuperscriptBox["a", "3"]}], "-", 
          RowBox[{"3", " ", "a", " ", 
           SuperscriptBox["b", "2"]}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox["a", "2"], " ", "c"}], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["b", "2"], " ", "c"}], "+", 
          RowBox[{"5", " ", "a", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox["c", "3"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], ")"}]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "3"]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "c"}], "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "c"}], "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}]]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", "c"}], "+", 
           RowBox[{"3", " ", 
            SqrtBox[
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["a", "2"]}], "-", 
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}]}]]}]}], ")"}]}]}], ")"}]}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}], "-", 
        RowBox[{"3", " ", "a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "+", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"3", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "b"}], "+", "c"}], ")"}]}], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "-", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"3", " ", "c"}]}], ")"}]}], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.94748192002569*^9, 3.9474819916089497`*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"66007504-f36d-6548-80d3-e454666d714d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[ABCD] = 8[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946524844351292*^9, 3.946524858117388*^9}, {
  3.9465551882674503`*^9, 
  3.946555189292087*^9}},ExpressionUUID->"c0cffa71-a4d6-8f4e-ba5d-\
cd628cc6e89d"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    FractionBox[
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], 
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]], 
    "]"}], ",", "square"}], "]"}]], "Input",
 CellChangeTimes->{{3.946406352215348*^9, 3.946406367448263*^9}, 
   3.946406509968422*^9, {3.946524861325182*^9, 3.9465248666207886`*^9}, {
   3.946555144204262*^9, 3.946555150140274*^9}, {3.9474819160813255`*^9, 
   3.947481931895302*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"b6e98e70-a4d4-8948-82ac-c1205e5e631a"]
}, Open  ]],

Cell[BoxData["8"], "Output",
 CellChangeTimes->{3.946406367975569*^9, 3.946406510789118*^9, 
  3.946524868051295*^9, 3.946544251860434*^9, 3.946555153136755*^9, 
  3.946556322145399*^9, 3.947481934775057*^9, 3.9474819949403305`*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"237feba6-38cd-1e4e-8433-80607e0ffd6e"]
}, Closed]]
},
CellGrouping->Manual,
WindowSize->{1293.2830188679245`, 654.7924528301886},
WindowMargins->{{0, Automatic}, {Automatic, -0.6792452830188679}},
FrontEndVersion->"14.0 for Microsoft Windows (64-bit) (December 12, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"f59f3ec9-2c82-e64c-a7b1-bf7907ba01e2"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 225, 4, 98, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[786, 26, 1345, 23, 173, "Text",ExpressionUUID->"08758b0a-705f-b842-b1d6-6a28a79b6218"],
Cell[CellGroupData[{
Cell[2156, 53, 200, 4, 67, "Section",ExpressionUUID->"5e4c6aa2-710c-4599-941e-5f13e499af78"],
Cell[CellGroupData[{
Cell[2381, 61, 1411, 31, 67, "Input",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"],
Cell[3795, 94, 274, 6, 32, "Output",ExpressionUUID->"55f3717f-3585-594b-914b-995d2ccd4855"]
}, Open  ]],
Cell[4084, 103, 391, 12, 31, "Input",ExpressionUUID->"d0c5b345-9e88-e04a-9131-1e258249750e"]
}, Closed]],
Cell[CellGroupData[{
Cell[4512, 120, 255, 4, 53, "Section",ExpressionUUID->"cf60f297-bbcd-8748-b453-e7118b4e0a98"],
Cell[CellGroupData[{
Cell[4792, 128, 212, 4, 54, "Subsection",ExpressionUUID->"c8cca55e-04f1-8f4a-b670-3c3179eed91e"],
Cell[5007, 134, 271223, 7062, 3643, "Input",ExpressionUUID->"90297db1-2eea-6346-9338-a3e8dcfe0024"]
}, Closed]],
Cell[CellGroupData[{
Cell[276267, 7201, 215, 4, 38, "Subsection",ExpressionUUID->"79ef6085-3de7-3c49-8561-f943fbd2d431"],
Cell[276485, 7207, 434, 11, 28, "Input",ExpressionUUID->"e725b315-4161-274c-8798-a4e0c807d6a8"],
Cell[276922, 7220, 435, 11, 28, "Input",ExpressionUUID->"60fea3de-a36e-734d-b67f-75eab8f36838"],
Cell[277360, 7233, 434, 11, 28, "Input",ExpressionUUID->"422bd8e2-a85e-d748-b542-6c9b62c11efd"],
Cell[277797, 7246, 1078, 29, 28, "Input",ExpressionUUID->"d021f1ab-c58d-b74b-8aa5-a62365464cc5"],
Cell[278878, 7277, 816, 23, 28, "Input",ExpressionUUID->"023d4850-e194-b941-a762-4c9a532e11d1"],
Cell[279697, 7302, 599, 16, 28, "Input",ExpressionUUID->"62ef2468-c328-714d-8bf7-299b142a086d"],
Cell[280299, 7320, 2069, 53, 181, "Input",ExpressionUUID->"d734f707-6812-364b-b359-ac3a6bb66e72"],
Cell[282371, 7375, 1710, 46, 143, "Input",ExpressionUUID->"34f7e383-98aa-bc47-9867-166186424dd4"],
Cell[284084, 7423, 1910, 50, 162, "Input",ExpressionUUID->"4370c731-693f-a941-82c8-1f6a14f724b2"],
Cell[285997, 7475, 609, 16, 28, "Input",ExpressionUUID->"6e2024d9-4541-ea4e-a308-49a8bb9b87a5"],
Cell[286609, 7493, 1127, 29, 124, "Input",ExpressionUUID->"384fc915-4ebd-5342-9174-a166a5e7f52d"],
Cell[287739, 7524, 1391, 39, 124, "Input",ExpressionUUID->"e878baba-ea71-dd4f-b972-2e4c3753c774"],
Cell[289133, 7565, 1394, 39, 124, "Input",ExpressionUUID->"4200ee2b-abeb-b246-85fa-68f1ce5d836b"],
Cell[290530, 7606, 1326, 38, 124, "Input",ExpressionUUID->"8131db8a-5012-e741-93f3-ec6da52923f1"],
Cell[291859, 7646, 1364, 37, 143, "Input",ExpressionUUID->"3e5eb206-464c-7e4f-b628-98c50c5a4629"]
}, Closed]],
Cell[CellGroupData[{
Cell[293260, 7688, 291, 5, 38, "Subsection",ExpressionUUID->"d004e03f-8f12-9a43-865f-339812029417"],
Cell[293554, 7695, 3320, 100, 130, "Input",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],
Cell[CellGroupData[{
Cell[296911, 7800, 170, 3, 38, "Subsection",ExpressionUUID->"2a49be25-3c4e-430e-86c6-869880736f30"],
Cell[CellGroupData[{
Cell[297106, 7807, 217, 4, 45, "Subsubsection",ExpressionUUID->"a576f9af-1f5b-4213-b4d3-e7b66981337e"],
Cell[297326, 7813, 53880, 889, 404, "Text",ExpressionUUID->"f7950398-57cb-4ee6-bf14-597b39eb91df"],
Cell[351209, 8704, 995, 24, 86, "Input",ExpressionUUID->"cf738f77-0d96-4e62-81a0-f2a504594dc8"]
}, Closed]],
Cell[CellGroupData[{
Cell[352241, 8733, 238, 4, 37, "Subsubsection",ExpressionUUID->"f7957972-a4e9-446f-bafd-6774f0dd3699"],
Cell[352482, 8739, 813, 18, 48, "Input",ExpressionUUID->"44de57fd-6e7d-4d98-94a0-c7b93947eadd"]
}, Closed]],
Cell[CellGroupData[{
Cell[353332, 8762, 215, 4, 37, "Subsubsection",ExpressionUUID->"ae32c2db-9871-344f-aabd-a2543db56100"],
Cell[353550, 8768, 2072, 56, 101, "Input",ExpressionUUID->"db0fcba9-9144-4df7-981b-db22bb466a6e"]
}, Closed]],
Cell[CellGroupData[{
Cell[355659, 8829, 242, 4, 37, "Subsubsection",ExpressionUUID->"29f12ada-9fd0-4747-b323-2cf96d6fb52e"],
Cell[355904, 8835, 660, 15, 28, "Input",ExpressionUUID->"158fb412-c771-43ab-b43b-a357380f4a11"]
}, Closed]],
Cell[CellGroupData[{
Cell[356601, 8855, 197, 3, 37, "Subsubsection",ExpressionUUID->"5a543829-5641-9144-8dd0-57eb7cf1938d"],
Cell[356801, 8860, 1563, 42, 124, "Input",ExpressionUUID->"35cb8ff3-829e-654a-a95d-e2c972de6be9"]
}, Closed]],
Cell[CellGroupData[{
Cell[358401, 8907, 174, 3, 37, "Subsubsection",ExpressionUUID->"e039afe9-d89d-4ec4-94b9-ddb3f9f259e0"],
Cell[358578, 8912, 558, 14, 28, "Input",ExpressionUUID->"2db3c5dc-e4da-4371-937a-22cb108c81e1"]
}, Closed]],
Cell[CellGroupData[{
Cell[359173, 8931, 372, 6, 37, "Subsubsection",ExpressionUUID->"bd16b166-d506-5544-b5d0-7aa6edfca35b"],
Cell[359548, 8939, 1243, 33, 52, "Input",ExpressionUUID->"6cd12b17-ccf6-1f40-8216-e746f72a898c"]
}, Closed]],
Cell[CellGroupData[{
Cell[360828, 8977, 384, 6, 37, "Subsubsection",ExpressionUUID->"d546f79d-5ed9-4f99-846e-3ac1a3756b86"],
Cell[361215, 8985, 968, 26, 28, "Input",ExpressionUUID->"5668c7c2-b2f3-48b4-bb4e-3f493e46ab9c"],
Cell[362186, 9013, 879, 24, 28, "Input",ExpressionUUID->"d07dfa48-d9b6-433c-9d4d-8f2532f1bec3"]
}, Closed]],
Cell[CellGroupData[{
Cell[363102, 9042, 323, 5, 37, "Subsubsection",ExpressionUUID->"8f461d45-0647-c84b-9fe0-f72d3601c63f"],
Cell[363428, 9049, 1682, 40, 157, "Input",ExpressionUUID->"5485ed32-34f6-e64e-bd2a-b4e163c2b97f"]
}, Closed]],
Cell[CellGroupData[{
Cell[365147, 9094, 201, 3, 35, "Subsubsection",ExpressionUUID->"54169a90-c35c-7a4a-a37f-78c9753e8eeb"],
Cell[365351, 9099, 1627, 39, 124, "Input",ExpressionUUID->"c1bc4c8d-1ecd-654a-b9e2-f902b4037dfa"]
}, Closed]],
Cell[CellGroupData[{
Cell[367015, 9143, 225, 4, 35, "Subsubsection",ExpressionUUID->"e126572d-bdab-a047-b925-c2661290f09e"],
Cell[367243, 9149, 1438, 37, 105, "Input",ExpressionUUID->"3eac6f83-9820-5d4f-9acd-4f2df1b13510"]
}, Closed]],
Cell[CellGroupData[{
Cell[368718, 9191, 308, 5, 35, "Subsubsection",ExpressionUUID->"1d12da59-37f1-9842-ad9c-eb916041816f"],
Cell[369029, 9198, 3086, 70, 219, "Input",ExpressionUUID->"806c98e7-c027-de46-8fc2-cc2eda959f64"]
}, Closed]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[372176, 9275, 211, 4, 53, "Section",ExpressionUUID->"2609bf4c-7f5c-314e-a744-f86d4be283dd"],
Cell[372390, 9281, 45630, 753, 227, "Text",ExpressionUUID->"20c7ab22-8503-fd4d-9d34-15585b88ac29"]
}, Open  ]],
Cell[CellGroupData[{
Cell[418057, 10039, 155, 3, 54, "Subsection",ExpressionUUID->"990a55c4-883d-5442-8fbf-2dbb85b093b7"],
Cell[CellGroupData[{
Cell[418237, 10046, 317, 6, 28, "Input",ExpressionUUID->"a51e3372-af24-ce43-8f2d-a262f2467327"],
Cell[418557, 10054, 8144, 262, 101, "Output",ExpressionUUID->"30581973-f30b-cf46-9f35-c0c2fd6ecd89"]
}, Open  ]],
Cell[426716, 10319, 216, 4, 45, "Subsubsection",ExpressionUUID->"a391f71e-f986-7743-bd67-91fb9d7f7783"],
Cell[CellGroupData[{
Cell[426957, 10327, 1521, 29, 44, "Input",ExpressionUUID->"6cbe327a-3800-744a-9ca4-36b428ff2919"],
Cell[428481, 10358, 149, 2, 32, "Output",ExpressionUUID->"3a198fa9-92f7-a541-b067-1f68c3946927"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[428679, 10366, 153, 3, 38, "Subsection",ExpressionUUID->"ca969abc-f772-1849-9f1d-57b0d16b2450"],
Cell[CellGroupData[{
Cell[428857, 10373, 368, 7, 28, "Input",ExpressionUUID->"61a84cdc-281b-1144-99d8-2c4bce4cb8fc"],
Cell[429228, 10382, 8290, 268, 101, "Output",ExpressionUUID->"94202046-bc25-c548-8b04-e3619cc6eea4"]
}, Open  ]],
Cell[437533, 10653, 216, 4, 45, "Subsubsection",ExpressionUUID->"db05976e-5c98-254a-9533-340b3684c183"],
Cell[CellGroupData[{
Cell[437774, 10661, 1521, 29, 44, "Input",ExpressionUUID->"92b2645c-4d54-d340-86f9-b447c8242fbf"],
Cell[439298, 10692, 175, 2, 32, "Output",ExpressionUUID->"2b26f2fc-47e9-2448-80b5-0d3939a1e489"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[439522, 10700, 153, 3, 38, "Subsection",ExpressionUUID->"8571e662-dc6e-c94d-9178-5a36d05c5564"],
Cell[CellGroupData[{
Cell[439700, 10707, 322, 6, 28, "Input",ExpressionUUID->"8d2985b4-8289-ac49-8f45-3a00d95d4959"],
Cell[440025, 10715, 5393, 178, 100, "Output",ExpressionUUID->"df6b6337-1f96-e940-8339-d48b40b3b6f8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[445455, 10898, 219, 4, 45, "Subsubsection",ExpressionUUID->"e8eba0e2-018a-be4a-9ccf-dabd4af88463"],
Cell[CellGroupData[{
Cell[445699, 10906, 717, 16, 48, "Input",ExpressionUUID->"23c230fb-0385-9b4a-a4b2-74f970c25759"],
Cell[446419, 10924, 268, 4, 32, "Output",ExpressionUUID->"0e764dd0-431c-f34c-93de-39ce446358bf"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[446748, 10935, 156, 3, 38, "Subsection",ExpressionUUID->"43c3888e-a2fd-ac41-a99c-eb28cd9466ce"],
Cell[CellGroupData[{
Cell[446929, 10942, 373, 7, 28, "Input",ExpressionUUID->"8a860fbb-1ffb-ca4d-a3f4-bd56db5e05d1"],
Cell[447305, 10951, 26208, 787, 273, "Output",ExpressionUUID->"b58d38ca-14a6-d344-814f-16396b88bbe5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[473550, 11743, 219, 4, 45, "Subsubsection",ExpressionUUID->"13faa8b4-8655-9445-a1f2-72421585932a"],
Cell[CellGroupData[{
Cell[473794, 11751, 717, 16, 48, "Input",ExpressionUUID->"8ee3c6e2-a7e6-794a-ad35-f9c8d2a991c0"],
Cell[474514, 11769, 290, 4, 32, "Output",ExpressionUUID->"452ad5da-f045-4547-8d92-e54fa57daaa7"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[474865, 11780, 204, 4, 38, "Subsection",ExpressionUUID->"16d27243-ccad-6840-8ee7-904d956ae870"],
Cell[CellGroupData[{
Cell[475094, 11788, 294, 6, 28, "Input",ExpressionUUID->"27a1df2a-a50e-f84d-ae46-681b65924b39"],
Cell[475391, 11796, 8476, 264, 100, "Output",ExpressionUUID->"b0b0723b-e532-fd46-8428-92477d0152f1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[483904, 12065, 219, 4, 45, "Subsubsection",ExpressionUUID->"1bfe84dc-e2ab-2a41-a751-cfa311c2763f"],
Cell[CellGroupData[{
Cell[484148, 12073, 741, 16, 48, "Input",ExpressionUUID->"69ba7802-f556-d84f-bdb0-77255e869cc3"],
Cell[484892, 12091, 342, 5, 32, "Output",ExpressionUUID->"3dc6d3a2-0ef8-b644-a3c6-afbf1d91b9da"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[485295, 12103, 206, 4, 38, "Subsection",ExpressionUUID->"e8e5cdc4-1e15-c741-8b36-55a5a40b37ec"],
Cell[485504, 12109, 294, 6, 28, "Input",ExpressionUUID->"1a8fe7e4-8c4d-f944-b721-cc7d1aeadb71"],
Cell[485801, 12117, 9034, 280, 145, "Output",ExpressionUUID->"1618e6d3-8570-fb4b-a8cd-88436a091bba"],
Cell[CellGroupData[{
Cell[494860, 12401, 218, 4, 45, "Subsubsection",ExpressionUUID->"c3b2abee-7cb0-0247-bde4-fc450a0f72b6"],
Cell[CellGroupData[{
Cell[495103, 12409, 714, 16, 48, "Input",ExpressionUUID->"438da6c3-7a1e-7241-a61d-417f2eace056"],
Cell[495820, 12427, 287, 4, 32, "Output",ExpressionUUID->"13b89ade-3989-c74f-9298-9810e83f58c6"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[496168, 12438, 181, 3, 38, "Subsection",ExpressionUUID->"f2f73996-ca76-b84f-90bb-e5167ca527c9"],
Cell[CellGroupData[{
Cell[496374, 12445, 345, 7, 28, "Input",ExpressionUUID->"4ad2ec31-863f-514e-b4f6-fd94de76a0d9"],
Cell[496722, 12454, 18503, 548, 250, "Output",ExpressionUUID->"0d09f034-b662-4546-8200-8517c99111e9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[515262, 13007, 218, 4, 45, "Subsubsection",ExpressionUUID->"5b5af5e6-d514-2646-99c4-15ab247e97ce"],
Cell[CellGroupData[{
Cell[515505, 13015, 714, 16, 48, "Input",ExpressionUUID->"8305524c-efcd-f746-9da3-f38232a4a0a0"],
Cell[516222, 13033, 309, 4, 32, "Output",ExpressionUUID->"33fb2ed4-e375-cf40-92f5-132174550154"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[516592, 13044, 205, 4, 38, "Subsection",ExpressionUUID->"f093b193-dced-7d4f-9700-2b552fd364e8"],
Cell[CellGroupData[{
Cell[516822, 13052, 344, 7, 28, "Input",ExpressionUUID->"d2f7624f-ca22-de4e-9bc2-56b624e6feed"],
Cell[517169, 13061, 16016, 489, 250, "Output",ExpressionUUID->"66007504-f36d-6548-80d3-e454666d714d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[533222, 13555, 218, 4, 45, "Subsubsection",ExpressionUUID->"c0cffa71-a4d6-8f4e-ba5d-cd628cc6e89d"],
Cell[533443, 13561, 714, 16, 48, "Input",ExpressionUUID->"b6e98e70-a4d4-8948-82ac-c1205e5e631a"]
}, Open  ]],
Cell[534172, 13580, 311, 4, 32, "Output",ExpressionUUID->"237feba6-38cd-1e4e-8433-80607e0ffd6e"]
}, Closed]]
}
]
*)

