(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   3249315,      89913]
NotebookOptionsPosition[   3050130,      87520]
NotebookOutlinePosition[   3050469,      87535]
CellTagsIndexPosition[   3050426,      87532]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
This Notebook contains the proofs of some of the results in  the paper
\"Relationships between a Central Quadrilateral and its Reference \
Quadrilateral\"
by Stanley Rabinowitz and Ercole Suppa,
submitted to the International Journal of Computer Discovered Mathematics 
(http : // www.journal - 1. eu/) in May 2022.
 
This Notebook is Copyright \[Copyright] May 2022 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and is published with open access. This \
Notebook is distributed under the terms of the Creative Commons Attribution \
License which permits any use, distribution, and reproduction in any medium, \
provided the original author and the source are credited.

The file GeoxCenters.m must reside in the same directory as this notebook.\
\>", "Text",
 Evaluatable->False,
 CellChangeTimes->{{3.8517106718981447`*^9, 3.851710701258429*^9}, {
   3.851711035640792*^9, 3.851711101569191*^9}, 3.8517113718428907`*^9, 
   3.857582052616704*^9, {3.857582090190035*^9, 3.857582135392453*^9}, {
   3.857582371185758*^9, 3.857582392353647*^9}, {3.8610823148482943`*^9, 
   3.8610823338414307`*^9}},ExpressionUUID->"d08986c7-ef4f-4445-8a81-\
a177c140a9e8"],

Cell[CellGroupData[{

Cell["Set Up", "Section",
 CellChangeTimes->{{3.858790576808064*^9, 
  3.858790582733438*^9}},ExpressionUUID->"89212534-7237-4eed-b992-\
f4fefc071f04"],

Cell[BoxData[
 RowBox[{"Get", "[", 
  RowBox[{
   RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<GeoxCenters.m\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8575821470498457`*^9, 3.857582155304802*^9}, {
  3.857582233458603*^9, 3.8575822336486893`*^9}, {3.857582304313387*^9, 
  3.857582311272935*^9}, {3.857582350681676*^9, 3.857582360353598*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"7c63bfc2-58ce-4821-8658-b86ccade219d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"normed", "[", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_", ",", "z_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], "/", 
    RowBox[{"(", 
     RowBox[{"x", "+", "y", "+", "z"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"squaredDistance", "[", 
    RowBox[{"p1_", ",", "p2_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{"Total", "[", "p2", "]"}], "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{"Return", "[", "Infinity", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], "=", 
       RowBox[{
        RowBox[{"normed", "[", "p1", "]"}], "-", 
        RowBox[{"normed", "[", "p2", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"a", "^", "2"}]}], "*", "y", "*", "z"}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", "z", "*", "x"}], "-", 
        RowBox[{
         RowBox[{"c", "^", "2"}], "*", "x", "*", "y"}]}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dist", "[", 
    RowBox[{"P_", ",", "Q_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"squaredDistance", "[", 
       RowBox[{"P", ",", "Q"}], "]"}], "]"}], "//", "Simplify"}], "//", 
    "PowerExpand"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"baryArea", "[", 
    RowBox[{"p1_", ",", "p2_", ",", "p3_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"normed", "[", "p1", "]"}], ",", 
       RowBox[{"normed", "[", "p2", "]"}], ",", 
       RowBox[{"normed", "[", "p3", "]"}]}], "}"}], "]"}], "K"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.857587210978294*^9, {3.857829439574634*^9, 3.857829493669174*^9}, {
   3.85782974708759*^9, 3.857829749542029*^9}, {3.858054883464953*^9, 
   3.8580548913999*^9}, {3.858238372066176*^9, 3.8582383734407187`*^9}, {
   3.859887583762052*^9, 3.859887586169178*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"0863b046-8b0f-4b7d-9bfd-c8c5ca9bd6b2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Quadrilaterals classes", "Section",
 CellChangeTimes->{{3.8149372947743545`*^9, 3.81493730456911*^9}, {
   3.8150766619788237`*^9, 3.815076687722373*^9}, {3.815307218478911*^9, 
   3.81530722210299*^9}, 3.815307770176461*^9, {3.815830618003149*^9, 
   3.81583062373456*^9}, {3.8492735680842953`*^9, 3.849273590155794*^9}, {
   3.85688823644116*^9, 3.856888237608892*^9}, 
   3.861082538322009*^9},ExpressionUUID->"7932e666-d308-4af3-820e-\
66659bf35ae8"],

Cell[TextData[StyleBox["X -> Y means that Y is a special type of X, i.e. X \
specializes to Y",
 FontSize->24]], "Text",
 Evaluatable->False,
 CellChangeTimes->{{3.814933108126809*^9, 3.81493323211734*^9}, {
  3.8149338547094793`*^9, 3.8149339178193626`*^9}, {3.815830684213579*^9, 
  3.815830701911251*^9}, {3.815830759045865*^9, 3.8158308083977613`*^9}, {
  3.8158308579099913`*^9, 
  3.8158308650778646`*^9}},ExpressionUUID->"f5a7ec9c-ccac-4438-8f9e-\
acbe28753294"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"quadrilaterals", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\"\<APquad\>\"", "\[DirectedEdge]", "\"\<rhombus\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<bicentric\>\"", "\[Rule]", "\"\<bicentricTrap\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<bicentricTrap\>\"", "\[Rule]", "\"\<square\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<convex\>\"", "\[DirectedEdge]", "\"\<trapezoid\>\""}], ",", 
      RowBox[{"\"\<convex\>\"", "\[DirectedEdge]", "\"\<cyclic\>\""}], ",", 
      RowBox[{"\"\<convex\>\"", "\[DirectedEdge]", "\"\<tangential\>\""}], 
      ",", 
      RowBox[{"\"\<convex\>\"", "\[DirectedEdge]", "\"\<orthodiagonal\>\""}], 
      ",", 
      RowBox[{"\"\<convex\>\"", "\[DirectedEdge]", "\"\<equidiagonal\>\""}], 
      ",", 
      RowBox[{"\"\<convex\>\"", "\[DirectedEdge]", "\"\<equalProdOpp\>\""}], 
      ",", 
      RowBox[{"\"\<convex\>\"", "\[DirectedEdge]", "\"\<exTangential\>\""}], 
      ",", 
      RowBox[{"\"\<convex\>\"", "\[DirectedEdge]", "\"\<equalProdAdj\>\""}], 
      ",", 
      RowBox[{"\"\<convex\>\"", "\[DirectedEdge]", "\"\<Pythagorean\>\""}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"\"\<cyclic\>\"", "\[DirectedEdge]", "\"\<harmonic\>\""}], ",", 
      
      RowBox[{"\"\<cyclic\>\"", "\[DirectedEdge]", "\"\<Hjelmslev\>\""}], ",", 
      RowBox[{"\"\<cyclic\>\"", "\[DirectedEdge]", "\"\<bicentric\>\""}], ",", 
      RowBox[{"\"\<cyclic\>\"", "\[DirectedEdge]", "\"\<isoTrap\>\""}], ",", 
      RowBox[{"\"\<cyclic\>\"", "\[DirectedEdge]", "\"\<cyclicOrtho\>\""}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"\"\<cyclic\>\"", "\[DirectedEdge]", "\"\<exBicentric\>\""}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"\"\<cyclicOrtho\>\"", "\[DirectedEdge]", "\"\<square\>\""}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"\"\<equalProdAdj\>\"", "\[DirectedEdge]", "\"\<kite\>\""}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"\"\<equalProdOpp\>\"", "\[DirectedEdge]", "\"\<harmonic\>\""}],
       ",", 
      RowBox[{"\"\<equalProdOpp\>\"", "\[DirectedEdge]", "\"\<kite\>\""}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{
      "\"\<equidiagonal\>\"", "\[DirectedEdge]", "\"\<equiOrthoQuad\>\""}], 
      ",", 
      RowBox[{"\"\<equidiagonal\>\"", "\[DirectedEdge]", "\"\<isoTrap\>\""}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"\"\<equiOrthoQuad\>\"", "\[Rule]", "\"\<equiOrthoKite\>\""}], 
      ",", 
      RowBox[{"\"\<equiOrthoQuad\>\"", "\[Rule]", "\"\<equiOrthoTrap\>\""}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"\"\<equiOrthoKite\>\"", "\[Rule]", "\"\<square\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<equiOrthoTrap\>\"", "\[Rule]", "\"\<square\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<exBicentric\>\"", "\[DirectedEdge]", "\"\<square\>\""}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"\"\<exTangential\>\"", "\[DirectedEdge]", "\"\<kite\>\""}], 
      ",", 
      RowBox[{
      "\"\<exTangential\>\"", "\[DirectedEdge]", "\"\<exBicentric\>\""}], ",", 
      RowBox[{
      "\"\<exTangential\>\"", "\[DirectedEdge]", "\"\<parallelogram\>\""}], 
      ",", 
      RowBox[{"\"\<exTangential\>\"", "\[DirectedEdge]", "\"\<APquad\>\""}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"\"\<harmonic\>\"", "\[DirectedEdge]", "\"\<rectangle\>\""}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"\"\<Hjelmslev\>\"", "\[Rule]", " ", "\"\<rectangle\>\""}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"\"\<isoTrap\>\"", "\[Rule]", "\"\<bicentricTrap\>\""}], ",", 
      RowBox[{"\"\<isoTrap\>\"", "\[Rule]", "\"\<equiOrthoTrap\>\""}], ",", 
      RowBox[{"\"\<isoTrap\>\"", "\[Rule]", "\"\<rectangle\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<kite\>\"", "\[Rule]", "\"\<rhombus\>\""}], ",", 
      RowBox[{"\"\<kite\>\"", "\[Rule]", "\"\<equiOrthoKite\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<orthoTrap\>\"", "\[Rule]", "\"\<equiOrthoTrap\>\""}], ",", 
      
      RowBox[{"\"\<orthoTrap\>\"", "\[Rule]", "\"\<rhombus\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
      "\"\<orthodiagonal\>\"", "\[DirectedEdge]", "\"\<equiOrthoQuad\>\""}], 
      ",", 
      RowBox[{
      "\"\<orthodiagonal\>\"", "\[DirectedEdge]", "\"\<orthoTrap\>\""}], ",", 
      
      RowBox[{
      "\"\<orthodiagonal\>\"", "\[DirectedEdge]", "\"\<cyclicOrtho\>\""}], 
      ",", 
      RowBox[{"\"\<orthodiagonal\>\"", "\[DirectedEdge]", "\"\<kite\>\""}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"\"\<parallelogram\>\"", "\[Rule]", "\"\<rhombus\>\""}], ",", 
      RowBox[{"\"\<parallelogram\>\"", "\[Rule]", "\"\<rectangle\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<Pythagorean\>\"", "\[DirectedEdge]", "\"\<Hjelmslev\>\""}],
       ",", " ", 
      RowBox[{"\"\<Pythagorean\>\"", "\[DirectedEdge]", "\"\<kite\>\""}], ",", 
      RowBox[{
      "\"\<Pythagorean\>\"", "\[DirectedEdge]", "\"\<parallelogram\>\""}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"\"\<rectangle\>\"", "\[Rule]", "\"\<square\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<rhombus\>\"", "\[Rule]", "\"\<square\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<tangential\>\"", "\[DirectedEdge]", "\"\<tangTrap\>\""}], 
      ",", 
      RowBox[{"\"\<tangential\>\"", "\[DirectedEdge]", "\"\<kite\>\""}], ",", 
      
      RowBox[{"\"\<tangential\>\"", "\[DirectedEdge]", "\"\<bicentric\>\""}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"\"\<tangTrap\>\"", "\[Rule]", "\"\<rhombus\>\""}], ",", 
      RowBox[{"\"\<tangTrap\>\"", "\[Rule]", "\"\<bicentricTrap\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<trapezoid\>\"", "\[DirectedEdge]", "\"\<tangTrap\>\""}], 
      ",", 
      RowBox[{
      "\"\<trapezoid\>\"", "\[DirectedEdge]", "\"\<parallelogram\>\""}], ",", 
      
      RowBox[{"\"\<trapezoid\>\"", "\[DirectedEdge]", "\"\<isoTrap\>\""}], 
      ",", 
      RowBox[{"\"\<trapezoid\>\"", "\[DirectedEdge]", "\"\<orthoTrap\>\""}]}],
      "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"qGraph", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{"quadrilaterals", ",", " ", 
    RowBox[{"VertexShapeFunction", "\[Rule]", "\"\<Square\>\""}], ",", 
    RowBox[{"VertexSize", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{".5", ",", ".2"}], "}"}]}], ",", " ", 
    RowBox[{"VertexLabels", "\[Rule]", 
     RowBox[{"Placed", "[", 
      RowBox[{"\"\<Name\>\"", ",", "Center"}], "]"}]}], ",", 
    RowBox[{"VertexStyle", "\[Rule]", 
     RowBox[{"Hue", "[", 
      RowBox[{"0.125", ",", "0.7", ",", "0.9"}], "]"}]}], ",", 
    RowBox[{"VertexLabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"FontFamily", "->", "\"\<TimesNewRoman\>\""}], ",", " ", 
       "10"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "1000"}], ",", " ", 
    RowBox[{"EdgeShapeFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Arrowheads", "[", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{".01", ",", ".4"}], "}"}], "}"}], "]"}], ",", 
         RowBox[{"Arrow", "[", "#", "]"}]}], "}"}], "&"}], ")"}]}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.814933240241745*^9, 3.8149332467192683`*^9}, {
   3.8149332811263742`*^9, 3.814933291079313*^9}, {3.81493342381786*^9, 
   3.814933487046664*^9}, {3.814933521953658*^9, 3.8149335414266453`*^9}, {
   3.814933737524289*^9, 3.814933781209375*^9}, {3.8149339190536814`*^9, 
   3.814933970822487*^9}, {3.814934020888803*^9, 3.8149340244507017`*^9}, {
   3.814934057114873*^9, 3.8149340745324073`*^9}, {3.8149341080403643`*^9, 
   3.8149341353618126`*^9}, {3.814934183538186*^9, 3.81493420048708*^9}, {
   3.814934230745803*^9, 3.8149342902630177`*^9}, {3.814935473967944*^9, 
   3.814935550699851*^9}, {3.8149356179186068`*^9, 3.8149357450761223`*^9}, {
   3.814935775287527*^9, 3.8149361367820854`*^9}, {3.8149367603806567`*^9, 
   3.814936802057534*^9}, {3.814937009684128*^9, 3.8149370336452937`*^9}, {
   3.814937100868298*^9, 3.8149371126231976`*^9}, {3.8149371537235694`*^9, 
   3.814937168816131*^9}, {3.8149372168334346`*^9, 3.814937216866169*^9}, {
   3.814937362527124*^9, 3.8149373698707466`*^9}, {3.814937609979744*^9, 
   3.81493761885634*^9}, {3.814937765970805*^9, 3.8149377791690445`*^9}, {
   3.8149380423711815`*^9, 3.8149380683397818`*^9}, {3.8149382724585395`*^9, 
   3.8149382958888617`*^9}, {3.8149383574425783`*^9, 
   3.8149383678888235`*^9}, {3.8149384639306927`*^9, 3.814938476027583*^9}, {
   3.814938610480615*^9, 3.8149386184243546`*^9}, {3.8149388822698326`*^9, 
   3.8149388957183723`*^9}, {3.8149389493951855`*^9, 3.814938995346192*^9}, {
   3.81493913183998*^9, 3.814939159782529*^9}, {3.8149393139590836`*^9, 
   3.814939321744573*^9}, {3.81493935296774*^9, 3.814939356487717*^9}, {
   3.814939402864936*^9, 3.814939437911641*^9}, {3.8149397934261103`*^9, 
   3.814939913302286*^9}, {3.8149400948009553`*^9, 3.814940103403845*^9}, {
   3.8149402037367735`*^9, 3.814940209182803*^9}, 3.814940241293773*^9, {
   3.8149404453765316`*^9, 3.814940451878065*^9}, {3.814940565248521*^9, 
   3.814940571352062*^9}, {3.8149406410165005`*^9, 3.8149406551020346`*^9}, {
   3.8149407501524005`*^9, 3.8149407794781637`*^9}, {3.814940840856262*^9, 
   3.814940890877486*^9}, {3.81494101644554*^9, 3.8149410671857505`*^9}, {
   3.814941259470688*^9, 3.814941404924508*^9}, {3.8149415979728937`*^9, 
   3.8149416036517677`*^9}, {3.814941839096223*^9, 3.81494184753257*^9}, {
   3.814941953183123*^9, 3.8149419629508467`*^9}, {3.814952079867736*^9, 
   3.814952085491398*^9}, {3.814952153988135*^9, 3.8149521761371975`*^9}, {
   3.814952258865845*^9, 3.814952268285758*^9}, {3.8149525423236494`*^9, 
   3.814952575419134*^9}, {3.814952655651478*^9, 3.814952688214507*^9}, {
   3.814952788443186*^9, 3.8149528003011885`*^9}, {3.8149528560028467`*^9, 
   3.8149528702369604`*^9}, {3.8149529997467847`*^9, 3.814953016064758*^9}, {
   3.8149530827717094`*^9, 3.814953095758891*^9}, {3.814953337883398*^9, 
   3.814953405896021*^9}, {3.8149535331384974`*^9, 3.8149535441071076`*^9}, {
   3.8149537954190445`*^9, 3.8149538045759196`*^9}, {3.8149538402988653`*^9, 
   3.814953860231078*^9}, {3.8149543967624655`*^9, 3.8149544037540927`*^9}, {
   3.8149545316171503`*^9, 3.814954538230318*^9}, {3.814955623399245*^9, 
   3.814955627835932*^9}, {3.8149559101295033`*^9, 3.8149559362374363`*^9}, {
   3.8149560041722918`*^9, 3.814956013792997*^9}, {3.814967218666486*^9, 
   3.8149672279242263`*^9}, {3.814967330662284*^9, 3.8149673419762497`*^9}, {
   3.8149674111545415`*^9, 3.814967423894358*^9}, {3.81496746496045*^9, 
   3.814967496825802*^9}, {3.814970485977045*^9, 3.8149704974671803`*^9}, {
   3.814970527770938*^9, 3.814970549315061*^9}, {3.8149705864514112`*^9, 
   3.814970588849679*^9}, {3.814970709926813*^9, 3.814970714913628*^9}, {
   3.814970783154889*^9, 3.814970877338237*^9}, {3.81497095055576*^9, 
   3.814970964746674*^9}, {3.814971004835935*^9, 3.814971014201108*^9}, {
   3.8149761975401373`*^9, 3.814976200900532*^9}, {3.81497624305612*^9, 
   3.814976259452667*^9}, 3.814976364087845*^9, {3.815068377173395*^9, 
   3.8150684880566072`*^9}, {3.815068540580529*^9, 3.815068609233412*^9}, {
   3.815068673650549*^9, 3.815068712141062*^9}, {3.815068791268303*^9, 
   3.8150688091334963`*^9}, {3.815075960484665*^9, 3.815076026803945*^9}, {
   3.8152353733879337`*^9, 3.8152356763464622`*^9}, {3.815307168266974*^9, 
   3.8153071818813887`*^9}, {3.815307540461192*^9, 3.8153077429388933`*^9}, {
   3.815830988174406*^9, 3.815831045466968*^9}, {3.815831199761703*^9, 
   3.815831217578204*^9}, {3.815832100444838*^9, 3.815832111891919*^9}, {
   3.8158324437650347`*^9, 3.8158324509562817`*^9}, {3.815832524339994*^9, 
   3.815832572652769*^9}, {3.815832603143921*^9, 3.81583272366145*^9}, {
   3.8159270856426888`*^9, 3.815927109713147*^9}, {3.8159935017116413`*^9, 
   3.815993540765583*^9}, {3.815993589399685*^9, 3.815993606181724*^9}, {
   3.815993639951994*^9, 3.815993640596836*^9}, {3.815993813439662*^9, 
   3.815993815870315*^9}, {3.8160022756273003`*^9, 3.816002354393774*^9}, {
   3.816002416010592*^9, 3.816002418866193*^9}, 3.816002810765256*^9, {
   3.816003325567091*^9, 3.81600337395726*^9}, {3.816003457422798*^9, 
   3.816003464462126*^9}, {3.816003742864805*^9, 3.8160037470233088`*^9}, {
   3.816004504554291*^9, 3.816004507416346*^9}, {3.849273642032983*^9, 
   3.8492736606233892`*^9}, {3.849273773216798*^9, 3.849273811192919*^9}, 
   3.849273842440482*^9, {3.849273990801811*^9, 3.8492740272254953`*^9}, {
   3.849274057690053*^9, 3.8492740645138063`*^9}, 3.849274096057906*^9, {
   3.8492741645624247`*^9, 3.8492741724821577`*^9}, 3.849274300628645*^9, {
   3.84927436427573*^9, 3.849274369891342*^9}, {3.849274446308695*^9, 
   3.849274493724263*^9}, 3.849274565438623*^9, {3.849274613374476*^9, 
   3.849274670278284*^9}, {3.8493460343490334`*^9, 3.849346097332273*^9}, {
   3.849346211727066*^9, 3.849346254007297*^9}, {3.849346302928334*^9, 
   3.849346310223556*^9}, {3.849346355184963*^9, 3.849346379112021*^9}, 
   3.849346436114224*^9, {3.849346466707322*^9, 3.8493464704667273`*^9}, {
   3.8493465145548573`*^9, 3.8493465187467003`*^9}, {3.8493465702753572`*^9, 
   3.849346670573954*^9}, {3.8493467089097767`*^9, 3.8493467833098173`*^9}, {
   3.84934682248728*^9, 3.849346850880147*^9}, {3.849347188806123*^9, 
   3.849347195060052*^9}, {3.849347356294697*^9, 3.8493473922627277`*^9}, {
   3.84934745720022*^9, 3.849347468807946*^9}, {3.849347630362927*^9, 
   3.8493476333623857`*^9}, 3.849347669947912*^9, 3.849347754996591*^9, {
   3.849347792596924*^9, 3.849347794220347*^9}, 3.8493478857511377`*^9, {
   3.8493479925130243`*^9, 3.849347995727697*^9}, 3.849348028385387*^9, 
   3.849348195187696*^9, {3.8493483385882883`*^9, 3.8493483516527843`*^9}, {
   3.849348415278081*^9, 3.849348422540011*^9}, {3.8493487943070087`*^9, 
   3.849348855066429*^9}, {3.849348885595248*^9, 3.84934897998009*^9}, {
   3.849349026614011*^9, 3.849349062933237*^9}, 3.849349101375464*^9, {
   3.849353093331274*^9, 3.8493531245709047`*^9}, 3.849353309435112*^9, 
   3.8493533575008717`*^9, {3.84944035062191*^9, 3.849440351924449*^9}, {
   3.849440486015437*^9, 3.849440501141389*^9}, {3.849440891462924*^9, 
   3.8494409000283957`*^9}, {3.85012835298006*^9, 3.850128355658296*^9}, {
   3.850128427931806*^9, 3.85012848418671*^9}, {3.850128545814266*^9, 
   3.85012854639552*^9}, {3.85015068804596*^9, 3.850150690091119*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"513fce6d-e219-4b80-a7c7-f036d4f949ec"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{
      "APquad", "rhombus", "bicentric", "bicentricTrap", "square", "convex", 
       "trapezoid", "cyclic", "tangential", "orthodiagonal", "equidiagonal", 
       "equalProdOpp", "exTangential", "equalProdAdj", "Pythagorean", 
       "harmonic", "Hjelmslev", "isoTrap", "cyclicOrtho", "exBicentric", 
       "kite", "equiOrthoQuad", "equiOrthoKite", "equiOrthoTrap", 
       "parallelogram", "rectangle", "orthoTrap", "tangTrap"}, {{{1, 2}, {3, 
       4}, {4, 5}, {6, 7}, {6, 8}, {6, 9}, {6, 10}, {6, 11}, {6, 12}, {6, 
       13}, {6, 14}, {6, 15}, {8, 16}, {8, 17}, {8, 3}, {8, 18}, {8, 19}, {8, 
       20}, {19, 5}, {14, 21}, {12, 16}, {12, 21}, {11, 22}, {11, 18}, {22, 
       23}, {22, 24}, {23, 5}, {24, 5}, {20, 5}, {13, 21}, {13, 20}, {13, 
       25}, {13, 1}, {16, 26}, {17, 26}, {18, 4}, {18, 24}, {18, 26}, {21, 
       2}, {21, 23}, {27, 24}, {27, 2}, {10, 22}, {10, 27}, {10, 19}, {10, 
       21}, {25, 2}, {25, 26}, {15, 17}, {15, 21}, {15, 25}, {26, 5}, {2, 
       5}, {9, 28}, {9, 21}, {9, 3}, {28, 2}, {28, 4}, {7, 28}, {7, 25}, {7, 
       18}, {7, 27}}, Null}, {EdgeShapeFunction -> {{
          Arrowheads[{{0.01, 0.4}}], 
          Arrow[#]}& }, ImageSize -> 1000, VertexLabels -> {
         Placed["Name", Center]}, VertexLabelStyle -> {
         Directive[FontFamily -> "TimesNewRoman", 10]}, 
       VertexShapeFunction -> {"Square"}, VertexSize -> {{0.5, 0.2}}, 
       VertexStyle -> {
         Hue[0.125, 0.7, 0.9]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{0., 2.}, {-3., 1.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-3., 1.}, {-5., 0.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-11., 2.}, {-9., 1.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-9., 1.}, {-5., 0.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-5., 4.}, {-7., 3.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-5., 4.}, {-6., 3.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-5., 4.}, {-10., 3.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-5., 4.}, {-5., 3.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-5., 4.}, {-8., 3.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-5., 4.}, {-4., 3.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-5., 4.}, {-1., 3.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-5., 4.}, {-2., 3.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-5., 4.}, {-3., 3.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-7., 3.}, {-9., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-7., 3.}, {-2., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-7., 3.}, {-7., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-7., 3.}, {-10., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-6., 3.}, {-11., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-6., 3.}, {-6., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-6., 3.}, {-4., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-6., 3.}, {-9., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-6., 3.}, {-5., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-6., 3.}, {-1., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-10., 3.}, {-11., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-10., 3.}, {-3., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-10., 3.}, {-10., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-5., 3.}, {-5., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-5., 3.}, {-3., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-5., 3.}, {-8., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-5., 3.}, {-7., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-8., 3.}, {-9., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-8., 3.}, {-8., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-4., 3.}, {-6., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-4., 3.}, {-3., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-1., 3.}, {0., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-1., 3.}, {-1., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-1., 3.}, {-3., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-1., 3.}, {-2., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-2., 3.}, {-3., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-3., 3.}, {-4., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-3., 3.}, {-3., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-3., 3.}, {-2., 2.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-6., 2.}, {-6., 1.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-4., 2.}, {-6., 1.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-9., 2.}, {-9., 1.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-9., 2.}, {-7., 1.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-9., 2.}, {-6., 1.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEiB6AMBxh/+byN3dft/9vD+EkTjT6UZP+zZ4Ty
9W406d5o+guX5yle5MzY9gfO/5UI0vAbwV/iD0II9TZ3Z8mL/YTzDdWtRBJO
fIfz08DgG5y/GKz9C5z/2KIPiD7D3aOsBAKf4PKJ3NsSuLd9gPPtX062ezn5
HZy/ZzcIvIbzLUHGPX4B54N0J3A/g/ONweAxnA8OnvwHcP45/u4pjctvw90j
nnNQLOfgNbi8ZMUuU3udS3D+ivQ3j76ePw3nT7EDOfAwnP/g5bU/Gzx2wvn/
tM508rGugPNhMQcAztODKA==
          "]]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEf9kMZDjD+8nkbu6/b/7eH8ZMmGn0oyf5nzwjl
691o0r3R9Bcuz1O8yJmx7Q+c/ysRpOE3gr/EH4QQ6m3uzpIX+wnnG6pbiSSc
+A7np4HBN/s1y+53zxf+sP+5oPHLhZxf7TfPqtOv8/uw/71j4ZfG05/the7c
eTV7w4f99d8UOtjWfLI/lfVr7w/Lj/sn6zst0V/90f6O2/UVU1593K/39orH
3xMf7N0KilfnH/q031//Zmk+6wd77ufnjnYe/Lz/zeu5YTwH39lrrH75/dHz
L/s9mnIuNW15az9/z2HHatNv+zcoysU7PX1jPzdSTcLm/P/9BpfffE6UeGGf
JsUgcdCP5cDsp/+f2218bC+0fMURtQCOA3c3rivbFH/f/tolHqHzr7kPhEQ9
u52occN+41wdhl2K/AfmHln2v3vPRftLzC3HP/8QOFD28P7hRIsT9mEd/ve1
9YQOrKhi53aS3WufeqfCvdVA+EBS8ROB8PcroeEjcgAWcwBAgc4h
          "]]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-3., 2.}, {-3., 1.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-3., 2.}, {-4., 1.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-8., 2.}, {-4., 1.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-8., 2.}, {-7., 1.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-4., 1.}, {-5., 0.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-7., 1.}, {-5., 0.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-2., 2.}, {-3., 1.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-2., 2.}, {-6., 1.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-6., 1.}, {-5., 0.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-7., 2.}, {-3., 1.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-7., 2.}, {-7., 1.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-10., 2.}, {-3., 1.}}]}, 
        {Arrowheads[{{0.01, 0.4}}], ArrowBox[{{-10., 2.}, {-9., 1.}}]}}, 
       {Hue[0.125, 0.7, 0.9], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         RectangleBox[{-0.4411765, 1.8235294}, {0.4411765, 2.1764706}], 
         InsetBox[
          StyleBox["\<\"APquad\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {0., 2.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-3.4411765, 0.8235294}, {-2.5588235, 1.1764706}], 
         InsetBox[
          StyleBox["\<\"rhombus\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-3., 1.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-11.4411765, 1.8235294}, {-10.5588235, 2.1764706}], 
         InsetBox[
          StyleBox["\<\"bicentric\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-11., 2.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-9.4411765, 0.8235294}, {-8.5588235, 1.1764706}], 
         InsetBox[
          StyleBox["\<\"bicentricTrap\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-9., 1.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-5.4411765, -0.17647060000000003}, \
{-4.5588235, 0.17647060000000003}], InsetBox[
          StyleBox["\<\"square\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-5., 0.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-5.4411765, 3.8235294}, {-4.5588235, 4.1764706}], 
         InsetBox[
          StyleBox["\<\"convex\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-5., 4.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-7.4411765, 2.8235294}, {-6.5588235, 3.1764706}], 
         InsetBox[
          StyleBox["\<\"trapezoid\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-7., 3.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-6.4411765, 2.8235294}, {-5.5588235, 3.1764706}], 
         InsetBox[
          StyleBox["\<\"cyclic\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-6., 3.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-10.4411765, 2.8235294}, {-9.5588235, 3.1764706}], 
         InsetBox[
          StyleBox["\<\"tangential\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-10., 3.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-5.4411765, 2.8235294}, {-4.5588235, 3.1764706}], 
         InsetBox[
          StyleBox["\<\"orthodiagonal\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-5., 3.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-8.4411765, 2.8235294}, {-7.5588235, 3.1764706}], 
         InsetBox[
          StyleBox["\<\"equidiagonal\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-8., 3.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-4.4411765, 2.8235294}, {-3.5588235, 3.1764706}], 
         InsetBox[
          StyleBox["\<\"equalProdOpp\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-4., 3.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-1.4411765, 2.8235294}, \
{-0.5588234999999999, 3.1764706}], InsetBox[
          StyleBox["\<\"exTangential\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-1., 3.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-2.4411765, 2.8235294}, {-1.5588235, 3.1764706}], 
         InsetBox[
          StyleBox["\<\"equalProdAdj\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-2., 3.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-3.4411765, 2.8235294}, {-2.5588235, 3.1764706}], 
         InsetBox[
          StyleBox["\<\"Pythagorean\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-3., 3.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-6.4411765, 1.8235294}, {-5.5588235, 2.1764706}], 
         InsetBox[
          StyleBox["\<\"harmonic\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-6., 2.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-4.4411765, 1.8235294}, {-3.5588235, 2.1764706}], 
         InsetBox[
          StyleBox["\<\"Hjelmslev\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-4., 2.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-9.4411765, 1.8235294}, {-8.5588235, 2.1764706}], 
         InsetBox[
          StyleBox["\<\"isoTrap\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-9., 2.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-5.4411765, 1.8235294}, {-4.5588235, 2.1764706}], 
         InsetBox[
          StyleBox["\<\"cyclicOrtho\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-5., 2.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-1.4411765, 1.8235294}, \
{-0.5588234999999999, 2.1764706}], InsetBox[
          StyleBox["\<\"exBicentric\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-1., 2.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-3.4411765, 1.8235294}, {-2.5588235, 2.1764706}], 
         InsetBox[
          StyleBox["\<\"kite\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-3., 2.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-8.4411765, 1.8235294}, {-7.5588235, 2.1764706}], 
         InsetBox[
          StyleBox["\<\"equiOrthoQuad\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-8., 2.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-4.4411765, 0.8235294}, {-3.5588235, 1.1764706}], 
         InsetBox[
          StyleBox["\<\"equiOrthoKite\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-4., 1.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-7.4411765, 0.8235294}, {-6.5588235, 1.1764706}], 
         InsetBox[
          StyleBox["\<\"equiOrthoTrap\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-7., 1.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-2.4411765, 1.8235294}, {-1.5588235, 2.1764706}], 
         InsetBox[
          StyleBox["\<\"parallelogram\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-2., 2.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-6.4411765, 0.8235294}, {-5.5588235, 1.1764706}], 
         InsetBox[
          StyleBox["\<\"rectangle\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-6., 1.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-7.4411765, 1.8235294}, {-6.5588235, 2.1764706}], 
         InsetBox[
          StyleBox["\<\"orthoTrap\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-7., 2.},
          BaseStyle->"Graphics"]}, {
         RectangleBox[{-10.4411765, 1.8235294}, {-9.5588235, 2.1764706}], 
         InsetBox[
          StyleBox["\<\"tangTrap\"\>",
           StripOnInput->False,
           FontFamily->"TimesNewRoman",
           FontSize->10], {-10., 2.},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->1000]], "Output",
 CellChangeTimes->{
  3.8149328574333897`*^9, 3.8149330228921804`*^9, 3.814933248164137*^9, {
   3.8149332841744833`*^9, 3.814933291651991*^9}, {3.814933424867361*^9, 
   3.8149334876556673`*^9}, {3.814933523527711*^9, 3.814933542191884*^9}, {
   3.8149337414450016`*^9, 3.8149337819589605`*^9}, 3.8149338795940294`*^9, 
   3.814933909993079*^9, 3.8149339734781346`*^9, 3.814934025356499*^9, 
   3.8149340752197404`*^9, {3.8149341093523164`*^9, 3.8149341361741433`*^9}, 
   3.8149342013931117`*^9, 3.8149342915749707`*^9, 3.8149355651808057`*^9, 
   3.8149356710933285`*^9, 3.814935746216238*^9, 3.814935930080829*^9, 
   3.8149361377349854`*^9, 3.8149370650546722`*^9, 3.8149371136058416`*^9, 
   3.814937172940775*^9, 3.81493721989657*^9, 3.814937371645132*^9, 
   3.814937619644045*^9, 3.81493777991296*^9, 3.8149381387249956`*^9, 
   3.8149382971508355`*^9, 3.8149384847784476`*^9, 3.8149386195671287`*^9, {
   3.8149389701648855`*^9, 3.81493899604193*^9}, {3.8149391417917204`*^9, 
   3.8149391606280255`*^9}, 3.814939359022555*^9, 3.8149394395776777`*^9, {
   3.81493979484791*^9, 3.8149398503357005`*^9}, {3.814939887506054*^9, 
   3.8149399144822736`*^9}, 3.8149401126570024`*^9, 3.814940210030543*^9, 
   3.8149402420707417`*^9, 3.8149404531602993`*^9, 3.8149405721893215`*^9, 
   3.814940655966129*^9, 3.814940789338151*^9, 3.814940891687418*^9, {
   3.81494102582813*^9, 3.814941067919046*^9}, 3.814941344331996*^9, {
   3.8149413777173157`*^9, 3.814941405829751*^9}, 3.8149416133955917`*^9, 
   3.814941848776698*^9, 3.8149419639378195`*^9, 3.8149521071279774`*^9, 
   3.814952195705406*^9, 3.8149522693321147`*^9, 3.8149525769324036`*^9, 
   3.814952729570315*^9, 3.8149528013618507`*^9, 3.8149528832544074`*^9, 
   3.8149530177631645`*^9, 3.814953100139425*^9, 3.8149534154198256`*^9, 
   3.8149535458140354`*^9, 3.814953807767313*^9, 3.814953861355632*^9, 
   3.814954405755102*^9, 3.8149545391958437`*^9, 3.8149550095619974`*^9, 
   3.8149556433445487`*^9, 3.8149559371628056`*^9, 3.814956015618497*^9, 
   3.8149672618918347`*^9, 3.814967348944423*^9, {3.81496746802709*^9, 
   3.8149674978117476`*^9}, {3.814970481367044*^9, 3.8149705503307753`*^9}, 
   3.814970589810676*^9, 3.814970715786607*^9, {3.8149708462583733`*^9, 
   3.8149708779212427`*^9}, 3.814970967309207*^9, 3.814971015081802*^9, 
   3.8149762617424707`*^9, 3.8149763746391153`*^9, 3.8150670599679937`*^9, 
   3.815068615076007*^9, {3.815068679005802*^9, 3.8150687179110003`*^9}, {
   3.815068795712207*^9, 3.815068811543044*^9}, {3.815075976812758*^9, 
   3.8150760278082848`*^9}, 3.815235681344532*^9, 3.815306921361067*^9, 
   3.815307184785961*^9, 3.8153077451565647`*^9, 3.815390711982278*^9, {
   3.815831187141522*^9, 3.81583121850384*^9}, 3.815832113103244*^9, 
   3.815832451996985*^9, {3.815832552213523*^9, 3.815832573600924*^9}, 
   3.815832663665708*^9, {3.815832697716661*^9, 3.8158327269716043`*^9}, 
   3.815993495824991*^9, 3.815993541846777*^9, 3.815993607066683*^9, 
   3.8159936419098587`*^9, 3.8159938169501677`*^9, 3.816002429249799*^9, 
   3.8160028161500797`*^9, 3.816003471007547*^9, 3.816003628023088*^9, 
   3.816003748475473*^9, 3.816004513017827*^9, {3.8383700291616898`*^9, 
   3.838370034138897*^9}, 3.8492741842148943`*^9, 3.849274501457224*^9, 
   3.849274568235083*^9, {3.849274614415606*^9, 3.849274674452454*^9}, 
   3.8493461097753696`*^9, 3.849346893720264*^9, 3.849347938299635*^9, {
   3.8493480006212673`*^9, 3.8493480294411573`*^9}, 3.849348196320517*^9, {
   3.84934833940221*^9, 3.849348352747261*^9}, {3.849348389451375*^9, 
   3.849348423986429*^9}, {3.849348821138719*^9, 3.8493488269309177`*^9}, {
   3.849348898638562*^9, 3.849348980795323*^9}, 3.849349064250403*^9, 
   3.8493491026703*^9, 3.84935332775566*^9, 3.8493533586415873`*^9, 
   3.849440353288872*^9, {3.849440487139781*^9, 3.8494405024540567`*^9}, 
   3.8494409016050262`*^9, 3.850128496399374*^9, 3.850128555431669*^9, 
   3.8501506920540533`*^9, 3.856888303505625*^9, 3.861082542712867*^9, 
   3.861097763697052*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"7cce6fb0-2805-4de9-aa13-e73715dd2225"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Section 5 (Lemmas)", "Section",
 CellChangeTimes->{{3.858790601848362*^9, 3.858790609085968*^9}, {
  3.8587907131195*^9, 3.858790715655356*^9}, {3.858790753239759*^9, 
  3.858790755903316*^9}, {3.859446154639089*^9, 
  3.859446158222807*^9}},ExpressionUUID->"47b6734f-7749-43fd-be07-\
f0a57a6ed3f6"],

Cell[CellGroupData[{

Cell["Lemmas about Medians", "Subsection",
 CellChangeTimes->{{3.858790798137211*^9, 
  3.8587908084156523`*^9}},ExpressionUUID->"e3e32188-b387-447f-b9c4-\
d6665e1c49ac"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"liesOnMedian", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coincidesWithE", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rational", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"n", "=", "1"}], ",", 
    RowBox[{"n", "\[LessEqual]", "1000"}], ",", 
    RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"coords", "=", 
      RowBox[{"ETC1", "[", 
       RowBox[{"[", 
        RowBox[{"n", ",", "2"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"coords", "\[Equal]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
       RowBox[{"Continue", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"coords", "=", 
      RowBox[{"coords", "/.", 
       RowBox[{"S", "->", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]]}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"simpl", "=", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"coord1", ",", "coord2", ",", "coord3"}], "}"}], "=", 
       RowBox[{"Simplify", "[", 
        RowBox[{"coords", ",", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "==", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}]}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplify", "[", 
         RowBox[{"coord2", "-", "coord3"}], "]"}], "\[Equal]", "0"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"AX", "=", 
         RowBox[{"Simplify", "[", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"squaredDistance", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", "simpl"}], 
             "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "==", 
             RowBox[{
              RowBox[{"b", "^", "2"}], "+", 
              RowBox[{"c", "^", "2"}]}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"AX", "===", "Infinity"}], ",", 
          RowBox[{"Continue", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"AX", "=", 
         RowBox[{"Factor", "[", "AX", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"AX", "=", 
         RowBox[{
          RowBox[{"AX", "/.", 
           RowBox[{
            RowBox[{
             RowBox[{"b", "^", "2"}], "+", 
             RowBox[{"c", "^", "2"}]}], "\[Rule]", 
            RowBox[{"a", "^", "2"}]}]}], "//", "PowerExpand"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"AX", "=", 
         RowBox[{"Simplify", "[", "AX", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"AX", "=!=", "0"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"coord1", "===", "0"}], ",", "\[IndentingNewLine]", 
             RowBox[{"AppendTo", "[", 
              RowBox[{"coincidesWithE", ",", "n"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"AppendTo", "[", 
               RowBox[{"liesOnMedian", ",", "n"}], "]"}], ";"}]}], 
            "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"Print", "[", 
            RowBox[{
            "\"\<n=\>\"", ",", "n", ",", "\"\<   \>\"", ",", "simpl", ",", 
             "\"\<   \>\"", ",", 
             RowBox[{"Style", "[", 
              RowBox[{"AX", ",", "Red"}], "]"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"ratio", "=", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "/", "2"}], ")"}], "/", "AX"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"NumericQ", "[", "ratio", "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"AppendTo", "[", 
               RowBox[{"rational", ",", 
                RowBox[{"{", 
                 RowBox[{"n", ",", "ratio"}], "}"}]}], "]"}], ";"}]}], 
            "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
         "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.857582475474887*^9, 3.8575824914258633`*^9}, {
   3.857582603098516*^9, 3.8575826063462563`*^9}, {3.8575826859946957`*^9, 
   3.857582834628669*^9}, {3.857582866761621*^9, 3.857582918269206*^9}, {
   3.8575829593432627`*^9, 3.8575829820122347`*^9}, {3.857583038556037*^9, 
   3.857583062875787*^9}, {3.857583132646698*^9, 3.857583139204028*^9}, {
   3.857583181647155*^9, 3.857583183044416*^9}, {3.857583236261652*^9, 
   3.857583241380466*^9}, {3.8575832790085163`*^9, 3.857583305296854*^9}, 
   3.8575833511115637`*^9, {3.85758370730136*^9, 3.85758372383037*^9}, {
   3.857584603034121*^9, 3.8575846802253313`*^9}, {3.857584732516699*^9, 
   3.857584733129534*^9}, {3.857585384557624*^9, 3.857585389483748*^9}, {
   3.8575855773775473`*^9, 3.857585750868944*^9}, {3.857586122032404*^9, 
   3.857586179918844*^9}, {3.8575862381032963`*^9, 3.857586332422942*^9}, {
   3.857587216418792*^9, 3.8575872822338667`*^9}, {3.85758940733781*^9, 
   3.8575894818251257`*^9}, {3.8575895361455193`*^9, 3.8575895514893293`*^9}, 
   3.857590807770513*^9, {3.857591511468974*^9, 3.857591575915415*^9}, {
   3.8576253931570997`*^9, 3.857625400911703*^9}, {3.8576255152800837`*^9, 
   3.857625555024227*^9}, {3.857625644906721*^9, 3.8576256668969088`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"36e45cb8-39da-47de-8414-d6ba15565464"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "3"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm["n=", 2, "   ", {1, 1, 1}, "   ", 
   Style[Rational[1, 3] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097763819264*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"5c6d8d5e-770a-4186-b380-72766d646354"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 3, "   ", {
   0, (-2) $CellContext`b^2 $CellContext`c^2, (-2) $CellContext`b^2 \
$CellContext`c^2}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097763820141*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"2d3a2bdc-b1a6-4c9b-84af-4ac36810f9a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "4"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 5, "   ", {(-4) $CellContext`b^2 $CellContext`c^2, (-2) \
$CellContext`b^2 $CellContext`c^2, (-2) $CellContext`b^2 $CellContext`c^2}, 
   "   ", 
   Style[Rational[1, 4] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097763831079*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"e2e11ac7-186e-4c6e-9619-f79dc87decc0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox["a",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 20, "   ", {
   4 $CellContext`b^2 $CellContext`c^2, (-4) $CellContext`b^2 \
$CellContext`c^2, (-4) $CellContext`b^2 $CellContext`c^2}, "   ", 
   Style[$CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097764252201*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"f9a0297d-5b10-4bcc-be47-4e5ac1bac8d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "b"}], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "b"}], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "b"}], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"4", " ", "b", " ", "c"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", "a", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 21, 
   "   ", {-$CellContext`b $CellContext`c ($CellContext`b^2 + \
$CellContext`c^2 + $CellContext`a ($CellContext`b + $CellContext`c)), \
-$CellContext`b $CellContext`c ($CellContext`b + $CellContext`c) \
($CellContext`a + $CellContext`b + $CellContext`c), -$CellContext`b \
$CellContext`c ($CellContext`b + $CellContext`c) ($CellContext`a + \
$CellContext`b + $CellContext`c)}, "   ", 
   Style[$CellContext`a ($CellContext`b + $CellContext`c) ($CellContext`a + \
$CellContext`b + $CellContext`c)/(3 $CellContext`b^2 + 
    4 $CellContext`b $CellContext`c + 3 $CellContext`c^2 + 
    3 $CellContext`a ($CellContext`b + $CellContext`c)), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097764396639*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"132e3841-7ce8-4df2-8a9c-673e8e62e98b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox["a",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 22, "   ", {
   2 $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + $CellContext`c^2), \
(-2) $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + $CellContext`c^2), \
(-2) $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + $CellContext`c^2)},
    "   ", 
   Style[$CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610977644285727`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"d5bbd7b9-29b1-45b7-ad74-0415515871cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox["a",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 23, "   ", {
   3 $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + $CellContext`c^2), \
-$CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + $CellContext`c^2), \
-$CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + $CellContext`c^2)}, 
   "   ", 
   Style[$CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097764431464*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"7199de73-10dc-4fb2-b880-09617b211a28"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "95", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"2", " ", "a"}], "5"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 95, "   ", {
   4 $CellContext`b^4 $CellContext`c^4, 8 $CellContext`b^4 $CellContext`c^4, 
    8 $CellContext`b^4 $CellContext`c^4}, "   ", 
   Style[Rational[2, 5] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097765150221*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"230c65cb-31d6-453f-b9fe-d85dfc9e3124"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "97", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"-", "16"}], " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"]}], ",", 
     RowBox[{
      RowBox[{"-", "16"}], " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 97, "   ", {
   0, (-16) $CellContext`b^6 $CellContext`c^6, (-16) $CellContext`b^6 \
$CellContext`c^6}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097765183282*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"88bac6c7-30f3-4357-aa2f-c53cc1c6e875"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "122", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"16", " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"]}], ",", 
     RowBox[{"16", " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 122, "   ", {
   0, 16 $CellContext`b^6 $CellContext`c^6, 
    16 $CellContext`b^6 $CellContext`c^6}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097765704996*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"c656a51f-b4e5-411a-8b86-16924d87893e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "123", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 123, "   ", {
   0, 8 $CellContext`b^3 $CellContext`c^3 ($CellContext`b^3 + \
$CellContext`b^2 $CellContext`c + $CellContext`b $CellContext`c^2 + \
$CellContext`c^3 - $CellContext`a ($CellContext`b^2 + $CellContext`b \
$CellContext`c + $CellContext`c^2)), 
    8 $CellContext`b^3 $CellContext`c^3 ($CellContext`b^3 + $CellContext`b^2 \
$CellContext`c + $CellContext`b $CellContext`c^2 + $CellContext`c^3 - \
$CellContext`a ($CellContext`b^2 + $CellContext`b $CellContext`c + \
$CellContext`c^2))}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097765738944*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"78405997-abb3-4837-abc6-c38cfb3ab2b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "127", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 127, "   ", {
   0, 4 $CellContext`b^4 $CellContext`c^4 ($CellContext`b^2 + \
$CellContext`c^2), 
    4 $CellContext`b^4 $CellContext`c^4 ($CellContext`b^2 + \
$CellContext`c^2)}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097765795353*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"cd004355-3b19-4471-9710-c08e82c22c36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "131", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"16", " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], ",", 
     RowBox[{"16", " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 131, "   ", {
   0, 16 $CellContext`b^6 $CellContext`c^6 ($CellContext`b^2 - \
$CellContext`c^2)^2, 
    16 $CellContext`b^6 $CellContext`c^6 ($CellContext`b^2 - \
$CellContext`c^2)^2}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097765889843*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"f5351527-193c-4044-83f6-b649869aae56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "140", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "6"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "6"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"3", " ", "a"}], "8"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 140, 
   "   ", {(-4) $CellContext`b^2 $CellContext`c^2, (-6) $CellContext`b^2 \
$CellContext`c^2, (-6) $CellContext`b^2 $CellContext`c^2}, "   ", 
   Style[Rational[3, 8] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097766077079*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"d8241ae3-0717-4e13-9d8a-0cbb502f041b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "199", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", "b", "+", "c"}], ")"}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 199, "   ", {
   2 $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + $CellContext`c^2), \
(-2) $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + $CellContext`b \
$CellContext`c + $CellContext`c^2 + $CellContext`a ($CellContext`b + \
$CellContext`c)), (-2) $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + \
$CellContext`b $CellContext`c + $CellContext`c^2 + $CellContext`a \
($CellContext`b + $CellContext`c))}, "   ", 
   Style[$CellContext`a ($CellContext`a + $CellContext`b) ($CellContext`a + \
$CellContext`c) ($CellContext`b + $CellContext`c)^(-1)/(
    2 $CellContext`a + $CellContext`b + $CellContext`c), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097880010159*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"10c4a303-8086-4837-87ed-baf6049cdd1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "216", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 216, "   ", {
   0, (-4) $CellContext`b^4 $CellContext`c^4, (-4) $CellContext`b^4 \
$CellContext`c^4}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097881107349*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"1753cea4-4441-4f14-88a3-c3c6818cb1a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "233", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "16"}], " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", "12"}], " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", "12"}], " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"3", " ", "a"}], "10"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 233, 
   "   ", {(-16) $CellContext`b^4 $CellContext`c^4, (-12) $CellContext`b^4 \
$CellContext`c^4, (-12) $CellContext`b^4 $CellContext`c^4}, "   ", 
   Style[Rational[3, 10] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610978813864937`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"a2c88a31-ef6b-42dd-858e-e4f53df7d1f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "237", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], 
     RowBox[{
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox["c", "4"]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 237, "   ", {
   2 $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + \
$CellContext`c^2)^2, (-2) $CellContext`b^4 $CellContext`c^4, (-2) \
$CellContext`b^4 $CellContext`c^4}, "   ", 
   Style[$CellContext`a $CellContext`b^2 $CellContext`c^2/($CellContext`b^4 + \
$CellContext`c^4), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097881908008*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"9ad79ee6-dc85-41a9-b70f-12f88632f2ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "253", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"16", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", "16"}], " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", "16"}], " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox["a",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 253, "   ", {
   16 $CellContext`b^4 $CellContext`c^4, (-16) $CellContext`b^4 \
$CellContext`c^4, (-16) $CellContext`b^4 $CellContext`c^4}, "   ", 
   Style[$CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610978821731853`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"b690c040-489d-474c-9aef-3fbf564f2bbe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "268", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"-", "16"}], " ", 
      SuperscriptBox["b", "5"], " ", 
      SuperscriptBox["c", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "16"}], " ", 
      SuperscriptBox["b", "5"], " ", 
      SuperscriptBox["c", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 268, "   ", {
   0, (-16) $CellContext`b^5 $CellContext`c^5 (-$CellContext`a + \
$CellContext`b + $CellContext`c), (-16) $CellContext`b^5 $CellContext`c^5 \
(-$CellContext`a + $CellContext`b + $CellContext`c)}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097883159745*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"d268053f-45ab-43e1-a120-c81f991a32b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "280", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox["a",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 280, 
   "   ", {(-8) $CellContext`b^3 $CellContext`c^3 (-$CellContext`a + \
$CellContext`b + $CellContext`c), 
    8 $CellContext`b^3 $CellContext`c^3 (-$CellContext`a + $CellContext`b + \
$CellContext`c), 
    8 $CellContext`b^3 $CellContext`c^3 (-$CellContext`a + $CellContext`b + \
$CellContext`c)}, "   ", 
   Style[$CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610978834358892`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"d5e3011b-243b-4678-b9cf-689948156116"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "339", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 339, "   ", {
   0, 2 $CellContext`b^4 $CellContext`c^4 ($CellContext`b^2 + \
$CellContext`c^2), 
    2 $CellContext`b^4 $CellContext`c^4 ($CellContext`b^2 + \
$CellContext`c^2)}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610978879508123`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"17b71c74-8c14-486d-a9b4-e6462ff11d52"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "347", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox["a",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 347, "   ", {
   4 $CellContext`b^2 $CellContext`c^2 (-$CellContext`a + $CellContext`b + \
$CellContext`c), (-4) $CellContext`b^2 $CellContext`c^2 (-$CellContext`a + \
$CellContext`b + $CellContext`c), (-4) $CellContext`b^2 $CellContext`c^2 \
(-$CellContext`a + $CellContext`b + $CellContext`c)}, "   ", 
   Style[$CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610978880547113`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"5f2eaeec-b51e-4453-a95b-3db966c16996"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "376", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"2", " ", "a"}], "3"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 376, "   ", {
   4 $CellContext`b^2 $CellContext`c^2, (-8) $CellContext`b^2 \
$CellContext`c^2, (-8) $CellContext`b^2 $CellContext`c^2}, "   ", 
   Style[Rational[2, 3] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610978917264643`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"892ced67-2b03-4341-a63c-12871fcba72a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "377", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"2", " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{
      SqrtBox["2"], " ", 
      SuperscriptBox["a", "2"], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "c"}], ")"}]}]]}], 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", "b", " ", "c"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", "a", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 377, "   ", {
   2 $CellContext`b $CellContext`c ($CellContext`b + $CellContext`c) \
($CellContext`a + $CellContext`b + $CellContext`c), 
    2 $CellContext`b $CellContext`c ($CellContext`b^2 + $CellContext`c^2 + \
$CellContext`a ($CellContext`b + $CellContext`c)), 
    2 $CellContext`b $CellContext`c ($CellContext`b^2 + $CellContext`c^2 + \
$CellContext`a ($CellContext`b + $CellContext`c))}, "   ", 
   Style[2^
     Rational[1, 
       2] $CellContext`a^2 (($CellContext`a + $CellContext`b) ($CellContext`a + \
$CellContext`c))^Rational[1, 2]/(3 $CellContext`b^2 + 
    2 $CellContext`b $CellContext`c + 3 $CellContext`c^2 + 
    3 $CellContext`a ($CellContext`b + $CellContext`c)), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610978919379053`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"ee896ad0-9412-42f1-886f-aee0fc973e87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "379", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     SuperscriptBox["a", "2"], 
     RowBox[{
      RowBox[{"4", " ", "a"}], "+", "b", "+", "c"}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 379, "   ", {
   2 $CellContext`b^2 $CellContext`c^2 (
     2 $CellContext`a + $CellContext`b + $CellContext`c), 
    2 $CellContext`a $CellContext`b^2 $CellContext`c^2, 
    2 $CellContext`a $CellContext`b^2 $CellContext`c^2}, "   ", 
   Style[$CellContext`a^2/(
    4 $CellContext`a + $CellContext`b + $CellContext`c), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097891985651*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"9512e5ae-a3ec-4a38-978d-ac0bb7fc0fb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "381", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"8", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "6"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 381, "   ", {
   8 $CellContext`b^2 $CellContext`c^2, 2 $CellContext`b^2 $CellContext`c^2, 
    2 $CellContext`b^2 $CellContext`c^2}, "   ", 
   Style[Rational[1, 6] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097892039646*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"310f45a6-0720-470e-9860-b97acc98c45e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "382", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"8", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 382, "   ", {
   8 $CellContext`b^2 $CellContext`c^2, (-2) $CellContext`b^2 \
$CellContext`c^2, (-2) $CellContext`b^2 $CellContext`c^2}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610978920736513`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"96765896-037c-47ee-b925-5e19f3ad4361"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "383", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", 
     FractionBox[
      RowBox[{"a", " ", "b", " ", "c"}], 
      RowBox[{
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox["b", "2"]}], "-", 
       RowBox[{"3", " ", "b", " ", "c"}], "+", 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox["c", "2"]}]}]]}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 383, 
   "   ", {(-8) $CellContext`b^2 $CellContext`c^2 (
     3^Rational[1, 2] $CellContext`b^2 + 
     3^Rational[1, 2] $CellContext`c^2 - ($CellContext`b^2 $CellContext`c^2)^
     Rational[1, 2]), 8 ($CellContext`b^2 $CellContext`c^2)^Rational[3, 2], 
    8 ($CellContext`b^2 $CellContext`c^2)^Rational[3, 2]}, "   ", 
   Style[-$CellContext`a $CellContext`b $CellContext`c/(
    3^Rational[1, 2] $CellContext`b^2 - 3 $CellContext`b $CellContext`c + 
    3^Rational[1, 2] $CellContext`c^2), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097892240921*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"2b8d6f4d-d092-4bd9-92cf-0bcd8e32903b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "401", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox["a",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 401, 
   "   ", {(-4) $CellContext`b^4 $CellContext`c^4, 
    4 $CellContext`b^4 $CellContext`c^4, 4 $CellContext`b^4 $CellContext`c^4},
    "   ", 
   Style[$CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097893402203*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"47c0c36f-0650-43b6-b552-b713985d31bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "402", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"16", " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "4"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 402, "   ", {
   16 $CellContext`b^6 $CellContext`c^6, 8 $CellContext`b^6 $CellContext`c^6, 
    8 $CellContext`b^6 $CellContext`c^6}, "   ", 
   Style[Rational[1, 4] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097893437654*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"aae936cc-0df0-46f5-8df0-c28c6a487393"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "404", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", "-", "c"}], ")"}], "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", "-", "c"}], ")"}], "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"2", " ", "b", " ", "c"}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"4", " ", "b", " ", "c"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", "a", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 404, 
   "   ", {$CellContext`b $CellContext`c ($CellContext`b^2 + $CellContext`c^2 + \
$CellContext`a ($CellContext`b + $CellContext`c)), $CellContext`b \
$CellContext`c (($CellContext`b - $CellContext`c)^2 + $CellContext`a \
($CellContext`b + $CellContext`c)), $CellContext`b $CellContext`c \
(($CellContext`b - $CellContext`c)^2 + $CellContext`a ($CellContext`b + \
$CellContext`c))}, "   ", 
   Style[$CellContext`a ($CellContext`a^2 - 
     2 $CellContext`b $CellContext`c + $CellContext`a ($CellContext`b + \
$CellContext`c))/(3 $CellContext`b^2 - 4 $CellContext`b $CellContext`c + 
    3 $CellContext`c^2 + 3 $CellContext`a ($CellContext`b + $CellContext`c)), 
    
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097893587975*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"6c04ff74-5c06-4531-b319-1b56c4416a28"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "405", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}]}], 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", "b", " ", "c"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", "a", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 405, 
   "   ", {(-2) $CellContext`b $CellContext`c ($CellContext`b^2 + \
$CellContext`c^2 + $CellContext`a ($CellContext`b + $CellContext`c)), (-2) \
$CellContext`b $CellContext`c ($CellContext`b^2 + $CellContext`b \
$CellContext`c + $CellContext`c^2 + $CellContext`a ($CellContext`b + \
$CellContext`c)), (-2) $CellContext`b $CellContext`c ($CellContext`b^2 + \
$CellContext`b $CellContext`c + $CellContext`c^2 + $CellContext`a \
($CellContext`b + $CellContext`c))}, "   ", 
   Style[$CellContext`a ($CellContext`a + $CellContext`b) ($CellContext`a + \
$CellContext`c)/(3 $CellContext`b^2 + 2 $CellContext`b $CellContext`c + 
    3 $CellContext`c^2 + 3 $CellContext`a ($CellContext`b + $CellContext`c)), 
    
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610978937344027`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"ac0d9d0e-33b5-4fba-bb48-0250ef47e162"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "408", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 408, "   ", {
   0, 8 $CellContext`b^6 $CellContext`c^6 ($CellContext`a + $CellContext`b + \
$CellContext`c), 
    8 $CellContext`b^6 $CellContext`c^6 ($CellContext`a + $CellContext`b + \
$CellContext`c)}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097893785803*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"82a3c1db-f6f9-40ec-bae3-e08ca71c0ddb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "409", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"3", " ", "b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "+", "c"}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"b", " ", "c"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["b", "3"], " ", "c"}], "+", 
         RowBox[{"13", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"10", " ", "b", " ", 
          SuperscriptBox["c", "3"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 409, "   ", {
   2 $CellContext`b $CellContext`c ($CellContext`b^2 + 
     3 $CellContext`b $CellContext`c + $CellContext`c^2) ($CellContext`b^3 + \
$CellContext`b^2 $CellContext`c + $CellContext`b $CellContext`c^2 + \
$CellContext`c^3 + $CellContext`a ($CellContext`b^2 + $CellContext`b \
$CellContext`c + $CellContext`c^2)), 
    2 $CellContext`b $CellContext`c ($CellContext`b^3 + 
     2 $CellContext`b^2 $CellContext`c + 
     2 $CellContext`b $CellContext`c^2 + $CellContext`c^3) ($CellContext`b^2 + \
$CellContext`b $CellContext`c + $CellContext`c^2 + $CellContext`a \
($CellContext`b + $CellContext`c)), 
    2 $CellContext`b $CellContext`c ($CellContext`b^3 + 
     2 $CellContext`b^2 $CellContext`c + 
     2 $CellContext`b $CellContext`c^2 + $CellContext`c^3) ($CellContext`b^2 + \
$CellContext`b $CellContext`c + $CellContext`c^2 + $CellContext`a \
($CellContext`b + $CellContext`c))}, "   ", 
   Style[$CellContext`a ($CellContext`a + $CellContext`b) ($CellContext`a + \
$CellContext`c) ($CellContext`b^3 + 2 $CellContext`b^2 $CellContext`c + 
     2 $CellContext`b $CellContext`c^2 + $CellContext`c^3)/(($CellContext`b + \
$CellContext`c)^3 (3 $CellContext`b^2 + $CellContext`b $CellContext`c + 
      3 $CellContext`c^2) + $CellContext`a (3 $CellContext`b^4 + 
      10 $CellContext`b^3 $CellContext`c + 
      13 $CellContext`b^2 $CellContext`c^2 + 
      10 $CellContext`b $CellContext`c^3 + 3 $CellContext`c^4)), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.86109789415351*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"9679f988-5b22-45d5-9726-74ffdfa67723"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "411", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", "a", " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", 
     FractionBox[
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}]}], 
      RowBox[{"a", "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"b", "+", "c"}], ")"}]}]}]]}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 411, 
   "   ", {(-4) $CellContext`a $CellContext`b^3 $CellContext`c^3, 
    4 $CellContext`b^3 $CellContext`c^3 ($CellContext`b + $CellContext`c), 
    4 $CellContext`b^3 $CellContext`c^3 ($CellContext`b + $CellContext`c)}, 
   "   ", 
   Style[-$CellContext`a ($CellContext`b + $CellContext`c)/($CellContext`a - 
    2 ($CellContext`b + $CellContext`c)), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097894250765*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"5f36d8f6-4999-43e2-9d95-d1a2816406dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "413", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}]]}], 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "3"], " ", "c"}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"5", " ", "b", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "3"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", "c"}], "+", 
         RowBox[{"4", " ", "b", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "3"]}]}], ")"}]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 413, 
   "   ", {(-4) $CellContext`b^3 $CellContext`c^3 ($CellContext`b^2 - \
$CellContext`b $CellContext`c + $CellContext`c^2) ($CellContext`b^2 + \
$CellContext`c^2 + $CellContext`a ($CellContext`b + $CellContext`c)), (-4) \
$CellContext`b^3 $CellContext`c^3 ($CellContext`a + $CellContext`b + \
$CellContext`c) ($CellContext`b^3 + 2 $CellContext`b^2 $CellContext`c + 
     2 $CellContext`b $CellContext`c^2 + $CellContext`c^3), (-4) \
$CellContext`b^3 $CellContext`c^3 ($CellContext`a + $CellContext`b + \
$CellContext`c) ($CellContext`b^3 + 2 $CellContext`b^2 $CellContext`c + 
     2 $CellContext`b $CellContext`c^2 + $CellContext`c^3)}, "   ", 
   Style[Complex[
     0, 1] ($CellContext`a + $CellContext`b + $CellContext`c) \
($CellContext`b^3 + 2 $CellContext`b^2 $CellContext`c + 
     2 $CellContext`b $CellContext`c^2 + $CellContext`c^3) ($CellContext`a^2 - 
      2 ($CellContext`b^2 + $CellContext`c^2))^Rational[1, 2]/(
    3 $CellContext`b^4 + 5 $CellContext`b^3 $CellContext`c + 
    10 $CellContext`b^2 $CellContext`c^2 + 5 $CellContext`b $CellContext`c^3 + 
    3 $CellContext`c^4 + $CellContext`a (3 $CellContext`b^3 + 
      4 $CellContext`b^2 $CellContext`c + 4 $CellContext`b $CellContext`c^2 + 
      3 $CellContext`c^3)), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097894491434*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"8fc7b2f3-e2b2-451f-b689-b99dd6e09785"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "416", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "5"], " ", 
      SuperscriptBox["c", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "5"], " ", 
      SuperscriptBox["c", "5"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "5"], " ", 
      SuperscriptBox["c", "5"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      RowBox[{"4", " ", "b", " ", "c"}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 416, 
   "   ", {(-4) $CellContext`b^5 $CellContext`c^5 ($CellContext`b^2 + \
$CellContext`c^2 + $CellContext`a ($CellContext`b + $CellContext`c)), 
    4 $CellContext`b^5 $CellContext`c^5 ($CellContext`b + $CellContext`c) \
($CellContext`a + $CellContext`b + $CellContext`c), 
    4 $CellContext`b^5 $CellContext`c^5 ($CellContext`b + $CellContext`c) \
($CellContext`a + $CellContext`b + $CellContext`c)}, "   ", 
   Style[$CellContext`a ($CellContext`b + $CellContext`c) ($CellContext`a + \
$CellContext`b + $CellContext`c)/($CellContext`a^2 + 
    4 $CellContext`b $CellContext`c + $CellContext`a ($CellContext`b + \
$CellContext`c)), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097894695709*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"d0c55bf9-de04-49ab-932c-31038521afb2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "417", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"-", "32"}], " ", 
      SuperscriptBox["b", "8"], " ", 
      SuperscriptBox["c", "8"]}], ",", 
     RowBox[{
      RowBox[{"-", "32"}], " ", 
      SuperscriptBox["b", "8"], " ", 
      SuperscriptBox["c", "8"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 417, "   ", {
   0, (-32) $CellContext`b^8 $CellContext`c^8, (-32) $CellContext`b^8 \
$CellContext`c^8}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610978947311783`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"38a5b87d-b66b-40e5-a813-f4378b7baa12"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "418", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 418, "   ", {
   0, 8 $CellContext`b^6 $CellContext`c^6, 
    8 $CellContext`b^6 $CellContext`c^6}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097894734201*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"db6a52f9-6aa8-45af-b1b0-bebda354b0b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "426", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"-", "16"}], " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"]}], ",", 
     RowBox[{
      RowBox[{"-", "16"}], " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 426, "   ", {
   0, (-16) $CellContext`b^6 $CellContext`c^6, (-16) $CellContext`b^6 \
$CellContext`c^6}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610978948621817`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"9c4848af-a513-41d0-a1ff-8421176a9108"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "439", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "4"]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 439, "   ", {
   4 ($CellContext`b^2 + $CellContext`c^2)^2, 
    4 ($CellContext`b^2 - $CellContext`c^2)^2, 
    4 ($CellContext`b^2 - $CellContext`c^2)^2}, "   ", 
   Style[$CellContext`a ($CellContext`b^2 - $CellContext`c^2)^2/(
    3 $CellContext`b^4 - 2 $CellContext`b^2 $CellContext`c^2 + 
    3 $CellContext`c^4), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097895114785*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"927e7963-55fa-44ef-8bfe-231ad6ea9dd8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "440", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 440, "   ", {
   0, 4 $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + $CellContext`b \
$CellContext`c + $CellContext`c^2 + $CellContext`a ($CellContext`b + \
$CellContext`c)), 
    4 $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + $CellContext`b \
$CellContext`c + $CellContext`c^2 + $CellContext`a ($CellContext`b + \
$CellContext`c))}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097895150202*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"47768016-18b4-4c79-97f3-be97971c98d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "441", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 441, "   ", {
   0, 8 $CellContext`b^4 $CellContext`c^4, 
    8 $CellContext`b^4 $CellContext`c^4}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610978951533117`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"b4b41159-4267-4f11-a9f6-cb720777b203"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "442", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}]}], 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"4", " ", "b", " ", "c"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", "a", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 442, 
   "   ", {(-2) $CellContext`b $CellContext`c ($CellContext`b + \
$CellContext`c) ($CellContext`a + $CellContext`b + $CellContext`c), (-2) \
$CellContext`b $CellContext`c ($CellContext`b^2 + $CellContext`b \
$CellContext`c + $CellContext`c^2 + $CellContext`a ($CellContext`b + \
$CellContext`c)), (-2) $CellContext`b $CellContext`c ($CellContext`b^2 + \
$CellContext`b $CellContext`c + $CellContext`c^2 + $CellContext`a \
($CellContext`b + $CellContext`c))}, "   ", 
   Style[$CellContext`a ($CellContext`a + $CellContext`b) ($CellContext`a + \
$CellContext`c)/(3 $CellContext`b^2 + 4 $CellContext`b $CellContext`c + 
    3 $CellContext`c^2 + 3 $CellContext`a ($CellContext`b + $CellContext`c)), 
    
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097895268154*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"c1f0bcf8-614b-455b-b7b9-a672726e0626"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "443", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"4", " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"4", " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{
      SqrtBox["2"], " ", 
      SuperscriptBox["a", "2"], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "c"}], ")"}]}]]}], 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"b", " ", "c"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", "a", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 443, "   ", {
   4 $CellContext`b $CellContext`c ($CellContext`b^2 + $CellContext`b \
$CellContext`c + $CellContext`c^2 + $CellContext`a ($CellContext`b + \
$CellContext`c)), 
    4 $CellContext`b $CellContext`c ($CellContext`b^2 + $CellContext`c^2 + \
$CellContext`a ($CellContext`b + $CellContext`c)), 
    4 $CellContext`b $CellContext`c ($CellContext`b^2 + $CellContext`c^2 + \
$CellContext`a ($CellContext`b + $CellContext`c))}, "   ", 
   Style[2^
     Rational[1, 
       2] $CellContext`a^2 (($CellContext`a + $CellContext`b) ($CellContext`a + \
$CellContext`c))^Rational[1, 2]/(
    3 $CellContext`b^2 + $CellContext`b $CellContext`c + 3 $CellContext`c^2 + 
    3 $CellContext`a ($CellContext`b + $CellContext`c)), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610978954681273`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"e1170123-7a2a-426f-983e-c7a9f51a440a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "446", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"8", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "8"], "+", 
        RowBox[{
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        SuperscriptBox["c", "8"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], 
     RowBox[{
      SuperscriptBox["b", "8"], "-", 
      RowBox[{
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      SuperscriptBox["c", "8"]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 446, "   ", {
   8 $CellContext`b^4 $CellContext`c^4 ($CellContext`b^8 + $CellContext`b^6 \
$CellContext`c^2 + $CellContext`b^2 $CellContext`c^6 + $CellContext`c^8), \
(-8) $CellContext`b^6 $CellContext`c^6 ($CellContext`b^4 + $CellContext`b^2 \
$CellContext`c^2 + $CellContext`c^4), (-8) $CellContext`b^6 $CellContext`c^6 \
($CellContext`b^4 + $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4)}, 
   "   ", 
   Style[$CellContext`a $CellContext`b^2 $CellContext`c^2 ($CellContext`b^4 + \
$CellContext`b^2 $CellContext`c^2 + $CellContext`c^4)/($CellContext`b^8 - \
$CellContext`b^6 $CellContext`c^2 - 
    2 $CellContext`b^4 $CellContext`c^4 - $CellContext`b^2 $CellContext`c^6 + \
$CellContext`c^8), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097895633312*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"7bfd27e7-bf31-49bc-ab69-ea9f42238e65"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "448", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], 
     RowBox[{"2", " ", "b", " ", "c"}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 448, 
   "   ", {(-4) $CellContext`b^3 $CellContext`c^3 ($CellContext`b^2 + \
$CellContext`b $CellContext`c + $CellContext`c^2 + $CellContext`a \
($CellContext`b + $CellContext`c)), 
    2 $CellContext`b^3 $CellContext`c^3 ($CellContext`b + $CellContext`c) \
($CellContext`a + $CellContext`b + $CellContext`c), 
    2 $CellContext`b^3 $CellContext`c^3 ($CellContext`b + $CellContext`c) \
($CellContext`a + $CellContext`b + $CellContext`c)}, "   ", 
   Style[Rational[
     1, 2] $CellContext`a $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b + $CellContext`c) ($CellContext`a + $CellContext`b + \
$CellContext`c), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.86109789582763*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"83131197-dd01-4593-9acf-1cbbc5785e3a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "449", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "16"}], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}]}], 
     RowBox[{"2", " ", "b", " ", "c"}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 449, 
   "   ", {(-16) $CellContext`b^3 $CellContext`c^3 ($CellContext`b^2 + \
$CellContext`c^2 + $CellContext`a ($CellContext`b + $CellContext`c)), 
    8 $CellContext`b^3 $CellContext`c^3 ($CellContext`b^2 + $CellContext`b \
$CellContext`c + $CellContext`c^2 + $CellContext`a ($CellContext`b + \
$CellContext`c)), 
    8 $CellContext`b^3 $CellContext`c^3 ($CellContext`b^2 + $CellContext`b \
$CellContext`c + $CellContext`c^2 + $CellContext`a ($CellContext`b + \
$CellContext`c))}, "   ", 
   Style[Rational[
     1, 2] $CellContext`a $CellContext`b^(-1) ($CellContext`a + \
$CellContext`b) $CellContext`c^(-1) ($CellContext`a + $CellContext`c), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610978960355263`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"3adead6f-6b3b-4546-a32d-d6764903e79d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "452", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}]}], 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"b", " ", "c"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", "a", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 452, 
   "   ", {(-4) $CellContext`b $CellContext`c ($CellContext`b^2 - \
$CellContext`b $CellContext`c + $CellContext`c^2 + $CellContext`a \
($CellContext`b + $CellContext`c)), (-4) $CellContext`b $CellContext`c \
($CellContext`b^2 + $CellContext`b $CellContext`c + $CellContext`c^2 + \
$CellContext`a ($CellContext`b + $CellContext`c)), (-4) $CellContext`b \
$CellContext`c ($CellContext`b^2 + $CellContext`b $CellContext`c + \
$CellContext`c^2 + $CellContext`a ($CellContext`b + $CellContext`c))}, "   ", 
   
   Style[$CellContext`a ($CellContext`a + $CellContext`b) ($CellContext`a + \
$CellContext`c)/(3 $CellContext`b^2 + $CellContext`b $CellContext`c + 
    3 $CellContext`c^2 + 3 $CellContext`a ($CellContext`b + $CellContext`c)), 
    
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097896173955*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"f9ef0307-aa07-4d97-bc5f-c3fc26e4412c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "453", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["b", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"2", " ", "b", " ", "c"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 453, 
   "   ", {(-4) $CellContext`b^3 $CellContext`c^3 ($CellContext`b + \
$CellContext`c)^2 ($CellContext`b^2 + $CellContext`c^2 + $CellContext`a \
($CellContext`b + $CellContext`c)), (-4) $CellContext`b^3 ($CellContext`b - \
$CellContext`c)^2 $CellContext`c^3 ($CellContext`b + $CellContext`c) \
($CellContext`a + $CellContext`b + $CellContext`c), (-4) $CellContext`b^3 \
($CellContext`b - $CellContext`c)^2 $CellContext`c^3 ($CellContext`b + \
$CellContext`c) ($CellContext`a + $CellContext`b + $CellContext`c)}, "   ", 
   Style[$CellContext`a ($CellContext`b - $CellContext`c)^2 ($CellContext`a + \
$CellContext`b + $CellContext`c)/(
    3 $CellContext`b^3 - $CellContext`b^2 $CellContext`c - $CellContext`b \
$CellContext`c^2 + 
    3 $CellContext`c^3 + $CellContext`a (3 $CellContext`b^2 - 
      2 $CellContext`b $CellContext`c + 3 $CellContext`c^2)), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610978964466753`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"431979c6-7eb3-4dae-845a-cbdb1c03d65f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "454", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"-", "32"}], " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "32"}], " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 454, "   ", {
   0, (-32) $CellContext`b^6 $CellContext`c^6 ($CellContext`b^2 - \
$CellContext`c^2)^2, (-32) $CellContext`b^6 $CellContext`c^6 \
($CellContext`b^2 - $CellContext`c^2)^2}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610978964819193`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"3aa71f05-0f2a-49ea-a718-15946c8e6f39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "464", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 464, "   ", {
   0, (-8) $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + \
$CellContext`b $CellContext`c + $CellContext`c^2 + $CellContext`a \
($CellContext`b + $CellContext`c)), (-8) $CellContext`b^2 $CellContext`c^2 \
($CellContext`b^2 + $CellContext`b $CellContext`c + $CellContext`c^2 + \
$CellContext`a ($CellContext`b + $CellContext`c))}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097896662897*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"0fb326f9-869e-4630-9620-ee4613497bc7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "465", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"4", " ", 
      SqrtBox["3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}], ",", 
     RowBox[{"4", " ", 
      SqrtBox["3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 465, "   ", {
   0, 4 3^Rational[1, 2] ($CellContext`b^2 $CellContext`c^2)^Rational[3, 2], 
    4 3^Rational[1, 2] ($CellContext`b^2 $CellContext`c^2)^Rational[3, 2]}, 
   "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610978966974783`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"02930c5d-8c6a-4444-9093-30c83371673a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "466", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"4", " ", 
      SqrtBox["3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}], ",", 
     RowBox[{"4", " ", 
      SqrtBox["3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 466, "   ", {
   0, 4 3^Rational[1, 2] ($CellContext`b^2 $CellContext`c^2)^Rational[3, 2], 
    4 3^Rational[1, 2] ($CellContext`b^2 $CellContext`c^2)^Rational[3, 2]}, 
   "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610978967419977`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"34c38970-e371-4370-81c3-1aaf77f6efd5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "474", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"2", " ", "a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "3"], "+", 
           SuperscriptBox["c", "3"]}], ")"}]}]}]]}], 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"2", " ", "b", " ", "c"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", "a", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 474, "   ", {
   2 $CellContext`b $CellContext`c ($CellContext`b^2 + $CellContext`c^2 + \
$CellContext`a ($CellContext`b + $CellContext`c)), 
    2 $CellContext`b $CellContext`c ($CellContext`b^2 - $CellContext`b \
$CellContext`c + $CellContext`c^2 + $CellContext`a ($CellContext`b + \
$CellContext`c)), 
    2 $CellContext`b $CellContext`c ($CellContext`b^2 - $CellContext`b \
$CellContext`c + $CellContext`c^2 + $CellContext`a ($CellContext`b + \
$CellContext`c))}, "   ", 
   Style[$CellContext`a (3 $CellContext`b^2 - 2 $CellContext`b $CellContext`c + 
      3 $CellContext`c^2 + 
      3 $CellContext`a ($CellContext`b + $CellContext`c))^(-1) (
      2 $CellContext`b^4 + 5 $CellContext`b^2 $CellContext`c^2 + 
      2 $CellContext`c^4 + 
      2 $CellContext`a ($CellContext`b^3 + $CellContext`c^3))^Rational[1, 2], 
    
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097896969851*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"aa9fd7cc-3b28-43e6-b7ff-5999aabf83cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "546", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"12", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "8"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 546, "   ", {
   12 $CellContext`b^2 $CellContext`c^2, 2 $CellContext`b^2 $CellContext`c^2, 
    2 $CellContext`b^2 $CellContext`c^2}, "   ", 
   Style[Rational[1, 8] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610979016273823`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"52bcb4f5-a9dc-4786-aad3-c956f1fbdc9d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "547", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "20"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "14"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "14"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"7", " ", "a"}], "24"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 547, 
   "   ", {(-20) $CellContext`b^2 $CellContext`c^2, (-14) $CellContext`b^2 \
$CellContext`c^2, (-14) $CellContext`b^2 $CellContext`c^2}, "   ", 
   Style[Rational[7, 24] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.86109790166439*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"1f232323-f321-4cd8-8bb1-6628891b6bf5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "548", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "10"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "10"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"5", " ", "a"}], "8"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 548, "   ", {
   4 $CellContext`b^2 $CellContext`c^2, (-10) $CellContext`b^2 \
$CellContext`c^2, (-10) $CellContext`b^2 $CellContext`c^2}, "   ", 
   Style[Rational[5, 8] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097901667561*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"f4d6070f-f25b-4569-9db4-da97b4b91262"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "549", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "10"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "10"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"5", " ", "a"}], "12"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 549, 
   "   ", {(-4) $CellContext`b^2 $CellContext`c^2, (-10) $CellContext`b^2 \
$CellContext`c^2, (-10) $CellContext`b^2 $CellContext`c^2}, "   ", 
   Style[Rational[5, 12] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097901670079*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"efe64d11-ab01-464b-b878-343d826e06fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "550", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "6"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "6"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"3", " ", "a"}], "4"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 550, "   ", {
   4 $CellContext`b^2 $CellContext`c^2, (-6) $CellContext`b^2 \
$CellContext`c^2, (-6) $CellContext`b^2 $CellContext`c^2}, "   ", 
   Style[Rational[3, 4] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610979016724663`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"87b27210-d1f0-4d6d-b1be-71640bde146b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "577", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 577, "   ", {
   0, 4 $CellContext`b^4 $CellContext`c^4, 
    4 $CellContext`b^4 $CellContext`c^4}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097902679924*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"3fd78cd7-235b-4c59-8850-9ced10caa02a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "631", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"2", " ", "a"}], "5"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 631, 
   "   ", {(-4) $CellContext`b^2 $CellContext`c^2, (-8) $CellContext`b^2 \
$CellContext`c^2, (-8) $CellContext`b^2 $CellContext`c^2}, "   ", 
   Style[Rational[2, 5] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097905023986*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"8fb626f5-5ef2-4399-ba19-40514a50626f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "632", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "12"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "14"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "14"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"7", " ", "a"}], "20"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 632, 
   "   ", {(-12) $CellContext`b^2 $CellContext`c^2, (-14) $CellContext`b^2 \
$CellContext`c^2, (-14) $CellContext`b^2 $CellContext`c^2}, "   ", 
   Style[Rational[7, 20] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610979050596533`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"cf91fb30-501b-40a1-881e-031f318591cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "828", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"16", " ", 
      SuperscriptBox["b", "7"], " ", 
      SuperscriptBox["c", "7"]}], ",", 
     RowBox[{"16", " ", 
      SuperscriptBox["b", "7"], " ", 
      SuperscriptBox["c", "7"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 828, "   ", {
   0, 16 $CellContext`b^7 $CellContext`c^7, 
    16 $CellContext`b^7 $CellContext`c^7}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097914199259*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"0abadcb0-b9d9-4656-8882-e9a601062415"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "851", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", 
     FractionBox[
      RowBox[{"a", " ", "b", " ", "c"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "b", " ", "c"}], "+", 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"b", "+", "c"}], ")"}]}]}]]}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 851, "   ", {
   2 $CellContext`a $CellContext`b^2 $CellContext`c^2 ($CellContext`b + \
$CellContext`c), (-2) $CellContext`b^3 $CellContext`c^3, (-2) \
$CellContext`b^3 $CellContext`c^3}, "   ", 
   Style[-$CellContext`a $CellContext`b $CellContext`c/((-2) $CellContext`b \
$CellContext`c + $CellContext`a ($CellContext`b + $CellContext`c)), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097917944048*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"91706627-8d00-41a6-ba95-33b6375aa1ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "852", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 852, "   ", {
   0, 8 $CellContext`b^6 $CellContext`c^6, 
    8 $CellContext`b^6 $CellContext`c^6}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097917979308*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"e57dc30f-a964-48c7-96dc-3526d4d7d071"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "853", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "3"], "+", 
           SuperscriptBox["c", "3"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "5"], " ", 
      SuperscriptBox["c", "5"]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "5"], " ", 
      SuperscriptBox["c", "5"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"]}], 
     RowBox[{
      SuperscriptBox["b", "6"], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      SuperscriptBox["c", "6"], "-", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "5"], "+", 
         RowBox[{
          SuperscriptBox["b", "3"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "3"]}], "+", 
         SuperscriptBox["c", "5"]}], ")"}]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 853, "   ", {
   4 $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + $CellContext`c^2) \
($CellContext`b^4 + $CellContext`c^4 - $CellContext`a ($CellContext`b^3 + \
$CellContext`c^3)), 4 $CellContext`b^5 $CellContext`c^5, 
    4 $CellContext`b^5 $CellContext`c^5}, "   ", 
   Style[$CellContext`a $CellContext`b^3 $CellContext`c^3/($CellContext`b^6 + \
$CellContext`b^4 $CellContext`c^2 + 
    2 $CellContext`b^3 $CellContext`c^3 + $CellContext`b^2 $CellContext`c^4 + \
$CellContext`c^6 - $CellContext`a ($CellContext`b^5 + $CellContext`b^3 \
$CellContext`c^2 + $CellContext`b^2 $CellContext`c^3 + $CellContext`c^5)), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097918223558*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"54497ec0-d65a-4713-8c84-7eb28b49aa21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "854", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], 
     RowBox[{
      SuperscriptBox["b", "5"], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", "c"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      SuperscriptBox["c", "5"], "+", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 854, "   ", {
   2 $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + $CellContext`c^2) \
(($CellContext`b - $CellContext`c)^2 ($CellContext`b + $CellContext`c) + \
$CellContext`a ($CellContext`b^2 + $CellContext`c^2)), (-2) $CellContext`b^4 \
$CellContext`c^4 (-$CellContext`a + $CellContext`b + $CellContext`c), (-2) \
$CellContext`b^4 $CellContext`c^4 (-$CellContext`a + $CellContext`b + \
$CellContext`c)}, "   ", 
   Style[$CellContext`a $CellContext`b^2 $CellContext`c^2 (-$CellContext`a + \
$CellContext`b + $CellContext`c)/($CellContext`b^5 - $CellContext`b^4 \
$CellContext`c - 2 $CellContext`b^3 $CellContext`c^2 - 
    2 $CellContext`b^2 $CellContext`c^3 - $CellContext`b $CellContext`c^4 + \
$CellContext`c^5 + $CellContext`a ($CellContext`b^4 + 
      4 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4)), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610979184525642`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"92c72a33-01b2-4a99-8d9d-a0c22932960f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "855", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", "-", "c"}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", 
     FractionBox[
      RowBox[{"a", " ", "b", " ", 
       RowBox[{"(", 
        RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", "c"}], 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"b", "+", "c"}], ")"}]}], "+", 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}]}]}]]}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 855, "   ", {
   2 $CellContext`b^2 $CellContext`c^2 ($CellContext`b^3 + $CellContext`a \
($CellContext`b - $CellContext`c)^2 + $CellContext`b^2 $CellContext`c + \
$CellContext`b $CellContext`c^2 + $CellContext`c^3), (-2) $CellContext`b^3 \
$CellContext`c^3 (-$CellContext`a + $CellContext`b + $CellContext`c), (-2) \
$CellContext`b^3 $CellContext`c^3 (-$CellContext`a + $CellContext`b + \
$CellContext`c)}, "   ", 
   Style[-$CellContext`a $CellContext`b ($CellContext`a - $CellContext`b - \
$CellContext`c) $CellContext`c/(($CellContext`b - $CellContext`c)^2 \
($CellContext`b + $CellContext`c) + $CellContext`a ($CellContext`b^2 + \
$CellContext`c^2)), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610979186069393`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"6fd52933-caba-4a4b-8742-cb28d0883229"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "856", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "5"], " ", 
      SuperscriptBox["c", "5"]}], ",", 
     RowBox[{"8", " ", 
      SuperscriptBox["b", "5"], " ", 
      SuperscriptBox["c", "5"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["a", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 856, "   ", {
   0, 8 $CellContext`b^5 $CellContext`c^5, 
    8 $CellContext`b^5 $CellContext`c^5}, "   ", 
   Style[Rational[1, 2] $CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.86109791864242*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"525d56bd-1da1-4955-8b0d-1a44f868a62f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "857", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["a", "2"], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a"}], "+", "b", "+", "c"}]]}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 857, 
   "   ", {(-2) $CellContext`b^2 $CellContext`c^2 ($CellContext`b + \
$CellContext`c), 2 $CellContext`a $CellContext`b^2 $CellContext`c^2, 
    2 $CellContext`a $CellContext`b^2 $CellContext`c^2}, "   ", 
   Style[-$CellContext`a^2/((-2) $CellContext`a + $CellContext`b + \
$CellContext`c), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097918687409*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"7b5594eb-1f31-4bc5-a9ec-1bd909a59285"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "858", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox["a",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 858, "   ", {
   2 $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + $CellContext`c^2), \
(-2) $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + $CellContext`c^2), \
(-2) $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + $CellContext`c^2)},
    "   ", 
   Style[$CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610979187228622`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"32bce703-9f74-43fc-afaf-6bf45fff8487"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "859", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}]}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 859, "   ", {
   2 $CellContext`b^2 $CellContext`c^2 ($CellContext`a + $CellContext`b + \
$CellContext`c) ($CellContext`b^2 + $CellContext`c^2), (-2) $CellContext`b^3 \
$CellContext`c^3 ($CellContext`b + $CellContext`c), (-2) $CellContext`b^3 \
$CellContext`c^3 ($CellContext`b + $CellContext`c)}, "   ", 
   Style[$CellContext`a $CellContext`b $CellContext`c ($CellContext`b + \
$CellContext`c)/(($CellContext`b - $CellContext`c)^2 ($CellContext`b + \
$CellContext`c) + $CellContext`a ($CellContext`b^2 + $CellContext`c^2)), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097918851914*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"406fde6c-86de-41ff-bef9-9f740fdf9530"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "861", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "3"], "+", 
           SuperscriptBox["c", "3"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], 
     RowBox[{
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox["c", "4"], "-", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "3"], "+", 
         SuperscriptBox["c", "3"]}], ")"}]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 861, 
   "   ", {(-4) $CellContext`b^2 $CellContext`c^2 (($CellContext`b^2 + \
$CellContext`c^2)^2 - $CellContext`a ($CellContext`b^3 + $CellContext`c^3)), 
    4 $CellContext`b^4 $CellContext`c^4, 4 $CellContext`b^4 $CellContext`c^4},
    "   ", 
   Style[$CellContext`a $CellContext`b^2 $CellContext`c^2/($CellContext`b^4 + \
$CellContext`c^4 - $CellContext`a ($CellContext`b^3 + $CellContext`c^3)), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097918985608*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"95635b8f-f6c4-455b-a03c-a88e78777a01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "863", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "5"], "+", 
        RowBox[{
         SuperscriptBox["b", "3"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "3"]}], "+", 
        SuperscriptBox["c", "5"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "5"], " ", 
      SuperscriptBox["c", "5"]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "5"], " ", 
      SuperscriptBox["c", "5"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"]}], 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "5"], "+", 
         RowBox[{
          SuperscriptBox["b", "3"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "3"]}], "+", 
         SuperscriptBox["c", "5"]}], ")"}]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 863, "   ", {
   2 $CellContext`a $CellContext`b^2 $CellContext`c^2 ($CellContext`b^5 + \
$CellContext`b^3 $CellContext`c^2 + $CellContext`b^2 $CellContext`c^3 + \
$CellContext`c^5), (-2) $CellContext`b^5 $CellContext`c^5, (-2) \
$CellContext`b^5 $CellContext`c^5}, "   ", 
   Style[$CellContext`a $CellContext`b^3 $CellContext`c^3/((-2) \
$CellContext`b^3 $CellContext`c^3 + $CellContext`a ($CellContext`b^5 + \
$CellContext`b^3 $CellContext`c^2 + $CellContext`b^2 $CellContext`c^3 + \
$CellContext`c^5)), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610979191105556`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"623114e1-1f00-4a34-8013-62ca6e6a8b7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "864", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}], 
     RowBox[{
      SuperscriptBox["b", "8"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      SuperscriptBox["c", "8"]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 864, "   ", {
   2 $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + \
$CellContext`c^2)^2 ($CellContext`b^4 + $CellContext`c^4), (-2) \
$CellContext`b^6 $CellContext`c^6, (-2) $CellContext`b^6 $CellContext`c^6}, 
   "   ", 
   Style[$CellContext`a $CellContext`b^4 $CellContext`c^4/($CellContext`b^8 + 
    2 $CellContext`b^6 $CellContext`c^2 + 
    2 $CellContext`b^2 $CellContext`c^6 + $CellContext`c^8), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097919166563*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"353db427-eedc-43cd-90c2-bc944188abcf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "865", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         SuperscriptBox["c", "4"]}], ")"}], "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["c", "6"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}], 
     RowBox[{
      SuperscriptBox["b", "8"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      SuperscriptBox["c", "8"]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 865, "   ", {
   2 $CellContext`b^2 $CellContext`c^2 ($CellContext`b^4 - \
$CellContext`c^4)^2, (-2) $CellContext`b^6 $CellContext`c^6, (-2) \
$CellContext`b^6 $CellContext`c^6}, "   ", 
   Style[$CellContext`a $CellContext`b^4 $CellContext`c^4/($CellContext`b^8 - 
    4 $CellContext`b^4 $CellContext`c^4 + $CellContext`c^8), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.86109791921358*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"c3ef3b65-ecbd-43c8-86d7-5ef58347a1ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "866", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], " ", "b", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", "c"}], 
     RowBox[{
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"2", " ", "a", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "3"], " ", "c"}], "+", 
      RowBox[{"2", " ", "b", " ", 
       RowBox[{"(", 
        RowBox[{"a", "-", 
         RowBox[{"2", " ", "c"}]}], ")"}], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 866, "   ", {
   2 $CellContext`b^2 ($CellContext`b - $CellContext`c)^2 $CellContext`c^2 \
($CellContext`b^2 + $CellContext`c^2), (-2) $CellContext`b^3 $CellContext`c^3 \
($CellContext`b^2 + $CellContext`b $CellContext`c + $CellContext`c^2 - \
$CellContext`a ($CellContext`b + $CellContext`c)), (-2) $CellContext`b^3 \
$CellContext`c^3 ($CellContext`b^2 + $CellContext`b $CellContext`c + \
$CellContext`c^2 - $CellContext`a ($CellContext`b + $CellContext`c))}, "   ", 
   
   Style[$CellContext`a ($CellContext`a - $CellContext`b) $CellContext`b \
($CellContext`a - $CellContext`c) $CellContext`c/($CellContext`b^4 + 
    2 $CellContext`a $CellContext`b^2 $CellContext`c - 
    4 $CellContext`b^3 $CellContext`c + 
    2 $CellContext`b ($CellContext`a - 
      2 $CellContext`c) $CellContext`c^2 + $CellContext`c^4), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097919421874*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"e09b9580-cccf-4def-a0b7-a60b5fcd73dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "867", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"2", " ", "b"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"2", " ", "c"}]}], ")"}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 867, 
   "   ", {(-2) $CellContext`b^2 ($CellContext`b - $CellContext`c)^2 \
$CellContext`c^2, 
    2 $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + $CellContext`b \
$CellContext`c + $CellContext`c^2 - $CellContext`a ($CellContext`b + \
$CellContext`c)), 
    2 $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 + $CellContext`b \
$CellContext`c + $CellContext`c^2 - $CellContext`a ($CellContext`b + \
$CellContext`c))}, "   ", 
   Style[$CellContext`a ($CellContext`a - 
      2 $CellContext`b)^(-1) ($CellContext`a - $CellContext`b) \
($CellContext`a - 2 $CellContext`c)^(-1) ($CellContext`a - $CellContext`c), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.861097919617333*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"e0aa6da3-3e5d-45a1-aba1-96df23674776"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "868", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"]}]}], "}"}], "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], 
     RowBox[{
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 868, 
   "   ", {(-2) $CellContext`b^2 $CellContext`c^2 ($CellContext`b^2 - \
$CellContext`c^2)^2, 2 $CellContext`b^4 $CellContext`c^4, 
    2 $CellContext`b^4 $CellContext`c^4}, "   ", 
   Style[$CellContext`a $CellContext`b^2 $CellContext`c^2/($CellContext`b^4 - 
    4 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610979196637583`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"5bf45707-0280-4b35-9594-a985ea3dc41d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "925", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["c", "4"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox["a",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 925, "   ", {
   4 $CellContext`b^4 $CellContext`c^4 ($CellContext`b^2 - \
$CellContext`c^2)^2, (-4) $CellContext`b^4 $CellContext`c^4 ($CellContext`b^2 - \
$CellContext`c^2)^2, (-4) $CellContext`b^4 $CellContext`c^4 ($CellContext`b^2 - \
$CellContext`c^2)^2}, "   ", 
   Style[$CellContext`a, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.8610979210557003`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"774b31ad-990f-483b-8a41-6c8500eae181"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "964", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "3"], " ", "c"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", "b", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "3"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", "c"}], "+", 
         RowBox[{"3", " ", "b", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "3"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "3"], " ", "c"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", "b", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "3"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", "c"}], "+", 
         RowBox[{"3", " ", "b", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "3"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "3"], " ", "c"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", "b", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "3"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", "c"}], "+", 
         RowBox[{"3", " ", "b", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "3"]}]}], ")"}]}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "3"], " ", "c"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"3", " ", "b", " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "3"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", "c"}], "+", 
           RowBox[{"3", " ", "b", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "3"]}]}], ")"}]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["b", "3"], " ", "c"}], "+", 
      RowBox[{"14", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"9", " ", "b", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "3"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["b", "2"], " ", "c"}], "+", 
         RowBox[{"9", " ", "b", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "3"]}]}], ")"}]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 964, "   ", {
   2 $CellContext`b^4 + 3 $CellContext`b^3 $CellContext`c + 
    6 $CellContext`b^2 $CellContext`c^2 + 3 $CellContext`b $CellContext`c^3 + 
    2 $CellContext`c^4 + $CellContext`a (2 $CellContext`b^3 + 
      3 $CellContext`b^2 $CellContext`c + 3 $CellContext`b $CellContext`c^2 + 
      2 $CellContext`c^3), 2 $CellContext`b^4 + 
    3 $CellContext`b^3 $CellContext`c + 4 $CellContext`b^2 $CellContext`c^2 + 
    3 $CellContext`b $CellContext`c^3 + 
    2 $CellContext`c^4 + $CellContext`a (2 $CellContext`b^3 + 
      3 $CellContext`b^2 $CellContext`c + 3 $CellContext`b $CellContext`c^2 + 
      2 $CellContext`c^3), 2 $CellContext`b^4 + 
    3 $CellContext`b^3 $CellContext`c + 4 $CellContext`b^2 $CellContext`c^2 + 
    3 $CellContext`b $CellContext`c^3 + 
    2 $CellContext`c^4 + $CellContext`a (2 $CellContext`b^3 + 
      3 $CellContext`b^2 $CellContext`c + 3 $CellContext`b $CellContext`c^2 + 
      2 $CellContext`c^3)}, "   ", 
   Style[$CellContext`a (2 $CellContext`b^4 + 
     3 $CellContext`b^3 $CellContext`c + 4 $CellContext`b^2 $CellContext`c^2 + 
     3 $CellContext`b $CellContext`c^3 + 
     2 $CellContext`c^4 + $CellContext`a (2 $CellContext`b^3 + 
       3 $CellContext`b^2 $CellContext`c + 3 $CellContext`b $CellContext`c^2 + 
       2 $CellContext`c^3))/(6 $CellContext`b^4 + 
    9 $CellContext`b^3 $CellContext`c + 14 $CellContext`b^2 $CellContext`c^2 + 
    9 $CellContext`b $CellContext`c^3 + 
    6 $CellContext`c^4 + $CellContext`a (6 $CellContext`b^3 + 
      9 $CellContext`b^2 $CellContext`c + 9 $CellContext`b $CellContext`c^2 + 
      6 $CellContext`c^3)), 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.857625569025097*^9, {3.857625646823153*^9, 3.857625668769244*^9}, 
   3.859025991424939*^9, 3.859909214840852*^9, 3.86109792313623*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"910a2eaa-9070-4731-a9b3-156868ec3d68"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["liesOnMedian"], "Input",
 CellLabel->"In[12]:=",ExpressionUUID->"54ce18c6-d528-4685-9991-19db1b739853"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "5", ",", "20", ",", "21", ",", "22", ",", "23", ",", "95", ",", 
   "140", ",", "199", ",", "233", ",", "237", ",", "253", ",", "280", ",", 
   "347", ",", "376", ",", "377", ",", "379", ",", "381", ",", "382", ",", 
   "383", ",", "401", ",", "402", ",", "404", ",", "405", ",", "409", ",", 
   "411", ",", "413", ",", "416", ",", "439", ",", "442", ",", "443", ",", 
   "446", ",", "448", ",", "449", ",", "452", ",", "453", ",", "474", ",", 
   "546", ",", "547", ",", "548", ",", "549", ",", "550", ",", "631", ",", 
   "632", ",", "851", ",", "853", ",", "854", ",", "855", ",", "857", ",", 
   "858", ",", "859", ",", "861", ",", "863", ",", "864", ",", "865", ",", 
   "866", ",", "867", ",", "868", ",", "925", ",", "964"}], "}"}]], "Output",
 CellChangeTimes->{3.8575876991332817`*^9, 3.8576255694726973`*^9, 
  3.857625651702629*^9, 3.857626935315383*^9, 3.859026149351355*^9, 
  3.8599093737051773`*^9, 3.861097924615768*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"64181869-f189-428e-a9e8-d85137825471"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["rational"], "Input",
 CellChangeTimes->{{3.857591043077764*^9, 3.857591044877014*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"9b0cb274-4df1-455a-add5-1a58f07de223"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     FractionBox["3", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"95", ",", 
     FractionBox["5", "4"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"97", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"122", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"123", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"127", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"131", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"140", ",", 
     FractionBox["4", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"216", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"233", ",", 
     FractionBox["5", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"253", ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"268", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"280", ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"339", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"347", ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"376", ",", 
     FractionBox["3", "4"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"381", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"382", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"401", ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"402", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"408", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"417", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"418", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"426", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"440", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"441", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"454", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"464", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"465", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"466", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"546", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"547", ",", 
     FractionBox["12", "7"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"548", ",", 
     FractionBox["4", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"549", ",", 
     FractionBox["6", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"550", ",", 
     FractionBox["2", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"577", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"631", ",", 
     FractionBox["5", "4"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"632", ",", 
     FractionBox["10", "7"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"828", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"852", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"856", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"858", ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"925", ",", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8575910460340433`*^9, 3.857592021705902*^9, 
  3.857625569506566*^9, 3.857626939390044*^9, 3.859026149360941*^9, 
  3.859909373718733*^9, 3.861097924628339*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"42125a45-8754-462b-ba84-f36534e49b33"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["coincidesWithE"], "Input",
 CellLabel->"In[14]:=",ExpressionUUID->"554b814f-00b0-4a8b-95c8-add2a6a0fdff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "97", ",", "122", ",", "123", ",", "127", ",", "131", ",", "216", 
   ",", "268", ",", "339", ",", "408", ",", "417", ",", "418", ",", "426", 
   ",", "440", ",", "441", ",", "454", ",", "464", ",", "465", ",", "466", 
   ",", "577", ",", "828", ",", "852", ",", "856"}], "}"}]], "Output",
 CellChangeTimes->{3.857625604455371*^9, 3.85762694328474*^9, 
  3.859026149398769*^9, 3.859909373819765*^9, 3.8610979247261143`*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"33668292-374e-4110-9668-0743227781f2"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X(102) lies on angle bisector", "Subsection",
 CellChangeTimes->{{3.858791069881806*^9, 3.85879107882787*^9}, {
   3.859404818267939*^9, 3.8594048240996017`*^9}, 
   3.8610921440084352`*^9},ExpressionUUID->"dbb1befd-a849-425c-9ea4-\
b9d195bfaf81"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f102", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  RowBox[{
   SuperscriptBox["a", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "4"], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "+", 
     SuperscriptBox["b", "4"], "-", 
     RowBox[{
      SuperscriptBox["a", "3"], " ", "c"}], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["b", "2"], " ", "c"}], "-", 
     RowBox[{
      SuperscriptBox["b", "3"], " ", "c"}], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     RowBox[{"2", " ", "a", " ", "b", " ", 
      SuperscriptBox["c", "2"]}], "+", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["c", "3"]}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["c", "3"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["c", "4"]}]}], ")"}], " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "b"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
      RowBox[{"2", " ", "a", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "3"], " ", "c"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"a", " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      SuperscriptBox["c", "4"]}], ")"}], "/", "a"}]}]}]], "Input",
 CellChangeTimes->{{3.857740503942257*^9, 3.857740526901718*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"306bc053-b366-4a7d-aed9-13d10022fc9a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f102", "[", 
     RowBox[{"a", ",", "b", ",", "c"}], "]"}], "-", 
    RowBox[{"f102", "[", 
     RowBox[{"b", ",", "a", ",", "c"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "+", 
     RowBox[{"b", "^", "2"}]}], "\[Equal]", 
    RowBox[{"c", "^", "2"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.857727925741263*^9, 3.857727960893217*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"c59c02c8-1f35-487d-91fc-7de37b4179a2"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.857727961958148*^9, 3.857728085897991*^9, 
  3.85774054970686*^9, 3.8577405989880857`*^9, 3.85902614944405*^9, 
  3.8599093739272947`*^9, 3.86109792482961*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"c2189221-d3e3-4148-bcf1-d063c91ac4bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"f102", "[", 
     RowBox[{"a", ",", "b", ",", "c"}], "]"}], "-", 
    RowBox[{"f102", "[", 
     RowBox[{"b", ",", "a", ",", "c"}], "]"}]}], "]"}], "//", 
  "Factor"}]], "Input",
 CellChangeTimes->{{3.85774060852573*^9, 3.857740630765485*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"d5187fbc-36b2-4e24-b3ea-6a94f77efc90"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "-", "b"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "4"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    SuperscriptBox["b", "4"], "-", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["b", "3"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["c", "4"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.8577406096715603`*^9, 3.8577406315947857`*^9}, 
   3.859026149488964*^9, 3.859909374026567*^9, 3.8610979249259567`*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"2ae7d054-9bbc-43ac-ab21-56ecaaf5d104"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Lemmas about Isosceles Triangles", "Subsection",
 CellChangeTimes->{{3.859445076022099*^9, 3.859445084999343*^9}, {
  3.859445221884012*^9, 3.859445228707782*^9}, {3.859445273990197*^9, 
  3.8594452945879297`*^9}, {3.859445819846087*^9, 
  3.85944583211761*^9}},ExpressionUUID->"7f694f99-2216-46d0-b435-\
d277881be957"],

Cell[CellGroupData[{

Cell["Code", "Subsubsection",
 CellChangeTimes->{{3.859446068161223*^9, 
  3.859446074114582*^9}},ExpressionUUID->"3592fc2f-0498-4a33-8241-\
5a0cecd78f72"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"coincidesWithM", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"onLineAtInfinity", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"atInfinitWhenIsosceles", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"transcendental", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coincidesWithA", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rational", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptA", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptM", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"n", "=", "1"}], ",", 
    RowBox[{"n", "\[LessEqual]", "1000"}], ",", 
    RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"coords", "=", 
      RowBox[{"ETC1", "[", 
       RowBox[{"[", 
        RowBox[{"n", ",", "2"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"ignore", " ", "transcendental", " ", "centers"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"coords", "\[Equal]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"transcendental", ",", "n"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Continue", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u", ",", "v", ",", "w"}], "}"}], "=", 
      RowBox[{"ptX", "=", 
       RowBox[{"coords", "/.", 
        RowBox[{"S", "->", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]]}]}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"ignore", " ", "points", " ", "at", " ", "infinity"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Expand", "[", 
         RowBox[{"u", "+", "v", "+", "w"}], "]"}], "\[Equal]", "0"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"onLineAtInfinity", ",", "n"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Continue", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Expand", "[", 
         RowBox[{
          RowBox[{"u", "+", "v", "+", "w"}], "/.", 
          RowBox[{"c", "\[Rule]", "b"}]}], "]"}], "\[Equal]", "0"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"atInfinitWhenIsosceles", ",", "n"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Continue", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Expand", "[", 
         RowBox[{"u", "/.", 
          RowBox[{"c", "\[Rule]", "b"}]}], "]"}], "\[Equal]", "0"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"coincidesWithM", ",", "n"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Continue", "[", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"ratio", " ", "=", " ", 
       RowBox[{"XM", "/", "AM"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"ratio", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"u", "/", 
         RowBox[{"(", 
          RowBox[{"u", "+", 
           RowBox[{"2", "v"}]}], ")"}]}], "/.", 
        RowBox[{"c", "\[Rule]", "b"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"(*", " ", 
      RowBox[{
      "ignore", " ", "points", " ", "that", " ", "coincide", " ", "with", " ",
        "A"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ratio", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"coincidesWithA", ",", "n"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Continue", "[", "]"}]}]}], "]"}], "\[IndentingNewLine]", ";",
      "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"NumericQ", "[", "ratio", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<n=\>\"", ",", "n", ",", "\"\<   \>\"", ",", "ptX", ",", 
          "\"\<   XM/AM=\>\"", ",", 
          RowBox[{"Style", "[", 
           RowBox[{"ratio", ",", "Red"}], "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"rational", ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "ratio"}], "}"}]}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.85823859791429*^9, 3.85823861081002*^9}, {
   3.858238666170635*^9, 3.858238671842203*^9}, {3.8582387034349937`*^9, 
   3.858238879946652*^9}, {3.8582389657328787`*^9, 3.8582389797310667`*^9}, {
   3.8582392486772118`*^9, 3.8582392767083197`*^9}, {3.858239316526222*^9, 
   3.858239316940321*^9}, {3.8582393919104853`*^9, 3.858239410404519*^9}, {
   3.858331060436795*^9, 3.8583310835636053`*^9}, {3.8583311335560627`*^9, 
   3.8583312056613417`*^9}, {3.858331353269075*^9, 3.858331361757183*^9}, {
   3.85833142168615*^9, 3.858331476637041*^9}, {3.8583315261749496`*^9, 
   3.858331647885808*^9}, 3.858331679870125*^9, {3.858331841511511*^9, 
   3.858331889799799*^9}, {3.858331948776697*^9, 3.858331950886672*^9}, {
   3.858332138091186*^9, 3.858332168351516*^9}, {3.8583598800744762`*^9, 
   3.858359881256414*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"2174a73f-b1f9-4467-aa7a-16b96a1a56b4"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", "3"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm["n=", 2, "   ", {1, 1, 1}, "   XM/AM=", 
   Style[
    Rational[1, 3], 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8582388810740433`*^9, 3.858238982017474*^9, 3.858239293903975*^9, 
   3.858239324800816*^9, 3.8582394196432247`*^9, 3.8583316812055197`*^9, 
   3.858331891465007*^9, 3.858331952268735*^9, {3.858332141041862*^9, 
   3.858332169750382*^9}, 3.858359883598342*^9, 3.859026180337306*^9, 
   3.8599093741520576`*^9, 3.861097924951191*^9},
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"4fa7a0c0-e321-4e38-aced-94e41f5cdfcd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "148", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 148, 
   "   ", {$CellContext`a^4 - $CellContext`a^2 $CellContext`b^2 - \
$CellContext`b^4 - $CellContext`a^2 $CellContext`c^2 + 
    3 $CellContext`b^2 $CellContext`c^2 - $CellContext`c^4, -$CellContext`a^4 - \
$CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 + 
    3 $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 - \
$CellContext`c^4, -$CellContext`a^4 + 
    3 $CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 - $CellContext`a^2 \
$CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4}, 
   "   XM/AM=", 
   Style[-1, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8582388810740433`*^9, 3.858238982017474*^9, 3.858239293903975*^9, 
   3.858239324800816*^9, 3.8582394196432247`*^9, 3.8583316812055197`*^9, 
   3.858331891465007*^9, 3.858331952268735*^9, {3.858332141041862*^9, 
   3.858332169750382*^9}, 3.858359883598342*^9, 3.859026180337306*^9, 
   3.8599093741520576`*^9, 3.8610979254708433`*^9},
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"66ecab55-a542-4b63-8a4b-43294fc2e036"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "149", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "3"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "3"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "c"}], "-", 
      RowBox[{"a", " ", "b", " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "3"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "3"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "3"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "c"}], "-", 
      RowBox[{"a", " ", "b", " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "3"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "3"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "3"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "c"}], "-", 
      RowBox[{"a", " ", "b", " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "3"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 149, 
   "   ", {$CellContext`a^3 - $CellContext`a^2 $CellContext`b + \
$CellContext`a $CellContext`b^2 - $CellContext`b^3 - $CellContext`a^2 \
$CellContext`c - $CellContext`a $CellContext`b $CellContext`c + \
$CellContext`b^2 $CellContext`c + $CellContext`a $CellContext`c^2 + \
$CellContext`b $CellContext`c^2 - $CellContext`c^3, -$CellContext`a^3 + \
$CellContext`a^2 $CellContext`b - $CellContext`a $CellContext`b^2 + \
$CellContext`b^3 + $CellContext`a^2 $CellContext`c - $CellContext`a \
$CellContext`b $CellContext`c - $CellContext`b^2 $CellContext`c + \
$CellContext`a $CellContext`c^2 + $CellContext`b $CellContext`c^2 - \
$CellContext`c^3, -$CellContext`a^3 + $CellContext`a^2 $CellContext`b + \
$CellContext`a $CellContext`b^2 - $CellContext`b^3 + $CellContext`a^2 \
$CellContext`c - $CellContext`a $CellContext`b $CellContext`c + \
$CellContext`b^2 $CellContext`c - $CellContext`a $CellContext`c^2 - \
$CellContext`b $CellContext`c^2 + $CellContext`c^3}, "   XM/AM=", 
   Style[-1, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8582388810740433`*^9, 3.858238982017474*^9, 3.858239293903975*^9, 
   3.858239324800816*^9, 3.8582394196432247`*^9, 3.8583316812055197`*^9, 
   3.858331891465007*^9, 3.858331952268735*^9, {3.858332141041862*^9, 
   3.858332169750382*^9}, 3.858359883598342*^9, 3.859026180337306*^9, 
   3.8599093741520576`*^9, 3.861097925479149*^9},
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"608e0e89-dbca-4e28-925a-b194be006c6d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "150", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "b"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "3"], " ", "c"}], "-", 
      RowBox[{"a", " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "3"]}], "-", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "b"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}], "+", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["b", "3"], " ", "c"}], "-", 
      RowBox[{"a", " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "3"]}], "-", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "b"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "3"], " ", "c"}], "+", 
      RowBox[{"a", " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      SuperscriptBox["c", "4"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 150, 
   "   ", {$CellContext`a^4 - $CellContext`a^3 $CellContext`b + \
$CellContext`a $CellContext`b^3 - $CellContext`b^4 - $CellContext`a^3 \
$CellContext`c + $CellContext`a^2 $CellContext`b $CellContext`c - \
$CellContext`a $CellContext`b^2 $CellContext`c + $CellContext`b^3 \
$CellContext`c - $CellContext`a $CellContext`b $CellContext`c^2 + \
$CellContext`a $CellContext`c^3 + $CellContext`b $CellContext`c^3 - \
$CellContext`c^4, -$CellContext`a^4 + $CellContext`a^3 $CellContext`b - \
$CellContext`a $CellContext`b^3 + $CellContext`b^4 + $CellContext`a^3 \
$CellContext`c - $CellContext`a^2 $CellContext`b $CellContext`c + \
$CellContext`a $CellContext`b^2 $CellContext`c - $CellContext`b^3 \
$CellContext`c - $CellContext`a $CellContext`b $CellContext`c^2 + \
$CellContext`a $CellContext`c^3 + $CellContext`b $CellContext`c^3 - \
$CellContext`c^4, -$CellContext`a^4 + $CellContext`a^3 $CellContext`b + \
$CellContext`a $CellContext`b^3 - $CellContext`b^4 + $CellContext`a^3 \
$CellContext`c - $CellContext`a^2 $CellContext`b $CellContext`c - \
$CellContext`a $CellContext`b^2 $CellContext`c + $CellContext`b^3 \
$CellContext`c + $CellContext`a $CellContext`b $CellContext`c^2 - \
$CellContext`a $CellContext`c^3 - $CellContext`b $CellContext`c^3 + \
$CellContext`c^4}, "   XM/AM=", 
   Style[-1, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8582388810740433`*^9, 3.858238982017474*^9, 3.858239293903975*^9, 
   3.858239324800816*^9, 3.8582394196432247`*^9, 3.8583316812055197`*^9, 
   3.858331891465007*^9, 3.858331952268735*^9, {3.858332141041862*^9, 
   3.858332169750382*^9}, 3.858359883598342*^9, 3.859026180337306*^9, 
   3.8599093741520576`*^9, 3.861097925483327*^9},
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"f84d67bb-a0a7-464c-8728-9b8e2f2aa65c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "290", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", 
     FractionBox["1", "3"]}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 290, 
   "   ", {$CellContext`b^2 $CellContext`c^2 ($CellContext`a^4 + \
$CellContext`b^4 - $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 \
$CellContext`c^2) ($CellContext`a^4 - $CellContext`a^2 $CellContext`b^2 - \
$CellContext`b^2 $CellContext`c^2 + $CellContext`c^4), $CellContext`a^2 \
$CellContext`c^2 ($CellContext`a^4 + $CellContext`b^4 - $CellContext`a^2 \
$CellContext`c^2 - $CellContext`b^2 $CellContext`c^2) (-$CellContext`a^2 \
$CellContext`b^2 + $CellContext`b^4 - $CellContext`a^2 $CellContext`c^2 + \
$CellContext`c^4), $CellContext`a^2 $CellContext`b^2 (-$CellContext`a^2 \
$CellContext`b^2 + $CellContext`b^4 - $CellContext`a^2 $CellContext`c^2 + \
$CellContext`c^4) ($CellContext`a^4 - $CellContext`a^2 $CellContext`b^2 - \
$CellContext`b^2 $CellContext`c^2 + $CellContext`c^4)}, "   XM/AM=", 
   Style[
    Rational[-1, 3], 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8582388810740433`*^9, 3.858238982017474*^9, 3.858239293903975*^9, 
   3.858239324800816*^9, 3.8582394196432247`*^9, 3.8583316812055197`*^9, 
   3.858331891465007*^9, 3.858331952268735*^9, {3.858332141041862*^9, 
   3.858332169750382*^9}, 3.858359883598342*^9, 3.859026180337306*^9, 
   3.8599093741520576`*^9, 3.861097928972438*^9},
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"4b40fde0-48d1-4a47-9b92-a0db020a8e18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "402", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "6"]}], "-", 
        SuperscriptBox["b", "8"], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        SuperscriptBox["c", "8"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "6"]}], "+", 
        SuperscriptBox["b", "8"], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        SuperscriptBox["c", "8"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "8"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "6"]}], "-", 
        SuperscriptBox["b", "8"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        SuperscriptBox["c", "8"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 402, 
   "   ", {(2 $CellContext`a^4 - $CellContext`a^2 $CellContext`b^2 - \
$CellContext`b^4 - $CellContext`a^2 $CellContext`c^2 + 
     2 $CellContext`b^2 $CellContext`c^2 - $CellContext`c^4) \
($CellContext`a^8 - $CellContext`a^6 $CellContext`b^2 - 
     2 $CellContext`a^4 $CellContext`b^4 + 
     3 $CellContext`a^2 $CellContext`b^6 - $CellContext`b^8 - \
$CellContext`a^6 $CellContext`c^2 + 
     5 $CellContext`a^4 $CellContext`b^2 $CellContext`c^2 - 
     3 $CellContext`a^2 $CellContext`b^4 $CellContext`c^2 - $CellContext`b^6 \
$CellContext`c^2 - 2 $CellContext`a^4 $CellContext`c^4 - 
     3 $CellContext`a^2 $CellContext`b^2 $CellContext`c^4 + 
     4 $CellContext`b^4 $CellContext`c^4 + 
     3 $CellContext`a^2 $CellContext`c^6 - $CellContext`b^2 $CellContext`c^6 - \
$CellContext`c^8), (-$CellContext`a^4 - $CellContext`a^2 $CellContext`b^2 + 
     2 $CellContext`b^4 + 
     2 $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 - \
$CellContext`c^4) (-$CellContext`a^8 + 3 $CellContext`a^6 $CellContext`b^2 - 
     2 $CellContext`a^4 $CellContext`b^4 - $CellContext`a^2 $CellContext`b^6 + \
$CellContext`b^8 - $CellContext`a^6 $CellContext`c^2 - 
     3 $CellContext`a^4 $CellContext`b^2 $CellContext`c^2 + 
     5 $CellContext`a^2 $CellContext`b^4 $CellContext`c^2 - $CellContext`b^6 \
$CellContext`c^2 + 4 $CellContext`a^4 $CellContext`c^4 - 
     3 $CellContext`a^2 $CellContext`b^2 $CellContext`c^4 - 
     2 $CellContext`b^4 $CellContext`c^4 - $CellContext`a^2 $CellContext`c^6 + 
     3 $CellContext`b^2 $CellContext`c^6 - $CellContext`c^8), \
(-$CellContext`a^4 + 
     2 $CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 - \
$CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 + 
     2 $CellContext`c^4) (-$CellContext`a^8 - $CellContext`a^6 \
$CellContext`b^2 + 
     4 $CellContext`a^4 $CellContext`b^4 - $CellContext`a^2 $CellContext`b^6 - \
$CellContext`b^8 + 3 $CellContext`a^6 $CellContext`c^2 - 
     3 $CellContext`a^4 $CellContext`b^2 $CellContext`c^2 - 
     3 $CellContext`a^2 $CellContext`b^4 $CellContext`c^2 + 
     3 $CellContext`b^6 $CellContext`c^2 - 
     2 $CellContext`a^4 $CellContext`c^4 + 
     5 $CellContext`a^2 $CellContext`b^2 $CellContext`c^4 - 
     2 $CellContext`b^4 $CellContext`c^4 - $CellContext`a^2 $CellContext`c^6 - \
$CellContext`b^2 $CellContext`c^6 + $CellContext`c^8)}, "   XM/AM=", 
   Style[
    Rational[1, 2], 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8582388810740433`*^9, 3.858238982017474*^9, 3.858239293903975*^9, 
   3.858239324800816*^9, 3.8582394196432247`*^9, 3.8583316812055197`*^9, 
   3.858331891465007*^9, 3.858331952268735*^9, {3.858332141041862*^9, 
   3.858332169750382*^9}, 3.858359883598342*^9, 3.859026180337306*^9, 
   3.8599093741520576`*^9, 3.861097929907825*^9},
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"d3d3bdd8-eadb-44b9-8bc8-90a5b9a7aa6d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "620", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", "2"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 620, "   ", {
   2 $CellContext`a^4 - 
    2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - 
    2 $CellContext`a^2 $CellContext`c^2 + $CellContext`c^4, $CellContext`a^4 - 
    2 $CellContext`a^2 $CellContext`b^2 + 2 $CellContext`b^4 - 
    2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4, $CellContext`a^4 + \
$CellContext`b^4 - 2 $CellContext`a^2 $CellContext`c^2 - 
    2 $CellContext`b^2 $CellContext`c^2 + 2 $CellContext`c^4}, "   XM/AM=", 
   Style[
    Rational[1, 2], 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8582388810740433`*^9, 3.858238982017474*^9, 3.858239293903975*^9, 
   3.858239324800816*^9, 3.8582394196432247`*^9, 3.8583316812055197`*^9, 
   3.858331891465007*^9, 3.858331952268735*^9, {3.858332141041862*^9, 
   3.858332169750382*^9}, 3.858359883598342*^9, 3.859026180337306*^9, 
   3.8599093741520576`*^9, 3.8610979319908247`*^9},
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"54591df9-04f6-456e-afd7-32c1ecd2f74a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "671", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", 
     FractionBox["1", "3"]}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 671, 
   "   ", {($CellContext`a^2 + $CellContext`b^2 - 
     2 $CellContext`c^2) ($CellContext`a^2 - 
     2 $CellContext`b^2 + $CellContext`c^2), ($CellContext`a^2 + \
$CellContext`b^2 - 
     2 $CellContext`c^2) ((-2) $CellContext`a^2 + $CellContext`b^2 + \
$CellContext`c^2), ($CellContext`a^2 - 
     2 $CellContext`b^2 + $CellContext`c^2) ((-2) $CellContext`a^2 + \
$CellContext`b^2 + $CellContext`c^2)}, "   XM/AM=", 
   Style[
    Rational[-1, 3], 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8582388810740433`*^9, 3.858238982017474*^9, 3.858239293903975*^9, 
   3.858239324800816*^9, 3.8582394196432247`*^9, 3.8583316812055197`*^9, 
   3.858331891465007*^9, 3.858331952268735*^9, {3.858332141041862*^9, 
   3.858332169750382*^9}, 3.858359883598342*^9, 3.859026180337306*^9, 
   3.8599093741520576`*^9, 3.861097932512117*^9},
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"af1ad1e6-336c-426b-b55b-450788ccd2e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "903", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"2", " ", "b"}], "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"2", " ", "b"}], "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "a"}], "+", "b", "+", "c"}], ")"}]}]}], 
    "}"}], "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", 
     FractionBox["1", "3"]}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 903, 
   "   ", {($CellContext`a + $CellContext`b - 
     2 $CellContext`c) ($CellContext`a - 
     2 $CellContext`b + $CellContext`c), ($CellContext`a + $CellContext`b - 
     2 $CellContext`c) ((-2) $CellContext`a + $CellContext`b + \
$CellContext`c), ($CellContext`a - 
     2 $CellContext`b + $CellContext`c) ((-2) $CellContext`a + $CellContext`b + \
$CellContext`c)}, "   XM/AM=", 
   Style[
    Rational[-1, 3], 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8582388810740433`*^9, 3.858238982017474*^9, 3.858239293903975*^9, 
   3.858239324800816*^9, 3.8582394196432247`*^9, 3.8583316812055197`*^9, 
   3.858331891465007*^9, 3.858331952268735*^9, {3.858332141041862*^9, 
   3.858332169750382*^9}, 3.858359883598342*^9, 3.859026180337306*^9, 
   3.8599093741520576`*^9, 3.861097932927553*^9},
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"de91ae73-49e0-4a61-87b4-9da43eca257e"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Lemma 5.11", "Subsubsection",
 CellChangeTimes->{{3.8594453686306143`*^9, 3.8594453774601097`*^9}, {
  3.8594458978974247`*^9, 
  3.859445905493806*^9}},ExpressionUUID->"8d28747c-75c4-4366-8c07-\
c55bccddb632"],

Cell[CellGroupData[{

Cell[BoxData["coincidesWithA"], "Input",
 CellChangeTimes->{{3.858331728301318*^9, 3.858331735140511*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"5c83edd7-f0f5-4b4d-a147-4ccc1ecc1f5c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "59", ",", "99", ",", "100", ",", "101", ",", "107", ",", "108", ",", "109",
    ",", "110", ",", "112", ",", "162", ",", "163", ",", "190", ",", "249", 
   ",", "250", ",", "476", ",", "643", ",", "644", ",", "645", ",", "646", 
   ",", "648", ",", "651", ",", "653", ",", "655", ",", "658", ",", "660", 
   ",", "662", ",", "664", ",", "666", ",", "668", ",", "670", ",", "677", 
   ",", "681", ",", "685", ",", "687", ",", "689", ",", "691", ",", "692", 
   ",", "765", ",", "769", ",", "771", ",", "773", ",", "777", ",", "779", 
   ",", "781", ",", "783", ",", "785", ",", "787", ",", "789", ",", "791", 
   ",", "793", ",", "795", ",", "797", ",", "799", ",", "803", ",", "805", 
   ",", "807", ",", "809", ",", "811", ",", "813", ",", "815", ",", "817", 
   ",", "819", ",", "823", ",", "825", ",", "827", ",", "831", ",", "833", 
   ",", "835", ",", "839", ",", "874", ",", "877", ",", "880", ",", "883", 
   ",", "886", ",", "889", ",", "892", ",", "898", ",", "901", ",", "906", 
   ",", "907", ",", "919", ",", "925", ",", "927", ",", "929", ",", "930", 
   ",", "931", ",", "932", ",", "933", ",", "934", ",", "935"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.858331736185823*^9, 3.858332195471545*^9, 
  3.8590261882992573`*^9, 3.85990938211487*^9, 3.861097933214198*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"c25cee09-4cdf-4c2f-81b2-205788e9684e"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Lemma 5.12", "Subsubsection",
 CellChangeTimes->{{3.8594453350151377`*^9, 3.859445346092084*^9}, {
  3.859445882051116*^9, 
  3.859445891101851*^9}},ExpressionUUID->"0c41d9be-0cc4-4472-b345-\
b69011c186c7"],

Cell[CellGroupData[{

Cell[BoxData["coincidesWithM"], "Input",
 CellLabel->"In[28]:=",ExpressionUUID->"9d5ae49b-cb60-4a60-abe0-66b0cab9790e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "11", ",", "115", ",", "116", ",", "122", ",", "123", ",", "124", ",", 
   "125", ",", "127", ",", "130", ",", "134", ",", "135", ",", "136", ",", 
   "137", ",", "139", ",", "244", ",", "245", ",", "246", ",", "247", ",", 
   "338", ",", "339", ",", "865", ",", "866", ",", "867", ",", "868"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.858241236301021*^9, 3.858331717152158*^9, 
  3.858332189871676*^9, 3.859026188290164*^9, 3.859909382125209*^9, 
  3.861097933222493*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"a6a9de13-18e9-40e1-82e5-0f451a412796"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Lemma 5.13", "Subsubsection",
 CellChangeTimes->{{3.859445420310774*^9, 3.859445426996429*^9}, {
  3.859445958498151*^9, 
  3.859445966518209*^9}},ExpressionUUID->"8c5cc360-a212-4ed8-9aa8-\
3e86e887ee9d"],

Cell[CellGroupData[{

Cell[BoxData["atInfinitWhenIsosceles"], "Input",
 CellLabel->"In[29]:=",ExpressionUUID->"cf2286b8-72f0-4c7a-8c11-f9111d10bdba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "351", ",", "647", ",", "649", ",", "650", ",", "652", ",", "654", ",", 
   "656", ",", "657", ",", "659", ",", "661", ",", "663", ",", "665", ",", 
   "667", ",", "669", ",", "676", ",", "684", ",", "686", ",", "693", ",", 
   "764", ",", "770", ",", "798", ",", "810", ",", "822", ",", "850", ",", 
   "875", ",", "876", ",", "878", ",", "879", ",", "881", ",", "882", ",", 
   "884", ",", "885", ",", "887", ",", "890", ",", "905"}], "}"}]], "Output",
 CellChangeTimes->{3.8583317601366863`*^9, 3.8583319096033287`*^9, 
  3.8583319671088057`*^9, 3.858332158416903*^9, 3.8583322201885433`*^9, 
  3.8590261883861437`*^9, 3.859909382217884*^9, 3.8610979332623568`*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"4087c3ff-4390-4d7f-938f-7dbaae67c307"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["On Line at Infinity", "Subsubsection",
 CellChangeTimes->{{3.85944591621681*^9, 
  3.859445923902027*^9}},ExpressionUUID->"45a91fab-27f0-4050-8126-\
7564dbe45784"],

Cell[CellGroupData[{

Cell[BoxData["onLineAtInfinity"], "Input",
 CellLabel->"In[30]:=",ExpressionUUID->"d45c2ca2-d9e4-4c4b-96db-3b090776d3fd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "30", ",", "511", ",", "512", ",", "513", ",", "514", ",", "515", ",", 
   "516", ",", "517", ",", "518", ",", "519", ",", "520", ",", "521", ",", 
   "522", ",", "523", ",", "524", ",", "525", ",", "526", ",", "527", ",", 
   "528", ",", "529", ",", "530", ",", "531", ",", "532", ",", "533", ",", 
   "534", ",", "535", ",", "536", ",", "537", ",", "538", ",", "539", ",", 
   "540", ",", "541", ",", "542", ",", "543", ",", "544", ",", "545", ",", 
   "674", ",", "680", ",", "688", ",", "690", ",", "696", ",", "698", ",", 
   "700", ",", "702", ",", "704", ",", "706", ",", "708", ",", "710", ",", 
   "712", ",", "714", ",", "716", ",", "718", ",", "720", ",", "722", ",", 
   "724", ",", "726", ",", "730", ",", "732", ",", "734", ",", "736", ",", 
   "740", ",", "742", ",", "744", ",", "746", ",", "752", ",", "754", ",", 
   "758", ",", "760", ",", "766", ",", "768", ",", "772", ",", "776", ",", 
   "778", ",", "780", ",", "782", ",", "784", ",", "786", ",", "788", ",", 
   "790", ",", "792", ",", "794", ",", "796", ",", "802", ",", "804", ",", 
   "806", ",", "808", ",", "812", ",", "814", ",", "816", ",", "818", ",", 
   "824", ",", "826", ",", "830", ",", "832", ",", "834", ",", "838", ",", 
   "888", ",", "891", ",", "900", ",", "912", ",", "916", ",", "918", ",", 
   "924", ",", "926", ",", "928", ",", "952", ",", "971"}], "}"}]], "Output",
 CellChangeTimes->{3.858331749174711*^9, 3.858332210629137*^9, 
  3.859026188338099*^9, 3.859909382229315*^9, 3.8610979332717047`*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"66b8f85f-c297-4018-976b-e133360ea132"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Transcendental", "Subsubsection",
 CellChangeTimes->{{3.859445937776704*^9, 
  3.8594459469135027`*^9}},ExpressionUUID->"59324dc0-4f8b-49b9-8a79-\
4259442ad5b3"],

Cell[CellGroupData[{

Cell[BoxData["transcendental"], "Input",
 CellChangeTimes->{{3.858331763374083*^9, 3.85833177063699*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"0b14d143-dc6c-419b-b6db-272b3e063e8b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "356", ",", "357", ",", "358", ",", "359", ",", "360", ",", "368", ",", 
   "369", ",", "370", ",", "848"}], "}"}]], "Output",
 CellChangeTimes->{3.85833177269938*^9, 3.8583322156324463`*^9, 
  3.859026188346973*^9, 3.859909382269559*^9, 3.86109793331126*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"19b49d1c-e7c1-42bb-984d-bf389796cd06"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Rational", "Subsubsection",
 CellChangeTimes->{{3.8594459827928257`*^9, 
  3.8594459914495*^9}},ExpressionUUID->"eed99e70-3dba-4177-be17-e45b82903e47"],

Cell[CellGroupData[{

Cell[BoxData["rational"], "Input",
 CellLabel->"In[32]:=",ExpressionUUID->"6b9c45d9-fd46-4d07-a773-7601139e9543"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     FractionBox["1", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"148", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"149", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"150", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"290", ",", 
     RowBox[{"-", 
      FractionBox["1", "3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"402", ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"620", ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"671", ",", 
     RowBox[{"-", 
      FractionBox["1", "3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"903", ",", 
     RowBox[{"-", 
      FractionBox["1", "3"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8583317869725113`*^9, 3.858332233644271*^9, 
  3.859026188395537*^9, 3.85990938227991*^9, 3.861097933320671*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"14fecc82-ad46-428f-837b-197ddc35acef"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"all", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "1000"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"other", "=", 
   RowBox[{"Union", "[", 
    RowBox[{
    "coincidesWithM", ",", "coincidesWithA", ",", "onLineAtInfinity", ",", 
     "transcendental", ",", "atInfinitWhenIsosceles"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"none", "=", 
   RowBox[{"Complement", "[", 
    RowBox[{"all", ",", "other"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.858332254199299*^9, 3.85833234927109*^9}, 
   3.858332386272368*^9},
 CellLabel->"In[33]:=",ExpressionUUID->"a7008ab6-a0de-4671-86f5-e4001438a3eb"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Section 7 (Diagonal Point)", "Section",
 CellChangeTimes->{{3.8594049965053043`*^9, 3.859405006959635*^9}, {
  3.859405114436821*^9, 
  3.8594051228924417`*^9}},ExpressionUUID->"470861c6-3446-4848-9c07-\
bf0f9b32f469"],

Cell[CellGroupData[{

Cell["Section 7.1 - General Quadrilaterals", "Subsection",
 CellChangeTimes->{{3.859405167493054*^9, 3.859405189953619*^9}, {
   3.859405283973345*^9, 3.859405287892915*^9}, 
   3.861083890286337*^9},ExpressionUUID->"9d82def8-3fac-42a3-817b-\
114b3e835fcd"],

Cell[CellGroupData[{

Cell["Theorem 7.1", "Subsubsection",
 CellChangeTimes->{{3.861083874246047*^9, 
  3.861083884323084*^9}},ExpressionUUID->"64765008-1a29-4e9f-ab64-\
b3955dcd556a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"QA", "-", 
    RowBox[{"CT", " ", "coordinates"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"p", ",", "q", ",", "r"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ptA", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ptB", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ptC", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ptD", "=", 
     RowBox[{"normed", "[", 
      RowBox[{"{", 
       RowBox[{"p", ",", "q", ",", "r"}], "}"}], "]"}]}], ";"}]}]}]], "Input",\

 CellChangeTimes->{{3.857821799077696*^9, 3.857821847212615*^9}, {
  3.8578219118616257`*^9, 3.857821922421125*^9}, {3.857822075245823*^9, 
  3.8578220876217203`*^9}, {3.85782866926807*^9, 3.857828683971848*^9}, {
  3.857830483378106*^9, 3.857830486464405*^9}, {3.857830801522435*^9, 
  3.8578308063216476`*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"4ecfe8d7-059a-474a-9395-a78585538ea2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x20", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", 
      SuperscriptBox["a", "4"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "-", 
     SuperscriptBox["b", "4"], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     SuperscriptBox["c", "4"]}], ",", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "4"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["b", "4"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     SuperscriptBox["c", "4"]}], ",", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "4"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "-", 
     SuperscriptBox["b", "4"], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["c", "4"]}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.85782214283048*^9, 3.857822144815009*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"575920e1-afc7-4733-889e-249b92cd939a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    SuperscriptBox["b", "4"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    SuperscriptBox["c", "4"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "4"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["b", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    SuperscriptBox["c", "4"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    SuperscriptBox["b", "4"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["c", "4"]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8578221468457413`*^9, 3.8578304906481028`*^9, 
  3.857899078752836*^9, 3.859026149588591*^9, 3.859909382416641*^9, 
  3.861097933379541*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"41071dad-4586-4e15-bd8e-858653dd6762"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"line", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u1_", ",", "v1_", ",", "w1_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"u2_", ",", "v2_", ",", "w2_"}], "}"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Det", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u1", ",", "v1", ",", "w1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u2", ",", "v2", ",", "w2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], "]"}], "\[Equal]", 
   "0"}]}]], "Input",
 CellChangeTimes->{{3.8578226329358377`*^9, 3.857822735792715*^9}, {
  3.857822783545182*^9, 3.857822786431864*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"c8f366ff-0239-44cc-af57-aead5947df52"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lineAC", "=", 
  RowBox[{"line", "[", 
   RowBox[{"ptA", ",", "ptC"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.857822741807932*^9, 3.857822769487686*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"dfa843dd-4249-4cb9-be50-67fbe28e24be"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "y"}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{{3.857822770643796*^9, 3.857822790473426*^9}, 
   3.857831817804304*^9, 3.859026149632494*^9, 3.859909382521009*^9, 
   3.8610979334259567`*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"adbedf3a-21d3-4da9-8ef9-80c9854d839c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lineBD", "=", 
  RowBox[{"line", "[", 
   RowBox[{"ptB", ",", "ptD"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.857822801408043*^9, 3.857822808904139*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"5b36009d-8ab9-4e5b-8739-4736dc02c121"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox[
    RowBox[{"r", " ", "x"}], 
    RowBox[{"p", "+", "q", "+", "r"}]], "-", 
   FractionBox[
    RowBox[{"p", " ", "z"}], 
    RowBox[{"p", "+", "q", "+", "r"}]]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{3.8578228104902143`*^9, 3.8578318210093307`*^9, 
  3.857833309241169*^9, 3.8590261496415157`*^9, 3.859909382530648*^9, 
  3.861097933435483*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"a65f9d0f-9424-4c77-b9f4-61449db61722"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ans", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lineAC", ",", "lineBD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "//", 
   "Quiet"}]}]], "Input",
 CellChangeTimes->{{3.857822827680702*^9, 3.85782283623978*^9}, {
  3.857822869744315*^9, 3.857822917588708*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"ddd8c2fa-fbeb-44f1-bee4-33dfccb73d3b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "\[Rule]", "0"}], ",", 
    RowBox[{"z", "\[Rule]", 
     FractionBox[
      RowBox[{"r", " ", "x"}], "p"]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.857822899723321*^9, 3.857822918679459*^9}, 
   3.8578318270976553`*^9, 3.8590261496802893`*^9, 3.859909382629826*^9, 
   3.861097933478096*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"e8668853-214b-4c9e-92d0-22134f0eab8a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["ptD"], "Input",
 CellChangeTimes->{{3.857831803422064*^9, 3.8578318042129593`*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"186439ff-86f1-44a0-a8d9-f3ec25b5e78c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["p", 
    RowBox[{"p", "+", "q", "+", "r"}]], ",", 
   FractionBox["q", 
    RowBox[{"p", "+", "q", "+", "r"}]], ",", 
   FractionBox["r", 
    RowBox[{"p", "+", "q", "+", "r"}]]}], "}"}]], "Output",
 CellChangeTimes->{3.857831805213594*^9, 3.8578326853133802`*^9, 
  3.857899090061749*^9, 3.8590261496890697`*^9, 3.859909382640901*^9, 
  3.861097933487049*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"47b17f17-c67c-46d3-a47e-2da9ab41a3b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptE", "=", 
  RowBox[{"normed", "[", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", "r"}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.857822930600896*^9, 3.857822988728651*^9}, {
  3.857828692748207*^9, 3.8578286968909616`*^9}, {3.857830495697688*^9, 
  3.8578304980483513`*^9}, {3.857830790138736*^9, 3.8578307944256067`*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"9291d8b1-7f95-4e75-ae2a-a4036117b8a1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["p", 
    RowBox[{"p", "+", "r"}]], ",", "0", ",", 
   FractionBox["r", 
    RowBox[{"p", "+", "r"}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8578229901518383`*^9, 3.857828697936102*^9, 3.857830499128005*^9, {
   3.857830795263682*^9, 3.857830813989064*^9}, 3.857832682358939*^9, 
   3.857833314002297*^9, 3.857898578665101*^9, 3.8578990942327433`*^9, 
   3.859026149728395*^9, 3.859909382737132*^9, 3.861097933528062*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"d4dcdb96-fea5-4c2d-a4de-1e9fe89a0612"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"areaABC", "=", 
  RowBox[{"baryArea", "[", 
   RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.857827314751285*^9, 3.857827349150406*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"3208da89-5644-4afa-a68a-1d74528a20f5"],

Cell[BoxData["K"], "Output",
 CellChangeTimes->{{3.8578273261494503`*^9, 3.857827352310793*^9}, 
   3.857828708538477*^9, 3.857830506639841*^9, 3.8578333173660173`*^9, 
   3.8590261497735567`*^9, 3.859909382746719*^9, 3.861097933537244*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"393043e2-3140-4b71-83e1-569c55badfea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"areaCDA", "=", 
  RowBox[{
   RowBox[{"baryArea", "[", 
    RowBox[{"ptC", ",", "ptD", ",", "ptA"}], "]"}], "/.", 
   RowBox[{
    RowBox[{"p", "+", "q", "+", "r"}], "\[Rule]", "1"}]}]}]], "Input",
 CellChangeTimes->{{3.857827354822645*^9, 3.857827384718645*^9}, {
  3.857830214121159*^9, 3.8578302268075533`*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"0f132a9e-c928-42df-88cb-5010ffa52448"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"K", " ", "q"}], 
   RowBox[{"p", "+", "q", "+", "r"}]]}]], "Output",
 CellChangeTimes->{3.8578273863582373`*^9, 3.857828712406196*^9, 
  3.857830229448584*^9, 3.857830509359467*^9, 3.857833320109062*^9, 
  3.85902614978332*^9, 3.859909382842771*^9, 3.8610979335787573`*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"79132867-195e-4c47-a1e5-07f097530548"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"areaABCD", "=", 
  RowBox[{
   RowBox[{"areaABC", "+", "areaCDA"}], "//", "Factor"}]}]], "Input",
 CellChangeTimes->{{3.857830194192675*^9, 3.8578302431515102`*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"b451f244-a13e-4e1f-9218-9b8d9ccba488"],

Cell[BoxData[
 FractionBox[
  RowBox[{"K", " ", 
   RowBox[{"(", 
    RowBox[{"p", "+", "r"}], ")"}]}], 
  RowBox[{"p", "+", "q", "+", "r"}]]], "Output",
 CellChangeTimes->{{3.857830233250979*^9, 3.857830244357922*^9}, 
   3.857830513457922*^9, 3.85902614982122*^9, 3.859909382852379*^9, 
   3.8610979335881453`*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"e8fcc13b-b103-43d3-88b8-4f0434a7a80e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nx20", "=", 
  RowBox[{"normed", "[", "x20", "]"}]}]], "Input",
 CellChangeTimes->{{3.857827691216062*^9, 3.8578277013752813`*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"d3dff3e0-0cfe-44b1-83cf-2a60d61091fe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"3", " ", 
      SuperscriptBox["a", "4"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "-", 
     SuperscriptBox["b", "4"], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     SuperscriptBox["c", "4"]}], 
    RowBox[{
     SuperscriptBox["a", "4"], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "+", 
     SuperscriptBox["b", "4"], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "+", 
     SuperscriptBox["c", "4"]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "4"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["b", "4"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     SuperscriptBox["c", "4"]}], 
    RowBox[{
     SuperscriptBox["a", "4"], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "+", 
     SuperscriptBox["b", "4"], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "+", 
     SuperscriptBox["c", "4"]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "4"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "-", 
     SuperscriptBox["b", "4"], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["c", "4"]}]}], 
    RowBox[{
     SuperscriptBox["a", "4"], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "+", 
     SuperscriptBox["b", "4"], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "+", 
     SuperscriptBox["c", "4"]}]]}], "}"}]], "Output",
 CellChangeTimes->{3.8578277025766153`*^9, 3.8578287304108686`*^9, 
  3.8578326945242157`*^9, 3.857833326172031*^9, 3.857899113785033*^9, 
  3.859026149832725*^9, 3.859909382947319*^9, 3.861097933630587*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"86afd077-7753-4c78-8389-6366d4e3cf89"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"lenAB", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"ptA", ",", "ptB"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenBC", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"ptB", ",", "ptC"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenCD", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"ptC", ",", "ptD"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenAD", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"ptA", ",", "ptD"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenAE", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"ptA", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenBE", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"ptB", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenCE", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"ptC", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenDE", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"ptD", ",", "ptE"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8578295110855827`*^9, 3.85782957461443*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"57e50172-32e8-477f-a5f3-ebf840f66a77"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ptF", "=", 
   RowBox[{"centerABE", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"nx20", ".", 
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "lenBE"}], ",", 
        RowBox[{"b", "\[Rule]", "lenAE"}], ",", 
        RowBox[{"c", "\[Rule]", "lenAB"}]}], "}"}]}], "//", "Simplify"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptG", "=", 
   RowBox[{"centerBCE", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"nx20", ".", 
       RowBox[{"{", 
        RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "lenCE"}], ",", 
        RowBox[{"b", "\[Rule]", "lenBE"}], ",", 
        RowBox[{"c", "\[Rule]", "lenBC"}]}], "}"}]}], "//", "Simplify"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptH", "=", 
   RowBox[{"centerCDE", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"nx20", ".", 
       RowBox[{"{", 
        RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "lenDE"}], ",", 
        RowBox[{"b", "\[Rule]", "lenCE"}], ",", 
        RowBox[{"c", "\[Rule]", "lenCD"}]}], "}"}]}], "//", "Simplify"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptI", "=", 
   RowBox[{"centerDAE", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"nx20", ".", 
       RowBox[{"{", 
        RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "lenAE"}], ",", 
        RowBox[{"b", "\[Rule]", "lenDE"}], ",", 
        RowBox[{"c", "\[Rule]", "lenAD"}]}], "}"}]}], "//", "Simplify"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.857829624470192*^9, 3.85782968199827*^9}, {
  3.8578299812552443`*^9, 3.857830099983593*^9}, {3.857830711955052*^9, 
  3.857830715065485*^9}, {3.857830779658985*^9, 3.8578307828018208`*^9}, {
  3.85783336440307*^9, 3.857833379810071*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"532664f9-0673-4f1c-a9c6-d9bba576ddde"],

Cell[CellGroupData[{

Cell[BoxData["ptF"], "Input",
 CellChangeTimes->{{3.857899128408311*^9, 3.8578991292793617`*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"5524ae46-e8c0-40c7-b089-fa04c6294abe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "p"}], "+", 
        RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["c", "2"], " ", "r"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "-", "r"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}]}], ")"}]}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "4"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "r"}], ")"}]}]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"p", "-", 
         RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "r"}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p"}], "+", "r"}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"p", "+", "r"}], ")"}]}]]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "p"}], "-", "r"}], ")"}]}], "-", 
     RowBox[{
      SuperscriptBox["a", "4"], " ", "r"}], "-", 
     RowBox[{
      SuperscriptBox["b", "4"], " ", "r"}], "+", 
     RowBox[{
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "p"}], "+", 
        RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], " ", "r"}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}]}], ")"}]}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "4"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "r"}], ")"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{3.857899130447198*^9, 3.859026150537359*^9, 
  3.8599093836422*^9, 3.861097934387591*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"cf9e7862-8485-476e-a74d-85e83fc9eab4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"areaFGH", "=", 
  RowBox[{
   RowBox[{"baryArea", "[", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH"}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.8578302610250883`*^9, 3.857830273129084*^9}, {
  3.85783035448252*^9, 3.857830368338265*^9}, {3.857830850498886*^9, 
  3.857830860938717*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"9730d227-81b9-44c9-ac5c-60f628ab0f61"],

Cell[BoxData[
 FractionBox[
  RowBox[{"K", " ", 
   RowBox[{"(", 
    RowBox[{"p", "+", "r"}], ")"}]}], 
  RowBox[{"p", "+", "q", "+", "r"}]]], "Output",
 CellChangeTimes->{
  3.857830133785974*^9, {3.857830265423327*^9, 3.857830275279084*^9}, {
   3.8578303570224257`*^9, 3.857830371272946*^9}, 3.857830534393124*^9, 
   3.857830729286992*^9, {3.857830836784233*^9, 3.857830862025066*^9}, 
   3.857832810214882*^9, 3.85783334037889*^9, 3.8578333930223017`*^9, 
   3.859026150578435*^9, 3.859909383681114*^9, 3.8610979344279633`*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"1556f727-324d-474b-aa85-141c9dde579b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"areaFGH", "/.", 
  RowBox[{"r", "\[Rule]", 
   RowBox[{"1", "-", "p", "-", "q"}]}]}]], "Input",
 CellChangeTimes->{{3.857830283455956*^9, 3.857830288687751*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"8275d24e-0dfa-4bae-a0f3-1fb9f14b2475"],

Cell[BoxData[
 RowBox[{"K", " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", "q"}], ")"}]}]], "Output",
 CellChangeTimes->{3.857830290188567*^9, 3.8578305423124332`*^9, 
  3.857830737877524*^9, 3.8578308697386103`*^9, 3.859026150587051*^9, 
  3.859909383691805*^9, 3.8610979344374313`*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"d23c9a2b-05df-48c2-81ce-03dc61d398d0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"areaABCD", "/", "areaFGH"}], "/.", 
   RowBox[{"r", "\[Rule]", 
    RowBox[{"1", "-", "p", "-", "q"}]}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.857830325088152*^9, 3.85783033373602*^9}, {
  3.85783038233053*^9, 3.857830392791869*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"ae8021bd-6cdf-48db-9b4a-796dfbc8e40a"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.857830336801631*^9, {3.857830383154911*^9, 3.857830394053072*^9}, 
   3.857830873731242*^9, 3.8590261506254272`*^9, 3.859909383787958*^9, 
   3.861097934478499*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"9e7d500e-bccb-4155-ab86-88adbfad0fbe"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Section 7.2 - Orthodiagonal Quadrilaterals", "Subsection",
 CellChangeTimes->{{3.861083672513912*^9, 3.8610837265016613`*^9}, {
  3.861083772333666*^9, 
  3.861083783117765*^9}},ExpressionUUID->"0d17fde0-0d53-4260-88b7-\
c578768f6c33"],

Cell[CellGroupData[{

Cell["Lemma 7.5 for X(402)", "Subsubsection",
 CellChangeTimes->{{3.861083840788579*^9, 3.861083852282742*^9}, {
  3.8610882500044317`*^9, 3.8610882527400427`*^9}, {3.861092164568664*^9, 
  3.861092168016555*^9}},ExpressionUUID->"146aa3cb-e612-4e95-9dfd-\
28e103e8b38d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x5", "=", 
  RowBox[{"ETC1", "[", 
   RowBox[{"[", 
    RowBox[{"5", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8610839403537073`*^9, 3.861083947742229*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"221e464c-a8d6-447e-932e-736ba26b3155"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "2"]}], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    SuperscriptBox["b", "4"], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    SuperscriptBox["c", "4"]}], ",", 
   RowBox[{
    SuperscriptBox["a", "4"], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    SuperscriptBox["c", "4"]}], ",", 
   RowBox[{
    SuperscriptBox["a", "4"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    SuperscriptBox["b", "4"], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.861083949738892*^9, 3.8610979344884777`*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"23634c37-100d-45ea-af9d-30d2133c1bf9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"x5", ",", 
    RowBox[{
     RowBox[{"a", "^", "2"}], "==", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}]}]}], "]"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], 
    RowBox[{"b", "^", "2"}], 
    RowBox[{"c", "^", "2"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.861083981625944*^9, 3.8610840047445383`*^9}, {
  3.8610840382697973`*^9, 3.861084053070752*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"bdfe97ac-0647-471a-bf2f-551298bda867"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.861084000059473*^9, 3.861084005739766*^9}, 
   3.8610840545692787`*^9, 3.8610979345323353`*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"7b9d42fd-523f-4917-9502-b394f4f28689"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x402", "=", 
  RowBox[{"ETC1", "[", 
   RowBox[{"[", 
    RowBox[{"402", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.861083918400093*^9, 3.861083934735454*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"c7923504-0ddd-42b1-b9c1-9db7cafa8d78"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "8"], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "6"]}], "-", 
      SuperscriptBox["b", "8"], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      SuperscriptBox["c", "8"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "6"]}], "+", 
      SuperscriptBox["b", "8"], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      SuperscriptBox["c", "8"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "6"]}], "-", 
      SuperscriptBox["b", "8"], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      SuperscriptBox["c", "8"]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.861083935751359*^9, 3.861097934545478*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"640be061-c8a3-45ec-82f8-54fc6b04615f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"x402", ",", 
    RowBox[{
     RowBox[{"a", "^", "2"}], "==", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}]}]}], "]"}], "/", 
  RowBox[{"(", 
   RowBox[{"8", 
    RowBox[{"b", "^", "6"}], 
    RowBox[{"c", "^", "6"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.8610840689750957`*^9, 3.8610840884045773`*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"a04c9867-66ef-4ac5-8d99-9ce89c7d3075"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.861084070702342*^9, 3.8610840896611147`*^9}, 
   3.861097934599875*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"67c44df8-fedd-403f-8297-17a98c194fc2"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Lemma 7.13 for X(102)", "Subsubsection",
 CellChangeTimes->{{3.861084262893421*^9, 3.8610842795473967`*^9}, {
  3.8610882340604467`*^9, 3.861088236723963*^9}, {3.861092171008654*^9, 
  3.8610921738086567`*^9}},ExpressionUUID->"aaf6148f-d5fe-4ba1-88e3-\
8a9e590b3d46"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x102", "=", 
  RowBox[{"ETC1", "[", 
   RowBox[{"[", 
    RowBox[{"102", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.861084291558082*^9, 3.861084306872923*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"3543d712-1fe4-4727-a85b-dd8b31d1d764"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["b", "3"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", "a", " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "b"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
      RowBox[{"2", " ", "a", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "3"], " ", "c"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"a", " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      SuperscriptBox["c", "4"]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["b", "3"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", "a", " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "b"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}], "+", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "c"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"a", " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      SuperscriptBox["c", "4"]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "b"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}], "+", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "c"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"a", " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      SuperscriptBox["c", "4"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "b"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
      RowBox[{"2", " ", "a", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "3"], " ", "c"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"a", " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.861084307802376*^9, 3.861097934620344*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"90cdad47-7011-4b85-a1e2-f100664f48e4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
   "center", " ", "functions", " ", "use", " ", "trilinear", " ", 
    "coordinates"}], ",", " ", 
   RowBox[{"ETC1", " ", "gives", " ", "barycentric", " ", "coordinates"}]}], 
  " ", "*)"}]], "Input",
 CellChangeTimes->{{3.861085857264145*^9, 3.861085888836368*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"3bacc282-27a9-4321-9459-1cabc57e00b3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"centerFunction102", "=", 
  RowBox[{
   RowBox[{"x102", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "/", "a"}]}]], "Input",
 CellChangeTimes->{{3.861084326230919*^9, 3.861084340871442*^9}, {
  3.861084377513638*^9, 3.8610843825518093`*^9}, {3.861085740868072*^9, 
  3.86108574121194*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"aecccb34-fabd-42e4-8765-b67e6b4dc5ee"],

Cell[BoxData[
 RowBox[{"a", " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "4"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    SuperscriptBox["b", "4"], "-", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["b", "3"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["c", "4"]}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "4"], "-", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "b"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "3"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["b", "3"], " ", "c"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"a", " ", "b", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "3"]}], "+", 
    SuperscriptBox["c", "4"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.861084341786139*^9, 3.8610857445736513`*^9, 
  3.861085828962948*^9, 3.861085894414536*^9, 3.861097934675214*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"e8a7a926-4c90-404d-aaea-ae70d8c150e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"fabc", "=", "centerFunction102"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fbac", "=", 
   RowBox[{"fabc", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "b"}], ",", 
      RowBox[{"b", "\[Rule]", "a"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Factor", "[", 
  RowBox[{"fabc", "-", "fbac"}], "]"}]}], "Input",
 CellChangeTimes->{{3.861084385175583*^9, 3.861084461415924*^9}, {
  3.861084506025692*^9, 3.8610845094164762`*^9}, {3.8610845596978703`*^9, 
  3.8610845729843197`*^9}, {3.861084665970015*^9, 3.861084672505911*^9}, {
  3.8610847516591873`*^9, 3.86108477521703*^9}, {3.861084904739153*^9, 
  3.8610849084735622`*^9}, {3.861085733598029*^9, 3.8610857381645527`*^9}, {
  3.861085846172873*^9, 3.861085852268873*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"7e858350-d466-41f7-b7f7-2626e7c8ceba"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "a"}], "+", "b"}], ")"}]}], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "4"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    SuperscriptBox["b", "4"], "-", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["b", "3"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["c", "4"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.861084424344079*^9, 3.861084463084681*^9, {3.861084514167388*^9, 
   3.861084574471871*^9}, {3.861084667191182*^9, 3.86108467405328*^9}, 
   3.861084776275116*^9, 3.861084909682946*^9, 3.861085853543077*^9, 
   3.861085897917819*^9, 3.861097934720786*^9},
 CellLabel->"Out[77]=",ExpressionUUID->"5d5455d2-dd01-4bcc-bcbc-f2c749fd5546"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fabc", "-", "fbac"}], "/.", 
   RowBox[{"c", "\[Rule]", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.8610848570414457`*^9, 3.861084876001211*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"fba84d91-bbdd-4fd6-af56-00d518d05eee"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.8610848705144672`*^9, 3.861084877219542*^9}, 
   3.861085948841217*^9, 3.861097934731729*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"c9950c45-b737-490c-9160-9badb73fa273"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Section 7.4 - Rhombi", "Subsection",
 CellChangeTimes->{{3.861089245893405*^9, 
  3.861089262711451*^9}},ExpressionUUID->"33efc3b8-cc24-4b49-bdd3-\
11597d0f8696"],

Cell[CellGroupData[{

Cell["Proposition 7.19 for X(40)", "Subsubsection",
 CellChangeTimes->{{3.860669617752452*^9, 3.8606696379733267`*^9}, {
  3.8606712433112993`*^9, 3.8606712500231113`*^9}, {3.861097461139688*^9, 
  3.861097474737636*^9}},ExpressionUUID->"85dbcfac-3ed2-44b0-890d-\
8efa96290fc7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ptA", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptB", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptC", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ptF", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ETC1", "[", 
     RowBox[{"[", 
      RowBox[{"40", ",", "2"}], "]"}], "]"}], "/.", 
    RowBox[{"c", "\[Rule]", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "+", 
       RowBox[{"b", "^", "2"}]}], "]"}]}]}], "//", "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.860669669250484*^9, 3.8606697322743692`*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"b30efd96-3fde-4377-93d9-4ec246afc3df"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", 
    SuperscriptBox["a", "2"], " ", "b", " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", "b", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}]]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "a", " ", 
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", "b", "+", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}]]}], ")"}]}], ",", 
   RowBox[{"2", " ", "a", " ", "b", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}]]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8606696959950237`*^9, 3.8606697332694902`*^9}, 
   3.8610975086444387`*^9, 3.861097934779408*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"c4644419-a184-4e70-9d5a-d655c6c71725"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"F", "=", 
  RowBox[{
   RowBox[{"ptF", "/.", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "\[Rule]", 
     RowBox[{"c", "^", "2"}]}]}], "//", "PowerExpand"}]}]], "Input",
 CellChangeTimes->{{3.86066974684604*^9, 3.860669810524342*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"354c36f1-bcba-4151-8118-4f68b53cf150"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", 
    SuperscriptBox["a", "2"], " ", "b", " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", "b", "-", "c"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "a", " ", 
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", "b", "+", "c"}], ")"}]}], ",", 
   RowBox[{"2", " ", "a", " ", "b", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", "c"}]}], "}"}]], "Output",\

 CellChangeTimes->{{3.860669758847571*^9, 3.8606698113731327`*^9}, 
   3.861097512400812*^9, 3.861097934789382*^9},
 CellLabel->"Out[83]=",ExpressionUUID->"6d9a8438-79e9-4582-81da-7b7e51667be0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"F2", "=", 
  RowBox[{"F", "/", 
   RowBox[{"(", 
    RowBox[{"2", "a", " ", "b"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.860669815966339*^9, 3.860669836276082*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"bb371ab0-27e2-4e0e-9887-9d8236ea9a71"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", "b", "-", "c"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", "b"}], " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", "b", "+", "c"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", "c"}]}], "}"}]], "Output",\

 CellChangeTimes->{{3.86066982948701*^9, 3.860669837239705*^9}, 
   3.861097515589467*^9, 3.861097934829605*^9},
 CellLabel->"Out[84]=",ExpressionUUID->"d5932f19-d3b0-402c-8964-b79363e3d01d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"area", " ", "BCF"}], " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], "BC", "*", "FQ"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "/", "2"}], ")"}], "FQ"}]}]}], ",", " ", 
   RowBox[{
    RowBox[{"so", " ", "FQ"}], " ", "=", " ", 
    RowBox[{
     RowBox[{"[", "BCF", "]"}], "*", 
     RowBox[{"(", 
      RowBox[{"2", "/", "a"}], ")"}]}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.860670131534824*^9, 3.860670224123826*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"92697046-2522-46ef-96a5-00ef56a74801"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FQ", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"baryArea", "[", 
      RowBox[{"ptB", ",", "ptC", ",", "F2"}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{"2", "/", "a"}], ")"}]}], "/.", 
    RowBox[{"K", "->", 
     RowBox[{"a", " ", 
      RowBox[{"b", "/", "2"}]}]}]}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.8606698798472853`*^9, 3.860670000643343*^9}, {
   3.86067026765411*^9, 3.860670276788249*^9}, 3.8606706806145372`*^9},
 CellLabel->"In[86]:=",ExpressionUUID->"b5c592c6-75b7-4f62-aa52-bc28789c5ff5"],

Cell[BoxData[
 FractionBox[
  RowBox[{"a", " ", "b"}], 
  RowBox[{"a", "-", "b", "+", "c"}]]], "Output",
 CellChangeTimes->{{3.860669948942638*^9, 3.8606700017907753`*^9}, 
   3.860670278384112*^9, 3.8606706817436028`*^9, 3.861097524283489*^9, 
   3.861097934883915*^9},
 CellLabel->"Out[86]=",ExpressionUUID->"705fa393-aa52-4d95-a60a-6063647cb1fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FP", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"baryArea", "[", 
      RowBox[{"ptA", ",", "F2", ",", "ptC"}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{"2", "/", "b"}], ")"}]}], "/.", 
    RowBox[{"K", "->", 
     RowBox[{"a", " ", 
      RowBox[{"b", "/", "2"}]}]}]}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.860670021515637*^9, 3.860670044555706*^9}, {
   3.86067028454974*^9, 3.8606702954844017`*^9}, 3.860670686662631*^9, {
   3.860671013376193*^9, 3.8606710229588327`*^9}, {3.860671061544276*^9, 
   3.86067108246309*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"1c3a58d7-5635-4843-a904-c3e212ec6b20"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"a", " ", "b"}], 
   RowBox[{"a", "-", "b", "-", "c"}]]}]], "Output",
 CellChangeTimes->{
  3.860670045975214*^9, 3.8606702993152637`*^9, 3.860670687932988*^9, 
   3.860671025249881*^9, {3.860671069418133*^9, 3.860671083657564*^9}, 
   3.86109752934112*^9, 3.861097934895254*^9},
 CellLabel->"Out[87]=",ExpressionUUID->"f47b30a4-9853-4a7f-8ec1-ccdbb1dfcfcb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sum", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"FP", "+", "FQ"}], "//", "Together"}], "//", 
   "ExpandAll"}]}]], "Input",
 CellChangeTimes->{{3.860670053706151*^9, 3.860670061787334*^9}, {
  3.860670337525744*^9, 3.8606704045084887`*^9}, {3.860670482406147*^9, 
  3.860670568477214*^9}, {3.860671142864359*^9, 3.860671194128881*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"f99fb1c2-bb6f-411e-bda4-9abc44436c23"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", "a", " ", "b", " ", "c"}], 
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    RowBox[{"2", " ", "a", " ", "b"}], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}]]}]], "Output",
 CellChangeTimes->{
  3.860670062846181*^9, 3.860670304918202*^9, {3.860670340527206*^9, 
   3.8606704055412827`*^9}, 3.8606704853195333`*^9, {3.860670538319693*^9, 
   3.860670569393882*^9}, 3.860670693592229*^9, 3.860671090066671*^9, {
   3.860671145882092*^9, 3.860671195254889*^9}, 3.8610975378565683`*^9, 
   3.861097934939093*^9},
 CellLabel->"Out[88]=",ExpressionUUID->"744d0b97-5b3a-4dff-a3e1-3963fd39aaf3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sum", "/.", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "2"}], "+", 
    RowBox[{"b", "^", "2"}]}], "\[Rule]", 
   RowBox[{"c", "^", "2"}]}]}]], "Input",
 CellChangeTimes->{{3.860671203041733*^9, 3.860671212815119*^9}},
 CellLabel->"In[89]:=",ExpressionUUID->"cd9660b8-9f44-46cd-8519-094a61bc2258"],

Cell[BoxData["c"], "Output",
 CellChangeTimes->{3.8606712135579767`*^9, 3.861097541447608*^9, 
  3.861097934951078*^9},
 CellLabel->"Out[89]=",ExpressionUUID->"9325f60f-8c24-47cb-a0d1-dff5834aacf0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"product", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"FP", "*", "FQ"}], "/.", 
    RowBox[{"c", "\[Rule]", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "+", 
       RowBox[{"b", "^", "2"}]}], "]"}]}]}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.8610975490725183`*^9, 3.861097562289871*^9}, {
  3.861097635060514*^9, 3.861097642850163*^9}},
 CellLabel->"In[90]:=",ExpressionUUID->"c85ebb44-c58b-4fa8-8a8b-197d53fc310a"],

Cell[BoxData[
 FractionBox[
  RowBox[{"a", " ", "b"}], "2"]], "Output",
 CellChangeTimes->{
  3.861097563707013*^9, {3.861097636984456*^9, 3.861097643949806*^9}, 
   3.861097934996037*^9},
 CellLabel->"Out[90]=",ExpressionUUID->"4b8f73af-76ea-49fe-b90a-98260853f5e0"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Proposition 7.20 for X(84)", "Subsubsection",
 CellChangeTimes->{{3.860669617752452*^9, 3.8606696379733267`*^9}, {
  3.8606712433112993`*^9, 3.8606712500231113`*^9}, {3.860678559174946*^9, 
  3.860678559518382*^9}, {3.861088034971642*^9, 3.861088040715427*^9}, {
  3.861092184616624*^9, 
  3.861092187576666*^9}},ExpressionUUID->"31a20017-3f76-4a14-aa99-\
a70617396042"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x84", "=", 
  RowBox[{"ETC1", "[", 
   RowBox[{"[", 
    RowBox[{"84", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.861086497181162*^9, 3.861086514792322*^9}},
 CellLabel->"In[91]:=",ExpressionUUID->"8172549d-b095-4b20-ab50-b3aa6e290547"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "3"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "3"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "c"}], "+", 
      RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "3"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "3"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "3"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "c"}], "+", 
      RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "3"]}], ")"}]}], ",", 
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "3"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "3"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "c"}], "+", 
      RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "3"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "3"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "c"}], "+", 
      RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "3"]}], ")"}]}], ",", 
   RowBox[{"c", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "3"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "c"}], "+", 
      RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "3"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "3"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "3"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "c"}], "+", 
      RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "3"]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.861086509389062*^9, 3.861086515794133*^9}, 
   3.861097935008902*^9},
 CellLabel->"Out[91]=",ExpressionUUID->"b28db607-5ee2-48ec-9324-a11db31559a7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"etc84", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "3"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "-", "c"}], ")"}], "^", "2"}]}], ")"}], "^", "2"}]}], 
   "-", 
   RowBox[{"a", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "-", "c"}], ")"}], "^", "2"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "+", "c"}], ")"}], "^", "2"}]}], ")"}], "^", 
     "2"}]}]}]}]], "Input",
 CellChangeTimes->{{3.8610865842257433`*^9, 3.861086624135104*^9}, 
   3.861086686104641*^9, 3.861086757840691*^9},
 CellLabel->"In[92]:=",ExpressionUUID->"062be80f-d86d-41d9-a0c7-c2f18a396796"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"]}], ")"}], "2"]}], "-", 
  RowBox[{"a", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"]}], ")"}], "2"]}]}]], "Output",
 CellChangeTimes->{{3.861086604957635*^9, 3.861086625077635*^9}, 
   3.861086686691229*^9, 3.861086759346591*^9, 3.8610979350512657`*^9},
 CellLabel->"Out[92]=",ExpressionUUID->"a75bf9f0-6746-4b19-b3b2-4657d7ffc92c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "confirm", " ", "that", " ", "our", " ", "value", " ", "for", " ", "X84", 
   " ", "agrees", " ", "with", " ", "the", " ", "one", " ", "in", " ", 
   "ETC"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.861086769083762*^9, 3.861086785271595*^9}},
 CellLabel->"In[93]:=",ExpressionUUID->"2d8f19a8-ca7b-4679-a807-f146a5971917"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"etc84", "-", 
   RowBox[{"x84", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.861086634446786*^9, 3.861086643502926*^9}},
 CellLabel->"In[94]:=",ExpressionUUID->"857183d2-455b-494f-ae05-8aa0a9d9b750"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.861086638123076*^9, 3.8610866445302067`*^9}, 
   3.861086689178617*^9, 3.861086762564528*^9, 3.861097935101829*^9},
 CellLabel->"Out[94]=",ExpressionUUID->"821e70e4-4acc-4336-b2fc-d32ea64d021a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ptA", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptB", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptC", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ptF", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ETC1", "[", 
     RowBox[{"[", 
      RowBox[{"84", ",", "2"}], "]"}], "]"}], "/.", 
    RowBox[{"c", "\[Rule]", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "+", 
       RowBox[{"b", "^", "2"}]}], "]"}]}]}], "//", "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.860669669250484*^9, 3.8606697322743692`*^9}, {
   3.860678564239655*^9, 3.860678573512237*^9}, 3.8606891016822577`*^9},
 CellLabel->"In[95]:=",ExpressionUUID->"2453005f-0845-4ad2-81ee-83b09ba9caa3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"8", " ", 
    SuperscriptBox["a", "3"], " ", 
    SuperscriptBox["b", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"b", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}]]}], ")"}]}], ",", 
   RowBox[{"8", " ", 
    SuperscriptBox["a", "3"], " ", 
    SuperscriptBox["b", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}]]}], ")"}]}], ",", 
   RowBox[{"8", " ", 
    SuperscriptBox["a", "3"], " ", 
    SuperscriptBox["b", "3"], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8606696959950237`*^9, 3.8606697332694902`*^9}, {
   3.860678568455172*^9, 3.860678575002658*^9}, 3.860689104870472*^9, 
   3.860690464542612*^9, 3.861097935147456*^9},
 CellLabel->"Out[98]=",ExpressionUUID->"b687ee77-6157-44b6-ad79-93ae6d75a7a0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"F", "=", 
  RowBox[{
   RowBox[{"ptF", "/.", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "\[Rule]", 
     RowBox[{"c", "^", "2"}]}]}], "//", "PowerExpand"}]}]], "Input",
 CellChangeTimes->{{3.86066974684604*^9, 3.860669810524342*^9}, {
  3.860678578671349*^9, 3.860678582151061*^9}, {3.860689108849821*^9, 
  3.860689112784618*^9}},
 CellLabel->"In[99]:=",ExpressionUUID->"ba7da1a1-b591-441b-b943-c676b04da678"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"8", " ", 
    SuperscriptBox["a", "3"], " ", 
    SuperscriptBox["b", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"b", "-", "c"}], ")"}]}], ",", 
   RowBox[{"8", " ", 
    SuperscriptBox["a", "3"], " ", 
    SuperscriptBox["b", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", "c"}], ")"}]}], ",", 
   RowBox[{"8", " ", 
    SuperscriptBox["a", "3"], " ", 
    SuperscriptBox["b", "3"], " ", "c"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.860669758847571*^9, 3.8606698113731327`*^9}, 
   3.8606785833399153`*^9, 3.860689113763138*^9, 3.8606904728634663`*^9, 
   3.861097935158505*^9},
 CellLabel->"Out[99]=",ExpressionUUID->"45b86ac2-cfe1-4cc5-b0dc-4f35a82e151f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"F2", "=", 
  RowBox[{"F", "/", 
   RowBox[{"(", 
    RowBox[{"8", 
     RowBox[{"a", "^", "3"}], 
     RowBox[{"b", "^", "3"}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.860669815966339*^9, 3.860669836276082*^9}, {
  3.860678588247737*^9, 3.860678604334737*^9}, {3.8606891172817097`*^9, 
  3.860689120536672*^9}},
 CellLabel->
  "In[100]:=",ExpressionUUID->"3eade57d-8abc-4901-83cb-42a57757edfd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"b", "-", "c"}], ",", 
   RowBox[{"a", "-", "c"}], ",", "c"}], "}"}]], "Output",
 CellChangeTimes->{{3.86066982948701*^9, 3.860669837239705*^9}, 
   3.860678605178685*^9, 3.8606891215583067`*^9, 3.860690476000852*^9, 
   3.8610979351998987`*^9},
 CellLabel->
  "Out[100]=",ExpressionUUID->"1fbae315-fc3a-4e4f-b4c8-13bd5cfaf5de"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"area", " ", "BFC"}], " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], "BC", "*", "PF"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "/", "2"}], ")"}], "PF"}]}]}], ",", " ", 
   RowBox[{
    RowBox[{"so", " ", "PF"}], " ", "=", " ", 
    RowBox[{
     RowBox[{"[", "BFC", "]"}], "*", 
     RowBox[{"(", 
      RowBox[{"2", "/", "a"}], ")"}]}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.860670131534824*^9, 3.860670224123826*^9}, {
  3.860678627959282*^9, 3.860678643350933*^9}, {3.860689050880579*^9, 
  3.8606890820004*^9}, {3.860689128304358*^9, 3.8606891308084087`*^9}, {
  3.860690486180751*^9, 3.860690486524665*^9}, {3.860690516725286*^9, 
  3.8606905170288763`*^9}},
 CellLabel->
  "In[101]:=",ExpressionUUID->"9489e855-7eb6-4a92-a3af-df91a51c4f30"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"baryArea", "[", 
   RowBox[{"ptB", ",", "F2", ",", "ptC"}], "]"}], "//", "Simplify"}]], "Input",\

 CellChangeTimes->{{3.860688279926961*^9, 3.860688282485606*^9}, 
   3.860689139241893*^9, 3.860689857315991*^9, {3.860690258205627*^9, 
   3.860690261915888*^9}},
 CellLabel->
  "In[102]:=",ExpressionUUID->"069be70a-7e12-4f6b-9993-0ffb9e8f5a09"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "b"}], "+", "c"}], ")"}], " ", "K"}], 
  RowBox[{"a", "+", "b", "-", "c"}]]], "Output",
 CellChangeTimes->{{3.8606882766529922`*^9, 3.860688283497793*^9}, 
   3.860689141283903*^9, 3.860689731877746*^9, 3.8606898584198027`*^9, 
   3.860690263043944*^9, 3.860690524984774*^9, 3.861097935250382*^9},
 CellLabel->
  "Out[102]=",ExpressionUUID->"2e4fcce1-574b-4956-8695-ab2c8b9a24d5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PF", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"baryArea", "[", 
      RowBox[{"ptB", ",", "F2", ",", "ptC"}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{"2", "/", "a"}], ")"}]}], "/.", 
    RowBox[{"K", "->", 
     RowBox[{"a", " ", 
      RowBox[{"b", "/", "2"}]}]}]}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.8606698798472853`*^9, 3.860670000643343*^9}, {
   3.86067026765411*^9, 3.860670276788249*^9}, 3.8606706806145372`*^9, {
   3.86067865074398*^9, 3.860678655662888*^9}, {3.860689211970191*^9, 
   3.8606892303046923`*^9}, {3.8606906496148043`*^9, 3.8606906538613234`*^9}},
 
 CellLabel->
  "In[103]:=",ExpressionUUID->"50efbea1-80d0-4528-b5b9-8fc9ac6ca7d3"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{"b", "-", "c"}], ")"}]}], 
   RowBox[{"a", "+", "b", "-", "c"}]]}]], "Output",
 CellChangeTimes->{{3.860669948942638*^9, 3.8606700017907753`*^9}, 
   3.860670278384112*^9, 3.8606706817436028`*^9, 3.8606786572808447`*^9, {
   3.860689213189721*^9, 3.860689231693152*^9}, 3.860689434939762*^9, 
   3.860689743971229*^9, {3.86069063409582*^9, 3.86069065491575*^9}, 
   3.861097935262516*^9},
 CellLabel->
  "Out[103]=",ExpressionUUID->"65e30e63-cdf1-49ae-b353-4d2bdc84374d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QF", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"baryArea", "[", 
      RowBox[{"ptA", ",", "ptC", ",", "F2"}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{"2", "/", "b"}], ")"}]}], "/.", 
    RowBox[{"K", "->", 
     RowBox[{"a", " ", 
      RowBox[{"b", "/", "2"}]}]}]}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.860670021515637*^9, 3.860670044555706*^9}, {
   3.86067028454974*^9, 3.8606702954844017`*^9}, 3.860670686662631*^9, {
   3.860671013376193*^9, 3.8606710229588327`*^9}, {3.860671061544276*^9, 
   3.86067108246309*^9}, {3.860678663191951*^9, 3.860678668223394*^9}, {
   3.860690010220743*^9, 3.8606900331234426`*^9}, {3.8606903672633047`*^9, 
   3.860690371596715*^9}},
 CellLabel->
  "In[104]:=",ExpressionUUID->"c5cdd15c-2940-4a2d-bcfe-7a0b71eaafe8"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", "c"}], ")"}]}], 
   RowBox[{"a", "+", "b", "-", "c"}]]}]], "Output",
 CellChangeTimes->{
  3.860670045975214*^9, 3.8606702993152637`*^9, 3.860670687932988*^9, 
   3.860671025249881*^9, {3.860671069418133*^9, 3.860671083657564*^9}, 
   3.860678669990464*^9, 3.860690036640683*^9, 3.8606901350960503`*^9, 
   3.860690372849709*^9, 3.860690403549327*^9, 3.8606906686798973`*^9, 
   3.861097935310245*^9},
 CellLabel->
  "Out[104]=",ExpressionUUID->"06fbb8c8-6432-4126-85a2-ef757080b41a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sum", "=", 
  RowBox[{
   RowBox[{"PF", "+", "QF"}], "//", "Together"}]}]], "Input",
 CellChangeTimes->{{3.860670053706151*^9, 3.860670061787334*^9}, {
  3.860670337525744*^9, 3.8606704045084887`*^9}, {3.860670482406147*^9, 
  3.860670568477214*^9}, {3.860671142864359*^9, 3.860671194128881*^9}, {
  3.8606786750082893`*^9, 3.860678688405656*^9}, {3.860690043524781*^9, 
  3.8606900569729147`*^9}},
 CellLabel->
  "In[105]:=",ExpressionUUID->"b6f73bb7-8227-4899-8c70-f19dfc9d3c69"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["a", "2"]}], "-", 
   SuperscriptBox["b", "2"], "+", 
   RowBox[{"a", " ", "c"}], "+", 
   RowBox[{"b", " ", "c"}]}], 
  RowBox[{"a", "+", "b", "-", "c"}]]], "Output",
 CellChangeTimes->{
  3.860670062846181*^9, 3.860670304918202*^9, {3.860670340527206*^9, 
   3.8606704055412827`*^9}, 3.8606704853195333`*^9, {3.860670538319693*^9, 
   3.860670569393882*^9}, 3.860670693592229*^9, 3.860671090066671*^9, {
   3.860671145882092*^9, 3.860671195254889*^9}, 3.860678689470821*^9, {
   3.8606900472412167`*^9, 3.860690058049921*^9}, 3.8606903783126087`*^9, 
   3.8606906722932367`*^9, 3.861097935321446*^9},
 CellLabel->
  "Out[105]=",ExpressionUUID->"d3b8c2d7-03a7-44b0-bcc1-5acd91517e0d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sum", "/.", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"a", "^", "2"}]}], "-", 
     RowBox[{"b", "^", "2"}]}], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{"c", "^", "2"}]}]}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.860671203041733*^9, 3.860671212815119*^9}, {
   3.860678709936322*^9, 3.860678719151038*^9}, 3.8606900609007673`*^9, {
   3.860690691982622*^9, 3.86069069837346*^9}},
 CellLabel->
  "In[106]:=",ExpressionUUID->"6a1ac0ef-f7ba-4d5b-824f-8b2d0b167604"],

Cell[BoxData["c"], "Output",
 CellChangeTimes->{
  3.8606712135579767`*^9, {3.860678713573374*^9, 3.86067872014662*^9}, 
   3.860690061917345*^9, {3.860690680410763*^9, 3.8606906993789997`*^9}, 
   3.861097935364987*^9},
 CellLabel->
  "Out[106]=",ExpressionUUID->"d3252340-39be-4cb4-96d8-9d38aac232cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PF", "*", "QF"}]], "Input",
 CellChangeTimes->{{3.86069084869718*^9, 3.860690850629814*^9}},
 CellLabel->
  "In[107]:=",ExpressionUUID->"75a2d2b9-c460-484d-9e12-4f580c19edf1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"a", " ", "b", " ", 
   RowBox[{"(", 
    RowBox[{"a", "-", "c"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"b", "-", "c"}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", "b", "-", "c"}], ")"}], "2"]]], "Output",
 CellChangeTimes->{3.8606908534773693`*^9, 3.861097935423522*^9},
 CellLabel->
  "Out[107]=",ExpressionUUID->"9f6347ec-be83-4483-ae76-c631a9726f66"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"prod", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"PF", "*", "QF"}], "//", "ExpandDenominator"}], "//", 
   "ExpandNumerator"}]}]], "Input",
 CellChangeTimes->{{3.860690875574205*^9, 3.8606909475021257`*^9}},
 CellLabel->
  "In[108]:=",ExpressionUUID->"361b179a-0031-4d74-962c-3b7486f04b16"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["b", "2"]}], "-", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
   RowBox[{"a", " ", 
    SuperscriptBox["b", "2"], " ", "c"}], "+", 
   RowBox[{"a", " ", "b", " ", 
    SuperscriptBox["c", "2"]}]}], 
  RowBox[{
   SuperscriptBox["a", "2"], "+", 
   RowBox[{"2", " ", "a", " ", "b"}], "+", 
   SuperscriptBox["b", "2"], "-", 
   RowBox[{"2", " ", "a", " ", "c"}], "-", 
   RowBox[{"2", " ", "b", " ", "c"}], "+", 
   SuperscriptBox["c", "2"]}]]], "Output",
 CellChangeTimes->{{3.860690880030531*^9, 3.860690910083622*^9}, 
   3.860690948645529*^9, 3.861097935433869*^9},
 CellLabel->
  "Out[108]=",ExpressionUUID->"e54e17bb-7022-47ec-b638-8093e74816e3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"prod", "/.", 
   RowBox[{
    RowBox[{"c", "^", "2"}], "\[Rule]", 
    RowBox[{
     RowBox[{"a", "^", "2"}], "+", 
     RowBox[{"b", "^", "2"}]}]}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.860690913968625*^9, 3.8606909163983583`*^9}, {
  3.860690994702578*^9, 3.8606910098541727`*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"5d99dedb-4c1d-4c73-bfdc-9b7d11cc4141"],

Cell[BoxData[
 FractionBox[
  RowBox[{"a", " ", "b"}], "2"]], "Output",
 CellChangeTimes->{{3.8606910035208883`*^9, 3.86069101093148*^9}, 
   3.861097935478361*^9},
 CellLabel->
  "Out[109]=",ExpressionUUID->"fcd8aa29-aeda-4469-bdfe-fde43c0f9481"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Section 7.5 - Rectangles", "Subsection",
 CellChangeTimes->{{3.859405671041423*^9, 3.859405678673934*^9}, {
  3.859405773238845*^9, 3.85940578635047*^9}, {3.8610899219217167`*^9, 
  3.8610899258736897`*^9}},ExpressionUUID->"f50f109f-1fc4-4f2a-a4ab-\
b48d2a93f3f4"],

Cell[CellGroupData[{

Cell["Theorem 7.26 for X(395)", "Subsubsection",
 CellChangeTimes->{{3.8590267048883963`*^9, 3.859026727459972*^9}, {
   3.861089969818034*^9, 3.861089975745613*^9}, 
   3.861092196760558*^9},ExpressionUUID->"ccc9f8cb-a605-4c03-99cf-\
a3ba19de81f4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"p", ",", "q", ",", "r"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptA", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptB", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptC", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptD", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptE", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", "0", ",", 
     RowBox[{"1", "/", "2"}]}], "}"}]}], ";"}]}], "Input",
 CellLabel->
  "In[110]:=",ExpressionUUID->"e4b465cb-fa21-401a-a4d4-bb595b3b33e9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"lenAB", "=", "c"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenBC", "=", "a"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenAE", "=", 
   RowBox[{"b", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenBE", "=", 
   RowBox[{"b", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenCE", "=", 
   RowBox[{"b", "/", "2"}]}], ";"}]}], "Input",
 CellLabel->
  "In[116]:=",ExpressionUUID->"841719af-6a8c-43ff-8499-751ded3c9f7f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x395", "=", 
  RowBox[{"ETC1", "[", 
   RowBox[{"[", 
    RowBox[{"395", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.858786060921858*^9, 3.858786181361096*^9}, {
  3.8587863905711937`*^9, 3.858786410594088*^9}, {3.8587881675849857`*^9, 
  3.8587881747443943`*^9}},
 CellLabel->
  "In[121]:=",ExpressionUUID->"ebe56187-cfa4-41de-8d6a-34d826178c23"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SqrtBox["3"], " ", 
     SuperscriptBox["a", "2"]}], "-", 
    RowBox[{"2", " ", "S"}]}], ",", 
   RowBox[{
    RowBox[{
     SqrtBox["3"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    RowBox[{"2", " ", "S"}]}], ",", 
   RowBox[{
    RowBox[{
     SqrtBox["3"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", "S"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8587881756168213`*^9, 3.85902618993408*^9, 
  3.859909415380006*^9, 3.860832646383442*^9, 3.861097935535557*^9},
 CellLabel->
  "Out[121]=",ExpressionUUID->"3e46321d-ab05-4dfa-89b5-3756c8d0475d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptF", "=", 
  RowBox[{"centerABE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x395", ".", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenAE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenAB"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.858785708664339*^9, 3.858785752208427*^9}, {
   3.858785901049223*^9, 3.8587859885123568`*^9}, {3.85878628204163*^9, 
   3.858786292089315*^9}, {3.858786357153858*^9, 3.858786360769568*^9}, {
   3.858786421793996*^9, 3.858786495154055*^9}, {3.8587867030365143`*^9, 
   3.858786704658731*^9}, {3.858788182793332*^9, 3.858788194031535*^9}, 
   3.858788246343902*^9},
 CellLabel->
  "In[122]:=",ExpressionUUID->"7b3f8b05-7bd1-4336-8661-03372c17d72a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SqrtBox["3"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", "a"}], "+", 
         RowBox[{
          SqrtBox["3"], " ", "c"}]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{
      SqrtBox["3"], " ", 
      SuperscriptBox["b", "2"]}], "4"], "-", 
    RowBox[{"a", " ", "c"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", "c", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "+", 
      RowBox[{
       SqrtBox["3"], " ", "c"}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8587864233685513`*^9, {3.8587864696808767`*^9, 3.858786496037889*^9}, 
   3.8587867069184437`*^9, 3.858786755813157*^9, 3.8587870936108103`*^9, 
   3.8587882474445353`*^9, 3.859026189973741*^9, 3.85990941542138*^9, 
   3.860832676299837*^9, 3.860832880239646*^9, 3.861097935580223*^9},
 CellLabel->
  "Out[122]=",ExpressionUUID->"9fec80a6-8107-4a35-800d-be49e2af00c1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptG", "=", 
  RowBox[{"centerBCE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x395", ".", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenCE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenBC"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8587865148663816`*^9, 3.858786564610229*^9}, {
  3.8587866148666897`*^9, 3.858786628154747*^9}, {3.858788263305393*^9, 
  3.858788287137041*^9}},
 CellLabel->
  "In[123]:=",ExpressionUUID->"11f832d1-8588-46f3-b7a5-9e3de17b2d66"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", "a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SqrtBox["3"], " ", "a"}], "-", "c"}], ")"}]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{
      SqrtBox["3"], " ", 
      SuperscriptBox["b", "2"]}], "4"], "-", 
    RowBox[{"a", " ", "c"}]}], ",", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{
       SqrtBox["3"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"6", " ", "a", " ", "c"}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.858788288448888*^9, 3.8590261899851227`*^9, 
  3.859909415433075*^9, 3.860832920043413*^9, 3.861097935626318*^9},
 CellLabel->
  "Out[123]=",ExpressionUUID->"3f20fade-0eb8-4ca3-b109-472d1c576f04"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"baryArea", "[", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "+", 
     RowBox[{"c", "^", "2"}]}], "\[Equal]", 
    RowBox[{"b", "^", "2"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.858786777987032*^9, 3.858786801250679*^9}, {
  3.858788317610319*^9, 3.85878834253583*^9}},
 CellLabel->
  "In[124]:=",ExpressionUUID->"9547adb8-8e55-4f83-b084-4952c3d29654"],

Cell[BoxData[
 FractionBox["K", "12"]], "Output",
 CellChangeTimes->{{3.858786793627717*^9, 3.8587868022970963`*^9}, 
   3.8587882951268663`*^9, 3.858788343593449*^9, 3.859026190074284*^9, 
   3.859909415525416*^9, 3.8610979357490253`*^9},
 CellLabel->
  "Out[124]=",ExpressionUUID->"0b858f7e-66a2-4cbe-adc4-eb7f2c84cf32"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Theorem 7.27 for X(396)", "Subsubsection",
 CellChangeTimes->{{3.8590267048883963`*^9, 3.859026727459972*^9}, 
   3.8590276561031523`*^9, {3.861090030685443*^9, 3.861090038729651*^9}, 
   3.8610922007045803`*^9},ExpressionUUID->"976e2a37-7b08-44a4-9b07-\
52c74fe73d4b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x396", "=", 
  RowBox[{"ETC1", "[", 
   RowBox[{"[", 
    RowBox[{"396", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.858786060921858*^9, 3.858786181361096*^9}, {
  3.8587863905711937`*^9, 3.858786410594088*^9}, {3.8587881675849857`*^9, 
  3.8587881747443943`*^9}, {3.8590276603278913`*^9, 3.859027662646915*^9}},
 CellLabel->
  "In[125]:=",ExpressionUUID->"c24769c4-6677-4d23-83fd-81b785e6cbd3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SqrtBox["3"], " ", 
     SuperscriptBox["a", "2"]}], "+", 
    RowBox[{"2", " ", "S"}]}], ",", 
   RowBox[{
    RowBox[{
     SqrtBox["3"], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    RowBox[{"2", " ", "S"}]}], ",", 
   RowBox[{
    RowBox[{
     SqrtBox["3"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"2", " ", "S"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8587881756168213`*^9, 3.85902618993408*^9, 
  3.859027663621985*^9, 3.85990941553579*^9, 3.8610979357607117`*^9},
 CellLabel->
  "Out[125]=",ExpressionUUID->"b1b68cb1-e5b0-4635-9c2b-616c722162fd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptF", "=", 
  RowBox[{"centerABE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x396", ".", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenAE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenAB"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.858785708664339*^9, 3.858785752208427*^9}, {
   3.858785901049223*^9, 3.8587859885123568`*^9}, {3.85878628204163*^9, 
   3.858786292089315*^9}, {3.858786357153858*^9, 3.858786360769568*^9}, {
   3.858786421793996*^9, 3.858786495154055*^9}, {3.8587867030365143`*^9, 
   3.858786704658731*^9}, {3.858788182793332*^9, 3.858788194031535*^9}, 
   3.858788246343902*^9, 3.859027669840116*^9},
 CellLabel->
  "In[126]:=",ExpressionUUID->"74e23c4b-3427-45e0-ba6c-95483c892772"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SqrtBox["3"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "a"}], "+", 
         RowBox[{
          SqrtBox["3"], " ", "c"}]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{
      SqrtBox["3"], " ", 
      SuperscriptBox["b", "2"]}], "4"], "+", 
    RowBox[{"a", " ", "c"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", "c", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{
       SqrtBox["3"], " ", "c"}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8587864233685513`*^9, {3.8587864696808767`*^9, 3.858786496037889*^9}, 
   3.8587867069184437`*^9, 3.858786755813157*^9, 3.8587870936108103`*^9, 
   3.8587882474445353`*^9, 3.859026189973741*^9, 3.859027670500546*^9, 
   3.8599094155769873`*^9, 3.861097935804044*^9},
 CellLabel->
  "Out[126]=",ExpressionUUID->"fb93bbd2-eca0-4bfa-96a8-99e8b8e98783"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptG", "=", 
  RowBox[{"centerBCE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x396", ".", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenCE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenBC"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8587865148663816`*^9, 3.858786564610229*^9}, {
   3.8587866148666897`*^9, 3.858786628154747*^9}, {3.858788263305393*^9, 
   3.858788287137041*^9}, 3.859027676232143*^9},
 CellLabel->
  "In[127]:=",ExpressionUUID->"7f7b6ecb-b0f2-4dd7-8548-fd991172ecc7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", "a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SqrtBox["3"], " ", "a"}], "+", "c"}], ")"}]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{
      SqrtBox["3"], " ", 
      SuperscriptBox["b", "2"]}], "4"], "+", 
    RowBox[{"a", " ", "c"}]}], ",", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{
       SqrtBox["3"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"6", " ", "a", " ", "c"}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.858788288448888*^9, 3.8590261899851227`*^9, 
  3.859027677347439*^9, 3.8599094155886917`*^9, 3.86109793584933*^9},
 CellLabel->
  "Out[127]=",ExpressionUUID->"6f296718-a7cc-4434-a946-c101162efe92"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"baryArea", "[", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "+", 
     RowBox[{"c", "^", "2"}]}], "\[Equal]", 
    RowBox[{"b", "^", "2"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.858786777987032*^9, 3.858786801250679*^9}, {
  3.858788317610319*^9, 3.85878834253583*^9}},
 CellLabel->
  "In[128]:=",ExpressionUUID->"50bc0c8a-95fa-4eb1-b325-64d667aefa2b"],

Cell[BoxData[
 FractionBox["K", "12"]], "Output",
 CellChangeTimes->{{3.858786793627717*^9, 3.8587868022970963`*^9}, 
   3.8587882951268663`*^9, 3.858788343593449*^9, 3.859026190074284*^9, 
   3.859027688655547*^9, 3.859909415655442*^9, 3.8610979359646893`*^9},
 CellLabel->
  "Out[128]=",ExpressionUUID->"668bc71d-4ee8-49ba-8183-661d40f7a6fe"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Theorem 7.29 for X(616)", "Subsubsection",
 CellChangeTimes->{{3.8590267048883963`*^9, 3.859026727459972*^9}, 
   3.8590276561031523`*^9, {3.859042356310068*^9, 3.859042356790008*^9}, {
   3.861090070394148*^9, 3.861090078337948*^9}, 
   3.861092202928553*^9},ExpressionUUID->"d0046373-2984-4859-8f72-\
326ffc0fefcc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x616", "=", 
  RowBox[{"ETC1", "[", 
   RowBox[{"[", 
    RowBox[{"616", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.858786060921858*^9, 3.858786181361096*^9}, {
  3.8587863905711937`*^9, 3.858786410594088*^9}, {3.8587881675849857`*^9, 
  3.8587881747443943`*^9}, {3.8590276603278913`*^9, 3.859027662646915*^9}, {
  3.859042362414756*^9, 3.859042368246148*^9}},
 CellLabel->
  "In[129]:=",ExpressionUUID->"7506da5a-ba41-4b04-a0cf-06edf922bc21"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "5"}], " ", 
     SuperscriptBox["a", "4"]}], "+", 
    SuperscriptBox["b", "4"], "+", 
    SuperscriptBox["c", "4"], "+", 
    RowBox[{"2", " ", 
     SqrtBox["3"], " ", 
     SuperscriptBox["c", "2"], " ", "S"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["b", "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["c", "2"]}], "-", 
       RowBox[{"2", " ", 
        SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["c", "2"], "-", 
       RowBox[{
        SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
   RowBox[{
    SuperscriptBox["a", "4"], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["b", "2"]}], "-", 
       SuperscriptBox["c", "2"], "+", 
       RowBox[{
        SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["b", "2"]}], "+", 
       SuperscriptBox["c", "2"], "+", 
       RowBox[{"2", " ", 
        SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
   RowBox[{
    SuperscriptBox["a", "4"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SuperscriptBox["b", "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["c", "2"]}], "+", 
       RowBox[{"2", " ", 
        SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       RowBox[{"5", " ", 
        SuperscriptBox["c", "2"]}], "+", 
       RowBox[{"2", " ", 
        SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8587881756168213`*^9, 3.85902618993408*^9, 
  3.859027663621985*^9, 3.8590423702523117`*^9, 3.859909415666065*^9, 
  3.861097935975753*^9},
 CellLabel->
  "Out[129]=",ExpressionUUID->"b73713f8-4706-4ee7-a57d-b71732d9fe36"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptF", "=", 
  RowBox[{"centerABE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x616", ".", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenAE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenAB"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.858785708664339*^9, 3.858785752208427*^9}, {
   3.858785901049223*^9, 3.8587859885123568`*^9}, {3.85878628204163*^9, 
   3.858786292089315*^9}, {3.858786357153858*^9, 3.858786360769568*^9}, {
   3.858786421793996*^9, 3.858786495154055*^9}, {3.8587867030365143`*^9, 
   3.858786704658731*^9}, {3.858788182793332*^9, 3.858788194031535*^9}, 
   3.858788246343902*^9, 3.859027669840116*^9, {3.859042382319257*^9, 
   3.8590423832220087`*^9}},
 CellLabel->
  "In[130]:=",ExpressionUUID->"97d0268c-efac-49f9-8807-0eee67bfa23e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", "c", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SqrtBox["3"], " ", "a", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["c", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      RowBox[{"2", " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SqrtBox["3"], " ", "a"}], "+", "c"}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "4"], " ", "c", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{
       SqrtBox["3"], " ", "a", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}]], "Output",\

 CellChangeTimes->{
  3.8587864233685513`*^9, {3.8587864696808767`*^9, 3.858786496037889*^9}, 
   3.8587867069184437`*^9, 3.858786755813157*^9, 3.8587870936108103`*^9, 
   3.8587882474445353`*^9, 3.859026189973741*^9, 3.859027670500546*^9, 
   3.8590423848575172`*^9, 3.8599094157113733`*^9, 3.861097936059243*^9},
 CellLabel->
  "Out[130]=",ExpressionUUID->"01986c69-b959-4b37-bf5d-2c0a063fbc62"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptG", "=", 
  RowBox[{"centerBCE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x616", ".", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenCE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenBC"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8587865148663816`*^9, 3.858786564610229*^9}, {
   3.8587866148666897`*^9, 3.858786628154747*^9}, {3.858788263305393*^9, 
   3.858788287137041*^9}, 3.859027676232143*^9, {3.859042391407422*^9, 
   3.859042391830041*^9}},
 CellLabel->
  "In[131]:=",ExpressionUUID->"16ef0102-186d-4f22-a818-7532517c6773"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", "a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "10"}], " ", 
       SuperscriptBox["a", "3"]}], "+", 
      RowBox[{"4", " ", "a", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["a", "2"], " ", "c"}], "+", 
      RowBox[{
       SqrtBox["3"], " ", 
       SuperscriptBox["b", "2"], " ", "c"}]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["a", "4"], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "2"], "+", 
    RowBox[{
     SqrtBox["3"], " ", 
     SuperscriptBox["a", "3"], " ", "c"}]}], ",", 
   RowBox[{
    FractionBox["1", "4"], " ", "a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", 
       SuperscriptBox["a", "3"]}], "+", 
      RowBox[{"6", " ", "a", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["a", "2"], " ", "c"}], "+", 
      RowBox[{
       SqrtBox["3"], " ", 
       SuperscriptBox["b", "2"], " ", "c"}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.858788288448888*^9, 3.8590261899851227`*^9, 
  3.859027677347439*^9, 3.859042393161137*^9, 3.859909415753799*^9, 
  3.861097936147051*^9},
 CellLabel->
  "Out[131]=",ExpressionUUID->"94233189-72ff-4a6b-93ed-51fe306acf90"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"baryArea", "[", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "+", 
     RowBox[{"c", "^", "2"}]}], "\[Equal]", 
    RowBox[{"b", "^", "2"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.858786777987032*^9, 3.858786801250679*^9}, {
  3.858788317610319*^9, 3.85878834253583*^9}},
 CellLabel->
  "In[132]:=",ExpressionUUID->"8ff5b48c-5e1f-4ac2-a1cc-7f0de2345af0"],

Cell[BoxData[
 FractionBox["K", "3"]], "Output",
 CellChangeTimes->{{3.858786793627717*^9, 3.8587868022970963`*^9}, 
   3.8587882951268663`*^9, 3.858788343593449*^9, 3.859026190074284*^9, 
   3.859027688655547*^9, 3.859042401266765*^9, 3.859909415896008*^9, 
   3.861097936319824*^9},
 CellLabel->
  "Out[132]=",ExpressionUUID->"70507645-d145-4e75-80ee-8981fbd963e3"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Theorem 7.29 for X(617)", "Subsubsection",
 CellChangeTimes->{{3.8590267048883963`*^9, 3.859026727459972*^9}, 
   3.8590276561031523`*^9, {3.859042356310068*^9, 3.859042356790008*^9}, 
   3.8590426390870533`*^9, {3.861090087586233*^9, 3.861090093905986*^9}, 
   3.86109220460052*^9},ExpressionUUID->"ad790a4d-acb3-41e0-8d6f-\
d443f1e96a2d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x617", "=", 
  RowBox[{"ETC1", "[", 
   RowBox[{"[", 
    RowBox[{"617", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.858786060921858*^9, 3.858786181361096*^9}, {
  3.8587863905711937`*^9, 3.858786410594088*^9}, {3.8587881675849857`*^9, 
  3.8587881747443943`*^9}, {3.8590276603278913`*^9, 3.859027662646915*^9}, {
  3.859042362414756*^9, 3.859042368246148*^9}, {3.8590426420638123`*^9, 
  3.859042644462646*^9}},
 CellLabel->
  "In[133]:=",ExpressionUUID->"907ccbda-af39-4e74-b442-8c2e0d5b368b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"5", " ", 
     SuperscriptBox["a", "4"]}], "-", 
    SuperscriptBox["b", "4"], "-", 
    SuperscriptBox["c", "4"], "+", 
    RowBox[{"2", " ", 
     SqrtBox["3"], " ", 
     SuperscriptBox["c", "2"], " ", "S"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       RowBox[{
        SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["b", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["c", "2"]}], "+", 
       RowBox[{
        SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "4"]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["b", "2"]}], "+", 
       SuperscriptBox["c", "2"], "-", 
       RowBox[{"2", " ", 
        SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SuperscriptBox["b", "2"]}], "+", 
       SuperscriptBox["c", "2"], "+", 
       RowBox[{
        SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "4"]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       RowBox[{"5", " ", 
        SuperscriptBox["c", "2"]}], "-", 
       RowBox[{"2", " ", 
        SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["c", "2"]}], "+", 
       RowBox[{
        SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8587881756168213`*^9, 3.85902618993408*^9, 
  3.859027663621985*^9, 3.8590423702523117`*^9, 3.859042645706134*^9, 
  3.859909415907052*^9, 3.8610979363624363`*^9},
 CellLabel->
  "Out[133]=",ExpressionUUID->"feafa3e4-020f-437a-a0e1-6c4d7446bd09"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptF", "=", 
  RowBox[{"centerABE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x617", ".", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenAE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenAB"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.858785708664339*^9, 3.858785752208427*^9}, {
   3.858785901049223*^9, 3.8587859885123568`*^9}, {3.85878628204163*^9, 
   3.858786292089315*^9}, {3.858786357153858*^9, 3.858786360769568*^9}, {
   3.858786421793996*^9, 3.858786495154055*^9}, {3.8587867030365143`*^9, 
   3.858786704658731*^9}, {3.858788182793332*^9, 3.858788194031535*^9}, 
   3.858788246343902*^9, 3.859027669840116*^9, {3.859042382319257*^9, 
   3.8590423832220087`*^9}, 3.8590426501198273`*^9},
 CellLabel->
  "In[134]:=",ExpressionUUID->"0a6c84b4-9fc6-4090-bc7b-2d66dfceb2ff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", "c", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{
       SqrtBox["3"], " ", "a", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    SuperscriptBox["c", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      RowBox[{"2", " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SqrtBox["3"]}], " ", "a"}], "+", "c"}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "4"], " ", "c", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{
       SqrtBox["3"], " ", "a", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}]], "Output",\

 CellChangeTimes->{
  3.8587864233685513`*^9, {3.8587864696808767`*^9, 3.858786496037889*^9}, 
   3.8587867069184437`*^9, 3.858786755813157*^9, 3.8587870936108103`*^9, 
   3.8587882474445353`*^9, 3.859026189973741*^9, 3.859027670500546*^9, 
   3.8590423848575172`*^9, 3.859042650686679*^9, 3.8599094159501743`*^9, 
   3.861097936436973*^9},
 CellLabel->
  "Out[134]=",ExpressionUUID->"cf2f6614-24b0-445b-bf2a-62ac9021af5c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptG", "=", 
  RowBox[{"centerBCE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x617", ".", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenCE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenBC"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8587865148663816`*^9, 3.858786564610229*^9}, {
   3.8587866148666897`*^9, 3.858786628154747*^9}, {3.858788263305393*^9, 
   3.858788287137041*^9}, 3.859027676232143*^9, {3.859042391407422*^9, 
   3.859042391830041*^9}, 3.859042654781164*^9},
 CellLabel->
  "In[135]:=",ExpressionUUID->"13618b1f-7df6-4237-8b3b-eb69acdb3bf4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", "a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["a", "3"]}], "-", 
      RowBox[{"4", " ", "a", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["a", "2"], " ", "c"}], "+", 
      RowBox[{
       SqrtBox["3"], " ", 
       SuperscriptBox["b", "2"], " ", "c"}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", "a", " ", "c"}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "4"], " ", "a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["a", "3"]}], "-", 
      RowBox[{"6", " ", "a", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["a", "2"], " ", "c"}], "+", 
      RowBox[{
       SqrtBox["3"], " ", 
       SuperscriptBox["b", "2"], " ", "c"}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.858788288448888*^9, 3.8590261899851227`*^9, 
  3.859027677347439*^9, 3.859042393161137*^9, 3.8590426552914457`*^9, 
  3.859909415994711*^9, 3.8610979365183372`*^9},
 CellLabel->
  "Out[135]=",ExpressionUUID->"d03c9a2c-f568-4d4c-be56-57e36b0d9439"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"baryArea", "[", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "+", 
     RowBox[{"c", "^", "2"}]}], "\[Equal]", 
    RowBox[{"b", "^", "2"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.858786777987032*^9, 3.858786801250679*^9}, {
  3.858788317610319*^9, 3.85878834253583*^9}},
 CellLabel->
  "In[136]:=",ExpressionUUID->"630b78eb-f4b5-4306-8ea8-beb8003ef4eb"],

Cell[BoxData[
 FractionBox["K", "3"]], "Output",
 CellChangeTimes->{{3.858786793627717*^9, 3.8587868022970963`*^9}, 
   3.8587882951268663`*^9, 3.858788343593449*^9, 3.859026190074284*^9, 
   3.859027688655547*^9, 3.859042401266765*^9, 3.859042659120059*^9, 
   3.859909416118535*^9, 3.861097936709234*^9},
 CellLabel->
  "Out[136]=",ExpressionUUID->"479c7365-b6bf-416e-9d43-ef0949cf365d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Theorem 7.32 for X(146)", "Subsubsection",
 CellChangeTimes->{{3.8590267048883963`*^9, 3.859026727459972*^9}, 
   3.8590276561031523`*^9, {3.859042356310068*^9, 3.859042356790008*^9}, 
   3.8590426390870533`*^9, {3.8590447361657467`*^9, 3.859044737189307*^9}, {
   3.861090135626151*^9, 3.86109013978616*^9}, 
   3.861092206856554*^9},ExpressionUUID->"bb08997d-7014-49b0-abd9-\
391e0cc0a303"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x146", "=", 
  RowBox[{"ETC1", "[", 
   RowBox[{"[", 
    RowBox[{"146", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.858786060921858*^9, 3.858786181361096*^9}, {
  3.8587863905711937`*^9, 3.858786410594088*^9}, {3.8587881675849857`*^9, 
  3.8587881747443943`*^9}, {3.8590276603278913`*^9, 3.859027662646915*^9}, {
  3.859042362414756*^9, 3.859042368246148*^9}, {3.8590426420638123`*^9, 
  3.859042644462646*^9}, {3.859044740382359*^9, 3.8590447452773867`*^9}},
 CellLabel->
  "In[137]:=",ExpressionUUID->"1c42f395-236e-4a68-85f9-d987e4bc64c9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "10"], "+", 
    RowBox[{
     SuperscriptBox["a", "8"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "4"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "6"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "8"]}], "-", 
    SuperscriptBox["b", "10"], "+", 
    RowBox[{
     SuperscriptBox["a", "8"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["b", "8"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "6"]}], "-", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "6"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "6"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "8"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "8"]}], "-", 
    SuperscriptBox["c", "10"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "10"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "8"], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "4"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "6"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "8"]}], "+", 
    SuperscriptBox["b", "10"], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "8"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "8"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "6"]}], "-", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "8"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "8"]}], "-", 
    SuperscriptBox["c", "10"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "10"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "8"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "4"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "6"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "8"]}], "-", 
    SuperscriptBox["b", "10"], "-", 
    RowBox[{
     SuperscriptBox["a", "8"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "8"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "6"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "8"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "8"]}], "+", 
    SuperscriptBox["c", "10"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8587881756168213`*^9, 3.85902618993408*^9, 
  3.859027663621985*^9, 3.8590423702523117`*^9, 3.859042645706134*^9, 
  3.8590447458071947`*^9, 3.8599094161311903`*^9, 3.861097936722991*^9},
 CellLabel->
  "Out[137]=",ExpressionUUID->"7cee9093-0db1-4a35-8a9d-854d83a18794"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptF", "=", 
  RowBox[{"centerABE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x146", ".", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenAE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenAB"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.858785708664339*^9, 3.858785752208427*^9}, {
   3.858785901049223*^9, 3.8587859885123568`*^9}, {3.85878628204163*^9, 
   3.858786292089315*^9}, {3.858786357153858*^9, 3.858786360769568*^9}, {
   3.858786421793996*^9, 3.858786495154055*^9}, {3.8587867030365143`*^9, 
   3.858786704658731*^9}, {3.858788182793332*^9, 3.858788194031535*^9}, 
   3.858788246343902*^9, 3.859027669840116*^9, {3.859042382319257*^9, 
   3.8590423832220087`*^9}, 3.8590426501198273`*^9, {3.859044752350841*^9, 
   3.859044753373679*^9}},
 CellLabel->
  "In[138]:=",ExpressionUUID->"5ed0dbb5-8124-4b2e-b3b4-170d15e15cd9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "32"], " ", 
    SuperscriptBox["c", "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["c", "2"]}]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "16"]}], " ", 
    SuperscriptBox["c", "6"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["c", "2"]}]}], ")"}], "2"]}], ",", 
   RowBox[{
    FractionBox["1", "32"], " ", 
    SuperscriptBox["c", "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["c", "2"]}]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8587864233685513`*^9, {3.8587864696808767`*^9, 3.858786496037889*^9}, 
   3.8587867069184437`*^9, 3.858786755813157*^9, 3.8587870936108103`*^9, 
   3.8587882474445353`*^9, 3.859026189973741*^9, 3.859027670500546*^9, 
   3.8590423848575172`*^9, 3.859042650686679*^9, 3.8590447547233887`*^9, 
   3.859909416171184*^9, 3.861097936767992*^9},
 CellLabel->
  "Out[138]=",ExpressionUUID->"50245e89-5ae5-41fb-890e-0ee1d1527e27"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptG", "=", 
  RowBox[{"centerBCE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x146", ".", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenCE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenBC"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8587865148663816`*^9, 3.858786564610229*^9}, {
   3.8587866148666897`*^9, 3.858786628154747*^9}, {3.858788263305393*^9, 
   3.858788287137041*^9}, 3.859027676232143*^9, {3.859042391407422*^9, 
   3.859042391830041*^9}, 3.859042654781164*^9, {3.859044768519006*^9, 
   3.859044769565692*^9}},
 CellLabel->
  "In[139]:=",ExpressionUUID->"768e57a8-58ad-4707-bb73-fa8ab16cb5d0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "32"], " ", 
    SuperscriptBox["a", "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "16"]}], " ", 
    SuperscriptBox["a", "6"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"]}], ")"}], "2"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "32"]}], " ", 
    SuperscriptBox["a", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"]}], ")"}], "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.858788288448888*^9, 3.8590261899851227`*^9, 
  3.859027677347439*^9, 3.859042393161137*^9, 3.8590426552914457`*^9, 
  3.859044770167042*^9, 3.859909416231501*^9, 3.8610979368299637`*^9},
 CellLabel->
  "Out[139]=",ExpressionUUID->"47bde273-e20d-44a5-8dfb-a8c993963628"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"baryArea", "[", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "+", 
     RowBox[{"c", "^", "2"}]}], "\[Equal]", 
    RowBox[{"b", "^", "2"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.858786777987032*^9, 3.858786801250679*^9}, {
  3.858788317610319*^9, 3.85878834253583*^9}},
 CellLabel->
  "In[140]:=",ExpressionUUID->"ca7b7b5a-2ecd-4261-95f2-5def058f5a37"],

Cell[BoxData["K"], "Output",
 CellChangeTimes->{{3.858786793627717*^9, 3.8587868022970963`*^9}, 
   3.8587882951268663`*^9, 3.858788343593449*^9, 3.859026190074284*^9, 
   3.859027688655547*^9, 3.859042401266765*^9, 3.859042659120059*^9, 
   3.859044782025463*^9, 3.859909416273966*^9, 3.861097936876124*^9},
 CellLabel->
  "Out[140]=",ExpressionUUID->"a27e723e-1196-4568-a25a-04fb6d954466"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Theorem 7.32 for X(147)", "Subsubsection",
 CellChangeTimes->{{3.8590267048883963`*^9, 3.859026727459972*^9}, 
   3.8590276561031523`*^9, {3.859042356310068*^9, 3.859042356790008*^9}, 
   3.8590426390870533`*^9, {3.8590447361657467`*^9, 3.859044737189307*^9}, 
   3.859044857862288*^9, 3.8610901507470903`*^9, 
   3.861092208728591*^9},ExpressionUUID->"9f17204f-a935-48b4-9347-\
af6013b7e006"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x147", "=", 
  RowBox[{"ETC1", "[", 
   RowBox[{"[", 
    RowBox[{"147", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.858786060921858*^9, 3.858786181361096*^9}, {
  3.8587863905711937`*^9, 3.858786410594088*^9}, {3.8587881675849857`*^9, 
  3.8587881747443943`*^9}, {3.8590276603278913`*^9, 3.859027662646915*^9}, {
  3.859042362414756*^9, 3.859042368246148*^9}, {3.8590426420638123`*^9, 
  3.859042644462646*^9}, {3.859044740382359*^9, 3.8590447452773867`*^9}, {
  3.859044866006941*^9, 3.859044872166421*^9}},
 CellLabel->
  "In[141]:=",ExpressionUUID->"1bb652cc-81d2-4b0e-8dc4-82da9407bf0e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "8"], "+", 
    RowBox[{
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "6"]}], "-", 
    SuperscriptBox["b", "8"], "+", 
    RowBox[{
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "6"]}], "-", 
    SuperscriptBox["c", "8"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "8"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "6"]}], "+", 
    SuperscriptBox["b", "8"], "+", 
    RowBox[{
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "6"]}], "-", 
    SuperscriptBox["c", "8"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "8"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "6"]}], "-", 
    SuperscriptBox["b", "8"], "+", 
    RowBox[{
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "6"]}], "+", 
    SuperscriptBox["c", "8"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8587881756168213`*^9, 3.85902618993408*^9, 
  3.859027663621985*^9, 3.8590423702523117`*^9, 3.859042645706134*^9, 
  3.8590447458071947`*^9, 3.859044875164279*^9, 3.8599094162873583`*^9, 
  3.861097936888878*^9},
 CellLabel->
  "Out[141]=",ExpressionUUID->"9bcbc869-fa07-4c93-9d24-d177db7b70ba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptF", "=", 
  RowBox[{"centerABE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x147", ".", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenAE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenAB"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.858785708664339*^9, 3.858785752208427*^9}, {
   3.858785901049223*^9, 3.8587859885123568`*^9}, {3.85878628204163*^9, 
   3.858786292089315*^9}, {3.858786357153858*^9, 3.858786360769568*^9}, {
   3.858786421793996*^9, 3.858786495154055*^9}, {3.8587867030365143`*^9, 
   3.858786704658731*^9}, {3.858788182793332*^9, 3.858788194031535*^9}, 
   3.858788246343902*^9, 3.859027669840116*^9, {3.859042382319257*^9, 
   3.8590423832220087`*^9}, 3.8590426501198273`*^9, {3.859044752350841*^9, 
   3.859044753373679*^9}, 3.859044879415017*^9},
 CellLabel->
  "In[142]:=",ExpressionUUID->"23b3d934-81a7-4fac-9ea6-68119d998f95"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "32"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["b", "2"], " ", "c"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["c", "3"]}]}], ")"}], "2"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "16"]}], " ", 
    SuperscriptBox["c", "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["c", "2"]}]}], ")"}], "2"]}], ",", 
   RowBox[{
    FractionBox["1", "32"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["b", "2"], " ", "c"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["c", "3"]}]}], ")"}], "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8587864233685513`*^9, {3.8587864696808767`*^9, 3.858786496037889*^9}, 
   3.8587867069184437`*^9, 3.858786755813157*^9, 3.8587870936108103`*^9, 
   3.8587882474445353`*^9, 3.859026189973741*^9, 3.859027670500546*^9, 
   3.8590423848575172`*^9, 3.859042650686679*^9, 3.8590447547233887`*^9, 
   3.859044880014617*^9, 3.859909416330288*^9, 3.8610979369348297`*^9},
 CellLabel->
  "Out[142]=",ExpressionUUID->"9bdf446d-d7dd-4ec2-826b-9cdf9820c146"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptG", "=", 
  RowBox[{"centerBCE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x147", ".", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenCE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenBC"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8587865148663816`*^9, 3.858786564610229*^9}, {
   3.8587866148666897`*^9, 3.858786628154747*^9}, {3.858788263305393*^9, 
   3.858788287137041*^9}, 3.859027676232143*^9, {3.859042391407422*^9, 
   3.859042391830041*^9}, 3.859042654781164*^9, {3.859044768519006*^9, 
   3.859044769565692*^9}, 3.859044885903104*^9},
 CellLabel->
  "In[143]:=",ExpressionUUID->"8993f150-0627-4fe5-a0f4-3056976e56de"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "32"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        SuperscriptBox["a", "3"]}], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["b", "2"]}]}], ")"}], "2"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "16"]}], " ", 
    SuperscriptBox["a", "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"]}], ")"}], "2"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "32"]}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        SuperscriptBox["a", "3"]}], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["b", "2"]}]}], ")"}], "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.858788288448888*^9, 3.8590261899851227`*^9, 
  3.859027677347439*^9, 3.859042393161137*^9, 3.8590426552914457`*^9, 
  3.859044770167042*^9, 3.859044886882308*^9, 3.8599094163453197`*^9, 
  3.861097936985882*^9},
 CellLabel->
  "Out[143]=",ExpressionUUID->"f03624df-7b30-466f-9c51-2c01e31fbf44"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"baryArea", "[", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "+", 
     RowBox[{"c", "^", "2"}]}], "\[Equal]", 
    RowBox[{"b", "^", "2"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.858786777987032*^9, 3.858786801250679*^9}, {
  3.858788317610319*^9, 3.85878834253583*^9}},
 CellLabel->
  "In[144]:=",ExpressionUUID->"1f0b5c6a-f503-4833-b53e-618fee01d588"],

Cell[BoxData["K"], "Output",
 CellChangeTimes->{{3.858786793627717*^9, 3.8587868022970963`*^9}, 
   3.8587882951268663`*^9, 3.858788343593449*^9, 3.859026190074284*^9, 
   3.859027688655547*^9, 3.859042401266765*^9, 3.859042659120059*^9, 
   3.859044782025463*^9, 3.859044895832169*^9, 3.8599094163865633`*^9, 
   3.861097937032836*^9},
 CellLabel->
  "Out[144]=",ExpressionUUID->"c93c71c1-e472-4a77-8acd-fcfceef4c97a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Theorem 7.32 for X(150)", "Subsubsection",
 CellChangeTimes->{{3.8590267048883963`*^9, 3.859026727459972*^9}, 
   3.8590276561031523`*^9, {3.859042356310068*^9, 3.859042356790008*^9}, 
   3.8590426390870533`*^9, {3.8590447361657467`*^9, 3.859044737189307*^9}, {
   3.859044910742312*^9, 3.859044911045905*^9}, 3.861090154267125*^9, 
   3.861092210400671*^9},ExpressionUUID->"74b698cb-b9ee-4266-9b66-\
2bcc8e23feea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x150", "=", 
  RowBox[{"ETC1", "[", 
   RowBox[{"[", 
    RowBox[{"150", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.858786060921858*^9, 3.858786181361096*^9}, {
  3.8587863905711937`*^9, 3.858786410594088*^9}, {3.8587881675849857`*^9, 
  3.8587881747443943`*^9}, {3.8590276603278913`*^9, 3.859027662646915*^9}, {
  3.859042362414756*^9, 3.859042368246148*^9}, {3.8590426420638123`*^9, 
  3.859042644462646*^9}, {3.859044740382359*^9, 3.8590447452773867`*^9}, {
  3.85904491431075*^9, 3.859044918878051*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"3a45b50d-1352-4807-9b10-64e6417279b5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "4"], "-", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "b"}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "3"]}], "-", 
    SuperscriptBox["b", "4"], "-", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["b", "3"], " ", "c"}], "-", 
    RowBox[{"a", " ", "b", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "3"]}], "-", 
    SuperscriptBox["c", "4"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "b"}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "3"]}], "+", 
    SuperscriptBox["b", "4"], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["b", "3"], " ", "c"}], "-", 
    RowBox[{"a", " ", "b", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "3"]}], "-", 
    SuperscriptBox["c", "4"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "b"}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "3"]}], "-", 
    SuperscriptBox["b", "4"], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["b", "3"], " ", "c"}], "+", 
    RowBox[{"a", " ", "b", " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "3"]}], "+", 
    SuperscriptBox["c", "4"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8587881756168213`*^9, 3.85902618993408*^9, 
  3.859027663621985*^9, 3.8590423702523117`*^9, 3.859042645706134*^9, 
  3.8590447458071947`*^9, 3.8590449199286747`*^9, 3.859909416397592*^9, 
  3.86109793708181*^9},
 CellLabel->
  "Out[145]=",ExpressionUUID->"664181ee-5e8a-47ef-9791-a75ec13ab6ba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptF", "=", 
  RowBox[{"centerABE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x150", ".", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenAE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenAB"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.858785708664339*^9, 3.858785752208427*^9}, {
   3.858785901049223*^9, 3.8587859885123568`*^9}, {3.85878628204163*^9, 
   3.858786292089315*^9}, {3.858786357153858*^9, 3.858786360769568*^9}, {
   3.858786421793996*^9, 3.858786495154055*^9}, {3.8587867030365143`*^9, 
   3.858786704658731*^9}, {3.858788182793332*^9, 3.858788194031535*^9}, 
   3.858788246343902*^9, 3.859027669840116*^9, {3.859042382319257*^9, 
   3.8590423832220087`*^9}, 3.8590426501198273`*^9, {3.859044752350841*^9, 
   3.859044753373679*^9}, {3.859044924479558*^9, 3.859044924734539*^9}},
 CellLabel->
  "In[146]:=",ExpressionUUID->"3d562128-095b-4412-a36e-b3c017f10a6d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "8"]}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "-", 
       RowBox[{"2", " ", "c"}]}], ")"}], "2"], " ", 
    SuperscriptBox["c", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "-", 
       RowBox[{"2", " ", "c"}]}], ")"}], "2"], " ", 
    SuperscriptBox["c", "2"]}], ",", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "-", 
       RowBox[{"2", " ", "c"}]}], ")"}], "2"], " ", 
    SuperscriptBox["c", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8587864233685513`*^9, {3.8587864696808767`*^9, 3.858786496037889*^9}, 
   3.8587867069184437`*^9, 3.858786755813157*^9, 3.8587870936108103`*^9, 
   3.8587882474445353`*^9, 3.859026189973741*^9, 3.859027670500546*^9, 
   3.8590423848575172`*^9, 3.859042650686679*^9, 3.8590447547233887`*^9, 
   3.859044925845641*^9, 3.859909416439583*^9, 3.861097937127899*^9},
 CellLabel->
  "Out[146]=",ExpressionUUID->"38edfd7b-e4f6-4116-995e-973c8775bd62"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptG", "=", 
  RowBox[{"centerBCE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x150", ".", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenCE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenBC"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8587865148663816`*^9, 3.858786564610229*^9}, {
   3.8587866148666897`*^9, 3.858786628154747*^9}, {3.858788263305393*^9, 
   3.858788287137041*^9}, 3.859027676232143*^9, {3.859042391407422*^9, 
   3.859042391830041*^9}, 3.859042654781164*^9, {3.859044768519006*^9, 
   3.859044769565692*^9}, {3.8590449338556967`*^9, 3.859044934102459*^9}},
 CellLabel->
  "In[147]:=",ExpressionUUID->"b370ef14-e4bc-4fc9-bd8b-fbd558b426a8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "8"], " ", 
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a"}], "+", "b"}], ")"}], "2"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a"}], "+", "b"}], ")"}], "2"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "8"]}], " ", 
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a"}], "+", "b"}], ")"}], "2"]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.858788288448888*^9, 3.8590261899851227`*^9, 
  3.859027677347439*^9, 3.859042393161137*^9, 3.8590426552914457`*^9, 
  3.859044770167042*^9, 3.859044935200601*^9, 3.8599094164840508`*^9, 
  3.861097937179235*^9},
 CellLabel->
  "Out[147]=",ExpressionUUID->"b056c503-2c0c-4e78-9739-98b11ea72d54"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"baryArea", "[", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "+", 
     RowBox[{"c", "^", "2"}]}], "\[Equal]", 
    RowBox[{"b", "^", "2"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.858786777987032*^9, 3.858786801250679*^9}, {
  3.858788317610319*^9, 3.85878834253583*^9}},
 CellLabel->
  "In[148]:=",ExpressionUUID->"5c365c94-6724-4e79-9573-2791a943c2c5"],

Cell[BoxData["K"], "Output",
 CellChangeTimes->{{3.858786793627717*^9, 3.8587868022970963`*^9}, 
   3.8587882951268663`*^9, 3.858788343593449*^9, 3.859026190074284*^9, 
   3.859027688655547*^9, 3.859042401266765*^9, 3.859042659120059*^9, 
   3.859044782025463*^9, 3.859044938329708*^9, 3.859909416494575*^9, 
   3.861097937225511*^9},
 CellLabel->
  "Out[148]=",ExpressionUUID->"6321edfd-6e21-4ce9-b37f-b55016bfaa6d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Theorem 7.32 for X(151)", "Subsubsection",
 CellChangeTimes->{{3.8590267048883963`*^9, 3.859026727459972*^9}, 
   3.8590276561031523`*^9, {3.859042356310068*^9, 3.859042356790008*^9}, 
   3.8590426390870533`*^9, {3.8590447361657467`*^9, 3.859044737189307*^9}, {
   3.859044910742312*^9, 3.859044911045905*^9}, 3.8590449512304087`*^9, 
   3.861090158203286*^9, 
   3.861092213152686*^9},ExpressionUUID->"ac1a83d0-835a-46e5-b4f2-\
fbb027e73ec3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x151", "=", 
  RowBox[{"ETC1", "[", 
   RowBox[{"[", 
    RowBox[{"151", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.858786060921858*^9, 3.858786181361096*^9}, {
  3.8587863905711937`*^9, 3.858786410594088*^9}, {3.8587881675849857`*^9, 
  3.8587881747443943`*^9}, {3.8590276603278913`*^9, 3.859027662646915*^9}, {
  3.859042362414756*^9, 3.859042368246148*^9}, {3.8590426420638123`*^9, 
  3.859042644462646*^9}, {3.859044740382359*^9, 3.8590447452773867`*^9}, {
  3.85904491431075*^9, 3.859044918878051*^9}, {3.859044953302846*^9, 
  3.859044955854165*^9}},
 CellLabel->
  "In[149]:=",ExpressionUUID->"b584d897-e52c-4f81-b164-50a442ed7630"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "10"], "-", 
    RowBox[{
     SuperscriptBox["a", "9"], " ", "b"}], "+", 
    RowBox[{
     SuperscriptBox["a", "8"], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "7"], " ", 
     SuperscriptBox["b", "3"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "4"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "6"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "7"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "8"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "9"]}], "-", 
    SuperscriptBox["b", "10"], "-", 
    RowBox[{
     SuperscriptBox["a", "9"], " ", "c"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "8"], " ", "b", " ", "c"}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "7"], " ", 
     SuperscriptBox["b", "2"], " ", "c"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "3"], " ", "c"}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "4"], " ", "c"}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "5"], " ", "c"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "6"], " ", "c"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "7"], " ", "c"}], "-", 
    RowBox[{"3", " ", "a", " ", 
     SuperscriptBox["b", "8"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["b", "9"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["a", "8"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "7"], " ", "b", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["b", "8"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "7"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["b", "7"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"6", " ", "a", " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "5"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{"6", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "5"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "5"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "6"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "6"]}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "6"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "6"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "7"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "7"]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "7"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "8"]}], "-", 
    RowBox[{"3", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "8"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "8"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "9"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "9"]}], "-", 
    SuperscriptBox["c", "10"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "10"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "9"], " ", "b"}], "-", 
    RowBox[{
     SuperscriptBox["a", "8"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "7"], " ", 
     SuperscriptBox["b", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "4"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "6"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "7"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "8"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "9"]}], "+", 
    SuperscriptBox["b", "10"], "+", 
    RowBox[{
     SuperscriptBox["a", "9"], " ", "c"}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "8"], " ", "b", " ", "c"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "7"], " ", 
     SuperscriptBox["b", "2"], " ", "c"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "3"], " ", "c"}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "4"], " ", "c"}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "5"], " ", "c"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "6"], " ", "c"}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "7"], " ", "c"}], "+", 
    RowBox[{"3", " ", "a", " ", 
     SuperscriptBox["b", "8"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["b", "9"], " ", "c"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "8"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"6", " ", "a", " ", 
     SuperscriptBox["b", "7"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "8"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "7"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "7"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"12", " ", "a", " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "5"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{"12", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "6"]}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "6"]}], "-", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "6"]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "7"]}], "+", 
    RowBox[{"6", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "7"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "7"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "8"]}], "-", 
    RowBox[{"3", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "8"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "8"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "9"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "9"]}], "-", 
    SuperscriptBox["c", "10"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "10"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "9"], " ", "b"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "8"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "7"], " ", 
     SuperscriptBox["b", "3"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "4"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "5"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "6"]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "7"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "8"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "9"]}], "-", 
    SuperscriptBox["b", "10"], "+", 
    RowBox[{
     SuperscriptBox["a", "9"], " ", "c"}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "8"], " ", "b", " ", "c"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "3"], " ", "c"}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "4"], " ", "c"}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "5"], " ", "c"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "6"], " ", "c"}], "-", 
    RowBox[{"3", " ", "a", " ", 
     SuperscriptBox["b", "8"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["b", "9"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["a", "8"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "7"], " ", "b", " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"6", " ", "a", " ", 
     SuperscriptBox["b", "7"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "8"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "7"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "7"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"12", " ", "a", " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "5"]}], "+", 
    RowBox[{"12", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "6"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "7"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "7"]}], "-", 
    RowBox[{"6", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "7"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "7"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "8"]}], "+", 
    RowBox[{"3", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "8"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "8"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "9"]}], "-", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "9"]}], "+", 
    SuperscriptBox["c", "10"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8587881756168213`*^9, 3.85902618993408*^9, 
  3.859027663621985*^9, 3.8590423702523117`*^9, 3.859042645706134*^9, 
  3.8590447458071947`*^9, 3.8590449199286747`*^9, 3.859044956578836*^9, 
  3.859909416545951*^9, 3.861097937247407*^9},
 CellLabel->
  "Out[149]=",ExpressionUUID->"5c41ce3a-aa7d-4bb0-a0bb-d7cf86fb333d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptF", "=", 
  RowBox[{"centerABE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x151", ".", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenAE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenAB"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.858785708664339*^9, 3.858785752208427*^9}, {
   3.858785901049223*^9, 3.8587859885123568`*^9}, {3.85878628204163*^9, 
   3.858786292089315*^9}, {3.858786357153858*^9, 3.858786360769568*^9}, {
   3.858786421793996*^9, 3.858786495154055*^9}, {3.8587867030365143`*^9, 
   3.858786704658731*^9}, {3.858788182793332*^9, 3.858788194031535*^9}, 
   3.858788246343902*^9, 3.859027669840116*^9, {3.859042382319257*^9, 
   3.8590423832220087`*^9}, 3.8590426501198273`*^9, {3.859044752350841*^9, 
   3.859044753373679*^9}, {3.859044924479558*^9, 3.859044924734539*^9}, 
   3.8590449623833027`*^9},
 CellLabel->
  "In[150]:=",ExpressionUUID->"29c8b74f-cea6-40bc-a8f2-eccac2e3f312"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "-", 
       RowBox[{"2", " ", "c"}]}], ")"}], "2"], " ", 
    SuperscriptBox["c", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "-", 
       RowBox[{"2", " ", "c"}]}], ")"}], "2"], " ", 
    SuperscriptBox["c", "8"]}], ",", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "-", 
       RowBox[{"2", " ", "c"}]}], ")"}], "2"], " ", 
    SuperscriptBox["c", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8587864233685513`*^9, {3.8587864696808767`*^9, 3.858786496037889*^9}, 
   3.8587867069184437`*^9, 3.858786755813157*^9, 3.8587870936108103`*^9, 
   3.8587882474445353`*^9, 3.859026189973741*^9, 3.859027670500546*^9, 
   3.8590423848575172`*^9, 3.859042650686679*^9, 3.8590447547233887`*^9, 
   3.859044925845641*^9, 3.859044963575554*^9, 3.859909416591305*^9, 
   3.861097937297393*^9},
 CellLabel->
  "Out[150]=",ExpressionUUID->"d181f1b7-8fa8-44b4-ab65-6e1e86a9fcf1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptG", "=", 
  RowBox[{"centerBCE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x151", ".", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenCE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenBC"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8587865148663816`*^9, 3.858786564610229*^9}, {
   3.8587866148666897`*^9, 3.858786628154747*^9}, {3.858788263305393*^9, 
   3.858788287137041*^9}, 3.859027676232143*^9, {3.859042391407422*^9, 
   3.859042391830041*^9}, 3.859042654781164*^9, {3.859044768519006*^9, 
   3.859044769565692*^9}, {3.8590449338556967`*^9, 3.859044934102459*^9}, 
   3.8590449728554173`*^9},
 CellLabel->
  "In[151]:=",ExpressionUUID->"60a601be-16c4-4424-8e43-89317be7d95b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "8"], " ", 
    SuperscriptBox["a", "6"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a"}], "+", "b"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    SuperscriptBox["a", "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a"}], "+", "b"}], ")"}], "2"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "8"]}], " ", 
    SuperscriptBox["a", "6"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a"}], "+", "b"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.858788288448888*^9, 3.8590261899851227`*^9, 
  3.859027677347439*^9, 3.859042393161137*^9, 3.8590426552914457`*^9, 
  3.859044770167042*^9, 3.859044935200601*^9, 3.8590449743495827`*^9, 
  3.859909416639144*^9, 3.861097937343318*^9},
 CellLabel->
  "Out[151]=",ExpressionUUID->"0b9337f4-63e1-4683-9a32-bbd06cbeef36"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"baryArea", "[", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "+", 
     RowBox[{"c", "^", "2"}]}], "\[Equal]", 
    RowBox[{"b", "^", "2"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.858786777987032*^9, 3.858786801250679*^9}, {
  3.858788317610319*^9, 3.85878834253583*^9}},
 CellLabel->
  "In[152]:=",ExpressionUUID->"b05f1a13-aa8f-4b2a-a3b0-fec484c9f1be"],

Cell[BoxData["K"], "Output",
 CellChangeTimes->{{3.858786793627717*^9, 3.8587868022970963`*^9}, 
   3.8587882951268663`*^9, 3.858788343593449*^9, 3.859026190074284*^9, 
   3.859027688655547*^9, 3.859042401266765*^9, 3.859042659120059*^9, 
   3.859044782025463*^9, 3.859044938329708*^9, 3.859044978714787*^9, 
   3.8599094166876593`*^9, 3.861097937391889*^9},
 CellLabel->
  "Out[152]=",ExpressionUUID->"4bde0875-9159-48d6-b46e-c4e9b9c0f064"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Theorem 7.32 for X(152)", "Subsubsection",
 CellChangeTimes->{{3.8590267048883963`*^9, 3.859026727459972*^9}, 
   3.8590276561031523`*^9, {3.859042356310068*^9, 3.859042356790008*^9}, 
   3.8590426390870533`*^9, {3.8590447361657467`*^9, 3.859044737189307*^9}, {
   3.859044910742312*^9, 3.859044911045905*^9}, 3.859044985718574*^9, 
   3.861090160675356*^9, 
   3.861092214808617*^9},ExpressionUUID->"466f562e-5536-4cb7-ae0d-\
23406d1e39ca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x152", "=", 
  RowBox[{"ETC1", "[", 
   RowBox[{"[", 
    RowBox[{"152", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.858786060921858*^9, 3.858786181361096*^9}, {
  3.8587863905711937`*^9, 3.858786410594088*^9}, {3.8587881675849857`*^9, 
  3.8587881747443943`*^9}, {3.8590276603278913`*^9, 3.859027662646915*^9}, {
  3.859042362414756*^9, 3.859042368246148*^9}, {3.8590426420638123`*^9, 
  3.859042644462646*^9}, {3.859044740382359*^9, 3.8590447452773867`*^9}, {
  3.85904491431075*^9, 3.859044918878051*^9}, {3.859044988014936*^9, 
  3.859044990414597*^9}},
 CellLabel->
  "In[153]:=",ExpressionUUID->"d14e7844-35ac-472d-9a53-13e50aeecddb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "8"], "-", 
    RowBox[{
     SuperscriptBox["a", "7"], " ", "b"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "5"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "6"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "7"]}], "-", 
    SuperscriptBox["b", "8"], "-", 
    RowBox[{
     SuperscriptBox["a", "7"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["a", "6"], " ", "b", " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"], " ", "c"}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "6"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["b", "7"], " ", "c"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"3", " ", "a", " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"3", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"3", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{"3", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "6"]}], "-", 
    RowBox[{"a", " ", "b", " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "7"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "7"]}], "-", 
    SuperscriptBox["c", "8"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "8"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "7"], " ", "b"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "3"]}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "5"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "6"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "7"]}], "+", 
    SuperscriptBox["b", "8"], "+", 
    RowBox[{
     SuperscriptBox["a", "7"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["a", "6"], " ", "b", " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"], " ", "c"}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "6"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["b", "7"], " ", "c"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "5"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "5"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "6"]}], "-", 
    RowBox[{"a", " ", "b", " ", 
     SuperscriptBox["c", "6"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "7"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "7"]}], "-", 
    SuperscriptBox["c", "8"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "8"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "7"], " ", "b"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "3"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "4"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "5"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "6"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "7"]}], "-", 
    SuperscriptBox["b", "8"], "+", 
    RowBox[{
     SuperscriptBox["a", "7"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["a", "6"], " ", "b", " ", "c"}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c"}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"], " ", "c"}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "6"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["b", "7"], " ", "c"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "5"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "5"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "5"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{"a", " ", "b", " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "6"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "7"]}], "-", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "7"]}], "+", 
    SuperscriptBox["c", "8"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8587881756168213`*^9, 3.85902618993408*^9, 
  3.859027663621985*^9, 3.8590423702523117`*^9, 3.859042645706134*^9, 
  3.8590447458071947`*^9, 3.8590449199286747`*^9, 3.859044991366724*^9, 
  3.859909416707922*^9, 3.861097937408841*^9},
 CellLabel->
  "Out[153]=",ExpressionUUID->"2528f025-4cc3-4d61-b483-de03827dafa4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptF", "=", 
  RowBox[{"centerABE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x152", ".", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenAE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenAB"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.858785708664339*^9, 3.858785752208427*^9}, {
   3.858785901049223*^9, 3.8587859885123568`*^9}, {3.85878628204163*^9, 
   3.858786292089315*^9}, {3.858786357153858*^9, 3.858786360769568*^9}, {
   3.858786421793996*^9, 3.858786495154055*^9}, {3.8587867030365143`*^9, 
   3.858786704658731*^9}, {3.858788182793332*^9, 3.858788194031535*^9}, 
   3.858788246343902*^9, 3.859027669840116*^9, {3.859042382319257*^9, 
   3.8590423832220087`*^9}, 3.8590426501198273`*^9, {3.859044752350841*^9, 
   3.859044753373679*^9}, {3.859044924479558*^9, 3.859044924734539*^9}, 
   3.8590449967435837`*^9},
 CellLabel->
  "In[154]:=",ExpressionUUID->"e1e660c3-c3ac-4b1c-a8d9-60c4a6414016"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "-", 
       RowBox[{"2", " ", "c"}]}], ")"}], "2"], " ", 
    SuperscriptBox["c", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "-", 
       RowBox[{"2", " ", "c"}]}], ")"}], "2"], " ", 
    SuperscriptBox["c", "6"]}], ",", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "-", 
       RowBox[{"2", " ", "c"}]}], ")"}], "2"], " ", 
    SuperscriptBox["c", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8587864233685513`*^9, {3.8587864696808767`*^9, 3.858786496037889*^9}, 
   3.8587867069184437`*^9, 3.858786755813157*^9, 3.8587870936108103`*^9, 
   3.8587882474445353`*^9, 3.859026189973741*^9, 3.859027670500546*^9, 
   3.8590423848575172`*^9, 3.859042650686679*^9, 3.8590447547233887`*^9, 
   3.859044925845641*^9, 3.859044998187661*^9, 3.859909416756754*^9, 
   3.861097937453761*^9},
 CellLabel->
  "Out[154]=",ExpressionUUID->"af9c21b9-2589-49e2-997f-21977f144425"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptG", "=", 
  RowBox[{"centerBCE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x152", ".", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenCE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenBC"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8587865148663816`*^9, 3.858786564610229*^9}, {
   3.8587866148666897`*^9, 3.858786628154747*^9}, {3.858788263305393*^9, 
   3.858788287137041*^9}, 3.859027676232143*^9, {3.859042391407422*^9, 
   3.859042391830041*^9}, 3.859042654781164*^9, {3.859044768519006*^9, 
   3.859044769565692*^9}, {3.8590449338556967`*^9, 3.859044934102459*^9}, 
   3.859045001871667*^9},
 CellLabel->
  "In[155]:=",ExpressionUUID->"5063e10a-f0aa-4fd4-a02c-bb212c54480e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "8"], " ", 
    SuperscriptBox["a", "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a"}], "+", "b"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    SuperscriptBox["a", "6"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a"}], "+", "b"}], ")"}], "2"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "8"]}], " ", 
    SuperscriptBox["a", "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a"}], "+", "b"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.858788288448888*^9, 3.8590261899851227`*^9, 
  3.859027677347439*^9, 3.859042393161137*^9, 3.8590426552914457`*^9, 
  3.859044770167042*^9, 3.859044935200601*^9, 3.8590450025055027`*^9, 
  3.8599094168062897`*^9, 3.861097937520245*^9},
 CellLabel->
  "Out[155]=",ExpressionUUID->"7057ec0e-be55-468c-8e15-2980d89dce8f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"baryArea", "[", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "+", 
     RowBox[{"c", "^", "2"}]}], "\[Equal]", 
    RowBox[{"b", "^", "2"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.858786777987032*^9, 3.858786801250679*^9}, {
  3.858788317610319*^9, 3.85878834253583*^9}},
 CellLabel->
  "In[156]:=",ExpressionUUID->"540a1099-2a15-496a-ab97-08ff57296ddd"],

Cell[BoxData["K"], "Output",
 CellChangeTimes->{{3.858786793627717*^9, 3.8587868022970963`*^9}, 
   3.8587882951268663`*^9, 3.858788343593449*^9, 3.859026190074284*^9, 
   3.859027688655547*^9, 3.859042401266765*^9, 3.859042659120059*^9, 
   3.859044782025463*^9, 3.859044938329708*^9, 3.859045007078032*^9, 
   3.859909416820175*^9, 3.86109793756748*^9},
 CellLabel->
  "Out[156]=",ExpressionUUID->"49a3d817-be8d-44c2-acd1-acdaeb205621"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Theorem 7.32 for X(153)", "Subsubsection",
 CellChangeTimes->{{3.8590267048883963`*^9, 3.859026727459972*^9}, 
   3.8590276561031523`*^9, {3.859042356310068*^9, 3.859042356790008*^9}, 
   3.8590426390870533`*^9, {3.8590447361657467`*^9, 3.859044737189307*^9}, {
   3.859044910742312*^9, 3.859044911045905*^9}, 3.859045018758669*^9, 
   3.861090164603449*^9, 
   3.861092216168879*^9},ExpressionUUID->"2136fb2c-be89-435e-b259-\
eb87f4c72114"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x153", "=", 
  RowBox[{"ETC1", "[", 
   RowBox[{"[", 
    RowBox[{"153", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.858786060921858*^9, 3.858786181361096*^9}, {
  3.8587863905711937`*^9, 3.858786410594088*^9}, {3.8587881675849857`*^9, 
  3.8587881747443943`*^9}, {3.8590276603278913`*^9, 3.859027662646915*^9}, {
  3.859042362414756*^9, 3.859042368246148*^9}, {3.8590426420638123`*^9, 
  3.859042644462646*^9}, {3.859044740382359*^9, 3.8590447452773867`*^9}, {
  3.85904491431075*^9, 3.859044918878051*^9}, {3.85904502149552*^9, 
  3.8590450236146173`*^9}},
 CellLabel->
  "In[157]:=",ExpressionUUID->"f1817b25-1fb6-4c7b-b6cb-39830d90a507"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "7"], "-", 
    RowBox[{
     SuperscriptBox["a", "6"], " ", "b"}], "-", 
    RowBox[{
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "6"]}], "-", 
    SuperscriptBox["b", "7"], "-", 
    RowBox[{
     SuperscriptBox["a", "6"], " ", "c"}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c"}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c"}], "-", 
    RowBox[{"5", " ", "a", " ", 
     SuperscriptBox["b", "5"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["b", "6"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"10", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{"5", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "5"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "5"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "6"]}], "-", 
    SuperscriptBox["c", "7"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "7"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "6"], " ", "b"}], "+", 
    RowBox[{
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "6"]}], "+", 
    SuperscriptBox["b", "7"], "+", 
    RowBox[{
     SuperscriptBox["a", "6"], " ", "c"}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c"}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c"}], "+", 
    RowBox[{"7", " ", "a", " ", 
     SuperscriptBox["b", "5"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["b", "6"], " ", "c"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"5", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"5", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{"5", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "5"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "5"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "6"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "6"]}], "-", 
    SuperscriptBox["c", "7"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "7"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "6"], " ", "b"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "6"]}], "-", 
    SuperscriptBox["b", "7"], "+", 
    RowBox[{
     SuperscriptBox["a", "6"], " ", "c"}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c"}], "-", 
    RowBox[{"5", " ", "a", " ", 
     SuperscriptBox["b", "5"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["b", "6"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"5", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{"5", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "4"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "5"]}], "+", 
    RowBox[{"7", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "5"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "6"]}], "-", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "6"]}], "+", 
    SuperscriptBox["c", "7"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8587881756168213`*^9, 3.85902618993408*^9, 
  3.859027663621985*^9, 3.8590423702523117`*^9, 3.859042645706134*^9, 
  3.8590447458071947`*^9, 3.8590449199286747`*^9, 3.8590450244492807`*^9, 
  3.859909416869396*^9, 3.861097937584326*^9},
 CellLabel->
  "Out[157]=",ExpressionUUID->"12b6bd83-3453-4163-aa35-e60152f99337"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptF", "=", 
  RowBox[{"centerABE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x153", ".", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenAE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenAB"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.858785708664339*^9, 3.858785752208427*^9}, {
   3.858785901049223*^9, 3.8587859885123568`*^9}, {3.85878628204163*^9, 
   3.858786292089315*^9}, {3.858786357153858*^9, 3.858786360769568*^9}, {
   3.858786421793996*^9, 3.858786495154055*^9}, {3.8587867030365143`*^9, 
   3.858786704658731*^9}, {3.858788182793332*^9, 3.858788194031535*^9}, 
   3.858788246343902*^9, 3.859027669840116*^9, {3.859042382319257*^9, 
   3.8590423832220087`*^9}, 3.8590426501198273`*^9, {3.859044752350841*^9, 
   3.859044753373679*^9}, {3.859044924479558*^9, 3.859044924734539*^9}, 
   3.8590450292155533`*^9},
 CellLabel->
  "In[158]:=",ExpressionUUID->"66420ba0-ed48-4e4c-9e0e-333e071ac3a1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "-", 
       RowBox[{"2", " ", "c"}]}], ")"}], "2"], " ", 
    SuperscriptBox["c", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "-", 
       RowBox[{"2", " ", "c"}]}], ")"}], "2"], " ", 
    SuperscriptBox["c", "5"]}], ",", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "-", 
       RowBox[{"2", " ", "c"}]}], ")"}], "2"], " ", 
    SuperscriptBox["c", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8587864233685513`*^9, {3.8587864696808767`*^9, 3.858786496037889*^9}, 
   3.8587867069184437`*^9, 3.858786755813157*^9, 3.8587870936108103`*^9, 
   3.8587882474445353`*^9, 3.859026189973741*^9, 3.859027670500546*^9, 
   3.8590423848575172`*^9, 3.859042650686679*^9, 3.8590447547233887`*^9, 
   3.859044925845641*^9, 3.859045030009522*^9, 3.85990941691296*^9, 
   3.86109793763104*^9},
 CellLabel->
  "Out[158]=",ExpressionUUID->"8686ea5a-12fa-45c1-a9b9-0af3f5cec659"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptG", "=", 
  RowBox[{"centerBCE", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"x153", ".", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenCE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenBC"}], ",", 
       RowBox[{"S", "\[Rule]", 
        RowBox[{"a", " ", 
         RowBox[{"c", "/", "2"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8587865148663816`*^9, 3.858786564610229*^9}, {
   3.8587866148666897`*^9, 3.858786628154747*^9}, {3.858788263305393*^9, 
   3.858788287137041*^9}, 3.859027676232143*^9, {3.859042391407422*^9, 
   3.859042391830041*^9}, 3.859042654781164*^9, {3.859044768519006*^9, 
   3.859044769565692*^9}, {3.8590449338556967`*^9, 3.859044934102459*^9}, 
   3.859045033039527*^9},
 CellLabel->
  "In[159]:=",ExpressionUUID->"83c5d417-a304-4a50-8b97-89f31c4eb412"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "8"], " ", 
    SuperscriptBox["a", "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a"}], "+", "b"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    SuperscriptBox["a", "5"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a"}], "+", "b"}], ")"}], "2"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "8"]}], " ", 
    SuperscriptBox["a", "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a"}], "+", "b"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.858788288448888*^9, 3.8590261899851227`*^9, 
  3.859027677347439*^9, 3.859042393161137*^9, 3.8590426552914457`*^9, 
  3.859044770167042*^9, 3.859044935200601*^9, 3.859045033667819*^9, 
  3.8599094169845047`*^9, 3.861097937678585*^9},
 CellLabel->
  "Out[159]=",ExpressionUUID->"db88960a-b462-4275-b969-2342ffb2ea41"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"baryArea", "[", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "+", 
     RowBox[{"c", "^", "2"}]}], "\[Equal]", 
    RowBox[{"b", "^", "2"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.858786777987032*^9, 3.858786801250679*^9}, {
  3.858788317610319*^9, 3.85878834253583*^9}},
 CellLabel->
  "In[160]:=",ExpressionUUID->"2d1b1e62-37f7-4ba7-bb12-a8f968cf0176"],

Cell[BoxData["K"], "Output",
 CellChangeTimes->{{3.858786793627717*^9, 3.8587868022970963`*^9}, 
   3.8587882951268663`*^9, 3.858788343593449*^9, 3.859026190074284*^9, 
   3.859027688655547*^9, 3.859042401266765*^9, 3.859042659120059*^9, 
   3.859044782025463*^9, 3.859044938329708*^9, 3.859045036750456*^9, 
   3.859909417085133*^9, 3.8610979377250566`*^9},
 CellLabel->
  "Out[160]=",ExpressionUUID->"c14a3478-16de-405e-8bbe-330fbf4628a1"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Squares", "Subsection",
 CellChangeTimes->{{3.8594059038583107`*^9, 
  3.859405913483205*^9}},ExpressionUUID->"806362de-4648-42d4-b529-\
fe243a62ed6f"],

Cell[CellGroupData[{

Cell["miscellaneous", "Subsubsection",
 CellChangeTimes->{{3.859406031346599*^9, 3.859406037971991*^9}, {
  3.861092021016653*^9, 
  3.8610920248962107`*^9}},ExpressionUUID->"4a77c34f-b15c-4e24-bf4f-\
85b2f82558c7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"coincidesWithM", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"onLineAtInfinity", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"atInfinitWhenIsosceles", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"transcendental", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coincidesWithA", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coincidesWithAsq", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coincidesWithMsq", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"atInfinitWhenSquare", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rational", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"squareRational", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptA", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptM", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"n", "=", "1"}], ",", 
    RowBox[{"n", "\[LessEqual]", "1000"}], ",", 
    RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<n=\>\"", ",", "n"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"coords", "=", 
      RowBox[{"ETC1", "[", 
       RowBox[{"[", 
        RowBox[{"n", ",", "2"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"ignore", " ", "transcendental", " ", "centers"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"coords", "\[Equal]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"transcendental", ",", "n"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Continue", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u", ",", "v", ",", "w"}], "}"}], "=", 
      RowBox[{"ptX", "=", 
       RowBox[{"coords", "/.", 
        RowBox[{"S", "->", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]]}]}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"ignore", " ", "points", " ", "at", " ", "infinity"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Expand", "[", 
         RowBox[{"u", "+", "v", "+", "w"}], "]"}], "\[Equal]", "0"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"onLineAtInfinity", ",", "n"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Continue", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Expand", "[", 
         RowBox[{
          RowBox[{"u", "+", "v", "+", "w"}], "/.", 
          RowBox[{"c", "\[Rule]", "b"}]}], "]"}], "\[Equal]", "0"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"atInfinitWhenIsosceles", ",", "n"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Continue", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Expand", "[", 
         RowBox[{"u", "/.", 
          RowBox[{"c", "\[Rule]", "b"}]}], "]"}], "\[Equal]", "0"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"coincidesWithM", ",", "n"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Continue", "[", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"ratio", " ", "=", " ", 
       RowBox[{"XM", "/", "AM"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"ratio", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"u", "/", 
         RowBox[{"(", 
          RowBox[{"u", "+", 
           RowBox[{"2", "v"}]}], ")"}]}], "/.", 
        RowBox[{"c", "\[Rule]", "b"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"(*", " ", 
      RowBox[{
      "ignore", " ", "points", " ", "that", " ", "coincide", " ", "with", " ",
        "A"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ratio", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"coincidesWithA", ",", "n"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Continue", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"NumericQ", "[", "ratio", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<n=\>\"", ",", "n", ",", "\"\<   \>\"", ",", "ptX", ",", 
          "\"\<   XM/AM=\>\"", ",", 
          RowBox[{"Style", "[", 
           RowBox[{"ratio", ",", "Red"}], "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"rational", ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "ratio"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Continue", "[", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"ratio", "=", 
      RowBox[{
       RowBox[{"Simplify", "[", 
        RowBox[{"ratio", "/.", 
         RowBox[{"a", "\[Rule]", 
          RowBox[{"b", " ", 
           RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], "]"}], "//", "Quiet"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ratio", "===", "ComplexInfinity"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"atInfinitWhenSquare", ",", "n"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ratio", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"coincidesWithAsq", ",", "n"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Continue", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ratio", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"coincidesWithMsq", ",", "n"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Continue", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"NumericQ", "[", "ratio", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<n=\>\"", ",", "n", ",", "\"\<   \>\"", ",", "ptX", ",", 
          "\"\<   XM/AM=\>\"", ",", 
          RowBox[{"Style", "[", 
           RowBox[{"ratio", ",", "Blue"}], "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"squareRational", ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "ratio"}], "}"}]}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.85823859791429*^9, 3.85823861081002*^9}, {
   3.858238666170635*^9, 3.858238671842203*^9}, {3.8582387034349937`*^9, 
   3.858238879946652*^9}, {3.8582389657328787`*^9, 3.8582389797310667`*^9}, {
   3.8582392486772118`*^9, 3.8582392767083197`*^9}, {3.858239316526222*^9, 
   3.858239316940321*^9}, {3.8582393919104853`*^9, 3.858239410404519*^9}, {
   3.858331060436795*^9, 3.8583310835636053`*^9}, {3.8583311335560627`*^9, 
   3.8583312056613417`*^9}, {3.858331353269075*^9, 3.858331361757183*^9}, {
   3.85833142168615*^9, 3.858331476637041*^9}, {3.8583315261749496`*^9, 
   3.858331647885808*^9}, 3.858331679870125*^9, {3.858331841511511*^9, 
   3.858331889799799*^9}, {3.858331948776697*^9, 3.858331950886672*^9}, {
   3.858332138091186*^9, 3.858332168351516*^9}, {3.8583598800744762`*^9, 
   3.858359881256414*^9}, {3.8590572502474737`*^9, 3.859057297806314*^9}, {
   3.859057346582951*^9, 3.859057445855009*^9}, {3.859057654764593*^9, 
   3.859057672008007*^9}, {3.859057728585338*^9, 3.8590577494402647`*^9}, {
   3.8590578014496107`*^9, 3.859057898193756*^9}, {3.859057958193616*^9, 
   3.8590579702170258`*^9}, {3.8590580079943*^9, 3.859058022673209*^9}, {
   3.8590581266503973`*^9, 3.8590581393538837`*^9}, {3.8591099751016607`*^9, 
   3.859110043172707*^9}, {3.859110184262834*^9, 3.8591102137013683`*^9}, {
   3.859110250494644*^9, 3.8591102538301773`*^9}, {3.859110286463319*^9, 
   3.859110291237661*^9}},
 CellLabel->
  "In[161]:=",ExpressionUUID->"1f601afd-4d8e-4850-b494-11213f28173a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["n=", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938598386*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"424ce6a4-95f1-47b7-8e19-66a703bf6195"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox["2"]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 1, "   ", {$CellContext`a, $CellContext`b, $CellContext`c}, 
   "   XM/AM=", 
   Style[-1 + 2^Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938599234*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"60806bc5-1385-463e-a1f0-4aea5b859fee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["n=", 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938602477*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"123efc4d-4e24-4ed1-a68a-c3368021f9c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", "3"],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm["n=", 2, "   ", {1, 1, 1}, "   XM/AM=", 
   Style[
    Rational[1, 3], 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938603581*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"03483b21-8a72-488f-98b7-05668a04a6eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["n=", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386047277`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"8fba131c-c01c-4fea-bb16-346769de3710"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm["n=", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386057568`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"503c6680-ab2a-415f-8cbe-c5b6dc0ab9a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm["n=", 5],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386068773`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"e2581352-7979-43cc-acf2-7a74f222ca66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", "2"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 5, "   ", {-$CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - \
$CellContext`a^2 $CellContext`c^2 - 
    2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4, $CellContext`a^4 - \
$CellContext`a^2 $CellContext`b^2 - 
    2 $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 + \
$CellContext`c^4, $CellContext`a^4 - 
    2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - $CellContext`a^2 \
$CellContext`c^2 - $CellContext`b^2 $CellContext`c^2}, "   XM/AM=", 
   Style[
    Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938608412*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f72b230d-4ac2-4bb8-8e17-3ef4e7cee6f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "6"}],
  SequenceForm["n=", 6],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938610093*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"8d1aa0f5-297a-44e3-90e9-3c4bad27e0c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["a", "2"], ",", 
     SuperscriptBox["b", "2"], ",", 
     SuperscriptBox["c", "2"]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", "2"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 6, "   ", {$CellContext`a^2, $CellContext`b^2, $CellContext`c^2}, 
   "   XM/AM=", 
   Style[
    Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938611253*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"8fe7e7f1-9cf1-43e9-9358-9003087bf803"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "7"}],
  SequenceForm["n=", 7],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386123543`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"e65c35d1-533a-454d-a209-0998daece8a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "7"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 7, "   ", {($CellContext`a + $CellContext`b - $CellContext`c) \
($CellContext`a - $CellContext`b + $CellContext`c), ($CellContext`a + \
$CellContext`b - $CellContext`c) (-$CellContext`a + $CellContext`b + \
$CellContext`c), ($CellContext`a - $CellContext`b + $CellContext`c) \
(-$CellContext`a + $CellContext`b + $CellContext`c)}, "   XM/AM=", 
   Style[Rational[1, 7] (1 + 2 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938613586*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"3618a02c-e427-4d30-9a31-5a2ef850aa71"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "8"}],
  SequenceForm["n=", 8],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386148643`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"088037b8-00f7-4d41-a7e5-ef32c71a7622"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "-", "b", "-", "c"}], ",", 
     RowBox[{
      RowBox[{"-", "a"}], "+", "b", "-", "c"}], ",", 
     RowBox[{
      RowBox[{"-", "a"}], "-", "b", "+", "c"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"3", "-", 
     RowBox[{"2", " ", 
      SqrtBox["2"]}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 8, "   ", {$CellContext`a - $CellContext`b - $CellContext`c, \
-$CellContext`a + $CellContext`b - $CellContext`c, -$CellContext`a - \
$CellContext`b + $CellContext`c}, "   XM/AM=", 
   Style[3 - 2 2^Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109793861614*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"cbe9f8b3-acf8-41af-8c4a-cf2e615788f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "9"}],
  SequenceForm["n=", 9],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938617442*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"61db27b9-6bf5-452b-a82c-e1aaa20c9b82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "-", "c"}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "-", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "7"], " ", 
     RowBox[{"(", 
      RowBox[{"3", "-", 
       SqrtBox["2"]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 9, "   ", {$CellContext`a ($CellContext`a - $CellContext`b - \
$CellContext`c), $CellContext`b (-$CellContext`a + $CellContext`b - \
$CellContext`c), $CellContext`c (-$CellContext`a - $CellContext`b + \
$CellContext`c)}, "   XM/AM=", 
   Style[Rational[1, 7] (3 - 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938618684*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"98874294-390d-4452-b9cf-88b3f2a37fb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "10"}],
  SequenceForm["n=", 10],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386199703`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"7ccffebb-0dc3-40e1-925e-de18c0f66b2a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "+", "c"}], ",", 
     RowBox[{"a", "+", "c"}], ",", 
     RowBox[{"a", "+", "b"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", 
     RowBox[{"2", "+", 
      SqrtBox["2"]}]],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 10, 
   "   ", {$CellContext`b + $CellContext`c, $CellContext`a + $CellContext`c, \
$CellContext`a + $CellContext`b}, "   XM/AM=", 
   Style[(2 + 2^Rational[1, 2])^(-1), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938621379*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"7d9dac93-17ee-4ecf-8be0-978697c1df1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "11"}],
  SequenceForm["n=", 11],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938622525*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"5d0a3600-bf7a-4450-91fa-b7cb3ae908d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "12"}],
  SequenceForm["n=", 12],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386235*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"522ca8f1-448b-44e9-b728-e709e9f21955"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     RowBox[{"-", 
      FractionBox["2", "7"]}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", 
       SqrtBox["2"]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 12, 
   "   ", {($CellContext`a + $CellContext`b - $CellContext`c) ($CellContext`a - \
$CellContext`b + $CellContext`c) ($CellContext`b + $CellContext`c)^2, \
($CellContext`a + $CellContext`b - $CellContext`c) ($CellContext`a + \
$CellContext`c)^2 (-$CellContext`a + $CellContext`b + $CellContext`c), \
($CellContext`a + $CellContext`b)^2 ($CellContext`a - $CellContext`b + \
$CellContext`c) (-$CellContext`a + $CellContext`b + $CellContext`c)}, 
   "   XM/AM=", 
   Style[Rational[-2, 7] (-3 + 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386248083`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"b549daf0-08d8-47d7-a1c8-d9e765e8de4b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "13"}],
  SequenceForm["n=", 13],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386261044`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"7a1a6c72-7e96-4b20-82f6-a7a164dba007"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "14"}],
  SequenceForm["n=", 14],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938627101*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"578f01aa-4746-4c9d-8c9b-48c9376ae058"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "15"}],
  SequenceForm["n=", 15],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386280947`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"79d028cc-b52d-41d6-8d52-0eb84b8298e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "16"}],
  SequenceForm["n=", 16],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938629084*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"c7a1bc50-db15-4a76-8405-92d05f944943"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "17"}],
  SequenceForm["n=", 17],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386300583`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"e9ab77c7-1a97-4d98-8594-eb71f0819bef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "18"}],
  SequenceForm["n=", 18],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938631028*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a8867059-2695-41ac-aa78-5367a11adbe3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "19"}],
  SequenceForm["n=", 19],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938631999*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"1617dc21-353c-411a-a326-917399ac1afc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "20"}],
  SequenceForm["n=", 20],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938632963*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"13f4af50-99d9-4cbe-a5c4-fd882717b5f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "4"]}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 20, "   ", {
   3 $CellContext`a^4 - 
    2 $CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 - 
    2 $CellContext`a^2 $CellContext`c^2 + 
    2 $CellContext`b^2 $CellContext`c^2 - $CellContext`c^4, -$CellContext`a^4 - 
    2 $CellContext`a^2 $CellContext`b^2 + 3 $CellContext`b^4 + 
    2 $CellContext`a^2 $CellContext`c^2 - 
    2 $CellContext`b^2 $CellContext`c^2 - $CellContext`c^4, -$CellContext`a^4 + 
    2 $CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 - 
    2 $CellContext`a^2 $CellContext`c^2 - 2 $CellContext`b^2 $CellContext`c^2 + 
    3 $CellContext`c^4}, "   XM/AM=", 
   Style[-1, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938634486*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"8d0346e3-8a40-4d0a-84c2-69f74c6432ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "21"}],
  SequenceForm["n=", 21],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386358137`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"0dc35bcc-93df-49cf-a863-e3170efefa14"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "7"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 21, 
   "   ", {$CellContext`a ($CellContext`a + $CellContext`b) ($CellContext`a - \
$CellContext`b - $CellContext`c) ($CellContext`a + $CellContext`c), \
$CellContext`b ($CellContext`a + $CellContext`b) (-$CellContext`a + \
$CellContext`b - $CellContext`c) ($CellContext`b + $CellContext`c), \
$CellContext`c ($CellContext`a + $CellContext`c) (-$CellContext`a - \
$CellContext`b + $CellContext`c) ($CellContext`b + $CellContext`c)}, 
   "   XM/AM=", 
   Style[Rational[1, 7] (-1 + 2 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938637083*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"2dec7cec-30c2-42ce-9daf-c9c2789a6649"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "22"}],
  SequenceForm["n=", 22],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938638296*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"79e75b8a-24bc-4c92-9158-c5305f8058bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        SuperscriptBox["b", "4"], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 22, 
   "   ", {$CellContext`a^2 ($CellContext`a^4 - $CellContext`b^4 - \
$CellContext`c^4), $CellContext`b^2 (-$CellContext`a^4 + $CellContext`b^4 - \
$CellContext`c^4), $CellContext`c^2 (-$CellContext`a^4 - $CellContext`b^4 + \
$CellContext`c^4)}, "   XM/AM=", 
   Style[-1, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938639472*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"2c107739-1e8b-456f-9b01-1df245c63963"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "23"}],
  SequenceForm["n=", 23],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938640635*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"8a542d14-967e-4fc4-8bb3-97f63042f55a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox["3",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 23, 
   "   ", {$CellContext`a^2 ($CellContext`a^4 - $CellContext`b^4 + \
$CellContext`b^2 $CellContext`c^2 - $CellContext`c^4), $CellContext`b^2 \
(-$CellContext`a^4 + $CellContext`b^4 + $CellContext`a^2 $CellContext`c^2 - \
$CellContext`c^4), $CellContext`c^2 (-$CellContext`a^4 + $CellContext`a^2 \
$CellContext`b^2 - $CellContext`b^4 + $CellContext`c^4)}, "   XM/AM=", 
   Style[3, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938641939*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"0d4e7760-8044-4d3f-97a1-79831009e668"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "24"}],
  SequenceForm["n=", 24],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938643276*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"c9f17cfa-937a-4fa8-96c1-acbd80e09968"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "25"}],
  SequenceForm["n=", 25],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938644392*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"269cd1bc-97d5-4665-a87f-d27ec35deace"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "26"}],
  SequenceForm["n=", 26],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109793864564*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"d2036a4c-0252-4a57-8a69-bf2d998f3aa1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "27"}],
  SequenceForm["n=", 27],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938646777*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"932643cb-fd58-4e7d-b155-34cf5ed7446f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "28"}],
  SequenceForm["n=", 28],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938647773*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"18f3c47b-2204-4818-91bf-8f9c53b40e27"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "29"}],
  SequenceForm["n=", 29],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386489*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"02f414cb-42d5-4267-ae94-c9bbb8762b1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "30"}],
  SequenceForm["n=", 30],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938650053*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f0b52c3f-eb4e-4247-8e56-9df74d2449e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "31"}],
  SequenceForm["n=", 31],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938651396*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"5fad6241-a2e4-40fd-84d8-3d7b1a8bc877"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["a", "3"], ",", 
     SuperscriptBox["b", "3"], ",", 
     SuperscriptBox["c", "3"]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"2", "-", 
     SqrtBox["2"]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 31, "   ", {$CellContext`a^3, $CellContext`b^3, $CellContext`c^3}, 
   "   XM/AM=", 
   Style[2 - 2^Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386528063`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"e2ea7745-681e-4626-92a8-58779ca92c99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "32"}],
  SequenceForm["n=", 32],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386540537`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a2e647c3-29b7-420a-a5fa-5c5085ec8575"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["a", "4"], ",", 
     SuperscriptBox["b", "4"], ",", 
     SuperscriptBox["c", "4"]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["2", "3"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 32, "   ", {$CellContext`a^4, $CellContext`b^4, $CellContext`c^4}, 
   "   XM/AM=", 
   Style[
    Rational[2, 3], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938655267*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f3a82601-a615-4123-beb4-a10ddaa3b8b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "33"}],
  SequenceForm["n=", 33],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938656707*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"9edb0959-833b-4b22-a956-fe5c0965d065"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "34"}],
  SequenceForm["n=", 34],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938658222*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"ab9d527c-37a7-4089-be3e-9b708d172af4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "35"}],
  SequenceForm["n=", 35],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938659486*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"fb9f1969-bff1-467c-99b8-3c19e9b32ec9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "35", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"b", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"a", " ", "b"}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "7"], " ", 
     RowBox[{"(", 
      RowBox[{"3", "-", 
       SqrtBox["2"]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 35, 
   "   ", {$CellContext`a^2 ($CellContext`a^2 - $CellContext`b^2 - \
$CellContext`b $CellContext`c - $CellContext`c^2), $CellContext`b^2 \
(-$CellContext`a^2 + $CellContext`b^2 - $CellContext`a $CellContext`c - \
$CellContext`c^2), $CellContext`c^2 (-$CellContext`a^2 - $CellContext`a \
$CellContext`b - $CellContext`b^2 + $CellContext`c^2)}, "   XM/AM=", 
   Style[Rational[1, 7] (3 - 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109793866082*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"2b917bd2-3a69-4316-9eee-eea3b3edee17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "36"}],
  SequenceForm["n=", 36],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938662094*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"cc46c660-5745-432e-8c1f-22d61915008b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{"a", " ", "b"}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"1", "+", 
     SqrtBox["2"]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 36, 
   "   ", {$CellContext`a^2 ($CellContext`a^2 - $CellContext`b^2 + \
$CellContext`b $CellContext`c - $CellContext`c^2), $CellContext`b^2 \
(-$CellContext`a^2 + $CellContext`b^2 + $CellContext`a $CellContext`c - \
$CellContext`c^2), $CellContext`c^2 (-$CellContext`a^2 + $CellContext`a \
$CellContext`b - $CellContext`b^2 + $CellContext`c^2)}, "   XM/AM=", 
   Style[1 + 2^Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938663374*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"93c591f4-079e-4641-8b32-5b7cc15f3a63"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "37"}],
  SequenceForm["n=", 37],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109793866469*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"abf263e6-0f1f-474f-9ec3-65367f917cab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "37", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", "c"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "7"], " ", 
     RowBox[{"(", 
      RowBox[{"4", "-", 
       SqrtBox["2"]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 37, 
   "   ", {$CellContext`a ($CellContext`b + $CellContext`c), $CellContext`b \
($CellContext`a + $CellContext`c), ($CellContext`a + $CellContext`b) \
$CellContext`c}, "   XM/AM=", 
   Style[Rational[1, 7] (4 - 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386658792`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f3ea4a23-ae2a-4ea2-a897-0b1cb093ca34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "38"}],
  SequenceForm["n=", 38],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938667172*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"8c5ea486-a4ef-4d49-9f79-e2b0c91dbff6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "38", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", "c"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "7"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{"3", " ", 
        SqrtBox["2"]}]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 38, 
   "   ", {$CellContext`a ($CellContext`b^2 + $CellContext`c^2), \
$CellContext`b ($CellContext`a^2 + $CellContext`c^2), ($CellContext`a^2 + \
$CellContext`b^2) $CellContext`c}, "   XM/AM=", 
   Style[Rational[1, 7] (-2 + 3 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938668401*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"02f8bf6f-42f4-405d-93f9-b1fdf2185d3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "39"}],
  SequenceForm["n=", 39],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938669611*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f0e8cbf4-506c-4736-b6e4-82dc97f73d1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "39", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["2", "5"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 39, 
   "   ", {$CellContext`a^2 ($CellContext`b^2 + $CellContext`c^2), \
$CellContext`b^2 ($CellContext`a^2 + $CellContext`c^2), ($CellContext`a^2 + \
$CellContext`b^2) $CellContext`c^2}, "   XM/AM=", 
   Style[
    Rational[2, 5], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386708593`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"7358a143-133d-4032-a86c-6363af182125"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "40"}],
  SequenceForm["n=", 40],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938672076*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"0e1cf711-2e67-4770-8c28-1202039ffad0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "40", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"1", "-", 
     SqrtBox["2"]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 40, 
   "   ", {$CellContext`a ($CellContext`a^3 + $CellContext`a^2 $CellContext`b - \
$CellContext`a $CellContext`b^2 - $CellContext`b^3 + $CellContext`a^2 \
$CellContext`c - 
     2 $CellContext`a $CellContext`b $CellContext`c + $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 + $CellContext`b \
$CellContext`c^2 - $CellContext`c^3), $CellContext`b (-$CellContext`a^3 - \
$CellContext`a^2 $CellContext`b + $CellContext`a $CellContext`b^2 + \
$CellContext`b^3 + $CellContext`a^2 $CellContext`c - 
     2 $CellContext`a $CellContext`b $CellContext`c + $CellContext`b^2 \
$CellContext`c + $CellContext`a $CellContext`c^2 - $CellContext`b \
$CellContext`c^2 - $CellContext`c^3), $CellContext`c (-$CellContext`a^3 + \
$CellContext`a^2 $CellContext`b + $CellContext`a $CellContext`b^2 - \
$CellContext`b^3 - $CellContext`a^2 $CellContext`c - 
     2 $CellContext`a $CellContext`b $CellContext`c - $CellContext`b^2 \
$CellContext`c + $CellContext`a $CellContext`c^2 + $CellContext`b \
$CellContext`c^2 + $CellContext`c^3)}, "   XM/AM=", 
   Style[1 - 2^Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938673623*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"90eb361c-2578-4ebe-9e13-6495e01d02e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "41"}],
  SequenceForm["n=", 41],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938675042*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"2159859e-9223-4a18-b591-286f89d816f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "41", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "-", "c"}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "-", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "7"], " ", 
     RowBox[{"(", 
      RowBox[{"4", "-", 
       SqrtBox["2"]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 41, 
   "   ", {$CellContext`a^3 ($CellContext`a - $CellContext`b - \
$CellContext`c), $CellContext`b^3 (-$CellContext`a + $CellContext`b - \
$CellContext`c), $CellContext`c^3 (-$CellContext`a - $CellContext`b + \
$CellContext`c)}, "   XM/AM=", 
   Style[Rational[1, 7] (4 - 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386762877`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"03352f43-4c48-4a0a-941d-a078dd2ab482"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "42"}],
  SequenceForm["n=", 42],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938677518*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f10b31d4-2f23-4057-bd0d-01ff874a3ac9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "42", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["2", 
     RowBox[{"3", "+", 
      SqrtBox["2"]}]],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 42, 
   "   ", {$CellContext`a^2 ($CellContext`b + $CellContext`c), \
$CellContext`b^2 ($CellContext`a + $CellContext`c), ($CellContext`a + \
$CellContext`b) $CellContext`c^2}, "   XM/AM=", 
   Style[2/(3 + 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386787243`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"363fe076-c38a-4e45-905e-b2ecd398adf6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "43"}],
  SequenceForm["n=", 43],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386800127`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"fa35cff0-ac0b-4f06-8033-b499bb77f5f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "43", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "b"}], "+", 
        RowBox[{"a", " ", "c"}], "-", 
        RowBox[{"b", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "b"}], "-", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"b", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"b", " ", "c"}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "17"], " ", 
     RowBox[{"(", 
      RowBox[{"11", "-", 
       SqrtBox["2"]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 43, 
   "   ", {$CellContext`a ($CellContext`a $CellContext`b + $CellContext`a \
$CellContext`c - $CellContext`b $CellContext`c), $CellContext`b \
($CellContext`a $CellContext`b - $CellContext`a $CellContext`c + \
$CellContext`b $CellContext`c), $CellContext`c (-$CellContext`a \
$CellContext`b + $CellContext`a $CellContext`c + $CellContext`b \
$CellContext`c)}, "   XM/AM=", 
   Style[Rational[1, 17] (11 - 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938681294*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"22235675-479d-4a73-8c62-f13c9182469a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "44"}],
  SequenceForm["n=", 44],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938682535*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"4a3d5d03-77c8-4ee0-be20-71c2895f6280"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "44", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "-", "b", "-", "c"}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", 
        RowBox[{"2", " ", "b"}], "-", "c"}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "-", "b", "+", 
        RowBox[{"2", " ", "c"}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"2", "+", 
     SqrtBox["2"]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 44, 
   "   ", {$CellContext`a (
     2 $CellContext`a - $CellContext`b - $CellContext`c), $CellContext`b \
(-$CellContext`a + 
     2 $CellContext`b - $CellContext`c), $CellContext`c (-$CellContext`a - \
$CellContext`b + 2 $CellContext`c)}, "   XM/AM=", 
   Style[2 + 2^Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938683769*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"16cc39b8-1a6f-4bec-bce7-d4c090f9476d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "45"}],
  SequenceForm["n=", 45],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938685025*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"8dd6d15d-f51b-4ecd-8385-a81cf5c83180"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "45", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"2", " ", "b"}], "-", 
        RowBox[{"2", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "a"}], "+", "b", "-", 
        RowBox[{"2", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "a"}], "-", 
        RowBox[{"2", " ", "b"}], "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "8"], " ", 
     RowBox[{"(", 
      RowBox[{"4", "-", 
       SqrtBox["2"]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 45, 
   "   ", {$CellContext`a ($CellContext`a - 2 $CellContext`b - 
     2 $CellContext`c), $CellContext`b ((-2) $CellContext`a + $CellContext`b - 
     2 $CellContext`c), $CellContext`c ((-2) $CellContext`a - 
     2 $CellContext`b + $CellContext`c)}, "   XM/AM=", 
   Style[Rational[1, 8] (4 - 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386863623`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"7d9ee4a5-eb53-40b2-a2ac-53570c6957c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "46"}],
  SequenceForm["n=", 46],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386876593`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"d1e6f408-9177-450c-870a-b565e0050e83"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "47"}],
  SequenceForm["n=", 47],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386886883`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"071f29f9-09fe-4993-bbac-5701944806e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "48"}],
  SequenceForm["n=", 48],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979386896887`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"429892d4-d9ee-482b-afe6-6ff6b7d89b45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "49"}],
  SequenceForm["n=", 49],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938690761*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"12d71520-3e46-4442-92d4-39df0049b81a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "50"}],
  SequenceForm["n=", 50],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938691803*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"401cee13-da71-42ed-887e-330d4254be7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "51"}],
  SequenceForm["n=", 51],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109793869291*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"d12baa10-3e54-402d-b0c0-196cdbc98c14"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "51", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["2", "3"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 51, 
   "   ", {$CellContext`a^2 ($CellContext`a^2 $CellContext`b^2 - \
$CellContext`b^4 + $CellContext`a^2 $CellContext`c^2 + 
     2 $CellContext`b^2 $CellContext`c^2 - $CellContext`c^4), \
$CellContext`b^2 (-$CellContext`a^4 + $CellContext`a^2 $CellContext`b^2 + 
     2 $CellContext`a^2 $CellContext`c^2 + $CellContext`b^2 $CellContext`c^2 - \
$CellContext`c^4), $CellContext`c^2 (-$CellContext`a^4 + 
     2 $CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 + \
$CellContext`a^2 $CellContext`c^2 + $CellContext`b^2 $CellContext`c^2)}, 
   "   XM/AM=", 
   Style[
    Rational[2, 3], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938694415*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"dcf398dc-8535-4a20-8654-0a060b3899ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "52"}],
  SequenceForm["n=", 52],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938695808*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f23de30e-eee5-4173-9482-4c265dd8ef94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "53"}],
  SequenceForm["n=", 53],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938696875*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f348457d-018c-4f8b-a8de-96d3827a7e23"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "54"}],
  SequenceForm["n=", 54],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938697914*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"812174b8-f79a-4fff-9f25-0223eb2466a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "54", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", "3"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 54, 
   "   ", {$CellContext`a^2 ($CellContext`a^4 - 
     2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - \
$CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2) \
($CellContext`a^4 - $CellContext`a^2 $CellContext`b^2 - 
     2 $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 + \
$CellContext`c^4), $CellContext`b^2 ($CellContext`a^4 - 
     2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - \
$CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2) \
(-$CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - $CellContext`a^2 \
$CellContext`c^2 - 
     2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4), \
$CellContext`c^2 (-$CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - \
$CellContext`a^2 $CellContext`c^2 - 
     2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4) \
($CellContext`a^4 - $CellContext`a^2 $CellContext`b^2 - 
     2 $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 + \
$CellContext`c^4)}, "   XM/AM=", 
   Style[
    Rational[1, 3], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938699584*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"59f4cac2-4898-43a7-b616-e5d77d3b9925"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "55"}],
  SequenceForm["n=", 55],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938701173*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"7e91b8dd-3304-45be-8a6f-d8ba83a58847"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "55", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "-", "c"}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "-", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"1", "-", 
     FractionBox["1", 
      SqrtBox["2"]]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 55, 
   "   ", {$CellContext`a^2 ($CellContext`a - $CellContext`b - \
$CellContext`c), $CellContext`b^2 (-$CellContext`a + $CellContext`b - \
$CellContext`c), $CellContext`c^2 (-$CellContext`a - $CellContext`b + \
$CellContext`c)}, "   XM/AM=", 
   Style[1 - 2^Rational[-1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938702429*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"1d2d4cb1-758a-4d6d-aab5-90960b967d6c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "56"}],
  SequenceForm["n=", 56],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979387036343`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"88f4296e-a436-4bab-81d8-2c3d84365e7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "56", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", 
     SqrtBox["2"]],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 56, 
   "   ", {$CellContext`a^2 ($CellContext`a + $CellContext`b - \
$CellContext`c) ($CellContext`a - $CellContext`b + $CellContext`c), \
$CellContext`b^2 ($CellContext`a + $CellContext`b - $CellContext`c) \
(-$CellContext`a + $CellContext`b + $CellContext`c), $CellContext`c^2 \
($CellContext`a - $CellContext`b + $CellContext`c) (-$CellContext`a + \
$CellContext`b + $CellContext`c)}, "   XM/AM=", 
   Style[2^Rational[-1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979387048893`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"97886cd3-4edd-4d2b-bae8-4a5df86f7e42"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "57"}],
  SequenceForm["n=", 57],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979387062397`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"c4367e4d-5791-4cd8-8465-962a95ab308c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "57", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "7"], " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       SqrtBox["2"]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 57, 
   "   ", {$CellContext`a ($CellContext`a + $CellContext`b - $CellContext`c) \
($CellContext`a - $CellContext`b + $CellContext`c), $CellContext`b \
($CellContext`a + $CellContext`b - $CellContext`c) (-$CellContext`a + \
$CellContext`b + $CellContext`c), $CellContext`c ($CellContext`a - \
$CellContext`b + $CellContext`c) (-$CellContext`a + $CellContext`b + \
$CellContext`c)}, "   XM/AM=", 
   Style[Rational[1, 7] (3 + 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938707572*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"9909bec2-8128-48b3-abc8-43ca2a5f35fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "58"}],
  SequenceForm["n=", 58],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979387088537`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"b26ffa10-9306-49e6-9d51-55fea53e2bcf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "58", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "7"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 58, 
   "   ", {$CellContext`a^2 ($CellContext`a + $CellContext`b) ($CellContext`a + \
$CellContext`c), $CellContext`b^2 ($CellContext`a + $CellContext`b) \
($CellContext`b + $CellContext`c), $CellContext`c^2 ($CellContext`a + \
$CellContext`c) ($CellContext`b + $CellContext`c)}, "   XM/AM=", 
   Style[Rational[1, 7] (1 + 2 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938710127*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"894966c4-3ec2-4658-9454-5337c943c2cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "59"}],
  SequenceForm["n=", 59],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979387115593`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"5d4cf0e1-cd30-4b79-ae3f-c216fc2d41ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "60"}],
  SequenceForm["n=", 60],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938712738*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"dd24dae8-b57d-43f2-b674-79bc6d10b1a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "60", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "c"}], ")"}], "2"]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "-", "c"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "-", "b", "+", "c"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "23"], " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"4", " ", 
        SqrtBox["2"]}]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 60, 
   "   ", {$CellContext`a^2 ($CellContext`a + $CellContext`b)^2 \
($CellContext`a - $CellContext`b - $CellContext`c) ($CellContext`a + \
$CellContext`c)^2, $CellContext`b^2 ($CellContext`a + $CellContext`b)^2 \
(-$CellContext`a + $CellContext`b - $CellContext`c) ($CellContext`b + \
$CellContext`c)^2, $CellContext`c^2 ($CellContext`a + $CellContext`c)^2 \
(-$CellContext`a - $CellContext`b + $CellContext`c) ($CellContext`b + \
$CellContext`c)^2}, "   XM/AM=", 
   Style[Rational[1, 23] (3 + 4 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938714252*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"12cc8230-3729-4a48-8787-920dfe6ffd0b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "61"}],
  SequenceForm["n=", 61],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979387156343`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"86018b45-a0f8-46e3-b813-687fd361d6c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "62"}],
  SequenceForm["n=", 62],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938717003*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f618f488-7d4a-4015-9f7b-d7c857c38a4d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "63"}],
  SequenceForm["n=", 63],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938718244*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"d8df3ea7-baea-4fc6-8b75-d1ccb0b6fbe8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "64"}],
  SequenceForm["n=", 64],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938719633*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"0f81b2e1-bd10-487c-a60e-0073315a43e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "65"}],
  SequenceForm["n=", 65],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979387208*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"31b006db-c60d-497d-a3bd-d06b2097f7ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"2", "-", 
     SqrtBox["2"]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 65, 
   "   ", {$CellContext`a ($CellContext`a + $CellContext`b - $CellContext`c) \
($CellContext`a - $CellContext`b + $CellContext`c) ($CellContext`b + \
$CellContext`c), $CellContext`b ($CellContext`a + $CellContext`b - \
$CellContext`c) ($CellContext`a + $CellContext`c) (-$CellContext`a + \
$CellContext`b + $CellContext`c), ($CellContext`a + $CellContext`b) \
$CellContext`c ($CellContext`a - $CellContext`b + $CellContext`c) \
(-$CellContext`a + $CellContext`b + $CellContext`c)}, "   XM/AM=", 
   Style[2 - 2^Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979387222557`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"ea8a76c5-8add-4cdb-9e7f-cbcc3d136e2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "66"}],
  SequenceForm["n=", 66],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109793872406*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"632fa184-b0a7-4496-b26c-911527d53fac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "67"}],
  SequenceForm["n=", 67],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938725503*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"075cce28-02c2-40fd-8019-fbabbd2f1c8b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", 
     FractionBox["1", "2"]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 67, 
   "   ", {($CellContext`a^4 - $CellContext`a^2 $CellContext`b^2 + \
$CellContext`b^4 - $CellContext`c^4) ($CellContext`a^4 - $CellContext`b^4 - \
$CellContext`a^2 $CellContext`c^2 + $CellContext`c^4), ($CellContext`a^4 - \
$CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - $CellContext`c^4) \
(-$CellContext`a^4 + $CellContext`b^4 - $CellContext`b^2 $CellContext`c^2 + \
$CellContext`c^4), ($CellContext`a^4 - $CellContext`b^4 - $CellContext`a^2 \
$CellContext`c^2 + $CellContext`c^4) (-$CellContext`a^4 + $CellContext`b^4 - \
$CellContext`b^2 $CellContext`c^2 + $CellContext`c^4)}, "   XM/AM=", 
   Style[
    Rational[-1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938727544*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"78886b45-39f0-4739-a03d-ac283cc2a9e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "68"}],
  SequenceForm["n=", 68],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938729458*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"20256040-78a3-4e18-b4ee-7753bec41749"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "69"}],
  SequenceForm["n=", 69],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938730948*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"248a9e60-9d3e-47a1-9133-47fbab963829"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "70"}],
  SequenceForm["n=", 70],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938732445*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"37f7a08d-8694-43d8-adf3-d262c22f5dff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "70", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "6"]}], "+", 
        SuperscriptBox["b", "8"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        SuperscriptBox["c", "8"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "6"]}], "-", 
        SuperscriptBox["b", "8"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        SuperscriptBox["c", "8"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "6"]}], "+", 
        SuperscriptBox["b", "8"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        SuperscriptBox["c", "8"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "6"]}], "+", 
        SuperscriptBox["b", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        SuperscriptBox["c", "8"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "6"]}], "-", 
        SuperscriptBox["b", "8"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        SuperscriptBox["c", "8"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "6"]}], "+", 
        SuperscriptBox["b", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        SuperscriptBox["c", "8"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 70, 
   "   ", {($CellContext`a^8 - 2 $CellContext`a^6 $CellContext`b^2 + 
     2 $CellContext`a^4 $CellContext`b^4 - 
     2 $CellContext`a^2 $CellContext`b^6 + $CellContext`b^8 - 
     2 $CellContext`a^6 $CellContext`c^2 - 
     2 $CellContext`b^6 $CellContext`c^2 + 
     2 $CellContext`a^2 $CellContext`c^6 + 
     2 $CellContext`b^2 $CellContext`c^6 - $CellContext`c^8) \
($CellContext`a^8 - 2 $CellContext`a^6 $CellContext`b^2 + 
     2 $CellContext`a^2 $CellContext`b^6 - $CellContext`b^8 - 
     2 $CellContext`a^6 $CellContext`c^2 + 
     2 $CellContext`b^6 $CellContext`c^2 + 
     2 $CellContext`a^4 $CellContext`c^4 - 
     2 $CellContext`a^2 $CellContext`c^6 - 
     2 $CellContext`b^2 $CellContext`c^6 + $CellContext`c^8), \
($CellContext`a^8 - 2 $CellContext`a^6 $CellContext`b^2 + 
     2 $CellContext`a^4 $CellContext`b^4 - 
     2 $CellContext`a^2 $CellContext`b^6 + $CellContext`b^8 - 
     2 $CellContext`a^6 $CellContext`c^2 - 
     2 $CellContext`b^6 $CellContext`c^2 + 
     2 $CellContext`a^2 $CellContext`c^6 + 
     2 $CellContext`b^2 $CellContext`c^6 - $CellContext`c^8) \
(-$CellContext`a^8 + 2 $CellContext`a^6 $CellContext`b^2 - 
     2 $CellContext`a^2 $CellContext`b^6 + $CellContext`b^8 + 
     2 $CellContext`a^6 $CellContext`c^2 - 
     2 $CellContext`b^6 $CellContext`c^2 + 
     2 $CellContext`b^4 $CellContext`c^4 - 
     2 $CellContext`a^2 $CellContext`c^6 - 
     2 $CellContext`b^2 $CellContext`c^6 + $CellContext`c^8), \
($CellContext`a^8 - 2 $CellContext`a^6 $CellContext`b^2 + 
     2 $CellContext`a^2 $CellContext`b^6 - $CellContext`b^8 - 
     2 $CellContext`a^6 $CellContext`c^2 + 
     2 $CellContext`b^6 $CellContext`c^2 + 
     2 $CellContext`a^4 $CellContext`c^4 - 
     2 $CellContext`a^2 $CellContext`c^6 - 
     2 $CellContext`b^2 $CellContext`c^6 + $CellContext`c^8) \
(-$CellContext`a^8 + 2 $CellContext`a^6 $CellContext`b^2 - 
     2 $CellContext`a^2 $CellContext`b^6 + $CellContext`b^8 + 
     2 $CellContext`a^6 $CellContext`c^2 - 
     2 $CellContext`b^6 $CellContext`c^2 + 
     2 $CellContext`b^4 $CellContext`c^4 - 
     2 $CellContext`a^2 $CellContext`c^6 - 
     2 $CellContext`b^2 $CellContext`c^6 + $CellContext`c^8)}, "   XM/AM=", 
   Style[-1, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979387358847`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"0f91c55e-ead1-4d63-8007-5459b924f442"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "71"}],
  SequenceForm["n=", 71],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109793873909*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a8cd29e9-6a8c-4e22-9aa7-b780f6880d79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "72"}],
  SequenceForm["n=", 72],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938740481*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"bf6350a3-e5e0-41a1-bc05-52ad2671ef61"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "73"}],
  SequenceForm["n=", 73],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938741666*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"4cda1e34-56a3-4378-bb9b-0ca832c2e751"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "74"}],
  SequenceForm["n=", 74],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979387428207`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"c178e9ab-8ed5-4dae-8f23-a2873ead0dd2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "74", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 74, 
   "   ", {$CellContext`a^2 ($CellContext`a^4 - 
     2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 + \
$CellContext`a^2 $CellContext`c^2 + $CellContext`b^2 $CellContext`c^2 - 
     2 $CellContext`c^4) ($CellContext`a^4 + $CellContext`a^2 \
$CellContext`b^2 - 2 $CellContext`b^4 - 
     2 $CellContext`a^2 $CellContext`c^2 + $CellContext`b^2 $CellContext`c^2 + \
$CellContext`c^4), $CellContext`b^2 ($CellContext`a^4 - 
     2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 + \
$CellContext`a^2 $CellContext`c^2 + $CellContext`b^2 $CellContext`c^2 - 
     2 $CellContext`c^4) ((-2) $CellContext`a^4 + $CellContext`a^2 \
$CellContext`b^2 + $CellContext`b^4 + $CellContext`a^2 $CellContext`c^2 - 
     2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4), \
$CellContext`c^2 ((-2) $CellContext`a^4 + $CellContext`a^2 $CellContext`b^2 + \
$CellContext`b^4 + $CellContext`a^2 $CellContext`c^2 - 
     2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4) \
($CellContext`a^4 + $CellContext`a^2 $CellContext`b^2 - 2 $CellContext`b^4 - 
     2 $CellContext`a^2 $CellContext`c^2 + $CellContext`b^2 $CellContext`c^2 + \
$CellContext`c^4)}, "   XM/AM=", 
   Style[-1, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938744636*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"bb440a8a-1252-4d84-8b59-306505566943"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "75"}],
  SequenceForm["n=", 75],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938746335*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"cb60cc51-bf6b-490e-8936-d9067617c95d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "75", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", " ", "c"}], ",", 
     RowBox[{"a", " ", "c"}], ",", 
     RowBox[{"a", " ", "b"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 75, 
   "   ", {$CellContext`b $CellContext`c, $CellContext`a $CellContext`c, \
$CellContext`a $CellContext`b}, "   XM/AM=", 
   Style[(1 + 2 2^Rational[1, 2])^(-1), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938747551*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f2bcb83a-09db-4be2-b723-2f86d93539e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "76"}],
  SequenceForm["n=", 76],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979387487698`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"9d998c17-7ddf-48a1-9f9c-db6e7e4d7a5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "76", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", "5"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 76, 
   "   ", {$CellContext`b^2 $CellContext`c^2, $CellContext`a^2 \
$CellContext`c^2, $CellContext`a^2 $CellContext`b^2}, "   XM/AM=", 
   Style[
    Rational[1, 5], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938750091*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"8c26d848-386c-4c09-bcea-1445b8677c61"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "77"}],
  SequenceForm["n=", 77],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109793875181*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"681d764e-a5c1-4c1e-9172-f072ee33c6c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "78"}],
  SequenceForm["n=", 78],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938752923*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"16672548-9cb6-4caf-9ba6-91ecc315897f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "79"}],
  SequenceForm["n=", 79],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938754113*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"0bdedcc7-4a28-410f-942e-3d82250acc96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "79", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"a", " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"a", " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "7"], " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       SqrtBox["2"]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 79, 
   "   ", {($CellContext`a^2 + $CellContext`a $CellContext`b + \
$CellContext`b^2 - $CellContext`c^2) ($CellContext`a^2 - $CellContext`b^2 + \
$CellContext`a $CellContext`c + $CellContext`c^2), ($CellContext`a^2 + \
$CellContext`a $CellContext`b + $CellContext`b^2 - $CellContext`c^2) \
(-$CellContext`a^2 + $CellContext`b^2 + $CellContext`b $CellContext`c + \
$CellContext`c^2), ($CellContext`a^2 - $CellContext`b^2 + $CellContext`a \
$CellContext`c + $CellContext`c^2) (-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`b $CellContext`c + $CellContext`c^2)}, "   XM/AM=", 
   Style[Rational[1, 7] (3 + 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938755711*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"e88a210e-a05f-4f15-8a64-a36c3a2681c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "80"}],
  SequenceForm["n=", 80],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938757303*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"47307d44-bb60-4297-b1e5-d5fcde83df7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "80", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"a", " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"a", " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"1", "-", 
     SqrtBox["2"]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 80, 
   "   ", {($CellContext`a^2 - $CellContext`a $CellContext`b + \
$CellContext`b^2 - $CellContext`c^2) ($CellContext`a^2 - $CellContext`b^2 - \
$CellContext`a $CellContext`c + $CellContext`c^2), ($CellContext`a^2 - \
$CellContext`a $CellContext`b + $CellContext`b^2 - $CellContext`c^2) \
(-$CellContext`a^2 + $CellContext`b^2 - $CellContext`b $CellContext`c + \
$CellContext`c^2), ($CellContext`a^2 - $CellContext`b^2 - $CellContext`a \
$CellContext`c + $CellContext`c^2) (-$CellContext`a^2 + $CellContext`b^2 - \
$CellContext`b $CellContext`c + $CellContext`c^2)}, "   XM/AM=", 
   Style[1 - 2^Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938758935*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"be7a87b8-b7a9-4680-b19c-ff0a324079a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "81"}],
  SequenceForm["n=", 81],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979387605753`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"84d5a05c-e5d3-4a42-b626-868182b8d2e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "81", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "17"], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 81, 
   "   ", {$CellContext`a ($CellContext`a + $CellContext`b) ($CellContext`a + \
$CellContext`c), $CellContext`b ($CellContext`a + $CellContext`b) \
($CellContext`b + $CellContext`c), $CellContext`c ($CellContext`a + \
$CellContext`c) ($CellContext`b + $CellContext`c)}, "   XM/AM=", 
   Style[Rational[1, 17] (5 + 2 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938761983*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"8998f67f-d08d-4a31-9fc2-427a72fb8458"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "82"}],
  SequenceForm["n=", 82],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938763281*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"0eff2d1a-50b4-4387-b0bd-43a3c45789f2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "82", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"9", "-", 
     RowBox[{"6", " ", 
      SqrtBox["2"]}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 82, 
   "   ", {$CellContext`a ($CellContext`a^2 + $CellContext`b^2) \
($CellContext`a^2 + $CellContext`c^2), $CellContext`b ($CellContext`a^2 + \
$CellContext`b^2) ($CellContext`b^2 + $CellContext`c^2), $CellContext`c \
($CellContext`a^2 + $CellContext`c^2) ($CellContext`b^2 + $CellContext`c^2)}, 
   "   XM/AM=", 
   Style[9 - 6 2^Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938764756*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f7ce5fc3-3d70-45df-a8a4-9c3a73054683"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "83"}],
  SequenceForm["n=", 83],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938766313*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"62053529-1d2d-4e1f-bc53-15b0d926acde"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "83", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["3", "7"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 83, 
   "   ", {($CellContext`a^2 + $CellContext`b^2) ($CellContext`a^2 + \
$CellContext`c^2), ($CellContext`a^2 + $CellContext`b^2) ($CellContext`b^2 + \
$CellContext`c^2), ($CellContext`a^2 + $CellContext`c^2) ($CellContext`b^2 + \
$CellContext`c^2)}, "   XM/AM=", 
   Style[
    Rational[3, 7], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938767804*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"e9b723ab-a02e-4a75-bbb8-bd15686dbdb8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "84"}],
  SequenceForm["n=", 84],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938769454*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"180e8179-8ad5-4a2d-9eb6-328380f58c13"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "84", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"1", "+", 
     SqrtBox["2"]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 84, 
   "   ", {$CellContext`a ($CellContext`a^3 - $CellContext`a^2 $CellContext`b - \
$CellContext`a $CellContext`b^2 + $CellContext`b^3 + $CellContext`a^2 \
$CellContext`c + 
     2 $CellContext`a $CellContext`b $CellContext`c + $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 - $CellContext`b \
$CellContext`c^2 - $CellContext`c^3) ($CellContext`a^3 + $CellContext`a^2 \
$CellContext`b - $CellContext`a $CellContext`b^2 - $CellContext`b^3 - \
$CellContext`a^2 $CellContext`c + 
     2 $CellContext`a $CellContext`b $CellContext`c - $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 + $CellContext`b \
$CellContext`c^2 + $CellContext`c^3), $CellContext`b ($CellContext`a^3 - \
$CellContext`a^2 $CellContext`b - $CellContext`a $CellContext`b^2 + \
$CellContext`b^3 + $CellContext`a^2 $CellContext`c + 
     2 $CellContext`a $CellContext`b $CellContext`c + $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 - $CellContext`b \
$CellContext`c^2 - $CellContext`c^3) (-$CellContext`a^3 - $CellContext`a^2 \
$CellContext`b + $CellContext`a $CellContext`b^2 + $CellContext`b^3 - \
$CellContext`a^2 $CellContext`c + 
     2 $CellContext`a $CellContext`b $CellContext`c - $CellContext`b^2 \
$CellContext`c + $CellContext`a $CellContext`c^2 - $CellContext`b \
$CellContext`c^2 + $CellContext`c^3), $CellContext`c (-$CellContext`a^3 - \
$CellContext`a^2 $CellContext`b + $CellContext`a $CellContext`b^2 + \
$CellContext`b^3 - $CellContext`a^2 $CellContext`c + 
     2 $CellContext`a $CellContext`b $CellContext`c - $CellContext`b^2 \
$CellContext`c + $CellContext`a $CellContext`c^2 - $CellContext`b \
$CellContext`c^2 + $CellContext`c^3) ($CellContext`a^3 + $CellContext`a^2 \
$CellContext`b - $CellContext`a $CellContext`b^2 - $CellContext`b^3 - \
$CellContext`a^2 $CellContext`c + 
     2 $CellContext`a $CellContext`b $CellContext`c - $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 + $CellContext`b \
$CellContext`c^2 + $CellContext`c^3)}, "   XM/AM=", 
   Style[1 + 2^Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938771826*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"5fd3d6e7-808e-463d-95ca-e076e81f4ded"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "85"}],
  SequenceForm["n=", 85],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938773943*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"6ec0dca9-6c6a-45ed-b18c-7a13994a843a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "85", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "-", "c"}], ")"}], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "-", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "-", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"a", " ", "b", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "-", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "17"], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 85, 
   "   ", {$CellContext`b (-$CellContext`a + $CellContext`b - $CellContext`c) \
$CellContext`c (-$CellContext`a - $CellContext`b + $CellContext`c), \
$CellContext`a ($CellContext`a - $CellContext`b - $CellContext`c) \
$CellContext`c (-$CellContext`a - $CellContext`b + $CellContext`c), \
$CellContext`a $CellContext`b ($CellContext`a - $CellContext`b - \
$CellContext`c) (-$CellContext`a + $CellContext`b - $CellContext`c)}, 
   "   XM/AM=", 
   Style[Rational[1, 17] (5 + 2 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938775341*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"fe12eea6-0df5-4104-a81b-8a6605cac1a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "86"}],
  SequenceForm["n=", 86],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979387766848`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"2df0dc22-433b-487b-997b-46780541904f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "86", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "23"], " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"4", " ", 
        SqrtBox["2"]}]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 86, 
   "   ", {($CellContext`a + $CellContext`b) ($CellContext`a + \
$CellContext`c), ($CellContext`a + $CellContext`b) ($CellContext`b + \
$CellContext`c), ($CellContext`a + $CellContext`c) ($CellContext`b + \
$CellContext`c)}, "   XM/AM=", 
   Style[Rational[1, 23] (3 + 4 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979388124437`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"fe5ef645-4580-4df4-8baf-17734029dde6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "87"}],
  SequenceForm["n=", 87],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979388141603`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"30bd1631-a5dc-4385-803d-bd424d7e6ae6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "87", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "b"}], "-", 
        RowBox[{"a", " ", "c"}], "-", 
        RowBox[{"b", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], "+", 
        RowBox[{"a", " ", "c"}], "-", 
        RowBox[{"b", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "b"}], "-", 
        RowBox[{"a", " ", "c"}], "-", 
        RowBox[{"b", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], "-", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"b", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], "+", 
        RowBox[{"a", " ", "c"}], "-", 
        RowBox[{"b", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], "-", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"b", " ", "c"}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "23"], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       SqrtBox["2"]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 87, 
   "   ", {$CellContext`a ($CellContext`a $CellContext`b - $CellContext`a \
$CellContext`c - $CellContext`b $CellContext`c) (-$CellContext`a \
$CellContext`b + $CellContext`a $CellContext`c - $CellContext`b \
$CellContext`c), $CellContext`b ($CellContext`a $CellContext`b - \
$CellContext`a $CellContext`c - $CellContext`b $CellContext`c) \
(-$CellContext`a $CellContext`b - $CellContext`a $CellContext`c + \
$CellContext`b $CellContext`c), $CellContext`c (-$CellContext`a \
$CellContext`b + $CellContext`a $CellContext`c - $CellContext`b \
$CellContext`c) (-$CellContext`a $CellContext`b - $CellContext`a \
$CellContext`c + $CellContext`b $CellContext`c)}, "   XM/AM=", 
   Style[Rational[1, 23] (5 + 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938815645*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"9cd0dd67-50f6-4f48-ba87-1ade4015f719"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "88"}],
  SequenceForm["n=", 88],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938817031*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"aaf78a81-8dff-49dc-b907-afcb244291ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "88", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"2", " ", "b"}], "+", "c"}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"2", " ", "b"}], "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "a"}], "+", "b", "+", "c"}], ")"}]}]}], 
    "}"}], "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "7"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 88, 
   "   ", {$CellContext`a ($CellContext`a + $CellContext`b - 
     2 $CellContext`c) ($CellContext`a - 
     2 $CellContext`b + $CellContext`c), $CellContext`b ($CellContext`a + \
$CellContext`b - 
     2 $CellContext`c) ((-2) $CellContext`a + $CellContext`b + \
$CellContext`c), $CellContext`c ($CellContext`a - 
     2 $CellContext`b + $CellContext`c) ((-2) $CellContext`a + $CellContext`b + \
$CellContext`c)}, "   XM/AM=", 
   Style[Rational[1, 7] (-1 - 2 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109793881845*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"544e99fd-57e0-42e1-a7d8-3b1da82be018"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "89"}],
  SequenceForm["n=", 89],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109793881986*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"7fa094c2-cd14-4783-82b6-704cf8cd31a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "89", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{"2", " ", "b"}], "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "-", "b", "+", 
        RowBox[{"2", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{"2", " ", "b"}], "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", 
        RowBox[{"2", " ", "b"}], "+", 
        RowBox[{"2", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "-", "b", "+", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", 
        RowBox[{"2", " ", "b"}], "+", 
        RowBox[{"2", " ", "c"}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "71"], " ", 
     RowBox[{"(", 
      RowBox[{"25", "+", 
       RowBox[{"8", " ", 
        SqrtBox["2"]}]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 89, 
   "   ", {$CellContext`a (2 $CellContext`a + 
     2 $CellContext`b - $CellContext`c) (2 $CellContext`a - $CellContext`b + 
     2 $CellContext`c), $CellContext`b (2 $CellContext`a + 
     2 $CellContext`b - $CellContext`c) (-$CellContext`a + 2 $CellContext`b + 
     2 $CellContext`c), $CellContext`c (2 $CellContext`a - $CellContext`b + 
     2 $CellContext`c) (-$CellContext`a + 2 $CellContext`b + 
     2 $CellContext`c)}, "   XM/AM=", 
   Style[Rational[1, 71] (25 + 8 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109793882127*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"3d9ad199-2565-436c-b429-9085d19b108d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "90"}],
  SequenceForm["n=", 90],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938822604*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"9427fcd5-a196-4303-8876-5f48a2d7de15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "91"}],
  SequenceForm["n=", 91],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938823716*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f41739a2-8187-4dc2-8b9a-7cace5295de7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "92"}],
  SequenceForm["n=", 92],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938825013*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"7674844f-e79f-46f6-9052-84fe414a098c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "93"}],
  SequenceForm["n=", 93],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979388262463`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"9ec84b58-d43e-4f0e-9ad9-5513bc89ff1d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "94"}],
  SequenceForm["n=", 94],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979388274727`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"e73c6bdf-1a05-4a9e-8cdc-64660ca7dd6a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "94", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"a", " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"a", " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"a", " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"a", " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 94, 
   "   ", {$CellContext`b^2 $CellContext`c^2 ($CellContext`a^2 - \
$CellContext`a $CellContext`b + $CellContext`b^2 - $CellContext`c^2) \
($CellContext`a^2 + $CellContext`a $CellContext`b + $CellContext`b^2 - \
$CellContext`c^2) ($CellContext`a^2 - $CellContext`b^2 - $CellContext`a \
$CellContext`c + $CellContext`c^2) ($CellContext`a^2 - $CellContext`b^2 + \
$CellContext`a $CellContext`c + $CellContext`c^2), $CellContext`a^2 \
$CellContext`c^2 ($CellContext`a^2 - $CellContext`a $CellContext`b + \
$CellContext`b^2 - $CellContext`c^2) ($CellContext`a^2 + $CellContext`a \
$CellContext`b + $CellContext`b^2 - $CellContext`c^2) (-$CellContext`a^2 + \
$CellContext`b^2 - $CellContext`b $CellContext`c + $CellContext`c^2) \
(-$CellContext`a^2 + $CellContext`b^2 + $CellContext`b $CellContext`c + \
$CellContext`c^2), $CellContext`a^2 $CellContext`b^2 ($CellContext`a^2 - \
$CellContext`b^2 - $CellContext`a $CellContext`c + $CellContext`c^2) \
($CellContext`a^2 - $CellContext`b^2 + $CellContext`a $CellContext`c + \
$CellContext`c^2) (-$CellContext`a^2 + $CellContext`b^2 - $CellContext`b \
$CellContext`c + $CellContext`c^2) (-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`b $CellContext`c + $CellContext`c^2)}, "   XM/AM=", 
   Style[-1, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938829486*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"48b43764-8302-4dfa-8638-1bf7a3e5c7f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "95"}],
  SequenceForm["n=", 95],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938831376*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"5388e781-b05c-491f-b7b5-74185c14e1d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "95", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", "5"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 95, 
   "   ", {($CellContext`a^4 - 
     2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - \
$CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2) \
($CellContext`a^4 - $CellContext`a^2 $CellContext`b^2 - 
     2 $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 + \
$CellContext`c^4), ($CellContext`a^4 - 
     2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - \
$CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2) \
(-$CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - $CellContext`a^2 \
$CellContext`c^2 - 
     2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4), \
(-$CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - $CellContext`a^2 \
$CellContext`c^2 - 
     2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4) \
($CellContext`a^4 - $CellContext`a^2 $CellContext`b^2 - 
     2 $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 + \
$CellContext`c^4)}, "   XM/AM=", 
   Style[
    Rational[1, 5], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938833284*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"4122fda2-1a78-494c-99c1-ad300b023cf6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "96"}],
  SequenceForm["n=", 96],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938834992*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"ae344921-dbf9-4e0b-ba61-a024605324b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "97"}],
  SequenceForm["n=", 97],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938836104*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"92e0a467-7c6f-4530-9eec-bcd9a0aa2cb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "98"}],
  SequenceForm["n=", 98],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979388371973`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"4eb002ba-2c03-494e-b11f-7f473bab44c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "98", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 98, 
   "   ", {($CellContext`a^4 + $CellContext`b^4 - $CellContext`a^2 \
$CellContext`c^2 - $CellContext`b^2 $CellContext`c^2) ($CellContext`a^4 - \
$CellContext`a^2 $CellContext`b^2 - $CellContext`b^2 $CellContext`c^2 + \
$CellContext`c^4), ($CellContext`a^4 + $CellContext`b^4 - $CellContext`a^2 \
$CellContext`c^2 - $CellContext`b^2 $CellContext`c^2) (-$CellContext`a^2 \
$CellContext`b^2 + $CellContext`b^4 - $CellContext`a^2 $CellContext`c^2 + \
$CellContext`c^4), (-$CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - \
$CellContext`a^2 $CellContext`c^2 + $CellContext`c^4) ($CellContext`a^4 - \
$CellContext`a^2 $CellContext`b^2 - $CellContext`b^2 $CellContext`c^2 + \
$CellContext`c^4)}, "   XM/AM=", 
   Style[-1, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979388387537`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"d4b0c781-209e-4471-81d9-9041268c3165"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "99"}],
  SequenceForm["n=", 99],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938840242*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"928028ad-eddb-4df8-9164-4940b7b9cdf7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "100"}],
  SequenceForm["n=", 100],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938841363*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"99cbda87-6f0e-4cfd-99e5-9167379e4d65"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "101"}],
  SequenceForm["n=", 101],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109793884247*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"bb2a0c2e-9892-4f6c-a29b-1e3a5dc4f61d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "102"}],
  SequenceForm["n=", 102],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938843547*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"1640a2bf-b523-430e-8b2c-44fba46047d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "102", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "3"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "3"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", "b"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "3"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "3"], " ", "c"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "3"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "3"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "3"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", "b"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "3"]}], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", "c"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "3"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", "b"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "3"]}], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", "c"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "3"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", "b"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "3"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "3"], " ", "c"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "3"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 102, 
   "   ", {$CellContext`a^2 ($CellContext`a^4 - 
     2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - \
$CellContext`a^3 $CellContext`c + $CellContext`a^2 $CellContext`b \
$CellContext`c + $CellContext`a $CellContext`b^2 $CellContext`c - \
$CellContext`b^3 $CellContext`c + $CellContext`a^2 $CellContext`c^2 - 
     2 $CellContext`a $CellContext`b $CellContext`c^2 + $CellContext`b^2 \
$CellContext`c^2 + $CellContext`a $CellContext`c^3 + $CellContext`b \
$CellContext`c^3 - 
     2 $CellContext`c^4) ($CellContext`a^4 - $CellContext`a^3 $CellContext`b + \
$CellContext`a^2 $CellContext`b^2 + $CellContext`a $CellContext`b^3 - 
     2 $CellContext`b^4 + $CellContext`a^2 $CellContext`b $CellContext`c - 
     2 $CellContext`a $CellContext`b^2 $CellContext`c + $CellContext`b^3 \
$CellContext`c - 
     2 $CellContext`a^2 $CellContext`c^2 + $CellContext`a $CellContext`b \
$CellContext`c^2 + $CellContext`b^2 $CellContext`c^2 - $CellContext`b \
$CellContext`c^3 + $CellContext`c^4), $CellContext`b^2 ($CellContext`a^4 - 
     2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - \
$CellContext`a^3 $CellContext`c + $CellContext`a^2 $CellContext`b \
$CellContext`c + $CellContext`a $CellContext`b^2 $CellContext`c - \
$CellContext`b^3 $CellContext`c + $CellContext`a^2 $CellContext`c^2 - 
     2 $CellContext`a $CellContext`b $CellContext`c^2 + $CellContext`b^2 \
$CellContext`c^2 + $CellContext`a $CellContext`c^3 + $CellContext`b \
$CellContext`c^3 - 
     2 $CellContext`c^4) ((-2) $CellContext`a^4 + $CellContext`a^3 \
$CellContext`b + $CellContext`a^2 $CellContext`b^2 - $CellContext`a \
$CellContext`b^3 + $CellContext`b^4 + $CellContext`a^3 $CellContext`c - 
     2 $CellContext`a^2 $CellContext`b $CellContext`c + $CellContext`a \
$CellContext`b^2 $CellContext`c + $CellContext`a^2 $CellContext`c^2 + \
$CellContext`a $CellContext`b $CellContext`c^2 - 
     2 $CellContext`b^2 $CellContext`c^2 - $CellContext`a $CellContext`c^3 + \
$CellContext`c^4), $CellContext`c^2 ((-2) $CellContext`a^4 + $CellContext`a^3 \
$CellContext`b + $CellContext`a^2 $CellContext`b^2 - $CellContext`a \
$CellContext`b^3 + $CellContext`b^4 + $CellContext`a^3 $CellContext`c - 
     2 $CellContext`a^2 $CellContext`b $CellContext`c + $CellContext`a \
$CellContext`b^2 $CellContext`c + $CellContext`a^2 $CellContext`c^2 + \
$CellContext`a $CellContext`b $CellContext`c^2 - 
     2 $CellContext`b^2 $CellContext`c^2 - $CellContext`a $CellContext`c^3 + \
$CellContext`c^4) ($CellContext`a^4 - $CellContext`a^3 $CellContext`b + \
$CellContext`a^2 $CellContext`b^2 + $CellContext`a $CellContext`b^3 - 
     2 $CellContext`b^4 + $CellContext`a^2 $CellContext`b $CellContext`c - 
     2 $CellContext`a $CellContext`b^2 $CellContext`c + $CellContext`b^3 \
$CellContext`c - 
     2 $CellContext`a^2 $CellContext`c^2 + $CellContext`a $CellContext`b \
$CellContext`c^2 + $CellContext`b^2 $CellContext`c^2 - $CellContext`b \
$CellContext`c^3 + $CellContext`c^4)}, "   XM/AM=", 
   Style[-1, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938846051*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a3700dec-c1cf-4cc0-b129-4d95c1dfb108"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "103"}],
  SequenceForm["n=", 103],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938848225*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"120b1561-fdef-443f-82cf-ec0114f53662"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "103", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "3"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "3"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "3"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "3"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "+", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "3"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "3"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "+", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 103, 
   "   ", {$CellContext`a^2 ($CellContext`a^3 - $CellContext`a^2 \
$CellContext`b - $CellContext`a $CellContext`b^2 + $CellContext`b^3 + \
$CellContext`a $CellContext`c^2 + $CellContext`b $CellContext`c^2 - 
     2 $CellContext`c^3) ($CellContext`a^3 + $CellContext`a $CellContext`b^2 - 
     2 $CellContext`b^3 - $CellContext`a^2 $CellContext`c + $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 + $CellContext`c^3), \
$CellContext`b^2 ($CellContext`a^3 - $CellContext`a^2 $CellContext`b - \
$CellContext`a $CellContext`b^2 + $CellContext`b^3 + $CellContext`a \
$CellContext`c^2 + $CellContext`b $CellContext`c^2 - 
     2 $CellContext`c^3) ((-2) $CellContext`a^3 + $CellContext`a^2 \
$CellContext`b + $CellContext`b^3 + $CellContext`a^2 $CellContext`c - \
$CellContext`b^2 $CellContext`c - $CellContext`b $CellContext`c^2 + \
$CellContext`c^3), $CellContext`c^2 ($CellContext`a^3 + $CellContext`a \
$CellContext`b^2 - 
     2 $CellContext`b^3 - $CellContext`a^2 $CellContext`c + $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 + $CellContext`c^3) ((-2) \
$CellContext`a^3 + $CellContext`a^2 $CellContext`b + $CellContext`b^3 + \
$CellContext`a^2 $CellContext`c - $CellContext`b^2 $CellContext`c - \
$CellContext`b $CellContext`c^2 + $CellContext`c^3)}, "   XM/AM=", 
   Style[-1, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938850017*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a5614611-646d-4954-b1f0-5a3869390628"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "104"}],
  SequenceForm["n=", 104],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938851623*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"2b2de884-e619-4474-8766-a6e314f933e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "104", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", "b"}], "+", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", "b"}], "+", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 104, 
   "   ", {$CellContext`a ($CellContext`a^3 - $CellContext`a^2 $CellContext`b - \
$CellContext`a $CellContext`b^2 + $CellContext`b^3 + 
     2 $CellContext`a $CellContext`b $CellContext`c - $CellContext`a \
$CellContext`c^2 - $CellContext`b $CellContext`c^2) ($CellContext`a^3 - \
$CellContext`a $CellContext`b^2 - $CellContext`a^2 $CellContext`c + 
     2 $CellContext`a $CellContext`b $CellContext`c - $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 + $CellContext`c^3), \
$CellContext`b ($CellContext`a^3 - $CellContext`a^2 $CellContext`b - \
$CellContext`a $CellContext`b^2 + $CellContext`b^3 + 
     2 $CellContext`a $CellContext`b $CellContext`c - $CellContext`a \
$CellContext`c^2 - $CellContext`b $CellContext`c^2) (-$CellContext`a^2 \
$CellContext`b + $CellContext`b^3 - $CellContext`a^2 $CellContext`c + 
     2 $CellContext`a $CellContext`b $CellContext`c - $CellContext`b^2 \
$CellContext`c - $CellContext`b $CellContext`c^2 + $CellContext`c^3), \
$CellContext`c ($CellContext`a^3 - $CellContext`a $CellContext`b^2 - \
$CellContext`a^2 $CellContext`c + 
     2 $CellContext`a $CellContext`b $CellContext`c - $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 + $CellContext`c^3) \
(-$CellContext`a^2 $CellContext`b + $CellContext`b^3 - $CellContext`a^2 \
$CellContext`c + 
     2 $CellContext`a $CellContext`b $CellContext`c - $CellContext`b^2 \
$CellContext`c - $CellContext`b $CellContext`c^2 + $CellContext`c^3)}, 
   "   XM/AM=", 
   Style[-1, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938853385*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a5cfa3e1-37bc-40a8-afec-928ab1d4258f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "105"}],
  SequenceForm["n=", 105],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979388549957`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"9600fb82-6611-46a8-8660-97eb1ecd29ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "105", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}], "-", 
        RowBox[{"b", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"a", " ", "b"}], "-", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}], "-", 
        RowBox[{"b", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"a", " ", "b"}], "-", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 105, 
   "   ", {$CellContext`a ($CellContext`a^2 + $CellContext`b^2 - \
$CellContext`a $CellContext`c - $CellContext`b $CellContext`c) \
($CellContext`a^2 - $CellContext`a $CellContext`b - $CellContext`b \
$CellContext`c + $CellContext`c^2), $CellContext`b ($CellContext`a^2 + \
$CellContext`b^2 - $CellContext`a $CellContext`c - $CellContext`b \
$CellContext`c) (-$CellContext`a $CellContext`b + $CellContext`b^2 - \
$CellContext`a $CellContext`c + $CellContext`c^2), $CellContext`c \
(-$CellContext`a $CellContext`b + $CellContext`b^2 - $CellContext`a \
$CellContext`c + $CellContext`c^2) ($CellContext`a^2 - $CellContext`a \
$CellContext`b - $CellContext`b $CellContext`c + $CellContext`c^2)}, 
   "   XM/AM=", 
   Style[-1, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938856429*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"898a7033-be37-476c-9b6a-446f3d6253f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "106"}],
  SequenceForm["n=", 106],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938857771*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"9d135c43-49e6-46d8-8827-a980238298d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "106", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"2", " ", "b"}], "+", "c"}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"2", " ", "b"}], "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "a"}], "+", "b", "+", "c"}], ")"}]}]}], 
    "}"}], "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 106, 
   "   ", {$CellContext`a^2 ($CellContext`a + $CellContext`b - 
     2 $CellContext`c) ($CellContext`a - 
     2 $CellContext`b + $CellContext`c), $CellContext`b^2 ($CellContext`a + \
$CellContext`b - 
     2 $CellContext`c) ((-2) $CellContext`a + $CellContext`b + \
$CellContext`c), $CellContext`c^2 ($CellContext`a - 
     2 $CellContext`b + $CellContext`c) ((-2) $CellContext`a + $CellContext`b + \
$CellContext`c)}, "   XM/AM=", 
   Style[-1, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938859076*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a7ac71df-575b-43e5-90c2-34dd94bb64dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "107"}],
  SequenceForm["n=", 107],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979388604097`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"02c12e9f-4698-48b2-b810-ca9dd53bb769"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "108"}],
  SequenceForm["n=", 108],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938861478*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a11c073a-8af9-4e04-9caa-1baa0579b312"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "109"}],
  SequenceForm["n=", 109],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938862546*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"78e72e7b-4b12-4e87-89db-89c5dd75b3aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "110"}],
  SequenceForm["n=", 110],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938863606*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"af30f489-3af0-4f47-aec6-2a5e41caf95a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "111"}],
  SequenceForm["n=", 111],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979388646708`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"1e81873f-c364-4881-8665-2ec09a157e9d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "111", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 111, 
   "   ", {$CellContext`a^2 ($CellContext`a^2 + $CellContext`b^2 - 
     2 $CellContext`c^2) ($CellContext`a^2 - 
     2 $CellContext`b^2 + $CellContext`c^2), $CellContext`b^2 \
($CellContext`a^2 + $CellContext`b^2 - 
     2 $CellContext`c^2) ((-2) $CellContext`a^2 + $CellContext`b^2 + \
$CellContext`c^2), $CellContext`c^2 ($CellContext`a^2 - 
     2 $CellContext`b^2 + $CellContext`c^2) ((-2) $CellContext`a^2 + \
$CellContext`b^2 + $CellContext`c^2)}, "   XM/AM=", 
   Style[-1, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109793886605*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"7b13667c-e774-48a7-9ef5-a4d303e6c356"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "112"}],
  SequenceForm["n=", 112],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979388674183`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"0c0aec3b-0cfd-4252-b5e0-43534917b428"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "113"}],
  SequenceForm["n=", 113],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979388684597`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"c9ad7577-fe77-4669-9198-4ff3f071c50b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "114"}],
  SequenceForm["n=", 114],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979388694983`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"19834269-9f97-4dfe-ad4a-b6250d436bd2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "115"}],
  SequenceForm["n=", 115],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938870557*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"7f495590-44f1-4580-a510-7e2545afe374"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "116"}],
  SequenceForm["n=", 116],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938871606*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"2203fb3d-c934-4a9c-91d1-82d416c834a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "117"}],
  SequenceForm["n=", 117],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938872652*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"485d1fac-e84e-4e04-b6af-423fe29c589a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "118"}],
  SequenceForm["n=", 118],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938873725*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"ce13a429-c650-4363-aee0-d84b5fa826da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "119"}],
  SequenceForm["n=", 119],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938874819*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"96d202cc-37c9-4541-870a-f21bd0b30194"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "120"}],
  SequenceForm["n=", 120],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938875881*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"306e7695-c2b7-41ba-af8b-6f365f181be5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "121"}],
  SequenceForm["n=", 121],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979388769207`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"7863921d-c554-487d-b9ee-eb59540d4814"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "122"}],
  SequenceForm["n=", 122],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979388779583`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"2431f9bf-29c0-455b-b880-c3ee7fa04cf5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "123"}],
  SequenceForm["n=", 123],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938879012*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a0732156-87e9-49d1-ae9c-35dcfdea82ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "124"}],
  SequenceForm["n=", 124],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979388800592`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"87164327-e440-4f61-bd2d-1b06e0be7acd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "125"}],
  SequenceForm["n=", 125],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979388811007`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"8e3cfdea-14ed-479d-915c-6180389d1b03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "126"}],
  SequenceForm["n=", 126],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979388823442`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"ef12ce19-9a73-451b-92ab-a735476c41f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "127"}],
  SequenceForm["n=", 127],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938883484*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"ef258d72-b844-4532-ae29-c2ced517f661"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "128"}],
  SequenceForm["n=", 128],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938884577*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"409f840e-d564-4f3f-b347-dadc059fc402"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "129"}],
  SequenceForm["n=", 129],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938885644*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"aee5d8cf-33b0-47d7-aa8f-a6fa2fbcc36d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "130"}],
  SequenceForm["n=", 130],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938886718*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"b43881be-88c4-4f46-9482-dd118b8d9d0f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "131"}],
  SequenceForm["n=", 131],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938887796*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"b74733c8-42ad-41fc-bb8d-cbd5de9a3fe0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "132"}],
  SequenceForm["n=", 132],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938888878*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"861475cb-86da-4fea-a980-627045d114c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "133"}],
  SequenceForm["n=", 133],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938889948*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"c9957821-c973-44df-833c-8e610f2414ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "134"}],
  SequenceForm["n=", 134],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938891019*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"5cbec0e8-1ced-4265-b127-8acb8409555b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "135"}],
  SequenceForm["n=", 135],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109793889214*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"b8416c47-b8fe-4cf8-9d25-8d187c84332b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "136"}],
  SequenceForm["n=", 136],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979388932257`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a97cebc5-db01-4961-91ac-796d422f6797"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "137"}],
  SequenceForm["n=", 137],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938894309*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"3968a1b7-155b-4470-981a-81b389368c23"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "138"}],
  SequenceForm["n=", 138],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938895382*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"b4de687a-d490-4f1d-bc73-a7ba4fd6b1aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "139"}],
  SequenceForm["n=", 139],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938896468*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"5e9e8f3b-db2d-4f9e-833a-f5187a1bff1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "140"}],
  SequenceForm["n=", 140],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109793889758*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a30efa3c-0b8b-4237-a524-5db21b0fa7e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "140", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", "4"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 140, "   ", {
   2 $CellContext`a^4 - 
    3 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - 
    3 $CellContext`a^2 $CellContext`c^2 - 
    2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4, $CellContext`a^4 - 
    3 $CellContext`a^2 $CellContext`b^2 + 2 $CellContext`b^4 - 
    2 $CellContext`a^2 $CellContext`c^2 - 
    3 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4, $CellContext`a^4 - 
    2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - 
    3 $CellContext`a^2 $CellContext`c^2 - 3 $CellContext`b^2 $CellContext`c^2 + 
    2 $CellContext`c^4}, "   XM/AM=", 
   Style[
    Rational[1, 4], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938899033*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"aeef31c2-aac6-40be-8011-b61e5ab322d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "141"}],
  SequenceForm["n=", 141],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938900486*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"e1846d12-c837-4207-950b-a66ddb339d88"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "141", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", "4"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 141, 
   "   ", {$CellContext`b^2 + $CellContext`c^2, $CellContext`a^2 + \
$CellContext`c^2, $CellContext`a^2 + $CellContext`b^2}, "   XM/AM=", 
   Style[
    Rational[1, 4], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938901802*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"12518b44-aed2-4eea-a1e7-dc71beb0f3b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "142"}],
  SequenceForm["n=", 142],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938903048*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"67f02c12-6216-47af-9ca3-96e255fdcb16"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "142", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], " ", "b"}], "+", 
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"a", " ", "c"}], "-", 
      RowBox[{"2", " ", "b", " ", "c"}], "+", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{"a", " ", "b"}], "-", 
      RowBox[{"2", " ", "a", " ", "c"}], "-", 
      RowBox[{"b", " ", "c"}], "+", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{"2", " ", "a", " ", "b"}], "+", 
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"a", " ", "c"}], "-", 
      RowBox[{"b", " ", "c"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", 
     RowBox[{"4", "-", 
      SqrtBox["2"]}]],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 142, 
   "   ", {-$CellContext`a $CellContext`b + $CellContext`b^2 - $CellContext`a \
$CellContext`c - 
    2 $CellContext`b $CellContext`c + $CellContext`c^2, $CellContext`a^2 - \
$CellContext`a $CellContext`b - 
    2 $CellContext`a $CellContext`c - $CellContext`b $CellContext`c + \
$CellContext`c^2, $CellContext`a^2 - 
    2 $CellContext`a $CellContext`b + $CellContext`b^2 - $CellContext`a \
$CellContext`c - $CellContext`b $CellContext`c}, "   XM/AM=", 
   Style[(4 - 2^Rational[1, 2])^(-1), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938904728*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"fd53ad82-c52e-446b-907a-0025f6d1b22e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "143"}],
  SequenceForm["n=", 143],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938906322*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"93e057d3-9fdb-48a6-a7d0-7efb49d5af47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "143", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["3", "4"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 143, 
   "   ", {$CellContext`a^2 ($CellContext`a^2 $CellContext`b^2 - \
$CellContext`b^4 + $CellContext`a^2 $CellContext`c^2 + 
     2 $CellContext`b^2 $CellContext`c^2 - $CellContext`c^4) \
($CellContext`a^4 - 2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - 
     2 $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 + \
$CellContext`c^4), $CellContext`b^2 (-$CellContext`a^4 + $CellContext`a^2 \
$CellContext`b^2 + 
     2 $CellContext`a^2 $CellContext`c^2 + $CellContext`b^2 $CellContext`c^2 - \
$CellContext`c^4) ($CellContext`a^4 - 
     2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - \
$CellContext`a^2 $CellContext`c^2 - 
     2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4), \
$CellContext`c^2 (-$CellContext`a^4 + 
     2 $CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 + \
$CellContext`a^2 $CellContext`c^2 + $CellContext`b^2 $CellContext`c^2) \
($CellContext`a^4 - $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - 
     2 $CellContext`a^2 $CellContext`c^2 - 
     2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4)}, "   XM/AM=", 
   Style[
    Rational[3, 4], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938908661*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"afde3554-c1ff-4711-99d3-dc636944dbff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "144"}],
  SequenceForm["n=", 144],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938910852*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"e4fd3928-1e74-4602-ba90-bad6e0faa176"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "144", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{"2", " ", "a", " ", "b"}], "-", 
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"2", " ", "a", " ", "c"}], "+", 
      RowBox[{"2", " ", "b", " ", "c"}], "-", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{"2", " ", "a", " ", "b"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", "a", " ", "c"}], "-", 
      RowBox[{"2", " ", "b", " ", "c"}], "-", 
      SuperscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{"2", " ", "a", " ", "b"}], "-", 
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"2", " ", "a", " ", "c"}], "-", 
      RowBox[{"2", " ", "b", " ", "c"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"]}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "7"], " ", 
     RowBox[{"(", 
      RowBox[{"5", "-", 
       RowBox[{"4", " ", 
        SqrtBox["2"]}]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 144, "   ", {
   3 $CellContext`a^2 - 2 $CellContext`a $CellContext`b - $CellContext`b^2 - 
    2 $CellContext`a $CellContext`c + 
    2 $CellContext`b $CellContext`c - $CellContext`c^2, -$CellContext`a^2 - 
    2 $CellContext`a $CellContext`b + 3 $CellContext`b^2 + 
    2 $CellContext`a $CellContext`c - 
    2 $CellContext`b $CellContext`c - $CellContext`c^2, -$CellContext`a^2 + 
    2 $CellContext`a $CellContext`b - $CellContext`b^2 - 
    2 $CellContext`a $CellContext`c - 2 $CellContext`b $CellContext`c + 
    3 $CellContext`c^2}, "   XM/AM=", 
   Style[Rational[1, 7] (5 - 4 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938912571*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"06a0c80d-78cf-49e8-851c-539c67186cdd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "145"}],
  SequenceForm["n=", 145],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938914461*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"1b183894-4318-4657-9cfd-97d7c63aae7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "145", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", "a"}], "-", "b", "-", "c"}], ",", 
     RowBox[{
      RowBox[{"-", "a"}], "+", 
      RowBox[{"3", " ", "b"}], "-", "c"}], ",", 
     RowBox[{
      RowBox[{"-", "a"}], "-", "b", "+", 
      RowBox[{"3", " ", "c"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     RowBox[{"-", "5"}], "+", 
     RowBox[{"4", " ", 
      SqrtBox["2"]}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 145, "   ", {
   3 $CellContext`a - $CellContext`b - $CellContext`c, -$CellContext`a + 
    3 $CellContext`b - $CellContext`c, -$CellContext`a - $CellContext`b + 
    3 $CellContext`c}, "   XM/AM=", 
   Style[-5 + 4 2^Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938915896*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"44b044e9-ec4d-4f8f-a74a-690ab13bed21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "146"}],
  SequenceForm["n=", 146],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979389172087`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"4d9beaf2-2566-47c2-9c9c-0202cd4fa908"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "146", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "10"], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "6"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "8"]}], "-", 
      SuperscriptBox["b", "10"], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"7", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "8"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"16", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{"7", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "8"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "8"]}], "-", 
      SuperscriptBox["c", "10"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "10"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "6"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "8"]}], "+", 
      SuperscriptBox["b", "10"], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "8"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"7", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "8"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"16", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{"7", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "8"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "8"]}], "-", 
      SuperscriptBox["c", "10"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "10"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "8"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "6"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "8"]}], "-", 
      SuperscriptBox["b", "10"], "-", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"7", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"16", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"7", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "8"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "8"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "8"]}], "+", 
      SuperscriptBox["c", "10"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox["3",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 146, 
   "   ", {$CellContext`a^10 + $CellContext`a^8 $CellContext`b^2 - 
    8 $CellContext`a^6 $CellContext`b^4 + 
    8 $CellContext`a^4 $CellContext`b^6 - $CellContext`a^2 $CellContext`b^8 - \
$CellContext`b^10 + $CellContext`a^8 $CellContext`c^2 + 
    9 $CellContext`a^6 $CellContext`b^2 $CellContext`c^2 - 
    6 $CellContext`a^4 $CellContext`b^4 $CellContext`c^2 - 
    7 $CellContext`a^2 $CellContext`b^6 $CellContext`c^2 + 
    3 $CellContext`b^8 $CellContext`c^2 - 8 $CellContext`a^6 $CellContext`c^4 - 
    6 $CellContext`a^4 $CellContext`b^2 $CellContext`c^4 + 
    16 $CellContext`a^2 $CellContext`b^4 $CellContext`c^4 - 
    2 $CellContext`b^6 $CellContext`c^4 + 8 $CellContext`a^4 $CellContext`c^6 - 
    7 $CellContext`a^2 $CellContext`b^2 $CellContext`c^6 - 
    2 $CellContext`b^4 $CellContext`c^6 - $CellContext`a^2 $CellContext`c^8 + 
    3 $CellContext`b^2 $CellContext`c^8 - $CellContext`c^10, \
-$CellContext`a^10 - $CellContext`a^8 $CellContext`b^2 + 
    8 $CellContext`a^6 $CellContext`b^4 - 
    8 $CellContext`a^4 $CellContext`b^6 + $CellContext`a^2 $CellContext`b^8 + \
$CellContext`b^10 + 3 $CellContext`a^8 $CellContext`c^2 - 
    7 $CellContext`a^6 $CellContext`b^2 $CellContext`c^2 - 
    6 $CellContext`a^4 $CellContext`b^4 $CellContext`c^2 + 
    9 $CellContext`a^2 $CellContext`b^6 $CellContext`c^2 + $CellContext`b^8 \
$CellContext`c^2 - 2 $CellContext`a^6 $CellContext`c^4 + 
    16 $CellContext`a^4 $CellContext`b^2 $CellContext`c^4 - 
    6 $CellContext`a^2 $CellContext`b^4 $CellContext`c^4 - 
    8 $CellContext`b^6 $CellContext`c^4 - 2 $CellContext`a^4 $CellContext`c^6 - 
    7 $CellContext`a^2 $CellContext`b^2 $CellContext`c^6 + 
    8 $CellContext`b^4 $CellContext`c^6 + 
    3 $CellContext`a^2 $CellContext`c^8 - $CellContext`b^2 $CellContext`c^8 - \
$CellContext`c^10, -$CellContext`a^10 + 3 $CellContext`a^8 $CellContext`b^2 - 
    2 $CellContext`a^6 $CellContext`b^4 - 2 $CellContext`a^4 $CellContext`b^6 + 
    3 $CellContext`a^2 $CellContext`b^8 - $CellContext`b^10 - \
$CellContext`a^8 $CellContext`c^2 - 
    7 $CellContext`a^6 $CellContext`b^2 $CellContext`c^2 + 
    16 $CellContext`a^4 $CellContext`b^4 $CellContext`c^2 - 
    7 $CellContext`a^2 $CellContext`b^6 $CellContext`c^2 - $CellContext`b^8 \
$CellContext`c^2 + 8 $CellContext`a^6 $CellContext`c^4 - 
    6 $CellContext`a^4 $CellContext`b^2 $CellContext`c^4 - 
    6 $CellContext`a^2 $CellContext`b^4 $CellContext`c^4 + 
    8 $CellContext`b^6 $CellContext`c^4 - 8 $CellContext`a^4 $CellContext`c^6 + 
    9 $CellContext`a^2 $CellContext`b^2 $CellContext`c^6 - 
    8 $CellContext`b^4 $CellContext`c^6 + $CellContext`a^2 $CellContext`c^8 + \
$CellContext`b^2 $CellContext`c^8 + $CellContext`c^10}, "   XM/AM=", 
   Style[3, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938919867*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"80efc043-7f3d-449b-ad12-30bbea8eb5ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "147"}],
  SequenceForm["n=", 147],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938922606*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"85de3362-4388-4c5c-a82d-a9718189ee6c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "147", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "8"], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "6"]}], "-", 
      SuperscriptBox["b", "8"], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      SuperscriptBox["c", "8"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "6"]}], "+", 
      SuperscriptBox["b", "8"], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      SuperscriptBox["c", "8"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "6"]}], "-", 
      SuperscriptBox["b", "8"], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      SuperscriptBox["c", "8"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox["3",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 147, 
   "   ", {$CellContext`a^8 + $CellContext`a^6 $CellContext`b^2 - 
    2 $CellContext`a^4 $CellContext`b^4 + $CellContext`a^2 $CellContext`b^6 - \
$CellContext`b^8 + $CellContext`a^6 $CellContext`c^2 - 
    3 $CellContext`a^4 $CellContext`b^2 $CellContext`c^2 + $CellContext`a^2 \
$CellContext`b^4 $CellContext`c^2 + $CellContext`b^6 $CellContext`c^2 - 
    2 $CellContext`a^4 $CellContext`c^4 + $CellContext`a^2 $CellContext`b^2 \
$CellContext`c^4 + $CellContext`a^2 $CellContext`c^6 + $CellContext`b^2 \
$CellContext`c^6 - $CellContext`c^8, -$CellContext`a^8 + $CellContext`a^6 \
$CellContext`b^2 - 
    2 $CellContext`a^4 $CellContext`b^4 + $CellContext`a^2 $CellContext`b^6 + \
$CellContext`b^8 + $CellContext`a^6 $CellContext`c^2 + $CellContext`a^4 \
$CellContext`b^2 $CellContext`c^2 - 
    3 $CellContext`a^2 $CellContext`b^4 $CellContext`c^2 + $CellContext`b^6 \
$CellContext`c^2 + $CellContext`a^2 $CellContext`b^2 $CellContext`c^4 - 
    2 $CellContext`b^4 $CellContext`c^4 + $CellContext`a^2 $CellContext`c^6 + \
$CellContext`b^2 $CellContext`c^6 - $CellContext`c^8, -$CellContext`a^8 + \
$CellContext`a^6 $CellContext`b^2 + $CellContext`a^2 $CellContext`b^6 - \
$CellContext`b^8 + $CellContext`a^6 $CellContext`c^2 + $CellContext`a^4 \
$CellContext`b^2 $CellContext`c^2 + $CellContext`a^2 $CellContext`b^4 \
$CellContext`c^2 + $CellContext`b^6 $CellContext`c^2 - 
    2 $CellContext`a^4 $CellContext`c^4 - 
    3 $CellContext`a^2 $CellContext`b^2 $CellContext`c^4 - 
    2 $CellContext`b^4 $CellContext`c^4 + $CellContext`a^2 $CellContext`c^6 + \
$CellContext`b^2 $CellContext`c^6 + $CellContext`c^8}, "   XM/AM=", 
   Style[3, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938925374*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"4bebea59-594e-41fa-96a7-a6e776c28987"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "148"}],
  SequenceForm["n=", 148],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938927535*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a2c7f76b-223f-4318-9c30-8b6d706d1188"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "148", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 148, 
   "   ", {$CellContext`a^4 - $CellContext`a^2 $CellContext`b^2 - \
$CellContext`b^4 - $CellContext`a^2 $CellContext`c^2 + 
    3 $CellContext`b^2 $CellContext`c^2 - $CellContext`c^4, -$CellContext`a^4 - \
$CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 + 
    3 $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 - \
$CellContext`c^4, -$CellContext`a^4 + 
    3 $CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 - $CellContext`a^2 \
$CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4}, 
   "   XM/AM=", 
   Style[-1, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109793892913*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"de6321ce-0fba-4c75-99d4-0fc5a1fe14ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "149"}],
  SequenceForm["n=", 149],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979389306602`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"1b3ca52c-2db5-4935-8baa-15297aec3172"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "149", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "3"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "3"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "c"}], "-", 
      RowBox[{"a", " ", "b", " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "3"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "3"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "3"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "c"}], "-", 
      RowBox[{"a", " ", "b", " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "3"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "3"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "3"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "c"}], "-", 
      RowBox[{"a", " ", "b", " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "3"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 149, 
   "   ", {$CellContext`a^3 - $CellContext`a^2 $CellContext`b + \
$CellContext`a $CellContext`b^2 - $CellContext`b^3 - $CellContext`a^2 \
$CellContext`c - $CellContext`a $CellContext`b $CellContext`c + \
$CellContext`b^2 $CellContext`c + $CellContext`a $CellContext`c^2 + \
$CellContext`b $CellContext`c^2 - $CellContext`c^3, -$CellContext`a^3 + \
$CellContext`a^2 $CellContext`b - $CellContext`a $CellContext`b^2 + \
$CellContext`b^3 + $CellContext`a^2 $CellContext`c - $CellContext`a \
$CellContext`b $CellContext`c - $CellContext`b^2 $CellContext`c + \
$CellContext`a $CellContext`c^2 + $CellContext`b $CellContext`c^2 - \
$CellContext`c^3, -$CellContext`a^3 + $CellContext`a^2 $CellContext`b + \
$CellContext`a $CellContext`b^2 - $CellContext`b^3 + $CellContext`a^2 \
$CellContext`c - $CellContext`a $CellContext`b $CellContext`c + \
$CellContext`b^2 $CellContext`c - $CellContext`a $CellContext`c^2 - \
$CellContext`b $CellContext`c^2 + $CellContext`c^3}, "   XM/AM=", 
   Style[-1, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979389324417`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"ed07be22-09d8-48cf-9c4a-fb91b02e16a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "150"}],
  SequenceForm["n=", 150],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938934116*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"84ca9f10-2d9d-4e33-879d-59f78f7d7d66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "150", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "b"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "3"], " ", "c"}], "-", 
      RowBox[{"a", " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "3"]}], "-", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "b"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}], "+", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["b", "3"], " ", "c"}], "-", 
      RowBox[{"a", " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "3"]}], "-", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "b"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "3"], " ", "c"}], "+", 
      RowBox[{"a", " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      SuperscriptBox["c", "4"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}],
  SequenceForm[
  "n=", 150, 
   "   ", {$CellContext`a^4 - $CellContext`a^3 $CellContext`b + \
$CellContext`a $CellContext`b^3 - $CellContext`b^4 - $CellContext`a^3 \
$CellContext`c + $CellContext`a^2 $CellContext`b $CellContext`c - \
$CellContext`a $CellContext`b^2 $CellContext`c + $CellContext`b^3 \
$CellContext`c - $CellContext`a $CellContext`b $CellContext`c^2 + \
$CellContext`a $CellContext`c^3 + $CellContext`b $CellContext`c^3 - \
$CellContext`c^4, -$CellContext`a^4 + $CellContext`a^3 $CellContext`b - \
$CellContext`a $CellContext`b^3 + $CellContext`b^4 + $CellContext`a^3 \
$CellContext`c - $CellContext`a^2 $CellContext`b $CellContext`c + \
$CellContext`a $CellContext`b^2 $CellContext`c - $CellContext`b^3 \
$CellContext`c - $CellContext`a $CellContext`b $CellContext`c^2 + \
$CellContext`a $CellContext`c^3 + $CellContext`b $CellContext`c^3 - \
$CellContext`c^4, -$CellContext`a^4 + $CellContext`a^3 $CellContext`b + \
$CellContext`a $CellContext`b^3 - $CellContext`b^4 + $CellContext`a^3 \
$CellContext`c - $CellContext`a^2 $CellContext`b $CellContext`c - \
$CellContext`a $CellContext`b^2 $CellContext`c + $CellContext`b^3 \
$CellContext`c + $CellContext`a $CellContext`b $CellContext`c^2 - \
$CellContext`a $CellContext`c^3 - $CellContext`b $CellContext`c^3 + \
$CellContext`c^4}, "   XM/AM=", 
   Style[-1, 
    RGBColor[1, 0, 0]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938936005*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f67cca86-b93d-44c0-939a-83d24189c909"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "151"}],
  SequenceForm["n=", 151],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979389377317`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"da250596-cc5a-4509-aef3-fa0c92bf207c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "151", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "10"], "-", 
      RowBox[{
       SuperscriptBox["a", "9"], " ", "b"}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "7"], " ", 
       SuperscriptBox["b", "3"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "6"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "7"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "8"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "9"]}], "-", 
      SuperscriptBox["b", "10"], "-", 
      RowBox[{
       SuperscriptBox["a", "9"], " ", "c"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "8"], " ", "b", " ", "c"}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "7"], " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "3"], " ", "c"}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "4"], " ", "c"}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "5"], " ", "c"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "6"], " ", "c"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "7"], " ", "c"}], "-", 
      RowBox[{"3", " ", "a", " ", 
       SuperscriptBox["b", "8"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "9"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "7"], " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"16", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"18", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "8"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "7"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", "b", " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"24", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"14", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"8", " ", "a", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "7"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "5"], " ", "b", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"14", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"26", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"6", " ", "a", " ", 
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "4"], " ", "b", " ", 
       SuperscriptBox["c", "5"]}], "+", 
      RowBox[{"18", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{"6", " ", "a", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "5"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "5"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", "b", " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"8", " ", "a", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["c", "7"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "2"], " ", "b", " ", 
       SuperscriptBox["c", "7"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "7"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "8"]}], "-", 
      RowBox[{"3", " ", "a", " ", "b", " ", 
       SuperscriptBox["c", "8"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "8"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "9"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "9"]}], "-", 
      SuperscriptBox["c", "10"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "10"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "9"], " ", "b"}], "-", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "7"], " ", 
       SuperscriptBox["b", "3"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "6"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "7"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "8"]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "9"]}], "+", 
      SuperscriptBox["b", "10"], "+", 
      RowBox[{
       SuperscriptBox["a", "9"], " ", "c"}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "8"], " ", "b", " ", "c"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "7"], " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "3"], " ", "c"}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "4"], " ", "c"}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "5"], " ", "c"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "6"], " ", "c"}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "7"], " ", "c"}], "+", 
      RowBox[{"3", " ", "a", " ", 
       SuperscriptBox["b", "8"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["b", "9"], " ", "c"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "8"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"18", " ", 
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"16", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"6", " ", "a", " ", 
       SuperscriptBox["b", "7"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "8"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "7"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "6"], " ", "b", " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"14", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"24", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"2", " ", "a", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "7"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "5"], " ", "b", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"26", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"14", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"12", " ", "a", " ", 
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "4"], " ", "b", " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "5"]}], "+", 
      RowBox[{"18", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{"12", " ", "a", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "3"], " ", "b", " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{"2", " ", "a", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["c", "7"]}], "+", 
      RowBox[{"6", " ", "a", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "7"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "7"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "8"]}], "-", 
      RowBox[{"3", " ", "a", " ", "b", " ", 
       SuperscriptBox["c", "8"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "8"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "9"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "9"]}], "-", 
      SuperscriptBox["c", "10"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "10"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "9"], " ", "b"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "8"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "7"], " ", 
       SuperscriptBox["b", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "5"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "6"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "7"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "8"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "9"]}], "-", 
      SuperscriptBox["b", "10"], "+", 
      RowBox[{
       SuperscriptBox["a", "9"], " ", "c"}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "8"], " ", "b", " ", "c"}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "3"], " ", "c"}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "4"], " ", "c"}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "5"], " ", "c"}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "6"], " ", "c"}], "-", 
      RowBox[{"3", " ", "a", " ", 
       SuperscriptBox["b", "8"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "9"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "7"], " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"26", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"6", " ", "a", " ", 
       SuperscriptBox["b", "7"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "8"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "7"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", "b", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"18", " ", 
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"14", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"14", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"18", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"2", " ", "a", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "7"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "5"], " ", "b", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"24", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"12", " ", "a", " ", 
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "4"], " ", "b", " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "5"]}], "+", 
      RowBox[{"12", " ", "a", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", "b", " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"16", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"2", " ", "a", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["c", "7"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "2"], " ", "b", " ", 
       SuperscriptBox["c", "7"]}], "-", 
      RowBox[{"6", " ", "a", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "7"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "7"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "8"]}], "+", 
      RowBox[{"3", " ", "a", " ", "b", " ", 
       SuperscriptBox["c", "8"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "8"]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "9"]}], "-", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "9"]}], "+", 
      SuperscriptBox["c", "10"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox["3",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 151, 
   "   ", {$CellContext`a^10 - $CellContext`a^9 $CellContext`b + \
$CellContext`a^8 $CellContext`b^2 + 2 $CellContext`a^7 $CellContext`b^3 - 
    8 $CellContext`a^6 $CellContext`b^4 + 8 $CellContext`a^4 $CellContext`b^6 - 
    2 $CellContext`a^3 $CellContext`b^7 - $CellContext`a^2 $CellContext`b^8 + \
$CellContext`a $CellContext`b^9 - $CellContext`b^10 - $CellContext`a^9 \
$CellContext`c + 3 $CellContext`a^8 $CellContext`b $CellContext`c - 
    6 $CellContext`a^7 $CellContext`b^2 $CellContext`c + 
    2 $CellContext`a^6 $CellContext`b^3 $CellContext`c + 
    12 $CellContext`a^5 $CellContext`b^4 $CellContext`c - 
    12 $CellContext`a^4 $CellContext`b^5 $CellContext`c - 
    2 $CellContext`a^3 $CellContext`b^6 $CellContext`c + 
    6 $CellContext`a^2 $CellContext`b^7 $CellContext`c - 
    3 $CellContext`a $CellContext`b^8 $CellContext`c + $CellContext`b^9 \
$CellContext`c + $CellContext`a^8 $CellContext`c^2 - 
    6 $CellContext`a^7 $CellContext`b $CellContext`c^2 + 
    16 $CellContext`a^6 $CellContext`b^2 $CellContext`c^2 - 
    12 $CellContext`a^5 $CellContext`b^3 $CellContext`c^2 - 
    8 $CellContext`a^4 $CellContext`b^4 $CellContext`c^2 + 
    18 $CellContext`a^3 $CellContext`b^5 $CellContext`c^2 - 
    12 $CellContext`a^2 $CellContext`b^6 $CellContext`c^2 + 
    3 $CellContext`b^8 $CellContext`c^2 + 2 $CellContext`a^7 $CellContext`c^3 + 
    2 $CellContext`a^6 $CellContext`b $CellContext`c^3 - 
    12 $CellContext`a^5 $CellContext`b^2 $CellContext`c^3 + 
    24 $CellContext`a^4 $CellContext`b^3 $CellContext`c^3 - 
    14 $CellContext`a^3 $CellContext`b^4 $CellContext`c^3 - 
    6 $CellContext`a^2 $CellContext`b^5 $CellContext`c^3 + 
    8 $CellContext`a $CellContext`b^6 $CellContext`c^3 - 
    4 $CellContext`b^7 $CellContext`c^3 - 8 $CellContext`a^6 $CellContext`c^4 + 
    12 $CellContext`a^5 $CellContext`b $CellContext`c^4 - 
    8 $CellContext`a^4 $CellContext`b^2 $CellContext`c^4 - 
    14 $CellContext`a^3 $CellContext`b^3 $CellContext`c^4 + 
    26 $CellContext`a^2 $CellContext`b^4 $CellContext`c^4 - 
    6 $CellContext`a $CellContext`b^5 $CellContext`c^4 - 
    2 $CellContext`b^6 $CellContext`c^4 - 
    12 $CellContext`a^4 $CellContext`b $CellContext`c^5 + 
    18 $CellContext`a^3 $CellContext`b^2 $CellContext`c^5 - 
    6 $CellContext`a^2 $CellContext`b^3 $CellContext`c^5 - 
    6 $CellContext`a $CellContext`b^4 $CellContext`c^5 + 
    6 $CellContext`b^5 $CellContext`c^5 + 8 $CellContext`a^4 $CellContext`c^6 - 
    2 $CellContext`a^3 $CellContext`b $CellContext`c^6 - 
    12 $CellContext`a^2 $CellContext`b^2 $CellContext`c^6 + 
    8 $CellContext`a $CellContext`b^3 $CellContext`c^6 - 
    2 $CellContext`b^4 $CellContext`c^6 - 2 $CellContext`a^3 $CellContext`c^7 + 
    6 $CellContext`a^2 $CellContext`b $CellContext`c^7 - 
    4 $CellContext`b^3 $CellContext`c^7 - $CellContext`a^2 $CellContext`c^8 - 
    3 $CellContext`a $CellContext`b $CellContext`c^8 + 
    3 $CellContext`b^2 $CellContext`c^8 + $CellContext`a $CellContext`c^9 + \
$CellContext`b $CellContext`c^9 - $CellContext`c^10, -$CellContext`a^10 + \
$CellContext`a^9 $CellContext`b - $CellContext`a^8 $CellContext`b^2 - 
    2 $CellContext`a^7 $CellContext`b^3 + 8 $CellContext`a^6 $CellContext`b^4 - 
    8 $CellContext`a^4 $CellContext`b^6 + 
    2 $CellContext`a^3 $CellContext`b^7 + $CellContext`a^2 $CellContext`b^8 - \
$CellContext`a $CellContext`b^9 + $CellContext`b^10 + $CellContext`a^9 \
$CellContext`c - 3 $CellContext`a^8 $CellContext`b $CellContext`c + 
    6 $CellContext`a^7 $CellContext`b^2 $CellContext`c - 
    2 $CellContext`a^6 $CellContext`b^3 $CellContext`c - 
    12 $CellContext`a^5 $CellContext`b^4 $CellContext`c + 
    12 $CellContext`a^4 $CellContext`b^5 $CellContext`c + 
    2 $CellContext`a^3 $CellContext`b^6 $CellContext`c - 
    6 $CellContext`a^2 $CellContext`b^7 $CellContext`c + 
    3 $CellContext`a $CellContext`b^8 $CellContext`c - $CellContext`b^9 \
$CellContext`c + 3 $CellContext`a^8 $CellContext`c^2 - 
    12 $CellContext`a^6 $CellContext`b^2 $CellContext`c^2 + 
    18 $CellContext`a^5 $CellContext`b^3 $CellContext`c^2 - 
    8 $CellContext`a^4 $CellContext`b^4 $CellContext`c^2 - 
    12 $CellContext`a^3 $CellContext`b^5 $CellContext`c^2 + 
    16 $CellContext`a^2 $CellContext`b^6 $CellContext`c^2 - 
    6 $CellContext`a $CellContext`b^7 $CellContext`c^2 + $CellContext`b^8 \
$CellContext`c^2 - 4 $CellContext`a^7 $CellContext`c^3 + 
    8 $CellContext`a^6 $CellContext`b $CellContext`c^3 - 
    6 $CellContext`a^5 $CellContext`b^2 $CellContext`c^3 - 
    14 $CellContext`a^4 $CellContext`b^3 $CellContext`c^3 + 
    24 $CellContext`a^3 $CellContext`b^4 $CellContext`c^3 - 
    12 $CellContext`a^2 $CellContext`b^5 $CellContext`c^3 + 
    2 $CellContext`a $CellContext`b^6 $CellContext`c^3 + 
    2 $CellContext`b^7 $CellContext`c^3 - 2 $CellContext`a^6 $CellContext`c^4 - 
    6 $CellContext`a^5 $CellContext`b $CellContext`c^4 + 
    26 $CellContext`a^4 $CellContext`b^2 $CellContext`c^4 - 
    14 $CellContext`a^3 $CellContext`b^3 $CellContext`c^4 - 
    8 $CellContext`a^2 $CellContext`b^4 $CellContext`c^4 + 
    12 $CellContext`a $CellContext`b^5 $CellContext`c^4 - 
    8 $CellContext`b^6 $CellContext`c^4 + 6 $CellContext`a^5 $CellContext`c^5 - 
    6 $CellContext`a^4 $CellContext`b $CellContext`c^5 - 
    6 $CellContext`a^3 $CellContext`b^2 $CellContext`c^5 + 
    18 $CellContext`a^2 $CellContext`b^3 $CellContext`c^5 - 
    12 $CellContext`a $CellContext`b^4 $CellContext`c^5 - 
    2 $CellContext`a^4 $CellContext`c^6 + 
    8 $CellContext`a^3 $CellContext`b $CellContext`c^6 - 
    12 $CellContext`a^2 $CellContext`b^2 $CellContext`c^6 - 
    2 $CellContext`a $CellContext`b^3 $CellContext`c^6 + 
    8 $CellContext`b^4 $CellContext`c^6 - 4 $CellContext`a^3 $CellContext`c^7 + 
    6 $CellContext`a $CellContext`b^2 $CellContext`c^7 - 
    2 $CellContext`b^3 $CellContext`c^7 + 3 $CellContext`a^2 $CellContext`c^8 - 
    3 $CellContext`a $CellContext`b $CellContext`c^8 - $CellContext`b^2 \
$CellContext`c^8 + $CellContext`a $CellContext`c^9 + $CellContext`b \
$CellContext`c^9 - $CellContext`c^10, -$CellContext`a^10 + $CellContext`a^9 \
$CellContext`b + 3 $CellContext`a^8 $CellContext`b^2 - 
    4 $CellContext`a^7 $CellContext`b^3 - 2 $CellContext`a^6 $CellContext`b^4 + 
    6 $CellContext`a^5 $CellContext`b^5 - 2 $CellContext`a^4 $CellContext`b^6 - 
    4 $CellContext`a^3 $CellContext`b^7 + 
    3 $CellContext`a^2 $CellContext`b^8 + $CellContext`a $CellContext`b^9 - \
$CellContext`b^10 + $CellContext`a^9 $CellContext`c - 
    3 $CellContext`a^8 $CellContext`b $CellContext`c + 
    8 $CellContext`a^6 $CellContext`b^3 $CellContext`c - 
    6 $CellContext`a^5 $CellContext`b^4 $CellContext`c - 
    6 $CellContext`a^4 $CellContext`b^5 $CellContext`c + 
    8 $CellContext`a^3 $CellContext`b^6 $CellContext`c - 
    3 $CellContext`a $CellContext`b^8 $CellContext`c + $CellContext`b^9 \
$CellContext`c - $CellContext`a^8 $CellContext`c^2 + 
    6 $CellContext`a^7 $CellContext`b $CellContext`c^2 - 
    12 $CellContext`a^6 $CellContext`b^2 $CellContext`c^2 - 
    6 $CellContext`a^5 $CellContext`b^3 $CellContext`c^2 + 
    26 $CellContext`a^4 $CellContext`b^4 $CellContext`c^2 - 
    6 $CellContext`a^3 $CellContext`b^5 $CellContext`c^2 - 
    12 $CellContext`a^2 $CellContext`b^6 $CellContext`c^2 + 
    6 $CellContext`a $CellContext`b^7 $CellContext`c^2 - $CellContext`b^8 \
$CellContext`c^2 - 2 $CellContext`a^7 $CellContext`c^3 - 
    2 $CellContext`a^6 $CellContext`b $CellContext`c^3 + 
    18 $CellContext`a^5 $CellContext`b^2 $CellContext`c^3 - 
    14 $CellContext`a^4 $CellContext`b^3 $CellContext`c^3 - 
    14 $CellContext`a^3 $CellContext`b^4 $CellContext`c^3 + 
    18 $CellContext`a^2 $CellContext`b^5 $CellContext`c^3 - 
    2 $CellContext`a $CellContext`b^6 $CellContext`c^3 - 
    2 $CellContext`b^7 $CellContext`c^3 + 8 $CellContext`a^6 $CellContext`c^4 - 
    12 $CellContext`a^5 $CellContext`b $CellContext`c^4 - 
    8 $CellContext`a^4 $CellContext`b^2 $CellContext`c^4 + 
    24 $CellContext`a^3 $CellContext`b^3 $CellContext`c^4 - 
    8 $CellContext`a^2 $CellContext`b^4 $CellContext`c^4 - 
    12 $CellContext`a $CellContext`b^5 $CellContext`c^4 + 
    8 $CellContext`b^6 $CellContext`c^4 + 
    12 $CellContext`a^4 $CellContext`b $CellContext`c^5 - 
    12 $CellContext`a^3 $CellContext`b^2 $CellContext`c^5 - 
    12 $CellContext`a^2 $CellContext`b^3 $CellContext`c^5 + 
    12 $CellContext`a $CellContext`b^4 $CellContext`c^5 - 
    8 $CellContext`a^4 $CellContext`c^6 + 
    2 $CellContext`a^3 $CellContext`b $CellContext`c^6 + 
    16 $CellContext`a^2 $CellContext`b^2 $CellContext`c^6 + 
    2 $CellContext`a $CellContext`b^3 $CellContext`c^6 - 
    8 $CellContext`b^4 $CellContext`c^6 + 2 $CellContext`a^3 $CellContext`c^7 - 
    6 $CellContext`a^2 $CellContext`b $CellContext`c^7 - 
    6 $CellContext`a $CellContext`b^2 $CellContext`c^7 + 
    2 $CellContext`b^3 $CellContext`c^7 + $CellContext`a^2 $CellContext`c^8 + 
    3 $CellContext`a $CellContext`b $CellContext`c^8 + $CellContext`b^2 \
$CellContext`c^8 - $CellContext`a $CellContext`c^9 - $CellContext`b \
$CellContext`c^9 + $CellContext`c^10}, "   XM/AM=", 
   Style[3, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938943675*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"75cf250d-3e25-49c1-a240-a4dd28db53fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "152"}],
  SequenceForm["n=", 152],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938948979*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"fd49f28f-2caa-447a-b6bb-4ea231bf2b26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "152", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "8"], "-", 
      RowBox[{
       SuperscriptBox["a", "7"], " ", "b"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "3"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "5"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "6"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "7"]}], "-", 
      SuperscriptBox["b", "8"], "-", 
      RowBox[{
       SuperscriptBox["a", "7"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", "b", " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "3"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "4"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "5"], " ", "c"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "6"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "7"], " ", "c"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "5"], " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"3", " ", "a", " ", 
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "b", " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"3", " ", "a", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "b", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"3", " ", "a", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b", " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{"3", " ", "a", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{"a", " ", "b", " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "7"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "7"]}], "-", 
      SuperscriptBox["c", "8"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "7"], " ", "b"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "3"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "5"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "6"]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "7"]}], "+", 
      SuperscriptBox["b", "8"], "+", 
      RowBox[{
       SuperscriptBox["a", "7"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", "b", " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "3"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "4"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "5"], " ", "c"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "6"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["b", "7"], " ", "c"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "5"], " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", "b", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "3"], " ", "b", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", "b", " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "5"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "5"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{"a", " ", "b", " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "7"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "7"]}], "-", 
      SuperscriptBox["c", "8"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "7"], " ", "b"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "5"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "6"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "7"]}], "-", 
      SuperscriptBox["b", "8"], "+", 
      RowBox[{
       SuperscriptBox["a", "7"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", "b", " ", "c"}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "3"], " ", "c"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "4"], " ", "c"}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "5"], " ", "c"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "6"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "7"], " ", "c"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "5"], " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "b", " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "b", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["c", "5"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b", " ", 
       SuperscriptBox["c", "5"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "5"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"a", " ", "b", " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "7"]}], "-", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "7"]}], "+", 
      SuperscriptBox["c", "8"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox["3",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 152, 
   "   ", {$CellContext`a^8 - $CellContext`a^7 $CellContext`b + 
    2 $CellContext`a^6 $CellContext`b^2 - 5 $CellContext`a^5 $CellContext`b^3 + 
    5 $CellContext`a^3 $CellContext`b^5 - 
    2 $CellContext`a^2 $CellContext`b^6 + $CellContext`a $CellContext`b^7 - \
$CellContext`b^8 - $CellContext`a^7 $CellContext`c + $CellContext`a^6 \
$CellContext`b $CellContext`c + $CellContext`a^5 $CellContext`b^2 \
$CellContext`c - $CellContext`a^4 $CellContext`b^3 $CellContext`c + \
$CellContext`a^3 $CellContext`b^4 $CellContext`c - $CellContext`a^2 \
$CellContext`b^5 $CellContext`c - $CellContext`a $CellContext`b^6 \
$CellContext`c + $CellContext`b^7 $CellContext`c + 
    2 $CellContext`a^6 $CellContext`c^2 + $CellContext`a^5 $CellContext`b \
$CellContext`c^2 + 6 $CellContext`a^4 $CellContext`b^2 $CellContext`c^2 - 
    6 $CellContext`a^3 $CellContext`b^3 $CellContext`c^2 - 
    2 $CellContext`a^2 $CellContext`b^4 $CellContext`c^2 - 
    3 $CellContext`a $CellContext`b^5 $CellContext`c^2 + 
    2 $CellContext`b^6 $CellContext`c^2 - 
    5 $CellContext`a^5 $CellContext`c^3 - $CellContext`a^4 $CellContext`b \
$CellContext`c^3 - 6 $CellContext`a^3 $CellContext`b^2 $CellContext`c^3 + 
    10 $CellContext`a^2 $CellContext`b^3 $CellContext`c^3 + 
    3 $CellContext`a $CellContext`b^4 $CellContext`c^3 - $CellContext`b^5 \
$CellContext`c^3 + $CellContext`a^3 $CellContext`b $CellContext`c^4 - 
    2 $CellContext`a^2 $CellContext`b^2 $CellContext`c^4 + 
    3 $CellContext`a $CellContext`b^3 $CellContext`c^4 - 
    2 $CellContext`b^4 $CellContext`c^4 + 
    5 $CellContext`a^3 $CellContext`c^5 - $CellContext`a^2 $CellContext`b \
$CellContext`c^5 - 
    3 $CellContext`a $CellContext`b^2 $CellContext`c^5 - $CellContext`b^3 \
$CellContext`c^5 - 
    2 $CellContext`a^2 $CellContext`c^6 - $CellContext`a $CellContext`b \
$CellContext`c^6 + 
    2 $CellContext`b^2 $CellContext`c^6 + $CellContext`a $CellContext`c^7 + \
$CellContext`b $CellContext`c^7 - $CellContext`c^8, -$CellContext`a^8 + \
$CellContext`a^7 $CellContext`b - 2 $CellContext`a^6 $CellContext`b^2 + 
    5 $CellContext`a^5 $CellContext`b^3 - 5 $CellContext`a^3 $CellContext`b^5 + 
    2 $CellContext`a^2 $CellContext`b^6 - $CellContext`a $CellContext`b^7 + \
$CellContext`b^8 + $CellContext`a^7 $CellContext`c - $CellContext`a^6 \
$CellContext`b $CellContext`c - $CellContext`a^5 $CellContext`b^2 \
$CellContext`c + $CellContext`a^4 $CellContext`b^3 $CellContext`c - \
$CellContext`a^3 $CellContext`b^4 $CellContext`c + $CellContext`a^2 \
$CellContext`b^5 $CellContext`c + $CellContext`a $CellContext`b^6 \
$CellContext`c - $CellContext`b^7 $CellContext`c + 
    2 $CellContext`a^6 $CellContext`c^2 - 
    3 $CellContext`a^5 $CellContext`b $CellContext`c^2 - 
    2 $CellContext`a^4 $CellContext`b^2 $CellContext`c^2 - 
    6 $CellContext`a^3 $CellContext`b^3 $CellContext`c^2 + 
    6 $CellContext`a^2 $CellContext`b^4 $CellContext`c^2 + $CellContext`a \
$CellContext`b^5 $CellContext`c^2 + 
    2 $CellContext`b^6 $CellContext`c^2 - $CellContext`a^5 $CellContext`c^3 + 
    3 $CellContext`a^4 $CellContext`b $CellContext`c^3 + 
    10 $CellContext`a^3 $CellContext`b^2 $CellContext`c^3 - 
    6 $CellContext`a^2 $CellContext`b^3 $CellContext`c^3 - $CellContext`a \
$CellContext`b^4 $CellContext`c^3 - 5 $CellContext`b^5 $CellContext`c^3 - 
    2 $CellContext`a^4 $CellContext`c^4 + 
    3 $CellContext`a^3 $CellContext`b $CellContext`c^4 - 
    2 $CellContext`a^2 $CellContext`b^2 $CellContext`c^4 + $CellContext`a \
$CellContext`b^3 $CellContext`c^4 - $CellContext`a^3 $CellContext`c^5 - 
    3 $CellContext`a^2 $CellContext`b $CellContext`c^5 - $CellContext`a \
$CellContext`b^2 $CellContext`c^5 + 5 $CellContext`b^3 $CellContext`c^5 + 
    2 $CellContext`a^2 $CellContext`c^6 - $CellContext`a $CellContext`b \
$CellContext`c^6 - 
    2 $CellContext`b^2 $CellContext`c^6 + $CellContext`a $CellContext`c^7 + \
$CellContext`b $CellContext`c^7 - $CellContext`c^8, -$CellContext`a^8 + \
$CellContext`a^7 $CellContext`b + 
    2 $CellContext`a^6 $CellContext`b^2 - $CellContext`a^5 $CellContext`b^3 - 
    2 $CellContext`a^4 $CellContext`b^4 - $CellContext`a^3 $CellContext`b^5 + 
    2 $CellContext`a^2 $CellContext`b^6 + $CellContext`a $CellContext`b^7 - \
$CellContext`b^8 + $CellContext`a^7 $CellContext`c - $CellContext`a^6 \
$CellContext`b $CellContext`c - 
    3 $CellContext`a^5 $CellContext`b^2 $CellContext`c + 
    3 $CellContext`a^4 $CellContext`b^3 $CellContext`c + 
    3 $CellContext`a^3 $CellContext`b^4 $CellContext`c - 
    3 $CellContext`a^2 $CellContext`b^5 $CellContext`c - $CellContext`a \
$CellContext`b^6 $CellContext`c + $CellContext`b^7 $CellContext`c - 
    2 $CellContext`a^6 $CellContext`c^2 - $CellContext`a^5 $CellContext`b \
$CellContext`c^2 - 2 $CellContext`a^4 $CellContext`b^2 $CellContext`c^2 + 
    10 $CellContext`a^3 $CellContext`b^3 $CellContext`c^2 - 
    2 $CellContext`a^2 $CellContext`b^4 $CellContext`c^2 - $CellContext`a \
$CellContext`b^5 $CellContext`c^2 - 2 $CellContext`b^6 $CellContext`c^2 + 
    5 $CellContext`a^5 $CellContext`c^3 + $CellContext`a^4 $CellContext`b \
$CellContext`c^3 - 6 $CellContext`a^3 $CellContext`b^2 $CellContext`c^3 - 
    6 $CellContext`a^2 $CellContext`b^3 $CellContext`c^3 + $CellContext`a \
$CellContext`b^4 $CellContext`c^3 + 
    5 $CellContext`b^5 $CellContext`c^3 - $CellContext`a^3 $CellContext`b \
$CellContext`c^4 + 
    6 $CellContext`a^2 $CellContext`b^2 $CellContext`c^4 - $CellContext`a \
$CellContext`b^3 $CellContext`c^4 - 
    5 $CellContext`a^3 $CellContext`c^5 + $CellContext`a^2 $CellContext`b \
$CellContext`c^5 + $CellContext`a $CellContext`b^2 $CellContext`c^5 - 
    5 $CellContext`b^3 $CellContext`c^5 + 
    2 $CellContext`a^2 $CellContext`c^6 + $CellContext`a $CellContext`b \
$CellContext`c^6 + 
    2 $CellContext`b^2 $CellContext`c^6 - $CellContext`a $CellContext`c^7 - \
$CellContext`b $CellContext`c^7 + $CellContext`c^8}, "   XM/AM=", 
   Style[3, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979389536*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"314f3435-bf8b-48ae-b907-7e206b27bc5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "153"}],
  SequenceForm["n=", 153],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938957272*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"ddd7dcf1-7318-4ed6-8a75-eb40206aafd2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "153", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "7"], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", "b"}], "-", 
      RowBox[{
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "5"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "6"]}], "-", 
      SuperscriptBox["b", "7"], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", "c"}], "+", 
      RowBox[{"7", " ", 
       SuperscriptBox["a", "5"], " ", "b", " ", "c"}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "3"], " ", "c"}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "4"], " ", "c"}], "-", 
      RowBox[{"5", " ", "a", " ", 
       SuperscriptBox["b", "5"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "6"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "4"], " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", "b", " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"10", " ", "a", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"], " ", "b", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{"5", " ", "a", " ", "b", " ", 
       SuperscriptBox["c", "5"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "5"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "6"]}], "-", 
      SuperscriptBox["c", "7"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "7"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", "b"}], "+", 
      RowBox[{
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "3"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "5"]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "6"]}], "+", 
      SuperscriptBox["b", "7"], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", "c"}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "5"], " ", "b", " ", "c"}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "3"], " ", "c"}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "4"], " ", "c"}], "+", 
      RowBox[{"7", " ", "a", " ", 
       SuperscriptBox["b", "5"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["b", "6"], " ", "c"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"5", " ", "a", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["a", "3"], " ", "b", " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"2", " ", "a", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"5", " ", "a", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{"5", " ", "a", " ", "b", " ", 
       SuperscriptBox["c", "5"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "5"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "6"]}], "-", 
      SuperscriptBox["c", "7"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "7"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", "b"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "3"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "5"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "6"]}], "-", 
      SuperscriptBox["b", "7"], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", "c"}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "5"], " ", "b", " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "3"], " ", "c"}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "4"], " ", "c"}], "-", 
      RowBox[{"5", " ", "a", " ", 
       SuperscriptBox["b", "5"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["b", "6"], " ", "c"}], "+", 
      RowBox[{
       SuperscriptBox["a", "5"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "4"], " ", "b", " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"5", " ", "a", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", "b", " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"2", " ", "a", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "3"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"], " ", "b", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"5", " ", "a", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "5"]}], "+", 
      RowBox[{"7", " ", "a", " ", "b", " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "5"]}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "6"]}], "+", 
      SuperscriptBox["c", "7"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox["3",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 153, 
   "   ", {$CellContext`a^7 - $CellContext`a^6 $CellContext`b - \
$CellContext`a^5 $CellContext`b^2 + $CellContext`a^4 $CellContext`b^3 - \
$CellContext`a^3 $CellContext`b^4 + $CellContext`a^2 $CellContext`b^5 + \
$CellContext`a $CellContext`b^6 - $CellContext`b^7 - $CellContext`a^6 \
$CellContext`c + 7 $CellContext`a^5 $CellContext`b $CellContext`c - 
    5 $CellContext`a^4 $CellContext`b^2 $CellContext`c - 
    2 $CellContext`a^3 $CellContext`b^3 $CellContext`c + 
    5 $CellContext`a^2 $CellContext`b^4 $CellContext`c - 
    5 $CellContext`a $CellContext`b^5 $CellContext`c + $CellContext`b^6 \
$CellContext`c - $CellContext`a^5 $CellContext`c^2 - 
    5 $CellContext`a^4 $CellContext`b $CellContext`c^2 + 
    10 $CellContext`a^3 $CellContext`b^2 $CellContext`c^2 - 
    6 $CellContext`a^2 $CellContext`b^3 $CellContext`c^2 - $CellContext`a \
$CellContext`b^4 $CellContext`c^2 + 
    3 $CellContext`b^5 $CellContext`c^2 + $CellContext`a^4 $CellContext`c^3 - 
    2 $CellContext`a^3 $CellContext`b $CellContext`c^3 - 
    6 $CellContext`a^2 $CellContext`b^2 $CellContext`c^3 + 
    10 $CellContext`a $CellContext`b^3 $CellContext`c^3 - 
    3 $CellContext`b^4 $CellContext`c^3 - $CellContext`a^3 $CellContext`c^4 + 
    5 $CellContext`a^2 $CellContext`b $CellContext`c^4 - $CellContext`a \
$CellContext`b^2 $CellContext`c^4 - 
    3 $CellContext`b^3 $CellContext`c^4 + $CellContext`a^2 $CellContext`c^5 - 
    5 $CellContext`a $CellContext`b $CellContext`c^5 + 
    3 $CellContext`b^2 $CellContext`c^5 + $CellContext`a $CellContext`c^6 + \
$CellContext`b $CellContext`c^6 - $CellContext`c^7, -$CellContext`a^7 + \
$CellContext`a^6 $CellContext`b + $CellContext`a^5 $CellContext`b^2 - \
$CellContext`a^4 $CellContext`b^3 + $CellContext`a^3 $CellContext`b^4 - \
$CellContext`a^2 $CellContext`b^5 - $CellContext`a $CellContext`b^6 + \
$CellContext`b^7 + $CellContext`a^6 $CellContext`c - 
    5 $CellContext`a^5 $CellContext`b $CellContext`c + 
    5 $CellContext`a^4 $CellContext`b^2 $CellContext`c - 
    2 $CellContext`a^3 $CellContext`b^3 $CellContext`c - 
    5 $CellContext`a^2 $CellContext`b^4 $CellContext`c + 
    7 $CellContext`a $CellContext`b^5 $CellContext`c - $CellContext`b^6 \
$CellContext`c + 
    3 $CellContext`a^5 $CellContext`c^2 - $CellContext`a^4 $CellContext`b \
$CellContext`c^2 - 6 $CellContext`a^3 $CellContext`b^2 $CellContext`c^2 + 
    10 $CellContext`a^2 $CellContext`b^3 $CellContext`c^2 - 
    5 $CellContext`a $CellContext`b^4 $CellContext`c^2 - $CellContext`b^5 \
$CellContext`c^2 - 3 $CellContext`a^4 $CellContext`c^3 + 
    10 $CellContext`a^3 $CellContext`b $CellContext`c^3 - 
    6 $CellContext`a^2 $CellContext`b^2 $CellContext`c^3 - 
    2 $CellContext`a $CellContext`b^3 $CellContext`c^3 + $CellContext`b^4 \
$CellContext`c^3 - 
    3 $CellContext`a^3 $CellContext`c^4 - $CellContext`a^2 $CellContext`b \
$CellContext`c^4 + 
    5 $CellContext`a $CellContext`b^2 $CellContext`c^4 - $CellContext`b^3 \
$CellContext`c^4 + 3 $CellContext`a^2 $CellContext`c^5 - 
    5 $CellContext`a $CellContext`b $CellContext`c^5 + $CellContext`b^2 \
$CellContext`c^5 + $CellContext`a $CellContext`c^6 + $CellContext`b \
$CellContext`c^6 - $CellContext`c^7, -$CellContext`a^7 + $CellContext`a^6 \
$CellContext`b + 3 $CellContext`a^5 $CellContext`b^2 - 
    3 $CellContext`a^4 $CellContext`b^3 - 3 $CellContext`a^3 $CellContext`b^4 + 
    3 $CellContext`a^2 $CellContext`b^5 + $CellContext`a $CellContext`b^6 - \
$CellContext`b^7 + $CellContext`a^6 $CellContext`c - 
    5 $CellContext`a^5 $CellContext`b $CellContext`c - $CellContext`a^4 \
$CellContext`b^2 $CellContext`c + 
    10 $CellContext`a^3 $CellContext`b^3 $CellContext`c - $CellContext`a^2 \
$CellContext`b^4 $CellContext`c - 
    5 $CellContext`a $CellContext`b^5 $CellContext`c + $CellContext`b^6 \
$CellContext`c + $CellContext`a^5 $CellContext`c^2 + 
    5 $CellContext`a^4 $CellContext`b $CellContext`c^2 - 
    6 $CellContext`a^3 $CellContext`b^2 $CellContext`c^2 - 
    6 $CellContext`a^2 $CellContext`b^3 $CellContext`c^2 + 
    5 $CellContext`a $CellContext`b^4 $CellContext`c^2 + $CellContext`b^5 \
$CellContext`c^2 - $CellContext`a^4 $CellContext`c^3 - 
    2 $CellContext`a^3 $CellContext`b $CellContext`c^3 + 
    10 $CellContext`a^2 $CellContext`b^2 $CellContext`c^3 - 
    2 $CellContext`a $CellContext`b^3 $CellContext`c^3 - $CellContext`b^4 \
$CellContext`c^3 + $CellContext`a^3 $CellContext`c^4 - 
    5 $CellContext`a^2 $CellContext`b $CellContext`c^4 - 
    5 $CellContext`a $CellContext`b^2 $CellContext`c^4 + $CellContext`b^3 \
$CellContext`c^4 - $CellContext`a^2 $CellContext`c^5 + 
    7 $CellContext`a $CellContext`b $CellContext`c^5 - $CellContext`b^2 \
$CellContext`c^5 - $CellContext`a $CellContext`c^6 - $CellContext`b \
$CellContext`c^6 + $CellContext`c^7}, "   XM/AM=", 
   Style[3, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938960987*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"256ca2d7-b5ca-4717-8b48-8b976c72c584"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "154"}],
  SequenceForm["n=", 154],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938964344*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a0f61774-a7d9-4a8b-a5a9-cc6d9d389bd0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "155"}],
  SequenceForm["n=", 155],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938965609*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"902dedb7-6d17-486b-9db0-27c4af1fc3af"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "156"}],
  SequenceForm["n=", 156],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979389668303`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"47355131-9a58-4976-9fcd-95b156332986"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "157"}],
  SequenceForm["n=", 157],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979389679832`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"68f0c73e-ce25-40ed-abd1-7a453eacac3a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "158"}],
  SequenceForm["n=", 158],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938969162*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"200a0f91-52e7-4a03-a6a6-39170935139b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "159"}],
  SequenceForm["n=", 159],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979389703608`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"c9d59bf2-70f8-48a9-a587-53c2818c8d6f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "160"}],
  SequenceForm["n=", 160],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938971533*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"2d718167-8eaa-448c-9408-af4f697002ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "160", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", "1"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 160, 
   "   ", {$CellContext`a^4 ($CellContext`a^2 $CellContext`b^2 - \
$CellContext`b^4 + $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 \
$CellContext`c^2 - $CellContext`c^4), $CellContext`b^4 (-$CellContext`a^4 + \
$CellContext`a^2 $CellContext`b^2 - $CellContext`a^2 $CellContext`c^2 + \
$CellContext`b^2 $CellContext`c^2 - $CellContext`c^4), $CellContext`c^4 \
(-$CellContext`a^4 - $CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 + \
$CellContext`a^2 $CellContext`c^2 + $CellContext`b^2 $CellContext`c^2)}, 
   "   XM/AM=", 
   Style[-1, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938973404*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"4fc6ec18-4ba4-4b09-a298-09b10a3793ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "161"}],
  SequenceForm["n=", 161],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938975162*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"60f0927f-0980-4458-8010-276c6d92f440"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "162"}],
  SequenceForm["n=", 162],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938976404*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"dfafd102-4f3e-4aee-975a-67fdd705bba4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "163"}],
  SequenceForm["n=", 163],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097938977693*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"18614846-c110-4a94-ac08-2b7f06bb424f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "164"}],
  SequenceForm["n=", 164],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979389788933`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"07227088-0b5a-4600-a990-d8f9e5b08675"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "164", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        SqrtBox[
         RowBox[{"a", " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"a", "-", "b", "+", "c"}], ")"}]}]], "-", 
        SqrtBox[
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]], "-", 
        SqrtBox[
         RowBox[{"c", " ", 
          RowBox[{"(", 
           RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]]}], ")"}]}], 
     ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SqrtBox[
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "+", "c"}], ")"}]}]]}], "+", 
        SqrtBox[
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]], "-", 
        SqrtBox[
         RowBox[{"c", " ", 
          RowBox[{"(", 
           RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]]}], ")"}]}], 
     ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SqrtBox[
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b", "+", "c"}], ")"}]}]]}], "-", 
        SqrtBox[
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]], "+", 
        SqrtBox[
         RowBox[{"c", " ", 
          RowBox[{"(", 
           RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]]}], ")"}]}]}], 
    "}"}], "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{
      SqrtBox["2"], "-", 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"2", "-", 
         SqrtBox["2"]}]]}]}], 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      SqrtBox["2"], "-", 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"2", "-", 
         SqrtBox["2"]}]]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 164, 
   "   ", {$CellContext`a (($CellContext`a ($CellContext`a + $CellContext`b - \
$CellContext`c) ($CellContext`a - $CellContext`b + $CellContext`c))^
      Rational[1, 
        2] - ($CellContext`b ($CellContext`a + $CellContext`b - \
$CellContext`c) (-$CellContext`a + $CellContext`b + $CellContext`c))^
     Rational[1, 
       2] - ($CellContext`c ($CellContext`a - $CellContext`b + \
$CellContext`c) (-$CellContext`a + $CellContext`b + $CellContext`c))^
     Rational[1, 
       2]), $CellContext`b (-($CellContext`a ($CellContext`a + $CellContext`b - \
$CellContext`c) ($CellContext`a - $CellContext`b + $CellContext`c))^
       Rational[
        1, 2] + ($CellContext`b ($CellContext`a + $CellContext`b - \
$CellContext`c) (-$CellContext`a + $CellContext`b + $CellContext`c))^
      Rational[1, 
        2] - ($CellContext`c ($CellContext`a - $CellContext`b + \
$CellContext`c) (-$CellContext`a + $CellContext`b + $CellContext`c))^
     Rational[1, 
       2]), $CellContext`c (-($CellContext`a ($CellContext`a + $CellContext`b - \
$CellContext`c) ($CellContext`a - $CellContext`b + $CellContext`c))^
       Rational[
        1, 2] - ($CellContext`b ($CellContext`a + $CellContext`b - \
$CellContext`c) (-$CellContext`a + $CellContext`b + $CellContext`c))^
     Rational[1, 
       2] + ($CellContext`c ($CellContext`a - $CellContext`b + \
$CellContext`c) (-$CellContext`a + $CellContext`b + $CellContext`c))^
      Rational[1, 2])}, "   XM/AM=", 
   Style[(-2 + 2^Rational[1, 2] - 
      2 (2 - 2^Rational[1, 2])^Rational[1, 2])^(-1) (2^Rational[1, 2] - 
     2 (2 - 2^Rational[1, 2])^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097939018805*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a6d7747f-4fa5-40ec-aa21-7bc549931ef7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "165"}],
  SequenceForm["n=", 165],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097939021242*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"9cab8fa7-76ff-4c54-a9c1-565e48153eb0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "165", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"2", " ", "a", " ", "b"}], "-", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", "a", " ", "c"}], "+", 
        RowBox[{"2", " ", "b", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"2", " ", "a", " ", "b"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", "a", " ", "c"}], "-", 
        RowBox[{"2", " ", "b", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{"2", " ", "a", " ", "b"}], "-", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", "a", " ", "c"}], "-", 
        RowBox[{"2", " ", "b", " ", "c"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SqrtBox["2"]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 165, 
   "   ", {$CellContext`a (3 $CellContext`a^2 - 
     2 $CellContext`a $CellContext`b - $CellContext`b^2 - 
     2 $CellContext`a $CellContext`c + 
     2 $CellContext`b $CellContext`c - $CellContext`c^2), $CellContext`b \
(-$CellContext`a^2 - 2 $CellContext`a $CellContext`b + 3 $CellContext`b^2 + 
     2 $CellContext`a $CellContext`c - 
     2 $CellContext`b $CellContext`c - $CellContext`c^2), $CellContext`c \
(-$CellContext`a^2 + 2 $CellContext`a $CellContext`b - $CellContext`b^2 - 
     2 $CellContext`a $CellContext`c - 2 $CellContext`b $CellContext`c + 
     3 $CellContext`c^2)}, "   XM/AM=", 
   Style[Rational[1, 3] (1 - 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097939056851*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"6c867f42-f39c-41cc-85d9-8a5025bff966"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "166"}],
  SequenceForm["n=", 166],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097939060294*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"49ae287b-815e-4d4d-88e5-73c65da41852"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "167"}],
  SequenceForm["n=", 167],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979398019543`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"827cd299-52d7-4b39-b350-67de707c1b68"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "168"}],
  SequenceForm["n=", 168],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097940036869*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"1dd35fc8-e1d9-4e2c-8789-0af4f005c6db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "169"}],
  SequenceForm["n=", 169],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097940274024*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"90201050-c21a-498e-abb6-f1eb4d6dfbe0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "169", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", "2"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 169, 
   "   ", {$CellContext`a ($CellContext`a^3 - $CellContext`a^2 $CellContext`b + \
$CellContext`a $CellContext`b^2 - $CellContext`b^3 - $CellContext`a^2 \
$CellContext`c + $CellContext`b^2 $CellContext`c + $CellContext`a \
$CellContext`c^2 + $CellContext`b $CellContext`c^2 - $CellContext`c^3), \
$CellContext`b (-$CellContext`a^3 + $CellContext`a^2 $CellContext`b - \
$CellContext`a $CellContext`b^2 + $CellContext`b^3 + $CellContext`a^2 \
$CellContext`c - $CellContext`b^2 $CellContext`c + $CellContext`a \
$CellContext`c^2 + $CellContext`b $CellContext`c^2 - $CellContext`c^3), \
$CellContext`c (-$CellContext`a^3 + $CellContext`a^2 $CellContext`b + \
$CellContext`a $CellContext`b^2 - $CellContext`b^3 + $CellContext`a^2 \
$CellContext`c + $CellContext`b^2 $CellContext`c - $CellContext`a \
$CellContext`c^2 - $CellContext`b $CellContext`c^2 + $CellContext`c^3)}, 
   "   XM/AM=", 
   Style[
    Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979402801456`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"fa05db61-7fb6-41e4-b7b9-b6b5f8f1b643"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "170"}],
  SequenceForm["n=", 170],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097940282207*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"cbd9fc59-5040-4ed7-9d64-bb959a0ec275"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "170", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "5"], " ", "b"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "3"], " ", 
         SuperscriptBox["b", "3"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "5"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "5"], " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", "b", " ", "c"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "3"], " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "3"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "4"], " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "5"], " ", "c"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "3"], " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["b", "3"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "3"], " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", "b", " ", 
         SuperscriptBox["c", "3"]}], "-", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "3"]}], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["b", "3"], " ", 
         SuperscriptBox["c", "3"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"a", " ", "b", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "5"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "5"]}]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "5"], " ", "b"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "3"], " ", 
         SuperscriptBox["b", "3"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "5"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "5"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", "b", " ", "c"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "3"], " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "3"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "4"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "5"], " ", "c"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "3"], " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["b", "3"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "3"], " ", 
         SuperscriptBox["c", "3"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", "b", " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["b", "3"], " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"a", " ", "b", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "5"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "5"]}]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "5"]}], " ", "b"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "3"], " ", 
         SuperscriptBox["b", "3"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "5"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "5"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", "b", " ", "c"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "3"], " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "3"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "4"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "5"], " ", "c"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "3"], " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["b", "3"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "3"], " ", 
         SuperscriptBox["c", "3"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", "b", " ", 
         SuperscriptBox["c", "3"]}], "-", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["b", "3"], " ", 
         SuperscriptBox["c", "3"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"a", " ", "b", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "5"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "5"]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["3", "17"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"3", " ", 
        SqrtBox["2"]}]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 170, 
   "   ", {$CellContext`a ($CellContext`a^5 $CellContext`b - 
     4 $CellContext`a^4 $CellContext`b^2 + 
     6 $CellContext`a^3 $CellContext`b^3 - 
     4 $CellContext`a^2 $CellContext`b^4 + $CellContext`a $CellContext`b^5 + \
$CellContext`a^5 $CellContext`c - $CellContext`a^4 $CellContext`b \
$CellContext`c - 2 $CellContext`a^3 $CellContext`b^2 $CellContext`c + 
     2 $CellContext`a^2 $CellContext`b^3 $CellContext`c + $CellContext`a \
$CellContext`b^4 $CellContext`c - $CellContext`b^5 $CellContext`c - 
     4 $CellContext`a^4 $CellContext`c^2 - 
     2 $CellContext`a^3 $CellContext`b $CellContext`c^2 + 
     4 $CellContext`a^2 $CellContext`b^2 $CellContext`c^2 - 
     2 $CellContext`a $CellContext`b^3 $CellContext`c^2 + 
     4 $CellContext`b^4 $CellContext`c^2 + 
     6 $CellContext`a^3 $CellContext`c^3 + 
     2 $CellContext`a^2 $CellContext`b $CellContext`c^3 - 
     2 $CellContext`a $CellContext`b^2 $CellContext`c^3 - 
     6 $CellContext`b^3 $CellContext`c^3 - 
     4 $CellContext`a^2 $CellContext`c^4 + $CellContext`a $CellContext`b \
$CellContext`c^4 + 
     4 $CellContext`b^2 $CellContext`c^4 + $CellContext`a $CellContext`c^5 - \
$CellContext`b $CellContext`c^5), $CellContext`b ($CellContext`a^5 \
$CellContext`b - 4 $CellContext`a^4 $CellContext`b^2 + 
     6 $CellContext`a^3 $CellContext`b^3 - 
     4 $CellContext`a^2 $CellContext`b^4 + $CellContext`a $CellContext`b^5 - \
$CellContext`a^5 $CellContext`c + $CellContext`a^4 $CellContext`b \
$CellContext`c + 2 $CellContext`a^3 $CellContext`b^2 $CellContext`c - 
     2 $CellContext`a^2 $CellContext`b^3 $CellContext`c - $CellContext`a \
$CellContext`b^4 $CellContext`c + $CellContext`b^5 $CellContext`c + 
     4 $CellContext`a^4 $CellContext`c^2 - 
     2 $CellContext`a^3 $CellContext`b $CellContext`c^2 + 
     4 $CellContext`a^2 $CellContext`b^2 $CellContext`c^2 - 
     2 $CellContext`a $CellContext`b^3 $CellContext`c^2 - 
     4 $CellContext`b^4 $CellContext`c^2 - 
     6 $CellContext`a^3 $CellContext`c^3 - 
     2 $CellContext`a^2 $CellContext`b $CellContext`c^3 + 
     2 $CellContext`a $CellContext`b^2 $CellContext`c^3 + 
     6 $CellContext`b^3 $CellContext`c^3 + 
     4 $CellContext`a^2 $CellContext`c^4 + $CellContext`a $CellContext`b \
$CellContext`c^4 - 
     4 $CellContext`b^2 $CellContext`c^4 - $CellContext`a $CellContext`c^5 + \
$CellContext`b $CellContext`c^5), $CellContext`c (-$CellContext`a^5 \
$CellContext`b + 4 $CellContext`a^4 $CellContext`b^2 - 
     6 $CellContext`a^3 $CellContext`b^3 + 
     4 $CellContext`a^2 $CellContext`b^4 - $CellContext`a $CellContext`b^5 + \
$CellContext`a^5 $CellContext`c + $CellContext`a^4 $CellContext`b \
$CellContext`c - 2 $CellContext`a^3 $CellContext`b^2 $CellContext`c - 
     2 $CellContext`a^2 $CellContext`b^3 $CellContext`c + $CellContext`a \
$CellContext`b^4 $CellContext`c + $CellContext`b^5 $CellContext`c - 
     4 $CellContext`a^4 $CellContext`c^2 + 
     2 $CellContext`a^3 $CellContext`b $CellContext`c^2 + 
     4 $CellContext`a^2 $CellContext`b^2 $CellContext`c^2 + 
     2 $CellContext`a $CellContext`b^3 $CellContext`c^2 - 
     4 $CellContext`b^4 $CellContext`c^2 + 
     6 $CellContext`a^3 $CellContext`c^3 - 
     2 $CellContext`a^2 $CellContext`b $CellContext`c^3 - 
     2 $CellContext`a $CellContext`b^2 $CellContext`c^3 + 
     6 $CellContext`b^3 $CellContext`c^3 - 
     4 $CellContext`a^2 $CellContext`c^4 - $CellContext`a $CellContext`b \
$CellContext`c^4 - 
     4 $CellContext`b^2 $CellContext`c^4 + $CellContext`a $CellContext`c^5 + \
$CellContext`b $CellContext`c^5)}, "   XM/AM=", 
   Style[Rational[3, 17] (1 - 3 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097940316308*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"4977d45a-29bf-4042-a56a-e97b13cbcc23"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "171"}],
  SequenceForm["n=", 171],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109794031949*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"af5c0fd3-995e-41c8-bb33-89cf8d49214d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "171", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"b", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "b"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     RowBox[{"-", 
      FractionBox["3", "23"]}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "5"}], "+", 
       SqrtBox["2"]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 171, 
   "   ", {$CellContext`a ($CellContext`a^2 + $CellContext`b $CellContext`c), \
$CellContext`b ($CellContext`b^2 + $CellContext`a $CellContext`c), \
$CellContext`c ($CellContext`a $CellContext`b + $CellContext`c^2)}, 
   "   XM/AM=", 
   Style[Rational[-3, 23] (-5 + 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097940320912*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"5c41e648-ecf0-470d-b93f-8406b1fbafce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "172"}],
  SequenceForm["n=", 172],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979403224287`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"cee09fb9-d82c-44c3-bd18-6430a1828b51"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "172", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"b", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "b"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["3", 
     RowBox[{"4", "+", 
      SqrtBox["2"]}]],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 172, 
   "   ", {$CellContext`a^2 ($CellContext`a^2 + $CellContext`b \
$CellContext`c), $CellContext`b^2 ($CellContext`b^2 + $CellContext`a \
$CellContext`c), $CellContext`c^2 ($CellContext`a $CellContext`b + \
$CellContext`c^2)}, "   XM/AM=", 
   Style[3/(4 + 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097940323832*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f0b44a56-3f8d-494c-a900-b68916369396"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "173"}],
  SequenceForm["n=", 173],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979403252497`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"01ea50aa-bd82-4803-b533-7b263a2e928f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "173", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", "c"}]]}], "-", 
        SqrtBox[
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"a", "-", "b", "+", "c"}], ")"}]}]], "+", 
        SqrtBox[
         RowBox[{"a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]]}], ")"}]}], 
     ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", "c"}]]}], "+", 
        SqrtBox[
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"a", "-", "b", "+", "c"}], ")"}]}]], "-", 
        SqrtBox[
         RowBox[{"a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]]}], ")"}]}], 
     ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        SqrtBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", "c"}]], "-", 
        SqrtBox[
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"a", "-", "b", "+", "c"}], ")"}]}]], "-", 
        SqrtBox[
         RowBox[{"a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]]}], ")"}]}]}], 
    "}"}], "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     RowBox[{
      SqrtBox["2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        SqrtBox[
         RowBox[{"2", "-", 
          SqrtBox["2"]}]]}], ")"}]}], 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SqrtBox["2"]}], "+", 
      SqrtBox[
       RowBox[{"4", "-", 
        RowBox[{"2", " ", 
         SqrtBox["2"]}]}]], "-", 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"2", "-", 
         SqrtBox["2"]}]]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 173, 
   "   ", {$CellContext`a (-(($CellContext`a + $CellContext`b - \
$CellContext`c) $CellContext`c)^
       Rational[
        1, 2] - ($CellContext`b ($CellContext`a - $CellContext`b + \
$CellContext`c))^
     Rational[1, 
       2] + ($CellContext`a (-$CellContext`a + $CellContext`b + \
$CellContext`c))^
      Rational[1, 
        2]), $CellContext`b (-(($CellContext`a + $CellContext`b - \
$CellContext`c) $CellContext`c)^
       Rational[
        1, 2] + ($CellContext`b ($CellContext`a - $CellContext`b + \
$CellContext`c))^
      Rational[1, 
        2] - ($CellContext`a (-$CellContext`a + $CellContext`b + \
$CellContext`c))^
     Rational[1, 
       2]), $CellContext`c ((($CellContext`a + $CellContext`b - \
$CellContext`c) $CellContext`c)^
      Rational[1, 
        2] - ($CellContext`b ($CellContext`a - $CellContext`b + \
$CellContext`c))^
     Rational[1, 
       2] - ($CellContext`a (-$CellContext`a + $CellContext`b + \
$CellContext`c))^Rational[1, 2])}, "   XM/AM=", 
   Style[2^
     Rational[1, 2] ((-2) 2^Rational[1, 2] + (4 - 2 2^Rational[1, 2])^
       Rational[1, 2] - 
      2 (2 - 2^Rational[1, 2])^Rational[1, 2])^(-1) (-2 + (2 - 2^
       Rational[1, 2])^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097940425427*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"80fb240a-af66-4566-84eb-5a628c309213"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "174"}],
  SequenceForm["n=", 174],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097940428281*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"df0667bc-5351-49d3-9082-cf135ada2eae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "174", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"a", "-", "b", "+", "c"}], ")"}]}]], ",", 
     SqrtBox[
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]], ",", 
     SqrtBox[
      RowBox[{"c", " ", 
       RowBox[{"(", 
        RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     SqrtBox["2"], 
     RowBox[{
      SqrtBox["2"], "+", 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"2", "-", 
         SqrtBox["2"]}]]}]}]],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 174, 
   "   ", {($CellContext`a ($CellContext`a + $CellContext`b - $CellContext`c) \
($CellContext`a - $CellContext`b + $CellContext`c))^
    Rational[1, 
      2], ($CellContext`b ($CellContext`a + $CellContext`b - $CellContext`c) \
(-$CellContext`a + $CellContext`b + $CellContext`c))^
    Rational[1, 
      2], ($CellContext`c ($CellContext`a - $CellContext`b + $CellContext`c) \
(-$CellContext`a + $CellContext`b + $CellContext`c))^Rational[1, 2]}, 
   "   XM/AM=", 
   Style[2^Rational[1, 2]/(2^Rational[1, 2] + 
    2 (2 - 2^Rational[1, 2])^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097940461577*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"e94cfece-55d0-47fa-b64e-1b885e1eae9e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "175"}],
  SequenceForm["n=", 175],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097940463883*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"71295953-e0b4-4cbb-941b-524207e90501"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "176"}],
  SequenceForm["n=", 176],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097940513369*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"2372d605-3e1b-4845-879b-ea0ded575733"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "177"}],
  SequenceForm["n=", 177],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979405514708`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"ec6c7c64-ca92-4f84-ae9c-1900dbd3bb0a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "177", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SqrtBox[
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b", "+", "c"}], ")"}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SqrtBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", "c"}]], "+", 
        SqrtBox[
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"a", "-", "b", "+", "c"}], ")"}]}]]}], ")"}]}], ",", 
     RowBox[{
      SqrtBox[
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SqrtBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", "c"}]], "+", 
        SqrtBox[
         RowBox[{"a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]]}], ")"}]}], 
     ",", 
     RowBox[{
      SqrtBox[
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SqrtBox[
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"a", "-", "b", "+", "c"}], ")"}]}]], "+", 
        SqrtBox[
         RowBox[{"a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]]}], ")"}]}]}], 
    "}"}], "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     SqrtBox["2"], 
     RowBox[{"2", "+", 
      SqrtBox[
       RowBox[{"2", "-", 
        SqrtBox["2"]}]]}]],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 177, 
   "   ", {($CellContext`a ($CellContext`a + $CellContext`b - $CellContext`c) \
($CellContext`a - $CellContext`b + $CellContext`c))^
     Rational[1, 
       2] ((($CellContext`a + $CellContext`b - $CellContext`c) \
$CellContext`c)^
      Rational[1, 
        2] + ($CellContext`b ($CellContext`a - $CellContext`b + \
$CellContext`c))^
      Rational[1, 
        2]), ($CellContext`b ($CellContext`a + $CellContext`b - \
$CellContext`c) (-$CellContext`a + $CellContext`b + $CellContext`c))^
     Rational[1, 
       2] ((($CellContext`a + $CellContext`b - $CellContext`c) \
$CellContext`c)^
      Rational[1, 
        2] + ($CellContext`a (-$CellContext`a + $CellContext`b + \
$CellContext`c))^
      Rational[1, 
        2]), ($CellContext`c ($CellContext`a - $CellContext`b + \
$CellContext`c) (-$CellContext`a + $CellContext`b + $CellContext`c))^
     Rational[1, 
       2] (($CellContext`b ($CellContext`a - $CellContext`b + \
$CellContext`c))^
      Rational[1, 
        2] + ($CellContext`a (-$CellContext`a + $CellContext`b + \
$CellContext`c))^Rational[1, 2])}, "   XM/AM=", 
   Style[2^Rational[1, 2]/(2 + (2 - 2^Rational[1, 2])^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097940609641*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"812e6988-b0b2-422c-b883-1d6eca0a2a7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "178"}],
  SequenceForm["n=", 178],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979406117897`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"5c5dec5a-0723-48ad-a6ec-b3f66abc77a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "178", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", "c"}]], "+", 
      SqrtBox[
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b", "+", "c"}], ")"}]}]]}], ",", 
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", "c"}]], "+", 
      SqrtBox[
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]]}], ",", 
     RowBox[{
      SqrtBox[
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b", "+", "c"}], ")"}]}]], "+", 
      SqrtBox[
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", 
     RowBox[{"2", "+", 
      SqrtBox[
       RowBox[{"2", "-", 
        SqrtBox["2"]}]]}]],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 178, 
   "   ", {(($CellContext`a + $CellContext`b - $CellContext`c) \
$CellContext`c)^
     Rational[1, 
       2] + ($CellContext`b ($CellContext`a - $CellContext`b + \
$CellContext`c))^
     Rational[1, 
       2], (($CellContext`a + $CellContext`b - $CellContext`c) \
$CellContext`c)^
     Rational[1, 
       2] + ($CellContext`a (-$CellContext`a + $CellContext`b + \
$CellContext`c))^
     Rational[1, 
       2], ($CellContext`b ($CellContext`a - $CellContext`b + \
$CellContext`c))^
     Rational[
      1, 2] + ($CellContext`a (-$CellContext`a + $CellContext`b + \
$CellContext`c))^Rational[1, 2]}, "   XM/AM=", 
   Style[(2 + (2 - 2^Rational[1, 2])^Rational[1, 2])^(-1), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097940650569*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"91430612-ff35-4163-bd16-6d6bd5bd6a54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "179"}],
  SequenceForm["n=", 179],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097940653373*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"c2ff204b-5b0b-43d4-9720-0ba627e21482"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "180"}],
  SequenceForm["n=", 180],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109794076818*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"5cdb1669-b7e7-4bed-9e64-513e28601448"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "181"}],
  SequenceForm["n=", 181],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979445456*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"148a63ab-b960-4abe-a114-9470e75ab7d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "181", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     RowBox[{"-", 
      FractionBox["4", "23"]}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "5"}], "+", 
       SqrtBox["2"]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 181, 
   "   ", {$CellContext`a^2 ($CellContext`a + $CellContext`b - \
$CellContext`c) ($CellContext`a - $CellContext`b + $CellContext`c) \
($CellContext`b + $CellContext`c)^2, $CellContext`b^2 ($CellContext`a + \
$CellContext`b - $CellContext`c) ($CellContext`a + $CellContext`c)^2 \
(-$CellContext`a + $CellContext`b + $CellContext`c), ($CellContext`a + \
$CellContext`b)^2 $CellContext`c^2 ($CellContext`a - $CellContext`b + \
$CellContext`c) (-$CellContext`a + $CellContext`b + $CellContext`c)}, 
   "   XM/AM=", 
   Style[Rational[-4, 23] (-5 + 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944582966*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"b0cb241a-07c4-4782-92fa-d42715d80afb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "182"}],
  SequenceForm["n=", 182],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944585032*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"3f1d9762-9372-46af-869c-03e4f4c5f9a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "182", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", "4"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 182, 
   "   ", {$CellContext`a^2 ($CellContext`a^4 - $CellContext`a^2 \
$CellContext`b^2 - $CellContext`a^2 $CellContext`c^2 - 
     2 $CellContext`b^2 $CellContext`c^2), $CellContext`b^2 \
(-$CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - 
     2 $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 \
$CellContext`c^2), $CellContext`c^2 ((-2) $CellContext`a^2 $CellContext`b^2 - \
$CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 + \
$CellContext`c^4)}, "   XM/AM=", 
   Style[
    Rational[1, 4], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979445867*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"4c7a7ae5-aab7-4682-a4c4-82920c2ea40f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "183"}],
  SequenceForm["n=", 183],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944588407*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"2986f96e-d608-476d-bcd4-f752869dcbf6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "183", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", "7"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 183, 
   "   ", {$CellContext`a^4 - $CellContext`a^2 $CellContext`b^2 - \
$CellContext`a^2 $CellContext`c^2 - 
    2 $CellContext`b^2 $CellContext`c^2, -$CellContext`a^2 $CellContext`b^2 + \
$CellContext`b^4 - 
    2 $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2, \
(-2) $CellContext`a^2 $CellContext`b^2 - $CellContext`a^2 $CellContext`c^2 - \
$CellContext`b^2 $CellContext`c^2 + $CellContext`c^4}, "   XM/AM=", 
   Style[
    Rational[1, 7], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944590026*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"860e2360-9874-467e-a00f-503bf189ea40"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "184"}],
  SequenceForm["n=", 184],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944592272*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"88aec533-fc51-4189-95e0-b6bc4323d2ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "185"}],
  SequenceForm["n=", 185],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944593639*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"eb701827-2be2-4229-a9a9-134b2e6db3f2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "186"}],
  SequenceForm["n=", 186],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979445950317`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"97c56e2d-780b-420d-9343-9fa62fa8fc1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "187"}],
  SequenceForm["n=", 187],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944596586*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"b501c19a-8759-472d-8f30-c298ef55df93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "187", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox["2",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 187, 
   "   ", {$CellContext`a^2 (
     2 $CellContext`a^2 - $CellContext`b^2 - $CellContext`c^2), \
$CellContext`b^2 (-$CellContext`a^2 + 
     2 $CellContext`b^2 - $CellContext`c^2), $CellContext`c^2 \
(-$CellContext`a^2 - $CellContext`b^2 + 2 $CellContext`c^2)}, "   XM/AM=", 
   Style[2, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944598724*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"15eb4da7-d256-4bec-bb72-6ac4fb2a01bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "188"}],
  SequenceForm["n=", 188],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944600472*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"7baea0b9-ca05-494d-896c-678347a72da2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "188", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]], ",", 
     SqrtBox[
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{"a", "-", "b", "+", "c"}], ")"}]}]], ",", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", "c"}]]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox[
     SqrtBox[
      RowBox[{"2", "-", 
       SqrtBox["2"]}]], 
     RowBox[{"2", "+", 
      SqrtBox[
       RowBox[{"2", "-", 
        SqrtBox["2"]}]]}]],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 188, 
   "   ", {($CellContext`a (-$CellContext`a + $CellContext`b + \
$CellContext`c))^
    Rational[1, 
      2], ($CellContext`b ($CellContext`a - $CellContext`b + $CellContext`c))^
    Rational[1, 
      2], (($CellContext`a + $CellContext`b - $CellContext`c) $CellContext`c)^
    Rational[1, 2]}, "   XM/AM=", 
   Style[(2 - 2^Rational[1, 2])^Rational[1, 2]/(
    2 + (2 - 2^Rational[1, 2])^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944605576*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"5b67ac84-c7d6-4cc5-9562-db2b6b29bd1a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "189"}],
  SequenceForm["n=", 189],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944607707*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"8b7ab2f2-4db8-471a-aa16-4012b201e275"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "189", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"3", "+", 
     RowBox[{"2", " ", 
      SqrtBox["2"]}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 189, 
   "   ", {($CellContext`a^3 - $CellContext`a^2 $CellContext`b - \
$CellContext`a $CellContext`b^2 + $CellContext`b^3 + $CellContext`a^2 \
$CellContext`c + 
     2 $CellContext`a $CellContext`b $CellContext`c + $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 - $CellContext`b \
$CellContext`c^2 - $CellContext`c^3) ($CellContext`a^3 + $CellContext`a^2 \
$CellContext`b - $CellContext`a $CellContext`b^2 - $CellContext`b^3 - \
$CellContext`a^2 $CellContext`c + 
     2 $CellContext`a $CellContext`b $CellContext`c - $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 + $CellContext`b \
$CellContext`c^2 + $CellContext`c^3), ($CellContext`a^3 - $CellContext`a^2 \
$CellContext`b - $CellContext`a $CellContext`b^2 + $CellContext`b^3 + \
$CellContext`a^2 $CellContext`c + 
     2 $CellContext`a $CellContext`b $CellContext`c + $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 - $CellContext`b \
$CellContext`c^2 - $CellContext`c^3) (-$CellContext`a^3 - $CellContext`a^2 \
$CellContext`b + $CellContext`a $CellContext`b^2 + $CellContext`b^3 - \
$CellContext`a^2 $CellContext`c + 
     2 $CellContext`a $CellContext`b $CellContext`c - $CellContext`b^2 \
$CellContext`c + $CellContext`a $CellContext`c^2 - $CellContext`b \
$CellContext`c^2 + $CellContext`c^3), (-$CellContext`a^3 - $CellContext`a^2 \
$CellContext`b + $CellContext`a $CellContext`b^2 + $CellContext`b^3 - \
$CellContext`a^2 $CellContext`c + 
     2 $CellContext`a $CellContext`b $CellContext`c - $CellContext`b^2 \
$CellContext`c + $CellContext`a $CellContext`c^2 - $CellContext`b \
$CellContext`c^2 + $CellContext`c^3) ($CellContext`a^3 + $CellContext`a^2 \
$CellContext`b - $CellContext`a $CellContext`b^2 - $CellContext`b^3 - \
$CellContext`a^2 $CellContext`c + 
     2 $CellContext`a $CellContext`b $CellContext`c - $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 + $CellContext`b \
$CellContext`c^2 + $CellContext`c^3)}, "   XM/AM=", 
   Style[3 + 2 2^Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944642399*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"dff85a27-2999-429e-9043-9b028f2d93e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "190"}],
  SequenceForm["n=", 190],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944645692*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"ca5aab45-13e0-407d-a696-7d9dadf327ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "191"}],
  SequenceForm["n=", 191],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944647588*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f587e2b4-806d-4537-9fef-b60c947cc634"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "191", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", "b", " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "7"], " ", 
     RowBox[{"(", 
      RowBox[{"5", "-", 
       RowBox[{"3", " ", 
        SqrtBox["2"]}]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 191, 
   "   ", {$CellContext`a ($CellContext`a^3 + $CellContext`a^2 $CellContext`b - \
$CellContext`a $CellContext`b^2 - $CellContext`b^3 + $CellContext`a^2 \
$CellContext`c - $CellContext`a $CellContext`b $CellContext`c - \
$CellContext`b^2 $CellContext`c - $CellContext`a $CellContext`c^2 - \
$CellContext`b $CellContext`c^2 - $CellContext`c^3), $CellContext`b \
(-$CellContext`a^3 - $CellContext`a^2 $CellContext`b + $CellContext`a \
$CellContext`b^2 + $CellContext`b^3 - $CellContext`a^2 $CellContext`c - \
$CellContext`a $CellContext`b $CellContext`c + $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 - $CellContext`b \
$CellContext`c^2 - $CellContext`c^3), $CellContext`c (-$CellContext`a^3 - \
$CellContext`a^2 $CellContext`b - $CellContext`a $CellContext`b^2 - \
$CellContext`b^3 - $CellContext`a^2 $CellContext`c - $CellContext`a \
$CellContext`b $CellContext`c - $CellContext`b^2 $CellContext`c + \
$CellContext`a $CellContext`c^2 + $CellContext`b $CellContext`c^2 + \
$CellContext`c^3)}, "   XM/AM=", 
   Style[Rational[1, 7] (5 - 3 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944650415*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"41a952b4-2cc6-4e3e-9a55-587aefafef02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "192"}],
  SequenceForm["n=", 192],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944653449*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a92589d3-547b-448a-82c9-b569fb726219"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "192", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], " ", "b"}], "-", 
      RowBox[{"a", " ", "c"}], "+", 
      RowBox[{"b", " ", "c"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], " ", "b"}], "+", 
      RowBox[{"a", " ", "c"}], "-", 
      RowBox[{"b", " ", "c"}]}], ",", 
     RowBox[{
      RowBox[{"a", " ", "b"}], "-", 
      RowBox[{"a", " ", "c"}], "-", 
      RowBox[{"b", " ", "c"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "7"], " ", 
     RowBox[{"(", 
      RowBox[{"9", "-", 
       RowBox[{"4", " ", 
        SqrtBox["2"]}]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 192, 
   "   ", {-$CellContext`a $CellContext`b - $CellContext`a $CellContext`c + \
$CellContext`b $CellContext`c, -$CellContext`a $CellContext`b + \
$CellContext`a $CellContext`c - $CellContext`b $CellContext`c, $CellContext`a \
$CellContext`b - $CellContext`a $CellContext`c - $CellContext`b \
$CellContext`c}, "   XM/AM=", 
   Style[Rational[1, 7] (9 - 4 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944655594*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"ca3ceca8-025e-4a3a-b6ac-035488ec8b7e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "193"}],
  SequenceForm["n=", 193],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944658038*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"5c665a55-4376-4ce1-afa5-5be1ad5c213b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "194"}],
  SequenceForm["n=", 194],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944659787*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"18b939a3-0014-4844-886c-b50903b5e6fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "194", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["3", "5"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 194, 
   "   ", {-$CellContext`a^2 $CellContext`b^2 - $CellContext`a^2 \
$CellContext`c^2 + $CellContext`b^2 $CellContext`c^2, -$CellContext`a^2 \
$CellContext`b^2 + $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 \
$CellContext`c^2, $CellContext`a^2 $CellContext`b^2 - $CellContext`a^2 \
$CellContext`c^2 - $CellContext`b^2 $CellContext`c^2}, "   XM/AM=", 
   Style[
    Rational[3, 5], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944662056*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"de57ef61-20e7-416e-b6b9-fcd30ed6bf30"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "195"}],
  SequenceForm["n=", 195],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979446643467`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"8cf908a9-e0a5-483f-956a-cf6baed49eb9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "195", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "6"]}], "+", 
        SuperscriptBox["b", "8"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        SuperscriptBox["c", "8"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "6"]}], "+", 
        SuperscriptBox["b", "8"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        SuperscriptBox["c", "8"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "6"]}], "+", 
        SuperscriptBox["b", "8"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        SuperscriptBox["c", "8"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["2", "3"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 195, 
   "   ", {$CellContext`a^2 ($CellContext`a^8 - 
     4 $CellContext`a^6 $CellContext`b^2 + 
     6 $CellContext`a^4 $CellContext`b^4 - 
     4 $CellContext`a^2 $CellContext`b^6 + $CellContext`b^8 - 
     4 $CellContext`a^6 $CellContext`c^2 + 
     5 $CellContext`a^4 $CellContext`b^2 $CellContext`c^2 + $CellContext`a^2 \
$CellContext`b^4 $CellContext`c^2 - 2 $CellContext`b^6 $CellContext`c^2 + 
     6 $CellContext`a^4 $CellContext`c^4 + $CellContext`a^2 $CellContext`b^2 \
$CellContext`c^4 + 2 $CellContext`b^4 $CellContext`c^4 - 
     4 $CellContext`a^2 $CellContext`c^6 - 
     2 $CellContext`b^2 $CellContext`c^6 + $CellContext`c^8), \
$CellContext`b^2 ($CellContext`a^8 - 4 $CellContext`a^6 $CellContext`b^2 + 
     6 $CellContext`a^4 $CellContext`b^4 - 
     4 $CellContext`a^2 $CellContext`b^6 + $CellContext`b^8 - 
     2 $CellContext`a^6 $CellContext`c^2 + $CellContext`a^4 $CellContext`b^2 \
$CellContext`c^2 + 5 $CellContext`a^2 $CellContext`b^4 $CellContext`c^2 - 
     4 $CellContext`b^6 $CellContext`c^2 + 
     2 $CellContext`a^4 $CellContext`c^4 + $CellContext`a^2 $CellContext`b^2 \
$CellContext`c^4 + 6 $CellContext`b^4 $CellContext`c^4 - 
     2 $CellContext`a^2 $CellContext`c^6 - 
     4 $CellContext`b^2 $CellContext`c^6 + $CellContext`c^8), \
$CellContext`c^2 ($CellContext`a^8 - 2 $CellContext`a^6 $CellContext`b^2 + 
     2 $CellContext`a^4 $CellContext`b^4 - 
     2 $CellContext`a^2 $CellContext`b^6 + $CellContext`b^8 - 
     4 $CellContext`a^6 $CellContext`c^2 + $CellContext`a^4 $CellContext`b^2 \
$CellContext`c^2 + $CellContext`a^2 $CellContext`b^4 $CellContext`c^2 - 
     4 $CellContext`b^6 $CellContext`c^2 + 
     6 $CellContext`a^4 $CellContext`c^4 + 
     5 $CellContext`a^2 $CellContext`b^2 $CellContext`c^4 + 
     6 $CellContext`b^4 $CellContext`c^4 - 
     4 $CellContext`a^2 $CellContext`c^6 - 
     4 $CellContext`b^2 $CellContext`c^6 + $CellContext`c^8)}, "   XM/AM=", 
   Style[
    Rational[2, 3], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944667605*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"db7e6bf9-2822-4855-bb8e-1f50a34e2a81"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "196"}],
  SequenceForm["n=", 196],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944670106*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"49db7a6b-1659-412a-b6d9-f9ac4a512d8d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "197"}],
  SequenceForm["n=", 197],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979446714478`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"3f06f4e4-006a-4f2b-9b4a-8ca93454da27"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "197", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", 
     SqrtBox["2"]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 197, 
   "   ", {$CellContext`a^2 ($CellContext`a^4 - $CellContext`b^4 + 
     2 $CellContext`a^2 $CellContext`b $CellContext`c - 
     2 $CellContext`a $CellContext`b^2 $CellContext`c - 
     2 $CellContext`a $CellContext`b $CellContext`c^2 + 
     2 $CellContext`b^2 $CellContext`c^2 - $CellContext`c^4), \
$CellContext`b^2 (-$CellContext`a^4 + $CellContext`b^4 - 
     2 $CellContext`a^2 $CellContext`b $CellContext`c + 
     2 $CellContext`a $CellContext`b^2 $CellContext`c + 
     2 $CellContext`a^2 $CellContext`c^2 - 
     2 $CellContext`a $CellContext`b $CellContext`c^2 - $CellContext`c^4), \
$CellContext`c^2 (-$CellContext`a^4 + 
     2 $CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 - 
     2 $CellContext`a^2 $CellContext`b $CellContext`c - 
     2 $CellContext`a $CellContext`b^2 $CellContext`c + 
     2 $CellContext`a $CellContext`b $CellContext`c^2 + $CellContext`c^4)}, 
   "   XM/AM=", 
   Style[-2^Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979446732273`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"eb544c6e-540d-42be-b9af-5d3ca5d969e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "198"}],
  SequenceForm["n=", 198],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109794467492*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"c86e9c45-6c72-4b4c-a65b-18e6e44e82d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "198", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", 
     FractionBox["1", 
      SqrtBox["2"]]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 198, 
   "   ", {$CellContext`a^2 ($CellContext`a^3 + $CellContext`a^2 \
$CellContext`b - $CellContext`a $CellContext`b^2 - $CellContext`b^3 + \
$CellContext`a^2 $CellContext`c - 
     2 $CellContext`a $CellContext`b $CellContext`c + $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 + $CellContext`b \
$CellContext`c^2 - $CellContext`c^3), $CellContext`b^2 (-$CellContext`a^3 - \
$CellContext`a^2 $CellContext`b + $CellContext`a $CellContext`b^2 + \
$CellContext`b^3 + $CellContext`a^2 $CellContext`c - 
     2 $CellContext`a $CellContext`b $CellContext`c + $CellContext`b^2 \
$CellContext`c + $CellContext`a $CellContext`c^2 - $CellContext`b \
$CellContext`c^2 - $CellContext`c^3), $CellContext`c^2 (-$CellContext`a^3 + \
$CellContext`a^2 $CellContext`b + $CellContext`a $CellContext`b^2 - \
$CellContext`b^3 - $CellContext`a^2 $CellContext`c - 
     2 $CellContext`a $CellContext`b $CellContext`c - $CellContext`b^2 \
$CellContext`c + $CellContext`a $CellContext`c^2 + $CellContext`b \
$CellContext`c^2 + $CellContext`c^3)}, "   XM/AM=", 
   Style[-2^Rational[-1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944684856*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"717be07b-a86d-4edb-9749-cc3384771b76"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "199"}],
  SequenceForm["n=", 199],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944687193*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"7213a0e0-517b-40df-b20c-b9ff9a164959"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "199", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "3"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "3"], " ", "c"}], "-", 
        RowBox[{"a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "3"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "3"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", "b"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "3"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "3"], " ", "c"}], "-", 
        RowBox[{"a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "3"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "3"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "3"]}], "-", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "3"], " ", "c"}], "+", 
        RowBox[{"a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "3"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "2"], "-", 
     FractionBox["1", 
      SqrtBox["2"]]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 199, 
   "   ", {$CellContext`a^2 ($CellContext`a^4 + $CellContext`a^3 \
$CellContext`b - $CellContext`a $CellContext`b^3 - $CellContext`b^4 + \
$CellContext`a^3 $CellContext`c + $CellContext`a^2 $CellContext`b \
$CellContext`c - $CellContext`a $CellContext`b^2 $CellContext`c - \
$CellContext`b^3 $CellContext`c - $CellContext`a $CellContext`b \
$CellContext`c^2 - $CellContext`a $CellContext`c^3 - $CellContext`b \
$CellContext`c^3 - $CellContext`c^4), $CellContext`b^2 (-$CellContext`a^4 - \
$CellContext`a^3 $CellContext`b + $CellContext`a $CellContext`b^3 + \
$CellContext`b^4 - $CellContext`a^3 $CellContext`c - $CellContext`a^2 \
$CellContext`b $CellContext`c + $CellContext`a $CellContext`b^2 \
$CellContext`c + $CellContext`b^3 $CellContext`c - $CellContext`a \
$CellContext`b $CellContext`c^2 - $CellContext`a $CellContext`c^3 - \
$CellContext`b $CellContext`c^3 - $CellContext`c^4), $CellContext`c^2 \
(-$CellContext`a^4 - $CellContext`a^3 $CellContext`b - $CellContext`a \
$CellContext`b^3 - $CellContext`b^4 - $CellContext`a^3 $CellContext`c - \
$CellContext`a^2 $CellContext`b $CellContext`c - $CellContext`a \
$CellContext`b^2 $CellContext`c - $CellContext`b^3 $CellContext`c + \
$CellContext`a $CellContext`b $CellContext`c^2 + $CellContext`a \
$CellContext`c^3 + $CellContext`b $CellContext`c^3 + $CellContext`c^4)}, 
   "   XM/AM=", 
   Style[Rational[1, 2] - 2^Rational[-1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109794472125*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"661ee9e7-fd17-479d-b522-757c8b87ee9f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "200"}],
  SequenceForm["n=", 200],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944723567*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"e2f79e39-9b0f-4608-b11b-af09a08e708f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "200", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "-", "b", "-", "c"}], ")"}], "2"]}], ",", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "+", "b", "-", "c"}], ")"}], "2"]}], ",", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "-", "b", "+", "c"}], ")"}], "2"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "7"], " ", 
     RowBox[{"(", 
      RowBox[{"5", "-", 
       RowBox[{"3", " ", 
        SqrtBox["2"]}]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 200, 
   "   ", {$CellContext`a ($CellContext`a - $CellContext`b - \
$CellContext`c)^2, $CellContext`b (-$CellContext`a + $CellContext`b - \
$CellContext`c)^2, $CellContext`c (-$CellContext`a - $CellContext`b + \
$CellContext`c)^2}, "   XM/AM=", 
   Style[Rational[1, 7] (5 - 3 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109794472503*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"01b82fdc-cec2-4575-9e93-d55e3e5c576c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "201"}],
  SequenceForm["n=", 201],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944726592*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"3b037879-b114-4e14-97f4-cbe0cce8cf4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "202"}],
  SequenceForm["n=", 202],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944728002*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"222e7fd0-5d80-4d83-8394-d106dd81c492"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "203"}],
  SequenceForm["n=", 203],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944868783*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"7319168e-fffb-4880-b9aa-5ab3823f4c78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "204"}],
  SequenceForm["n=", 204],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097944980424*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"0eb6e242-fab6-4221-a701-fd06a4a8512e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "205"}],
  SequenceForm["n=", 205],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979449857407`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"4e23acf7-3ae9-4f0a-8f4e-8ef833f95787"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "205", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 205, 
   "   ", {$CellContext`a^3 ($CellContext`a^4 - $CellContext`b^4 + 
     2 $CellContext`a^2 $CellContext`b $CellContext`c - 
     2 $CellContext`a $CellContext`b^2 $CellContext`c - 
     2 $CellContext`a $CellContext`b $CellContext`c^2 + 
     2 $CellContext`b^2 $CellContext`c^2 - $CellContext`c^4), \
$CellContext`b^3 (-$CellContext`a^4 + $CellContext`b^4 - 
     2 $CellContext`a^2 $CellContext`b $CellContext`c + 
     2 $CellContext`a $CellContext`b^2 $CellContext`c + 
     2 $CellContext`a^2 $CellContext`c^2 - 
     2 $CellContext`a $CellContext`b $CellContext`c^2 - $CellContext`c^4), \
$CellContext`c^3 (-$CellContext`a^4 + 
     2 $CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 - 
     2 $CellContext`a^2 $CellContext`b $CellContext`c - 
     2 $CellContext`a $CellContext`b^2 $CellContext`c + 
     2 $CellContext`a $CellContext`b $CellContext`c^2 + $CellContext`c^4)}, 
   "   XM/AM=", 
   Style[(-2) (1 + 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979450216417`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"d3f0e582-11ca-437a-a9e1-d0c51624d015"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "206"}],
  SequenceForm["n=", 206],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945023816*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"755d36ba-bacc-4767-b797-e1f222c49def"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "207"}],
  SequenceForm["n=", 207],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945025078*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"694b7461-e978-47da-8c7c-869ab5b8f8ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "208"}],
  SequenceForm["n=", 208],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945026312*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"c07d6efc-de23-4eb1-8d62-994d6b23ec05"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "209"}],
  SequenceForm["n=", 209],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945027906*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f11fc1ab-e69e-4bb9-ae8a-49b5c5a8d9ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "210"}],
  SequenceForm["n=", 210],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979450293207`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"844ea55d-9da9-475d-a8b9-2f01756c2f14"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "210", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "-", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"2", "-", 
       SqrtBox["2"]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 210, 
   "   ", {$CellContext`a ($CellContext`a - $CellContext`b - $CellContext`c) \
($CellContext`b + $CellContext`c), $CellContext`b (-$CellContext`a + \
$CellContext`b - $CellContext`c) ($CellContext`a + $CellContext`c), \
($CellContext`a + $CellContext`b) $CellContext`c (-$CellContext`a - \
$CellContext`b + $CellContext`c)}, "   XM/AM=", 
   Style[Rational[1, 3] (2 - 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945031283*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a716f608-0b32-4010-874f-68182d44666e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "211"}],
  SequenceForm["n=", 211],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945032989*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a8ae8276-dcb3-4a27-942f-ef25784401c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "212"}],
  SequenceForm["n=", 212],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979450348673`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"cc534cd7-44b3-445c-832b-8b6402dde8a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "213"}],
  SequenceForm["n=", 213],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945036577*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"e56ce8c6-8ca9-4e36-af04-6055250e8cdc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "213", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      SuperscriptBox["c", "3"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     RowBox[{"-", 
      FractionBox["2", "17"]}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "6"}], "+", 
       SqrtBox["2"]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 213, 
   "   ", {$CellContext`a^3 ($CellContext`b + $CellContext`c), \
$CellContext`b^3 ($CellContext`a + $CellContext`c), ($CellContext`a + \
$CellContext`b) $CellContext`c^3}, "   XM/AM=", 
   Style[Rational[-2, 17] (-6 + 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979450699778`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"44952c49-5b94-4d32-9588-9b0fd11ba8a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "214"}],
  SequenceForm["n=", 214],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979450720663`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"92cd81cf-7e14-478a-90ee-2d85a1e47508"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "214", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "-", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", 
        RowBox[{"2", " ", "b"}], "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "-", "b", "+", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{"a", " ", "b"}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", 
     SqrtBox["2"]],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 214, 
   "   ", {$CellContext`a (
     2 $CellContext`a - $CellContext`b - $CellContext`c) ($CellContext`a^2 - \
$CellContext`b^2 + $CellContext`b $CellContext`c - $CellContext`c^2), \
$CellContext`b (-$CellContext`a + 
     2 $CellContext`b - $CellContext`c) (-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`a $CellContext`c - $CellContext`c^2), $CellContext`c \
(-$CellContext`a - $CellContext`b + 
     2 $CellContext`c) (-$CellContext`a^2 + $CellContext`a $CellContext`b - \
$CellContext`b^2 + $CellContext`c^2)}, "   XM/AM=", 
   Style[2^Rational[-1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979450739326`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"44056a51-e697-40b6-9972-6fac7f4b834d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "215"}],
  SequenceForm["n=", 215],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979450758123`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"3eef0a47-2c85-4d18-a242-37feefd5e322"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "215", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"b", " ", "c"}], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], ",", 
     RowBox[{
      SuperscriptBox["b", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "-", "c"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], "+", 
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"a", " ", "c"}], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], ",", 
     RowBox[{
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "-", "b", "+", "c"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], "+", 
         RowBox[{"a", " ", "b"}], "-", 
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", 
     SqrtBox["2"]],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 215, 
   "   ", {$CellContext`a^4 ($CellContext`a - $CellContext`b - \
$CellContext`c) ($CellContext`a^2 - $CellContext`b^2 + $CellContext`b \
$CellContext`c - $CellContext`c^2)^2, $CellContext`b^4 (-$CellContext`a + \
$CellContext`b - $CellContext`c) (-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`a $CellContext`c - $CellContext`c^2)^2, $CellContext`c^4 \
(-$CellContext`a - $CellContext`b + $CellContext`c) (-$CellContext`a^2 + \
$CellContext`a $CellContext`b - $CellContext`b^2 + $CellContext`c^2)^2}, 
   "   XM/AM=", 
   Style[2^Rational[-1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945077723*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"55512347-bfa3-476c-8d95-26d449a90317"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "216"}],
  SequenceForm["n=", 216],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945080068*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f6d1163a-0c56-4d20-9522-e0802154f088"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "217"}],
  SequenceForm["n=", 217],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109794508158*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"beeca184-8582-41ff-b04f-7077866e9b7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "218"}],
  SequenceForm["n=", 218],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945082963*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"be11cb74-2c4f-4f36-ba89-62be638b1f25"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "218", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"2", " ", "a", " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", "a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"2", " ", "a", " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", "b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", "a", " ", "c"}], "-", 
        RowBox[{"2", " ", "b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["2", "3"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 218, 
   "   ", {$CellContext`a^2 ($CellContext`a^2 - 
     2 $CellContext`a $CellContext`b + $CellContext`b^2 - 
     2 $CellContext`a $CellContext`c + $CellContext`c^2), $CellContext`b^2 \
($CellContext`a^2 - 2 $CellContext`a $CellContext`b + $CellContext`b^2 - 
     2 $CellContext`b $CellContext`c + $CellContext`c^2), $CellContext`c^2 \
($CellContext`a^2 + $CellContext`b^2 - 2 $CellContext`a $CellContext`c - 
     2 $CellContext`b $CellContext`c + $CellContext`c^2)}, "   XM/AM=", 
   Style[
    Rational[2, 3], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109794508469*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"10ddc38d-7e79-4b9e-997f-1bf52a80f2ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "219"}],
  SequenceForm["n=", 219],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979450866833`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"1b17d887-2610-4aa7-ab1e-f143110c490a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "220"}],
  SequenceForm["n=", 220],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979450882072`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"9074ca5c-2a73-439d-b60d-afe30e8561bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "220", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "-", "b", "-", "c"}], ")"}], "2"]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "+", "b", "-", "c"}], ")"}], "2"]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "-", "b", "+", "c"}], ")"}], "2"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"(", 
      RowBox[{"2", "-", 
       SqrtBox["2"]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 220, 
   "   ", {$CellContext`a^2 ($CellContext`a - $CellContext`b - \
$CellContext`c)^2, $CellContext`b^2 (-$CellContext`a + $CellContext`b - \
$CellContext`c)^2, $CellContext`c^2 (-$CellContext`a - $CellContext`b + \
$CellContext`c)^2}, "   XM/AM=", 
   Style[Rational[1, 4] (2 - 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945093173*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"4d165aa5-b4cb-4820-b080-391d61d149dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "221"}],
  SequenceForm["n=", 221],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945095583*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a9f06b5d-ae24-4b1a-8ae6-78368c3fd98f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "222"}],
  SequenceForm["n=", 222],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945097031*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"8ac18be1-b88b-4433-be06-49eec5880a83"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "223"}],
  SequenceForm["n=", 223],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945098516*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"009918e2-471c-47dd-8d0f-f56c3583369d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "223", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     SqrtBox["2"]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 223, 
   "   ", {$CellContext`a ($CellContext`a + $CellContext`b - $CellContext`c) \
($CellContext`a - $CellContext`b + $CellContext`c) ($CellContext`a^3 + \
$CellContext`a^2 $CellContext`b - $CellContext`a $CellContext`b^2 - \
$CellContext`b^3 + $CellContext`a^2 $CellContext`c - 
     2 $CellContext`a $CellContext`b $CellContext`c + $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 + $CellContext`b \
$CellContext`c^2 - $CellContext`c^3), $CellContext`b ($CellContext`a + \
$CellContext`b - $CellContext`c) (-$CellContext`a + $CellContext`b + \
$CellContext`c) (-$CellContext`a^3 - $CellContext`a^2 $CellContext`b + \
$CellContext`a $CellContext`b^2 + $CellContext`b^3 + $CellContext`a^2 \
$CellContext`c - 
     2 $CellContext`a $CellContext`b $CellContext`c + $CellContext`b^2 \
$CellContext`c + $CellContext`a $CellContext`c^2 - $CellContext`b \
$CellContext`c^2 - $CellContext`c^3), $CellContext`c ($CellContext`a - \
$CellContext`b + $CellContext`c) (-$CellContext`a + $CellContext`b + \
$CellContext`c) (-$CellContext`a^3 + $CellContext`a^2 $CellContext`b + \
$CellContext`a $CellContext`b^2 - $CellContext`b^3 - $CellContext`a^2 \
$CellContext`c - 
     2 $CellContext`a $CellContext`b $CellContext`c - $CellContext`b^2 \
$CellContext`c + $CellContext`a $CellContext`c^2 + $CellContext`b \
$CellContext`c^2 + $CellContext`c^3)}, "   XM/AM=", 
   Style[-1 - 2^Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979451322803`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"dbae63dc-2250-43fd-9934-c7ef2008bf34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "224"}],
  SequenceForm["n=", 224],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979451347237`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"93a18f8a-cb58-418b-8e66-56f4ece14e1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "224", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "3"], " ", "b"}], "+", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["b", "3"]}], "-", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "3"], " ", "c"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["c", "3"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "3"], " ", "b"}], "-", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["b", "3"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "3"], " ", "c"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", "b", " ", 
         SuperscriptBox["c", "3"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "3"], " ", "c"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "3"], " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["c", "3"]}], "-", 
        RowBox[{"2", " ", "b", " ", 
         SuperscriptBox["c", "3"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", 
     SqrtBox["2"]],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 224, 
   "   ", {$CellContext`a ($CellContext`a^2 - $CellContext`b^2 - \
$CellContext`c^2) ($CellContext`a^4 - 2 $CellContext`a^3 $CellContext`b + 
     2 $CellContext`a $CellContext`b^3 - $CellContext`b^4 - 
     2 $CellContext`a^3 $CellContext`c - 
     2 $CellContext`a^2 $CellContext`b $CellContext`c + 
     2 $CellContext`b^2 $CellContext`c^2 + 
     2 $CellContext`a $CellContext`c^3 - $CellContext`c^4), $CellContext`b \
(-$CellContext`a^2 + $CellContext`b^2 - $CellContext`c^2) (-$CellContext`a^4 + 
     2 $CellContext`a^3 $CellContext`b - 
     2 $CellContext`a $CellContext`b^3 + $CellContext`b^4 - 
     2 $CellContext`a $CellContext`b^2 $CellContext`c - 
     2 $CellContext`b^3 $CellContext`c + 2 $CellContext`a^2 $CellContext`c^2 + 
     2 $CellContext`b $CellContext`c^3 - $CellContext`c^4), $CellContext`c \
(-$CellContext`a^2 - $CellContext`b^2 + $CellContext`c^2) (-$CellContext`a^4 + 
     2 $CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 + 
     2 $CellContext`a^3 $CellContext`c + 2 $CellContext`b^3 $CellContext`c - 
     2 $CellContext`a $CellContext`b $CellContext`c^2 - 
     2 $CellContext`a $CellContext`c^3 - 
     2 $CellContext`b $CellContext`c^3 + $CellContext`c^4)}, "   XM/AM=", 
   Style[2^Rational[-1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945136677*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"286a0e0a-b278-480a-801f-84b7a7f590b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "225"}],
  SequenceForm["n=", 225],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945138502*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a308199b-53cc-456f-a803-9040297a444d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "226"}],
  SequenceForm["n=", 226],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945139876*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"06fab6f5-148a-4de5-8fb0-7c3d390dd82e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "226", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", "2"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 226, 
   "   ", {($CellContext`a + $CellContext`b - $CellContext`c) ($CellContext`a - \
$CellContext`b + $CellContext`c) ($CellContext`b + $CellContext`c), \
($CellContext`a + $CellContext`b - $CellContext`c) ($CellContext`a + \
$CellContext`c) (-$CellContext`a + $CellContext`b + $CellContext`c), \
($CellContext`a + $CellContext`b) ($CellContext`a - $CellContext`b + \
$CellContext`c) (-$CellContext`a + $CellContext`b + $CellContext`c)}, 
   "   XM/AM=", 
   Style[
    Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945141386*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f74ead31-ccb4-411b-a828-7c4fab0367d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "227"}],
  SequenceForm["n=", 227],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979451428223`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"bb453a80-51ac-4744-9706-38efbc6514ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "227", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"-", 
     SqrtBox["2"]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 227, 
   "   ", {$CellContext`a ($CellContext`a + $CellContext`b - $CellContext`c) \
($CellContext`a - $CellContext`b + $CellContext`c) ($CellContext`b + \
$CellContext`c) ($CellContext`a^3 + $CellContext`a^2 $CellContext`b - \
$CellContext`a $CellContext`b^2 - $CellContext`b^3 + $CellContext`a^2 \
$CellContext`c - 
     2 $CellContext`a $CellContext`b $CellContext`c + $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 + $CellContext`b \
$CellContext`c^2 - $CellContext`c^3), $CellContext`b ($CellContext`a + \
$CellContext`b - $CellContext`c) ($CellContext`a + $CellContext`c) \
(-$CellContext`a + $CellContext`b + $CellContext`c) (-$CellContext`a^3 - \
$CellContext`a^2 $CellContext`b + $CellContext`a $CellContext`b^2 + \
$CellContext`b^3 + $CellContext`a^2 $CellContext`c - 
     2 $CellContext`a $CellContext`b $CellContext`c + $CellContext`b^2 \
$CellContext`c + $CellContext`a $CellContext`c^2 - $CellContext`b \
$CellContext`c^2 - $CellContext`c^3), ($CellContext`a + $CellContext`b) \
$CellContext`c ($CellContext`a - $CellContext`b + $CellContext`c) \
(-$CellContext`a + $CellContext`b + $CellContext`c) (-$CellContext`a^3 + \
$CellContext`a^2 $CellContext`b + $CellContext`a $CellContext`b^2 - \
$CellContext`b^3 - $CellContext`a^2 $CellContext`c - 
     2 $CellContext`a $CellContext`b $CellContext`c - $CellContext`b^2 \
$CellContext`c + $CellContext`a $CellContext`c^2 + $CellContext`b \
$CellContext`c^2 + $CellContext`c^3)}, "   XM/AM=", 
   Style[-2^Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945145185*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"5b72f46f-47f4-4b45-a423-8f60eb6176c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "228"}],
  SequenceForm["n=", 228],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945147436*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"80171790-57bd-41f6-85cf-8219cc7fdd13"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "229"}],
  SequenceForm["n=", 229],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945148982*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"31e04e2d-7846-4a00-830e-9afc2cdf1a9b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "229", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]}], ")"}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 229, 
   "   ", {$CellContext`a ($CellContext`a + $CellContext`b) ($CellContext`a + \
$CellContext`c) ($CellContext`a^4 - $CellContext`b^4 + $CellContext`a^2 \
$CellContext`b $CellContext`c + $CellContext`a $CellContext`b^2 \
$CellContext`c + $CellContext`a $CellContext`b $CellContext`c^2 + 
     2 $CellContext`b^2 $CellContext`c^2 - $CellContext`c^4), $CellContext`b \
($CellContext`a + $CellContext`b) ($CellContext`b + $CellContext`c) \
(-$CellContext`a^4 + $CellContext`b^4 + $CellContext`a^2 $CellContext`b \
$CellContext`c + $CellContext`a $CellContext`b^2 $CellContext`c + 
     2 $CellContext`a^2 $CellContext`c^2 + $CellContext`a $CellContext`b \
$CellContext`c^2 - $CellContext`c^4), $CellContext`c ($CellContext`a + \
$CellContext`c) ($CellContext`b + $CellContext`c) (-$CellContext`a^4 + 
     2 $CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 + \
$CellContext`a^2 $CellContext`b $CellContext`c + $CellContext`a \
$CellContext`b^2 $CellContext`c + $CellContext`a $CellContext`b \
$CellContext`c^2 + $CellContext`c^4)}, "   XM/AM=", 
   Style[Rational[1, 3] (-1 + 2 2^Rational[1, 2]), 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945151129*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"1ee9c17e-52d3-44b7-80db-64a5e5935736"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "230"}],
  SequenceForm["n=", 230],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945153021*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"5de85d77-2706-44cc-9d97-a96e2238820d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "231"}],
  SequenceForm["n=", 231],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945154442*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"b69c6c7e-7dc7-414b-9870-317582db5a56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "232"}],
  SequenceForm["n=", 232],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945155959*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"5e3e6695-53fc-48d4-81c4-37c6e5cd2b8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "233"}],
  SequenceForm["n=", 233],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945157248*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"ea9ff7c2-3b27-4fa2-9deb-894225b63ff1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "233", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["2", "5"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 233, 
   "   ", {($CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 + \
$CellContext`a^2 $CellContext`c^2 + 
     2 $CellContext`b^2 $CellContext`c^2 - $CellContext`c^4) (
     2 $CellContext`a^4 - 
     3 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - 
     3 $CellContext`a^2 $CellContext`c^2 - 
     2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4), \
(-$CellContext`a^4 + $CellContext`a^2 $CellContext`b^2 + 
     2 $CellContext`a^2 $CellContext`c^2 + $CellContext`b^2 $CellContext`c^2 - \
$CellContext`c^4) ($CellContext`a^4 - 3 $CellContext`a^2 $CellContext`b^2 + 
     2 $CellContext`b^4 - 2 $CellContext`a^2 $CellContext`c^2 - 
     3 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4), \
(-$CellContext`a^4 + 
     2 $CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 + \
$CellContext`a^2 $CellContext`c^2 + $CellContext`b^2 $CellContext`c^2) \
($CellContext`a^4 - 2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - 
     3 $CellContext`a^2 $CellContext`c^2 - 
     3 $CellContext`b^2 $CellContext`c^2 + 2 $CellContext`c^4)}, "   XM/AM=", 
   
   Style[
    Rational[2, 5], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945159329*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"11cb14ab-ed56-4326-a47d-02d51b708b05"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "234"}],
  SequenceForm["n=", 234],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945161337*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"7b60b894-0f1f-43d3-ac70-f28c0728c537"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "235"}],
  SequenceForm["n=", 235],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109794522229*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"b78faaa7-5445-4343-a298-6626c0e28431"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "236"}],
  SequenceForm["n=", 236],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945228849*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"e1ee56ee-9412-4070-8699-529896240b42"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "237"}],
  SequenceForm["n=", 237],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945304894*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"4408f436-8867-4657-88a6-ad049deb9af7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "237", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox["2",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 237, 
   "   ", {$CellContext`a^4 ($CellContext`a^2 $CellContext`b^2 - \
$CellContext`b^4 + $CellContext`a^2 $CellContext`c^2 - $CellContext`c^4), \
$CellContext`b^4 (-$CellContext`a^4 + $CellContext`a^2 $CellContext`b^2 + \
$CellContext`b^2 $CellContext`c^2 - $CellContext`c^4), $CellContext`c^4 \
(-$CellContext`a^4 - $CellContext`b^4 + $CellContext`a^2 $CellContext`c^2 + \
$CellContext`b^2 $CellContext`c^2)}, "   XM/AM=", 
   Style[2, 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945307414*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"c5a6cb11-aa2f-4868-a722-766c45b2b55a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "238"}],
  SequenceForm["n=", 238],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979453092337`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"51382ead-a4d6-49dd-b554-7c9e6f2bc53a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "238", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"b", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"1", "+", 
     SqrtBox["2"]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 238, 
   "   ", {$CellContext`a ($CellContext`a^2 - $CellContext`b $CellContext`c), \
$CellContext`b ($CellContext`b^2 - $CellContext`a $CellContext`c), \
$CellContext`c (-$CellContext`a $CellContext`b + $CellContext`c^2)}, 
   "   XM/AM=", 
   Style[1 + 2^Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945314294*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"a0837c02-21b7-4ea7-adb0-f3ba72d441ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "239"}],
  SequenceForm["n=", 239],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979453162947`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"12d22f2c-3485-41d3-a153-043e2e3f5619"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "239", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{"b", " ", "c"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"a", " ", "c"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], " ", "b"}], "+", 
      SuperscriptBox["c", "2"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"3", "+", 
     RowBox[{"2", " ", 
      SqrtBox["2"]}]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 239, 
   "   ", {$CellContext`a^2 - $CellContext`b $CellContext`c, $CellContext`b^2 - \
$CellContext`a $CellContext`c, -$CellContext`a $CellContext`b + \
$CellContext`c^2}, "   XM/AM=", 
   Style[3 + 2 2^Rational[1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945349128*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f30adc5e-714a-4b4c-8373-06bac7520675"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "240"}],
  SequenceForm["n=", 240],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.86109794535148*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"58d7cb7d-07be-4397-b028-98342e3ea861"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "241"}],
  SequenceForm["n=", 241],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945353297*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"de20ab84-946c-446d-af4b-bfa762e60d53"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "241", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "b"}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{"a", " ", "b"}], "+", 
        RowBox[{"b", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"b", " ", "c"}]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"1", "+", 
     FractionBox["1", 
      SqrtBox["2"]]}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 241, 
   "   ", {$CellContext`a ($CellContext`a + $CellContext`b - $CellContext`c) \
($CellContext`a - $CellContext`b + $CellContext`c) ($CellContext`a \
$CellContext`b - $CellContext`b^2 + $CellContext`a $CellContext`c - \
$CellContext`c^2), $CellContext`b ($CellContext`a + $CellContext`b - \
$CellContext`c) (-$CellContext`a + $CellContext`b + $CellContext`c) \
(-$CellContext`a^2 + $CellContext`a $CellContext`b + $CellContext`b \
$CellContext`c - $CellContext`c^2), $CellContext`c ($CellContext`a - \
$CellContext`b + $CellContext`c) (-$CellContext`a + $CellContext`b + \
$CellContext`c) (-$CellContext`a^2 - $CellContext`b^2 + $CellContext`a \
$CellContext`c + $CellContext`b $CellContext`c)}, "   XM/AM=", 
   Style[1 + 2^Rational[-1, 2], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979453551407`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"14f22f81-26b1-42e3-b72b-23f3919fbdb4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "242"}],
  SequenceForm["n=", 242],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945356798*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"8b2570e9-4517-4b62-a6fb-e3a908c1337a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "243"}],
  SequenceForm["n=", 243],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945358574*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"0cce9d06-a821-4607-bdb1-b54d395d16ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "244"}],
  SequenceForm["n=", 244],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945359935*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"2bd52b36-a715-4503-b128-b0359d2458e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "245"}],
  SequenceForm["n=", 245],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945361589*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"e1cf9257-9e4b-4c74-abb0-4c40c35fb0ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "246"}],
  SequenceForm["n=", 246],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945363402*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"f8cd5c74-8fea-4ef5-b26d-dd665e1ae889"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "247"}],
  SequenceForm["n=", 247],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945364871*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"50b913c8-199e-4211-af52-1ec16d67d5a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "248"}],
  SequenceForm["n=", 248],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945366199*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"67ec631e-9815-4264-b19e-18207f69eed2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "249"}],
  SequenceForm["n=", 249],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979453675137`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"9d94d5e8-04a2-45d0-abb7-4d9355b27de7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "250"}],
  SequenceForm["n=", 250],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945368869*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"335297b6-f578-4f32-88bd-62b0e04943e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "251"}],
  SequenceForm["n=", 251],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945370397*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"50b73e62-a268-4ea8-bd7b-4d603a880a61"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "251", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["3", "5"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 251, 
   "   ", {$CellContext`a^2 ($CellContext`a^2 + $CellContext`b^2) \
($CellContext`a^2 + $CellContext`c^2), $CellContext`b^2 ($CellContext`a^2 + \
$CellContext`b^2) ($CellContext`b^2 + $CellContext`c^2), $CellContext`c^2 \
($CellContext`a^2 + $CellContext`c^2) ($CellContext`b^2 + $CellContext`c^2)}, 
   "   XM/AM=", 
   Style[
    Rational[3, 5], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945372562*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"fbc6ef28-059a-4f44-a948-381af93ae706"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "252"}],
  SequenceForm["n=", 252],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.8610979453747883`*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"bdd59463-3575-4a27-af51-29ee33f0e2fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "252", 
   "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"   XM/AM=\"\>", "\[InvisibleSpace]", 
   StyleBox[
    FractionBox["1", "7"],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]]}],
  SequenceForm[
  "n=", 252, 
   "   ", {($CellContext`a^4 - 
     2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - \
$CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2) \
($CellContext`a^4 - $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - 
     2 $CellContext`a^2 $CellContext`c^2 - 
     2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4) \
($CellContext`a^4 - 
     2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - \
$CellContext`a^2 $CellContext`c^2 - 
     2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4) \
($CellContext`a^4 - $CellContext`a^2 $CellContext`b^2 - 
     2 $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 + \
$CellContext`c^4), ($CellContext`a^4 - 
     2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - \
$CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2) \
($CellContext`a^4 - $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - 
     2 $CellContext`a^2 $CellContext`c^2 - 
     2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4) \
(-$CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - $CellContext`a^2 \
$CellContext`c^2 - 
     2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4) \
($CellContext`a^4 - 2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - 
     2 $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 + \
$CellContext`c^4), ($CellContext`a^4 - 
     2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - \
$CellContext`a^2 $CellContext`c^2 - 
     2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4) \
(-$CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - $CellContext`a^2 \
$CellContext`c^2 - 
     2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4) \
($CellContext`a^4 - $CellContext`a^2 $CellContext`b^2 - 
     2 $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 + \
$CellContext`c^4) ($CellContext`a^4 - 
     2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - 
     2 $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 + \
$CellContext`c^4)}, "   XM/AM=", 
   Style[
    Rational[1, 7], 
    RGBColor[0, 0, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945378125*^9},
 CellLabel->
  "During evaluation of \
In[161]:=",ExpressionUUID->"8a7936e1-f6f0-4b55-a555-0684146d8957"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "253"}],
  SequenceForm["n=", 253],
  Editable->False]], "Print",
 CellChangeTimes->{3.859110299359682*^9, 3.8599094333407373`*^9, 
  3.861097945381535*^9},
 CellLab